from typing import (
    Optional,
    overload,
    List,
    Dict,
    OrderedDict,
    Tuple,
    Iterable,
    KeysView,
    Any,
)

class TupleProxyIterator:
    def __init__(self, proxy: Any): ...
    def __iter__(self) -> TupleProxyIterator: ...
    def __next__(self) -> Optional[str]: ...

class TupleProxy:
    def __init__(self, encoding: str = ...) -> None: ...
    def __copy__(self) -> TupleProxy: ...
    def compare(self, other: TupleProxy) -> int: ...
    def getMinFields(self) -> int: ...
    def getMaxFields(self) -> int: ...
    def _getindex(self, index: int) -> str: ...
    @overload
    def __getitem__(self, key: slice) -> List[str]: ...
    @overload
    def __getitem__(self, key: int) -> Any: ...
    def _setindex(self, index: int, value: Optional[str]) -> None: ...
    def __setitem__(self, index: int, value: Optional[str]) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> TupleProxyIterator: ...

class NamedTupleProxy(TupleProxy):
    def __setattr__(self, key: str, value: str) -> None: ...
    def __getattr__(self, key: str) -> str: ...

class GTFProxy(NamedTupleProxy):
    def to_dict(self) -> Dict[str, Any]: ...
    def from_dict(self, d: Dict[str, Any]) -> None: ...
    def invert(self, lcontig: int) -> None: ...
    def keys(self) -> KeysView[str]: ...
    def setAttribute(self, key: str, value: Any) -> None: ...
    def attribute_string2dict(self, s: str) -> OrderedDict[str, Any]: ...
    def dict2attribute_string(self, d: Dict[str, Any]) -> str: ...
    def attribute_string2iterator(self, s: str) -> Iterable[Tuple[str, Any]]: ...
    def __getattr__(self, key: str) -> Any: ...
    def __setattr__(self, key: str, value: Any) -> None: ...
    # deprecated:
    # def asDict(self) -> Any: ...
    # def as_dict(self) -> Any: ...
    # def fromDict(self, *args, **kwargs) -> Any: ...

class GFF3Proxy(GTFProxy): ...

class BedProxy(NamedTupleProxy):
    def __setattr__(self, key: str, value: Any) -> None: ...

class VCFProxy(NamedTupleProxy):
    @property
    def pos(self) -> int: ...
    def __setattr__(self, key: str, value: Any) -> None: ...
