/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;
import weka.core.converters.FileSourcedConverter;
import weka.core.converters.IncrementalConverter;
import weka.core.converters.Loader;
import weka.core.converters.URLSourcedLoader;
import weka.gui.ConverterFileChooser;
import weka.gui.InstancesSummaryPanel;
import weka.gui.Messages;

public class SetInstancesPanel
extends JPanel {
    private static final long serialVersionUID = -384804041420453735L;
    protected JButton m_OpenFileBut;
    protected JButton m_OpenURLBut;
    protected JButton m_CloseBut;
    protected InstancesSummaryPanel m_Summary;
    protected ConverterFileChooser m_FileChooser;
    protected String m_LastURL;
    protected Thread m_IOThread;
    protected PropertyChangeSupport m_Support;
    protected Instances m_Instances;
    protected Loader m_Loader;
    protected JFrame m_ParentFrame;
    protected JPanel m_CloseButPanel;
    protected boolean m_readIncrementally;

    public SetInstancesPanel() {
        Messages.getInstance();
        this.m_OpenFileBut = new JButton(Messages.getString("SetInstancesPanel_OpenFileBut_JButton_Text"));
        Messages.getInstance();
        this.m_OpenURLBut = new JButton(Messages.getString("SetInstancesPanel_OpenURLBut_JButton_Text"));
        Messages.getInstance();
        this.m_CloseBut = new JButton(Messages.getString("SetInstancesPanel_CloseBut_JButton_Text"));
        this.m_Summary = new InstancesSummaryPanel();
        this.m_FileChooser = new ConverterFileChooser(new File(System.getProperty("user.dir")));
        this.m_LastURL = "http://";
        this.m_Support = new PropertyChangeSupport(this);
        this.m_ParentFrame = null;
        this.m_CloseButPanel = null;
        this.m_readIncrementally = true;
        Messages.getInstance();
        this.m_OpenFileBut.setToolTipText(Messages.getString("SetInstancesPanel_OpenFileBut_SetToolTipText_Text"));
        Messages.getInstance();
        this.m_OpenURLBut.setToolTipText(Messages.getString("SetInstancesPanel_OpenURLBut_SetToolTipText_Text"));
        Messages.getInstance();
        this.m_CloseBut.setToolTipText(Messages.getString("SetInstancesPanel_CloseBut_SetToolTipText_Text"));
        this.m_FileChooser.setFileSelectionMode(0);
        this.m_OpenURLBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SetInstancesPanel.this.setInstancesFromURLQ();
            }
        });
        this.m_OpenFileBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SetInstancesPanel.this.setInstancesFromFileQ();
            }
        });
        this.m_CloseBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SetInstancesPanel.this.closeFrame();
            }
        });
        this.m_Summary.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(1, 2));
        buttons.add(this.m_OpenFileBut);
        buttons.add(this.m_OpenURLBut);
        this.m_CloseButPanel = new JPanel();
        this.m_CloseButPanel.setLayout(new FlowLayout(2));
        this.m_CloseButPanel.add(this.m_CloseBut);
        this.m_CloseButPanel.setVisible(false);
        JPanel buttonsAll = new JPanel();
        buttonsAll.setLayout(new BorderLayout());
        buttonsAll.add((Component)buttons, "Center");
        buttonsAll.add((Component)this.m_CloseButPanel, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_Summary, "Center");
        this.add((Component)buttonsAll, "South");
    }

    public void setParentFrame(JFrame parent) {
        this.m_ParentFrame = parent;
        this.m_CloseButPanel.setVisible(this.m_ParentFrame != null);
    }

    public JFrame getParentFrame() {
        return this.m_ParentFrame;
    }

    public void closeFrame() {
        if (this.m_ParentFrame != null) {
            this.m_ParentFrame.setVisible(false);
        }
    }

    public void setInstancesFromFileQ() {
        if (this.m_IOThread == null) {
            int returnVal = this.m_FileChooser.showOpenDialog(this);
            if (returnVal == 0) {
                final File selected = this.m_FileChooser.getSelectedFile();
                this.m_IOThread = new Thread(){

                    public void run() {
                        SetInstancesPanel.this.setInstancesFromFile(selected);
                        SetInstancesPanel.this.m_IOThread = null;
                    }
                };
                this.m_IOThread.setPriority(1);
                this.m_IOThread.start();
            }
        } else {
            Messages.getInstance();
            String string = Messages.getString("SetInstancesPanel_SetInstancesFromFileQ_JOptionPaneShowMessageDialog_Text_First");
            Messages.getInstance();
            JOptionPane.showMessageDialog(this, string, Messages.getString("SetInstancesPanel_SetInstancesFromFileQ_JOptionPaneShowMessageDialog_Text_Second"), 2);
        }
    }

    public void setInstancesFromURLQ() {
        if (this.m_IOThread == null) {
            try {
                Messages.getInstance();
                String string = Messages.getString("SetInstancesPanel_SetInstancesFromFileQ_UrlName_JOptionPaneShowMessageDialog_Text_First");
                Messages.getInstance();
                String urlName = (String)JOptionPane.showInputDialog(this, string, Messages.getString("SetInstancesPanel_SetInstancesFromFileQ_UrlName_JOptionPaneShowMessageDialog_Text_Second"), 3, null, null, this.m_LastURL);
                if (urlName != null) {
                    this.m_LastURL = urlName;
                    final URL url = new URL(urlName);
                    this.m_IOThread = new Thread(){

                        public void run() {
                            SetInstancesPanel.this.setInstancesFromURL(url);
                            SetInstancesPanel.this.m_IOThread = null;
                        }
                    };
                    this.m_IOThread.setPriority(1);
                    this.m_IOThread.start();
                }
            }
            catch (Exception ex) {
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                String string = stringBuilder.append(Messages.getString("SetInstancesPanel_SetInstancesFromFileQ_Exception_JOptionPaneShowMessageDialog_Text_First")).append(ex.getMessage()).toString();
                Messages.getInstance();
                JOptionPane.showMessageDialog(this, string, Messages.getString("SetInstancesPanel_SetInstancesFromFileQ_Exception_JOptionPaneShowMessageDialog_Text_Second"), 0);
            }
        } else {
            Messages.getInstance();
            String string = Messages.getString("SetInstancesPanel_SetInstancesFromFileQ_Exception_JOptionPaneShowMessageDialog_Text_Third");
            Messages.getInstance();
            JOptionPane.showMessageDialog(this, string, Messages.getString("SetInstancesPanel_SetInstancesFromFileQ_Exception_JOptionPaneShowMessageDialog_Text_Fourth"), 2);
        }
    }

    protected void setInstancesFromFile(File f) {
        boolean incremental = this.m_readIncrementally;
        try {
            this.m_Loader = ConverterUtils.getLoaderForFile(f);
            if (this.m_Loader == null) {
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                throw new Exception(stringBuilder.append(Messages.getString("SetInstancesPanel_SetInstancesFromFile_Exception_Text_First")).append(f).toString());
            }
            if (!(this.m_Loader instanceof IncrementalConverter)) {
                incremental = false;
            }
            ((FileSourcedConverter)((Object)this.m_Loader)).setFile(f);
            if (incremental) {
                this.setInstances(this.m_Loader.getStructure());
            } else {
                this.setInstances(this.m_Loader.getDataSet());
            }
        }
        catch (Exception ex) {
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            String string = stringBuilder.append(Messages.getString("SetInstancesPanel_SetInstancesFromFile_Exception_JOptionPaneShowMessageDialog_Text_First")).append(f.getName()).toString();
            Messages.getInstance();
            JOptionPane.showMessageDialog(this, string, Messages.getString("SetInstancesPanel_SetInstancesFromFile_Exception_JOptionPaneShowMessageDialog_Text_Second"), 0);
        }
    }

    protected void setInstancesFromURL(URL u) {
        boolean incremental = this.m_readIncrementally;
        try {
            this.m_Loader = ConverterUtils.getURLLoaderForFile(u.toString());
            if (this.m_Loader == null) {
                StringBuilder stringBuilder = new StringBuilder();
                Messages.getInstance();
                throw new Exception(stringBuilder.append(Messages.getString("SetInstancesPanel_SetInstancesFromURL_Exception_Text_First")).append(u).toString());
            }
            if (!(this.m_Loader instanceof IncrementalConverter)) {
                incremental = false;
            }
            ((URLSourcedLoader)((Object)this.m_Loader)).setURL(u.toString());
            if (incremental) {
                this.setInstances(this.m_Loader.getStructure());
            } else {
                this.setInstances(this.m_Loader.getDataSet());
            }
        }
        catch (Exception ex) {
            StringBuilder stringBuilder = new StringBuilder();
            Messages.getInstance();
            String string = stringBuilder.append(Messages.getString("SetInstancesPanel_SetInstancesFromURL_Exception_JOptionPaneShowMessageDialog_Text_First")).append(u).toString();
            Messages.getInstance();
            JOptionPane.showMessageDialog(this, string, Messages.getString("SetInstancesPanel_SetInstancesFromURL_Exception_JOptionPaneShowMessageDialog_Text_Second"), 0);
        }
    }

    public void setInstances(Instances i) {
        this.m_Instances = i;
        this.m_Summary.setInstances(this.m_Instances);
        this.m_Support.firePropertyChange("", null, null);
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    public Loader getLoader() {
        return this.m_Loader;
    }

    public InstancesSummaryPanel getSummary() {
        return this.m_Summary;
    }

    public void setReadIncrementally(boolean incremental) {
        this.m_readIncrementally = incremental;
    }

    public boolean getReadIncrementally() {
        return this.m_readIncrementally;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.m_Support.removePropertyChangeListener(l);
    }
}

