/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <DBOptionsAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for DBOptionsAttributes::OptionType
//

static const char *OptionType_strings[] = {
"Bool", "Int", "Float", 
"Double", "String", "Enum"
};

std::string
DBOptionsAttributes::OptionType_ToString(DBOptionsAttributes::OptionType t)
{
    int index = int(t);
    if(index < 0 || index >= 6) index = 0;
    return OptionType_strings[index];
}

std::string
DBOptionsAttributes::OptionType_ToString(int t)
{
    int index = (t < 0 || t >= 6) ? 0 : t;
    return OptionType_strings[index];
}

bool
DBOptionsAttributes::OptionType_FromString(const std::string &s, DBOptionsAttributes::OptionType &val)
{
    val = DBOptionsAttributes::Bool;
    for(int i = 0; i < 6; ++i)
    {
        if(s == OptionType_strings[i])
        {
            val = (OptionType)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: DBOptionsAttributes::DBOptionsAttributes
//
// Purpose: 
//   Init utility for the DBOptionsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void DBOptionsAttributes::Init()
{

    DBOptionsAttributes::SelectAll();
}

// ****************************************************************************
// Method: DBOptionsAttributes::DBOptionsAttributes
//
// Purpose: 
//   Copy utility for the DBOptionsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void DBOptionsAttributes::Copy(const DBOptionsAttributes &obj)
{
    types = obj.types;
    names = obj.names;
    optBools = obj.optBools;
    optFloats = obj.optFloats;
    optDoubles = obj.optDoubles;
    optInts = obj.optInts;
    optStrings = obj.optStrings;
    optEnums = obj.optEnums;
    enumStrings = obj.enumStrings;
    enumStringsSizes = obj.enumStringsSizes;
    obsoleteNames = obj.obsoleteNames;
    help = obj.help;

    DBOptionsAttributes::SelectAll();
}

// Type map format string
const char *DBOptionsAttributes::TypeMapFormatString = DBOPTIONSATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t DBOptionsAttributes::TmfsStruct = {DBOPTIONSATTRIBUTES_TMFS};


// ****************************************************************************
// Method: DBOptionsAttributes::DBOptionsAttributes
//
// Purpose: 
//   Default constructor for the DBOptionsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DBOptionsAttributes::DBOptionsAttributes() : 
    AttributeSubject(DBOptionsAttributes::TypeMapFormatString)
{
    DBOptionsAttributes::Init();
}

// ****************************************************************************
// Method: DBOptionsAttributes::DBOptionsAttributes
//
// Purpose: 
//   Constructor for the derived classes of DBOptionsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DBOptionsAttributes::DBOptionsAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    DBOptionsAttributes::Init();
}

// ****************************************************************************
// Method: DBOptionsAttributes::DBOptionsAttributes
//
// Purpose: 
//   Copy constructor for the DBOptionsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DBOptionsAttributes::DBOptionsAttributes(const DBOptionsAttributes &obj) : 
    AttributeSubject(DBOptionsAttributes::TypeMapFormatString)
{
    DBOptionsAttributes::Copy(obj);
}

// ****************************************************************************
// Method: DBOptionsAttributes::DBOptionsAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the DBOptionsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DBOptionsAttributes::DBOptionsAttributes(const DBOptionsAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    DBOptionsAttributes::Copy(obj);
}

// ****************************************************************************
// Method: DBOptionsAttributes::~DBOptionsAttributes
//
// Purpose: 
//   Destructor for the DBOptionsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DBOptionsAttributes::~DBOptionsAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: DBOptionsAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the DBOptionsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DBOptionsAttributes& 
DBOptionsAttributes::operator = (const DBOptionsAttributes &obj)
{
    if (this == &obj) return *this;

    DBOptionsAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: DBOptionsAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the DBOptionsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
DBOptionsAttributes::operator == (const DBOptionsAttributes &obj) const
{
    // Create the return value
    return ((types == obj.types) &&
            (names == obj.names) &&
            (optBools == obj.optBools) &&
            (optFloats == obj.optFloats) &&
            (optDoubles == obj.optDoubles) &&
            (optInts == obj.optInts) &&
            (optStrings == obj.optStrings) &&
            (optEnums == obj.optEnums) &&
            (enumStrings == obj.enumStrings) &&
            (enumStringsSizes == obj.enumStringsSizes) &&
            (obsoleteNames == obj.obsoleteNames) &&
            true /* can ignore help */);
}

// ****************************************************************************
// Method: DBOptionsAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the DBOptionsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
DBOptionsAttributes::operator != (const DBOptionsAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: DBOptionsAttributes::TypeName
//
// Purpose: 
//   Type name method for the DBOptionsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
DBOptionsAttributes::TypeName() const
{
    return "DBOptionsAttributes";
}

// ****************************************************************************
// Method: DBOptionsAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the DBOptionsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
DBOptionsAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const DBOptionsAttributes *tmp = (const DBOptionsAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: DBOptionsAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the DBOptionsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
DBOptionsAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new DBOptionsAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: DBOptionsAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the DBOptionsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
DBOptionsAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new DBOptionsAttributes(*this);
    else
        retval = new DBOptionsAttributes;

    return retval;
}

// ****************************************************************************
// Method: DBOptionsAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
DBOptionsAttributes::SelectAll()
{
    Select(ID_types,            (void *)&types);
    Select(ID_names,            (void *)&names);
    Select(ID_optBools,         (void *)&optBools);
    Select(ID_optFloats,        (void *)&optFloats);
    Select(ID_optDoubles,       (void *)&optDoubles);
    Select(ID_optInts,          (void *)&optInts);
    Select(ID_optStrings,       (void *)&optStrings);
    Select(ID_optEnums,         (void *)&optEnums);
    Select(ID_enumStrings,      (void *)&enumStrings);
    Select(ID_enumStringsSizes, (void *)&enumStringsSizes);
    Select(ID_obsoleteNames,    (void *)&obsoleteNames);
    Select(ID_help,             (void *)&help);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: DBOptionsAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
DBOptionsAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    DBOptionsAttributes defaultObject;
    bool addToParent = false;
    // Create a node for DBOptionsAttributes.
    DataNode *node = new DataNode("DBOptionsAttributes");

    if(completeSave || !FieldsEqual(ID_types, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("types", types));
    }

    if(completeSave || !FieldsEqual(ID_names, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("names", names));
    }

    if(completeSave || !FieldsEqual(ID_optBools, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("optBools", optBools));
    }

    if(completeSave || !FieldsEqual(ID_optFloats, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("optFloats", optFloats));
    }

    if(completeSave || !FieldsEqual(ID_optDoubles, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("optDoubles", optDoubles));
    }

    if(completeSave || !FieldsEqual(ID_optInts, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("optInts", optInts));
    }

    if(completeSave || !FieldsEqual(ID_optStrings, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("optStrings", optStrings));
    }

    if(completeSave || !FieldsEqual(ID_optEnums, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("optEnums", optEnums));
    }

    if(completeSave || !FieldsEqual(ID_enumStrings, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("enumStrings", enumStrings));
    }

    if(completeSave || !FieldsEqual(ID_enumStringsSizes, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("enumStringsSizes", enumStringsSizes));
    }

    if(completeSave || !FieldsEqual(ID_obsoleteNames, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("obsoleteNames", obsoleteNames));
    }

    if(completeSave || !FieldsEqual(ID_help, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("help", help));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: DBOptionsAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
DBOptionsAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("DBOptionsAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("types")) != 0)
        SetTypes(node->AsIntVector());
    if((node = searchNode->GetNode("names")) != 0)
        SetNames(node->AsStringVector());
    if((node = searchNode->GetNode("optBools")) != 0)
        SetOptBools(node->AsIntVector());
    if((node = searchNode->GetNode("optFloats")) != 0)
        SetOptFloats(node->AsDoubleVector());
    if((node = searchNode->GetNode("optDoubles")) != 0)
        SetOptDoubles(node->AsDoubleVector());
    if((node = searchNode->GetNode("optInts")) != 0)
        SetOptInts(node->AsIntVector());
    if((node = searchNode->GetNode("optStrings")) != 0)
        SetOptStrings(node->AsStringVector());
    if((node = searchNode->GetNode("optEnums")) != 0)
        SetOptEnums(node->AsIntVector());
    if((node = searchNode->GetNode("enumStrings")) != 0)
        SetEnumStrings(node->AsStringVector());
    if((node = searchNode->GetNode("enumStringsSizes")) != 0)
        SetEnumStringsSizes(node->AsIntVector());
    if((node = searchNode->GetNode("obsoleteNames")) != 0)
        SetObsoleteNames(node->AsStringVector());
    if((node = searchNode->GetNode("help")) != 0)
        SetHelp(node->AsString());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
DBOptionsAttributes::SetTypes(const intVector &types_)
{
    types = types_;
    Select(ID_types, (void *)&types);
}

void
DBOptionsAttributes::SetNames(const stringVector &names_)
{
    names = names_;
    Select(ID_names, (void *)&names);
}

void
DBOptionsAttributes::SetOptBools(const intVector &optBools_)
{
    optBools = optBools_;
    Select(ID_optBools, (void *)&optBools);
}

void
DBOptionsAttributes::SetOptFloats(const doubleVector &optFloats_)
{
    optFloats = optFloats_;
    Select(ID_optFloats, (void *)&optFloats);
}

void
DBOptionsAttributes::SetOptDoubles(const doubleVector &optDoubles_)
{
    optDoubles = optDoubles_;
    Select(ID_optDoubles, (void *)&optDoubles);
}

void
DBOptionsAttributes::SetOptInts(const intVector &optInts_)
{
    optInts = optInts_;
    Select(ID_optInts, (void *)&optInts);
}

void
DBOptionsAttributes::SetOptStrings(const stringVector &optStrings_)
{
    optStrings = optStrings_;
    Select(ID_optStrings, (void *)&optStrings);
}

void
DBOptionsAttributes::SetOptEnums(const intVector &optEnums_)
{
    optEnums = optEnums_;
    Select(ID_optEnums, (void *)&optEnums);
}

void
DBOptionsAttributes::SetEnumStrings(const stringVector &enumStrings_)
{
    enumStrings = enumStrings_;
    Select(ID_enumStrings, (void *)&enumStrings);
}

void
DBOptionsAttributes::SetEnumStringsSizes(const intVector &enumStringsSizes_)
{
    enumStringsSizes = enumStringsSizes_;
    Select(ID_enumStringsSizes, (void *)&enumStringsSizes);
}

void
DBOptionsAttributes::SetObsoleteNames(const stringVector &obsoleteNames_)
{
    obsoleteNames = obsoleteNames_;
    Select(ID_obsoleteNames, (void *)&obsoleteNames);
}

void
DBOptionsAttributes::SetHelp(const std::string &help_)
{
    help = help_;
    Select(ID_help, (void *)&help);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const intVector &
DBOptionsAttributes::GetTypes() const
{
    return types;
}

intVector &
DBOptionsAttributes::GetTypes()
{
    return types;
}

const stringVector &
DBOptionsAttributes::GetNames() const
{
    return names;
}

stringVector &
DBOptionsAttributes::GetNames()
{
    return names;
}

const intVector &
DBOptionsAttributes::GetOptBools() const
{
    return optBools;
}

intVector &
DBOptionsAttributes::GetOptBools()
{
    return optBools;
}

const doubleVector &
DBOptionsAttributes::GetOptFloats() const
{
    return optFloats;
}

doubleVector &
DBOptionsAttributes::GetOptFloats()
{
    return optFloats;
}

const doubleVector &
DBOptionsAttributes::GetOptDoubles() const
{
    return optDoubles;
}

doubleVector &
DBOptionsAttributes::GetOptDoubles()
{
    return optDoubles;
}

const intVector &
DBOptionsAttributes::GetOptInts() const
{
    return optInts;
}

intVector &
DBOptionsAttributes::GetOptInts()
{
    return optInts;
}

const stringVector &
DBOptionsAttributes::GetOptStrings() const
{
    return optStrings;
}

stringVector &
DBOptionsAttributes::GetOptStrings()
{
    return optStrings;
}

const intVector &
DBOptionsAttributes::GetOptEnums() const
{
    return optEnums;
}

intVector &
DBOptionsAttributes::GetOptEnums()
{
    return optEnums;
}

const stringVector &
DBOptionsAttributes::GetEnumStrings() const
{
    return enumStrings;
}

stringVector &
DBOptionsAttributes::GetEnumStrings()
{
    return enumStrings;
}

const intVector &
DBOptionsAttributes::GetEnumStringsSizes() const
{
    return enumStringsSizes;
}

intVector &
DBOptionsAttributes::GetEnumStringsSizes()
{
    return enumStringsSizes;
}

const stringVector &
DBOptionsAttributes::GetObsoleteNames() const
{
    return obsoleteNames;
}

stringVector &
DBOptionsAttributes::GetObsoleteNames()
{
    return obsoleteNames;
}

const std::string &
DBOptionsAttributes::GetHelp() const
{
    return help;
}

std::string &
DBOptionsAttributes::GetHelp()
{
    return help;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
DBOptionsAttributes::SelectTypes()
{
    Select(ID_types, (void *)&types);
}

void
DBOptionsAttributes::SelectNames()
{
    Select(ID_names, (void *)&names);
}

void
DBOptionsAttributes::SelectOptBools()
{
    Select(ID_optBools, (void *)&optBools);
}

void
DBOptionsAttributes::SelectOptFloats()
{
    Select(ID_optFloats, (void *)&optFloats);
}

void
DBOptionsAttributes::SelectOptDoubles()
{
    Select(ID_optDoubles, (void *)&optDoubles);
}

void
DBOptionsAttributes::SelectOptInts()
{
    Select(ID_optInts, (void *)&optInts);
}

void
DBOptionsAttributes::SelectOptStrings()
{
    Select(ID_optStrings, (void *)&optStrings);
}

void
DBOptionsAttributes::SelectOptEnums()
{
    Select(ID_optEnums, (void *)&optEnums);
}

void
DBOptionsAttributes::SelectEnumStrings()
{
    Select(ID_enumStrings, (void *)&enumStrings);
}

void
DBOptionsAttributes::SelectEnumStringsSizes()
{
    Select(ID_enumStringsSizes, (void *)&enumStringsSizes);
}

void
DBOptionsAttributes::SelectObsoleteNames()
{
    Select(ID_obsoleteNames, (void *)&obsoleteNames);
}

void
DBOptionsAttributes::SelectHelp()
{
    Select(ID_help, (void *)&help);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: DBOptionsAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
DBOptionsAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_types:            return "types";
    case ID_names:            return "names";
    case ID_optBools:         return "optBools";
    case ID_optFloats:        return "optFloats";
    case ID_optDoubles:       return "optDoubles";
    case ID_optInts:          return "optInts";
    case ID_optStrings:       return "optStrings";
    case ID_optEnums:         return "optEnums";
    case ID_enumStrings:      return "enumStrings";
    case ID_enumStringsSizes: return "enumStringsSizes";
    case ID_obsoleteNames:    return "obsoleteNames";
    case ID_help:             return "help";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: DBOptionsAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
DBOptionsAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_types:            return FieldType_intVector;
    case ID_names:            return FieldType_stringVector;
    case ID_optBools:         return FieldType_intVector;
    case ID_optFloats:        return FieldType_doubleVector;
    case ID_optDoubles:       return FieldType_doubleVector;
    case ID_optInts:          return FieldType_intVector;
    case ID_optStrings:       return FieldType_stringVector;
    case ID_optEnums:         return FieldType_intVector;
    case ID_enumStrings:      return FieldType_stringVector;
    case ID_enumStringsSizes: return FieldType_intVector;
    case ID_obsoleteNames:    return FieldType_stringVector;
    case ID_help:             return FieldType_string;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: DBOptionsAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
DBOptionsAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_types:            return "intVector";
    case ID_names:            return "stringVector";
    case ID_optBools:         return "intVector";
    case ID_optFloats:        return "doubleVector";
    case ID_optDoubles:       return "doubleVector";
    case ID_optInts:          return "intVector";
    case ID_optStrings:       return "stringVector";
    case ID_optEnums:         return "intVector";
    case ID_enumStrings:      return "stringVector";
    case ID_enumStringsSizes: return "intVector";
    case ID_obsoleteNames:    return "stringVector";
    case ID_help:             return "string";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: DBOptionsAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
DBOptionsAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const DBOptionsAttributes &obj = *((const DBOptionsAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_types:
        {  // new scope
        retval = (types == obj.types);
        }
        break;
    case ID_names:
        {  // new scope
        retval = (names == obj.names);
        }
        break;
    case ID_optBools:
        {  // new scope
        retval = (optBools == obj.optBools);
        }
        break;
    case ID_optFloats:
        {  // new scope
        retval = (optFloats == obj.optFloats);
        }
        break;
    case ID_optDoubles:
        {  // new scope
        retval = (optDoubles == obj.optDoubles);
        }
        break;
    case ID_optInts:
        {  // new scope
        retval = (optInts == obj.optInts);
        }
        break;
    case ID_optStrings:
        {  // new scope
        retval = (optStrings == obj.optStrings);
        }
        break;
    case ID_optEnums:
        {  // new scope
        retval = (optEnums == obj.optEnums);
        }
        break;
    case ID_enumStrings:
        {  // new scope
        retval = (enumStrings == obj.enumStrings);
        }
        break;
    case ID_enumStringsSizes:
        {  // new scope
        retval = (enumStringsSizes == obj.enumStringsSizes);
        }
        break;
    case ID_obsoleteNames:
        {  // new scope
        retval = (obsoleteNames == obj.obsoleteNames);
        }
        break;
    case ID_help:
        {  // new scope
        retval = (help == obj.help);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
//  Method: DBOptionsAttributes::FindIndex
//
//  Purpose:
//     Finds the index of a member.
//
//  Programmer: Hank Childs
//  Creation:   May 23, 2005
//
//  Modifications:
//    Mark C. Miller, Tue Apr 29 17:39:39 PDT 2008
//    Made it a const method
// ****************************************************************************

int
DBOptionsAttributes::FindIndex(const std::string &name) const
{
    for (size_t i = 0 ; i < names.size() ; i++)
        if (names[i] == name)
        {
            // Now find the index within its type.
            int nMatches = 0;
            for (size_t j = 0 ; j < i ; j++)
                 if (types[j] == types[i])
                     nMatches++;
            return nMatches;
        }

    return -1;
}

// ****************************************************************************
//  Method: DBOptionsAttributes::SetBool
//
//  Purpose:
//      Sets a boolean value.
//
//  Programmer: Hank Childs
//  Creation:   May 23, 2005
//
// ****************************************************************************

void
DBOptionsAttributes::SetBool(const std::string &name, bool defaultValue)
{
    int bIndex = FindIndex(name);
    if (bIndex < 0)
    {
        names.push_back(name);
        types.push_back(Bool);
        optBools.push_back(defaultValue);
    }
    else
        optBools[bIndex] = defaultValue;
}

// ****************************************************************************
//  Method: DBOptionsAttributes::GetBool
//
//  Purpose:
//      Gets a boolean value.
//
//  Programmer: Hank Childs
//  Creation:   May 23, 2005
//
//  Modifications:
//    Mark C. Miller, Tue Apr 29 17:39:39 PDT 2008
//    Made it a const method
//
// ****************************************************************************

bool
DBOptionsAttributes::GetBool(const std::string &name) const
{
    int bIndex = FindIndex(name);
    if (bIndex < 0)
        EXCEPTION0(BadDeclareFormatString);
    return optBools[bIndex] != 0;
}

// ****************************************************************************
//  Method: DBOptionsAttributes::SetFloat
//
//  Purpose:
//      Sets a floating point value.
//
//  Programmer: Hank Childs
//  Creation:   May 23, 2005
//
// ****************************************************************************

void
DBOptionsAttributes::SetFloat(const std::string &name, float defaultValue)
{
    int bIndex = FindIndex(name);
    if (bIndex < 0)
    {
        names.push_back(name);
        types.push_back(Float);
        optFloats.push_back(defaultValue);
    }
    else
        optFloats[bIndex] = defaultValue;
}

// ****************************************************************************
//  Method: DBOptionsAttributes::GetFloat
//
//  Purpose:
//      Gets a floating point value.
//
//  Programmer: Hank Childs
//  Creation:   May 23, 2005
//
//  Modifications:
//    Mark C. Miller, Tue Apr 29 17:39:39 PDT 2008
//    Made it a const method
//
// ****************************************************************************

float
DBOptionsAttributes::GetFloat(const std::string &name) const
{
    int bIndex = FindIndex(name);
    if (bIndex < 0)
        EXCEPTION0(BadDeclareFormatString);
    return (float) optFloats[bIndex];
}

// ****************************************************************************
//  Method: DBOptionsAttributes::SetDouble
//
//  Purpose:
//      Sets a double precision value.
//
//  Programmer: Hank Childs
//  Creation:   May 23, 2005
//
// ****************************************************************************

void
DBOptionsAttributes::SetDouble(const std::string &name, double defaultValue)
{
    int bIndex = FindIndex(name);
    if (bIndex < 0)
    {
        names.push_back(name);
        types.push_back(Double);
        optDoubles.push_back(defaultValue);
    }
    else
        optDoubles[bIndex] = defaultValue;
}

// ****************************************************************************
//  Method: DBOptionsAttributes::GetDouble
//
//  Purpose:
//      Gets a double precision value.
//
//  Programmer: Hank Childs
//  Creation:   May 23, 2005
//
//  Modifications:
//    Mark C. Miller, Tue Apr 29 17:39:39 PDT 2008
//    Made it a const method
//
// ****************************************************************************

double
DBOptionsAttributes::GetDouble(const std::string &name) const
{
    int bIndex = FindIndex(name);
    if (bIndex < 0)
        EXCEPTION0(BadDeclareFormatString);
    return optDoubles[bIndex];
}

// ****************************************************************************
//  Method: DBOptionsAttributes::SetInt
//
//  Purpose:
//      Sets an integer value.
//
//  Programmer: Hank Childs
//  Creation:   May 23, 2005
//
// ****************************************************************************

void
DBOptionsAttributes::SetInt(const std::string &name, int defaultValue)
{
    int bIndex = FindIndex(name);
    if (bIndex < 0)
    {
        names.push_back(name);
        types.push_back(Int);
        optInts.push_back(defaultValue);
    }
    else
        optInts[bIndex] = defaultValue;
}

// ****************************************************************************
//  Method: DBOptionsAttributes::GetInt
//
//  Purpose:
//      Gets an integer value.
//
//  Programmer: Hank Childs
//  Creation:   May 23, 2005
//
//  Modifications:
//    Mark C. Miller, Tue Apr 29 17:39:39 PDT 2008
//    Made it a const method
//
// ****************************************************************************

int
DBOptionsAttributes::GetInt(const std::string &name) const
{
    int bIndex = FindIndex(name);
    if (bIndex < 0)
        EXCEPTION0(BadDeclareFormatString);
    return optInts[bIndex];
}

// ****************************************************************************
//  Method: DBOptionsAttributes::SetString
//
//  Purpose:
//      Sets a string value.
//
//  Programmer: Hank Childs
//  Creation:   May 23, 2005
//
// ****************************************************************************

void
DBOptionsAttributes::SetString(const std::string &name, const std::string &defaultValue)
{
    int bIndex = FindIndex(name);
    if (bIndex < 0)
    {
        names.push_back(name);
        types.push_back(String);
        optStrings.push_back(defaultValue);
    }
    else
        optStrings[bIndex] = defaultValue;
}

// ****************************************************************************
//  Method: DBOptionsAttributes::GetString
//
//  Purpose:
//      Gets a string value.
//
//  Programmer: Hank Childs
//  Creation:   May 23, 2005
//
//  Modifications:
//    Mark C. Miller, Tue Apr 29 17:39:39 PDT 2008
//    Made it a const method
//
// ****************************************************************************

const std::string &
DBOptionsAttributes::GetString(const std::string &name) const
{
    int bIndex = FindIndex(name);
    if (bIndex < 0)
        EXCEPTION0(BadDeclareFormatString);
    return optStrings[bIndex];
}

// ****************************************************************************
//  Method: DBOptionsAttributes::SetEnum
//
//  Purpose:
//      Sets a enumerated value (encoded as int).
//
//  Programmer: Hank Childs
//  Creation:   May 23, 2005
//
//  Modifications:
//    Jeremy Meredith, Fri Oct 12 10:40:26 EDT 2007
//    Fixed a bug where the string size array wasn't kept conformant with
//    the other arrays.
//
// ****************************************************************************

void
DBOptionsAttributes::SetEnum(const std::string &name, int defaultValue)
{
    int bIndex = FindIndex(name);
    if (bIndex < 0)
    {
        names.push_back(name);
        types.push_back(Enum);
        optEnums.push_back(defaultValue);
        enumStringsSizes.push_back(0);
    }
    else
        optEnums[bIndex] = defaultValue;
}

// ****************************************************************************
//  Method: DBOptionsAttributes::GetEnum
//
//  Purpose:
//      Gets a enumerated value (encoded as int).
//
//  Programmer: Hank Childs
//  Creation:   May 23, 2005
//
//  Modifications:
//    Mark C. Miller, Tue Apr 29 17:39:39 PDT 2008
//    Made it a const method
//
// ****************************************************************************

int
DBOptionsAttributes::GetEnum(const std::string &name) const
{
    int bIndex = FindIndex(name);
    if (bIndex < 0)
        EXCEPTION0(BadDeclareFormatString);
    return optEnums[bIndex];
}

// ****************************************************************************
//  Method: DBOptionsAttributes::SetEnumStrings
//
//  Purpose:
//      Sets the strings for an enumerated type.
//
//  Programmer: Hank Childs
//  Creation:   May 23, 2005
//
// ****************************************************************************

void
DBOptionsAttributes::SetEnumStrings(const std::string &name, 
                                    const std::vector<std::string> &values)
{
    int eIndex = FindIndex(name);
    if (eIndex < 0)
        EXCEPTION0(BadDeclareFormatString);

    int numEnums = (int)optEnums.size();
    std::vector<std::string> newList;
    int idx = 0;
    for (int i = 0 ; i < numEnums ; i++)
    {
         if (i == eIndex)
         {
             for (size_t j = 0 ; j < values.size() ; j++)
                 newList.push_back(values[j]);
         }
         else
         {
             for (int j = 0 ; j < enumStringsSizes[i] ; j++)
                 newList.push_back(enumStrings[idx+j]);
         }
         idx += enumStringsSizes[i];
    }
    enumStrings = newList;
    enumStringsSizes[eIndex] = values.size();
}

int
DBOptionsAttributes::GetNumberOfOptions(void) const
{
    return names.size();
}

DBOptionsAttributes::OptionType
DBOptionsAttributes::GetType(int index) const
{
    if (index < 0 || (size_t)index >= types.size())
        EXCEPTION0(BadDeclareFormatString);

    return (DBOptionsAttributes::OptionType) types[index];
}

// ****************************************************************************
//  Method: DBOptionsAttributes::GetEnumStrings
//
//  Purpose:
//     Finds the index of a member.
//
//  Programmer: Hank Childs (assumed)
//  Creation:   Unknown
//
//  Modifications:
//    Mark C. Miller, Tue Apr 29 17:39:39 PDT 2008
//    Made it a const method
// ****************************************************************************
std::vector<std::string>
DBOptionsAttributes::GetEnumStrings(const std::string &name) const
{
    int  i;

    int eIndex = FindIndex(name);
    if (eIndex < 0)
        EXCEPTION0(BadDeclareFormatString);

    int start = 0;
    for (i = 0 ; i < eIndex ; i++)
         start += enumStringsSizes[i];

    std::vector<std::string> rv(enumStringsSizes[eIndex]);
    for (i = 0 ; i < enumStringsSizes[eIndex] ; i++)
         rv[i] = enumStrings[start+i];

    return rv;
}

std::string
DBOptionsAttributes::GetName(int idx) const
{
    return names[idx];
}

// ****************************************************************************
//  Method: DBOptionsAttributes::SetObsolete
//
//  Purpose: Indicate that a given option is obsolete.
//
//  Programmer: Mark C. Miller
//  Creation:   March 4, 2009
//
// ****************************************************************************

void
DBOptionsAttributes::SetObsolete(const std::string &name)
{
    obsoleteNames.push_back(name);
}

// ****************************************************************************
//  Method: DBOptionsAttributes::IsObsolete
//
//  Purpose: Returns whether a given option name is obsolete.
//
//  Programmer: Mark C. Miller
//  Creation:   March 16, 2009
// ****************************************************************************

bool
DBOptionsAttributes::IsObsolete(const std::string &name) const
{
    for (size_t i = 0 ; i < obsoleteNames.size() ; i++)
    {
        if (obsoleteNames[i] == name)
            return true;
    }
    return false;
}

// ****************************************************************************
//  Method: DBOptionsAttributes::Merge
//
//  Purpose: Merges options into this object.
//
//  Programmer: Brad Whitlock
//  Creation:   Fri Aug 14 18:04:39 PDT 2015
//
// ****************************************************************************

bool
DBOptionsAttributes::Merge(const DBOptionsAttributes &obj)
{
    bool retval = true;

    TRY
    {
        for(int i = 0; i < obj.GetNumberOfOptions(); ++i)
        {
            std::string name = obj.GetName(i);
            OptionType type = obj.GetType(i);
            switch(type)
            {
            case Bool:
                SetBool(name, obj.GetBool(name));
                break;
            case Int:
                SetInt(name, obj.GetInt(name));
                break;
            case Float:
                SetFloat(name, obj.GetFloat(name));
                break;
            case Double:
                SetDouble(name, obj.GetDouble(name));
                break;
            case String:
                SetString(name, obj.GetString(name));
                break;
            case Enum:
                SetEnum(name, obj.GetEnum(name));
                SetEnumStrings(name, obj.GetEnumStrings(name));
                break;
            }
        }
    }
    CATCHALL
    {
        retval = false;
    }
    ENDTRY

    return retval;
}

