/***************************************************************************
 *   Copyright (C) 2005 by Dmitry Nezhevenko                               *
 *   dionua@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef P2K_MOTO_H
#define P2K_MOTO_H

// Error codes
#define P2K_E_NOPHONE -1
#define P2K_E_CANT_OPEN -2
#define P2K_E_CANT_SETCONFIG -3
#define P2K_E_CANT_CLAIMIFACE -4
#define P2K_E_CANT_CLOSE -5
#define P2K_E_NOT_CONNECTED -6
#define P2K_E_ANSWER_E001 -7
#define P2K_E_ANSWER_E002 -8
#define P2K_E_CPH_00 -9
#define P2K_E_CPH_01 -10
#define P2K_E_CPH_02a -11
#define P2K_E_CPH_02b -12
#define P2K_E_CPH_03 -13
#define P2K_E_OUTDATA -14
#define P2K_E_INPSIZE -15
#define P2K_E_INPDATA -16
#define P2K_E_CPH -17
#define P2K_E_INCORRECT_SEEMSIZE -18
#define P2K_E_BUFFER_TOOLONG -19

#define P2K_E_BUG -100
#define P2K_E_OLD -200

// Phone state
#define P2K_PHONE_NONE 0
#define P2K_PHONE_AT 1
#define P2K_PHONE_P2K 2

#define P2K_SEEK_BEGIN 0
#define P2K_SEEK_CURRENT 1
#define P2K_SEEK_END 2

typedef struct
{
	int vendor;
	int product;
	char manufacturerStr[256];
	char productStr[256];
}
p2k_devInfo;

// File information
typedef struct
{
	long id; //File number
	char name[256]; //File name. For phones with directories is like /a/mobile/aaa
	long size; //File size
	unsigned char owner; //File owner
	unsigned char attr;  //File attributes
} p2k_fileInfo;

typedef void (*p2k_onFile) (p2k_fileInfo file);

// Init library. Run first
void p2k_init();

// Set AT Vendor/Product ID. (Default 0x22b8/0x4902 - for C380/C650)
void p2k_setATconfig (unsigned int vendor, unsigned int product);

// Set P2K Vendor/Product ID. (Default 0x22b8/0x4901 - for C380/C650)
void p2k_setP2Kconfig (unsigned int vendor, unsigned int product);

// Get usb device list (like lsusb). Return count of devices.
p2k_devInfo* p2k_getDevList();

// Find phone. Returns current phone state (P2K_PHONE_NONE...)
int p2k_findPhone();

// Open phone
int p2k_openPhone();

// Close phone
int p2k_closePhone();

// Reboot phone
int p2k_reboot();

// Suspend phone
int p2k_suspend();

// Get hone drive name
// Unknown result for E398 and other phones with flash card
int p2k_getDriveName(unsigned char * buf);

// Get phone model
int p2k_getPhoneModel(unsigned char * buf);

// Get free space on device
int p2k_freeSpace(unsigned char * dev);

// Get File count
int p2k_fileCount();

// Get file list. onGetFile will be called for each file.
int p2k_fileList(p2k_onFile onGetFile);

// Read SEEM, record XXXX_YYYY from phone to seemBuf
int p2k_read_seem(int x, int y, unsigned char * seemBuf, int seemBufSize);

// Write SEEM record to phone.
int p2k_write_seem(int x, int y, unsigned char * seemBuf, int seemSize);

// Delete file from phone. File must be closed.
int p2k_FSAC_Delete(char * fname);

// Open file. file attributes will be changed to attr.
// Only one file can be opened. Close opened file before open new one.
int p2k_FSAC_Open(char * fname, unsigned char attr);

// Close file
int p2k_FSAC_Close();

// Seek in file. dir:
// P2K_SEEK_BEGIN - seek from begin
// P2K_SEEK_CURRENT - seek from current position
// P2K_SEEK_END - seek from end of file
int p2k_FSAC_Seek(unsigned long offset, char dir);

// Read data from file. size must be <= 0x400
// File pos will be increased.
int p2k_FSAC_Read(unsigned char * buf, unsigned short size);

// Write data to file. size must be <= 0x400
// File pos will be increased.
int p2k_FSAC_Write(unsigned char * tbuf, int size);


#endif
