/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2008 Sun Microsystems, Inc.
 */

package org.netbeans.modules.maven.configurations;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.DialogDescriptor;

/**
 *
 * @author  mkleint
 */
public class NewConfigurationPanel extends javax.swing.JPanel implements DocumentListener {

    private DialogDescriptor descriptor;

    public String getConfigurationId() {
        return txtId.getText();
    }

    public void setConfigurationId(String configurationId) {
        txtId.setText(configurationId);
        txtId.setEditable(false);
        txtId.setEnabled(false);
    }

    public boolean isShared() {
        return cbShared.isSelected();
    }

    public void setShared(boolean shared) {
        cbShared.setSelected(shared);
    }
    /** Creates new form NewConfigurationPanel */
    public NewConfigurationPanel() {
        initComponents();

        txtId.getDocument().addDocumentListener(this);
    }
    
    public void setProfiles(List<String> profiles) {
        String val = ""; //NOI18N
        if (profiles != null) {
            for (String prf : profiles) {
                val = val + prf;
            }
        }
        txtActivate.setText(val);
    }

    public List<String> getProfiles() {
        String val = txtActivate.getText().trim();
        String[] splitted = val.split(" ,"); //NOI18N
        List<String> toRet = new ArrayList<String>();
        for (String s : splitted) {
            if (s.trim().length() > 0) {
                toRet.add(s.trim());
            }
        }
        return toRet;
    }

    void attachDescriptor(DialogDescriptor dd) {
        this.descriptor = dd;
        check();
    }

    private void check() {
        if (descriptor != null) {
            descriptor.setValid(txtId.getText().trim().length() > 0);
        }
    }
    

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        lblId = new javax.swing.JLabel();
        txtId = new javax.swing.JTextField();
        cbShared = new javax.swing.JCheckBox();
        lblActivate = new javax.swing.JLabel();
        lblHint = new javax.swing.JLabel();
        txtActivate = new javax.swing.JTextField();

        lblId.setLabelFor(txtId);
        org.openide.awt.Mnemonics.setLocalizedText(lblId, org.openide.util.NbBundle.getMessage(NewConfigurationPanel.class, "NewConfigurationPanel.lblId.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(cbShared, org.openide.util.NbBundle.getMessage(NewConfigurationPanel.class, "NewConfigurationPanel.cbShared.text")); // NOI18N

        lblActivate.setLabelFor(txtActivate);
        org.openide.awt.Mnemonics.setLocalizedText(lblActivate, org.openide.util.NbBundle.getMessage(NewConfigurationPanel.class, "NewConfigurationPanel.lblActivate.text")); // NOI18N

        lblHint.setText(org.openide.util.NbBundle.getMessage(NewConfigurationPanel.class, "NewConfigurationPanel.lblHint.text")); // NOI18N
        lblHint.setVerticalAlignment(javax.swing.SwingConstants.TOP);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(lblId)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(cbShared)
                            .addComponent(txtId, javax.swing.GroupLayout.DEFAULT_SIZE, 292, Short.MAX_VALUE)))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(lblActivate)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(txtActivate, javax.swing.GroupLayout.DEFAULT_SIZE, 291, Short.MAX_VALUE))
                    .addComponent(lblHint, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 423, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblId)
                    .addComponent(txtId, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(cbShared)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblActivate)
                    .addComponent(txtActivate, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addComponent(lblHint)
                .addContainerGap())
        );

        txtId.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(NewConfigurationPanel.class, "NewConfigurationPanel.txtId.AccessibleContext.accessibleDescription")); // NOI18N
        cbShared.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(NewConfigurationPanel.class, "NewConfigurationPanel.cbShared.AccessibleContext.accessibleDescription")); // NOI18N
        txtActivate.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(NewConfigurationPanel.class, "NewConfigurationPanel.txtActivate.AccessibleContext.accessibleDescription")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox cbShared;
    private javax.swing.JLabel lblActivate;
    private javax.swing.JLabel lblHint;
    private javax.swing.JLabel lblId;
    private javax.swing.JTextField txtActivate;
    private javax.swing.JTextField txtId;
    // End of variables declaration//GEN-END:variables

    public void insertUpdate(DocumentEvent e) {
        check();
    }

    public void removeUpdate(DocumentEvent e) {
        check();
    }

    public void changedUpdate(DocumentEvent e) {
        check();
    }

}
