/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

/*
 * DeviceAnywhereCustomizerPanel.java
 *
 * Created on April 27, 2007, 4:34 PM
 */

package org.netbeans.modules.deployment.deviceanywhere;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JButton;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser.URLDisplayer;
import org.openide.util.NbBundle;

/**
 *
 * @author  suchys
 */
public class DeviceAnywhereGlobalCustomizerPanel extends javax.swing.JPanel {
        
    private boolean underline1 = false;
    private boolean underline2 = false;
    static final Stroke LINK_IN_FOCUS_STROKE = new BasicStroke(1, BasicStroke.CAP_SQUARE,
        BasicStroke.JOIN_BEVEL, 0, new float[] {0, 2}, 0);
    static final Color LINK_IN_FOCUS_COLOR = getColor("LINK_IN_FOCUS"); //NOI18N
    /**
     * Creates new form DeviceAnywhereCustomizerPanel
     */
    DeviceAnywhereGlobalCustomizerPanel() {
        initComponents(); 
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jTextFieldUser = new javax.swing.JTextField();
        jPasswordField = new javax.swing.JPasswordField();
        jTextArea1 = new javax.swing.JTextArea();
        jButton1 = new JButton(){
            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2 = prepareGraphics( g );
                super.paintComponent(g2);

                Dimension size = getSize();
                if( hasFocus() ) {
                    g2.setStroke( LINK_IN_FOCUS_STROKE );
                    g2.setColor( LINK_IN_FOCUS_COLOR );
                    g2.drawRect( 0, 0, size.width - 1, size.height - 1 );
                }
            }

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                if( underline1 ) {
                    Font f = getFont();
                    FontMetrics fm = getFontMetrics(f);
                    int y1 = fm.getHeight();
                    int x2 = fm.stringWidth(getText());
                    if( getText().length() > 0 )
                    g.drawLine(0, y1, x2, y1);
                }
            }
        };
        jButton2 = new JButton(){
            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2 = prepareGraphics( g );
                super.paintComponent(g2);

                Dimension size = getSize();
                if( hasFocus() ) {
                    g2.setStroke( LINK_IN_FOCUS_STROKE );
                    g2.setColor( LINK_IN_FOCUS_COLOR );
                    g2.drawRect( 0, 0, size.width - 1, size.height - 1 );
                }
            }

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                if( underline2 ) {
                    Font f = getFont();
                    FontMetrics fm = getFontMetrics(f);
                    int y1 = fm.getHeight();
                    int x2 = fm.stringWidth(getText());
                    if( getText().length() > 0 )
                    g.drawLine(0, y1, x2, y1);
                }
            }
        };

        jLabel3.setLabelFor(jTextFieldUser);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, org.openide.util.NbBundle.getMessage(DeviceAnywhereGlobalCustomizerPanel.class, "LBL_UserName")); // NOI18N

        jLabel4.setLabelFor(jPasswordField);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel4, org.openide.util.NbBundle.getMessage(DeviceAnywhereGlobalCustomizerPanel.class, "LBL_Password")); // NOI18N

        jTextFieldUser.setName(DeviceAnywhereDeploymentPlugin.PROP_USERID);

        jPasswordField.setName(DeviceAnywhereDeploymentPlugin.PROP_PASSWORD);

        jTextArea1.setBackground(javax.swing.UIManager.getDefaults().getColor("Panel.background"));
        jTextArea1.setEditable(false);
        jTextArea1.setLineWrap(true);
        jTextArea1.setText(org.openide.util.NbBundle.getMessage(DeviceAnywhereGlobalCustomizerPanel.class, "MSG_PassWarning")); // NOI18N
        jTextArea1.setWrapStyleWord(true);

        org.openide.awt.Mnemonics.setLocalizedText(jButton1, org.openide.util.NbBundle.getMessage(DeviceAnywhereGlobalCustomizerPanel.class, "DA_url_text")); // NOI18N
        jButton1.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));
        jButton1.setBorderPainted(false);
        jButton1.setContentAreaFilled(false);
        jButton1.setFocusPainted(false);
        jButton1.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jButton1.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButton1.setCursor( Cursor.getPredefinedCursor(Cursor.HAND_CURSOR) );
        jButton1.setForeground( new Color(0x0E1B55) );
        jButton1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                jButton1MouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                jButton1MouseExited(evt);
            }
        });
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(jButton2, org.openide.util.NbBundle.getMessage(DeviceAnywhereGlobalCustomizerPanel.class, "DA_about_text")); // NOI18N
        jButton2.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));
        jButton2.setBorderPainted(false);
        jButton2.setContentAreaFilled(false);
        jButton2.setFocusPainted(false);
        jButton2.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jButton2.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jButton2.setCursor( Cursor.getPredefinedCursor(Cursor.HAND_CURSOR) );
        jButton2.setForeground( new Color(0x0E1B55) );
        jButton2.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                jButton2MouseEntered(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                jButton2MouseExited(evt);
            }
        });
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(jButton1)
                .addContainerGap())
            .add(layout.createSequentialGroup()
                .add(jButton2)
                .addContainerGap())
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jTextArea1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 517, Short.MAX_VALUE)
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jLabel3)
                            .add(layout.createSequentialGroup()
                                .add(jLabel4, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 93, Short.MAX_VALUE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)))
                        .add(1, 1, 1)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jTextFieldUser, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 423, Short.MAX_VALUE)
                            .add(jPasswordField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 423, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))))
                .add(0, 0, 0))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel3)
                    .add(jTextFieldUser, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 20, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel4)
                    .add(jPasswordField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jButton1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jButton2)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jTextArea1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(0, 0, 0))
        );

        jLabel3.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(DeviceAnywhereGlobalCustomizerPanel.class, "ACSN_UserName")); // NOI18N
        jLabel3.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(DeviceAnywhereGlobalCustomizerPanel.class, "ACSD_UserName")); // NOI18N
        jLabel4.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(DeviceAnywhereGlobalCustomizerPanel.class, "ACSN_Password")); // NOI18N
        jLabel4.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(DeviceAnywhereGlobalCustomizerPanel.class, "ACSD_Password")); // NOI18N
        jTextFieldUser.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(DeviceAnywhereGlobalCustomizerPanel.class, "ACSN_UserName")); // NOI18N
        jTextFieldUser.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(DeviceAnywhereGlobalCustomizerPanel.class, "ACSD_UserName")); // NOI18N
        jPasswordField.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(DeviceAnywhereGlobalCustomizerPanel.class, "ACSD_Password")); // NOI18N
        jPasswordField.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(DeviceAnywhereGlobalCustomizerPanel.class, "ACSD_Password")); // NOI18N
        jTextArea1.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(DeviceAnywhereGlobalCustomizerPanel.class, "ACSN_PassWarning")); // NOI18N
        jTextArea1.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(DeviceAnywhereGlobalCustomizerPanel.class, "ACSD_PassWarning")); // NOI18N
        jButton1.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(DeviceAnywhereGlobalCustomizerPanel.class, "ACSN_Link")); // NOI18N
        jButton1.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(DeviceAnywhereGlobalCustomizerPanel.class, "ACSD_Link")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

    private void jButton1MouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButton1MouseEntered
        underline1 = true;
        setForeground( getColor("RSS_LINK")); //NOI18N
        repaint();
    }//GEN-LAST:event_jButton1MouseEntered

    private void jButton1MouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButton1MouseExited
        underline1 = false;
        setForeground( getColor("HEADER_TEXT")); //NOI18N
        repaint();
    }//GEN-LAST:event_jButton1MouseExited

private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        try {
            URLDisplayer.getDefault().showURL(new URL(org.openide.util.NbBundle.getMessage(DeviceAnywhereGlobalCustomizerPanel.class, "DA_url"))); //NOI18N
        } catch (MalformedURLException ex) {
            //ignore
        }
}//GEN-LAST:event_jButton1ActionPerformed

private void jButton2MouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButton2MouseEntered
        underline2 = true;
        setForeground( getColor("RSS_LINK")); //NOI18N
        repaint();
}//GEN-LAST:event_jButton2MouseEntered

private void jButton2MouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButton2MouseExited
        underline2 = false;
        setForeground( getColor("HEADER_TEXT")); //NOI18N
        repaint();
}//GEN-LAST:event_jButton2MouseExited

private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        try {
            URLDisplayer.getDefault().showURL(new URL(org.openide.util.NbBundle.getMessage(DeviceAnywhereGlobalCustomizerPanel.class, "DA_about"))); //NOI18N
        } catch (MalformedURLException ex) {
            //ignore
        }
}//GEN-LAST:event_jButton2ActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    javax.swing.JLabel jLabel3;
    javax.swing.JLabel jLabel4;
    javax.swing.JPasswordField jPasswordField;
    javax.swing.JTextArea jTextArea1;
    javax.swing.JTextField jTextFieldUser;
    // End of variables declaration//GEN-END:variables
    
    private static Color getColor( String resId ) {
        ResourceBundle bundle = NbBundle.getBundle("org.netbeans.modules.deployment.deviceanywhere.Bundle"); // NOI18N
        try {
            Integer rgb = Integer.decode(bundle.getString(resId));
            return new Color(rgb.intValue());
        } catch( NumberFormatException nfE ) {
            ErrorManager.getDefault().notify( ErrorManager.INFORMATIONAL, nfE );
            return Color.BLACK;
        }
    }

    private static Graphics2D prepareGraphics(Graphics g) {
        Graphics2D g2 = (Graphics2D) g;
        Map rhints = (Map)(Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints")); //NOI18N
        if( rhints == null && Boolean.getBoolean("swing.aatext") ) { //NOI18N
             g2.setRenderingHint( RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON );
        } else if( rhints != null ) {
            g2.addRenderingHints( rhints );
        }
        return g2;
    }
}
