/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.h2.command.ddl.CommandWithColumns;
import org.h2.command.ddl.CreateTableData;
import org.h2.command.dml.Insert;
import org.h2.command.dml.Query;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.ColumnNamer;
import org.h2.value.DataType;

public class CreateTable
extends CommandWithColumns {
    private final CreateTableData data = new CreateTableData();
    private boolean ifNotExists;
    private boolean onCommitDrop;
    private boolean onCommitTruncate;
    private Query asQuery;
    private String comment;
    private boolean sortedInsertMode;

    public CreateTable(Session session, Schema schema) {
        super(session, schema);
        this.data.persistIndexes = true;
        this.data.persistData = true;
    }

    public void setQuery(Query query) {
        this.asQuery = query;
    }

    public void setTemporary(boolean bl) {
        this.data.temporary = bl;
    }

    public void setTableName(String string) {
        this.data.tableName = string;
    }

    @Override
    public void addColumn(Column column) {
        this.data.columns.add(column);
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update() {
        boolean bl;
        Database database;
        if (!this.transactional) {
            this.session.commit(true);
        }
        if (!(database = this.session.getDatabase()).isPersistent()) {
            this.data.persistIndexes = false;
        }
        boolean bl2 = bl = this.data.temporary && !this.data.globalTemporary;
        if (!bl) {
            database.lockMeta(this.session);
        }
        if (this.getSchema().resolveTableOrView(this.session, this.data.tableName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(42101, this.data.tableName);
        }
        if (this.asQuery != null) {
            this.asQuery.prepare();
            if (this.data.columns.isEmpty()) {
                this.generateColumnsFromQuery();
            } else if (this.data.columns.size() != this.asQuery.getColumnCount()) {
                throw DbException.get(21002);
            }
        }
        this.changePrimaryKeysToNotNull(this.data.columns);
        this.data.id = this.getObjectId();
        this.data.create = this.create;
        this.data.session = this.session;
        Table table = this.getSchema().createTable(this.data);
        ArrayList<Sequence> arrayList = this.generateSequences(this.data.columns, this.data.temporary);
        table.setComment(this.comment);
        if (bl) {
            if (this.onCommitDrop) {
                table.setOnCommitDrop(true);
            }
            if (this.onCommitTruncate) {
                table.setOnCommitTruncate(true);
            }
            this.session.addLocalTempTable(table);
        } else {
            database.lockMeta(this.session);
            database.addSchemaObject(this.session, table);
        }
        try {
            for (Column object2 : this.data.columns) {
                object2.prepareExpression(this.session);
            }
            for (Sequence sequence : arrayList) {
                table.addSequence(sequence);
            }
            this.createConstraints();
            if (this.asQuery != null) {
                boolean bl3 = this.session.isUndoLogEnabled();
                try {
                    this.session.setUndoLogEnabled(false);
                    this.session.startStatementWithinTransaction();
                    Insert insert = new Insert(this.session);
                    insert.setSortedInsertMode(this.sortedInsertMode);
                    insert.setQuery(this.asQuery);
                    insert.setTable(table);
                    insert.setInsertFromSelect(true);
                    insert.prepare();
                    insert.update();
                }
                finally {
                    this.session.setUndoLogEnabled(bl3);
                }
            }
            HashSet hashSet = new HashSet();
            hashSet.clear();
            table.addDependencies(hashSet);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                Table table2;
                DbObject dbObject = (DbObject)iterator.next();
                if (dbObject == table || dbObject.getType() != 0 || !(dbObject instanceof Table) || (table2 = (Table)dbObject).getId() <= table.getId()) continue;
                throw DbException.get(50100, "Table depends on another table with a higher ID: " + table2 + ", this is currently not supported, as it would prevent the database from being re-opened");
            }
        }
        catch (DbException dbException) {
            database.checkPowerOff();
            database.removeSchemaObject(this.session, table);
            if (!this.transactional) {
                this.session.commit(true);
            }
            throw dbException;
        }
        return 0;
    }

    private void generateColumnsFromQuery() {
        int n = this.asQuery.getColumnCount();
        ArrayList<Expression> arrayList = this.asQuery.getExpressions();
        ColumnNamer columnNamer = new ColumnNamer(this.session);
        for (int i = 0; i < n; ++i) {
            int n2;
            Expression expression = arrayList.get(i);
            int n3 = expression.getType();
            String string = columnNamer.getColumnName(expression, i, expression.getAlias());
            long l = expression.getPrecision();
            int n4 = expression.getDisplaySize();
            DataType dataType = DataType.getDataType(n3);
            if (l > 0L && (dataType.defaultPrecision == 0L || dataType.defaultPrecision > l && dataType.defaultPrecision < 127L)) {
                l = dataType.defaultPrecision;
            }
            if ((n2 = expression.getScale()) > 0 && (dataType.defaultScale == 0 || dataType.defaultScale > n2 && (long)dataType.defaultScale < l)) {
                n2 = dataType.defaultScale;
            }
            if ((long)n2 > l) {
                l = n2;
            }
            String[] stringArray = null;
            if (dataType.type == 25) {
                if (!(expression instanceof ExpressionColumn)) {
                    throw DbException.get(50000, "Unable to resolve enumerators of expression");
                }
                stringArray = ((ExpressionColumn)expression).getColumn().getEnumerators();
            }
            Column column = new Column(string, n3, l, n2, n4, stringArray);
            this.addColumn(column);
        }
    }

    public void setPersistIndexes(boolean bl) {
        this.data.persistIndexes = bl;
    }

    public void setGlobalTemporary(boolean bl) {
        this.data.globalTemporary = bl;
    }

    public void setOnCommitDrop() {
        this.onCommitDrop = true;
    }

    public void setOnCommitTruncate() {
        this.onCommitTruncate = true;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public void setPersistData(boolean bl) {
        this.data.persistData = bl;
        if (!bl) {
            this.data.persistIndexes = false;
        }
    }

    public void setSortedInsertMode(boolean bl) {
        this.sortedInsertMode = bl;
    }

    public void setTableEngine(String string) {
        this.data.tableEngine = string;
    }

    public void setTableEngineParams(ArrayList<String> arrayList) {
        this.data.tableEngineParams = arrayList;
    }

    public void setHidden(boolean bl) {
        this.data.isHidden = bl;
    }

    @Override
    public int getType() {
        return 30;
    }
}

