/*
 * Decompiled with CFR 0.152.
 */
package gr.zeus.ui.typesafe;

import java.awt.AWTKeyStroke;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTextArea;

public final class SimpleTextAreaTraversal {
    private static final Set<AWTKeyStroke> NEW_FORWARD_TRAVERSAL_KEYS = new HashSet<AWTKeyStroke>();
    private static final Set<AWTKeyStroke> NEW_BACKWARD_TRAVERSAL_KEYS;
    private JTextArea m_textArea = null;
    private Set<AWTKeyStroke> m_oldForwardKeys = null;
    private Set<AWTKeyStroke> m_oldBackwardKeys = null;

    public SimpleTextAreaTraversal(JTextArea ta) {
        this.m_textArea = ta;
        this.m_oldForwardKeys = this.m_textArea.getFocusTraversalKeys(0);
        this.m_oldBackwardKeys = this.m_textArea.getFocusTraversalKeys(1);
    }

    public void changeTraveralKeys() {
        this.m_textArea.setFocusTraversalKeys(0, NEW_FORWARD_TRAVERSAL_KEYS);
        this.m_textArea.setFocusTraversalKeys(1, NEW_BACKWARD_TRAVERSAL_KEYS);
    }

    public void restoreTraveralKeys() {
        this.m_textArea.setFocusTraversalKeys(0, this.m_oldForwardKeys);
        this.m_textArea.setFocusTraversalKeys(1, this.m_oldBackwardKeys);
    }

    static {
        NEW_FORWARD_TRAVERSAL_KEYS.add(AWTKeyStroke.getAWTKeyStroke(9, 0));
        NEW_FORWARD_TRAVERSAL_KEYS.add(AWTKeyStroke.getAWTKeyStroke(9, 128));
        NEW_BACKWARD_TRAVERSAL_KEYS = new HashSet<AWTKeyStroke>();
        NEW_BACKWARD_TRAVERSAL_KEYS.add(AWTKeyStroke.getAWTKeyStroke(9, 64));
        NEW_BACKWARD_TRAVERSAL_KEYS.add(AWTKeyStroke.getAWTKeyStroke(9, 192));
    }
}

