PACKAGE ibusiness_unit.fm_manager IS

   TYPE object IS NEW ibusiness_unit.object WITH PRIVATE;
   TYPE reference IS ACCESS ALL object'class;
   TYPE view IS ACCESS CONSTANT object'class;



   FUNCTION create (tracer_class_name        : IN string := "";
                    tracer_class_description : IN string := "")
                    RETURN ibusiness_unit.reference;


   PROCEDURE initialize (ref                  : IN OUT reference;
                         s_device        : IN string;
                         c_manager        : IN string;
                         d_manager          : IN string;
                         f_manager          : IN string;
                         fz_manager    : IN string;
                         gcc_manager          : IN string;
                         gcu_manager          : IN string;
                         mode_manager         : IN string;
                         rec_manager          : IN string;
                         l_proxy            : IN string;
                         eng_data      : IN string;
                         enable : IN boolean);


   PROCEDURE finalize (ref : IN OUT reference);


   PROCEDURE proceed (ref : IN OUT reference);


   FUNCTION fire (ref : IN reference) RETURN boolean;


   TYPE info IS
      RECORD
         a       : boolean := false;
         b       : boolean := false;
         c : boolean := false;
      END RECORD;

   FUNCTION get_info (ref : IN reference) RETURN info;


PRIVATE
   TYPE private_members;
   TYPE access_private_members IS ACCESS private_members;

   TYPE object IS NEW ibusiness_unit.object WITH
      RECORD
         member : access_private_members := NULL;
      END RECORD;

END ibusiness_unit.fm_manager;

