------------------------------------------------------------------------------
--                                  G P S                                   --
--                                                                          --
--                     Copyright (C) 2011-2014, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Command_Line;      use Ada.Command_Line;
with Ada.Text_IO;           use Ada.Text_IO;
with GNATCOLL.Scripts;          use GNATCOLL.Scripts;
with GNATCOLL.Scripts.Python;   use GNATCOLL.Scripts.Python;
with GNATCOLL.Scripts.Shell;    use GNATCOLL.Scripts.Shell;
with GNATCOLL.Traces;       use GNATCOLL.Traces;
with Testsuite_Export;      use Testsuite_Export;
with TestConsole;           use TestConsole;

procedure Testpython is
   Repo    : Scripts_Repository := new Scripts_Repository_Record;
   Errors  : Boolean;
   Console : aliased Test_Console;
   Python  : Scripting_Language;
begin
   Parse_Config_File;
   Register_Python_Scripting (Repo, "M");
   Register_Standard_Classes (Repo, "Console");

   Python := Lookup_Scripting_Language (Repo, "python");
   Set_Default_Console (Python, Console'Unchecked_Access);

   Execute_File
     (Script       => Python,
      Filename     => "K318_018.py",
      Show_Command => False,
      Errors       => Errors);
   if Errors then
      Put_Line ("Errors were reported by Execute_File");
   end if;

   declare
      C : Callback_Data'Class := Create (Python, 0);
   begin
      Execute_Command (C, "returnString");
      Put_Line ("returnString returned: ");
      Put_Line (Return_Value (C));  --  as string
      Free (C);
   end;

   declare
      C : Callback_Data'Class := Create (Python, 0);
   begin
      Execute_Command (C, "returnIntList");
      Put_Line ("returnIntList returned: ");

      declare
         L : List_Instance'Class := Return_Value (C);
      begin
         for Int in 1 .. Number_Of_Arguments (L) loop
            Put_Line (Integer'Image (Nth_Arg (L, Int)));
         end loop;
      end;
      Free (C);
   end;

   declare
      C : Callback_Data'Class := Create (Python, 0);
   begin
      Execute_Command (C, "returnStrList");
      Put_Line ("returnStrList returned: ");

      declare
         L : List_Instance'Class := Return_Value (C);
      begin
         for Str in 1 .. Number_Of_Arguments (L) loop
            Put_Line (Nth_Arg (L, Str));
         end loop;
      end;
      Free (C);
   end;

   declare
      C : Callback_Data'Class := Create (Python, 0);
      Inst : Class_Instance;
   begin
      Execute_Command (C, "returnNewInstance");
      Put_Line ("returnNewInstance returned: ");
      Inst := Return_Value (C);
      Put_Line ("<an instance>");

      Execute_Command (C, "returnOldInstance");
      Put_Line ("returnOldInstance returned: ");
      Inst := Return_Value (C);
      Put_Line ("<an instance>");

      Free (C);
   end;

   declare
      C : Callback_Data'Class := Create (Python, 0);
      Inst : Class_Instance;
   begin
      Execute_Command (C, "raiseError");
      Put_Line ("raiseError should have returned an error: ");
      Free (C);
   exception
      when Error_In_Command =>
         Put_Line ("raiseError properly raised an exception");
         Free (C);
   end;

   Free (Console);
   Destroy (Repo);
end Testpython;
