/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.rmi.registry;

import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.StubNotFoundException;
import java.rmi.UnknownHostException;
import java.rmi.UnmarshalException;
import java.rmi.activation.ActivateFailedException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.SkeletonMismatchException;
import java.rmi.server.SkeletonNotFoundException;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.ServiceUnavailableException;
import javax.naming.StringRefAddr;
import javax.naming.spi.NamingManager;
import org.apache.harmony.jndi.internal.nls.Messages;
import org.apache.harmony.jndi.provider.rmi.registry.AtomicNameParser;
import org.apache.harmony.jndi.provider.rmi.registry.BindingEnumeration;
import org.apache.harmony.jndi.provider.rmi.registry.NameClassPairEnumeration;
import org.apache.harmony.jndi.provider.rmi.registry.RegistryContextFactory;
import org.apache.harmony.jndi.provider.rmi.registry.RemoteReference;
import org.apache.harmony.jndi.provider.rmi.registry.RemoteReferenceWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryContext
implements Context,
Referenceable {
    public static final String SECURITY_MANAGER = "java.naming.rmi.security.manager";
    public static final String CLIENT_SOCKET_FACTORY = "org.apache.harmony.jndi.provider.rmi.registry.clientSocketFactory";
    public static final String RMI_URL_PREFIX = "rmi:";
    public static final String ADDRESS_TYPE = "URL";
    protected static final NameParser nameParser = new AtomicNameParser();
    protected String host;
    protected int port;
    protected RMIClientSocketFactory csf;
    protected Hashtable<Object, Object> environment;
    protected Registry registry;
    protected Reference reference;

    public RegistryContext(String host, int port, Hashtable<?, ?> environment) throws NamingException {
        String clientSocketFactoryName;
        this.host = host;
        this.port = port;
        Hashtable<Object, Object> hashtable = this.environment = environment != null ? (Hashtable)environment.clone() : new Hashtable();
        if (this.environment.get(SECURITY_MANAGER) != null) {
            this.installSecurityManager();
        }
        if ((clientSocketFactoryName = (String)this.environment.get(CLIENT_SOCKET_FACTORY)) == null) {
            this.csf = null;
        } else {
            try {
                this.csf = (RMIClientSocketFactory)Class.forName(clientSocketFactoryName, true, Thread.currentThread().getContextClassLoader()).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw (ConfigurationException)new ConfigurationException(Messages.getString("jndi.79")).initCause(e);
            }
            catch (InstantiationException e) {
                throw (ConfigurationException)new ConfigurationException(Messages.getString("jndi.79")).initCause(e);
            }
            catch (IllegalAccessException e) {
                throw (NoPermissionException)new NoPermissionException(Messages.getString("jndi.79")).initCause(e);
            }
        }
        this.registry = this.getRegistry(host, port, this.csf);
        this.reference = null;
    }

    protected RegistryContext(RegistryContext context) {
        this.host = context.host;
        this.port = context.port;
        this.csf = context.csf;
        this.environment = (Hashtable)context.environment.clone();
        this.registry = context.registry;
        this.reference = context.reference;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        if (name.isEmpty()) {
            return this.cloneContext();
        }
        String stringName = this.getMyComponents(name);
        try {
            return this.getObjectInstance(stringName, this.registry.lookup(stringName));
        }
        catch (NotBoundException e) {
            throw (NameNotFoundException)new NameNotFoundException(Messages.getString("jndi.7A", stringName)).initCause(e);
        }
        catch (RemoteException e) {
            throw (NamingException)this.newNamingException(e).fillInStackTrace();
        }
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(new CompositeName(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(new CompositeName(name));
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException(Messages.getString("jndi.7B"));
        }
        String stringName = this.getMyComponents(name);
        try {
            this.registry.bind(stringName, this.getStateToBind(stringName, obj));
        }
        catch (AlreadyBoundException e) {
            throw (NameAlreadyBoundException)new NameAlreadyBoundException(Messages.getString("jndi.7C", stringName)).initCause(e);
        }
        catch (RemoteException e) {
            throw (NamingException)this.newNamingException(e).fillInStackTrace();
        }
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(new CompositeName(name), obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException(Messages.getString("jndi.7D"));
        }
        String stringName = this.getMyComponents(name);
        try {
            this.registry.rebind(stringName, this.getStateToBind(stringName, obj));
        }
        catch (RemoteException e) {
            throw (NamingException)this.newNamingException(e).fillInStackTrace();
        }
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(new CompositeName(name), obj);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException(Messages.getString("jndi.7E"));
        }
        String stringName = this.getMyComponents(name);
        try {
            this.registry.unbind(stringName);
        }
        catch (NotBoundException notBoundException) {
        }
        catch (RemoteException e) {
            throw (NamingException)this.newNamingException(e).fillInStackTrace();
        }
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(new CompositeName(name));
    }

    @Override
    public Context createSubcontext(Name name) throws OperationNotSupportedException {
        throw new OperationNotSupportedException(Messages.getString("jndi.7F"));
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(new CompositeName(name));
    }

    @Override
    public void destroySubcontext(Name name) throws OperationNotSupportedException {
        throw new OperationNotSupportedException(Messages.getString("jndi.7F"));
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(new CompositeName(name));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.bind(newName, this.lookup(oldName));
        this.unbind(oldName);
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.rename(new CompositeName(oldName), new CompositeName(newName));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        if (name.isEmpty()) {
            try {
                return new NameClassPairEnumeration(this.registry.list());
            }
            catch (RemoteException e) {
                throw (NamingException)this.newNamingException(e).fillInStackTrace();
            }
        }
        Object obj = this.lookup(name);
        if (obj instanceof Context) {
            try {
                NamingEnumeration<NameClassPair> namingEnumeration = ((Context)obj).list("");
                return namingEnumeration;
            }
            finally {
                ((Context)obj).close();
            }
        }
        throw new NotContextException(Messages.getString("jndi.80", name));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.list(new CompositeName(name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        if (name.isEmpty()) {
            try {
                return new BindingEnumeration(this.registry.list(), this);
            }
            catch (RemoteException e) {
                throw (NamingException)this.newNamingException(e).fillInStackTrace();
            }
        }
        Object obj = this.lookup(name);
        if (obj instanceof Context) {
            try {
                NamingEnumeration<Binding> namingEnumeration = ((Context)obj).listBindings("");
                return namingEnumeration;
            }
            finally {
                ((Context)obj).close();
            }
        }
        throw new NotContextException(Messages.getString("jndi.80", name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.listBindings(new CompositeName(name));
    }

    @Override
    public NameParser getNameParser(Name name) {
        return nameParser;
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.getNameParser(new CompositeName(name));
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return ((Name)prefix.clone()).addAll(name);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(new CompositeName(name), new CompositeName(prefix)).toString();
    }

    @Override
    public String getNameInNamespace() {
        return "";
    }

    @Override
    public Hashtable<?, ?> getEnvironment() {
        return (Hashtable)this.environment.clone();
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NoPermissionException {
        if (propName.equals(SECURITY_MANAGER)) {
            this.installSecurityManager();
        }
        return this.environment.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) {
        return this.environment.remove(propName);
    }

    @Override
    public void close() {
        this.environment = null;
        this.registry = null;
    }

    @Override
    public Reference getReference() throws NamingException {
        if (this.reference == null) {
            if (this.host == null || this.host.equals("localhost")) {
                throw new ConfigurationException(Messages.getString("jndi.81"));
            }
            this.reference = new Reference(RegistryContext.class.getName(), new StringRefAddr(ADDRESS_TYPE, "rmi://" + this.host + (this.port > 0 ? ":" + this.port : "")), RegistryContextFactory.class.getName(), null);
        }
        return (Reference)this.reference.clone();
    }

    protected void setReference(Reference reference) {
        this.reference = reference;
    }

    protected RegistryContext cloneContext() {
        return new RegistryContext(this);
    }

    protected String getMyComponents(Name name) {
        if (name instanceof CompositeName) {
            return name.get(0);
        }
        return name.toString();
    }

    protected Remote getStateToBind(String name, Object obj) throws NamingException, RemoteException {
        if ((obj = NamingManager.getStateToBind(obj, new CompositeName().add(name), this, this.environment)) instanceof Remote) {
            return (Remote)obj;
        }
        if (obj instanceof Reference) {
            return new RemoteReferenceWrapper((Reference)obj);
        }
        if (obj instanceof Referenceable) {
            return new RemoteReferenceWrapper(((Referenceable)obj).getReference());
        }
        throw new IllegalArgumentException(Messages.getString("jndi.82"));
    }

    protected Object getObjectInstance(String name, Remote remote) throws NamingException, RemoteException {
        Remote obj = remote instanceof RemoteReference ? ((RemoteReference)remote).getReference() : remote;
        try {
            return NamingManager.getObjectInstance(obj, new CompositeName().add(name), this, this.environment);
        }
        catch (NamingException e) {
            throw e;
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            throw (NamingException)new NamingException(Messages.getString("jndi.83")).initCause(e);
        }
    }

    protected NamingException newNamingException(Throwable e) {
        NoPermissionException ret;
        NamingException namingException = e instanceof AccessException ? new NoPermissionException() : (e instanceof ConnectException ? new ServiceUnavailableException() : (e instanceof ConnectIOException || e instanceof ExportException || e instanceof MarshalException || e instanceof UnmarshalException ? new CommunicationException() : (e instanceof ActivateFailedException || e instanceof NoSuchObjectException || e instanceof SkeletonMismatchException || e instanceof SkeletonNotFoundException || e instanceof StubNotFoundException || e instanceof UnknownHostException ? new ConfigurationException() : (ret = e instanceof ServerException ? this.newNamingException(e.getCause()) : new NamingException()))));
        if (ret.getCause() == null) {
            ret.initCause(e);
        }
        return ret;
    }

    protected void installSecurityManager() throws NoPermissionException {
        if (!(System.getSecurityManager() instanceof RMISecurityManager)) {
            try {
                System.setSecurityManager(new RMISecurityManager());
            }
            catch (SecurityException e) {
                throw (NoPermissionException)new NoPermissionException(Messages.getString("jndi.84")).initCause(e);
            }
        }
    }

    protected Registry getRegistry(String host, int port, RMIClientSocketFactory csf) throws NamingException {
        try {
            return csf != null ? LocateRegistry.getRegistry(host, port, csf) : (host != null ? (port != 0 ? LocateRegistry.getRegistry(host, port) : LocateRegistry.getRegistry(host)) : (port != 0 ? LocateRegistry.getRegistry(port) : LocateRegistry.getRegistry()));
        }
        catch (RemoteException e) {
            throw (NamingException)new NamingException().initCause(e);
        }
    }
}

