/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FileFinder {
    private static Logger LOGGER = Logger.getLogger((Class)(class$net$sourceforge$cobertura$util$FileFinder == null ? (class$net$sourceforge$cobertura$util$FileFinder = FileFinder.class$("net.sourceforge.cobertura.util.FileFinder")) : class$net$sourceforge$cobertura$util$FileFinder));
    private Set sourceDirectories = new HashSet();
    private Map sourceFilesMap = new HashMap();
    static /* synthetic */ Class class$net$sourceforge$cobertura$util$FileFinder;

    public void addSourceDirectory(String directory) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Adding sourceDirectory=[" + directory + "]"));
        }
        directory = this.getCorrectedPath(directory);
        this.sourceDirectories.add(directory);
    }

    public void addSourceFile(String baseDir, String file) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Adding sourceFile baseDir=[" + baseDir + "] file=[" + file + "]"));
        }
        if (baseDir == null || file == null) {
            throw new NullPointerException();
        }
        file = this.getCorrectedPath(file);
        HashSet<String> container = (HashSet<String>)this.sourceFilesMap.get(baseDir = this.getCorrectedPath(baseDir));
        if (container == null) {
            container = new HashSet<String>();
            this.sourceFilesMap.put(baseDir, container);
        }
        container.add(file);
    }

    public File getFileForSource(String fileName) throws IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Searching for file, name=[" + fileName + "]"));
        }
        fileName = this.getCorrectedPath(fileName);
        Iterator it = this.sourceDirectories.iterator();
        while (it.hasNext()) {
            String directory = (String)it.next();
            File file = new File(directory, fileName);
            if (!file.isFile()) continue;
            LOGGER.debug((Object)"Found inside sourceDirectories");
            return file;
        }
        Iterator it2 = this.sourceFilesMap.keySet().iterator();
        while (it2.hasNext()) {
            File file;
            String directory = (String)it2.next();
            Set container = (Set)this.sourceFilesMap.get(directory);
            if (!container.contains(fileName) || !(file = new File(directory, fileName)).isFile()) continue;
            LOGGER.debug((Object)"Found inside sourceFilesMap");
            return file;
        }
        LOGGER.debug((Object)"File not found");
        throw new IOException("Cannot find source file, name=[" + fileName + "]");
    }

    public List getSourceDirectoryList() {
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator it = this.sourceDirectories.iterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        Iterator it2 = this.sourceFilesMap.keySet().iterator();
        while (it2.hasNext()) {
            result.add(it2.next());
        }
        return result;
    }

    private String getCorrectedPath(String path) {
        return path.replace('\\', '/');
    }

    public String toString() {
        return "FileFinder, source directories: " + this.getSourceDirectoryList().toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

