
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQTabWidget.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QTabWidget>
#include <QAction>
#include <QActionEvent>
#include <QBackingStore>
#include <QBitmap>
#include <QChildEvent>
#include <QCloseEvent>
#include <QContextMenuEvent>
#include <QCursor>
#include <QDragEnterEvent>
#include <QDragLeaveEvent>
#include <QDragMoveEvent>
#include <QDropEvent>
#include <QEnterEvent>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QFontInfo>
#include <QFontMetrics>
#include <QGraphicsEffect>
#include <QGraphicsProxyWidget>
#include <QHideEvent>
#include <QIcon>
#include <QInputMethodEvent>
#include <QKeyEvent>
#include <QKeySequence>
#include <QLayout>
#include <QLocale>
#include <QMargins>
#include <QMetaMethod>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPaintEvent>
#include <QPainter>
#include <QPalette>
#include <QPixmap>
#include <QPoint>
#include <QPointF>
#include <QRect>
#include <QRegion>
#include <QResizeEvent>
#include <QScreen>
#include <QShowEvent>
#include <QSize>
#include <QSizePolicy>
#include <QStyle>
#include <QStyleOptionTabWidgetFrame>
#include <QTabBar>
#include <QTabletEvent>
#include <QThread>
#include <QTimerEvent>
#include <QWheelEvent>
#include <QWidget>
#include <QWindow>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QTabWidget

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QTabWidget::staticMetaObject);
}


// int QTabWidget::addTab(QWidget *widget, const QString &)


static void _init_f_addTab_3232 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_addTab_3232 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<int > ((int)((QTabWidget *)cls)->addTab (arg1, arg2));
}


// int QTabWidget::addTab(QWidget *widget, const QIcon &icon, const QString &label)


static void _init_f_addTab_4911 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("icon");
  decl->add_arg<const QIcon & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("label");
  decl->add_arg<const QString & > (argspec_2);
  decl->set_return<int > ();
}

static void _call_f_addTab_4911 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  const QIcon &arg2 = gsi::arg_reader<const QIcon & >() (args, heap);
  const QString &arg3 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<int > ((int)((QTabWidget *)cls)->addTab (arg1, arg2, arg3));
}


// void QTabWidget::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget *)cls)->clear ();
}


// QWidget *QTabWidget::cornerWidget(Qt::Corner corner)


static void _init_f_cornerWidget_c1366 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("corner", true, "Qt::TopRightCorner");
  decl->add_arg<const qt_gsi::Converter<Qt::Corner>::target_type & > (argspec_0);
  decl->set_return<QWidget * > ();
}

static void _call_f_cornerWidget_c1366 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::Corner>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::Corner>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::Corner>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::Corner>(heap, Qt::TopRightCorner), heap);
  ret.write<QWidget * > ((QWidget *)((QTabWidget *)cls)->cornerWidget (qt_gsi::QtToCppAdaptor<Qt::Corner>(arg1).cref()));
}


// int QTabWidget::count()


static void _init_f_count_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_count_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTabWidget *)cls)->count ());
}


// int QTabWidget::currentIndex()


static void _init_f_currentIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTabWidget *)cls)->currentIndex ());
}


// QWidget *QTabWidget::currentWidget()


static void _init_f_currentWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_currentWidget_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)((QTabWidget *)cls)->currentWidget ());
}


// bool QTabWidget::documentMode()


static void _init_f_documentMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_documentMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTabWidget *)cls)->documentMode ());
}


// Qt::TextElideMode QTabWidget::elideMode()


static void _init_f_elideMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::TextElideMode>::target_type > ();
}

static void _call_f_elideMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::TextElideMode>::target_type > ((qt_gsi::Converter<Qt::TextElideMode>::target_type)qt_gsi::CppToQtAdaptor<Qt::TextElideMode>(((QTabWidget *)cls)->elideMode ()));
}


// bool QTabWidget::hasHeightForWidth()


static void _init_f_hasHeightForWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasHeightForWidth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTabWidget *)cls)->hasHeightForWidth ());
}


// int QTabWidget::heightForWidth(int width)


static void _init_f_heightForWidth_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_heightForWidth_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<int > ((int)((QTabWidget *)cls)->heightForWidth (arg1));
}


// QSize QTabWidget::iconSize()


static void _init_f_iconSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_iconSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QTabWidget *)cls)->iconSize ());
}


// int QTabWidget::indexOf(const QWidget *widget)


static void _init_f_indexOf_c2010 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<const QWidget * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_indexOf_c2010 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QWidget *arg1 = gsi::arg_reader<const QWidget * >() (args, heap);
  ret.write<int > ((int)((QTabWidget *)cls)->indexOf (arg1));
}


// int QTabWidget::insertTab(int index, QWidget *widget, const QString &)


static void _init_f_insertTab_3891 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("widget");
  decl->add_arg<QWidget * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("arg3");
  decl->add_arg<const QString & > (argspec_2);
  decl->set_return<int > ();
}

static void _call_f_insertTab_3891 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  QWidget *arg2 = gsi::arg_reader<QWidget * >() (args, heap);
  const QString &arg3 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<int > ((int)((QTabWidget *)cls)->insertTab (arg1, arg2, arg3));
}


// int QTabWidget::insertTab(int index, QWidget *widget, const QIcon &icon, const QString &label)


static void _init_f_insertTab_5570 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("widget");
  decl->add_arg<QWidget * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("icon");
  decl->add_arg<const QIcon & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("label");
  decl->add_arg<const QString & > (argspec_3);
  decl->set_return<int > ();
}

static void _call_f_insertTab_5570 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  QWidget *arg2 = gsi::arg_reader<QWidget * >() (args, heap);
  const QIcon &arg3 = gsi::arg_reader<const QIcon & >() (args, heap);
  const QString &arg4 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<int > ((int)((QTabWidget *)cls)->insertTab (arg1, arg2, arg3, arg4));
}


// bool QTabWidget::isMovable()


static void _init_f_isMovable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isMovable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTabWidget *)cls)->isMovable ());
}


// bool QTabWidget::isTabEnabled(int index)


static void _init_f_isTabEnabled_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isTabEnabled_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QTabWidget *)cls)->isTabEnabled (arg1));
}


// bool QTabWidget::isTabVisible(int index)


static void _init_f_isTabVisible_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isTabVisible_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<bool > ((bool)((QTabWidget *)cls)->isTabVisible (arg1));
}


// QSize QTabWidget::minimumSizeHint()


static void _init_f_minimumSizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_minimumSizeHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QTabWidget *)cls)->minimumSizeHint ());
}


// void QTabWidget::removeTab(int index)


static void _init_f_removeTab_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeTab_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget *)cls)->removeTab (arg1);
}


// void QTabWidget::setCornerWidget(QWidget *w, Qt::Corner corner)


static void _init_f_setCornerWidget_2573 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("corner", true, "Qt::TopRightCorner");
  decl->add_arg<const qt_gsi::Converter<Qt::Corner>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setCornerWidget_2573 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  const qt_gsi::Converter<Qt::Corner>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::Corner>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::Corner>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::Corner>(heap, Qt::TopRightCorner), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget *)cls)->setCornerWidget (arg1, qt_gsi::QtToCppAdaptor<Qt::Corner>(arg2).cref());
}


// void QTabWidget::setCurrentIndex(int index)


static void _init_f_setCurrentIndex_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentIndex_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget *)cls)->setCurrentIndex (arg1);
}


// void QTabWidget::setCurrentWidget(QWidget *widget)


static void _init_f_setCurrentWidget_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCurrentWidget_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget *)cls)->setCurrentWidget (arg1);
}


// void QTabWidget::setDocumentMode(bool set)


static void _init_f_setDocumentMode_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("set");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDocumentMode_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget *)cls)->setDocumentMode (arg1);
}


// void QTabWidget::setElideMode(Qt::TextElideMode mode)


static void _init_f_setElideMode_2042 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::TextElideMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setElideMode_2042 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::TextElideMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::TextElideMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget *)cls)->setElideMode (qt_gsi::QtToCppAdaptor<Qt::TextElideMode>(arg1).cref());
}


// void QTabWidget::setIconSize(const QSize &size)


static void _init_f_setIconSize_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIconSize_1805 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget *)cls)->setIconSize (arg1);
}


// void QTabWidget::setMovable(bool movable)


static void _init_f_setMovable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("movable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMovable_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget *)cls)->setMovable (arg1);
}


// void QTabWidget::setTabBarAutoHide(bool enabled)


static void _init_f_setTabBarAutoHide_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTabBarAutoHide_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget *)cls)->setTabBarAutoHide (arg1);
}


// void QTabWidget::setTabEnabled(int index, bool enabled)


static void _init_f_setTabEnabled_1523 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("enabled");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setTabEnabled_1523 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  bool arg2 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget *)cls)->setTabEnabled (arg1, arg2);
}


// void QTabWidget::setTabIcon(int index, const QIcon &icon)


static void _init_f_setTabIcon_2446 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("icon");
  decl->add_arg<const QIcon & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setTabIcon_2446 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QIcon &arg2 = gsi::arg_reader<const QIcon & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget *)cls)->setTabIcon (arg1, arg2);
}


// void QTabWidget::setTabPosition(QTabWidget::TabPosition position)


static void _init_f_setTabPosition_2656 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("position");
  decl->add_arg<const qt_gsi::Converter<QTabWidget::TabPosition>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTabPosition_2656 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QTabWidget::TabPosition>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QTabWidget::TabPosition>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget *)cls)->setTabPosition (qt_gsi::QtToCppAdaptor<QTabWidget::TabPosition>(arg1).cref());
}


// void QTabWidget::setTabShape(QTabWidget::TabShape s)


static void _init_f_setTabShape_2300 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const qt_gsi::Converter<QTabWidget::TabShape>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTabShape_2300 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QTabWidget::TabShape>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QTabWidget::TabShape>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget *)cls)->setTabShape (qt_gsi::QtToCppAdaptor<QTabWidget::TabShape>(arg1).cref());
}


// void QTabWidget::setTabText(int index, const QString &text)


static void _init_f_setTabText_2684 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setTabText_2684 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget *)cls)->setTabText (arg1, arg2);
}


// void QTabWidget::setTabToolTip(int index, const QString &tip)


static void _init_f_setTabToolTip_2684 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("tip");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setTabToolTip_2684 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget *)cls)->setTabToolTip (arg1, arg2);
}


// void QTabWidget::setTabVisible(int index, bool visible)


static void _init_f_setTabVisible_1523 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("visible");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setTabVisible_1523 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  bool arg2 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget *)cls)->setTabVisible (arg1, arg2);
}


// void QTabWidget::setTabWhatsThis(int index, const QString &text)


static void _init_f_setTabWhatsThis_2684 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("text");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setTabWhatsThis_2684 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget *)cls)->setTabWhatsThis (arg1, arg2);
}


// void QTabWidget::setTabsClosable(bool closeable)


static void _init_f_setTabsClosable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("closeable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTabsClosable_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget *)cls)->setTabsClosable (arg1);
}


// void QTabWidget::setUsesScrollButtons(bool useButtons)


static void _init_f_setUsesScrollButtons_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("useButtons");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setUsesScrollButtons_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget *)cls)->setUsesScrollButtons (arg1);
}


// QSize QTabWidget::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QTabWidget *)cls)->sizeHint ());
}


// QTabBar *QTabWidget::tabBar()


static void _init_f_tabBar_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTabBar * > ();
}

static void _call_f_tabBar_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTabBar * > ((QTabBar *)((QTabWidget *)cls)->tabBar ());
}


// bool QTabWidget::tabBarAutoHide()


static void _init_f_tabBarAutoHide_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_tabBarAutoHide_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTabWidget *)cls)->tabBarAutoHide ());
}


// QIcon QTabWidget::tabIcon(int index)


static void _init_f_tabIcon_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QIcon > ();
}

static void _call_f_tabIcon_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QIcon > ((QIcon)((QTabWidget *)cls)->tabIcon (arg1));
}


// QTabWidget::TabPosition QTabWidget::tabPosition()


static void _init_f_tabPosition_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTabWidget::TabPosition>::target_type > ();
}

static void _call_f_tabPosition_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QTabWidget::TabPosition>::target_type > ((qt_gsi::Converter<QTabWidget::TabPosition>::target_type)qt_gsi::CppToQtAdaptor<QTabWidget::TabPosition>(((QTabWidget *)cls)->tabPosition ()));
}


// QTabWidget::TabShape QTabWidget::tabShape()


static void _init_f_tabShape_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QTabWidget::TabShape>::target_type > ();
}

static void _call_f_tabShape_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QTabWidget::TabShape>::target_type > ((qt_gsi::Converter<QTabWidget::TabShape>::target_type)qt_gsi::CppToQtAdaptor<QTabWidget::TabShape>(((QTabWidget *)cls)->tabShape ()));
}


// QString QTabWidget::tabText(int index)


static void _init_f_tabText_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_tabText_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)((QTabWidget *)cls)->tabText (arg1));
}


// QString QTabWidget::tabToolTip(int index)


static void _init_f_tabToolTip_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_tabToolTip_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)((QTabWidget *)cls)->tabToolTip (arg1));
}


// QString QTabWidget::tabWhatsThis(int index)


static void _init_f_tabWhatsThis_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_tabWhatsThis_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)((QTabWidget *)cls)->tabWhatsThis (arg1));
}


// bool QTabWidget::tabsClosable()


static void _init_f_tabsClosable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_tabsClosable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTabWidget *)cls)->tabsClosable ());
}


// bool QTabWidget::usesScrollButtons()


static void _init_f_usesScrollButtons_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_usesScrollButtons_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTabWidget *)cls)->usesScrollButtons ());
}


// QWidget *QTabWidget::widget(int index)


static void _init_f_widget_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QWidget * > ();
}

static void _call_f_widget_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QWidget * > ((QWidget *)((QTabWidget *)cls)->widget (arg1));
}


// static QString QTabWidget::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QTabWidget::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QTabWidget () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("addTab", "@brief Method int QTabWidget::addTab(QWidget *widget, const QString &)\n", false, &_init_f_addTab_3232, &_call_f_addTab_3232);
  methods += new qt_gsi::GenericMethod ("addTab", "@brief Method int QTabWidget::addTab(QWidget *widget, const QIcon &icon, const QString &label)\n", false, &_init_f_addTab_4911, &_call_f_addTab_4911);
  methods += new qt_gsi::GenericMethod ("clear", "@brief Method void QTabWidget::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
  methods += new qt_gsi::GenericMethod ("cornerWidget", "@brief Method QWidget *QTabWidget::cornerWidget(Qt::Corner corner)\n", true, &_init_f_cornerWidget_c1366, &_call_f_cornerWidget_c1366);
  methods += new qt_gsi::GenericMethod (":count", "@brief Method int QTabWidget::count()\n", true, &_init_f_count_c0, &_call_f_count_c0);
  methods += new qt_gsi::GenericMethod (":currentIndex", "@brief Method int QTabWidget::currentIndex()\n", true, &_init_f_currentIndex_c0, &_call_f_currentIndex_c0);
  methods += new qt_gsi::GenericMethod (":currentWidget", "@brief Method QWidget *QTabWidget::currentWidget()\n", true, &_init_f_currentWidget_c0, &_call_f_currentWidget_c0);
  methods += new qt_gsi::GenericMethod (":documentMode", "@brief Method bool QTabWidget::documentMode()\n", true, &_init_f_documentMode_c0, &_call_f_documentMode_c0);
  methods += new qt_gsi::GenericMethod (":elideMode", "@brief Method Qt::TextElideMode QTabWidget::elideMode()\n", true, &_init_f_elideMode_c0, &_call_f_elideMode_c0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Method bool QTabWidget::hasHeightForWidth()\nThis is a reimplementation of QWidget::hasHeightForWidth", true, &_init_f_hasHeightForWidth_c0, &_call_f_hasHeightForWidth_c0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Method int QTabWidget::heightForWidth(int width)\nThis is a reimplementation of QWidget::heightForWidth", true, &_init_f_heightForWidth_c767, &_call_f_heightForWidth_c767);
  methods += new qt_gsi::GenericMethod (":iconSize", "@brief Method QSize QTabWidget::iconSize()\n", true, &_init_f_iconSize_c0, &_call_f_iconSize_c0);
  methods += new qt_gsi::GenericMethod ("indexOf", "@brief Method int QTabWidget::indexOf(const QWidget *widget)\n", true, &_init_f_indexOf_c2010, &_call_f_indexOf_c2010);
  methods += new qt_gsi::GenericMethod ("insertTab", "@brief Method int QTabWidget::insertTab(int index, QWidget *widget, const QString &)\n", false, &_init_f_insertTab_3891, &_call_f_insertTab_3891);
  methods += new qt_gsi::GenericMethod ("insertTab", "@brief Method int QTabWidget::insertTab(int index, QWidget *widget, const QIcon &icon, const QString &label)\n", false, &_init_f_insertTab_5570, &_call_f_insertTab_5570);
  methods += new qt_gsi::GenericMethod ("isMovable?|:movable", "@brief Method bool QTabWidget::isMovable()\n", true, &_init_f_isMovable_c0, &_call_f_isMovable_c0);
  methods += new qt_gsi::GenericMethod ("isTabEnabled?", "@brief Method bool QTabWidget::isTabEnabled(int index)\n", true, &_init_f_isTabEnabled_c767, &_call_f_isTabEnabled_c767);
  methods += new qt_gsi::GenericMethod ("isTabVisible?", "@brief Method bool QTabWidget::isTabVisible(int index)\n", true, &_init_f_isTabVisible_c767, &_call_f_isTabVisible_c767);
  methods += new qt_gsi::GenericMethod (":minimumSizeHint", "@brief Method QSize QTabWidget::minimumSizeHint()\nThis is a reimplementation of QWidget::minimumSizeHint", true, &_init_f_minimumSizeHint_c0, &_call_f_minimumSizeHint_c0);
  methods += new qt_gsi::GenericMethod ("removeTab", "@brief Method void QTabWidget::removeTab(int index)\n", false, &_init_f_removeTab_767, &_call_f_removeTab_767);
  methods += new qt_gsi::GenericMethod ("setCornerWidget", "@brief Method void QTabWidget::setCornerWidget(QWidget *w, Qt::Corner corner)\n", false, &_init_f_setCornerWidget_2573, &_call_f_setCornerWidget_2573);
  methods += new qt_gsi::GenericMethod ("setCurrentIndex|currentIndex=", "@brief Method void QTabWidget::setCurrentIndex(int index)\n", false, &_init_f_setCurrentIndex_767, &_call_f_setCurrentIndex_767);
  methods += new qt_gsi::GenericMethod ("setCurrentWidget|currentWidget=", "@brief Method void QTabWidget::setCurrentWidget(QWidget *widget)\n", false, &_init_f_setCurrentWidget_1315, &_call_f_setCurrentWidget_1315);
  methods += new qt_gsi::GenericMethod ("setDocumentMode|documentMode=", "@brief Method void QTabWidget::setDocumentMode(bool set)\n", false, &_init_f_setDocumentMode_864, &_call_f_setDocumentMode_864);
  methods += new qt_gsi::GenericMethod ("setElideMode|elideMode=", "@brief Method void QTabWidget::setElideMode(Qt::TextElideMode mode)\n", false, &_init_f_setElideMode_2042, &_call_f_setElideMode_2042);
  methods += new qt_gsi::GenericMethod ("setIconSize|iconSize=", "@brief Method void QTabWidget::setIconSize(const QSize &size)\n", false, &_init_f_setIconSize_1805, &_call_f_setIconSize_1805);
  methods += new qt_gsi::GenericMethod ("setMovable|movable=", "@brief Method void QTabWidget::setMovable(bool movable)\n", false, &_init_f_setMovable_864, &_call_f_setMovable_864);
  methods += new qt_gsi::GenericMethod ("setTabBarAutoHide|tabBarAutoHide=", "@brief Method void QTabWidget::setTabBarAutoHide(bool enabled)\n", false, &_init_f_setTabBarAutoHide_864, &_call_f_setTabBarAutoHide_864);
  methods += new qt_gsi::GenericMethod ("setTabEnabled", "@brief Method void QTabWidget::setTabEnabled(int index, bool enabled)\n", false, &_init_f_setTabEnabled_1523, &_call_f_setTabEnabled_1523);
  methods += new qt_gsi::GenericMethod ("setTabIcon", "@brief Method void QTabWidget::setTabIcon(int index, const QIcon &icon)\n", false, &_init_f_setTabIcon_2446, &_call_f_setTabIcon_2446);
  methods += new qt_gsi::GenericMethod ("setTabPosition|tabPosition=", "@brief Method void QTabWidget::setTabPosition(QTabWidget::TabPosition position)\n", false, &_init_f_setTabPosition_2656, &_call_f_setTabPosition_2656);
  methods += new qt_gsi::GenericMethod ("setTabShape|tabShape=", "@brief Method void QTabWidget::setTabShape(QTabWidget::TabShape s)\n", false, &_init_f_setTabShape_2300, &_call_f_setTabShape_2300);
  methods += new qt_gsi::GenericMethod ("setTabText", "@brief Method void QTabWidget::setTabText(int index, const QString &text)\n", false, &_init_f_setTabText_2684, &_call_f_setTabText_2684);
  methods += new qt_gsi::GenericMethod ("setTabToolTip", "@brief Method void QTabWidget::setTabToolTip(int index, const QString &tip)\n", false, &_init_f_setTabToolTip_2684, &_call_f_setTabToolTip_2684);
  methods += new qt_gsi::GenericMethod ("setTabVisible", "@brief Method void QTabWidget::setTabVisible(int index, bool visible)\n", false, &_init_f_setTabVisible_1523, &_call_f_setTabVisible_1523);
  methods += new qt_gsi::GenericMethod ("setTabWhatsThis", "@brief Method void QTabWidget::setTabWhatsThis(int index, const QString &text)\n", false, &_init_f_setTabWhatsThis_2684, &_call_f_setTabWhatsThis_2684);
  methods += new qt_gsi::GenericMethod ("setTabsClosable|tabsClosable=", "@brief Method void QTabWidget::setTabsClosable(bool closeable)\n", false, &_init_f_setTabsClosable_864, &_call_f_setTabsClosable_864);
  methods += new qt_gsi::GenericMethod ("setUsesScrollButtons|usesScrollButtons=", "@brief Method void QTabWidget::setUsesScrollButtons(bool useButtons)\n", false, &_init_f_setUsesScrollButtons_864, &_call_f_setUsesScrollButtons_864);
  methods += new qt_gsi::GenericMethod (":sizeHint", "@brief Method QSize QTabWidget::sizeHint()\nThis is a reimplementation of QWidget::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
  methods += new qt_gsi::GenericMethod ("tabBar", "@brief Method QTabBar *QTabWidget::tabBar()\n", true, &_init_f_tabBar_c0, &_call_f_tabBar_c0);
  methods += new qt_gsi::GenericMethod (":tabBarAutoHide", "@brief Method bool QTabWidget::tabBarAutoHide()\n", true, &_init_f_tabBarAutoHide_c0, &_call_f_tabBarAutoHide_c0);
  methods += new qt_gsi::GenericMethod ("tabIcon", "@brief Method QIcon QTabWidget::tabIcon(int index)\n", true, &_init_f_tabIcon_c767, &_call_f_tabIcon_c767);
  methods += new qt_gsi::GenericMethod (":tabPosition", "@brief Method QTabWidget::TabPosition QTabWidget::tabPosition()\n", true, &_init_f_tabPosition_c0, &_call_f_tabPosition_c0);
  methods += new qt_gsi::GenericMethod (":tabShape", "@brief Method QTabWidget::TabShape QTabWidget::tabShape()\n", true, &_init_f_tabShape_c0, &_call_f_tabShape_c0);
  methods += new qt_gsi::GenericMethod ("tabText", "@brief Method QString QTabWidget::tabText(int index)\n", true, &_init_f_tabText_c767, &_call_f_tabText_c767);
  methods += new qt_gsi::GenericMethod ("tabToolTip", "@brief Method QString QTabWidget::tabToolTip(int index)\n", true, &_init_f_tabToolTip_c767, &_call_f_tabToolTip_c767);
  methods += new qt_gsi::GenericMethod ("tabWhatsThis", "@brief Method QString QTabWidget::tabWhatsThis(int index)\n", true, &_init_f_tabWhatsThis_c767, &_call_f_tabWhatsThis_c767);
  methods += new qt_gsi::GenericMethod (":tabsClosable", "@brief Method bool QTabWidget::tabsClosable()\n", true, &_init_f_tabsClosable_c0, &_call_f_tabsClosable_c0);
  methods += new qt_gsi::GenericMethod (":usesScrollButtons", "@brief Method bool QTabWidget::usesScrollButtons()\n", true, &_init_f_usesScrollButtons_c0, &_call_f_usesScrollButtons_c0);
  methods += new qt_gsi::GenericMethod ("widget", "@brief Method QWidget *QTabWidget::widget(int index)\n", true, &_init_f_widget_c767, &_call_f_widget_c767);
  methods += gsi::qt_signal<int > ("currentChanged(int)", "currentChanged", gsi::arg("index"), "@brief Signal declaration for QTabWidget::currentChanged(int index)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QPoint & > ("customContextMenuRequested(const QPoint &)", "customContextMenuRequested", gsi::arg("pos"), "@brief Signal declaration for QTabWidget::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QTabWidget::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QTabWidget::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("tabBarClicked(int)", "tabBarClicked", gsi::arg("index"), "@brief Signal declaration for QTabWidget::tabBarClicked(int index)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("tabBarDoubleClicked(int)", "tabBarDoubleClicked", gsi::arg("index"), "@brief Signal declaration for QTabWidget::tabBarDoubleClicked(int index)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int > ("tabCloseRequested(int)", "tabCloseRequested", gsi::arg("index"), "@brief Signal declaration for QTabWidget::tabCloseRequested(int index)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QIcon & > ("windowIconChanged(const QIcon &)", "windowIconChanged", gsi::arg("icon"), "@brief Signal declaration for QTabWidget::windowIconChanged(const QIcon &icon)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowIconTextChanged(const QString &)", "windowIconTextChanged", gsi::arg("iconText"), "@brief Signal declaration for QTabWidget::windowIconTextChanged(const QString &iconText)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowTitleChanged(const QString &)", "windowTitleChanged", gsi::arg("title"), "@brief Signal declaration for QTabWidget::windowTitleChanged(const QString &title)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QTabWidget::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QWidget> &qtdecl_QWidget ();

qt_gsi::QtNativeClass<QTabWidget> decl_QTabWidget (qtdecl_QWidget (), "QtWidgets", "QTabWidget_Native",
  methods_QTabWidget (),
  "@hide\n@alias QTabWidget");

GSI_QTWIDGETS_PUBLIC gsi::Class<QTabWidget> &qtdecl_QTabWidget () { return decl_QTabWidget; }

}


class QTabWidget_Adaptor : public QTabWidget, public qt_gsi::QtObjectBase
{
public:

  virtual ~QTabWidget_Adaptor();

  //  [adaptor ctor] QTabWidget::QTabWidget(QWidget *parent)
  QTabWidget_Adaptor() : QTabWidget()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QTabWidget::QTabWidget(QWidget *parent)
  QTabWidget_Adaptor(QWidget *parent) : QTabWidget(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QTabWidget::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QTabWidget_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QTabWidget::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  [expose] void QTabWidget::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QTabWidget_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QTabWidget::destroy(destroyWindow, destroySubWindows);
  }

  //  [expose] bool QTabWidget::focusNextChild()
  bool fp_QTabWidget_focusNextChild_0 () {
    return QTabWidget::focusNextChild();
  }

  //  [expose] bool QTabWidget::focusPreviousChild()
  bool fp_QTabWidget_focusPreviousChild_0 () {
    return QTabWidget::focusPreviousChild();
  }

  //  [expose] bool QTabWidget::isSignalConnected(const QMetaMethod &signal)
  bool fp_QTabWidget_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QTabWidget::isSignalConnected(signal);
  }

  //  [expose] int QTabWidget::receivers(const char *signal)
  int fp_QTabWidget_receivers_c1731 (const char *signal) const {
    return QTabWidget::receivers(signal);
  }

  //  [expose] QObject *QTabWidget::sender()
  QObject * fp_QTabWidget_sender_c0 () const {
    return QTabWidget::sender();
  }

  //  [expose] int QTabWidget::senderSignalIndex()
  int fp_QTabWidget_senderSignalIndex_c0 () const {
    return QTabWidget::senderSignalIndex();
  }

  //  [expose] void QTabWidget::setTabBar(QTabBar *)
  void fp_QTabWidget_setTabBar_1259 (QTabBar *arg1) {
    QTabWidget::setTabBar(arg1);
  }

  //  [expose] void QTabWidget::updateMicroFocus(Qt::InputMethodQuery query)
  void fp_QTabWidget_updateMicroFocus_2420 (const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) {
    QTabWidget::updateMicroFocus(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  //  [emitter impl] void QTabWidget::currentChanged(int index)
  void emitter_QTabWidget_currentChanged_767(int index)
  {
    emit QTabWidget::currentChanged(index);
  }

  //  [emitter impl] void QTabWidget::customContextMenuRequested(const QPoint &pos)
  void emitter_QTabWidget_customContextMenuRequested_1916(const QPoint &pos)
  {
    emit QTabWidget::customContextMenuRequested(pos);
  }

  //  [emitter impl] void QTabWidget::destroyed(QObject *)
  void emitter_QTabWidget_destroyed_1302(QObject *arg1)
  {
    emit QTabWidget::destroyed(arg1);
  }

  //  [adaptor impl] bool QTabWidget::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QTabWidget::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QTabWidget_Adaptor, bool, QObject *, QEvent *>(&QTabWidget_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QTabWidget::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] bool QTabWidget::hasHeightForWidth()
  bool cbs_hasHeightForWidth_c0_0() const
  {
    return QTabWidget::hasHeightForWidth();
  }

  virtual bool hasHeightForWidth() const
  {
    if (cb_hasHeightForWidth_c0_0.can_issue()) {
      return cb_hasHeightForWidth_c0_0.issue<QTabWidget_Adaptor, bool>(&QTabWidget_Adaptor::cbs_hasHeightForWidth_c0_0);
    } else {
      return QTabWidget::hasHeightForWidth();
    }
  }

  //  [adaptor impl] int QTabWidget::heightForWidth(int width)
  int cbs_heightForWidth_c767_0(int width) const
  {
    return QTabWidget::heightForWidth(width);
  }

  virtual int heightForWidth(int width) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QTabWidget_Adaptor, int, int>(&QTabWidget_Adaptor::cbs_heightForWidth_c767_0, width);
    } else {
      return QTabWidget::heightForWidth(width);
    }
  }

  //  [adaptor impl] QVariant QTabWidget::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QTabWidget::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QTabWidget_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QTabWidget_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QTabWidget::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QTabWidget::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QTabWidget::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QTabWidget_Adaptor, QSize>(&QTabWidget_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QTabWidget::minimumSizeHint();
    }
  }

  //  [emitter impl] void QTabWidget::objectNameChanged(const QString &objectName)
  void emitter_QTabWidget_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QTabWidget::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] QPaintEngine *QTabWidget::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QTabWidget::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QTabWidget_Adaptor, QPaintEngine *>(&QTabWidget_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QTabWidget::paintEngine();
    }
  }

  //  [adaptor impl] void QTabWidget::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QTabWidget::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QTabWidget_Adaptor, bool>(&QTabWidget_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QTabWidget::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QTabWidget::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QTabWidget::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QTabWidget_Adaptor, QSize>(&QTabWidget_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QTabWidget::sizeHint();
    }
  }

  //  [emitter impl] void QTabWidget::tabBarClicked(int index)
  void emitter_QTabWidget_tabBarClicked_767(int index)
  {
    emit QTabWidget::tabBarClicked(index);
  }

  //  [emitter impl] void QTabWidget::tabBarDoubleClicked(int index)
  void emitter_QTabWidget_tabBarDoubleClicked_767(int index)
  {
    emit QTabWidget::tabBarDoubleClicked(index);
  }

  //  [emitter impl] void QTabWidget::tabCloseRequested(int index)
  void emitter_QTabWidget_tabCloseRequested_767(int index)
  {
    emit QTabWidget::tabCloseRequested(index);
  }

  //  [emitter impl] void QTabWidget::windowIconChanged(const QIcon &icon)
  void emitter_QTabWidget_windowIconChanged_1787(const QIcon &icon)
  {
    emit QTabWidget::windowIconChanged(icon);
  }

  //  [emitter impl] void QTabWidget::windowIconTextChanged(const QString &iconText)
  void emitter_QTabWidget_windowIconTextChanged_2025(const QString &iconText)
  {
    emit QTabWidget::windowIconTextChanged(iconText);
  }

  //  [emitter impl] void QTabWidget::windowTitleChanged(const QString &title)
  void emitter_QTabWidget_windowTitleChanged_2025(const QString &title)
  {
    emit QTabWidget::windowTitleChanged(title);
  }

  //  [adaptor impl] void QTabWidget::actionEvent(QActionEvent *event)
  void cbs_actionEvent_1823_0(QActionEvent *event)
  {
    QTabWidget::actionEvent(event);
  }

  virtual void actionEvent(QActionEvent *event)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QTabWidget_Adaptor, QActionEvent *>(&QTabWidget_Adaptor::cbs_actionEvent_1823_0, event);
    } else {
      QTabWidget::actionEvent(event);
    }
  }

  //  [adaptor impl] void QTabWidget::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QTabWidget::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QTabWidget_Adaptor, QEvent *>(&QTabWidget_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QTabWidget::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QTabWidget::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QTabWidget::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QTabWidget_Adaptor, QChildEvent *>(&QTabWidget_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QTabWidget::childEvent(event);
    }
  }

  //  [adaptor impl] void QTabWidget::closeEvent(QCloseEvent *event)
  void cbs_closeEvent_1719_0(QCloseEvent *event)
  {
    QTabWidget::closeEvent(event);
  }

  virtual void closeEvent(QCloseEvent *event)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QTabWidget_Adaptor, QCloseEvent *>(&QTabWidget_Adaptor::cbs_closeEvent_1719_0, event);
    } else {
      QTabWidget::closeEvent(event);
    }
  }

  //  [adaptor impl] void QTabWidget::contextMenuEvent(QContextMenuEvent *event)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *event)
  {
    QTabWidget::contextMenuEvent(event);
  }

  virtual void contextMenuEvent(QContextMenuEvent *event)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QTabWidget_Adaptor, QContextMenuEvent *>(&QTabWidget_Adaptor::cbs_contextMenuEvent_2363_0, event);
    } else {
      QTabWidget::contextMenuEvent(event);
    }
  }

  //  [adaptor impl] void QTabWidget::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QTabWidget::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QTabWidget_Adaptor, QEvent *>(&QTabWidget_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QTabWidget::customEvent(event);
    }
  }

  //  [adaptor impl] void QTabWidget::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QTabWidget::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QTabWidget_Adaptor, const QMetaMethod &>(&QTabWidget_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QTabWidget::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QTabWidget::dragEnterEvent(QDragEnterEvent *event)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *event)
  {
    QTabWidget::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QDragEnterEvent *event)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QTabWidget_Adaptor, QDragEnterEvent *>(&QTabWidget_Adaptor::cbs_dragEnterEvent_2109_0, event);
    } else {
      QTabWidget::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QTabWidget::dragLeaveEvent(QDragLeaveEvent *event)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *event)
  {
    QTabWidget::dragLeaveEvent(event);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *event)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QTabWidget_Adaptor, QDragLeaveEvent *>(&QTabWidget_Adaptor::cbs_dragLeaveEvent_2092_0, event);
    } else {
      QTabWidget::dragLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QTabWidget::dragMoveEvent(QDragMoveEvent *event)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *event)
  {
    QTabWidget::dragMoveEvent(event);
  }

  virtual void dragMoveEvent(QDragMoveEvent *event)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QTabWidget_Adaptor, QDragMoveEvent *>(&QTabWidget_Adaptor::cbs_dragMoveEvent_2006_0, event);
    } else {
      QTabWidget::dragMoveEvent(event);
    }
  }

  //  [adaptor impl] void QTabWidget::dropEvent(QDropEvent *event)
  void cbs_dropEvent_1622_0(QDropEvent *event)
  {
    QTabWidget::dropEvent(event);
  }

  virtual void dropEvent(QDropEvent *event)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QTabWidget_Adaptor, QDropEvent *>(&QTabWidget_Adaptor::cbs_dropEvent_1622_0, event);
    } else {
      QTabWidget::dropEvent(event);
    }
  }

  //  [adaptor impl] void QTabWidget::enterEvent(QEnterEvent *event)
  void cbs_enterEvent_1727_0(QEnterEvent *event)
  {
    QTabWidget::enterEvent(event);
  }

  virtual void enterEvent(QEnterEvent *event)
  {
    if (cb_enterEvent_1727_0.can_issue()) {
      cb_enterEvent_1727_0.issue<QTabWidget_Adaptor, QEnterEvent *>(&QTabWidget_Adaptor::cbs_enterEvent_1727_0, event);
    } else {
      QTabWidget::enterEvent(event);
    }
  }

  //  [adaptor impl] bool QTabWidget::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QTabWidget::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QTabWidget_Adaptor, bool, QEvent *>(&QTabWidget_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QTabWidget::event(arg1);
    }
  }

  //  [adaptor impl] void QTabWidget::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QTabWidget::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QTabWidget_Adaptor, QFocusEvent *>(&QTabWidget_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QTabWidget::focusInEvent(event);
    }
  }

  //  [adaptor impl] bool QTabWidget::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QTabWidget::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QTabWidget_Adaptor, bool, bool>(&QTabWidget_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QTabWidget::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QTabWidget::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QTabWidget::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QTabWidget_Adaptor, QFocusEvent *>(&QTabWidget_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QTabWidget::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QTabWidget::hideEvent(QHideEvent *event)
  void cbs_hideEvent_1595_0(QHideEvent *event)
  {
    QTabWidget::hideEvent(event);
  }

  virtual void hideEvent(QHideEvent *event)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QTabWidget_Adaptor, QHideEvent *>(&QTabWidget_Adaptor::cbs_hideEvent_1595_0, event);
    } else {
      QTabWidget::hideEvent(event);
    }
  }

  //  [adaptor impl] void QTabWidget::initPainter(QPainter *painter)
  void cbs_initPainter_c1426_0(QPainter *painter) const
  {
    QTabWidget::initPainter(painter);
  }

  virtual void initPainter(QPainter *painter) const
  {
    if (cb_initPainter_c1426_0.can_issue()) {
      cb_initPainter_c1426_0.issue<QTabWidget_Adaptor, QPainter *>(&QTabWidget_Adaptor::cbs_initPainter_c1426_0, painter);
    } else {
      QTabWidget::initPainter(painter);
    }
  }

  //  [adaptor impl] void QTabWidget::initStyleOption(QStyleOptionTabWidgetFrame *option)
  void cbs_initStyleOption_c3247_0(QStyleOptionTabWidgetFrame *option) const
  {
    QTabWidget::initStyleOption(option);
  }

  virtual void initStyleOption(QStyleOptionTabWidgetFrame *option) const
  {
    if (cb_initStyleOption_c3247_0.can_issue()) {
      cb_initStyleOption_c3247_0.issue<QTabWidget_Adaptor, QStyleOptionTabWidgetFrame *>(&QTabWidget_Adaptor::cbs_initStyleOption_c3247_0, option);
    } else {
      QTabWidget::initStyleOption(option);
    }
  }

  //  [adaptor impl] void QTabWidget::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QTabWidget::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QTabWidget_Adaptor, QInputMethodEvent *>(&QTabWidget_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QTabWidget::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QTabWidget::keyPressEvent(QKeyEvent *)
  void cbs_keyPressEvent_1514_0(QKeyEvent *arg1)
  {
    QTabWidget::keyPressEvent(arg1);
  }

  virtual void keyPressEvent(QKeyEvent *arg1)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QTabWidget_Adaptor, QKeyEvent *>(&QTabWidget_Adaptor::cbs_keyPressEvent_1514_0, arg1);
    } else {
      QTabWidget::keyPressEvent(arg1);
    }
  }

  //  [adaptor impl] void QTabWidget::keyReleaseEvent(QKeyEvent *event)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *event)
  {
    QTabWidget::keyReleaseEvent(event);
  }

  virtual void keyReleaseEvent(QKeyEvent *event)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QTabWidget_Adaptor, QKeyEvent *>(&QTabWidget_Adaptor::cbs_keyReleaseEvent_1514_0, event);
    } else {
      QTabWidget::keyReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QTabWidget::leaveEvent(QEvent *event)
  void cbs_leaveEvent_1217_0(QEvent *event)
  {
    QTabWidget::leaveEvent(event);
  }

  virtual void leaveEvent(QEvent *event)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QTabWidget_Adaptor, QEvent *>(&QTabWidget_Adaptor::cbs_leaveEvent_1217_0, event);
    } else {
      QTabWidget::leaveEvent(event);
    }
  }

  //  [adaptor impl] int QTabWidget::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QTabWidget::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QTabWidget_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QTabWidget_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QTabWidget::metric(arg1);
    }
  }

  //  [adaptor impl] void QTabWidget::mouseDoubleClickEvent(QMouseEvent *event)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *event)
  {
    QTabWidget::mouseDoubleClickEvent(event);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *event)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QTabWidget_Adaptor, QMouseEvent *>(&QTabWidget_Adaptor::cbs_mouseDoubleClickEvent_1738_0, event);
    } else {
      QTabWidget::mouseDoubleClickEvent(event);
    }
  }

  //  [adaptor impl] void QTabWidget::mouseMoveEvent(QMouseEvent *event)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *event)
  {
    QTabWidget::mouseMoveEvent(event);
  }

  virtual void mouseMoveEvent(QMouseEvent *event)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QTabWidget_Adaptor, QMouseEvent *>(&QTabWidget_Adaptor::cbs_mouseMoveEvent_1738_0, event);
    } else {
      QTabWidget::mouseMoveEvent(event);
    }
  }

  //  [adaptor impl] void QTabWidget::mousePressEvent(QMouseEvent *event)
  void cbs_mousePressEvent_1738_0(QMouseEvent *event)
  {
    QTabWidget::mousePressEvent(event);
  }

  virtual void mousePressEvent(QMouseEvent *event)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QTabWidget_Adaptor, QMouseEvent *>(&QTabWidget_Adaptor::cbs_mousePressEvent_1738_0, event);
    } else {
      QTabWidget::mousePressEvent(event);
    }
  }

  //  [adaptor impl] void QTabWidget::mouseReleaseEvent(QMouseEvent *event)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *event)
  {
    QTabWidget::mouseReleaseEvent(event);
  }

  virtual void mouseReleaseEvent(QMouseEvent *event)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QTabWidget_Adaptor, QMouseEvent *>(&QTabWidget_Adaptor::cbs_mouseReleaseEvent_1738_0, event);
    } else {
      QTabWidget::mouseReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QTabWidget::moveEvent(QMoveEvent *event)
  void cbs_moveEvent_1624_0(QMoveEvent *event)
  {
    QTabWidget::moveEvent(event);
  }

  virtual void moveEvent(QMoveEvent *event)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QTabWidget_Adaptor, QMoveEvent *>(&QTabWidget_Adaptor::cbs_moveEvent_1624_0, event);
    } else {
      QTabWidget::moveEvent(event);
    }
  }

  //  [adaptor impl] bool QTabWidget::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  bool cbs_nativeEvent_6949_0(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  {
    return QTabWidget::nativeEvent(eventType, message, result);
  }

  virtual bool nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)
  {
    if (cb_nativeEvent_6949_0.can_issue()) {
      return cb_nativeEvent_6949_0.issue<QTabWidget_Adaptor, bool, const QByteArray &, void *, QIntegerForSizeof<void *>::Signed *>(&QTabWidget_Adaptor::cbs_nativeEvent_6949_0, eventType, message, result);
    } else {
      return QTabWidget::nativeEvent(eventType, message, result);
    }
  }

  //  [adaptor impl] void QTabWidget::paintEvent(QPaintEvent *)
  void cbs_paintEvent_1725_0(QPaintEvent *arg1)
  {
    QTabWidget::paintEvent(arg1);
  }

  virtual void paintEvent(QPaintEvent *arg1)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QTabWidget_Adaptor, QPaintEvent *>(&QTabWidget_Adaptor::cbs_paintEvent_1725_0, arg1);
    } else {
      QTabWidget::paintEvent(arg1);
    }
  }

  //  [adaptor impl] QPaintDevice *QTabWidget::redirected(QPoint *offset)
  QPaintDevice * cbs_redirected_c1225_0(QPoint *offset) const
  {
    return QTabWidget::redirected(offset);
  }

  virtual QPaintDevice * redirected(QPoint *offset) const
  {
    if (cb_redirected_c1225_0.can_issue()) {
      return cb_redirected_c1225_0.issue<QTabWidget_Adaptor, QPaintDevice *, QPoint *>(&QTabWidget_Adaptor::cbs_redirected_c1225_0, offset);
    } else {
      return QTabWidget::redirected(offset);
    }
  }

  //  [adaptor impl] void QTabWidget::resizeEvent(QResizeEvent *)
  void cbs_resizeEvent_1843_0(QResizeEvent *arg1)
  {
    QTabWidget::resizeEvent(arg1);
  }

  virtual void resizeEvent(QResizeEvent *arg1)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QTabWidget_Adaptor, QResizeEvent *>(&QTabWidget_Adaptor::cbs_resizeEvent_1843_0, arg1);
    } else {
      QTabWidget::resizeEvent(arg1);
    }
  }

  //  [adaptor impl] QPainter *QTabWidget::sharedPainter()
  QPainter * cbs_sharedPainter_c0_0() const
  {
    return QTabWidget::sharedPainter();
  }

  virtual QPainter * sharedPainter() const
  {
    if (cb_sharedPainter_c0_0.can_issue()) {
      return cb_sharedPainter_c0_0.issue<QTabWidget_Adaptor, QPainter *>(&QTabWidget_Adaptor::cbs_sharedPainter_c0_0);
    } else {
      return QTabWidget::sharedPainter();
    }
  }

  //  [adaptor impl] void QTabWidget::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QTabWidget::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QTabWidget_Adaptor, QShowEvent *>(&QTabWidget_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QTabWidget::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QTabWidget::tabInserted(int index)
  void cbs_tabInserted_767_0(int index)
  {
    QTabWidget::tabInserted(index);
  }

  virtual void tabInserted(int index)
  {
    if (cb_tabInserted_767_0.can_issue()) {
      cb_tabInserted_767_0.issue<QTabWidget_Adaptor, int>(&QTabWidget_Adaptor::cbs_tabInserted_767_0, index);
    } else {
      QTabWidget::tabInserted(index);
    }
  }

  //  [adaptor impl] void QTabWidget::tabRemoved(int index)
  void cbs_tabRemoved_767_0(int index)
  {
    QTabWidget::tabRemoved(index);
  }

  virtual void tabRemoved(int index)
  {
    if (cb_tabRemoved_767_0.can_issue()) {
      cb_tabRemoved_767_0.issue<QTabWidget_Adaptor, int>(&QTabWidget_Adaptor::cbs_tabRemoved_767_0, index);
    } else {
      QTabWidget::tabRemoved(index);
    }
  }

  //  [adaptor impl] void QTabWidget::tabletEvent(QTabletEvent *event)
  void cbs_tabletEvent_1821_0(QTabletEvent *event)
  {
    QTabWidget::tabletEvent(event);
  }

  virtual void tabletEvent(QTabletEvent *event)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QTabWidget_Adaptor, QTabletEvent *>(&QTabWidget_Adaptor::cbs_tabletEvent_1821_0, event);
    } else {
      QTabWidget::tabletEvent(event);
    }
  }

  //  [adaptor impl] void QTabWidget::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QTabWidget::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QTabWidget_Adaptor, QTimerEvent *>(&QTabWidget_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QTabWidget::timerEvent(event);
    }
  }

  //  [adaptor impl] void QTabWidget::wheelEvent(QWheelEvent *event)
  void cbs_wheelEvent_1718_0(QWheelEvent *event)
  {
    QTabWidget::wheelEvent(event);
  }

  virtual void wheelEvent(QWheelEvent *event)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QTabWidget_Adaptor, QWheelEvent *>(&QTabWidget_Adaptor::cbs_wheelEvent_1718_0, event);
    } else {
      QTabWidget::wheelEvent(event);
    }
  }

  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_hasHeightForWidth_c0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enterEvent_1727_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_initPainter_c1426_0;
  gsi::Callback cb_initStyleOption_c3247_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_nativeEvent_6949_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_redirected_c1225_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_sharedPainter_c0_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_tabInserted_767_0;
  gsi::Callback cb_tabRemoved_767_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_1718_0;
};

QTabWidget_Adaptor::~QTabWidget_Adaptor() { }

//  Constructor QTabWidget::QTabWidget(QWidget *parent) (adaptor class)

static void _init_ctor_QTabWidget_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QTabWidget_Adaptor> ();
}

static void _call_ctor_QTabWidget_Adaptor_1315 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  ret.write<QTabWidget_Adaptor *> (new QTabWidget_Adaptor (arg1));
}


// void QTabWidget::actionEvent(QActionEvent *event)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QActionEvent *arg1 = args.read<QActionEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}


// void QTabWidget::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QTabWidget::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QTabWidget::closeEvent(QCloseEvent *event)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// void QTabWidget::contextMenuEvent(QContextMenuEvent *event)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}


// exposed void QTabWidget::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<WId>::target_type & >() (qt_gsi::CppToQtReadAdaptor<WId>(heap, 0), heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg3 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->fp_QTabWidget_create_2208 (arg1, arg2, arg3);
}


// emitter void QTabWidget::currentChanged(int index)

static void _init_emitter_currentChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_currentChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QTabWidget_Adaptor *)cls)->emitter_QTabWidget_currentChanged_767 (arg1);
}


// emitter void QTabWidget::customContextMenuRequested(const QPoint &pos)

static void _init_emitter_customContextMenuRequested_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customContextMenuRequested_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ((QTabWidget_Adaptor *)cls)->emitter_QTabWidget_customContextMenuRequested_1916 (arg1);
}


// void QTabWidget::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// exposed void QTabWidget::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->fp_QTabWidget_destroy_1620 (arg1, arg2);
}


// emitter void QTabWidget::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QTabWidget_Adaptor *)cls)->emitter_QTabWidget_destroyed_1302 (arg1);
}


// void QTabWidget::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// void QTabWidget::dragEnterEvent(QDragEnterEvent *event)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}


// void QTabWidget::dragLeaveEvent(QDragLeaveEvent *event)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}


// void QTabWidget::dragMoveEvent(QDragMoveEvent *event)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}


// void QTabWidget::dropEvent(QDropEvent *event)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDropEvent *arg1 = args.read<QDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}


// void QTabWidget::enterEvent(QEnterEvent *event)

static void _init_cbs_enterEvent_1727_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1727_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEnterEvent *arg1 = args.read<QEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_enterEvent_1727_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1727_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_enterEvent_1727_0 = cb;
}


// bool QTabWidget::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QTabWidget_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QTabWidget::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QTabWidget_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QTabWidget::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// exposed bool QTabWidget::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTabWidget_Adaptor *)cls)->fp_QTabWidget_focusNextChild_0 ());
}


// bool QTabWidget::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QTabWidget_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QTabWidget::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// exposed bool QTabWidget::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTabWidget_Adaptor *)cls)->fp_QTabWidget_focusPreviousChild_0 ());
}


// bool QTabWidget::hasHeightForWidth()

static void _init_cbs_hasHeightForWidth_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasHeightForWidth_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QTabWidget_Adaptor *)cls)->cbs_hasHeightForWidth_c0_0 ());
}

static void _set_callback_cbs_hasHeightForWidth_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_hasHeightForWidth_c0_0 = cb;
}


// int QTabWidget::heightForWidth(int width)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QTabWidget_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// void QTabWidget::hideEvent(QHideEvent *event)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// void QTabWidget::initPainter(QPainter *painter)

static void _init_cbs_initPainter_c1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initPainter_c1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_initPainter_c1426_0 (arg1);
}

static void _set_callback_cbs_initPainter_c1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_initPainter_c1426_0 = cb;
}


// void QTabWidget::initStyleOption(QStyleOptionTabWidgetFrame *option)

static void _init_cbs_initStyleOption_c3247_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<QStyleOptionTabWidgetFrame * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initStyleOption_c3247_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QStyleOptionTabWidgetFrame *arg1 = args.read<QStyleOptionTabWidgetFrame * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_initStyleOption_c3247_0 (arg1);
}

static void _set_callback_cbs_initStyleOption_c3247_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_initStyleOption_c3247_0 = cb;
}


// void QTabWidget::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QTabWidget::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QTabWidget_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// exposed bool QTabWidget::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QTabWidget_Adaptor *)cls)->fp_QTabWidget_isSignalConnected_c2394 (arg1));
}


// void QTabWidget::keyPressEvent(QKeyEvent *)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QTabWidget::keyReleaseEvent(QKeyEvent *event)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QTabWidget::leaveEvent(QEvent *event)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}


// int QTabWidget::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QTabWidget_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QSize QTabWidget::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QTabWidget_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}


// void QTabWidget::mouseDoubleClickEvent(QMouseEvent *event)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QTabWidget::mouseMoveEvent(QMouseEvent *event)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QTabWidget::mousePressEvent(QMouseEvent *event)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QTabWidget::mouseReleaseEvent(QMouseEvent *event)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// void QTabWidget::moveEvent(QMoveEvent *event)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// bool QTabWidget::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)

static void _init_cbs_nativeEvent_6949_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("eventType");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("message");
  decl->add_arg<void * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("result");
  decl->add_arg<QIntegerForSizeof<void *>::Signed * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_nativeEvent_6949_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  void *arg2 = args.read<void * > (heap);
  QIntegerForSizeof<void *>::Signed *arg3 = args.read<QIntegerForSizeof<void *>::Signed * > (heap);
  ret.write<bool > ((bool)((QTabWidget_Adaptor *)cls)->cbs_nativeEvent_6949_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_nativeEvent_6949_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_nativeEvent_6949_0 = cb;
}


// emitter void QTabWidget::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QTabWidget_Adaptor *)cls)->emitter_QTabWidget_objectNameChanged_4567 (arg1);
}


// QPaintEngine *QTabWidget::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QTabWidget_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// void QTabWidget::paintEvent(QPaintEvent *)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// exposed int QTabWidget::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QTabWidget_Adaptor *)cls)->fp_QTabWidget_receivers_c1731 (arg1));
}


// QPaintDevice *QTabWidget::redirected(QPoint *offset)

static void _init_cbs_redirected_c1225_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<QPoint * > (argspec_0);
  decl->set_return<QPaintDevice * > ();
}

static void _call_cbs_redirected_c1225_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPoint *arg1 = args.read<QPoint * > (heap);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QTabWidget_Adaptor *)cls)->cbs_redirected_c1225_0 (arg1));
}

static void _set_callback_cbs_redirected_c1225_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_redirected_c1225_0 = cb;
}


// void QTabWidget::resizeEvent(QResizeEvent *)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// exposed QObject *QTabWidget::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QTabWidget_Adaptor *)cls)->fp_QTabWidget_sender_c0 ());
}


// exposed int QTabWidget::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QTabWidget_Adaptor *)cls)->fp_QTabWidget_senderSignalIndex_c0 ());
}


// exposed void QTabWidget::setTabBar(QTabBar *)

static void _init_fp_setTabBar_1259 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabBar * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setTabBar_1259 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabBar *arg1 = gsi::arg_reader<QTabBar * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->fp_QTabWidget_setTabBar_1259 (arg1);
}


// void QTabWidget::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}


// QPainter *QTabWidget::sharedPainter()

static void _init_cbs_sharedPainter_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainter * > ();
}

static void _call_cbs_sharedPainter_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainter * > ((QPainter *)((QTabWidget_Adaptor *)cls)->cbs_sharedPainter_c0_0 ());
}

static void _set_callback_cbs_sharedPainter_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_sharedPainter_c0_0 = cb;
}


// void QTabWidget::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QTabWidget::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QTabWidget_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// emitter void QTabWidget::tabBarClicked(int index)

static void _init_emitter_tabBarClicked_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_tabBarClicked_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QTabWidget_Adaptor *)cls)->emitter_QTabWidget_tabBarClicked_767 (arg1);
}


// emitter void QTabWidget::tabBarDoubleClicked(int index)

static void _init_emitter_tabBarDoubleClicked_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_tabBarDoubleClicked_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QTabWidget_Adaptor *)cls)->emitter_QTabWidget_tabBarDoubleClicked_767 (arg1);
}


// emitter void QTabWidget::tabCloseRequested(int index)

static void _init_emitter_tabCloseRequested_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_tabCloseRequested_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QTabWidget_Adaptor *)cls)->emitter_QTabWidget_tabCloseRequested_767 (arg1);
}


// void QTabWidget::tabInserted(int index)

static void _init_cbs_tabInserted_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabInserted_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_tabInserted_767_0 (arg1);
}

static void _set_callback_cbs_tabInserted_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_tabInserted_767_0 = cb;
}


// void QTabWidget::tabRemoved(int index)

static void _init_cbs_tabRemoved_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabRemoved_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_tabRemoved_767_0 (arg1);
}

static void _set_callback_cbs_tabRemoved_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_tabRemoved_767_0 = cb;
}


// void QTabWidget::tabletEvent(QTabletEvent *event)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// void QTabWidget::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// exposed void QTabWidget::updateMicroFocus(Qt::InputMethodQuery query)

static void _init_fp_updateMicroFocus_2420 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query", true, "Qt::ImQueryAll");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_2420 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::InputMethodQuery>(heap, Qt::ImQueryAll), heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->fp_QTabWidget_updateMicroFocus_2420 (arg1);
}


// void QTabWidget::wheelEvent(QWheelEvent *event)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QTabWidget_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QTabWidget_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// emitter void QTabWidget::windowIconChanged(const QIcon &icon)

static void _init_emitter_windowIconChanged_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconChanged_1787 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = gsi::arg_reader<const QIcon & >() (args, heap);
  ((QTabWidget_Adaptor *)cls)->emitter_QTabWidget_windowIconChanged_1787 (arg1);
}


// emitter void QTabWidget::windowIconTextChanged(const QString &iconText)

static void _init_emitter_windowIconTextChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iconText");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconTextChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QTabWidget_Adaptor *)cls)->emitter_QTabWidget_windowIconTextChanged_2025 (arg1);
}


// emitter void QTabWidget::windowTitleChanged(const QString &title)

static void _init_emitter_windowTitleChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowTitleChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QTabWidget_Adaptor *)cls)->emitter_QTabWidget_windowTitleChanged_2025 (arg1);
}


namespace gsi
{

gsi::Class<QTabWidget> &qtdecl_QTabWidget ();

static gsi::Methods methods_QTabWidget_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QTabWidget::QTabWidget(QWidget *parent)\nThis method creates an object of class QTabWidget.", &_init_ctor_QTabWidget_Adaptor_1315, &_call_ctor_QTabWidget_Adaptor_1315);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QTabWidget::actionEvent(QActionEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QTabWidget::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QTabWidget::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QTabWidget::closeEvent(QCloseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QTabWidget::contextMenuEvent(QContextMenuEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*create|qt_create", "@brief Method void QTabWidget::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
  methods += new qt_gsi::GenericMethod ("emit_currentChanged", "@brief Emitter for signal void QTabWidget::currentChanged(int index)\nCall this method to emit this signal.", false, &_init_emitter_currentChanged_767, &_call_emitter_currentChanged_767);
  methods += new qt_gsi::GenericMethod ("emit_customContextMenuRequested", "@brief Emitter for signal void QTabWidget::customContextMenuRequested(const QPoint &pos)\nCall this method to emit this signal.", false, &_init_emitter_customContextMenuRequested_1916, &_call_emitter_customContextMenuRequested_1916);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QTabWidget::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*destroy|qt_destroy", "@brief Method void QTabWidget::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QTabWidget::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QTabWidget::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QTabWidget::dragEnterEvent(QDragEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QTabWidget::dragLeaveEvent(QDragLeaveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QTabWidget::dragMoveEvent(QDragMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QTabWidget::dropEvent(QDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QTabWidget::enterEvent(QEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1727_0, &_call_cbs_enterEvent_1727_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1727_0, &_call_cbs_enterEvent_1727_0, &_set_callback_cbs_enterEvent_1727_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QTabWidget::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QTabWidget::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QTabWidget::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextChild", "@brief Method bool QTabWidget::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QTabWidget::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QTabWidget::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusPreviousChild", "@brief Method bool QTabWidget::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Virtual method bool QTabWidget::hasHeightForWidth()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@hide", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0, &_set_callback_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QTabWidget::heightForWidth(int width)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QTabWidget::hideEvent(QHideEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@brief Virtual method void QTabWidget::initPainter(QPainter *painter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@hide", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0, &_set_callback_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initStyleOption", "@brief Virtual method void QTabWidget::initStyleOption(QStyleOptionTabWidgetFrame *option)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initStyleOption_c3247_0, &_call_cbs_initStyleOption_c3247_0);
  methods += new qt_gsi::GenericMethod ("*initStyleOption", "@hide", true, &_init_cbs_initStyleOption_c3247_0, &_call_cbs_initStyleOption_c3247_0, &_set_callback_cbs_initStyleOption_c3247_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QTabWidget::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QTabWidget::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QTabWidget::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QTabWidget::keyPressEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QTabWidget::keyReleaseEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QTabWidget::leaveEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QTabWidget::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QTabWidget::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QTabWidget::mouseDoubleClickEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QTabWidget::mouseMoveEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QTabWidget::mousePressEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QTabWidget::mouseReleaseEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QTabWidget::moveEvent(QMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@brief Virtual method bool QTabWidget::nativeEvent(const QByteArray &eventType, void *message, QIntegerForSizeof<void *>::Signed *result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_nativeEvent_6949_0, &_call_cbs_nativeEvent_6949_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@hide", false, &_init_cbs_nativeEvent_6949_0, &_call_cbs_nativeEvent_6949_0, &_set_callback_cbs_nativeEvent_6949_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QTabWidget::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QTabWidget::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QTabWidget::paintEvent(QPaintEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QTabWidget::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*redirected", "@brief Virtual method QPaintDevice *QTabWidget::redirected(QPoint *offset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*redirected", "@hide", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0, &_set_callback_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QTabWidget::resizeEvent(QResizeEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QTabWidget::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QTabWidget::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*setTabBar", "@brief Method void QTabWidget::setTabBar(QTabBar *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setTabBar_1259, &_call_fp_setTabBar_1259);
  methods += new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QTabWidget::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@brief Virtual method QPainter *QTabWidget::sharedPainter()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@hide", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0, &_set_callback_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QTabWidget::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QTabWidget::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_tabBarClicked", "@brief Emitter for signal void QTabWidget::tabBarClicked(int index)\nCall this method to emit this signal.", false, &_init_emitter_tabBarClicked_767, &_call_emitter_tabBarClicked_767);
  methods += new qt_gsi::GenericMethod ("emit_tabBarDoubleClicked", "@brief Emitter for signal void QTabWidget::tabBarDoubleClicked(int index)\nCall this method to emit this signal.", false, &_init_emitter_tabBarDoubleClicked_767, &_call_emitter_tabBarDoubleClicked_767);
  methods += new qt_gsi::GenericMethod ("emit_tabCloseRequested", "@brief Emitter for signal void QTabWidget::tabCloseRequested(int index)\nCall this method to emit this signal.", false, &_init_emitter_tabCloseRequested_767, &_call_emitter_tabCloseRequested_767);
  methods += new qt_gsi::GenericMethod ("*tabInserted", "@brief Virtual method void QTabWidget::tabInserted(int index)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabInserted_767_0, &_call_cbs_tabInserted_767_0);
  methods += new qt_gsi::GenericMethod ("*tabInserted", "@hide", false, &_init_cbs_tabInserted_767_0, &_call_cbs_tabInserted_767_0, &_set_callback_cbs_tabInserted_767_0);
  methods += new qt_gsi::GenericMethod ("*tabRemoved", "@brief Virtual method void QTabWidget::tabRemoved(int index)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabRemoved_767_0, &_call_cbs_tabRemoved_767_0);
  methods += new qt_gsi::GenericMethod ("*tabRemoved", "@hide", false, &_init_cbs_tabRemoved_767_0, &_call_cbs_tabRemoved_767_0, &_set_callback_cbs_tabRemoved_767_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QTabWidget::tabletEvent(QTabletEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QTabWidget::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QTabWidget::updateMicroFocus(Qt::InputMethodQuery query)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_2420, &_call_fp_updateMicroFocus_2420);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QTabWidget::wheelEvent(QWheelEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("emit_windowIconChanged", "@brief Emitter for signal void QTabWidget::windowIconChanged(const QIcon &icon)\nCall this method to emit this signal.", false, &_init_emitter_windowIconChanged_1787, &_call_emitter_windowIconChanged_1787);
  methods += new qt_gsi::GenericMethod ("emit_windowIconTextChanged", "@brief Emitter for signal void QTabWidget::windowIconTextChanged(const QString &iconText)\nCall this method to emit this signal.", false, &_init_emitter_windowIconTextChanged_2025, &_call_emitter_windowIconTextChanged_2025);
  methods += new qt_gsi::GenericMethod ("emit_windowTitleChanged", "@brief Emitter for signal void QTabWidget::windowTitleChanged(const QString &title)\nCall this method to emit this signal.", false, &_init_emitter_windowTitleChanged_2025, &_call_emitter_windowTitleChanged_2025);
  return methods;
}

gsi::Class<QTabWidget_Adaptor> decl_QTabWidget_Adaptor (qtdecl_QTabWidget (), "QtWidgets", "QTabWidget",
  methods_QTabWidget_Adaptor (),
  "@qt\n@brief Binding of QTabWidget");

}


//  Implementation of the enum wrapper class for QTabWidget::TabPosition
namespace qt_gsi
{

static gsi::Enum<QTabWidget::TabPosition> decl_QTabWidget_TabPosition_Enum ("QtWidgets", "QTabWidget_TabPosition",
    gsi::enum_const ("North", QTabWidget::North, "@brief Enum constant QTabWidget::North") +
    gsi::enum_const ("South", QTabWidget::South, "@brief Enum constant QTabWidget::South") +
    gsi::enum_const ("West", QTabWidget::West, "@brief Enum constant QTabWidget::West") +
    gsi::enum_const ("East", QTabWidget::East, "@brief Enum constant QTabWidget::East"),
  "@qt\n@brief This class represents the QTabWidget::TabPosition enum");

static gsi::QFlagsClass<QTabWidget::TabPosition > decl_QTabWidget_TabPosition_Enums ("QtWidgets", "QTabWidget_QFlags_TabPosition",
  "@qt\n@brief This class represents the QFlags<QTabWidget::TabPosition> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QTabWidget> inject_QTabWidget_TabPosition_Enum_in_parent (decl_QTabWidget_TabPosition_Enum.defs ());
static gsi::ClassExt<QTabWidget> decl_QTabWidget_TabPosition_Enum_as_child (decl_QTabWidget_TabPosition_Enum, "TabPosition");
static gsi::ClassExt<QTabWidget> decl_QTabWidget_TabPosition_Enums_as_child (decl_QTabWidget_TabPosition_Enums, "QFlags_TabPosition");

}


//  Implementation of the enum wrapper class for QTabWidget::TabShape
namespace qt_gsi
{

static gsi::Enum<QTabWidget::TabShape> decl_QTabWidget_TabShape_Enum ("QtWidgets", "QTabWidget_TabShape",
    gsi::enum_const ("Rounded", QTabWidget::Rounded, "@brief Enum constant QTabWidget::Rounded") +
    gsi::enum_const ("Triangular", QTabWidget::Triangular, "@brief Enum constant QTabWidget::Triangular"),
  "@qt\n@brief This class represents the QTabWidget::TabShape enum");

static gsi::QFlagsClass<QTabWidget::TabShape > decl_QTabWidget_TabShape_Enums ("QtWidgets", "QTabWidget_QFlags_TabShape",
  "@qt\n@brief This class represents the QFlags<QTabWidget::TabShape> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QTabWidget> inject_QTabWidget_TabShape_Enum_in_parent (decl_QTabWidget_TabShape_Enum.defs ());
static gsi::ClassExt<QTabWidget> decl_QTabWidget_TabShape_Enum_as_child (decl_QTabWidget_TabShape_Enum, "TabShape");
static gsi::ClassExt<QTabWidget> decl_QTabWidget_TabShape_Enums_as_child (decl_QTabWidget_TabShape_Enums, "QFlags_TabShape");

}

