/* The following code was generated by JFlex 1.7.0-SNAPSHOT tweaked for IntelliJ platform */

 /* It's an automatically generated code. Do not modify it. */
package com.intellij.lexer;

import com.intellij.psi.tree.IElementType;
import com.intellij.psi.*;
import com.intellij.psi.xml.*;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.7.0-SNAPSHOT
 * from the specification file <tt>_XmlLexer.flex</tt>
 */
public class __XmlLexer implements FlexLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int TAG = 2;
  public static final int PROCESSING_INSTRUCTION = 4;
  public static final int PI_ANY = 6;
  public static final int END_TAG = 8;
  public static final int COMMENT = 10;
  public static final int ATTR_LIST = 12;
  public static final int ATTR = 14;
  public static final int ATTR_VALUE_START = 16;
  public static final int ATTR_VALUE_DQ = 18;
  public static final int ATTR_VALUE_SQ = 20;
  public static final int DTD_MARKUP = 22;
  public static final int DOCTYPE = 24;
  public static final int CDATA = 26;
  public static final int C_COMMENT_START = 28;
  public static final int C_COMMENT_END = 30;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7,  7, 
     8,  8,  9,  9, 10, 10,  8,  8, 11, 11, 12, 12, 13, 13, 14, 14
  };

  /** 
   * Translates characters to character classes
   * Chosen bits are [11, 6, 4]
   * Total runtime size is 13568 bytes
   */
  public static int ZZ_CMAP(int ch) {
    return ZZ_CMAP_A[(ZZ_CMAP_Y[(ZZ_CMAP_Z[ch>>10]<<6)|((ch>>4)&0x3f)]<<4)|(ch&0xf)];
  }

  /* The ZZ_CMAP_Z table has 1088 entries */
  static final char ZZ_CMAP_Z[] = zzUnpackCMap(
    "\1\0\1\1\1\2\1\3\1\4\1\5\1\6\1\7\1\10\2\11\1\12\1\13\6\14\1\15\23\14\1\16"+
    "\1\14\1\17\1\20\12\14\1\21\10\11\1\22\1\23\1\24\1\25\1\26\1\27\1\30\1\31\1"+
    "\32\1\11\1\33\1\34\2\11\1\14\1\35\3\11\1\36\10\11\1\37\1\40\20\11\1\41\2\11"+
    "\1\42\5\11\1\43\4\11\1\44\1\45\4\11\51\14\1\46\3\14\1\47\1\50\4\14\1\51\12"+
    "\11\1\52\u0381\11");

  /* The ZZ_CMAP_Y table has 2752 entries */
  static final char ZZ_CMAP_Y[] = zzUnpackCMap(
    "\1\0\1\1\1\2\1\3\1\4\1\5\1\6\1\7\1\10\1\1\1\11\1\12\1\13\1\14\1\13\1\14\34"+
    "\13\1\15\1\16\1\17\10\1\1\20\1\21\1\13\1\22\4\13\1\23\10\13\1\24\12\13\1\25"+
    "\1\13\1\26\1\25\1\13\1\27\4\1\1\13\1\30\1\31\2\1\2\13\1\30\1\1\1\32\1\25\5"+
    "\13\1\33\1\34\1\35\1\1\1\36\1\13\1\1\1\37\5\13\1\40\1\41\1\42\1\13\1\30\1"+
    "\43\1\13\1\44\1\45\1\1\1\13\1\46\4\1\1\13\1\47\4\1\1\50\2\13\1\51\1\1\1\52"+
    "\1\16\1\25\1\53\1\54\1\55\1\56\1\57\1\60\2\16\1\61\1\54\1\55\1\62\1\1\1\63"+
    "\1\1\1\64\1\65\1\22\1\55\1\66\1\1\1\67\1\16\1\70\1\71\1\54\1\55\1\66\1\1\1"+
    "\60\1\16\1\41\1\72\1\73\1\74\1\75\1\1\1\67\2\1\1\76\1\36\1\55\1\51\1\1\1\77"+
    "\1\16\1\1\1\76\1\36\1\55\1\100\1\1\1\57\1\16\1\101\1\76\1\36\1\13\1\102\1"+
    "\57\1\103\1\16\1\42\1\104\1\105\1\13\1\106\1\107\3\1\1\25\2\13\1\110\1\107"+
    "\3\1\1\111\1\112\1\113\1\114\1\115\1\116\2\1\1\67\3\1\1\117\1\13\1\120\1\1"+
    "\1\121\7\1\2\13\1\30\1\103\1\1\1\122\1\123\1\124\1\125\1\1\2\13\1\126\2\13"+
    "\1\127\24\13\1\130\1\131\2\13\1\130\2\13\1\132\1\133\1\14\3\13\1\133\3\13"+
    "\1\30\2\1\1\13\1\1\5\13\1\134\1\25\45\13\1\135\1\13\1\25\1\30\4\13\1\30\1"+
    "\136\1\137\1\16\1\13\1\16\1\13\1\16\1\137\1\67\3\13\1\140\1\1\1\141\4\1\5"+
    "\13\1\27\2\13\1\142\4\13\1\40\1\13\1\143\3\1\1\13\1\144\1\47\2\13\1\145\1"+
    "\13\1\75\3\1\1\13\1\107\3\13\1\47\4\1\1\146\5\1\1\104\2\13\1\140\1\147\3\1"+
    "\1\150\1\13\1\151\1\42\2\13\1\40\1\1\2\13\1\140\1\1\1\37\1\42\1\13\1\144\6"+
    "\1\1\152\1\153\14\13\4\1\21\13\1\134\2\13\1\134\1\154\1\13\1\144\3\13\1\155"+
    "\1\156\1\157\1\120\1\156\2\1\1\160\4\1\1\161\1\1\1\120\6\1\1\162\1\163\1\164"+
    "\1\165\1\166\3\1\1\167\147\1\2\13\1\143\2\13\1\143\10\13\1\170\1\171\2\13"+
    "\1\126\3\13\1\172\1\1\1\13\1\107\4\173\4\1\1\103\35\1\1\174\2\1\1\175\1\25"+
    "\4\13\1\176\1\25\4\13\1\127\1\104\1\13\1\144\1\25\4\13\1\143\1\1\1\13\1\30"+
    "\3\1\1\13\40\1\133\13\1\40\4\1\135\13\1\40\2\1\10\13\1\120\4\1\2\13\1\144"+
    "\20\13\1\120\1\13\1\177\1\1\2\13\1\143\1\103\1\13\1\144\4\13\1\40\2\1\1\200"+
    "\1\201\5\13\1\202\1\13\1\144\1\27\3\1\1\200\1\203\1\13\1\31\1\1\3\13\1\140"+
    "\1\201\2\13\1\140\3\1\1\204\1\42\1\13\1\40\1\13\1\107\1\1\1\13\1\120\1\50"+
    "\2\13\1\31\1\103\1\1\1\205\1\206\2\13\1\46\1\1\1\207\1\1\1\13\1\210\3\13\1"+
    "\211\1\212\1\213\1\30\1\64\1\214\1\215\1\173\2\13\1\127\1\40\7\13\1\31\1\1"+
    "\72\13\1\140\1\13\1\216\2\13\1\145\20\1\26\13\1\144\6\13\1\75\2\1\1\107\1"+
    "\217\1\55\1\220\1\221\6\13\1\16\1\1\1\150\25\13\1\144\1\1\4\13\1\201\2\13"+
    "\1\27\2\1\1\145\7\1\1\205\7\13\1\120\2\1\1\25\1\30\1\25\1\30\1\222\4\13\1"+
    "\143\1\223\1\224\2\1\1\225\1\13\1\14\1\226\2\144\2\1\7\13\1\30\30\1\1\13\1"+
    "\120\3\13\1\67\2\1\2\13\1\1\1\13\1\227\2\13\1\40\1\13\1\144\2\13\1\230\3\1"+
    "\11\13\1\144\6\1\2\13\1\27\3\13\1\140\11\1\23\13\1\107\1\13\1\40\1\27\11\1"+
    "\1\231\2\13\1\232\1\13\1\40\1\13\1\107\1\13\1\143\4\1\1\13\1\233\1\13\1\40"+
    "\1\13\1\75\4\1\3\13\1\234\4\1\1\67\1\235\1\13\1\140\2\1\1\13\1\120\1\13\1"+
    "\120\2\1\1\117\1\13\1\47\1\1\3\13\1\40\1\13\1\40\1\13\1\31\1\13\1\16\6\1\4"+
    "\13\1\46\3\1\3\13\1\31\3\13\1\31\60\1\1\150\2\13\1\27\4\1\1\150\2\13\2\1\1"+
    "\13\1\46\1\1\1\150\1\13\1\107\2\1\2\13\1\236\1\150\2\13\1\31\1\237\1\240\2"+
    "\1\1\13\1\22\1\145\5\1\1\241\1\242\1\46\2\13\1\143\2\1\1\71\1\54\1\55\1\66"+
    "\1\1\1\243\1\16\21\1\3\13\1\1\1\244\13\1\2\13\1\143\2\1\1\245\2\1\3\13\1\1"+
    "\1\246\3\1\2\13\1\30\5\1\1\13\1\75\30\1\4\13\1\1\1\103\34\1\3\13\1\46\20\1"+
    "\71\13\1\75\16\1\14\13\1\140\53\1\2\13\1\143\75\1\44\13\1\107\33\1\43\13\1"+
    "\46\1\13\1\143\7\1\1\13\1\144\1\1\3\13\1\1\1\140\1\1\1\150\1\247\1\13\67\1"+
    "\4\13\1\47\1\67\3\1\1\150\6\1\1\16\77\1\6\13\1\30\1\120\1\46\1\75\66\1\5\13"+
    "\1\205\3\13\1\137\1\250\1\251\1\252\3\13\1\253\1\254\1\13\1\255\1\256\1\36"+
    "\24\13\1\257\1\13\1\36\1\127\1\13\1\127\1\13\1\205\1\13\1\205\1\143\1\13\1"+
    "\143\1\13\1\55\1\13\1\55\1\13\1\207\3\1\14\13\1\47\123\1\1\252\1\13\1\260"+
    "\1\261\1\262\1\263\1\264\1\265\1\266\1\145\1\267\1\145\24\1\55\13\1\107\2"+
    "\1\103\13\1\47\15\13\1\144\150\13\1\16\25\1\41\13\1\144\36\1");

  /* The ZZ_CMAP_A table has 2944 entries */
  static final char ZZ_CMAP_A[] = zzUnpackCMap(
    "\11\0\2\65\1\0\2\65\22\0\1\65\1\15\1\57\1\6\1\4\1\66\1\16\1\60\2\14\3\0\1"+
    "\12\1\11\1\63\12\2\1\10\1\30\1\17\1\64\1\13\1\61\1\0\1\23\1\54\1\21\1\22\1"+
    "\50\1\44\2\1\1\56\2\1\1\55\1\52\1\1\1\45\1\47\2\1\1\51\1\24\1\53\3\1\1\46"+
    "\1\1\1\20\1\67\1\25\1\0\1\7\1\0\1\32\1\41\4\44\1\31\4\1\1\26\1\42\1\40\1\34"+
    "\1\33\1\36\1\1\1\35\1\27\1\37\2\1\1\43\2\1\1\5\1\14\1\62\7\0\1\3\24\0\1\1"+
    "\12\0\1\1\4\0\1\1\5\0\27\1\1\0\12\1\4\0\14\1\16\0\5\1\7\0\1\1\1\0\1\1\1\0"+
    "\5\1\1\0\2\1\2\0\4\1\1\0\1\1\6\0\1\1\1\0\3\1\1\0\1\1\1\0\4\1\1\0\23\1\1\0"+
    "\13\1\10\0\6\1\1\0\26\1\2\0\1\1\6\0\10\1\10\0\13\1\5\0\3\1\33\0\6\1\1\0\1"+
    "\1\17\0\2\1\7\0\2\1\12\0\3\1\2\0\2\1\1\0\16\1\15\0\11\1\13\0\1\1\30\0\6\1"+
    "\4\0\2\1\4\0\1\1\5\0\6\1\4\0\1\1\11\0\1\1\3\0\1\1\7\0\11\1\7\0\5\1\17\0\26"+
    "\1\3\0\1\1\2\0\1\1\7\0\11\1\4\0\10\1\2\0\2\1\2\0\26\1\1\0\7\1\1\0\1\1\3\0"+
    "\4\1\3\0\1\1\20\0\1\1\15\0\2\1\1\0\1\1\5\0\6\1\4\0\2\1\1\0\2\1\1\0\2\1\1\0"+
    "\2\1\17\0\4\1\1\0\1\1\3\0\3\1\20\0\11\1\1\0\2\1\1\0\2\1\1\0\5\1\3\0\1\1\2"+
    "\0\1\1\30\0\1\1\13\0\10\1\2\0\1\1\3\0\1\1\1\0\6\1\3\0\3\1\1\0\4\1\3\0\2\1"+
    "\1\0\1\1\1\0\2\1\3\0\2\1\3\0\3\1\3\0\14\1\13\0\10\1\1\0\2\1\10\0\3\1\5\0\4"+
    "\1\1\0\5\1\3\0\1\1\3\0\2\1\15\0\13\1\2\0\1\1\21\0\1\1\5\0\22\1\3\0\10\1\1"+
    "\0\11\1\1\0\1\1\2\0\7\1\11\0\1\1\1\0\2\1\15\0\2\1\1\0\1\1\2\0\2\1\1\0\1\1"+
    "\2\0\1\1\6\0\4\1\1\0\7\1\1\0\3\1\1\0\1\1\1\0\1\1\2\0\2\1\1\0\4\1\1\0\2\1\11"+
    "\0\1\1\2\0\5\1\1\0\1\1\25\0\14\1\1\0\24\1\13\0\5\1\3\0\6\1\4\0\4\1\3\0\1\1"+
    "\3\0\2\1\7\0\3\1\4\0\15\1\14\0\1\1\1\0\6\1\1\0\1\1\5\0\1\1\2\0\13\1\1\0\15"+
    "\1\1\0\4\1\2\0\7\1\1\0\1\1\1\0\4\1\2\0\1\1\1\0\4\1\2\0\7\1\1\0\1\1\1\0\4\1"+
    "\2\0\16\1\2\0\6\1\2\0\15\1\2\0\1\1\1\0\10\1\7\0\15\1\1\0\6\1\23\0\1\1\4\0"+
    "\1\1\3\0\11\1\1\0\1\1\5\0\17\1\1\0\16\1\2\0\14\1\13\0\1\1\15\0\7\1\7\0\16"+
    "\1\15\0\2\1\11\0\4\1\1\0\4\1\3\0\2\1\11\0\10\1\1\0\1\1\1\0\1\1\1\0\1\1\1\0"+
    "\6\1\1\0\7\1\1\0\1\1\3\0\3\1\1\0\7\1\3\0\4\1\2\0\6\1\14\0\2\3\7\0\1\1\15\0"+
    "\1\1\2\0\1\1\4\0\1\1\2\0\12\1\1\0\1\1\3\0\5\1\6\0\1\1\1\0\1\1\1\0\1\1\1\0"+
    "\4\1\1\0\13\1\2\0\4\1\5\0\5\1\4\0\1\1\4\0\2\1\13\0\5\1\6\0\4\1\3\0\2\1\14"+
    "\0\10\1\7\0\10\1\1\0\7\1\6\0\2\1\12\0\5\1\5\0\2\1\3\0\7\1\6\0\3\1\12\0\2\1"+
    "\13\0\11\1\2\0\27\1\2\0\7\1\1\0\3\1\1\0\4\1\1\0\4\1\2\0\6\1\3\0\1\1\1\0\1"+
    "\1\2\0\5\1\1\0\12\1\12\0\5\1\1\0\3\1\1\0\10\1\4\0\7\1\3\0\1\1\3\0\2\1\1\0"+
    "\1\1\3\0\2\1\2\0\5\1\2\0\1\1\1\0\1\1\30\0\3\1\3\0\6\1\2\0\6\1\2\0\6\1\11\0"+
    "\7\1\4\0\5\1\3\0\5\1\5\0\1\1\1\0\10\1\1\0\5\1\1\0\1\1\1\0\2\1\1\0\2\1\1\0"+
    "\12\1\6\0\12\1\2\0\6\1\2\0\6\1\2\0\6\1\2\0\3\1\3\0\14\1\1\0\16\1\1\0\2\1\1"+
    "\0\2\1\1\0\10\1\6\0\4\1\4\0\16\1\2\0\1\1\1\0\14\1\1\0\2\1\3\0\1\1\2\0\4\1"+
    "\1\0\2\1\12\0\10\1\6\0\6\1\1\0\3\1\1\0\12\1\3\0\1\1\12\0\4\1\25\0\1\1\1\0"+
    "\1\1\3\0\7\1\1\0\1\1\1\0\4\1\1\0\17\1\1\0\2\1\14\0\3\1\4\0\2\1\1\0\1\1\20"+
    "\0\4\1\10\0\1\1\13\0\10\1\5\0\3\1\2\0\1\1\2\0\2\1\2\0\4\1\1\0\14\1\1\0\1\1"+
    "\1\0\7\1\1\0\21\1\1\0\4\1\2\0\10\1\1\0\7\1\1\0\14\1\1\0\4\1\1\0\5\1\1\0\1"+
    "\1\3\0\14\1\2\0\10\1\1\0\2\1\1\0\1\1\2\0\1\1\1\0\12\1\1\0\4\1\1\0\1\1\1\0"+
    "\1\1\6\0\1\1\4\0\1\1\1\0\1\1\1\0\1\1\1\0\3\1\1\0\2\1\1\0\1\1\2\0\1\1\1\0\1"+
    "\1\1\0\1\1\1\0\1\1\1\0\1\1\1\0\2\1\1\0\1\1\2\0\4\1\1\0\7\1\1\0\4\1\1\0\4\1"+
    "\1\0\1\1\1\0\12\1\1\0\5\1\1\0\3\1\1\0\5\1\1\0\5\1");

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\1\16\0\1\1\1\2\1\1\1\3\1\4\1\2"+
    "\1\1\1\3\1\5\1\6\1\7\2\3\2\10\1\3"+
    "\4\11\1\12\1\13\1\14\1\13\1\15\1\16\4\17"+
    "\1\20\1\21\1\22\2\23\1\14\1\23\1\24\3\23"+
    "\1\25\1\3\2\12\2\3\2\1\1\26\1\13\4\26"+
    "\1\27\10\0\1\30\1\31\1\5\1\0\1\32\2\10"+
    "\1\33\1\12\2\0\1\16\5\0\1\34\1\0\2\12"+
    "\3\0\1\35\1\36\1\0\1\37\12\0\1\40\1\41"+
    "\1\42\1\43\1\44\2\12\1\45\1\46\2\0\1\47"+
    "\2\0\2\12\2\0\2\12\2\0\1\50\1\51\4\0"+
    "\1\52\1\53";

  private static int [] zzUnpackAction() {
    int [] result = new int[147];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\70\0\160\0\250\0\340\0\u0118\0\u0150\0\u0188"+
    "\0\u01c0\0\u01f8\0\u0230\0\u0268\0\u02a0\0\u02d8\0\u0310\0\u0348"+
    "\0\u0380\0\u03b8\0\u03f0\0\u0428\0\u0460\0\u0498\0\u04d0\0\u0508"+
    "\0\u0540\0\u04d0\0\u0578\0\u05b0\0\u05e8\0\u0620\0\u0658\0\u04d0"+
    "\0\u03f0\0\u0578\0\u0658\0\u0690\0\u04d0\0\u06c8\0\u0700\0\u04d0"+
    "\0\u0738\0\u04d0\0\u0540\0\u03f0\0\u0578\0\u04d0\0\u04d0\0\u04d0"+
    "\0\u04d0\0\u0770\0\u03f0\0\u0578\0\u04d0\0\u07a8\0\u07e0\0\u0818"+
    "\0\u04d0\0\u0850\0\u0888\0\u08c0\0\u08f8\0\u0930\0\u04d0\0\u0968"+
    "\0\u04d0\0\u09a0\0\u09d8\0\u03f0\0\u0578\0\u0a10\0\u04d0\0\u0a48"+
    "\0\u0a80\0\u0ab8\0\u0af0\0\u0b28\0\u0b60\0\u0b98\0\u0bd0\0\u04d0"+
    "\0\u04d0\0\u0c08\0\u0c40\0\u04d0\0\u0c78\0\u0cb0\0\u04d0\0\u0ce8"+
    "\0\u0d20\0\u0d58\0\u0d90\0\u0dc8\0\u0e00\0\u0e38\0\u0e70\0\u0850"+
    "\0\u04d0\0\u0ea8\0\u0ee0\0\u0f18\0\u08f8\0\u0930\0\u0f50\0\u04d0"+
    "\0\u04d0\0\u0f88\0\u04d0\0\u0fc0\0\u0ff8\0\u1030\0\u1068\0\u10a0"+
    "\0\u10d8\0\u1110\0\u1148\0\u1180\0\u11b8\0\u05e8\0\u04d0\0\u04d0"+
    "\0\u04d0\0\u04d0\0\u11f0\0\u1228\0\u04d0\0\u04d0\0\u1260\0\u1298"+
    "\0\u04d0\0\u12d0\0\u1308\0\u1340\0\u1378\0\u13b0\0\u13e8\0\u1420"+
    "\0\u1458\0\u1490\0\u14c8\0\u0690\0\u0690\0\u1500\0\u1538\0\u1570"+
    "\0\u15a8\0\u04d0\0\u04d0";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[147];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\3\20\1\21\1\22\1\20\1\22\7\20\1\23\1\24"+
    "\45\20\1\25\1\20\1\26\1\27\1\30\1\27\1\31"+
    "\3\27\2\30\2\27\1\32\2\27\1\23\1\33\1\27"+
    "\4\30\1\27\2\30\1\27\26\30\4\27\1\34\1\27"+
    "\1\31\3\27\1\35\5\27\2\35\5\27\1\23\1\33"+
    "\1\27\4\35\1\27\2\35\1\27\12\35\1\36\13\35"+
    "\2\27\1\37\6\27\3\40\1\31\12\40\1\41\1\42"+
    "\41\40\1\43\3\40\1\31\2\40\1\27\1\44\1\27"+
    "\1\31\3\27\2\44\2\27\1\32\2\27\1\23\1\33"+
    "\1\27\4\44\1\27\2\44\1\27\26\44\6\27\1\31"+
    "\2\27\12\45\1\46\4\45\1\47\1\50\47\45\1\27"+
    "\1\51\1\27\1\31\3\27\2\51\5\27\1\23\1\33"+
    "\1\27\4\51\1\27\2\51\1\27\26\51\6\27\1\31"+
    "\2\27\3\52\1\53\12\52\1\54\1\55\37\52\1\56"+
    "\1\57\3\52\1\60\1\31\2\52\16\27\1\23\1\33"+
    "\50\27\4\61\1\62\1\61\1\62\7\61\1\63\1\64"+
    "\37\61\1\65\6\61\1\66\5\61\1\67\1\61\1\67"+
    "\7\61\1\63\1\64\40\61\1\65\5\61\1\70\1\61"+
    "\1\27\1\44\1\27\1\31\3\27\2\44\2\27\1\71"+
    "\2\27\1\23\1\33\1\72\4\44\1\27\2\44\1\27"+
    "\16\44\1\73\1\44\1\74\5\44\1\75\1\76\4\27"+
    "\1\31\2\27\25\77\1\100\42\77\1\101\1\102\10\101"+
    "\1\103\3\101\1\104\1\105\1\101\4\102\1\106\2\102"+
    "\1\101\26\102\12\101\1\102\10\101\1\103\3\101\1\104"+
    "\1\105\1\101\4\102\1\107\2\102\1\101\26\102\11\101"+
    "\4\20\1\0\1\20\1\0\7\20\2\0\45\20\1\0"+
    "\1\20\1\26\3\20\1\21\1\0\1\20\1\0\7\20"+
    "\2\0\45\20\1\25\1\20\1\26\5\0\1\110\63\0"+
    "\1\111\4\0\1\112\2\111\10\0\4\111\1\0\1\113"+
    "\1\111\1\0\1\113\1\114\3\111\1\115\1\111\1\116"+
    "\16\111\26\0\1\117\43\0\1\120\1\0\1\121\7\0"+
    "\1\25\61\0\1\25\2\0\16\20\2\0\45\20\1\0"+
    "\1\20\1\26\71\0\2\30\4\0\1\30\1\122\2\30"+
    "\6\0\4\30\1\0\2\30\1\0\26\30\14\0\1\31"+
    "\61\0\1\31\17\0\1\123\65\0\1\124\55\0\2\35"+
    "\4\0\1\35\1\125\2\35\6\0\4\35\1\0\2\35"+
    "\1\0\26\35\12\0\2\35\4\0\1\35\1\125\2\35"+
    "\6\0\4\35\1\0\2\35\1\0\11\35\1\126\14\35"+
    "\24\0\1\127\55\0\2\44\4\0\1\44\1\130\2\44"+
    "\6\0\4\44\1\0\2\44\1\0\26\44\11\0\12\45"+
    "\1\131\55\45\15\0\1\132\53\0\2\51\4\0\1\51"+
    "\1\133\2\51\6\0\4\51\1\0\2\51\1\0\26\51"+
    "\16\0\1\134\146\0\1\135\10\0\1\136\146\0\1\137"+
    "\3\0\25\140\1\141\31\140\1\142\10\140\1\0\2\44"+
    "\4\0\1\44\1\130\2\44\6\0\4\44\1\0\2\44"+
    "\1\0\22\44\1\143\3\44\12\0\2\44\4\0\1\44"+
    "\1\130\2\44\6\0\4\44\1\0\2\44\1\0\15\44"+
    "\1\144\10\44\11\0\57\145\1\61\10\145\60\146\1\61"+
    "\7\146\25\0\1\147\43\0\3\102\5\0\1\102\2\0"+
    "\3\102\2\0\4\102\1\0\2\102\1\0\26\102\6\0"+
    "\1\102\14\0\1\131\70\0\1\150\54\0\17\110\1\0"+
    "\42\110\1\151\5\110\1\0\2\111\4\0\1\111\1\152"+
    "\2\111\6\0\4\111\1\0\2\111\1\153\26\111\13\0"+
    "\1\154\40\0\1\155\25\0\2\111\4\0\1\111\1\152"+
    "\2\111\6\0\4\111\1\0\1\111\1\156\1\153\26\111"+
    "\12\0\2\111\4\0\1\111\1\152\2\111\6\0\4\111"+
    "\1\0\2\111\1\153\2\111\1\157\6\111\1\160\14\111"+
    "\12\0\2\111\4\0\1\111\1\152\2\111\6\0\4\111"+
    "\1\0\2\111\1\153\6\111\1\161\17\111\12\0\2\111"+
    "\4\0\1\111\1\152\2\111\6\0\4\111\1\0\2\111"+
    "\1\153\10\111\1\162\15\111\23\0\1\163\5\0\1\164"+
    "\1\0\1\165\46\0\2\122\4\0\1\122\1\0\2\122"+
    "\6\0\4\122\1\0\2\122\1\0\26\122\23\0\1\163"+
    "\5\0\1\164\50\0\2\125\4\0\1\125\1\0\2\125"+
    "\6\0\4\125\1\0\2\125\1\0\26\125\12\0\2\35"+
    "\4\0\1\35\1\125\2\35\6\0\4\35\1\0\1\166"+
    "\1\35\1\0\26\35\12\0\2\130\4\0\1\130\1\0"+
    "\2\130\6\0\4\130\1\0\2\130\1\0\26\130\24\0"+
    "\1\167\74\0\1\170\50\0\2\133\4\0\1\133\1\0"+
    "\2\133\6\0\4\133\1\0\2\133\1\0\26\133\11\0"+
    "\57\134\1\0\2\134\1\171\5\134\57\135\1\0\6\135"+
    "\1\172\1\135\60\136\1\0\1\136\1\171\5\136\60\137"+
    "\1\0\5\137\1\172\1\137\57\142\1\140\10\142\1\0"+
    "\2\44\4\0\1\44\1\130\2\44\6\0\4\44\1\0"+
    "\2\44\1\0\23\44\1\173\2\44\12\0\2\44\4\0"+
    "\1\44\1\130\2\44\6\0\4\44\1\0\2\44\1\0"+
    "\20\44\1\174\5\44\24\0\1\175\55\0\2\152\4\0"+
    "\1\152\1\0\2\152\6\0\4\152\1\0\2\152\1\153"+
    "\26\152\13\0\1\154\25\0\1\176\41\0\1\177\16\0"+
    "\3\177\6\0\1\177\6\0\1\177\2\0\1\177\3\0"+
    "\1\177\3\0\1\177\14\0\2\111\4\0\1\111\1\152"+
    "\2\111\6\0\4\111\1\0\2\111\1\176\26\111\12\0"+
    "\2\111\4\0\1\111\1\152\2\111\6\0\4\111\1\0"+
    "\2\111\1\153\3\111\1\200\22\111\12\0\2\111\4\0"+
    "\1\111\1\152\2\111\6\0\4\111\1\0\2\111\1\153"+
    "\2\111\1\156\23\111\12\0\2\111\4\0\1\111\1\152"+
    "\2\111\6\0\4\111\1\0\2\111\1\153\3\111\1\113"+
    "\22\111\12\0\2\111\4\0\1\111\1\152\2\111\6\0"+
    "\4\111\1\0\2\111\1\153\4\111\1\160\21\111\23\0"+
    "\1\201\76\0\1\202\113\0\1\203\23\0\2\44\4\0"+
    "\1\44\1\130\2\44\6\0\4\44\1\0\2\44\1\0"+
    "\24\44\1\204\1\44\12\0\2\44\4\0\1\44\1\130"+
    "\2\44\6\0\3\44\1\205\1\0\2\44\1\0\26\44"+
    "\13\0\1\177\16\0\3\177\4\0\1\176\1\0\1\177"+
    "\6\0\1\177\2\0\1\177\3\0\1\177\3\0\1\177"+
    "\14\0\2\111\4\0\1\111\1\152\2\111\6\0\4\111"+
    "\1\0\2\111\1\153\4\111\1\156\21\111\33\0\1\206"+
    "\66\0\1\207\47\0\2\44\4\0\1\44\1\130\2\44"+
    "\6\0\4\44\1\0\2\44\1\0\25\44\1\210\12\0"+
    "\2\44\4\0\1\44\1\130\2\44\6\0\4\44\1\0"+
    "\2\44\1\0\17\44\1\211\6\44\34\0\1\212\70\0"+
    "\1\213\44\0\2\44\4\0\1\44\1\130\2\44\6\0"+
    "\1\214\3\44\1\0\2\44\1\0\26\44\12\0\2\44"+
    "\4\0\1\44\1\130\2\44\6\0\4\44\1\0\2\44"+
    "\1\0\21\44\1\215\4\44\35\0\1\216\111\0\1\217"+
    "\44\0\1\220\113\0\1\221\40\0\1\222\117\0\1\223"+
    "\17\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[5600];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String[] ZZ_ERROR_MSG = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\1\16\0\7\1\1\11\2\1\1\11\5\1\1\11"+
    "\4\1\1\11\2\1\1\11\1\1\1\11\3\1\4\11"+
    "\3\1\1\11\3\1\1\11\5\1\1\11\1\1\1\11"+
    "\5\1\1\11\10\0\2\11\1\1\1\0\1\11\2\1"+
    "\1\11\1\1\2\0\1\1\5\0\1\11\1\0\2\1"+
    "\3\0\2\11\1\0\1\11\12\0\1\1\4\11\2\1"+
    "\2\11\2\0\1\11\2\0\2\1\2\0\2\1\2\0"+
    "\2\1\4\0\2\11";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[147];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private CharSequence zzBuffer = "";

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /**
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
  private IElementType elTokenType = XmlTokenType.XML_DATA_CHARACTERS;
  private IElementType elTokenType2 = XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN;
  private IElementType javaEmbeddedTokenType = XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN;
  private boolean myConditionalCommentsSupport;

  public void setConditionalCommentsSupport(final boolean b) {
    myConditionalCommentsSupport = b;
  }

  public void setElTypes(IElementType _elTokenType,IElementType _elTokenType2) {
    elTokenType = _elTokenType;
    elTokenType2 = _elTokenType2;
  }

  public void setJavaEmbeddedType(IElementType _tokenType) {
    javaEmbeddedTokenType = _tokenType;
  }

  private int myPrevState = YYINITIAL;

  public int yyprevstate() {
    return myPrevState;
  }

  private int popState(){
    final int prev = myPrevState;
    myPrevState = YYINITIAL;
    return prev;
  }

  protected void pushState(int state){
    myPrevState = state;
  }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public __XmlLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    int size = 0;
    for (int i = 0, length = packed.length(); i < length; i += 2) {
      size += packed.charAt(i);
    }
    char[] map = new char[size];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < packed.length()) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }

  public final int getTokenStart() {
    return zzStartRead;
  }

  public final int getTokenEnd() {
    return getTokenStart() + yylength();
  }

  public void reset(CharSequence buffer, int start, int end, int initialState) {
    zzBuffer = buffer;
    zzCurrentPos = zzMarkedPos = zzStartRead = start;
    zzAtEOF  = false;
    zzAtBOL = true;
    zzEndRead = end;
    yybegin(initialState);
  }

  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   *
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {
    return true;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final CharSequence yytext() {
    return zzBuffer.subSequence(zzStartRead, zzMarkedPos);
  }


  /**
   * Returns the character at position <tt>pos</tt> from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer.charAt(zzStartRead+pos);
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public IElementType advance() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    CharSequence zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL/*, zzEndReadL*/);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL/*, zzEndReadL*/);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + ZZ_CMAP(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        return null;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { return XmlTokenType.XML_DATA_CHARACTERS;
            }
          case 44: break;
          case 2: 
            { return XmlTokenType.XML_REAL_WHITE_SPACE;
            }
          case 45: break;
          case 3: 
            { if(yystate() == YYINITIAL){
        return XmlTokenType.XML_BAD_CHARACTER;
      }
      else yybegin(popState()); yypushback(yylength());
            }
          case 46: break;
          case 4: 
            { yybegin(TAG); return XmlTokenType.XML_START_TAG_START;
            }
          case 47: break;
          case 5: 
            { yybegin(ATTR_LIST); pushState(TAG); return XmlTokenType.XML_NAME;
            }
          case 48: break;
          case 6: 
            { return XmlTokenType.XML_WHITE_SPACE;
            }
          case 49: break;
          case 7: 
            { yybegin(YYINITIAL); return XmlTokenType.XML_TAG_END;
            }
          case 50: break;
          case 8: 
            { yybegin(PI_ANY); return XmlTokenType.XML_NAME;
            }
          case 51: break;
          case 9: 
            { return XmlTokenType.XML_TAG_CHARACTERS;
            }
          case 52: break;
          case 10: 
            { return XmlTokenType.XML_NAME;
            }
          case 53: break;
          case 11: 
            { return XmlTokenType.XML_COMMENT_CHARACTERS;
            }
          case 54: break;
          case 12: 
            { return XmlTokenType.XML_BAD_CHARACTER;
            }
          case 55: break;
          case 13: 
            { if (myConditionalCommentsSupport) {
    yybegin(C_COMMENT_START);
    return XmlTokenType.XML_CONDITIONAL_COMMENT_START;
  } else return XmlTokenType.XML_COMMENT_CHARACTERS;
            }
          case 56: break;
          case 14: 
            { yybegin(ATTR); return XmlTokenType.XML_NAME;
            }
          case 57: break;
          case 15: 
            { yybegin(ATTR_LIST); yypushback(yylength());
            }
          case 58: break;
          case 16: 
            { yybegin(ATTR_VALUE_DQ); return XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER;
            }
          case 59: break;
          case 17: 
            { yybegin(ATTR_VALUE_SQ); return XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER;
            }
          case 60: break;
          case 18: 
            { return XmlTokenType.XML_EQ;
            }
          case 61: break;
          case 19: 
            { return XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN;
            }
          case 62: break;
          case 20: 
            { yybegin(ATTR_LIST); return XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER;
            }
          case 63: break;
          case 21: 
            { yybegin(YYINITIAL); return XmlTokenType.XML_DOCTYPE_END;
            }
          case 64: break;
          case 22: 
            { yybegin(COMMENT); return XmlTokenType.XML_COMMENT_CHARACTERS;
            }
          case 65: break;
          case 23: 
            { yybegin(COMMENT); return XmlTokenType.XML_CONDITIONAL_COMMENT_END;
            }
          case 66: break;
          case 24: 
            { yybegin(PROCESSING_INSTRUCTION); return XmlTokenType.XML_PI_START;
            }
          case 67: break;
          case 25: 
            { yybegin(END_TAG); return XmlTokenType.XML_END_TAG_START;
            }
          case 68: break;
          case 26: 
            { yybegin(YYINITIAL); return XmlTokenType.XML_EMPTY_ELEMENT_END;
            }
          case 69: break;
          case 27: 
            { yybegin(YYINITIAL); return XmlTokenType.XML_PI_END;
            }
          case 70: break;
          case 28: 
            { return XmlElementType.XML_MARKUP_DECL;
            }
          case 71: break;
          case 29: 
            { yybegin(COMMENT); return XmlTokenType.XML_CONDITIONAL_COMMENT_START_END;
            }
          case 72: break;
          case 30: 
            { return elTokenType;
            }
          case 73: break;
          case 31: 
            { return XmlTokenType.XML_ENTITY_REF_TOKEN;
            }
          case 74: break;
          case 32: 
            { yybegin(ATTR_LIST); pushState(PROCESSING_INSTRUCTION); return XmlTokenType.XML_NAME;
            }
          case 75: break;
          case 33: 
            { yybegin(YYINITIAL); return XmlTokenType.XML_COMMENT_END;
            }
          case 76: break;
          case 34: 
            { if (myConditionalCommentsSupport) {
    yybegin(C_COMMENT_END);
    return XmlTokenType.XML_CONDITIONAL_COMMENT_END_START;
  } else return XmlTokenType.XML_COMMENT_CHARACTERS;
            }
          case 77: break;
          case 35: 
            { return elTokenType2;
            }
          case 78: break;
          case 36: 
            { return javaEmbeddedTokenType;
            }
          case 79: break;
          case 37: 
            { yybegin(YYINITIAL); return XmlTokenType.XML_CDATA_END;
            }
          case 80: break;
          case 38: 
            { return XmlTokenType.XML_CHAR_ENTITY_REF;
            }
          case 81: break;
          case 39: 
            { yybegin(COMMENT); return XmlTokenType.XML_COMMENT_START;
            }
          case 82: break;
          case 40: 
            { return XmlTokenType.XML_DOCTYPE_PUBLIC;
            }
          case 83: break;
          case 41: 
            { return XmlTokenType.XML_DOCTYPE_SYSTEM;
            }
          case 84: break;
          case 42: 
            { yybegin(CDATA); return XmlTokenType.XML_CDATA_START;
            }
          case 85: break;
          case 43: 
            { yybegin(DOCTYPE); return XmlTokenType.XML_DOCTYPE_START;
            }
          case 86: break;
          default:
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
