#ifndef _BIGCHUMPPRE_H_
#define _BIGCHUMPPRE_H_

// bigchumppre_table generated by DK/circ_table_gen.py -- do not modify manually

 // variables used
 // --sig_max  1.500000
 // --table_div  26.013498
 // --table_op  0.500000

struct tablebigchumppre { // 1-dimensional function table
    float low;
    float high;
    float istep;
    int size;
    float data[];
};

template <int tab_size>
struct tablebigchumppre_imp {
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
    operator tablebigchumppre&() const { return *(tablebigchumppre*)this; }
};

 static tablebigchumppre_imp<2048> bigchumppre_table __rt_data = {
	0,-0.833333,682.333,2048, {
	0.000000000000,-0.000225910485,-0.000456670557,-0.000692199602,-0.000932419379,
	-0.001177253928,-0.001426629478,-0.001680474365,-0.001938718950,-0.002201295540,
	-0.002468138311,-0.002739183243,-0.003014368044,-0.003293632087,-0.003576916348,
	-0.003864163342,-0.004155317069,-0.004450322955,-0.004749127799,-0.005051679725,
	-0.005357928128,-0.005667823630,-0.005981318036,-0.006298364287,-0.006618916420,
	-0.006942929530,-0.007270359732,-0.007601164118,-0.007935300732,-0.008272728528,
	-0.008613407341,-0.008957297858,-0.009304361582,-0.009654560812,-0.010007858609,
	-0.010364218771,-0.010723605810,-0.011085984928,-0.011451321990,-0.011819583505,
	-0.012190736603,-0.012564749018,-0.012941589064,-0.013321225616,-0.013703628096,
	-0.014088766453,-0.014476611145,-0.014867133127,-0.015260303831,-0.015656095154,
	-0.016054479442,-0.016455429479,-0.016858918472,-0.017264920038,-0.017673408193,
	-0.018084357339,-0.018497742256,-0.018913538087,-0.019331720330,-0.019752264828,
	-0.020175147760,-0.020600345630,-0.021027835260,-0.021457593780,-0.021889598620,
	-0.022323827504,-0.022760258441,-0.023198869717,-0.023639639890,-0.024082547780,
	-0.024527572467,-0.024974693281,-0.025423889798,-0.025875141832,-0.026328429434,
	-0.026783732880,-0.027241032672,-0.027700309528,-0.028161544382,-0.028624718376,
	-0.029089812855,-0.029556809366,-0.030025689650,-0.030496435643,-0.030969029464,
	-0.031443453422,-0.031919690001,-0.032397721866,-0.032877531854,-0.033359102973,
	-0.033842418398,-0.034327461467,-0.034814215682,-0.035302664700,-0.035792792336,
	-0.036284582558,-0.036778019481,-0.037273087373,-0.037769770642,-0.038268053844,
	-0.038767921671,-0.039269358956,-0.039772350669,-0.040276881912,-0.040782937921,
	-0.041290504061,-0.041799565827,-0.042310108839,-0.042822118841,-0.043335581703,
	-0.043850483412,-0.044366810078,-0.044884547927,-0.045403683303,-0.045924202663,
	-0.046446092579,-0.046969339734,-0.047493930921,-0.048019853043,-0.048547093112,
	-0.049075638243,-0.049605475660,-0.050136592689,-0.050668976758,-0.051202615398,
	-0.051737496241,-0.052273607016,-0.052810935552,-0.053349469775,-0.053889197706,
	-0.054430107461,-0.054972187251,-0.055515425379,-0.056059810242,-0.056605330325,
	-0.057151974206,-0.057699730550,-0.058248588110,-0.058798535730,-0.059349562337,
	-0.059901656946,-0.060454808654,-0.061009006645,-0.061564240185,-0.062120498623,
	-0.062677771388,-0.063236047994,-0.063795318030,-0.064355571168,-0.064916797159,
	-0.065478985828,-0.066042127083,-0.066606210904,-0.067171227350,-0.067737166553,
	-0.068304018721,-0.068871774136,-0.069440423153,-0.070009956200,-0.070580363777,
	-0.071151636454,-0.071723764875,-0.072296739752,-0.072870551867,-0.073445192072,
	-0.074020651287,-0.074596920499,-0.075173990763,-0.075751853204,-0.076330499007,
	-0.076909919429,-0.077490105789,-0.078071049471,-0.078652741923,-0.079235174659,
	-0.079818339253,-0.080402227344,-0.080986830632,-0.081572140879,-0.082158149909,
	-0.082744849606,-0.083332231914,-0.083920288837,-0.084509012439,-0.085098394843,
	-0.085688428228,-0.086279104834,-0.086870416957,-0.087462356951,-0.088054917226,
	-0.088648090248,-0.089241868538,-0.089836244676,-0.090431211292,-0.091026761075,
	-0.091622886764,-0.092219581155,-0.092816837096,-0.093414647488,-0.094013005284,
	-0.094611903490,-0.095211335163,-0.095811293413,-0.096411771398,-0.097012762328,
	-0.097614259465,-0.098216256119,-0.098818745648,-0.099421721463,-0.100025177020,
	-0.100629105825,-0.101233501432,-0.101838357443,-0.102443667507,-0.103049425319,
	-0.103655624621,-0.104262259203,-0.104869322899,-0.105476809590,-0.106084713199,
	-0.106693027699,-0.107301747103,-0.107910865472,-0.108520376907,-0.109130275557,
	-0.109740555610,-0.110351211301,-0.110962236905,-0.111573626739,-0.112185375165,
	-0.112797476583,-0.113409925438,-0.114022716214,-0.114635843435,-0.115249301669,
	-0.115863085521,-0.116477189636,-0.117091608702,-0.117706337443,-0.118321370623,
	-0.118936703045,-0.119552329551,-0.120168245021,-0.120784444372,-0.121400922560,
	-0.122017674578,-0.122634695456,-0.123251980261,-0.123869524096,-0.124487322102,
	-0.125105369454,-0.125723661365,-0.126342193081,-0.126960959886,-0.127579957097,
	-0.128199180067,-0.128818624183,-0.129438284867,-0.130058157574,-0.130678237794,
	-0.131298521049,-0.131919002896,-0.132539678925,-0.133160544757,-0.133781596047,
	-0.134402828482,-0.135024237783,-0.135645819699,-0.136267570015,-0.136889484544,
	-0.137511559132,-0.138133789657,-0.138756172024,-0.139378702173,-0.140001376072,
	-0.140624189718,-0.141247139141,-0.141870220399,-0.142493429579,-0.143116762798,
	-0.143740216202,-0.144363785966,-0.144987468292,-0.145611259414,-0.146235155590,
	-0.146859153109,-0.147483248287,-0.148107437467,-0.148731717020,-0.149356083345,
	-0.149980532867,-0.150605062037,-0.151229667335,-0.151854345265,-0.152479092359,
	-0.153103905175,-0.153728780295,-0.154353714330,-0.154978703913,-0.155603745705,
	-0.156228836391,-0.156853972680,-0.157479151308,-0.158104369034,-0.158729622643,
	-0.159354908942,-0.159980224763,-0.160605566964,-0.161230932423,-0.161856318045,
	-0.162481720756,-0.163107137507,-0.163732565270,-0.164358001043,-0.164983441844,
	-0.165608884714,-0.166234326718,-0.166859764941,-0.167485196492,-0.168110618501,
	-0.168736028121,-0.169361422524,-0.169986798906,-0.170612154483,-0.171237486493,
	-0.171862792194,-0.172488068866,-0.173113313809,-0.173738524344,-0.174363697812,
	-0.174988831574,-0.175613923012,-0.176238969528,-0.176863968542,-0.177488917496,
	-0.178113813850,-0.178738655084,-0.179363438698,-0.179988162210,-0.180612823158,
	-0.181237419098,-0.181861947604,-0.182486406270,-0.183110792709,-0.183735104551,
	-0.184359339444,-0.184983495056,-0.185607569069,-0.186231559188,-0.186855463132,
	-0.187479278639,-0.188103003463,-0.188726635378,-0.189350172172,-0.189973611652,
	-0.190596951642,-0.191220189983,-0.191843324530,-0.192466353158,-0.193089273756,
	-0.193712084232,-0.194334782507,-0.194957366521,-0.195579834227,-0.196202183597,
	-0.196824412617,-0.197446519289,-0.198068501630,-0.198690357674,-0.199312085468,
	-0.199933683075,-0.200555148575,-0.201176480061,-0.201797675641,-0.202418733439,
	-0.203039651591,-0.203660428251,-0.204281061585,-0.204901549775,-0.205521891015,
	-0.206142083516,-0.206762125501,-0.207382015207,-0.208001750887,-0.208621330804,
	-0.209240753238,-0.209860016481,-0.210479118840,-0.211098058632,-0.211716834191,
	-0.212335443861,-0.212953886003,-0.213572158986,-0.214190261196,-0.214808191030,
	-0.215425946898,-0.216043527223,-0.216660930439,-0.217278154994,-0.217895199348,
	-0.218512061974,-0.219128741354,-0.219745235986,-0.220361544379,-0.220977665051,
	-0.221593596536,-0.222209337377,-0.222824886129,-0.223440241361,-0.224055401649,
	-0.224670365584,-0.225285131767,-0.225899698811,-0.226514065339,-0.227128229986,
	-0.227742191397,-0.228355948229,-0.228969499151,-0.229582842838,-0.230195977982,
	-0.230808903281,-0.231421617444,-0.232034119194,-0.232646407260,-0.233258480383,
	-0.233870337316,-0.234481976820,-0.235093397665,-0.235704598635,-0.236315578521,
	-0.236926336123,-0.237536870254,-0.238147179734,-0.238757263395,-0.239367120076,
	-0.239976748627,-0.240586147907,-0.241195316786,-0.241804254140,-0.242412958858,
	-0.243021429836,-0.243629665979,-0.244237666202,-0.244845429428,-0.245452954591,
	-0.246060240630,-0.246667286497,-0.247274091151,-0.247880653558,-0.248486972696,
	-0.249093047548,-0.249698877109,-0.250304460380,-0.250909796370,-0.251514884099,
	-0.252119722592,-0.252724310885,-0.253328648021,-0.253932733050,-0.254536565031,
	-0.255140143032,-0.255743466127,-0.256346533399,-0.256949343939,-0.257551896844,
	-0.258154191221,-0.258756226182,-0.259358000850,-0.259959514353,-0.260560765827,
	-0.261161754414,-0.261762479267,-0.262362939543,-0.262963134407,-0.263563063033,
	-0.264162724599,-0.264762118292,-0.265361243307,-0.265960098844,-0.266558684112,
	-0.267156998323,-0.267755040701,-0.268352810473,-0.268950306874,-0.269547529146,
	-0.270144476538,-0.270741148304,-0.271337543706,-0.271933662012,-0.272529502496,
	-0.273125064440,-0.273720347130,-0.274315349860,-0.274910071931,-0.275504512647,
	-0.276098671322,-0.276692547273,-0.277286139826,-0.277879448311,-0.278472472064,
	-0.279065210429,-0.279657662752,-0.280249828390,-0.280841706702,-0.281433297053,
	-0.282024598817,-0.282615611369,-0.283206334095,-0.283796766381,-0.284386907623,
	-0.284976757220,-0.285566314578,-0.286155579108,-0.286744550226,-0.287333227354,
	-0.287921609919,-0.288509697353,-0.289097489095,-0.289684984586,-0.290272183276,
	-0.290859084617,-0.291445688068,-0.292031993093,-0.292617999159,-0.293203705742,
	-0.293789112318,-0.294374218373,-0.294959023393,-0.295543526874,-0.296127728312,
	-0.296711627211,-0.297295223079,-0.297878515427,-0.298461503774,-0.299044187642,
	-0.299626566556,-0.300208640048,-0.300790407653,-0.301371868912,-0.301953023370,
	-0.302533870576,-0.303114410083,-0.303694641450,-0.304274564239,-0.304854178016,
	-0.305433482354,-0.306012476827,-0.306591161015,-0.307169534502,-0.307747596876,
	-0.308325347729,-0.308902786658,-0.309479913263,-0.310056727149,-0.310633227924,
	-0.311209415201,-0.311785288597,-0.312360847732,-0.312936092230,-0.313511021721,
	-0.314085635836,-0.314659934211,-0.315233916487,-0.315807582307,-0.316380931319,
	-0.316953963174,-0.317526677526,-0.318099074036,-0.318671152364,-0.319242912176,
	-0.319814353144,-0.320385474938,-0.320956277237,-0.321526759720,-0.322096922070,
	-0.322666763976,-0.323236285128,-0.323805485220,-0.324374363949,-0.324942921016,
	-0.325511156126,-0.326079068985,-0.326646659306,-0.327213926801,-0.327780871188,
	-0.328347492188,-0.328913789525,-0.329479762926,-0.330045412120,-0.330610736842,
	-0.331175736827,-0.331740411815,-0.332304761550,-0.332868785775,-0.333432484241,
	-0.333995856699,-0.334558902904,-0.335121622613,-0.335684015587,-0.336246081589,
	-0.336807820387,-0.337369231749,-0.337930315447,-0.338491071257,-0.339051498956,
	-0.339611598326,-0.340171369149,-0.340730811211,-0.341289924303,-0.341848708215,
	-0.342407162741,-0.342965287680,-0.343523082830,-0.344080547994,-0.344637682977,
	-0.345194487586,-0.345750961633,-0.346307104928,-0.346862917289,-0.347418398532,
	-0.347973548478,-0.348528366950,-0.349082853773,-0.349637008775,-0.350190831786,
	-0.350744322638,-0.351297481168,-0.351850307212,-0.352402800611,-0.352954961205,
	-0.353506788840,-0.354058283364,-0.354609444623,-0.355160272472,-0.355710766762,
	-0.356260927350,-0.356810754094,-0.357360246855,-0.357909405495,-0.358458229879,
	-0.359006719874,-0.359554875349,-0.360102696176,-0.360650182227,-0.361197333379,
	-0.361744149509,-0.362290630497,-0.362836776225,-0.363382586576,-0.363928061436,
	-0.364473200694,-0.365018004239,-0.365562471963,-0.366106603760,-0.366650399526,
	-0.367193859158,-0.367736982557,-0.368279769624,-0.368822220263,-0.369364334379,
	-0.369906111879,-0.370447552673,-0.370988656672,-0.371529423789,-0.372069853939,
	-0.372609947037,-0.373149703003,-0.373689121757,-0.374228203220,-0.374766947316,
	-0.375305353971,-0.375843423112,-0.376381154668,-0.376918548570,-0.377455604749,
	-0.377992323140,-0.378528703679,-0.379064746303,-0.379600450950,-0.380135817562,
	-0.380670846081,-0.381205536451,-0.381739888617,-0.382273902526,-0.382807578128,
	-0.383340915371,-0.383873914209,-0.384406574594,-0.384938896481,-0.385470879827,
	-0.386002524590,-0.386533830729,-0.387064798205,-0.387595426981,-0.388125717019,
	-0.388655668287,-0.389185280749,-0.389714554376,-0.390243489135,-0.390772085000,
	-0.391300341940,-0.391828259932,-0.392355838950,-0.392883078970,-0.393409979971,
	-0.393936541932,-0.394462764834,-0.394988648658,-0.395514193389,-0.396039399011,
	-0.396564265509,-0.397088792872,-0.397612981087,-0.398136830145,-0.398660340037,
	-0.399183510755,-0.399706342293,-0.400228834645,-0.400750987809,-0.401272801781,
	-0.401794276559,-0.402315412145,-0.402836208538,-0.403356665741,-0.403876783757,
	-0.404396562591,-0.404916002248,-0.405435102736,-0.405953864062,-0.406472286235,
	-0.406990369266,-0.407508113166,-0.408025517948,-0.408542583625,-0.409059310212,
	-0.409575697725,-0.410091746180,-0.410607455596,-0.411122825992,-0.411637857387,
	-0.412152549803,-0.412666903263,-0.413180917788,-0.413694593405,-0.414207930136,
	-0.414720928011,-0.415233587054,-0.415745907295,-0.416257888763,-0.416769531488,
	-0.417280835501,-0.417791800836,-0.418302427523,-0.418812715599,-0.419322665098,
	-0.419832276056,-0.420341548510,-0.420850482497,-0.421359078057,-0.421867335230,
	-0.422375254055,-0.422882834575,-0.423390076832,-0.423896980869,-0.424403546730,
	-0.424909774460,-0.425415664106,-0.425921215714,-0.426426429332,-0.426931305008,
	-0.427435842791,-0.427940042732,-0.428443904882,-0.428947429293,-0.429450616016,
	-0.429953465107,-0.430455976618,-0.430958150605,-0.431459987123,-0.431961486231,
	-0.432462647984,-0.432963472441,-0.433463959661,-0.433964109704,-0.434463922630,
	-0.434963398500,-0.435462537377,-0.435961339324,-0.436459804403,-0.436957932679,
	-0.437455724216,-0.437953179082,-0.438450297341,-0.438947079061,-0.439443524310,
	-0.439939633156,-0.440435405668,-0.440930841917,-0.441425941972,-0.441920705906,
	-0.442415133790,-0.442909225696,-0.443402981698,-0.443896401869,-0.444389486285,
	-0.444882235021,-0.445374648152,-0.445866725754,-0.446358467906,-0.446849874684,
	-0.447340946167,-0.447831682435,-0.448322083566,-0.448812149641,-0.449301880740,
	-0.449791276946,-0.450280338341,-0.450769065006,-0.451257457025,-0.451745514482,
	-0.452233237461,-0.452720626048,-0.453207680327,-0.453694400386,-0.454180786309,
	-0.454666838186,-0.455152556103,-0.455637940149,-0.456122990413,-0.456607706984,
	-0.457092089952,-0.457576139408,-0.458059855442,-0.458543238146,-0.459026287613,
	-0.459509003935,-0.459991387204,-0.460473437515,-0.460955154962,-0.461436539638,
	-0.461917591641,-0.462398311064,-0.462878698004,-0.463358752558,-0.463838474823,
	-0.464317864895,-0.464796922875,-0.465275648859,-0.465754042947,-0.466232105238,
	-0.466709835832,-0.467187234830,-0.467664302332,-0.468141038439,-0.468617443254,
	-0.469093516878,-0.469569259414,-0.470044670966,-0.470519751636,-0.470994501528,
	-0.471468920747,-0.471943009397,-0.472416767585,-0.472890195414,-0.473363292992,
	-0.473836060424,-0.474308497818,-0.474780605281,-0.475252382920,-0.475723830843,
	-0.476194949160,-0.476665737978,-0.477136197406,-0.477606327556,-0.478076128536,
	-0.478545600456,-0.479014743428,-0.479483557563,-0.479952042972,-0.480420199767,
	-0.480888028060,-0.481355527965,-0.481822699592,-0.482289543057,-0.482756058473,
	-0.483222245953,-0.483688105613,-0.484153637566,-0.484618841928,-0.485083718815,
	-0.485548268341,-0.486012490624,-0.486476385778,-0.486939953923,-0.487403195173,
	-0.487866109647,-0.488328697462,-0.488790958737,-0.489252893589,-0.489714502138,
	-0.490175784501,-0.490636740800,-0.491097371153,-0.491557675680,-0.492017654501,
	-0.492477307737,-0.492936635508,-0.493395637936,-0.493854315143,-0.494312667248,
	-0.494770694376,-0.495228396648,-0.495685774186,-0.496142827113,-0.496599555553,
	-0.497055959628,-0.497512039463,-0.497967795181,-0.498423226907,-0.498878334765,
	-0.499333118879,-0.499787579375,-0.500241716378,-0.500695530014,-0.501149020407,
	-0.501602187685,-0.502055031974,-0.502507553399,-0.502959752089,-0.503411628169,
	-0.503863181767,-0.504314413011,-0.504765322028,-0.505215908947,-0.505666173895,
	-0.506116117001,-0.506565738394,-0.507015038203,-0.507464016556,-0.507912673584,
	-0.508361009416,-0.508809024181,-0.509256718010,-0.509704091033,-0.510151143380,
	-0.510597875183,-0.511044286572,-0.511490377678,-0.511936148633,-0.512381599568,
	-0.512826730614,-0.513271541905,-0.513716033572,-0.514160205747,-0.514604058564,
	-0.515047592154,-0.515490806651,-0.515933702188,-0.516376278898,-0.516818536915,
	-0.517260476373,-0.517702097405,-0.518143400146,-0.518584384730,-0.519025051292,
	-0.519465399965,-0.519905430886,-0.520345144188,-0.520784540008,-0.521223618481,
	-0.521662379741,-0.522100823926,-0.522538951170,-0.522976761610,-0.523414255382,
	-0.523851432623,-0.524288293469,-0.524724838057,-0.525161066523,-0.525596979005,
	-0.526032575640,-0.526467856566,-0.526902821919,-0.527337471838,-0.527771806461,
	-0.528205825925,-0.528639530369,-0.529072919930,-0.529505994748,-0.529938754961,
	-0.530371200707,-0.530803332126,-0.531235149357,-0.531666652538,-0.532097841809,
	-0.532528717310,-0.532959279180,-0.533389527559,-0.533819462586,-0.534249084402,
	-0.534678393147,-0.535107388961,-0.535536071984,-0.535964442358,-0.536392500222,
	-0.536820245717,-0.537247678984,-0.537674800165,-0.538101609400,-0.538528106830,
	-0.538954292598,-0.539380166844,-0.539805729711,-0.540230981339,-0.540655921871,
	-0.541080551449,-0.541504870215,-0.541928878311,-0.542352575879,-0.542775963061,
	-0.543199040002,-0.543621806842,-0.544044263724,-0.544466410792,-0.544888248189,
	-0.545309776057,-0.545730994540,-0.546151903780,-0.546572503923,-0.546992795109,
	-0.547412777485,-0.547832451192,-0.548251816375,-0.548670873177,-0.549089621743,
	-0.549508062217,-0.549926194743,-0.550344019464,-0.550761536526,-0.551178746072,
	-0.551595648248,-0.552012243197,-0.552428531065,-0.552844511997,-0.553260186136,
	-0.553675553628,-0.554090614618,-0.554505369252,-0.554919817673,-0.555333960028,
	-0.555747796463,-0.556161327121,-0.556574552149,-0.556987471693,-0.557400085897,
	-0.557812394908,-0.558224398872,-0.558636097934,-0.559047492241,-0.559458581938,
	-0.559869367171,-0.560279848087,-0.560690024832,-0.561099897552,-0.561509466394,
	-0.561918731503,-0.562327693027,-0.562736351112,-0.563144705905,-0.563552757552,
	-0.563960506200,-0.564367951996,-0.564775095086,-0.565181935619,-0.565588473740,
	-0.565994709597,-0.566400643336,-0.566806275106,-0.567211605053,-0.567616633325,
	-0.568021360069,-0.568425785432,-0.568829909562,-0.569233732606,-0.569637254713,
	-0.570040476028,-0.570443396701,-0.570846016879,-0.571248336709,-0.571650356340,
	-0.572052075919,-0.572453495594,-0.572854615514,-0.573255435826,-0.573655956678,
	-0.574056178218,-0.574456100595,-0.574855723956,-0.575255048451,-0.575654074227,
	-0.576052801432,-0.576451230215,-0.576849360724,-0.577247193108,-0.577644727515,
	-0.578041964094,-0.578438902993,-0.578835544360,-0.579231888346,-0.579627935097,
	-0.580023684763,-0.580419137493,-0.580814293435,-0.581209152738,-0.581603715551,
	-0.581997982023,-0.582391952303,-0.582785626540,-0.583179004882,-0.583572087478,
	-0.583964874479,-0.584357366032,-0.584749562287,-0.585141463393,-0.585533069498,
	-0.585924380754,-0.586315397307,-0.586706119308,-0.587096546907,-0.587486680251,
	-0.587876519490,-0.588266064774,-0.588655316253,-0.589044274075,-0.589432938390,
	-0.589821309348,-0.590209387097,-0.590597171788,-0.590984663569,-0.591371862590,
	-0.591758769001,-0.592145382952,-0.592531704591,-0.592917734069,-0.593303471534,
	-0.593688917137,-0.594074071028,-0.594458933355,-0.594843504269,-0.595227783919,
	-0.595611772455,-0.595995470026,-0.596378876783,-0.596761992875,-0.597144818451,
	-0.597527353662,-0.597909598658,-0.598291553587,-0.598673218601,-0.599054593848,
	-0.599435679478,-0.599816475642,-0.600196982489,-0.600577200169,-0.600957128832,
	-0.601336768628,-0.601716119706,-0.602095182217,-0.602473956310,-0.602852442135,
	-0.603230639842,-0.603608549581,-0.603986171503,-0.604363505756,-0.604740552491,
	-0.605117311857,-0.605493784006,-0.605869969085,-0.606245867246,-0.606621478639,
	-0.606996803413,-0.607371841718,-0.607746593705,-0.608121059522,-0.608495239321,
	-0.608869133251,-0.609242741462,-0.609616064104,-0.609989101326,-0.610361853280,
	-0.610734320114,-0.611106501979,-0.611478399025,-0.611850011401,-0.612221339258,
	-0.612592382745,-0.612963142013,-0.613333617211,-0.613703808489,-0.614073715997,
	-0.614443339886,-0.614812680304,-0.615181737402,-0.615550511330,-0.615919002238,
	-0.616287210275,-0.616655135592,-0.617022778337,-0.617390138662,-0.617757216716,
	-0.618124012649,-0.618490526611,-0.618856758751,-0.619222709219,-0.619588378166,
	-0.619953765740,-0.620318872092,-0.620683697372,-0.621048241729,-0.621412505313,
	-0.621776488274,-0.622140190762,-0.622503612925,-0.622866754915,-0.623229616880,
	-0.623592198971,-0.623954501337,-0.624316524128,-0.624678267493,-0.625039731582,
	-0.625400916545,-0.625761822531,-0.626122449690,-0.626482798171,-0.626842868124,
	-0.627202659699,-0.627562173045,-0.627921408312,-0.628280365649,-0.628639045206,
	-0.628997447131,-0.629355571576,-0.629713418688,-0.630070988618,-0.630428281514,
	-0.630785297527,-0.631142036805,-0.631498499499,-0.631854685757,-0.632210595728,
	-0.632566229562,-0.632921587408,-0.633276669416,-0.633631475735,-0.633986006513,
	-0.634340261901,-0.634694242047,-0.635047947100,-0.635401377210,-0.635754532525,
	-0.636107413196,-0.636460019370,-0.636812351197,-0.637164408826,-0.637516192406,
	-0.637867702086,-0.638218938015,-0.638569900342,-0.638920589215,-0.639271004784,
	-0.639621147198,-0.639971016605,-0.640320613154,-0.640669936994,-0.641018988274,
	-0.641367767143,-0.641716273749,-0.642064508240,-0.642412470767,-0.642760161476,
	-0.643107580518,-0.643454728039,-0.643801604190,-0.644148209119,-0.644494542974,
	-0.644840605903,-0.645186398055,-0.645531919579,-0.645877170623,-0.646222151335,
	-0.646566861864,-0.646911302358,-0.647255472965,-0.647599373834,-0.647943005113,
	-0.648286366949,-0.648629459492,-0.648972282889,-0.649314837289,-0.649657122839,
	-0.649999139688,-0.650340887984,-0.650682367875,-0.651023579508,-0.651364523032,
	-0.651705198595,-0.652045606344,-0.652385746427,-0.652725618993,-0.653065224189,
	-0.653404562162,-0.653743633061,-0.654082437033,-0.654420974226,-0.654759244787,
	-0.655097248865,-0.655434986606,-0.655772458159,-0.656109663670,-0.656446603288,
	-0.656783277159,-0.657119685432,-0.657455828253,-0.657791705769,-0.658127318129,
	-0.658462665480,-0.658797747968,-0.659132565741,-0.659467118946,-0.659801407730,
	-0.660135432240,-0.660469192625,-0.660802689029,-0.661135921601,-0.661468890487,
	-0.661801595835,-0.662134037791,-0.662466216502,-0.662798132116,-0.663129784778,
	-0.663461174635,-0.663792301835,-0.664123166524,-0.664453768848,-0.664784108955,
	-0.665114186990,-0.665444003101,-0.665773557434,-0.666102850135,-0.666431881350,
	-0.666760651227,-0.667089159912,-0.667417407550,-0.667745394288,-0.668073120273,
	-0.668400585650,-0.668727790566,-0.669054735167,-0.669381419599,-0.669707844008,
	-0.670034008540,-0.670359913341,-0.670685558557,-0.671010944334,-0.671336070817,
	-0.671660938153,-0.671985546487,-0.672309895966,-0.672633986734,-0.672957818938,
	-0.673281392723,-0.673604708234,-0.673927765618,-0.674250565019,-0.674573106584,
	-0.674895390457,-0.675217416784,-0.675539185710,-0.675860697381,-0.676181951942,
	-0.676502949538,-0.676823690315,-0.677144174416,-0.677464401989,-0.677784373177,
	-0.678104088125,-0.678423546980,-0.678742749884,-0.679061696984,-0.679380388425,
	-0.679698824350,-0.680017004906,-0.680334930236,-0.680652600485,-0.680970015798,
	-0.681287176319,-0.681604082194,-0.681920733566,-0.682237130580,-0.682553273381,
	-0.682869162112,-0.683184796919,-0.683500177945,-0.683815305335,-0.684130179233,
	-0.684444799783,-0.684759167129,-0.685073281415,-0.685387142786,-0.685700751385,
	-0.686014107356,-0.686327210844,-0.686640061992,-0.686952660943,-0.687265007842,
	-0.687577102833,-0.687888946058,-0.688200537662,-0.688511877789,-0.688822966581,
	-0.689133804183,-0.689444390737,-0.689754726388,-0.690064811278,-0.690374645551,
	-0.690684229350,-0.690993562819,-0.691302646100,-0.691611479337,-0.691920062673,
	-0.692228396251,-0.692536480214,-0.692844314704,-0.693151899865,-0.693459235840,
	-0.693766322771,-0.694073160802,-0.694379750074,-0.694686090731,-0.694992182916,
	-0.695298026770,-0.695603622437,-0.695908970058,-0.696214069777,-0.696518921735,
	-0.696823526076,-0.697127882941,-0.697431992473,-0.697735854813,-0.698039470105,
	-0.698342838489,-0.698645960109,-0.698948835107,-0.699251463623,-0.699553845801,
	-0.699855981781,-0.700157871707,-0.700459515719,-0.700760913959,-0.701062066570,
	-0.701362973692,-0.701663635468,-0.701964052038,-0.702264223545,-0.702564150129,
	-0.702863831933,-0.703163269097,-0.703462461763,-0.703761410072,-0.704060114166,
	-0.704358574185,-0.704656790270,-0.704954762563,-0.705252491205,-0.705549976336,
	-0.705847218098,-0.706144216631,-0.706440972077,-0.706737484575,-0.707033754267,
	-0.707329781293,-0.707625565794,-0.707921107910,-0.708216407783,-0.708511465552,
	-0.708806281358,-0.709100855341,-0.709395187642,-0.709689278400,-0.709983127756,
	-0.710276735851,-0.710570102824,-0.710863228815,-0.711156113965,-0.711448758413,
	-0.711741162300,-0.712033325764,-0.712325248947,-0.712616931987,-0.712908375024,
	-0.713199578199,-0.713490541650,-0.713781265518,-0.714071749941,-0.714361995059,
	-0.714652001012,-0.714941767939,-0.715231295980,-0.715520585272,-0.715809635957,
	-0.716098448172,-0.716387022057,-0.716675357752,-0.716963455394,-0.717251315123,
	-0.717538937078,-0.717826321398,-0.718113468221,-0.718400377687,-0.718687049933,
	-0.718973485099,-0.719259683323,-0.719545644744,-0.719831369499,-0.720116857728,
	-0.720402109569,-0.720687125161,-0.720971904641,-0.721256448147,-0.721540755819,
	-0.721824827793,-0.722108664208,-0.722392265203,-0.722675630914,-0.722958761481,
	-0.723241657040,-0.723524317730,-0.723806743688,-0.724088935052,-0.724370891959,
	-0.724652614548,-0.724934102955,-0.725215357319,-0.725496377777,-0.725777164465,
	-0.726057717522,-0.726338037084,-0.726618123289,-0.726897976274,-0.727177596176,
	-0.727456983133,-0.727736137280,-0.728015058756,-0.728293747696,-0.728572204239,
	-0.728850428519,-0.729128420676,-0.729406180844,-0.729683709161,-0.729961005763,
	-0.730238070787,-0.730514904369,-0.730791506645,-0.731067877753,-0.731344017828,
	-0.731619927006,-0.731895605424,-0.732171053218,-0.732446270523,-0.732721257477,
	-0.732996014214,-0.733270540872,-0.733544837585,-0.733818904490,-0.734092741722,
	-0.734366349417,-0.734639727710,-0.734912876738,-0.735185796635,-0.735458487538,
	-0.735730949582,-0.736003182902,-0.736275187633,-0.736546963910,-0.736818511870,
	-0.737089831646,-0.737360923375,-0.737631787191,-0.737902423229,-0.738172831624,
	-0.738443012512,-0.738712966026,-0.738982692301,-0.739252191473,-0.739521463676,
	-0.739790509045,-0.740059327714,-0.740327919817,-0.740596285489,-0.740864424865,
	-0.741132338079,-0.741400025265,-0.741667486557,-0.741934722090,-0.742201731997,
	-0.742468516413,-0.742735075471,-0.743001409306,-0.743267518051,-0.743533401841,
	-0.743799060809,-0.744064495088,-0.744329704813,-0.744594690117,-0.744859451134,
	-0.745123987997,-0.745388300839,-0.745652389794,-0.745916254996,-0.746179896577,
	-0.746443314671,-0.746706509410,-0.746969480929,-0.747232229359,-0.747494754835,
	-0.747757057489,-0.748019137453,-0.748280994862,-0.748542629846,-0.748804042540,
	-0.749065233076,-0.749326201586,-0.749586948203,-0.749847473059,-0.750107776287,
	-0.750367858020,-0.750627718389,-0.750887357526,-0.751146775565,-0.751405972637,
	-0.751664948874,-0.751923704408,-0.752182239372,-0.752440553897,-0.752698648114,
	-0.752956522157,-0.753214176156,-0.753471610243,-0.753728824551,-0.753985819209,
	-0.754242594351,-0.754499150107,-0.754755486609,-0.755011603988,-0.755267502376,
	-0.755523181903,-0.755778642701,-0.756033884901,-0.756288908634,-0.756543714031,
	-0.756798301224,-0.757052670342,-0.757306821517,-0.757560754879,-0.757814470560,
	-0.758067968689,-0.758321249398,-0.758574312817,-0.758827159077,-0.759079788307,
	-0.759332200639,-0.759584396202,-0.759836375127,-0.760088137545,-0.760339683584,
	-0.760591013376,-0.760842127050,-0.761093024737,-0.761343706566,-0.761594172667,
	-0.761844423169,-0.762094458204,-0.762344277899,-0.762593882386,-0.762843271793,
	-0.763092446249,-0.763341405886,-0.763590150831,-0.763838681214,-0.764086997165,
	-0.764335098812,-0.764582986285,-0.764830659713,-0.765078119225,-0.765325364950,
	-0.765572397017,-0.765819215554,-0.766065820691,-0.766312212556,-0.766558391278,
	-0.766804356985,-0.767050109807,-0.767295649872,-0.767540977307,-0.767786092242,
	-0.768030994805,-0.768275685124,-0.768520163328,-0.768764429544,-0.769008483901,
	-0.769252326526,-0.769495957548,-0.769739377095,-0.769982585294,-0.770225582274,
	-0.770468368161,-0.770710943085,-0.770953307171,-0.771195460549,-0.771437403345,
	-0.771679135688,-0.771920657703,-0.772161969519,-0.772403071264,-0.772643963063,
	-0.772884645045,-0.773125117337,-0.773365380064,-0.773605433356,-0.773845277338,
	-0.774084912137,-0.774324337881,-0.774563554695,-0.774802562707,-0.775041362044,
	-0.775279952831,-0.775518335195,-0.775756509264,-0.775994475162,-0.776232233017,
	-0.776469782955,-0.776707125102,-0.776944259585,-0.777181186528,-0.777417906059,
	-0.777654418303,-0.777890723387,-0.778126821436,-0.778362712576,-0.778598396932,
	-0.778833874631,-0.779069145798,-0.779304210559,-0.779539069038,-0.779773721363,
	-0.780008167657,-0.780242408046,-0.780476442657,-0.780710271613,-0.780943895039,
	-0.781177313062,-0.781410525807,-0.781643533397,-0.781876335958,-0.782108933615,
	-0.782341326492,-0.782573514715,-0.782805498408,-0.783037277696,-0.783268852703,
	-0.783500223553,-0.783731390372,-0.783962353284,-0.784193112412,-0.784423667881,
	-0.784654019816,-0.784884168340,-0.785114113578,-0.785343855653,-0.785573394690,
	-0.785802730812,-0.786031864144,-0.786260794808,-0.786489522930,-0.786718048632,
	-0.786946372038,-0.787174493271,-0.787402412456,-0.787630129715,-0.787857645172,
	-0.788084958950,-0.788312071172,-0.788538981962,-0.788765691443,-0.788992199738,
	-0.789218506969,-0.789444613260,-0.789670518734,-0.789896223513,-0.790121727720,
	-0.790347031478,-0.790572134909,-0.790797038137,-0.791021741283,-0.791246244471,
	-0.791470547822,-0.791694651458,-0.791918555503,-0.792142260078,-0.792365765305,
	-0.792589071308,-0.792812178206,-0.793035086123,-0.793257795181,-0.793480305501,
	-0.793702617206,-0.793924730416,-0.794146645253,-0.794368361840,-0.794589880298,
	-0.794811200748,-0.795032323311,-0.795253248110,-0.795473975264,-0.795694504897,
	-0.795914837128,-0.796134972079,-0.796354909871,-0.796574650625,-0.796794194462,
	-0.797012525336,-0.797229485267,-0.797445523768,-0.797660769987,-0.797875293613,
	-0.798089139394,-0.798302338859,-0.798514915575,-0.798726887905,-0.798938270608,
	-0.799149075837,-0.799359313801,-0.799568993215,-0.799778121625,-0.799986705640,
	-0.800194751112,-0.800402263271,-0.800609246830,-0.800815706064,-0.801021644884,
	-0.801227066884,-0.801431975389,-0.801636373489,-0.801840264070,-0.802043649839,
	-0.802246533348,-0.802448917006,-0.802650803103,-0.802852193816,-0.803053091223,
	-0.803253497317,-0.803453414007,-0.803652843132,-0.803851786467,-0.804050245724,
	-0.804248222565,-0.804445718599,-0.804642735392,-0.804839274468,-0.805035337312,
	-0.805230925375,-0.805426040073,-0.805620682796,-0.805814854902,-0.806008557726,
	-0.806201792578,-0.806394560745,-0.806586863494,-0.806778702072,-0.806970077708,
	-0.807160991615,-0.807351444987,-0.807541439006,-0.807730974839,-0.807920053639,
	-0.808108676548,-0.808296844694,-0.808484559195,-0.808671821160,-0.808858631686,
	-0.809044991862,-0.809230902766,-0.809416365470,-0.809601381036,-0.809785950521,
	-0.809970074971,-0.810153755429,-0.810336992928,-0.810519788498,-0.810702143160,
	-0.810884057931,-0.811065533823,-0.811246571841,-0.811427172987,-0.811607338256,
	-0.811787068640,-0.811966365127,-0.812145228700,-0.812323660337,-0.812501661013,
	-0.812679231701,-0.812856373367,-0.813033086976,-0.813209373489,-0.813385233862,
	-0.813560669052,-0.813735680008,-0.813910267680,-0.814084433012,-0.814258176949,
	-0.814431500429,-0.814604404390,-0.814776889768,-0.814948957495,-0.815120608500,
	-0.815291843713,-0.815462664057,-0.815633070456,-0.815803063831,-0.815972645101,
	-0.816141815183,-0.816310574991,-0.816478925439,-0.816646867436,-0.816814401892,
	-0.816981529712,-0.817148251804,-0.817314569068,-0.817480482407,-0.817645992721,
	-0.817811100906,-0.817975807858,-0.818140114473,-0.818304021642,-0.818467530256,
	-0.818630641204,-0.818793355374,-0.818955673651,-0.819117596919,-0.819279126062,
	-0.819440261960,-0.819601005491,-0.819761357535,-0.819921318966,-0.820080890660,
	-0.820240073489,-0.820398868324,-0.820557276036,-0.820715297492,-0.820872933560,
	-0.821030185104,-0.821187052988,-0.821343538073,-0.821499641221,-0.821655363290,
	-0.821810705137,-0.821965667619,-0.822120251589,-0.822274457900,-0.822428287404,
	-0.822581740950,-0.822734819386,-0.822887523559,-0.823039854314,-0.823191812493,
	-0.823343398940,-0.823494614494,-0.823645459994,-0.823795936277,-0.823946044179,
	-0.824095784534,-0.824245158175,-0.824394165932,-0.824542808634,-0.824691087111,
	-0.824839002187,-0.824986554687,-0.825133745435,-0.825280575252,-0.825427044957,
	-0.825573155369,-0.825718907305,-0.825864301579,-0.826009339005,-0.826154020395,
	-0.826298346558,-0.826442318304,-0.826585936440,-0.826729201770,-0.826872115098,
	-0.827014677226,-0.827156888955,-0.827298751083,-0.827440264407,-0.827581429724,
	-0.827722247825,-0.827862719504,-0.828002845551,-0.828142626755,-0.828282063902,
	-0.828421157779,-0.828559909168,-0.828698318852,-0.828836387611,-0.828974116223,
	-0.829111505467,-0.829248556116,-0.829385268944,-0.829521644724,-0.829657684224,
	-0.829793388215,-0.829928757461,-0.830063792729,-0.830198494782,-0.830332864380,
	-0.830466902284,-0.830600609252,-0.830733986039,-0.830867033402,-0.830999752092,
	-0.831132142861,-0.831264206457,-0.831395943629,-0.831527355122,-0.831658441681,
	-0.831789204048,-0.831919642963,-0.832049759166,-0.832179553393,-0.832309026379,
	-0.832438178859,-0.832567011564,-0.832695525224,-0.832823720568,-0.832951598322,
	-0.833079159210,-0.833206403956,-0.833333333281
	}
};

double always_inline bigchumppreclip(double x) {
    double f = fabs(x);
    f = f * bigchumppre_table.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = bigchumppre_table.data[0];
    } else if (i >= bigchumppre_table.size-1) {
        f = bigchumppre_table.data[bigchumppre_table.size-1];
    } else {
    f -= i;
    f = bigchumppre_table.data[i]*(1-f) + bigchumppre_table.data[i+1]*f;
    }
    return copysign(f, x);
}

#endif //_BIGCHUMPPRE_H_
