/* A Bison parser, made by GNU Bison 3.7.5.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30705

/* Bison version string.  */
#define YYBISON_VERSION "3.7.5"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 28 "parser.y"

#include "config.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#ifdef	HAVE_STRINGS_H
#include <strings.h>
#endif

#define	COB_IN_PARSER	1
#include "cobc.h"
#include "tree.h"
#include "libcob/coblocal.h"

#define _PARSER_H	/* work around bad Windows SDK header */

#ifndef	_STDLIB_H
#define	_STDLIB_H 1
#endif

#define YYSTYPE			cb_tree
#define yyerror(x)		cb_error_always ("%s", x)

#define push_expr(type, node) \
  current_expr = cb_build_list (cb_int (type), node, current_expr)

/* Statement terminator definitions */
#define TERM_NONE		0
#define TERM_ACCEPT		1U
#define TERM_ADD		2U
#define TERM_CALL		3U
#define TERM_COMPUTE		4U
#define TERM_DELETE		5U
#define TERM_DISPLAY		6U
#define TERM_DIVIDE		7U
#define TERM_EVALUATE		8U
#define TERM_IF			9U
#define TERM_JSON		10U
#define TERM_MODIFY		11U
#define TERM_MULTIPLY		12U
#define TERM_PERFORM		13U
#define TERM_READ		14U
#define TERM_RECEIVE		15U
#define TERM_RETURN		16U
#define TERM_REWRITE		17U
#define TERM_SEARCH		18U
#define TERM_START		19U
#define TERM_STRING		20U
#define TERM_SUBTRACT		21U
#define TERM_UNSTRING		22U
#define TERM_WRITE		23U
#define TERM_XML		24U
#define TERM_MAX		25U	/* Always last entry, used for array size */

#define	TERMINATOR_WARNING(x,z)	terminator_warning (x, TERM_##z, #z)
#define	TERMINATOR_ERROR(x,z)	terminator_error (x, TERM_##z, #z)
#define	TERMINATOR_CLEAR(x,z)	terminator_clear (x, TERM_##z)

/* Defines for duplicate checks */
/* Note - We use <= 16 for common item definitions and */
/* > 16 for non-common item definitions e.g. REPORT and SCREEN */
#define	SYN_CLAUSE_1		(1U << 0)
#define	SYN_CLAUSE_2		(1U << 1)
#define	SYN_CLAUSE_3		(1U << 2)
#define	SYN_CLAUSE_4		(1U << 3)
#define	SYN_CLAUSE_5		(1U << 4)
#define	SYN_CLAUSE_6		(1U << 5)
#define	SYN_CLAUSE_7		(1U << 6)
#define	SYN_CLAUSE_8		(1U << 7)
#define	SYN_CLAUSE_9		(1U << 8)
#define	SYN_CLAUSE_10		(1U << 9)
#define	SYN_CLAUSE_11		(1U << 10)
#define	SYN_CLAUSE_12		(1U << 11)
#define	SYN_CLAUSE_13		(1U << 12)
#define	SYN_CLAUSE_14		(1U << 13)
#define	SYN_CLAUSE_15		(1U << 14)
#define	SYN_CLAUSE_16		(1U << 15)
#define	SYN_CLAUSE_17		(1U << 16)
#define	SYN_CLAUSE_18		(1U << 17)
#define	SYN_CLAUSE_19		(1U << 18)
#define	SYN_CLAUSE_20		(1U << 19)
#define	SYN_CLAUSE_21		(1U << 20)
#define	SYN_CLAUSE_22		(1U << 21)
#define	SYN_CLAUSE_23		(1U << 22)
#define	SYN_CLAUSE_24		(1U << 23)
#define	SYN_CLAUSE_25		(1U << 24)
#define	SYN_CLAUSE_26		(1U << 25)
#define	SYN_CLAUSE_27		(1U << 26)
#define	SYN_CLAUSE_28		(1U << 27)
#define	SYN_CLAUSE_29		(1U << 28)
#define	SYN_CLAUSE_30		(1U << 29)
#define	SYN_CLAUSE_31		(1U << 30)
#define	SYN_CLAUSE_32		(1U << 31)

#define	EVAL_DEPTH		32
#define	PROG_DEPTH		16

/* Global variables */

struct cb_program		*current_program = NULL;    /* program in parse/syntax check/codegen */
struct cb_label			*current_section = NULL;
struct cb_label			*current_paragraph = NULL;
struct cb_statement		*current_statement = NULL;
cb_tree				defined_prog_list = NULL;
int				cb_exp_line = 0;

int				functions_are_all = 0;
int				non_const_word = 0;
int				suppress_data_exceptions = 0;
unsigned int			cobc_repeat_last_token = 0;
unsigned int			cobc_in_id = 0;
unsigned int			cobc_in_procedure = 0;
unsigned int			cobc_in_repository = 0;
unsigned int			cobc_cs_check = 0;
unsigned int			cobc_allow_program_name = 0;
unsigned int			cobc_in_xml_generate_body = 0;
unsigned int			cobc_in_json_generate_body = 0;
unsigned int			cobc_areacheck = 0;
unsigned int			cobc_in_area_a = 0;

/* Local variables */

enum inspect_rep_keyword {
	INSPECT_REP_DEFAULT,
	INSPECT_REP_ALL,
	INSPECT_REP_LEADING,
	INSPECT_REP_FIRST,
	INSPECT_REP_TRAILING,
};

union examine_keyword {
	/* EXAMINE TALLYING/REPLACING options */
	enum {
		EXAMINE_TAL_ALL,
		EXAMINE_TAL_LEADING,
		EXAMINE_TAL_UNTIL_FIRST,
	} tallying;
	enum {
		EXAMINE_REP_ALL,
		EXAMINE_REP_LEADING,
		EXAMINE_REP_FIRST,
		EXAMINE_REP_UNTIL_FIRST,
	} replacing;
};

enum tallying_phrase {
	NO_PHRASE,
	FOR_PHRASE,
	CHARACTERS_PHRASE,
	ALL_LEADING_TRAILING_PHRASES,
	VALUE_REGION_PHRASE
};

enum key_clause_type {
	NO_KEY,
	RECORD_KEY,
	RELATIVE_KEY
};

static cb_tree			current_expr;
static struct cb_field		*current_field;
static struct cb_field		*control_field;
static struct cb_field		*description_field;
static struct cb_file		*current_file;
static struct cb_cd		*current_cd;
static struct cb_report		*current_report;
static struct cb_report		*report_instance;
static struct cb_key_component	*key_component_list;

static struct cb_file		*linage_file;
static cb_tree			next_label_list;

static const char			*stack_progid[PROG_DEPTH];

static enum cb_storage		current_storage;

static cb_tree			perform_stack;
static cb_tree			qualifier;
static cb_tree			keys_list;

static cb_tree			save_tree;
static cb_tree			start_tree;

static unsigned int		check_unreached;
static unsigned int		within_typedef_definition;
static unsigned int		in_declaratives;
static unsigned int		in_debugging;
static unsigned int		current_linage;
static unsigned int		report_count;
static unsigned int		first_prog;
static unsigned int		setup_from_identification;
static unsigned int		use_global_ind;
static unsigned int		same_area;
static enum inspect_rep_keyword	inspect_keyword;
static union examine_keyword	examine_keyword;
static unsigned int		main_flag_set;
static int			next_label_id;
static int			eval_level;
static int			eval_inc;
static int			eval_inc2;
static int			depth;
static int			first_nested_program;
static enum cb_call_mode	call_mode;
static int			size_mode;
static cob_flags_t		set_attr_val_on;
static cob_flags_t		set_attr_val_off;
static cob_flags_t		check_duplicate;
static cob_flags_t		check_on_off_duplicate;
static cob_flags_t		check_pic_duplicate;
static cob_flags_t		check_line_col_duplicate;
static unsigned int		skip_statements;
static unsigned int		start_debug;
static unsigned int		save_debug;
static unsigned int		needs_field_debug;
static unsigned int		needs_debug_item;
static unsigned int		env_div_seen;
static cob_flags_t		header_check;
static unsigned int		call_nothing;
static enum tallying_phrase	previous_tallying_phrase;
static cb_tree			default_rounded_mode;
static enum key_clause_type	key_type;

static int			ext_dyn_specified;
static enum cb_assign_device	assign_device;

static enum cb_display_type	display_type;
static int			is_first_display_item;
static cb_tree			advancing_value;
static cb_tree			upon_value;
static cb_tree			line_column;

static unsigned int		exhibit_changed;
static unsigned int		exhibit_named;

static cb_tree			ml_suppress_list;
static cb_tree			xml_encoding;
static int			with_xml_dec;
static int			with_attrs;

static cb_tree			alphanumeric_collation;
static cb_tree			national_collation;

static enum cb_ml_suppress_category	ml_suppress_category;

static int			term_array[TERM_MAX];
static cb_tree			eval_check[EVAL_DEPTH][EVAL_DEPTH];

static int			last_source_line = 0;

/* Defines for header presence */

#define	COBC_HD_ENVIRONMENT_DIVISION	(1U << 0)
#define	COBC_HD_CONFIGURATION_SECTION	(1U << 1)
#define	COBC_HD_SPECIAL_NAMES		(1U << 2)
#define	COBC_HD_INPUT_OUTPUT_SECTION	(1U << 3)
#define	COBC_HD_FILE_CONTROL		(1U << 4)
#define	COBC_HD_I_O_CONTROL		(1U << 5)
#define	COBC_HD_DATA_DIVISION		(1U << 6)
#define	COBC_HD_FILE_SECTION		(1U << 7)
#define	COBC_HD_WORKING_STORAGE_SECTION	(1U << 8)
#define	COBC_HD_LOCAL_STORAGE_SECTION	(1U << 9)
#define	COBC_HD_LINKAGE_SECTION		(1U << 10)
#define	COBC_HD_COMMUNICATION_SECTION	(1U << 11)
#define	COBC_HD_REPORT_SECTION		(1U << 12)
#define	COBC_HD_SCREEN_SECTION		(1U << 13)
#define	COBC_HD_PROCEDURE_DIVISION	(1U << 14)
#define	COBC_HD_PROGRAM_ID		(1U << 15)
#define	COBC_HD_SOURCE_COMPUTER		(1U << 16)
#define	COBC_HD_OBJECT_COMPUTER		(1U << 17)
#define	COBC_HD_REPOSITORY		(1U << 18)

/* Static functions */

/* Area A enforcement */

static COB_INLINE void
check_area_a (cb_tree word) {
	if (!cobc_in_area_a && cobc_areacheck) {
		(void) cb_syntax_check_x (word, _("'%s' should start in Area A"),
					  CB_NAME (word));
	}
}

static COB_INLINE void
check_area_a_of (const char * const item) {
	if (!cobc_in_area_a && cobc_areacheck) {
		(void) cb_syntax_check (_("%s should start in Area A"), item);
	}
}

static COB_INLINE void
check_non_area_a_of (const char * const item) {
	if (cobc_in_area_a && cobc_areacheck) {
		(void) cb_syntax_check (_("%s should not start in Area A"), item);
	}
}

static COB_INLINE void
check_non_area_a (cb_tree stmt) {
	if (cobc_in_area_a && cobc_areacheck) {
		if (stmt) {
			(void) cb_syntax_check_x (stmt, _("start of statement in Area A"));
		} else {
			(void) cb_syntax_check (_("start of statement in Area A"));
		}
	}
}

/* Collating sequences */

/* Known collating sequences/alphabets */
enum cb_colseq {
	CB_COLSEQ_NATIVE,
	CB_COLSEQ_ASCII,
	CB_COLSEQ_EBCDIC,
};
enum cb_colseq cb_default_colseq = CB_COLSEQ_NATIVE;

/* Decipher character conversion table names */
int cb_deciph_default_colseq_name (const char * const name)
{
	if (!cb_strcasecmp (name, "ASCII")) {
		cb_default_colseq = CB_COLSEQ_ASCII;
	} else if (!cb_strcasecmp (name, "EBCDIC")) {
		cb_default_colseq = CB_COLSEQ_EBCDIC;
	} else if (!cb_strcasecmp (name, "NATIVE")) {
		cb_default_colseq = CB_COLSEQ_NATIVE;
	} else {
		return 1;
	}
	return 0;
}

static cb_tree
build_colseq_tree (const char *alphabet_name,
		      int alphabet_type,
		      int alphabet_target)
{
	const cb_tree name = cb_build_reference (alphabet_name);
	struct cb_alphabet_name * alpha;
	alpha = CB_ALPHABET_NAME (cb_build_alphabet_name (name));
	alpha->alphabet_type = alphabet_type;
	alpha->alphabet_target = alphabet_target;
	return name;
}

static cb_tree
build_colseq (enum cb_colseq colseq)
{
	switch (colseq) {
	case CB_COLSEQ_NATIVE:
		return NULL;
	case CB_COLSEQ_ASCII:
		return build_colseq_tree ("ASCII",
				      CB_ALPHABET_ASCII,
				      CB_ALPHABET_ALPHANUMERIC);
	case CB_COLSEQ_EBCDIC:
		return build_colseq_tree ("EBCDIC",
				      CB_ALPHABET_EBCDIC,
				      CB_ALPHABET_ALPHANUMERIC);
	/* LCOV_EXCL_START */
	default:
		cobc_err_msg (_("call to '%s' with invalid parameter '%s'"),
			"build_colseq", "colseq");
		COBC_ABORT ();
	}
	/* LCOV_EXCL_STOP */

}


/* Statements */

static COB_INLINE COB_A_INLINE void
emit_statement (cb_tree x)
{
	if (!skip_statements) {
		CB_ADD_TO_CHAIN (x, current_program->exec_list);
	}
}

static void
begin_statement_internal (enum cob_statement statement, const unsigned int term,
	const char *file, const int line)
{
	cb_tree stmt_tree;
	current_statement = cb_build_statement (statement);
	current_paragraph->flag_statement = 1;
	stmt_tree = CB_TREE (current_statement);
	stmt_tree->source_file = file;
	stmt_tree->source_line = line;
	current_statement->flag_in_debug = in_debugging;
	emit_statement (stmt_tree);
	if (term) {
		term_array[term]++;
	}
	check_non_area_a (stmt_tree);
	if (check_unreached) {
		cb_warning_x (cb_warn_unreachable, stmt_tree,
			_("unreachable statement '%s'"),
			cb_statement_name[statement]);
	}
}

static COB_INLINE void
begin_statement (enum cob_statement statement, const unsigned int term)
{
	begin_statement_internal (statement, term, cb_source_file, cb_source_line);
}

/* begin statement, starting in "pos";
   note: to be able to check for area A, pos->source_column must be temporarily set to -1
         at the place where the tree is created, if cobc_in_area_a was true */
static COB_INLINE void
begin_statement_at_tree_pos (enum cob_statement statement, const unsigned int term, cb_tree pos)
{
	const int backup_in_area_a = cobc_in_area_a;
	cobc_in_area_a = pos->source_column == -1;
	begin_statement_internal (statement, term, pos->source_file, pos->source_line);
	cobc_in_area_a = backup_in_area_a;
}

/* create a new statement with base attributes of real_statement, the
   location of pos and set this as new current_statement */
static void
begin_implicit_statement (struct cb_statement* real_statement, cb_tree pos)
{
	struct cb_statement	*new_statement;
	new_statement = cb_build_statement (real_statement->statement);
	new_statement->common = current_statement->common;
	new_statement->flag_in_debug = !!in_debugging;
	new_statement->flag_implicit = 1;
	if (pos){
		cb_tree stmt_tree;
		stmt_tree = CB_TREE (new_statement);
		stmt_tree->source_file = pos->source_file;
		stmt_tree->source_line = pos->source_line;
	}
	real_statement->body = cb_list_add (real_statement->body,
					    CB_TREE (new_statement));
	current_statement = new_statement;
}

# if 0 /* activate only for debugging purposes for attribs
	FIXME: Replace by DEBUG_LOG function */
static void
print_bits (cob_flags_t num)
{
	unsigned int 	size = sizeof (cob_flags_t);
	unsigned int	max_pow = 1 << (size * 8 - 1);
	int 		i = 0;

	for(; i < size * 8; ++i){
		/* Print last bit and shift left. */
		fprintf (stderr, "%u ", num & max_pow ? 1 : 0);
		num = num << 1;
	}
	fprintf (stderr, "\n");
}
#endif

/* general functions */

static void
copy_pos (cb_tree item, cb_tree source)
{
	item->source_file = source->source_file;
	item->source_line = source->source_line;
}

static COB_INLINE int
is_valid_statement_tree (cb_tree tree) {
	if ( tree == cb_error_node
	 || (CB_LIST_P (tree) && CB_VALUE (tree) == cb_error_node)) {
		return 0;
	}
	return 1;
}

static void
emit_entry (const char *name, const int encode, cb_tree using_list, cb_tree convention)
{
	cb_tree		l;
	cb_tree		label;
	cb_tree		entry_conv;
	char		buff[COB_MINI_BUFF];

	snprintf (buff, (size_t)COB_MINI_MAX, "E$%s", name);
	label = cb_build_label (cb_build_reference (buff), NULL);
	if (encode) {
		CB_LABEL (label)->name = cb_encode_program_id (name, 0, cb_fold_call);
		CB_LABEL (label)->orig_name = name;
	} else {
		CB_LABEL (label)->name = name;
		CB_LABEL (label)->orig_name = current_program->orig_program_id;
	}
	CB_LABEL (label)->flag_begin = 1;
	CB_LABEL (label)->flag_entry = 1;
	emit_statement (label);

	if (current_program->flag_debugging) {
		emit_statement (cb_build_debug (cb_debug_contents,
						"START PROGRAM", NULL));
	}

	cb_validate_parameters_and_returning (current_program, using_list);

	for (l = current_program->entry_list; l; l = CB_CHAIN (l)) {
		struct cb_label *check = CB_LABEL (CB_PURPOSE (l));
		if (strcmp (name, check->name) == 0) {
			cb_error_x (current_statement
					? CB_TREE (current_statement)
					: CB_TREE (current_program),
				    _("ENTRY '%s' duplicated"), name);
		}
	}

	if (convention) {
		entry_conv = convention;
	} else {
		entry_conv = current_program->entry_convention;
	}

	current_program->entry_list =
		cb_list_append (current_program->entry_list,
				CB_BUILD_PAIR (label, CB_BUILD_PAIR (entry_conv, using_list)));
}

/* Main entry point and the number of its main parameters */
static void
emit_main_entry (struct cb_program *program, cb_tree using_list)
{
	if (using_list) {
		program->num_proc_params = cb_list_length (using_list);
	}

	emit_entry (program->program_id, 0, using_list, NULL);
	if (program->source_name) {
		emit_entry (program->source_name, 1, using_list, NULL);
	}
}

static void
emit_entry_goto (const char *name)
{
	cb_tree		l;
	cb_tree		label;
	char		buff[COB_MINI_BUFF];

	snprintf (buff, (size_t)COB_MINI_MAX, "E$%s", name);
	label = cb_build_label (cb_build_reference (buff), NULL);
	CB_LABEL (label)->name = name;
	CB_LABEL (label)->orig_name = name;
	CB_LABEL (label)->flag_begin = 1;
	CB_LABEL (label)->flag_entry = 1;
	CB_LABEL (label)->flag_entry_for_goto = 1;
#if 0	/* seems to be not necessary */
	copy_pos (label, current_statement);
#endif
	emit_statement (label);

	for (l = current_program->entry_list_goto; l; l = CB_CHAIN (l)) {
		struct cb_label *real_label = CB_LABEL (CB_VALUE (l));
		if (strcmp (name, real_label->name) == 0) {
			cb_error_x (CB_TREE (current_statement),
				    _("ENTRY FOR GO TO '%s' duplicated"), name);
		}
	}

	if (current_program->entry_list_goto) {
		current_program->entry_list_goto =
			cb_list_add (current_program->entry_list_goto, label);
	} else {
		current_program->entry_list_goto = CB_LIST_INIT (label);
	}
}

static size_t
increment_depth (void)
{
	if (++depth >= PROG_DEPTH) {
		cb_error (_("maximum nested program depth exceeded (%d)"),
			  PROG_DEPTH);
		return 1;
	}
	return 0;
}

static void
terminator_warning (cb_tree stmt, const unsigned int termid,
		    const char *name)
{
	char		terminator[32];

	check_unreached = 0;
	if (term_array[termid]) {
		term_array[termid]--;
	/* LCOV_EXCL_START */
	} else {
		cobc_err_msg ("call to '%s' without any open term for %s",
			"terminator_warning", name);
		COBC_ABORT ();
	}
	/* LCOV_EXCL_STOP */
	snprintf (terminator, 32, "END-%s", name);
	if (is_reserved_word (terminator)) {
		cb_warning_x (cb_warn_terminator, CB_TREE (current_statement),
			_("%s statement not terminated by %s"), name, terminator);
	}

	/* Free tree associated with terminator */
	if (stmt) {
		cobc_parse_free (stmt);
	}
}

static void
terminator_error (cb_tree stmt, const unsigned int termid, const char *name)
{
	char		terminator[32];

	check_unreached = 0;
	if (term_array[termid]) {
		term_array[termid]--;
	/* LCOV_EXCL_START */
	} else {
		cobc_err_msg ("call to '%s' without any open term for %s",
			"terminator_error", name);
		COBC_ABORT ();
	}
	/* LCOV_EXCL_STOP */
	snprintf (terminator, 32, "END-%s", name);
	if (is_reserved_word (terminator)) {
		cb_error_x (CB_TREE (current_statement),
			_("%s statement not terminated by %s"), name, terminator);
	} else {
		cb_error_x (CB_TREE (current_statement),
			_("%s statement not terminated"), name);
	}

	/* Free tree associated with terminator */
	if (stmt) {
		cobc_parse_free (stmt);
	}
}

static void
terminator_clear (cb_tree stmt, const unsigned int termid)
{
	struct cb_perform	*p;
	check_unreached = 0;
	if (term_array[termid]) {
		term_array[termid]--;
	/* LCOV_EXCL_START */
	} else {
		cobc_err_msg ("call to '%s' without any open term for %s",
			"terminator_warning", cb_statement_name[current_statement->statement]);
		COBC_ABORT ();
	}
	/* LCOV_EXCL_STOP */
	if (termid == TERM_PERFORM
	 && perform_stack) {
		p = CB_PERFORM (CB_VALUE (perform_stack));
		if (p->perform_type == CB_PERFORM_UNTIL) {
			cb_terminate_cond ();
		}
	}
	/* Free tree associated with terminator */
	if (stmt) {
		cobc_parse_free (stmt);
	}
}

static void
setup_use_file (struct cb_file *fileptr)
{
	struct cb_file	*newptr;

	if (fileptr->organization == COB_ORG_SORT) {
		cb_error (_("USE statement invalid for SD file"));
	}
	if (fileptr->flag_global) {
		newptr = cobc_parse_malloc (sizeof(struct cb_file));
		*newptr = *fileptr;
		newptr->handler = current_section;
		newptr->handler_prog = current_program;
		if (!use_global_ind) {
			current_program->local_file_list =
				cb_list_add (current_program->local_file_list,
					     CB_TREE (newptr));
		} else {
			current_program->global_file_list =
				cb_list_add (current_program->global_file_list,
					     CB_TREE (newptr));
		}
	} else {
		fileptr->handler = current_section;
	}
}

/* note: same message in field.c */
static int
emit_duplicate_clause_message (const char *clause)
{
	return cb_syntax_check (_("duplicate %s clause"), clause);
}

static int
check_repeated (const char *clause, const cob_flags_t bitval,
			cob_flags_t *already_seen)
{
	if (*already_seen & bitval) {
		return emit_duplicate_clause_message (clause);
	}
	*already_seen |= bitval;
	return 0;
}

static void
emit_conflicting_clause_message (const char *clause, const char *conflicting)
{
	if (cb_syntax_check (_("cannot specify both %s and %s"), clause, conflicting)) {
		cb_note (COBC_WARN_FILLER, 0, _("%s is ignored"), clause);
	}
}


static void
error_if_no_page_lines_limit (const char *phrase)
{
	if (!current_report->lines && !current_report->t_lines) {
		cb_error (_("cannot specify %s without number of lines on page"),
			  phrase);
	}
}

static void
setup_occurs (void)
{
	check_repeated ("OCCURS", SYN_CLAUSE_7, &check_pic_duplicate);
	if (current_field->indexes == COB_MAX_SUBSCRIPTS) {
		cb_error (_("maximum OCCURS depth exceeded (%d)"),
			COB_MAX_SUBSCRIPTS);
	} else {
		current_field->indexes++;
	}

	if (current_field->flag_unbounded) {
		if (current_field->storage == CB_STORAGE_LINKAGE) {
			struct cb_field *p = current_field;
			while (p) {
				p->flag_above_unbounded = 1;
				p = p->parent;
			}
		} else {
			cb_tree x = CB_TREE (current_field);
			cb_error_x (x, _("'%s' is not in LINKAGE SECTION"), cb_name (x));
			current_field->flag_above_unbounded = 1;
		}
	}

	if (current_field->flag_item_based) {
		cb_error (_("%s and %s are mutually exclusive"), "BASED", "OCCURS");
	} else if (current_field->flag_external) {
		cb_error (_("%s and %s are mutually exclusive"), "EXTERNAL", "OCCURS");
	}
	current_field->flag_occurs = 1;
}

static void
setup_occurs_min_max (cb_tree occurs_min, cb_tree occurs_max)
{
	if (occurs_max) {
		current_field->occurs_min = cb_get_int (occurs_min);
		if (occurs_max != cb_int0) {
			current_field->occurs_max = cb_get_int (occurs_max);
			if (!current_field->depending) {
				if (cb_syntax_check (_("TO phrase without DEPENDING phrase"))) {
					cb_note (COBC_WARN_FILLER, 0,
						 _("maximum number of occurrences assumed to be exact number"));
					current_field->occurs_min = 1; /* as done by IBM + MF */
				}
			}
			if (current_field->occurs_max <= current_field->occurs_min) {
				cb_error (_("OCCURS TO must be greater than OCCURS FROM"));
				current_field->occurs_max = current_field->occurs_min;
			}
		} else {
			current_field->occurs_max = 0;	/* UNBOUNDED */
		}
	} else {
		current_field->occurs_min = 1; /* as done by IBM + MF */
		current_field->occurs_max = cb_get_int (occurs_min);
		if (current_field->depending) {
			cb_verify (cb_odo_without_to, _("OCCURS DEPENDING ON without TO phrase"));
		}
	}
	/* LCOV_EXCL_START */
	if (current_field->occurs_max > COB_MAX_FIELD_SIZE) {
		/* testing here to give an early error; unlikely to be reached
		   with 64bit compilers so no own msgid for now; should be added
		   when the maximum field size is changed to be configurable */
		cb_error_x (CB_TREE (current_field),
			_("'%s' cannot be larger than %d bytes"),
			current_field->name, COB_MAX_FIELD_SIZE);
		current_field->occurs_min = current_field->occurs_max = 1;
	}
	/* LCOV_EXCL_STOP */
}

static void
check_relaxed_syntax (const cob_flags_t lev)
{
	const char	*s;

	switch (lev) {
	case COBC_HD_ENVIRONMENT_DIVISION:
		s = "ENVIRONMENT DIVISION";
		break;
	case COBC_HD_CONFIGURATION_SECTION:
		s = "CONFIGURATION SECTION";
		break;
	case COBC_HD_SPECIAL_NAMES:
		s = "SPECIAL-NAMES";
		break;
	case COBC_HD_INPUT_OUTPUT_SECTION:
		s = "INPUT-OUTPUT SECTION";
		break;
	case COBC_HD_FILE_CONTROL:
		s = "FILE-CONTROL";
		break;
	case COBC_HD_I_O_CONTROL:
		s = "I-O-CONTROL";
		break;
	case COBC_HD_DATA_DIVISION:
		s = "DATA DIVISION";
		break;
	case COBC_HD_FILE_SECTION:
		s = "FILE SECTION";
		break;
	case COBC_HD_WORKING_STORAGE_SECTION:
		s = "WORKING-STORAGE SECTION";
		break;
	case COBC_HD_LOCAL_STORAGE_SECTION:
		s = "LOCAL-STORAGE SECTION";
		break;
	case COBC_HD_LINKAGE_SECTION:
		s = "LINKAGE SECTION";
		break;
	case COBC_HD_COMMUNICATION_SECTION:
		s = "COMMUNICATION SECTION";
		break;
	case COBC_HD_REPORT_SECTION:
		s = "REPORT SECTION";
		break;
	case COBC_HD_SCREEN_SECTION:
		s = "SCREEN SECTION";
		break;
	case COBC_HD_PROCEDURE_DIVISION:
		s = "PROCEDURE DIVISION";
		break;
	case COBC_HD_PROGRAM_ID:
		s = "PROGRAM-ID";
		break;
	/* LCOV_EXCL_START */
	default:
		s = _("unknown");
		break;
	/* LCOV_EXCL_STOP */
	}
	if (cb_syntax_check (_("%s header missing"), s)) {
		cb_note (COBC_WARN_FILLER, 0, _("%s header assumed"), s);
	}
}

static void
setup_default_collation (struct cb_program *program) {
	switch (cb_default_colseq) {
#ifdef COB_EBCDIC_MACHINE
	case CB_COLSEQ_ASCII:
#else
	case CB_COLSEQ_EBCDIC:
#endif
		alphanumeric_collation = build_colseq (cb_default_colseq);
		break;
	default:
		alphanumeric_collation = NULL;
	}
	national_collation = NULL; /* TODO: default national collation */
	program->collating_sequence = alphanumeric_collation;
	program->collating_sequence_n = national_collation;
}

static void
program_init_without_program_id (void)
{
	cb_tree		l;

	current_section = NULL;
	current_paragraph = NULL;
	l = cb_build_alphanumeric_literal (demangle_name,
		strlen (demangle_name));
	current_program->program_name = (char *)CB_LITERAL (l)->data;
	current_program->program_id
		= cb_build_program_id (current_program->program_name, 0);
	current_program->prog_type = COB_MODULE_TYPE_PROGRAM;
	if (!main_flag_set) {
		main_flag_set = 1;
		current_program->flag_main = cobc_flag_main;
	}
	setup_default_collation (current_program);
	check_relaxed_syntax (COBC_HD_PROGRAM_ID);
}

/* check if headers are present - return 0 if fine, 1 if missing
   Lev1 must always be present and is checked
   Lev2/3/4, if non-zero (forced) may be present
*/
static int
check_headers_present (const cob_flags_t lev1, const cob_flags_t lev2,
		       const cob_flags_t lev3, const cob_flags_t lev4)
{
	int ret = 0;
	if (!(header_check & lev1)) {
		header_check |= lev1;
		check_relaxed_syntax (lev1);
		ret = 1;
	}
	if (lev2) {
		if (!(header_check & lev2)) {
			header_check |= lev2;
			check_relaxed_syntax (lev2);
			ret = 1;
		}
	}
	if (lev3) {
		if (!(header_check & lev3)) {
			header_check |= lev3;
			check_relaxed_syntax (lev3);
			ret = 1;
		}
	}
	if (lev4) {
		if (!(header_check & lev4)) {
			header_check |= lev4;
			check_relaxed_syntax (lev4);
			ret = 1;
		}
	}
	return ret;
}

/*
  TODO: Refactor header checks - have several header_checks: division_header,
  section_header, paragraph_header, sentence_type
*/
static void
set_conf_section_part (const cob_flags_t part)
{
	header_check &= ~COBC_HD_SOURCE_COMPUTER;
	header_check &= ~COBC_HD_OBJECT_COMPUTER;
	header_check &= ~COBC_HD_SPECIAL_NAMES;
	header_check &= ~COBC_HD_REPOSITORY;
	header_check |= part;
}

static const char *
get_conf_section_part_name (const cob_flags_t part)
{
	if (part == COBC_HD_SOURCE_COMPUTER) {
		return "SOURCE-COMPUTER";
	} else if (part == COBC_HD_OBJECT_COMPUTER) {
		return "OBJECT-COMPUTER";
	} else if (part == COBC_HD_SPECIAL_NAMES) {
		return "SPECIAL-NAMES";
	} else if (part == COBC_HD_REPOSITORY) {
		return "REPOSITORY";
	/* LCOV_EXCL_START */
	} else {
		/* This should never happen (and therefore doesn't get a translation) */
		cb_error ("unexpected configuration section part " CB_FMT_LLU, part);
		COBC_ABORT ();
	/* LCOV_EXCL_STOP */
	}
}

static int
get_conf_section_part_order (const cob_flags_t part)
{
	if (part == COBC_HD_SOURCE_COMPUTER) {
		return 1;
	} else if (part == COBC_HD_OBJECT_COMPUTER) {
		return 2;
	} else if (part == COBC_HD_SPECIAL_NAMES) {
		return 3;
	} else if (part == COBC_HD_REPOSITORY) {
		return 4;
	/* LCOV_EXCL_START */
	} else {
		/* This should never happen (and therefore doesn't get a translation) */
		cb_error ("unexpected configuration section part " CB_FMT_LLU, part);
		COBC_ABORT ();
	/* LCOV_EXCL_STOP */
	}
}

static void
check_conf_section_order (const cob_flags_t part)
{
	const cob_flags_t	prev_part
		= header_check & (COBC_HD_SOURCE_COMPUTER
				  | COBC_HD_OBJECT_COMPUTER
				  | COBC_HD_SPECIAL_NAMES
				  | COBC_HD_REPOSITORY);
#define MESSAGE_LEN 100
	char			message[MESSAGE_LEN] = { '\0' };

	if (prev_part == 0) {
		return;
	}

	if (prev_part == part) {
		cb_error (_("duplicate %s"), get_conf_section_part_name (part));
	} else if (get_conf_section_part_order (part) < get_conf_section_part_order (prev_part)) {
		snprintf (message, MESSAGE_LEN, _("%s incorrectly after %s"),
			  get_conf_section_part_name (part),
			  get_conf_section_part_name (prev_part));
		cb_verify (cb_incorrect_conf_sec_order, message);
	}
}

#undef MESSAGE_LEN

/* check if a given register is available; if it is,
   enforce code generation and add a
   "receiving" entry for it when xref is requested */
static void
cb_set_register_receiving (struct cb_field *reg_field, int mandatory)
{
	if (!reg_field) {
		if (mandatory) {
			cb_error ("missing register definition");
		}
		return;
	}
	reg_field->count++;

	if (cb_listing_xref) {
		cobc_xref_set_receiving (CB_TREE (reg_field));
	}
}

static enum cb_handler_type
get_handler_type_from_statement (struct cb_statement *statement)
{
	if (statement->statement == STMT_DISPLAY) {
		return DISPLAY_HANDLER;
	}
	if (statement->statement == STMT_XML_GENERATE
	 || statement->statement == STMT_XML_PARSE) {
		return XML_HANDLER;
	}
	if (statement->statement == STMT_JSON_GENERATE
	 || statement->statement == STMT_JSON_PARSE) {
		return JSON_HANDLER;
	}
#if 0 /* not merged yet */
	if (statement->statement == STMT_DELETE_FILE) {
		return DELETE_FILE_HANDLER;
	}
#endif
	if (statement->statement == STMT_SEND
	 || statement->statement == STMT_RECEIVE) {
		return MCS_HANDLER;
	}
	return NO_HANDLER;
}

static void
build_words_for_nested_programs (void)
{
	cb_tree		x;
	cb_tree		y;

	/* Inherit special name mnemonics from parent */
	for (x = current_program->mnemonic_spec_list; x; x = CB_CHAIN (x)) {
		y = cb_build_reference (cb_name(CB_PURPOSE(x)));
		if (CB_SYSTEM_NAME_P (CB_VALUE(x))) {
			cb_define (y, CB_VALUE(x));
		} else {
			cb_build_constant (y, CB_VALUE(x));
		}
	}

	/* Inherit class names from parent */
	for (x = current_program->class_name_list; x; x = CB_CHAIN(x)) {
		y = cb_build_reference (cb_name(CB_VALUE(x)));
		cb_define (y, CB_VALUE(x));
	}
}

static void
clear_initial_values (void)
{
	perform_stack = NULL;
	current_statement = NULL;
	qualifier = NULL;
	in_declaratives = 0;
	in_debugging = 0;
	use_global_ind = 0;
	check_duplicate = 0;
	check_pic_duplicate = 0;
	skip_statements = 0;
	start_debug = 0;
	save_debug = 0;
	needs_field_debug = 0;
	needs_debug_item = 0;
	env_div_seen = 0;
	header_check = 0;
	next_label_id = 0;
	current_linage = 0;
	set_attr_val_on = 0;
	set_attr_val_off = 0;
	report_count = 0;
	current_storage = CB_STORAGE_WORKING;
	eval_level = 0;
	eval_inc = 0;
	eval_inc2 = 0;
	inspect_keyword = INSPECT_REP_DEFAULT;
	check_unreached = 0;
	cobc_in_id = 0;
	cobc_in_procedure = 0;
	cobc_in_repository = 0;
	cobc_in_xml_generate_body = 0;
	cobc_in_json_generate_body = 0;
	non_const_word = 0;
	suppress_data_exceptions = 0;
	same_area = 1;
	memset ((void *)eval_check, 0, sizeof(eval_check));
	memset ((void *)term_array, 0, sizeof(term_array));
	linage_file = NULL;
	current_file = NULL;
	current_cd = NULL;
	current_report = NULL;
	report_instance = NULL;
	next_label_list = NULL;
	default_rounded_mode = cb_int (COB_STORE_ROUND);
}

/*
  We must check for redefinitions of program-names and external program names
  outside of the usual reference/word_list methods as it may have to be done in
  a case-sensitive way.
*/
static void
begin_scope_of_program_name (struct cb_program *program)
{
	const char	*prog_name = program->program_name;
	const char	*prog_id = program->orig_program_id;
	cb_tree		l;

	/*
	  Error if we find a program or prototype with the same name as the
	  given program or prototype, respectively.
	*/
	for (l = defined_prog_list; l; l = CB_CHAIN (l)) {
		const struct cb_program	*elt_program = CB_PROGRAM (CB_VALUE (l));
		const char	*elt_name = elt_program->program_name;
		const char	*elt_id = elt_program->orig_program_id;
		/*
		  If we find a program's matching prototype or a prototype's
		  matching definition, nothing needs to be done.
		*/
		if (program->flag_prototype != elt_program->flag_prototype) {
			continue;
		}

		if (cb_fold_call && strcasecmp (prog_name, elt_name) == 0) {
			cb_error_x (CB_TREE(program),
				    _("redefinition of program name '%s'"),
				    elt_name);
			return;
		} else if (strcmp (prog_id, elt_id) == 0) {
			cb_error_x (CB_TREE(program),
				    _("redefinition of program ID '%s'"),
				    elt_id);
			return;
		}
	}

	/* Otherwise, add the program to the list. */
	defined_prog_list = cb_list_add (defined_prog_list, CB_TREE (program));
}

static void
remove_program_name (struct cb_list *l, struct cb_list *prev)
{
	if (prev == NULL) {
		defined_prog_list = l->chain;
	} else {
		prev->chain = l->chain;
	}
	cobc_parse_free (l);
}

/* Remove the program from defined_prog_list, if necessary. */
static void
end_scope_of_program_name (struct cb_program *program, const unsigned char type)
{
	struct	cb_list	*prev = NULL;
	struct	cb_list *l;

	/* create empty entry if the program has no PROCEDURE DIVISION, error for UDF */
	if (!program->entry_list) {
		if (type == COB_MODULE_TYPE_FUNCTION
		/* CHECKME: That would be valid in a function-definition according to COBOL2014
		  --> How is it intended to work? */
		 && !program->flag_prototype) {
			cb_error (_("FUNCTION '%s' has no PROCEDURE DIVISION"), program->program_name);
		} else {
			emit_main_entry (program, NULL);
		}
	}
	program->last_source_line = last_source_line;

	if (program->nested_level == 0
	 || defined_prog_list == NULL) {
		return;
	}

	/* Remove any subprograms */
	l = CB_LIST (defined_prog_list);
	while (l) {
		const struct cb_program *lprog = CB_PROGRAM (l->value);
		if (lprog->nested_level > program->nested_level) {
			remove_program_name (l, prev);
		} else {
			prev = l;
		}
		if (prev && prev->chain != NULL) {
			l = CB_LIST (prev->chain);
		} else {
			l = NULL;
		}
	}

	/* Remove the specified program, if it is not COMMON */
	if (!program->flag_common) {
		l = CB_LIST (defined_prog_list);
		while (l) {
			const struct cb_program *lprog = CB_PROGRAM (l->value);
			/* The nested_level check is for the pathological case
			   where two nested programs have the same name */
			if (program->nested_level == lprog->nested_level
			 && !strcmp (program->orig_program_id, lprog->orig_program_id)) {
				remove_program_name (l, prev);
				if (prev && prev->chain != NULL) {
					l = CB_LIST (prev->chain);
				} else {
					l = NULL;
				}
				break;
			} else {
				prev = l;
				if (l->chain != NULL) {
					l = CB_LIST (l->chain);
				} else {
					l = NULL;
				}
			}
		}
	}
}

static void
setup_registers (void)
{
	const char *backup_source_file = cb_source_file;
	cb_source_file = "register-definition";
	cb_set_intr_when_compiled ();
	cb_build_registers ();
	cb_add_external_defined_registers ();
	cb_source_file = backup_source_file;
}

static void
setup_program_start (void)
{
	if (setup_from_identification) {
		setup_from_identification = 0;
		return;
	}
	current_section = NULL;
	current_paragraph = NULL;

	if (depth != 0 && first_nested_program) {
		check_headers_present (COBC_HD_PROCEDURE_DIVISION, 0, 0, 0);
	}
	first_nested_program = 1;
}

static int
setup_program (cb_tree id, cb_tree as_literal, const enum cob_module_type type, const int prototype)
{
	const char	*external_name = NULL;

	setup_program_start ();

	/* finish last program/function */
	if (!first_prog) {
		const char *backup_source_file = cb_source_file;
		if (!current_program->flag_validated) {
			current_program->flag_validated = 1;
			cb_validate_program_body (current_program);
		}

		/* setup new */
		clear_initial_values ();
		current_program = cb_build_program (current_program, depth);
		if (depth) {
			build_words_for_nested_programs();
		}
		cb_source_file = backup_source_file;
		setup_registers ();
	} else {
		/* in this case we had setup an "empty" current_program
		   along with registers before (on start) and now only "add"
		   to that */
		first_prog = 0;
	}

	/* set internal name */
	if (CB_LITERAL_P (id)) {
		current_program->program_name = (char *)CB_LITERAL (id)->data;
	} else {
		current_program->program_name = CB_NAME (id);
	}	

	stack_progid[depth] = current_program->program_name;
	current_program->prog_type = type;
	current_program->flag_prototype = prototype;

	if (depth != 0 && type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("functions may not be defined within a program/function"));
	}

	if (increment_depth ()) {
		return 1;
	}

	/* set external name if specified */
	if (as_literal) {
		external_name = (const char *)CB_LITERAL (as_literal)->data;
	} else {
		external_name = current_program->program_name;
	}

	/* build encoded external PROGRAM-ID */
	current_program->program_id
		= cb_build_program_id (external_name, type == COB_MODULE_TYPE_FUNCTION);

	if (type == COB_MODULE_TYPE_PROGRAM) {
		if (!main_flag_set
		 && !current_program->flag_prototype) {
			main_flag_set = 1;
			current_program->flag_main = !!cobc_flag_main;
		}
	} else { /* COB_MODULE_TYPE_FUNCTION */
		current_program->flag_recursive = 1;
	}

	if (CB_REFERENCE_P (id)) {
		cb_define (id, CB_TREE (current_program));
	}

	/* Initalize default COLLATING SEQUENCE */
	setup_default_collation (current_program);

	begin_scope_of_program_name (current_program);

	return 0;
}

static void
decrement_depth (const char *name, const unsigned char type)
{
	int	d;

	if (depth) {
		depth--;
	}

	if (!strcmp (stack_progid[depth], name)) {
		return;
	}

	if (type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("END FUNCTION '%s' is different from FUNCTION-ID '%s'"),
			  name, stack_progid[depth]);
		return;
	}

	/* Set depth to that of whatever program we just ended, if it exists. */
	for (d = depth; d >= 0; --d) {
		if (!strcmp (stack_progid[d], name)) {
			depth = d;
			return;
		}
	}

	if (depth != d) {
		cb_error (_("END PROGRAM '%s' is different from PROGRAM-ID '%s'"),
			  name, stack_progid[depth]);
	}
}

static void
clean_up_program (cb_tree name, const unsigned char type)
{
	char		*s;

	end_scope_of_program_name (current_program, type);

	if (name) {
		if (CB_LITERAL_P (name)) {
			s = (char *)(CB_LITERAL (name)->data);
		} else {
			s = (char *)(CB_NAME (name));
		}

		decrement_depth (s, type);
	}

	current_section = NULL;
	current_paragraph = NULL;
	if (!current_program->flag_validated) {
		current_program->flag_validated = 1;
		cb_validate_program_body (current_program);
	}
}

static const char *
get_literal_or_word_name (const cb_tree x)
{
	if (CB_LITERAL_P (x)) {
		return (const char *) CB_LITERAL (x)->data;
	} else { /* CB_REFERENCE_P (x) */
		return (const char *) CB_NAME (x);
	}
}

/* verify and set currency symbol used in picture (compile time) and - if no currency
   string is explicitly set (which is currently not implemented) - as currency string
   (run time for display and [de-]editing)*/
static void
set_currency_picture_symbol (const cb_tree x)
{
	unsigned char	*s		= CB_LITERAL (x)->data;

	if (CB_LITERAL (x)->size != 1) {
		cb_error_x (x, _("currency symbol must be one character long"));
		return;
	}
	switch (*s) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'N':
	case 'P':
	case 'R':
	case 'S':
	case 'V':
	case 'X':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'n':
	case 'p':
	case 'r':
	case 's':
	case 'v':
	case 'x':
	case 'z':
	case '+':
	case '-':
	case ',':
	case '.':
	case '*':
	case '/':
	case ';':
	case '(':
	case ')':
	case '=':
	case '\'':
	case '"':
	case ' ':
#if 0 /* note: MicroFocus also dissalows L (VAX) and G (OSVS) */
	case 'L':
	case 'G':
	case 'l':
	case 'g':
#endif
		cb_error_x (x, _("invalid character '%c' in currency symbol"), s[0]);
		return;
	default:
		break;
	}
	current_program->currency_symbol = s[0];
}

/* Return 1 if the prototype name is the same as the current function's. */
static int
check_prototype_redefines_current_element (const cb_tree prototype_name)
{
	const char	*name = get_literal_or_word_name (prototype_name);

	if (strcasecmp (name, current_program->program_name) == 0) {
		cb_warning_x (COBC_WARN_FILLER, prototype_name,
			_("prototype has same name as current function and will be ignored"));
		return 1;
	}

	return 0;
}

/* Returns 1 if the prototype has been duplicated. */
static int
check_for_duplicate_prototype (const cb_tree prototype_name,
			       const cb_tree prototype)
{
	cb_tree	dup;

	if (CB_WORD_COUNT (prototype_name) > 0) {
		/* Make sure the duplicate is a prototype */
		dup = cb_ref (prototype_name);
		if (!CB_PROTOTYPE_P (dup)) {
			redefinition_error (prototype_name);
			return 1;
		}

		/* Check the duplicate prototypes match */
		if (strcmp (CB_PROTOTYPE (prototype)->ext_name,
			    CB_PROTOTYPE (dup)->ext_name)
		    || CB_PROTOTYPE (prototype)->type != CB_PROTOTYPE (dup)->type) {
			cb_error_x (prototype_name,
				    _("duplicate REPOSITORY entries for '%s' do not match"),
				    get_literal_or_word_name (prototype_name));
		} else {
			cb_warning_x (COBC_WARN_FILLER, prototype_name,
				      _("duplicate REPOSITORY entry for '%s'"),
				      get_literal_or_word_name (prototype_name));
		}
		return 1;
	}

	return 0;
}

static void
setup_prototype (cb_tree prototype_name, cb_tree ext_name,
		  const enum cob_module_type type, const int is_current_element)
{
	cb_tree	prototype;
	int	name_redefinition_allowed;

	if (!is_current_element
	    && check_prototype_redefines_current_element (prototype_name)) {
		return;
	}

	prototype = cb_build_prototype (prototype_name, ext_name, type);

	if (!is_current_element
	 && check_for_duplicate_prototype (prototype_name, prototype)) {
		return;
	}

	name_redefinition_allowed = type == COB_MODULE_TYPE_PROGRAM
		&& is_current_element && cb_program_name_redefinition;
	if (!name_redefinition_allowed) {
		if (CB_LITERAL_P (prototype_name)) {
			cb_define (cb_build_reference ((const char *)CB_LITERAL (prototype_name)->data), prototype);
		} else {
			cb_define (prototype_name, prototype);
		}

		if (type == COB_MODULE_TYPE_PROGRAM) {
			current_program->program_spec_list =
				cb_list_add (current_program->program_spec_list, prototype);
		} else { /* COB_MODULE_TYPE_FUNCTION */
			current_program->user_spec_list =
				cb_list_add (current_program->user_spec_list, prototype);
		}
	}
}

static void
error_if_record_delimiter_incompatible (const enum cob_file_org organization,
					const char *organization_name)
{
	int	is_compatible;

	if (!current_file->flag_delimiter) {
		return;
	}

	if (organization == COB_ORG_LINE_SEQUENTIAL) {
		is_compatible = current_file->organization == COB_ORG_SEQUENTIAL
			|| current_file->organization == COB_ORG_LINE_SEQUENTIAL;
	} else {
		is_compatible = current_file->organization == organization;
	}

	if (!is_compatible) {
		cb_error (_("ORGANIZATION %s is incompatible with RECORD DELIMITER"),
			  organization_name);
	}
}

static int
set_current_field (int level, cb_tree name)
{
	cb_tree	x  = cb_build_field_tree (level, name, current_field,
					  current_storage, current_file, 0);

	if (CB_INVALID_TREE (x)) {
		return 1;
	} else {
		current_field = CB_FIELD (x);
		check_pic_duplicate = 0;
		if (current_field->level == 1 || current_field->level == 77) {
			within_typedef_definition = 0;
		}
	}

	return 0;
}

static void
setup_external_definition (cb_tree x, const int type)
{
	/* note: syntax checks for conflicting clauses
	         are done in inherit_external_definition */

	if (x != cb_error_node) {
		struct cb_field *f = CB_FIELD (cb_ref (x));

		/* additional checks if the definition isn't provided by type */
		if (type != 1 /* called with SAME AS / LIKE data-name */ ) {
			if (f->level == 88) {
				cb_error (_("condition-name not allowed here: '%s'"), cb_name (x));
				x = cb_error_node;
			}
			/* note: the following are not explicit specified but implied with
			   LIKE as ILE-COBOL does not have those sections */
			if (f->storage == CB_STORAGE_SCREEN) {
				cb_error (_("SCREEN item cannot be used here"));
				x = cb_error_node;
			} else if (f->storage == CB_STORAGE_REPORT) {
				cb_error (_("REPORT item cannot be used here"));
				x = cb_error_node;
			}
			if (type == 0) {
				/* rules that apply only to SAME AS */
				if (f->flag_is_typedef) {
					cb_error (_("TYPEDEF item cannot be used here"));
					x = cb_error_node;
				}
			}
		}

		if (current_field->level == 77) {
			if (type != 2 /* called with LIKE */
			 && f->children) {
				cb_error (_("elementary item expected"));
				x = cb_error_node;
			}
		} else {
			struct cb_field *p = current_field;
			do {
				if (p == f) {
					cb_error (_ ("item may not reference itself"));
					x = cb_error_node;
					break;
				}
				p = p->parent;
			} while (p);
			for (p = f->parent; p; p = p->parent) {
				if (p->usage != CB_USAGE_DISPLAY) {
					cb_error (_("item may not be subordinate to any item with USAGE clause"));
				} else if (p->flag_sign_clause) {
					cb_error (_("item may not be subordinate to any item with SIGN clause"));
				} else {
					continue;
				}
				x = cb_error_node;
				break;
			}
		}
	}

	if (x == cb_error_node) {
		current_field->flag_is_verified = 1;
		current_field->flag_invalid = 1;
		current_field->external_definition = cb_error_node;
	} else {
		current_field->external_definition = cb_ref (x);
	}
}

static void
setup_external_definition_type (cb_tree x)
{
	if (!check_repeated ("TYPE TO", SYN_CLAUSE_31, &check_pic_duplicate)) {
		if (current_field->external_definition) {
			emit_conflicting_clause_message ("SAME AS", "TYPE TO");
		}
		setup_external_definition (x, 1);
	}
}

/* verifies that no conflicting clauses are used and
   inherits the definition of the original field specified
   by SAME AS or by type_name into the current_field */
static void
inherit_external_definition (const int lvl)
{
	/* syntax checks */
	{
		/* note: REDEFINES (clause 1) is allowed with RM/COBOL but not COBOL 2002+ */
		static const cob_flags_t	allowed_clauses =
			SYN_CLAUSE_1 | SYN_CLAUSE_2 | SYN_CLAUSE_3 | SYN_CLAUSE_7 | SYN_CLAUSE_12;
		cob_flags_t	tested = check_pic_duplicate & ~(allowed_clauses);
		if (tested != SYN_CLAUSE_30 && tested != SYN_CLAUSE_31
		 && tested != 0 /* USAGE as TYPE TO */) {
			struct cb_field *fld = CB_FIELD (current_field->external_definition);
			cb_error_x (CB_TREE(current_field), _("illegal combination of %s with other clauses"),
				fld->flag_is_typedef ? "TYPE TO" : "SAME AS");
			current_field->flag_is_verified = 1;
			current_field->flag_invalid = 1;
			return;
		}
	}
	/* actual copy */
	{
		struct cb_field *fld = CB_FIELD (current_field->external_definition);
		int new_level = lvl;
		int old_level = current_field->level;
		copy_into_field (fld, current_field);
		if (new_level > 1 && new_level < 66 && new_level > old_level) {
			cb_error (_("entry following %s may not be subordinate to it"),
				fld->flag_is_typedef ? "TYPE TO" : "SAME AS");
		}
	}
}

static cb_tree
get_finalized_description_tree (void)
{
	struct cb_field *p;

			/* finalize last field if target of SAME AS / TYPEDEF */
	if (current_field && !CB_INVALID_TREE (current_field->external_definition)) {
			inherit_external_definition (0);
	}

	/* validate the complete current "block" */
	for (p = description_field; p; p = p->sister) {
		cb_validate_field (p);
	}
	return CB_TREE (description_field);
}

static void
check_not_both (const cob_flags_t flag1, const cob_flags_t flag2,
		const char *flag1_name, const char *flag2_name,
		const cob_flags_t flags, const cob_flags_t flag_to_set)
{
	if (flag_to_set == flag1 && (flags & flag2)) {
		cb_error (_("cannot specify both %s and %s"),
			  flag1_name, flag2_name);
	} else if (flag_to_set == flag2 && (flags & flag1)) {
		cb_error (_("cannot specify both %s and %s"),
			  flag1_name, flag2_name);

	}
}

static COB_INLINE COB_A_INLINE void
check_not_highlight_and_lowlight (const cob_flags_t flags,
				  const cob_flags_t flag_to_set)
{
	check_not_both (COB_SCREEN_HIGHLIGHT, COB_SCREEN_LOWLIGHT,
			"HIGHLIGHT", "LOWLIGHT", flags, flag_to_set);
}

static void
set_screen_attr (const char *clause, const cob_flags_t bitval)
{
	if (current_field->screen_flag & bitval) {
		emit_duplicate_clause_message (clause);
	} else {
		current_field->screen_flag |= bitval;
	}
}

static void
set_attr_with_conflict (const char *clause, const cob_flags_t bitval,
			const char *confl_clause, const cob_flags_t confl_bit,
			const int local_check_duplicate, cob_flags_t *flags)
{
	if (local_check_duplicate && (*flags & bitval)) {
		emit_duplicate_clause_message (clause);
	} else if (*flags & confl_bit) {
		emit_conflicting_clause_message (clause, confl_clause);
	} else {
		*flags |= bitval;
	}
}

static COB_INLINE COB_A_INLINE void
set_screen_attr_with_conflict (const char *clause, const cob_flags_t bitval,
			       const char *confl_clause,
			       const cob_flags_t confl_bit)
{
	set_attr_with_conflict (clause, bitval, confl_clause, confl_bit, 1,
				&current_field->screen_flag);
}

static COB_INLINE COB_A_INLINE int
has_dispattr (const cob_flags_t attrib)
{
	return current_statement->attr_ptr
		&& current_statement->attr_ptr->dispattrs & attrib;
}

static void
attach_attrib_to_cur_stmt (void)
{
	if (!current_statement->attr_ptr) {
		current_statement->attr_ptr =
			cobc_parse_malloc (sizeof(struct cb_attr_struct));
	}
}

static COB_INLINE COB_A_INLINE void
set_dispattr (const cob_flags_t attrib)
{
	attach_attrib_to_cur_stmt ();
	current_statement->attr_ptr->dispattrs |= attrib;
}

static COB_INLINE COB_A_INLINE void
set_dispattr_with_conflict (const char *attrib_name, const cob_flags_t attrib,
			    const char *confl_name,
			    const cob_flags_t confl_attrib)
{
	attach_attrib_to_cur_stmt ();
	set_attr_with_conflict (attrib_name, attrib, confl_name, confl_attrib, 0,
				&current_statement->attr_ptr->dispattrs);
}

static void
bit_set_attr (const cb_tree on_off, const cob_flags_t attr_val)
{
	if (on_off == cb_int1) {
		set_attr_val_on |= attr_val;
	} else {
		set_attr_val_off |= attr_val;
	}
}

static void
set_field_attribs (cb_tree fgc, cb_tree bgc, cb_tree scroll, cb_tree timeout,
	cb_tree prompt, cb_tree size_is, cb_tree control, cb_tree color, cb_tree cursor)
{
	/* [WITH] FOREGROUND-COLOR [IS] */
	if (fgc) {
		current_statement->attr_ptr->fgc = fgc;
	}
	/* [WITH] BACKGROUND-COLOR [IS] */
	if (bgc) {
		current_statement->attr_ptr->bgc = bgc;
	}
	/* [WITH] SCROLL UP | DOWN */
	if (scroll) {
		current_statement->attr_ptr->scroll = scroll;
	}
	/* [WITH] TIME-OUT [AFTER] */
	if (timeout) {
		current_statement->attr_ptr->timeout = timeout;
	}
	/* [WITH] PROMPT CHARACTER [IS] */
	if (prompt) {
		current_statement->attr_ptr->prompt = prompt;
	}
	/* [WITH] SIZE [IS] */
	if (size_is) {
		current_statement->attr_ptr->size_is = size_is;
	}
	/* [WITH] CONTROL (variable named attributes) */
	if (control) {
		current_statement->attr_ptr->control = control;
	}
	/* [WITH] COLOR (variable numeric added attributes) */
	if (color) {
		current_statement->attr_ptr->color = color;
	}
	/* [WITH] CURSOR */
	if (cursor) {
		current_statement->attr_ptr->cursor = cursor;
	}
}

static void
set_attribs (const cob_flags_t attrib, cb_tree fgc, cb_tree bgc, cb_tree scroll,
	     cb_tree timeout, cb_tree prompt, cb_tree size_is,
	     cb_tree control, cb_tree color, cb_tree cursor)
{
	attach_attrib_to_cur_stmt ();
	set_field_attribs (fgc, bgc, scroll, timeout, prompt, size_is, control, color, cursor);

	current_statement->attr_ptr->dispattrs |= attrib;
}

static void
set_attribs_with_conflict  (cb_tree fgc, cb_tree bgc, cb_tree scroll,
			    cb_tree timeout, cb_tree prompt, cb_tree size_is,
			    const char *clause_name, const cob_flags_t attrib,
			    const char *confl_name, const cob_flags_t confl_attrib)
{
	attach_attrib_to_cur_stmt ();
	set_field_attribs (fgc, bgc, scroll, timeout, prompt, size_is, NULL, NULL, NULL);

	set_dispattr_with_conflict (clause_name, attrib, confl_name,
				    confl_attrib);
}

static cob_flags_t
zero_conflicting_flag (const cob_flags_t screen_flag, cob_flags_t parent_flag,
				const cob_flags_t flag1, const cob_flags_t flag2)
{
	if (screen_flag & flag1) {
		parent_flag &= ~flag2;
	} else if (screen_flag & flag2) {
		parent_flag &= ~flag1;
	}

	return parent_flag;
}

static cob_flags_t
zero_conflicting_flags (const cob_flags_t screen_flag, cob_flags_t parent_flag)
{
	parent_flag = zero_conflicting_flag (screen_flag, parent_flag,
					     COB_SCREEN_BLANK_LINE,
					     COB_SCREEN_BLANK_SCREEN);
	parent_flag = zero_conflicting_flag (screen_flag, parent_flag,
					     COB_SCREEN_ERASE_EOL,
					     COB_SCREEN_ERASE_EOS);
	parent_flag = zero_conflicting_flag (screen_flag, parent_flag,
					     COB_SCREEN_HIGHLIGHT,
					     COB_SCREEN_LOWLIGHT);

	return parent_flag;
}

static int
has_relative_pos (struct cb_field const *field)
{
	return !!(field->screen_flag
		  & ( COB_SCREEN_LINE_PLUS | COB_SCREEN_LINE_MINUS
		    | COB_SCREEN_COLUMN_PLUS | COB_SCREEN_COLUMN_MINUS));
}

static void
validate_screen_attributes (void)
{
	cob_flags_t	flags;

	if (current_field->parent) {
		flags = current_field->parent->screen_flag;
		flags &= ~COB_SCREEN_BLANK_LINE;
		flags &= ~COB_SCREEN_BLANK_SCREEN;
		flags &= ~COB_SCREEN_ERASE_EOL;
		flags &= ~COB_SCREEN_ERASE_EOS;
		flags &= ~COB_SCREEN_LINE_PLUS;
		flags &= ~COB_SCREEN_LINE_MINUS;
		flags &= ~COB_SCREEN_COLUMN_PLUS;
		flags &= ~COB_SCREEN_COLUMN_MINUS;

		flags = zero_conflicting_flags (current_field->screen_flag, flags);

		current_field->screen_flag |= flags;
	}

	if (current_field->screen_flag & COB_SCREEN_INITIAL) {
		if (!(current_field->screen_flag & COB_SCREEN_INPUT)) {
			cb_error (_("INITIAL specified on non-input field"));
		}
	}
	if (!qualifier) {
		current_field->flag_filler = 1;
	}

	if (!description_field) {
		description_field = current_field;
	}
	if (current_field->flag_occurs
	 && !has_relative_pos (current_field)) {
		cb_error (_("relative LINE/COLUMN clause required with OCCURS"));
	}
	cobc_cs_check = CB_CS_SCREEN;
}

static void
check_and_set_usage (const enum cb_usage usage)
{
	check_repeated ("USAGE", SYN_CLAUSE_5, &check_pic_duplicate);
	current_field->usage = usage;
}

static void
check_preceding_tallying_phrases (const enum tallying_phrase phrase)
{
	switch (phrase) {
	case FOR_PHRASE:
		if (previous_tallying_phrase == ALL_LEADING_TRAILING_PHRASES) {
			cb_error (_("FOR phrase cannot immediately follow ALL/LEADING/TRAILING"));
		} else if (previous_tallying_phrase == FOR_PHRASE) {
			cb_error (_("missing CHARACTERS/ALL/LEADING/TRAILING phrase after FOR phrase"));
		}
		break;

	case ALL_LEADING_TRAILING_PHRASES:
		if (previous_tallying_phrase == CHARACTERS_PHRASE
		 || previous_tallying_phrase == ALL_LEADING_TRAILING_PHRASES) {
			cb_error (_("missing value between ALL/LEADING/TRAILING words"));
		}
		/* fall through */
	case CHARACTERS_PHRASE:
		if (previous_tallying_phrase == NO_PHRASE) {
			cb_error (_("missing FOR phrase before CHARACTERS/ALL/LEADING/TRAILING phrase"));
		}
		break;

	case VALUE_REGION_PHRASE:
		if (! ( previous_tallying_phrase == ALL_LEADING_TRAILING_PHRASES
		     || previous_tallying_phrase == VALUE_REGION_PHRASE)) {
			cb_error (_("missing ALL/LEADING/TRAILING before value"));
		}
		break;

	/* LCOV_EXCL_START */
	default:
		/* This should never happen (and therefore doesn't get a translation) */
		cb_error ("unexpected tallying phrase");
		COBC_ABORT();
	/* LCOV_EXCL_STOP */
	}

	previous_tallying_phrase = phrase;
}

static int
is_recursive_call (cb_tree target)
{
	const char *target_name = "";

	if (CB_LITERAL_P (target)) {
		target_name = (const char *)(CB_LITERAL(target)->data);
	} else if (CB_REFERENCE_P (target)
	        && CB_PROTOTYPE_P (cb_ref (target))) {
		target_name = CB_PROTOTYPE (cb_ref (target))->ext_name;
	}

	return !strcmp (target_name, current_program->orig_program_id);
}

static cb_tree
check_not_88_level (cb_tree x)
{
	struct cb_field	*f;

	if (!CB_REF_OR_FIELD_P(x)) {
		/* note: this also applies to cb_error_node */
		return x;
	}

	f = CB_FIELD_PTR (x);

	if (f->level == 88) {
#if 0	/* note: we may consider to support the extension (if existing) to
		         reference a condition-name target by the condition-name */
		if (cb_verify (cb_condition_references_data, _("use of condition-name in place of data-name"))) {
			return CB_TREE (f->parent);
		}
#else
		cb_error (_("condition-name not allowed here: '%s'"), cb_name (x));
		/* invalidate field to prevent same error in typeck.c (validate_one) */
		/* FIXME: If we really need the additional check here then we missed
		          a call to cb_validate_one() somewhere */
		return cb_error_node;
#endif
	} else {
		return x;
	}
}

static int
is_screen_field (cb_tree x)
{
	if (CB_FIELD_P (x)) {
		return (CB_FIELD (x))->storage == CB_STORAGE_SCREEN;
	} else if (CB_REFERENCE_P (x)) {
		return is_screen_field (cb_ref (x));
	} else {
		return 0;
	}
}

static void
error_if_no_advancing_in_screen_display (cb_tree advancing)
{
	if (advancing != cb_int1) {
		cb_error (_("cannot specify NO ADVANCING in screen DISPLAY"));
	}
}

static cb_tree
get_default_display_device (void)
{
	if (current_program->flag_console_is_crt
	 || cb_console_is_crt) {
		return cb_null;
	} else {
		return cb_int0;
	}
}

static COB_INLINE COB_A_INLINE int
contains_one_screen_field (struct cb_list *l)
{
	return cb_list_length (CB_TREE(l)) == 1
		&& is_screen_field (l->value);
}

static int
contains_only_screen_fields (struct cb_list *l)
{
	for (; l; l = l->chain ? CB_LIST (l->chain) : NULL) {
		if (!is_screen_field (l->value)) {
			return 0;
		}
	}

	return 1;
}

static int
contains_fields_and_screens (struct cb_list *l)
{
	int	field_seen = 0;
	int	screen_seen = 0;

	for (; l; l = l->chain ? CB_LIST (l->chain) : NULL) {
		if (is_screen_field (l->value)) {
			screen_seen = 1;
		} else {
			field_seen = 1;
		}
	}

	return screen_seen && field_seen;
}

static enum cb_display_type
deduce_display_type (struct	cb_list *l, cb_tree local_upon_value, cb_tree local_line_column,
		     struct cb_attr_struct * const attr_ptr)
{
	int	using_default_device_which_is_crt =
		local_upon_value == NULL && get_default_display_device () == cb_null;

	/* TODO: Separate CGI DISPLAYs here */
	if (contains_only_screen_fields (l)) {
		if (!contains_one_screen_field (l)
		 || attr_ptr) {
			cb_verify_x (CB_TREE(l), cb_accept_display_extensions,
				     _("non-standard DISPLAY"));
		}

		if (local_upon_value != NULL && local_upon_value != cb_null) {
			cb_error_x (CB_TREE(l), _("screens may only be displayed on CRT"));
		}

		return SCREEN_DISPLAY;
	} else if (contains_fields_and_screens (l)) {
		cb_error_x (CB_TREE(l), _("cannot mix screens and fields in the same DISPLAY statement"));
		return MIXED_DISPLAY;
	} else if (local_line_column || attr_ptr) {
		if (local_upon_value != NULL && local_upon_value != cb_null) {
			cb_error_x (CB_TREE(l), _("screen clauses may only be used for DISPLAY on CRT"));
		}

		cb_verify_x (CB_TREE(l), cb_accept_display_extensions,
			     _("non-standard DISPLAY"));

		return FIELD_ON_SCREEN_DISPLAY;
	} else if (local_upon_value == cb_null || using_default_device_which_is_crt) {
		/* This is the only format permitted by the standard */
		return FIELD_ON_SCREEN_DISPLAY;
	} else if (display_type == FIELD_ON_SCREEN_DISPLAY && local_upon_value == NULL) {
		/* This is for when fields without clauses follow fields with screen clauses */
		return FIELD_ON_SCREEN_DISPLAY;
	} else {
		return DEVICE_DISPLAY;
	}
}

static void
set_display_type (struct cb_list *l, cb_tree local_upon_value,
		  cb_tree local_line_column, struct cb_attr_struct * const attr_ptr)
{
	display_type = deduce_display_type (l, local_upon_value, local_line_column, attr_ptr);
}

static void
error_if_different_display_type (struct cb_list *l, cb_tree local_upon_value,
				 cb_tree local_line_column, struct cb_attr_struct * const attr_ptr)
{
	const enum cb_display_type	type =
		deduce_display_type (l, local_upon_value, local_line_column, attr_ptr);

	/* Avoid re-displaying the same error for mixed DISPLAYs */
	if (type == display_type || display_type == MIXED_DISPLAY) {
		return;
	}

	if (type != MIXED_DISPLAY) {
		if (type == SCREEN_DISPLAY || display_type == SCREEN_DISPLAY) {
			cb_error_x (CB_TREE(l), _("cannot mix screens and fields in the same DISPLAY statement"));
		} else {
			/*
			  The only other option is that there is a mix of
			  FIELD_ON_SCREEN_DISPLAY and DEVICE_DISPLAY.
			*/
			cb_error_x (CB_TREE(l), _("ambiguous DISPLAY; put items to display on device in separate DISPLAY"));
		}
	}

	display_type = MIXED_DISPLAY;
}

static void
error_if_not_usage_display_or_nonnumeric_lit (cb_tree x)
{
	if (CB_NUMERIC_LITERAL_P (x)) {
		cb_error_x (x, _("%s is not an alphanumeric literal"), CB_LITERAL (x)->data);
	} else if (CB_REFERENCE_P (x) && CB_FIELD_P (cb_ref (x))) {
		const struct cb_field *f = CB_FIELD (cb_ref (x));
		if (f->usage != CB_USAGE_DISPLAY) {
			cb_error_x (x, _ ("'%s' is not USAGE DISPLAY"), cb_name (x));
		}
	}
}

/* guarantees a reference to a validated field-reference (or cb_error_node) */
static cb_tree
validated_field_reference (cb_tree fld_ref)
{
	cb_tree ref = NULL;
	if (CB_REFERENCE_P (fld_ref)) {
		ref = cb_ref (fld_ref);
		if (CB_FIELD_P (ref)) {
			return fld_ref;
		}
	}
	if (ref != cb_error_node) {
		cb_error_x (fld_ref, _ ("'%s' is not a field"), cb_name (fld_ref));
	}
	return cb_error_node;
}

static void
check_validate_item (cb_tree x)
{
	struct cb_field	*f;
	enum cb_class	tree_class;

	if (CB_INVALID_TREE(x) || x->tag != CB_TAG_REFERENCE) {
		return;
	}
	x = cb_ref (x);
	if (CB_INVALID_TREE (x) || !CB_FIELD_P (x)) {
		cb_error (_("invalid target for %s"), "VALIDATE");
		return;
	}

	f = CB_FIELD (x);
	tree_class = CB_TREE_CLASS(f);
	if (is_screen_field(x)) {
		cb_error (_("SCREEN item cannot be used here"));
	} else if (f->level == 66) {
		cb_error (_("RENAMES item may not be used here"));
	} else if (f->flag_any_length) {
		cb_error (_("ANY LENGTH item not allowed here"));
	} else if (tree_class == CB_CLASS_INDEX
		|| tree_class == CB_CLASS_OBJECT
		|| tree_class == CB_CLASS_POINTER) {
		cb_error (_("item '%s' has wrong class for VALIDATE"), cb_name (x));
	}
}

static void
error_if_following_every_clause (void)
{
	if (ml_suppress_list
	 && CB_ML_SUPPRESS (CB_VALUE (ml_suppress_list))->target == CB_ML_SUPPRESS_TYPE) {
		cb_error (_("WHEN clause must follow EVERY clause"));
	}
}

static void
prepend_to_ml_suppress_list (cb_tree suppress_entry)
{
	cb_tree	new_list_head = CB_LIST_INIT (suppress_entry);
	cb_list_append (new_list_head, ml_suppress_list);
	ml_suppress_list = new_list_head;
}

static void
add_identifier_to_ml_suppress_conds (cb_tree identifier)
{
	cb_tree suppress_id = cb_build_ml_suppress_clause ();
	CB_ML_SUPPRESS (suppress_id)->target = CB_ML_SUPPRESS_IDENTIFIER;
	CB_ML_SUPPRESS (suppress_id)->identifier = identifier;
	prepend_to_ml_suppress_list (suppress_id);
}

static void
add_when_to_ml_suppress_conds (cb_tree when_list)
{
	struct cb_ml_suppress_clause	*last_suppress_clause;
	cb_tree	suppress_all;

	/*
	  If the preceding clause in SUPPRESS was an identifier, the WHEN
	  belongs to the identifier. If EVERY was preceding, the WHEN belongs to
	  the EVERY. Otherwise, the WHEN acts on the entire record.
	*/
	if (ml_suppress_list) {
		last_suppress_clause = CB_ML_SUPPRESS (CB_VALUE (ml_suppress_list));
		if ( (last_suppress_clause->target == CB_ML_SUPPRESS_IDENTIFIER
		   || last_suppress_clause->target == CB_ML_SUPPRESS_TYPE)
		  && !last_suppress_clause->when_list) {
			last_suppress_clause->when_list = when_list;
			return;
		}
	}

	suppress_all = cb_build_ml_suppress_clause ();
	CB_ML_SUPPRESS (suppress_all)->when_list = when_list;
	prepend_to_ml_suppress_list (suppress_all);
}

static void
add_type_to_ml_suppress_conds (enum cb_ml_suppress_category category,
			       enum cb_ml_type ml_type)
{
	cb_tree	suppress_type = cb_build_ml_suppress_clause ();
	CB_ML_SUPPRESS (suppress_type)->target = CB_ML_SUPPRESS_TYPE;
	CB_ML_SUPPRESS (suppress_type)->category = category;
	CB_ML_SUPPRESS (suppress_type)->ml_type = ml_type;
	prepend_to_ml_suppress_list (suppress_type);
}

static void
set_record_size (cb_tree min, cb_tree max)
{
	int record_min, record_max;

	if (min) {
		record_min = cb_get_int (min);
		if (record_min < 0) {
			/* already handled by integer check */
		} else {
			current_file->record_min = record_min;
		}
	} else {
		record_min = 0;
	}
	if (!max) {
		return;
	}

	record_max = cb_get_int (max);
	if (record_max < 0) {
		/* already handled by integer check */
		return;
	} else if (record_max == 0) {
		/* Note: standard COBOL does not allow zero at all, use the related
		         configuration option */
		if (cb_records_mismatch_record_clause >= CB_ERROR) {
			cb_error (_("non-zero value expected"));
		}
		return;
	}
	if (current_file->organization == COB_ORG_INDEXED
	 && record_max > MAX_FD_RECORD_IDX)  {
		cb_error (_("RECORD size (IDX) exceeds maximum allowed (%d)"),
			MAX_FD_RECORD_IDX);
		current_file->record_max = MAX_FD_RECORD_IDX;
	} else if (record_max > MAX_FD_RECORD)  {
		cb_error (_("RECORD size exceeds maximum allowed (%d)"),
			MAX_FD_RECORD);
		current_file->record_max = MAX_FD_RECORD;
	} else {
		if (record_max <= record_min)  {
			cb_error (_("RECORD clause invalid"));
		}
		current_file->record_max = record_max;
	}
}


#line 2513 "parser.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Use api.header.include to #include this header
   instead of duplicating it here.  */
#ifndef YY_YY_PARSER_H_INCLUDED
# define YY_YY_PARSER_H_INCLUDED
/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif
#if YYDEBUG
extern int yydebug;
#endif

/* Token kinds.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
  enum yytokentype
  {
    YYEMPTY = -2,
    TOKEN_EOF = 0,                 /* "end of file"  */
    YYerror = 256,                 /* error  */
    YYUNDEF = 257,                 /* "invalid token"  */
    THREEDIMENSIONAL = 258,        /* "3D"  */
    ABSENT = 259,                  /* ABSENT  */
    ACCEPT = 260,                  /* ACCEPT  */
    ACCESS = 261,                  /* ACCESS  */
    ACTIVEX = 262,                 /* "ACTIVE-X"  */
    ACTIVE_CLASS = 263,            /* "ACTIVE-CLASS"  */
    ACTION = 264,                  /* ACTION  */
    ACTUAL = 265,                  /* ACTUAL  */
    ADD = 266,                     /* ADD  */
    ADDRESS = 267,                 /* ADDRESS  */
    ADJUSTABLE_COLUMNS = 268,      /* "ADJUSTABLE-COLUMNS"  */
    ADVANCING = 269,               /* ADVANCING  */
    AFTER = 270,                   /* AFTER  */
    ALIGNED = 271,                 /* ALIGNED  */
    ALIGNMENT = 272,               /* ALIGNMENT  */
    ALL = 273,                     /* ALL  */
    ALLOCATE = 274,                /* ALLOCATE  */
    ALLOWING = 275,                /* ALLOWING  */
    ALPHABET = 276,                /* ALPHABET  */
    ALPHABETIC = 277,              /* ALPHABETIC  */
    ALPHABETIC_LOWER = 278,        /* "ALPHABETIC-LOWER"  */
    ALPHABETIC_UPPER = 279,        /* "ALPHABETIC-UPPER"  */
    ALPHANUMERIC = 280,            /* ALPHANUMERIC  */
    ALPHANUMERIC_EDITED = 281,     /* "ALPHANUMERIC-EDITED"  */
    ALSO = 282,                    /* ALSO  */
    ALTER = 283,                   /* ALTER  */
    ALTERNATE = 284,               /* ALTERNATE  */
    AND = 285,                     /* AND  */
    ANY = 286,                     /* ANY  */
    APPLY = 287,                   /* APPLY  */
    ARE = 288,                     /* ARE  */
    AREA = 289,                    /* AREA  */
    AREAS = 290,                   /* AREAS  */
    ARGUMENT_NUMBER = 291,         /* "ARGUMENT-NUMBER"  */
    ARGUMENT_VALUE = 292,          /* "ARGUMENT-VALUE"  */
    ARITHMETIC = 293,              /* ARITHMETIC  */
    AS = 294,                      /* AS  */
    ASCENDING = 295,               /* ASCENDING  */
    ASCII = 296,                   /* ASCII  */
    ASSIGN = 297,                  /* ASSIGN  */
    AT = 298,                      /* AT  */
    AT_END = 299,                  /* "AT END"  */
    ATTRIBUTE = 300,               /* ATTRIBUTE  */
    ATTRIBUTES = 301,              /* ATTRIBUTES  */
    AUTHOR = 302,                  /* AUTHOR  */
    AUTO = 303,                    /* AUTO  */
    AUTO_DECIMAL = 304,            /* "AUTO-DECIMAL"  */
    AUTO_SPIN = 305,               /* "AUTO-SPIN"  */
    AUTOMATIC = 306,               /* AUTOMATIC  */
    AWAY_FROM_ZERO = 307,          /* "AWAY-FROM-ZERO"  */
    B_AND = 308,                   /* "B-AND"  */
    B_NOT = 309,                   /* "B-NOT"  */
    B_OR = 310,                    /* "B-OR"  */
    B_XOR = 311,                   /* "B-XOR"  */
    B_SHIFT_L = 312,               /* "B-SHIFT-L"  */
    B_SHIFT_R = 313,               /* "B-SHIFT-R"  */
    B_SHIFT_LC = 314,              /* "B-SHIFT-LC"  */
    B_SHIFT_RC = 315,              /* "B-SHIFT-RC"  */
    BACKGROUND_COLOR = 316,        /* "BACKGROUND-COLOR"  */
    BACKGROUND_HIGH = 317,         /* "BACKGROUND-HIGH"  */
    BACKGROUND_LOW = 318,          /* "BACKGROUND-LOW"  */
    BACKGROUND_STANDARD = 319,     /* "BACKGROUND-STANDARD"  */
    BACKWARD = 320,                /* BACKWARD  */
    BAR = 321,                     /* BAR  */
    BASED = 322,                   /* BASED  */
    BEFORE = 323,                  /* BEFORE  */
    BELL = 324,                    /* BELL  */
    BINARY = 325,                  /* BINARY  */
    BINARY_C_LONG = 326,           /* "BINARY-C-LONG"  */
    BINARY_CHAR = 327,             /* "BINARY-CHAR"  */
    BINARY_DOUBLE = 328,           /* "BINARY-DOUBLE"  */
    BINARY_LONG = 329,             /* "BINARY-LONG"  */
    BINARY_SEQUENTIAL = 330,       /* "BINARY-SEQUENTIAL"  */
    BINARY_SHORT = 331,            /* "BINARY-SHORT"  */
    BIT = 332,                     /* BIT  */
    BITMAP = 333,                  /* BITMAP  */
    BITMAP_END = 334,              /* "BITMAP-END"  */
    BITMAP_HANDLE = 335,           /* "BITMAP-HANDLE"  */
    BITMAP_NUMBER = 336,           /* "BITMAP-NUMBER"  */
    BITMAP_START = 337,            /* "BITMAP-START"  */
    BITMAP_TIMER = 338,            /* "BITMAP-TIMER"  */
    BITMAP_TRAILING = 339,         /* "BITMAP-TRAILING"  */
    BITMAP_TRANSPARENT_COLOR = 340, /* "BITMAP-TRANSPARENT-COLOR"  */
    BITMAP_WIDTH = 341,            /* "BITMAP-WIDTH"  */
    BLANK = 342,                   /* BLANK  */
    BLINK = 343,                   /* BLINK  */
    BLOCK = 344,                   /* BLOCK  */
    BOOLEAN = 345,                 /* BOOLEAN  */
    BOTTOM = 346,                  /* BOTTOM  */
    BOX = 347,                     /* BOX  */
    BOXED = 348,                   /* BOXED  */
    BULK_ADDITION = 349,           /* "BULK-ADDITION"  */
    BUSY = 350,                    /* BUSY  */
    BUTTONS = 351,                 /* BUTTONS  */
    BY = 352,                      /* BY  */
    BYTE_LENGTH = 353,             /* "BYTE-LENGTH"  */
    C = 354,                       /* C  */
    CALENDAR_FONT = 355,           /* "CALENDAR-FONT"  */
    CALL = 356,                    /* CALL  */
    CANCEL = 357,                  /* CANCEL  */
    CANCEL_BUTTON = 358,           /* "CANCEL-BUTTON"  */
    CAPACITY = 359,                /* CAPACITY  */
    CARD_PUNCH = 360,              /* "CARD-PUNCH"  */
    CARD_READER = 361,             /* "CARD-READER"  */
    CASSETTE = 362,                /* CASSETTE  */
    CCOL = 363,                    /* CCOL  */
    CD = 364,                      /* CD  */
    CELL = 365,                    /* CELL  */
    CELL_COLOR = 366,              /* "CELL-COLOR"  */
    CELL_DATA = 367,               /* "CELL-DATA"  */
    CELL_FONT = 368,               /* "CELL-FONT"  */
    CELL_PROTECTION = 369,         /* "CELL-PROTECTION"  */
    CENTER = 370,                  /* CENTER  */
    CENTERED = 371,                /* CENTERED  */
    CENTERED_HEADINGS = 372,       /* "CENTERED-HEADINGS"  */
    CENTURY_DATE = 373,            /* "CENTURY-DATE"  */
    CF = 374,                      /* CF  */
    CH = 375,                      /* CH  */
    CHAINING = 376,                /* CHAINING  */
    CHANGED = 377,                 /* CHANGED  */
    CHARACTER = 378,               /* CHARACTER  */
    CHARACTERS = 379,              /* CHARACTERS  */
    CHECK_BOX = 380,               /* "CHECK-BOX"  */
    CLASS = 381,                   /* CLASS  */
    CLASSIFICATION = 382,          /* CLASSIFICATION  */
    CLASS_NAME = 383,              /* "class-name"  */
    CLEAR_SELECTION = 384,         /* "CLEAR-SELECTION"  */
    CLINE = 385,                   /* CLINE  */
    CLINES = 386,                  /* CLINES  */
    CLOSE = 387,                   /* CLOSE  */
    COBOL = 388,                   /* COBOL  */
    CODE = 389,                    /* CODE  */
    CODE_SET = 390,                /* "CODE-SET"  */
    COLLATING = 391,               /* COLLATING  */
    COL = 392,                     /* COL  */
    COLOR = 393,                   /* COLOR  */
    COLORS = 394,                  /* COLORS  */
    COLS = 395,                    /* COLS  */
    COLUMN = 396,                  /* COLUMN  */
    COLUMN_COLOR = 397,            /* "COLUMN-COLOR"  */
    COLUMN_DIVIDERS = 398,         /* "COLUMN-DIVIDERS"  */
    COLUMN_FONT = 399,             /* "COLUMN-FONT"  */
    COLUMN_HEADINGS = 400,         /* "COLUMN-HEADINGS"  */
    COLUMN_PROTECTION = 401,       /* "COLUMN-PROTECTION"  */
    COLUMNS = 402,                 /* COLUMNS  */
    COMBO_BOX = 403,               /* "COMBO-BOX"  */
    COMMA = 404,                   /* COMMA  */
    COMMAND_LINE = 405,            /* "COMMAND-LINE"  */
    COMMA_DELIM = 406,             /* "comma delimiter"  */
    COMMIT = 407,                  /* COMMIT  */
    COMMON = 408,                  /* COMMON  */
    COMMUNICATION = 409,           /* COMMUNICATION  */
    COMP = 410,                    /* COMP  */
    COMPUTE = 411,                 /* COMPUTE  */
    COMP_0 = 412,                  /* "COMP-0"  */
    COMP_1 = 413,                  /* "COMP-1"  */
    COMP_2 = 414,                  /* "COMP-2"  */
    COMP_3 = 415,                  /* "COMP-3"  */
    COMP_4 = 416,                  /* "COMP-4"  */
    COMP_5 = 417,                  /* "COMP-5"  */
    COMP_6 = 418,                  /* "COMP-6"  */
    COMP_N = 419,                  /* "COMP-N"  */
    COMP_X = 420,                  /* "COMP-X"  */
    CONCATENATE_FUNC = 421,        /* "FUNCTION CONCATENATE"  */
    CONDITION = 422,               /* CONDITION  */
    CONFIGURATION = 423,           /* CONFIGURATION  */
    CONSTANT = 424,                /* CONSTANT  */
    CONTAINS = 425,                /* CONTAINS  */
    CONTENT = 426,                 /* CONTENT  */
    CONTENT_LENGTH_FUNC = 427,     /* "FUNCTION CONTENT-LENGTH"  */
    CONTENT_OF_FUNC = 428,         /* "FUNCTION CONTENT-OF"  */
    CONTINUE = 429,                /* CONTINUE  */
    CONTROL = 430,                 /* CONTROL  */
    CONTROLS = 431,                /* CONTROLS  */
    CONVERSION = 432,              /* CONVERSION  */
    CONVERTING = 433,              /* CONVERTING  */
    COPY = 434,                    /* COPY  */
    COPY_SELECTION = 435,          /* "COPY-SELECTION"  */
    CORE_INDEX = 436,              /* "CORE-INDEX"  */
    CORRESPONDING = 437,           /* CORRESPONDING  */
    COUNT = 438,                   /* COUNT  */
    CRT = 439,                     /* CRT  */
    CRT_UNDER = 440,               /* "CRT-UNDER"  */
    CSIZE = 441,                   /* CSIZE  */
    CURRENCY = 442,                /* CURRENCY  */
    CURRENT_DATE_FUNC = 443,       /* "FUNCTION CURRENT-DATE"  */
    CURSOR = 444,                  /* CURSOR  */
    CURSOR_COL = 445,              /* "CURSOR-COL"  */
    CURSOR_COLOR = 446,            /* "CURSOR-COLOR"  */
    CURSOR_FRAME_WIDTH = 447,      /* "CURSOR-FRAME-WIDTH"  */
    CURSOR_ROW = 448,              /* "CURSOR-ROW"  */
    CURSOR_X = 449,                /* "CURSOR-X"  */
    CURSOR_Y = 450,                /* "CURSOR-Y"  */
    CUSTOM_PRINT_TEMPLATE = 451,   /* "CUSTOM-PRINT-TEMPLATE"  */
    CYCLE = 452,                   /* CYCLE  */
    CYL_INDEX = 453,               /* "CYL-INDEX"  */
    CYL_OVERFLOW = 454,            /* "CYL-OVERFLOW"  */
    DASHED = 455,                  /* DASHED  */
    DATA = 456,                    /* DATA  */
    DATA_COLUMNS = 457,            /* "DATA-COLUMNS"  */
    DATA_POINTER = 458,            /* "DATA-POINTER"  */
    DATA_TYPES = 459,              /* "DATA-TYPES"  */
    DATE = 460,                    /* DATE  */
    DATE_COMPILED = 461,           /* "DATE-COMPILED"  */
    DATE_ENTRY = 462,              /* "DATE-ENTRY"  */
    DATE_MODIFIED = 463,           /* "DATE-MODIFIED"  */
    DATE_WRITTEN = 464,            /* "DATE-WRITTEN"  */
    DAY = 465,                     /* DAY  */
    DAY_OF_WEEK = 466,             /* "DAY-OF-WEEK"  */
    DE = 467,                      /* DE  */
    DEBUGGING = 468,               /* DEBUGGING  */
    DECIMAL_POINT = 469,           /* "DECIMAL-POINT"  */
    DECLARATIVES = 470,            /* DECLARATIVES  */
    DEFAULT = 471,                 /* DEFAULT  */
    DEFAULT_BUTTON = 472,          /* "DEFAULT-BUTTON"  */
    DEFAULT_FONT = 473,            /* "DEFAULT-FONT"  */
    DELETE = 474,                  /* DELETE  */
    DELIMITED = 475,               /* DELIMITED  */
    DELIMITER = 476,               /* DELIMITER  */
    DEPENDING = 477,               /* DEPENDING  */
    DESCENDING = 478,              /* DESCENDING  */
    DESTINATION = 479,             /* DESTINATION  */
    DESTROY = 480,                 /* DESTROY  */
    DETAIL = 481,                  /* DETAIL  */
    DISABLE = 482,                 /* DISABLE  */
    DISC = 483,                    /* DISC  */
    DISK = 484,                    /* DISK  */
    DISP = 485,                    /* DISP  */
    DISPLAY = 486,                 /* DISPLAY  */
    DISPLAY_1 = 487,               /* "DISPLAY-1"  */
    DISPLAY_COLUMNS = 488,         /* "DISPLAY-COLUMNS"  */
    DISPLAY_FORMAT = 489,          /* "DISPLAY-FORMAT"  */
    DISPLAY_OF_FUNC = 490,         /* "FUNCTION DISPLAY-OF"  */
    DIVIDE = 491,                  /* DIVIDE  */
    DIVIDERS = 492,                /* DIVIDERS  */
    DIVIDER_COLOR = 493,           /* "DIVIDER-COLOR"  */
    DIVISION = 494,                /* DIVISION  */
    DOTDASH = 495,                 /* DOTDASH  */
    DOTTED = 496,                  /* DOTTED  */
    DRAG_COLOR = 497,              /* "DRAG-COLOR"  */
    DROP_DOWN = 498,               /* "DROP-DOWN"  */
    DROP_LIST = 499,               /* "DROP-LIST"  */
    DOWN = 500,                    /* DOWN  */
    DUPLICATES = 501,              /* DUPLICATES  */
    DYNAMIC = 502,                 /* DYNAMIC  */
    EBCDIC = 503,                  /* EBCDIC  */
    EC = 504,                      /* EC  */
    ECHO = 505,                    /* ECHO  */
    EGI = 506,                     /* EGI  */
    EIGHTY_EIGHT = 507,            /* "level-number 88"  */
    ENABLE = 508,                  /* ENABLE  */
    ELEMENT = 509,                 /* ELEMENT  */
    ELSE = 510,                    /* ELSE  */
    EMI = 511,                     /* EMI  */
    ENCRYPTION = 512,              /* ENCRYPTION  */
    ENCODING = 513,                /* ENCODING  */
    END = 514,                     /* END  */
    END_ACCEPT = 515,              /* "END-ACCEPT"  */
    END_ADD = 516,                 /* "END-ADD"  */
    END_CALL = 517,                /* "END-CALL"  */
    END_COMPUTE = 518,             /* "END-COMPUTE"  */
    END_COLOR = 519,               /* "END-COLOR"  */
    END_DELETE = 520,              /* "END-DELETE"  */
    END_DISPLAY = 521,             /* "END-DISPLAY"  */
    END_DIVIDE = 522,              /* "END-DIVIDE"  */
    END_EVALUATE = 523,            /* "END-EVALUATE"  */
    END_FUNCTION = 524,            /* "END FUNCTION"  */
    END_IF = 525,                  /* "END-IF"  */
    END_JSON = 526,                /* "END-JSON"  */
    END_MODIFY = 527,              /* "END-MODIFY"  */
    END_MULTIPLY = 528,            /* "END-MULTIPLY"  */
    END_PERFORM = 529,             /* "END-PERFORM"  */
    END_PROGRAM = 530,             /* "END PROGRAM"  */
    END_READ = 531,                /* "END-READ"  */
    END_RECEIVE = 532,             /* "END-RECEIVE"  */
    END_RETURN = 533,              /* "END-RETURN"  */
    END_REWRITE = 534,             /* "END-REWRITE"  */
    END_SEARCH = 535,              /* "END-SEARCH"  */
    END_SEND = 536,                /* "END-SEND"  */
    END_START = 537,               /* "END-START"  */
    END_STRING = 538,              /* "END-STRING"  */
    END_SUBTRACT = 539,            /* "END-SUBTRACT"  */
    END_UNSTRING = 540,            /* "END-UNSTRING"  */
    END_WRITE = 541,               /* "END-WRITE"  */
    END_XML = 542,                 /* "END-XML"  */
    ENGRAVED = 543,                /* ENGRAVED  */
    ENSURE_VISIBLE = 544,          /* "ENSURE-VISIBLE"  */
    ENTRY = 545,                   /* ENTRY  */
    ENTRY_CONVENTION = 546,        /* "ENTRY-CONVENTION"  */
    ENTRY_FIELD = 547,             /* "ENTRY-FIELD"  */
    ENTRY_REASON = 548,            /* "ENTRY-REASON"  */
    ENVIRONMENT = 549,             /* ENVIRONMENT  */
    ENVIRONMENT_NAME = 550,        /* "ENVIRONMENT-NAME"  */
    ENVIRONMENT_VALUE = 551,       /* "ENVIRONMENT-VALUE"  */
    EOL = 552,                     /* EOL  */
    EOP = 553,                     /* EOP  */
    EOS = 554,                     /* EOS  */
    EQUAL = 555,                   /* EQUAL  */
    ERASE = 556,                   /* ERASE  */
    ERROR = 557,                   /* ERROR  */
    ESCAPE = 558,                  /* ESCAPE  */
    ESCAPE_BUTTON = 559,           /* "ESCAPE-BUTTON"  */
    ESI = 560,                     /* ESI  */
    EVALUATE = 561,                /* EVALUATE  */
    EVENT = 562,                   /* EVENT  */
    EVENT_LIST = 563,              /* "EVENT-LIST"  */
    EVENT_STATUS = 564,            /* "EVENT STATUS"  */
    EVERY = 565,                   /* EVERY  */
    EXAMINE = 566,                 /* EXAMINE  */
    EXCEPTION = 567,               /* EXCEPTION  */
    EXCEPTION_CONDITION = 568,     /* "EXCEPTION CONDITION"  */
    EXCEPTION_VALUE = 569,         /* "EXCEPTION-VALUE"  */
    EXPAND = 570,                  /* EXPAND  */
    EXCLUSIVE = 571,               /* EXCLUSIVE  */
    EXHIBIT = 572,                 /* EXHIBIT  */
    EXIT = 573,                    /* EXIT  */
    EXPONENTIATION = 574,          /* "exponentiation operator"  */
    EXTEND = 575,                  /* EXTEND  */
    EXTENDED_SEARCH = 576,         /* "EXTENDED-SEARCH"  */
    EXTERNAL = 577,                /* EXTERNAL  */
    EXTERNAL_FORM = 578,           /* "EXTERNAL-FORM"  */
    F = 579,                       /* F  */
    FACTORY = 580,                 /* FACTORY  */
    FD = 581,                      /* FD  */
    FH__FCD = 582,                 /* "FH--FCD"  */
    FH__KEYDEF = 583,              /* "FH--KEYDEF"  */
    FILE_CONTROL = 584,            /* "FILE-CONTROL"  */
    FILE_ID = 585,                 /* "FILE-ID"  */
    FILE_LIMIT = 586,              /* "FILE-LIMIT"  */
    FILE_LIMITS = 587,             /* "FILE-LIMITS"  */
    FILE_NAME = 588,               /* "FILE-NAME"  */
    FILE_POS = 589,                /* "FILE-POS"  */
    FILL_COLOR = 590,              /* "FILL-COLOR"  */
    FILL_COLOR2 = 591,             /* "FILL-COLOR2"  */
    FILL_PERCENT = 592,            /* "FILL-PERCENT"  */
    FILLER = 593,                  /* FILLER  */
    FINAL = 594,                   /* FINAL  */
    FINISH_REASON = 595,           /* "FINISH-REASON"  */
    FIRST = 596,                   /* FIRST  */
    FIXED = 597,                   /* FIXED  */
    FIXED_FONT = 598,              /* "FIXED-FONT"  */
    FIXED_WIDTH = 599,             /* "FIXED-WIDTH"  */
    FLAT = 600,                    /* FLAT  */
    FLAT_BUTTONS = 601,            /* "FLAT-BUTTONS"  */
    FLOAT_BINARY_128 = 602,        /* "FLOAT-BINARY-128"  */
    FLOAT_BINARY_32 = 603,         /* "FLOAT-BINARY-32"  */
    FLOAT_BINARY_64 = 604,         /* "FLOAT-BINARY-64"  */
    FLOAT_DECIMAL_16 = 605,        /* "FLOAT-DECIMAL-16"  */
    FLOAT_DECIMAL_34 = 606,        /* "FLOAT-DECIMAL-34"  */
    FLOAT_DECIMAL_7 = 607,         /* "FLOAT-DECIMAL-7"  */
    FLOAT_EXTENDED = 608,          /* "FLOAT-EXTENDED"  */
    FLOAT_LONG = 609,              /* "FLOAT-LONG"  */
    FLOAT_SHORT = 610,             /* "FLOAT-SHORT"  */
    FLOATING = 611,                /* FLOATING  */
    FONT = 612,                    /* FONT  */
    FOOTING = 613,                 /* FOOTING  */
    FOR = 614,                     /* FOR  */
    FOREGROUND_COLOR = 615,        /* "FOREGROUND-COLOR"  */
    FOREVER = 616,                 /* FOREVER  */
    FORMAT = 617,                  /* FORMAT  */
    FORMATTED_DATE_FUNC = 618,     /* "FUNCTION FORMATTED-DATE"  */
    FORMATTED_DATETIME_FUNC = 619, /* "FUNCTION FORMATTED-DATETIME"  */
    FORMATTED_TIME_FUNC = 620,     /* "FUNCTION FORMATTED-TIME"  */
    FRAME = 621,                   /* FRAME  */
    FRAMED = 622,                  /* FRAMED  */
    FREE = 623,                    /* FREE  */
    FROM = 624,                    /* FROM  */
    FROM_CRT = 625,                /* "FROM CRT"  */
    FULL = 626,                    /* FULL  */
    FULL_HEIGHT = 627,             /* "FULL-HEIGHT"  */
    FUNCTION = 628,                /* FUNCTION  */
    FUNCTION_ID = 629,             /* "FUNCTION-ID"  */
    FUNCTION_NAME = 630,           /* "intrinsic function name"  */
    FUNCTION_POINTER = 631,        /* "FUNCTION-POINTER"  */
    GENERATE = 632,                /* GENERATE  */
    GIVING = 633,                  /* GIVING  */
    GLOBAL = 634,                  /* GLOBAL  */
    GO = 635,                      /* GO  */
    GO_BACK = 636,                 /* "GO-BACK"  */
    GO_FORWARD = 637,              /* "GO-FORWARD"  */
    GO_HOME = 638,                 /* "GO-HOME"  */
    GO_SEARCH = 639,               /* "GO-SEARCH"  */
    GOBACK = 640,                  /* GOBACK  */
    GRAPHICAL = 641,               /* GRAPHICAL  */
    GREATER = 642,                 /* GREATER  */
    GREATER_OR_EQUAL = 643,        /* "GREATER OR EQUAL"  */
    GRID = 644,                    /* GRID  */
    GROUP = 645,                   /* GROUP  */
    GROUP_VALUE = 646,             /* "GROUP-VALUE"  */
    HANDLE = 647,                  /* HANDLE  */
    HAS_CHILDREN = 648,            /* "HAS-CHILDREN"  */
    HEADING = 649,                 /* HEADING  */
    HEADING_COLOR = 650,           /* "HEADING-COLOR"  */
    HEADING_DIVIDER_COLOR = 651,   /* "HEADING-DIVIDER-COLOR"  */
    HEADING_FONT = 652,            /* "HEADING-FONT"  */
    HEAVY = 653,                   /* HEAVY  */
    HEIGHT_IN_CELLS = 654,         /* "HEIGHT-IN-CELLS"  */
    HIDDEN_DATA = 655,             /* "HIDDEN-DATA"  */
    HIGHLIGHT = 656,               /* HIGHLIGHT  */
    HIGH_COLOR = 657,              /* "HIGH-COLOR"  */
    HIGH_VALUE = 658,              /* "HIGH-VALUE"  */
    HOT_TRACK = 659,               /* "HOT-TRACK"  */
    HSCROLL = 660,                 /* HSCROLL  */
    HSCROLL_POS = 661,             /* "HSCROLL-POS"  */
    ICON = 662,                    /* ICON  */
    ID = 663,                      /* ID  */
    IDENTIFIED = 664,              /* IDENTIFIED  */
    IDENTIFICATION = 665,          /* IDENTIFICATION  */
    IF = 666,                      /* IF  */
    IGNORE = 667,                  /* IGNORE  */
    IGNORING = 668,                /* IGNORING  */
    IN = 669,                      /* IN  */
    INDEPENDENT = 670,             /* INDEPENDENT  */
    INDEX = 671,                   /* INDEX  */
    INDEXED = 672,                 /* INDEXED  */
    INDICATE = 673,                /* INDICATE  */
    INITIALIZE = 674,              /* INITIALIZE  */
    INITIALIZED = 675,             /* INITIALIZED  */
    INITIATE = 676,                /* INITIATE  */
    INPUT = 677,                   /* INPUT  */
    INPUT_OUTPUT = 678,            /* "INPUT-OUTPUT"  */
    INQUIRE = 679,                 /* INQUIRE  */
    INSERTION_INDEX = 680,         /* "INSERTION-INDEX"  */
    INSERT_ROWS = 681,             /* "INSERT-ROWS"  */
    INSPECT = 682,                 /* INSPECT  */
    INSTALLATION = 683,            /* INSTALLATION  */
    INTERMEDIATE = 684,            /* INTERMEDIATE  */
    INTO = 685,                    /* INTO  */
    INTRINSIC = 686,               /* INTRINSIC  */
    INVALID = 687,                 /* INVALID  */
    INVALID_KEY = 688,             /* "INVALID KEY"  */
    IS = 689,                      /* IS  */
    ITEM = 690,                    /* ITEM  */
    ITEM_TEXT = 691,               /* "ITEM-TEXT"  */
    ITEM_TO_ADD = 692,             /* "ITEM-TO_ADD"  */
    ITEM_TO_DELETE = 693,          /* "ITEM-TO_DELETE"  */
    ITEM_TO_EMPTY = 694,           /* "ITEM-TO_EMPTY"  */
    ITEM_VALUE = 695,              /* "ITEM-VALUE"  */
    I_O = 696,                     /* "I-O"  */
    I_O_CONTROL = 697,             /* "I-O-CONTROL"  */
    JSON = 698,                    /* JSON  */
    JUSTIFIED = 699,               /* JUSTIFIED  */
    KEPT = 700,                    /* KEPT  */
    KEY = 701,                     /* KEY  */
    KEYBOARD = 702,                /* KEYBOARD  */
    LABEL = 703,                   /* LABEL  */
    LABEL_OFFSET = 704,            /* "LABEL-OFFSET"  */
    LARGE_FONT = 705,              /* "LARGE-FONT"  */
    LARGE_OFFSET = 706,            /* "LARGE-OFFSET"  */
    LAST = 707,                    /* LAST  */
    LAST_ROW = 708,                /* "LAST-ROW"  */
    LAYOUT_DATA = 709,             /* "LAYOUT-DATA"  */
    LAYOUT_MANAGER = 710,          /* "LAYOUT-MANAGER"  */
    LEADING = 711,                 /* LEADING  */
    LEADING_SHIFT = 712,           /* "LEADING-SHIFT"  */
    LEAVE = 713,                   /* LEAVE  */
    LEFT = 714,                    /* LEFT  */
    LEFTLINE = 715,                /* LEFTLINE  */
    LEFT_TEXT = 716,               /* "LEFT-TEXT"  */
    LENGTH = 717,                  /* LENGTH  */
    LENGTH_OF = 718,               /* "LENGTH OF"  */
    LENGTH_FUNC = 719,             /* "FUNCTION LENGTH/BYTE-LENGTH"  */
    LESS = 720,                    /* LESS  */
    LESS_OR_EQUAL = 721,           /* "LESS OR EQUAL"  */
    LEVEL_NUMBER = 722,            /* "level-number"  */
    LIKE = 723,                    /* LIKE  */
    LIMIT = 724,                   /* LIMIT  */
    LIMITS = 725,                  /* LIMITS  */
    LINAGE = 726,                  /* LINAGE  */
    LINAGE_COUNTER = 727,          /* "LINAGE-COUNTER"  */
    LINE = 728,                    /* LINE  */
    LINE_COUNTER = 729,            /* "LINE-COUNTER"  */
    LINE_LIMIT = 730,              /* "LINE LIMIT"  */
    LINE_SEQUENTIAL = 731,         /* "LINE-SEQUENTIAL"  */
    LINES = 732,                   /* LINES  */
    LINES_AT_ROOT = 733,           /* "LINES-AT-ROOT"  */
    LINKAGE = 734,                 /* LINKAGE  */
    LIST_BOX = 735,                /* "LIST-BOX"  */
    LITERAL = 736,                 /* "Literal"  */
    LM_RESIZE = 737,               /* "LM-RESIZE"  */
    LOC = 738,                     /* LOC  */
    LOCALE = 739,                  /* LOCALE  */
    LOCALE_DATE_FUNC = 740,        /* "FUNCTION LOCALE-DATE"  */
    LOCALE_TIME_FUNC = 741,        /* "FUNCTION LOCALE-TIME"  */
    LOCALE_TIME_FROM_FUNC = 742,   /* "FUNCTION LOCALE-TIME-FROM-SECONDS"  */
    LOCAL_STORAGE = 743,           /* "LOCAL-STORAGE"  */
    LOCK = 744,                    /* LOCK  */
    LOCK_HOLDING = 745,            /* "LOCK-HOLDING"  */
    LONG_DATE = 746,               /* "LONG-DATE"  */
    LOWER = 747,                   /* LOWER  */
    LOWERED = 748,                 /* LOWERED  */
    LOWER_CASE_FUNC = 749,         /* "FUNCTION LOWER-CASE"  */
    LOWLIGHT = 750,                /* LOWLIGHT  */
    LOW_COLOR = 751,               /* "LOW-COLOR"  */
    LOW_VALUE = 752,               /* "LOW-VALUE"  */
    MAGNETIC_TAPE = 753,           /* "MAGNETIC-TAPE"  */
    MANUAL = 754,                  /* MANUAL  */
    MASS_UPDATE = 755,             /* "MASS-UPDATE"  */
    MASTER_INDEX = 756,            /* "MASTER-INDEX"  */
    MAX_LINES = 757,               /* "MAX-LINES"  */
    MAX_PROGRESS = 758,            /* "MAX-PROGRESS"  */
    MAX_TEXT = 759,                /* "MAX-TEXT"  */
    MAX_VAL = 760,                 /* "MAX-VAL"  */
    MEMORY = 761,                  /* MEMORY  */
    MEDIUM_FONT = 762,             /* "MEDIUM-FONT"  */
    MENU = 763,                    /* MENU  */
    MERGE = 764,                   /* MERGE  */
    MESSAGE = 765,                 /* MESSAGE  */
    MICROSECOND_TIME = 766,        /* "MICROSECOND-TIME"  */
    MINUS = 767,                   /* MINUS  */
    MIN_VAL = 768,                 /* "MIN-VAL"  */
    MNEMONIC_NAME = 769,           /* "Mnemonic name"  */
    MODE = 770,                    /* MODE  */
    MODIFY = 771,                  /* MODIFY  */
    MODULES = 772,                 /* MODULES  */
    MOVE = 773,                    /* MOVE  */
    MULTILINE = 774,               /* MULTILINE  */
    MULTIPLE = 775,                /* MULTIPLE  */
    MULTIPLY = 776,                /* MULTIPLY  */
    NAME = 777,                    /* NAME  */
    NAMED = 778,                   /* NAMED  */
    NAMESPACE = 779,               /* NAMESPACE  */
    NAMESPACE_PREFIX = 780,        /* "NAMESPACE-PREFIX"  */
    NATIONAL = 781,                /* NATIONAL  */
    NATIONAL_EDITED = 782,         /* "NATIONAL-EDITED"  */
    NATIONAL_OF_FUNC = 783,        /* "FUNCTION NATIONAL-OF"  */
    NATIVE = 784,                  /* NATIVE  */
    NAVIGATE_URL = 785,            /* "NAVIGATE-URL"  */
    NEAREST_AWAY_FROM_ZERO = 786,  /* "NEAREST-AWAY-FROM-ZERO"  */
    NEAREST_EVEN = 787,            /* "NEAREST-EVEN"  */
    NEAREST_TOWARD_ZERO = 788,     /* "NEAREST-TOWARD-ZERO"  */
    NEGATIVE = 789,                /* NEGATIVE  */
    NESTED = 790,                  /* NESTED  */
    NEW = 791,                     /* NEW  */
    NEXT = 792,                    /* NEXT  */
    NEXT_ITEM = 793,               /* "NEXT-ITEM"  */
    NEXT_GROUP = 794,              /* "NEXT GROUP"  */
    NEXT_PAGE = 795,               /* "NEXT PAGE"  */
    NO = 796,                      /* NO  */
    NO_ADVANCING = 797,            /* "NO ADVANCING"  */
    NO_AUTOSEL = 798,              /* "NO-AUTOSEL"  */
    NO_AUTO_DEFAULT = 799,         /* "NO-AUTO-DEFAULT"  */
    NO_BOX = 800,                  /* "NO-BOX"  */
    NO_DATA = 801,                 /* "NO DATA"  */
    NO_DIVIDERS = 802,             /* "NO-DIVIDERS"  */
    NO_ECHO = 803,                 /* "NO-ECHO"  */
    NO_F4 = 804,                   /* "NO-F4"  */
    NO_FOCUS = 805,                /* "NO-FOCUS"  */
    NO_GROUP_TAB = 806,            /* "NO-GROUP-TAB"  */
    NO_KEY_LETTER = 807,           /* "NO-KEY-LETTER"  */
    NO_SEARCH = 808,               /* "NO-SEARCH"  */
    NO_UPDOWN = 809,               /* "NO-UPDOWN"  */
    NOMINAL = 810,                 /* NOMINAL  */
    NONE = 811,                    /* NONE  */
    NONNUMERIC = 812,              /* NONNUMERIC  */
    NORMAL = 813,                  /* NORMAL  */
    NOT = 814,                     /* NOT  */
    NOTAB = 815,                   /* NOTAB  */
    NOTHING = 816,                 /* NOTHING  */
    NOTIFY = 817,                  /* NOTIFY  */
    NOTIFY_CHANGE = 818,           /* "NOTIFY-CHANGE"  */
    NOTIFY_DBLCLICK = 819,         /* "NOTIFY-DBLCLICK"  */
    NOTIFY_SELCHANGE = 820,        /* "NOTIFY-SELCHANGE"  */
    NOT_AT_END = 821,              /* "NOT AT END"  */
    NOT_EOP = 822,                 /* "NOT AT EOP"  */
    NOT_ON_ESCAPE = 823,           /* "NOT ON ESCAPE"  */
    NOT_EQUAL = 824,               /* "NOT EQUAL"  */
    NOT_ON_EXCEPTION = 825,        /* "NOT ON EXCEPTION"  */
    NOT_INVALID_KEY = 826,         /* "NOT INVALID KEY"  */
    NOT_ON_OVERFLOW = 827,         /* "NOT ON OVERFLOW"  */
    NOT_SIZE_ERROR = 828,          /* "NOT SIZE ERROR"  */
    NUM_COL_HEADINGS = 829,        /* "NUM-COL-HEADINGS"  */
    NUM_ROWS = 830,                /* "NUM-ROWS"  */
    NUMBER = 831,                  /* NUMBER  */
    NUMBERS = 832,                 /* NUMBERS  */
    NUMERIC = 833,                 /* NUMERIC  */
    NUMERIC_EDITED = 834,          /* "NUMERIC-EDITED"  */
    NUMVALC_FUNC = 835,            /* "FUNCTION NUMVAL-C"  */
    OBJECT = 836,                  /* OBJECT  */
    OBJECT_COMPUTER = 837,         /* "OBJECT-COMPUTER"  */
    OCCURS = 838,                  /* OCCURS  */
    OF = 839,                      /* OF  */
    OFF = 840,                     /* OFF  */
    OK_BUTTON = 841,               /* "OK-BUTTON"  */
    OMITTED = 842,                 /* OMITTED  */
    ON = 843,                      /* ON  */
    ONLY = 844,                    /* ONLY  */
    ON_ESCAPE = 845,               /* "ON ESCAPE"  */
    ON_EXCEPTION = 846,            /* "ON EXCEPTION"  */
    OPEN = 847,                    /* OPEN  */
    OPTIONAL = 848,                /* OPTIONAL  */
    OPTIONS = 849,                 /* OPTIONS  */
    OR = 850,                      /* OR  */
    ORDER = 851,                   /* ORDER  */
    ORGANIZATION = 852,            /* ORGANIZATION  */
    OTHER = 853,                   /* OTHER  */
    OTHERS = 854,                  /* OTHERS  */
    OUTPUT = 855,                  /* OUTPUT  */
    OVERLAP_LEFT = 856,            /* "OVERLAP-LEFT"  */
    OVERLAP_TOP = 857,             /* "OVERLAP-TOP"  */
    OVERLINE = 858,                /* OVERLINE  */
    PACKED_DECIMAL = 859,          /* "PACKED-DECIMAL"  */
    PADDING = 860,                 /* PADDING  */
    PASCAL = 861,                  /* PASCAL  */
    PAGE = 862,                    /* PAGE  */
    PAGE_COUNTER = 863,            /* "PAGE-COUNTER"  */
    PAGE_SETUP = 864,              /* "PAGE-SETUP"  */
    PAGED = 865,                   /* PAGED  */
    PARAGRAPH = 866,               /* PARAGRAPH  */
    PARENT = 867,                  /* PARENT  */
    PARSE = 868,                   /* PARSE  */
    PASSWORD = 869,                /* PASSWORD  */
    PERFORM = 870,                 /* PERFORM  */
    PERMANENT = 871,               /* PERMANENT  */
    PH = 872,                      /* PH  */
    PF = 873,                      /* PF  */
    PHYSICAL = 874,                /* PHYSICAL  */
    PICTURE = 875,                 /* PICTURE  */
    PICTURE_SYMBOL = 876,          /* "PICTURE SYMBOL"  */
    PIXEL = 877,                   /* PIXEL  */
    PLACEMENT = 878,               /* PLACEMENT  */
    PLUS = 879,                    /* PLUS  */
    POINTER = 880,                 /* POINTER  */
    POP_UP = 881,                  /* "POP-UP"  */
    POS = 882,                     /* POS  */
    POSITION = 883,                /* POSITION  */
    POSITION_SHIFT = 884,          /* "POSITION-SHIFT"  */
    POSITIVE = 885,                /* POSITIVE  */
    PRESENT = 886,                 /* PRESENT  */
    PREVIOUS = 887,                /* PREVIOUS  */
    PRINT = 888,                   /* PRINT  */
    PRINT_CONTROL = 889,           /* "PRINT-CONTROL"  */
    PRINT_NO_PROMPT = 890,         /* "PRINT-NO-PROMPT"  */
    PRINT_PREVIEW = 891,           /* "PRINT-PREVIEW"  */
    PRINTER = 892,                 /* PRINTER  */
    PRINTER_1 = 893,               /* "PRINTER-1"  */
    PRINTING = 894,                /* PRINTING  */
    PRIORITY = 895,                /* PRIORITY  */
    PROCEDURE = 896,               /* PROCEDURE  */
    PROCEDURES = 897,              /* PROCEDURES  */
    PROCEED = 898,                 /* PROCEED  */
    PROCESSING = 899,              /* PROCESSING  */
    PROGRAM = 900,                 /* PROGRAM  */
    PROGRAM_ID = 901,              /* "PROGRAM-ID"  */
    PROGRAM_NAME = 902,            /* "program name"  */
    PROGRAM_POINTER = 903,         /* "PROGRAM-POINTER"  */
    PROGRESS = 904,                /* PROGRESS  */
    PROHIBITED = 905,              /* PROHIBITED  */
    PROMPT = 906,                  /* PROMPT  */
    PROPERTIES = 907,              /* PROPERTIES  */
    PROPERTY = 908,                /* PROPERTY  */
    PROTECTED = 909,               /* PROTECTED  */
    PROTOTYPE = 910,               /* PROTOTYPE  */
    PURGE = 911,                   /* PURGE  */
    PUSH_BUTTON = 912,             /* "PUSH-BUTTON"  */
    QUERY_INDEX = 913,             /* "QUERY-INDEX"  */
    QUEUE = 914,                   /* QUEUE  */
    QUOTE = 915,                   /* QUOTE  */
    RADIO_BUTTON = 916,            /* "RADIO-BUTTON"  */
    RAISE = 917,                   /* RAISE  */
    RAISED = 918,                  /* RAISED  */
    RAISING = 919,                 /* RAISING  */
    RANDOM = 920,                  /* RANDOM  */
    RD = 921,                      /* RD  */
    READ = 922,                    /* READ  */
    READERS = 923,                 /* READERS  */
    READ_ONLY = 924,               /* "READ-ONLY"  */
    READY_TRACE = 925,             /* "READY TRACE"  */
    RECEIVE = 926,                 /* RECEIVE  */
    RECEIVED = 927,                /* RECEIVED  */
    RECORD = 928,                  /* RECORD  */
    RECORD_DATA = 929,             /* "RECORD-DATA"  */
    RECORD_OVERFLOW = 930,         /* "RECORD-OVERFLOW"  */
    RECORD_TO_ADD = 931,           /* "RECORD-TO-ADD"  */
    RECORD_TO_DELETE = 932,        /* "RECORD-TO-DELETE"  */
    RECORDING = 933,               /* RECORDING  */
    RECORDS = 934,                 /* RECORDS  */
    RECURSIVE = 935,               /* RECURSIVE  */
    REDEFINES = 936,               /* REDEFINES  */
    REEL = 937,                    /* REEL  */
    REFERENCE = 938,               /* REFERENCE  */
    REFERENCES = 939,              /* REFERENCES  */
    REFRESH = 940,                 /* REFRESH  */
    REGION_COLOR = 941,            /* "REGION-COLOR"  */
    RELATION = 942,                /* RELATION  */
    RELATIVE = 943,                /* RELATIVE  */
    RELEASE = 944,                 /* RELEASE  */
    REMAINDER = 945,               /* REMAINDER  */
    REMARKS = 946,                 /* REMARKS  */
    REMOVAL = 947,                 /* REMOVAL  */
    RENAMES = 948,                 /* RENAMES  */
    REORG_CRITERIA = 949,          /* "REORG-CRITERIA"  */
    REPEATED = 950,                /* REPEATED  */
    REPLACE = 951,                 /* REPLACE  */
    REPLACING = 952,               /* REPLACING  */
    REPORT = 953,                  /* REPORT  */
    REPORTING = 954,               /* REPORTING  */
    REPORTS = 955,                 /* REPORTS  */
    REPOSITORY = 956,              /* REPOSITORY  */
    REQUIRED = 957,                /* REQUIRED  */
    REREAD = 958,                  /* REREAD  */
    RERUN = 959,                   /* RERUN  */
    RESERVE = 960,                 /* RESERVE  */
    RESET = 961,                   /* RESET  */
    RESET_TRACE = 962,             /* "RESET TRACE"  */
    RESET_GRID = 963,              /* "RESET-GRID"  */
    RESET_LIST = 964,              /* "RESET-LIST"  */
    RESET_TABS = 965,              /* "RESET-TABS"  */
    RETRY = 966,                   /* RETRY  */
    RETURN = 967,                  /* RETURN  */
    RETURNING = 968,               /* RETURNING  */
    REVERSE = 969,                 /* REVERSE  */
    REVERSE_FUNC = 970,            /* "FUNCTION REVERSE"  */
    REVERSE_VIDEO = 971,           /* "REVERSE-VIDEO"  */
    REVERSED = 972,                /* REVERSED  */
    REWIND = 973,                  /* REWIND  */
    REWRITE = 974,                 /* REWRITE  */
    RF = 975,                      /* RF  */
    RH = 976,                      /* RH  */
    RIGHT = 977,                   /* RIGHT  */
    RIGHT_ALIGN = 978,             /* "RIGHT-ALIGN"  */
    RIGHTLINE = 979,               /* RIGHTLINE  */
    RIMMED = 980,                  /* RIMMED  */
    ROLLBACK = 981,                /* ROLLBACK  */
    ROUNDED = 982,                 /* ROUNDED  */
    ROUNDING = 983,                /* ROUNDING  */
    ROW_COLOR = 984,               /* "ROW-COLOR"  */
    ROW_COLOR_PATTERN = 985,       /* "ROW-COLOR-PATTERN"  */
    ROW_DIVIDERS = 986,            /* "ROW-DIVIDERS"  */
    ROW_FONT = 987,                /* "ROW-FONT"  */
    ROW_HEADINGS = 988,            /* "ROW-HEADINGS"  */
    ROW_PROTECTION = 989,          /* "ROW-PROTECTION"  */
    RUN = 990,                     /* RUN  */
    S = 991,                       /* S  */
    SAME = 992,                    /* SAME  */
    SAVE_AS = 993,                 /* "SAVE-AS"  */
    SAVE_AS_NO_PROMPT = 994,       /* "SAVE-AS-NO-PROMPT"  */
    SCREEN = 995,                  /* SCREEN  */
    SCREEN_CONTROL = 996,          /* "SCREEN CONTROL"  */
    SCROLL = 997,                  /* SCROLL  */
    SCROLL_BAR = 998,              /* "SCROLL-BAR"  */
    SD = 999,                      /* SD  */
    SEARCH = 1000,                 /* SEARCH  */
    SEARCH_OPTIONS = 1001,         /* "SEARCH-OPTIONS"  */
    SEARCH_TEXT = 1002,            /* "SEARCH-TEXT"  */
    SECONDS = 1003,                /* SECONDS  */
    SECTION = 1004,                /* SECTION  */
    SECURE = 1005,                 /* SECURE  */
    SECURITY = 1006,               /* SECURITY  */
    SEGMENT = 1007,                /* SEGMENT  */
    SEGMENT_LIMIT = 1008,          /* "SEGMENT-LIMIT"  */
    SELECT = 1009,                 /* SELECT  */
    SELECTION_INDEX = 1010,        /* "SELECTION-INDEX"  */
    SELECTION_TEXT = 1011,         /* "SELECTION-TEXT"  */
    SELECT_ALL = 1012,             /* "SELECTION-ALL"  */
    SELF_ACT = 1013,               /* "SELF-ACT"  */
    SEMI_COLON = 1014,             /* "semi-colon"  */
    SEND = 1015,                   /* SEND  */
    SENTENCE = 1016,               /* SENTENCE  */
    SEPARATE = 1017,               /* SEPARATE  */
    SEPARATION = 1018,             /* SEPARATION  */
    SEQUENCE = 1019,               /* SEQUENCE  */
    SEQUENTIAL = 1020,             /* SEQUENTIAL  */
    SET = 1021,                    /* SET  */
    SEVENTY_EIGHT = 1022,          /* "level-number 78"  */
    SHADING = 1023,                /* SHADING  */
    SHADOW = 1024,                 /* SHADOW  */
    SHARING = 1025,                /* SHARING  */
    SHORT_DATE = 1026,             /* "SHORT-DATE"  */
    SHOW_LINES = 1027,             /* "SHOW-LINES"  */
    SHOW_NONE = 1028,              /* "SHOW-NONE"  */
    SHOW_SEL_ALWAYS = 1029,        /* "SHOW-SEL-ALWAYS"  */
    SIGN = 1030,                   /* SIGN  */
    SIGNED = 1031,                 /* SIGNED  */
    SIGNED_INT = 1032,             /* "SIGNED-INT"  */
    SIGNED_LONG = 1033,            /* "SIGNED-LONG"  */
    SIGNED_SHORT = 1034,           /* "SIGNED-SHORT"  */
    SIXTY_SIX = 1035,              /* "level-number 66"  */
    SIZE = 1036,                   /* SIZE  */
    SIZE_ERROR = 1037,             /* "SIZE ERROR"  */
    SMALL_FONT = 1038,             /* "SMALL-FONT"  */
    SORT = 1039,                   /* SORT  */
    SORT_MERGE = 1040,             /* "SORT-MERGE"  */
    SORT_ORDER = 1041,             /* "SORT-ORDER"  */
    SOURCE = 1042,                 /* SOURCE  */
    SOURCE_COMPUTER = 1043,        /* "SOURCE-COMPUTER"  */
    SPACE = 1044,                  /* SPACE  */
    SPECIAL_NAMES = 1045,          /* "SPECIAL-NAMES"  */
    SPINNER = 1046,                /* SPINNER  */
    SQUARE = 1047,                 /* SQUARE  */
    STANDARD = 1048,               /* STANDARD  */
    STANDARD_1 = 1049,             /* "STANDARD-1"  */
    STANDARD_2 = 1050,             /* "STANDARD-2"  */
    STANDARD_BINARY = 1051,        /* "STANDARD-BINARY"  */
    STANDARD_DECIMAL = 1052,       /* "STANDARD-DECIMAL"  */
    START = 1053,                  /* START  */
    START_X = 1054,                /* "START-X"  */
    START_Y = 1055,                /* "START-Y"  */
    STATIC = 1056,                 /* STATIC  */
    STATIC_LIST = 1057,            /* "STATIC-LIST"  */
    STATUS = 1058,                 /* STATUS  */
    STATUS_BAR = 1059,             /* "STATUS-BAR"  */
    STATUS_TEXT = 1060,            /* "STATUS-TEXT"  */
    STDCALL = 1061,                /* STDCALL  */
    STEP = 1062,                   /* STEP  */
    STOP = 1063,                   /* STOP  */
    STRING = 1064,                 /* STRING  */
    STRONG = 1065,                 /* STRONG  */
    STYLE = 1066,                  /* STYLE  */
    SUB_QUEUE_1 = 1067,            /* "SUB-QUEUE-1"  */
    SUB_QUEUE_2 = 1068,            /* "SUB-QUEUE-2"  */
    SUB_QUEUE_3 = 1069,            /* "SUB-QUEUE-3"  */
    SUBSTITUTE_FUNC = 1070,        /* "FUNCTION SUBSTITUTE"  */
    SUBSTITUTE_CASE_FUNC = 1071,   /* "FUNCTION SUBSTITUTE-CASE"  */
    SUBTRACT = 1072,               /* SUBTRACT  */
    SUBWINDOW = 1073,              /* SUBWINDOW  */
    SUM = 1074,                    /* SUM  */
    SUPPRESS = 1075,               /* SUPPRESS  */
    SUPPRESS_XML = 1076,           /* "SUPPRESS"  */
    SYMBOLIC = 1077,               /* SYMBOLIC  */
    SYNCHRONIZED = 1078,           /* SYNCHRONIZED  */
    SYSTEM_DEFAULT = 1079,         /* "SYSTEM-DEFAULT"  */
    SYSTEM_INFO = 1080,            /* "SYSTEM-INFO"  */
    SYSTEM_OFFSET = 1081,          /* "SYSTEM-OFFSET"  */
    TAB = 1082,                    /* TAB  */
    TAB_TO_ADD = 1083,             /* "TAB-TO-ADD"  */
    TAB_TO_DELETE = 1084,          /* "TAB-TO-DELETE"  */
    TABLE = 1085,                  /* TABLE  */
    TALLYING = 1086,               /* TALLYING  */
    TEMPORARY = 1087,              /* TEMPORARY  */
    TAPE = 1088,                   /* TAPE  */
    TERMINAL = 1089,               /* TERMINAL  */
    TERMINATE = 1090,              /* TERMINATE  */
    TERMINAL_INFO = 1091,          /* "TERMINAL-INFO"  */
    TERMINATION_VALUE = 1092,      /* "TERMINATION-VALUE"  */
    TEST = 1093,                   /* TEST  */
    TEXT = 1094,                   /* TEXT  */
    THAN = 1095,                   /* THAN  */
    THEN = 1096,                   /* THEN  */
    THREAD = 1097,                 /* THREAD  */
    THREADS = 1098,                /* THREADS  */
    THRU = 1099,                   /* THRU  */
    THUMB_POSITION = 1100,         /* "THUMB-POSITION"  */
    TILED_HEADINGS = 1101,         /* "TILED-HEADINGS"  */
    TIME = 1102,                   /* TIME  */
    TIME_OUT = 1103,               /* "TIME-OUT"  */
    TIMES = 1104,                  /* TIMES  */
    TITLE = 1105,                  /* TITLE  */
    TITLE_POSITION = 1106,         /* "TITLE-POSITION"  */
    TO = 1107,                     /* TO  */
    TOK_AMPER = 1108,              /* "&"  */
    TOK_CLOSE_PAREN = 1109,        /* ")"  */
    TOK_COLON = 1110,              /* ":"  */
    TOK_DIV = 1111,                /* "/"  */
    TOK_DOT = 1112,                /* "."  */
    TOK_EQUAL = 1113,              /* "="  */
    TOK_EXTERN = 1114,             /* "EXTERN"  */
    TOK_FALSE = 1115,              /* "FALSE"  */
    TOK_FILE = 1116,               /* "FILE"  */
    TOK_GREATER = 1117,            /* ">"  */
    TOK_INITIAL = 1118,            /* "INITIAL"  */
    TOK_LESS = 1119,               /* "<"  */
    TOK_MINUS = 1120,              /* "-"  */
    TOK_MUL = 1121,                /* "*"  */
    TOK_NULL = 1122,               /* "NULL"  */
    TOK_OVERFLOW = 1123,           /* "OVERFLOW"  */
    TOK_OPEN_PAREN = 1124,         /* "("  */
    TOK_PLUS = 1125,               /* "+"  */
    TOK_TRUE = 1126,               /* "TRUE"  */
    TOP = 1127,                    /* TOP  */
    TOWARD_GREATER = 1128,         /* "TOWARD-GREATER"  */
    TOWARD_LESSER = 1129,          /* "TOWARD-LESSER"  */
    TRACK = 1130,                  /* TRACK  */
    TRACKS = 1131,                 /* TRACKS  */
    TRACK_AREA = 1132,             /* "TRACK-AREA"  */
    TRACK_LIMIT = 1133,            /* "TRACK-LIMIT"  */
    TRADITIONAL_FONT = 1134,       /* "TRADITIONAL-FONT"  */
    TRAILING = 1135,               /* TRAILING  */
    TRAILING_SHIFT = 1136,         /* "TRAILING-SHIFT"  */
    TRANSFORM = 1137,              /* TRANSFORM  */
    TRANSPARENT = 1138,            /* TRANSPARENT  */
    TREE_VIEW = 1139,              /* "TREE-VIEW"  */
    TRIM_FUNC = 1140,              /* "FUNCTION TRIM"  */
    TRUNCATION = 1141,             /* TRUNCATION  */
    TYPE = 1142,                   /* TYPE  */
    TYPEDEF = 1143,                /* TYPEDEF  */
    U = 1144,                      /* U  */
    UCS_4 = 1145,                  /* "UCS-4"  */
    UNBOUNDED = 1146,              /* UNBOUNDED  */
    UNDERLINE = 1147,              /* UNDERLINE  */
    UNFRAMED = 1148,               /* UNFRAMED  */
    UNIT = 1149,                   /* UNIT  */
    UNLOCK = 1150,                 /* UNLOCK  */
    UNSIGNED = 1151,               /* UNSIGNED  */
    UNSIGNED_INT = 1152,           /* "UNSIGNED-INT"  */
    UNSIGNED_LONG = 1153,          /* "UNSIGNED-LONG"  */
    UNSIGNED_SHORT = 1154,         /* "UNSIGNED-SHORT"  */
    UNSORTED = 1155,               /* UNSORTED  */
    UNSTRING = 1156,               /* UNSTRING  */
    UNTIL = 1157,                  /* UNTIL  */
    UP = 1158,                     /* UP  */
    UPDATE = 1159,                 /* UPDATE  */
    UPDATERS = 1160,               /* UPDATERS  */
    UPON = 1161,                   /* UPON  */
    UPON_ARGUMENT_NUMBER = 1162,   /* "UPON ARGUMENT-NUMBER"  */
    UPON_COMMAND_LINE = 1163,      /* "UPON COMMAND-LINE"  */
    UPON_ENVIRONMENT_NAME = 1164,  /* "UPON ENVIRONMENT-NAME"  */
    UPON_ENVIRONMENT_VALUE = 1165, /* "UPON ENVIRONMENT-VALUE"  */
    UPPER = 1166,                  /* UPPER  */
    UPPER_CASE_FUNC = 1167,        /* "FUNCTION UPPER-CASE"  */
    USAGE = 1168,                  /* USAGE  */
    USE = 1169,                    /* USE  */
    USE_ALT = 1170,                /* "USE-ALT"  */
    USE_RETURN = 1171,             /* "USE-RETURN"  */
    USE_TAB = 1172,                /* "USE-TAB"  */
    USER = 1173,                   /* USER  */
    USER_DEFAULT = 1174,           /* "USER-DEFAULT"  */
    USER_FUNCTION_NAME = 1175,     /* "user function name"  */
    USING = 1176,                  /* USING  */
    UTF_8 = 1177,                  /* "UTF-8"  */
    UTF_16 = 1178,                 /* "UTF-16"  */
    V = 1179,                      /* V  */
    VALID = 1180,                  /* VALID  */
    VALIDATE = 1181,               /* VALIDATE  */
    VAL_STATUS = 1182,             /* "VAL-STATUS"  */
    VALIDATE_STATUS = 1183,        /* "VALIDATE-STATUS"  */
    VALIDATING = 1184,             /* VALIDATING  */
    VALUE = 1185,                  /* VALUE  */
    VALUE_FORMAT = 1186,           /* "VALUE-FORMAT"  */
    VALUES = 1187,                 /* VALUES  */
    VARIABLE = 1188,               /* VARIABLE  */
    VARIANT = 1189,                /* VARIANT  */
    VARYING = 1190,                /* VARYING  */
    VERTICAL = 1191,               /* VERTICAL  */
    VERY_HEAVY = 1192,             /* "VERY-HEAVY"  */
    VIRTUAL_WIDTH = 1193,          /* "VIRTUAL-WIDTH"  */
    VOLATILE = 1194,               /* VOLATILE  */
    VPADDING = 1195,               /* VPADDING  */
    VSCROLL = 1196,                /* VSCROLL  */
    VSCROLL_BAR = 1197,            /* "VSCROLL-BAR"  */
    VSCROLL_POS = 1198,            /* "VSCROLL-POS"  */
    VTOP = 1199,                   /* VTOP  */
    WAIT = 1200,                   /* WAIT  */
    WEB_BROWSER = 1201,            /* "WEB-BROWSER"  */
    WHEN = 1202,                   /* WHEN  */
    WHEN_COMPILED_FUNC = 1203,     /* "FUNCTION WHEN-COMPILED"  */
    WHEN_XML = 1204,               /* "WHEN"  */
    WIDTH = 1205,                  /* WIDTH  */
    WIDTH_IN_CELLS = 1206,         /* "WIDTH-IN-CELLS"  */
    WINAPI = 1207,                 /* WINAPI  */
    WINDOW = 1208,                 /* WINDOW  */
    WITH = 1209,                   /* WITH  */
    WORD = 1210,                   /* "Identifier"  */
    WORDS = 1211,                  /* WORDS  */
    WORKING_STORAGE = 1212,        /* "WORKING-STORAGE"  */
    WRAP = 1213,                   /* WRAP  */
    WRITE = 1214,                  /* WRITE  */
    WRITE_ONLY = 1215,             /* "WRITE-ONLY"  */
    WRITE_VERIFY = 1216,           /* "WRITE-VERIFY"  */
    WRITERS = 1217,                /* WRITERS  */
    X = 1218,                      /* X  */
    XML = 1219,                    /* XML  */
    XML_DECLARATION = 1220,        /* "XML-DECLARATION"  */
    XML_SCHEMA = 1221,             /* "XML-SCHEMA"  */
    Y = 1222,                      /* Y  */
    YYYYDDD = 1223,                /* YYYYDDD  */
    YYYYMMDD = 1224,               /* YYYYMMDD  */
    ZERO = 1225,                   /* ZERO  */
    LEVEL_NUMBER_IN_AREA_A = 1226, /* "level-number (Area A)"  */
    WORD_IN_AREA_A = 1227,         /* "Identifier (Area A)"  */
    SHIFT_PREFER = 1228            /* SHIFT_PREFER  */
  };
  typedef enum yytokentype yytoken_kind_t;
#endif

/* Value type.  */
#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef int YYSTYPE;
# define YYSTYPE_IS_TRIVIAL 1
# define YYSTYPE_IS_DECLARED 1
#endif


extern YYSTYPE yylval;

int yyparse (void);

#endif /* !YY_YY_PARSER_H_INCLUDED  */
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_THREEDIMENSIONAL = 3,           /* "3D"  */
  YYSYMBOL_ABSENT = 4,                     /* ABSENT  */
  YYSYMBOL_ACCEPT = 5,                     /* ACCEPT  */
  YYSYMBOL_ACCESS = 6,                     /* ACCESS  */
  YYSYMBOL_ACTIVEX = 7,                    /* "ACTIVE-X"  */
  YYSYMBOL_ACTIVE_CLASS = 8,               /* "ACTIVE-CLASS"  */
  YYSYMBOL_ACTION = 9,                     /* ACTION  */
  YYSYMBOL_ACTUAL = 10,                    /* ACTUAL  */
  YYSYMBOL_ADD = 11,                       /* ADD  */
  YYSYMBOL_ADDRESS = 12,                   /* ADDRESS  */
  YYSYMBOL_ADJUSTABLE_COLUMNS = 13,        /* "ADJUSTABLE-COLUMNS"  */
  YYSYMBOL_ADVANCING = 14,                 /* ADVANCING  */
  YYSYMBOL_AFTER = 15,                     /* AFTER  */
  YYSYMBOL_ALIGNED = 16,                   /* ALIGNED  */
  YYSYMBOL_ALIGNMENT = 17,                 /* ALIGNMENT  */
  YYSYMBOL_ALL = 18,                       /* ALL  */
  YYSYMBOL_ALLOCATE = 19,                  /* ALLOCATE  */
  YYSYMBOL_ALLOWING = 20,                  /* ALLOWING  */
  YYSYMBOL_ALPHABET = 21,                  /* ALPHABET  */
  YYSYMBOL_ALPHABETIC = 22,                /* ALPHABETIC  */
  YYSYMBOL_ALPHABETIC_LOWER = 23,          /* "ALPHABETIC-LOWER"  */
  YYSYMBOL_ALPHABETIC_UPPER = 24,          /* "ALPHABETIC-UPPER"  */
  YYSYMBOL_ALPHANUMERIC = 25,              /* ALPHANUMERIC  */
  YYSYMBOL_ALPHANUMERIC_EDITED = 26,       /* "ALPHANUMERIC-EDITED"  */
  YYSYMBOL_ALSO = 27,                      /* ALSO  */
  YYSYMBOL_ALTER = 28,                     /* ALTER  */
  YYSYMBOL_ALTERNATE = 29,                 /* ALTERNATE  */
  YYSYMBOL_AND = 30,                       /* AND  */
  YYSYMBOL_ANY = 31,                       /* ANY  */
  YYSYMBOL_APPLY = 32,                     /* APPLY  */
  YYSYMBOL_ARE = 33,                       /* ARE  */
  YYSYMBOL_AREA = 34,                      /* AREA  */
  YYSYMBOL_AREAS = 35,                     /* AREAS  */
  YYSYMBOL_ARGUMENT_NUMBER = 36,           /* "ARGUMENT-NUMBER"  */
  YYSYMBOL_ARGUMENT_VALUE = 37,            /* "ARGUMENT-VALUE"  */
  YYSYMBOL_ARITHMETIC = 38,                /* ARITHMETIC  */
  YYSYMBOL_AS = 39,                        /* AS  */
  YYSYMBOL_ASCENDING = 40,                 /* ASCENDING  */
  YYSYMBOL_ASCII = 41,                     /* ASCII  */
  YYSYMBOL_ASSIGN = 42,                    /* ASSIGN  */
  YYSYMBOL_AT = 43,                        /* AT  */
  YYSYMBOL_AT_END = 44,                    /* "AT END"  */
  YYSYMBOL_ATTRIBUTE = 45,                 /* ATTRIBUTE  */
  YYSYMBOL_ATTRIBUTES = 46,                /* ATTRIBUTES  */
  YYSYMBOL_AUTHOR = 47,                    /* AUTHOR  */
  YYSYMBOL_AUTO = 48,                      /* AUTO  */
  YYSYMBOL_AUTO_DECIMAL = 49,              /* "AUTO-DECIMAL"  */
  YYSYMBOL_AUTO_SPIN = 50,                 /* "AUTO-SPIN"  */
  YYSYMBOL_AUTOMATIC = 51,                 /* AUTOMATIC  */
  YYSYMBOL_AWAY_FROM_ZERO = 52,            /* "AWAY-FROM-ZERO"  */
  YYSYMBOL_B_AND = 53,                     /* "B-AND"  */
  YYSYMBOL_B_NOT = 54,                     /* "B-NOT"  */
  YYSYMBOL_B_OR = 55,                      /* "B-OR"  */
  YYSYMBOL_B_XOR = 56,                     /* "B-XOR"  */
  YYSYMBOL_B_SHIFT_L = 57,                 /* "B-SHIFT-L"  */
  YYSYMBOL_B_SHIFT_R = 58,                 /* "B-SHIFT-R"  */
  YYSYMBOL_B_SHIFT_LC = 59,                /* "B-SHIFT-LC"  */
  YYSYMBOL_B_SHIFT_RC = 60,                /* "B-SHIFT-RC"  */
  YYSYMBOL_BACKGROUND_COLOR = 61,          /* "BACKGROUND-COLOR"  */
  YYSYMBOL_BACKGROUND_HIGH = 62,           /* "BACKGROUND-HIGH"  */
  YYSYMBOL_BACKGROUND_LOW = 63,            /* "BACKGROUND-LOW"  */
  YYSYMBOL_BACKGROUND_STANDARD = 64,       /* "BACKGROUND-STANDARD"  */
  YYSYMBOL_BACKWARD = 65,                  /* BACKWARD  */
  YYSYMBOL_BAR = 66,                       /* BAR  */
  YYSYMBOL_BASED = 67,                     /* BASED  */
  YYSYMBOL_BEFORE = 68,                    /* BEFORE  */
  YYSYMBOL_BELL = 69,                      /* BELL  */
  YYSYMBOL_BINARY = 70,                    /* BINARY  */
  YYSYMBOL_BINARY_C_LONG = 71,             /* "BINARY-C-LONG"  */
  YYSYMBOL_BINARY_CHAR = 72,               /* "BINARY-CHAR"  */
  YYSYMBOL_BINARY_DOUBLE = 73,             /* "BINARY-DOUBLE"  */
  YYSYMBOL_BINARY_LONG = 74,               /* "BINARY-LONG"  */
  YYSYMBOL_BINARY_SEQUENTIAL = 75,         /* "BINARY-SEQUENTIAL"  */
  YYSYMBOL_BINARY_SHORT = 76,              /* "BINARY-SHORT"  */
  YYSYMBOL_BIT = 77,                       /* BIT  */
  YYSYMBOL_BITMAP = 78,                    /* BITMAP  */
  YYSYMBOL_BITMAP_END = 79,                /* "BITMAP-END"  */
  YYSYMBOL_BITMAP_HANDLE = 80,             /* "BITMAP-HANDLE"  */
  YYSYMBOL_BITMAP_NUMBER = 81,             /* "BITMAP-NUMBER"  */
  YYSYMBOL_BITMAP_START = 82,              /* "BITMAP-START"  */
  YYSYMBOL_BITMAP_TIMER = 83,              /* "BITMAP-TIMER"  */
  YYSYMBOL_BITMAP_TRAILING = 84,           /* "BITMAP-TRAILING"  */
  YYSYMBOL_BITMAP_TRANSPARENT_COLOR = 85,  /* "BITMAP-TRANSPARENT-COLOR"  */
  YYSYMBOL_BITMAP_WIDTH = 86,              /* "BITMAP-WIDTH"  */
  YYSYMBOL_BLANK = 87,                     /* BLANK  */
  YYSYMBOL_BLINK = 88,                     /* BLINK  */
  YYSYMBOL_BLOCK = 89,                     /* BLOCK  */
  YYSYMBOL_BOOLEAN = 90,                   /* BOOLEAN  */
  YYSYMBOL_BOTTOM = 91,                    /* BOTTOM  */
  YYSYMBOL_BOX = 92,                       /* BOX  */
  YYSYMBOL_BOXED = 93,                     /* BOXED  */
  YYSYMBOL_BULK_ADDITION = 94,             /* "BULK-ADDITION"  */
  YYSYMBOL_BUSY = 95,                      /* BUSY  */
  YYSYMBOL_BUTTONS = 96,                   /* BUTTONS  */
  YYSYMBOL_BY = 97,                        /* BY  */
  YYSYMBOL_BYTE_LENGTH = 98,               /* "BYTE-LENGTH"  */
  YYSYMBOL_C = 99,                         /* C  */
  YYSYMBOL_CALENDAR_FONT = 100,            /* "CALENDAR-FONT"  */
  YYSYMBOL_CALL = 101,                     /* CALL  */
  YYSYMBOL_CANCEL = 102,                   /* CANCEL  */
  YYSYMBOL_CANCEL_BUTTON = 103,            /* "CANCEL-BUTTON"  */
  YYSYMBOL_CAPACITY = 104,                 /* CAPACITY  */
  YYSYMBOL_CARD_PUNCH = 105,               /* "CARD-PUNCH"  */
  YYSYMBOL_CARD_READER = 106,              /* "CARD-READER"  */
  YYSYMBOL_CASSETTE = 107,                 /* CASSETTE  */
  YYSYMBOL_CCOL = 108,                     /* CCOL  */
  YYSYMBOL_CD = 109,                       /* CD  */
  YYSYMBOL_CELL = 110,                     /* CELL  */
  YYSYMBOL_CELL_COLOR = 111,               /* "CELL-COLOR"  */
  YYSYMBOL_CELL_DATA = 112,                /* "CELL-DATA"  */
  YYSYMBOL_CELL_FONT = 113,                /* "CELL-FONT"  */
  YYSYMBOL_CELL_PROTECTION = 114,          /* "CELL-PROTECTION"  */
  YYSYMBOL_CENTER = 115,                   /* CENTER  */
  YYSYMBOL_CENTERED = 116,                 /* CENTERED  */
  YYSYMBOL_CENTERED_HEADINGS = 117,        /* "CENTERED-HEADINGS"  */
  YYSYMBOL_CENTURY_DATE = 118,             /* "CENTURY-DATE"  */
  YYSYMBOL_CF = 119,                       /* CF  */
  YYSYMBOL_CH = 120,                       /* CH  */
  YYSYMBOL_CHAINING = 121,                 /* CHAINING  */
  YYSYMBOL_CHANGED = 122,                  /* CHANGED  */
  YYSYMBOL_CHARACTER = 123,                /* CHARACTER  */
  YYSYMBOL_CHARACTERS = 124,               /* CHARACTERS  */
  YYSYMBOL_CHECK_BOX = 125,                /* "CHECK-BOX"  */
  YYSYMBOL_CLASS = 126,                    /* CLASS  */
  YYSYMBOL_CLASSIFICATION = 127,           /* CLASSIFICATION  */
  YYSYMBOL_CLASS_NAME = 128,               /* "class-name"  */
  YYSYMBOL_CLEAR_SELECTION = 129,          /* "CLEAR-SELECTION"  */
  YYSYMBOL_CLINE = 130,                    /* CLINE  */
  YYSYMBOL_CLINES = 131,                   /* CLINES  */
  YYSYMBOL_CLOSE = 132,                    /* CLOSE  */
  YYSYMBOL_COBOL = 133,                    /* COBOL  */
  YYSYMBOL_CODE = 134,                     /* CODE  */
  YYSYMBOL_CODE_SET = 135,                 /* "CODE-SET"  */
  YYSYMBOL_COLLATING = 136,                /* COLLATING  */
  YYSYMBOL_COL = 137,                      /* COL  */
  YYSYMBOL_COLOR = 138,                    /* COLOR  */
  YYSYMBOL_COLORS = 139,                   /* COLORS  */
  YYSYMBOL_COLS = 140,                     /* COLS  */
  YYSYMBOL_COLUMN = 141,                   /* COLUMN  */
  YYSYMBOL_COLUMN_COLOR = 142,             /* "COLUMN-COLOR"  */
  YYSYMBOL_COLUMN_DIVIDERS = 143,          /* "COLUMN-DIVIDERS"  */
  YYSYMBOL_COLUMN_FONT = 144,              /* "COLUMN-FONT"  */
  YYSYMBOL_COLUMN_HEADINGS = 145,          /* "COLUMN-HEADINGS"  */
  YYSYMBOL_COLUMN_PROTECTION = 146,        /* "COLUMN-PROTECTION"  */
  YYSYMBOL_COLUMNS = 147,                  /* COLUMNS  */
  YYSYMBOL_COMBO_BOX = 148,                /* "COMBO-BOX"  */
  YYSYMBOL_COMMA = 149,                    /* COMMA  */
  YYSYMBOL_COMMAND_LINE = 150,             /* "COMMAND-LINE"  */
  YYSYMBOL_COMMA_DELIM = 151,              /* "comma delimiter"  */
  YYSYMBOL_COMMIT = 152,                   /* COMMIT  */
  YYSYMBOL_COMMON = 153,                   /* COMMON  */
  YYSYMBOL_COMMUNICATION = 154,            /* COMMUNICATION  */
  YYSYMBOL_COMP = 155,                     /* COMP  */
  YYSYMBOL_COMPUTE = 156,                  /* COMPUTE  */
  YYSYMBOL_COMP_0 = 157,                   /* "COMP-0"  */
  YYSYMBOL_COMP_1 = 158,                   /* "COMP-1"  */
  YYSYMBOL_COMP_2 = 159,                   /* "COMP-2"  */
  YYSYMBOL_COMP_3 = 160,                   /* "COMP-3"  */
  YYSYMBOL_COMP_4 = 161,                   /* "COMP-4"  */
  YYSYMBOL_COMP_5 = 162,                   /* "COMP-5"  */
  YYSYMBOL_COMP_6 = 163,                   /* "COMP-6"  */
  YYSYMBOL_COMP_N = 164,                   /* "COMP-N"  */
  YYSYMBOL_COMP_X = 165,                   /* "COMP-X"  */
  YYSYMBOL_CONCATENATE_FUNC = 166,         /* "FUNCTION CONCATENATE"  */
  YYSYMBOL_CONDITION = 167,                /* CONDITION  */
  YYSYMBOL_CONFIGURATION = 168,            /* CONFIGURATION  */
  YYSYMBOL_CONSTANT = 169,                 /* CONSTANT  */
  YYSYMBOL_CONTAINS = 170,                 /* CONTAINS  */
  YYSYMBOL_CONTENT = 171,                  /* CONTENT  */
  YYSYMBOL_CONTENT_LENGTH_FUNC = 172,      /* "FUNCTION CONTENT-LENGTH"  */
  YYSYMBOL_CONTENT_OF_FUNC = 173,          /* "FUNCTION CONTENT-OF"  */
  YYSYMBOL_CONTINUE = 174,                 /* CONTINUE  */
  YYSYMBOL_CONTROL = 175,                  /* CONTROL  */
  YYSYMBOL_CONTROLS = 176,                 /* CONTROLS  */
  YYSYMBOL_CONVERSION = 177,               /* CONVERSION  */
  YYSYMBOL_CONVERTING = 178,               /* CONVERTING  */
  YYSYMBOL_COPY = 179,                     /* COPY  */
  YYSYMBOL_COPY_SELECTION = 180,           /* "COPY-SELECTION"  */
  YYSYMBOL_CORE_INDEX = 181,               /* "CORE-INDEX"  */
  YYSYMBOL_CORRESPONDING = 182,            /* CORRESPONDING  */
  YYSYMBOL_COUNT = 183,                    /* COUNT  */
  YYSYMBOL_CRT = 184,                      /* CRT  */
  YYSYMBOL_CRT_UNDER = 185,                /* "CRT-UNDER"  */
  YYSYMBOL_CSIZE = 186,                    /* CSIZE  */
  YYSYMBOL_CURRENCY = 187,                 /* CURRENCY  */
  YYSYMBOL_CURRENT_DATE_FUNC = 188,        /* "FUNCTION CURRENT-DATE"  */
  YYSYMBOL_CURSOR = 189,                   /* CURSOR  */
  YYSYMBOL_CURSOR_COL = 190,               /* "CURSOR-COL"  */
  YYSYMBOL_CURSOR_COLOR = 191,             /* "CURSOR-COLOR"  */
  YYSYMBOL_CURSOR_FRAME_WIDTH = 192,       /* "CURSOR-FRAME-WIDTH"  */
  YYSYMBOL_CURSOR_ROW = 193,               /* "CURSOR-ROW"  */
  YYSYMBOL_CURSOR_X = 194,                 /* "CURSOR-X"  */
  YYSYMBOL_CURSOR_Y = 195,                 /* "CURSOR-Y"  */
  YYSYMBOL_CUSTOM_PRINT_TEMPLATE = 196,    /* "CUSTOM-PRINT-TEMPLATE"  */
  YYSYMBOL_CYCLE = 197,                    /* CYCLE  */
  YYSYMBOL_CYL_INDEX = 198,                /* "CYL-INDEX"  */
  YYSYMBOL_CYL_OVERFLOW = 199,             /* "CYL-OVERFLOW"  */
  YYSYMBOL_DASHED = 200,                   /* DASHED  */
  YYSYMBOL_DATA = 201,                     /* DATA  */
  YYSYMBOL_DATA_COLUMNS = 202,             /* "DATA-COLUMNS"  */
  YYSYMBOL_DATA_POINTER = 203,             /* "DATA-POINTER"  */
  YYSYMBOL_DATA_TYPES = 204,               /* "DATA-TYPES"  */
  YYSYMBOL_DATE = 205,                     /* DATE  */
  YYSYMBOL_DATE_COMPILED = 206,            /* "DATE-COMPILED"  */
  YYSYMBOL_DATE_ENTRY = 207,               /* "DATE-ENTRY"  */
  YYSYMBOL_DATE_MODIFIED = 208,            /* "DATE-MODIFIED"  */
  YYSYMBOL_DATE_WRITTEN = 209,             /* "DATE-WRITTEN"  */
  YYSYMBOL_DAY = 210,                      /* DAY  */
  YYSYMBOL_DAY_OF_WEEK = 211,              /* "DAY-OF-WEEK"  */
  YYSYMBOL_DE = 212,                       /* DE  */
  YYSYMBOL_DEBUGGING = 213,                /* DEBUGGING  */
  YYSYMBOL_DECIMAL_POINT = 214,            /* "DECIMAL-POINT"  */
  YYSYMBOL_DECLARATIVES = 215,             /* DECLARATIVES  */
  YYSYMBOL_DEFAULT = 216,                  /* DEFAULT  */
  YYSYMBOL_DEFAULT_BUTTON = 217,           /* "DEFAULT-BUTTON"  */
  YYSYMBOL_DEFAULT_FONT = 218,             /* "DEFAULT-FONT"  */
  YYSYMBOL_DELETE = 219,                   /* DELETE  */
  YYSYMBOL_DELIMITED = 220,                /* DELIMITED  */
  YYSYMBOL_DELIMITER = 221,                /* DELIMITER  */
  YYSYMBOL_DEPENDING = 222,                /* DEPENDING  */
  YYSYMBOL_DESCENDING = 223,               /* DESCENDING  */
  YYSYMBOL_DESTINATION = 224,              /* DESTINATION  */
  YYSYMBOL_DESTROY = 225,                  /* DESTROY  */
  YYSYMBOL_DETAIL = 226,                   /* DETAIL  */
  YYSYMBOL_DISABLE = 227,                  /* DISABLE  */
  YYSYMBOL_DISC = 228,                     /* DISC  */
  YYSYMBOL_DISK = 229,                     /* DISK  */
  YYSYMBOL_DISP = 230,                     /* DISP  */
  YYSYMBOL_DISPLAY = 231,                  /* DISPLAY  */
  YYSYMBOL_DISPLAY_1 = 232,                /* "DISPLAY-1"  */
  YYSYMBOL_DISPLAY_COLUMNS = 233,          /* "DISPLAY-COLUMNS"  */
  YYSYMBOL_DISPLAY_FORMAT = 234,           /* "DISPLAY-FORMAT"  */
  YYSYMBOL_DISPLAY_OF_FUNC = 235,          /* "FUNCTION DISPLAY-OF"  */
  YYSYMBOL_DIVIDE = 236,                   /* DIVIDE  */
  YYSYMBOL_DIVIDERS = 237,                 /* DIVIDERS  */
  YYSYMBOL_DIVIDER_COLOR = 238,            /* "DIVIDER-COLOR"  */
  YYSYMBOL_DIVISION = 239,                 /* DIVISION  */
  YYSYMBOL_DOTDASH = 240,                  /* DOTDASH  */
  YYSYMBOL_DOTTED = 241,                   /* DOTTED  */
  YYSYMBOL_DRAG_COLOR = 242,               /* "DRAG-COLOR"  */
  YYSYMBOL_DROP_DOWN = 243,                /* "DROP-DOWN"  */
  YYSYMBOL_DROP_LIST = 244,                /* "DROP-LIST"  */
  YYSYMBOL_DOWN = 245,                     /* DOWN  */
  YYSYMBOL_DUPLICATES = 246,               /* DUPLICATES  */
  YYSYMBOL_DYNAMIC = 247,                  /* DYNAMIC  */
  YYSYMBOL_EBCDIC = 248,                   /* EBCDIC  */
  YYSYMBOL_EC = 249,                       /* EC  */
  YYSYMBOL_ECHO = 250,                     /* ECHO  */
  YYSYMBOL_EGI = 251,                      /* EGI  */
  YYSYMBOL_EIGHTY_EIGHT = 252,             /* "level-number 88"  */
  YYSYMBOL_ENABLE = 253,                   /* ENABLE  */
  YYSYMBOL_ELEMENT = 254,                  /* ELEMENT  */
  YYSYMBOL_ELSE = 255,                     /* ELSE  */
  YYSYMBOL_EMI = 256,                      /* EMI  */
  YYSYMBOL_ENCRYPTION = 257,               /* ENCRYPTION  */
  YYSYMBOL_ENCODING = 258,                 /* ENCODING  */
  YYSYMBOL_END = 259,                      /* END  */
  YYSYMBOL_END_ACCEPT = 260,               /* "END-ACCEPT"  */
  YYSYMBOL_END_ADD = 261,                  /* "END-ADD"  */
  YYSYMBOL_END_CALL = 262,                 /* "END-CALL"  */
  YYSYMBOL_END_COMPUTE = 263,              /* "END-COMPUTE"  */
  YYSYMBOL_END_COLOR = 264,                /* "END-COLOR"  */
  YYSYMBOL_END_DELETE = 265,               /* "END-DELETE"  */
  YYSYMBOL_END_DISPLAY = 266,              /* "END-DISPLAY"  */
  YYSYMBOL_END_DIVIDE = 267,               /* "END-DIVIDE"  */
  YYSYMBOL_END_EVALUATE = 268,             /* "END-EVALUATE"  */
  YYSYMBOL_END_FUNCTION = 269,             /* "END FUNCTION"  */
  YYSYMBOL_END_IF = 270,                   /* "END-IF"  */
  YYSYMBOL_END_JSON = 271,                 /* "END-JSON"  */
  YYSYMBOL_END_MODIFY = 272,               /* "END-MODIFY"  */
  YYSYMBOL_END_MULTIPLY = 273,             /* "END-MULTIPLY"  */
  YYSYMBOL_END_PERFORM = 274,              /* "END-PERFORM"  */
  YYSYMBOL_END_PROGRAM = 275,              /* "END PROGRAM"  */
  YYSYMBOL_END_READ = 276,                 /* "END-READ"  */
  YYSYMBOL_END_RECEIVE = 277,              /* "END-RECEIVE"  */
  YYSYMBOL_END_RETURN = 278,               /* "END-RETURN"  */
  YYSYMBOL_END_REWRITE = 279,              /* "END-REWRITE"  */
  YYSYMBOL_END_SEARCH = 280,               /* "END-SEARCH"  */
  YYSYMBOL_END_SEND = 281,                 /* "END-SEND"  */
  YYSYMBOL_END_START = 282,                /* "END-START"  */
  YYSYMBOL_END_STRING = 283,               /* "END-STRING"  */
  YYSYMBOL_END_SUBTRACT = 284,             /* "END-SUBTRACT"  */
  YYSYMBOL_END_UNSTRING = 285,             /* "END-UNSTRING"  */
  YYSYMBOL_END_WRITE = 286,                /* "END-WRITE"  */
  YYSYMBOL_END_XML = 287,                  /* "END-XML"  */
  YYSYMBOL_ENGRAVED = 288,                 /* ENGRAVED  */
  YYSYMBOL_ENSURE_VISIBLE = 289,           /* "ENSURE-VISIBLE"  */
  YYSYMBOL_ENTRY = 290,                    /* ENTRY  */
  YYSYMBOL_ENTRY_CONVENTION = 291,         /* "ENTRY-CONVENTION"  */
  YYSYMBOL_ENTRY_FIELD = 292,              /* "ENTRY-FIELD"  */
  YYSYMBOL_ENTRY_REASON = 293,             /* "ENTRY-REASON"  */
  YYSYMBOL_ENVIRONMENT = 294,              /* ENVIRONMENT  */
  YYSYMBOL_ENVIRONMENT_NAME = 295,         /* "ENVIRONMENT-NAME"  */
  YYSYMBOL_ENVIRONMENT_VALUE = 296,        /* "ENVIRONMENT-VALUE"  */
  YYSYMBOL_EOL = 297,                      /* EOL  */
  YYSYMBOL_EOP = 298,                      /* EOP  */
  YYSYMBOL_EOS = 299,                      /* EOS  */
  YYSYMBOL_EQUAL = 300,                    /* EQUAL  */
  YYSYMBOL_ERASE = 301,                    /* ERASE  */
  YYSYMBOL_ERROR = 302,                    /* ERROR  */
  YYSYMBOL_ESCAPE = 303,                   /* ESCAPE  */
  YYSYMBOL_ESCAPE_BUTTON = 304,            /* "ESCAPE-BUTTON"  */
  YYSYMBOL_ESI = 305,                      /* ESI  */
  YYSYMBOL_EVALUATE = 306,                 /* EVALUATE  */
  YYSYMBOL_EVENT = 307,                    /* EVENT  */
  YYSYMBOL_EVENT_LIST = 308,               /* "EVENT-LIST"  */
  YYSYMBOL_EVENT_STATUS = 309,             /* "EVENT STATUS"  */
  YYSYMBOL_EVERY = 310,                    /* EVERY  */
  YYSYMBOL_EXAMINE = 311,                  /* EXAMINE  */
  YYSYMBOL_EXCEPTION = 312,                /* EXCEPTION  */
  YYSYMBOL_EXCEPTION_CONDITION = 313,      /* "EXCEPTION CONDITION"  */
  YYSYMBOL_EXCEPTION_VALUE = 314,          /* "EXCEPTION-VALUE"  */
  YYSYMBOL_EXPAND = 315,                   /* EXPAND  */
  YYSYMBOL_EXCLUSIVE = 316,                /* EXCLUSIVE  */
  YYSYMBOL_EXHIBIT = 317,                  /* EXHIBIT  */
  YYSYMBOL_EXIT = 318,                     /* EXIT  */
  YYSYMBOL_EXPONENTIATION = 319,           /* "exponentiation operator"  */
  YYSYMBOL_EXTEND = 320,                   /* EXTEND  */
  YYSYMBOL_EXTENDED_SEARCH = 321,          /* "EXTENDED-SEARCH"  */
  YYSYMBOL_EXTERNAL = 322,                 /* EXTERNAL  */
  YYSYMBOL_EXTERNAL_FORM = 323,            /* "EXTERNAL-FORM"  */
  YYSYMBOL_F = 324,                        /* F  */
  YYSYMBOL_FACTORY = 325,                  /* FACTORY  */
  YYSYMBOL_FD = 326,                       /* FD  */
  YYSYMBOL_FH__FCD = 327,                  /* "FH--FCD"  */
  YYSYMBOL_FH__KEYDEF = 328,               /* "FH--KEYDEF"  */
  YYSYMBOL_FILE_CONTROL = 329,             /* "FILE-CONTROL"  */
  YYSYMBOL_FILE_ID = 330,                  /* "FILE-ID"  */
  YYSYMBOL_FILE_LIMIT = 331,               /* "FILE-LIMIT"  */
  YYSYMBOL_FILE_LIMITS = 332,              /* "FILE-LIMITS"  */
  YYSYMBOL_FILE_NAME = 333,                /* "FILE-NAME"  */
  YYSYMBOL_FILE_POS = 334,                 /* "FILE-POS"  */
  YYSYMBOL_FILL_COLOR = 335,               /* "FILL-COLOR"  */
  YYSYMBOL_FILL_COLOR2 = 336,              /* "FILL-COLOR2"  */
  YYSYMBOL_FILL_PERCENT = 337,             /* "FILL-PERCENT"  */
  YYSYMBOL_FILLER = 338,                   /* FILLER  */
  YYSYMBOL_FINAL = 339,                    /* FINAL  */
  YYSYMBOL_FINISH_REASON = 340,            /* "FINISH-REASON"  */
  YYSYMBOL_FIRST = 341,                    /* FIRST  */
  YYSYMBOL_FIXED = 342,                    /* FIXED  */
  YYSYMBOL_FIXED_FONT = 343,               /* "FIXED-FONT"  */
  YYSYMBOL_FIXED_WIDTH = 344,              /* "FIXED-WIDTH"  */
  YYSYMBOL_FLAT = 345,                     /* FLAT  */
  YYSYMBOL_FLAT_BUTTONS = 346,             /* "FLAT-BUTTONS"  */
  YYSYMBOL_FLOAT_BINARY_128 = 347,         /* "FLOAT-BINARY-128"  */
  YYSYMBOL_FLOAT_BINARY_32 = 348,          /* "FLOAT-BINARY-32"  */
  YYSYMBOL_FLOAT_BINARY_64 = 349,          /* "FLOAT-BINARY-64"  */
  YYSYMBOL_FLOAT_DECIMAL_16 = 350,         /* "FLOAT-DECIMAL-16"  */
  YYSYMBOL_FLOAT_DECIMAL_34 = 351,         /* "FLOAT-DECIMAL-34"  */
  YYSYMBOL_FLOAT_DECIMAL_7 = 352,          /* "FLOAT-DECIMAL-7"  */
  YYSYMBOL_FLOAT_EXTENDED = 353,           /* "FLOAT-EXTENDED"  */
  YYSYMBOL_FLOAT_LONG = 354,               /* "FLOAT-LONG"  */
  YYSYMBOL_FLOAT_SHORT = 355,              /* "FLOAT-SHORT"  */
  YYSYMBOL_FLOATING = 356,                 /* FLOATING  */
  YYSYMBOL_FONT = 357,                     /* FONT  */
  YYSYMBOL_FOOTING = 358,                  /* FOOTING  */
  YYSYMBOL_FOR = 359,                      /* FOR  */
  YYSYMBOL_FOREGROUND_COLOR = 360,         /* "FOREGROUND-COLOR"  */
  YYSYMBOL_FOREVER = 361,                  /* FOREVER  */
  YYSYMBOL_FORMAT = 362,                   /* FORMAT  */
  YYSYMBOL_FORMATTED_DATE_FUNC = 363,      /* "FUNCTION FORMATTED-DATE"  */
  YYSYMBOL_FORMATTED_DATETIME_FUNC = 364,  /* "FUNCTION FORMATTED-DATETIME"  */
  YYSYMBOL_FORMATTED_TIME_FUNC = 365,      /* "FUNCTION FORMATTED-TIME"  */
  YYSYMBOL_FRAME = 366,                    /* FRAME  */
  YYSYMBOL_FRAMED = 367,                   /* FRAMED  */
  YYSYMBOL_FREE = 368,                     /* FREE  */
  YYSYMBOL_FROM = 369,                     /* FROM  */
  YYSYMBOL_FROM_CRT = 370,                 /* "FROM CRT"  */
  YYSYMBOL_FULL = 371,                     /* FULL  */
  YYSYMBOL_FULL_HEIGHT = 372,              /* "FULL-HEIGHT"  */
  YYSYMBOL_FUNCTION = 373,                 /* FUNCTION  */
  YYSYMBOL_FUNCTION_ID = 374,              /* "FUNCTION-ID"  */
  YYSYMBOL_FUNCTION_NAME = 375,            /* "intrinsic function name"  */
  YYSYMBOL_FUNCTION_POINTER = 376,         /* "FUNCTION-POINTER"  */
  YYSYMBOL_GENERATE = 377,                 /* GENERATE  */
  YYSYMBOL_GIVING = 378,                   /* GIVING  */
  YYSYMBOL_GLOBAL = 379,                   /* GLOBAL  */
  YYSYMBOL_GO = 380,                       /* GO  */
  YYSYMBOL_GO_BACK = 381,                  /* "GO-BACK"  */
  YYSYMBOL_GO_FORWARD = 382,               /* "GO-FORWARD"  */
  YYSYMBOL_GO_HOME = 383,                  /* "GO-HOME"  */
  YYSYMBOL_GO_SEARCH = 384,                /* "GO-SEARCH"  */
  YYSYMBOL_GOBACK = 385,                   /* GOBACK  */
  YYSYMBOL_GRAPHICAL = 386,                /* GRAPHICAL  */
  YYSYMBOL_GREATER = 387,                  /* GREATER  */
  YYSYMBOL_GREATER_OR_EQUAL = 388,         /* "GREATER OR EQUAL"  */
  YYSYMBOL_GRID = 389,                     /* GRID  */
  YYSYMBOL_GROUP = 390,                    /* GROUP  */
  YYSYMBOL_GROUP_VALUE = 391,              /* "GROUP-VALUE"  */
  YYSYMBOL_HANDLE = 392,                   /* HANDLE  */
  YYSYMBOL_HAS_CHILDREN = 393,             /* "HAS-CHILDREN"  */
  YYSYMBOL_HEADING = 394,                  /* HEADING  */
  YYSYMBOL_HEADING_COLOR = 395,            /* "HEADING-COLOR"  */
  YYSYMBOL_HEADING_DIVIDER_COLOR = 396,    /* "HEADING-DIVIDER-COLOR"  */
  YYSYMBOL_HEADING_FONT = 397,             /* "HEADING-FONT"  */
  YYSYMBOL_HEAVY = 398,                    /* HEAVY  */
  YYSYMBOL_HEIGHT_IN_CELLS = 399,          /* "HEIGHT-IN-CELLS"  */
  YYSYMBOL_HIDDEN_DATA = 400,              /* "HIDDEN-DATA"  */
  YYSYMBOL_HIGHLIGHT = 401,                /* HIGHLIGHT  */
  YYSYMBOL_HIGH_COLOR = 402,               /* "HIGH-COLOR"  */
  YYSYMBOL_HIGH_VALUE = 403,               /* "HIGH-VALUE"  */
  YYSYMBOL_HOT_TRACK = 404,                /* "HOT-TRACK"  */
  YYSYMBOL_HSCROLL = 405,                  /* HSCROLL  */
  YYSYMBOL_HSCROLL_POS = 406,              /* "HSCROLL-POS"  */
  YYSYMBOL_ICON = 407,                     /* ICON  */
  YYSYMBOL_ID = 408,                       /* ID  */
  YYSYMBOL_IDENTIFIED = 409,               /* IDENTIFIED  */
  YYSYMBOL_IDENTIFICATION = 410,           /* IDENTIFICATION  */
  YYSYMBOL_IF = 411,                       /* IF  */
  YYSYMBOL_IGNORE = 412,                   /* IGNORE  */
  YYSYMBOL_IGNORING = 413,                 /* IGNORING  */
  YYSYMBOL_IN = 414,                       /* IN  */
  YYSYMBOL_INDEPENDENT = 415,              /* INDEPENDENT  */
  YYSYMBOL_INDEX = 416,                    /* INDEX  */
  YYSYMBOL_INDEXED = 417,                  /* INDEXED  */
  YYSYMBOL_INDICATE = 418,                 /* INDICATE  */
  YYSYMBOL_INITIALIZE = 419,               /* INITIALIZE  */
  YYSYMBOL_INITIALIZED = 420,              /* INITIALIZED  */
  YYSYMBOL_INITIATE = 421,                 /* INITIATE  */
  YYSYMBOL_INPUT = 422,                    /* INPUT  */
  YYSYMBOL_INPUT_OUTPUT = 423,             /* "INPUT-OUTPUT"  */
  YYSYMBOL_INQUIRE = 424,                  /* INQUIRE  */
  YYSYMBOL_INSERTION_INDEX = 425,          /* "INSERTION-INDEX"  */
  YYSYMBOL_INSERT_ROWS = 426,              /* "INSERT-ROWS"  */
  YYSYMBOL_INSPECT = 427,                  /* INSPECT  */
  YYSYMBOL_INSTALLATION = 428,             /* INSTALLATION  */
  YYSYMBOL_INTERMEDIATE = 429,             /* INTERMEDIATE  */
  YYSYMBOL_INTO = 430,                     /* INTO  */
  YYSYMBOL_INTRINSIC = 431,                /* INTRINSIC  */
  YYSYMBOL_INVALID = 432,                  /* INVALID  */
  YYSYMBOL_INVALID_KEY = 433,              /* "INVALID KEY"  */
  YYSYMBOL_IS = 434,                       /* IS  */
  YYSYMBOL_ITEM = 435,                     /* ITEM  */
  YYSYMBOL_ITEM_TEXT = 436,                /* "ITEM-TEXT"  */
  YYSYMBOL_ITEM_TO_ADD = 437,              /* "ITEM-TO_ADD"  */
  YYSYMBOL_ITEM_TO_DELETE = 438,           /* "ITEM-TO_DELETE"  */
  YYSYMBOL_ITEM_TO_EMPTY = 439,            /* "ITEM-TO_EMPTY"  */
  YYSYMBOL_ITEM_VALUE = 440,               /* "ITEM-VALUE"  */
  YYSYMBOL_I_O = 441,                      /* "I-O"  */
  YYSYMBOL_I_O_CONTROL = 442,              /* "I-O-CONTROL"  */
  YYSYMBOL_JSON = 443,                     /* JSON  */
  YYSYMBOL_JUSTIFIED = 444,                /* JUSTIFIED  */
  YYSYMBOL_KEPT = 445,                     /* KEPT  */
  YYSYMBOL_KEY = 446,                      /* KEY  */
  YYSYMBOL_KEYBOARD = 447,                 /* KEYBOARD  */
  YYSYMBOL_LABEL = 448,                    /* LABEL  */
  YYSYMBOL_LABEL_OFFSET = 449,             /* "LABEL-OFFSET"  */
  YYSYMBOL_LARGE_FONT = 450,               /* "LARGE-FONT"  */
  YYSYMBOL_LARGE_OFFSET = 451,             /* "LARGE-OFFSET"  */
  YYSYMBOL_LAST = 452,                     /* LAST  */
  YYSYMBOL_LAST_ROW = 453,                 /* "LAST-ROW"  */
  YYSYMBOL_LAYOUT_DATA = 454,              /* "LAYOUT-DATA"  */
  YYSYMBOL_LAYOUT_MANAGER = 455,           /* "LAYOUT-MANAGER"  */
  YYSYMBOL_LEADING = 456,                  /* LEADING  */
  YYSYMBOL_LEADING_SHIFT = 457,            /* "LEADING-SHIFT"  */
  YYSYMBOL_LEAVE = 458,                    /* LEAVE  */
  YYSYMBOL_LEFT = 459,                     /* LEFT  */
  YYSYMBOL_LEFTLINE = 460,                 /* LEFTLINE  */
  YYSYMBOL_LEFT_TEXT = 461,                /* "LEFT-TEXT"  */
  YYSYMBOL_LENGTH = 462,                   /* LENGTH  */
  YYSYMBOL_LENGTH_OF = 463,                /* "LENGTH OF"  */
  YYSYMBOL_LENGTH_FUNC = 464,              /* "FUNCTION LENGTH/BYTE-LENGTH"  */
  YYSYMBOL_LESS = 465,                     /* LESS  */
  YYSYMBOL_LESS_OR_EQUAL = 466,            /* "LESS OR EQUAL"  */
  YYSYMBOL_LEVEL_NUMBER = 467,             /* "level-number"  */
  YYSYMBOL_LIKE = 468,                     /* LIKE  */
  YYSYMBOL_LIMIT = 469,                    /* LIMIT  */
  YYSYMBOL_LIMITS = 470,                   /* LIMITS  */
  YYSYMBOL_LINAGE = 471,                   /* LINAGE  */
  YYSYMBOL_LINAGE_COUNTER = 472,           /* "LINAGE-COUNTER"  */
  YYSYMBOL_LINE = 473,                     /* LINE  */
  YYSYMBOL_LINE_COUNTER = 474,             /* "LINE-COUNTER"  */
  YYSYMBOL_LINE_LIMIT = 475,               /* "LINE LIMIT"  */
  YYSYMBOL_LINE_SEQUENTIAL = 476,          /* "LINE-SEQUENTIAL"  */
  YYSYMBOL_LINES = 477,                    /* LINES  */
  YYSYMBOL_LINES_AT_ROOT = 478,            /* "LINES-AT-ROOT"  */
  YYSYMBOL_LINKAGE = 479,                  /* LINKAGE  */
  YYSYMBOL_LIST_BOX = 480,                 /* "LIST-BOX"  */
  YYSYMBOL_LITERAL = 481,                  /* "Literal"  */
  YYSYMBOL_LM_RESIZE = 482,                /* "LM-RESIZE"  */
  YYSYMBOL_LOC = 483,                      /* LOC  */
  YYSYMBOL_LOCALE = 484,                   /* LOCALE  */
  YYSYMBOL_LOCALE_DATE_FUNC = 485,         /* "FUNCTION LOCALE-DATE"  */
  YYSYMBOL_LOCALE_TIME_FUNC = 486,         /* "FUNCTION LOCALE-TIME"  */
  YYSYMBOL_LOCALE_TIME_FROM_FUNC = 487,    /* "FUNCTION LOCALE-TIME-FROM-SECONDS"  */
  YYSYMBOL_LOCAL_STORAGE = 488,            /* "LOCAL-STORAGE"  */
  YYSYMBOL_LOCK = 489,                     /* LOCK  */
  YYSYMBOL_LOCK_HOLDING = 490,             /* "LOCK-HOLDING"  */
  YYSYMBOL_LONG_DATE = 491,                /* "LONG-DATE"  */
  YYSYMBOL_LOWER = 492,                    /* LOWER  */
  YYSYMBOL_LOWERED = 493,                  /* LOWERED  */
  YYSYMBOL_LOWER_CASE_FUNC = 494,          /* "FUNCTION LOWER-CASE"  */
  YYSYMBOL_LOWLIGHT = 495,                 /* LOWLIGHT  */
  YYSYMBOL_LOW_COLOR = 496,                /* "LOW-COLOR"  */
  YYSYMBOL_LOW_VALUE = 497,                /* "LOW-VALUE"  */
  YYSYMBOL_MAGNETIC_TAPE = 498,            /* "MAGNETIC-TAPE"  */
  YYSYMBOL_MANUAL = 499,                   /* MANUAL  */
  YYSYMBOL_MASS_UPDATE = 500,              /* "MASS-UPDATE"  */
  YYSYMBOL_MASTER_INDEX = 501,             /* "MASTER-INDEX"  */
  YYSYMBOL_MAX_LINES = 502,                /* "MAX-LINES"  */
  YYSYMBOL_MAX_PROGRESS = 503,             /* "MAX-PROGRESS"  */
  YYSYMBOL_MAX_TEXT = 504,                 /* "MAX-TEXT"  */
  YYSYMBOL_MAX_VAL = 505,                  /* "MAX-VAL"  */
  YYSYMBOL_MEMORY = 506,                   /* MEMORY  */
  YYSYMBOL_MEDIUM_FONT = 507,              /* "MEDIUM-FONT"  */
  YYSYMBOL_MENU = 508,                     /* MENU  */
  YYSYMBOL_MERGE = 509,                    /* MERGE  */
  YYSYMBOL_MESSAGE = 510,                  /* MESSAGE  */
  YYSYMBOL_MICROSECOND_TIME = 511,         /* "MICROSECOND-TIME"  */
  YYSYMBOL_MINUS = 512,                    /* MINUS  */
  YYSYMBOL_MIN_VAL = 513,                  /* "MIN-VAL"  */
  YYSYMBOL_MNEMONIC_NAME = 514,            /* "Mnemonic name"  */
  YYSYMBOL_MODE = 515,                     /* MODE  */
  YYSYMBOL_MODIFY = 516,                   /* MODIFY  */
  YYSYMBOL_MODULES = 517,                  /* MODULES  */
  YYSYMBOL_MOVE = 518,                     /* MOVE  */
  YYSYMBOL_MULTILINE = 519,                /* MULTILINE  */
  YYSYMBOL_MULTIPLE = 520,                 /* MULTIPLE  */
  YYSYMBOL_MULTIPLY = 521,                 /* MULTIPLY  */
  YYSYMBOL_NAME = 522,                     /* NAME  */
  YYSYMBOL_NAMED = 523,                    /* NAMED  */
  YYSYMBOL_NAMESPACE = 524,                /* NAMESPACE  */
  YYSYMBOL_NAMESPACE_PREFIX = 525,         /* "NAMESPACE-PREFIX"  */
  YYSYMBOL_NATIONAL = 526,                 /* NATIONAL  */
  YYSYMBOL_NATIONAL_EDITED = 527,          /* "NATIONAL-EDITED"  */
  YYSYMBOL_NATIONAL_OF_FUNC = 528,         /* "FUNCTION NATIONAL-OF"  */
  YYSYMBOL_NATIVE = 529,                   /* NATIVE  */
  YYSYMBOL_NAVIGATE_URL = 530,             /* "NAVIGATE-URL"  */
  YYSYMBOL_NEAREST_AWAY_FROM_ZERO = 531,   /* "NEAREST-AWAY-FROM-ZERO"  */
  YYSYMBOL_NEAREST_EVEN = 532,             /* "NEAREST-EVEN"  */
  YYSYMBOL_NEAREST_TOWARD_ZERO = 533,      /* "NEAREST-TOWARD-ZERO"  */
  YYSYMBOL_NEGATIVE = 534,                 /* NEGATIVE  */
  YYSYMBOL_NESTED = 535,                   /* NESTED  */
  YYSYMBOL_NEW = 536,                      /* NEW  */
  YYSYMBOL_NEXT = 537,                     /* NEXT  */
  YYSYMBOL_NEXT_ITEM = 538,                /* "NEXT-ITEM"  */
  YYSYMBOL_NEXT_GROUP = 539,               /* "NEXT GROUP"  */
  YYSYMBOL_NEXT_PAGE = 540,                /* "NEXT PAGE"  */
  YYSYMBOL_NO = 541,                       /* NO  */
  YYSYMBOL_NO_ADVANCING = 542,             /* "NO ADVANCING"  */
  YYSYMBOL_NO_AUTOSEL = 543,               /* "NO-AUTOSEL"  */
  YYSYMBOL_NO_AUTO_DEFAULT = 544,          /* "NO-AUTO-DEFAULT"  */
  YYSYMBOL_NO_BOX = 545,                   /* "NO-BOX"  */
  YYSYMBOL_NO_DATA = 546,                  /* "NO DATA"  */
  YYSYMBOL_NO_DIVIDERS = 547,              /* "NO-DIVIDERS"  */
  YYSYMBOL_NO_ECHO = 548,                  /* "NO-ECHO"  */
  YYSYMBOL_NO_F4 = 549,                    /* "NO-F4"  */
  YYSYMBOL_NO_FOCUS = 550,                 /* "NO-FOCUS"  */
  YYSYMBOL_NO_GROUP_TAB = 551,             /* "NO-GROUP-TAB"  */
  YYSYMBOL_NO_KEY_LETTER = 552,            /* "NO-KEY-LETTER"  */
  YYSYMBOL_NO_SEARCH = 553,                /* "NO-SEARCH"  */
  YYSYMBOL_NO_UPDOWN = 554,                /* "NO-UPDOWN"  */
  YYSYMBOL_NOMINAL = 555,                  /* NOMINAL  */
  YYSYMBOL_NONE = 556,                     /* NONE  */
  YYSYMBOL_NONNUMERIC = 557,               /* NONNUMERIC  */
  YYSYMBOL_NORMAL = 558,                   /* NORMAL  */
  YYSYMBOL_NOT = 559,                      /* NOT  */
  YYSYMBOL_NOTAB = 560,                    /* NOTAB  */
  YYSYMBOL_NOTHING = 561,                  /* NOTHING  */
  YYSYMBOL_NOTIFY = 562,                   /* NOTIFY  */
  YYSYMBOL_NOTIFY_CHANGE = 563,            /* "NOTIFY-CHANGE"  */
  YYSYMBOL_NOTIFY_DBLCLICK = 564,          /* "NOTIFY-DBLCLICK"  */
  YYSYMBOL_NOTIFY_SELCHANGE = 565,         /* "NOTIFY-SELCHANGE"  */
  YYSYMBOL_NOT_AT_END = 566,               /* "NOT AT END"  */
  YYSYMBOL_NOT_EOP = 567,                  /* "NOT AT EOP"  */
  YYSYMBOL_NOT_ON_ESCAPE = 568,            /* "NOT ON ESCAPE"  */
  YYSYMBOL_NOT_EQUAL = 569,                /* "NOT EQUAL"  */
  YYSYMBOL_NOT_ON_EXCEPTION = 570,         /* "NOT ON EXCEPTION"  */
  YYSYMBOL_NOT_INVALID_KEY = 571,          /* "NOT INVALID KEY"  */
  YYSYMBOL_NOT_ON_OVERFLOW = 572,          /* "NOT ON OVERFLOW"  */
  YYSYMBOL_NOT_SIZE_ERROR = 573,           /* "NOT SIZE ERROR"  */
  YYSYMBOL_NUM_COL_HEADINGS = 574,         /* "NUM-COL-HEADINGS"  */
  YYSYMBOL_NUM_ROWS = 575,                 /* "NUM-ROWS"  */
  YYSYMBOL_NUMBER = 576,                   /* NUMBER  */
  YYSYMBOL_NUMBERS = 577,                  /* NUMBERS  */
  YYSYMBOL_NUMERIC = 578,                  /* NUMERIC  */
  YYSYMBOL_NUMERIC_EDITED = 579,           /* "NUMERIC-EDITED"  */
  YYSYMBOL_NUMVALC_FUNC = 580,             /* "FUNCTION NUMVAL-C"  */
  YYSYMBOL_OBJECT = 581,                   /* OBJECT  */
  YYSYMBOL_OBJECT_COMPUTER = 582,          /* "OBJECT-COMPUTER"  */
  YYSYMBOL_OCCURS = 583,                   /* OCCURS  */
  YYSYMBOL_OF = 584,                       /* OF  */
  YYSYMBOL_OFF = 585,                      /* OFF  */
  YYSYMBOL_OK_BUTTON = 586,                /* "OK-BUTTON"  */
  YYSYMBOL_OMITTED = 587,                  /* OMITTED  */
  YYSYMBOL_ON = 588,                       /* ON  */
  YYSYMBOL_ONLY = 589,                     /* ONLY  */
  YYSYMBOL_ON_ESCAPE = 590,                /* "ON ESCAPE"  */
  YYSYMBOL_ON_EXCEPTION = 591,             /* "ON EXCEPTION"  */
  YYSYMBOL_OPEN = 592,                     /* OPEN  */
  YYSYMBOL_OPTIONAL = 593,                 /* OPTIONAL  */
  YYSYMBOL_OPTIONS = 594,                  /* OPTIONS  */
  YYSYMBOL_OR = 595,                       /* OR  */
  YYSYMBOL_ORDER = 596,                    /* ORDER  */
  YYSYMBOL_ORGANIZATION = 597,             /* ORGANIZATION  */
  YYSYMBOL_OTHER = 598,                    /* OTHER  */
  YYSYMBOL_OTHERS = 599,                   /* OTHERS  */
  YYSYMBOL_OUTPUT = 600,                   /* OUTPUT  */
  YYSYMBOL_OVERLAP_LEFT = 601,             /* "OVERLAP-LEFT"  */
  YYSYMBOL_OVERLAP_TOP = 602,              /* "OVERLAP-TOP"  */
  YYSYMBOL_OVERLINE = 603,                 /* OVERLINE  */
  YYSYMBOL_PACKED_DECIMAL = 604,           /* "PACKED-DECIMAL"  */
  YYSYMBOL_PADDING = 605,                  /* PADDING  */
  YYSYMBOL_PASCAL = 606,                   /* PASCAL  */
  YYSYMBOL_PAGE = 607,                     /* PAGE  */
  YYSYMBOL_PAGE_COUNTER = 608,             /* "PAGE-COUNTER"  */
  YYSYMBOL_PAGE_SETUP = 609,               /* "PAGE-SETUP"  */
  YYSYMBOL_PAGED = 610,                    /* PAGED  */
  YYSYMBOL_PARAGRAPH = 611,                /* PARAGRAPH  */
  YYSYMBOL_PARENT = 612,                   /* PARENT  */
  YYSYMBOL_PARSE = 613,                    /* PARSE  */
  YYSYMBOL_PASSWORD = 614,                 /* PASSWORD  */
  YYSYMBOL_PERFORM = 615,                  /* PERFORM  */
  YYSYMBOL_PERMANENT = 616,                /* PERMANENT  */
  YYSYMBOL_PH = 617,                       /* PH  */
  YYSYMBOL_PF = 618,                       /* PF  */
  YYSYMBOL_PHYSICAL = 619,                 /* PHYSICAL  */
  YYSYMBOL_PICTURE = 620,                  /* PICTURE  */
  YYSYMBOL_PICTURE_SYMBOL = 621,           /* "PICTURE SYMBOL"  */
  YYSYMBOL_PIXEL = 622,                    /* PIXEL  */
  YYSYMBOL_PLACEMENT = 623,                /* PLACEMENT  */
  YYSYMBOL_PLUS = 624,                     /* PLUS  */
  YYSYMBOL_POINTER = 625,                  /* POINTER  */
  YYSYMBOL_POP_UP = 626,                   /* "POP-UP"  */
  YYSYMBOL_POS = 627,                      /* POS  */
  YYSYMBOL_POSITION = 628,                 /* POSITION  */
  YYSYMBOL_POSITION_SHIFT = 629,           /* "POSITION-SHIFT"  */
  YYSYMBOL_POSITIVE = 630,                 /* POSITIVE  */
  YYSYMBOL_PRESENT = 631,                  /* PRESENT  */
  YYSYMBOL_PREVIOUS = 632,                 /* PREVIOUS  */
  YYSYMBOL_PRINT = 633,                    /* PRINT  */
  YYSYMBOL_PRINT_CONTROL = 634,            /* "PRINT-CONTROL"  */
  YYSYMBOL_PRINT_NO_PROMPT = 635,          /* "PRINT-NO-PROMPT"  */
  YYSYMBOL_PRINT_PREVIEW = 636,            /* "PRINT-PREVIEW"  */
  YYSYMBOL_PRINTER = 637,                  /* PRINTER  */
  YYSYMBOL_PRINTER_1 = 638,                /* "PRINTER-1"  */
  YYSYMBOL_PRINTING = 639,                 /* PRINTING  */
  YYSYMBOL_PRIORITY = 640,                 /* PRIORITY  */
  YYSYMBOL_PROCEDURE = 641,                /* PROCEDURE  */
  YYSYMBOL_PROCEDURES = 642,               /* PROCEDURES  */
  YYSYMBOL_PROCEED = 643,                  /* PROCEED  */
  YYSYMBOL_PROCESSING = 644,               /* PROCESSING  */
  YYSYMBOL_PROGRAM = 645,                  /* PROGRAM  */
  YYSYMBOL_PROGRAM_ID = 646,               /* "PROGRAM-ID"  */
  YYSYMBOL_PROGRAM_NAME = 647,             /* "program name"  */
  YYSYMBOL_PROGRAM_POINTER = 648,          /* "PROGRAM-POINTER"  */
  YYSYMBOL_PROGRESS = 649,                 /* PROGRESS  */
  YYSYMBOL_PROHIBITED = 650,               /* PROHIBITED  */
  YYSYMBOL_PROMPT = 651,                   /* PROMPT  */
  YYSYMBOL_PROPERTIES = 652,               /* PROPERTIES  */
  YYSYMBOL_PROPERTY = 653,                 /* PROPERTY  */
  YYSYMBOL_PROTECTED = 654,                /* PROTECTED  */
  YYSYMBOL_PROTOTYPE = 655,                /* PROTOTYPE  */
  YYSYMBOL_PURGE = 656,                    /* PURGE  */
  YYSYMBOL_PUSH_BUTTON = 657,              /* "PUSH-BUTTON"  */
  YYSYMBOL_QUERY_INDEX = 658,              /* "QUERY-INDEX"  */
  YYSYMBOL_QUEUE = 659,                    /* QUEUE  */
  YYSYMBOL_QUOTE = 660,                    /* QUOTE  */
  YYSYMBOL_RADIO_BUTTON = 661,             /* "RADIO-BUTTON"  */
  YYSYMBOL_RAISE = 662,                    /* RAISE  */
  YYSYMBOL_RAISED = 663,                   /* RAISED  */
  YYSYMBOL_RAISING = 664,                  /* RAISING  */
  YYSYMBOL_RANDOM = 665,                   /* RANDOM  */
  YYSYMBOL_RD = 666,                       /* RD  */
  YYSYMBOL_READ = 667,                     /* READ  */
  YYSYMBOL_READERS = 668,                  /* READERS  */
  YYSYMBOL_READ_ONLY = 669,                /* "READ-ONLY"  */
  YYSYMBOL_READY_TRACE = 670,              /* "READY TRACE"  */
  YYSYMBOL_RECEIVE = 671,                  /* RECEIVE  */
  YYSYMBOL_RECEIVED = 672,                 /* RECEIVED  */
  YYSYMBOL_RECORD = 673,                   /* RECORD  */
  YYSYMBOL_RECORD_DATA = 674,              /* "RECORD-DATA"  */
  YYSYMBOL_RECORD_OVERFLOW = 675,          /* "RECORD-OVERFLOW"  */
  YYSYMBOL_RECORD_TO_ADD = 676,            /* "RECORD-TO-ADD"  */
  YYSYMBOL_RECORD_TO_DELETE = 677,         /* "RECORD-TO-DELETE"  */
  YYSYMBOL_RECORDING = 678,                /* RECORDING  */
  YYSYMBOL_RECORDS = 679,                  /* RECORDS  */
  YYSYMBOL_RECURSIVE = 680,                /* RECURSIVE  */
  YYSYMBOL_REDEFINES = 681,                /* REDEFINES  */
  YYSYMBOL_REEL = 682,                     /* REEL  */
  YYSYMBOL_REFERENCE = 683,                /* REFERENCE  */
  YYSYMBOL_REFERENCES = 684,               /* REFERENCES  */
  YYSYMBOL_REFRESH = 685,                  /* REFRESH  */
  YYSYMBOL_REGION_COLOR = 686,             /* "REGION-COLOR"  */
  YYSYMBOL_RELATION = 687,                 /* RELATION  */
  YYSYMBOL_RELATIVE = 688,                 /* RELATIVE  */
  YYSYMBOL_RELEASE = 689,                  /* RELEASE  */
  YYSYMBOL_REMAINDER = 690,                /* REMAINDER  */
  YYSYMBOL_REMARKS = 691,                  /* REMARKS  */
  YYSYMBOL_REMOVAL = 692,                  /* REMOVAL  */
  YYSYMBOL_RENAMES = 693,                  /* RENAMES  */
  YYSYMBOL_REORG_CRITERIA = 694,           /* "REORG-CRITERIA"  */
  YYSYMBOL_REPEATED = 695,                 /* REPEATED  */
  YYSYMBOL_REPLACE = 696,                  /* REPLACE  */
  YYSYMBOL_REPLACING = 697,                /* REPLACING  */
  YYSYMBOL_REPORT = 698,                   /* REPORT  */
  YYSYMBOL_REPORTING = 699,                /* REPORTING  */
  YYSYMBOL_REPORTS = 700,                  /* REPORTS  */
  YYSYMBOL_REPOSITORY = 701,               /* REPOSITORY  */
  YYSYMBOL_REQUIRED = 702,                 /* REQUIRED  */
  YYSYMBOL_REREAD = 703,                   /* REREAD  */
  YYSYMBOL_RERUN = 704,                    /* RERUN  */
  YYSYMBOL_RESERVE = 705,                  /* RESERVE  */
  YYSYMBOL_RESET = 706,                    /* RESET  */
  YYSYMBOL_RESET_TRACE = 707,              /* "RESET TRACE"  */
  YYSYMBOL_RESET_GRID = 708,               /* "RESET-GRID"  */
  YYSYMBOL_RESET_LIST = 709,               /* "RESET-LIST"  */
  YYSYMBOL_RESET_TABS = 710,               /* "RESET-TABS"  */
  YYSYMBOL_RETRY = 711,                    /* RETRY  */
  YYSYMBOL_RETURN = 712,                   /* RETURN  */
  YYSYMBOL_RETURNING = 713,                /* RETURNING  */
  YYSYMBOL_REVERSE = 714,                  /* REVERSE  */
  YYSYMBOL_REVERSE_FUNC = 715,             /* "FUNCTION REVERSE"  */
  YYSYMBOL_REVERSE_VIDEO = 716,            /* "REVERSE-VIDEO"  */
  YYSYMBOL_REVERSED = 717,                 /* REVERSED  */
  YYSYMBOL_REWIND = 718,                   /* REWIND  */
  YYSYMBOL_REWRITE = 719,                  /* REWRITE  */
  YYSYMBOL_RF = 720,                       /* RF  */
  YYSYMBOL_RH = 721,                       /* RH  */
  YYSYMBOL_RIGHT = 722,                    /* RIGHT  */
  YYSYMBOL_RIGHT_ALIGN = 723,              /* "RIGHT-ALIGN"  */
  YYSYMBOL_RIGHTLINE = 724,                /* RIGHTLINE  */
  YYSYMBOL_RIMMED = 725,                   /* RIMMED  */
  YYSYMBOL_ROLLBACK = 726,                 /* ROLLBACK  */
  YYSYMBOL_ROUNDED = 727,                  /* ROUNDED  */
  YYSYMBOL_ROUNDING = 728,                 /* ROUNDING  */
  YYSYMBOL_ROW_COLOR = 729,                /* "ROW-COLOR"  */
  YYSYMBOL_ROW_COLOR_PATTERN = 730,        /* "ROW-COLOR-PATTERN"  */
  YYSYMBOL_ROW_DIVIDERS = 731,             /* "ROW-DIVIDERS"  */
  YYSYMBOL_ROW_FONT = 732,                 /* "ROW-FONT"  */
  YYSYMBOL_ROW_HEADINGS = 733,             /* "ROW-HEADINGS"  */
  YYSYMBOL_ROW_PROTECTION = 734,           /* "ROW-PROTECTION"  */
  YYSYMBOL_RUN = 735,                      /* RUN  */
  YYSYMBOL_S = 736,                        /* S  */
  YYSYMBOL_SAME = 737,                     /* SAME  */
  YYSYMBOL_SAVE_AS = 738,                  /* "SAVE-AS"  */
  YYSYMBOL_SAVE_AS_NO_PROMPT = 739,        /* "SAVE-AS-NO-PROMPT"  */
  YYSYMBOL_SCREEN = 740,                   /* SCREEN  */
  YYSYMBOL_SCREEN_CONTROL = 741,           /* "SCREEN CONTROL"  */
  YYSYMBOL_SCROLL = 742,                   /* SCROLL  */
  YYSYMBOL_SCROLL_BAR = 743,               /* "SCROLL-BAR"  */
  YYSYMBOL_SD = 744,                       /* SD  */
  YYSYMBOL_SEARCH = 745,                   /* SEARCH  */
  YYSYMBOL_SEARCH_OPTIONS = 746,           /* "SEARCH-OPTIONS"  */
  YYSYMBOL_SEARCH_TEXT = 747,              /* "SEARCH-TEXT"  */
  YYSYMBOL_SECONDS = 748,                  /* SECONDS  */
  YYSYMBOL_SECTION = 749,                  /* SECTION  */
  YYSYMBOL_SECURE = 750,                   /* SECURE  */
  YYSYMBOL_SECURITY = 751,                 /* SECURITY  */
  YYSYMBOL_SEGMENT = 752,                  /* SEGMENT  */
  YYSYMBOL_SEGMENT_LIMIT = 753,            /* "SEGMENT-LIMIT"  */
  YYSYMBOL_SELECT = 754,                   /* SELECT  */
  YYSYMBOL_SELECTION_INDEX = 755,          /* "SELECTION-INDEX"  */
  YYSYMBOL_SELECTION_TEXT = 756,           /* "SELECTION-TEXT"  */
  YYSYMBOL_SELECT_ALL = 757,               /* "SELECTION-ALL"  */
  YYSYMBOL_SELF_ACT = 758,                 /* "SELF-ACT"  */
  YYSYMBOL_SEMI_COLON = 759,               /* "semi-colon"  */
  YYSYMBOL_SEND = 760,                     /* SEND  */
  YYSYMBOL_SENTENCE = 761,                 /* SENTENCE  */
  YYSYMBOL_SEPARATE = 762,                 /* SEPARATE  */
  YYSYMBOL_SEPARATION = 763,               /* SEPARATION  */
  YYSYMBOL_SEQUENCE = 764,                 /* SEQUENCE  */
  YYSYMBOL_SEQUENTIAL = 765,               /* SEQUENTIAL  */
  YYSYMBOL_SET = 766,                      /* SET  */
  YYSYMBOL_SEVENTY_EIGHT = 767,            /* "level-number 78"  */
  YYSYMBOL_SHADING = 768,                  /* SHADING  */
  YYSYMBOL_SHADOW = 769,                   /* SHADOW  */
  YYSYMBOL_SHARING = 770,                  /* SHARING  */
  YYSYMBOL_SHORT_DATE = 771,               /* "SHORT-DATE"  */
  YYSYMBOL_SHOW_LINES = 772,               /* "SHOW-LINES"  */
  YYSYMBOL_SHOW_NONE = 773,                /* "SHOW-NONE"  */
  YYSYMBOL_SHOW_SEL_ALWAYS = 774,          /* "SHOW-SEL-ALWAYS"  */
  YYSYMBOL_SIGN = 775,                     /* SIGN  */
  YYSYMBOL_SIGNED = 776,                   /* SIGNED  */
  YYSYMBOL_SIGNED_INT = 777,               /* "SIGNED-INT"  */
  YYSYMBOL_SIGNED_LONG = 778,              /* "SIGNED-LONG"  */
  YYSYMBOL_SIGNED_SHORT = 779,             /* "SIGNED-SHORT"  */
  YYSYMBOL_SIXTY_SIX = 780,                /* "level-number 66"  */
  YYSYMBOL_SIZE = 781,                     /* SIZE  */
  YYSYMBOL_SIZE_ERROR = 782,               /* "SIZE ERROR"  */
  YYSYMBOL_SMALL_FONT = 783,               /* "SMALL-FONT"  */
  YYSYMBOL_SORT = 784,                     /* SORT  */
  YYSYMBOL_SORT_MERGE = 785,               /* "SORT-MERGE"  */
  YYSYMBOL_SORT_ORDER = 786,               /* "SORT-ORDER"  */
  YYSYMBOL_SOURCE = 787,                   /* SOURCE  */
  YYSYMBOL_SOURCE_COMPUTER = 788,          /* "SOURCE-COMPUTER"  */
  YYSYMBOL_SPACE = 789,                    /* SPACE  */
  YYSYMBOL_SPECIAL_NAMES = 790,            /* "SPECIAL-NAMES"  */
  YYSYMBOL_SPINNER = 791,                  /* SPINNER  */
  YYSYMBOL_SQUARE = 792,                   /* SQUARE  */
  YYSYMBOL_STANDARD = 793,                 /* STANDARD  */
  YYSYMBOL_STANDARD_1 = 794,               /* "STANDARD-1"  */
  YYSYMBOL_STANDARD_2 = 795,               /* "STANDARD-2"  */
  YYSYMBOL_STANDARD_BINARY = 796,          /* "STANDARD-BINARY"  */
  YYSYMBOL_STANDARD_DECIMAL = 797,         /* "STANDARD-DECIMAL"  */
  YYSYMBOL_START = 798,                    /* START  */
  YYSYMBOL_START_X = 799,                  /* "START-X"  */
  YYSYMBOL_START_Y = 800,                  /* "START-Y"  */
  YYSYMBOL_STATIC = 801,                   /* STATIC  */
  YYSYMBOL_STATIC_LIST = 802,              /* "STATIC-LIST"  */
  YYSYMBOL_STATUS = 803,                   /* STATUS  */
  YYSYMBOL_STATUS_BAR = 804,               /* "STATUS-BAR"  */
  YYSYMBOL_STATUS_TEXT = 805,              /* "STATUS-TEXT"  */
  YYSYMBOL_STDCALL = 806,                  /* STDCALL  */
  YYSYMBOL_STEP = 807,                     /* STEP  */
  YYSYMBOL_STOP = 808,                     /* STOP  */
  YYSYMBOL_STRING = 809,                   /* STRING  */
  YYSYMBOL_STRONG = 810,                   /* STRONG  */
  YYSYMBOL_STYLE = 811,                    /* STYLE  */
  YYSYMBOL_SUB_QUEUE_1 = 812,              /* "SUB-QUEUE-1"  */
  YYSYMBOL_SUB_QUEUE_2 = 813,              /* "SUB-QUEUE-2"  */
  YYSYMBOL_SUB_QUEUE_3 = 814,              /* "SUB-QUEUE-3"  */
  YYSYMBOL_SUBSTITUTE_FUNC = 815,          /* "FUNCTION SUBSTITUTE"  */
  YYSYMBOL_SUBSTITUTE_CASE_FUNC = 816,     /* "FUNCTION SUBSTITUTE-CASE"  */
  YYSYMBOL_SUBTRACT = 817,                 /* SUBTRACT  */
  YYSYMBOL_SUBWINDOW = 818,                /* SUBWINDOW  */
  YYSYMBOL_SUM = 819,                      /* SUM  */
  YYSYMBOL_SUPPRESS = 820,                 /* SUPPRESS  */
  YYSYMBOL_SUPPRESS_XML = 821,             /* "SUPPRESS"  */
  YYSYMBOL_SYMBOLIC = 822,                 /* SYMBOLIC  */
  YYSYMBOL_SYNCHRONIZED = 823,             /* SYNCHRONIZED  */
  YYSYMBOL_SYSTEM_DEFAULT = 824,           /* "SYSTEM-DEFAULT"  */
  YYSYMBOL_SYSTEM_INFO = 825,              /* "SYSTEM-INFO"  */
  YYSYMBOL_SYSTEM_OFFSET = 826,            /* "SYSTEM-OFFSET"  */
  YYSYMBOL_TAB = 827,                      /* TAB  */
  YYSYMBOL_TAB_TO_ADD = 828,               /* "TAB-TO-ADD"  */
  YYSYMBOL_TAB_TO_DELETE = 829,            /* "TAB-TO-DELETE"  */
  YYSYMBOL_TABLE = 830,                    /* TABLE  */
  YYSYMBOL_TALLYING = 831,                 /* TALLYING  */
  YYSYMBOL_TEMPORARY = 832,                /* TEMPORARY  */
  YYSYMBOL_TAPE = 833,                     /* TAPE  */
  YYSYMBOL_TERMINAL = 834,                 /* TERMINAL  */
  YYSYMBOL_TERMINATE = 835,                /* TERMINATE  */
  YYSYMBOL_TERMINAL_INFO = 836,            /* "TERMINAL-INFO"  */
  YYSYMBOL_TERMINATION_VALUE = 837,        /* "TERMINATION-VALUE"  */
  YYSYMBOL_TEST = 838,                     /* TEST  */
  YYSYMBOL_TEXT = 839,                     /* TEXT  */
  YYSYMBOL_THAN = 840,                     /* THAN  */
  YYSYMBOL_THEN = 841,                     /* THEN  */
  YYSYMBOL_THREAD = 842,                   /* THREAD  */
  YYSYMBOL_THREADS = 843,                  /* THREADS  */
  YYSYMBOL_THRU = 844,                     /* THRU  */
  YYSYMBOL_THUMB_POSITION = 845,           /* "THUMB-POSITION"  */
  YYSYMBOL_TILED_HEADINGS = 846,           /* "TILED-HEADINGS"  */
  YYSYMBOL_TIME = 847,                     /* TIME  */
  YYSYMBOL_TIME_OUT = 848,                 /* "TIME-OUT"  */
  YYSYMBOL_TIMES = 849,                    /* TIMES  */
  YYSYMBOL_TITLE = 850,                    /* TITLE  */
  YYSYMBOL_TITLE_POSITION = 851,           /* "TITLE-POSITION"  */
  YYSYMBOL_TO = 852,                       /* TO  */
  YYSYMBOL_TOK_AMPER = 853,                /* "&"  */
  YYSYMBOL_TOK_CLOSE_PAREN = 854,          /* ")"  */
  YYSYMBOL_TOK_COLON = 855,                /* ":"  */
  YYSYMBOL_TOK_DIV = 856,                  /* "/"  */
  YYSYMBOL_TOK_DOT = 857,                  /* "."  */
  YYSYMBOL_TOK_EQUAL = 858,                /* "="  */
  YYSYMBOL_TOK_EXTERN = 859,               /* "EXTERN"  */
  YYSYMBOL_TOK_FALSE = 860,                /* "FALSE"  */
  YYSYMBOL_TOK_FILE = 861,                 /* "FILE"  */
  YYSYMBOL_TOK_GREATER = 862,              /* ">"  */
  YYSYMBOL_TOK_INITIAL = 863,              /* "INITIAL"  */
  YYSYMBOL_TOK_LESS = 864,                 /* "<"  */
  YYSYMBOL_TOK_MINUS = 865,                /* "-"  */
  YYSYMBOL_TOK_MUL = 866,                  /* "*"  */
  YYSYMBOL_TOK_NULL = 867,                 /* "NULL"  */
  YYSYMBOL_TOK_OVERFLOW = 868,             /* "OVERFLOW"  */
  YYSYMBOL_TOK_OPEN_PAREN = 869,           /* "("  */
  YYSYMBOL_TOK_PLUS = 870,                 /* "+"  */
  YYSYMBOL_TOK_TRUE = 871,                 /* "TRUE"  */
  YYSYMBOL_TOP = 872,                      /* TOP  */
  YYSYMBOL_TOWARD_GREATER = 873,           /* "TOWARD-GREATER"  */
  YYSYMBOL_TOWARD_LESSER = 874,            /* "TOWARD-LESSER"  */
  YYSYMBOL_TRACK = 875,                    /* TRACK  */
  YYSYMBOL_TRACKS = 876,                   /* TRACKS  */
  YYSYMBOL_TRACK_AREA = 877,               /* "TRACK-AREA"  */
  YYSYMBOL_TRACK_LIMIT = 878,              /* "TRACK-LIMIT"  */
  YYSYMBOL_TRADITIONAL_FONT = 879,         /* "TRADITIONAL-FONT"  */
  YYSYMBOL_TRAILING = 880,                 /* TRAILING  */
  YYSYMBOL_TRAILING_SHIFT = 881,           /* "TRAILING-SHIFT"  */
  YYSYMBOL_TRANSFORM = 882,                /* TRANSFORM  */
  YYSYMBOL_TRANSPARENT = 883,              /* TRANSPARENT  */
  YYSYMBOL_TREE_VIEW = 884,                /* "TREE-VIEW"  */
  YYSYMBOL_TRIM_FUNC = 885,                /* "FUNCTION TRIM"  */
  YYSYMBOL_TRUNCATION = 886,               /* TRUNCATION  */
  YYSYMBOL_TYPE = 887,                     /* TYPE  */
  YYSYMBOL_TYPEDEF = 888,                  /* TYPEDEF  */
  YYSYMBOL_U = 889,                        /* U  */
  YYSYMBOL_UCS_4 = 890,                    /* "UCS-4"  */
  YYSYMBOL_UNBOUNDED = 891,                /* UNBOUNDED  */
  YYSYMBOL_UNDERLINE = 892,                /* UNDERLINE  */
  YYSYMBOL_UNFRAMED = 893,                 /* UNFRAMED  */
  YYSYMBOL_UNIT = 894,                     /* UNIT  */
  YYSYMBOL_UNLOCK = 895,                   /* UNLOCK  */
  YYSYMBOL_UNSIGNED = 896,                 /* UNSIGNED  */
  YYSYMBOL_UNSIGNED_INT = 897,             /* "UNSIGNED-INT"  */
  YYSYMBOL_UNSIGNED_LONG = 898,            /* "UNSIGNED-LONG"  */
  YYSYMBOL_UNSIGNED_SHORT = 899,           /* "UNSIGNED-SHORT"  */
  YYSYMBOL_UNSORTED = 900,                 /* UNSORTED  */
  YYSYMBOL_UNSTRING = 901,                 /* UNSTRING  */
  YYSYMBOL_UNTIL = 902,                    /* UNTIL  */
  YYSYMBOL_UP = 903,                       /* UP  */
  YYSYMBOL_UPDATE = 904,                   /* UPDATE  */
  YYSYMBOL_UPDATERS = 905,                 /* UPDATERS  */
  YYSYMBOL_UPON = 906,                     /* UPON  */
  YYSYMBOL_UPON_ARGUMENT_NUMBER = 907,     /* "UPON ARGUMENT-NUMBER"  */
  YYSYMBOL_UPON_COMMAND_LINE = 908,        /* "UPON COMMAND-LINE"  */
  YYSYMBOL_UPON_ENVIRONMENT_NAME = 909,    /* "UPON ENVIRONMENT-NAME"  */
  YYSYMBOL_UPON_ENVIRONMENT_VALUE = 910,   /* "UPON ENVIRONMENT-VALUE"  */
  YYSYMBOL_UPPER = 911,                    /* UPPER  */
  YYSYMBOL_UPPER_CASE_FUNC = 912,          /* "FUNCTION UPPER-CASE"  */
  YYSYMBOL_USAGE = 913,                    /* USAGE  */
  YYSYMBOL_USE = 914,                      /* USE  */
  YYSYMBOL_USE_ALT = 915,                  /* "USE-ALT"  */
  YYSYMBOL_USE_RETURN = 916,               /* "USE-RETURN"  */
  YYSYMBOL_USE_TAB = 917,                  /* "USE-TAB"  */
  YYSYMBOL_USER = 918,                     /* USER  */
  YYSYMBOL_USER_DEFAULT = 919,             /* "USER-DEFAULT"  */
  YYSYMBOL_USER_FUNCTION_NAME = 920,       /* "user function name"  */
  YYSYMBOL_USING = 921,                    /* USING  */
  YYSYMBOL_UTF_8 = 922,                    /* "UTF-8"  */
  YYSYMBOL_UTF_16 = 923,                   /* "UTF-16"  */
  YYSYMBOL_V = 924,                        /* V  */
  YYSYMBOL_VALID = 925,                    /* VALID  */
  YYSYMBOL_VALIDATE = 926,                 /* VALIDATE  */
  YYSYMBOL_VAL_STATUS = 927,               /* "VAL-STATUS"  */
  YYSYMBOL_VALIDATE_STATUS = 928,          /* "VALIDATE-STATUS"  */
  YYSYMBOL_VALIDATING = 929,               /* VALIDATING  */
  YYSYMBOL_VALUE = 930,                    /* VALUE  */
  YYSYMBOL_VALUE_FORMAT = 931,             /* "VALUE-FORMAT"  */
  YYSYMBOL_VALUES = 932,                   /* VALUES  */
  YYSYMBOL_VARIABLE = 933,                 /* VARIABLE  */
  YYSYMBOL_VARIANT = 934,                  /* VARIANT  */
  YYSYMBOL_VARYING = 935,                  /* VARYING  */
  YYSYMBOL_VERTICAL = 936,                 /* VERTICAL  */
  YYSYMBOL_VERY_HEAVY = 937,               /* "VERY-HEAVY"  */
  YYSYMBOL_VIRTUAL_WIDTH = 938,            /* "VIRTUAL-WIDTH"  */
  YYSYMBOL_VOLATILE = 939,                 /* VOLATILE  */
  YYSYMBOL_VPADDING = 940,                 /* VPADDING  */
  YYSYMBOL_VSCROLL = 941,                  /* VSCROLL  */
  YYSYMBOL_VSCROLL_BAR = 942,              /* "VSCROLL-BAR"  */
  YYSYMBOL_VSCROLL_POS = 943,              /* "VSCROLL-POS"  */
  YYSYMBOL_VTOP = 944,                     /* VTOP  */
  YYSYMBOL_WAIT = 945,                     /* WAIT  */
  YYSYMBOL_WEB_BROWSER = 946,              /* "WEB-BROWSER"  */
  YYSYMBOL_WHEN = 947,                     /* WHEN  */
  YYSYMBOL_WHEN_COMPILED_FUNC = 948,       /* "FUNCTION WHEN-COMPILED"  */
  YYSYMBOL_WHEN_XML = 949,                 /* "WHEN"  */
  YYSYMBOL_WIDTH = 950,                    /* WIDTH  */
  YYSYMBOL_WIDTH_IN_CELLS = 951,           /* "WIDTH-IN-CELLS"  */
  YYSYMBOL_WINAPI = 952,                   /* WINAPI  */
  YYSYMBOL_WINDOW = 953,                   /* WINDOW  */
  YYSYMBOL_WITH = 954,                     /* WITH  */
  YYSYMBOL_WORD = 955,                     /* "Identifier"  */
  YYSYMBOL_WORDS = 956,                    /* WORDS  */
  YYSYMBOL_WORKING_STORAGE = 957,          /* "WORKING-STORAGE"  */
  YYSYMBOL_WRAP = 958,                     /* WRAP  */
  YYSYMBOL_WRITE = 959,                    /* WRITE  */
  YYSYMBOL_WRITE_ONLY = 960,               /* "WRITE-ONLY"  */
  YYSYMBOL_WRITE_VERIFY = 961,             /* "WRITE-VERIFY"  */
  YYSYMBOL_WRITERS = 962,                  /* WRITERS  */
  YYSYMBOL_X = 963,                        /* X  */
  YYSYMBOL_XML = 964,                      /* XML  */
  YYSYMBOL_XML_DECLARATION = 965,          /* "XML-DECLARATION"  */
  YYSYMBOL_XML_SCHEMA = 966,               /* "XML-SCHEMA"  */
  YYSYMBOL_Y = 967,                        /* Y  */
  YYSYMBOL_YYYYDDD = 968,                  /* YYYYDDD  */
  YYSYMBOL_YYYYMMDD = 969,                 /* YYYYMMDD  */
  YYSYMBOL_ZERO = 970,                     /* ZERO  */
  YYSYMBOL_LEVEL_NUMBER_IN_AREA_A = 971,   /* "level-number (Area A)"  */
  YYSYMBOL_WORD_IN_AREA_A = 972,           /* "Identifier (Area A)"  */
  YYSYMBOL_SHIFT_PREFER = 973,             /* SHIFT_PREFER  */
  YYSYMBOL_YYACCEPT = 974,                 /* $accept  */
  YYSYMBOL_start = 975,                    /* start  */
  YYSYMBOL_976_1 = 976,                    /* $@1  */
  YYSYMBOL_compilation_group = 977,        /* compilation_group  */
  YYSYMBOL_nested_list = 978,              /* nested_list  */
  YYSYMBOL_979_2 = 979,                    /* $@2  */
  YYSYMBOL_source_element_list = 980,      /* source_element_list  */
  YYSYMBOL_source_element = 981,           /* source_element  */
  YYSYMBOL_simple_prog = 982,              /* simple_prog  */
  YYSYMBOL_983_3 = 983,                    /* $@3  */
  YYSYMBOL_program_definition = 984,       /* program_definition  */
  YYSYMBOL_function_definition = 985,      /* function_definition  */
  YYSYMBOL__end_program_list = 986,        /* _end_program_list  */
  YYSYMBOL_end_program_list = 987,         /* end_program_list  */
  YYSYMBOL_end_program = 988,              /* end_program  */
  YYSYMBOL_989_4 = 989,                    /* $@4  */
  YYSYMBOL_end_function = 990,             /* end_function  */
  YYSYMBOL_991_5 = 991,                    /* $@5  */
  YYSYMBOL_program_prototype = 992,        /* program_prototype  */
  YYSYMBOL_993_6 = 993,                    /* $@6  */
  YYSYMBOL_994_7 = 994,                    /* $@7  */
  YYSYMBOL_function_prototype = 995,       /* function_prototype  */
  YYSYMBOL_996_8 = 996,                    /* $@8  */
  YYSYMBOL_997_9 = 997,                    /* $@9  */
  YYSYMBOL__prototype_procedure_division_header = 998, /* _prototype_procedure_division_header  */
  YYSYMBOL_999_10 = 999,                   /* $@10  */
  YYSYMBOL_control = 1000,                 /* control  */
  YYSYMBOL__control_division = 1001,       /* _control_division  */
  YYSYMBOL_1002_11 = 1002,                 /* $@11  */
  YYSYMBOL__default_section = 1003,        /* _default_section  */
  YYSYMBOL_1004_12 = 1004,                 /* $@12  */
  YYSYMBOL__default_clauses = 1005,        /* _default_clauses  */
  YYSYMBOL__default_accept_clause = 1006,  /* _default_accept_clause  */
  YYSYMBOL_1007_13 = 1007,                 /* $@13  */
  YYSYMBOL__default_display_clause = 1008, /* _default_display_clause  */
  YYSYMBOL_1009_14 = 1009,                 /* $@14  */
  YYSYMBOL__program_body = 1010,           /* _program_body  */
  YYSYMBOL_1011_15 = 1011,                 /* $@15  */
  YYSYMBOL_1012_16 = 1012,                 /* $@16  */
  YYSYMBOL__identification_header = 1013,  /* _identification_header  */
  YYSYMBOL_identification_header = 1014,   /* identification_header  */
  YYSYMBOL_1015_17 = 1015,                 /* $@17  */
  YYSYMBOL_identification_or_id = 1016,    /* identification_or_id  */
  YYSYMBOL_program_id_header = 1017,       /* program_id_header  */
  YYSYMBOL_program_id_paragraph = 1018,    /* program_id_paragraph  */
  YYSYMBOL_function_id_header = 1019,      /* function_id_header  */
  YYSYMBOL_function_id_paragraph = 1020,   /* function_id_paragraph  */
  YYSYMBOL_program_id_name = 1021,         /* program_id_name  */
  YYSYMBOL_end_program_name = 1022,        /* end_program_name  */
  YYSYMBOL__as_literal = 1023,             /* _as_literal  */
  YYSYMBOL__program_type = 1024,           /* _program_type  */
  YYSYMBOL_program_type_clause = 1025,     /* program_type_clause  */
  YYSYMBOL_init_or_recurse_and_common = 1026, /* init_or_recurse_and_common  */
  YYSYMBOL_init_or_recurse = 1027,         /* init_or_recurse  */
  YYSYMBOL__options_paragraph = 1028,      /* _options_paragraph  */
  YYSYMBOL__options_clauses = 1029,        /* _options_clauses  */
  YYSYMBOL__arithmetic_clause = 1030,      /* _arithmetic_clause  */
  YYSYMBOL_arithmetic_choice = 1031,       /* arithmetic_choice  */
  YYSYMBOL__default_rounded_clause = 1032, /* _default_rounded_clause  */
  YYSYMBOL__entry_convention_clause = 1033, /* _entry_convention_clause  */
  YYSYMBOL_convention_type = 1034,         /* convention_type  */
  YYSYMBOL__intermediate_rounding_clause = 1035, /* _intermediate_rounding_clause  */
  YYSYMBOL_intermediate_rounding_choice = 1036, /* intermediate_rounding_choice  */
  YYSYMBOL__environment_division = 1037,   /* _environment_division  */
  YYSYMBOL__environment_header = 1038,     /* _environment_header  */
  YYSYMBOL_environment = 1039,             /* environment  */
  YYSYMBOL_environment_header = 1040,      /* environment_header  */
  YYSYMBOL__configuration_section = 1041,  /* _configuration_section  */
  YYSYMBOL__configuration_header = 1042,   /* _configuration_header  */
  YYSYMBOL_configuration = 1043,           /* configuration  */
  YYSYMBOL_configuration_header = 1044,    /* configuration_header  */
  YYSYMBOL__configuration_paragraphs = 1045, /* _configuration_paragraphs  */
  YYSYMBOL_configuration_paragraphs = 1046, /* configuration_paragraphs  */
  YYSYMBOL_configuration_paragraph = 1047, /* configuration_paragraph  */
  YYSYMBOL__source_computer_paragraph = 1048, /* _source_computer_paragraph  */
  YYSYMBOL_source_computer_paragraph = 1049, /* source_computer_paragraph  */
  YYSYMBOL_1050_18 = 1050,                 /* $@18  */
  YYSYMBOL__source_computer_entry = 1051,  /* _source_computer_entry  */
  YYSYMBOL__with_debugging_mode = 1052,    /* _with_debugging_mode  */
  YYSYMBOL_object_computer_paragraph = 1053, /* object_computer_paragraph  */
  YYSYMBOL_1054_19 = 1054,                 /* $@19  */
  YYSYMBOL__object_computer_entry = 1055,  /* _object_computer_entry  */
  YYSYMBOL_object_clauses_list = 1056,     /* object_clauses_list  */
  YYSYMBOL_object_clauses = 1057,          /* object_clauses  */
  YYSYMBOL_object_computer_memory = 1058,  /* object_computer_memory  */
  YYSYMBOL_object_computer_sequence = 1059, /* object_computer_sequence  */
  YYSYMBOL_program_collating_sequence = 1060, /* program_collating_sequence  */
  YYSYMBOL_program_coll_sequence_values = 1061, /* program_coll_sequence_values  */
  YYSYMBOL_object_computer_segment = 1062, /* object_computer_segment  */
  YYSYMBOL_object_computer_class = 1063,   /* object_computer_class  */
  YYSYMBOL_locale_class = 1064,            /* locale_class  */
  YYSYMBOL_computer_words = 1065,          /* computer_words  */
  YYSYMBOL__repository_paragraph = 1066,   /* _repository_paragraph  */
  YYSYMBOL_repository_paragraph = 1067,    /* repository_paragraph  */
  YYSYMBOL_1068_20 = 1068,                 /* $@20  */
  YYSYMBOL__repository_entry = 1069,       /* _repository_entry  */
  YYSYMBOL_repository_list = 1070,         /* repository_list  */
  YYSYMBOL_repository_name = 1071,         /* repository_name  */
  YYSYMBOL_repository_name_list = 1072,    /* repository_name_list  */
  YYSYMBOL_special_names_header = 1073,    /* special_names_header  */
  YYSYMBOL_special_names_sentence = 1074,  /* special_names_sentence  */
  YYSYMBOL_special_name_list = 1075,       /* special_name_list  */
  YYSYMBOL_special_name = 1076,            /* special_name  */
  YYSYMBOL_mnemonic_name_clause = 1077,    /* mnemonic_name_clause  */
  YYSYMBOL_1078_21 = 1078,                 /* $@21  */
  YYSYMBOL_word_or_terminal = 1079,        /* word_or_terminal  */
  YYSYMBOL_mnemonic_choices = 1080,        /* mnemonic_choices  */
  YYSYMBOL__special_name_mnemonic_on_off = 1081, /* _special_name_mnemonic_on_off  */
  YYSYMBOL_on_off_clauses = 1082,          /* on_off_clauses  */
  YYSYMBOL_on_off_clauses_1 = 1083,        /* on_off_clauses_1  */
  YYSYMBOL_alphabet_name_clause = 1084,    /* alphabet_name_clause  */
  YYSYMBOL_1085_22 = 1085,                 /* @22  */
  YYSYMBOL_alphabet_definition = 1086,     /* alphabet_definition  */
  YYSYMBOL_1087_23 = 1087,                 /* @23  */
  YYSYMBOL_1088_24 = 1088,                 /* @24  */
  YYSYMBOL_alphabet_target_alphanumeric = 1089, /* alphabet_target_alphanumeric  */
  YYSYMBOL_alphabet_target_national = 1090, /* alphabet_target_national  */
  YYSYMBOL_alphabet_type_alphanumeric = 1091, /* alphabet_type_alphanumeric  */
  YYSYMBOL_alphabet_type_national = 1092,  /* alphabet_type_national  */
  YYSYMBOL_alphabet_type_common = 1093,    /* alphabet_type_common  */
  YYSYMBOL_alphabet_literal_list = 1094,   /* alphabet_literal_list  */
  YYSYMBOL_alphabet_literal = 1095,        /* alphabet_literal  */
  YYSYMBOL_1096_25 = 1096,                 /* @25  */
  YYSYMBOL_alphabet_also_sequence = 1097,  /* alphabet_also_sequence  */
  YYSYMBOL_alphabet_lits = 1098,           /* alphabet_lits  */
  YYSYMBOL_space_or_zero = 1099,           /* space_or_zero  */
  YYSYMBOL__alphnat_target = 1100,         /* _alphnat_target  */
  YYSYMBOL__in_alphabet = 1101,            /* _in_alphabet  */
  YYSYMBOL_symbolic_characters_clause = 1102, /* symbolic_characters_clause  */
  YYSYMBOL_symbolic_collection = 1103,     /* symbolic_collection  */
  YYSYMBOL_symbolic_chars_list = 1104,     /* symbolic_chars_list  */
  YYSYMBOL_symbolic_chars_phrase = 1105,   /* symbolic_chars_phrase  */
  YYSYMBOL_char_list = 1106,               /* char_list  */
  YYSYMBOL_integer_list = 1107,            /* integer_list  */
  YYSYMBOL_symbolic_constant_clause = 1108, /* symbolic_constant_clause  */
  YYSYMBOL_symbolic_constant_list = 1109,  /* symbolic_constant_list  */
  YYSYMBOL_symbolic_constant = 1110,       /* symbolic_constant  */
  YYSYMBOL_class_name_clause = 1111,       /* class_name_clause  */
  YYSYMBOL_class_item_list = 1112,         /* class_item_list  */
  YYSYMBOL_class_item = 1113,              /* class_item  */
  YYSYMBOL_locale_clause = 1114,           /* locale_clause  */
  YYSYMBOL_xml_schema_clause = 1115,       /* xml_schema_clause  */
  YYSYMBOL_1116_26 = 1116,                 /* @26  */
  YYSYMBOL_schema_definition = 1117,       /* schema_definition  */
  YYSYMBOL_currency_sign_clause = 1118,    /* currency_sign_clause  */
  YYSYMBOL__with_pic_symbol = 1119,        /* _with_pic_symbol  */
  YYSYMBOL_decimal_point_clause = 1120,    /* decimal_point_clause  */
  YYSYMBOL_numeric_sign_clause = 1121,     /* numeric_sign_clause  */
  YYSYMBOL_cursor_clause = 1122,           /* cursor_clause  */
  YYSYMBOL_crt_status_clause = 1123,       /* crt_status_clause  */
  YYSYMBOL_screen_control = 1124,          /* screen_control  */
  YYSYMBOL_event_status = 1125,            /* event_status  */
  YYSYMBOL_top_clause = 1126,              /* top_clause  */
  YYSYMBOL_1127_27 = 1127,                 /* $@27  */
  YYSYMBOL__input_output_section = 1128,   /* _input_output_section  */
  YYSYMBOL_input_output = 1129,            /* input_output  */
  YYSYMBOL__input_output_header = 1130,    /* _input_output_header  */
  YYSYMBOL__file_control_header = 1131,    /* _file_control_header  */
  YYSYMBOL__file_control_sequence = 1132,  /* _file_control_sequence  */
  YYSYMBOL_file_control_entry = 1133,      /* file_control_entry  */
  YYSYMBOL_1134_28 = 1134,                 /* $@28  */
  YYSYMBOL_1135_29 = 1135,                 /* $@29  */
  YYSYMBOL__select_clauses_or_error = 1136, /* _select_clauses_or_error  */
  YYSYMBOL__select_clause_sequence = 1137, /* _select_clause_sequence  */
  YYSYMBOL_select_clause = 1138,           /* select_clause  */
  YYSYMBOL_assign_clause = 1139,           /* assign_clause  */
  YYSYMBOL__assign_device_or_line_adv_file = 1140, /* _assign_device_or_line_adv_file  */
  YYSYMBOL_assign_device = 1141,           /* assign_device  */
  YYSYMBOL_general_device_name = 1142,     /* general_device_name  */
  YYSYMBOL_line_seq_device_name = 1143,    /* line_seq_device_name  */
  YYSYMBOL_line_adv_file = 1144,           /* line_adv_file  */
  YYSYMBOL__ext_clause = 1145,             /* _ext_clause  */
  YYSYMBOL_ext_clause = 1146,              /* ext_clause  */
  YYSYMBOL_assignment_name = 1147,         /* assignment_name  */
  YYSYMBOL_access_mode_clause = 1148,      /* access_mode_clause  */
  YYSYMBOL_access_mode = 1149,             /* access_mode  */
  YYSYMBOL_alternate_record_key_clause = 1150, /* alternate_record_key_clause  */
  YYSYMBOL__password_clause = 1151,        /* _password_clause  */
  YYSYMBOL_password_clause = 1152,         /* password_clause  */
  YYSYMBOL_1153_30 = 1153,                 /* $@30  */
  YYSYMBOL_encryption_clause = 1154,       /* encryption_clause  */
  YYSYMBOL__suppress_clause = 1155,        /* _suppress_clause  */
  YYSYMBOL_collating_sequence_clause = 1156, /* collating_sequence_clause  */
  YYSYMBOL_collating_sequence = 1157,      /* collating_sequence  */
  YYSYMBOL_coll_sequence_values = 1158,    /* coll_sequence_values  */
  YYSYMBOL_collating_sequence_clause_key = 1159, /* collating_sequence_clause_key  */
  YYSYMBOL_alphabet_name = 1160,           /* alphabet_name  */
  YYSYMBOL_file_status_clause = 1161,      /* file_status_clause  */
  YYSYMBOL__file_or_sort = 1162,           /* _file_or_sort  */
  YYSYMBOL_lock_mode_clause = 1163,        /* lock_mode_clause  */
  YYSYMBOL_1164_31 = 1164,                 /* $@31  */
  YYSYMBOL_lock_mode = 1165,               /* lock_mode  */
  YYSYMBOL__lock_with = 1166,              /* _lock_with  */
  YYSYMBOL__with_rollback = 1167,          /* _with_rollback  */
  YYSYMBOL_with_rollback = 1168,           /* with_rollback  */
  YYSYMBOL__with_mass_update = 1169,       /* _with_mass_update  */
  YYSYMBOL_organization_clause = 1170,     /* organization_clause  */
  YYSYMBOL_organization = 1171,            /* organization  */
  YYSYMBOL_padding_character_clause = 1172, /* padding_character_clause  */
  YYSYMBOL_record_delimiter_clause = 1173, /* record_delimiter_clause  */
  YYSYMBOL_1174_32 = 1174,                 /* $@32  */
  YYSYMBOL_record_delimiter_option = 1175, /* record_delimiter_option  */
  YYSYMBOL_record_key_clause = 1176,       /* record_key_clause  */
  YYSYMBOL__split_keys = 1177,             /* _split_keys  */
  YYSYMBOL_source_is = 1178,               /* source_is  */
  YYSYMBOL_split_key_list = 1179,          /* split_key_list  */
  YYSYMBOL_1180_33 = 1180,                 /* $@33  */
  YYSYMBOL_split_key = 1181,               /* split_key  */
  YYSYMBOL_relative_key_clause = 1182,     /* relative_key_clause  */
  YYSYMBOL_reserve_clause = 1183,          /* reserve_clause  */
  YYSYMBOL_no_or_integer = 1184,           /* no_or_integer  */
  YYSYMBOL_sharing_clause = 1185,          /* sharing_clause  */
  YYSYMBOL_sharing_option = 1186,          /* sharing_option  */
  YYSYMBOL_file_limit_clause = 1187,       /* file_limit_clause  */
  YYSYMBOL_thru_list = 1188,               /* thru_list  */
  YYSYMBOL_actual_key_clause = 1189,       /* actual_key_clause  */
  YYSYMBOL_nominal_key_clause = 1190,      /* nominal_key_clause  */
  YYSYMBOL_track_area_clause = 1191,       /* track_area_clause  */
  YYSYMBOL_track_limit_clause = 1192,      /* track_limit_clause  */
  YYSYMBOL__i_o_control = 1193,            /* _i_o_control  */
  YYSYMBOL_i_o_control_header = 1194,      /* i_o_control_header  */
  YYSYMBOL__i_o_control_entries = 1195,    /* _i_o_control_entries  */
  YYSYMBOL_i_o_control_list = 1196,        /* i_o_control_list  */
  YYSYMBOL_i_o_control_clause = 1197,      /* i_o_control_clause  */
  YYSYMBOL_same_clause = 1198,             /* same_clause  */
  YYSYMBOL__same_option = 1199,            /* _same_option  */
  YYSYMBOL_apply_clause = 1200,            /* apply_clause  */
  YYSYMBOL_obsolete_dos_vs_apply_phrase = 1201, /* obsolete_dos_vs_apply_phrase  */
  YYSYMBOL_multiple_file_tape_clause = 1202, /* multiple_file_tape_clause  */
  YYSYMBOL_1203_34 = 1203,                 /* $@34  */
  YYSYMBOL_multiple_file_list = 1204,      /* multiple_file_list  */
  YYSYMBOL_multiple_file = 1205,           /* multiple_file  */
  YYSYMBOL__multiple_file_position = 1206, /* _multiple_file_position  */
  YYSYMBOL_rerun_clause = 1207,            /* rerun_clause  */
  YYSYMBOL__on_assignment = 1208,          /* _on_assignment  */
  YYSYMBOL_rerun_event = 1209,             /* rerun_event  */
  YYSYMBOL__prototype_environment_division = 1210, /* _prototype_environment_division  */
  YYSYMBOL__prototype_special_names_paragraph = 1211, /* _prototype_special_names_paragraph  */
  YYSYMBOL__prototype_special_names_sentence_list = 1212, /* _prototype_special_names_sentence_list  */
  YYSYMBOL_prototype_special_names_sentence_list = 1213, /* prototype_special_names_sentence_list  */
  YYSYMBOL_prototype_special_name_list = 1214, /* prototype_special_name_list  */
  YYSYMBOL_prototype_special_name = 1215,  /* prototype_special_name  */
  YYSYMBOL__data_division = 1216,          /* _data_division  */
  YYSYMBOL_1217_35 = 1217,                 /* $@35  */
  YYSYMBOL__data_division_header = 1218,   /* _data_division_header  */
  YYSYMBOL_data = 1219,                    /* data  */
  YYSYMBOL_data_division_header = 1220,    /* data_division_header  */
  YYSYMBOL_tok_file = 1221,                /* tok_file  */
  YYSYMBOL__file_section_header = 1222,    /* _file_section_header  */
  YYSYMBOL__file_description_sequence = 1223, /* _file_description_sequence  */
  YYSYMBOL_file_description = 1224,        /* file_description  */
  YYSYMBOL_file_description_entry = 1225,  /* file_description_entry  */
  YYSYMBOL_1226_36 = 1226,                 /* $@36  */
  YYSYMBOL_file_type = 1227,               /* file_type  */
  YYSYMBOL__file_description_clause_sequence = 1228, /* _file_description_clause_sequence  */
  YYSYMBOL_file_description_clause = 1229, /* file_description_clause  */
  YYSYMBOL_block_contains_clause = 1230,   /* block_contains_clause  */
  YYSYMBOL__records_or_characters = 1231,  /* _records_or_characters  */
  YYSYMBOL_record_clause = 1232,           /* record_clause  */
  YYSYMBOL__record_depending = 1233,       /* _record_depending  */
  YYSYMBOL__from_integer = 1234,           /* _from_integer  */
  YYSYMBOL__to_integer = 1235,             /* _to_integer  */
  YYSYMBOL_label_records_clause = 1236,    /* label_records_clause  */
  YYSYMBOL_value_of_clause = 1237,         /* value_of_clause  */
  YYSYMBOL_file_id = 1238,                 /* file_id  */
  YYSYMBOL_valueof_name = 1239,            /* valueof_name  */
  YYSYMBOL_data_records_clause = 1240,     /* data_records_clause  */
  YYSYMBOL_linage_clause = 1241,           /* linage_clause  */
  YYSYMBOL__linage_sequence = 1242,        /* _linage_sequence  */
  YYSYMBOL_linage_lines = 1243,            /* linage_lines  */
  YYSYMBOL_linage_footing = 1244,          /* linage_footing  */
  YYSYMBOL_linage_top = 1245,              /* linage_top  */
  YYSYMBOL_linage_bottom = 1246,           /* linage_bottom  */
  YYSYMBOL_recording_mode_clause = 1247,   /* recording_mode_clause  */
  YYSYMBOL_recording_mode = 1248,          /* recording_mode  */
  YYSYMBOL_u_or_s = 1249,                  /* u_or_s  */
  YYSYMBOL_code_set_clause = 1250,         /* code_set_clause  */
  YYSYMBOL__for_sub_records_clause = 1251, /* _for_sub_records_clause  */
  YYSYMBOL_report_clause = 1252,           /* report_clause  */
  YYSYMBOL_report_keyword = 1253,          /* report_keyword  */
  YYSYMBOL_rep_name_list = 1254,           /* rep_name_list  */
  YYSYMBOL_communication = 1255,           /* communication  */
  YYSYMBOL__communication_section = 1256,  /* _communication_section  */
  YYSYMBOL_1257_37 = 1257,                 /* $@37  */
  YYSYMBOL__communication_description_sequence = 1258, /* _communication_description_sequence  */
  YYSYMBOL_communication_description = 1259, /* communication_description  */
  YYSYMBOL_cd = 1260,                      /* cd  */
  YYSYMBOL_communication_description_entry = 1261, /* communication_description_entry  */
  YYSYMBOL_1262_38 = 1262,                 /* $@38  */
  YYSYMBOL__communication_description_clause_sequence = 1263, /* _communication_description_clause_sequence  */
  YYSYMBOL_communication_description_clause = 1264, /* communication_description_clause  */
  YYSYMBOL__input_cd_clauses = 1265,       /* _input_cd_clauses  */
  YYSYMBOL_named_input_cd_clauses = 1266,  /* named_input_cd_clauses  */
  YYSYMBOL_named_input_cd_clause = 1267,   /* named_input_cd_clause  */
  YYSYMBOL_unnamed_input_cd_clauses = 1268, /* unnamed_input_cd_clauses  */
  YYSYMBOL__output_cd_clauses = 1269,      /* _output_cd_clauses  */
  YYSYMBOL_output_cd_clauses = 1270,       /* output_cd_clauses  */
  YYSYMBOL_output_cd_clause = 1271,        /* output_cd_clause  */
  YYSYMBOL__i_o_cd_clauses = 1272,         /* _i_o_cd_clauses  */
  YYSYMBOL_named_i_o_cd_clauses = 1273,    /* named_i_o_cd_clauses  */
  YYSYMBOL_named_i_o_cd_clause = 1274,     /* named_i_o_cd_clause  */
  YYSYMBOL_unnamed_i_o_cd_clauses = 1275,  /* unnamed_i_o_cd_clauses  */
  YYSYMBOL_working_storage = 1276,         /* working_storage  */
  YYSYMBOL__working_storage_section = 1277, /* _working_storage_section  */
  YYSYMBOL_1278_39 = 1278,                 /* $@39  */
  YYSYMBOL__record_description_list = 1279, /* _record_description_list  */
  YYSYMBOL_1280_40 = 1280,                 /* $@40  */
  YYSYMBOL_record_description_list = 1281, /* record_description_list  */
  YYSYMBOL_data_description = 1282,        /* data_description  */
  YYSYMBOL_1283_41 = 1283,                 /* $@41  */
  YYSYMBOL_level_number = 1284,            /* level_number  */
  YYSYMBOL__filler = 1285,                 /* _filler  */
  YYSYMBOL__entry_name = 1286,             /* _entry_name  */
  YYSYMBOL_user_entry_name = 1287,         /* user_entry_name  */
  YYSYMBOL__const_global = 1288,           /* _const_global  */
  YYSYMBOL_lit_or_length = 1289,           /* lit_or_length  */
  YYSYMBOL_con_source = 1290,              /* con_source  */
  YYSYMBOL_fp32_usage = 1291,              /* fp32_usage  */
  YYSYMBOL_fp64_usage = 1292,              /* fp64_usage  */
  YYSYMBOL_fp128_usage = 1293,             /* fp128_usage  */
  YYSYMBOL_pointer_len = 1294,             /* pointer_len  */
  YYSYMBOL_renames_entry = 1295,           /* renames_entry  */
  YYSYMBOL__renames_thru = 1296,           /* _renames_thru  */
  YYSYMBOL_condition_name_entry = 1297,    /* condition_name_entry  */
  YYSYMBOL_1298_42 = 1298,                 /* $@42  */
  YYSYMBOL__user_entry_name = 1299,        /* _user_entry_name  */
  YYSYMBOL_constant_entry = 1300,          /* constant_entry  */
  YYSYMBOL_1301_43 = 1301,                 /* $@43  */
  YYSYMBOL_constant_source = 1302,         /* constant_source  */
  YYSYMBOL_constant_78_source = 1303,      /* constant_78_source  */
  YYSYMBOL_constant_expression_list = 1304, /* constant_expression_list  */
  YYSYMBOL_constant_expression = 1305,     /* constant_expression  */
  YYSYMBOL__data_description_clause_sequence = 1306, /* _data_description_clause_sequence  */
  YYSYMBOL_data_description_clause_sequence = 1307, /* data_description_clause_sequence  */
  YYSYMBOL_data_description_clause = 1308, /* data_description_clause  */
  YYSYMBOL_redefines_clause = 1309,        /* redefines_clause  */
  YYSYMBOL_like_clause = 1310,             /* like_clause  */
  YYSYMBOL__length_modifier = 1311,        /* _length_modifier  */
  YYSYMBOL_length_modifier = 1312,         /* length_modifier  */
  YYSYMBOL_same_as_clause = 1313,          /* same_as_clause  */
  YYSYMBOL_typedef_clause = 1314,          /* typedef_clause  */
  YYSYMBOL__strong = 1315,                 /* _strong  */
  YYSYMBOL_external_clause = 1316,         /* external_clause  */
  YYSYMBOL__as_extname = 1317,             /* _as_extname  */
  YYSYMBOL__global_clause = 1318,          /* _global_clause  */
  YYSYMBOL_global_clause = 1319,           /* global_clause  */
  YYSYMBOL_special_names_clause = 1320,    /* special_names_clause  */
  YYSYMBOL_1321_44 = 1321,                 /* $@44  */
  YYSYMBOL_special_names_target = 1322,    /* special_names_target  */
  YYSYMBOL_select_when_clause = 1323,      /* select_when_clause  */
  YYSYMBOL_1324_45 = 1324,                 /* $@45  */
  YYSYMBOL_when_choice = 1325,             /* when_choice  */
  YYSYMBOL_format_clause = 1326,           /* format_clause  */
  YYSYMBOL_format_choice = 1327,           /* format_choice  */
  YYSYMBOL_volatile_clause = 1328,         /* volatile_clause  */
  YYSYMBOL_picture_clause = 1329,          /* picture_clause  */
  YYSYMBOL_1330_46 = 1330,                 /* $@46  */
  YYSYMBOL__pic_locale_format_or_depending_on_or_byte_length = 1331, /* _pic_locale_format_or_depending_on_or_byte_length  */
  YYSYMBOL__is_locale_name = 1332,         /* _is_locale_name  */
  YYSYMBOL_locale_name = 1333,             /* locale_name  */
  YYSYMBOL_type_to_clause = 1334,          /* type_to_clause  */
  YYSYMBOL_usage_clause = 1335,            /* usage_clause  */
  YYSYMBOL_usage_clause_screen_report = 1336, /* usage_clause_screen_report  */
  YYSYMBOL__usage_is = 1337,               /* _usage_is  */
  YYSYMBOL_usage_screen_report = 1338,     /* usage_screen_report  */
  YYSYMBOL_usage = 1339,                   /* usage  */
  YYSYMBOL__to_program_type = 1340,        /* _to_program_type  */
  YYSYMBOL__to_type_name = 1341,           /* _to_type_name  */
  YYSYMBOL_conflict_usage = 1342,          /* conflict_usage  */
  YYSYMBOL__object_reference_type = 1343,  /* _object_reference_type  */
  YYSYMBOL__factory_of = 1344,             /* _factory_of  */
  YYSYMBOL__only = 1345,                   /* _only  */
  YYSYMBOL_double_usage = 1346,            /* double_usage  */
  YYSYMBOL_long_double = 1347,             /* long_double  */
  YYSYMBOL__font_name = 1348,              /* _font_name  */
  YYSYMBOL__layout_name = 1349,            /* _layout_name  */
  YYSYMBOL_sign_clause = 1350,             /* sign_clause  */
  YYSYMBOL_byte_length_clause = 1351,      /* byte_length_clause  */
  YYSYMBOL_report_occurs_clause = 1352,    /* report_occurs_clause  */
  YYSYMBOL_report_occurs_step = 1353,      /* report_occurs_step  */
  YYSYMBOL_occurs_clause = 1354,           /* occurs_clause  */
  YYSYMBOL__occurs_from_integer = 1355,    /* _occurs_from_integer  */
  YYSYMBOL__occurs_to_integer = 1356,      /* _occurs_to_integer  */
  YYSYMBOL__occurs_integer_to = 1357,      /* _occurs_integer_to  */
  YYSYMBOL__occurs_depending = 1358,       /* _occurs_depending  */
  YYSYMBOL__capacity_in = 1359,            /* _capacity_in  */
  YYSYMBOL__occurs_initialized = 1360,     /* _occurs_initialized  */
  YYSYMBOL__occurs_keys_and_indexed = 1361, /* _occurs_keys_and_indexed  */
  YYSYMBOL_1362_47 = 1362,                 /* $@47  */
  YYSYMBOL_occurs_keys = 1363,             /* occurs_keys  */
  YYSYMBOL_occurs_key_list = 1364,         /* occurs_key_list  */
  YYSYMBOL_occurs_key_field = 1365,        /* occurs_key_field  */
  YYSYMBOL_ascending_or_descending = 1366, /* ascending_or_descending  */
  YYSYMBOL__occurs_indexed = 1367,         /* _occurs_indexed  */
  YYSYMBOL_occurs_indexed = 1368,          /* occurs_indexed  */
  YYSYMBOL_occurs_index_list = 1369,       /* occurs_index_list  */
  YYSYMBOL_occurs_index = 1370,            /* occurs_index  */
  YYSYMBOL_justified_clause = 1371,        /* justified_clause  */
  YYSYMBOL_synchronized_clause = 1372,     /* synchronized_clause  */
  YYSYMBOL__left_or_right = 1373,          /* _left_or_right  */
  YYSYMBOL_blank_clause = 1374,            /* blank_clause  */
  YYSYMBOL_based_clause = 1375,            /* based_clause  */
  YYSYMBOL_value_clause = 1376,            /* value_clause  */
  YYSYMBOL_value_table_item_list = 1377,   /* value_table_item_list  */
  YYSYMBOL_value_table_item = 1378,        /* value_table_item  */
  YYSYMBOL_value_from_subscripts_is_are = 1379, /* value_from_subscripts_is_are  */
  YYSYMBOL_from_subscripts = 1380,         /* from_subscripts  */
  YYSYMBOL__to_subscripts = 1381,          /* _to_subscripts  */
  YYSYMBOL_from_to_subscripts = 1382,      /* from_to_subscripts  */
  YYSYMBOL__repeated_phrase = 1383,        /* _repeated_phrase  */
  YYSYMBOL_repeated_phrase = 1384,         /* repeated_phrase  */
  YYSYMBOL_subscripts = 1385,              /* subscripts  */
  YYSYMBOL_value_is_are = 1386,            /* value_is_are  */
  YYSYMBOL_value_item_list = 1387,         /* value_item_list  */
  YYSYMBOL_value_item = 1388,              /* value_item  */
  YYSYMBOL_value_clause_report = 1389,     /* value_clause_report  */
  YYSYMBOL_value_clause_condition = 1390,  /* value_clause_condition  */
  YYSYMBOL_1391_48 = 1391,                 /* $@48  */
  YYSYMBOL_value_item_list_in_alphabet = 1392, /* value_item_list_in_alphabet  */
  YYSYMBOL_value_item_condition_list = 1393, /* value_item_condition_list  */
  YYSYMBOL_value_item_condition = 1394,    /* value_item_condition  */
  YYSYMBOL__false_or_content_validation = 1395, /* _false_or_content_validation  */
  YYSYMBOL_false_is = 1396,                /* false_is  */
  YYSYMBOL_content_validation = 1397,      /* content_validation  */
  YYSYMBOL_valid_or_invalid = 1398,        /* valid_or_invalid  */
  YYSYMBOL__when_condition = 1399,         /* _when_condition  */
  YYSYMBOL_validate_status_clause = 1400,  /* validate_status_clause  */
  YYSYMBOL_when_error_choice = 1401,       /* when_error_choice  */
  YYSYMBOL__on_choice = 1402,              /* _on_choice  */
  YYSYMBOL_default_clause = 1403,          /* default_clause  */
  YYSYMBOL_x_or_none = 1404,               /* x_or_none  */
  YYSYMBOL_class_clause = 1405,            /* class_clause  */
  YYSYMBOL_class_option = 1406,            /* class_option  */
  YYSYMBOL_destination_clause = 1407,      /* destination_clause  */
  YYSYMBOL_present_when_clause = 1408,     /* present_when_clause  */
  YYSYMBOL_invalid_when_clause = 1409,     /* invalid_when_clause  */
  YYSYMBOL_any_length_clause = 1410,       /* any_length_clause  */
  YYSYMBOL_external_form_clause = 1411,    /* external_form_clause  */
  YYSYMBOL_identified_by_clause = 1412,    /* identified_by_clause  */
  YYSYMBOL_local_storage = 1413,           /* local_storage  */
  YYSYMBOL__local_storage_section = 1414,  /* _local_storage_section  */
  YYSYMBOL_1415_49 = 1415,                 /* $@49  */
  YYSYMBOL_linkage = 1416,                 /* linkage  */
  YYSYMBOL__linkage_section = 1417,        /* _linkage_section  */
  YYSYMBOL_1418_50 = 1418,                 /* $@50  */
  YYSYMBOL__report_section = 1419,         /* _report_section  */
  YYSYMBOL_1420_51 = 1420,                 /* $@51  */
  YYSYMBOL_1421_52 = 1421,                 /* $@52  */
  YYSYMBOL__report_description_sequence = 1422, /* _report_description_sequence  */
  YYSYMBOL_report_description = 1423,      /* report_description  */
  YYSYMBOL_1424_53 = 1424,                 /* $@53  */
  YYSYMBOL_1425_54 = 1425,                 /* $@54  */
  YYSYMBOL__report_description_options = 1426, /* _report_description_options  */
  YYSYMBOL_report_description_option = 1427, /* report_description_option  */
  YYSYMBOL_control_clause = 1428,          /* control_clause  */
  YYSYMBOL_control_field_list = 1429,      /* control_field_list  */
  YYSYMBOL_control_final_tag = 1430,       /* control_final_tag  */
  YYSYMBOL_control_identifier_list = 1431, /* control_identifier_list  */
  YYSYMBOL_control_identifier = 1432,      /* control_identifier  */
  YYSYMBOL_page_limit_clause = 1433,       /* page_limit_clause  */
  YYSYMBOL_page_line_column = 1434,        /* page_line_column  */
  YYSYMBOL_page_limit_cols = 1435,         /* page_limit_cols  */
  YYSYMBOL_integer_or_zero_or_ident = 1436, /* integer_or_zero_or_ident  */
  YYSYMBOL__page_heading_list = 1437,      /* _page_heading_list  */
  YYSYMBOL_page_detail = 1438,             /* page_detail  */
  YYSYMBOL_heading_clause = 1439,          /* heading_clause  */
  YYSYMBOL_first_detail = 1440,            /* first_detail  */
  YYSYMBOL_last_heading = 1441,            /* last_heading  */
  YYSYMBOL_last_detail = 1442,             /* last_detail  */
  YYSYMBOL_footing_clause = 1443,          /* footing_clause  */
  YYSYMBOL__report_group_description_list = 1444, /* _report_group_description_list  */
  YYSYMBOL_report_group_description_entry = 1445, /* report_group_description_entry  */
  YYSYMBOL_1446_55 = 1446,                 /* $@55  */
  YYSYMBOL__report_group_options = 1447,   /* _report_group_options  */
  YYSYMBOL_report_group_option = 1448,     /* report_group_option  */
  YYSYMBOL_type_is_clause = 1449,          /* type_is_clause  */
  YYSYMBOL_type_option = 1450,             /* type_option  */
  YYSYMBOL__control_heading_final = 1451,  /* _control_heading_final  */
  YYSYMBOL__or_page = 1452,                /* _or_page  */
  YYSYMBOL__control_footing_final = 1453,  /* _control_footing_final  */
  YYSYMBOL_next_group_clause = 1454,       /* next_group_clause  */
  YYSYMBOL_next_group_plus = 1455,         /* next_group_plus  */
  YYSYMBOL_next_page = 1456,               /* next_page  */
  YYSYMBOL_sum_clause_list = 1457,         /* sum_clause_list  */
  YYSYMBOL__reset_clause = 1458,           /* _reset_clause  */
  YYSYMBOL_data_or_final = 1459,           /* data_or_final  */
  YYSYMBOL_present_when_condition = 1460,  /* present_when_condition  */
  YYSYMBOL_present_absent = 1461,          /* present_absent  */
  YYSYMBOL__page_or_id = 1462,             /* _page_or_id  */
  YYSYMBOL_page_or_ids = 1463,             /* page_or_ids  */
  YYSYMBOL_data_varying_clause = 1464,     /* data_varying_clause  */
  YYSYMBOL_data_varying_list = 1465,       /* data_varying_list  */
  YYSYMBOL_data_varying = 1466,            /* data_varying  */
  YYSYMBOL__var_from = 1467,               /* _var_from  */
  YYSYMBOL__var_by = 1468,                 /* _var_by  */
  YYSYMBOL_line_clause = 1469,             /* line_clause  */
  YYSYMBOL_line_keyword_clause = 1470,     /* line_keyword_clause  */
  YYSYMBOL__line_clause_options = 1471,    /* _line_clause_options  */
  YYSYMBOL_line_clause_option = 1472,      /* line_clause_option  */
  YYSYMBOL_column_clause = 1473,           /* column_clause  */
  YYSYMBOL_col_keyword_clause = 1474,      /* col_keyword_clause  */
  YYSYMBOL__orientation = 1475,            /* _orientation  */
  YYSYMBOL__left_right_center = 1476,      /* _left_right_center  */
  YYSYMBOL_col_or_plus = 1477,             /* col_or_plus  */
  YYSYMBOL_column_integer_list = 1478,     /* column_integer_list  */
  YYSYMBOL_column_integer = 1479,          /* column_integer  */
  YYSYMBOL_source_clause = 1480,           /* source_clause  */
  YYSYMBOL_group_indicate_clause = 1481,   /* group_indicate_clause  */
  YYSYMBOL__screen_section = 1482,         /* _screen_section  */
  YYSYMBOL_1483_56 = 1483,                 /* $@56  */
  YYSYMBOL_1484_57 = 1484,                 /* $@57  */
  YYSYMBOL__screen_description_list = 1485, /* _screen_description_list  */
  YYSYMBOL_screen_description_list = 1486, /* screen_description_list  */
  YYSYMBOL_screen_description = 1487,      /* screen_description  */
  YYSYMBOL_1488_58 = 1488,                 /* $@58  */
  YYSYMBOL_1489_59 = 1489,                 /* $@59  */
  YYSYMBOL_1490_60 = 1490,                 /* $@60  */
  YYSYMBOL__screen_options = 1491,         /* _screen_options  */
  YYSYMBOL_screen_option = 1492,           /* screen_option  */
  YYSYMBOL_screen_value_clause = 1493,     /* screen_value_clause  */
  YYSYMBOL__value_is = 1494,               /* _value_is  */
  YYSYMBOL_control_definition = 1495,      /* control_definition  */
  YYSYMBOL_control_type_name = 1496,       /* control_type_name  */
  YYSYMBOL_control_type = 1497,            /* control_type  */
  YYSYMBOL_control_item = 1498,            /* control_item  */
  YYSYMBOL__control_attributes = 1499,     /* _control_attributes  */
  YYSYMBOL_control_attributes = 1500,      /* control_attributes  */
  YYSYMBOL_control_attribute = 1501,       /* control_attribute  */
  YYSYMBOL_control_style = 1502,           /* control_style  */
  YYSYMBOL_control_property = 1503,        /* control_property  */
  YYSYMBOL_control_style_name = 1504,      /* control_style_name  */
  YYSYMBOL_control_property_name = 1505,   /* control_property_name  */
  YYSYMBOL_control_style_name_generic = 1506, /* control_style_name_generic  */
  YYSYMBOL_control_property_name_generic = 1507, /* control_property_name_generic  */
  YYSYMBOL_control_style_name_label = 1508, /* control_style_name_label  */
  YYSYMBOL_control_property_name_label = 1509, /* control_property_name_label  */
  YYSYMBOL_control_style_name_entry_field = 1510, /* control_style_name_entry_field  */
  YYSYMBOL_control_property_name_entry_field = 1511, /* control_property_name_entry_field  */
  YYSYMBOL_control_style_name_push_button = 1512, /* control_style_name_push_button  */
  YYSYMBOL_control_property_name_push_button = 1513, /* control_property_name_push_button  */
  YYSYMBOL_control_style_name_check_box = 1514, /* control_style_name_check_box  */
  YYSYMBOL_control_property_name_radio_button = 1515, /* control_property_name_radio_button  */
  YYSYMBOL_control_style_name_list_box = 1516, /* control_style_name_list_box  */
  YYSYMBOL_control_property_name_list_box = 1517, /* control_property_name_list_box  */
  YYSYMBOL_control_style_name_combo_box = 1518, /* control_style_name_combo_box  */
  YYSYMBOL_control_style_name_frame = 1519, /* control_style_name_frame  */
  YYSYMBOL_control_property_name_frame = 1520, /* control_property_name_frame  */
  YYSYMBOL_control_style_name_tab_control = 1521, /* control_style_name_tab_control  */
  YYSYMBOL_control_property_name_tab_control = 1522, /* control_property_name_tab_control  */
  YYSYMBOL_control_style_name_bar = 1523,  /* control_style_name_bar  */
  YYSYMBOL_control_property_name_bar = 1524, /* control_property_name_bar  */
  YYSYMBOL_control_property_name_bitmap = 1525, /* control_property_name_bitmap  */
  YYSYMBOL_control_style_name_grid = 1526, /* control_style_name_grid  */
  YYSYMBOL_control_property_name_grid = 1527, /* control_property_name_grid  */
  YYSYMBOL_control_style_name_tree_view = 1528, /* control_style_name_tree_view  */
  YYSYMBOL_control_property_name_tree_view = 1529, /* control_property_name_tree_view  */
  YYSYMBOL_control_property_name_web_browser = 1530, /* control_property_name_web_browser  */
  YYSYMBOL_control_style_name_activex = 1531, /* control_style_name_activex  */
  YYSYMBOL_control_property_name_activex = 1532, /* control_property_name_activex  */
  YYSYMBOL_control_style_name_date_entry = 1533, /* control_style_name_date_entry  */
  YYSYMBOL_control_property_name_date_entry = 1534, /* control_property_name_date_entry  */
  YYSYMBOL_control_style_type = 1535,      /* control_style_type  */
  YYSYMBOL_control_property_type = 1536,   /* control_property_type  */
  YYSYMBOL_changeable_control_properties = 1537, /* changeable_control_properties  */
  YYSYMBOL_changeable_control_property = 1538, /* changeable_control_property  */
  YYSYMBOL_changeable_window_properties = 1539, /* changeable_window_properties  */
  YYSYMBOL_changeable_window_property = 1540, /* changeable_window_property  */
  YYSYMBOL_eol = 1541,                     /* eol  */
  YYSYMBOL_eos = 1542,                     /* eos  */
  YYSYMBOL__plus = 1543,                   /* _plus  */
  YYSYMBOL_plus = 1544,                    /* plus  */
  YYSYMBOL_plus_tokens = 1545,             /* plus_tokens  */
  YYSYMBOL_minus = 1546,                   /* minus  */
  YYSYMBOL_minus_tokens = 1547,            /* minus_tokens  */
  YYSYMBOL_control_size = 1548,            /* control_size  */
  YYSYMBOL_control_size_unit = 1549,       /* control_size_unit  */
  YYSYMBOL__cell = 1550,                   /* _cell  */
  YYSYMBOL_screen_line_number = 1551,      /* screen_line_number  */
  YYSYMBOL__screen_line_plus_minus = 1552, /* _screen_line_plus_minus  */
  YYSYMBOL_screen_col_number = 1553,       /* screen_col_number  */
  YYSYMBOL__screen_col_plus_minus = 1554,  /* _screen_col_plus_minus  */
  YYSYMBOL_screen_occurs_clause = 1555,    /* screen_occurs_clause  */
  YYSYMBOL_screen_global_clause = 1556,    /* screen_global_clause  */
  YYSYMBOL__prototype_data_division = 1557, /* _prototype_data_division  */
  YYSYMBOL__procedure_division = 1558,     /* _procedure_division  */
  YYSYMBOL_procedure_division = 1559,      /* procedure_division  */
  YYSYMBOL_1560_61 = 1560,                 /* $@61  */
  YYSYMBOL_1561_62 = 1561,                 /* $@62  */
  YYSYMBOL_1562_63 = 1562,                 /* $@63  */
  YYSYMBOL_1563_64 = 1563,                 /* $@64  */
  YYSYMBOL__procedure_using_chaining = 1564, /* _procedure_using_chaining  */
  YYSYMBOL_1565_65 = 1565,                 /* $@65  */
  YYSYMBOL_1566_66 = 1566,                 /* $@66  */
  YYSYMBOL_procedure_param_list = 1567,    /* procedure_param_list  */
  YYSYMBOL_procedure_param = 1568,         /* procedure_param  */
  YYSYMBOL__procedure_type = 1569,         /* _procedure_type  */
  YYSYMBOL__size_optional = 1570,          /* _size_optional  */
  YYSYMBOL_using_size_clause = 1571,       /* using_size_clause  */
  YYSYMBOL_size_is_integer = 1572,         /* size_is_integer  */
  YYSYMBOL__acu_size = 1573,               /* _acu_size  */
  YYSYMBOL__procedure_optional = 1574,     /* _procedure_optional  */
  YYSYMBOL__procedure_returning = 1575,    /* _procedure_returning  */
  YYSYMBOL__procedure_declaratives = 1576, /* _procedure_declaratives  */
  YYSYMBOL_1577_67 = 1577,                 /* $@67  */
  YYSYMBOL_1578_68 = 1578,                 /* $@68  */
  YYSYMBOL_1579_69 = 1579,                 /* $@69  */
  YYSYMBOL__procedure_list = 1580,         /* _procedure_list  */
  YYSYMBOL_procedure = 1581,               /* procedure  */
  YYSYMBOL_1582_70 = 1582,                 /* $@70  */
  YYSYMBOL_proc_name = 1583,               /* proc_name  */
  YYSYMBOL_section_header = 1584,          /* section_header  */
  YYSYMBOL_1585_71 = 1585,                 /* $@71  */
  YYSYMBOL__use_statement = 1586,          /* _use_statement  */
  YYSYMBOL_paragraph_header = 1587,        /* paragraph_header  */
  YYSYMBOL_invalid_statement = 1588,       /* invalid_statement  */
  YYSYMBOL__segment = 1589,                /* _segment  */
  YYSYMBOL_statement_list = 1590,          /* statement_list  */
  YYSYMBOL_1591_72 = 1591,                 /* @72  */
  YYSYMBOL_1592_73 = 1592,                 /* @73  */
  YYSYMBOL_statements = 1593,              /* statements  */
  YYSYMBOL_1594_74 = 1594,                 /* $@74  */
  YYSYMBOL_statement = 1595,               /* statement  */
  YYSYMBOL_1596_75 = 1596,                 /* $@75  */
  YYSYMBOL_accept_statement = 1597,        /* accept_statement  */
  YYSYMBOL_1598_76 = 1598,                 /* $@76  */
  YYSYMBOL_accept_body = 1599,             /* accept_body  */
  YYSYMBOL_1600_77 = 1600,                 /* $@77  */
  YYSYMBOL_1601_78 = 1601,                 /* $@78  */
  YYSYMBOL_accp_identifier = 1602,         /* accp_identifier  */
  YYSYMBOL_field_with_pos_specifier = 1603, /* field_with_pos_specifier  */
  YYSYMBOL_1604_79 = 1604,                 /* $@79  */
  YYSYMBOL__pos_specifier = 1605,          /* _pos_specifier  */
  YYSYMBOL_pos_specifier = 1606,           /* pos_specifier  */
  YYSYMBOL_pos_specifier_value = 1607,     /* pos_specifier_value  */
  YYSYMBOL_identifier_or_numeric_literal = 1608, /* identifier_or_numeric_literal  */
  YYSYMBOL__accept_clauses = 1609,         /* _accept_clauses  */
  YYSYMBOL_accept_clauses = 1610,          /* accept_clauses  */
  YYSYMBOL_accept_clause = 1611,           /* accept_clause  */
  YYSYMBOL_accept_from_screen_clauses = 1612, /* accept_from_screen_clauses  */
  YYSYMBOL_accept_from_screen_clause = 1613, /* accept_from_screen_clause  */
  YYSYMBOL_lines_or_number = 1614,         /* lines_or_number  */
  YYSYMBOL_at_line_column = 1615,          /* at_line_column  */
  YYSYMBOL_1616_80 = 1616,                 /* @80  */
  YYSYMBOL_1617_81 = 1617,                 /* @81  */
  YYSYMBOL_line_number = 1618,             /* line_number  */
  YYSYMBOL_column_number = 1619,           /* column_number  */
  YYSYMBOL_mode_is_block = 1620,           /* mode_is_block  */
  YYSYMBOL_accp_attr = 1621,               /* accp_attr  */
  YYSYMBOL__key_dest = 1622,               /* _key_dest  */
  YYSYMBOL_key_dest = 1623,                /* key_dest  */
  YYSYMBOL_no_echo = 1624,                 /* no_echo  */
  YYSYMBOL_reverse_video = 1625,           /* reverse_video  */
  YYSYMBOL_update_default = 1626,          /* update_default  */
  YYSYMBOL__end_accept = 1627,             /* _end_accept  */
  YYSYMBOL_add_statement = 1628,           /* add_statement  */
  YYSYMBOL_1629_82 = 1629,                 /* $@82  */
  YYSYMBOL_add_body = 1630,                /* add_body  */
  YYSYMBOL__add_to = 1631,                 /* _add_to  */
  YYSYMBOL__end_add = 1632,                /* _end_add  */
  YYSYMBOL_allocate_statement = 1633,      /* allocate_statement  */
  YYSYMBOL_1634_83 = 1634,                 /* $@83  */
  YYSYMBOL_allocate_body = 1635,           /* allocate_body  */
  YYSYMBOL__loc = 1636,                    /* _loc  */
  YYSYMBOL__allocate_returning = 1637,     /* _allocate_returning  */
  YYSYMBOL_alter_statement = 1638,         /* alter_statement  */
  YYSYMBOL_1639_84 = 1639,                 /* $@84  */
  YYSYMBOL_alter_body = 1640,              /* alter_body  */
  YYSYMBOL_alter_entry = 1641,             /* alter_entry  */
  YYSYMBOL__proceed_to = 1642,             /* _proceed_to  */
  YYSYMBOL_call_statement = 1643,          /* call_statement  */
  YYSYMBOL_1644_85 = 1644,                 /* $@85  */
  YYSYMBOL_call_body = 1645,               /* call_body  */
  YYSYMBOL_1646_86 = 1646,                 /* $@86  */
  YYSYMBOL__conv_linkage = 1647,           /* _conv_linkage  */
  YYSYMBOL_1648_87 = 1648,                 /* @87  */
  YYSYMBOL_conv_linkage_option = 1649,     /* conv_linkage_option  */
  YYSYMBOL__mnemonic_conv = 1650,          /* _mnemonic_conv  */
  YYSYMBOL_mnemonic_conv = 1651,           /* mnemonic_conv  */
  YYSYMBOL_program_or_prototype = 1652,    /* program_or_prototype  */
  YYSYMBOL__id_or_lit_or_func_as = 1653,   /* _id_or_lit_or_func_as  */
  YYSYMBOL_nested_or_prototype = 1654,     /* nested_or_prototype  */
  YYSYMBOL_call_using = 1655,              /* call_using  */
  YYSYMBOL_1656_88 = 1656,                 /* $@88  */
  YYSYMBOL_call_param_list = 1657,         /* call_param_list  */
  YYSYMBOL_call_param = 1658,              /* call_param  */
  YYSYMBOL__call_type = 1659,              /* _call_type  */
  YYSYMBOL_call_returning = 1660,          /* call_returning  */
  YYSYMBOL_return_give = 1661,             /* return_give  */
  YYSYMBOL_null_or_omitted = 1662,         /* null_or_omitted  */
  YYSYMBOL_call_exception_phrases = 1663,  /* call_exception_phrases  */
  YYSYMBOL__call_on_exception = 1664,      /* _call_on_exception  */
  YYSYMBOL_call_on_exception = 1665,       /* call_on_exception  */
  YYSYMBOL__call_not_on_exception = 1666,  /* _call_not_on_exception  */
  YYSYMBOL_call_not_on_exception = 1667,   /* call_not_on_exception  */
  YYSYMBOL__end_call = 1668,               /* _end_call  */
  YYSYMBOL_cancel_statement = 1669,        /* cancel_statement  */
  YYSYMBOL_1670_89 = 1670,                 /* $@89  */
  YYSYMBOL_cancel_body = 1671,             /* cancel_body  */
  YYSYMBOL_cancel_list = 1672,             /* cancel_list  */
  YYSYMBOL_id_or_lit_or_program_name = 1673, /* id_or_lit_or_program_name  */
  YYSYMBOL_close_statement = 1674,         /* close_statement  */
  YYSYMBOL_1675_90 = 1675,                 /* $@90  */
  YYSYMBOL_close_body = 1676,              /* close_body  */
  YYSYMBOL_close_files = 1677,             /* close_files  */
  YYSYMBOL__close_option = 1678,           /* _close_option  */
  YYSYMBOL_close_window = 1679,            /* close_window  */
  YYSYMBOL_1680_91 = 1680,                 /* $@91  */
  YYSYMBOL__close_display_option = 1681,   /* _close_display_option  */
  YYSYMBOL_compute_statement = 1682,       /* compute_statement  */
  YYSYMBOL_1683_92 = 1683,                 /* $@92  */
  YYSYMBOL_compute_body = 1684,            /* compute_body  */
  YYSYMBOL__end_compute = 1685,            /* _end_compute  */
  YYSYMBOL_commit_statement = 1686,        /* commit_statement  */
  YYSYMBOL_continue_statement = 1687,      /* continue_statement  */
  YYSYMBOL_1688_93 = 1688,                 /* @93  */
  YYSYMBOL__continue_after_phrase = 1689,  /* _continue_after_phrase  */
  YYSYMBOL_1690_94 = 1690,                 /* $@94  */
  YYSYMBOL_destroy_statement = 1691,       /* destroy_statement  */
  YYSYMBOL_1692_95 = 1692,                 /* $@95  */
  YYSYMBOL_destroy_body = 1693,            /* destroy_body  */
  YYSYMBOL_delete_statement = 1694,        /* delete_statement  */
  YYSYMBOL_1695_96 = 1695,                 /* $@96  */
  YYSYMBOL_delete_body = 1696,             /* delete_body  */
  YYSYMBOL_delete_file_list = 1697,        /* delete_file_list  */
  YYSYMBOL__end_delete = 1698,             /* _end_delete  */
  YYSYMBOL_disable_statement = 1699,       /* disable_statement  */
  YYSYMBOL_1700_97 = 1700,                 /* $@97  */
  YYSYMBOL_enable_disable_handling = 1701, /* enable_disable_handling  */
  YYSYMBOL__enable_disable_key = 1702,     /* _enable_disable_key  */
  YYSYMBOL_communication_mode = 1703,      /* communication_mode  */
  YYSYMBOL_display_statement = 1704,       /* display_statement  */
  YYSYMBOL_1705_98 = 1705,                 /* $@98  */
  YYSYMBOL_display_body = 1706,            /* display_body  */
  YYSYMBOL_screen_or_device_display = 1707, /* screen_or_device_display  */
  YYSYMBOL_display_list = 1708,            /* display_list  */
  YYSYMBOL_display_atom = 1709,            /* display_atom  */
  YYSYMBOL_1710_99 = 1710,                 /* $@99  */
  YYSYMBOL_disp_list = 1711,               /* disp_list  */
  YYSYMBOL__with_display_attr = 1712,      /* _with_display_attr  */
  YYSYMBOL_display_attrs = 1713,           /* display_attrs  */
  YYSYMBOL_display_clauses = 1714,         /* display_clauses  */
  YYSYMBOL_display_clause = 1715,          /* display_clause  */
  YYSYMBOL__display_upon = 1716,           /* _display_upon  */
  YYSYMBOL_display_upon = 1717,            /* display_upon  */
  YYSYMBOL_crt_under = 1718,               /* crt_under  */
  YYSYMBOL_display_erase = 1719,           /* display_erase  */
  YYSYMBOL_1720_100 = 1720,                /* $@100  */
  YYSYMBOL_display_pos_specifier = 1721,   /* display_pos_specifier  */
  YYSYMBOL_field_or_literal_or_erase_with_pos_specifier = 1722, /* field_or_literal_or_erase_with_pos_specifier  */
  YYSYMBOL_1723_101 = 1723,                /* $@101  */
  YYSYMBOL_field_or_literal_or_erase_list = 1724, /* field_or_literal_or_erase_list  */
  YYSYMBOL_field_or_literal_or_erase = 1725, /* field_or_literal_or_erase  */
  YYSYMBOL_display_message_box = 1726,     /* display_message_box  */
  YYSYMBOL_1727_102 = 1727,                /* $@102  */
  YYSYMBOL__display_message_clauses = 1728, /* _display_message_clauses  */
  YYSYMBOL_display_message_clauses = 1729, /* display_message_clauses  */
  YYSYMBOL_display_message_clause = 1730,  /* display_message_clause  */
  YYSYMBOL_display_window = 1731,          /* display_window  */
  YYSYMBOL_1732_103 = 1732,                /* $@103  */
  YYSYMBOL_1733_104 = 1733,                /* $@104  */
  YYSYMBOL_sub_or_window = 1734,           /* sub_or_window  */
  YYSYMBOL_display_floating_window = 1735, /* display_floating_window  */
  YYSYMBOL_1736_105 = 1736,                /* $@105  */
  YYSYMBOL_1737_106 = 1737,                /* $@106  */
  YYSYMBOL_display_initial_window = 1738,  /* display_initial_window  */
  YYSYMBOL_1739_107 = 1739,                /* $@107  */
  YYSYMBOL_initial_type = 1740,            /* initial_type  */
  YYSYMBOL__graphical = 1741,              /* _graphical  */
  YYSYMBOL__upon_window_handle = 1742,     /* _upon_window_handle  */
  YYSYMBOL_window_handle = 1743,           /* window_handle  */
  YYSYMBOL_display_window_clauses = 1744,  /* display_window_clauses  */
  YYSYMBOL_display_window_clause = 1745,   /* display_window_clause  */
  YYSYMBOL_shadow = 1746,                  /* shadow  */
  YYSYMBOL_boxed = 1747,                   /* boxed  */
  YYSYMBOL__top_or_bottom = 1748,          /* _top_or_bottom  */
  YYSYMBOL__left_or_centered_or_right = 1749, /* _left_or_centered_or_right  */
  YYSYMBOL_no_scroll_wrap = 1750,          /* no_scroll_wrap  */
  YYSYMBOL_pop_up_or_handle = 1751,        /* pop_up_or_handle  */
  YYSYMBOL_pop_up_area = 1752,             /* pop_up_area  */
  YYSYMBOL_handle_is_in = 1753,            /* handle_is_in  */
  YYSYMBOL_disp_attr = 1754,               /* disp_attr  */
  YYSYMBOL_control_source = 1755,          /* control_source  */
  YYSYMBOL__end_display = 1756,            /* _end_display  */
  YYSYMBOL_divide_statement = 1757,        /* divide_statement  */
  YYSYMBOL_1758_108 = 1758,                /* $@108  */
  YYSYMBOL_divide_body = 1759,             /* divide_body  */
  YYSYMBOL__end_divide = 1760,             /* _end_divide  */
  YYSYMBOL_enable_statement = 1761,        /* enable_statement  */
  YYSYMBOL_1762_109 = 1762,                /* $@109  */
  YYSYMBOL_entry = 1763,                   /* entry  */
  YYSYMBOL_entry_statement = 1764,         /* entry_statement  */
  YYSYMBOL_1765_110 = 1765,                /* $@110  */
  YYSYMBOL_1766_111 = 1766,                /* $@111  */
  YYSYMBOL_entry_body = 1767,              /* entry_body  */
  YYSYMBOL_evaluate_statement = 1768,      /* evaluate_statement  */
  YYSYMBOL_1769_112 = 1769,                /* $@112  */
  YYSYMBOL_evaluate_body = 1770,           /* evaluate_body  */
  YYSYMBOL_evaluate_subject_list = 1771,   /* evaluate_subject_list  */
  YYSYMBOL_evaluate_subject = 1772,        /* evaluate_subject  */
  YYSYMBOL_evaluate_condition_list = 1773, /* evaluate_condition_list  */
  YYSYMBOL_evaluate_case_list = 1774,      /* evaluate_case_list  */
  YYSYMBOL_end_evaluate = 1775,            /* end_evaluate  */
  YYSYMBOL_evaluate_case = 1776,           /* evaluate_case  */
  YYSYMBOL_when_other = 1777,              /* when_other  */
  YYSYMBOL_evaluate_other = 1778,          /* evaluate_other  */
  YYSYMBOL_when = 1779,                    /* when  */
  YYSYMBOL_evaluate_when_list = 1780,      /* evaluate_when_list  */
  YYSYMBOL_evaluate_object_list = 1781,    /* evaluate_object_list  */
  YYSYMBOL_evaluate_object = 1782,         /* evaluate_object  */
  YYSYMBOL__evaluate_thru_expr = 1783,     /* _evaluate_thru_expr  */
  YYSYMBOL__end_evaluate = 1784,           /* _end_evaluate  */
  YYSYMBOL_exhibit_statement = 1785,       /* exhibit_statement  */
  YYSYMBOL_1786_113 = 1786,                /* $@113  */
  YYSYMBOL_exhibit_body = 1787,            /* exhibit_body  */
  YYSYMBOL_1788_114 = 1788,                /* $@114  */
  YYSYMBOL__changed = 1789,                /* _changed  */
  YYSYMBOL__named = 1790,                  /* _named  */
  YYSYMBOL__erase = 1791,                  /* _erase  */
  YYSYMBOL_exhibit_target_list = 1792,     /* exhibit_target_list  */
  YYSYMBOL_exhibit_target = 1793,          /* exhibit_target  */
  YYSYMBOL_exit_statement = 1794,          /* exit_statement  */
  YYSYMBOL_1795_115 = 1795,                /* $@115  */
  YYSYMBOL_exit_body = 1796,               /* exit_body  */
  YYSYMBOL_goback_exit_body = 1797,        /* goback_exit_body  */
  YYSYMBOL_free_statement = 1798,          /* free_statement  */
  YYSYMBOL_1799_116 = 1799,                /* $@116  */
  YYSYMBOL_free_body = 1800,               /* free_body  */
  YYSYMBOL_generate_statement = 1801,      /* generate_statement  */
  YYSYMBOL_1802_117 = 1802,                /* $@117  */
  YYSYMBOL_generate_body = 1803,           /* generate_body  */
  YYSYMBOL_goto_statement = 1804,          /* goto_statement  */
  YYSYMBOL_1805_118 = 1805,                /* $@118  */
  YYSYMBOL_go_body = 1806,                 /* go_body  */
  YYSYMBOL__goto_depending = 1807,         /* _goto_depending  */
  YYSYMBOL_goback_statement = 1808,        /* goback_statement  */
  YYSYMBOL_1809_119 = 1809,                /* $@119  */
  YYSYMBOL_if_statement = 1810,            /* if_statement  */
  YYSYMBOL_1811_120 = 1811,                /* $@120  */
  YYSYMBOL_else = 1812,                    /* else  */
  YYSYMBOL_if_else_statements = 1813,      /* if_else_statements  */
  YYSYMBOL__if_then = 1814,                /* _if_then  */
  YYSYMBOL_if_true = 1815,                 /* if_true  */
  YYSYMBOL_if_false = 1816,                /* if_false  */
  YYSYMBOL__end_if = 1817,                 /* _end_if  */
  YYSYMBOL_initialize_statement = 1818,    /* initialize_statement  */
  YYSYMBOL_1819_121 = 1819,                /* $@121  */
  YYSYMBOL_initialize_body = 1820,         /* initialize_body  */
  YYSYMBOL__initialize_filler = 1821,      /* _initialize_filler  */
  YYSYMBOL__initialize_value = 1822,       /* _initialize_value  */
  YYSYMBOL__initialize_replacing = 1823,   /* _initialize_replacing  */
  YYSYMBOL_initialize_replacing_list = 1824, /* initialize_replacing_list  */
  YYSYMBOL_initialize_replacing_item = 1825, /* initialize_replacing_item  */
  YYSYMBOL_initialize_category = 1826,     /* initialize_category  */
  YYSYMBOL__initialize_default = 1827,     /* _initialize_default  */
  YYSYMBOL_initiate_statement = 1828,      /* initiate_statement  */
  YYSYMBOL_1829_122 = 1829,                /* $@122  */
  YYSYMBOL_initiate_body = 1830,           /* initiate_body  */
  YYSYMBOL_inquire_statement = 1831,       /* inquire_statement  */
  YYSYMBOL_1832_123 = 1832,                /* $@123  */
  YYSYMBOL_inquire_body = 1833,            /* inquire_body  */
  YYSYMBOL_inspect_statement = 1834,       /* inspect_statement  */
  YYSYMBOL_1835_124 = 1835,                /* $@124  */
  YYSYMBOL_inspect_body = 1836,            /* inspect_body  */
  YYSYMBOL__backward = 1837,               /* _backward  */
  YYSYMBOL_send_identifier = 1838,         /* send_identifier  */
  YYSYMBOL_inspect_format_variant = 1839,  /* inspect_format_variant  */
  YYSYMBOL_examine_statement = 1840,       /* examine_statement  */
  YYSYMBOL_1841_125 = 1841,                /* $@125  */
  YYSYMBOL_examine_format_variant = 1842,  /* examine_format_variant  */
  YYSYMBOL_1843_126 = 1843,                /* $@126  */
  YYSYMBOL_examine_tallying_keyword = 1844, /* examine_tallying_keyword  */
  YYSYMBOL_examine_replacing_keyword = 1845, /* examine_replacing_keyword  */
  YYSYMBOL__examine_tallying_replacing = 1846, /* _examine_tallying_replacing  */
  YYSYMBOL_single_character_value = 1847,  /* single_character_value  */
  YYSYMBOL_inspect_tallying = 1848,        /* inspect_tallying  */
  YYSYMBOL_1849_127 = 1849,                /* $@127  */
  YYSYMBOL_inspect_replacing = 1850,       /* inspect_replacing  */
  YYSYMBOL_inspect_converting = 1851,      /* inspect_converting  */
  YYSYMBOL_tallying_list = 1852,           /* tallying_list  */
  YYSYMBOL_tallying_item = 1853,           /* tallying_item  */
  YYSYMBOL_replacing_list = 1854,          /* replacing_list  */
  YYSYMBOL_replacing_item = 1855,          /* replacing_item  */
  YYSYMBOL_rep_keyword = 1856,             /* rep_keyword  */
  YYSYMBOL_replacing_region = 1857,        /* replacing_region  */
  YYSYMBOL_inspect_region = 1858,          /* inspect_region  */
  YYSYMBOL_inspect_before = 1859,          /* inspect_before  */
  YYSYMBOL_inspect_after = 1860,           /* inspect_after  */
  YYSYMBOL_json = 1861,                    /* json  */
  YYSYMBOL_json_generate_statement = 1862, /* json_generate_statement  */
  YYSYMBOL_1863_128 = 1863,                /* $@128  */
  YYSYMBOL_json_generate_body = 1864,      /* json_generate_body  */
  YYSYMBOL_1865_129 = 1865,                /* $@129  */
  YYSYMBOL_1866_130 = 1866,                /* $@130  */
  YYSYMBOL__json_suppress = 1867,          /* _json_suppress  */
  YYSYMBOL_json_suppress_list = 1868,      /* json_suppress_list  */
  YYSYMBOL_json_suppress_entry = 1869,     /* json_suppress_entry  */
  YYSYMBOL__end_json = 1870,               /* _end_json  */
  YYSYMBOL_json_parse_statement = 1871,    /* json_parse_statement  */
  YYSYMBOL_1872_131 = 1872,                /* $@131  */
  YYSYMBOL_json_parse_body = 1873,         /* json_parse_body  */
  YYSYMBOL__with_detail = 1874,            /* _with_detail  */
  YYSYMBOL_merge_statement = 1875,         /* merge_statement  */
  YYSYMBOL_1876_132 = 1876,                /* $@132  */
  YYSYMBOL_modify_statement = 1877,        /* modify_statement  */
  YYSYMBOL_1878_133 = 1878,                /* $@133  */
  YYSYMBOL_modify_body = 1879,             /* modify_body  */
  YYSYMBOL__end_modify = 1880,             /* _end_modify  */
  YYSYMBOL_move_statement = 1881,          /* move_statement  */
  YYSYMBOL_1882_134 = 1882,                /* $@134  */
  YYSYMBOL_move_body = 1883,               /* move_body  */
  YYSYMBOL_multiply_statement = 1884,      /* multiply_statement  */
  YYSYMBOL_1885_135 = 1885,                /* $@135  */
  YYSYMBOL_multiply_body = 1886,           /* multiply_body  */
  YYSYMBOL__end_multiply = 1887,           /* _end_multiply  */
  YYSYMBOL_open_statement = 1888,          /* open_statement  */
  YYSYMBOL_1889_136 = 1889,                /* $@136  */
  YYSYMBOL_open_body = 1890,               /* open_body  */
  YYSYMBOL_open_file_entry = 1891,         /* open_file_entry  */
  YYSYMBOL__open_exclusive = 1892,         /* _open_exclusive  */
  YYSYMBOL_open_mode = 1893,               /* open_mode  */
  YYSYMBOL__open_sharing = 1894,           /* _open_sharing  */
  YYSYMBOL__open_option = 1895,            /* _open_option  */
  YYSYMBOL_lock_allowing = 1896,           /* lock_allowing  */
  YYSYMBOL_open_lock_option = 1897,        /* open_lock_option  */
  YYSYMBOL_allowing_option = 1898,         /* allowing_option  */
  YYSYMBOL_allowing_all = 1899,            /* allowing_all  */
  YYSYMBOL_open_option_sequential = 1900,  /* open_option_sequential  */
  YYSYMBOL_osvs_input_mode = 1901,         /* osvs_input_mode  */
  YYSYMBOL_perform_statement = 1902,       /* perform_statement  */
  YYSYMBOL_1903_137 = 1903,                /* $@137  */
  YYSYMBOL_perform_body = 1904,            /* perform_body  */
  YYSYMBOL_1905_138 = 1905,                /* $@138  */
  YYSYMBOL_1906_139 = 1906,                /* $@139  */
  YYSYMBOL__end_perform = 1907,            /* _end_perform  */
  YYSYMBOL_end_perform_or_dot = 1908,      /* end_perform_or_dot  */
  YYSYMBOL_perform_procedure = 1909,       /* perform_procedure  */
  YYSYMBOL__perform_option = 1910,         /* _perform_option  */
  YYSYMBOL_perform_test = 1911,            /* perform_test  */
  YYSYMBOL_cond_or_exit = 1912,            /* cond_or_exit  */
  YYSYMBOL_perform_varying_list = 1913,    /* perform_varying_list  */
  YYSYMBOL_perform_varying = 1914,         /* perform_varying  */
  YYSYMBOL__by_phrase = 1915,              /* _by_phrase  */
  YYSYMBOL_purge_statement = 1916,         /* purge_statement  */
  YYSYMBOL_1917_140 = 1917,                /* $@140  */
  YYSYMBOL_raise_statement = 1918,         /* raise_statement  */
  YYSYMBOL_1919_141 = 1919,                /* $@141  */
  YYSYMBOL_raise_body = 1920,              /* raise_body  */
  YYSYMBOL_exception_name = 1921,          /* exception_name  */
  YYSYMBOL_read_statement = 1922,          /* read_statement  */
  YYSYMBOL_1923_142 = 1923,                /* $@142  */
  YYSYMBOL_read_body = 1924,               /* read_body  */
  YYSYMBOL__read_into = 1925,              /* _read_into  */
  YYSYMBOL__lock_phrases = 1926,           /* _lock_phrases  */
  YYSYMBOL_ignoring_lock = 1927,           /* ignoring_lock  */
  YYSYMBOL_advancing_lock_or_retry = 1928, /* advancing_lock_or_retry  */
  YYSYMBOL__retry_phrase = 1929,           /* _retry_phrase  */
  YYSYMBOL_retry_phrase = 1930,            /* retry_phrase  */
  YYSYMBOL_retry_options = 1931,           /* retry_options  */
  YYSYMBOL__extended_with_lock = 1932,     /* _extended_with_lock  */
  YYSYMBOL_extended_with_lock = 1933,      /* extended_with_lock  */
  YYSYMBOL__read_key = 1934,               /* _read_key  */
  YYSYMBOL_read_handler = 1935,            /* read_handler  */
  YYSYMBOL__end_read = 1936,               /* _end_read  */
  YYSYMBOL_ready_statement = 1937,         /* ready_statement  */
  YYSYMBOL_receive_statement = 1938,       /* receive_statement  */
  YYSYMBOL_1939_143 = 1939,                /* $@143  */
  YYSYMBOL_receive_body = 1940,            /* receive_body  */
  YYSYMBOL_message_or_segment = 1941,      /* message_or_segment  */
  YYSYMBOL__data_sentence_phrases = 1942,  /* _data_sentence_phrases  */
  YYSYMBOL__no_data_sentence = 1943,       /* _no_data_sentence  */
  YYSYMBOL_no_data_sentence = 1944,        /* no_data_sentence  */
  YYSYMBOL__with_data_sentence = 1945,     /* _with_data_sentence  */
  YYSYMBOL_with_data_sentence = 1946,      /* with_data_sentence  */
  YYSYMBOL__end_receive = 1947,            /* _end_receive  */
  YYSYMBOL_release_statement = 1948,       /* release_statement  */
  YYSYMBOL_1949_144 = 1949,                /* $@144  */
  YYSYMBOL_release_body = 1950,            /* release_body  */
  YYSYMBOL_reset_statement = 1951,         /* reset_statement  */
  YYSYMBOL_return_statement = 1952,        /* return_statement  */
  YYSYMBOL_1953_145 = 1953,                /* $@145  */
  YYSYMBOL_return_body = 1954,             /* return_body  */
  YYSYMBOL__end_return = 1955,             /* _end_return  */
  YYSYMBOL_rewrite_statement = 1956,       /* rewrite_statement  */
  YYSYMBOL_1957_146 = 1957,                /* $@146  */
  YYSYMBOL_rewrite_body = 1958,            /* rewrite_body  */
  YYSYMBOL__with_lock = 1959,              /* _with_lock  */
  YYSYMBOL_with_lock = 1960,               /* with_lock  */
  YYSYMBOL__end_rewrite = 1961,            /* _end_rewrite  */
  YYSYMBOL_rollback_statement = 1962,      /* rollback_statement  */
  YYSYMBOL_search = 1963,                  /* search  */
  YYSYMBOL_search_statement = 1964,        /* search_statement  */
  YYSYMBOL_1965_147 = 1965,                /* $@147  */
  YYSYMBOL_1966_148 = 1966,                /* $@148  */
  YYSYMBOL_search_body = 1967,             /* search_body  */
  YYSYMBOL_search_all_body = 1968,         /* search_all_body  */
  YYSYMBOL__search_varying = 1969,         /* _search_varying  */
  YYSYMBOL__search_at_end = 1970,          /* _search_at_end  */
  YYSYMBOL_end_pos_token = 1971,           /* end_pos_token  */
  YYSYMBOL_search_whens = 1972,            /* search_whens  */
  YYSYMBOL_search_when = 1973,             /* search_when  */
  YYSYMBOL__end_search = 1974,             /* _end_search  */
  YYSYMBOL_end_search_pos_token = 1975,    /* end_search_pos_token  */
  YYSYMBOL_send_statement = 1976,          /* send_statement  */
  YYSYMBOL_1977_149 = 1977,                /* $@149  */
  YYSYMBOL_send_body = 1978,               /* send_body  */
  YYSYMBOL_send_body_mcs = 1979,           /* send_body_mcs  */
  YYSYMBOL_message_tag_data_item = 1980,   /* message_tag_data_item  */
  YYSYMBOL__from_identifier = 1981,        /* _from_identifier  */
  YYSYMBOL_from_identifier = 1982,         /* from_identifier  */
  YYSYMBOL_send_body_cd = 1983,            /* send_body_cd  */
  YYSYMBOL_with_indicator = 1984,          /* with_indicator  */
  YYSYMBOL__replacing_line = 1985,         /* _replacing_line  */
  YYSYMBOL_set_statement = 1986,           /* set_statement  */
  YYSYMBOL_1987_150 = 1987,                /* $@150  */
  YYSYMBOL_set_body = 1988,                /* set_body  */
  YYSYMBOL_on_or_off = 1989,               /* on_or_off  */
  YYSYMBOL_up_or_down = 1990,              /* up_or_down  */
  YYSYMBOL_set_environment = 1991,         /* set_environment  */
  YYSYMBOL_set_attr = 1992,                /* set_attr  */
  YYSYMBOL_set_attr_clause = 1993,         /* set_attr_clause  */
  YYSYMBOL_set_attr_one = 1994,            /* set_attr_one  */
  YYSYMBOL_set_to = 1995,                  /* set_to  */
  YYSYMBOL_set_up_down = 1996,             /* set_up_down  */
  YYSYMBOL_set_to_on_off_sequence = 1997,  /* set_to_on_off_sequence  */
  YYSYMBOL_set_to_on_off = 1998,           /* set_to_on_off  */
  YYSYMBOL_set_to_true_false_sequence = 1999, /* set_to_true_false_sequence  */
  YYSYMBOL_set_to_true_false = 2000,       /* set_to_true_false  */
  YYSYMBOL_set_last_exception_to_off = 2001, /* set_last_exception_to_off  */
  YYSYMBOL_set_thread_priority = 2002,     /* set_thread_priority  */
  YYSYMBOL_sort_statement = 2003,          /* sort_statement  */
  YYSYMBOL_2004_151 = 2004,                /* $@151  */
  YYSYMBOL_sort_merge_body = 2005,         /* sort_merge_body  */
  YYSYMBOL_2006_152 = 2006,                /* @152  */
  YYSYMBOL__sort_key_list = 2007,          /* _sort_key_list  */
  YYSYMBOL__key_sort_list = 2008,          /* _key_sort_list  */
  YYSYMBOL__sort_duplicates = 2009,        /* _sort_duplicates  */
  YYSYMBOL__sort_collating = 2010,         /* _sort_collating  */
  YYSYMBOL_sort_input = 2011,              /* sort_input  */
  YYSYMBOL_sort_output = 2012,             /* sort_output  */
  YYSYMBOL_start_statement = 2013,         /* start_statement  */
  YYSYMBOL_2014_153 = 2014,                /* $@153  */
  YYSYMBOL_start_body = 2015,              /* start_body  */
  YYSYMBOL__sizelen_clause = 2016,         /* _sizelen_clause  */
  YYSYMBOL__start_key = 2017,              /* _start_key  */
  YYSYMBOL_start_op = 2018,                /* start_op  */
  YYSYMBOL_not_equal_op = 2019,            /* not_equal_op  */
  YYSYMBOL__end_start = 2020,              /* _end_start  */
  YYSYMBOL_stop = 2021,                    /* stop  */
  YYSYMBOL_stop_statement = 2022,          /* stop_statement  */
  YYSYMBOL_2023_154 = 2023,                /* $@154  */
  YYSYMBOL_stop_returning = 2024,          /* stop_returning  */
  YYSYMBOL__status_x = 2025,               /* _status_x  */
  YYSYMBOL_stop_argument = 2026,           /* stop_argument  */
  YYSYMBOL_stop_literal = 2027,            /* stop_literal  */
  YYSYMBOL_string_statement = 2028,        /* string_statement  */
  YYSYMBOL_2029_155 = 2029,                /* $@155  */
  YYSYMBOL_string_body = 2030,             /* string_body  */
  YYSYMBOL_string_items = 2031,            /* string_items  */
  YYSYMBOL_2032_156 = 2032,                /* $@156  */
  YYSYMBOL_string_item_list = 2033,        /* string_item_list  */
  YYSYMBOL_string_item = 2034,             /* string_item  */
  YYSYMBOL__string_delimited = 2035,       /* _string_delimited  */
  YYSYMBOL_string_delimiter = 2036,        /* string_delimiter  */
  YYSYMBOL__with_pointer = 2037,           /* _with_pointer  */
  YYSYMBOL__end_string = 2038,             /* _end_string  */
  YYSYMBOL_subtract_statement = 2039,      /* subtract_statement  */
  YYSYMBOL_2040_157 = 2040,                /* $@157  */
  YYSYMBOL_subtract_body = 2041,           /* subtract_body  */
  YYSYMBOL__end_subtract = 2042,           /* _end_subtract  */
  YYSYMBOL_suppress_statement = 2043,      /* suppress_statement  */
  YYSYMBOL_2044_158 = 2044,                /* $@158  */
  YYSYMBOL__printing = 2045,               /* _printing  */
  YYSYMBOL_terminate_statement = 2046,     /* terminate_statement  */
  YYSYMBOL_2047_159 = 2047,                /* $@159  */
  YYSYMBOL_terminate_body = 2048,          /* terminate_body  */
  YYSYMBOL_transform_statement = 2049,     /* transform_statement  */
  YYSYMBOL_2050_160 = 2050,                /* $@160  */
  YYSYMBOL_transform_body = 2051,          /* transform_body  */
  YYSYMBOL_unlock_statement = 2052,        /* unlock_statement  */
  YYSYMBOL_2053_161 = 2053,                /* $@161  */
  YYSYMBOL_unlock_body = 2054,             /* unlock_body  */
  YYSYMBOL_unstring_statement = 2055,      /* unstring_statement  */
  YYSYMBOL_2056_162 = 2056,                /* $@162  */
  YYSYMBOL_unstring_body = 2057,           /* unstring_body  */
  YYSYMBOL__unstring_delimited = 2058,     /* _unstring_delimited  */
  YYSYMBOL_unstring_delimited_list = 2059, /* unstring_delimited_list  */
  YYSYMBOL_unstring_delimited_item = 2060, /* unstring_delimited_item  */
  YYSYMBOL_unstring_into = 2061,           /* unstring_into  */
  YYSYMBOL_unstring_into_item = 2062,      /* unstring_into_item  */
  YYSYMBOL__unstring_into_delimiter = 2063, /* _unstring_into_delimiter  */
  YYSYMBOL__unstring_tallying = 2064,      /* _unstring_tallying  */
  YYSYMBOL__end_unstring = 2065,           /* _end_unstring  */
  YYSYMBOL_validate_statement = 2066,      /* validate_statement  */
  YYSYMBOL_2067_163 = 2067,                /* $@163  */
  YYSYMBOL_validate_fields = 2068,         /* validate_fields  */
  YYSYMBOL_use_statement = 2069,           /* use_statement  */
  YYSYMBOL_2070_164 = 2070,                /* $@164  */
  YYSYMBOL_use_phrase = 2071,              /* use_phrase  */
  YYSYMBOL_use_file_exception = 2072,      /* use_file_exception  */
  YYSYMBOL__use_global = 2073,             /* _use_global  */
  YYSYMBOL_use_file_exception_target = 2074, /* use_file_exception_target  */
  YYSYMBOL_use_for_debugging = 2075,       /* use_for_debugging  */
  YYSYMBOL_debugging_list = 2076,          /* debugging_list  */
  YYSYMBOL_debugging_target = 2077,        /* debugging_target  */
  YYSYMBOL__all_refs = 2078,               /* _all_refs  */
  YYSYMBOL_use_at_start_end = 2079,        /* use_at_start_end  */
  YYSYMBOL_program_start_end = 2080,       /* program_start_end  */
  YYSYMBOL_use_before_reporting = 2081,    /* use_before_reporting  */
  YYSYMBOL_use_after_exception = 2082,     /* use_after_exception  */
  YYSYMBOL_use_exception_list = 2083,      /* use_exception_list  */
  YYSYMBOL_use_exception = 2084,           /* use_exception  */
  YYSYMBOL_use_ex_keyw = 2085,             /* use_ex_keyw  */
  YYSYMBOL_write_statement = 2086,         /* write_statement  */
  YYSYMBOL_2087_165 = 2087,                /* $@165  */
  YYSYMBOL_write_body = 2088,              /* write_body  */
  YYSYMBOL_from_option = 2089,             /* from_option  */
  YYSYMBOL_write_option = 2090,            /* write_option  */
  YYSYMBOL_before_or_after = 2091,         /* before_or_after  */
  YYSYMBOL_write_handler = 2092,           /* write_handler  */
  YYSYMBOL__end_write = 2093,              /* _end_write  */
  YYSYMBOL_xml = 2094,                     /* xml  */
  YYSYMBOL_xml_generate_statement = 2095,  /* xml_generate_statement  */
  YYSYMBOL_2096_166 = 2096,                /* $@166  */
  YYSYMBOL_xml_generate_body = 2097,       /* xml_generate_body  */
  YYSYMBOL_2098_167 = 2098,                /* $@167  */
  YYSYMBOL_2099_168 = 2099,                /* $@168  */
  YYSYMBOL__with_encoding_xml_dec_and_attrs = 2100, /* _with_encoding_xml_dec_and_attrs  */
  YYSYMBOL_with_encoding_xml_dec_and_attrs = 2101, /* with_encoding_xml_dec_and_attrs  */
  YYSYMBOL_with_encoding_xml_dec_and_attr = 2102, /* with_encoding_xml_dec_and_attr  */
  YYSYMBOL_encoding_xml_dec_and_attr = 2103, /* encoding_xml_dec_and_attr  */
  YYSYMBOL__xml_gen_namespace = 2104,      /* _xml_gen_namespace  */
  YYSYMBOL__xml_gen_namespace_prefix = 2105, /* _xml_gen_namespace_prefix  */
  YYSYMBOL__xml_name_of = 2106,            /* _xml_name_of  */
  YYSYMBOL_identifier_name_list = 2107,    /* identifier_name_list  */
  YYSYMBOL_identifier_is_name = 2108,      /* identifier_is_name  */
  YYSYMBOL__json_name_of = 2109,           /* _json_name_of  */
  YYSYMBOL_json_identifier_name_list = 2110, /* json_identifier_name_list  */
  YYSYMBOL_json_identifier_is_name = 2111, /* json_identifier_is_name  */
  YYSYMBOL__type_of = 2112,                /* _type_of  */
  YYSYMBOL_identifier_type_list = 2113,    /* identifier_type_list  */
  YYSYMBOL_identifier_is_type = 2114,      /* identifier_is_type  */
  YYSYMBOL__xml_type = 2115,               /* _xml_type  */
  YYSYMBOL_ml_type = 2116,                 /* ml_type  */
  YYSYMBOL__xml_gen_suppress = 2117,       /* _xml_gen_suppress  */
  YYSYMBOL_xml_suppress_list = 2118,       /* xml_suppress_list  */
  YYSYMBOL_xml_suppress_entry = 2119,      /* xml_suppress_entry  */
  YYSYMBOL_xml_suppress_generic_opt = 2120, /* xml_suppress_generic_opt  */
  YYSYMBOL_xml_suppress_when_list = 2121,  /* xml_suppress_when_list  */
  YYSYMBOL__end_xml = 2122,                /* _end_xml  */
  YYSYMBOL_xml_parse_statement = 2123,     /* xml_parse_statement  */
  YYSYMBOL_2124_169 = 2124,                /* $@169  */
  YYSYMBOL_xml_parse_body = 2125,          /* xml_parse_body  */
  YYSYMBOL_2126_170 = 2126,                /* $@170  */
  YYSYMBOL__with_encoding = 2127,          /* _with_encoding  */
  YYSYMBOL__returning_national = 2128,     /* _returning_national  */
  YYSYMBOL__validating_with = 2129,        /* _validating_with  */
  YYSYMBOL_schema_file_or_record_name = 2130, /* schema_file_or_record_name  */
  YYSYMBOL__accept_exception_phrases = 2131, /* _accept_exception_phrases  */
  YYSYMBOL__accp_on_exception = 2132,      /* _accp_on_exception  */
  YYSYMBOL_accp_on_exception = 2133,       /* accp_on_exception  */
  YYSYMBOL_escape_or_exception = 2134,     /* escape_or_exception  */
  YYSYMBOL__accp_not_on_exception = 2135,  /* _accp_not_on_exception  */
  YYSYMBOL_accp_not_on_exception = 2136,   /* accp_not_on_exception  */
  YYSYMBOL_not_escape_or_not_exception = 2137, /* not_escape_or_not_exception  */
  YYSYMBOL__common_exception_phrases = 2138, /* _common_exception_phrases  */
  YYSYMBOL__common_on_exception = 2139,    /* _common_on_exception  */
  YYSYMBOL_common_on_exception = 2140,     /* common_on_exception  */
  YYSYMBOL__common_not_on_exception = 2141, /* _common_not_on_exception  */
  YYSYMBOL_common_not_on_exception = 2142, /* common_not_on_exception  */
  YYSYMBOL_on_size_error_phrases = 2143,   /* on_size_error_phrases  */
  YYSYMBOL__on_size_error = 2144,          /* _on_size_error  */
  YYSYMBOL_on_size_error = 2145,           /* on_size_error  */
  YYSYMBOL__not_on_size_error = 2146,      /* _not_on_size_error  */
  YYSYMBOL_not_on_size_error = 2147,       /* not_on_size_error  */
  YYSYMBOL__on_overflow_phrases = 2148,    /* _on_overflow_phrases  */
  YYSYMBOL__on_overflow = 2149,            /* _on_overflow  */
  YYSYMBOL_on_overflow = 2150,             /* on_overflow  */
  YYSYMBOL__not_on_overflow = 2151,        /* _not_on_overflow  */
  YYSYMBOL_not_on_overflow = 2152,         /* not_on_overflow  */
  YYSYMBOL_return_at_end = 2153,           /* return_at_end  */
  YYSYMBOL_read_at_end = 2154,             /* read_at_end  */
  YYSYMBOL__at_end_clause = 2155,          /* _at_end_clause  */
  YYSYMBOL_at_end_clause = 2156,           /* at_end_clause  */
  YYSYMBOL__not_at_end_clause = 2157,      /* _not_at_end_clause  */
  YYSYMBOL_not_at_end_clause = 2158,       /* not_at_end_clause  */
  YYSYMBOL_at_eop_clauses = 2159,          /* at_eop_clauses  */
  YYSYMBOL__at_eop_clause = 2160,          /* _at_eop_clause  */
  YYSYMBOL_at_eop_clause = 2161,           /* at_eop_clause  */
  YYSYMBOL__not_at_eop_clause = 2162,      /* _not_at_eop_clause  */
  YYSYMBOL_not_at_eop_clause = 2163,       /* not_at_eop_clause  */
  YYSYMBOL__invalid_key_phrases = 2164,    /* _invalid_key_phrases  */
  YYSYMBOL_invalid_key_phrases = 2165,     /* invalid_key_phrases  */
  YYSYMBOL__invalid_key_sentence = 2166,   /* _invalid_key_sentence  */
  YYSYMBOL_invalid_key_sentence = 2167,    /* invalid_key_sentence  */
  YYSYMBOL__not_invalid_key_sentence = 2168, /* _not_invalid_key_sentence  */
  YYSYMBOL_not_invalid_key_sentence = 2169, /* not_invalid_key_sentence  */
  YYSYMBOL__thread_start = 2170,           /* _thread_start  */
  YYSYMBOL__thread_handle = 2171,          /* _thread_handle  */
  YYSYMBOL_thread_reference_optional = 2172, /* thread_reference_optional  */
  YYSYMBOL__scroll_lines = 2173,           /* _scroll_lines  */
  YYSYMBOL__count_in = 2174,               /* _count_in  */
  YYSYMBOL_condition = 2175,               /* condition  */
  YYSYMBOL_expr = 2176,                    /* expr  */
  YYSYMBOL_partial_expr = 2177,            /* partial_expr  */
  YYSYMBOL_2178_171 = 2178,                /* $@171  */
  YYSYMBOL_expr_tokens = 2179,             /* expr_tokens  */
  YYSYMBOL_expr_token = 2180,              /* expr_token  */
  YYSYMBOL_condition_no_is = 2181,         /* condition_no_is  */
  YYSYMBOL_expr_no_is = 2182,              /* expr_no_is  */
  YYSYMBOL_partial_expr_no_is = 2183,      /* partial_expr_no_is  */
  YYSYMBOL_2184_172 = 2184,                /* $@172  */
  YYSYMBOL_expr_tokens_no_is = 2185,       /* expr_tokens_no_is  */
  YYSYMBOL_expr_token_no_is = 2186,        /* expr_token_no_is  */
  YYSYMBOL__not_expr = 2187,               /* _not_expr  */
  YYSYMBOL_not_expr = 2188,                /* not_expr  */
  YYSYMBOL_condition_or_class = 2189,      /* condition_or_class  */
  YYSYMBOL_eq = 2190,                      /* eq  */
  YYSYMBOL_gt = 2191,                      /* gt  */
  YYSYMBOL_lt = 2192,                      /* lt  */
  YYSYMBOL_ge = 2193,                      /* ge  */
  YYSYMBOL_le = 2194,                      /* le  */
  YYSYMBOL_exp_list = 2195,                /* exp_list  */
  YYSYMBOL__e_sep = 2196,                  /* _e_sep  */
  YYSYMBOL_exp = 2197,                     /* exp  */
  YYSYMBOL_exp_term = 2198,                /* exp_term  */
  YYSYMBOL_exp_factor = 2199,              /* exp_factor  */
  YYSYMBOL_exp_unary = 2200,               /* exp_unary  */
  YYSYMBOL_exp_atom = 2201,                /* exp_atom  */
  YYSYMBOL_line_linage_page_counter = 2202, /* line_linage_page_counter  */
  YYSYMBOL_arithmetic_x_list = 2203,       /* arithmetic_x_list  */
  YYSYMBOL_arithmetic_x = 2204,            /* arithmetic_x  */
  YYSYMBOL_record_name = 2205,             /* record_name  */
  YYSYMBOL_file_or_record_name = 2206,     /* file_or_record_name  */
  YYSYMBOL_table_name = 2207,              /* table_name  */
  YYSYMBOL_file_name_list = 2208,          /* file_name_list  */
  YYSYMBOL_file_file_name_list = 2209,     /* file_file_name_list  */
  YYSYMBOL_file_name = 2210,               /* file_name  */
  YYSYMBOL_cd_name = 2211,                 /* cd_name  */
  YYSYMBOL_report_name = 2212,             /* report_name  */
  YYSYMBOL_mnemonic_name_list = 2213,      /* mnemonic_name_list  */
  YYSYMBOL_mnemonic_name = 2214,           /* mnemonic_name  */
  YYSYMBOL_entry_name_list = 2215,         /* entry_name_list  */
  YYSYMBOL_entry_name = 2216,              /* entry_name  */
  YYSYMBOL_procedure_name_list = 2217,     /* procedure_name_list  */
  YYSYMBOL_procedure_name = 2218,          /* procedure_name  */
  YYSYMBOL_label = 2219,                   /* label  */
  YYSYMBOL_integer_label = 2220,           /* integer_label  */
  YYSYMBOL_reference_list = 2221,          /* reference_list  */
  YYSYMBOL_reference = 2222,               /* reference  */
  YYSYMBOL__reference = 2223,              /* _reference  */
  YYSYMBOL_single_reference_list = 2224,   /* single_reference_list  */
  YYSYMBOL_single_reference = 2225,        /* single_reference  */
  YYSYMBOL_optional_reference_list = 2226, /* optional_reference_list  */
  YYSYMBOL_optional_reference = 2227,      /* optional_reference  */
  YYSYMBOL_reference_or_literal = 2228,    /* reference_or_literal  */
  YYSYMBOL_undefined_word = 2229,          /* undefined_word  */
  YYSYMBOL_undefined_word_but_no_error = 2230, /* undefined_word_but_no_error  */
  YYSYMBOL_unique_word = 2231,             /* unique_word  */
  YYSYMBOL_target_x_list = 2232,           /* target_x_list  */
  YYSYMBOL_target_x = 2233,                /* target_x  */
  YYSYMBOL__x_list = 2234,                 /* _x_list  */
  YYSYMBOL_x_list = 2235,                  /* x_list  */
  YYSYMBOL_x = 2236,                       /* x  */
  YYSYMBOL_call_x = 2237,                  /* call_x  */
  YYSYMBOL_x_common = 2238,                /* x_common  */
  YYSYMBOL_length_of_register = 2239,      /* length_of_register  */
  YYSYMBOL_report_x_list = 2240,           /* report_x_list  */
  YYSYMBOL_expr_x = 2241,                  /* expr_x  */
  YYSYMBOL_arith_x = 2242,                 /* arith_x  */
  YYSYMBOL_arith_nonzero_x = 2243,         /* arith_nonzero_x  */
  YYSYMBOL_alphanumeric_literal = 2244,    /* alphanumeric_literal  */
  YYSYMBOL_numeric_literal = 2245,         /* numeric_literal  */
  YYSYMBOL_non_numeric_literal = 2246,     /* non_numeric_literal  */
  YYSYMBOL_nonzero_numeric_literal = 2247, /* nonzero_numeric_literal  */
  YYSYMBOL_prog_or_entry = 2248,           /* prog_or_entry  */
  YYSYMBOL_alnum_or_id = 2249,             /* alnum_or_id  */
  YYSYMBOL_simple_display_value = 2250,    /* simple_display_value  */
  YYSYMBOL_inspect_from = 2251,            /* inspect_from  */
  YYSYMBOL_inspect_to = 2252,              /* inspect_to  */
  YYSYMBOL_simple_value = 2253,            /* simple_value  */
  YYSYMBOL_simple_all_value = 2254,        /* simple_all_value  */
  YYSYMBOL_id_or_lit = 2255,               /* id_or_lit  */
  YYSYMBOL_id_or_lit_or_func = 2256,       /* id_or_lit_or_func  */
  YYSYMBOL_id_or_lit_or_length_or_func = 2257, /* id_or_lit_or_length_or_func  */
  YYSYMBOL_num_id_or_lit = 2258,           /* num_id_or_lit  */
  YYSYMBOL_positive_id_or_lit = 2259,      /* positive_id_or_lit  */
  YYSYMBOL_pos_num_id_or_lit_or_zero = 2260, /* pos_num_id_or_lit_or_zero  */
  YYSYMBOL_pos_num_id_or_lit = 2261,       /* pos_num_id_or_lit  */
  YYSYMBOL_from_parameter = 2262,          /* from_parameter  */
  YYSYMBOL_sub_identifier = 2263,          /* sub_identifier  */
  YYSYMBOL_table_identifier = 2264,        /* table_identifier  */
  YYSYMBOL_sub_identifier_1 = 2265,        /* sub_identifier_1  */
  YYSYMBOL_display_identifier = 2266,      /* display_identifier  */
  YYSYMBOL_numeric_identifier = 2267,      /* numeric_identifier  */
  YYSYMBOL_identifier_or_file_name = 2268, /* identifier_or_file_name  */
  YYSYMBOL_identifier_field = 2269,        /* identifier_field  */
  YYSYMBOL_type_name = 2270,               /* type_name  */
  YYSYMBOL_identifier = 2271,              /* identifier  */
  YYSYMBOL_identifier_1 = 2272,            /* identifier_1  */
  YYSYMBOL_identifier_list = 2273,         /* identifier_list  */
  YYSYMBOL_validate_for_identifier_list = 2274, /* validate_for_identifier_list  */
  YYSYMBOL_for_identifier = 2275,          /* for_identifier  */
  YYSYMBOL_target_identifier = 2276,       /* target_identifier  */
  YYSYMBOL_target_identifier_1 = 2277,     /* target_identifier_1  */
  YYSYMBOL_target_identifier_single = 2278, /* target_identifier_single  */
  YYSYMBOL_data_name_without_sub_or_refmod = 2279, /* data_name_without_sub_or_refmod  */
  YYSYMBOL_display_identifier_or_alphabet_name = 2280, /* display_identifier_or_alphabet_name  */
  YYSYMBOL_qualified_word = 2281,          /* qualified_word  */
  YYSYMBOL_unqualified_word = 2282,        /* unqualified_word  */
  YYSYMBOL_2283_173 = 2283,                /* $@173  */
  YYSYMBOL_unqualified_word_check = 2284,  /* unqualified_word_check  */
  YYSYMBOL_subref = 2285,                  /* subref  */
  YYSYMBOL_refmod = 2286,                  /* refmod  */
  YYSYMBOL_integer = 2287,                 /* integer  */
  YYSYMBOL_symbolic_integer = 2288,        /* symbolic_integer  */
  YYSYMBOL_unsigned_pos_integer = 2289,    /* unsigned_pos_integer  */
  YYSYMBOL_integer_or_zero = 2290,         /* integer_or_zero  */
  YYSYMBOL_class_value = 2291,             /* class_value  */
  YYSYMBOL_figurative_constant = 2292,     /* figurative_constant  */
  YYSYMBOL_literal = 2293,                 /* literal  */
  YYSYMBOL_basic_literal = 2294,           /* basic_literal  */
  YYSYMBOL_basic_value = 2295,             /* basic_value  */
  YYSYMBOL_zero_spaces_high_low_values = 2296, /* zero_spaces_high_low_values  */
  YYSYMBOL_function = 2297,                /* function  */
  YYSYMBOL_func_no_parm = 2298,            /* func_no_parm  */
  YYSYMBOL_func_one_parm = 2299,           /* func_one_parm  */
  YYSYMBOL_func_multi_parm = 2300,         /* func_multi_parm  */
  YYSYMBOL_func_refmod = 2301,             /* func_refmod  */
  YYSYMBOL_func_args = 2302,               /* func_args  */
  YYSYMBOL_trim_args = 2303,               /* trim_args  */
  YYSYMBOL_length_arg = 2304,              /* length_arg  */
  YYSYMBOL_2305_174 = 2305,                /* $@174  */
  YYSYMBOL_numvalc_args = 2306,            /* numvalc_args  */
  YYSYMBOL_locale_dt_args = 2307,          /* locale_dt_args  */
  YYSYMBOL_formatted_datetime_args = 2308, /* formatted_datetime_args  */
  YYSYMBOL_formatted_time_args = 2309,     /* formatted_time_args  */
  YYSYMBOL_not_const_word = 2310,          /* not_const_word  */
  YYSYMBOL_flag_all = 2311,                /* flag_all  */
  YYSYMBOL_flag_duplicates = 2312,         /* flag_duplicates  */
  YYSYMBOL__flag_initialized = 2313,       /* _flag_initialized  */
  YYSYMBOL__flag_initialized_to = 2314,    /* _flag_initialized_to  */
  YYSYMBOL__to_init_val = 2315,            /* _to_init_val  */
  YYSYMBOL__flag_next = 2316,              /* _flag_next  */
  YYSYMBOL__flag_not = 2317,               /* _flag_not  */
  YYSYMBOL_flag_optional = 2318,           /* flag_optional  */
  YYSYMBOL_flag_rounded = 2319,            /* flag_rounded  */
  YYSYMBOL_round_mode = 2320,              /* round_mode  */
  YYSYMBOL_round_choice = 2321,            /* round_choice  */
  YYSYMBOL_flag_separate = 2322,           /* flag_separate  */
  YYSYMBOL__from_idx_to_idx = 2323,        /* _from_idx_to_idx  */
  YYSYMBOL__dest_index = 2324,             /* _dest_index  */
  YYSYMBOL_error_stmt_recover = 2325,      /* error_stmt_recover  */
  YYSYMBOL_verb = 2326,                    /* verb  */
  YYSYMBOL_scope_terminator = 2327,        /* scope_terminator  */
  YYSYMBOL__dot = 2328,                    /* _dot  */
  YYSYMBOL_dot_or_else_end_of_file_control = 2329, /* dot_or_else_end_of_file_control  */
  YYSYMBOL_level_number_in_area_a = 2330,  /* level_number_in_area_a  */
  YYSYMBOL_dot_or_else_end_of_file_description = 2331, /* dot_or_else_end_of_file_description  */
  YYSYMBOL_dot_or_else_end_of_communication_description = 2332, /* dot_or_else_end_of_communication_description  */
  YYSYMBOL_dot_or_else_end_of_report_description = 2333, /* dot_or_else_end_of_report_description  */
  YYSYMBOL_dot_or_else_end_of_report_group_description = 2334, /* dot_or_else_end_of_report_group_description  */
  YYSYMBOL_dot_or_else_end_of_record_description = 2335, /* dot_or_else_end_of_record_description  */
  YYSYMBOL_file_control_end_delimiter = 2336, /* file_control_end_delimiter  */
  YYSYMBOL_file_description_end_delimiter = 2337, /* file_description_end_delimiter  */
  YYSYMBOL_record_description_end_delimiter = 2338, /* record_description_end_delimiter  */
  YYSYMBOL__dot_or_else_area_a = 2339,     /* _dot_or_else_area_a  */
  YYSYMBOL__advancing = 2340,              /* _advancing  */
  YYSYMBOL__after = 2341,                  /* _after  */
  YYSYMBOL__are = 2342,                    /* _are  */
  YYSYMBOL__area = 2343,                   /* _area  */
  YYSYMBOL__areas = 2344,                  /* _areas  */
  YYSYMBOL__as = 2345,                     /* _as  */
  YYSYMBOL__at = 2346,                     /* _at  */
  YYSYMBOL__before = 2347,                 /* _before  */
  YYSYMBOL__binary = 2348,                 /* _binary  */
  YYSYMBOL__box = 2349,                    /* _box  */
  YYSYMBOL__by = 2350,                     /* _by  */
  YYSYMBOL__character = 2351,              /* _character  */
  YYSYMBOL__characters = 2352,             /* _characters  */
  YYSYMBOL__collating = 2353,              /* _collating  */
  YYSYMBOL__contains = 2354,               /* _contains  */
  YYSYMBOL__controls = 2355,               /* _controls  */
  YYSYMBOL__control = 2356,                /* _control  */
  YYSYMBOL__data = 2357,                   /* _data  */
  YYSYMBOL__end_of = 2358,                 /* _end_of  */
  YYSYMBOL__every = 2359,                  /* _every  */
  YYSYMBOL__file = 2360,                   /* _file  */
  YYSYMBOL__for = 2361,                    /* _for  */
  YYSYMBOL__from = 2362,                   /* _from  */
  YYSYMBOL__in = 2363,                     /* _in  */
  YYSYMBOL__in_equal = 2364,               /* _in_equal  */
  YYSYMBOL__in_order = 2365,               /* _in_order  */
  YYSYMBOL__index = 2366,                  /* _index  */
  YYSYMBOL__indicate = 2367,               /* _indicate  */
  YYSYMBOL__initial = 2368,                /* _initial  */
  YYSYMBOL__into = 2369,                   /* _into  */
  YYSYMBOL__is = 2370,                     /* _is  */
  YYSYMBOL__is_equal = 2371,               /* _is_equal  */
  YYSYMBOL__is_are = 2372,                 /* _is_are  */
  YYSYMBOL__is_are_equal = 2373,           /* _is_are_equal  */
  YYSYMBOL__is_in = 2374,                  /* _is_in  */
  YYSYMBOL__key = 2375,                    /* _key  */
  YYSYMBOL__line = 2376,                   /* _line  */
  YYSYMBOL__line_or_lines = 2377,          /* _line_or_lines  */
  YYSYMBOL__limits = 2378,                 /* _limits  */
  YYSYMBOL__lines = 2379,                  /* _lines  */
  YYSYMBOL__lock = 2380,                   /* _lock  */
  YYSYMBOL__message = 2381,                /* _message  */
  YYSYMBOL__mode = 2382,                   /* _mode  */
  YYSYMBOL__new = 2383,                    /* _new  */
  YYSYMBOL__number = 2384,                 /* _number  */
  YYSYMBOL__number_or_numbers = 2385,      /* _number_or_numbers  */
  YYSYMBOL__of = 2386,                     /* _of  */
  YYSYMBOL__on = 2387,                     /* _on  */
  YYSYMBOL__on_for = 2388,                 /* _on_for  */
  YYSYMBOL__onoff_status = 2389,           /* _onoff_status  */
  YYSYMBOL__other = 2390,                  /* _other  */
  YYSYMBOL__others = 2391,                 /* _others  */
  YYSYMBOL__procedure = 2392,              /* _procedure  */
  YYSYMBOL__program = 2393,                /* _program  */
  YYSYMBOL__protected = 2394,              /* _protected  */
  YYSYMBOL__record = 2395,                 /* _record  */
  YYSYMBOL__records = 2396,                /* _records  */
  YYSYMBOL__right = 2397,                  /* _right  */
  YYSYMBOL__sign = 2398,                   /* _sign  */
  YYSYMBOL__signed = 2399,                 /* _signed  */
  YYSYMBOL__sign_is = 2400,                /* _sign_is  */
  YYSYMBOL__size = 2401,                   /* _size  */
  YYSYMBOL__standard = 2402,               /* _standard  */
  YYSYMBOL__status = 2403,                 /* _status  */
  YYSYMBOL__symbolic = 2404,               /* _symbolic  */
  YYSYMBOL__tape = 2405,                   /* _tape  */
  YYSYMBOL__terminal = 2406,               /* _terminal  */
  YYSYMBOL__then = 2407,                   /* _then  */
  YYSYMBOL__times = 2408,                  /* _times  */
  YYSYMBOL__to = 2409,                     /* _to  */
  YYSYMBOL__up = 2410,                     /* _up  */
  YYSYMBOL__when = 2411,                   /* _when  */
  YYSYMBOL__when_set_to = 2412,            /* _when_set_to  */
  YYSYMBOL__with = 2413,                   /* _with  */
  YYSYMBOL__with_for = 2414,               /* _with_for  */
  YYSYMBOL__exception = 2415,              /* _exception  */
  YYSYMBOL_at_end = 2416,                  /* at_end  */
  YYSYMBOL_on_escape = 2417,               /* on_escape  */
  YYSYMBOL_on_exception = 2418,            /* on_exception  */
  YYSYMBOL_column_or_col = 2419,           /* column_or_col  */
  YYSYMBOL_columns_or_cols = 2420,         /* columns_or_cols  */
  YYSYMBOL_column_or_cols = 2421,          /* column_or_cols  */
  YYSYMBOL_column_or_col_or_position_or_pos = 2422, /* column_or_col_or_position_or_pos  */
  YYSYMBOL_comp_equal = 2423,              /* comp_equal  */
  YYSYMBOL_exception_or_error = 2424,      /* exception_or_error  */
  YYSYMBOL_file_limit_or_limits = 2425,    /* file_limit_or_limits  */
  YYSYMBOL_in_of = 2426,                   /* in_of  */
  YYSYMBOL_label_option = 2427,            /* label_option  */
  YYSYMBOL_line_or_lines = 2428,           /* line_or_lines  */
  YYSYMBOL_lock_records = 2429,            /* lock_records  */
  YYSYMBOL_object_char_or_word_or_modules = 2430, /* object_char_or_word_or_modules  */
  YYSYMBOL_records = 2431,                 /* records  */
  YYSYMBOL_reel_or_unit = 2432,            /* reel_or_unit  */
  YYSYMBOL_size_or_length = 2433,          /* size_or_length  */
  YYSYMBOL_length_of = 2434,               /* length_of  */
  YYSYMBOL_track_or_tracks = 2435,         /* track_or_tracks  */
  YYSYMBOL_using_or_varying = 2436,        /* using_or_varying  */
  YYSYMBOL_detail_keyword = 2437,          /* detail_keyword  */
  YYSYMBOL_ch_keyword = 2438,              /* ch_keyword  */
  YYSYMBOL_cf_keyword = 2439,              /* cf_keyword  */
  YYSYMBOL_ph_keyword = 2440,              /* ph_keyword  */
  YYSYMBOL_pf_keyword = 2441,              /* pf_keyword  */
  YYSYMBOL_rh_keyword = 2442,              /* rh_keyword  */
  YYSYMBOL_rf_keyword = 2443,              /* rf_keyword  */
  YYSYMBOL_control_keyword = 2444          /* control_keyword  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

#if defined __GNUC__ && ! defined __ICC && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                            \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if 1

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* 1 */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   22611

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  974
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  1471
/* YYNRULES -- Number of rules.  */
#define YYNRULES  3506
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  4958

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   1228


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int16 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845,   846,   847,   848,   849,   850,   851,   852,   853,   854,
     855,   856,   857,   858,   859,   860,   861,   862,   863,   864,
     865,   866,   867,   868,   869,   870,   871,   872,   873,   874,
     875,   876,   877,   878,   879,   880,   881,   882,   883,   884,
     885,   886,   887,   888,   889,   890,   891,   892,   893,   894,
     895,   896,   897,   898,   899,   900,   901,   902,   903,   904,
     905,   906,   907,   908,   909,   910,   911,   912,   913,   914,
     915,   916,   917,   918,   919,   920,   921,   922,   923,   924,
     925,   926,   927,   928,   929,   930,   931,   932,   933,   934,
     935,   936,   937,   938,   939,   940,   941,   942,   943,   944,
     945,   946,   947,   948,   949,   950,   951,   952,   953,   954,
     955,   956,   957,   958,   959,   960,   961,   962,   963,   964,
     965,   966,   967,   968,   969,   970,   971,   972,   973
};

#if YYDEBUG
  /* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,  3571,  3571,  3571,  3610,  3612,  3616,  3616,  3626,  3627,
    3631,  3632,  3633,  3634,  3638,  3638,  3650,  3661,  3669,  3673,
    3677,  3678,  3683,  3682,  3696,  3695,  3711,  3746,  3709,  3766,
    3795,  3764,  3810,  3812,  3812,  3824,  3825,  3828,  3827,  3834,
    3836,  3836,  3844,  3846,  3851,  3853,  3853,  3861,  3863,  3863,
    3876,  3880,  3874,  3892,  3893,  3897,  3897,  3907,  3907,  3911,
    3919,  3951,  3958,  3970,  3981,  3988,  3989,  3996,  3997,  4001,
    4002,  4006,  4010,  4014,  4015,  4022,  4023,  4027,  4031,  4037,
    4039,  4047,  4054,  4056,  4060,  4067,  4071,  4075,  4091,  4094,
    4104,  4106,  4113,  4117,  4121,  4127,  4129,  4136,  4140,  4144,
    4148,  4157,  4162,  4163,  4166,  4168,  4177,  4181,  4182,  4185,
    4187,  4197,  4199,  4203,  4204,  4208,  4209,  4210,  4211,  4212,
    4217,  4218,  4223,  4222,  4233,  4234,  4237,  4238,  4251,  4250,
    4264,  4265,  4266,  4267,  4271,  4272,  4276,  4277,  4278,  4279,
    4283,  4291,  4299,  4304,  4308,  4314,  4318,  4323,  4330,  4340,
    4354,  4365,  4369,  4373,  4377,  4384,  4385,  4389,  4390,  4395,
    4394,  4407,  4409,  4410,  4417,  4418,  4422,  4426,  4432,  4433,
    4440,  4447,  4452,  4463,  4478,  4481,  4482,  4485,  4489,  4490,
    4491,  4492,  4493,  4494,  4495,  4496,  4497,  4498,  4499,  4500,
    4501,  4502,  4503,  4511,  4510,  4529,  4531,  4534,  4545,  4568,
    4576,  4579,  4580,  4584,  4591,  4606,  4627,  4626,  4651,  4650,
    4659,  4658,  4668,  4670,  4674,  4678,  4679,  4685,  4691,  4697,
    4706,  4707,  4714,  4721,  4731,  4737,  4745,  4755,  4759,  4766,
    4770,  4775,  4774,  4785,  4789,  4796,  4797,  4798,  4799,  4800,
    4801,  4805,  4806,  4811,  4814,  4818,  4826,  4829,  4840,  4866,
    4874,  4878,  4889,  4909,  4917,  4928,  4929,  4936,  4950,  4951,
    4955,  4974,  5005,  5006,  5010,  5014,  5035,  5057,  5056,  5080,
    5087,  5099,  5166,  5169,  5178,  5197,  5213,  5231,  5249,  5266,
    5284,  5283,  5311,  5317,  5318,  5319,  5328,  5329,  5337,  5338,
    5342,  5344,  5342,  5390,  5391,  5397,  5398,  5407,  5408,  5409,
    5410,  5411,  5412,  5413,  5414,  5415,  5416,  5417,  5418,  5419,
    5420,  5421,  5422,  5423,  5424,  5425,  5426,  5449,  5459,  5469,
    5480,  5491,  5522,  5525,  5529,  5533,  5537,  5542,  5546,  5554,
    5560,  5566,  5576,  5577,  5578,  5579,  5583,  5584,  5585,  5586,
    5587,  5588,  5589,  5593,  5601,  5605,  5613,  5617,  5624,  5625,
    5631,  5638,  5639,  5640,  5647,  5702,  5705,  5710,  5709,  5721,
    5734,  5737,  5741,  5751,  5761,  5766,  5770,  5776,  5780,  5785,
    5792,  5802,  5813,  5823,  5827,  5831,  5835,  5839,  5848,  5859,
    5861,  5862,  5868,  5868,  5875,  5879,  5883,  5890,  5891,  5892,
    5896,  5902,  5903,  5907,  5913,  5914,  5930,  5931,  5935,  5941,
    5947,  5953,  5966,  5977,  5976,  5985,  5996,  6010,  6023,  6039,
    6078,  6081,  6088,  6089,  6093,  6093,  6097,  6102,  6120,  6131,
    6138,  6139,  6145,  6158,  6159,  6160,  6166,  6174,  6175,  6181,
    6191,  6201,  6211,  6221,  6222,  6229,  6237,  6238,  6239,  6246,
    6247,  6251,  6252,  6253,  6254,  6260,  6288,  6289,  6290,  6291,
    6297,  6302,  6306,  6310,  6311,  6318,  6319,  6320,  6321,  6322,
    6323,  6324,  6325,  6332,  6331,  6347,  6348,  6352,  6355,  6356,
    6362,  6366,  6370,  6371,  6375,  6377,  6378,  6386,  6390,  6391,
    6395,  6396,  6400,  6401,  6405,  6406,  6407,  6417,  6414,  6428,
    6429,  6432,  6434,  6442,  6443,  6444,  6452,  6453,  6457,  6477,
    6476,  6500,  6507,  6512,  6519,  6520,  6524,  6534,  6549,  6550,
    6551,  6552,  6553,  6554,  6555,  6556,  6557,  6564,  6571,  6571,
    6571,  6577,  6586,  6602,  6614,  6615,  6619,  6620,  6624,  6625,
    6632,  6643,  6648,  6659,  6660,  6664,  6665,  6671,  6682,  6700,
    6701,  6705,  6706,  6707,  6711,  6718,  6725,  6734,  6743,  6744,
    6745,  6746,  6747,  6756,  6757,  6763,  6802,  6803,  6812,  6827,
    6828,  6832,  6846,  6867,  6868,  6870,  6869,  6887,  6888,  6892,
    6907,  6910,  6909,  6931,  6932,  6936,  6937,  6938,  6941,  6943,
    6944,  6948,  6949,  6953,  6954,  6955,  6956,  6957,  6958,  6959,
    6960,  6961,  6962,  6963,  6967,  6971,  6973,  6977,  6978,  6982,
    6983,  6984,  6985,  6986,  6987,  6988,  6991,  6993,  6994,  6998,
    6999,  7003,  7004,  7005,  7006,  7007,  7008,  7012,  7017,  7018,
    7021,  7019,  7036,  7040,  7040,  7053,  7054,  7058,  7059,  7060,
    7062,  7061,  7082,  7117,  7130,  7136,  7138,  7142,  7149,  7153,
    7164,  7167,  7179,  7180,  7182,  7186,  7190,  7196,  7200,  7204,
    7208,  7212,  7216,  7220,  7228,  7232,  7236,  7244,  7248,  7252,
    7256,  7267,  7268,  7272,  7273,  7277,  7278,  7282,  7283,  7287,
    7331,  7334,  7342,  7341,  7355,  7361,  7365,  7390,  7389,  7404,
    7413,  7420,  7431,  7435,  7442,  7443,  7447,  7448,  7449,  7450,
    7451,  7452,  7453,  7454,  7455,  7456,  7459,  7461,  7465,  7469,
    7473,  7474,  7475,  7476,  7477,  7478,  7479,  7480,  7481,  7482,
    7483,  7484,  7485,  7486,  7487,  7488,  7489,  7490,  7491,  7492,
    7493,  7494,  7495,  7496,  7497,  7498,  7499,  7500,  7501,  7502,
    7512,  7533,  7547,  7548,  7551,  7560,  7579,  7603,  7604,  7614,
    7642,  7645,  7653,  7654,  7658,  7683,  7682,  7694,  7702,  7719,
    7731,  7749,  7748,  7759,  7760,  7766,  7773,  7774,  7775,  7781,
    7799,  7798,  7815,  7817,  7831,  7873,  7878,  7881,  7888,  7902,
    7913,  7914,  7915,  7949,  7956,  7957,  7963,  7964,  7968,  7972,
    7977,  7982,  7990,  7994,  7999,  8006,  8010,  8015,  8024,  8028,
    8033,  8037,  8041,  8045,  8049,  8053,  8057,  8061,  8065,  8070,
    8074,  8082,  8088,  8096,  8100,  8104,  8108,  8113,  8117,  8122,
    8126,  8131,  8136,  8141,  8145,  8149,  8157,  8161,  8165,  8173,
    8177,  8181,  8185,  8189,  8193,  8197,  8201,  8205,  8213,  8221,
    8225,  8229,  8233,  8237,  8241,  8246,  8251,  8259,  8260,  8264,
    8265,  8270,  8277,  8279,  8280,  8281,  8284,  8286,  8290,  8291,
    8295,  8296,  8300,  8303,  8305,  8306,  8307,  8308,  8309,  8310,
    8313,  8315,  8321,  8328,  8340,  8355,  8364,  8365,  8374,  8381,
    8390,  8408,  8409,  8413,  8414,  8418,  8419,  8422,  8423,  8428,
    8429,  8436,  8437,  8443,  8445,  8447,  8446,  8451,  8452,  8456,
    8478,  8479,  8483,  8508,  8509,  8512,  8514,  8518,  8525,  8526,
    8531,  8549,  8560,  8580,  8581,  8582,  8589,  8600,  8627,  8641,
    8649,  8670,  8681,  8695,  8696,  8700,  8732,  8733,  8737,  8741,
    8742,  8746,  8753,  8754,  8758,  8759,  8763,  8767,  8775,  8776,
    8780,  8781,  8785,  8790,  8800,  8799,  8807,  8819,  8820,  8824,
    8825,  8829,  8831,  8832,  8836,  8847,  8854,  8855,  8858,  8860,
    8869,  8877,  8878,  8882,  8883,  8884,  8885,  8891,  8898,  8899,
    8905,  8912,  8913,  8914,  8915,  8916,  8917,  8918,  8924,  8935,
    8944,  8954,  8963,  8978,  9001,  9020,  9021,  9023,  9022,  9046,
    9047,  9049,  9048,  9066,  9067,  9069,  9067,  9079,  9080,  9086,
    9088,  9086,  9114,  9115,  9116,  9123,  9129,  9134,  9135,  9141,
    9148,  9149,  9150,  9154,  9161,  9162,  9166,  9176,  9215,  9226,
    9227,  9241,  9254,  9255,  9258,  9259,  9264,  9265,  9266,  9267,
    9268,  9269,  9281,  9295,  9309,  9323,  9337,  9350,  9351,  9356,
    9355,  9369,  9378,  9379,  9383,  9384,  9385,  9386,  9387,  9388,
    9389,  9390,  9391,  9392,  9393,  9394,  9395,  9396,  9397,  9398,
    9399,  9403,  9410,  9414,  9418,  9419,  9420,  9427,  9431,  9439,
    9442,  9450,  9460,  9461,  9466,  9469,  9474,  9478,  9486,  9493,
    9502,  9507,  9514,  9515,  9516,  9520,  9527,  9528,  9529,  9536,
    9540,  9547,  9552,  9558,  9565,  9571,  9581,  9585,  9592,  9594,
    9598,  9602,  9606,  9610,  9617,  9618,  9623,  9660,  9663,  9671,
    9674,  9681,  9692,  9693,  9696,  9698,  9702,  9706,  9720,  9735,
    9738,  9740,  9744,  9748,  9752,  9759,  9781,  9785,  9786,  9790,
    9811,  9819,  9828,  9829,  9831,  9829,  9851,  9852,  9856,  9857,
    9861,  9864,  9863,  9876,  9883,  9875,  9893,  9913,  9915,  9919,
    9924,  9929,  9933,  9937,  9942,  9947,  9952,  9957,  9966,  9970,
    9974,  9978,  9982,  9988,  9992,  9997, 10003, 10007, 10011, 10016,
   10020, 10024, 10029, 10034, 10039, 10048, 10052, 10056, 10062, 10066,
   10070, 10074, 10078, 10082, 10086, 10090, 10096, 10102, 10107, 10112,
   10116, 10117, 10118, 10119, 10120, 10121, 10122, 10123, 10132, 10137,
   10148, 10161, 10162, 10166, 10167, 10174, 10175, 10176, 10177, 10178,
   10179, 10180, 10181, 10182, 10185, 10188, 10189, 10190, 10191, 10192,
   10193, 10200, 10201, 10206, 10207, 10210, 10212, 10216, 10217, 10221,
   10222, 10223, 10227, 10228, 10232, 10233, 10237, 10238, 10239, 10240,
   10241, 10244, 10245, 10246, 10247, 10248, 10250, 10251, 10253, 10254,
   10258, 10259, 10260, 10261, 10263, 10265, 10267, 10268, 10269, 10270,
   10271, 10272, 10273, 10274, 10275, 10281, 10282, 10283, 10284, 10285,
   10286, 10287, 10288, 10289, 10290, 10294, 10295, 10300, 10301, 10302,
   10303, 10304, 10308, 10316, 10317, 10318, 10319, 10320, 10321, 10322,
   10323, 10324, 10325, 10326, 10328, 10330, 10331, 10332, 10336, 10337,
   10338, 10339, 10340, 10341, 10342, 10343, 10344, 10345, 10350, 10351,
   10352, 10353, 10354, 10355, 10356, 10357, 10358, 10359, 10364, 10365,
   10376, 10377, 10401, 10402, 10419, 10422, 10423, 10424, 10427, 10431,
   10432, 10433, 10434, 10435, 10436, 10437, 10438, 10439, 10440, 10441,
   10442, 10443, 10444, 10445, 10446, 10452, 10453, 10454, 10474, 10475,
   10476, 10477, 10478, 10479, 10480, 10481, 10485, 10486, 10487, 10488,
   10489, 10490, 10496, 10497, 10498, 10499, 10500, 10501, 10502, 10503,
   10508, 10510, 10511, 10512, 10517, 10518, 10519, 10523, 10524, 10525,
   10526, 10527, 10528, 10539, 10540, 10541, 10542, 10547, 10550, 10551,
   10552, 10553, 10554, 10556, 10561, 10562, 10563, 10569, 10570, 10571,
   10572, 10573, 10574, 10575, 10576, 10577, 10578, 10582, 10583, 10584,
   10585, 10586, 10587, 10588, 10589, 10590, 10591, 10592, 10593, 10594,
   10595, 10597, 10598, 10599, 10600, 10601, 10602, 10603, 10604, 10605,
   10606, 10607, 10608, 10609, 10610, 10611, 10612, 10613, 10616, 10617,
   10618, 10626, 10627, 10628, 10632, 10633, 10634, 10638, 10639, 10642,
   10643, 10644, 10647, 10656, 10657, 10658, 10659, 10660, 10661, 10662,
   10663, 10664, 10665, 10666, 10667, 10668, 10670, 10671, 10672, 10673,
   10674, 10675, 10676, 10677, 10678, 10679, 10686, 10690, 10694, 10695,
   10696, 10697, 10698, 10699, 10700, 10701, 10707, 10708, 10709, 10714,
   10715, 10720, 10725, 10726, 10730, 10731, 10736, 10737, 10741, 10742,
   10743, 10748, 10749, 10753, 10754, 10758, 10759, 10763, 10767, 10767,
   10771, 10775, 10775, 10779, 10783, 10784, 10788, 10789, 10793, 10801,
   10803, 10807, 10814, 10824, 10827, 10831, 10838, 10850, 10856, 10858,
   10865, 10874, 10879, 10891, 10914, 10878, 10940, 10940, 10976, 10980,
   10979, 10993, 10992, 11012, 11013, 11018, 11040, 11042, 11046, 11057,
   11059, 11063, 11071, 11080, 11088, 11094, 11098, 11142, 11144, 11152,
   11155, 11175, 11180, 11190, 11225, 11228, 11235, 11237, 11227, 11268,
   11269, 11273, 11274, 11276, 11275, 11294, 11295, 11306, 11310, 11319,
   11318, 11364, 11365, 11369, 11414, 11437, 11440, 11469, 11486, 11468,
   11502, 11502, 11539, 11547, 11548, 11549, 11550, 11551, 11552, 11553,
   11554, 11555, 11556, 11557, 11558, 11559, 11560, 11561, 11562, 11563,
   11564, 11565, 11566, 11567, 11568, 11569, 11570, 11571, 11572, 11573,
   11574, 11575, 11576, 11578, 11579, 11580, 11581, 11582, 11583, 11584,
   11585, 11586, 11587, 11588, 11589, 11590, 11591, 11592, 11594, 11595,
   11596, 11597, 11598, 11599, 11600, 11601, 11602, 11603, 11604, 11605,
   11606, 11607, 11608, 11609, 11610, 11611, 11612, 11613, 11615, 11614,
   11633, 11646, 11645, 11656, 11655, 11690, 11689, 11700, 11704, 11708,
   11714, 11720, 11725, 11730, 11735, 11740, 11746, 11752, 11756, 11762,
   11766, 11770, 11775, 11779, 11783, 11787, 11791, 11795, 11799, 11803,
   11817, 11824, 11825, 11832, 11832, 11843, 11845, 11849, 11853, 11857,
   11864, 11868, 11872, 11879, 11880, 11884, 11886, 11890, 11891, 11895,
   11896, 11900, 11904, 11905, 11914, 11915, 11920, 11921, 11925, 11926,
   11931, 11930, 11954, 11953, 11976, 11989, 11996, 12003, 12010, 12016,
   12022, 12027, 12033, 12038, 12043, 12048, 12055, 12072, 12077, 12082,
   12087, 12093, 12099, 12105, 12112, 12116, 12120, 12124, 12128, 12139,
   12144, 12149, 12155, 12160, 12165, 12170, 12176, 12182, 12188, 12194,
   12200, 12205, 12210, 12217, 12224, 12230, 12233, 12233, 12237, 12248,
   12249, 12250, 12254, 12255, 12256, 12260, 12261, 12265, 12269, 12289,
   12288, 12297, 12301, 12308, 12312, 12320, 12321, 12325, 12329, 12341,
   12340, 12350, 12354, 12365, 12367, 12380, 12381, 12389, 12388, 12397,
   12398, 12402, 12408, 12408, 12415, 12414, 12430, 12429, 12513, 12517,
   12516, 12532, 12536, 12540, 12548, 12551, 12559, 12567, 12571, 12575,
   12579, 12583, 12587, 12606, 12612, 12632, 12636, 12646, 12650, 12655,
   12659, 12658, 12675, 12676, 12681, 12690, 12694, 12717, 12719, 12723,
   12736, 12753, 12756, 12760, 12764, 12769, 12792, 12793, 12797, 12798,
   12802, 12806, 12810, 12821, 12825, 12832, 12836, 12844, 12848, 12855,
   12862, 12866, 12878, 12877, 12889, 12890, 12899, 12903, 12910, 12911,
   12921, 12920, 12928, 12929, 12933, 12944, 12954, 12955, 12956, 12957,
   12958, 12959, 12964, 12963, 12975, 12976, 12984, 12983, 12992, 12999,
   13003, 13014, 13026, 13025, 13050, 13053, 13053, 13068, 13067, 13076,
   13083, 13094, 13093, 13102, 13106, 13113, 13120, 13130, 13134, 13146,
   13145, 13154, 13157, 13159, 13165, 13167, 13168, 13169, 13170, 13178,
   13177, 13189, 13193, 13197, 13201, 13205, 13206, 13212, 13213, 13214,
   13215, 13216, 13217, 13221, 13229, 13240, 13241, 13246, 13245, 13292,
   13296, 13302, 13304, 13308, 13309, 13313, 13314, 13318, 13322, 13327,
   13331, 13332, 13337, 13340, 13344, 13348, 13352, 13356, 13363, 13364,
   13369, 13368, 13386, 13394, 13394, 13406, 13410, 13417, 13418, 13419,
   13429, 13428, 13446, 13448, 13452, 13453, 13457, 13461, 13462, 13463,
   13464, 13469, 13474, 13468, 13488, 13489, 13494, 13501, 13493, 13520,
   13519, 13542, 13543, 13544, 13548, 13549, 13554, 13557, 13564, 13577,
   13589, 13596, 13597, 13603, 13604, 13608, 13609, 13610, 13611, 13612,
   13613, 13617, 13620, 13624, 13625, 13626, 13630, 13631, 13632, 13633,
   13637, 13638, 13643, 13644, 13648, 13658, 13674, 13679, 13685, 13691,
   13696, 13701, 13706, 13713, 13719, 13725, 13731, 13737, 13744, 13748,
   13752, 13756, 13760, 13765, 13770, 13775, 13780, 13785, 13790, 13797,
   13807, 13808, 13812, 13816, 13828, 13827, 13836, 13840, 13844, 13848,
   13852, 13859, 13863, 13875, 13874, 13884, 13887, 13886, 13894, 13893,
   13908, 13936, 13935, 13962, 13972, 13973, 13978, 13989, 14000, 14014,
   14022, 14030, 14031, 14036, 14040, 14052, 14062, 14074, 14084, 14093,
   14103, 14115, 14125, 14132, 14143, 14144, 14149, 14224, 14225, 14226,
   14227, 14231, 14232, 14236, 14240, 14250, 14249, 14263, 14262, 14303,
   14303, 14304, 14304, 14305, 14305, 14308, 14317, 14328, 14329, 14337,
   14336, 14348, 14368, 14386, 14400, 14423, 14446, 14467, 14490, 14494,
   14502, 14503, 14513, 14512, 14521, 14532, 14531, 14540, 14555, 14554,
   14567, 14572, 14583, 14587, 14598, 14598, 14613, 14612, 14621, 14628,
   14636, 14647, 14659, 14662, 14670, 14676, 14682, 14687, 14700, 14699,
   14707, 14715, 14716, 14720, 14721, 14722, 14727, 14730, 14737, 14741,
   14749, 14756, 14757, 14758, 14759, 14760, 14761, 14762, 14774, 14777,
   14787, 14786, 14794, 14803, 14816, 14815, 14827, 14828, 14835, 14834,
   14843, 14852, 14853, 14857, 14858, 14859, 14863, 14864, 14865, 14866,
   14873, 14872, 14882, 14881, 14931, 14962, 14963, 14964, 14968, 14969,
   14970, 14971, 14975, 14976, 14980, 14987, 15002, 15001, 15022, 15032,
   15040, 15044, 15051, 15056, 15061, 15066, 15071, 15076, 15084, 15085,
   15089, 15094, 15100, 15102, 15103, 15104, 15105, 15109, 15137, 15140,
   15144, 15148, 15152, 15159, 15166, 15174, 15177, 15176, 15190, 15195,
   15188, 15206, 15207, 15211, 15212, 15216, 15224, 15228, 15238, 15237,
   15249, 15260, 15261, 15268, 15267, 15279, 15278, 15291, 15292, 15296,
   15300, 15312, 15311, 15319, 15323, 15334, 15333, 15342, 15346, 15353,
   15357, 15369, 15368, 15377, 15378, 15382, 15411, 15412, 15416, 15417,
   15418, 15419, 15423, 15424, 15428, 15429, 15430, 15434, 15435, 15443,
   15444, 15448, 15449, 15455, 15464, 15465, 15466, 15471, 15472, 15473,
   15477, 15484, 15500, 15501, 15502, 15508, 15507, 15519, 15531, 15528,
   15545, 15542, 15558, 15566, 15574, 15579, 15592, 15598, 15610, 15613,
   15618, 15622, 15636, 15643, 15644, 15648, 15649, 15652, 15653, 15658,
   15701, 15705, 15715, 15714, 15727, 15726, 15734, 15739, 15748, 15763,
   15762, 15772, 15801, 15802, 15806, 15810, 15814, 15818, 15825, 15826,
   15830, 15834, 15837, 15839, 15843, 15852, 15853, 15854, 15858, 15859,
   15863, 15867, 15871, 15879, 15880, 15884, 15885, 15889, 15893, 15904,
   15915, 15914, 15923, 15928, 15929, 15933, 15934, 15935, 15939, 15940,
   15944, 15948, 15949, 15953, 15957, 15961, 15972, 15971, 15979, 15989,
   16000, 15999, 16008, 16015, 16019, 16031, 16030, 16042, 16051, 16054,
   16058, 16062, 16069, 16073, 16084, 16094, 16097, 16096, 16103, 16102,
   16111, 16119, 16128, 16129, 16134, 16137, 16145, 16151, 16155, 16162,
   16170, 16174, 16189, 16199, 16198, 16206, 16207, 16213, 16231, 16242,
   16244, 16248, 16267, 16271, 16278, 16279, 16280, 16281, 16284, 16286,
   16293, 16292, 16306, 16307, 16308, 16309, 16310, 16311, 16312, 16313,
   16317, 16318, 16322, 16323, 16329, 16338, 16345, 16346, 16350, 16354,
   16358, 16364, 16370, 16374, 16378, 16382, 16391, 16395, 16399, 16403,
   16407, 16416, 16425, 16426, 16430, 16439, 16440, 16444, 16448, 16457,
   16466, 16478, 16477, 16487, 16485, 16545, 16546, 16563, 16564, 16567,
   16568, 16575, 16577, 16582, 16591, 16601, 16618, 16627, 16637, 16655,
   16654, 16664, 16677, 16680, 16688, 16691, 16696, 16701, 16709, 16710,
   16711, 16712, 16713, 16714, 16723, 16724, 16728, 16732, 16742, 16745,
   16744, 16755, 16762, 16770, 16784, 16791, 16795, 16799, 16807, 16818,
   16819, 16823, 16827, 16834, 16835, 16836, 16837, 16844, 16843, 16852,
   16859, 16859, 16869, 16870, 16874, 16888, 16889, 16894, 16895, 16899,
   16900, 16904, 16908, 16920, 16919, 16928, 16932, 16936, 16940, 16948,
   16952, 16963, 16963, 16975, 16976, 16983, 16982, 16990, 16999, 17012,
   17011, 17019, 17031, 17030, 17038, 17055, 17054, 17064, 17072, 17073,
   17078, 17079, 17084, 17091, 17092, 17097, 17104, 17105, 17109, 17110,
   17114, 17118, 17129, 17128, 17143, 17148, 17160, 17159, 17168, 17169,
   17170, 17171, 17172, 17176, 17204, 17207, 17219, 17229, 17234, 17239,
   17244, 17252, 17292, 17293, 17297, 17357, 17367, 17390, 17391, 17392,
   17393, 17397, 17406, 17412, 17422, 17449, 17453, 17454, 17458, 17464,
   17480, 17481, 17488, 17487, 17499, 17509, 17510, 17515, 17518, 17522,
   17526, 17533, 17534, 17538, 17539, 17540, 17544, 17548, 17557, 17560,
   17559, 17573, 17584, 17571, 17595, 17597, 17601, 17602, 17606, 17610,
   17622, 17631, 17641, 17644, 17654, 17657, 17665, 17668, 17677, 17681,
   17688, 17696, 17699, 17706, 17710, 17717, 17721, 17729, 17732, 17741,
   17745, 17752, 17760, 17763, 17767, 17768, 17769, 17772, 17774, 17782,
   17783, 17787, 17792, 17797, 17804, 17809, 17814, 17822, 17826, 17833,
   17837, 17849, 17848, 17877, 17872, 17892, 17895, 17903, 17904, 17908,
   17909, 17914, 17915, 17931, 17932, 17933, 17943, 17947, 17954, 17966,
   17967, 17971, 17972, 17976, 17988, 17989, 17994, 17995, 17996, 18006,
   18010, 18017, 18028, 18029, 18033, 18046, 18050, 18051, 18061, 18065,
   18072, 18084, 18085, 18089, 18103, 18104, 18105, 18115, 18119, 18126,
   18138, 18139, 18143, 18158, 18159, 18171, 18173, 18182, 18186, 18193,
   18205, 18206, 18210, 18224, 18225, 18235, 18239, 18246, 18258, 18259,
   18263, 18277, 18278, 18282, 18283, 18293, 18297, 18304, 18316, 18317,
   18321, 18336, 18339, 18348, 18351, 18359, 18363, 18372, 18376, 18383,
   18384, 18396, 18401, 18409, 18416, 18416, 18427, 18428, 18432, 18433,
   18435, 18437, 18439, 18440, 18442, 18443, 18444, 18445, 18446, 18448,
   18449, 18450, 18451, 18452, 18453, 18454, 18455, 18456, 18457, 18458,
   18462, 18467, 18475, 18482, 18482, 18493, 18494, 18498, 18499, 18500,
   18501, 18503, 18504, 18506, 18507, 18508, 18509, 18510, 18512, 18513,
   18514, 18515, 18516, 18517, 18518, 18519, 18520, 18521, 18524, 18526,
   18530, 18533, 18535, 18536, 18537, 18538, 18539, 18540, 18542, 18543,
   18544, 18545, 18546, 18550, 18551, 18555, 18556, 18560, 18561, 18565,
   18566, 18570, 18574, 18580, 18584, 18590, 18592, 18593, 18597, 18598,
   18599, 18603, 18604, 18605, 18606, 18607, 18608, 18609, 18610, 18611,
   18612, 18616, 18620, 18624, 18625, 18626, 18627, 18630, 18631, 18641,
   18653, 18662, 18678, 18687, 18703, 18718, 18719, 18724, 18733, 18739,
   18749, 18763, 18788, 18792, 18813, 18817, 18838, 18850, 18864, 18878,
   18879, 18884, 18890, 18891, 18896, 18905, 18907, 18912, 18926, 18927,
   18928, 18935, 18946, 18947, 18951, 18959, 18960, 18964, 18965, 18969,
   18981, 18985, 18992, 19001, 19002, 19008, 19017, 19026, 19040, 19057,
   19061, 19068, 19069, 19070, 19077, 19078, 19082, 19086, 19093, 19094,
   19098, 19099, 19103, 19104, 19105, 19106, 19110, 19114, 19118, 19122,
   19126, 19147, 19157, 19161, 19168, 19169, 19170, 19174, 19175, 19176,
   19177, 19178, 19182, 19186, 19193, 19194, 19195, 19196, 19200, 19204,
   19211, 19223, 19235, 19247, 19261, 19262, 19266, 19267, 19271, 19278,
   19279, 19286, 19287, 19294, 19295, 19296, 19300, 19301, 19305, 19309,
   19313, 19317, 19318, 19322, 19326, 19327, 19331, 19335, 19336, 19345,
   19349, 19354, 19355, 19361, 19365, 19369, 19373, 19374, 19380, 19384,
   19388, 19389, 19393, 19400, 19410, 19429, 19438, 19454, 19466, 19473,
   19480, 19487, 19497, 19501, 19508, 19512, 19519, 19541, 19554, 19561,
   19565, 19569, 19573, 19580, 19596, 19609, 19635, 19639, 19647, 19647,
   19660, 19665, 19673, 19681, 19685, 19695, 19710, 19732, 19752, 19756,
   19763, 19778, 19786, 19787, 19788, 19789, 19790, 19791, 19795, 19799,
   19815, 19819, 19825, 19825, 19828, 19829, 19830, 19831, 19837, 19841,
   19845, 19849, 19853, 19857, 19862, 19867, 19871, 19875, 19879, 19883,
   19887, 19891, 19898, 19899, 19903, 19904, 19905, 19906, 19910, 19911,
   19912, 19913, 19914, 19918, 19922, 19926, 19933, 19937, 19941, 19948,
   19955, 19962, 19972, 19972, 19988, 19995, 20005, 20012, 20022, 20026,
   20039, 20043, 20058, 20066, 20067, 20071, 20072, 20073, 20077, 20078,
   20083, 20086, 20094, 20097, 20105, 20107, 20108, 20112, 20113, 20117,
   20118, 20119, 20124, 20127, 20140, 20144, 20152, 20156, 20160, 20164,
   20168, 20172, 20176, 20180, 20187, 20188, 20192, 20193, 20203, 20204,
   20213, 20217, 20222, 20226, 20234, 20235, 20236, 20237, 20238, 20239,
   20240, 20241, 20242, 20243, 20244, 20245, 20246, 20247, 20248, 20249,
   20250, 20251, 20252, 20253, 20254, 20255, 20256, 20257, 20258, 20259,
   20260, 20261, 20262, 20263, 20264, 20265, 20266, 20267, 20268, 20269,
   20270, 20271, 20272, 20273, 20274, 20275, 20276, 20277, 20278, 20279,
   20280, 20281, 20282, 20283, 20284, 20285, 20289, 20290, 20291, 20292,
   20293, 20294, 20295, 20296, 20297, 20298, 20299, 20300, 20301, 20302,
   20303, 20304, 20305, 20306, 20307, 20308, 20309, 20310, 20311, 20315,
   20316, 20324, 20325, 20335, 20344, 20345, 20346, 20356, 20359, 20362,
   20365, 20366, 20367, 20377, 20377, 20377, 20377, 20380, 20380, 20383,
   20383, 20383, 20383, 20383, 20383, 20386, 20387, 20393, 20405, 20405,
   20406, 20406, 20407, 20407, 20408, 20408, 20409, 20409, 20409, 20410,
   20410, 20411, 20411, 20412, 20412, 20413, 20413, 20414, 20414, 20415,
   20415, 20416, 20416, 20417, 20417, 20418, 20418, 20419, 20419, 20420,
   20420, 20421, 20421, 20422, 20422, 20423, 20423, 20424, 20424, 20425,
   20425, 20426, 20426, 20427, 20427, 20428, 20428, 20429, 20429, 20429,
   20430, 20430, 20430, 20431, 20431, 20432, 20432, 20433, 20433, 20434,
   20434, 20435, 20435, 20436, 20436, 20436, 20437, 20437, 20437, 20438,
   20438, 20438, 20438, 20439, 20439, 20439, 20440, 20440, 20441, 20441,
   20442, 20442, 20442, 20443, 20443, 20443, 20444, 20444, 20445, 20445,
   20446, 20446, 20447, 20447, 20448, 20448, 20449, 20449, 20450, 20450,
   20451, 20451, 20452, 20452, 20453, 20453, 20453, 20454, 20454, 20454,
   20454, 20455, 20455, 20456, 20456, 20457, 20457, 20458, 20458, 20459,
   20459, 20460, 20460, 20461, 20461, 20461, 20462, 20462, 20463, 20463,
   20464, 20464, 20465, 20465, 20465, 20466, 20466, 20467, 20467, 20468,
   20468, 20469, 20469, 20470, 20470, 20471, 20471, 20472, 20472, 20473,
   20473, 20474, 20474, 20475, 20475, 20476, 20476, 20477, 20477, 20478,
   20478, 20479, 20479, 20479, 20481, 20481, 20485, 20485, 20486, 20486,
   20487, 20487, 20488, 20488, 20489, 20489, 20490, 20490, 20491, 20491,
   20491, 20491, 20492, 20492, 20493, 20493, 20494, 20494, 20495, 20495,
   20496, 20496, 20497, 20497, 20498, 20498, 20499, 20499, 20499, 20500,
   20500, 20501, 20501, 20502, 20502, 20503, 20503, 20504, 20504, 20505,
   20505, 20508, 20508, 20509, 20509, 20510, 20510, 20511, 20511, 20512,
   20512, 20513, 20513, 20514, 20514, 20515, 20515
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if 1
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "\"3D\"", "ABSENT",
  "ACCEPT", "ACCESS", "\"ACTIVE-X\"", "\"ACTIVE-CLASS\"", "ACTION",
  "ACTUAL", "ADD", "ADDRESS", "\"ADJUSTABLE-COLUMNS\"", "ADVANCING",
  "AFTER", "ALIGNED", "ALIGNMENT", "ALL", "ALLOCATE", "ALLOWING",
  "ALPHABET", "ALPHABETIC", "\"ALPHABETIC-LOWER\"", "\"ALPHABETIC-UPPER\"",
  "ALPHANUMERIC", "\"ALPHANUMERIC-EDITED\"", "ALSO", "ALTER", "ALTERNATE",
  "AND", "ANY", "APPLY", "ARE", "AREA", "AREAS", "\"ARGUMENT-NUMBER\"",
  "\"ARGUMENT-VALUE\"", "ARITHMETIC", "AS", "ASCENDING", "ASCII", "ASSIGN",
  "AT", "\"AT END\"", "ATTRIBUTE", "ATTRIBUTES", "AUTHOR", "AUTO",
  "\"AUTO-DECIMAL\"", "\"AUTO-SPIN\"", "AUTOMATIC", "\"AWAY-FROM-ZERO\"",
  "\"B-AND\"", "\"B-NOT\"", "\"B-OR\"", "\"B-XOR\"", "\"B-SHIFT-L\"",
  "\"B-SHIFT-R\"", "\"B-SHIFT-LC\"", "\"B-SHIFT-RC\"",
  "\"BACKGROUND-COLOR\"", "\"BACKGROUND-HIGH\"", "\"BACKGROUND-LOW\"",
  "\"BACKGROUND-STANDARD\"", "BACKWARD", "BAR", "BASED", "BEFORE", "BELL",
  "BINARY", "\"BINARY-C-LONG\"", "\"BINARY-CHAR\"", "\"BINARY-DOUBLE\"",
  "\"BINARY-LONG\"", "\"BINARY-SEQUENTIAL\"", "\"BINARY-SHORT\"", "BIT",
  "BITMAP", "\"BITMAP-END\"", "\"BITMAP-HANDLE\"", "\"BITMAP-NUMBER\"",
  "\"BITMAP-START\"", "\"BITMAP-TIMER\"", "\"BITMAP-TRAILING\"",
  "\"BITMAP-TRANSPARENT-COLOR\"", "\"BITMAP-WIDTH\"", "BLANK", "BLINK",
  "BLOCK", "BOOLEAN", "BOTTOM", "BOX", "BOXED", "\"BULK-ADDITION\"",
  "BUSY", "BUTTONS", "BY", "\"BYTE-LENGTH\"", "C", "\"CALENDAR-FONT\"",
  "CALL", "CANCEL", "\"CANCEL-BUTTON\"", "CAPACITY", "\"CARD-PUNCH\"",
  "\"CARD-READER\"", "CASSETTE", "CCOL", "CD", "CELL", "\"CELL-COLOR\"",
  "\"CELL-DATA\"", "\"CELL-FONT\"", "\"CELL-PROTECTION\"", "CENTER",
  "CENTERED", "\"CENTERED-HEADINGS\"", "\"CENTURY-DATE\"", "CF", "CH",
  "CHAINING", "CHANGED", "CHARACTER", "CHARACTERS", "\"CHECK-BOX\"",
  "CLASS", "CLASSIFICATION", "\"class-name\"", "\"CLEAR-SELECTION\"",
  "CLINE", "CLINES", "CLOSE", "COBOL", "CODE", "\"CODE-SET\"", "COLLATING",
  "COL", "COLOR", "COLORS", "COLS", "COLUMN", "\"COLUMN-COLOR\"",
  "\"COLUMN-DIVIDERS\"", "\"COLUMN-FONT\"", "\"COLUMN-HEADINGS\"",
  "\"COLUMN-PROTECTION\"", "COLUMNS", "\"COMBO-BOX\"", "COMMA",
  "\"COMMAND-LINE\"", "\"comma delimiter\"", "COMMIT", "COMMON",
  "COMMUNICATION", "COMP", "COMPUTE", "\"COMP-0\"", "\"COMP-1\"",
  "\"COMP-2\"", "\"COMP-3\"", "\"COMP-4\"", "\"COMP-5\"", "\"COMP-6\"",
  "\"COMP-N\"", "\"COMP-X\"", "\"FUNCTION CONCATENATE\"", "CONDITION",
  "CONFIGURATION", "CONSTANT", "CONTAINS", "CONTENT",
  "\"FUNCTION CONTENT-LENGTH\"", "\"FUNCTION CONTENT-OF\"", "CONTINUE",
  "CONTROL", "CONTROLS", "CONVERSION", "CONVERTING", "COPY",
  "\"COPY-SELECTION\"", "\"CORE-INDEX\"", "CORRESPONDING", "COUNT", "CRT",
  "\"CRT-UNDER\"", "CSIZE", "CURRENCY", "\"FUNCTION CURRENT-DATE\"",
  "CURSOR", "\"CURSOR-COL\"", "\"CURSOR-COLOR\"", "\"CURSOR-FRAME-WIDTH\"",
  "\"CURSOR-ROW\"", "\"CURSOR-X\"", "\"CURSOR-Y\"",
  "\"CUSTOM-PRINT-TEMPLATE\"", "CYCLE", "\"CYL-INDEX\"",
  "\"CYL-OVERFLOW\"", "DASHED", "DATA", "\"DATA-COLUMNS\"",
  "\"DATA-POINTER\"", "\"DATA-TYPES\"", "DATE", "\"DATE-COMPILED\"",
  "\"DATE-ENTRY\"", "\"DATE-MODIFIED\"", "\"DATE-WRITTEN\"", "DAY",
  "\"DAY-OF-WEEK\"", "DE", "DEBUGGING", "\"DECIMAL-POINT\"",
  "DECLARATIVES", "DEFAULT", "\"DEFAULT-BUTTON\"", "\"DEFAULT-FONT\"",
  "DELETE", "DELIMITED", "DELIMITER", "DEPENDING", "DESCENDING",
  "DESTINATION", "DESTROY", "DETAIL", "DISABLE", "DISC", "DISK", "DISP",
  "DISPLAY", "\"DISPLAY-1\"", "\"DISPLAY-COLUMNS\"", "\"DISPLAY-FORMAT\"",
  "\"FUNCTION DISPLAY-OF\"", "DIVIDE", "DIVIDERS", "\"DIVIDER-COLOR\"",
  "DIVISION", "DOTDASH", "DOTTED", "\"DRAG-COLOR\"", "\"DROP-DOWN\"",
  "\"DROP-LIST\"", "DOWN", "DUPLICATES", "DYNAMIC", "EBCDIC", "EC", "ECHO",
  "EGI", "\"level-number 88\"", "ENABLE", "ELEMENT", "ELSE", "EMI",
  "ENCRYPTION", "ENCODING", "END", "\"END-ACCEPT\"", "\"END-ADD\"",
  "\"END-CALL\"", "\"END-COMPUTE\"", "\"END-COLOR\"", "\"END-DELETE\"",
  "\"END-DISPLAY\"", "\"END-DIVIDE\"", "\"END-EVALUATE\"",
  "\"END FUNCTION\"", "\"END-IF\"", "\"END-JSON\"", "\"END-MODIFY\"",
  "\"END-MULTIPLY\"", "\"END-PERFORM\"", "\"END PROGRAM\"", "\"END-READ\"",
  "\"END-RECEIVE\"", "\"END-RETURN\"", "\"END-REWRITE\"", "\"END-SEARCH\"",
  "\"END-SEND\"", "\"END-START\"", "\"END-STRING\"", "\"END-SUBTRACT\"",
  "\"END-UNSTRING\"", "\"END-WRITE\"", "\"END-XML\"", "ENGRAVED",
  "\"ENSURE-VISIBLE\"", "ENTRY", "\"ENTRY-CONVENTION\"", "\"ENTRY-FIELD\"",
  "\"ENTRY-REASON\"", "ENVIRONMENT", "\"ENVIRONMENT-NAME\"",
  "\"ENVIRONMENT-VALUE\"", "EOL", "EOP", "EOS", "EQUAL", "ERASE", "ERROR",
  "ESCAPE", "\"ESCAPE-BUTTON\"", "ESI", "EVALUATE", "EVENT",
  "\"EVENT-LIST\"", "\"EVENT STATUS\"", "EVERY", "EXAMINE", "EXCEPTION",
  "\"EXCEPTION CONDITION\"", "\"EXCEPTION-VALUE\"", "EXPAND", "EXCLUSIVE",
  "EXHIBIT", "EXIT", "\"exponentiation operator\"", "EXTEND",
  "\"EXTENDED-SEARCH\"", "EXTERNAL", "\"EXTERNAL-FORM\"", "F", "FACTORY",
  "FD", "\"FH--FCD\"", "\"FH--KEYDEF\"", "\"FILE-CONTROL\"", "\"FILE-ID\"",
  "\"FILE-LIMIT\"", "\"FILE-LIMITS\"", "\"FILE-NAME\"", "\"FILE-POS\"",
  "\"FILL-COLOR\"", "\"FILL-COLOR2\"", "\"FILL-PERCENT\"", "FILLER",
  "FINAL", "\"FINISH-REASON\"", "FIRST", "FIXED", "\"FIXED-FONT\"",
  "\"FIXED-WIDTH\"", "FLAT", "\"FLAT-BUTTONS\"", "\"FLOAT-BINARY-128\"",
  "\"FLOAT-BINARY-32\"", "\"FLOAT-BINARY-64\"", "\"FLOAT-DECIMAL-16\"",
  "\"FLOAT-DECIMAL-34\"", "\"FLOAT-DECIMAL-7\"", "\"FLOAT-EXTENDED\"",
  "\"FLOAT-LONG\"", "\"FLOAT-SHORT\"", "FLOATING", "FONT", "FOOTING",
  "FOR", "\"FOREGROUND-COLOR\"", "FOREVER", "FORMAT",
  "\"FUNCTION FORMATTED-DATE\"", "\"FUNCTION FORMATTED-DATETIME\"",
  "\"FUNCTION FORMATTED-TIME\"", "FRAME", "FRAMED", "FREE", "FROM",
  "\"FROM CRT\"", "FULL", "\"FULL-HEIGHT\"", "FUNCTION", "\"FUNCTION-ID\"",
  "\"intrinsic function name\"", "\"FUNCTION-POINTER\"", "GENERATE",
  "GIVING", "GLOBAL", "GO", "\"GO-BACK\"", "\"GO-FORWARD\"", "\"GO-HOME\"",
  "\"GO-SEARCH\"", "GOBACK", "GRAPHICAL", "GREATER",
  "\"GREATER OR EQUAL\"", "GRID", "GROUP", "\"GROUP-VALUE\"", "HANDLE",
  "\"HAS-CHILDREN\"", "HEADING", "\"HEADING-COLOR\"",
  "\"HEADING-DIVIDER-COLOR\"", "\"HEADING-FONT\"", "HEAVY",
  "\"HEIGHT-IN-CELLS\"", "\"HIDDEN-DATA\"", "HIGHLIGHT", "\"HIGH-COLOR\"",
  "\"HIGH-VALUE\"", "\"HOT-TRACK\"", "HSCROLL", "\"HSCROLL-POS\"", "ICON",
  "ID", "IDENTIFIED", "IDENTIFICATION", "IF", "IGNORE", "IGNORING", "IN",
  "INDEPENDENT", "INDEX", "INDEXED", "INDICATE", "INITIALIZE",
  "INITIALIZED", "INITIATE", "INPUT", "\"INPUT-OUTPUT\"", "INQUIRE",
  "\"INSERTION-INDEX\"", "\"INSERT-ROWS\"", "INSPECT", "INSTALLATION",
  "INTERMEDIATE", "INTO", "INTRINSIC", "INVALID", "\"INVALID KEY\"", "IS",
  "ITEM", "\"ITEM-TEXT\"", "\"ITEM-TO_ADD\"", "\"ITEM-TO_DELETE\"",
  "\"ITEM-TO_EMPTY\"", "\"ITEM-VALUE\"", "\"I-O\"", "\"I-O-CONTROL\"",
  "JSON", "JUSTIFIED", "KEPT", "KEY", "KEYBOARD", "LABEL",
  "\"LABEL-OFFSET\"", "\"LARGE-FONT\"", "\"LARGE-OFFSET\"", "LAST",
  "\"LAST-ROW\"", "\"LAYOUT-DATA\"", "\"LAYOUT-MANAGER\"", "LEADING",
  "\"LEADING-SHIFT\"", "LEAVE", "LEFT", "LEFTLINE", "\"LEFT-TEXT\"",
  "LENGTH", "\"LENGTH OF\"", "\"FUNCTION LENGTH/BYTE-LENGTH\"", "LESS",
  "\"LESS OR EQUAL\"", "\"level-number\"", "LIKE", "LIMIT", "LIMITS",
  "LINAGE", "\"LINAGE-COUNTER\"", "LINE", "\"LINE-COUNTER\"",
  "\"LINE LIMIT\"", "\"LINE-SEQUENTIAL\"", "LINES", "\"LINES-AT-ROOT\"",
  "LINKAGE", "\"LIST-BOX\"", "\"Literal\"", "\"LM-RESIZE\"", "LOC",
  "LOCALE", "\"FUNCTION LOCALE-DATE\"", "\"FUNCTION LOCALE-TIME\"",
  "\"FUNCTION LOCALE-TIME-FROM-SECONDS\"", "\"LOCAL-STORAGE\"", "LOCK",
  "\"LOCK-HOLDING\"", "\"LONG-DATE\"", "LOWER", "LOWERED",
  "\"FUNCTION LOWER-CASE\"", "LOWLIGHT", "\"LOW-COLOR\"", "\"LOW-VALUE\"",
  "\"MAGNETIC-TAPE\"", "MANUAL", "\"MASS-UPDATE\"", "\"MASTER-INDEX\"",
  "\"MAX-LINES\"", "\"MAX-PROGRESS\"", "\"MAX-TEXT\"", "\"MAX-VAL\"",
  "MEMORY", "\"MEDIUM-FONT\"", "MENU", "MERGE", "MESSAGE",
  "\"MICROSECOND-TIME\"", "MINUS", "\"MIN-VAL\"", "\"Mnemonic name\"",
  "MODE", "MODIFY", "MODULES", "MOVE", "MULTILINE", "MULTIPLE", "MULTIPLY",
  "NAME", "NAMED", "NAMESPACE", "\"NAMESPACE-PREFIX\"", "NATIONAL",
  "\"NATIONAL-EDITED\"", "\"FUNCTION NATIONAL-OF\"", "NATIVE",
  "\"NAVIGATE-URL\"", "\"NEAREST-AWAY-FROM-ZERO\"", "\"NEAREST-EVEN\"",
  "\"NEAREST-TOWARD-ZERO\"", "NEGATIVE", "NESTED", "NEW", "NEXT",
  "\"NEXT-ITEM\"", "\"NEXT GROUP\"", "\"NEXT PAGE\"", "NO",
  "\"NO ADVANCING\"", "\"NO-AUTOSEL\"", "\"NO-AUTO-DEFAULT\"",
  "\"NO-BOX\"", "\"NO DATA\"", "\"NO-DIVIDERS\"", "\"NO-ECHO\"",
  "\"NO-F4\"", "\"NO-FOCUS\"", "\"NO-GROUP-TAB\"", "\"NO-KEY-LETTER\"",
  "\"NO-SEARCH\"", "\"NO-UPDOWN\"", "NOMINAL", "NONE", "NONNUMERIC",
  "NORMAL", "NOT", "NOTAB", "NOTHING", "NOTIFY", "\"NOTIFY-CHANGE\"",
  "\"NOTIFY-DBLCLICK\"", "\"NOTIFY-SELCHANGE\"", "\"NOT AT END\"",
  "\"NOT AT EOP\"", "\"NOT ON ESCAPE\"", "\"NOT EQUAL\"",
  "\"NOT ON EXCEPTION\"", "\"NOT INVALID KEY\"", "\"NOT ON OVERFLOW\"",
  "\"NOT SIZE ERROR\"", "\"NUM-COL-HEADINGS\"", "\"NUM-ROWS\"", "NUMBER",
  "NUMBERS", "NUMERIC", "\"NUMERIC-EDITED\"", "\"FUNCTION NUMVAL-C\"",
  "OBJECT", "\"OBJECT-COMPUTER\"", "OCCURS", "OF", "OFF", "\"OK-BUTTON\"",
  "OMITTED", "ON", "ONLY", "\"ON ESCAPE\"", "\"ON EXCEPTION\"", "OPEN",
  "OPTIONAL", "OPTIONS", "OR", "ORDER", "ORGANIZATION", "OTHER", "OTHERS",
  "OUTPUT", "\"OVERLAP-LEFT\"", "\"OVERLAP-TOP\"", "OVERLINE",
  "\"PACKED-DECIMAL\"", "PADDING", "PASCAL", "PAGE", "\"PAGE-COUNTER\"",
  "\"PAGE-SETUP\"", "PAGED", "PARAGRAPH", "PARENT", "PARSE", "PASSWORD",
  "PERFORM", "PERMANENT", "PH", "PF", "PHYSICAL", "PICTURE",
  "\"PICTURE SYMBOL\"", "PIXEL", "PLACEMENT", "PLUS", "POINTER",
  "\"POP-UP\"", "POS", "POSITION", "\"POSITION-SHIFT\"", "POSITIVE",
  "PRESENT", "PREVIOUS", "PRINT", "\"PRINT-CONTROL\"",
  "\"PRINT-NO-PROMPT\"", "\"PRINT-PREVIEW\"", "PRINTER", "\"PRINTER-1\"",
  "PRINTING", "PRIORITY", "PROCEDURE", "PROCEDURES", "PROCEED",
  "PROCESSING", "PROGRAM", "\"PROGRAM-ID\"", "\"program name\"",
  "\"PROGRAM-POINTER\"", "PROGRESS", "PROHIBITED", "PROMPT", "PROPERTIES",
  "PROPERTY", "PROTECTED", "PROTOTYPE", "PURGE", "\"PUSH-BUTTON\"",
  "\"QUERY-INDEX\"", "QUEUE", "QUOTE", "\"RADIO-BUTTON\"", "RAISE",
  "RAISED", "RAISING", "RANDOM", "RD", "READ", "READERS", "\"READ-ONLY\"",
  "\"READY TRACE\"", "RECEIVE", "RECEIVED", "RECORD", "\"RECORD-DATA\"",
  "\"RECORD-OVERFLOW\"", "\"RECORD-TO-ADD\"", "\"RECORD-TO-DELETE\"",
  "RECORDING", "RECORDS", "RECURSIVE", "REDEFINES", "REEL", "REFERENCE",
  "REFERENCES", "REFRESH", "\"REGION-COLOR\"", "RELATION", "RELATIVE",
  "RELEASE", "REMAINDER", "REMARKS", "REMOVAL", "RENAMES",
  "\"REORG-CRITERIA\"", "REPEATED", "REPLACE", "REPLACING", "REPORT",
  "REPORTING", "REPORTS", "REPOSITORY", "REQUIRED", "REREAD", "RERUN",
  "RESERVE", "RESET", "\"RESET TRACE\"", "\"RESET-GRID\"",
  "\"RESET-LIST\"", "\"RESET-TABS\"", "RETRY", "RETURN", "RETURNING",
  "REVERSE", "\"FUNCTION REVERSE\"", "\"REVERSE-VIDEO\"", "REVERSED",
  "REWIND", "REWRITE", "RF", "RH", "RIGHT", "\"RIGHT-ALIGN\"", "RIGHTLINE",
  "RIMMED", "ROLLBACK", "ROUNDED", "ROUNDING", "\"ROW-COLOR\"",
  "\"ROW-COLOR-PATTERN\"", "\"ROW-DIVIDERS\"", "\"ROW-FONT\"",
  "\"ROW-HEADINGS\"", "\"ROW-PROTECTION\"", "RUN", "S", "SAME",
  "\"SAVE-AS\"", "\"SAVE-AS-NO-PROMPT\"", "SCREEN", "\"SCREEN CONTROL\"",
  "SCROLL", "\"SCROLL-BAR\"", "SD", "SEARCH", "\"SEARCH-OPTIONS\"",
  "\"SEARCH-TEXT\"", "SECONDS", "SECTION", "SECURE", "SECURITY", "SEGMENT",
  "\"SEGMENT-LIMIT\"", "SELECT", "\"SELECTION-INDEX\"",
  "\"SELECTION-TEXT\"", "\"SELECTION-ALL\"", "\"SELF-ACT\"",
  "\"semi-colon\"", "SEND", "SENTENCE", "SEPARATE", "SEPARATION",
  "SEQUENCE", "SEQUENTIAL", "SET", "\"level-number 78\"", "SHADING",
  "SHADOW", "SHARING", "\"SHORT-DATE\"", "\"SHOW-LINES\"", "\"SHOW-NONE\"",
  "\"SHOW-SEL-ALWAYS\"", "SIGN", "SIGNED", "\"SIGNED-INT\"",
  "\"SIGNED-LONG\"", "\"SIGNED-SHORT\"", "\"level-number 66\"", "SIZE",
  "\"SIZE ERROR\"", "\"SMALL-FONT\"", "SORT", "\"SORT-MERGE\"",
  "\"SORT-ORDER\"", "SOURCE", "\"SOURCE-COMPUTER\"", "SPACE",
  "\"SPECIAL-NAMES\"", "SPINNER", "SQUARE", "STANDARD", "\"STANDARD-1\"",
  "\"STANDARD-2\"", "\"STANDARD-BINARY\"", "\"STANDARD-DECIMAL\"", "START",
  "\"START-X\"", "\"START-Y\"", "STATIC", "\"STATIC-LIST\"", "STATUS",
  "\"STATUS-BAR\"", "\"STATUS-TEXT\"", "STDCALL", "STEP", "STOP", "STRING",
  "STRONG", "STYLE", "\"SUB-QUEUE-1\"", "\"SUB-QUEUE-2\"",
  "\"SUB-QUEUE-3\"", "\"FUNCTION SUBSTITUTE\"",
  "\"FUNCTION SUBSTITUTE-CASE\"", "SUBTRACT", "SUBWINDOW", "SUM",
  "SUPPRESS", "\"SUPPRESS\"", "SYMBOLIC", "SYNCHRONIZED",
  "\"SYSTEM-DEFAULT\"", "\"SYSTEM-INFO\"", "\"SYSTEM-OFFSET\"", "TAB",
  "\"TAB-TO-ADD\"", "\"TAB-TO-DELETE\"", "TABLE", "TALLYING", "TEMPORARY",
  "TAPE", "TERMINAL", "TERMINATE", "\"TERMINAL-INFO\"",
  "\"TERMINATION-VALUE\"", "TEST", "TEXT", "THAN", "THEN", "THREAD",
  "THREADS", "THRU", "\"THUMB-POSITION\"", "\"TILED-HEADINGS\"", "TIME",
  "\"TIME-OUT\"", "TIMES", "TITLE", "\"TITLE-POSITION\"", "TO", "\"&\"",
  "\")\"", "\":\"", "\"/\"", "\".\"", "\"=\"", "\"EXTERN\"", "\"FALSE\"",
  "\"FILE\"", "\">\"", "\"INITIAL\"", "\"<\"", "\"-\"", "\"*\"",
  "\"NULL\"", "\"OVERFLOW\"", "\"(\"", "\"+\"", "\"TRUE\"", "TOP",
  "\"TOWARD-GREATER\"", "\"TOWARD-LESSER\"", "TRACK", "TRACKS",
  "\"TRACK-AREA\"", "\"TRACK-LIMIT\"", "\"TRADITIONAL-FONT\"", "TRAILING",
  "\"TRAILING-SHIFT\"", "TRANSFORM", "TRANSPARENT", "\"TREE-VIEW\"",
  "\"FUNCTION TRIM\"", "TRUNCATION", "TYPE", "TYPEDEF", "U", "\"UCS-4\"",
  "UNBOUNDED", "UNDERLINE", "UNFRAMED", "UNIT", "UNLOCK", "UNSIGNED",
  "\"UNSIGNED-INT\"", "\"UNSIGNED-LONG\"", "\"UNSIGNED-SHORT\"",
  "UNSORTED", "UNSTRING", "UNTIL", "UP", "UPDATE", "UPDATERS", "UPON",
  "\"UPON ARGUMENT-NUMBER\"", "\"UPON COMMAND-LINE\"",
  "\"UPON ENVIRONMENT-NAME\"", "\"UPON ENVIRONMENT-VALUE\"", "UPPER",
  "\"FUNCTION UPPER-CASE\"", "USAGE", "USE", "\"USE-ALT\"",
  "\"USE-RETURN\"", "\"USE-TAB\"", "USER", "\"USER-DEFAULT\"",
  "\"user function name\"", "USING", "\"UTF-8\"", "\"UTF-16\"", "V",
  "VALID", "VALIDATE", "\"VAL-STATUS\"", "\"VALIDATE-STATUS\"",
  "VALIDATING", "VALUE", "\"VALUE-FORMAT\"", "VALUES", "VARIABLE",
  "VARIANT", "VARYING", "VERTICAL", "\"VERY-HEAVY\"", "\"VIRTUAL-WIDTH\"",
  "VOLATILE", "VPADDING", "VSCROLL", "\"VSCROLL-BAR\"", "\"VSCROLL-POS\"",
  "VTOP", "WAIT", "\"WEB-BROWSER\"", "WHEN", "\"FUNCTION WHEN-COMPILED\"",
  "\"WHEN\"", "WIDTH", "\"WIDTH-IN-CELLS\"", "WINAPI", "WINDOW", "WITH",
  "\"Identifier\"", "WORDS", "\"WORKING-STORAGE\"", "WRAP", "WRITE",
  "\"WRITE-ONLY\"", "\"WRITE-VERIFY\"", "WRITERS", "X", "XML",
  "\"XML-DECLARATION\"", "\"XML-SCHEMA\"", "Y", "YYYYDDD", "YYYYMMDD",
  "ZERO", "\"level-number (Area A)\"", "\"Identifier (Area A)\"",
  "SHIFT_PREFER", "$accept", "start", "$@1", "compilation_group",
  "nested_list", "$@2", "source_element_list", "source_element",
  "simple_prog", "$@3", "program_definition", "function_definition",
  "_end_program_list", "end_program_list", "end_program", "$@4",
  "end_function", "$@5", "program_prototype", "$@6", "$@7",
  "function_prototype", "$@8", "$@9",
  "_prototype_procedure_division_header", "$@10", "control",
  "_control_division", "$@11", "_default_section", "$@12",
  "_default_clauses", "_default_accept_clause", "$@13",
  "_default_display_clause", "$@14", "_program_body", "$@15", "$@16",
  "_identification_header", "identification_header", "$@17",
  "identification_or_id", "program_id_header", "program_id_paragraph",
  "function_id_header", "function_id_paragraph", "program_id_name",
  "end_program_name", "_as_literal", "_program_type",
  "program_type_clause", "init_or_recurse_and_common", "init_or_recurse",
  "_options_paragraph", "_options_clauses", "_arithmetic_clause",
  "arithmetic_choice", "_default_rounded_clause",
  "_entry_convention_clause", "convention_type",
  "_intermediate_rounding_clause", "intermediate_rounding_choice",
  "_environment_division", "_environment_header", "environment",
  "environment_header", "_configuration_section", "_configuration_header",
  "configuration", "configuration_header", "_configuration_paragraphs",
  "configuration_paragraphs", "configuration_paragraph",
  "_source_computer_paragraph", "source_computer_paragraph", "$@18",
  "_source_computer_entry", "_with_debugging_mode",
  "object_computer_paragraph", "$@19", "_object_computer_entry",
  "object_clauses_list", "object_clauses", "object_computer_memory",
  "object_computer_sequence", "program_collating_sequence",
  "program_coll_sequence_values", "object_computer_segment",
  "object_computer_class", "locale_class", "computer_words",
  "_repository_paragraph", "repository_paragraph", "$@20",
  "_repository_entry", "repository_list", "repository_name",
  "repository_name_list", "special_names_header", "special_names_sentence",
  "special_name_list", "special_name", "mnemonic_name_clause", "$@21",
  "word_or_terminal", "mnemonic_choices", "_special_name_mnemonic_on_off",
  "on_off_clauses", "on_off_clauses_1", "alphabet_name_clause", "@22",
  "alphabet_definition", "@23", "@24", "alphabet_target_alphanumeric",
  "alphabet_target_national", "alphabet_type_alphanumeric",
  "alphabet_type_national", "alphabet_type_common",
  "alphabet_literal_list", "alphabet_literal", "@25",
  "alphabet_also_sequence", "alphabet_lits", "space_or_zero",
  "_alphnat_target", "_in_alphabet", "symbolic_characters_clause",
  "symbolic_collection", "symbolic_chars_list", "symbolic_chars_phrase",
  "char_list", "integer_list", "symbolic_constant_clause",
  "symbolic_constant_list", "symbolic_constant", "class_name_clause",
  "class_item_list", "class_item", "locale_clause", "xml_schema_clause",
  "@26", "schema_definition", "currency_sign_clause", "_with_pic_symbol",
  "decimal_point_clause", "numeric_sign_clause", "cursor_clause",
  "crt_status_clause", "screen_control", "event_status", "top_clause",
  "$@27", "_input_output_section", "input_output", "_input_output_header",
  "_file_control_header", "_file_control_sequence", "file_control_entry",
  "$@28", "$@29", "_select_clauses_or_error", "_select_clause_sequence",
  "select_clause", "assign_clause", "_assign_device_or_line_adv_file",
  "assign_device", "general_device_name", "line_seq_device_name",
  "line_adv_file", "_ext_clause", "ext_clause", "assignment_name",
  "access_mode_clause", "access_mode", "alternate_record_key_clause",
  "_password_clause", "password_clause", "$@30", "encryption_clause",
  "_suppress_clause", "collating_sequence_clause", "collating_sequence",
  "coll_sequence_values", "collating_sequence_clause_key", "alphabet_name",
  "file_status_clause", "_file_or_sort", "lock_mode_clause", "$@31",
  "lock_mode", "_lock_with", "_with_rollback", "with_rollback",
  "_with_mass_update", "organization_clause", "organization",
  "padding_character_clause", "record_delimiter_clause", "$@32",
  "record_delimiter_option", "record_key_clause", "_split_keys",
  "source_is", "split_key_list", "$@33", "split_key",
  "relative_key_clause", "reserve_clause", "no_or_integer",
  "sharing_clause", "sharing_option", "file_limit_clause", "thru_list",
  "actual_key_clause", "nominal_key_clause", "track_area_clause",
  "track_limit_clause", "_i_o_control", "i_o_control_header",
  "_i_o_control_entries", "i_o_control_list", "i_o_control_clause",
  "same_clause", "_same_option", "apply_clause",
  "obsolete_dos_vs_apply_phrase", "multiple_file_tape_clause", "$@34",
  "multiple_file_list", "multiple_file", "_multiple_file_position",
  "rerun_clause", "_on_assignment", "rerun_event",
  "_prototype_environment_division", "_prototype_special_names_paragraph",
  "_prototype_special_names_sentence_list",
  "prototype_special_names_sentence_list", "prototype_special_name_list",
  "prototype_special_name", "_data_division", "$@35",
  "_data_division_header", "data", "data_division_header", "tok_file",
  "_file_section_header", "_file_description_sequence", "file_description",
  "file_description_entry", "$@36", "file_type",
  "_file_description_clause_sequence", "file_description_clause",
  "block_contains_clause", "_records_or_characters", "record_clause",
  "_record_depending", "_from_integer", "_to_integer",
  "label_records_clause", "value_of_clause", "file_id", "valueof_name",
  "data_records_clause", "linage_clause", "_linage_sequence",
  "linage_lines", "linage_footing", "linage_top", "linage_bottom",
  "recording_mode_clause", "recording_mode", "u_or_s", "code_set_clause",
  "_for_sub_records_clause", "report_clause", "report_keyword",
  "rep_name_list", "communication", "_communication_section", "$@37",
  "_communication_description_sequence", "communication_description", "cd",
  "communication_description_entry", "$@38",
  "_communication_description_clause_sequence",
  "communication_description_clause", "_input_cd_clauses",
  "named_input_cd_clauses", "named_input_cd_clause",
  "unnamed_input_cd_clauses", "_output_cd_clauses", "output_cd_clauses",
  "output_cd_clause", "_i_o_cd_clauses", "named_i_o_cd_clauses",
  "named_i_o_cd_clause", "unnamed_i_o_cd_clauses", "working_storage",
  "_working_storage_section", "$@39", "_record_description_list", "$@40",
  "record_description_list", "data_description", "$@41", "level_number",
  "_filler", "_entry_name", "user_entry_name", "_const_global",
  "lit_or_length", "con_source", "fp32_usage", "fp64_usage", "fp128_usage",
  "pointer_len", "renames_entry", "_renames_thru", "condition_name_entry",
  "$@42", "_user_entry_name", "constant_entry", "$@43", "constant_source",
  "constant_78_source", "constant_expression_list", "constant_expression",
  "_data_description_clause_sequence", "data_description_clause_sequence",
  "data_description_clause", "redefines_clause", "like_clause",
  "_length_modifier", "length_modifier", "same_as_clause",
  "typedef_clause", "_strong", "external_clause", "_as_extname",
  "_global_clause", "global_clause", "special_names_clause", "$@44",
  "special_names_target", "select_when_clause", "$@45", "when_choice",
  "format_clause", "format_choice", "volatile_clause", "picture_clause",
  "$@46", "_pic_locale_format_or_depending_on_or_byte_length",
  "_is_locale_name", "locale_name", "type_to_clause", "usage_clause",
  "usage_clause_screen_report", "_usage_is", "usage_screen_report",
  "usage", "_to_program_type", "_to_type_name", "conflict_usage",
  "_object_reference_type", "_factory_of", "_only", "double_usage",
  "long_double", "_font_name", "_layout_name", "sign_clause",
  "byte_length_clause", "report_occurs_clause", "report_occurs_step",
  "occurs_clause", "_occurs_from_integer", "_occurs_to_integer",
  "_occurs_integer_to", "_occurs_depending", "_capacity_in",
  "_occurs_initialized", "_occurs_keys_and_indexed", "$@47", "occurs_keys",
  "occurs_key_list", "occurs_key_field", "ascending_or_descending",
  "_occurs_indexed", "occurs_indexed", "occurs_index_list", "occurs_index",
  "justified_clause", "synchronized_clause", "_left_or_right",
  "blank_clause", "based_clause", "value_clause", "value_table_item_list",
  "value_table_item", "value_from_subscripts_is_are", "from_subscripts",
  "_to_subscripts", "from_to_subscripts", "_repeated_phrase",
  "repeated_phrase", "subscripts", "value_is_are", "value_item_list",
  "value_item", "value_clause_report", "value_clause_condition", "$@48",
  "value_item_list_in_alphabet", "value_item_condition_list",
  "value_item_condition", "_false_or_content_validation", "false_is",
  "content_validation", "valid_or_invalid", "_when_condition",
  "validate_status_clause", "when_error_choice", "_on_choice",
  "default_clause", "x_or_none", "class_clause", "class_option",
  "destination_clause", "present_when_clause", "invalid_when_clause",
  "any_length_clause", "external_form_clause", "identified_by_clause",
  "local_storage", "_local_storage_section", "$@49", "linkage",
  "_linkage_section", "$@50", "_report_section", "$@51", "$@52",
  "_report_description_sequence", "report_description", "$@53", "$@54",
  "_report_description_options", "report_description_option",
  "control_clause", "control_field_list", "control_final_tag",
  "control_identifier_list", "control_identifier", "page_limit_clause",
  "page_line_column", "page_limit_cols", "integer_or_zero_or_ident",
  "_page_heading_list", "page_detail", "heading_clause", "first_detail",
  "last_heading", "last_detail", "footing_clause",
  "_report_group_description_list", "report_group_description_entry",
  "$@55", "_report_group_options", "report_group_option", "type_is_clause",
  "type_option", "_control_heading_final", "_or_page",
  "_control_footing_final", "next_group_clause", "next_group_plus",
  "next_page", "sum_clause_list", "_reset_clause", "data_or_final",
  "present_when_condition", "present_absent", "_page_or_id", "page_or_ids",
  "data_varying_clause", "data_varying_list", "data_varying", "_var_from",
  "_var_by", "line_clause", "line_keyword_clause", "_line_clause_options",
  "line_clause_option", "column_clause", "col_keyword_clause",
  "_orientation", "_left_right_center", "col_or_plus",
  "column_integer_list", "column_integer", "source_clause",
  "group_indicate_clause", "_screen_section", "$@56", "$@57",
  "_screen_description_list", "screen_description_list",
  "screen_description", "$@58", "$@59", "$@60", "_screen_options",
  "screen_option", "screen_value_clause", "_value_is",
  "control_definition", "control_type_name", "control_type",
  "control_item", "_control_attributes", "control_attributes",
  "control_attribute", "control_style", "control_property",
  "control_style_name", "control_property_name",
  "control_style_name_generic", "control_property_name_generic",
  "control_style_name_label", "control_property_name_label",
  "control_style_name_entry_field", "control_property_name_entry_field",
  "control_style_name_push_button", "control_property_name_push_button",
  "control_style_name_check_box", "control_property_name_radio_button",
  "control_style_name_list_box", "control_property_name_list_box",
  "control_style_name_combo_box", "control_style_name_frame",
  "control_property_name_frame", "control_style_name_tab_control",
  "control_property_name_tab_control", "control_style_name_bar",
  "control_property_name_bar", "control_property_name_bitmap",
  "control_style_name_grid", "control_property_name_grid",
  "control_style_name_tree_view", "control_property_name_tree_view",
  "control_property_name_web_browser", "control_style_name_activex",
  "control_property_name_activex", "control_style_name_date_entry",
  "control_property_name_date_entry", "control_style_type",
  "control_property_type", "changeable_control_properties",
  "changeable_control_property", "changeable_window_properties",
  "changeable_window_property", "eol", "eos", "_plus", "plus",
  "plus_tokens", "minus", "minus_tokens", "control_size",
  "control_size_unit", "_cell", "screen_line_number",
  "_screen_line_plus_minus", "screen_col_number", "_screen_col_plus_minus",
  "screen_occurs_clause", "screen_global_clause",
  "_prototype_data_division", "_procedure_division", "procedure_division",
  "$@61", "$@62", "$@63", "$@64", "_procedure_using_chaining", "$@65",
  "$@66", "procedure_param_list", "procedure_param", "_procedure_type",
  "_size_optional", "using_size_clause", "size_is_integer", "_acu_size",
  "_procedure_optional", "_procedure_returning", "_procedure_declaratives",
  "$@67", "$@68", "$@69", "_procedure_list", "procedure", "$@70",
  "proc_name", "section_header", "$@71", "_use_statement",
  "paragraph_header", "invalid_statement", "_segment", "statement_list",
  "@72", "@73", "statements", "$@74", "statement", "$@75",
  "accept_statement", "$@76", "accept_body", "$@77", "$@78",
  "accp_identifier", "field_with_pos_specifier", "$@79", "_pos_specifier",
  "pos_specifier", "pos_specifier_value", "identifier_or_numeric_literal",
  "_accept_clauses", "accept_clauses", "accept_clause",
  "accept_from_screen_clauses", "accept_from_screen_clause",
  "lines_or_number", "at_line_column", "@80", "@81", "line_number",
  "column_number", "mode_is_block", "accp_attr", "_key_dest", "key_dest",
  "no_echo", "reverse_video", "update_default", "_end_accept",
  "add_statement", "$@82", "add_body", "_add_to", "_end_add",
  "allocate_statement", "$@83", "allocate_body", "_loc",
  "_allocate_returning", "alter_statement", "$@84", "alter_body",
  "alter_entry", "_proceed_to", "call_statement", "$@85", "call_body",
  "$@86", "_conv_linkage", "@87", "conv_linkage_option", "_mnemonic_conv",
  "mnemonic_conv", "program_or_prototype", "_id_or_lit_or_func_as",
  "nested_or_prototype", "call_using", "$@88", "call_param_list",
  "call_param", "_call_type", "call_returning", "return_give",
  "null_or_omitted", "call_exception_phrases", "_call_on_exception",
  "call_on_exception", "_call_not_on_exception", "call_not_on_exception",
  "_end_call", "cancel_statement", "$@89", "cancel_body", "cancel_list",
  "id_or_lit_or_program_name", "close_statement", "$@90", "close_body",
  "close_files", "_close_option", "close_window", "$@91",
  "_close_display_option", "compute_statement", "$@92", "compute_body",
  "_end_compute", "commit_statement", "continue_statement", "@93",
  "_continue_after_phrase", "$@94", "destroy_statement", "$@95",
  "destroy_body", "delete_statement", "$@96", "delete_body",
  "delete_file_list", "_end_delete", "disable_statement", "$@97",
  "enable_disable_handling", "_enable_disable_key", "communication_mode",
  "display_statement", "$@98", "display_body", "screen_or_device_display",
  "display_list", "display_atom", "$@99", "disp_list",
  "_with_display_attr", "display_attrs", "display_clauses",
  "display_clause", "_display_upon", "display_upon", "crt_under",
  "display_erase", "$@100", "display_pos_specifier",
  "field_or_literal_or_erase_with_pos_specifier", "$@101",
  "field_or_literal_or_erase_list", "field_or_literal_or_erase",
  "display_message_box", "$@102", "_display_message_clauses",
  "display_message_clauses", "display_message_clause", "display_window",
  "$@103", "$@104", "sub_or_window", "display_floating_window", "$@105",
  "$@106", "display_initial_window", "$@107", "initial_type", "_graphical",
  "_upon_window_handle", "window_handle", "display_window_clauses",
  "display_window_clause", "shadow", "boxed", "_top_or_bottom",
  "_left_or_centered_or_right", "no_scroll_wrap", "pop_up_or_handle",
  "pop_up_area", "handle_is_in", "disp_attr", "control_source",
  "_end_display", "divide_statement", "$@108", "divide_body",
  "_end_divide", "enable_statement", "$@109", "entry", "entry_statement",
  "$@110", "$@111", "entry_body", "evaluate_statement", "$@112",
  "evaluate_body", "evaluate_subject_list", "evaluate_subject",
  "evaluate_condition_list", "evaluate_case_list", "end_evaluate",
  "evaluate_case", "when_other", "evaluate_other", "when",
  "evaluate_when_list", "evaluate_object_list", "evaluate_object",
  "_evaluate_thru_expr", "_end_evaluate", "exhibit_statement", "$@113",
  "exhibit_body", "$@114", "_changed", "_named", "_erase",
  "exhibit_target_list", "exhibit_target", "exit_statement", "$@115",
  "exit_body", "goback_exit_body", "free_statement", "$@116", "free_body",
  "generate_statement", "$@117", "generate_body", "goto_statement",
  "$@118", "go_body", "_goto_depending", "goback_statement", "$@119",
  "if_statement", "$@120", "else", "if_else_statements", "_if_then",
  "if_true", "if_false", "_end_if", "initialize_statement", "$@121",
  "initialize_body", "_initialize_filler", "_initialize_value",
  "_initialize_replacing", "initialize_replacing_list",
  "initialize_replacing_item", "initialize_category",
  "_initialize_default", "initiate_statement", "$@122", "initiate_body",
  "inquire_statement", "$@123", "inquire_body", "inspect_statement",
  "$@124", "inspect_body", "_backward", "send_identifier",
  "inspect_format_variant", "examine_statement", "$@125",
  "examine_format_variant", "$@126", "examine_tallying_keyword",
  "examine_replacing_keyword", "_examine_tallying_replacing",
  "single_character_value", "inspect_tallying", "$@127",
  "inspect_replacing", "inspect_converting", "tallying_list",
  "tallying_item", "replacing_list", "replacing_item", "rep_keyword",
  "replacing_region", "inspect_region", "inspect_before", "inspect_after",
  "json", "json_generate_statement", "$@128", "json_generate_body",
  "$@129", "$@130", "_json_suppress", "json_suppress_list",
  "json_suppress_entry", "_end_json", "json_parse_statement", "$@131",
  "json_parse_body", "_with_detail", "merge_statement", "$@132",
  "modify_statement", "$@133", "modify_body", "_end_modify",
  "move_statement", "$@134", "move_body", "multiply_statement", "$@135",
  "multiply_body", "_end_multiply", "open_statement", "$@136", "open_body",
  "open_file_entry", "_open_exclusive", "open_mode", "_open_sharing",
  "_open_option", "lock_allowing", "open_lock_option", "allowing_option",
  "allowing_all", "open_option_sequential", "osvs_input_mode",
  "perform_statement", "$@137", "perform_body", "$@138", "$@139",
  "_end_perform", "end_perform_or_dot", "perform_procedure",
  "_perform_option", "perform_test", "cond_or_exit",
  "perform_varying_list", "perform_varying", "_by_phrase",
  "purge_statement", "$@140", "raise_statement", "$@141", "raise_body",
  "exception_name", "read_statement", "$@142", "read_body", "_read_into",
  "_lock_phrases", "ignoring_lock", "advancing_lock_or_retry",
  "_retry_phrase", "retry_phrase", "retry_options", "_extended_with_lock",
  "extended_with_lock", "_read_key", "read_handler", "_end_read",
  "ready_statement", "receive_statement", "$@143", "receive_body",
  "message_or_segment", "_data_sentence_phrases", "_no_data_sentence",
  "no_data_sentence", "_with_data_sentence", "with_data_sentence",
  "_end_receive", "release_statement", "$@144", "release_body",
  "reset_statement", "return_statement", "$@145", "return_body",
  "_end_return", "rewrite_statement", "$@146", "rewrite_body",
  "_with_lock", "with_lock", "_end_rewrite", "rollback_statement",
  "search", "search_statement", "$@147", "$@148", "search_body",
  "search_all_body", "_search_varying", "_search_at_end", "end_pos_token",
  "search_whens", "search_when", "_end_search", "end_search_pos_token",
  "send_statement", "$@149", "send_body", "send_body_mcs",
  "message_tag_data_item", "_from_identifier", "from_identifier",
  "send_body_cd", "with_indicator", "_replacing_line", "set_statement",
  "$@150", "set_body", "on_or_off", "up_or_down", "set_environment",
  "set_attr", "set_attr_clause", "set_attr_one", "set_to", "set_up_down",
  "set_to_on_off_sequence", "set_to_on_off", "set_to_true_false_sequence",
  "set_to_true_false", "set_last_exception_to_off", "set_thread_priority",
  "sort_statement", "$@151", "sort_merge_body", "@152", "_sort_key_list",
  "_key_sort_list", "_sort_duplicates", "_sort_collating", "sort_input",
  "sort_output", "start_statement", "$@153", "start_body",
  "_sizelen_clause", "_start_key", "start_op", "not_equal_op",
  "_end_start", "stop", "stop_statement", "$@154", "stop_returning",
  "_status_x", "stop_argument", "stop_literal", "string_statement",
  "$@155", "string_body", "string_items", "$@156", "string_item_list",
  "string_item", "_string_delimited", "string_delimiter", "_with_pointer",
  "_end_string", "subtract_statement", "$@157", "subtract_body",
  "_end_subtract", "suppress_statement", "$@158", "_printing",
  "terminate_statement", "$@159", "terminate_body", "transform_statement",
  "$@160", "transform_body", "unlock_statement", "$@161", "unlock_body",
  "unstring_statement", "$@162", "unstring_body", "_unstring_delimited",
  "unstring_delimited_list", "unstring_delimited_item", "unstring_into",
  "unstring_into_item", "_unstring_into_delimiter", "_unstring_tallying",
  "_end_unstring", "validate_statement", "$@163", "validate_fields",
  "use_statement", "$@164", "use_phrase", "use_file_exception",
  "_use_global", "use_file_exception_target", "use_for_debugging",
  "debugging_list", "debugging_target", "_all_refs", "use_at_start_end",
  "program_start_end", "use_before_reporting", "use_after_exception",
  "use_exception_list", "use_exception", "use_ex_keyw", "write_statement",
  "$@165", "write_body", "from_option", "write_option", "before_or_after",
  "write_handler", "_end_write", "xml", "xml_generate_statement", "$@166",
  "xml_generate_body", "$@167", "$@168",
  "_with_encoding_xml_dec_and_attrs", "with_encoding_xml_dec_and_attrs",
  "with_encoding_xml_dec_and_attr", "encoding_xml_dec_and_attr",
  "_xml_gen_namespace", "_xml_gen_namespace_prefix", "_xml_name_of",
  "identifier_name_list", "identifier_is_name", "_json_name_of",
  "json_identifier_name_list", "json_identifier_is_name", "_type_of",
  "identifier_type_list", "identifier_is_type", "_xml_type", "ml_type",
  "_xml_gen_suppress", "xml_suppress_list", "xml_suppress_entry",
  "xml_suppress_generic_opt", "xml_suppress_when_list", "_end_xml",
  "xml_parse_statement", "$@169", "xml_parse_body", "$@170",
  "_with_encoding", "_returning_national", "_validating_with",
  "schema_file_or_record_name", "_accept_exception_phrases",
  "_accp_on_exception", "accp_on_exception", "escape_or_exception",
  "_accp_not_on_exception", "accp_not_on_exception",
  "not_escape_or_not_exception", "_common_exception_phrases",
  "_common_on_exception", "common_on_exception",
  "_common_not_on_exception", "common_not_on_exception",
  "on_size_error_phrases", "_on_size_error", "on_size_error",
  "_not_on_size_error", "not_on_size_error", "_on_overflow_phrases",
  "_on_overflow", "on_overflow", "_not_on_overflow", "not_on_overflow",
  "return_at_end", "read_at_end", "_at_end_clause", "at_end_clause",
  "_not_at_end_clause", "not_at_end_clause", "at_eop_clauses",
  "_at_eop_clause", "at_eop_clause", "_not_at_eop_clause",
  "not_at_eop_clause", "_invalid_key_phrases", "invalid_key_phrases",
  "_invalid_key_sentence", "invalid_key_sentence",
  "_not_invalid_key_sentence", "not_invalid_key_sentence", "_thread_start",
  "_thread_handle", "thread_reference_optional", "_scroll_lines",
  "_count_in", "condition", "expr", "partial_expr", "$@171", "expr_tokens",
  "expr_token", "condition_no_is", "expr_no_is", "partial_expr_no_is",
  "$@172", "expr_tokens_no_is", "expr_token_no_is", "_not_expr",
  "not_expr", "condition_or_class", "eq", "gt", "lt", "ge", "le",
  "exp_list", "_e_sep", "exp", "exp_term", "exp_factor", "exp_unary",
  "exp_atom", "line_linage_page_counter", "arithmetic_x_list",
  "arithmetic_x", "record_name", "file_or_record_name", "table_name",
  "file_name_list", "file_file_name_list", "file_name", "cd_name",
  "report_name", "mnemonic_name_list", "mnemonic_name", "entry_name_list",
  "entry_name", "procedure_name_list", "procedure_name", "label",
  "integer_label", "reference_list", "reference", "_reference",
  "single_reference_list", "single_reference", "optional_reference_list",
  "optional_reference", "reference_or_literal", "undefined_word",
  "undefined_word_but_no_error", "unique_word", "target_x_list",
  "target_x", "_x_list", "x_list", "x", "call_x", "x_common",
  "length_of_register", "report_x_list", "expr_x", "arith_x",
  "arith_nonzero_x", "alphanumeric_literal", "numeric_literal",
  "non_numeric_literal", "nonzero_numeric_literal", "prog_or_entry",
  "alnum_or_id", "simple_display_value", "inspect_from", "inspect_to",
  "simple_value", "simple_all_value", "id_or_lit", "id_or_lit_or_func",
  "id_or_lit_or_length_or_func", "num_id_or_lit", "positive_id_or_lit",
  "pos_num_id_or_lit_or_zero", "pos_num_id_or_lit", "from_parameter",
  "sub_identifier", "table_identifier", "sub_identifier_1",
  "display_identifier", "numeric_identifier", "identifier_or_file_name",
  "identifier_field", "type_name", "identifier", "identifier_1",
  "identifier_list", "validate_for_identifier_list", "for_identifier",
  "target_identifier", "target_identifier_1", "target_identifier_single",
  "data_name_without_sub_or_refmod", "display_identifier_or_alphabet_name",
  "qualified_word", "unqualified_word", "$@173", "unqualified_word_check",
  "subref", "refmod", "integer", "symbolic_integer",
  "unsigned_pos_integer", "integer_or_zero", "class_value",
  "figurative_constant", "literal", "basic_literal", "basic_value",
  "zero_spaces_high_low_values", "function", "func_no_parm",
  "func_one_parm", "func_multi_parm", "func_refmod", "func_args",
  "trim_args", "length_arg", "$@174", "numvalc_args", "locale_dt_args",
  "formatted_datetime_args", "formatted_time_args", "not_const_word",
  "flag_all", "flag_duplicates", "_flag_initialized",
  "_flag_initialized_to", "_to_init_val", "_flag_next", "_flag_not",
  "flag_optional", "flag_rounded", "round_mode", "round_choice",
  "flag_separate", "_from_idx_to_idx", "_dest_index", "error_stmt_recover",
  "verb", "scope_terminator", "_dot", "dot_or_else_end_of_file_control",
  "level_number_in_area_a", "dot_or_else_end_of_file_description",
  "dot_or_else_end_of_communication_description",
  "dot_or_else_end_of_report_description",
  "dot_or_else_end_of_report_group_description",
  "dot_or_else_end_of_record_description", "file_control_end_delimiter",
  "file_description_end_delimiter", "record_description_end_delimiter",
  "_dot_or_else_area_a", "_advancing", "_after", "_are", "_area", "_areas",
  "_as", "_at", "_before", "_binary", "_box", "_by", "_character",
  "_characters", "_collating", "_contains", "_controls", "_control",
  "_data", "_end_of", "_every", "_file", "_for", "_from", "_in",
  "_in_equal", "_in_order", "_index", "_indicate", "_initial", "_into",
  "_is", "_is_equal", "_is_are", "_is_are_equal", "_is_in", "_key",
  "_line", "_line_or_lines", "_limits", "_lines", "_lock", "_message",
  "_mode", "_new", "_number", "_number_or_numbers", "_of", "_on",
  "_on_for", "_onoff_status", "_other", "_others", "_procedure",
  "_program", "_protected", "_record", "_records", "_right", "_sign",
  "_signed", "_sign_is", "_size", "_standard", "_status", "_symbolic",
  "_tape", "_terminal", "_then", "_times", "_to", "_up", "_when",
  "_when_set_to", "_with", "_with_for", "_exception", "at_end",
  "on_escape", "on_exception", "column_or_col", "columns_or_cols",
  "column_or_cols", "column_or_col_or_position_or_pos", "comp_equal",
  "exception_or_error", "file_limit_or_limits", "in_of", "label_option",
  "line_or_lines", "lock_records", "object_char_or_word_or_modules",
  "records", "reel_or_unit", "size_or_length", "length_of",
  "track_or_tracks", "using_or_varying", "detail_keyword", "ch_keyword",
  "cf_keyword", "ph_keyword", "pf_keyword", "rh_keyword", "rf_keyword",
  "control_keyword", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_int16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,   744,
     745,   746,   747,   748,   749,   750,   751,   752,   753,   754,
     755,   756,   757,   758,   759,   760,   761,   762,   763,   764,
     765,   766,   767,   768,   769,   770,   771,   772,   773,   774,
     775,   776,   777,   778,   779,   780,   781,   782,   783,   784,
     785,   786,   787,   788,   789,   790,   791,   792,   793,   794,
     795,   796,   797,   798,   799,   800,   801,   802,   803,   804,
     805,   806,   807,   808,   809,   810,   811,   812,   813,   814,
     815,   816,   817,   818,   819,   820,   821,   822,   823,   824,
     825,   826,   827,   828,   829,   830,   831,   832,   833,   834,
     835,   836,   837,   838,   839,   840,   841,   842,   843,   844,
     845,   846,   847,   848,   849,   850,   851,   852,   853,   854,
     855,   856,   857,   858,   859,   860,   861,   862,   863,   864,
     865,   866,   867,   868,   869,   870,   871,   872,   873,   874,
     875,   876,   877,   878,   879,   880,   881,   882,   883,   884,
     885,   886,   887,   888,   889,   890,   891,   892,   893,   894,
     895,   896,   897,   898,   899,   900,   901,   902,   903,   904,
     905,   906,   907,   908,   909,   910,   911,   912,   913,   914,
     915,   916,   917,   918,   919,   920,   921,   922,   923,   924,
     925,   926,   927,   928,   929,   930,   931,   932,   933,   934,
     935,   936,   937,   938,   939,   940,   941,   942,   943,   944,
     945,   946,   947,   948,   949,   950,   951,   952,   953,   954,
     955,   956,   957,   958,   959,   960,   961,   962,   963,   964,
     965,   966,   967,   968,   969,   970,   971,   972,   973,   974,
     975,   976,   977,   978,   979,   980,   981,   982,   983,   984,
     985,   986,   987,   988,   989,   990,   991,   992,   993,   994,
     995,   996,   997,   998,   999,  1000,  1001,  1002,  1003,  1004,
    1005,  1006,  1007,  1008,  1009,  1010,  1011,  1012,  1013,  1014,
    1015,  1016,  1017,  1018,  1019,  1020,  1021,  1022,  1023,  1024,
    1025,  1026,  1027,  1028,  1029,  1030,  1031,  1032,  1033,  1034,
    1035,  1036,  1037,  1038,  1039,  1040,  1041,  1042,  1043,  1044,
    1045,  1046,  1047,  1048,  1049,  1050,  1051,  1052,  1053,  1054,
    1055,  1056,  1057,  1058,  1059,  1060,  1061,  1062,  1063,  1064,
    1065,  1066,  1067,  1068,  1069,  1070,  1071,  1072,  1073,  1074,
    1075,  1076,  1077,  1078,  1079,  1080,  1081,  1082,  1083,  1084,
    1085,  1086,  1087,  1088,  1089,  1090,  1091,  1092,  1093,  1094,
    1095,  1096,  1097,  1098,  1099,  1100,  1101,  1102,  1103,  1104,
    1105,  1106,  1107,  1108,  1109,  1110,  1111,  1112,  1113,  1114,
    1115,  1116,  1117,  1118,  1119,  1120,  1121,  1122,  1123,  1124,
    1125,  1126,  1127,  1128,  1129,  1130,  1131,  1132,  1133,  1134,
    1135,  1136,  1137,  1138,  1139,  1140,  1141,  1142,  1143,  1144,
    1145,  1146,  1147,  1148,  1149,  1150,  1151,  1152,  1153,  1154,
    1155,  1156,  1157,  1158,  1159,  1160,  1161,  1162,  1163,  1164,
    1165,  1166,  1167,  1168,  1169,  1170,  1171,  1172,  1173,  1174,
    1175,  1176,  1177,  1178,  1179,  1180,  1181,  1182,  1183,  1184,
    1185,  1186,  1187,  1188,  1189,  1190,  1191,  1192,  1193,  1194,
    1195,  1196,  1197,  1198,  1199,  1200,  1201,  1202,  1203,  1204,
    1205,  1206,  1207,  1208,  1209,  1210,  1211,  1212,  1213,  1214,
    1215,  1216,  1217,  1218,  1219,  1220,  1221,  1222,  1223,  1224,
    1225,  1226,  1227,  1228
};
#endif

#define YYPACT_NINF (-4283)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-3474)

#define yytable_value_is_error(Yyn) \
  0

  /* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
   -4283,  1632,  1495, -4283, -4283, -4283,  1342, -4283,  1069, -4283,
    1537,   114,  1133, -4283,  1763,  1267, -4283, -4283,  1384, -4283,
   -4283, -4283, -4283, -4283,    45, -4283, -4283,  2171, -4283, -4283,
    1964,  1993, -4283, -4283, -4283, -4283, -4283, -4283,  1436,  1069,
    1451,  1069,  2100,  1923, -4283,  2225,  2253, -4283,  2038,  3946,
    1725, -4283,  1267,  2266,   -78,  2217,   -78,  2231,  1267, -4283,
    1534,  1788,  2251, -4283, -4283,  1696,  2364, -4283, -4283, -4283,
    1873,  2303,   185,   185,  1839,  1875,  1923,  1923,  1923,   185,
    1893,  1267,  1267,  1923,  1267,  1267,   369, -4283, -4283, -4283,
     185, -4283,  3946, -4283, -4283, -4283, -4283, -4283, -4283,   251,
   -4283, -4283, -4283, -4283, -4283,  2257, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,  1267, -4283,
   -4283, -4283, -4283, -4283,  2644, -4283, -4283,  2217, -4283,  2644,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,  2172,  1923,
    2262,  1603, -4283,  1949, -4283,  1267,  1267,  1267, -4283, -4283,
   -4283, -4283,  1075,  1923, -4283,  1923,  1738,  2551,  1738,  1923,
    1923, -4283, -4283,  1738, -4283, -4283, -4283,  1749,   -52,  1923,
   -4283, -4283, -4283, -4283, -4283,  1871,   237, -4283, -4283,  1967,
    2239,   894,  1590, -4283,   939,  1590, -4283,  1923,    74,  2001,
    1267, -4283, -4283, -4283, -4283,  1267,  1163, -4283, -4283, -4283,
     928,  1075, -4283,  1923,   642,  1738,  2269,    15, -4283, -4283,
   -4283, -4283,  2275,  1868,   778,    24, -4283,  1806, -4283,  1749,
   -4283,  1923,  1808,   185,  1085, -4283, -4283, -4283, -4283, -4283,
    2006,   -32,  1923,   179, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283,  1901, -4283,  1909,   901, -4283, -4283,  1267, -4283,  2112,
    1267,   328, -4283, -4283, -4283, -4283,  1923, -4283,  2529,  7959,
   12570, -4283, -4283, -4283,  1817, -4283,    34,   191,  1267, -4283,
   -4283, -4283,   277, -4283, -4283, -4283,   650,  2022, -4283, -4283,
   -4283,  -190, -4283, -4283,  1738, -4283,  2013, -4283,  2000, -4283,
    1923, -4283, -4283,   305, -4283, -4283, -4283, -4283, -4283,   808,
    2658,  2651,   161,  1833, -4283,   225, -4283, -4283,    58, -4283,
     235, -4283,  1808, -4283,   166, -4283, -4283,  2136, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,  1939,
   -4283,   -32, -4283,  2359,   185,   185, -4283,  2006,   203, -4283,
    -258, -4283,  1267, -4283, -4283,  2150, -4283,  2641, -4283,  1267,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
    1563,   475, -4283, 14921, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283,  2438, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283,  1169, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283,  2780, -4283, -4283, -4283, -4283, -4283,  1332, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,  1500, -4283,
   -4283, -4283, -4283, -4283,  2052,  2656, -4283,   494,  1222, -4283,
   -4283, -4283,  1028,  1752, -4283,  2224,  1638, -4283,   330, -4283,
   -4283, -4283, -4283, -4283, -4283,  1923,  1923, -4283, -4283, -4283,
    2149, -4283,  1969, -4283, -4283, -4283,  2193, -4283, -4283, -4283,
    1923,  2334, -4283, -4283, -4283, -4283,   839,  1923, -4283, -4283,
    2055,  2389, -4283,  2644,  1338,  2644,  1965, -4283, -4283,  1970,
    2611, -4283, -4283, -4283, -4283, -4283,  2345, -4283,  2136,   185,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283,  2600, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283,  1879, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,  -216,  6059,
   20536,   850,   475,   195,  -414,   482,  2819,  1231,   177,  1111,
   12385, 18798,  1111,  1631,  4881,  2716,  1717,   482,  1738,  1987,
      30, 10038,   482,  1886,    46,  2777,  1738,    46, 17717, 18798,
    2083,  2531,   -66,  1894,    41,  1902,  1894,  1738,  1902,  1306,
    -398,   401,  1738,  1902, -4283,  8662,  2209,  1886,  1738,  1902,
    8174,  1738,  1306,   475,  2496, -4283, -4283, -4283,  1738, -4283,
   -4283, -4283, -4283, -4283,  1738, -4283, -4283, -4283, -4283, -4283,
   -4283,  1992, -4283, -4283,   181,  1627, -4283,  2113,  2368,  1749,
    1749,  1749,   141,  1627,   -51, -4283, -4283, -4283,  -137, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283,  2270, -4283,   185,
    2224,  1987,  1987,  2280,  2224,  2224,  1987,  2224,  2224,  1987,
    2224,  2224,  2007, -4283,  2557,   888, -4283, -4283, -4283,  2837,
     739, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,  1588,
    2324, -4283, -4283,  2022,  2396,  2334, -4283, -4283,   898,   119,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,  2363, -4283,
    2345, -4283, -4283, -4283,  1923, -4283,  2023,  1763,  1763, -4283,
      98, -4283,  1324,  2619, -4283, 20727,  2012,  2374,  2514,  2280,
   -4283, -4283, -4283,  1738, -4283, -4283,  2018,  2019,  2021, -4283,
   -4283,  2025,    15,    15,  2026,  2027,  2028, -4283, -4283,  2030,
      15, -4283, -4283, -4283,  1738,  2034, -4283,  2021, -4283,  2643,
   -4283, 17884, -4283, -4283,  9160, -4283, -4283, -4283,  2036,  2037,
    2040, -4283, 21577, 21577, 20536, 21577, -4283,   120,   487, -4283,
    2583, -4283, -4283,  9160, -4283, -4283,  2487, -4283,  1870,  1939,
   -4283, -4283,   850, -4283,  2058, -4283,    15, -4283,  2652,   -66,
   -4283, -4283, -4283, -4283,  1005, -4283, -4283, -4283, -4283, -4283,
    1902, -4283,  1071,  2280,  2653, -4283,   455, -4283,  2190, -4283,
   -4283,  1992,  1939, -4283, -4283,  1902,  2655,  2249,  2747, -4283,
   -4283,  1738,  2090,  2092, -4283, -4283, -4283,  1894, -4283,  2541,
   -4283,  1748,  2839, -4283, -4283, -4283, -4283, -4283,  2666,  1642,
   18053, -4283, -4283, -4283, -4283,  1979,  2012, -4283, -4283, -4283,
   -4283, -4283,  2541, 17218,  1824,  1863,  2757,  2668,  1291, -4283,
   -4283, -4283,  2669,   173, -4283, -4283, -4283, 17467,  -264, -4283,
   -4283, -4283, -4283, -4283,  2416, -4283, -4283,  2744,    30, -4283,
   -4283, -4283,   482, -4283, -4283, -4283, -4283, -4283,  2654, -4283,
     -35, -4283, 18798, -4283, -4283,  2104, -4283, -4283,   308, -4283,
    1886, -4283, -4283,  1738, 16245,   -67, -4283,  1120, -4283, -4283,
    4881, -4283, -4283, -4283,  2077, 15461,   -67,  2675, 18798, -4283,
    2097,  2679,  2857, -4283, -4283,  1934, -4283,    86, -4283, -4283,
   12982,  2114, -4283, -4283,  2002, -4283, -4283,  2682,  1658,  2683,
     876, -4283,  2592, -4283,  2684,  2249,  2008,  2685, -4283,  2592,
   18798, -4283,  2686, -4283,  2601,  9160,  2660, -4283, -4283, -4283,
   -4283, -4283, -4283,  2460, -4283,   482, -4283, -4283, -4283,  2337,
     914, -4283,   451,  2934, -4283,   171, -4283,  2698,  1944,  2703,
    2560, 18798,  1738,  1738,  2710, 18195, -4283, -4283,  1886, -4283,
   -4283,  2863, -4283, -4283,  1891, -4283,  2715,  2781, -4283, -4283,
    1738, -4283,  2722,  2592,  2528, -4283,  2631,  1738,  1738,  1738,
    2730,  2080, -4283, 10457, -4283, 20536,  2151, -4283,  1738,  1738,
   -4283,   200, -4283, -4283,  -228, -4283, -4283, -4283,  8484, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,  1267,
   -4283,  2265,  2539, -4283, -4283, -4283,  2326,  1627, -4283, -4283,
   -4283,  8886,  2853, -4283, -4283,  2145, -4283, -4283,  1738,  1738,
    2334, -4283,  2334,  1902,  1902,  2334,  1902,  1902,  1738,  1902,
    1902, -4283,  2191, -4283,  1199, -4283, -4283, -4283, -4283,  2664,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283,  1105, -4283,   232, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283,    96, -4283, -4283, -4283, -4283,
   -4283, -4283,  2070, -4283,   722, -4283, -4283, -4283,  -374,  1923,
   -4283,  1964, -4283, -4283,   196, -4283, -4283,  2313, -4283, -4283,
   20727,   825, -4283, -4283,  1923, -4283, 20727, -4283, -4283, -4283,
    2554,  2181, 21184,    89,  1738, -4283,  2846,  2838,    -9,  2178,
   20536, 20536, 19853,  2036, -4283,  2081,  2082, 20536, 20536, 20536,
    9160,  2084,  2182,  9160,  2036, -4283, -4283, 18940,  2657, -4283,
   -4283,  1939, -4283, 20536, -4283,  9160, 20536, -4283, -4283,  1615,
   -4283,  2620, 20536, 20536, 20536, 20536, 20536, 20536, 20536, 20536,
   20536, 20536, 20536, 20536, -4283,  1939, -4283, -4283,  2555, -4283,
    2402,  2565, -4283, -4283,  8174, -4283,  1738,  1071, -4283, -4283,
   -4283,  1800,   824,  1738, -4283, -4283, -4283, -4283, -4283, 20536,
    2536, -4283,  2151, -4283, 20536,   183, -4283, -4283, -4283, -4283,
    2341, -4283, -4283, -4283, -4283, -4283, -4283,   -82,  1979, -4283,
    2101, -4283, 18798, -4283, -4283, -4283, -4283, -4283, -4283,  2485,
     102, -4283, -4283, -4283, 17218,   438,  6809, -4283,  1958,  2153,
    2110,  1642,  1642,  1642,  1642, 18053, -4283, -4283, 18798, 18940,
   -4283, -4283, -4283,  1631, -4283, -4283,  2115, -4283,  5991,    22,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
     792, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, 16741,
   -4283, -4283, -4283,  3618,   207, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283,  2576,    21,  2748, -4283, -4283, -4283,  2809,  2094,
    2727, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283,   909, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,  2334,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283,   909, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, 16245, -4283,
     909,   909,   909,   -67, -4283,   433,   197, 20536, -4283, -4283,
     -59, 11792, -4283, -4283,   231, 19327,   -67, -4283, -4283,  2214,
     482, -4283, -4283, 18940, -4283, -4283, -4283, -4283, -4283,  2297,
    2280, -4283,  1551, -4283,  2677,  2677,   687,  2226,   375,  2222,
   -4283,   735, -4283, -4283,  2240, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283,  2249, -4283, -4283, -4283, -4283,  2646,  4881, -4283,
   -4283, -4283,  2649, -4283, -4283, -4283,  2341,  2601, -4283,  1738,
    2126,   254,  2229, -4283, -4283,  1939, -4283,  2234, -4283, -4283,
     445,  2235,  2006, -4283, -4283,  5456, -4283,  2991,   795,   193,
   -4283, -4283, -4283,  1923, -4283,   837, -4283, -4283,  1738, 18798,
   -4283,  2871,  2723,  2726, -4283, -4283, 18940, -4283,  2729, -4283,
   -4283, -4283, -4283, -4283,  2999,  2670, -4283, -4283, -4283,  2320,
    1879,  2255,  2830,  2740,  2830,  2680,  2730,   380, -4283, -4283,
    1738,   380, 18798, -4283, -4283,  1196,   104,  1732, 20536, -4283,
    2824,  2745,  2824,     7, -4283, -4283, -4283,   176,    34, -4283,
    1267, -4283,  2369,  2419,  1693,  1504, -4283, -4283,  2264, 19521,
    1504,  2952,  1923,  1905,  1905,  1923,    81,  2172,  1923,  3092,
    2542, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283,  2173, -4283,  1860,  8526,  1738, -4283,  2224,  2224,  1699,
    1902, -4283,  1902,  2224,  1902,  1902,  2224,  1902,  1902, -4283,
    2952,  2280,  2280,  2454,  1902, -4283, -4283, -4283,  1105, -4283,
   -4283, -4283, -4283,    15, -4283,  1923,  1923,  2180, -4283,  -374,
    2350,  2253,  2253, -4283, -4283, -4283,  2661,   217,   217,  -176,
   -4283,  1976, -4283, -4283, -4283, -4283,  3055, -4283,  2674,  1218,
     930, -4283,  1923, -4283, -4283, -4283, -4283, -4283,  1923,  1890,
   -4283,   930, -4283,  1923, -4283, -4283, -4283, -4283, -4283,   145,
   -4283, -4283, -4283,    95, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283,    35, -4283, -4283, -4283,  3133, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283,  2705,  2371,   980, -4283,  2998,  1734, -4283,
   -4283, -4283, -4283, -4283,  1976, -4283, -4283, -4283,  2185,  2187,
   -4283,  9160,  1976,  2711,  2355,  2357,  2580, -4283, -4283, -4283,
   -4283, -4283, -4283,  2639, -4283, -4283, -4283, -4283, -4283, -4283,
    1002, -4283,  1738,   128,  1736,  2310,   216,  2311, -4283,   429,
   -4283,   836,  9160, -4283, -4283,   400,  2312,  2314,  2315,   434,
   -4283,  1939, -4283,  2317, -4283,  1738,   444,  2318, -4283,  2280,
    2789,   945, -4283,   335,   302,   482,  1735,  2321,   486, -4283,
    2325,  2555,   487,   487, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283,  2334,  2467,  2332,   850, -4283, -4283,
     -65,  3134,   861, -4283, -4283,  2458,  2493,  2648, -4283,  1375,
    1923, -4283, -4283,  1413, -4283, -4283,  2301,    51, -4283, -4283,
   -4283,  2746, -4283, -4283, 18798, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283,   640, -4283, -4283,  6690, -4283, -4283,  5501,   -59,
   -4283, -4283, -4283, -4283,   910, -4283,  1923,  1923, -4283,    44,
     -59, -4283, -4283, -4283, -4283,    67,  1923, -4283, -4283, -4283,
    6809, -4283, -4283,  1958, -4283, -4283,  1939,  1738, -4283, -4283,
   -4283, -4283, -4283, -4283,  1642,  2808,   945,  2813, -4283,  2596,
   -4283,    61, -4283, -4283, -4283, -4283, -4283,  3168, -4283,  2356,
   -4283, -4283, -4283,  5991,  2233,  3618, -4283, -4283, -4283, -4283,
   -4283,  1987, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283,  2858,  1013,   192,  2012, -4283,  1175, -4283,
    2224, -4283, -4283, -4283, -4283, -4283,  2935, -4283,  1987, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283,  2507,  1987, -4283, -4283,
   -4283,  1738, -4283, -4283,  1738, -4283,  1738,  1738,  1738, -4283,
    1760,   340, -4283, -4283,  2511, -4283, -4283,   271,  1720,  2965,
   -4283, -4283,  1006, -4283, -4283, -4283, -4283, 18263, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283,   482,   482,   945,  2834,  2126,  2341,   375,  2801, 16674,
      32,  9858,  1738,   850,  2361, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283,  2320,  2649,  1738, -4283, -4283, -4283,
   -4283,  1738,   312,   820,  2503, -4283,  2320,    17,  9160,  2636,
    1649,   844, -4283,  2280,  1002,  2640, -4283, -4283, -4283, 18798,
    2006,  2006,  2006,  2006,  2006,  2006,  2006,  2006,   795, -4283,
     946,    51,   905,   766, -4283,  2999, -4283,  1738,  1738,   945,
    2845,  1760, -4283,  3207,  1738,   944, -4283, -4283,  2341,  3212,
    2307,  2750, -4283, -4283,  1738, -4283,  1738, -4283, -4283, -4283,
    2285, -4283, -4283, -4283,  2290, -4283,  2441,  2441, -4283, -4283,
   -4283, 20536, 20021,  1732, -4283, -4283,  1738, -4283,  2535,  2983,
    2334, -4283, -4283, -4283, -4283,  1267, -4283,  2519,  1923,  3092,
    3714, -4283,  2331, -4283,  2883,  1738, -4283,   -10, -4283,  2316,
    1923,  1923,  1923,   585,  2323,  2543,  1738,  1803, -4283,  2327,
    1738,  3225,  2328,  2832,   -15,  1987,  1923,  1923,  1210,   346,
    2329, -4283, -4283, 19682, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, 15244, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283,  3714, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283,  1116,   863,  1555,
    2889, -4283,  2334,   237,   300,   300,  2333,   831,  1041,  2334,
    2336,  1923, -4283, -4283, -4283,   109, -4283,  2173, -4283, -4283,
   -4283,   739, -4283,  9530, -4283,  1902,  1902, -4283, -4283,  2224,
   -4283,  1902,  1902,  1902,   846,  1902, -4283,  1902,  1105, -4283,
    2070, -4283, -4283, -4283, -4283,  2483, -4283,  2539,  2642,  2642,
   -4283,   230, -4283,  -299,   908,   230, -4283, -4283,   176, -4283,
   -4283, -4283, -4283, -4283,  2109,  1738,    80, -4283, -4283, -4283,
   -4283,  2704, -4283, -4283, -4283, -4283, -4283, -4283,  2704, -4283,
   -4283, -4283, -4283,   825, 20536,  1042, -4283,   825, -4283, -4283,
   -4283,  1923,  1006, -4283,  1006, -4283,   930,  2801,  1923,  2428,
     830,  2805,  2805, -4283, -4283, -4283,  1976, -4283, -4283, -4283,
   -4283, -4283, -4283,   223, -4283, -4283, -4283, -4283,  2190,  7312,
    2036, 20169,  2036, -4283,  2433,  2036, -4283,  1738,  2036,  2036,
    2036,  9160,  2036,  2190,   891,  2036,    -9, -4283, -4283, -4283,
    2717,  2509,   372,  2911,   945, 20369,  2036,  2036,  1235, -4283,
    2467, -4283,   482, -4283, -4283, -4283,  2677, -4283, -4283, -4283,
   -4283, -4283,  2751, -4283, -4283,  2575, -4283,   328, -4283, -4283,
   20536, -4283, -4283, -4283, -4283,  2724,  2864,  1048,  2153,  1066,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
     825, -4283, -4283,   825,  1042, -4283, -4283, -4283, -4283,  1076,
    3037,   825,  1006,  1006, 20536, -4283, -4283, -4283,  3448,  3448,
   -4283,   482, -4283,   482, -4283, -4283, -4283, -4283,  5991, -4283,
   -4283,  3168, -4283, -4283, -4283, -4283, -4283,  3203, -4283, -4283,
   -4283,  2960,  1013,  3001, -4283, -4283, -4283,  1738, -4283, -4283,
   -4283,  2809,  2377,  2140,   452,  2378, -4283, -4283, -4283, -4283,
   -4283,  2457, -4283, -4283,  1939, -4283,  3213, -4283, -4283, -4283,
     769, -4283,  1760,  2618, -4283, -4283, -4283,  2548, -4283, -4283,
    2711,    27, -4283, -4283, -4283, 18798, -4283,   482, -4283,   482,
     671,  1902, -4283,  1738, -4283, -4283,    49, -4283, -4283, -4283,
    3298, -4283,  2947, -4283, -4283, -4283,   297,   151, -4283, -4283,
   -4283,  2752,   380, -4283,    51, -4283,  1927,  1738,  2622, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
     430, -4283, 18798, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283,    18, -4283,  1738, -4283, -4283,  1764, -4283,
   -4283, -4283, 20536,  -183,  2692, 18389,  2190,  2190, -4283,   482,
    2468, -4283,  2731, -4283,  9160, -4283,  3100,  2494, -4283,   820,
   -4283,  1016, -4283, -4283, -4283,  3141,    19, -4283, -4283, 10038,
   -4283,  2290, -4283, 18798, 18798,  1736, -4283,  1634,  3141,  2802,
    2398,  9160,  2472, -4283,  3221,    34, -4283,  2587, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283,  2488, -4283, -4283,  3714, -4283,  1923, -4283,  2497, -4283,
   -4283, -4283,  2367,  1895, 18531,   482, -4283, -4283, -4283,  3139,
   11185, -4283, -4283,  2473, -4283,  3240,  2455,  2499,  1429, 11185,
   -4283, -4283,  1738, -4283, -4283, -4283, -4283, -4283,  2390, 15600,
     482,  2484,  3714,  2484,  3714,  2985,  2329, -4283, -4283, -4283,
    -334,   783,  1311,  1369,  1408,  3339, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283,  1987,  3899, -4283, -4283, -4283,   802,   761,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283,  2373, -4283,  3317, -4283,  2999, -4283,  2552,  2599,
    2599,  2408, -4283,  3714, -4283,  2512,  3006, -4283, -4283, -4283,
    2333, -4283, -4283, -4283, -4283, -4283, -4283,  2890,   122,  2801,
    1246,  1923, -4283, -4283,  1923, -4283, -4283,  2172,  2711,  2249,
    1987, -4283, -4283, -4283, -4283,  2604,  2711,  1923,  3243,   314,
     405,    37,  2126, -4283, -4283,  1923,  1923, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283,  2567, -4283,  2884, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283,  2610,  3307,   300,  1902,  1902,  1902,  1902,
    1902,  1902, -4283,  2755, -4283, -4283,  3351, -4283, -4283,    78,
    1301,  1412,  2678, -4283, -4283,  2217,  2231, -4283,  1923,  2603,
    2787, -4283, -4283, -4283, -4283,  3170, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, 20536, 20536, -4283,  1736,
   -4283, -4283, -4283, -4283, -4283,  1048, -4283,  2137, -4283, -4283,
    1738,   844, -4283, -4283,  2532, -4283, -4283, -4283,  1923,  1098,
   -4283, -4283,   895, -4283, -4283, -4283, -4283,  2036, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283,  3018, -4283, -4283, -4283,  3010,
   -4283, -4283, -4283, -4283, -4283, -4283,  3013, -4283, -4283,  1651,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283,  1879,  3161, -4283,
   -4283,  -293, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
     -59,   -59,   -59,   -59, 18798, -4283,  1066, -4283,  7070, -4283,
   -4283, -4283, -4283, -4283,  2280, -4283, -4283, -4283,  1736, -4283,
   -4283,  1712, 20536,  2837, -4283, -4283, -4283, 10988, -4283, -4283,
   -4283,   384, -4283, -4283, -4283, -4283,  5848, 10988,   945,  2706,
     945,  2707, -4283, -4283,  1013, -4283,  2696, -4283,  1235, -4283,
   -4283, -4283, -4283,  2140, -4283,  3139, -4283, -4283,  1987, -4283,
    1235,  9160, -4283, -4283,  3297, -4283,  2353, -4283, -4283,  2618,
   -4283,  2353,  3036,  3039,   337,  1302, -4283,  2804, -4283, -4283,
   18672,   945,  2803,  2803,  2814, -4283,  1489, -4283,  3131, -4283,
   -4283, -4283,  1738, 18798,  2224,  2919,  2964, -4283,  1182, -4283,
   -4283, -4283,  1031, -4283, -4283, -4283,  3210,  2866, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283,  2924, -4283, -4283,  2945, -4283,
    2280,  2280, -4283, -4283, -4283, -4283, -4283, -4283, -4283,  1736,
   -4283, -4283, -4283,  2849,  2556,  1923, -4283, -4283, -4283,   895,
    3018,   945,  1235,  3207, -4283,  2801,  3141,  2801,  -183,  1798,
   -4283, -4283,  2142,   188,  2801, -4283,  2901,  3201, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,  2126,  2784,
   -4283,  2515, -4283, -4283,   185,    34, -4283,    34,  1267,  2681,
     221,   182, -4283,  1177,  1738, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,   482, -4283,
   -4283, -4283, -4283, -4283, -4283, 17285,  2951, -4283, -4283,  2801,
    3066,  2591,  2334,  2591,  2334,  2224,  -100, -4283, -4283, -4283,
   -4283, 10626, -4283, -4283, -4283,  2759, -4283, -4283,  2316,  2966,
    1923,  2373,  2987,  3092,  3714, -4283,  2550, 21641,  3354, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283,  3073,  4850, -4283,  2390, -4283,  2810,  -107, -4283,
   -4283, -4283,  2971, -4283,  1048,  1140, -4283, -4283,  3243, -4283,
   -4283, -4283,  3714, -4283,  2334,   218,  1738, -4283, -4283, -4283,
   -4283,  2334, -4283,  2000, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283,  1073,  1073,  1923,  1923,  2711,   227, -4283,  1923,
    1628,  1923,  1923,  1923,  1923, -4283,  2630, -4283,   671,  1041,
    2334,  1923,  2172,  1350, -4283,  2693,  1041,  1902, -4283,  2334,
   -4283,  1105,  2933,  3436, -4283, -4283, -4283, -4283,  1412,    82,
   -4283, -4283, -4283,  3224, -4283, -4283,  1465,  1923, -4283, -4283,
    2510, -4283, -4283, -4283,  1736,  1736, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283,   844, -4283, -4283, -4283,  3048,  3242, -4283,
    2307, -4283, -4283, -4283,  3448, 18798, 18798, 18798, 18798, -4283,
   -4283, -4283, -4283, -4283,  1738,  1736,   -59, -4283, -4283, -4283,
   -4283,  2617,  -343, -4283, -4283,   482, -4283,   482, -4283,  3373,
   -4283,  1004, -4283, -4283, -4283, -4283, -4283,  3374,  3256,  2353,
   -4283, -4283,  2353,  1235,  2612,  2612, -4283,  3458,  3406, -4283,
   -4283, -4283,  2835,  1902,  1675, -4283,   770,   237,  1738, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283,   199, -4283, -4283, -4283,
   -4283, -4283,  2936, -4283,  1151, -4283, -4283,  2937,  1516, -4283,
   -4283, -4283,  3383,  2992, -4283,  1923,  1396, -4283, -4283,   811,
    2993,  2997, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283,  1902,  1902, -4283, -4283, -4283, -4283, -4283, -4283,
    1738, -4283,  3242, -4283, -4283, -4283,  1738, -4283,  1738, -4283,
   -4283, -4283, -4283, -4283,  2920,  3190, -4283, -4283, -4283, -4283,
    5726, -4283,  7046,    65,  1738,  2901,  2280,  2671, -4283, -4283,
   -4283,   163,  1314,  2848, -4283, -4283,  2633, -4283, -4283, -4283,
   -4283,  1267, -4283,  2728, -4283, -4283, -4283,   376,  2647, -4283,
    2280, -4283,  3714, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, 17285, -4283,  2107, -4283, -4283, -4283,  2662,  2538,  2334,
    2650, -4283,  3274, -4283,  3277, -4283,  1738,  2720,  2553, -4283,
   -4283, -4283,   189,  2917,  1232,   527, -4283, -4283, -4283, -4283,
   -4283,  2739,  2484,  2659, -4283, -4283, 21641, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283,  1128, -4283, -4283,  3024,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283,  2591,  3250, -4283, -4283,
    2709, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283,  1738,   115,  2863,  1719, -4283, -4283, -4283, -4283,   568,
    1738,  1923, -4283, -4283,  3509, -4283,  1738, -4283, -4283,  1041,
   -4283,  1738,  1738, -4283, -4283, -4283, -4283,  2863,  1699,  1738,
    1923,  1738, -4283,  1041,  2687, -4283, -4283,  1923,  1923,   137,
   -4283, -4283,    98, -4283, -4283, -4283,  1237,   781,   176, -4283,
   -4283, -4283,   844,  3048,   895,    23, 10988, -4283, -4283, -4283,
   -4283, -4283,  1738,   -59, -4283, -4283,   895,   895,  1013, -4283,
   -4283, -4283, -4283, 18798, -4283, -4283, -4283,  2353, -4283, 18798,
   18798, -4283, -4283,  1923,  1902,  1902,  2873, -4283,  1923,  1923,
     237, -4283, -4283,  2923, -4283, -4283, -4283, -4283, -4283, -4283,
    2806, -4283, -4283, -4283, -4283,  6308,  2621, -4283,  1738, -4283,
   -4283,  2752,   380, -4283, -4283, -4283, -4283, -4283, -4283,   895,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   18798, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,  2671,
    1738,  1738,  1642,  2995,   163, -4283,   178,  2570, -4283, -4283,
    1923,  1915, -4283, -4283, -4283, -4283,  2688, -4283, -4283,  2579,
    1923,  1738, -4283, -4283, -4283, -4283, -4283, -4283,  2334,  3107,
    2224,  2224,   350, -4283,  1923, -4283, -4283,  2280, -4283, -4283,
    1439,   154,  3173, -4283,  3227, -4283,  2966, -4283,  2484, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283,  1041,  1041, -4283, -4283, -4283, -4283,  3177,
    3314, -4283,  2512,  2334, -4283, -4283, -4283, -4283, -4283,  1738,
   -4283, -4283, -4283, -4283,  3174, -4283, -4283, -4283, -4283,  3523,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283,  1213,  1517, -4283,
   -4283, -4283, -4283, -4283,   136,  -308, -4283, -4283, -4283,  1738,
     317,  1923,  2702,  1041, -4283, -4283, -4283,  2313, -4283, -4283,
    3041, -4283,   184,  2690,   844, -4283,    16,   270, -4283, 18798,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283,   850,  1902,  1923,
     237,   237, -4283, -4283, -4283, -4283,  9160, -4283, -4283, -4283,
   -4283, 10038, -4283, -4283, -4283, -4283, -4283, -4283, -4283,  1738,
   -4283,  1923,  1738, -4283, -4283, -4283,  1923,  3026, -4283, -4283,
    9160, -4283, -4283, -4283,   850, -4283, -4283, -4283, -4283, -4283,
   -4283,  2380, -4283, -4283, -4283, -4283,  2002,  2904,  3338,  1605,
    2886,   757, -4283, 10038, -4283,   221, -4283, -4283,   350,  1738,
    1738,  2999, -4283,  3137, -4283,  1720,  2711,  1900,  2334, -4283,
   -4283,  2967, -4283, -4283, -4283,  1738, -4283, -4283, -4283, -4283,
   -4283,  3512,  2224, -4283,  2863, -4283,  -308,  1738,  2007, -4283,
   -4283, -4283, -4283,  1738, -4283, -4283, -4283, -4283, -4283,  1923,
   -4283,  2944, -4283, -4283, -4283,   885,   752,   885, -4283,   237,
    1041, -4283, -4283, -4283,  1267,  2778,   123,   844, -4283, -4283,
   -4283, -4283,  2990,    26, -4283,  2280, -4283, -4283, -4283, -4283,
   -4283,  1738, -4283, -4283,   850,    78,  1301, -4283,  1939, -4283,
   -4283,  1642, -4283,   776, -4283,  9160,  2280,  2676, -4283, -4283,
    2862,  2769,  2708,  2002, -4283,    76,  2224, -4283, -4283, -4283,
     799, -4283, -4283,  9357, -4283, -4283,   757,  2713, -4283, -4283,
   -4283,   350, -4283, -4283, -4283, -4283,  1923,  1720, -4283, -4283,
   -4283,  1738, -4283, -4283,  1041,  1738,  3314,    11, -4283, -4283,
   -4283, -4283, -4283,    11, -4283,  1738,  1738,   915, -4283, -4283,
    2841, -4283,  3071, -4283, -4283, -4283, -4283,  1923, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283,  1738, -4283, -4283,
    3046,  3540, -4283, -4283, -4283,  3049,  1738,  2280,  2754,  1642,
    1738, -4283,  1295,  1902,  2718, -4283, -4283, -4283, -4283,   180,
     869,  1896,  1886,  2719,  2463,  2734, -4283, -4283,  2180, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283,  2944,  1400,  1923,
   -4283, -4283, -4283, -4283, -4283,  3004, -4283, -4283,   930,  3365,
   -4283,  1923,  1923,  1923, -4283,  1738, -4283,  1923,  1738,   283,
   -4283, -4283, -4283, -4283, -4283,  2940, -4283,  1902,  1729,   180,
   -4283, -4283,   130,  3140,  3150,  3359,  3135, -4283,   869, -4283,
    1714,   967, -4283, -4283, -4283,  3065, -4283, -4283,  2180, -4283,
    2779, -4283,  3352,  1738,  1661, -4283, -4283,   237,   237,  9160,
   -4283,   235,  1738, -4283,  1923,  1331,   689,   283, -4283, -4283,
    1642, -4283,  2224, -4283, -4283, -4283,  3016,  1738, -4283,  1923,
    3019,  1738,  1923,  1923,  1923,  1923, -4283,  3155,    87,  3157,
   -4283,  3145, -4283,  2079, -4283, -4283,  1738,  3427,  1483,  3165,
     100,  3166,  3151, -4283,   854, -4283, -4283,  1738,  2785,   211,
   20919,  1006, -4283, -4283, -4283,  2673, -4283, -4283, -4283,  1913,
   -4283, -4283,  1144,   176, -4283, -4283, -4283, -4283, -4283,   355,
   -4283, -4283, -4283,   355,   355, -4283, -4283, -4283, -4283, -4283,
   -4283,  3028, -4283, -4283, -4283,  1000, -4283, -4283,  1738,  2334,
   -4283,  1738,  1738,  1738,  1738,  1923,  1923,  1923,  1923,  1923,
   -4283,  1738,  1923,  1923,  1923,  1923,  1923,  1923,  1923,  1923,
    1923,  1923,  1923, -4283,  1738,  1923,  1627,  2175, -4283,  1923,
   -4283, -4283, -4283, -4283,  1009, -4283,  2704,  2704,  1923,  1923,
     -59,    44,  1923,  4881, -4283, -4283, -4283, -4283,  2704,   -59,
   -4283,  3371,  2334, -4283,  3501, -4283, -4283, -4283,   -59, -4283,
   -4283,  1738, -4283, -4283,  1923,  1738,  1923, -4283, -4283,   108,
   -4283, -4283, -4283, -4283, -4283,  2136, -4283, -4283, -4283, -4283,
    3246,  2704, -4283, -4283, -4283, 13312,   155,  1144, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283,   689, -4283, -4283, -4283, -4283,
   -4283,  1902, -4283,  2591, -4283, -4283, -4283, -4283,  1738,  1738,
    1738,  1738,  1738,  1738,  1738,  1738,  1738,  1738,  1738,  1738,
    1738,  1738,  1738,  1738,  1738,  1738,  1738, -4283, -4283,   300,
     300,  2205, -4283, -4283, -4283, -4283,  3248,  3495,   -56,   825,
   -4283, -4283, -4283,  1923, -4283,  1923,   825,  1042,  1006, -4283,
   -4283,   825, -4283, -4283,   825,  2591,  1923,  1006, -4283,   255,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283,  1939, -4283, -4283,
   -4283, 14205,  2136, -4283, -4283, -4283, -4283, -4283,  3137, -4283,
   -4283, -4283, -4283, -4283,  1738, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283,  1738, -4283, -4283, -4283,
     300,   300,   912,   245, -4283,  1923, -4283, -4283,  1738,  1738,
   -4283, -4283, -4283,  1509,  1509, -4283, -4283, -4283, -4283, -4283,
   -4283,   591, -4283,  1048, -4283, -4283, -4283, 21279, -4283, -4283,
   -4283,  1738,  1738, -4283, -4283, -4283, -4283, -4283,  2033, -4283,
   -4283, -4283,  4535, -4283,  1048,  1738, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283,   825, -4283, -4283,   825, -4283,
   -4283, -4283, -4283, -4283,  1738, -4283,  1906,  1040,  1127, -4283,
   -4283,   912,  1627, -4283, -4283, -4283, -4283, -4283,  1738,  2319,
    1923,  1923,  2267,  1923, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283,  2238, -4283, -4283, -4283,  1738, -4283, -4283,  1923,   912,
     912, -4283,  3236,  1923,  1923,   912,  4862,  1738,   912, -4283,
   -4283, -4283,   912,   912, -4283, -4283, -4283, -4283,  3214,  2120,
    3092,  1923,  2334, -4283,  1923,  2280,  -108, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283,  3714, -4283, -4283, -4283, -4283, -4283,
   -4283,   233, -4283, -4283,  1567, -4283,  1074, -4283, -4283, -4283,
   -4283, -4283,  2120,  1738, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283,   300, -4283,  1782,  2650, 21641, 21641,  2476,  3714,  3095,
    3095,  2383, 10038, -4283, -4283,  1567,  -149, -4283, -4283, -4283,
    2334,  -149, -4283,   374, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283,  2334, -4283,  2591,  2190, 21130, -4283, -4283,   138,  2087,
   -4283, -4283,  2102, -4283, -4283, -4283, -4283,  1180,  1180, -4283,
   -4283, -4283, -4283, -4283,  1110,  1110,  3095,  3095, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283,   300, -4283, -4283,  3277,
   -4283,  2224,  1738, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283,    33,   164, -4283, -4283, -4283,  1110, -4283, -4283,
    3030,  3031, -4283,  2826,    66, -4283,  3044, -4283,  3044, -4283,
    3044, -4283,  3044, -4283, -4283, -4283,  2334, -4283, -4283, -4283,
   -4283,  3038, -4283, -4283, -4283, -4283, -4283, -4283
};

  /* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_int16 yydefact[] =
{
       2,     0,    14,     1,     3,     5,    36,     4,    79,    35,
       0,    53,     0,    15,   102,  3250,    58,    57,    53,     8,
      10,    11,    12,    13,     0,    54,    55,    82,   104,    50,
     107,     0,   103,  3249,    37,     9,    61,    59,     0,    79,
       0,    79,     0,  3341,    80,    88,   489,   109,   284,   111,
       0,   108,  3250,    39,     0,    18,     0,     0,  3250,  3342,
       0,     0,    90,   491,    51,   494,     0,   490,   283,   101,
       0,   286,     0,     0,     0,  3408,  3341,  3341,  3341,     0,
       0,  3250,  3250,  3341,  3250,  3250,  3303,   196,   280,   195,
       0,   106,   112,   113,   115,   116,   119,   117,   118,     0,
     175,   178,   193,   179,   180,   246,   181,   183,   182,   186,
     184,   185,   187,   188,   189,   190,   191,   192,  3250,   105,
      40,    38,    64,    63,    67,    22,    16,    19,    20,    67,
      24,    17,    56,    84,    85,    86,    87,    83,  3372,  3341,
      95,  1526,   493,     0,   496,  3250,  3250,  3250,   288,  2946,
    2945,   206,   243,  3341,  3409,  3341,     0,     0,     0,  3341,
    3341,   128,   159,     0,   122,   173,  3304,     0,  3321,  3341,
     267,   114,   177,   174,   176,  3341,     0,   248,   110,     0,
       0,  3341,     0,    21,  3341,     0,  3373,  3341,     0,     0,
    3250,  1522,    52,  1521,  1580,  3250,   487,   492,   285,   287,
     433,   212,  3322,  3341,     0,     0,     0,  3056,   276,  2934,
     274,   279,     0,     0,   130,   161,   278,   124,   639,   257,
     258,  3341,     0,     0,     0,  3065,  2451,  2450,   194,   200,
     203,  3387,  3341,     0,   377,   376,   373,   374,   375,   372,
     247,     0,    68,     0,     0,    66,    65,  3250,    62,     0,
    3250,     0,    92,    94,    93,    91,  3341,    81,     0,     0,
       0,   495,   502,   503,   619,   497,   622,     0,  3250,   290,
     289,   282,   436,   207,   208,   210,     0,     0,   244,   245,
     277,   272,  3468,  3469,     0,   266,     0,  3302,  3415,  3398,
    3341,   155,   129,  3397,   134,   136,   137,   138,   139,  3397,
       0,  3305,     0,     0,   160,     0,   164,   123,   126,   259,
       0,  2948,   249,   250,  3346,   253,   281,     0,  3075,  3082,
    3076,  3074,  3072,  3077,   270,  3073,   268,  3083,   269,  3078,
    3080,  3387,  3390,  3389,     0,     0,   197,   201,    42,    60,
      71,    74,  3250,    78,    77,  3397,    72,    73,    23,  3250,
      25,  3156,  3157,  3158,  3159,  3160,  3161,  3162,  3163,    89,
       0,  1804,  3276,     0,  1651,  1769,  1779,  1787,  1794,  1852,
    1860,  1881,  1876,  1882,  1891,  1887,  1899,  1909,  2044,  2053,
    2055,  2061,  2190,  2095,  2109,  2122,  2125,  2128,  2134,  2136,
    2148,  2170,  2174,  2178,  2235,  2253,  2255,  2261,  2265,  1648,
    2271,  2305,  2332,  2334,  2339,  2369,  2370,  2386,  2389,  2390,
    2395,  2404,  2405,  2423,  2440,  2481,  2499,  2518,  2537,  2553,
    2561,  2565,  3275,  2569,  2572,  2575,  2592,  2632,  2648,  3277,
    1582,  1583,  1584,  1585,  1586,  1587,  1588,  1589,  1591,  1590,
    1592,  1594,  1593,  1595,  1596,  1597,  1598,  2056,  1599,  1600,
    1602,  1603,  1604,  1605,  1606,  1607,  1608,  1609,  1610,  1611,
    1612,  1601,     0,  1613,  1614,  1615,  1616,  1617,  1618,  1619,
    1620,  1621,  1622,  1623,  1624,  1625,  1626,  1627,  1628,  1629,
    1630,  2406,  1631,  1632,  1633,  1634,  1635,     0,  1636,  1637,
    1638,  1639,  1640,  1641,  1642,  1643,  1644,  1645,     0,  1646,
    1647,  1559,  1581,   618,     0,   564,   498,  3132,     0,  2916,
     499,   435,  3149,     0,   463,  3382,   446,   434,     0,   439,
     441,   442,   454,   443,   444,  3341,  3341,   213,   214,  3070,
     246,   262,   264,  3071,  3440,   271,     0,  3057,   275,  3416,
    3341,     0,   133,   135,   131,   156,  3397,  3341,  3306,   141,
       0,     0,   171,    67,     0,    67,     0,   162,   165,     0,
       0,   260,   251,  3348,  3347,   254,     0,  3079,     0,     0,
    3388,   204,   198,   199,   202,    45,    41,    47,    76,    26,
      70,    75,    29,    97,    98,    99,   100,    96,  1809,  1812,
    1811,  1806,  1807,  1810,  1808,  1798,  1805,  3174,  3175,  3176,
    3177,  3178,  3179,  3180,  3181,  3182,  3183,  3184,  3185,  3186,
    2138,  3226,  3227,  3228,  3229,  3230,  3231,  3232,  3233,  3234,
    3235,  3236,  3237,  3238,  3239,  3240,  3241,  3242,  3243,  3244,
    3245,  3246,  3247,  3248,  3187,  3188,  3190,  3189,  3191,  3192,
    3193,  3194,  3195,  3196,  3197,  3199,  3198,  3200,  3201,  3202,
    3203,  3204,  3205,  3206,  3207,  3208,  3209,  3210,  3211,  3212,
    3213,  3214,  3215,  3216,  3217,  3218,  3219,  3220,  3170,  3221,
    3222,  3223,  3224,  3225,  3172,  1650,  3171,  3173,  1683,     0,
       0,     0,  1804,     0,     0,     0,  1884,     0,     0,  1904,
    1953,     0,  1904,  2794,     0,  2099,  2111,     0,     0,  3431,
    2118,     0,     0,     0,     0,  2181,     0,     0,     0,     0,
       0,  2276,  2781,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2540,     0,  2563,     0,     0,     0,
       0,     0,     0,  1804,     0,  2236,  2248,  2408,     0,  2521,
    2533,  2536,  2519,  2534,  2786,  2535,  2522,  2531,  2523,  2532,
    3037,  3041,  2649,  2701,  1580,     0,   563,     0,   976,   674,
       0,     0,   624,     0,   635,   628,   629,   627,     0,  3268,
    3254,  3267,  3253,  3255,   501,  3256,   504,     0,  3150,     0,
    3382,  3431,  3431,  3380,  3382,  3382,  3431,  3382,  3382,  3431,
    3382,  3382,  3319,  3383,  3317,     0,   447,   448,   449,  3284,
       0,  3265,  3264,  3266,  3263,  3251,   440,   437,  3252,     0,
       0,   261,   263,     0,     0,     0,   149,   132,  3058,  3321,
     166,   167,   170,   172,   168,   169,   163,   125,     0,  3066,
     252,   255,  3081,   205,  3341,    48,     0,   474,   474,  1799,
    1528,  1682,  3056,  1767,  1653,  1695,     0,  3370,  1681,  3380,
    3108,  3106,  3109,     0,  3102,  3110,     0,     0,  3116,  3485,
    3486,     0,  2899,  2901,     0,     0,     0,  3105,  2970,     0,
    2903,  3107,  3111,  3112,     0,     0,  3104,  3116,  3103,  1777,
    2964,  1775,  2956,  2959,     0,  2958,  2962,  2963,  3113,     0,
       0,  2971,     0,     0,     0,     0,  1780,     0,  2880,  2890,
    2892,  2896,  2980,     0,  2898,  2977,  3138,  3053,  3054,  2978,
    2979,  2931,  1788,  1789,     0,  2927,  2929,  2928,  1850,  2781,
    1855,  3009,  1859,  1853,  1854,  1856,  1858,  3008,  1872,  1861,
    1862,  1863,  1866,  3380,  1879,  3048,     0,  2905,  3152,  2951,
    3047,  3052,  2952,  1885,  1883,     0,  1897,  3401,  3309,  1888,
    3042,  1890,  3425,     0,  1906,  1908,  1900,     0,  1950,  1984,
    1983,  3082,  3297,  1930,  1982,  1975,  1981,  1974,  2042,  2726,
    2954,  1925,  1927,  1917,  1918,  1931,     0,  1919,  1920,  1971,
    1921,  1922,  1984,  1924,     0,  2958,     0,  2051,     0,  2054,
    2068,  2067,  2093,     0,  2064,  2066,  2793,  3341,     0,  2183,
    2184,  2185,  2100,  2096,  2101,  2113,  2117,  2115,  2118,  2116,
    2110,  2123,  2124,  2949,  2126,  2127,  3432,  2129,  2925,  1837,
       0,  1836,     0,  2135,  2792,  2142,  2791,  2149,  2151,  2918,
    2171,  2172,  1214,  1990,     0,     0,  2175,  1213,  2182,  2179,
       0,  2254,  2485,  3029,  3030,  3147,     0,  2259,     0,  2262,
       0,  2269,     0,  1649,  2277,  2272,  2273,     0,  3326,  2306,
    2318,     0,  2917,  2333,     0,  2335,  2337,  2367,  3144,  2384,
       0,  2387,  2635,  2908,  2393,  3401,     0,  2402,  2909,  2635,
       0,  2424,     0,  2426,  2429,     0,     0,  2921,  2441,  2442,
    2443,  2444,  2445,  2446,  2472,  2447,  2475,  2448,  2449,     0,
       0,  2919,     0,     0,  3028,  3052,  2482,  2516,  2504,  2551,
       0,     0,     0,     0,  2559,     0,  2564,  2562,  2566,  2567,
    2570,  3303,  3032,  2573,  3403,  3011,  2590,  2578,  3010,  3012,
    2593,  2594,  2646,  2635,     0,  2057,     0,     0,     0,     0,
    2420,  2412,  2911,  2524,  2785,     0,  3039,  3040,     0,     0,
    1566,     0,  1567,  1560,     0,  1561,  1562,  1565,     0,  3270,
    3272,  3271,  3269,  3273,  3274,  3260,  3261,   620,  3262,  3250,
     975,     0,   980,   675,   672,   677,     0,     0,   625,   636,
     637,     0,   638,   633,   634,  3341,  3151,   291,     0,     0,
       0,  3381,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3320,  3423,  3318,     0,   348,   471,   349,  3285,  3321,
     438,   219,   218,   239,   235,  3058,   240,   224,   238,   236,
     216,   217,   237,   209,   215,   226,   227,   229,   221,   222,
     223,   211,   220,   265,   273,     0,   152,   154,   153,   150,
     151,  2939,     0,   142,     0,  3058,   127,   256,     0,  3341,
      43,   475,    27,    30,     0,  1531,  1529,  1551,  1768,  1652,
    1695,  3292,  3294,  1700,  3341,  1679,  1696,  1697,  1699,  1701,
    1712,     0,  3311,     0,     0,  3371,     0,     0,     0,     0,
       0,     0,     0,  3113,  3122,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3113,  1778,  1770,     0,     0,  2957,
    2965,  2966,  2967,     0,  3088,     0,     0,  2895,  2894,     0,
    2893,  3140,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2981,  2982,  2983,  3139,  1783,  1790,
    1792,     0,  1851,  1795,  1815,  1857,     0,  1866,  3481,  3482,
    1864,     0,  1869,     0,  1880,  1877,  3463,  3462,  2906,     0,
    3154,  2907,  3050,  3051,     0,  2726,  1895,  1898,  1892,  3402,
    2352,  3310,  1889,  3043,  3426,  1905,  1907,  1902,  1931,  1985,
       0,  3298,     0,  2043,  1910,  3451,  1577,  3450,  1915,  2732,
    2729,  1577,  1926,  1923,  2955,  3439,     0,  1952,     0,  1986,
       0,  2726,  2726,  2726,  2726,     0,  2052,  2045,     0,     0,
    2073,  2094,  2062,  2794,  2081,  2063,  2070,  2071,     0,  1577,
    2810,  2812,  2815,  2813,  2814,  2816,  2817,  2818,  2819,  2808,
    3342,  2850,  2811,  2803,  2807,  2805,  2806,  2802,  2804,  2795,
    2796,  2809,  2798,     0,     0,  2192,  2191,  2102,  2097,  2114,
    2112,  2950,     0,  2132,  3444,  2120,  2119,  2143,  2144,  2153,
       0,  2173,  1989,  1295,  1324,  1292,  1374,  1309,  1308,  1373,
    1375,  1397,  1376,  1360,  1443,  1477,  1393,  1422,  1396,  1419,
    1465,  1368,  1391,  1387,  1394,  1417,  1463,  1294,  1297,  1404,
    1401,  1293,  1400,  1399,  1449,  1321,  1403,  1322,  1478,  1326,
    1386,  1415,  1412,  1439,  1430,  1467,  1266,  1440,  1450,  1413,
    1348,  1350,  1349,  1416,  1451,  1452,  1453,  1454,  1312,  1313,
    1442,  1405,  1407,  1406,  1411,  1346,  1427,  1320,  1429,  1436,
    1437,  1328,  1330,  1441,  1333,  1272,  1425,  3327,  1371,  1347,
    1319,  1289,  1448,  1288,  1291,  1290,  1446,  1438,  1414,  1398,
    1459,  1434,  1435,  1370,  1456,  1457,  1458,  1447,  1462,     0,
    1323,  1424,  1420,  1423,  1455,  1410,  1421,  1329,  1362,  1392,
    1388,  1384,  1395,  1418,  1460,  1461,  1428,  1331,  1332,  1296,
    1464,  1325,  1369,  1327,  1408,  1409,  1445,  1361,  1363,  1265,
    1334,  1351,  1372,  1444,  1476,  1402,  1385,  1426,  1367,  1390,
    1389,  3327,  1225,  1240,  1241,  1242,  1243,  1244,  1245,  1246,
    1247,  1248,  1249,  1250,  1251,  1252,  1253,  1254,  2176,  1482,
    3327,  3327,  3327,  2177,  1486,     0,  2489,     0,  3031,  3148,
    3343,  2257,  1217,  1219,  3349,     0,  2258,  2260,  2256,     0,
       0,  2270,  2266,     0,  2274,  2281,  2278,  2280,  2279,  2282,
    3380,  2320,  2931,  3014,  2783,  2783,     0,  2316,     0,     0,
    3013,  2928,   642,  3015,     0,  2782,  2338,  2336,  2368,  2340,
    3145,  3146,  3401,  2385,  2371,  2373,  2374,     0,     0,  2388,
    2394,  2391,  2342,  2910,  2403,  2396,  2352,     0,  2425,     0,
    3439,  2432,     0,  2998,  3003,  3004,  3005,     0,  2473,  2476,
       0,     0,     0,  2920,  2453,     0,  2452,     0,     0,  3050,
    2517,  2500,  2506,  3341,  2507,  2502,  2552,  2538,     0,  2541,
    2542,  2545,     0,     0,  2560,  2554,     0,  2568,     0,  3404,
    3405,  2574,  2591,  2576,  3299,     0,  2595,  2647,  2633,  2637,
    1798,     0,  2246,     0,  2246,     0,  2420,  2414,  2422,  2407,
       0,  2414,     0,  2520,  2526,     0,  2875,  2873,     0,  3038,
    2699,     0,  2699,  2705,  1574,  1569,  1573,     0,   622,   565,
    3250,   979,     0,   983,     0,   742,  3132,   626,     0,   776,
     640,  3307,  3341,     0,     0,  3341,  3307,  3372,  3341,  3282,
       0,   505,   508,   509,   510,   511,   512,   513,   514,   515,
     516,     0,   500,     0,     0,   450,  2932,  3382,  3382,     0,
     458,  2912,   451,  3382,   452,   460,  3382,   453,   462,  3424,
    3307,  3380,  3380,     0,     0,   225,   228,   231,     0,  3476,
    3478,  3477,   140,  3060,  3059,  3341,  3341,   143,    46,     0,
     120,  1518,  1518,  1802,  1803,  1801,     0,  1536,  1536,     0,
    1523,  2713,  3018,  1714,  3016,  3017,     0,  1698,     0,     0,
       0,  1718,  3341,  1735,  1736,  1737,  1720,  1722,  3341,  3341,
    1725,     0,  1766,  3341,  1727,  1731,  1728,  1730,  1732,     0,
    1760,  1761,  1739,  1742,  3400,  1743,  1764,  1762,  1763,  1729,
    1733,  3433,  1745,  1734,  1719,  3280,  1740,  1765,  1749,  1702,
    1738,  1744,  1748,     0,     0,     0,  2991,     0,  1690,  1694,
    1693,  1684,  1680,  1675,  2713,  3455,  3454,  1672,  1662,  1664,
    1665,     0,  2713,  3356,     0,     0,     0,  1708,  1670,  1655,
    1660,  1659,  1669,     0,  1678,  1657,  1677,  1658,  2995,  2994,
       0,  2969,     0,  2875,  2873,     0,  2875,     0,  3118,  2875,
    3100,     0,     0,  2900,  2902,  2875,     0,     0,     0,  2875,
    2974,  2975,  2976,     0,  2904,     0,  2875,     0,  3101,  3380,
    3048,  2735,  1776,  3052,  2952,     0,     0,     0,  2875,  2897,
    3142,  1783,  2879,  2878,  2883,  2884,  2885,  2886,  2887,  2888,
    2889,  2882,  2881,  2891,     0,  1785,     0,     0,  2930,  1796,
       0,  1813,  1874,  1865,  1868,     0,     0,     0,  2953,  2735,
    3341,  3153,  3049,     0,  1894,  1896,  3321,  2771,  2353,  2354,
    1901,     0,  1951,  1976,  1960,  2734,  1578,  2727,  2733,  2728,
    2730,  2731,     0,  1940,  1939,  1928,  1935,  1937,     0,  3343,
    2029,  2030,  2031,  2016,     0,  2019,  3341,  3341,  2022,  3315,
    3343,  2025,  2026,  2032,  2027,  3433,  3341,  2028,  2035,  2033,
    1932,  1933,  1959,  1954,  1955,  1957,  1958,     0,  1972,  1979,
    1913,  1914,  1911,  1912,  2726,     0,  2735,     0,  2065,  2081,
    2072,  1577,  2069,  2090,  2087,  2089,  2088,  2082,  2084,  2091,
    2076,  2074,  2075,     0,     0,  2849,  2797,  2860,  2861,  2862,
    2851,  3431,  2868,  2871,  2870,  2872,  2864,  2857,  2859,  2858,
    2863,  2865,  2867,  2869,  2799,  2852,  2853,  2854,  2855,  2856,
    2198,  2200,  2199,     0,     0,     0,  1685,  2924,  2132,  2922,
    3382,  2130,  2926,  3445,  2121,  2145,  2146,  1577,  3431,  2161,
    2162,  2164,  2166,  2167,  2163,  2165,  2156,  3431,  2152,  3328,
    3329,     0,  1224,  1481,     0,  1483,     0,     0,     0,  1487,
       0,  2222,  2206,  2180,  2187,  2188,  2189,  2491,     0,     0,
    3344,  3345,     0,  1218,  3351,  3350,  3352,     0,  1260,  1383,
    1344,  1287,  1303,  1354,  1273,  1377,  1352,  1301,  1269,  1382,
    1469,  1379,  1365,  1298,  1366,  1364,  1335,  1337,  1340,  1299,
    1353,  1307,  1356,  1305,  1345,  1342,  1258,  1357,  1378,  1267,
    1311,  1432,  1470,  1281,  1339,  1275,  1282,  1302,  1274,  1358,
    1472,  1359,  1270,  1318,  1473,  1257,  1264,  1284,  1315,  1316,
    1285,  1300,  1261,  1262,  1317,  1255,  1338,  1283,  1268,  1474,
    1341,  1380,  1263,  1468,  1431,  1475,  1433,  1286,  1304,  1336,
    1256,  1381,  1471,  1271,  1306,  1314,  1280,  1466,  1278,  1279,
    1355,  1343,  1276,  1277,  1310,  1259,  1223,  1226,  1227,  1228,
    1229,  1230,  1231,  1232,  1233,  1234,  1235,  1236,  1237,  1238,
    1239,     0,  2263,  2735,     0,  3439,  2352,     0,  3325,  2318,
    2308,     0,     0,     0,     0,   651,   647,   650,   649,   648,
     653,   850,   665,   661,   663,   664,   666,   662,   852,   851,
     654,  2992,   667,   668,   643,   657,   658,   659,   652,   655,
     656,   646,   645,  2319,     0,  2342,     0,  2636,  3025,  3026,
    3027,     0,     0,  2398,     0,  2431,  2637,     0,     0,     0,
       0,     0,  2474,  3380,     0,     0,  2478,  2477,  2469,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2455,  2456,
    3147,  2771,     0,  2549,  2543,  3299,  2544,     0,     0,  2735,
       0,     0,  3300,  3133,     0,  2549,  2642,  2641,  2352,  3278,
    1819,     0,  2247,  2237,     0,  2249,     0,  2409,  3446,  3447,
       0,  2416,  2421,  2413,     0,  2525,  3419,  3419,  2876,  2877,
    3062,     0,     0,     0,  2700,  2650,     0,  2702,  2707,     0,
    1575,  1564,   621,   567,   977,  3250,   984,  1122,  3341,  3282,
       0,   673,     0,   743,     0,     0,   632,     0,   907,  3435,
    3341,  3341,  3341,     0,     0,  3406,     0,   875,   760,     0,
       0,  3289,     0,  3413,   903,  3431,  3341,  3341,  3341,  3282,
       0,   759,   631,   776,   698,   700,   703,   701,   702,   704,
     706,   705,   721,   722,   720,   707,   709,   708,     0,   710,
     711,   712,   713,   714,   715,   716,     0,   723,   724,   725,
     728,   726,   727,   717,   718,   719,   729,     0,     0,  3289,
       0,  3308,     0,     0,  3346,  3346,     0,     0,     0,     0,
       0,  3341,   559,  3283,   560,     0,  2947,   558,   561,   506,
     507,     0,   292,  3401,  2933,     0,     0,  3487,  3488,  3382,
    2913,     0,     0,     0,     0,     0,   472,   445,     0,   230,
       0,  3058,  3058,   144,    49,     0,   121,   980,    32,    32,
    1800,  1532,  1533,  1539,     0,  1530,  1552,  1553,     0,  3449,
    2724,  2725,  3448,  1654,  2721,  1756,  2716,  1577,  2719,  2720,
    1717,  3376,  1711,  3459,  3458,  3461,  3460,  1713,  3376,  3067,
    1703,  3019,  3020,     0,     0,     0,  1726,     0,  1721,  1759,
    1747,  3341,  2787,  3434,  2787,  3281,     0,  3325,  3341,     0,
       0,     0,     0,  1676,  1661,  1663,  2713,  1673,  3357,  1666,
    1667,  1668,  1709,  3291,  1671,  2997,  2968,  2996,  3152,     0,
    3113,     0,  3113,  3117,     0,  3113,  3123,     0,  3113,  3113,
    3113,     0,  3113,  3152,     0,  3113,     0,  1577,  1577,  1771,
    2741,  2738,  3050,  3051,  2735,     0,  3113,  3113,     0,  3141,
    1785,  1784,     0,  1781,  1793,  1791,  2783,  1817,  1818,  1814,
    1816,  1873,     0,  1867,  1870,     0,  1878,     0,  1886,  2357,
       0,  1577,  1577,  1893,  2772,  2778,  2775,     0,  1986,  1962,
    1580,  1948,  1949,  1946,  1945,  1947,  1944,  1936,  1938,  1941,
       0,  2017,  2018,     0,     0,  1491,  1493,  2023,  2024,     0,
       0,     0,  2787,  2787,     0,  1934,  1956,  1987,  3439,  3439,
    1916,     0,  2046,     0,  2077,  2080,  2078,  2079,     0,  2794,
    2086,  2083,  2801,  2800,  2866,  2201,  2204,     0,  2205,  2195,
    2196,     0,     0,  2103,  1686,  2131,  2923,     0,  1577,  2147,
    2137,  2141,     0,     0,  2168,     0,  1485,  1484,  1490,  1489,
    1488,     0,  3055,  2999,  3000,  2223,     0,  2225,  2224,  2226,
    2208,  2218,     0,     0,  2186,  2492,  2483,     0,   893,   894,
    3356,  3330,  1222,  1480,  1479,     0,  1220,  2264,  2267,     0,
       0,     0,   644,     0,  2307,  1577,     0,  2325,  2321,  2326,
    2322,  2327,     0,  2317,   660,  2324,  2344,  2375,  2343,  1577,
    2392,  2760,     0,  1577,  2771,  2399,     0,     0,  2438,  2437,
    2436,  2435,  2434,  2454,  2479,  3022,  2480,  3021,  3023,  3024,
       0,  2466,     0,  2471,  2458,  2459,  2460,  2464,  2461,  2465,
    2462,  2463,  2457,  3148,  2515,     0,  2513,  2508,     0,  2501,
    3484,  3483,     0,  2744,     0,     0,  3152,  3152,  2555,     0,
       0,  3134,  2579,  2580,     0,  2583,  2586,  2588,  2584,  2398,
    3279,     0,  1820,  2060,  2059,  2789,  2251,  2794,  1577,     0,
    2410,  2417,  3420,  2529,  2529,  2874,  3063,     0,  2789,     0,
    2709,     0,     0,  1576,   566,   622,   981,     0,  1123,   488,
     928,   929,   693,   695,   694,   688,   692,   690,   691,   687,
     689,   686,   940,   934,   936,   937,  3341,   744,   670,   971,
     972,  3436,     0,     0,     0,     0,   756,   757,   758,  3313,
       0,  3407,   901,   732,  3035,   879,     0,   873,   762,     0,
     730,  3290,     0,   751,  3414,   904,   905,   902,     0,     0,
       0,     0,     0,     0,     0,  1097,  1093,  1094,   699,   782,
    3410,  3410,  3410,  3410,  3410,   783,   785,   786,   787,   790,
     791,   792,   793,   795,   794,   797,   834,   831,   829,   830,
     832,   833,   796,  3431,   803,   798,   835,   799,   839,   837,
     814,   815,   813,   817,   818,   816,   836,   770,   788,   789,
     686,   932,   922,   930,   740,   973,  3299,   745,   737,  3164,
    3164,     0,   676,     0,   641,   528,   556,  3479,  3480,  2942,
     537,  2940,  3471,  3470,   530,  2944,  2943,  3366,  3303,  3325,
       0,  3341,   534,   533,  3341,   562,   294,  3372,  3356,  3401,
    3431,   359,  3466,  3467,   398,     0,  3356,  3341,  3301,  3356,
     400,     0,  3439,   381,   380,  3341,  3341,   296,   297,   302,
     307,   316,   304,   363,   305,   308,     0,   309,     0,   299,
     397,   300,   301,   306,   303,   298,   310,   311,   312,   313,
     314,   315,   293,     0,  3295,  3346,   455,   456,     0,   459,
     461,   464,   465,   468,   473,   470,   232,   233,  3061,   145,
     146,   478,   157,  1519,    33,     0,     0,  1534,  3341,     0,
    1549,  1540,  1545,  1537,  1538,  1554,  2714,  2722,  1577,  1757,
    1758,  3033,  2715,  2717,  2723,  3377,     0,     0,  1751,  1723,
    2990,  1724,  2041,  2040,  1750,     0,  1753,     0,  1752,  1754,
       0,     0,  1689,  1688,     0,  1692,  1691,  1674,  3341,  1656,
    1704,  1706,  2735,  3129,  3098,  3131,  3099,  3113,  3092,  3127,
    3095,  3096,  3097,  3125,  3094,  3166,  3120,  3121,  3091,  2953,
    2743,  2740,  2736,  2742,  2737,  2739,  3049,  1772,  3114,     0,
    3089,  3090,  3143,  3006,  3007,  1782,  1786,  1798,     0,  1871,
    3155,     0,  2777,  2780,  2773,  2779,  2774,  2776,  1903,  1977,
    3343,  3343,  3343,  3343,     0,  1961,  1963,  1964,     0,  2037,
    2020,  2021,  1492,  1494,  3380,  2036,  2039,  2038,  2034,  2005,
    2002,  3353,     0,  3284,  2001,  2004,  1995,  1973,  1991,  1997,
    1998,  2008,  1999,  1993,  2012,  2013,     0,  1980,  2735,  2905,
    2735,  2905,  2085,  2092,     0,  2197,  2202,  2104,     0,  2133,
    2140,  2145,  2154,  2157,  2158,  3313,  3428,  2150,  3431,  2155,
       0,     0,  2219,  2221,     0,  2214,  2228,  2215,  2216,  2207,
    2210,  2228,     0,  3003,  2493,  3341,  2487,     0,  3331,  2490,
       0,  2735,  3391,  3391,     0,  2283,  2284,  2784,  2312,  2314,
    2315,  2311,     0,     0,  3382,     0,  2363,  2345,  2358,  2351,
    2347,  2360,     0,  1577,  1577,  2372,  2381,  2378,  2762,  2753,
    2761,  2754,  2759,  2397,  2400,     0,  2427,  2428,  3358,  2433,
    3380,  3380,  2470,  2514,  2505,  2509,  2510,  2511,  2512,  2503,
    1577,  1577,  2539,  2750,  2747,  3341,  2547,  2546,  2548,  2735,
    3166,  2735,     0,  3133,  2582,  3325,  2789,  3325,  2744,  2643,
    2640,  2639,  3360,  1827,  3325,  2238,  2671,     0,  1577,  2415,
    1577,  2418,  2527,  2530,  2528,  3064,  2651,  2708,  3439,     0,
    2706,  1571,   570,   568,     0,   622,   978,   622,  3250,     0,
       0,   941,   938,     0,     0,   669,   906,   962,   963,   964,
     965,   966,   961,   967,   960,   959,   957,   958,   968,  3314,
     755,  2821,   970,  2820,  2822,     0,     0,   731,   733,  3325,
     871,  3429,   876,  3429,     0,  3382,   766,   761,   765,   969,
     735,     0,  3036,   769,   773,     0,   772,   771,  3435,     0,
    3341,     0,   908,  3282,   909,   913,   922,     0,  1099,  1095,
    3411,   828,   827,   820,   819,   826,   825,   824,   823,   822,
     821,   784,     0,     0,   800,     0,   802,     0,  3431,   912,
     923,   931,     0,   739,     0,     0,   738,   736,  3301,   862,
     863,   680,   679,   684,     0,   518,     0,   555,  2941,  3367,
     539,     0,   521,  3415,   548,   550,   554,   553,   549,   551,
     547,   552,     0,     0,  3341,  3341,  3356,   344,   401,  3341,
    3401,  3341,  3341,  3341,  3341,   420,  3286,   421,     0,     0,
       0,  3341,  3372,  3341,  3296,     0,     0,   457,   466,     0,
     467,     0,     0,     0,   484,   485,   486,   477,   479,     0,
     482,   476,   158,     0,    28,    31,     0,  3341,  1544,  1550,
       0,  1555,  1524,  2718,  1715,  1716,  1741,  3472,  3473,  2788,
    1755,  1746,  1687,     0,  1705,  1773,  3093,  3333,  3168,  3115,
    1819,  1875,  2356,  2355,  3439,     0,     0,     0,     0,  1970,
    1965,  3316,  3355,  3354,     0,  1994,  3343,  1992,  2007,  2006,
    2009,     0,     0,  2000,  2048,     0,  2047,     0,  2194,     0,
    2193,  1942,  2105,  2107,  2108,  1577,  2159,     0,     0,  2228,
    3001,  3002,  2228,     0,  3337,  3337,  2213,  2229,  2230,  2211,
    2217,  2212,     0,     0,  2496,   364,     0,     0,  2486,  3332,
    1221,  2268,  3392,   423,   424,   425,     0,  2304,  3443,  2302,
    2303,  2301,  3442,  2275,  2285,  2286,  2288,     0,     0,  2313,
    2309,  2328,  2330,     0,  2348,  3341,  2771,  2346,  2359,     0,
       0,     0,  2362,  2383,  2380,  2376,  2382,  2377,  2379,  2401,
    3359,  2439,     0,     0,  2752,  2749,  2745,  2751,  2746,  2748,
       0,  2557,  3168,  2556,  2571,  2581,     0,  2585,     0,  2577,
    1577,  1577,  2634,  2645,  2768,  2765,  2644,  3361,  3362,  2638,
    1821,  1822,     0,     0,     0,  2671,  3380,  2241,  2252,  2411,
    2419,  2654,     0,     0,  2596,  1570,     0,   571,   569,   982,
     985,  3250,   939,     0,   935,   942,   943,     0,     0,   683,
    3380,   678,   681,   671,  2838,  2840,  2843,  2841,  2842,  2844,
    2845,  2846,  2847,  2837,  2839,  2832,  2836,  2834,  2835,  2831,
    2833,  2824,  2825,     0,  2828,  2827,  2993,     0,     0,     0,
     873,  3430,     0,   874,   877,   864,     0,     0,     0,   754,
     752,   753,   842,   953,     0,  2875,   926,   917,   911,   916,
     914,     0,     0,   919,   910,  1098,     0,  1096,   801,  1208,
    1204,  1205,  1198,  1202,  1210,  1196,   853,  1203,  1195,   860,
    1201,   808,  1197,  1199,  1200,  1209,   805,   807,  1206,   809,
    1207,   804,   812,   811,   840,   838,  3429,     0,   741,   974,
       0,   747,   750,   749,   746,  3165,   685,   529,   520,   519,
     517,   557,   538,  3303,   526,   535,   532,   536,   531,     0,
       0,  3341,   347,   346,   322,   345,     0,   400,   396,     0,
     403,     0,     0,  3287,  3288,   419,   422,  3303,     0,     0,
    3341,     0,   399,   426,     0,   469,   234,  3341,  3341,     0,
     480,   483,  1528,  1541,  1542,  1546,     0,  1547,     0,  1559,
    1707,  3334,     0,  3333,  2735,  1831,  1978,  1969,  1968,  1966,
    1967,  2015,     0,  3343,  2010,  2011,  2735,  2735,     0,  2098,
    1943,  2106,  2139,     0,  2169,  2209,  2220,  2228,  3338,     0,
       0,  2231,  2232,  3341,  2494,     0,     0,  2484,  3341,  3341,
     365,  2488,  2299,  3393,  2296,  2298,  2297,  2290,  2295,  2287,
       0,  2293,  2291,  2292,  2289,     0,     0,  2350,     0,  2341,
    2366,  2760,  2757,  2365,  2349,  2361,  2467,  2468,  2550,  2735,
    2587,  2589,  2767,  2770,  2763,  2769,  2764,  2766,  1823,  1824,
       0,  1825,  2961,  2960,  3034,  1829,  1828,  1830,  2790,  2241,
       0,     0,  2726,  2662,  2655,  2656,     0,     0,  2710,  2711,
    3341,  2604,  1572,   573,   987,  1124,     0,   947,   946,   948,
    3341,     0,  2826,  2830,  2829,   734,   880,   872,     0,   881,
    3382,  3382,   883,   764,  3341,   768,   767,  3380,   843,   841,
       0,     0,     0,   951,     0,   921,     0,   918,     0,   915,
    1100,   854,   855,   859,   858,   857,   856,   806,   861,   810,
     924,   925,   748,     0,     0,   540,   541,   542,   543,     0,
     524,  3324,   528,     0,   352,   353,   351,   350,   429,     0,
     336,   337,   338,   332,   333,   327,   339,   340,   328,     0,
     341,   342,   331,   329,   330,   335,   334,     0,   321,   325,
     326,   323,   430,   402,     0,   410,   418,   431,   432,  2935,
       0,  3341,     0,     0,  3058,  3058,   481,  1551,  1543,  1535,
       0,  1559,  1580,     0,     0,  1774,  1840,  3339,  2014,     0,
    2050,  2049,  2203,  2160,  2227,  2234,  2233,     0,  2497,  3341,
       0,     0,   366,  3394,  2294,  2300,     0,  2331,  2985,  2984,
    2986,     0,  2364,  2755,  2756,  2758,  2558,  1826,  2239,  2672,
    2673,  3341,  2242,  2243,  2245,  2250,  3341,  2666,  2657,  2661,
       0,  2660,  2658,  2712,     0,  3292,  2631,  2630,  2605,  2597,
    2598,  3280,  2599,  2600,  2601,  2602,     0,     0,     0,  3321,
     986,  1126,  3438,     0,   945,     0,   682,   882,   883,     0,
       0,  3299,   868,   888,   889,   890,  3356,   887,     0,   847,
     844,   848,   955,   954,   956,     0,   952,   927,   920,   546,
     545,  3291,  3382,   522,  3303,   527,   410,     0,  3319,  3489,
    3490,   318,   317,     0,   407,   406,   405,   408,   404,  3341,
     412,   355,   414,  2936,   378,   387,   394,   387,   383,     0,
       0,   427,   147,   148,  3250,     0,  1580,     0,  3169,  1577,
    1577,  1797,  1847,  1843,  1577,  3380,  3340,  1834,  1839,  1838,
    1833,     0,  1996,  2495,     0,   367,   368,  2987,  2988,  2989,
    2329,  2726,  2674,     0,  2244,     0,  3380,  2677,  2659,  2703,
       0,  3417,  2628,  2625,  2626,     0,  3382,   574,   572,  3257,
    3337,   989,   988,     0,  1130,  1125,  1127,     0,   949,   944,
     870,   883,   878,  3058,   884,   891,  3341,     0,   763,   849,
     845,   950,  3044,  3046,     0,     0,   524,  3135,   320,   343,
     319,   413,   357,  3135,   356,   411,     0,  3368,   385,   390,
       0,   386,     0,   384,   371,   428,    34,  3341,  1556,  3167,
    1849,  1846,  1841,  1848,  1842,  1844,  1845,     0,  1832,  2498,
       0,     0,  2240,  2676,  2675,  2664,     0,  3380,  2687,  2726,
       0,  3418,     0,     0,  2629,  2627,  2623,  2622,  2621,     0,
     595,     0,     0,     0,  1131,     0,  1128,   869,   897,   898,
     900,  3058,   886,  3045,   544,   525,   523,   355,     0,  3341,
     409,   416,   417,   415,  3369,     0,   393,   395,     0,     0,
    1835,  3341,  3341,  3341,  2663,  2667,  2668,  3341,     0,     0,
    2652,  2704,  2624,  3465,  3464,  3395,  2914,     0,  2617,  2611,
    2612,  2614,  3341,     0,     0,     0,     0,   576,   596,   597,
     578,   606,   990,  1136,  1137,     0,  1129,   899,   892,  2937,
     360,  3137,     0,     0,     0,  1548,  1557,     0,     0,     0,
    2669,     0,  2678,  2679,  3341,     0,     0,  2688,  2689,  2691,
    2726,  3396,  3382,  2915,  2620,  2615,  2618,     0,  2613,  3341,
       0,     0,  3341,  3341,  3341,  3341,   598,     0,  3371,     0,
    3422,     0,   575,   579,   581,   580,     0,     0,     0,     0,
       0,     0,     0,   577,   607,   609,   608,     0,     0,     0,
    1191,     0,  1134,  1193,  2938,     0,   354,  3136,   358,     0,
    3474,  3475,   391,     0,   369,   370,  2665,  2670,  2680,     0,
    2684,  2686,  2685,  2682,  2682,  2696,  2692,  3086,  3087,  3084,
    3085,  2693,  2697,  2690,  2653,     0,  2619,  2616,     0,     0,
     604,     0,     0,     0,     0,  3341,  3341,  3341,  3341,  3341,
     582,     0,  3341,  3341,  3341,  3341,  3341,  3341,  3341,  3341,
    3341,  3341,  3341,   610,     0,  3341,     0,  3341,  1161,  3341,
    1148,  1149,  1150,  1141,  3435,  1142,  3376,  3376,  3341,  3341,
    3343,  3315,  3341,     0,  1166,  1158,  1145,  1159,  3376,  3343,
    1146,     0,     0,  1157,  1168,  1165,  1160,  1163,  3343,  1147,
    1162,     0,  1169,  1156,  3341,     0,  3341,  1185,  1179,     0,
    1183,  1182,  1180,  1138,  1184,     0,  1186,  1181,  1164,  1151,
       0,  3376,  1194,  1212,  1211,  3147,     0,   391,   388,   392,
    1558,  2681,  2695,  2683,  2694,     0,  2610,  2607,  2609,  2608,
    2603,  2606,   599,  3429,   603,   601,   605,   600,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   994,  3258,  3346,
    3346,  3363,   993,   997,   998,  1027,     0,     0,     0,     0,
    1139,  1140,  1174,  3341,  1172,  3341,     0,     0,     0,  1143,
    1144,     0,  1188,  1170,     0,  3429,  3341,     0,  1189,     0,
    1187,  1192,   778,   779,   780,   781,   774,  1190,  1517,  1173,
    1137,  3147,     0,   241,   242,   362,   389,  2698,   895,   591,
     587,   588,   592,   590,     0,   593,   583,   589,   584,   585,
     586,   615,   611,   612,   616,   614,     0,   613,  3505,  3506,
    3346,  3346,     0,   991,   995,  3341,  1003,   999,  1001,  1002,
    1004,  1006,  1178,  1513,  1509,  1175,  1176,  1154,  1155,  1177,
    1171,  1506,  1516,     0,  1153,  1152,   775,  1191,   361,   602,
     896,     0,     0,  3364,  3365,  3069,  1014,  1009,  3360,  1013,
    3068,  1012,     0,  1028,     0,  1000,  1005,  1501,  1498,  1502,
    1499,  1514,  1497,  1515,  1500,     0,  1510,  1511,     0,  1507,
    1505,  1503,  1504,  1167,     0,   617,  1007,  3361,  3362,  1008,
    1011,     0,     0,  1029,   638,   996,  1512,  1508,     0,     0,
    3341,  3341,     0,  3341,  1015,  1016,  1017,  1018,  1019,  1020,
    1010,     0,  1031,  3259,  1032,     0,  3492,  3491,  3341,     0,
       0,  3494,     0,  3341,  3341,     0,   776,     0,     0,  1026,
    1022,  3493,     0,     0,  1021,  1087,  3453,  3452,  3335,  3376,
    3282,  3341,     0,  1086,  3341,  3380,  3341,  1037,  1039,  1038,
    1040,  1049,  1041,  1043,     0,  1046,  1033,  1034,  1035,  1045,
    1047,     0,  1050,  1036,  1104,  1042,     0,  1044,  1048,  1030,
    3456,  3457,  3376,     0,  1023,  1025,  1024,  3336,  1121,  3379,
    3378,  3346,  1103,     0,   873,     0,     0,     0,   933,  3374,
    3374,     0,     0,  1106,  1101,  1104,     0,  1496,  1108,  1116,
    1117,     0,  1119,  1110,   594,  1102,  1074,  1072,  1073,  1068,
    1071,     0,  1069,  3429,  3152,  1076,  2972,  3496,     0,     0,
    3498,  3500,     0,  3504,  3502,  1051,  1056,  3384,  3384,  1053,
    1057,  1052,  1058,  3375,  1088,  1088,  3374,  3374,  1081,  1105,
    1107,  1118,  1115,  1114,  1112,  1113,  3346,  1111,  1070,   877,
    1120,  3382,     0,  1075,  2973,  3495,  3499,  3497,  3503,  3501,
    3386,  3385,  1059,  1064,  1092,  1090,  1082,  1088,  1091,  1084,
       0,     0,  1109,   866,     0,  1078,  1062,  1054,  1062,  1067,
    1062,  1055,  1062,  1089,  1083,  1085,     0,   865,  1080,  1077,
    1079,     0,  1061,  1060,  1066,  1065,   867,  1063
};

  /* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
   -4283, -4283, -4283, -4283, -4283, -4283, -4283,  3625, -4283, -4283,
   -4283, -4283, -4283, -4283,  -116, -4283,   572, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283,  1115, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283,  2645, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283,  3594,  3466,  1233,
   -4283, -4283, -4283,  3312, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283,  3639, -4283, -4283, -4283,
    2403, -4283, -4283,  3564, -4283,  1827, -4283, -4283, -4283, -4283,
   -4283, -4283,  3361,  1344, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283,  3445, -4283,   593, -4283, -4283, -4283,  3363, -4283,  1146,
   -4283, -4283,  3573, -4283, -4283,  -985, -4283, -4283,  3336, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,  2865,
   -4283,  2453, -4283, -4283,  -763, -4283,  3513,  3153, -4283, -4283,
   -4283,  3368, -4283, -4283, -4283, -4283,  3465, -4283, -4283,  3156,
    2365, -4283, -4283, -4283,  2391, -4283,  2426, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283,  -640, -4283, -4283,
   -4283, -4283, -4283,  1185, -4283, -4283, -2368, -4283, -4283, -4283,
   -4283, -4283,  -488,  -877, -2977, -4283, -4283,   222, -4283, -4283,
   -4283, -4283, -4283,  -465, -4283, -4283, -4283,  -573, -4283, -4283,
   -4283, -4283,   219, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283,  3176, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283,   634, -4283, -4283, -4283, -4283,  2860, -4283, -4283, -4283,
     198, -2122, -4283, -4283, -4283, -4283,  3653, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,  -556,
   -4283,  -301, -4283, -4283, -4283,   239, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283,  -720, -4283, -4283, -4283,  -664, -4283, -4283,
    -729, -4283, -4283, -4283, -4283, -1650, -4283, -4283,  2946, -4283,
   -3367, -4283, -3455,  -736, -4283, -1052,  1430, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -2621, -4283, -4283, -4283,
     353, -2220, -4283, -4283,  1268, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283,  1945, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -3074, -4283, -4283, -4283, -4283,
   -1074, -4283, -1073, -1476, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283,  1256,  1257, -4283, -4283, -2793, -4283, -4283, -4283,
   -4283, -4283, -3553, -4283, -1193, -4283, -4283, -3640, -4283,  -530,
    -417, -4283,  1562, -4283, -3812, -4283,  -595, -2637, -4283, -4283,
   -2509, -4283, -4283, -4283,   320, -4283, -4283, -4283, -2749,   315,
     324, -4283, -1058, -2808, -2413, -4283, -4283, -4283, -4283, -4283,
     845, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283,  1204, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283,  -955, -2211, -4283,
   -4283, -1017, -2071, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -2303, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -2469, -4283,
   -1051, -4283,   810, -4283, -4283, -4283, -4283, -1114, -4283, -4283,
   -4283, -4283, -4283, -4283, -1121, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283,  -494, -4283, -4283, -4283,  -905, -4283, -4283,
   -4283, -4283,  -628, -4283,  3042, -4283,  -817, -1595, -4283,  -740,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283,  2143,  2712,   473,  -771,  -768, -4283,
   -2467, -4283,  -942, -4283, -4283, -4283, -4283,  -774, -4283,  -806,
   -4283, -4283, -4283,  1928, -4283, -4283, -4283, -4283, -4283, -4283,
     -73, -4283, -4283,  1924,   118, -4283, -4283,    99,   684, -4283,
   -4283,  -283, -4283, -4283, -4283, -4283, -1785, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -1239, -4283, -4283,  -163,
   -4283,  3505, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283,  -811, -1621, -4283,  2506, -4283,  2501, -4283,   649,
   -4283,  -753, -4283, -4283, -4283, -4283, -1101, -4283, -4283,   659,
    2498, -1253,  1903, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283,  1804,  1141, -4283, -4283, -4283,  2867, -4283, -4283,
   -4283, -4283, -4283, -1594, -4283, -4283,  1477, -4283, -4283, -4283,
   -4283,   244, -4283, -4283,   117, -4283, -4283, -1102, -4283, -4283,
   -4283,  -415, -4283,  -412, -4283, -4283, -4283, -4283, -4283,  2861,
   -4283, -4283, -4283, -4283,  2444, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283,  3090, -4283, -4283,
   -4283, -4283, -4283,  2392, -4283,  2816, -4283, -4283,  2420, -4283,
   -4283,  1759, -4283,   228, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283,  1737, -4283, -4283, -4283, -4283,   615, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283,  2812,  1137,  3089,
   -2486, -2860, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -1865, -2600, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,  2395, -4283,
   -4283, -1107,  2397, -4283, -4283,  2393, -4283,  1718,  1107, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,   246,
   -4283, -4283, -4283,  2798, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283,  1691, -4283, -4283, -4283, -4283, -1297, -4283,
   -4283, -4283,   589, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283,   590,  2366, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283,  2774, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -2548, -4283, -4283,  1662, -4283, -4283,   578,
   -4283,  1078, -4283, -4283, -2831,   241,   243, -4283, -4283, -4283,
   -4283, -4283, -4283,  -106, -4283,  -271,  2088, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283,  2770, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283,   220, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -3598,  1547, -4283, -4283, -4283,
     565, -4283, -4283, -4283, -4283, -4283,  2811,  2765, -4283, -4283,
   -4283,  1515, -4283, -4283, -4283, -1427,  1056, -4283, -4283,   566,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
     556, -4283,   559, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283,   997, -1911, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283,  2096, -4283,   987, -4283,
    2103, -4283, -4283, -4283, -4283, -4283, -4283, -4283,  2165, -4283,
   -4283, -4283, -4283, -4283, -4283,  -124, -4283, -4283, -4283, -4283,
    1496, -4283, -4283, -4283,  2753, -4283,  2760, -4283, -4283, -4283,
   -4283,  3125, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283,   994, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
    2154, -4283, -4283,  1484, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283,   545, -4283,  1494, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,
   -4283, -4283, -4283,  -499, -4283, -4283, -4283, -4283, -4283, -4283,
    -359, -4283, -4283, -4283, -4283,  1043,  1539,  1552, -4283, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -4283,   -64, -4283,
   -4283, -4283, -4283, -4283,  -477,   208, -4283,  -217, -4283, -4283,
    -518,  -589, -3875, -4283, -4283,  -521, -4283, -4283,  2129, -4283,
   -4283, -4283, -4283, -4283, -4283, -4283, -4283, -1558, -4283,  1339,
   -4283, -4283,  1334, -4283, -1303, -4283,  2504, -4283,  2508, -1805,
   -4283,  1265, -4283,  1269,   575, -4283,   592, -4283,   595, -4283,
   -4283, -4283, -2613,    -6, -2168, -4283, -4283,   248, -4283,   247,
   -2196,   580, -4283,  1244, -4283,  1249,  2986, -1467,  3187,  -319,
   -2488, -2239,  -596, -1248, -4283, -4283,  2480, -2089, -4283, -4283,
   -4283, -4283,   204, -4283, -1363, -1364, -2001,  1092,  1093,  1096,
    1099,  1242, -1823,  -584,  1394,  1935, -4283,  1640,  4344, -1129,
    -615,  -697,  3184,  2788, -1116, -4283,  -257,  1398,  -722, -4283,
    -979, -4283,  1801, -4283,  -552, -4283,  2589,   477,  -142, -4283,
   -4283, -1185, -4283,   934, -2502,   -46,  1431,  3612,  -604,  -603,
   -4283,  -597,  1156,    10, -3271,   538, -4283, -1144, -3269, -4283,
   -4283,   129, -4283,    38, -4283,  1600, -1034, -1980, -2867, -2758,
   -4283,  -688,  2606, -4283, -2423, -1827, -2940,  -251,  -586,  -683,
    -744,  -583,  3215, -2560, -4283, -2788,   513,  3818,  -741, -4283,
   -4283,  -310, -4283, -2036, -4283, -4283, -2836,    71, -2744, -4283,
    1426,  -769,  -789,  -175,  3117, -3084, -2249,  3138,    73,  -223,
    3905,  -314,  -627,  -662, -4283, -4283, -4283, -1146,  3075, -4283,
   -4283, -4283, -4283,  1435, -4283, -4283,  2184, -4283,  -309, -4283,
   -4283, -4283, -4283,  1609, -4283, -2527, -4283,  1308,   973,   654,
     326, -4283, -4283, -4283,   -45,  -680,  -248,  2786, -4283,  -541,
    -816,  -751, -4283, -4283, -4283, -1728, -4283,  -139, -2364,   780,
   -4283,  1490, -1957, -4283, -4283, -4283, -1681, -1739, -1112, -1772,
    -273, -4283, -4283,   749, -4283, -4283,  -182,  -184, -4283, -2087,
     971, -4283,   132, -4283, -3308, -4283,   -28, -1973, -2408, -4283,
   -4283, -2604, -4283,  -739, -4283, -4283, -4283,  3136, -1692, -2478,
   -2479,  -854,  -814,  -726,  -904,  3654,   736, -4283, -4283,  3647,
   -4283,  -840, -4283, -4283, -4283,  -154, -4283,   540, -4283,  1607,
   -2246, -4283, -4283, -4283, -3248,  -677,  1950,   598, -4283,  -215,
   -4283, -4283,   903, -4283, -1746, -4283, -1271, -4283,  2148, -4283,
   -4283, -4283,  -674, -4283,  -719,  -451, -4283,  2228,  1486, -4283,
   -4283,   186, -4283, -4282,  -844, -4283, -4283, -4283, -4283, -4283,
   -4283
};

  /* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,     1,     2,     4,     5,     6,    18,    19,     7,     8,
      20,    21,   126,   127,   128,   182,   131,   185,    22,   837,
    1831,    23,   838,  1832,  3075,  3503,    10,    11,    53,   121,
     179,   576,   577,   834,   836,  1249,    13,    46,   141,    24,
      25,    42,    26,    38,    39,    40,    41,   124,   247,   181,
     243,   345,   346,   347,    14,    44,    45,   137,    62,   140,
     255,   190,   587,    29,    30,    31,  1251,    48,    49,    50,
      51,    91,    92,    93,  2525,    94,   217,   307,   559,    95,
     214,   292,   293,   294,   295,   296,   549,  1243,   297,   298,
    1239,   299,  3501,    96,   215,   304,   305,   306,   554,    97,
      98,    99,   100,   101,   175,   102,   228,   573,   229,   230,
     103,   201,   273,   525,   526,   274,   275,  1223,  1231,  1224,
    1225,  1226,  2518,  3066,  2706,  4655,   203,   177,   104,   105,
     312,   313,   314,   830,   106,   219,   220,   107,   530,   531,
    3494,   109,   224,   326,  3495,   535,  3496,   112,   113,   114,
     115,   116,   117,   169,    69,    70,    71,   148,   200,   270,
     512,  1794,  2502,  2503,  3027,  3028,  4027,  4028,  4029,  4030,
    4031,  3804,  3805,  1206,  3029,  4007,  3030,  4263,  4264,  4329,
    3031,  4446,  3032,  2745,  3585,  3034,   240,  3035,  3036,  3037,
    3038,  4178,  4268,  4568,  4269,  4271,  3039,  3040,  3041,  3042,
    4034,  4168,  3043,  4171,  4172,  4265,  4266,  4331,  3044,  3045,
    3476,  3046,  3255,  3047,  3823,  3048,  3049,  3050,  3051,   271,
     272,   517,   518,   519,   520,   799,   521,   522,   523,   792,
    3061,  3062,  3490,   524,   794,  1812,  1252,  3072,  3497,  3498,
    3499,  3500,    64,   264,    65,    66,  2527,   143,   144,   196,
     265,   266,   776,   267,  1185,  1781,  1782,  3790,  1783,  4153,
    4002,  3445,  1784,  1785,  3004,  3796,  1786,  1787,  3792,  3995,
    3996,  3997,  3998,  1788,  3460,  3461,  1789,  3447,  1790,  1791,
    2497,   757,   758,  2403,  2864,  3343,  3344,  3345,  3943,  4119,
    4227,  4422,  4423,  4424,  4425,  4367,  4368,  4369,  4433,  4434,
    4435,  4436,   504,   505,  1758,   506,   507,   762,   763,  1769,
     764,  1180,  1181,   221,  2479,  2970,  2304,  2305,  2306,  2307,
    2308,   765,  3355,   766,  1764,  1174,   767,  1765,  2982,  3691,
    3442,  2971,  2442,  2443,  2444,  2445,  2446,  3377,  3378,  2447,
    2448,  3437,  2449,  3433,  2412,  2450,  2451,  3435,  3784,  2452,
    3391,  3730,  2453,  2899,  2454,  2455,  2908,  3387,  3727,  3966,
    2456,  2457,  4548,  4549,  4646,  2967,  3426,  3424,  3397,  3969,
    3970,  4250,  2309,  2310,  3987,  3989,  2459,  3388,  4811,  4947,
    2460,  3720,  3383,  2906,  3962,  3380,  4128,  4132,  4247,  4133,
    4134,  4135,  4136,  4709,  4137,  4318,  4319,  2461,  2462,  2917,
    2463,  2464,  2465,  3404,  3405,  2466,  3743,  3979,  3400,  3429,
    3430,  3735,  2410,  2972,  3431,  4815,  2411,  3351,  2883,  2884,
    2885,  3684,  3685,  3686,  3949,  4124,  2467,  3733,  3972,  2468,
    3366,  2469,  3364,  2470,  2471,  2472,  2473,  2474,  2475,  1171,
    1172,  2865,  1762,  1763,  3347,  2407,  2867,  3944,  4120,  4232,
    4312,  4439,  4507,  4612,  4613,  4687,  4688,  4689,  4690,  4614,
    4716,  4717,  4718,  4746,  4764,  4765,  4766,  4767,  4768,  4769,
    4683,  4723,  4774,  4786,  4816,  4817,  4885,  4937,  4952,  4941,
    4818,  4869,  4870,  4819,  4913,  4949,  4820,  4821,  4926,  4927,
    2476,  2926,  2927,  3408,  3747,  4823,  4824,  4854,  4855,  4825,
    4826,  4906,  4907,  4858,  4859,  4860,  4827,  4828,  2869,  3349,
    4121,  4235,  4236,  4237,  4374,  4375,  4565,  4440,  4553,  4554,
    4555,  4442,  3773,  4562,  1034,  4650,  1621,  1622,  1623,  1624,
    2256,  1592,  2257,  1593,  2258,  1594,  2259,  1595,  2260,  1596,
    2261,  1597,  2262,  1598,  2263,  2264,  1599,  2265,  1600,  2266,
    1601,  1602,  2267,  1603,  2268,  1604,  1605,  2269,  1606,  2270,
    1607,  2752,  2142,  1608,  1609,  1613,  1614,  2677,  2678,  4856,
    4857,  4732,  4733,  4734,  4700,  4741,  4742,  4624,  4738,  4622,
    4735,  4556,  4557,  2528,   192,   193,   258,  2538,  3839,   194,
    1257,  1838,  1837,  2531,  2532,  2533,  3080,  3081,  3082,  4049,
    3510,  1840,  3512,  3838,  4339,  4453,   754,  1153,  1757,  1154,
    1155,  2400,  3675,  1156,  1157,  2862,  2015,  2016,  2660,  1158,
     260,   430,   710,   431,   678,   843,  1260,  2593,   844,   845,
     846,  2713,  1274,  1897,  1898,  1265,  1266,  1267,  3119,  3120,
    1925,  3196,  1848,  1849,  2552,  2557,  1269,  1889,  3088,  3089,
    4558,  2049,  1892,  1259,   432,   679,   879,  1298,  1296,   433,
     680,   896,  1985,  2633,   434,   681,   912,   913,  1987,   435,
     682,   918,  2636,   840,  1254,  1836,   595,   596,  1989,  1990,
    2639,  2843,  3323,  3660,  3661,  3662,  4056,  1022,  4200,  4191,
    4284,  4192,  4282,  4193,  1333,   436,   683,   923,   924,   925,
     437,   684,   929,   930,  1340,   931,  1336,  2641,   438,   685,
     934,  1345,   439,   440,   686,   944,  1354,   441,   688,   949,
     442,   687,   946,  1355,  1358,   443,   689,   956,  2010,   957,
     444,   690,   968,   969,   970,   971,  1385,   972,  1387,  2050,
    2025,  2026,  3859,  2027,  2665,   973,  1368,   974,   975,   976,
    2053,  2054,   977,  2659,  3175,  3176,  3177,   978,  1389,  2688,
     979,   980,  2658,  3534,   981,  2689,   982,  1370,  2058,  1035,
    3197,  3198,  3199,  3200,  3201,  3551,  3202,  3203,  3204,  3205,
    2051,  3101,  1374,   445,   691,   987,  1397,   446,   692,   447,
     448,   733,   734,  1135,   449,   693,   992,   993,   994,  1405,
    1406,  1401,  1407,  2071,  2072,  1408,  1409,  2077,  2078,  2700,
    1402,   450,   695,  1003,  2116,  1004,  1438,  3218,  3561,  3562,
     451,   696,  1010,  1023,   452,   697,  1011,   453,   698,  1014,
     454,   699,  1017,  2121,   455,   700,   456,   701,   674,  2126,
    1448,  2127,  2718,  2720,   457,   702,  1027,  1449,  2136,  2724,
    3223,  3224,  3225,  3227,   458,   703,  1030,   459,   704,  1036,
     460,   705,  1039,  1040,   998,  2153,   461,   694,  1436,  2115,
    2712,  2114,  3560,  2707,  2154,  2743,  2155,  2156,  3239,  3240,
    2740,  2741,  2742,  3233,  3576,  3577,  3578,   462,   463,  1137,
    1732,  3665,  4211,  3932,  4092,  4093,  2373,   464,  1138,  1734,
    3326,   465,   706,   466,   707,  1047,  1628,   467,   708,  1049,
     468,   709,  1051,  1632,   469,   711,  1055,  1056,  1057,  1639,
    2276,  3603,  3604,  3894,  3887,  3888,  3605,  3606,   470,   712,
    1059,  2765,  2766,  3610,  3261,  1644,  1645,  1646,  2768,  2770,
    2771,  3896,   471,   713,   472,   714,  1065,  4222,   473,   715,
    1067,  2322,  3266,  3267,  3268,  2007,  2008,  2009,  3617,  3270,
    3616,  3899,  1659,   474,   475,   716,  1069,  1667,  3275,  3627,
    3276,  3625,  3277,  1664,   476,   717,  1071,   477,   478,   718,
    1074,  1671,   479,   719,  1077,  2784,  2785,  1675,   480,   481,
     482,   738,  1139,  1140,  1736,  1741,  2380,  2848,  2850,  2851,
    1739,  2382,   483,   720,  1081,  1082,  3286,  1680,  1681,  1083,
    2326,  3289,   484,   721,  1088,   231,  1697,  1089,  1090,  2348,
    2349,  1091,  1092,  1093,  1094,  1095,  1096,  1097,  1098,   485,
     722,  1041,  3244,  1616,  3588,  2157,  2746,  3584,  3877,   486,
     723,  1107,  2351,  1705,  2815,  2816,  1701,   487,   488,  1143,
    1743,  3332,   746,   747,   489,   724,  1109,  1110,  1111,  1709,
    1710,  2356,  3307,  2823,  1707,   490,   725,  1114,  1715,   491,
     726,  1117,   492,   727,  1118,   493,   728,  1120,   494,   729,
    1123,   495,   730,  1126,  1725,  2832,  2833,  2365,  2835,  3316,
    3318,  1723,   496,   731,  1130,  3676,  3941,  4109,  4110,  4111,
    4580,  4112,  4359,  4360,  4407,  4113,  4308,  4114,  4115,  4223,
    4224,  4116,   497,   732,  1132,  1669,  2368,  2369,  3652,  1728,
     498,   499,  1148,  1750,  3671,  4400,  3933,  3934,  3935,  4102,
    4097,  4344,  4217,  4345,  4346,  3667,  4089,  4090,  4298,  4392,
    4393,  4572,  4573,  4350,  4397,  4398,  4466,  4471,  2395,   500,
    1149,  1752,  4299,  2398,  2860,  3339,  3938,  2543,  3092,  2544,
    2545,  3086,  2546,  2547,  1378,  2019,  1379,  2017,  1380,  2619,
    3144,  2620,  3142,  2621,  3302,  3638,  3303,  3636,  3304,  2780,
    3900,  4084,  2781,  3279,  3280,  3653,  3916,  3654,  3914,  3655,
    2653,  2654,  3166,  2655,  3164,  2656,  1060,  2279,   748,  3106,
    3325,  1025,  1026,   996,   997,  1429,  1430,  3372,  3373,  3374,
    3375,  3711,  3712,  2084,  1431,  3714,  2105,  2106,  2107,  2108,
    2109,  1746,  2391,  1934,   898,   899,   900,   901,   880,   936,
    1348,  1078,  1079,  1141,  1800,  4304,  1801,   847,  1031,  1100,
    1101,  2118,  2119,  1443,  1647,   915,   916,  1795,  2996,  4174,
    4378,  1240,  2990,  2991,  2997,   151,  2498,   315,  1012,   938,
    1383,   983,   882,  3921,   883,   884,  4875,  1949,   904,  4077,
    3102,  1899,  2311,  3717,  1930,  2596,  3241,  2731,  3569,  1683,
    3152,   926,  1127,  1649,  1843,  2560,  2796,  2797,  2317,  1844,
    1042,  1104,  3103,  3090,  3923,  2903,  3393,   885,   750,   951,
    4251,  4252,   939,   940,   906,   907,  2733,   751,  1241,  1242,
    1824,  1146,  1147,  1845,   831,  2562,  4721,   532,   327,   886,
     329,   330,  4472,   887,   888,   889,   890,  1304,  1283,  1957,
    1941,  1942,  1953,  1946,  1935,  1937,   768,  2834,  4327,  1328,
    1971,  2629,  1662,  1625,   779,  1351,  2001,   359,  3439,  3528,
    3844,   675,   676,   677,    34,   807,  1166,   774,  4228,  4607,
    4772,  4608,   808,   775,  1168,   501,  2841,  2576,  2494,  1209,
    3815,  2912,  1270,  1271,  3485,  1372,  2534,   300,   168,   550,
    2482,  1362,  1893,  3370,  2679,  1204,  1202,   204,  4003,  1061,
    2141,  3249,  3842,  4838,  3869,  4201,  1433,  2162,   566,  2167,
    3544,  2589,  3631,  3659,  4682,  3450,  4335,  4427,   187,  4894,
    4623,  4841,  1192,   795,  4922,   334,  3593,  4074,  4402,   301,
    1894,  3054,  1721,  2902,   155,  3412,  2478,   540,  4302,  2853,
    4428,  1810,  1365,  3228,  3722,  2680,  2574,  2892,  3688,  3206,
    3608,  2124,  2783,  2548,  1381,  4830,  4750,  4832,  4561,  1349,
    4355,  3055,   284,  2994,  3519,  4452,  1822,  2486,  1342,  2822,
     891,  2509,  4163,  4778,  4784,  4888,  4889,  4890,  4891,  4892,
    4618
};

  /* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     232,   328,   984,   567,  1167,  1119,  1927,   119,  1643,  1718,
     510,   183,  1178,   132,   208,    60,   211,   276,   910,  1891,
    1072,   216,  1018,  1173,  1175,  1176,  2163,   152,  1182,  2401,
    1815,   259,  1001,   159,  2566,  1278,   161,   162,  1103,   164,
     165,  1742,  2769,  2363,   170,  2871,  1227,  1227,   156,   157,
     158,  1682,  2004,  2973,  1188,   163,  2670,  2085,  1193,  1194,
    1827,  1196,  1197,   280,  1199,  1200,   536,  2681,  1129,  2104,
     937,  3122,  3096,   178,  3181,  2924,  2987,  2988,  1802,  3097,
    1804,  1805,   881,  1807,  1808,  2491,  3135,   561,  2060,  2061,
    2062,  2063,  1268,   560,  1013,  2549,   897,   995,  1028,  1013,
     197,   198,   199,  3340,  1189,  1190,   331,  1360,  2402,  1195,
    2599,   188,  1198,  2601,  3401,  2986,  3406,  1102,  1013,  1343,
    1210,  1693,  2607,  1043,  3390,   205,  2611,   206,  1115,   914,
    1292,   212,   213,  2614,  2571,  3724,  2370,  1940,  3745,  1043,
    3098,   223,  2021,  1300,  3104,   257,  3246,   233,  1958,  1956,
     261,  2125,  1353,   244,  2782,  2819,   249,  3219,  2549,   251,
    2079,  1967,  1324,  2669,  3216,  1388,  2549,  3959,  1961,  3281,
    2081,  3521,  1352,  4652,  3403,   277,   362,   316,  2280,   551,
     149, -1527,  4939,  3242, -1525,  2685,   149,   337,  1285,  1286,
    2882,  2763,   508,   310,  2646,   948,  1291,  -846,  4358,   563,
    1403,  1754,   348,  3207,   335,   350,  3993,   252,   575, -3439,
    2709,  4164,  4506,   920,  2568,   563, -3030,  3882,   287,  1255,
    1819,  1032,  1302,   511,  4099,  2110,   556,   209,   360,   209,
     910,   910,   910,   910,   209,  1672,  3925, -3382, -3031,   317,
    1895,  1326,  1331,  2120,  1311, -3439,   166,  3179,  4849,  2323,
    3180,  2481,   172,   317,   832,  2388,  4706, -3439,  3185,  1817,
     773,  2692,   541,  1828,  2164, -3439,  1261,  3870,  2789,    75,
    2066, -3439,    72,  2790,  2579,  1618,   209,  1064,   234,  2388,
    2572,  1928,  4195,  4686,  2024,  2362,  -623,  1179,   571,   572,
    1400,  1043,  4486,  2458,  1591,  1833,    77,   579,  1926,  3309,
    3310,  4850,  2082, -3431,   582,  4499, -2310,   202,  1451,   513,
    1309,  3264,  2682,  4409,  2362,  3736,  1353,  -846,  2091,  1640,
     933,  4244,  2791,  3259,    75,  4142,    59,  2362,  1375,  1400,
    1183,   800,   225,   563,    59,  4306,  1699,  3547,  1375,  4642,
    4643,  2675,  3788,  2676,  3776,  -992,  2583,  3547,  1058,  2817,
     533,    77,  3273,  1064,  2587,   537,  2378,  1749,  2735, -3299,
     914,  1862,   513,   336, -3439,  -992,   816,  2388,  4175,  1713,
    3336,   841,  4936,  1384,  2559,  2160,  2284,    73,  1001,  2493,
     351,  2830,  4278,  2539, -3402,  2747,  -992,  -992,  1610,  3300,
    2748,  3922,  1375,   759,  3570,  2569,  1717,   302,  1653,  3854,
    4460,  1019,   332,   122,  3465,  4948,  1635,   548,  1019,  1441,
    3580,  2536,  3469,   933,  1375,  3473,  3474,  1444,  3322,    36,
   -3382, -3439,   343,  1686,  2378,  1441,  1767,   932,   287,   282,
     947, -3439, -3301,  1434,   -44,    74,  4100,   202,    75,  3001,
      76,  3247,  3410, -3439,  2915,  3644,  2285,  2286,  2287,  2288,
   -1527,  2289,  2889, -1525,  1080,  3532, -1527,   933,  1068, -1525,
      87,  1075,  1227,   933,  2736,    77,  1108,   933,  2758,  4203,
    2637,  1000,  1124, -3439,  3802,   986,  3570,  3980,   202,  4169,
    4783,  1261,  3078,   910,  2651,   235,  -777,  -777,  4240,  4903,
    3110,  1690,  1013,   166,   933,  1375,  4915,   809,   810,  1441,
    3548,  -623,   911,  4940,  2273, -2430,  4219,  1268,  1636,  3402,
   -2430,  2973,   815,  1268,  3967,    59,  4143,  3002,   225,   818,
    4465,  1755,    16,   833,    17,  3363,  4461,  1637,  3990, -3301,
    1043,   801,  4791,  2290,  2291,  3472,   552,  1931,   167,   928,
    1314,   509,  1315,  1316,  1317,  1318,  1319,  1320,  2111,  3803,
    4170,  2388, -3439,    59,  2828, -1527,  3533,  1062, -1525, -2430,
      78,  1747,  3411,  2002,    59,  4886,    79,  1435,  2890,   123,
    1896,  2379,  1312,  2749,   588, -3291, -3301,  1313,  3475, -3291,
    2388,    89,  2638,  3840,  4571,  2388,  4189,  2359,  3283, -1527,
    -992, -1527, -1525,  4395, -1525,  2388,  3741,  3079,   302,   283,
     564,  4317,  1998,   533, -3321,   344,  4289,  1377, -3132,  4462,
    3330,  2150,  4165,  1820, -3346,  3855,   564,  1377,   910,   910,
     910,    79,  2652,  3248,   318,   910,   910,   910,  1952,  1756,
    1272,  1952,  2023,  4176,  4644,  1244,  1929,  2388,   318,  2379,
    1235,   910,  2523,  1952,   910,  -992, -3439,  3486,  2710,  3922,
     910,   910,   910,   910,   910,   910,   910,   910,   910,   910,
     910,   910,  2896,  2112,  2882,  2165,  3558,   278, -3427,   303,
    2542,  1377,  1129,  1337,  2825,   527,   921,  4851,  2388,  3242,
   -3078,  2737,   937,   859,   860,  3301,  1638,   910,  1356,  3252,
    -992,    37,   910,  1377,  1020,  1085,  1694,  3274,  2517,  -992,
    4196,  4739,   319,  1945,  1945,  1945,  3867,  2916,  2897, -3439,
    3265,   318, -3132, -3041,  1611,  2923,   319,  1341,   320,  1966,
    1928,  2703,  2292,  2293,  2294,  2295,  2296,  2297,  2298,  2299,
    2300,  3053,   320,  1187,   564,    79,  1021,  3570,  3865,   842,
    3883,  3866, -3439,  1021,  1016,  1016,   759,  1825,  3926,  3109,
   -3039,   908,   917,  1376,  4233,  1346,   941,  3290,  3291,  3582,
    2588,  2690,  3234,  3443,   534,  1999,   236,  4131,   941,  1015,
    2003,   333,   802,   941,  1377,  2014, -3325,  1044,  4314,  2537,
     862,  -777,   863,  1612,   937,   793, -3439,  2735,  1073,   319,
    1073,  1245,  1105,  1044,   317,  3878,  2738,   514,  2606,  2161,
    2549,  -623,  1834,  1073,   318,   320,  1248,   995,  3947,  1142,
    3085,   288,  3293,  1450,  -623,  4004,  4177,  1000,  -992,  3147,
    3389,  4715,  2315, -1536,  2661,  2662,  2277, -1527,  3647,    80,
   -1525,  4197,  2696,  4904,  1184,  2079,  2624,  1652, -3439, -3356,
    2549,  4144,   922,  3549,  2524,  1654,  4710, -3431,   318,  2761,
     514,  2588,  -992,  1086,   318, -3341,  2301,  4198,   318,   352,
     353,   354,  3801,  2389,  2340,  3271,  1207,  3884,  1591,  4233,
     303, -3299,   534,   862,  4307,   863,  2101,  2586,  2779,  2080,
     253,   321,   319,  2341,  4190,   318,   533,  2389,  2721, -2310,
    2158,  2122,  4147,  2736,  4190,   321,  1016,  3789,   320,   207,
   -3299,   287,  4053,  -243,   218, -3301,  3260,  2312,   760,  -992,
    2002, -3291,  3453, -3299, -3397,  1087,   870,   862,  2695,   863,
     207,   761,  4311,   862,  2024,   863,   319,   862,  1745,   863,
    4166,   287,   319,   254,  4487, -3301,   319,   773,  2573,  3830,
     801,  2839,   320,  3687,  4653,  1044,   207,  4500,   320, -1568,
     289,  -992,   320,  1264,   862,   910,   863,   933,  2390,  3114,
    4410,   534,   287,   319,  2697,   534, -3301,  2458,   321,  1404,
    2573,   803,   207,   534,  3451,  2389,   207,  3817,   355,   320,
    1150,   515, -3128,   917,  3824,  1312,  3547,  3994,   207,   589,
    1313,  2973,    83,  3977,  4046,  3927,   207,  2514,  2515,  1033,
    2302,   207,  1835,  3901,  3118,  -623,  2320,   941,  2006,   870,
     322, -1536,   534,   545,   516,  1798, -3341,  1799,   937,  1256,
    1803,   207,   317,  2303,   322,  1814,  2272,  1013,  3117,  1813,
    4645,   237,   238,   422,   515, -3305,  4064,  2664,  1150,  3739,
    1145,  1150, -3437,  2666,   207,  1272,  1796,  1797,  3846,  1887,
   -3301,  1272,  1821,   870,   340,  2519,  1806, -1568,   290,   870,
     -44,   321,  1748,   870,  3003, -3291, -3291,   516,  -992,   534,
   -3130,  2505,  2506,    86, -3341,  1929,  1818,  2511,  1151, -3402,
    2512,   590,   557,   941,   804,    87,   910,  1441,   323,  2166,
     870,  4167,  4467,  4362,  2711,  1152,  4905,   322,  2005,   941,
   -3321,   937,   323,   317,  3885,   321,  3550, -3346,   173,  2113,
    2737,   321, -3132,  4429,  4188,   321,   553,   534, -3299,   207,
    1404,   311,  1341,    88,  1759,  4654, -1536,  1997, -3439,  3683,
    2151,  1651,   207,  3443,   150,   207,  1151,  4199,   509,  1151,
     150,  1261,   321,  4101,  3968,  2616,   509, -3299,   429,  2520,
     207,   534,  2011,  1152,  1087,   568,  1152,  1793,  1996,  2389,
   -3299,  3886,   542,  2898,  2393,  -992,   941,  2561,   279,  3157,
    2028,  4363, -2222,   941,  2623,   323,   528,  -777,  2561,   318,
    4852,   802,  -992,   202,  1044, -1536,  4468,   805,  2389,  2597,
     322,   325,   239,  2389,  2622,   317,  2342,  3535,  3536,  3537,
    3538,   356,   357,  2389,  1145,   325,    89,  2872, -2430, -2430,
    1142,  2613,  3253,  4740,   358,  3346, -3132,    90,   903,  3880,
    2739,  1829,  3786,   341, -3132,  2738,  4429,  1643,  3646,  4148,
    3648,   317,  4396,  4005,   322, -3291,  1846,  3664,   207, -3291,
     322,  1748, -3439,   744,   322,  2389,  2091,  4279,  1826,  1686,
   -2222,   534, -3439,   317, -3126,  2343,  3621,   319,  3583,   209,
     209,   760,   534,   207,  2152,  1312, -2222,  4753,   323,   209,
    1313,   322,  2023,   320,   761,  1640,   591,  2663,   325,  3471,
    1952,   592,  3170,  2603,   288,  4048,  2389, -3439, -3124,  4085,
    2344,  4873,  3718,  3226,  2793,  3434,  3879,  2330, -3119, -3439,
    3284,  3948,  3731,  1695, -3427,  2714,   225,  4033,  3094, -3439,
    4062,  1896,   323,  1347,   288,  3464,  4722,  3525,   323,  2979,
    4576,  4042,   323,  2139,  3780,   225, -3321, -3321,    59,  3781,
     207,   911,  1044,  4006,   593,  4658,  3069,  3070,  3254,   822,
    2627,  3553,  4218,  1321,  2022,   288,  3981,  3136,   318,   323,
     937,  1421,  3285,  1322,  1696,  2553,   207,  3271,  2881,  2554,
   -3356, -3439,   184,  4293,  4430, -3439,  4547,  2820,  1963,  1205,
     268,   325,  1043,    59,  2143, -3321,  4460,  3831,  3140,  3141,
     803,  3975,  1236,  2671,    -7,   207,  1665,  4702,  1398,  3056,
    3057, -3439,   534,   225,  2717,  3059,  3060,  2120,  2345,  4310,
     207,  2159, -3439,  3554,  4334,  3556,   207,   318, -3431,  2732,
     207,  2559,  3162,  3163,  2704,   325,  1213,   862,  2992,   863,
    3903,   325,  4577,   289,  3221,   325,   319,   594,  1087, -2222,
     903,   903,   903,   903,   202,  2635,   321,   207,  2974,  2975,
    2378,  4578,   320,  3620,  1019,  2319,  3591,  4140,  3902,  3782,
    2079,  2722,   325,   289,  3124,  2604,  3126,  4295,  1811,  3128,
    2725,  1896,  3130,  3131,  3132,  2327,  3134,  3133,  2617,  3138,
    1963,  3982,  3786,  3171,    87,  4569,  3621,  4430,  4469,  3220,
    3150,  3151,  4620,  2595,   289,   319,   921,   225,   318,   262,
    2352,  4149,  4150,   804,  1214,  2887,  2873,   225,  2386,  4320,
    4234,   320,  4461,  2489,  3641,  2813,  3643, -2917,  1213,  3596,
    1216,  2346,  4072,  3833,   917,  2814, -3321,     9,  2617,  2800,
    3284, -3472,  2995,  3100,   760,  2976,  3258,  3384,  1338,   921,
    1087,   290,  4246,   952,  3973,  -324,  2312,  2513,  2399,  4920,
    3278,  4181, -3397,  2510,  3282,  2510,   735,  2510,  2510,  3182,
    2510,  2510,   953,   870,  3795,   225,   342,  3174, -2222,  3410,
   -3439,   290,  3208,  3530,  3210,   322,   319,  4141,  2332, -3439,
    3454, -3291,  3285,  3852,  4320, -1988,  4874,  4876,  3983,  2921,
     318,   343,   320, -3441, -3041,  4462,  1214,   777,  3455,  2281,
    4569,  3083,   290,  2597,  2911,    89,   805,  4353,  1648,    75,
    4579, -3321,  1216, -1520,  1145,   321,  4914,  4354, -3473,  3329,
    3891, -3439, -3439,  1016,  2827,  4234,   318,  1653, -3439,  4477,
    2732,   778,  2282,  3320,  2993,  4909,    77, -3439,  1666,  1211,
    3251,  4456,     3,  4547,   739,  3984, -2222,   543,   318,   859,
     860, -3440,  3663,   323,    59,  3256,  4381,  4550,  2798,  2739,
    2672,  3385,   922,  2504,  1016,  2379,  2117,  4431,   319,  4470,
     202,   202,  3868,    12,   321,   544,  1686,  2757,  1013,  1441,
      -6, -3439,  4364,  1218,   320,  2350,  4420,  2618,  4275,  3413,
     225,  3834,   269,   903,  3113,  2904,  2821,  2347, -3421,  2910,
    2605,  4365, -3439,  4432,   319,  3678,   817,  3679,  4728,  3785,
    3311,   941,  4205,  4206,  1963,  4924,   534,  3831,  4366,   202,
     320,   954,  4807,   823,  3689,  2404,   319,  4925,   225,  3597,
     534,  1399,  1237, -3439, -2222, -3291, -3291,  2618, -3132,   910,
     910,  2773,   320,   291,   322,   534,    59,  2414,   282, -2222,
    1339,  2477,  2480,  2980,  2483,   321,   325,  2488,  2490,  4621,
    2492,   -69,  4324,  1338,  2387,  3067,  3622, -3431,  2918,  1159,
    2748,   941, -2848,   545,   344,  1218,  1692,  2140,  4921,   824,
    4431,  3137,  2874,  3974,   534,  1043,    15,  2642,   534,  1021,
     207,  1159,   736,  3058,    59,   207,   821,  1963,   825,  4420,
    3820,   534,    16,   322,    17,  1842,   248,  2521,  2522,   207,
    3314, -3421,  1219,  4551,  2101,   207,  4432,  2855,  2857,  2631,
    2028,  4274,   323,   740,  2795,   534,  3183,  1238,   903,   903,
     903,  3006,  2650,  3052,  2563,   903,   903,   903, -3321,  2651,
    2564,  2565,  2881,  3146, -2917,  2567,  1212,   321,  3084,  4267,
    3121,   903,  4210,   207,   903,  2555,  2556,   988,  3598,  3513,
     903,   903,   903,   903,   903,   903,   903,   903,   903,   903,
     903,   903,  3321,   769,  1050,  1052,   209,   207,  3601,    -6,
   -3439,   323, -1520,   321,   322,  3139, -3321,   752, -1520,  3118,
    4059,  3783,  4715, -3341,  4238,   207,  3452,   903,  4463,  2798,
     543,  2798,   903,  2561,  1219,   321,    79, -3370,   534,   207,
     207, -1988,   910,    -6,   780,    -6,  2977,   263,   283,  4464,
    2022,  3985,  3976,  3386,  4550,   325,  3172,  3357,  3358,  3359,
    -324,  1044,   207, -3041,  2981, -3041, -3041, -3041, -3041, -3041,
   -3041,  4552,  1044,   781,  3821,   207,   234,   910,    59,   910,
    -885,  4382,  3487,  2749,  4730,   955,   225,  3599,  2617,  1952,
     782,   783,   323,  3173,  1375,   509,  2891,   207,  4105,   207,
     207,   207,  2779,   910,   202,  1339,   322,  2652,   207,  3168,
   -1988,   207,  2647,  4417,   325,  3690,  3622, -1520, -3441,  3663,
    3099,  3526,  3456,  1222,  4117,  3360,  1842,  2754,   910, -3441,
      27,  1213,   741,  4810, -3041, -3472,   207,   207,  -324,  2798,
    2798,  2732,   322,   207,  2978,  3892,  4848,  3986,  2673,  2674,
   -3472, -1520,  3713, -1520,  -324,  2855,  3893,  2855,  2684,  4454,
    4455,  4727,   910,  3361,   322,   534,  1044,  4696,   207,  3156,
   -3439,  2875,   941,  2876,  3623,  3624,   941,  1299,  4625,  4055,
     324,  3149,  2877,  2878,   323,  3014,  2879,  2880, -1495,  4625,
    2905,  4060,  4061,  3875,  4052,   325,  1652,    28,   917,  1931,
    2760,  3634,  3635,   133,  1654,   207,  3161,   742,  4697,  1214,
    4551,   245,  1215,   784,  3174,  1222,  3209,  4704,  3211,   770,
     323,  1686, -3473,   771,  1160,  1216,  2149,  3410,  4001,  3669,
    1005,  3670,   945,  1161,   583,   584,  3650, -3473,   534,  2149,
    3188,  3015,   323,  3213,  4086,   534,  1160,  4853,  2786,  4253,
    4051,  1063,  2128,   753,  1070,  1161,  2129,  1217,  1084,  2130,
    2131,   743,  1676,  -885,    33,  4438,  3542, -3439, -3321,  2087,
    2088,  2089,    47,  4728,  4159,  3457,   534,   941,  2824,  1299,
    3423,    -6,  4493,   235,   937,  3410,  3543,   325,  4160,  4812,
    2824,  2092,  2093,  1432,  1441,   903,  2799,  2618,  3250,   919,
     910,  2648,  2129,   318,  4106,  2130,  2131,  1076,   207,  3466,
    3458,  2904,  1686,  1905,   744,  3937,  1729,  -324,  1446,  3459,
    1906,  4449,  2499,   325,  3410,  2708,   509,  1652,  4438, -3041,
     207,  4728,  3600,   772,  4254,  1660,  4692,  3572,  4552,  1686,
   -3323,  4678,  4679,  4695,  1629,   325,  3601,  3415,  4699,    43,
    1134,  4701,  1376,   585,   937,  4253,  2804,  2805,  2806,  2807,
    2808,  2809,  2810,  2811,  4418,  2863,  4731,  4736,  4107,  2094,
    2095,  2651,    52,  1377,  1771,  2090,  1677,   246,  3299,  2500,
    1312,   319,   785,  1652,   191,  1313,  1162,  4759,  1218, -1520,
    1054,  3328,  2907,   786, -2276,  3108,  3063,   320,  3065,  2052,
    2510,   207, -3370,   225,  4760,  3417,  4186,  1711,  1162,   207,
    4494,  1299,  4713,  4714,   202,  3876,  3422,  4813,  1312,  2539,
    1772,  3425,  3427,  1313,   225,  1702,   903,   207,  1375,  1994,
    1661,  3368,  1013,    54,  4108,  4495,  4496,  4497,  3682,  1744,
    4761,  1359,   745,  1163,  3419,    59,  -324,  2985,    56, -3439,
    4194,   796,  4756,  4404,  2998,  4757,  3807,  3398,  4370,  4866,
    4840,  3107,  4867,  3107,    59,  1163,  3862,   134,  1006,  1159,
     135,   136,  1007,  3467,  4450,  2366, -3312,  4371,  4417,    58,
    4451,  1995,   941,   941,   941,  1164,  1773,  4910,  3713,  3954,
    4609,  4610,   225,  4840,   917,  1367, -2276,    59,  4762,  4861,
    2866,   318,  1008,  3186,  3187,  3651,  3121,  1164,  3574,  2652,
    3541,  4405,  4895, -3421,  4729, -2276,  4871,  1219,  1905,  4730,
    2870,  4763,  1220,  1221,  -324,  1906,   787,  4781,  2367,  4868,
    1703,   317,  2893,  2894,  2895,  2575,  1704,  2799,  4896,  2799,
   -3082,  2973,  1044,  2872, -3082,  3154,  4728,  2091,  2919,  2920,
    2922,  3912,  3913,  4406,   108,  2477,  3284,  3516,  4930,  4931,
     321,  3575,   797,   798,   236,   318,  4929,   788,  2798,  1044,
     941,  3107,  3107,  4865,   910,   910,  4842,  4730,  -324,   319,
     110,    61,  4782,  3602,   509,  4916,   789,  4194,  4220,   586,
    4243,  4897,  -324,  1962,    63,   320,   226,   108,  4943,   227,
    4918,    68,  1165,  3000,   108,  3129,  1009,  3874,  3285,  1969,
   -1133,  1640,  -324,  3362,   118,   111,  3632,  3633,  4726,  4776,
    1312,  4917,   120,   110,  1165,  1313,  2888,  -324,  3335,  2732,
     110,   990,   125,  4777,  2092,  2093,  4919,  3178,  4932,  1312,
     130, -3421,   991,   529,  1313,  3529,  4747,  2799,  2799,  2336,
    4748,  4385,  3514,  3515,  4726,   138,  1312,  4419,   111,   320,
    2337,  1313,  1933,  1936,  1939,   111, -3421, -3421, -3421, -1133,
     910,  4776,  1307,  1308, -2276,  1310,  4420, -1495,  3613,   318,
    1299, -1133,   139,  3105,  2540,  4777,  2541,  4628,  1968,   322,
    3111,  3568,   318,  4421,  2065,  2067,  4634,   142,  1222,   209,
   -3291,  3272,  2144,   176,  1719,  4637,  2542,  1377,   317,  1686,
    1720,  2732,  2094,  2095,  2507,  2508,   772,  1686,  2484,    59,
    2872,  2146,  2147,  2148,  2485,  1432,  4450,  2392, -1133,  4418,
    2625,   226,  4451,  1774,   227,  4877,  4781,  1312,   772,  2581,
    1312,  1312,  1313,   145,  2582,  1313,  1313,  4900,  3545,    59,
    3517, -1133,  4902,  4898,  3518,  3657,  1775,   319,   321,  3658,
    2132,  2133,   146,  2408,  2786,  2409,  2102,   323,  2103,  4095,
     529,  3327,   147,   320,  1044,  4953,  3235,  4954,  1044,  4955,
    2381,  2096,   153,  1044,  2381,  1044,   320,  1044,  1640,  3077,
     154,  4878,  4730,  3077,  1160, -3009, -3009, -3009, -3009,  3726,
     202,  1652,  2649,  1161,  3813,  3814,  2132,  2133,   160,   207,
   -1133,   176,  2134,  2135,  4680,  4681,  2097,  2540,   209,  2541,
    4771,  4000,   321,   180,    55,  2098,    57,   186,  4776,   237,
     238,   189,  2873,   207,  2099,   941,  3095,  4839,   195,  1652,
     210,  1652,  4777,   941,   218,  4037,  1972,  1973,  4789,  4790,
    3115,  3116,   790,   791,  4794,   207,   241,  4834,  2134,  2135,
     242,  4835,  4836,  1947,  1948,  4570, -3041,  1213,  3826,   256,
     325,  1391,  1392,  1393,  1394, -3041, -3041,  2100, -3421,  1145,
   -3041,  1044,  3236,  4057,  1044,   910,  3779,   322,   286,  1652,
     281,  3777,  1044,  1044,  1044, -1133,   285,   317,   338,  4068,
    1652,   291,   941,   311,   941,  1441,   339,   349,   361,  2872,
   -3008, -3008, -3008, -3008,   503,   538,   318,  3414,  3416,  3418,
    3420,   539,  4611,  2708,   850,   547,   769,   548,   555,  2274,
     851,   852,   568,   570,   581,   289,   321, -2058,   737,  2510,
    2510,   755,  2510,  2510,  3063,  1214,   854,  3478,  1215,   321,
     756,   322,   793,   813,   814,   225,  1162,  1648,  1776,   819,
     820,  1216,   826,  1777,   828,   323,   829,   827,   941, -1133,
     941,   835,  2732,   839,   943,   859,   860,  1640,  1002,  1016,
    2798,  1029,  1038,  1778,  1053,  1779,  3477,  1054,  1116,  1062,
     239,  2338,  3930,  1217,   319,  1136,  1170,   509,  3353,  4182,
    4183,  1145,  1169,  1186,  1191,  1711, -3421,  1203,  1201,  2873,
     320,  1208,  2360,  1163,  1903,  1904,  3951,  1234,  1246,  1258,
    1250,  1273,  4419,  1277,  1275,  3492,  3493,  1280,  1281,   323,
    1282, -3421, -3421, -3421,  1284,  1287,  1288,  1289,  2385,  1290,
     941,  4420,  1323,  1293,  1295,  1303,  1305,  1327,  4292,  1306,
    1330, -1133,  1044,   207,  1332,  1164,  1344,  1350,  4421,  3742,
    1357,  3924,  1359,  1361,  1364,   322,  1366,  1369,   325,   903,
     903,  1371,  1373,  1386,  1395,  1396,  2799,  1400,   322,  1437,
    3856,  1439,  3857, -1133,  1442,  1447,  1617,  1627,  1648,  1630,
    4280,  4281,  1631,   318,  1633,  4286,  1655,  1656,  1658,  3504,
    1663,  1668,  1670,  1673,  1674,  2101,   941,  1678,  2874,  2102,
    1679,  2103,  1687,  3462,  1087,  3939,  3463,  1691,  1905,  1698,
    1700,   855,   856,   857,  1218,  1906,  1706,   166,  1907,  3470,
    1708,   941,   325,   858,  1714,  3564,  4351,  3479,  3480,  2510,
    1722,  1724,   770,   323,  1648,  -930,   771,  3571,  1727,  1730,
    1738,  1731,   859,   860,  1760,  1740,   323,  -930,  1761,  1766,
    1748,   318,  1770,   202,  1809,  1823,  1839, -1710,  1850,  1902,
    1932,   319,  1165,   321,  1955,  1965,  1943,  1944,  1984,  1954,
    1970,  3607,  4256,  1908, -1133,  1986,   911,   320,  1909,  1910,
    3506,  2000,  2006,  3619,  2013,  1376,  2163,  2117,  2873,  2057,
    2123,  3586,  2069,  2059,   610,  2138,  2271,  2275,  3428,  2278,
    2283,  2313,  3749,  4239,  3237,  1780,  2316,  3953,  2314,  2321,
     534,  2328,   861,  4879,   910,  -930,  2329,  2331,  2339,  3571,
    3523,  2355,  2357,  4880,  4881,  2358,  2362,  4474,  2361,   319,
    2364,  2372,   903,   864,   865,   866,   325,  2371,  3742,  2374,
    2376,  2394,   867,  1219,  2396,   320,   772,  2406,  2405,   325,
   -1133,  2416,  2481,  3672, -1133,  2493,  2495,  1652,  2496,   534,
    1652,  3750,  1911,  2516,  1912, -3058,  4379,   903,    84,   903,
    2530,  1913,   318,  3751,  2550,  2874,   772,  2551,  2575,  2580,
    1914,  2577,  2578,  4139,  2584,  2585,  2592,  2588,  2590,  2798,
    2591,  2594,   322,   903,  2600,  2602,  2608, -2964,  2609,  2610,
    1299,  2612,  2615,  2640,  4882,  2626,  2643,  2628,  1652,  3924,
    2632,  1652,  1044,  1652,  2634,  2644,  2691,  4559,   903,  2645,
    3752,  2693,  2657,  4444,  2694,  2698,  4883,  4884,   869,  2705,
    2699,   859,   860,  2702,  2723,  2719, -1133,  3723,  2151,  3725,
     321,  2751,  2759,  3753,  1228,  1058,  2787,  3587,  2774,  1652,
     319,  2794,   903,  2829,  2802,  2831,  2840,  2875,  2842,  2876,
    2510,  2844,  2847,  4080,  4129,  4130,   320,  2849,  2877,  2878,
     323,  2861,  2879,  2880,  2852,  3428,  1229,  1230,  2859,  1974,
    1975,  1976,  1977,  1978,  1979,  1980,  1981,  1982,  1983,  2868,
    1915,  2886,  2887,  2891,  2911,  2901,  2914, -1133,  2984,  3787,
    2900,  2999,  3754,    85,  2909,  2913,  3793,  3640,   321,   941,
    3095,   941,  3112,  3074,  2925,  2708,  1896,  3127,  2989, -3040,
    2617,  2618,  3158,  3159,  1222,  2652,  3184,  2651,  3677,  3586,
    3214,  3215,  3217,  3680,  1796,  3818,  -930,  3222,  3229,  3230,
    3231,  1916,  3245,  3262,  3825,  1917,  3263,  3305,  2779,  3288,
    3312,  3315,   941,  2756,  3324,  3317,  3313,  3338,  3337,  3341,
    3342,  3835,  3350,   871,  2874,  4207,  3348,  3356,  3564,   322,
    3369,  3354,  3376,   325,  3379,  3392,  3381, -1133,  2799,  1918,
    3571,  3382,  1087,  3399,  3407,  3421,  3432,  3755,  3728,  4581,
     903,  3438,  3436,  3441,  3444,  3446,   287,  3449,  4229,  3468,
    3481,  2798,  3737,  3482,  3483,  3906,  3907,  3484,  3491,    82,
    3509,  4287,   941,  3489,  3507,  3511,  3522,  3527, -2969,  3607,
    -930, -3038,  3531,  3559,  3573,  3581,  3555,  3557, -3033,   321,
    3589,  3592,  4296,  3595,  2875,  3609,  2876,   322,  3614, -1133,
    3615,  3273,  3274,  3629,  4209,  2877,  2878,   323,  3630,  2879,
    2880,  3300,  1648,  3666,  3301,  3693,  4255,  3668,  3673,  3674,
    3681,  3757,  3716,   872,   873,  3719,  3799,  3800,  1686,   941,
    3721,  3806,  3732,  3809,  3810,  3811,  3812,  2559,  3748,  -930,
    -930,  3746,  3778,  3819,  4559,  3587,  3936,  3775,  3822,  3827,
    1648,  3828,  1648,  3832,  3841,  3837,  3843,  3853,  -930,  1652,
    3858,  3863,  3864,  3574,  3575,  3868,  3873, -3440,  3890,  3836,
    3895,  3897,  3904,  4348,  -930,   323,  3905,  3651,  3650,  3940,
    3942,  1261,  3931,  3956,  3946,  2803,  3960,  1182,  3238,  3961,
    4309,  3964,  3958,   875,  2798,  3971,  3988,  3950,  3965,  3991,
    1648,  3978,  3992,  3758,  4069,  4831,  3955,   209,  1652,  4096,
     325,  1648,  4073,  4081,  4075,  4103,  4123,  4127,   322,  4146,
     876,  4043,  4145,  3797,  3797,  4151,  4152,  4158,   877,  3189,
    4122,  3190,  4187,  4157,  3957,  3760,  4180,  4185,  4216,  4225,
     209,  4226,  4231,  1686,  4131,  4105,  4249,   209,  4262,  4277,
    4189,  4300,  4301,  4297, -2003,  4342,   878,  4336,  4361,  4303,
    4316,  4337,  4341,   207,  4343,  4349,  4373,  3999,  1919,  4357,
    4386,  4401,  -930,  4414,  3963, -3291,  4412,  3898,   325, -3291,
    4372,  4376,  4384,  2875,  1044,  2876,  4413,  4415,  4447,  4445,
    4476,  4485,  4479,  4488,  2877,  2878,   323,  4489,  2879,  2880,
    4492,  4498,  4501,  4502,  4010,  4011,  4012,  2510,  4361,  4505,
    4566,  2569,  4050,  4575,  4636,  4648,   941,  4684,   941,  4685,
    4791,  4893,  4837,  4946,   903,   903,  3945,  4944,  4945,  4951,
    2087,  2088,  2089,    35,  3076,  4957,  4441,  -930,  3505,  2504,
     129,   250,   578,    32,  1830,  2561,   171,  2526,  4008,  3881,
     546,  3835,   308,  1920,  4032,  3502,  2904,  2799,   558,  4035,
    4036,  3071,   174,   574,  1921,  1232,  4475,  4039,  1816,  4041,
     562,   222,  -930,   811,   309,  1922,   812,  4380,  3033,  4273,
    4656,  4257,  3808,  4333,   806,  3488,  3829,  3816,  1253,    67,
    4326,  4154,  3798,  4490,  4416,  4503,  3692,  2762,  1177,   325,
    2413,  2928,  4808,  4809,  2968,  2969,  4933,  4322,  4245,  3936,
    2750,  3744,  3762,  4377,  3740,  3738,  3763,  1686,  4814,  3352,
     903,  3073,   317,  4725,  4770,  4822,  3409,  4013,  4014,  4901,
    4015,  4899,  4315,  1073,  2872,  4707,  2090,  4443,  4651,  1045,
    4629,  2145,  4737,  4630,  4633,  4649,  1923,  4118,  1626,  4047,
    2529,  3920,  2535,  3508,  4184,   502,  1841,  1847,  3524,  3520,
    1890,  3155,  2570,  4009,  3845,  2630,  -930,  3918,  4285,  1329,
    4283,  1993,   989,  3723,  2667,  1335,  1382,  2064,  2012,  3860,
    2686,  3540,  4040,  1924,  1390,  3169,  1046,   209,  2068,  4044,
    4045,  2701,  2083,  2070,  4162,  3212,  1440,  3861,  3764,  2715,
    3565,  2510,  1640,  3566,  1615,  2137,  2744,  3579,  3232,  3872,
    3871,  4214,  2375,  4088,  3889,  1634,  2764,  3611,  4155,  1657,
    2776,  1445,  3269,  3628,  3618,  3626,  3319,  2384,  3331,  2377,
    3191,  -930,  2324,  -930,  2812,  4067,  1688,  1106,  3334,  2837,
    4070,  4071,  -930,  -930,  -930,  1689,  -930,  -930,  3645,  2838,
    4408,  2320,   209,  2354,  4305,  2788,  2775,  4156,  4390,  3765,
    4098,   209,  4212,  3929,  4458,  4574,  4473,   209,  3087,  2799,
     209,  2397,   209,   209,  2020,  3093,  3145,  2018,  1648,  3143,
     209,  1648,   209,  3649,   209,  4083,  3639,  4173,  3637,  3656,
    3167,  3915,  1652,  3917,  3165,  1334, -3380, -2003,  1099,  2086,
    3295,  3296,  4104,  1044,  3297,  3952,  1133,  3298,  2091,  2716,
    1988, -3291,  4125,  3791,  3448,  3192,   565,  1737,  3005,  2708,
    4087,  4016,  4017,  4078,  2801,  4230,  4138,  4632,  3774,  1648,
    1991,  4323,  1648,  1121,  1648,   903,  3068,  1247,  4657,  3768,
    2415,  1233,  1294,  3440,  4330,  3160,  4018,  -930,  3292,  2818,
    4270,  4272,  4270,  4248,  3642, -3380,  4615,    72,  3909,  2983,
    4829,  1792,  4221,  3546,  3567,  4054,  4259, -3380,  4863,  4749,
    1648,  3308,  4019,  1276,  4923,   569,  4754,  4241,  4242,  3594,
    4294,  4846,   580,  3794,  2854,  2683,  3734,  2558,  4567,  4751,
    3064,  4773,  2487,  4887,  4038,  2092,  2093,  4020,     0,  3333,
    3333,  3770,  2799,  4179,     0,  4743,     0,     0,     0,     0,
       0,  4290,  4291,     0, -3380,     0,     0,     0,     0,     0,
       0,     0,     0,  2873,     0,  4773,  4755,     0,     0,     0,
       0,  4204,  4328,     0,     0,     0,  4356, -3380,  4328,     0,
    3367,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4213,   209,   209,     0,     0,  4215,     0,
       0,     0,    73,     0,  3193, -3291, -3291,     0,     0,     0,
     209,     0,     0,  2094,  2095,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4161,     0,
    4403,     0,     0,     0,     0,     0, -3380,     0,     0,  4021,
     209,     0,     0,  4325,   209,     0,     0,   318,     0,     0,
       0,     0,     0,  4332,  4332,  1044,     0,     0,     0,  2918,
      74,     0,     0,    75,     0,    76,     0,     0,   917,  4276,
       0,  4261,  4022,     0,     0,     0,  4023,  4024,     0,     0,
       0,     0,  2096,     0,     0,     0,     0,     0,     0,     0,
      77,     0,     0,     0,     0,     0,     0,     0,  4457,     0,
   -2003,     0,     0,     0,  4025,   917,   859,   860,     0,     0,
       0,     0,     0,   910,   910,  4934,     0,  2097,     0,     0,
       0, -3380,     0,     0,     0,   319,  2098,     0,     0,     0,
     209,   209,     0,     0,     0,  2099,     0,     0,     0,     0,
       0,   320,     0,   910,     0,     0,   941,  3194,  4321,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4258,     0,
    1648,     0,     0,     0,  4260,     0,     0,  4270,     0,     0,
       0,  4448,     0,     0,     0,     0,     0,     0,  2100,  4338,
       0,   209,     0,     0,     0,    78, -3380,     0,  1044,     0,
       0,     0,     0,     0,     0, -3380,  4564,     0,     0,     0,
       0,     0,     0,     0,     0,   917,     0,     0,     0,  1648,
       0,     0,     0,     0,   903,     0,     0,     0,     0,     0,
       0,     0,  4617,     0,     0,     0,     0,     0, -2003,     0,
    2319,  4383,     0,     0,  4583,   749,     0,     0,     0,  2874,
       0,     0,     0,  4387,  4388,  4389,     0,     0,     0,  4391,
    3195,     0,   941,     0,  2510,   209,   209,     0,     0,     0,
    3539,     0,     0,     0,  4411,     0,   209,   209,  4708,     0,
       0,     0,  4026,     0,     0,     0,     0, -3380,     0,     0,
       0,     0,  4270,     0, -3380,     0,     0,  4635,     0,     0,
       0,     0,     0,     0,     0,     0,  4459,     0,     0,     0,
       0,     0,     0,     0,   321,     0,     0,     0,     0, -3380,
       0,  4478,     0,     0,  4481,  4482,  4483,  4484,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   534,     0,     0,     0,  1299, -3380,     0,  1044,
       0,     0,  4560,     0,     0,     0,     0,     0,     0,  3612,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      79,     0,     0,  4076,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4698,   209,     0,     0,  4588,  4589,  4590,
    4591,  4592,  4705,     0,  4594,  4595,  4596,  4597,  4598,  4599,
    4600,  4601,  4602,  4603,  4604,     0,  2101,  4606,     0,  4616,
    2102,  4619,  2103,  1191,     0,     0,     0,     0,     0,     0,
    4626,  4627,     0,     0,  4631,     0,   848,     0,   905,     0,
       0,   927,     0,   322,     0,     0,   950,  4720,   985,     0,
       0,     0,   999,     0,     0,     0,  4639,     0,  4641,     0,
       0,     0,  1037,     0,    80,  1037,     0,     0,    81,     0,
       0,  3715,  1066,     0,     0,     0,  4752,     0,     0,  -635,
       0,     0,     0,     0,     0,     0,  1122,     0,  1128,  1131,
       0,     0,     0,     0,     0,     0, -3380,     0,     0,     0,
   -3380,     0,  1144,     0,     0,     0,     0,     0,  2875,     0,
    2876,     0,     0,     0,     0,     0,  4720,     0,     0,  2877,
    2878,   323,     0,  2879,  2880,   909,     0,     0,     0,     0,
     942,  1652,     0,     0,     0,  4693,     0,  4694,     0,     0,
       0,     0,   942,     0,  4720,  4720,     0,   942,  4703,     0,
    4720,     0,     0,  4720,     0,     0,     0,  4720,  4720,     0,
       0,     0,  -635,     0,     0,  1652,   942,  4844,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -3380,     0,     0,     0,     0,    82,     0,     0,
       0,  4862,     0,     0,     0,     0,     0,  4724,     0,     0,
       0,     0,     0,  1648,     0,     0,     0,     0,  4872,     0,
       0,  1279,  -635,     0,     0,  -635,  -635,     0,     0,  4560,
       0,  4720,  -635,     0,   325,  4862,  4720,    83,     0,  -635,
    1044,  3847,  3848,  3849,  3850,     0,  4908,  1044,     0,     0,
       0,     0,  1044, -3380,     0,  1044,     0,     0,     0,     0,
     905,   905,   905,   905,     0,     0,     0, -3380,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4779,  4780,    84,  4785,    85,     0,     0,     0,
       0, -3380,   927,     0,     0,     0,     0,     0,     0,     0,
    4788,     0,     0,     0,     0,  4792,  4793,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -635,  -635,    86,  1363,
       0,  4956,     0,  4843,     0,     0,  4845,     0,  4847,     0,
      87,     0,     0, -3380,     0,     0,     0,     0,     0,  1301,
       0,     0,     0,     0,     0,     0,     0,   909,   909,   909,
     909,     0,     0,     0,     0,     0,  1044,     0,  1325,  1044,
       0,     0,     0,     0,     0,     0,     0,     0,    88,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -3380,     0,     0,     0,     0,  1066,     0,
       0,   942,     0,     0,     0, -3380,     0,     0,     0,     0,
       0,  1452, -3380,     0, -3380,     0,     0,  3749,   999,     0,
       0,     0,     0,     0,     0,     0,  4795,  3715,     0,     0,
       0,     0,     0,  1179,     0,     0,     0,     0,  1650,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   317,
       0,    89,     0,  1684,     0,     0,     0,     0,     0,     0,
       0,     0,    90,     0,     0,     0,  3750,   942,     0,     0,
       0,     0,     0,     0,     0,  -635,     0,     0,  3751,     0,
    1712,     0,     0,   942,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1726,  2419,
       0,     0,     0,     0,     0,  1733,  1735,     0,     0,     0,
       0,     0,     0,   905,     0,     0,  1751,  1753,     0,     0,
       0,     0,     0,     0,     0,  3752,     0,     0,     0,  -635,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1685,  -635,     0,     0,     0,     0,     0,     0,  3753,  4796,
     942,     0,  1905,  4797,     0,     0,     0,   942,  -635,  1906,
       0,     0,  -635,     0,  -635,     0,  1159,     0,     0,  4063,
       0,     0,     0,  -635,   902,  4065,  4066,     0,     0,   935,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   935,     0,     0,     0,     0,   935,   850,     0,     0,
     909,     0,     0,   851,   852,     0,     0,  3754,     0,     0,
       0,  -635,     0,     0,     0,   935,     0,     0,     0,   854,
       0,     0,     0,     0,  -635,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1900,  1901,     0,     0,     0,     0,     0,   905,   905,
     905,     0,     0,     0,     0,   905,   905,   905,  1950,     0,
       0,  1950,     0,     0,     0,     0,     0,     0,  -635,     0,
       0,   905,     0,  1950,   905,     0,     0,     0,     0,     0,
     905,   905,   905,   905,   905,   905,   905,   905,   905,   905,
     905,   905,  3755,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1128,     0,  1992,  -635,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -635,   905,     0,     0,
       0,     0,   905,     0,     0,     0,  -635,     0,     0,     0,
       0,     0,     0,     0,     0,   909,   909,   909,     0,     0,
       0,     0,   909,   909,   909,  1951,     0,     0,  1951,     0,
       0,     0,  1964,     0,     0,     0,  2055,  3756,   909,     0,
    1951,   909,     0,     0,     0,  4202,  3757,   909,   909,   909,
     909,   909,   909,   909,   909,   909,   909,   909,   909,     0,
       0,     0,     0,  -635,     0,     0,   902,   902,   902,   902,
       0,     0,     0,     0,   855,   856,   857,     0,     0,     0,
       0,     0,  4798,     0,   909,     0,   858,     0,     0,   909,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  -635,     0,     0,     0,     0,
     935,     0,     0,     0,   318,     0,     0,     0,     0,     0,
       0,     0,     0,  2056,     0,     0,     0,     0,  3758,     0,
       0,     0,     0,     0,  1964,  3759,  2425,     0,     0,     0,
    -635,     0,     0,     0,     0,     0,     0,     0, -3412,     0,
       0,     0,  -635,     0,     0,     0,     0,     0,     0,     0,
    3760,     0,     0,     0,     0,  4799,     0,     0,     0,  4800,
       0,  1160,     0,     0,     0,   861,     0,     0,     0,     0,
    1161,     0,  1648,     0,  -635,     0,   935,     0,  3761,     0,
       0,     0,   319,     0,     0,     0,   864,   865,   866,     0,
       0,     0,   935,     0,     0,   867,     0,     0,   320,     0,
       0,     0,     0,   903,   903,     0,  1648,     0,     0,     0,
       0,     0,  -635,     0,     0,     0,     0,     0,     0,     0,
       0,  4801,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   903,     0,  -635,     0,     0,     0,     0,
       0,     0,  -635,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   905,     0,     0,     0,   935,
       0,     0,     0,     0,     0,  4802,   935,     0,  -635,     0,
       0,     0,     0,     0,     0,     0,     0,  -635,     0,     0,
       0,   869,     0,     0,     0,  -635,     0,  -635,  2333,     0,
    -635,     0,     0,     0,   317,     0,     0,     0,     0,     0,
       0,     0,  2428,     0,     0,     0,  2318,     0,     0,   902,
     218,     0,     0,  4803,     0,     0,     0,  2325,     0,     0,
       0,     0,     0,  1162,     0,     0,  -635,  3762,     0,     0,
       0,  3763,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   909,     0,     0,     0,  2353,     0,     0,     0,
       0,     0,     0,     0,     0,   942,     0,     0,  1964,     0,
       0,   321,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2383,     0,
    1163,     0,  2029,  2030,  2031,  2032,   905,     0,     0,     0,
    2033,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2034,  2035,
       0,     0,     0,  3764,     0,   942,   871,     0,     0,     0,
       0,     0,  1164,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1964,   850,     0,   902,   902,   902,     0,   851,   852,
       0,   902,   902,   902,     0,     0,     0,  2433,     0,  2036,
       0,  1960,     0,     0,   854,     0,     0,   902,     0,  4804,
     902,     0,     0,   909,  3765,     0,   902,   902,   902,   902,
     902,   902,   902,   902,   902,   902,   902,   902,  3766,     0,
     322,     0,     0,     0,     0,     0,  2037,     0,  2038,     0,
       0,  4805,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3767,   902,     0,     0,   872,   873,   902,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1900,     0,     0,     0,     0,     0,  1165,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1684,
       0,     0,     0,     0,  3768,     0,     0,     0, -1827,     0,
       0,     0, -3412,  1960, -1827,     0,  2334,     0,   323,  4806,
    2598,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1950,     0,     0,     0,     0,     0,   875,     0,     0,     0,
       0,     0,     0,     0,     0,  4544,     0,     0,     0,     0,
       0,     0,     0,     0,  3769,     0,     0,     0,     0,     0,
       0,     0,  2408,   876,  2409,     0,  3770,  2440,     0,     0,
       0,   877,  2039,  3771,     0,  3772,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1685,     0,     0,   855,
     856,   857,     0,  2362,     0,     0,     0,     0,     0,   878,
       0,   858,     0,   772,     0,     0,   207,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1951,     0,     0,
       0,   325,     0,     0,     0,     0,     0,     0,     0,   318,
       0,  2040,     0,     0,     0,     0,   942,     0,     0,     0,
     942,  2055,     0,     0,     0,  2687,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -1827,     0,     0,     0,     0, -3299, -1827, -1827,
       0,     0,  2041,     0,     0,     0,     0,     0,     0,  2029,
    2030,  2031,  2032,     0, -1827,     0,     0,  2033,   859,   860,
     861,     0,     0,     0,     0,     0,     0,     0,   862,     0,
     863,     0,     0,     0,     0,  2034,  2035,   319,     0,     0,
       0,   864,   865,   866,     0,     0,     0,     0,     0,     0,
     867,     0,     0,   320,     0,     0,     0,     0,  2056,  2726,
       0,   902,  2727,     0,  2728,  2729,  2730,     0,     0,     0,
     868,   942,     0,     0,   935,     0,     0,  1960,     0,     0,
    2753,     0,     0,     0,     0,     0,  2036,     0,     0,     0,
       0,     0,  2073,     0,     0,     0,  2042,     0,     0,     0,
       0,     0,     0, -2794,     0,     0,     0,     0,     0, -2794,
       0,     0,     0, -2794, -2794, -2794,     0,     0,     0,     0,
       0, -2794,  2074,  2037,     0,  2038,     0,     0,     0,     0,
       0,     0,     0,     0,   935,     0,   869,     0,     0,     0,
       0,     0,     0,  2668, -2794, -2794, -2794, -2794, -2794, -2794,
   -2794, -2794,     0,     0,     0,  2734,     0,     0,     0,     0,
    1960,     0,     0,     0,   870,     0,     0,     0,     0,     0,
       0,   849,     0,     0,     0,     0,     0,   317,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -1827,
   -1827, -1827,   902,     0,     0,     0,     0,  1650,     0,     0,
    2772, -1827,     0,     0,  2043,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   321,     0,     0, -2794,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -1827,
       0,     0,     0,     0,  2777,     0,     0,     0,     0,  2778,
       0,     0,     0,     0,     0,  2792,  1684,     0,     0,  2039,
       0,     0,     0,     0,     0,     0,     0, -2794,     0,     0,
       0,     0,     0, -2794, -2794,     0,     0,     0,     0,     0,
       0,   871,     0,     0,     0,  2826,   942,   942,   942, -2794,
       0,     0,  2836,  2836,     0,     0,     0,     0, -1827, -1827,
   -1827,     0,  2845,     0,  2846,     0,     0,     0, -1827,     0,
   -1827,     0,     0,     0,     0,     0,     0, -1827,  2040,   905,
     905, -1827, -1827, -1827,  2858,  1876,     0,  1877,  1878,     0,
   -1827,     0,     0, -1827,     0,   850,     0,     0,     0,     0,
       0,   851,   852,  1685,     0,     0,     0,  2335,  2044,     0,
   -1827,   853,     0,  2045,     0,   322,     0,   854,     0,  2041,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   942,     0,  2734,     0,     0,     0,
       0,   872,   873,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2046,     0,     0,     0,     0,     0,     0,     0,
       0, -2794,     0,     0,  2047,     0,   909,   909,     0,     0,
       0,     0,     0,     0,     0,   935, -1827,     0,     0,   935,
   -2794,     0,     0, -1827,     0,     0,  2336,     0,     0,     0,
       0,     0,     0,   323,     0,     0,     0,  2337,     0,     0,
       0,     0,     0,     0, -1827,     0,     0,     0,     0,     0,
       0,   875,     0,  2042,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2794, -2794, -2794,     0,     0,     0,
       0,     0,     0,  3091,     0,     0, -2794,     0,   876,     0,
       0,     0,     0,     0,     0,     0,   877,     0, -2794, -2794,
       0,     0,   905,  1122,     0,     0, -1827,     0,     0,  3552,
       0,     0,     0,  2048, -2794,     0,     0,     0,  1900,     0,
       0,     0,     0,     0,   878,     0,     0,     0,     0, -3299,
     935,   207,     0,     0,     0,     0,     0,   905,     0,   905,
       0,     0,   855,   856,   857, -2794,   325,     0,     0,  1950,
       0,     0,     0,     0,   858,     0,     0,     0,     0,     0,
       0, -1827,     0,   905,     0,     0,  3153,     0,     0,     0,
       0,  2043,     0, -2794, -2794, -2794, -2794, -2794,     0,     0,
       0,     0,   318, -2794,     0, -2794,     0,     0,   905,   909,
       0,     0, -2794,     0,   850,   927, -2794, -2794, -2794,     0,
     851,   852,     0,     0,     0, -2794,     0,     0, -2794,     0,
       0,     0,  1122,     0,     0,     0,   854,     0,     0,     0,
       0,     0,   905,     0,   909, -2794,   909, -1827,     0,     0,
       0,     0,     0,     0,     0, -1827,  1951,     0,     0,     0,
       0,   859,   860,   861,     0, -2794,     0,     0,     0,   942,
     909,   862,     0,   863,     0,  3091,     0,   942,     0,     0,
     319, -1827, -1827,     0,   864,   865,   866,     0,     0,     0,
   -2794,     0,     0,   867,     0,   909,   320,     0,     0,     0,
   -2794,  3243,  1876,     0,  1877,  1878,     0,     0,     0, -2794,
       0, -2794,     0,   868,     0,     0,     0,     0, -2794,     0,
       0,  3257,     0,     0,     0,  2044, -2794,     0,     0,   909,
    2045,     0,     0, -1827,     0,     0,   942,     0,   942, -2794,
       0,     0,     0,     0,     0,  3287,     0,     0,     0,     0,
       0, -1827,     0,     0,     0,   935,   935,   935,     0,     0,
       0, -2794, -1827,     0,     0,     0,     0,     0,     0,  2046,
       0,     0,     0,  3294,     0,     0,     0,     0, -1827,   869,
     905,  2047,     0,     0,     0,     0, -1827,  2734,  1685,     0,
       0, -2794,  1684,     0,     0,     0, -3299,     0,     0,     0,
       0,     0,   942,     0,   942,     0,     0,   870,     0,     0,
       0,   855,   856,   857, -1827,     0,     0,     0,     0,  1684,
       0, -1827,     0,   858,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -1827,     0,     0,     0,
       0,     0,     0,   935,     0,     0, -2794,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   321,
       0,     0,     0,     0,     0,     0,     0,   909,     0,     0,
       0,     0,     0,  1261,   942,   902,   902,     0,     0,  1685,
    2048,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -3439, -3439, -3439, -3439,     0,     0,     0,     0, -3439,
       0,     0,     0,     0,     0,     0,  1685,     0,     0,     0,
     859,   860,   861,     0,   871,     0,     0, -3439, -3439,     0,
   -2794,     0,     0,     0,     0,     0,     0,     0,     0,  3716,
       0,     0,     0,   864,   865,   866,     0,     0,     0,     0,
     942,     0,   867,     0,     0,     0, -2794, -2794,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   942,     0, -3291, -3439,     0,
       0, -3291,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -2794,     0, -2794,   322, -2794,
       0,  2075,     0, -2794,     0, -2794, -2794, -2794, -2794,     0,
   -2794, -2794,  2076,     0,     0, -3439,     0, -3439,     0,     0,
    2029,  2030,  2031,  2032,   872,   873, -2794,     0,  2033,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   869,   874,
       0,     0,     0,     0,     0,     0,  2034,  2035,     0,     0,
       0,     0,     0, -2794,     0,     0,     0,     0,   902,     0,
       0, -2794,     0,     0,   905,   905,     0,     0,     0,     0,
       0,     0,     0,   927,     0,     0,   323,     0,  3091,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -2794,
       0,     0,     0,   902,   875,   902, -2794,  2036,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2794,     0,     0,     0,     0,     0,     0,   935,   902,
       0,   876,     0,     0,     0,     0,   935,     0,     0,   877,
       0,     0,     0,     0,  2037,     0,  2038,     0,     0,     0,
       0, -3439,     0,     0,   902,     0,     0,     0,     0,     0,
       0,   909,   909,     0,     0,     0,     0,   878,     0,     0,
     905,     0,     0,     0,   207,     0,     0,     0,     0,     0,
       0,     0,     0,   871,     0,     0,     0,     0,   902,   325,
       0,     0,     0,     0,     0,   935,  3563,   935,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1684,
   -3439,     0,     0,     0,     0,     0,     0,  3243,   849,     0,
       0,     0,     0,     0,   317,     0,     0,     0,     0,     0,
   -1579,   363,     0,     0,     0,   364,     0,     0,     0,     0,
    2772,   365,     0,     0,     0,     0,     0,     0,     0,   366,
       0, -3439,     0,     0,     0,     0,     0,   909,   367,     0,
       0,   935,     0,   935,     0,     0,     0,     0,     0,     0,
    2039,     0,     0,   942, -1579,   942,     0,     0,     0,     0,
       0,     0,     0,   872,   873,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1685,     0,     0,     0,
       0,     0,     0,     0,  1685,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   942,     0,     0,     0,
       0,     0,     0, -3291,     0,     0,   902,     0,     0,  2040,
       0,   368,   369,   935,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -3439,     0,     0,     0,     0,
       0,     0,     0,   875,     0,     0,     0,     0,     0,     0,
       0,     0,   370,     0,     0,  1264,     0,     0,     0,     0,
    2041,     0,   850,     0,     0,     0,   942,     0,   851,   852,
     876,     0,   371,     0,     0,   905,   372,     0,   877,     0,
       0,     0, -3439,     0,   854,     0,     0,     0,     0,   935,
       0,     0,     0,     0,   373,     0,     0,     0,     0,     0,
       0,     0,   927,     0,     0,     0,   878,     0,     0,     0,
       0,     0,     0,   207,   935,     0,     0,     0,     0,     0,
       0, -1579,     0,   942,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   374,
       0,     0,     0, -3439,     0,   375,     0,   376,     0,     0,
       0,   377,     0,     0,  2042,     0,   378,     0,     0,     0,
       0,     0,   909,     0,     0,     0,     0, -3291, -3291,     0,
       0,     0,     0,   379,     0, -1579,     0,     0,     0, -1579,
   -1579, -1579, -1579, -1579,     0, -1579, -1579, -1579, -1579,     0,
   -1579, -1579,     0, -1579, -1579,     0, -1579, -1579, -1579, -1579,
   -1579,     0, -1579, -1579, -1579, -1579, -1579, -1579,     0,     0,
     380,     0,  3851,     0,     0,     0,   892,     0, -1579,     0,
       0,     0,     0, -1579,     0,     0,   381,     0,     0,  3563,
       0,   382, -1579,     0,     0,     0,     0,   383,   384,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -3439,     0, -3439, -3439,     0,   855,
     856,   857,  2043,     0,     0,     0,     0,     0,     0,     0,
       0,   858,     0,     0,     0,     0,     0, -3439,     0,     0,
       0,     0, -3439,     0,     0,     0,     0,     0,   385,     0,
     902,   902,     0,     0,     0,     0,     0,   386,     0,   318,
     387,     0,     0,     0,     0,   388,     0,     0,  3908,     0,
     942,     0,   942,     0,  3910,     0,  3911,     0,     0,     0,
       0, -3439,     0,     0,     0,     0,     0,     0,   850,     0,
       0,   389,  3928, -3439,   851,   852,     0,     0,     0,   390,
       0,   391,     0,     0,   392,     0,     0,   393,     0,     0,
     854,     0,     0, -1579,     0,     0,     0,     0,   859,   860,
     861,     0,     0,   394,     0,     0,     0,     0,   862,     0,
     863,     0,     0,  1876,     0,  1877,  1878,   319,     0,     0,
       0,   864,   865,   866,     0,     0,   902,     0,     0,     0,
     867,     0,     0,   320,     0,     0,  2044,     0,     0,     0,
       0,  2045,   935,     0,   935,     0,     0,     0,     0,     0,
     868,     0,     0,     0,   905,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   395,
       0,     0, -3439,     0,     0,     0,   396,     0,   397,     0,
    2046,   398,     0,     0,     0,   935,  2022,     0,     0,     0,
       0,     0,  2047,     0,     0,     0,     0,   399,     0,     0,
       0,     0,     0,     0,     0,     0, -1579,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   869,     0,     0,     0,
       0,     0,     0,  3919,     0,     0, -1579, -1579, -1579,     0,
   -1579, -1579, -1579, -1579,   534,     0,     0,     0,     0,     0,
       0,   909,     0,     0,   870,   935,     0,     0,     0,     0,
   -1579, -1579,   400,     0,     0,     0,     0,     0,     0,     0,
    4058,     0,     0,     0,     0,   855,   856,   857,     0,     0,
       0,     0,     0,     0,     0,   401,     0,   858,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2048,     0,     0,     0,     0,   321,     0,     0,     0,
       0,     0,   935,  4079,     0,   318,  4082,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   402,     0,     0,     0,
       0,     0,   403,     0,     0,     0,     0,   404,     0,     0,
     405,   406,     0,     0,     0,     0,     0,     0,  4091,  4094,
       0,   902,     0,     0,     0,     0,     0,     0,     0,   407,
       0,   871,     0,     0,     0,     0,     0,     0,     0,  4126,
       0,     0,     0,     0,   859,   860,   861,   408,     0,     0,
       0,     0,   409,     0,   862,     0,   863,     0,     0,   410,
       0,     0,     0,   319,     0,     0,   411,   864,   865,   866,
       0,     0,     0,     0,     0,     0,   867,     0,     0,   320,
       0,     0,     0,     0,     0,   412,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3078,     0,     0,
     413,     0,     0,     0,     0,   322,   414,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -1579,     0,   415,     0,     0,     0,     0,     0,
       0,   872,   873,     0,     0,     0,     0,     0,   416,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   417,   418,
       0,     0,     0,     0,     0,     0,     0,   419,     0,     0,
     420,     0,   869,     0,     0,     0,     0,     0,     0,   935,
       0,   935,     0,     0,     0,   421,     0,  4091,     0,     0,
    4094,     0,     0,   323,     0,     0,     0,     0,  1684,     0,
     870,     0,     0,     0,     0,     0,     0, -1579,     0,     0,
       0,   875,     0,     0,     0,     0,     0,     0, -1579,     0,
       0,     0,  3079,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   423,     0,     0,     0,     0,     0,   876,   362,
     363,     0,     0,     0,   364,   424,   877,     0,     0,     0,
     365,   425,   321,     0,     0,     0,     0,     0,   366,     0,
       0,  4208,     0,     0,     0,     0,     0,   367,     0,     0,
       0,     0,     0,     0,   878,     0,   426,     0,     0,     0,
       0,   207,     0,     0,     0,  1685,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   325, -1579,     0,  4288,
       0,     0,     0,     0,     0,     0,     0,   871,     0,   427,
       0,     0,     0,  1684,   428,     0,     0,     0,     0,     0,
       0,     0, -1579,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     368,   369,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     902,   370,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   322,     0,     0,     0,  4340,     0,     0,     0,     0,
       0,   371,     0,     0,  4347,   372,     0,     0,  4352,     0,
    1685,     0,     0,     0,     0,     0,     0,   872,   873,     0,
       0,     0,     0,   373,     0,     0,     0,     0,  3123,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4347,     0,     0,  4394,  4399,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   893,   374,   323,
       0,   894,   895,     0,   375,     0,   376,     0,  4426,  4437,
     377,     0,     0,     0,     0,   378,     0,   875,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1684,     0,     0,
    4394,     0,   379,     0,     0,  4399,     0,     0,     0,     0,
       0,     0,     0,     0,   876,     0,     0,     0,     0,  4480,
       0,     0,   877,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4491,     0,     0,     0,     0,   380,
       0,     0,     0,     0,     0,  4504,     0,     0,     0,  4563,
     878,     0,     0,     0,     0,   381,     0,   207,     0,     0,
     382,     0,     0,     0,     0,     0,   383,   384,     0,     0,
       0,     0,   325,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1685,     0,  4582,     0,     0,  4584,
    4585,  4586,  4587,     0,     0,     0,     0,     0,     0,  4593,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4605,     0,     0,     0,     0,   385,     0,     0,
       0,     0,     0,     0,     0,     0,   386,     0,     0,   387,
     850,  2318,     0,     0,   388,     0,   851,   852,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4638,
       0,     0,   854,  4640,     0,     0,     0,     0,     0,     0,
     389,     0,     0,     0,     0,     0,     0,     0,   390,     0,
     391,     0,     0,   392,     0,     0,   393,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   394,     0,     0,     0,  4659,  4660,  4661,  4662,
    4663,  4664,  4665,  4666,  4667,  4668,  4669,  4670,  4671,  4672,
    4673,  4674,  4675,  4676,  4677,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4691,     0,     0,     0,
       0,     0,     0,     0,     0,  1122,  3091,     0,     0,     0,
       0,     0,     0,     0,     0,  3091,     0,     0,     0,     0,
    4647,     0,     0,     0,     0,     0,     0,     0,   395,     0,
       0,     0,     0,     0,     0,   396,     0,   397,     0,     0,
     398,     0,  4711,     0, -1563,   363,     0,     0,     0,   364,
       0,     0,     0,     0,  4712,   365,   399,     0,     0,     0,
    4719,     0,     0,   366,     0,     0,  4691,  4691,     0,     0,
       0,     0,   367,     0,     0,     0,     0,     0,     0,     0,
       0,   927,     0,     0,     0,     0,     0,  2501,     0,  4744,
    4745,     0,  -295,     0,     0,     0,  -295,   855,   856,   857,
       0,     0,   927,  4691,     0,     0,     0,     0,     0,   858,
       0,   400,     0,     0,     0,  -295,     0,     0,     0,     0,
       0,     0,  4758,     0,     0,     0,     0,     0,  -295,  4719,
       0,     0,     0,     0,   401,     0,  4775,     0,     0,     0,
       0,     0,     0,     0,     0,   368,   369,     0,     0,     0,
       0,     0,     0,  4787,     0,     0,  -295,  4719,  4719,     0,
       0,     0,     0,  4719,     0,  4833,  4719,     0,     0,     0,
    4719,  4719,     0,     0,     0,   402,   370,     0,     0,     0,
       0,   403,     0,     0,     0,     0,   404,     0,     0,   405,
     406,     0,     0,     0,     0,     0,   371,     0,   861,     0,
     372,     0,     0,     0,     0,     0,     0,     0,   407,     0,
       0,  4864,     0,     0,     0,  1125,     0,     0,   373,   864,
     865,   866,  -295,   905,   905,     0,   408,     0,   867,     0,
       0,   409,     0,     0,   849,     0,     0,     0,   410,     0,
     317,     0,     0,     0,     0,   411,     0,     0,     0,     0,
       0,     0,     0,   905,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   374,   412,     0,     0,     0,     0,   375,
       0,   376,  4928,  4928,     0,   377,     0,     0,     0,   413,
     378,     0,     0,     0,     0,   414,     0,  -295,     0,     0,
    4935,     0,     0,     0,     0,     0,     0,   379,     0,     0,
    4938,  4942,     0,   415,     0,  4928,     0,     0,     0,     0,
     909,   909,  4950,     0,   869,     0,     0,   416,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,     0,
       0,     0,     0,     0,   380,     0,   419,     0,     0,   420,
     909,     0,     0,  -295,     0,     0,     0,     0,     0,     0,
     381,     0,     0,     0,   421,   382,     0,     0,     0,     0,
       0,   383,   384,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   422,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   850,     0,
       0,     0,     0,     0,   851,   852,     0,     0,     0,     0,
       0,   423,     0,     0,  1112,     0,     0,     0,     0,     0,
     854,     0,   385,     0,   424,     0,     0,  -295,  -295,     0,
     425,   386,     0,     0,   387,     0,     0,     0,     0,   388,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   426,     0,  1768,     0,   871,
       0,     0,     0,     0,     0,   389,     0,     0,     0,     0,
       0,     0,     0,   390,     0,   391,     0,     0,   392,     0,
       0,   393,     0,     0,     0,     0,     0,  -630,   427,     0,
       0,     0,     0,   428,     0,     0,     0,   394,     0,     0,
       0,   429,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -295,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -630,     0,     0,  -630,  -630,  -630,  -630,
    -630,     0,  -630,  -630,     0,     0,     0,     0,  -295,     0,
       0,     0,     0,  -630,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   872,
     873,     0,     0,   395,     0,     0,     0,     0,     0,  -295,
     396,     0,   397,     0,     0,   398,     0,     0,     0,     0,
       0,     0,  -630,     0,     0,  -295,     0,     0,     0,     0,
       0,   399,     0,     0,     0,   855,   856,   857,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   858,     0,     0,
    -630,  -630,     0,  -630,  -630,  -630,  -630,  -630,  -630,  -630,
    -630,  -630,     0,     0,     0,     0,     0,     0,     0,   875,
       0,     0,     0,     0,     0,   318,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   400,     0,     0,     0,
       0,  -295,     0,     0,     0,     0,   876,     0,     0,     0,
       0,     0,     0,     0,   877,     0,     0,     0,     0,   401,
       0,     0,  -630,     0,     0,     0,     0,     0,     0,     0,
    -630,     0,     0,     0,     0,     0,     0,  -630,  -630,     0,
       0,     0,   878,  -295,   859,   860,   861,     0,     0,   207,
       0,  -295,     0,     0,   862,     0,   863,     0,     0,     0,
     402,     0,     0,   319,     0,     0,   403,   864,   865,   866,
       0,   404,     0,     0,   405,   406,   867,     0,     0,   320,
       0,     0,     0,     0,     0,     0,     0,  -295,     0,     0,
       0,     0,     0,   407,     0,     0,   868,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   902,
     902,   408,     0,     0,     0,     0,   409,     0,     0,  -295,
       0,     0,     0,   410,     0,     0,     0,     0,  -630,  -630,
     411,     0,     0,     0,  -295,     0,     0,     0,     0,   902,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,  -295,     0,  -630,  -630,  -630,  -630,  -630,     0,  -630,
    -630,  -630,   869,     0,   413,     0,     0,     0,  -630,     0,
     414,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -630,     0,     0,  -630,     0,     0,   415,     0,
     870,     0,     0,     0,     0,     0,     0,     0,  -630,     0,
    -295,     0,   416,     0,     0,     0,     0,     0,     0,     0,
    -295,  -295,   417,   418,     0,  -630,  -295,     0,     0,     0,
       0,   419,  -630,     0,   420,     0,     0,     0,     0,     0,
    -295,     0,     0,     0,     0,     0,     0,     0,  -630,   421,
    -630,     0,   321,     0,     0,     0,   850,     0,     0,  -295,
    -630,     0,   851,   852,     0,     0,     0,     0,     0,     0,
       0, -1563,  -630,     0,     0,     0,     0,     0,   854,     0,
       0,     0,     0,     0,  -630,     0,     0,     0,  4313,     0,
       0,     0,     0,     0,  -635,  -630,   423,     0,     0,     0,
       0,     0,     0,     0,  -630,     0,     0,   871,     0,   424,
       0,     0,     0,  -295,     0,   425,     0,  -295,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  -295,  -295,  -635,     0,     0,     0,     0,
     426,     0,  -630,     0,     0,     0,     0,     0,  -635,  -635,
    -635,  -635,     0,  -635,     0,     0,  -635,     0,     0,     0,
       0,     0,     0,     0,     0,  -635,     0,     0,     0,     0,
       0,     0,     0,   427,  -635,  -635,     0,     0,   428,     0,
       0,   322,     0,     0,     0,     0, -1563,     0,     0,     0,
       0,     0,     0,     0,     0,  -635,     0,     0,     0,  -630,
       0,     0,     0,     0,     0,     0,     0,   872,   873,     0,
       0,     0,  -635,     0,     0,     0,     0,  -635,     0,     0,
    -630,     0,  1113,     0,  -635,  -635,     0,     0,  -635,     0,
       0,     0,     0,     0,     0,  -635,  -630,     0,     0,     0,
       0,  -630,     0,     0,     0,     0,     0,  -630,     0,     0,
       0,     0,     0,   855,   856,   857,     0,  -630,     0,   323,
       0,     0,  -635,     0,  -630,   858,  3007,     0,     0,     0,
    3008,     0,     0,  -635,     0,     0,     0,   875,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3009,
       0,     0,     0,   318,  -635,     0,     0,  -630,     0,     0,
       0,     0,  3010,     0,   876,     0,     0,     0,     0,     0,
       0,     0,   877,     0,  -630,     0,     0,     0,  -635,  -635,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     878,     0,     0,     0,     0,     0,     0,   207,     0,     0,
       0,     0,     0,  -630,   861,     0,  -630,     0,     0,     0,
       0,     0,   325,     0,     0,     0,     0,     0,     0,     0,
    -630,   319,     0,     0,     0,   864,   865,   866,     0,  -635,
       0,     0,     0,     0,   867,     0,     0,   320,  -635,     0,
       0,  -630,     0,  -630,  -630,  -630,   548,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -630,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1179,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  -630,
       0,     0,     0,     0,     0,     0,     0,  -635,     0,     0,
       0,     0,     0,  -635,     0,     0,  -635,     0,  -635,     0,
       0,   801,     0,     0,     0,     0,  -635,     0,     0,     0,
     869,     0,     0,  -630,     0,     0,  -635,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -635,     0,
    -635,     0,     0,     0,     0,     0,  -630,     0,     0,     0,
       0,     0,     0,  -630,  -630,     0,     0,     0,     0,     0,
       0,     0,     0,  -630,  -630,  -630,     0,  3011,     0,     0,
       0,  -635,     0,     0,     0,     0,     0,     0,     0,  -630,
       0,  -635,     0,     0,     0,  -635,     0,     0,  -630,     0,
       0,     0,     0,  -635,  -630,     0,  -630,  -635,  -630,     0,
     321,  -630,     0,     0,     0,  -630,     0,     0,     0,     0,
    -635,     0,     0,     0,  -635,     0,     0,  -635,  -635,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -635,     0,  -635,     0,     0,  -630,     0,  1024,
       0,  3012,  3013,     0,     0,     0,     0,     0,     0,     0,
   -2794,     0,     0,     0,     0,   871, -2794,     0,     0,     0,
   -2794, -2794, -2794,  -635,     0,     0,     0,     0, -2794,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -635,     0,
       0,     0,     0,     0,     0,  -635,     0,     0,     0,     0,
       0, -2794, -2794, -2794, -2794, -2794, -2794, -2794, -2794,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -635,     0,
    -635,     0,  -635,     0,     0,     0,     0,  3014,     0,   322,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    -635,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   802,     0,     0,   872,   873,  -635,     0,     0,
       0,     0,     0,     0,  -635,  -635, -2794,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3015,     0,     0,     0,     0,  -635,     0,
       0,     0,     0,     0,  -635,     0,     0,  -635,  -635,  -382,
       0,     0,     0,     0, -2794,     0,     0,   323,     0,     0,
   -2794, -2794,     0,     0,     0,     0,     0,     0,     0,  1024,
       0,     0,     0,     0,     0,   875, -2794,     0,     0,     0,
   -2794,     0,     0,     0,     0,     0, -2794,     0,     0,  -635,
   -2794, -2794, -2794,     0,     0,     0,     0,     0, -2794,     0,
       0,  -635,   876,  -635,  -635,     0,     0,     0,     0,     0,
     877,  -635,     0,     0,     0,  3016,     0,     0,     0,     0,
       0, -2794, -2794, -2794, -2794, -2794, -2794, -2794, -2794,     0,
    -635,     0,     0,     0,     0,     0,     0,  -635,   878,     0,
       0,     0,     0,     0,     0,   207,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3017,     0,     0,
     325,     0,  -635,     0,     0,  3018,     0,     0,  -635,     0,
       0,     0,     0,     0,     0,     0,  -635,     0,     0,     0,
    -635,     0,     0,     0,     0,     0,     0,     0, -2794,     0,
       0,  -635,     0,     0,     0,     0, -2794,     0,     0,     0,
       0,   803,     0,     0,     0,     0,  2767, -2794,     0,     0,
       0,     0,     0,     0,  -635,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3019, -2794,     0,     0,     0,     0,  -635,
   -2794, -2794,     0,     0,  -635,     0,     0,     0,  3020,     0,
    -635, -2794, -2794, -2794,  -635,     0, -2794,     0,     0,     0,
       0,     0,     0, -2794,     0,  3021,     0,  -635,     0,     0,
       0,  -635,     0,     0,     0, -2794, -2794,     0,     0,  -635,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2794,     0,     0,     0,     0,     0,     0,     0,     0,
    -635,     0,     0,     0,     0,     0,     0,     0,  -635,  -635,
       0,     0,     0,     0,   804,     0,     0,  -635,     0,     0,
       0,     0, -2794,     0, -3305,     0,     0,     0,     0,     0,
    3022,     0,     0,  -635,     0,     0,     0,     0,     0,     0,
       0,     0,   218,     0,  3023,     0,     0,     0,     0,     0,
   -2794, -2794, -2794, -2794, -2794,     0,     0,  -635,     0,     0,
   -2794,     0, -2794,  -379,     0,     0,     0,     0, -2794, -2794,
       0,     0,     0, -2794, -2794, -2794,     0,     0,     0,     0,
       0,     0, -2794,     0,     0, -2794,     0, -2794,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -2794,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   805,     0,     0,
       0,  3024, -2794,     0,     0,     0,     0,     0,     0,     0,
       0, -2794, -2794, -2794,     0,     0,     0,  3025,  3026,     0,
       0,     0,     0, -2794,     0,     0,     0, -2794,     0,     0,
       0,     0,     0,     0,     0, -2794, -2794, -2794,     0,     0,
       0,     0,     0,     0,     0,     0, -2794,     0, -2794,     0,
       0, -2794,     0,     0,     0, -2794,     0,     0,     0,     0,
       0,     0,     0, -2794,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2794,     0,     0,   849,
       0,     0, -2794,     0,     0,   317,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2794,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2794, -2794, -2794, -2794, -2794,     0,     0,     0,     0,     0,
   -2794,     0, -2794,     0,     0,     0,     0,     0, -2794, -2794,
       0,     0,     0, -2794, -2794, -2794,     0,     0,     0,     0,
       0,     0, -2794,     0,     0, -2794,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -2794,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -2794, -2794,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2794,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2794,     0,     0,
       0,     0,     0,     0,     0,     0, -2794,     0, -2794,     0,
       0,     0,     0,   850,     0, -2794,     0,  3371,     0,   851,
     852,     0,     0, -2794,     0,     0,     0,     0, -2823,     0,
       0,     0,     0,     0, -2823,   854, -2794, -2794, -2823, -2823,
   -2823,     0,     0,     0,     0,     0, -2823,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2794,     0,
       0,     0,     0, -2794, -2794,     0,     0,     0,     0, -2823,
   -2823, -2823, -2823, -2823, -2823, -2823, -2823,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2794,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -2794,     0, -2794,     0, -2794,     0,     0,     0,
   -2794,     0, -2794, -2794, -2794, -2794,     0, -2794, -2794,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2794,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2794, -2823,     0,     0,     0,     0, -3439,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2794,     0,     0,     0,     0,     0,     0,     0, -2794,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -2823,     0,     0,     0,     0,     0, -2823, -2823,
       0,     0,     0,     0,     0,     0, -2794,     0,     0,     0,
       0,     0,     0, -2794, -2823,     0,     0,     0,     0,     0,
     855,   856,   857,     0,     0,     0,     0, -2794, -2794,     0,
       0,     0,   858,     0,     0,  1019,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2794, -2794,     0,     0,     0,     0,     0,
     318,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -2794,     0, -2794,     0, -2794,     0,     0,     0,
   -2794,     0, -2794, -2794, -2794, -2794,     0, -2794, -2794,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   859,
     860,   861,     0, -2794,     0,     0, -2823,     0,     0,   862,
       0,   863,     0,     0,     0,     0,     0,     0,   319,     0,
       0,     0,   864,   865,   866, -2823,     0,     0,     0,     0,
   -2794,   867,     0,     0,   320,     0,     0,     0, -2794,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   868,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2794,     0,     0, -2823,
   -2823, -2823,     0, -2794,     0,     0,     0,     0,     0,     0,
       0, -2823,     0,     0,     0,     0,     0,     0, -2794,     0,
       0,     0,     0, -2823, -2823, -3439,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -2823,
       0,  1261,     0,     0,     0,     0,     0,   869,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -3439,
   -3439, -3439, -3439,     0,     0,     0,     0, -3439,     0,     0,
       0,     0,     0,     0,     0,   870,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -3439, -3439,     0,     0,  3189,
       0,  3190,     0,     0,     0,     0,     0,     0, -2823, -2823,
   -2823, -2823, -2823,     0,     0,     0,     0,     0, -2823,     0,
   -2823,     0,     0,     0, -2003,     0,     0, -2823,     0,     0,
       0, -2823, -2823, -2823,     0,     0,     0,   321,     0,     0,
   -2823,     0,     0, -2823,     0, -3291, -3439,     0,     0, -3291,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2823,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2823,     0,     0, -3439,     0, -3439,     0,     0,     0,     0,
    1021,     0,   871,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -2823,  3371,     0,     0,     0,
       0,     0,     0,     0,     0, -2823,     0, -2823,     0,     0,
       0,     0,     0, -2823, -2823,     0, -2823, -2823, -2823, -2823,
       0,     0,     0, -2823,     0, -2823,     0,     0,     0,     0,
       0, -2823,     0,     0,  3729,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2823,     0,     0,     0, -2823, -2823,
   -2823, -2823, -2823, -2823, -2823, -2823,   322,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2823,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   872,   873,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2823,     0,     0, -3439,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2823,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   323,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2823,   875,     0,     0,     0,     0,     0, -3439,     0,
       0, -2823,     0,     0,     0,     0,     0, -2823, -2823,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   876,
       0,     0,     0, -2823,     0,     0,     0,   877,     0,     0,
    3191,     0,     0,     0,     0,     0,     0,     0,     0, -3439,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   878,     0,     0,     0,     0,
       0,   534,   207,     0,     0, -2823,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2823, -2823,     0,     0,     0,     0, -2003,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -3291,     0,     0,     0,  3192,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2823,     0, -2823, -3439, -2823, -2823,     0,     0, -2823,     0,
   -2823, -2823, -2823, -2823,     0, -2823, -2823,     0,     0,     0,
       0,     0,     0,     0, -2823,     0,     0,     0,     0,     0,
       0, -2823,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -3439,
       0,     0,     0,     0,     0,     0,     0,     0, -2823,     0,
       0,     0,     0,     0,     0,     0, -2823,     0, -2823, -2823,
   -2823,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2823,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -2823, -2823, -2823,     0,     0,     0,     0,     0,
       0, -2823,     0,     0,     0,     0,     0,     0, -2823,     0,
       0, -3439,     0,     0,     0,     0, -2823,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3193, -3291, -3291,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -2823, -2823, -2823,
   -2823, -2823,     0,     0,     0,     0,     0, -2823,     0, -2823,
       0,     0,     0,     0,     0,     0, -2823,     0,     0,     0,
   -2823, -2823, -2823,     0,     0,     0,     0,     0,     0, -2823,
       0,     0, -2823,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -2823,
       0,     0, -3439,     0, -3439, -3439,     0,     0,     0,     0,
   -2003,     0,     0,     0,     0,     0,     0,     0,     0, -2823,
       0,     0,     0,     0,     0, -3439,     0,     0,     0,     0,
   -3439,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2823,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2823,     0,     0,  3194,     0,     0,
       0,     0,     0, -2823,     0, -2823,     0,     0,     0, -3439,
       0,     0, -2823,     0,     0,     0,     0,     0,     0,     0,
   -2823, -3439,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -2823,     0, -3147,     0,     0,     0,     0,
       0,  1453,     0,     0,     0, -3147,     0,     0,     0,  1454,
       0,     0,     0,     0,     0, -2823,     0,     0,     0,     0,
       0, -3147,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2003,     0,
       0,  1455, -3147,     0,     0, -2823,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3195,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -3147,  1456,  1457,  1458,  1459,  1460,  1461,  1462,  1463,     0,
   -3439,     0,     0, -3147, -3147, -3147,     0,  1464, -3147,     0,
       0,     0,  1465,     0,     0, -3147,     0,     0,     0,     0,
   -2823,     0,     0,  1466,  1467,  1468,  1469, -3147,     0, -3147,
   -3147,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1470,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1471,     0,     0,  1472,  1473,  1474, -3147,  1475,     0,
       0,     0,   534,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1476,     0, -2823,     0,     0,     0,     0,     0,
       0,  1477,  1478,  1479,  1480,  1481,  1482,  1483,  1484,     0,
       0,     0, -3147,     0,  1485,     0,  1486,     0,     0,     0,
   -2823, -2823,     0,     0,     0,     0,     0,     0,     0, -3147,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1487,  1488,     0,     0,  1489,
    1490,     0, -3147, -3147,  1491, -3147, -3147,     0,     0, -2823,
       0, -2823,     0, -2823,     0,     0,     0, -2823,     0, -2823,
   -2823, -2823, -2823,     0, -2823, -2823,  1492,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -2823,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -3147,  1493,     0,     0,     0,  1494,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -3147, -2823,     0,     0,
    1495,     0,     0,     0,     0, -2823,  1496,  1497,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1498,  1499,  1500,  1501,  1502,
       0,     0,  1503, -2823,     0,     0, -3147, -3147, -3147,     0,
   -2823,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -2823,     0,     0,     0, -3147,
       0,     0,     0,     0, -3147,     0,     0,     0,     0,     0,
       0,     0,     0,  1504,  1505,  1506,  1507,     0,     0,     0,
       0,     0,  1508,  1509,     0,  1510,     0,  1511,  1512,  1513,
   -3147, -3147,  1514,     0,  1515,     0, -3147, -3147,  1516,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1517,  1518,     0,
       0,     0,     0,     0,     0,     0,     0,  1519,  1520,  1521,
    1522,  1523,  1524,     0,     0,     0,     0,     0,     0,     0,
       0,  1525,     0,     0,     0,  1526,     0,     0,     0,  1528,
       0, -3147,     0, -3147,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -3147,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -3147, -3147, -3147,     0,     0,  1529,     0,
       0,     0,  1530,     0,  1531,  1532,  1533,  1534,     0,     0,
       0,     0,     0,     0,     0,  1535,     0,     0,     0,     0,
       0, -3147,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1536,     0,     0,     0,     0,     0,     0,     0,
    1537,     0,     0,     0,     0, -3147, -3147, -3147,     0, -3147,
       0, -3147, -3147,     0, -3147, -3147, -3147,     0,     0,     0,
       0,  1619, -3147,     0, -3147, -3147, -3147, -3147,     0,     0,
       0,     0,     0,     0,     0,     0,  1538,  1539,     0,     0,
   -3147,     0,     0,     0,     0,     0,     0,     0, -3147,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -3147, -3147,     0,     0,   849,     0,     0,
       0,  1540, -3147,   317,  1541,     0,     0,     0, -3147,     0,
       0,     0,     0,     0,     0,  1542,     0,     0,     0,     0,
       0,  1543,     0,     0,     0,  1544,     0,  1545,  1546,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1547,     0,     0,  1548,  1549,     0,     0,     0,     0,
    1550,     0,     0,     0,     0, -3147,     0,     0,     0,     0,
       0, -3147,     0,     0,     0,     0,  1551,     0,  1552,  1553,
       0,     0,     0,     0,     0,     0,     0,  1554,  1555,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1556,  1557,  1558,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -3147, -3147,     0, -3147,     0,     0,
       0,  1559,  1560,  1561,  1562, -3147,  1563,     0,     0,     0,
    1564,  1565,     0,     0,     0,     0,     0,     0,  1566,  1567,
       0,     0,     0,     0,     0,     0,     0,  1568,  1569,  1570,
   -3147,   850,     0,     0,     0,  1571,     0,   851,   852,     0,
    1572,     0, -3439, -3147, -3147, -3147, -3147,     0,     0,     0,
       0,   363,     0,   854,     0,   364,     0,     0,  1573,     0,
       0,   365,     0, -3147, -3147,     0,     0,     0,     0,   366,
       0,  1574,  1575,     0, -3147,     0,     0,  1576,   367,     0,
       0,     0,     0,  1620,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1577,  1578,     0,     0, -3147,     0,     0,     0,     0,  1579,
       0,     0,     0,     0,     0,     0,     0,  1580, -3147, -3147,
       0,     0,     0,  1581,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   368,   369,  1582,     0, -3147,     0,     0,     0,  1583,
       0,     0,     0,     0,     0, -3147,   958,     0,     0,     0,
       0,     0, -3147,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   370, -3147,     0,     0,     0, -3147, -3147, -3147,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   371,  1584,     0,     0,   372,     0, -3147, -3147,
    1585,     0,  1586, -3147, -3147,  1587, -3147,     0,     0,     0,
       0,   959,  1588, -3147,   373,     0,     0,     0,   855,   856,
     857,     0,     0,     0,     0,  1589,     0,     0,     0,  1590,
     858,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   318,   374,
       0,     0,     0,     0,     0,   375,     0,   376,     0,     0,
     960,   377,     0,     0,     0,     0,   378,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   379,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   859,   860,   861,
       0,     0,     0,     0,     0,     0,     0,   862,     0,   863,
     380,     0,     0,     0,     0,     0,   961,     0,     0,     0,
     864,   865,   866,     0,     0,     0,   381,     0,     0,   867,
       0,   382,   320,     0,     0,     0,     0,   383,   384,     0,
       0,     0,     0,     0,     0,   962,     0,     0,     0,   868,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   385,     0,
       0,     0,     0,     0,     0,     0,     0,   386,     0,     0,
     387,     0,     0,     0,     0,   388,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   869,     0,     0,     0,     0,
       0,     0,   963,     0,     0,     0,     0,     0,     0,     0,
       0,   389,     0,     0,     0,     0,     0,     0,     0,   390,
       0,   391,     0,   870,   392,     0,     0,   393,     0,     0,
     317,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   394,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   321,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   395,
    1640,     0,     0,     0,     0,     0,   396,     0,   397,     0,
       0,   398,     0,     0,     0,     0,     0,     0,     0,     0,
     871,     0,     0,     0,     0,     0,     0,   399,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   850,     0,
       0,     0,     0,     0,   851,   852,     0,     0,     0,     0,
       0,     0,   400,     0,     0,     0,     0,     0,     0,     0,
     854,     0,     0,     0,   322,     0,     0,     0,   964,     0,
       0,     0,     0,     0,     0,   401,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     872,   873,     0,   965,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   402,     0,     0,     0,
       0,     0,   403,     0,     0,     0,     0,   404,     0,     0,
     405,   406,     0,     0,     0,     0,     0,     0,   966,     0,
       0,     0,   323,     0,     0,     0,     0,     0,     0,   407,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     875,     0,     0,     0,     0,     0,     0,   408,     0,     0,
       0,     0,   409,     0,     0,     0,     0,     0,     0,   410,
       0,     0,     0,     0,     0,     0,   411,   876,     0,     0,
       0,     0,     0,     0,     0,   877,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,     0,     0,     0,
       0,  1453,     0,     0,     0,     0,     0,     0,     0,  1454,
     413,     0,     0,   878,     0,     0,   414,     0,   967,   534,
     207,     0,     0,  1641,     0,   855,   856,   857,     0,     0,
       0,     0,     0,     0,   415,   325,     0,   858,     0,     0,
   -1215,  1455,     0,     0,     0,     0,     0,     0,   416,     0,
       0,     0,     0, -1215, -1215, -1215, -1215,     0,   417,   418,
       0, -1215,     0,     0,     0,   318,     0,   419,     0,     0,
     420,  1456,  1457,  1458,  1459,  1460,  1461,  1462,  1463, -1215,
   -1215,     0,     0,     0,     0,   421,     0,  1464,     0,     0,
       0,     0,  1465,     0,     0,     0,     0,     0,     0,     0,
   -1215,     0,     0,  1466,  1467,  1468,  1469,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1470, -1215,     0,   859,   860,   861,     0,     0, -1215,
   -1215,  1471,   423, -1215,  1472,  1473,  1474,     0,  1475,     0,
       0,     0,     0,  1642,     0,   424,     0,   864,   865,   866,
       0,   425,     0,     0,     0,     0,   867,     0,     0,   320,
       0,     0,     0,     0,     0,     0,     0, -1215,     0,     0,
       0,     0,  1476,     0,     0,     0,   426,     0, -1215,     0,
       0,  1477,  1478,  1479,  1480,  1481,  1482,  1483,  1484,     0,
       0,     0,     0,     0,  1485,     0,  1486,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   427,
       0,     0,     0,     0,   428,     0,     0,     0,     0,     0,
       0,     0,     0, -1215, -1215,  1487,  1488,     0,     0,  1489,
    1490,     0,     0,     0,  1491,     0,     0,     0,     0,     0,
       0,     0,   869,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1492,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1493,     0,     0,     0,  1494,     0,     0,     0,     0,
       0,     0,     0, -1215,     0,     0,     0,     0,     0,     0,
    1495,     0,     0,     0,     0,     0,  1496,  1497,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   321,     0,     0,  1498,  1499,  1500,  1501,  1502,
       0,     0,  1503,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -1215,     0,     0,     0,     0,     0,     0,     0,
       0, -1215,     0, -1215,     0,     0,     0,     0,     0,     0,
       0, -1215,     0,  1504,  1505,  1506,  1507,   871,     0,     0,
       0, -1215,  1508,  1509,     0,  1510,     0,  1511,  1512,  1513,
       0,     0,  1514, -1215,  1515, -1215,     0,     0,  1516,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1517,  1518,     0,
       0,     0,     0,     0,     0,     0, -1215,  1519,  1520,  1521,
    1522,  1523,  1524,     0,     0,     0, -1215,     0,     0,     0,
       0,  1525,     0,     0,     0,  1526,     0,     0, -1215,  1528,
       0,   322, -1215,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -1215,     0,     0,     0, -1215,
       0,     0,     0, -1215,     0,     0,     0,   872,   873,     0,
       0,     0,     0,     0,     0,     0,     0, -1215,  1529, -1215,
       0,     0,  1530,     0,  1531,  1532,  1533,  1534,     0,     0,
   -3439,     0,     0,     0,     0,  1535,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -1215,     0,
       0,     0,  1536,     0,     0,     0,     0,     0,     0,   323,
    1537,     0,     0, -1215,     0,     0,     0,     0,     0,     0,
   -1215,     0,     0,     0,     0,     0,     0,   875,     0,     0,
       0,  1619,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2323,     0,  1538,  1539,     0,     0,
       0,     0,     0,     0,   876, -1215,     0, -1215,     0,     0,
       0,     0,   877,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -1215,     0, -2323,     0,     0,
       0,  1540,     0,     0,  1541,     0,     0,     0,     0,     0,
     878,     0, -1215,     0,     0,  1542,   534,   207,     0, -1215,
   -1215,  1543,     0,     0,     0,  1544,     0,  1545,  1546,     0,
       0,     0,   325,     0,     0,     0,     0,     0,     0,     0,
       0,  1547,     0, -1215,  1548,  1549,     0,     0,     0,     0,
    1550,     0, -1215,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1551,     0,  1552,  1553,
       0,     0,     0,     0,     0,     0,     0,  1554,  1555,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -1215,     0,     0,     0,     0,     0,
    1556,  1557,  1558,     0,     0,     0, -1215,     0, -1215, -1215,
       0,     0,     0,     0,     0,     0, -1215,     0,     0,     0,
       0,  1559,  1560,  1561,  1562,     0,  1563,     0,     0,     0,
    1564,  1565,     0,     0,     0,     0,     0,     0,  1566,  1567,
       0,     0, -1215,     0,     0,     0,     0,  1568,  1569,  1570,
       0,     0,     0,     0,     0,  1571,     0,     0,     0,     0,
    1572,     0,     0,     0,     0,     0,     0, -1215,     0,     0,
       0,     0,     0, -1215,     0,     0,     0,     0,  1573,     0,
       0, -1215,     0,     0,     0, -1215,     0,     0,     0,     0,
       0,  1574,  1575,     0,     0,     0,     0,  1576,     0,     0,
       0,     0,     0,  1620,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -1215,
    1577,  1578,     0,     0,     0,     0,     0,     0,     0,  1579,
       0,     0,     0,     0,     0,     0,     0,  1580,     0,     0,
       0,     0,     0,  1581, -1215,     0,     0,     0,     0, -1215,
       0,     0,     0,     0,     0, -1215,     0,     0,     0, -1215,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -1215,  1582,     0,     0,     0,     0,     0,  1583,
       0,     0,     0,     0, -1215,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1453,     0,     0,     0,     0,     0,
       0,     0,  1454,     0,     0, -1215,     0,     0,     0,     0,
       0,     0,     0, -1215, -1215,     0,     0,     0,     0,     0,
       0,     0, -1215,  1584,     0,     0,     0,     0,     0,     0,
    1585,     0,  1586, -1216,  1455,  1587,     0,     0,     0,     0,
       0,     0,  1588,     0,     0,     0, -1216, -1216, -1216, -1216,
       0,     0,     0,     0, -1216,  1589,     0,     0,     0,  1590,
       0,     0, -1215,     0,  1456,  1457,  1458,  1459,  1460,  1461,
    1462,  1463, -1216, -1216,     0,     0,     0,     0,     0,     0,
    1464,     0,     0,     0,     0,  1465,     0,     0,     0,     0,
       0,     0,     0, -1216,     0,     0,  1466,  1467,  1468,  1469,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1470, -1216,     0,     0,     0,     0,
       0,     0, -1216, -1216,  1471,     0, -1216,  1472,  1473,  1474,
       0,  1475,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -1216,     0,     0,     0,     0,  1476,     0,     0,     0,     0,
       0, -1216,     0,     0,  1477,  1478,  1479,  1480,  1481,  1482,
    1483,  1484,     0,     0,     0,     0,     0,  1485,     0,  1486,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -1216, -1216,  1487,  1488,
       0,     0,  1489,  1490,     0,     0,     0,  1491,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1492,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1493,     0,     0,     0,  1494,     0,
       0,     0,     0,     0,     0,     0, -1216,     0,     0,     0,
       0,     0,     0,  1495,     0,     0,     0,     0,     0,  1496,
    1497,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1498,  1499,
    1500,  1501,  1502,     0,     0,  1503,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -1216,     0,     0,     0,     0,
       0,     0,     0,     0, -1216,     0, -1216,     0,     0,     0,
       0,     0,     0,     0, -1216,     0,  1504,  1505,  1506,  1507,
       0,     0,     0,     0, -1216,  1508,  1509,     0,  1510,     0,
    1511,  1512,  1513,     0,     0,  1514, -1216,  1515, -1216,     0,
       0,  1516,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1517,  1518,     0,     0,     0,     0,     0,     0,     0, -1216,
    1519,  1520,  1521,  1522,  1523,  1524,     0,     0,     0, -1216,
       0,     0,     0,     0,  1525,     0,     0,     0,  1526,     0,
       0, -1216,  1528,     0,     0, -1216,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -1216,     0,
       0,     0, -1216,     0,     0,     0, -1216,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -1216,  1529, -1216,     0,     0,  1530,     0,  1531,  1532,  1533,
    1534,     0,     0,     0,     0,     0,     0,     0,  1535,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -1216,     0,     0,     0,  1536,     0,     0,     0,     0,
       0,     0,     0,  1537,     0,     0, -1216,     0,     0,     0,
       0,     0,     0, -1216,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1619,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1538,
    1539,     0,     0,     0,     0,     0,     0,     0, -1216,     0,
   -1216,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -1216,     0,
       0,     0,     0,     0,  1540,     0,     0,  1541,     0,     0,
       0,     0,     0,     0,     0, -1216,     0,     0,  1542,     0,
       0,     0, -1216, -1216,  1543,     0,     0,     0,  1544,     0,
    1545,  1546,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1547,     0, -1216,  1548,  1549,     0,
       0,     0,     0,  1550,     0, -1216,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1551,
       0,  1552,  1553,     0,     0,     0,     0,     0,     0,     0,
    1554,  1555,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -1216,     0,     0,
       0,     0,     0,  1556,  1557,  1558,     0,     0,     0, -1216,
       0, -1216, -1216,     0,     0,     0,   597,     0,     0, -1216,
       0,     0,   598,     0,  1559,  1560,  1561,  1562,     0,  1563,
     599,     0,     0,  1564,  1565,     0,     0,     0,     0,   600,
       0,  1566,  1567,     0,     0, -1216,     0,     0,     0,     0,
    1568,  1569,  1570,     0,     0,     0,     0,     0,  1571,     0,
       0,     0,     0,  1572,     0,     0,     0,     0,     0,     0,
   -1216,     0,     0,     0,     0,     0, -1216,     0,     0,     0,
       0,  1573,     0,     0, -1216,     0,     0,     0, -1216,     0,
       0,     0,     0,     0,  1574,  1575,     0,     0,     0,     0,
    1576,     0,     0,     0,     0,     0,  1620,     0,     0,     0,
       0,     0,   601,   602,     0,     0,     0,     0,     0,     0,
       0,     0, -1216,  1577,  1578,     0,     0,     0,     0,     0,
       0,     0,  1579,     0,     0,     0,     0,     0,     0,     0,
    1580,     0,     0,   603,     0,     0,  1581, -1216,     0,     0,
       0,     0, -1216,     0,     0,     0,     0,     0, -1216,     0,
       0,     0, -1216,   604,     0,     0,     0,   605,     0,     0,
       0,     0,     0,     0,     0, -1216,  1582,     0,     0,     0,
       0,     0,  1583,     0,     0,   606,     0, -1216,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -1216,     0,
       0,     0,     0,     0,     0,     0, -1216, -1216,     0,     0,
       0,     0,     0,     0,     0, -1216,  1584,     0,     0,     0,
     607,     0,     0,  1585,     0,  1586,     0,     0,  1587,     0,
       0,     0,   608,     0,     0,  1588,     0,   609,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1589,     0,
       0,     0,  1590,     0,     0, -1216,   610,     0,     0,     0,
       0,   611,   612,   613,   614,     0,   615,   616,   617,   618,
       0,   619,     0,   620,   621,   622,     0,   623,   624,   625,
     626,   627,     0,   628,   629,   630,   631,   632,   633,     0,
       0,   634,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   635,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   636,   637,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   638,
       0,     0,     0,     0,     0,     0,     0,     0,   639,     0,
       0,   640,     0,     0,     0,     0,   641,     0,     0,     0,
       0,     0,     0,     0,  2929,  2930,  2931,  2932,  2933,     0,
    2934,  2935,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   642,     0,     0,     0,     0,     0,     0,     0,
     643,     0,   644,     0,     0,   645,     0,     0,   646,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2936,
       0,  2937,  2938,  2291,  2939,  2940,  2941,  2942,  2943,  2944,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     647,     0,     0,     0,     0,     0,     0,   648,     0,   649,
       0,     0,   650,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   651,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1453,     0,     0,     0,     0,  2945,  2946,     0,  1454,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1455,     0,     0,   652,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   653,     0,     0,     0,
    1456,  1457,  1458,  1459,  1460,  1461,  1462,  1463,     0,     0,
       0,     0,     0,     0,     0,     0,  1464,     0,     0,     0,
       0,  1465,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1466,  1467,  1468,  1469,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   654,     0,
    1470,  2947,  2948,  2949,  2950,  2951,     0,  2298,  2299,  2952,
    1471,  3394,     0,  1472,  1473,  1474,     0,  1475,     0,     0,
     655,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2953,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   656,     0,     0,  2954,     0,     0,     0,
     657,  1476,     0,     0,     0,     0,     0,   658,     0,     0,
    1477,  1478,  1479,  1480,  1481,  1482,  1483,  1484,     0,     0,
    2955,     0,     0,  1485,     0,  1486,   659,     0,     0,     0,
    -777,  -777,  -777,  -777,  -777,     0,  -777,  -777,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   660,     0,     0,
       0,     0,     0,     0,  1487,  1488,     0,     0,  1489,  1490,
       0,     0,     0,  1491,     0,   661,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   662,
       0,     0,     0,     0,     0,  1492,     0,     0,     0,   663,
     664,     0,     0,     0,     0,     0,     0,     0,   665,     0,
       0,   666,     0,     0,     0,     0,     0,     0,     0,     0,
    1493,     0,     0,     0,  1494,  -777,   667,  -777,  -777,  -777,
    -777,  -777,  -777,  -777,  -777,  -777,     0,     0,     0,  1495,
    2956,     0,     0,     0,     0,  1496,  1497,     0,   668,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1498,  1499,  1500,  1501,  1502,     0,
       0,  1503,     0,   669,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   670,     0,     0,     0,
       0,     0,   671,     0,     0,     0,     0,     0,     0,     0,
       0,  -777,  -777,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1504,  1505,  1506,  1507,     0,     0,  2957,     0,
       0,  1508,  1509,     0,  1510,     0,  1511,  1512,  1513,     0,
       0,  1514,     0,  1515,     0,     0,     0,  1516,     0,  2958,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     672,     0,     0,     0,     0,   673,  1517,  1518,     0,     0,
       0,     0,  2959,     0,     0,     0,  1519,  1520,  1521,  1522,
    1523,  1524,     0,     0,     0,     0,     0,     0,     0,     0,
    1525,     0,     0,     0,  1526,     0,     0,     0,  1528,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -777,  -777,  -777,
    -777,  -777,     0,  -777,  -777,  -777,     0,  1529,     0,     0,
       0,  1530,     0,  1531,  1532,  1533,  1534,     0,     0,     0,
       0,     0,     0,     0,  1535,     0,  -777,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1536,  -777,     0,     0,     0,     0,     0,     0,  1537,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -777,     0,     0,     0,
    1619,  2960,  2961,  2962,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1538,  1539,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1540,     0,     0,  1541,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1542,     0,     0,     0,     0,     0,
    1543,     0,     0,     0,  1544,     0,  1545,  1546,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1547,     0,     0,  1548,  1549,     0,     0,     0,     0,  1550,
       0,     0,     0,     0,     0,     0,  -777,     0,     0,     0,
       0,     0,     0,     0,     0,  1551,     0,  1552,  1553,     0,
       0,  2963,  2964,  2965,     0,     0,  1554,  1555,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2966,     0,     0,  1556,
    1557,  1558,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3395,     0,     0,     0,     0,     0,     0,     0,     0,
    1559,  1560,  1561,  1562,     0,  1563,     0,     0,     0,  1564,
    1565,     0,     0,     0,  -777,     0,     0,  1566,  1567,     0,
       0,     0,     0,     0,     0,     0,  1568,  1569,  1570,     0,
       0,     0,     0,     0,  1571,  -777,     0,     0,     0,  1572,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1573,  -777,     0,
       0,     0,     0,     0,  1453,     0,     0,     0,     0,     0,
    1574,  1575,  1454,     0,     0,     0,  1576,     0,     0,     0,
       0,     0,  1620,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1577,
    1578,     0,     0,     0,  1455,     0,     0,     0,  1579,     0,
       0,     0,     0,     0,     0,     0,  1580,     0,     0,     0,
       0,     0,  1581,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1456,  1457,  1458,  1459,  1460,  1461,
    1462,  1463,     0,     0,     0,     0,     0,     0,     0,     0,
    1464,     0,  1582,     0,     0,  1465,     0,     0,  1583,     0,
       0,     0,     0,     0,     0,     0,  1466,  1467,  1468,  1469,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1470,     0,     0,  -777,  -777,  -777,
       0,     0,     0,     0,  1471,     0,     0,  1472,  1473,  1474,
       0,  1475,  1584,     0,     0,     0,     0,     0,     0,  1585,
       0,  1586,     0,     0,  1587,     0,     0,     0,     0,     0,
       0,  1588,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1589,  1476,     0,     0,  1590,     0,
       0,     0,     0,     0,  1477,  1478,  1479,  1480,  1481,  1482,
    1483,  1484,     0,     0,     0,     0,     0,  1485,     0,  1486,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1487,  1488,
       0,     0,  1489,  1490,     0,     0,     0,  1491,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  -777,  -777,  -777,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1492,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  -777,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1493,     0,     0,     0,  1494,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1495,     0,  3396,     0,     0,     0,  1496,
    1497,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1498,  1499,
    1500,  1501,  1502,     0,     0,  1503,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1504,  1505,  1506,  1507,
       0,     0,     0,     0,     0,  1508,  1509,     0,  1510,     0,
    1511,  1512,  1513,     0,     0,  1514,     0,  1515,     0,     0,
       0,  1516,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1517,  1518,     0,     0,     0,     0,     0,     0,     0,     0,
    1519,  1520,  1521,  1522,  1523,  1524,     0,     0,     0,     0,
       0,     0,   317,     0,  1525,     0,     0,     0,  1526,  1527,
       0,     0,  1528,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1529,     0,     0,     0,  1530,     0,  1531,  1532,  1533,
    1534,     0,     0,   849,     0,     0,     0,     0,  1535,   317,
       0,     0,     0, -3341, -3341, -3341,     0,     0,     0,     0,
       0,  1410,  1640,     0,     0,  1536,     0,     0,     0,     0,
       0,     0,     0,  1537,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1411,  1412,  1413,  1414,  1415,  1416,
    1417,  1418,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1538,
    1539,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     850,     0,     0,     0,     0,     0,   851,   852,     0,     0,
       0,     0,     0,     0,  1540,     0,     0,  1541,     0,     0,
       0,     0,   854,     0,     0,     0,     0,     0,  1542, -3341,
       0,     0,     0,     0,  1543,     0,     0,     0,  1544,     0,
    1545,  1546,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1547,     0,     0,  1548,  1549,     0,
       0,     0,     0,  1550,     0,     0,     0,   850,     0,     0,
       0,     0,     0,   851,   852,     0,     0,     0,     0,  1551,
       0,  1552,  1553,     0,     0,     0,     0,     0,     0,   854,
    1554,  1555,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1556,  1557,  1558,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1559,  1560,  1561,  1562,     0,  1563,
       0,     0,     0,  1564,  1565,     0,     0,     0,     0,     0,
       0,  1566,  1567,     0,     0,     0,     0,     0,     0,     0,
    1568,  1569,  1570,     0,     0,     0,     0,     0,  1571,     0,
       0,     0,     0,  1572,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1573,     0,     0,     0,  1641,     0,   855,   856,   857,
       0, -3341,     0,     0,  1574,  1575,     0,     0,     0,   858,
    1576,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1419,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1577,  1578,     0,     0,   318,     0,     0,
       0,     0,  1579,     0,     0,     0,     0,     0,     0,     0,
    1580,     0,     0,     0,     0,     0,  1581,     0,     0,     0,
       0,     0,     0,     0,   855,   856,   857,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   858,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1582,     0, -3341, -3341,
       0,     0,  1583,     0,     0,     0,   859,   860,   861,     0,
       0,     0,     0,     0,   318,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   319,     0,     0,     0,   864,
     865,   866,     0,     0,     0,     0,     0,     0,   867,     0,
       0,   320,     0,     0,     0,  1420,  1584,     0,     0,     0,
       0,     0,     0,  1585,     0,  1586,     0,     0,  1587,     0,
       0,     0,     0,     0,     0,  1588,     0,     0,     0,     0,
       0,     0,     0,   859,   860,   861, -3341, -3341,  1589,     0,
       0,     0,  1590,   862,     0,   863,     0,     0,     0,     0,
       0,     0,   319,     0,     0,     0,   864,   865,   866,     0,
     849,     0,     0,     0,     0,   867,   317,     0,   320,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   869,   868,     0,     0,     0,     0,
       0, -1929,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -3341,     0,     0,     0, -1929,
   -1929, -1929, -1929,     0,     0,     0,     0, -1929,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   849,     0,     0,
    1421,     0,     0,   317,     0, -1929, -1929,  2087,  2088,  2089,
   -3341,     0,     0,     0,     0,  3694,     0,     0,     0, -3341,
       0,   869,     0,     0,     0,     0,     0,     0, -3341,     0,
       0,     0,     0,     0,   321,     0,  1422,     0,  3695,  3696,
    3697,  3698,  3699,  3700,  3701,  3702,     0,     0,     0,   870,
       0,     0,     0,     0,     0, -1929, -1929,     0,     0, -1929,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -3341,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   850,     0,     0,     0,     0,   871,
     851,   852,     0, -1929,     0, -1929,     0,     0,     0,     0,
       0,   321,     0,     0,     0,     0,   854,     0,     0,     0,
       0,     0,     0,  2090,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   850,     0,     0,     0,     0,   871,   851,   852,     0,
       0,     0,     0,   322,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   854,     0,     0,     0,     0,     0,   849,
       0,     0,     0,     0,     0,   317,     0,     0,     0,   872,
     873,     0,     0,     0,     0,     0,     0,  1410,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -3439,     0,     0,     0,     0,     0,     0, -1929,
    1411,  1412,  1413,  1414,  1415,  1416,  1417,  1418,     0,     0,
     322,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   323,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   872,   873,     0,   875,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -2323,     0, -1929,     0,
       0,   855,   856,   857,     0,  2091,   876,     0,     0,     0,
       0,     0,     0,   858,   877,  1423,     0,  1424,     0, -3341,
       0,     0,     0, -3341,  3703, -3341,  1425,  1426,   323, -2323,
    1427,  1428,     0,     0,     0,     0,     0,     0,     0, -1929,
       0,   318,   878,     0,     0,     0,   875,     0,   534,   207,
       0,     0,     0,   850,     0,     0,     0,     0,     0,   851,
     852,     0,     0,     0,   325,     0,     0,     0,   855,   856,
     857,     0,     0,   876,     0,   854,     0,     0,     0,     0,
     858,   877,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2092,  2093,     0,     0,     0,     0,     0,     0,
     859,   860,   861,     0,     0,     0,     0,     0,   318,   878,
     862, -1929,   863,     0,     0,     0,   207,     0,     0,   319,
       0,     0,     0,   864,   865,   866,     0,     0,     0,     0,
       0,   325,   867, -1929,     0,   320,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   849,
       0,     0,   868, -1929,     0,   317,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   859,   860,   861,
    2094,  2095,     0,     0,     0,     0,     0,   862,     0,   863,
   -1929,     0,     0,     0,     0,     0,   319,     0,     0,     0,
     864,   865,   866,     0,     0,     0,     0,     0,     0,   867,
       0,     0,   320,     0,     0,     0,  1419,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   869,   868,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2096,
       0, -1929,     0,     0,     0,     0,   870,     0,     0,     0,
     855,   856,   857,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   858,     0,  1421, -1929, -1929,     0,     0,     0,
       0,     0,     0,     0,  2097,     0,     0,     0,     0,     0,
       0,     0,     0,  2098,     0,   869,     0,     0,     0,     0,
     318,     0,  2099,     0,     0,     0,     0,     0,   321,     0,
    3704,     0,     0,   850,     0,     0,     0,     0,     0,   851,
     852,     0,     0,   870,     0,     0,   849,     0,     0,  1048,
       0,  1420,   317,     0,     0,   854,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2100,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   859,
     860,   861, -1929,   871, -1929, -1929,     0,     0,     0,   862,
       0,   863,     0,     0,     0,   321,     0,     0,   319,     0,
       0,     0,   864,   865,   866, -1929,     0,     0,     0,     0,
   -1929,   867,     0,     0,   320,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   868,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -1929,
     871,     0,     0,     0,     0,     0,     0,   322,     0,     0,
       0, -1929,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1421,     0,     0,     0,
       0,     0,     0,   872,   873,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   869,     0,     0,
     850,     0,     0,     0,     0,     0,   851,   852,     0,     0,
       0,     0,  1422,     0,     0,   849,     0,     0,     0,     0,
       0,   317,   854,     0,   322,   870,     0,     0,     0,     0,
     855,   856,   857,     0,     0,   323,     0,     0,     0,     0,
       0,     0,   858,     0,     0,     0,     0,     0,     0,     0,
     872,   873,     0,   875,     0,     0,     0,     0,     0,     0,
   -1929,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     318,     0,     0,     0, -1929,     0,     0,   321,     0,     0,
     876,     0,     0,     0,     0,     0,     0,     0,   877,  3705,
       0,  3706,     0,  2101,     0,     0,     0,  2102,     0,  2103,
    3707,  3708,   323,     0,  3709,  3710,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   878,     0,     0,     0,
     875,     0, -1929,   207,     0,     0,     0,     0,     0,   859,
     860,   861,   871,     0,     0,     0,     0,     0,   325,   862,
       0,   863,     0,     0,     0,     0,     0,   876,   319,     0,
       0,     0,   864,   865,   866,   877,     0,   849,     0,     0,
       0,   867,     0,   317,   320,     0,     0,     0,     0,   850,
       0,     0,     0,     0,     0,   851,   852,     0,     0,     0,
       0,   868,     0,   878,     0,     0,     0,     0,     0,     0,
     207,   854,     0,     0,     0,     0,     0,   855,   856,   857,
       0,     0,     0,     0,     0,   325,   322,     0,     0,   858,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   849,     0,     0,     0,     0,
       0,   317,   872,   873,     0,     0,     0,   318,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   869,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1423,     0,  1424,     0,   870,     0,     0,     0,     0,
       0,     0,  1425,  1426,   323,     0,  1427,  1428,     0,     0,
       0,     0,     0,     0,     0,     0,   859,   860,   861,     0,
       0,     0,   875,     0,     0,     0,   862,     0,   863,     0,
       0,   850,     0,     0,     0,   319,     0,   851,   852,   864,
     865,   866,     0,     0,     0,     0,     0,   321,   867,   876,
       0,   320,     0,   854,     0,     0,     0,   877,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   868,     0,
       0,   849,     0,     0,     0,     0,     0,   317,     0,     0,
       0,     0,     0,     0,     0,   878,   855,   856,   857,     0,
       0,     0,   207,     0,     0,     0,     0,     0,   858,   850,
       0,     0,   871,     0,     0,   851,   852,   325,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   854,     0,     0,     0,     0,   318,     0,     0,     0,
       0,     0,     0,     0,   869,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   870,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   322,     0,     0,     0,
       0,     0,     0,     0,     0,   859,   860,   861,     0,     0,
       0,     0,     0,     0,     0,   862,     0,   863,     0,     0,
       0,     0,   872,   873,   319,     0,     0,     0,   864,   865,
     866,     0,     0,   849,   321,     0,     0,   867,     0,   317,
     320,     0,     0,     0,     0,   850,     0,     0,   855,   856,
     857,   851,   852,     0,  1716,     0,     0,   868,     0,     0,
     858,     0,     0,     0,     0,     0,     0,   854,     0,     0,
       0,     0,     0,     0,   323,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   318,   871,
       0,     0,   875,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   855,   856,   857,   876,
       0,     0,     0,   869,     0,     0,     0,   877,   858,     0,
     963,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   859,   860,   861,
       0,   870,     0,     0,     0,   878,   318,   862,     0,   863,
       0,     0,   207,   322,     0,     0,   319,     0,     0,     0,
     864,   865,   866,     0,   849,     0,     0,   325,     0,   867,
     317,     0,   320,     0,     0,     0,     0,   850,     0,   872,
     873,     0,     0,   851,   852,     0,     0,     0,     0,   868,
       0,     0,     0,   321,     0,     0,     0,     0,     0,   854,
       0,     0,     0,     0,     0,   859,   860,   861,     0,     0,
       0,     0,     0,     0,     0,   862,  1297,   863,     0,     0,
       0,     0,     0,     0,   319,     0,     0,     0,   864,   865,
     866,   323,   855,   856,   857,     0,     0,   867,     0,     0,
     320,     0,     0,     0,   858,     0,     0,     0,   871,   875,
       0,     0,     0,     0,     0,   869,     0,   868,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   318,     0,     0,     0,   876,     0,     0,     0,
       0,     0,     0,   870,   877,     0,     0,     0,     0,     0,
     849,     0,     0,     0,     0,     0,   317,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   878,     0,     0,     0,     0,     0,   850,   207,
       0,     0,   322,   869,   851,   852,     0,     0,     0,     0,
       0,   859,   860,   861,   325,   321,     0,     0,     0,     0,
     854,   862,     0,   863,     0,     0,     0,     0,   872,   873,
     319,   870,     0,     0,   864,   865,   866,     0,     0,     0,
       0,     0,     0,   867,     0,     0,   320,     0,     0,     0,
       0,     0,     0,     0,   855,   856,   857,     0,     0,     0,
       0,     0,     0,   868,     0,     0,   858,     0,     0,     0,
     871,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     323,     0,     0,   321,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   318,     0,     0,     0,   875,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1959,     0,     0,     0,     0,     0,   317,     0,
       0,     0,     0,     0,   850,   876,     0,     0,     0,   869,
     851,   852,     0,   877,     0,     0,     0,     0,   871,     0,
       0,     0,     0,     0,   322,     0,   854,     0,     0,     0,
       0,     0,     0,   859,   860,   861,     0,   870,     0,     0,
       0,   878,     0,   862,     0,   863,     0,     0,   207,     0,
     872,   873,   319,     0,     0,     0,   864,   865,   866,     0,
       0,     0,     0,   325,     0,   867,     0,     0,   320,     0,
       0,     0,     0,     0,     0,   855,   856,   857,     0,     0,
       0,     0,     0,     0,     0,   868,     0,   858,     0,   321,
       0,     0,   322,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   323,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   318,     0,     0,   872,   873,
     875,     0,     0,     0,     0,     0,     0,  3365,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   871,     0,   850,   876,     0,     0,
       0,   869,   851,   852,     0,   877,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   854,     0,
     323,     0,  2755,     0,   859,   860,   861,     0,     0,   870,
       0,     0,     0,   878,   862,     0,   863,     0,   875,     0,
     207,     0,     0,   319,     0,     0,     0,   864,   865,   866,
       0,   855,   856,   857,     0,   325,   867,     0,     0,   320,
    3306,     0,     0,   858,     0,   876,     0,     0,   322,     0,
       0,     0,     0,   877,     0,     0,   868,     0,     0,     0,
       0,   321,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   318,     0,     0,   872,   873,     0,     0,     0,     0,
       0,   878,     0,     0,     0,     0,     0,     0,   207,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   325,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   871,     0,     0,     0,
       0,     0,   869,     0,     0,     0,   323,     0,     0,     0,
     859,   860,   861,     0,     0,     0,     0,     0,     0,     0,
     862,     0,   863,     0,   875,     0,     0,     0,     0,   319,
     870,     0,     0,   864,   865,   866,     0,     0,     0,     0,
       0,     0,   867,     0,     0,   320,     0,     0,     0,     0,
       0,   876,     0,   855,   856,   857,     0,     0,     0,   877,
       0,     0,   868,     0,     0,   858,     0,     0,     0,     0,
     322,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2168,     0,   321,     0,     0,     0,     0,   878,     0,     0,
    2169,     0,     0,   318,   207,     0,   872,   873,     0,     0,
       0,     0,     0,     0,     0,     0,  2170,     0,     0,   325,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2171,   869,     0,
       0,     0,     0,     0,     0,     0,     0,   871,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   323,     0,
       0,     0,   859,   860,   861,  2172,   870,     0,     0,     0,
       0,     0,   862,     0,   863,     0,   875,     0,  2173,  2174,
    2175,   319,     0,  2176,     0,   864,   865,   866,     0,     0,
    2177,     0,     0,     0,   867,     0,     0,   320,     0,     0,
       0,     0,  2178,   876,  2179,  2180,     0,     0,     0,     0,
       0,   877,     0,     0,   868,     0,     0,     0,   321,     0,
       0,   322,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2181,     0,     0,     0,     0,     0,     0,   878,
       0,     0,     0,     0,     0,     0,   207,   872,   873,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   325,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   871,     0,     0,     0,     0,     0,     0,
     869,     0,     0,     0,     0,     0,  3590,  2182,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   323,
       0,     0,     0,     0,  2183,     0,     0,     0,   870,     0,
       0,     0,  2417,     0,     0,     0,     0,   875,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2184,  2185,     0,
    2186,  2187,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   876,     0,     0,   322,  2418,     0,
       0,     0,   877,     0,     0,     0,     0,     0,     0,     0,
     321,     0,     0,     0,     0,     0,     0,     0,  2419,     0,
       0,     0,     0,   872,   873,  2188,     0,     0,     0,     0,
     878,     0,     0,     0,     0,     0,     0,   207,     0,     0,
       0,  2189,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   325,     0,     0,     0,     0,  2420,     0,     0,
       0,     0,     0,     0,     0,   871,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   323,     0,     0,     0,     0,
       0,  2190,  2191,  2192,     0,  -696,     0,     0,     0,     0,
       0,     0,     0,   875,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2193,     0,     0,     0,     0,  2194,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     876,     0,     0,  2417,     0,     0,     0,     0,   877,     0,
       0,     0,     0,     0,     0,  2195,  2196,     0,     0,   322,
       0,  2197,  2198,     0,     0,     0,     0,  2421,     0,     0,
       0,     0,     0,     0,     0,  2422,   878,     0,     0,  2418,
       0,     0,     0,   207,     0,   872,   873,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   325,  2419,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2199,     0,  2200,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2201,     0,   323,  2420,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2202,  2203,
    2204,     0,     0,     0,     0,   875,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  -697,     0,     0,     0,
       0,     0,     0, -3341, -3341,     0,  2205,     0,     0,     0,
       0,     0,   876,     0,     0,     0,     0,     0,     0,     0,
     877,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2206,  2207,  2208,     0,  2209,     0,  2210,  2211,     0,  2212,
    2213,  2214,     0,  2423,     0,     0,     0,  2215,   878,  2216,
    2217,  2218,  2219,     0,     0,   207,     0,     0,  2421,     0,
   -3341,     0,     0,     0,     0,  2220,  2422,   892,     0,     0,
     325,     0,     0,  2221,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2222,  2223,
   -3341,     0,     0,     0,     0,     0,     0,  2224,     0,     0,
       0,     0,     0,  2225,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2424,     0,    59,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2425,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0, -3412,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2426,
    2226,     0,     0,     0,     0,     0,  2227,     0,     0,     0,
    -696,     0,     0,     0, -3341, -3341,     0,     0,     0,  -696,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   850,
       0,     0,     0,     0,     0,   851,   852,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   854,     0,     0,  2423,     0,     0,     0,     0,  2228,
    2229,     0,  2230,     0,     0,     0,     0,     0,     0,     0,
    2231, -3341,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   892,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2232,     0,     0,     0,     0,
       0, -3341,     0,     0,     0,     0,     0,     0,  2233,  2234,
    2235,  2236,     0,     0,  2427,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2424,     0,    59,     0,  2237,  2238,
       0,     0,     0,     0,     0,     0,  2425,     0,     0,  2239,
       0,     0,     0,     0,     0,     0,     0,     0, -3412,     0,
       0,  2428,     0,     0,     0,     0,     0,     0,     0,     0,
    2426,     0,  2429,     0,     0,     0,     0,     0,     0,  2240,
       0,  -697,  -696,     0,     0,     0,     0,     0,     0,     0,
    -697,     0,     0,  2241,  2242,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   850,     0,     0,
       0,     0,     0,   851,   852,     0,     0,     0,     0,     0,
       0,     0,  2430,     0,     0,     0,     0,     0,     0,   854,
    2243,     0,     0,     0,     0,     0,   855,   856,   857,  -696,
    2244,     0,     0,   892,     0,     0,     0,  2245,   858,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2246,     0,
       0,     0,  2247,  2248,  2249,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   318,     0,  2431,     0,
       0,  -696,     0,  2250,  2251,  2427,     0,     0,  2252,  2253,
       0,  2254,     0,     0,     0,  2432,     0,     0,  2255,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2433,     0,     0,     0,
       0,     0,  2428,     0,     0,     0,     0,     0,     0,     0,
       0, -3341,     0,  2429,     0,   859,   860,   861,     0,     0,
       0,     0,     0,  -697,     0,   862,     0,   863,     0,     0,
       0,     0,     0,     0,   319,   850,     0,     0,   864,   865,
     866,   851,   852,     0,  2434,     0,     0,   867,     0,     0,
     320,     0,     0,     0,     0,     0,     0,   854,     0,     0,
       0,     0,     0,  2430,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  -696,     0,
    -697,     0,     0,     0,   855,   856,   857,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   858,     0,     0,     0,
       0, -3412,     0,     0,     0,     0,     0,     0,  2435, -3341,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2431,
       0,     0,  -697,   892,   318,     0,     0,     0,     0,     0,
       0,     0,     0,   869,  2436,     0,  2432,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2437,
       0,  2438,     0,  2439,     0,     0,  2440,  2433,     0,     0,
    2441,   870,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0, -3341,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   859,   860,   861,     0,     0,     0,     0,
       0,     0,  -696,   862,     0,   863,     0,     0,     0,     0,
       0,     0,   319,     0,     0,  2434,   864,   865,   866,     0,
       0,     0,     0,   321,     0,   867,     0,     0,   320,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   855,   856,   857,   850,     0,     0,     0,  -697,
       0,   851,   852,     0,   858,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   854,     0,     0,
       0,     0, -3412,     0,     0,     0,     0,     0,   871,  2435,
   -3341,     0,   318,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     892,     0,     0,     0,     0,  2436,     0,     0,     0,     0,
       0,   869,     0,     0,     0,     0,     0,     0,     0,     0,
    2437,     0,  2438,     0,  2439,     0,     0,  2440,     0,     0,
       0,  2441,     0,     0,     0,     0,     0,     0,     0,   870,
       0,   859,   860,   861,     0,     0,     0,     0,     0,     0,
       0,   862,   322,   863,     0,     0,     0,     0,     0,     0,
     319,     0,     0,  -697,   864,   865,   866,     0,     0,     0,
       0,     0,     0,   867,     0,     0,   320,     0,   872,   873,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   321,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   850,     0,     0,     0,     0,  1938,   851,   852,
       0,     0,     0,     0,     0,     0,     0,     0,   893,     0,
     323,     0,   894,   895,   854,     0,     0,     0,     0,     0,
       0,     0,   855,   856,   857,     0,   871,     0,   875,     0,
       0,     0,     0,     0,   858,     0,     0,     0,     0,   869,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   876,     0,     0,     0,     0,
    1261,     0,   318,   877,     0, -3439,     0,   870,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -3439, -3439,
   -3439, -3439,     0,     0,     0,  1262, -3439,     0,     0,     0,
       0,   878,     0,     0,     0,     0,     0,     0,   207,     0,
     322,     0,     0,     0,     0, -3439,     0,     0,     0,     0,
       0,     0,     0,   325,     0,     0,     0,     0,     0,   321,
       0,   859,   860,   861,     0,     0,   872,   873,     0,     0,
       0,   862,     0,   863,     0,     0,     0,     0,     0,     0,
     319,     0,     0,     0,   864,   865,   866,     0,     0,     0,
       0,     0,     0,   867, -3291, -3439,   320,     0, -3291,     0,
       0,     0,     0,     0,     0,  2856,     0,     0,     0,     0,
       0,     0,     0,     0,   871,     0,   893,     0,   323,     0,
     894,   895,     0,     0,     0,     0,     0,     0,     0,   855,
     856,   857, -3439,     0, -3439,     0,   875,     0,     0,     0,
       0,   858,     0,     0,     0,     0, -3439,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   876,     0,     0,     0,     0,     0,   318,
       0,   877,     0, -3439,     0,     0,     0,     0,     0,   869,
       0,     0,     0,     0,     0,     0,     0,     0,   322,     0,
       0,     0,     0,     0,     0,     0,     0,  4508,     0,   878,
       0,     0,     0,     0,     0,     0,   207,   870,     0,     0,
    4509,  4510,  4511,  4512,   872,   873,     0,     0,  4513,     0,
       0,   325,     0,     0,     0,  3125,     0,     0,   859,   860,
     861,     0,     0,     0,     0,     0,  4514,  4515,   862,     0,
     863,     0,     0,     0,     0,     0,     0,   319,     0,     0,
       0,   864,   865,   866,     0,     0,     0,  4516,     0,   321,
     867,     0,     0,   320,   893,     0,   323,     0,   894,   895,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4517,
       0,     0,     0,     0,   875,     0,  2553,  4518,     0,     0,
    2554,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   876,     0,     0,   871,     0,     0, -3439,     0,   877,
       0,     0,     0,     0,  4519,     0,     0,  1263, -3439,     0,
       0,     0,     0,     0,     0,  4520,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   869,   878,     0,     0,
       0,     0,     0,     0,   207,     0,     0,     0, -3439,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   325,
       0,     0,     0,     0,   870,     0,     0,     0,     0,     0,
    -776,  -776,     0,     0,     0,     0,     0,     0,   322,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0, -3439,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   872,   873,     0, -3439,     0,     0,
       0,     0,     0,     0,     0,     0,   321,     0,     0,     0,
   -3291,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0, -3439,
    4521,     0, -3439,  3148,     0,     0,     0,     0,     0,     0,
       0,     0,  1851,     0,   893,     0,   323,     0,   894,   895,
       0,     0,  1264,     0,     0,  1852,  1853,  1854,  1855,     0,
       0,   871,     0,  1856,   875,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -3439,     0,
       0,     0,  1857,     0,     0, -3439,     0,     0,     0,  4522,
       0,   876,     0,     0,     0,     0,     0,     0,  4523,   877,
    4524,     0,     0,     0,     0,     0,   850,     0, -3341,     0,
       0,     0,   851,   852,     0,     0,     0,     0,  4525,     0,
       0,     0, -3439,     0,     0,     0,     0,   878,   854,     0,
    4526,     0,  1858,     0,   207,   322,     0,  4508,     0,     0,
   -3439,     0,     0,     0,     0,     0,     0,     0,     0,   325,
    4509,  4510,  4511,  4512,     0,     0,     0,     0,  4513,     0,
       0,   872,   873,    59, -3291, -3291,     0,     0,     0,  1859,
       0,  1860,     0,  2425,     0,     0,  4514,  4515,     0,     0,
       0,     0,     0,  1861,     0, -3412,     0,     0, -3439,  4527,
       0, -3439,     0,     0,     0,     0,     0,  4516,     0,     0,
       0,     0,  4528,     0,     0,     0,  4529,     0,     0,     0,
    1862,   893,     0,   323,     0,   894,   895,     0,     0,  4517,
       0,     0,     0,     0,  4530,     0,  2553,  4518,     0,     0,
    2554,   875,     0,     0,     0,     0,     0,     0,     0, -3439,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -3439,     0, -3439, -3439,  -776,     0,     0,   876,     0,
       0, -3439,     0,     0,  4519,     0,   877,     0,     0,     0,
    4531,     0,     0,     0, -3439,  4520,     0,  1870,     0, -3439,
       0,     0,     0,     0,     0,     0,     0, -3439,     0,     0,
       0,     0,     0,     0,   878,     0,     0,     0,     0,     0,
       0,   207,     0,   855,   856,   857,     0,     0,     0,     0,
       0,     0,  4532,     0,  1871,   858,   325,     0, -3439,     0,
    -776,  -776,     0,     0,     0,     0,     0,     0,     0,     0,
   -3439,     0,  4533,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   318,     0,     0,     0,     0,     0,  2428,
       0,     0,     0,     0,  1863,     0,  2555,  2556,     0,     0,
       0,     0,     0,     0, -3439,  1864,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4534,     0,     0,     0, -3293, -3439,     0,     0,     0,     0,
    4521,     0,     0,     0,     0,  1865,     0,     0,     0,     0,
       0,     0,   859,   860,   861,     0,     0,     0,     0,     0,
       0,     0,   862,     0,   863,     0,     0,     0,     0,     0,
       0,   319,     0,     0,     0,   864,   865,   866,     0, -3439,
       0,  4535,     0,     0,   867,     0,     0,   320,     0,     0,
       0, -3439,     0,  1876,     0,  1877,  1878,     0, -3439,  4522,
       0,     0,     0,  4536,  1866,     0,     0,     0,  4523,     0,
    4524,     0,     0,     0,     0,     0,     0,     0, -3341,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4525,  4537,
       0,     0,     0,     0,     0,     0,  1867,     0,     0,  1868,
    4526,   534,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2433,     0,     0,     0,     0,     0,
    4538,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     869,     0,  4539,    59,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2425,     0,  1869,     0,     0,     0,     0,
       0,     0,  1870,     0,     0, -3412,     0,     0,   870,  4527,
       0,     0,     0,   850,     0,     0,  4540,     0,     0,   851,
     852,     0,  4528,     0,     0,     0,  4529,     0,     0,     0,
       0,     0,     0,     0,     0,   854,     0,     0,     0,  1871,
       0,  4541,     0,     0,  4530,     0, -1132,     0,     0,     0,
       0,     0,  4542,     0,     0,     0,     0,  1872,     0,     0,
     321,     0,     0,     0,     0,     0,     0,     0,     0, -3412,
       0,     0,     0,     0,     0,  -776,     0,   850,     0,     0,
       0,  4543,     0,   851,   852,     0,     0,     0,     0,     0,
    4531,     0,     0,     0,     0,     0,     0,  1870,     0,   854,
       0,     0,  4544,     0,     0,  1873,  4911,     0,  1874,     0,
    4545,  -776,     0,     0,     0,   871,     0,     0,     0,  4546,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4532,     0,  1871,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4533,     0,     0,     0,  1875,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1876,  2428,
    1877,  1878,     0,     0,     0,     0,  2555,  2556,  1879,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   322,
       0,  1880,     0,     0,     0,     0,  1881,     0,     0,     0,
    4534,     0,     0,     0,  1882,     0,     0,     0,     0,     0,
     855,   856,   857,     0,     0,   872,   873,     0,     0,     0,
       0,     0,   858,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0, -3399,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1883,     0,     0,
     318,  4535,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1876,     0,  1877,  1878,   323,     0,     0,
       0,     0,     0,  4536,   855,   856,   857,     0,     0,     0,
       0,  1884,     0,     0,     0,   875,   858,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4537,
       0,     0,  1885,     0,     0,     0,  4912,     0,     0,   859,
     860,   861,   876,     0,   318,     0,     0,     0,     0,   862,
     877,   863,     0,     0,  2433,     0,     0,     0,   319,     0,
    4538,     0,   864,   865,   866,     0,     0,     0,     0,     0,
       0,   867,  4539,     0,   320,     0,  1886,     0,   878,     0,
       0,     0,     0,     0,     0,   207,     0,     0,  1887,     0,
       0,     0,     0,     0,     0,  1888,     0,     0,     0,     0,
     325,     0,     0,   859,   860,   861,  4540,     0,     0,     0,
       0,     0,     0,   862,     0,   863,     0,     0,     0,     0,
       0,     0,   319,     0,     0,     0,   864,   865,   866,     0,
       0,  4541,     0,     0,     0,   867, -1135,     0,   320,     0,
       0,     0,  4542,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   869,     0, -3412,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4543,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   870,     0,     0,     0,     0,
       0,     0,  4544,     0,     0,     0,     0,     0,     0,     0,
    4545,  -776,     0,     0,     0,     0,     0,     0,     0,  4546,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   869,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   321,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   870,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   871,     0,     0,     0,     0,     0,     0,     0,
       0,   321,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   871,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   322,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   872,   873,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     322,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   323,     0,   894,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   872,   873,     0,     0,
       0,     0,   875,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   876,
       0,     0,     0,     0,     0,     0,     0,   877,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   323,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   878,   875,     0,     0,     0,
       0,     0,   207,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   325,     0,     0,
       0,     0,     0,   876,     0,     0,     0,     0,     0,     0,
       0,   877,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   878,
       0,     0,     0,     0,     0,     0,   207,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   325
};

static const yytype_int16 yycheck[] =
{
     175,   224,   690,   317,   755,   727,  1277,    52,  1060,  1121,
     267,   127,   763,    58,   156,    43,   158,   201,   680,  1272,
     717,   163,   699,   759,   760,   761,  1621,    73,   764,  1757,
    1215,   194,   694,    79,  1861,   849,    81,    82,   721,    84,
      85,  1143,  2281,  1724,    90,  2409,   809,   810,    76,    77,
      78,  1085,  1355,  2466,   780,    83,  2029,  1420,   784,   785,
    1245,   787,   788,   205,   790,   791,   281,  2040,   730,  1433,
     685,  2598,  2551,   118,  2674,  2439,  2484,  2485,  1194,  2558,
    1196,  1197,   679,  1199,  1200,  1777,  2613,   310,  1391,  1392,
    1393,  1394,   845,   308,   697,  1841,   680,   693,   702,   702,
     145,   146,   147,  2861,   781,   782,   230,   947,  1758,   786,
    1933,   139,   789,  1936,  2922,  2483,  2924,   721,   721,   933,
     800,  1100,  1945,   706,  2912,   153,  1949,   155,   725,   681,
     874,   159,   160,  1956,  1873,  3383,  1730,  1283,  3407,   722,
    2563,   169,  1381,   884,  2567,   190,  2750,   175,  1294,  1293,
     195,  1448,   941,   181,  2322,  2351,   184,  2717,  1904,   187,
    1408,  1305,   903,  2028,  2712,   976,  1912,  3720,  1297,  2782,
    1409,  3111,   941,    18,  2923,   203,     0,   223,  1645,    18,
       1,     0,    18,  2743,     0,  2050,     1,   233,   862,   863,
    2410,  2278,     1,   221,  1999,    18,   870,     8,    18,    33,
      27,     1,   247,  2689,   232,   250,    91,   133,     5,    46,
      18,    75,     1,    18,    69,    33,    45,    18,   123,   121,
     124,   175,   884,   268,    46,    18,     1,   156,   256,   158,
     892,   893,   894,   895,   163,  1075,   171,    40,    45,    18,
     151,   903,   916,   222,   124,   226,   124,  2670,    15,  1676,
    2673,   170,     1,    18,   568,   151,     1,   246,  2681,    27,
     508,  2066,   290,  1248,    33,   258,    43,  3575,   251,   187,
    1399,   213,    21,   256,  1895,  1044,   205,   312,    41,   151,
     245,   290,    12,   339,  1385,    97,   252,   338,   334,   335,
     268,   874,   205,  1769,  1034,    99,   214,   342,  1277,  2826,
    2827,    68,  1409,   259,   349,   205,   274,   359,  1030,    32,
     894,    14,   245,   183,    97,  3399,  1105,   128,   300,    98,
      12,  4133,   305,   274,   187,   171,   434,    97,   312,   268,
     467,     1,   481,    33,   434,   259,  1105,  3197,   312,   231,
     232,   297,   124,   299,  3428,   134,  1904,  3207,   414,  2350,
     277,   214,   201,   312,  1912,   284,    44,  1146,    18,   171,
     912,   216,    32,   184,   446,   154,   541,   151,    51,  1113,
    2858,   587,   339,   970,   481,   434,     1,   126,  1040,    33,
      52,  2361,   259,   303,    70,  2157,   175,   176,   455,   572,
      40,  3662,   312,   252,  3230,   250,  1118,   373,  1060,   742,
      45,   378,   434,   481,  3008,   339,   320,   136,   378,  1012,
    3241,   587,  3016,    12,   312,  3019,  3020,   452,  2841,   374,
     223,   258,   680,  1085,    44,  1028,  1177,   684,   123,   414,
     687,   621,   127,   697,   231,   184,   258,   359,   187,   330,
     189,   414,   776,   246,   459,  3312,    71,    72,    73,    74,
     269,    76,   462,   269,   852,   748,   275,    12,   715,   275,
     834,   718,  1225,    12,   124,   214,   723,    12,  2273,  4067,
     535,   694,   729,   358,   247,   690,  3312,  3746,   359,   787,
    4762,    43,   781,  1145,   433,   248,   231,   232,  4128,   115,
    2577,  1095,  1095,   124,    12,   312,   358,   525,   526,  1102,
     116,   467,   481,   339,  1633,   251,  4104,  1260,   422,  2922,
     256,  2924,   540,  1266,   325,   434,   362,   408,   481,   547,
    4395,   749,   408,   569,   410,  2893,   171,   441,  3776,   434,
    1113,   201,   394,   158,   159,   221,   375,  1278,   169,   953,
      53,   955,    55,    56,    57,    58,    59,    60,   341,   322,
     858,   151,   541,   434,  2359,   374,   849,   955,   374,   305,
     309,  1145,   896,  1352,   434,  4847,   484,   831,   578,   647,
     481,   259,   865,   223,    99,   137,   481,   870,   541,   141,
     151,   955,   647,  3523,  4459,   151,   570,  1716,  2784,   408,
     379,   410,   408,   310,   410,   151,  3404,   896,   373,   584,
     434,  4241,  1343,   530,   526,   863,  4204,   591,   467,   254,
    2849,   178,   476,   517,   432,   958,   434,   591,  1280,  1281,
    1282,   484,   571,   596,   403,  1287,  1288,  1289,  1290,   857,
     845,  1293,  1385,   316,   526,   819,   645,   151,   403,   259,
     815,  1303,  1827,  1305,  1306,   434,   338,  3055,   456,  3920,
    1312,  1313,  1314,  1315,  1316,  1317,  1318,  1319,  1320,  1321,
    1322,  1323,    77,   456,  2884,   434,  3214,    25,   216,   645,
     590,   591,  1334,   930,  2355,    25,   481,   444,   151,  3239,
     378,   341,  1297,   462,   463,   868,   600,  1349,   945,    18,
     479,   646,  1354,   591,   664,   294,   245,   546,  1814,   488,
     430,   110,   481,  1287,  1288,  1289,  3573,   722,   123,   412,
     413,   403,   467,   378,   781,   369,   481,   932,   497,  1303,
     290,  2085,   347,   348,   349,   350,   351,   352,   353,   354,
     355,  2503,   497,   779,   434,   484,   713,  3573,  3569,   955,
     541,  3572,   445,   713,   852,   852,   252,    25,   683,  2576,
     378,   680,   681,   570,  4121,   300,   685,   327,   328,   422,
     446,  2064,  2742,  2983,   954,  1349,   529,   417,   697,   698,
    1354,   803,   442,   702,   591,  1372,   842,   706,  4233,   955,
     472,   526,   474,   850,  1399,   588,   489,    18,   717,   481,
     719,   819,   721,   722,    18,    25,   456,   520,  1942,   858,
    2546,   767,   606,   732,   403,   497,   834,  1403,   432,   738,
    2538,   506,  2813,  1028,   780,   247,   499,  1040,   607,  2624,
    2909,   970,  1662,   593,   184,   185,  1640,   646,  3316,   578,
     646,   561,  2071,   459,   971,  2083,  1965,  1060,   541,   434,
    2586,   687,   647,   459,  1829,  1060,  4658,   955,   403,  2276,
     520,   446,   641,   452,   403,   955,   481,   587,   403,   531,
     532,   533,  3466,   759,    69,  2776,   795,   668,  1608,  4236,
     645,   683,   954,   472,   798,   474,   858,  1911,   566,   857,
     806,   660,   481,    88,   868,   403,   813,   759,  2127,   857,
    1616,  1443,  3976,   124,   868,   660,   852,   679,   497,   955,
     683,   123,  3842,   955,   955,   127,   857,  1648,   767,   698,
    1699,   473,  2999,   683,   136,   514,   608,   472,   857,   474,
     955,   780,  4230,   472,  2025,   474,   481,   472,  1143,   474,
     794,   123,   481,   859,   847,   127,   481,  1185,   903,   857,
     201,  2368,   497,  3351,   789,   874,   955,   847,   497,   749,
     645,   740,   497,   515,   472,  1617,   474,    12,   854,  2580,
     830,   954,   123,   481,  2071,   954,   127,  2443,   660,   947,
     903,   641,   955,   954,   852,   759,   955,  3479,   650,   497,
     857,   704,   854,   912,  3486,   865,  3846,   872,   955,   514,
     870,  3404,   741,  3742,   857,   930,   955,  1811,  1812,   953,
     625,   955,   806,  3616,   781,   971,  1668,   936,   711,   608,
     789,   781,   954,   955,   737,  1190,   935,  1192,  1633,   921,
    1195,   955,    18,   648,   789,  1209,  1630,  1630,  2586,  1204,
     922,   794,   795,   857,   704,   764,  3867,  2022,   857,  3403,
     869,   857,   860,  2022,   955,  1260,  1188,  1189,  3534,   904,
     955,  1266,   956,   608,   153,  1818,  1198,   857,   753,   608,
     857,   660,   869,   608,   955,   627,   628,   737,   857,   954,
     854,  1797,  1798,   822,   955,   645,   844,  1803,   955,   765,
    1806,   606,   857,  1012,   754,   834,  1748,  1690,   867,   858,
     608,   955,   403,   224,   902,   972,   722,   789,  1355,  1028,
      25,  1716,   867,    18,   905,   660,   722,   925,   857,   902,
     341,   660,   971,   259,  4054,   660,   955,   954,   930,   955,
     947,   955,  1337,   872,  1169,   970,   896,  1342,   965,   947,
     697,  1060,   955,  3353,   955,   955,   955,   867,   955,   955,
     955,    43,   660,   965,   955,  1959,   955,   930,   972,  1823,
     955,   954,  1367,   972,   514,   853,   972,  1185,  1342,   759,
     930,   962,   857,   578,  1748,   954,  1095,  1850,   526,  2636,
    1385,   302,   403,  1102,  1963,   867,   526,   922,  1861,   403,
     947,   442,   971,   359,  1113,   955,   497,   857,   759,  1930,
     789,   970,   955,   759,  1963,    18,   401,  3170,  3171,  3172,
    3173,   873,   874,   759,   869,   970,   955,    30,   954,   955,
    1139,  1955,   541,   622,   886,  2865,   971,   966,   680,  3587,
     880,  1249,  3442,   322,   467,   456,   259,  2279,  3315,  3978,
    3317,    18,   949,   665,   789,   137,  1264,  3324,   955,   141,
     789,   869,   945,   842,   789,   759,   300,  4187,   526,  1911,
     481,   954,   500,    18,   854,   460,   445,   481,   921,  1188,
    1189,   767,   954,   955,   831,   865,   497,  4722,   867,  1198,
     870,   789,  2025,   497,   780,    98,   801,   637,   970,  3018,
    1942,   806,   216,   854,   506,    48,   759,   506,   854,  3902,
     495,  4844,  3379,   841,  2328,  2976,   526,   852,   854,   462,
     489,   925,  3391,   852,   852,  2116,   481,  3809,  2547,   489,
    3858,   481,   867,   858,   506,  3007,  4683,  3122,   867,   456,
     320,  3823,   867,   414,   184,   481,    25,    25,   434,   189,
     955,   481,  1261,   765,   859,  4583,  2521,  2522,   667,     1,
     854,  3206,  4100,   856,   906,   506,   218,   456,   403,   867,
    1965,   559,   541,   866,   903,   137,   955,  3268,  2410,   141,
     955,   541,   129,   587,   510,   541,  4440,   462,  1297,   481,
     442,   970,  1955,   434,  1549,    25,    45,  3499,  2617,  2618,
     641,   854,   484,   473,     0,   955,   510,  4635,    97,  2505,
    2506,   625,   954,   481,  2120,  2511,  2512,   222,   603,   600,
     955,  1616,   541,  3208,   489,  3210,   955,   403,   647,  2150,
     955,   481,  2651,  2652,  2091,   970,   403,   472,   587,   474,
    3616,   970,   422,   645,  2721,   970,   481,   952,   514,   660,
     892,   893,   894,   895,   359,  1987,   660,   955,   322,   323,
      44,   441,   497,   412,   378,  1668,  3251,     8,  3616,   309,
    2698,  2128,   970,   645,  2600,   619,  2602,  4215,   259,  2605,
    2137,   481,  2608,  2609,  2610,  1680,  2612,  2611,   573,  2615,
    1399,   343,  3692,   407,   834,  4452,   445,   510,   789,  2718,
    2626,  2627,   473,   481,   645,   481,   481,   481,   403,   326,
    1705,  3993,  3994,   754,   481,   379,   319,   481,   302,  4243,
    4121,   497,   171,  1776,  3309,   559,  3311,   183,   403,    20,
     497,   716,  3880,    48,  1443,   569,   692,   175,   573,  2333,
     489,   481,   481,   481,   767,   409,  2765,    98,   682,   481,
     514,   753,  4136,   422,   302,    18,  2277,  1810,  1753,   359,
    2779,  4043,   764,  1800,  2783,  1802,   377,  1804,  1805,   473,
    1807,  1808,   441,   608,   481,   481,   655,  2659,   789,   776,
     489,   753,  2691,  3157,  2693,   789,   481,   128,  1692,   625,
     324,   473,   541,  3546,  4318,   455,  4845,  4846,   450,   369,
     403,   680,   497,    94,   849,   254,   481,   559,   342,   902,
    4567,   683,   753,  2334,    39,   955,   857,   302,  1060,   187,
     600,   526,   497,     0,   869,   660,  4875,   312,   481,  2848,
      94,   726,   541,   852,  2358,  4236,   403,  2279,   781,  4407,
    2361,   593,   935,   607,   793,  4873,   214,   445,   752,    41,
    2759,  4389,     0,  4707,   302,   507,   867,   293,   403,   462,
     463,   726,  3323,   867,   434,  2761,   246,  4440,  2331,   880,
     740,   222,   647,  1795,   852,   259,   481,   803,   481,   970,
     359,   359,   863,   594,   660,   857,  2328,  2271,  2271,  2272,
     175,   489,   803,   660,   497,  1703,   822,   782,  4180,   896,
     481,   216,   754,  1145,   854,  2426,   781,   892,   834,  2430,
     854,   822,   541,   839,   481,  3345,   857,  3347,   624,  3438,
    2829,  1630,  4070,  4071,  1633,   595,   954,  3829,   839,   359,
     497,   600,  4786,   375,   537,  1760,   481,   607,   481,   230,
     954,   430,   824,   541,   955,   627,   628,   782,   971,  2391,
    2392,  2283,   497,   955,   789,   954,   434,  1765,   414,   970,
     894,  1769,  1770,   880,  1772,   660,   970,  1775,  1776,   740,
    1778,   857,  4254,   682,   558,  2518,   945,   955,  2435,   154,
      40,  1690,   970,   955,   863,   660,   852,   858,   588,   431,
     803,   880,   595,   541,   954,  2358,   239,  1992,   954,   713,
     955,   154,   613,  2509,   434,   955,   553,  1716,   555,   822,
    3482,   954,   408,   789,   410,   970,   857,  1825,  1826,   955,
    2834,   834,   789,  4440,   858,   955,   839,  2391,  2392,  1984,
    2025,  4179,   867,   481,   970,   954,   740,   919,  1280,  1281,
    1282,  2501,  2006,  2503,  1852,  1287,  1288,  1289,   526,   433,
    1858,  1859,  2884,  2622,   510,  1863,   248,   660,   930,   954,
    2593,  1303,  4081,   955,  1306,   627,   628,   691,   359,  3088,
    1312,  1313,  1314,  1315,  1316,  1317,  1318,  1319,  1320,  1321,
    1322,  1323,  2841,   641,   708,   709,  1795,   955,   717,   374,
     726,   867,   269,   660,   789,  2616,   526,   377,   275,   781,
    3853,   741,   970,   379,  4123,   955,  2998,  1349,   557,  2572,
     546,  2574,  1354,  2576,   789,   660,   484,   183,   954,   955,
     955,   781,  2564,   408,   152,   410,   790,   744,   584,   578,
     906,   783,  3735,   484,  4707,   970,   850,    22,    23,    24,
     403,  1850,   955,    53,   369,    55,    56,    57,    58,    59,
      60,  4440,  1861,   181,   584,   955,    41,  2599,   434,  2601,
      40,   541,  3058,   223,   870,   834,   481,   458,   573,  2611,
     198,   199,   867,   887,   312,   955,   947,   955,    43,   955,
     955,   955,   566,  2625,   359,   894,   789,   571,   955,  2657,
     850,   955,  2000,   259,   970,   798,   945,   374,   489,  3660,
    2564,  3127,   736,   970,  3941,    90,   970,  2162,  2650,   500,
     857,   403,   660,  4786,   124,   955,   955,   955,   481,  2682,
    2683,  2742,   789,   955,   888,   489,  4814,   879,  2036,  2037,
     970,   408,  3375,   410,   497,  2599,   500,  2601,  2046,  4387,
    4388,   512,  2684,   128,   789,   954,  1955,  4627,   955,  2632,
     541,   854,  1961,   856,  3273,  3274,  1965,   881,  4517,  3844,
     955,  2625,   865,   866,   867,   417,   869,   870,   481,  4528,
     247,  3856,  3857,   378,  3839,   970,  2279,   294,  1987,  2800,
    2275,  3300,  3301,   529,  2279,   955,  2650,   735,  4628,   481,
    4707,   481,   484,   321,  3176,   970,  2691,  4637,  2693,   857,
     867,  2743,   955,   861,   479,   497,  1613,   776,   369,  3328,
     373,  3330,   861,   488,   531,   532,   298,   970,   954,  1626,
    2684,   473,   867,  2699,  3909,   954,   479,   540,  2323,  4145,
    3838,   713,    18,   613,   716,   488,    22,   529,   720,    25,
      26,   789,  1079,   223,   857,  4371,   414,   945,   213,    22,
      23,    24,   168,   624,   921,   889,   954,  2066,  2353,   983,
    2954,   646,   659,   248,  2759,   776,   434,   970,   935,  4786,
    2365,   387,   388,   997,  2757,  1617,  2331,   782,  2755,   682,
    2822,   748,    22,   403,   249,    25,    26,   861,   955,  3009,
     924,  2912,  2834,   140,   842,   861,  1133,   660,  1022,   933,
     147,   520,   322,   970,   776,  2114,   955,  2410,  4434,   319,
     955,   624,   703,   971,  4151,   537,  4619,  3231,  4707,  2861,
     481,  4609,  4610,  4626,  1048,   970,   717,   896,  4631,    38,
     733,  4634,   570,   650,  2829,  4251,  2340,  2341,  2342,  2343,
    2344,  2345,  2346,  2347,   510,  2400,  4693,  4694,   313,   465,
     466,   433,   239,   591,    89,   128,  1080,   647,  2822,   379,
     865,   481,   490,  2466,   641,   870,   641,   341,   660,   646,
     316,  2847,  2427,   501,   320,  2574,  2513,   497,  2515,   301,
    2517,   955,   183,   481,   358,   896,  4051,  1111,   641,   955,
     787,  1115,  4680,  4681,   359,   600,  2953,  4786,   865,   303,
     135,  2958,  2959,   870,   481,   341,  1748,   955,   312,   489,
     632,  2895,  2895,   857,   379,   812,   813,   814,  3350,  1143,
     394,   673,   970,   698,   896,   434,   789,  2482,   857,   134,
    4056,   673,  4735,   584,  2489,  4738,   688,  2920,   422,   537,
    4799,  2572,   540,  2574,   434,   698,  3565,   793,   611,   154,
     796,   797,   615,  3010,   673,    15,   446,   441,   259,   239,
     679,   541,  2271,  2272,  2273,   740,   201,  4874,  3711,  3713,
     175,   176,   481,  4832,  2283,   957,   422,   434,   452,  4826,
    2405,   403,   645,  2682,  2683,   567,  3119,   740,    15,   571,
    3184,   642,  4850,   659,   865,   441,  4843,   789,   140,   870,
    2408,   475,   794,   795,   867,   147,   634,   120,    68,   607,
     446,    18,  2420,  2421,  2422,    15,   452,  2572,    15,  2574,
     849,  4814,  2331,    30,   853,  2628,   624,   300,  2436,  2437,
    2438,  3650,  3651,   684,    49,  2443,   489,  3105,  4896,  4897,
     660,    68,   784,   785,   529,   403,  4895,   675,  3111,  2358,
    2359,  2682,  2683,  4841,  3096,  3097,  4800,   870,   921,   481,
      49,   216,   175,   954,   955,   358,   694,  4193,    68,   886,
    4131,    68,   935,  1297,   201,   497,   585,    92,  4927,   588,
     358,   423,   857,  2491,    99,  2607,   749,  3583,   541,   854,
       7,    98,   955,   578,   749,    49,  3290,  3291,  4689,   212,
     865,   394,   216,    92,   857,   870,  2415,   970,   854,  3230,
      99,   860,   275,   226,   387,   388,   394,  2660,  4906,   865,
     269,   787,   871,   481,   870,   854,   473,  2682,  2683,   860,
     477,  4338,  3096,  3097,  4725,   727,   865,   803,    92,   497,
     871,   870,  1280,  1281,  1282,    99,   812,   813,   814,    66,
    3192,   212,   892,   893,   600,   895,   822,   970,  3264,   403,
    1384,    78,   291,  2571,   568,   226,   570,  4520,  1306,   789,
    2578,  3228,   403,   839,  1398,  1399,  4529,   861,   970,  2488,
     645,  2776,  1591,   414,   673,  4538,   590,   591,    18,  3231,
     679,  3312,   465,   466,   875,   876,   971,  3239,   673,   434,
      30,  1610,  1611,  1612,   679,  1429,   673,   855,   125,   510,
     855,   585,   679,   448,   588,   119,   120,   865,   971,   865,
     865,   865,   870,   239,   870,   870,   870,  4856,  3192,   434,
     473,   148,  4861,  4852,   477,   473,   471,   481,   660,   477,
     526,   527,   749,   930,  2839,   932,   862,   867,   864,  3932,
     481,  2846,   329,   497,  2563,  4938,    18,  4940,  2567,  4942,
    1737,   534,   803,  2572,  1741,  2574,   497,  2576,    98,  2531,
     775,   175,   870,  2535,   479,   907,   908,   909,   910,  3385,
     359,  2884,   361,   488,    34,    35,   526,   527,   775,   955,
     207,   414,   578,   579,   469,   470,   569,   568,  2607,   570,
    4751,  3793,   660,    39,    39,   578,    41,   515,   212,   794,
     795,   429,   319,   955,   587,  2624,   576,   577,   749,  2922,
     149,  2924,   226,  2632,   955,  3817,  1312,  1313,  4779,  4780,
    2581,  2582,   960,   961,  4785,   955,   749,  4788,   578,   579,
     481,  4792,  4793,  1288,  1289,  4453,   856,   403,  3491,   728,
     970,   907,   908,   909,   910,   865,   866,   630,   659,   869,
     870,  2670,   124,  3845,  2673,  3407,  3434,   789,   880,  2972,
     481,  3428,  2681,  2682,  2683,   292,   481,    18,   857,  3875,
    2983,   955,  2691,   955,  2693,  3368,   857,   655,   239,    30,
     907,   908,   909,   910,   957,   762,   403,  2931,  2932,  2933,
    2934,   781,   607,  2712,   166,   127,   641,   136,   955,  1633,
     172,   173,   853,   434,   153,   645,   660,   359,    18,  3056,
    3057,   749,  3059,  3060,  3061,   481,   188,  3022,   484,   660,
     154,   789,   588,   844,   621,   481,   641,  2279,   673,   764,
     431,   497,   857,   678,   213,   867,   481,   857,  2757,   366,
    2759,   231,  3573,   954,    15,   462,   463,    98,   122,   852,
    3523,   955,    65,   698,   761,   700,  3021,   316,   639,   955,
     955,  1695,  3666,   529,   481,   359,   488,   955,  2886,  4044,
    4045,   869,   749,   593,   584,  1709,   787,   310,   861,   319,
     497,    34,  1716,   698,    36,    37,  3690,   481,   515,   260,
     857,   869,   803,   369,   510,  3069,  3070,   869,   869,   867,
     869,   812,   813,   814,   869,   869,   869,   869,  1742,   869,
    2829,   822,   319,   869,   261,   869,   869,   420,  4211,   869,
     852,   448,  2841,   955,   262,   740,   263,   727,   839,   369,
     265,  3662,   673,   176,   834,   789,   834,   386,   970,  2391,
    2392,    92,   266,   954,   177,   267,  3111,   268,   789,   523,
    3555,   197,  3557,   480,   290,   841,   869,   272,  2410,   852,
    4189,  4190,   273,   403,    97,  4194,   842,   955,   276,  3075,
     277,   369,   278,   955,   279,   858,  2895,   281,   595,   862,
     369,   864,   312,  3001,   514,  3672,  3004,   640,   140,    45,
     282,   363,   364,   365,   660,   147,   283,   124,   150,  3017,
     430,  2920,   970,   375,   284,  3218,  4299,  3025,  3026,  3256,
     285,   220,   857,   867,  2466,    18,   861,  3230,   286,   481,
     280,   380,   462,   463,   749,   935,   867,    30,   479,   693,
     869,   403,   169,   359,   833,   955,   713,   473,   847,   183,
     852,   481,   857,   660,   852,   378,   955,   955,   483,   955,
     420,  3256,  4154,   205,   581,   643,   481,   497,   210,   211,
    3078,   515,   711,  3268,   953,   570,  4651,   481,   319,   906,
     312,  3245,   947,   953,   255,   338,   852,   770,   695,   392,
     844,   849,     7,  4125,   456,   930,   430,   970,   838,   430,
     954,   852,   464,   607,  3746,    98,   852,   852,    97,  3312,
    3118,   220,   369,   617,   618,   369,    97,  4400,   369,   481,
     430,   271,  2564,   485,   486,   487,   970,   852,   369,   369,
     430,   287,   494,   789,   369,   497,   971,   698,   749,   970,
     657,   857,   170,  3338,   661,    33,   584,  3350,   955,   954,
    3353,    66,   294,   679,   296,   955,  4321,  2599,   788,  2601,
     479,   303,   403,    78,    89,   595,   971,   473,    15,   151,
     312,   446,   781,  3967,   969,   968,   576,   446,   803,  3842,
     803,   522,   789,  2625,   854,   854,   854,   378,   854,   854,
    2014,   854,   854,    39,   698,   854,   718,   852,  3401,  3920,
     713,  3404,  3111,  3406,   852,   692,   378,  4440,  2650,   541,
     125,   378,   446,  4378,   598,    27,   720,   721,   580,   341,
     844,   462,   463,   970,   697,   270,   743,  3382,   697,  3384,
     660,   246,   378,   148,   890,   414,   713,  3245,   857,  3442,
     481,   585,  2684,   378,   584,    18,    14,   854,   921,   856,
    3487,   481,   947,  3895,  3960,  3961,   497,   947,   865,   866,
     867,   258,   869,   870,   803,   695,   922,   923,   713,  1314,
    1315,  1316,  1317,  1318,  1319,  1320,  1321,  1322,  1323,   740,
     422,   930,   379,   947,    39,   722,   434,   804,   379,  3444,
     947,   935,   207,   790,   947,   947,  3451,  3305,   660,  3208,
     576,  3210,   854,   641,   955,  3214,   481,   854,   955,   378,
     573,   782,   541,   718,   970,   571,   259,   433,  3344,  3483,
      97,   341,   301,  3348,  3446,  3480,   319,   930,   930,   852,
      97,   473,   764,    15,  3489,   477,   369,   625,   566,   697,
     852,   221,  3251,  2167,   183,   831,   595,   929,   526,   857,
     109,  3506,   844,   715,   595,  4076,   749,   970,  3561,   789,
     201,   844,   869,   970,   104,   955,   891,   884,  3523,   511,
    3573,   852,   514,   869,   369,    16,    39,   292,  3386,  4475,
    2822,   762,   810,   955,   852,   359,   123,   477,  4119,   765,
     803,  4054,  3400,   489,   764,  3632,  3633,    70,    27,   701,
     593,  4195,  3311,   628,   781,   215,   854,   369,   378,  3604,
     403,   378,   231,   697,    97,   359,   690,   690,   359,   660,
     596,   598,  4216,   589,   854,   274,   856,   789,   489,   946,
     446,   201,   546,   489,  4076,   865,   866,   867,   473,   869,
     870,   572,  2884,   522,   868,  3354,  4152,   226,   644,   914,
     749,   366,   481,   815,   816,   369,  3464,  3465,  4100,  3368,
     849,  3469,   683,  3471,  3472,  3473,  3474,   481,   375,   462,
     463,    97,   481,  3481,  4707,  3483,  3671,   647,   765,   526,
    2922,    25,  2924,   239,   416,   955,   224,   850,   481,  3692,
      97,    97,   216,    15,    68,   863,   641,   541,   541,  3507,
      97,   489,   489,  4297,   497,   867,   489,   567,   298,   641,
     857,    43,   821,   955,   766,  2339,   222,  4233,   880,   222,
    4226,   781,   852,   885,  4187,   588,   482,   860,   955,   259,
    2972,   852,   803,   448,   641,  4786,   854,  3446,  3741,   524,
     970,  2983,   599,   902,   718,   955,   947,   420,   789,   302,
     912,   844,   359,  3462,  3463,   358,   222,    14,   920,    91,
     852,    93,   852,   369,  3719,   480,   844,   506,   522,   645,
    3479,   213,   666,  4215,   417,    43,   589,  3486,   614,   781,
     570,   699,   793,   887,   116,    25,   948,   726,  4309,   861,
     857,   500,   526,   955,   525,   821,   857,  3792,   740,   861,
     215,   641,   595,   224,  3726,   137,   446,  3615,   970,   141,
    4312,   857,   588,   854,  3523,   856,   446,   462,   246,   820,
     584,   446,   583,   446,   865,   866,   867,   462,   869,   870,
     183,   446,   446,   462,   105,   106,   107,  3874,  4359,   834,
     947,   250,  3837,   595,   123,   379,  3555,   379,  3557,   134,
     394,   536,   418,   807,  3096,  3097,  3681,   607,   607,   595,
      22,    23,    24,    18,  2529,   607,   581,   660,  3076,  3791,
      56,   185,   340,    14,  1251,  4338,    92,  1830,  3800,  3588,
     299,  3836,   217,   825,  3806,  3072,  4407,  3842,   305,  3811,
    3812,  2525,    99,   337,   836,   810,  4402,  3819,  1225,  3821,
     312,   168,   695,   530,   219,   847,   530,  4327,  2503,  4177,
    4567,  4156,  3470,  4266,   518,  3061,  3498,  3478,   838,    46,
    4256,  4002,  3463,  4423,  4368,  4434,  3353,  2277,   762,   970,
    1765,  2443,  4786,  4786,  2458,  2458,  4909,  4247,  4135,  3934,
    2158,  3406,   657,  4318,  3404,  3401,   661,  4389,  4786,  2884,
    3192,  2527,    18,  4688,  4751,  4786,  2926,   228,   229,  4860,
     231,  4855,  4236,  3672,    30,  4650,   128,  4375,  4565,   707,
    4521,  1608,  4694,  4521,  4528,  4561,   918,  3941,  1046,  3832,
    1832,  3662,  1838,  3079,  4047,   260,  1260,  1266,  3119,  3110,
    1272,  2630,  1869,  3801,  3530,  1971,   789,  3660,  4193,   912,
    4192,  1337,   692,  3958,  2025,   924,   970,  1395,  1368,  3561,
    2053,  3176,  3820,   955,   982,  2658,   707,  3726,  1403,  3827,
    3828,  2083,  1409,  1406,  4027,  2698,  1008,  3561,   743,  2118,
    3221,  4068,    98,  3223,  1040,  1449,  2154,  3239,  2740,  3578,
    3577,  4092,  1734,  3929,  3604,  1055,  2279,  3262,  4003,  1064,
    2315,  1020,  2776,  3277,  3268,  3276,  2839,  1741,  2851,  1736,
     392,   854,  1677,   856,  2348,  3873,  1093,   722,  2854,  2365,
    3878,  3879,   865,   866,   867,  1095,   869,   870,  3313,  2365,
    4359,  4523,  3791,  1709,  4223,  2326,  2314,  4009,  4345,   804,
    3934,  3800,  4089,  3665,  4392,  4464,  4397,  3806,  2544,  4054,
    3809,  1752,  3811,  3812,  1380,  2546,  2621,  1379,  3350,  2620,
    3819,  3353,  3821,  3318,  3823,  3901,  3304,  4039,  3303,  3319,
    2656,  3654,  4125,  3655,  2655,   919,     7,   459,   721,  1429,
    2818,  2818,  3940,  3842,  2818,  3711,   732,  2818,   300,  2118,
    1331,   473,  3950,  3446,  2990,   477,   314,  1139,  2497,  3858,
    3920,   422,   423,  3895,  2334,  4119,  3964,  4523,  3425,  3401,
    1334,  4251,  3404,   728,  3406,  3407,  2520,   830,  4575,   884,
    1766,   813,   877,  2980,  4263,  2647,   447,   970,  2802,  2350,
    4175,  4176,  4177,  4138,  3310,    66,  4507,    21,  3642,  2479,
    4786,  1185,  4111,  3193,  3225,  3843,  4158,    78,  4832,  4718,
    3442,  2825,   473,   847,  4888,   331,  4722,  4129,  4130,  3253,
    4213,  4805,   345,  3453,  2387,  2045,  3398,  1849,  4449,  4718,
    2514,  4752,  1774,  4847,  3818,   387,   388,   498,    -1,  2853,
    2854,   946,  4187,  4041,    -1,  4703,    -1,    -1,    -1,    -1,
      -1,  4205,  4206,    -1,   125,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   319,    -1,  4786,  4724,    -1,    -1,    -1,
      -1,  4069,  4257,    -1,    -1,    -1,  4303,   148,  4263,    -1,
    2894,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4091,  3993,  3994,    -1,    -1,  4096,    -1,
      -1,    -1,   126,    -1,   626,   627,   628,    -1,    -1,    -1,
    4009,    -1,    -1,   465,   466,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4027,    -1,
    4357,    -1,    -1,    -1,    -1,    -1,   207,    -1,    -1,   600,
    4039,    -1,    -1,  4255,  4043,    -1,    -1,   403,    -1,    -1,
      -1,    -1,    -1,  4265,  4266,  4054,    -1,    -1,    -1,  4806,
     184,    -1,    -1,   187,    -1,   189,    -1,    -1,  4067,  4184,
      -1,  4169,   633,    -1,    -1,    -1,   637,   638,    -1,    -1,
      -1,    -1,   534,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     214,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4391,    -1,
     722,    -1,    -1,    -1,   665,  4104,   462,   463,    -1,    -1,
      -1,    -1,    -1,  4845,  4846,  4911,    -1,   569,    -1,    -1,
      -1,   292,    -1,    -1,    -1,   481,   578,    -1,    -1,    -1,
    4129,  4130,    -1,    -1,    -1,   587,    -1,    -1,    -1,    -1,
      -1,   497,    -1,  4875,    -1,    -1,  4145,   769,  4246,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4157,    -1,
    3692,    -1,    -1,    -1,  4163,    -1,    -1,  4452,    -1,    -1,
      -1,  4383,    -1,    -1,    -1,    -1,    -1,    -1,   630,  4277,
      -1,  4180,    -1,    -1,    -1,   309,   357,    -1,  4187,    -1,
      -1,    -1,    -1,    -1,    -1,   366,  4441,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4204,    -1,    -1,    -1,  3741,
      -1,    -1,    -1,    -1,  3746,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4507,    -1,    -1,    -1,    -1,    -1,   850,    -1,
    4523,  4329,    -1,    -1,  4479,   487,    -1,    -1,    -1,   595,
      -1,    -1,    -1,  4341,  4342,  4343,    -1,    -1,    -1,  4347,
     872,    -1,  4251,    -1,  4581,  4254,  4255,    -1,    -1,    -1,
    3174,    -1,    -1,    -1,  4362,    -1,  4265,  4266,  4652,    -1,
      -1,    -1,   833,    -1,    -1,    -1,    -1,   448,    -1,    -1,
      -1,    -1,  4567,    -1,   455,    -1,    -1,  4532,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4394,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   660,    -1,    -1,    -1,    -1,   480,
      -1,  4409,    -1,    -1,  4412,  4413,  4414,  4415,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   954,    -1,    -1,    -1,  3250,   508,    -1,  4338,
      -1,    -1,  4440,    -1,    -1,    -1,    -1,    -1,    -1,  3263,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     484,    -1,    -1,  3895,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4628,  4383,    -1,    -1,  4485,  4486,  4487,
    4488,  4489,  4637,    -1,  4492,  4493,  4494,  4495,  4496,  4497,
    4498,  4499,  4500,  4501,  4502,    -1,   858,  4505,    -1,  4507,
     862,  4509,   864,   584,    -1,    -1,    -1,    -1,    -1,    -1,
    4518,  4519,    -1,    -1,  4522,    -1,   678,    -1,   680,    -1,
      -1,   683,    -1,   789,    -1,    -1,   688,  4682,   690,    -1,
      -1,    -1,   694,    -1,    -1,    -1,  4544,    -1,  4546,    -1,
      -1,    -1,   704,    -1,   578,   707,    -1,    -1,   582,    -1,
      -1,  3375,   714,    -1,    -1,    -1,     1,    -1,    -1,     4,
      -1,    -1,    -1,    -1,    -1,    -1,   728,    -1,   730,   731,
      -1,    -1,    -1,    -1,    -1,    -1,   657,    -1,    -1,    -1,
     661,    -1,   744,    -1,    -1,    -1,    -1,    -1,   854,    -1,
     856,    -1,    -1,    -1,    -1,    -1,  4751,    -1,    -1,   865,
     866,   867,    -1,   869,   870,   680,    -1,    -1,    -1,    -1,
     685,  4814,    -1,    -1,    -1,  4623,    -1,  4625,    -1,    -1,
      -1,    -1,   697,    -1,  4779,  4780,    -1,   702,  4636,    -1,
    4785,    -1,    -1,  4788,    -1,    -1,    -1,  4792,  4793,    -1,
      -1,    -1,    87,    -1,    -1,  4848,   721,  4802,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   743,    -1,    -1,    -1,    -1,   701,    -1,    -1,
      -1,  4826,    -1,    -1,    -1,    -1,    -1,  4685,    -1,    -1,
      -1,    -1,    -1,  4125,    -1,    -1,    -1,    -1,  4843,    -1,
      -1,   853,   137,    -1,    -1,   140,   141,    -1,    -1,  4707,
      -1,  4856,   147,    -1,   970,  4860,  4861,   741,    -1,   154,
    4619,  3535,  3536,  3537,  3538,    -1,  4871,  4626,    -1,    -1,
      -1,    -1,  4631,   804,    -1,  4634,    -1,    -1,    -1,    -1,
     892,   893,   894,   895,    -1,    -1,    -1,   818,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4760,  4761,   788,  4763,   790,    -1,    -1,    -1,
      -1,   842,   924,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    4778,    -1,    -1,    -1,    -1,  4783,  4784,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   231,   232,   822,   951,
      -1,  4946,    -1,  4801,    -1,    -1,  4804,    -1,  4806,    -1,
     834,    -1,    -1,   884,    -1,    -1,    -1,    -1,    -1,   884,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   892,   893,   894,
     895,    -1,    -1,    -1,    -1,    -1,  4735,    -1,   903,  4738,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   872,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   934,    -1,    -1,    -1,    -1,  1020,    -1,
      -1,   936,    -1,    -1,    -1,   946,    -1,    -1,    -1,    -1,
      -1,  1033,   953,    -1,   955,    -1,    -1,     7,  1040,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     4,  3711,    -1,    -1,
      -1,    -1,    -1,   338,    -1,    -1,    -1,    -1,  1060,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    18,
      -1,   955,    -1,  1085,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   966,    -1,    -1,    -1,    66,  1012,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   390,    -1,    -1,    78,    -1,
    1112,    -1,    -1,  1028,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1130,    87,
      -1,    -1,    -1,    -1,    -1,  1137,  1138,    -1,    -1,    -1,
      -1,    -1,    -1,  1145,    -1,    -1,  1148,  1149,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   125,    -1,    -1,    -1,   444,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1085,   456,    -1,    -1,    -1,    -1,    -1,    -1,   148,   137,
    1095,    -1,   140,   141,    -1,    -1,    -1,  1102,   473,   147,
      -1,    -1,   477,    -1,   479,    -1,   154,    -1,    -1,  3863,
      -1,    -1,    -1,   488,   680,  3869,  3870,    -1,    -1,   685,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   697,    -1,    -1,    -1,    -1,   702,   166,    -1,    -1,
    1145,    -1,    -1,   172,   173,    -1,    -1,   207,    -1,    -1,
      -1,   526,    -1,    -1,    -1,   721,    -1,    -1,    -1,   188,
      -1,    -1,    -1,    -1,   539,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1273,  1274,    -1,    -1,    -1,    -1,    -1,  1280,  1281,
    1282,    -1,    -1,    -1,    -1,  1287,  1288,  1289,  1290,    -1,
      -1,  1293,    -1,    -1,    -1,    -1,    -1,    -1,   583,    -1,
      -1,  1303,    -1,  1305,  1306,    -1,    -1,    -1,    -1,    -1,
    1312,  1313,  1314,  1315,  1316,  1317,  1318,  1319,  1320,  1321,
    1322,  1323,   292,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1334,    -1,  1336,   620,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   631,  1349,    -1,    -1,
      -1,    -1,  1354,    -1,    -1,    -1,   641,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1280,  1281,  1282,    -1,    -1,
      -1,    -1,  1287,  1288,  1289,  1290,    -1,    -1,  1293,    -1,
      -1,    -1,  1297,    -1,    -1,    -1,  1388,   357,  1303,    -1,
    1305,  1306,    -1,    -1,    -1,  4059,   366,  1312,  1313,  1314,
    1315,  1316,  1317,  1318,  1319,  1320,  1321,  1322,  1323,    -1,
      -1,    -1,    -1,   698,    -1,    -1,   892,   893,   894,   895,
      -1,    -1,    -1,    -1,   363,   364,   365,    -1,    -1,    -1,
      -1,    -1,   390,    -1,  1349,    -1,   375,    -1,    -1,  1354,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   740,    -1,    -1,    -1,    -1,
     936,    -1,    -1,    -1,   403,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1388,    -1,    -1,    -1,    -1,   448,    -1,
      -1,    -1,    -1,    -1,  1399,   455,   444,    -1,    -1,    -1,
     775,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   456,    -1,
      -1,    -1,   787,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     480,    -1,    -1,    -1,    -1,   473,    -1,    -1,    -1,   477,
      -1,   479,    -1,    -1,    -1,   464,    -1,    -1,    -1,    -1,
     488,    -1,  4814,    -1,   819,    -1,  1012,    -1,   508,    -1,
      -1,    -1,   481,    -1,    -1,    -1,   485,   486,   487,    -1,
      -1,    -1,  1028,    -1,    -1,   494,    -1,    -1,   497,    -1,
      -1,    -1,    -1,  4845,  4846,    -1,  4848,    -1,    -1,    -1,
      -1,    -1,   857,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   539,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4875,    -1,   880,    -1,    -1,    -1,    -1,
      -1,    -1,   887,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1617,    -1,    -1,    -1,  1095,
      -1,    -1,    -1,    -1,    -1,   583,  1102,    -1,   913,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   922,    -1,    -1,
      -1,   580,    -1,    -1,    -1,   930,    -1,   932,    12,    -1,
     935,    -1,    -1,    -1,    18,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   620,    -1,    -1,    -1,  1668,    -1,    -1,  1145,
     955,    -1,    -1,   631,    -1,    -1,    -1,  1679,    -1,    -1,
      -1,    -1,    -1,   641,    -1,    -1,   971,   657,    -1,    -1,
      -1,   661,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1617,    -1,    -1,    -1,  1708,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1630,    -1,    -1,  1633,    -1,
      -1,   660,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1740,    -1,
     698,    -1,    61,    62,    63,    64,  1748,    -1,    -1,    -1,
      69,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    87,    88,
      -1,    -1,    -1,   743,    -1,  1690,   715,    -1,    -1,    -1,
      -1,    -1,   740,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  1716,   166,    -1,  1280,  1281,  1282,    -1,   172,   173,
      -1,  1287,  1288,  1289,    -1,    -1,    -1,   775,    -1,   138,
      -1,  1297,    -1,    -1,   188,    -1,    -1,  1303,    -1,   787,
    1306,    -1,    -1,  1748,   804,    -1,  1312,  1313,  1314,  1315,
    1316,  1317,  1318,  1319,  1320,  1321,  1322,  1323,   818,    -1,
     789,    -1,    -1,    -1,    -1,    -1,   175,    -1,   177,    -1,
      -1,   819,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   842,  1349,    -1,    -1,   815,   816,  1354,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  1895,    -1,    -1,    -1,    -1,    -1,   857,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1911,
      -1,    -1,    -1,    -1,   884,    -1,    -1,    -1,    12,    -1,
      -1,    -1,   880,  1399,    18,    -1,   290,    -1,   867,   887,
    1932,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    1942,    -1,    -1,    -1,    -1,    -1,   885,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   913,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   934,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   930,   912,   932,    -1,   946,   935,    -1,    -1,
      -1,   920,   301,   953,    -1,   955,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  1911,    -1,    -1,   363,
     364,   365,    -1,    97,    -1,    -1,    -1,    -1,    -1,   948,
      -1,   375,    -1,   971,    -1,    -1,   955,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  1942,    -1,    -1,
      -1,   970,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   403,
      -1,   360,    -1,    -1,    -1,    -1,  1961,    -1,    -1,    -1,
    1965,  2053,    -1,    -1,    -1,  2057,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   166,    -1,    -1,    -1,    -1,   171,   172,   173,
      -1,    -1,   401,    -1,    -1,    -1,    -1,    -1,    -1,    61,
      62,    63,    64,    -1,   188,    -1,    -1,    69,   462,   463,
     464,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   472,    -1,
     474,    -1,    -1,    -1,    -1,    87,    88,   481,    -1,    -1,
      -1,   485,   486,   487,    -1,    -1,    -1,    -1,    -1,    -1,
     494,    -1,    -1,   497,    -1,    -1,    -1,    -1,  2053,  2141,
      -1,  1617,  2144,    -1,  2146,  2147,  2148,    -1,    -1,    -1,
     514,  2066,    -1,    -1,  1630,    -1,    -1,  1633,    -1,    -1,
    2162,    -1,    -1,    -1,    -1,    -1,   138,    -1,    -1,    -1,
      -1,    -1,     1,    -1,    -1,    -1,   495,    -1,    -1,    -1,
      -1,    -1,    -1,    12,    -1,    -1,    -1,    -1,    -1,    18,
      -1,    -1,    -1,    22,    23,    24,    -1,    -1,    -1,    -1,
      -1,    30,    31,   175,    -1,   177,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1690,    -1,   580,    -1,    -1,    -1,
      -1,    -1,    -1,   542,    53,    54,    55,    56,    57,    58,
      59,    60,    -1,    -1,    -1,  2150,    -1,    -1,    -1,    -1,
    1716,    -1,    -1,    -1,   608,    -1,    -1,    -1,    -1,    -1,
      -1,    12,    -1,    -1,    -1,    -1,    -1,    18,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   363,
     364,   365,  1748,    -1,    -1,    -1,    -1,  2279,    -1,    -1,
    2282,   375,    -1,    -1,   603,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   660,    -1,    -1,   128,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   403,
      -1,    -1,    -1,    -1,  2316,    -1,    -1,    -1,    -1,  2321,
      -1,    -1,    -1,    -1,    -1,  2327,  2328,    -1,    -1,   301,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,    -1,    -1,
      -1,    -1,    -1,   172,   173,    -1,    -1,    -1,    -1,    -1,
      -1,   715,    -1,    -1,    -1,  2357,  2271,  2272,  2273,   188,
      -1,    -1,  2364,  2365,    -1,    -1,    -1,    -1,   462,   463,
     464,    -1,  2374,    -1,  2376,    -1,    -1,    -1,   472,    -1,
     474,    -1,    -1,    -1,    -1,    -1,    -1,   481,   360,  2391,
    2392,   485,   486,   487,  2396,   714,    -1,   716,   717,    -1,
     494,    -1,    -1,   497,    -1,   166,    -1,    -1,    -1,    -1,
      -1,   172,   173,  2328,    -1,    -1,    -1,   781,   737,    -1,
     514,   182,    -1,   742,    -1,   789,    -1,   188,    -1,   401,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  2359,    -1,  2361,    -1,    -1,    -1,
      -1,   815,   816,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   781,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   300,    -1,    -1,   793,    -1,  2391,  2392,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  1961,   580,    -1,    -1,  1965,
     319,    -1,    -1,   587,    -1,    -1,   860,    -1,    -1,    -1,
      -1,    -1,    -1,   867,    -1,    -1,    -1,   871,    -1,    -1,
      -1,    -1,    -1,    -1,   608,    -1,    -1,    -1,    -1,    -1,
      -1,   885,    -1,   495,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   363,   364,   365,    -1,    -1,    -1,
      -1,    -1,    -1,  2545,    -1,    -1,   375,    -1,   912,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   920,    -1,   387,   388,
      -1,    -1,  2564,  2565,    -1,    -1,   660,    -1,    -1,   541,
      -1,    -1,    -1,   892,   403,    -1,    -1,    -1,  2580,    -1,
      -1,    -1,    -1,    -1,   948,    -1,    -1,    -1,    -1,   683,
    2066,   955,    -1,    -1,    -1,    -1,    -1,  2599,    -1,  2601,
      -1,    -1,   363,   364,   365,   434,   970,    -1,    -1,  2611,
      -1,    -1,    -1,    -1,   375,    -1,    -1,    -1,    -1,    -1,
      -1,   715,    -1,  2625,    -1,    -1,  2628,    -1,    -1,    -1,
      -1,   603,    -1,   462,   463,   464,   465,   466,    -1,    -1,
      -1,    -1,   403,   472,    -1,   474,    -1,    -1,  2650,  2564,
      -1,    -1,   481,    -1,   166,  2657,   485,   486,   487,    -1,
     172,   173,    -1,    -1,    -1,   494,    -1,    -1,   497,    -1,
      -1,    -1,  2674,    -1,    -1,    -1,   188,    -1,    -1,    -1,
      -1,    -1,  2684,    -1,  2599,   514,  2601,   781,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   789,  2611,    -1,    -1,    -1,
      -1,   462,   463,   464,    -1,   534,    -1,    -1,    -1,  2624,
    2625,   472,    -1,   474,    -1,  2717,    -1,  2632,    -1,    -1,
     481,   815,   816,    -1,   485,   486,   487,    -1,    -1,    -1,
     559,    -1,    -1,   494,    -1,  2650,   497,    -1,    -1,    -1,
     569,  2743,   714,    -1,   716,   717,    -1,    -1,    -1,   578,
      -1,   580,    -1,   514,    -1,    -1,    -1,    -1,   587,    -1,
      -1,  2763,    -1,    -1,    -1,   737,   595,    -1,    -1,  2684,
     742,    -1,    -1,   867,    -1,    -1,  2691,    -1,  2693,   608,
      -1,    -1,    -1,    -1,    -1,  2787,    -1,    -1,    -1,    -1,
      -1,   885,    -1,    -1,    -1,  2271,  2272,  2273,    -1,    -1,
      -1,   630,   896,    -1,    -1,    -1,    -1,    -1,    -1,   781,
      -1,    -1,    -1,  2815,    -1,    -1,    -1,    -1,   912,   580,
    2822,   793,    -1,    -1,    -1,    -1,   920,  2742,  2743,    -1,
      -1,   660,  2834,    -1,    -1,    -1,   930,    -1,    -1,    -1,
      -1,    -1,  2757,    -1,  2759,    -1,    -1,   608,    -1,    -1,
      -1,   363,   364,   365,   948,    -1,    -1,    -1,    -1,  2861,
      -1,   955,    -1,   375,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   970,    -1,    -1,    -1,
      -1,    -1,    -1,  2359,    -1,    -1,   715,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   660,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  2822,    -1,    -1,
      -1,    -1,    -1,    43,  2829,  2391,  2392,    -1,    -1,  2834,
     892,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    61,    62,    63,    64,    -1,    -1,    -1,    -1,    69,
      -1,    -1,    -1,    -1,    -1,    -1,  2861,    -1,    -1,    -1,
     462,   463,   464,    -1,   715,    -1,    -1,    87,    88,    -1,
     789,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   481,
      -1,    -1,    -1,   485,   486,   487,    -1,    -1,    -1,    -1,
    2895,    -1,   494,    -1,    -1,    -1,   815,   816,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2920,    -1,   137,   138,    -1,
      -1,   141,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   854,    -1,   856,   789,   858,
      -1,   860,    -1,   862,    -1,   864,   865,   866,   867,    -1,
     869,   870,   871,    -1,    -1,   175,    -1,   177,    -1,    -1,
      61,    62,    63,    64,   815,   816,   885,    -1,    69,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   580,   830,
      -1,    -1,    -1,    -1,    -1,    -1,    87,    88,    -1,    -1,
      -1,    -1,    -1,   912,    -1,    -1,    -1,    -1,  2564,    -1,
      -1,   920,    -1,    -1,  3096,  3097,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  3105,    -1,    -1,   867,    -1,  3110,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   948,
      -1,    -1,    -1,  2599,   885,  2601,   955,   138,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   970,    -1,    -1,    -1,    -1,    -1,    -1,  2624,  2625,
      -1,   912,    -1,    -1,    -1,    -1,  2632,    -1,    -1,   920,
      -1,    -1,    -1,    -1,   175,    -1,   177,    -1,    -1,    -1,
      -1,   301,    -1,    -1,  2650,    -1,    -1,    -1,    -1,    -1,
      -1,  3096,  3097,    -1,    -1,    -1,    -1,   948,    -1,    -1,
    3192,    -1,    -1,    -1,   955,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   715,    -1,    -1,    -1,    -1,  2684,   970,
      -1,    -1,    -1,    -1,    -1,  2691,  3218,  2693,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3231,
     360,    -1,    -1,    -1,    -1,    -1,    -1,  3239,    12,    -1,
      -1,    -1,    -1,    -1,    18,    -1,    -1,    -1,    -1,    -1,
       0,     1,    -1,    -1,    -1,     5,    -1,    -1,    -1,    -1,
    3262,    11,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    19,
      -1,   401,    -1,    -1,    -1,    -1,    -1,  3192,    28,    -1,
      -1,  2757,    -1,  2759,    -1,    -1,    -1,    -1,    -1,    -1,
     301,    -1,    -1,  3208,    44,  3210,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   815,   816,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3231,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  3239,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  3251,    -1,    -1,    -1,
      -1,    -1,    -1,   473,    -1,    -1,  2822,    -1,    -1,   360,
      -1,   101,   102,  2829,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   495,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   885,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   132,    -1,    -1,   515,    -1,    -1,    -1,    -1,
     401,    -1,   166,    -1,    -1,    -1,  3311,    -1,   172,   173,
     912,    -1,   152,    -1,    -1,  3407,   156,    -1,   920,    -1,
      -1,    -1,   542,    -1,   188,    -1,    -1,    -1,    -1,  2895,
      -1,    -1,    -1,    -1,   174,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3434,    -1,    -1,    -1,   948,    -1,    -1,    -1,
      -1,    -1,    -1,   955,  2920,    -1,    -1,    -1,    -1,    -1,
      -1,   201,    -1,  3368,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   219,
      -1,    -1,    -1,   603,    -1,   225,    -1,   227,    -1,    -1,
      -1,   231,    -1,    -1,   495,    -1,   236,    -1,    -1,    -1,
      -1,    -1,  3407,    -1,    -1,    -1,    -1,   627,   628,    -1,
      -1,    -1,    -1,   253,    -1,   255,    -1,    -1,    -1,   259,
     260,   261,   262,   263,    -1,   265,   266,   267,   268,    -1,
     270,   271,    -1,   273,   274,    -1,   276,   277,   278,   279,
     280,    -1,   282,   283,   284,   285,   286,   287,    -1,    -1,
     290,    -1,  3544,    -1,    -1,    -1,    54,    -1,   298,    -1,
      -1,    -1,    -1,   303,    -1,    -1,   306,    -1,    -1,  3561,
      -1,   311,   312,    -1,    -1,    -1,    -1,   317,   318,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   714,    -1,   716,   717,    -1,   363,
     364,   365,   603,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   375,    -1,    -1,    -1,    -1,    -1,   737,    -1,    -1,
      -1,    -1,   742,    -1,    -1,    -1,    -1,    -1,   368,    -1,
    3096,  3097,    -1,    -1,    -1,    -1,    -1,   377,    -1,   403,
     380,    -1,    -1,    -1,    -1,   385,    -1,    -1,  3640,    -1,
    3555,    -1,  3557,    -1,  3646,    -1,  3648,    -1,    -1,    -1,
      -1,   781,    -1,    -1,    -1,    -1,    -1,    -1,   166,    -1,
      -1,   411,  3664,   793,   172,   173,    -1,    -1,    -1,   419,
      -1,   421,    -1,    -1,   424,    -1,    -1,   427,    -1,    -1,
     188,    -1,    -1,   433,    -1,    -1,    -1,    -1,   462,   463,
     464,    -1,    -1,   443,    -1,    -1,    -1,    -1,   472,    -1,
     474,    -1,    -1,   714,    -1,   716,   717,   481,    -1,    -1,
      -1,   485,   486,   487,    -1,    -1,  3192,    -1,    -1,    -1,
     494,    -1,    -1,   497,    -1,    -1,   737,    -1,    -1,    -1,
      -1,   742,  3208,    -1,  3210,    -1,    -1,    -1,    -1,    -1,
     514,    -1,    -1,    -1,  3746,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   509,
      -1,    -1,   892,    -1,    -1,    -1,   516,    -1,   518,    -1,
     781,   521,    -1,    -1,    -1,  3251,   906,    -1,    -1,    -1,
      -1,    -1,   793,    -1,    -1,    -1,    -1,   537,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   546,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   580,    -1,    -1,    -1,
      -1,    -1,    -1,   587,    -1,    -1,   566,   567,   568,    -1,
     570,   571,   572,   573,   954,    -1,    -1,    -1,    -1,    -1,
      -1,  3746,    -1,    -1,   608,  3311,    -1,    -1,    -1,    -1,
     590,   591,   592,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3852,    -1,    -1,    -1,    -1,   363,   364,   365,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   615,    -1,   375,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   892,    -1,    -1,    -1,    -1,   660,    -1,    -1,    -1,
      -1,    -1,  3368,  3895,    -1,   403,  3898,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   656,    -1,    -1,    -1,
      -1,    -1,   662,    -1,    -1,    -1,    -1,   667,    -1,    -1,
     670,   671,    -1,    -1,    -1,    -1,    -1,    -1,  3930,  3931,
      -1,  3407,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   689,
      -1,   715,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  3951,
      -1,    -1,    -1,    -1,   462,   463,   464,   707,    -1,    -1,
      -1,    -1,   712,    -1,   472,    -1,   474,    -1,    -1,   719,
      -1,    -1,    -1,   481,    -1,    -1,   726,   485,   486,   487,
      -1,    -1,    -1,    -1,    -1,    -1,   494,    -1,    -1,   497,
      -1,    -1,    -1,    -1,    -1,   745,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   781,    -1,    -1,
     760,    -1,    -1,    -1,    -1,   789,   766,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   782,    -1,   784,    -1,    -1,    -1,    -1,    -1,
      -1,   815,   816,    -1,    -1,    -1,    -1,    -1,   798,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   808,   809,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   817,    -1,    -1,
     820,    -1,   580,    -1,    -1,    -1,    -1,    -1,    -1,  3555,
      -1,  3557,    -1,    -1,    -1,   835,    -1,  4089,    -1,    -1,
    4092,    -1,    -1,   867,    -1,    -1,    -1,    -1,  4100,    -1,
     608,    -1,    -1,    -1,    -1,    -1,    -1,   857,    -1,    -1,
      -1,   885,    -1,    -1,    -1,    -1,    -1,    -1,   868,    -1,
      -1,    -1,   896,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   882,    -1,    -1,    -1,    -1,    -1,   912,     0,
       1,    -1,    -1,    -1,     5,   895,   920,    -1,    -1,    -1,
      11,   901,   660,    -1,    -1,    -1,    -1,    -1,    19,    -1,
      -1,  4076,    -1,    -1,    -1,    -1,    -1,    28,    -1,    -1,
      -1,    -1,    -1,    -1,   948,    -1,   926,    -1,    -1,    -1,
      -1,   955,    -1,    -1,    -1,  4100,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   970,   947,    -1,  4201,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   715,    -1,   959,
      -1,    -1,    -1,  4215,   964,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   972,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     101,   102,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
    3746,   132,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   789,    -1,    -1,    -1,  4287,    -1,    -1,    -1,    -1,
      -1,   152,    -1,    -1,  4296,   156,    -1,    -1,  4300,    -1,
    4215,    -1,    -1,    -1,    -1,    -1,    -1,   815,   816,    -1,
      -1,    -1,    -1,   174,    -1,    -1,    -1,    -1,   826,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4345,    -1,    -1,  4348,  4349,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   865,   219,   867,
      -1,   869,   870,    -1,   225,    -1,   227,    -1,  4370,  4371,
     231,    -1,    -1,    -1,    -1,   236,    -1,   885,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4389,    -1,    -1,
    4392,    -1,   253,    -1,    -1,  4397,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   912,    -1,    -1,    -1,    -1,  4411,
      -1,    -1,   920,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4426,    -1,    -1,    -1,    -1,   290,
      -1,    -1,    -1,    -1,    -1,  4437,    -1,    -1,    -1,  4441,
     948,    -1,    -1,    -1,    -1,   306,    -1,   955,    -1,    -1,
     311,    -1,    -1,    -1,    -1,    -1,   317,   318,    -1,    -1,
      -1,    -1,   970,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  4389,    -1,  4478,    -1,    -1,  4481,
    4482,  4483,  4484,    -1,    -1,    -1,    -1,    -1,    -1,  4491,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4504,    -1,    -1,    -1,    -1,   368,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   377,    -1,    -1,   380,
     166,  4523,    -1,    -1,   385,    -1,   172,   173,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4541,
      -1,    -1,   188,  4545,    -1,    -1,    -1,    -1,    -1,    -1,
     411,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   419,    -1,
     421,    -1,    -1,   424,    -1,    -1,   427,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   443,    -1,    -1,    -1,  4588,  4589,  4590,  4591,
    4592,  4593,  4594,  4595,  4596,  4597,  4598,  4599,  4600,  4601,
    4602,  4603,  4604,  4605,  4606,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4618,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4627,  4628,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  4637,    -1,    -1,    -1,    -1,
    4555,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   509,    -1,
      -1,    -1,    -1,    -1,    -1,   516,    -1,   518,    -1,    -1,
     521,    -1,  4664,    -1,     0,     1,    -1,    -1,    -1,     5,
      -1,    -1,    -1,    -1,  4676,    11,   537,    -1,    -1,    -1,
    4682,    -1,    -1,    19,    -1,    -1,  4688,  4689,    -1,    -1,
      -1,    -1,    28,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4703,    -1,    -1,    -1,    -1,    -1,     1,    -1,  4711,
    4712,    -1,     6,    -1,    -1,    -1,    10,   363,   364,   365,
      -1,    -1,  4724,  4725,    -1,    -1,    -1,    -1,    -1,   375,
      -1,   592,    -1,    -1,    -1,    29,    -1,    -1,    -1,    -1,
      -1,    -1,  4744,    -1,    -1,    -1,    -1,    -1,    42,  4751,
      -1,    -1,    -1,    -1,   615,    -1,  4758,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   101,   102,    -1,    -1,    -1,
      -1,    -1,    -1,  4775,    -1,    -1,    70,  4779,  4780,    -1,
      -1,    -1,    -1,  4785,    -1,  4787,  4788,    -1,    -1,    -1,
    4792,  4793,    -1,    -1,    -1,   656,   132,    -1,    -1,    -1,
      -1,   662,    -1,    -1,    -1,    -1,   667,    -1,    -1,   670,
     671,    -1,    -1,    -1,    -1,    -1,   152,    -1,   464,    -1,
     156,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   689,    -1,
      -1,  4833,    -1,    -1,    -1,   481,    -1,    -1,   174,   485,
     486,   487,   136,  4845,  4846,    -1,   707,    -1,   494,    -1,
      -1,   712,    -1,    -1,    12,    -1,    -1,    -1,   719,    -1,
      18,    -1,    -1,    -1,    -1,   726,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  4875,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   219,   745,    -1,    -1,    -1,    -1,   225,
      -1,   227,  4894,  4895,    -1,   231,    -1,    -1,    -1,   760,
     236,    -1,    -1,    -1,    -1,   766,    -1,   201,    -1,    -1,
    4912,    -1,    -1,    -1,    -1,    -1,    -1,   253,    -1,    -1,
    4922,  4923,    -1,   784,    -1,  4927,    -1,    -1,    -1,    -1,
    4845,  4846,  4934,    -1,   580,    -1,    -1,   798,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   808,   809,    -1,
      -1,    -1,    -1,    -1,   290,    -1,   817,    -1,    -1,   820,
    4875,    -1,    -1,   257,    -1,    -1,    -1,    -1,    -1,    -1,
     306,    -1,    -1,    -1,   835,   311,    -1,    -1,    -1,    -1,
      -1,   317,   318,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   857,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,    -1,
      -1,    -1,    -1,    -1,   172,   173,    -1,    -1,    -1,    -1,
      -1,   882,    -1,    -1,   182,    -1,    -1,    -1,    -1,    -1,
     188,    -1,   368,    -1,   895,    -1,    -1,   331,   332,    -1,
     901,   377,    -1,    -1,   380,    -1,    -1,    -1,    -1,   385,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   926,    -1,     1,    -1,   715,
      -1,    -1,    -1,    -1,    -1,   411,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   419,    -1,   421,    -1,    -1,   424,    -1,
      -1,   427,    -1,    -1,    -1,    -1,    -1,    31,   959,    -1,
      -1,    -1,    -1,   964,    -1,    -1,    -1,   443,    -1,    -1,
      -1,   972,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   417,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    67,    -1,    -1,    70,    71,    72,    73,
      74,    -1,    76,    77,    -1,    -1,    -1,    -1,   442,    -1,
      -1,    -1,    -1,    87,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   815,
     816,    -1,    -1,   509,    -1,    -1,    -1,    -1,    -1,   473,
     516,    -1,   518,    -1,    -1,   521,    -1,    -1,    -1,    -1,
      -1,    -1,   126,    -1,    -1,   489,    -1,    -1,    -1,    -1,
      -1,   537,    -1,    -1,    -1,   363,   364,   365,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   375,    -1,    -1,
     154,   155,    -1,   157,   158,   159,   160,   161,   162,   163,
     164,   165,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   885,
      -1,    -1,    -1,    -1,    -1,   403,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   592,    -1,    -1,    -1,
      -1,   555,    -1,    -1,    -1,    -1,   912,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   920,    -1,    -1,    -1,    -1,   615,
      -1,    -1,   216,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     224,    -1,    -1,    -1,    -1,    -1,    -1,   231,   232,    -1,
      -1,    -1,   948,   597,   462,   463,   464,    -1,    -1,   955,
      -1,   605,    -1,    -1,   472,    -1,   474,    -1,    -1,    -1,
     656,    -1,    -1,   481,    -1,    -1,   662,   485,   486,   487,
      -1,   667,    -1,    -1,   670,   671,   494,    -1,    -1,   497,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   641,    -1,    -1,
      -1,    -1,    -1,   689,    -1,    -1,   514,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4845,
    4846,   707,    -1,    -1,    -1,    -1,   712,    -1,    -1,   673,
      -1,    -1,    -1,   719,    -1,    -1,    -1,    -1,   322,   323,
     726,    -1,    -1,    -1,   688,    -1,    -1,    -1,    -1,  4875,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   745,
      -1,   705,    -1,   347,   348,   349,   350,   351,    -1,   353,
     354,   355,   580,    -1,   760,    -1,    -1,    -1,   362,    -1,
     766,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   376,    -1,    -1,   379,    -1,    -1,   784,    -1,
     608,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   392,    -1,
     754,    -1,   798,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     764,   765,   808,   809,    -1,   409,   770,    -1,    -1,    -1,
      -1,   817,   416,    -1,   820,    -1,    -1,    -1,    -1,    -1,
     784,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   432,   835,
     434,    -1,   660,    -1,    -1,    -1,   166,    -1,    -1,   803,
     444,    -1,   172,   173,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   857,   456,    -1,    -1,    -1,    -1,    -1,   188,    -1,
      -1,    -1,    -1,    -1,   468,    -1,    -1,    -1,     1,    -1,
      -1,    -1,    -1,    -1,     7,   479,   882,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   488,    -1,    -1,   715,    -1,   895,
      -1,    -1,    -1,   857,    -1,   901,    -1,   861,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   877,   878,    48,    -1,    -1,    -1,    -1,
     926,    -1,   526,    -1,    -1,    -1,    -1,    -1,    61,    62,
      63,    64,    -1,    66,    -1,    -1,    69,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    78,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   959,    87,    88,    -1,    -1,   964,    -1,
      -1,   789,    -1,    -1,    -1,    -1,   972,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   108,    -1,    -1,    -1,   583,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   815,   816,    -1,
      -1,    -1,   125,    -1,    -1,    -1,    -1,   130,    -1,    -1,
     604,    -1,   830,    -1,   137,   138,    -1,    -1,   141,    -1,
      -1,    -1,    -1,    -1,    -1,   148,   620,    -1,    -1,    -1,
      -1,   625,    -1,    -1,    -1,    -1,    -1,   631,    -1,    -1,
      -1,    -1,    -1,   363,   364,   365,    -1,   641,    -1,   867,
      -1,    -1,   175,    -1,   648,   375,     6,    -1,    -1,    -1,
      10,    -1,    -1,   186,    -1,    -1,    -1,   885,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    29,
      -1,    -1,    -1,   403,   207,    -1,    -1,   681,    -1,    -1,
      -1,    -1,    42,    -1,   912,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   920,    -1,   698,    -1,    -1,    -1,   231,   232,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     948,    -1,    -1,    -1,    -1,    -1,    -1,   955,    -1,    -1,
      -1,    -1,    -1,   737,   464,    -1,   740,    -1,    -1,    -1,
      -1,    -1,   970,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     754,   481,    -1,    -1,    -1,   485,   486,   487,    -1,   292,
      -1,    -1,    -1,    -1,   494,    -1,    -1,   497,   301,    -1,
      -1,   775,    -1,   777,   778,   779,   136,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   790,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   338,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   823,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   360,    -1,    -1,
      -1,    -1,    -1,   366,    -1,    -1,   369,    -1,   371,    -1,
      -1,   201,    -1,    -1,    -1,    -1,   379,    -1,    -1,    -1,
     580,    -1,    -1,   857,    -1,    -1,   389,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   401,    -1,
     403,    -1,    -1,    -1,    -1,    -1,   880,    -1,    -1,    -1,
      -1,    -1,    -1,   887,   888,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   897,   898,   899,    -1,   257,    -1,    -1,
      -1,   434,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   913,
      -1,   444,    -1,    -1,    -1,   448,    -1,    -1,   922,    -1,
      -1,    -1,    -1,   456,   928,    -1,   930,   460,   932,    -1,
     660,   935,    -1,    -1,    -1,   939,    -1,    -1,    -1,    -1,
     473,    -1,    -1,    -1,   477,    -1,    -1,   480,   481,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   495,    -1,   497,    -1,    -1,   971,    -1,     1,
      -1,   331,   332,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      12,    -1,    -1,    -1,    -1,   715,    18,    -1,    -1,    -1,
      22,    23,    24,   526,    -1,    -1,    -1,    -1,    30,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   541,    -1,
      -1,    -1,    -1,    -1,    -1,   548,    -1,    -1,    -1,    -1,
      -1,    53,    54,    55,    56,    57,    58,    59,    60,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   581,    -1,
     583,    -1,   585,    -1,    -1,    -1,    -1,   417,    -1,   789,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     603,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   442,    -1,    -1,   815,   816,   620,    -1,    -1,
      -1,    -1,    -1,    -1,   627,   628,   128,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   473,    -1,    -1,    -1,    -1,   651,    -1,
      -1,    -1,    -1,    -1,   657,    -1,    -1,   660,   661,   489,
      -1,    -1,    -1,    -1,   166,    -1,    -1,   867,    -1,    -1,
     172,   173,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     1,
      -1,    -1,    -1,    -1,    -1,   885,   188,    -1,    -1,    -1,
      12,    -1,    -1,    -1,    -1,    -1,    18,    -1,    -1,   702,
      22,    23,    24,    -1,    -1,    -1,    -1,    -1,    30,    -1,
      -1,   714,   912,   716,   717,    -1,    -1,    -1,    -1,    -1,
     920,   724,    -1,    -1,    -1,   555,    -1,    -1,    -1,    -1,
      -1,    53,    54,    55,    56,    57,    58,    59,    60,    -1,
     743,    -1,    -1,    -1,    -1,    -1,    -1,   750,   948,    -1,
      -1,    -1,    -1,    -1,    -1,   955,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   597,    -1,    -1,
     970,    -1,   775,    -1,    -1,   605,    -1,    -1,   781,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   789,    -1,    -1,    -1,
     793,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   300,    -1,
      -1,   804,    -1,    -1,    -1,    -1,   128,    -1,    -1,    -1,
      -1,   641,    -1,    -1,    -1,    -1,   318,   319,    -1,    -1,
      -1,    -1,    -1,    -1,   827,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   673,   166,    -1,    -1,    -1,    -1,   852,
     172,   173,    -1,    -1,   857,    -1,    -1,    -1,   688,    -1,
     863,   363,   364,   365,   867,    -1,   188,    -1,    -1,    -1,
      -1,    -1,    -1,   375,    -1,   705,    -1,   880,    -1,    -1,
      -1,   884,    -1,    -1,    -1,   387,   388,    -1,    -1,   892,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   403,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     913,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   921,   922,
      -1,    -1,    -1,    -1,   754,    -1,    -1,   930,    -1,    -1,
      -1,    -1,   434,    -1,   764,    -1,    -1,    -1,    -1,    -1,
     770,    -1,    -1,   946,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   955,    -1,   784,    -1,    -1,    -1,    -1,    -1,
     462,   463,   464,   465,   466,    -1,    -1,   970,    -1,    -1,
     472,    -1,   474,   803,    -1,    -1,    -1,    -1,   300,   481,
      -1,    -1,    -1,   485,   486,   487,    -1,    -1,    -1,    -1,
      -1,    -1,   494,    -1,    -1,   497,    -1,   319,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   514,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   857,    -1,    -1,
      -1,   861,   534,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   363,   364,   365,    -1,    -1,    -1,   877,   878,    -1,
      -1,    -1,    -1,   375,    -1,    -1,    -1,   559,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   387,   388,   569,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   578,    -1,   580,    -1,
      -1,   403,    -1,    -1,    -1,   587,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   595,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   608,    -1,    -1,    12,
      -1,    -1,   434,    -1,    -1,    18,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   630,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     462,   463,   464,   465,   466,    -1,    -1,    -1,    -1,    -1,
     472,    -1,   474,    -1,    -1,    -1,    -1,    -1,   660,   481,
      -1,    -1,    -1,   485,   486,   487,    -1,    -1,    -1,    -1,
      -1,    -1,   494,    -1,    -1,   497,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   514,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   534,   715,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   559,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   569,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   578,    -1,   580,    -1,
      -1,    -1,    -1,   166,    -1,   587,    -1,     1,    -1,   172,
     173,    -1,    -1,   595,    -1,    -1,    -1,    -1,    12,    -1,
      -1,    -1,    -1,    -1,    18,   188,   608,   789,    22,    23,
      24,    -1,    -1,    -1,    -1,    -1,    30,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   630,    -1,
      -1,    -1,    -1,   815,   816,    -1,    -1,    -1,    -1,    53,
      54,    55,    56,    57,    58,    59,    60,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   660,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   854,    -1,   856,    -1,   858,    -1,    -1,    -1,
     862,    -1,   864,   865,   866,   867,    -1,   869,   870,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   885,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   715,   128,    -1,    -1,    -1,    -1,   302,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     912,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   920,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   166,    -1,    -1,    -1,    -1,    -1,   172,   173,
      -1,    -1,    -1,    -1,    -1,    -1,   948,    -1,    -1,    -1,
      -1,    -1,    -1,   955,   188,    -1,    -1,    -1,    -1,    -1,
     363,   364,   365,    -1,    -1,    -1,    -1,   789,   970,    -1,
      -1,    -1,   375,    -1,    -1,   378,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   815,   816,    -1,    -1,    -1,    -1,    -1,
     403,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   854,    -1,   856,    -1,   858,    -1,    -1,    -1,
     862,    -1,   864,   865,   866,   867,    -1,   869,   870,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   462,
     463,   464,    -1,   885,    -1,    -1,   300,    -1,    -1,   472,
      -1,   474,    -1,    -1,    -1,    -1,    -1,    -1,   481,    -1,
      -1,    -1,   485,   486,   487,   319,    -1,    -1,    -1,    -1,
     912,   494,    -1,    -1,   497,    -1,    -1,    -1,   920,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   514,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   948,    -1,    -1,   363,
     364,   365,    -1,   955,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   375,    -1,    -1,    -1,    -1,    -1,    -1,   970,    -1,
      -1,    -1,    -1,   387,   388,   558,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   403,
      -1,    43,    -1,    -1,    -1,    -1,    -1,   580,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    61,
      62,    63,    64,    -1,    -1,    -1,    -1,    69,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   608,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    87,    88,    -1,    -1,    91,
      -1,    93,    -1,    -1,    -1,    -1,    -1,    -1,   462,   463,
     464,   465,   466,    -1,    -1,    -1,    -1,    -1,   472,    -1,
     474,    -1,    -1,    -1,   116,    -1,    -1,   481,    -1,    -1,
      -1,   485,   486,   487,    -1,    -1,    -1,   660,    -1,    -1,
     494,    -1,    -1,   497,    -1,   137,   138,    -1,    -1,   141,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     514,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     534,    -1,    -1,   175,    -1,   177,    -1,    -1,    -1,    -1,
     713,    -1,   715,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   559,     1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   569,    -1,    12,    -1,    -1,
      -1,    -1,    -1,    18,   578,    -1,   580,    22,    23,    24,
      -1,    -1,    -1,   587,    -1,    30,    -1,    -1,    -1,    -1,
      -1,   595,    -1,    -1,   598,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   608,    -1,    -1,    -1,    53,    54,
      55,    56,    57,    58,    59,    60,   789,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   630,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   815,   816,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   660,    -1,    -1,   301,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   128,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   867,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   715,   885,    -1,    -1,    -1,    -1,    -1,   360,    -1,
      -1,   166,    -1,    -1,    -1,    -1,    -1,   172,   173,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   912,
      -1,    -1,    -1,   188,    -1,    -1,    -1,   920,    -1,    -1,
     392,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   401,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   948,    -1,    -1,    -1,    -1,
      -1,   954,   955,    -1,    -1,   789,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   970,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   815,   816,    -1,    -1,    -1,    -1,   459,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   473,    -1,    -1,    -1,   477,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     854,    -1,   856,   495,   858,   300,    -1,    -1,   862,    -1,
     864,   865,   866,   867,    -1,   869,   870,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   319,    -1,    -1,    -1,    -1,    -1,
      -1,   885,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   541,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   912,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   920,    -1,   363,   364,
     365,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     375,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   387,   388,   948,    -1,    -1,    -1,    -1,    -1,
      -1,   955,    -1,    -1,    -1,    -1,    -1,    -1,   403,    -1,
      -1,   603,    -1,    -1,    -1,    -1,   970,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   626,   627,   628,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   462,   463,   464,
     465,   466,    -1,    -1,    -1,    -1,    -1,   472,    -1,   474,
      -1,    -1,    -1,    -1,    -1,    -1,   481,    -1,    -1,    -1,
     485,   486,   487,    -1,    -1,    -1,    -1,    -1,    -1,   494,
      -1,    -1,   497,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   514,
      -1,    -1,   714,    -1,   716,   717,    -1,    -1,    -1,    -1,
     722,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   534,
      -1,    -1,    -1,    -1,    -1,   737,    -1,    -1,    -1,    -1,
     742,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   559,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   569,    -1,    -1,   769,    -1,    -1,
      -1,    -1,    -1,   578,    -1,   580,    -1,    -1,    -1,   781,
      -1,    -1,   587,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     595,   793,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   608,    -1,     3,    -1,    -1,    -1,    -1,
      -1,     9,    -1,    -1,    -1,    13,    -1,    -1,    -1,    17,
      -1,    -1,    -1,    -1,    -1,   630,    -1,    -1,    -1,    -1,
      -1,    29,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   850,    -1,
      -1,    49,    50,    -1,    -1,   660,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     872,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      78,    79,    80,    81,    82,    83,    84,    85,    86,    -1,
     892,    -1,    -1,    91,    92,    93,    -1,    95,    96,    -1,
      -1,    -1,   100,    -1,    -1,   103,    -1,    -1,    -1,    -1,
     715,    -1,    -1,   111,   112,   113,   114,   115,    -1,   117,
     118,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   129,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   139,    -1,    -1,   142,   143,   144,   145,   146,    -1,
      -1,    -1,   954,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   180,    -1,   789,    -1,    -1,    -1,    -1,    -1,
      -1,   189,   190,   191,   192,   193,   194,   195,   196,    -1,
      -1,    -1,   200,    -1,   202,    -1,   204,    -1,    -1,    -1,
     815,   816,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   217,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   233,   234,    -1,    -1,   237,
     238,    -1,   240,   241,   242,   243,   244,    -1,    -1,   854,
      -1,   856,    -1,   858,    -1,    -1,    -1,   862,    -1,   864,
     865,   866,   867,    -1,   869,   870,   264,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     885,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     288,   289,    -1,    -1,    -1,   293,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   304,   912,    -1,    -1,
     308,    -1,    -1,    -1,    -1,   920,   314,   315,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   333,   334,   335,   336,   337,
      -1,    -1,   340,   948,    -1,    -1,   344,   345,   346,    -1,
     955,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   970,    -1,    -1,    -1,   367,
      -1,    -1,    -1,    -1,   372,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   381,   382,   383,   384,    -1,    -1,    -1,
      -1,    -1,   390,   391,    -1,   393,    -1,   395,   396,   397,
     398,   399,   400,    -1,   402,    -1,   404,   405,   406,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   425,   426,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   435,   436,   437,
     438,   439,   440,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   449,    -1,    -1,    -1,   453,    -1,    -1,    -1,   457,
      -1,   459,    -1,   461,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     478,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   491,   492,   493,    -1,    -1,   496,    -1,
      -1,    -1,   500,    -1,   502,   503,   504,   505,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   513,    -1,    -1,    -1,    -1,
      -1,   519,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   530,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     538,    -1,    -1,    -1,    -1,   543,   544,   545,    -1,   547,
      -1,   549,   550,    -1,   552,   553,   554,    -1,    -1,    -1,
      -1,   559,   560,    -1,   562,   563,   564,   565,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   574,   575,    -1,    -1,
     578,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   586,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   601,   602,    -1,    -1,    12,    -1,    -1,
      -1,   609,   610,    18,   612,    -1,    -1,    -1,   616,    -1,
      -1,    -1,    -1,    -1,    -1,   623,    -1,    -1,    -1,    -1,
      -1,   629,    -1,    -1,    -1,   633,    -1,   635,   636,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   649,    -1,    -1,   652,   653,    -1,    -1,    -1,    -1,
     658,    -1,    -1,    -1,    -1,   663,    -1,    -1,    -1,    -1,
      -1,   669,    -1,    -1,    -1,    -1,   674,    -1,   676,   677,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   685,   686,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     708,   709,   710,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   722,   723,    -1,   725,    -1,    -1,
      -1,   729,   730,   731,   732,   733,   734,    -1,    -1,    -1,
     738,   739,    -1,    -1,    -1,    -1,    -1,    -1,   746,   747,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   755,   756,   757,
     758,   166,    -1,    -1,    -1,   763,    -1,   172,   173,    -1,
     768,    -1,   177,   771,   772,   773,   774,    -1,    -1,    -1,
      -1,     1,    -1,   188,    -1,     5,    -1,    -1,   786,    -1,
      -1,    11,    -1,   791,   792,    -1,    -1,    -1,    -1,    19,
      -1,   799,   800,    -1,   802,    -1,    -1,   805,    28,    -1,
      -1,    -1,    -1,   811,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     828,   829,    -1,    -1,   832,    -1,    -1,    -1,    -1,   837,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   845,   846,   847,
      -1,    -1,    -1,   851,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   101,   102,   881,    -1,   883,    -1,    -1,    -1,   887,
      -1,    -1,    -1,    -1,    -1,   893,   301,    -1,    -1,    -1,
      -1,    -1,   900,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   132,   911,    -1,    -1,    -1,   915,   916,   917,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   152,   931,    -1,    -1,   156,    -1,   936,   937,
     938,    -1,   940,   941,   942,   943,   944,    -1,    -1,    -1,
      -1,   356,   950,   951,   174,    -1,    -1,    -1,   363,   364,
     365,    -1,    -1,    -1,    -1,   963,    -1,    -1,    -1,   967,
     375,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   403,   219,
      -1,    -1,    -1,    -1,    -1,   225,    -1,   227,    -1,    -1,
     415,   231,    -1,    -1,    -1,    -1,   236,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   253,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   462,   463,   464,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   472,    -1,   474,
     290,    -1,    -1,    -1,    -1,    -1,   481,    -1,    -1,    -1,
     485,   486,   487,    -1,    -1,    -1,   306,    -1,    -1,   494,
      -1,   311,   497,    -1,    -1,    -1,    -1,   317,   318,    -1,
      -1,    -1,    -1,    -1,    -1,   510,    -1,    -1,    -1,   514,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   368,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   377,    -1,    -1,
     380,    -1,    -1,    -1,    -1,   385,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   580,    -1,    -1,    -1,    -1,
      -1,    -1,   587,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   411,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   419,
      -1,   421,    -1,   608,   424,    -1,    -1,   427,    -1,    -1,
      18,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   443,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   660,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   509,
      98,    -1,    -1,    -1,    -1,    -1,   516,    -1,   518,    -1,
      -1,   521,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     715,    -1,    -1,    -1,    -1,    -1,    -1,   537,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,    -1,
      -1,    -1,    -1,    -1,   172,   173,    -1,    -1,    -1,    -1,
      -1,    -1,   592,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     188,    -1,    -1,    -1,   789,    -1,    -1,    -1,   793,    -1,
      -1,    -1,    -1,    -1,    -1,   615,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     815,   816,    -1,   818,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   656,    -1,    -1,    -1,
      -1,    -1,   662,    -1,    -1,    -1,    -1,   667,    -1,    -1,
     670,   671,    -1,    -1,    -1,    -1,    -1,    -1,   863,    -1,
      -1,    -1,   867,    -1,    -1,    -1,    -1,    -1,    -1,   689,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     885,    -1,    -1,    -1,    -1,    -1,    -1,   707,    -1,    -1,
      -1,    -1,   712,    -1,    -1,    -1,    -1,    -1,    -1,   719,
      -1,    -1,    -1,    -1,    -1,    -1,   726,   912,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   920,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   745,    -1,    -1,    -1,    -1,
      -1,     9,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    17,
     760,    -1,    -1,   948,    -1,    -1,   766,    -1,   953,   954,
     955,    -1,    -1,   361,    -1,   363,   364,   365,    -1,    -1,
      -1,    -1,    -1,    -1,   784,   970,    -1,   375,    -1,    -1,
      48,    49,    -1,    -1,    -1,    -1,    -1,    -1,   798,    -1,
      -1,    -1,    -1,    61,    62,    63,    64,    -1,   808,   809,
      -1,    69,    -1,    -1,    -1,   403,    -1,   817,    -1,    -1,
     820,    79,    80,    81,    82,    83,    84,    85,    86,    87,
      88,    -1,    -1,    -1,    -1,   835,    -1,    95,    -1,    -1,
      -1,    -1,   100,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     108,    -1,    -1,   111,   112,   113,   114,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   129,   130,    -1,   462,   463,   464,    -1,    -1,   137,
     138,   139,   882,   141,   142,   143,   144,    -1,   146,    -1,
      -1,    -1,    -1,   481,    -1,   895,    -1,   485,   486,   487,
      -1,   901,    -1,    -1,    -1,    -1,   494,    -1,    -1,   497,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   175,    -1,    -1,
      -1,    -1,   180,    -1,    -1,    -1,   926,    -1,   186,    -1,
      -1,   189,   190,   191,   192,   193,   194,   195,   196,    -1,
      -1,    -1,    -1,    -1,   202,    -1,   204,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   959,
      -1,    -1,    -1,    -1,   964,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   231,   232,   233,   234,    -1,    -1,   237,
     238,    -1,    -1,    -1,   242,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   580,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   264,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   289,    -1,    -1,    -1,   293,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   301,    -1,    -1,    -1,    -1,    -1,    -1,
     308,    -1,    -1,    -1,    -1,    -1,   314,   315,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   660,    -1,    -1,   333,   334,   335,   336,   337,
      -1,    -1,   340,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   360,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   369,    -1,   371,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   379,    -1,   381,   382,   383,   384,   715,    -1,    -1,
      -1,   389,   390,   391,    -1,   393,    -1,   395,   396,   397,
      -1,    -1,   400,   401,   402,   403,    -1,    -1,   406,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   425,   426,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   434,   435,   436,   437,
     438,   439,   440,    -1,    -1,    -1,   444,    -1,    -1,    -1,
      -1,   449,    -1,    -1,    -1,   453,    -1,    -1,   456,   457,
      -1,   789,   460,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   473,    -1,    -1,    -1,   477,
      -1,    -1,    -1,   481,    -1,    -1,    -1,   815,   816,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   495,   496,   497,
      -1,    -1,   500,    -1,   502,   503,   504,   505,    -1,    -1,
     838,    -1,    -1,    -1,    -1,   513,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   526,    -1,
      -1,    -1,   530,    -1,    -1,    -1,    -1,    -1,    -1,   867,
     538,    -1,    -1,   541,    -1,    -1,    -1,    -1,    -1,    -1,
     548,    -1,    -1,    -1,    -1,    -1,    -1,   885,    -1,    -1,
      -1,   559,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   902,    -1,   574,   575,    -1,    -1,
      -1,    -1,    -1,    -1,   912,   583,    -1,   585,    -1,    -1,
      -1,    -1,   920,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   603,    -1,   935,    -1,    -1,
      -1,   609,    -1,    -1,   612,    -1,    -1,    -1,    -1,    -1,
     948,    -1,   620,    -1,    -1,   623,   954,   955,    -1,   627,
     628,   629,    -1,    -1,    -1,   633,    -1,   635,   636,    -1,
      -1,    -1,   970,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   649,    -1,   651,   652,   653,    -1,    -1,    -1,    -1,
     658,    -1,   660,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   674,    -1,   676,   677,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   685,   686,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   702,    -1,    -1,    -1,    -1,    -1,
     708,   709,   710,    -1,    -1,    -1,   714,    -1,   716,   717,
      -1,    -1,    -1,    -1,    -1,    -1,   724,    -1,    -1,    -1,
      -1,   729,   730,   731,   732,    -1,   734,    -1,    -1,    -1,
     738,   739,    -1,    -1,    -1,    -1,    -1,    -1,   746,   747,
      -1,    -1,   750,    -1,    -1,    -1,    -1,   755,   756,   757,
      -1,    -1,    -1,    -1,    -1,   763,    -1,    -1,    -1,    -1,
     768,    -1,    -1,    -1,    -1,    -1,    -1,   775,    -1,    -1,
      -1,    -1,    -1,   781,    -1,    -1,    -1,    -1,   786,    -1,
      -1,   789,    -1,    -1,    -1,   793,    -1,    -1,    -1,    -1,
      -1,   799,   800,    -1,    -1,    -1,    -1,   805,    -1,    -1,
      -1,    -1,    -1,   811,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   827,
     828,   829,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   837,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   845,    -1,    -1,
      -1,    -1,    -1,   851,   852,    -1,    -1,    -1,    -1,   857,
      -1,    -1,    -1,    -1,    -1,   863,    -1,    -1,    -1,   867,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   880,   881,    -1,    -1,    -1,    -1,    -1,   887,
      -1,    -1,    -1,    -1,   892,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,     9,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    17,    -1,    -1,   913,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   921,   922,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   930,   931,    -1,    -1,    -1,    -1,    -1,    -1,
     938,    -1,   940,    48,    49,   943,    -1,    -1,    -1,    -1,
      -1,    -1,   950,    -1,    -1,    -1,    61,    62,    63,    64,
      -1,    -1,    -1,    -1,    69,   963,    -1,    -1,    -1,   967,
      -1,    -1,   970,    -1,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    -1,    -1,    -1,    -1,   100,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   108,    -1,    -1,   111,   112,   113,   114,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   129,   130,    -1,    -1,    -1,    -1,
      -1,    -1,   137,   138,   139,    -1,   141,   142,   143,   144,
      -1,   146,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     175,    -1,    -1,    -1,    -1,   180,    -1,    -1,    -1,    -1,
      -1,   186,    -1,    -1,   189,   190,   191,   192,   193,   194,
     195,   196,    -1,    -1,    -1,    -1,    -1,   202,    -1,   204,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   231,   232,   233,   234,
      -1,    -1,   237,   238,    -1,    -1,    -1,   242,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   264,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   289,    -1,    -1,    -1,   293,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   301,    -1,    -1,    -1,
      -1,    -1,    -1,   308,    -1,    -1,    -1,    -1,    -1,   314,
     315,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   333,   334,
     335,   336,   337,    -1,    -1,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   360,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   369,    -1,   371,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   379,    -1,   381,   382,   383,   384,
      -1,    -1,    -1,    -1,   389,   390,   391,    -1,   393,    -1,
     395,   396,   397,    -1,    -1,   400,   401,   402,   403,    -1,
      -1,   406,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     425,   426,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   434,
     435,   436,   437,   438,   439,   440,    -1,    -1,    -1,   444,
      -1,    -1,    -1,    -1,   449,    -1,    -1,    -1,   453,    -1,
      -1,   456,   457,    -1,    -1,   460,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   473,    -1,
      -1,    -1,   477,    -1,    -1,    -1,   481,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     495,   496,   497,    -1,    -1,   500,    -1,   502,   503,   504,
     505,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   513,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   526,    -1,    -1,    -1,   530,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   538,    -1,    -1,   541,    -1,    -1,    -1,
      -1,    -1,    -1,   548,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   559,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   574,
     575,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   583,    -1,
     585,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   603,    -1,
      -1,    -1,    -1,    -1,   609,    -1,    -1,   612,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   620,    -1,    -1,   623,    -1,
      -1,    -1,   627,   628,   629,    -1,    -1,    -1,   633,    -1,
     635,   636,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   649,    -1,   651,   652,   653,    -1,
      -1,    -1,    -1,   658,    -1,   660,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   674,
      -1,   676,   677,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     685,   686,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   702,    -1,    -1,
      -1,    -1,    -1,   708,   709,   710,    -1,    -1,    -1,   714,
      -1,   716,   717,    -1,    -1,    -1,     5,    -1,    -1,   724,
      -1,    -1,    11,    -1,   729,   730,   731,   732,    -1,   734,
      19,    -1,    -1,   738,   739,    -1,    -1,    -1,    -1,    28,
      -1,   746,   747,    -1,    -1,   750,    -1,    -1,    -1,    -1,
     755,   756,   757,    -1,    -1,    -1,    -1,    -1,   763,    -1,
      -1,    -1,    -1,   768,    -1,    -1,    -1,    -1,    -1,    -1,
     775,    -1,    -1,    -1,    -1,    -1,   781,    -1,    -1,    -1,
      -1,   786,    -1,    -1,   789,    -1,    -1,    -1,   793,    -1,
      -1,    -1,    -1,    -1,   799,   800,    -1,    -1,    -1,    -1,
     805,    -1,    -1,    -1,    -1,    -1,   811,    -1,    -1,    -1,
      -1,    -1,   101,   102,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   827,   828,   829,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   837,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     845,    -1,    -1,   132,    -1,    -1,   851,   852,    -1,    -1,
      -1,    -1,   857,    -1,    -1,    -1,    -1,    -1,   863,    -1,
      -1,    -1,   867,   152,    -1,    -1,    -1,   156,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   880,   881,    -1,    -1,    -1,
      -1,    -1,   887,    -1,    -1,   174,    -1,   892,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   913,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   921,   922,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   930,   931,    -1,    -1,    -1,
     219,    -1,    -1,   938,    -1,   940,    -1,    -1,   943,    -1,
      -1,    -1,   231,    -1,    -1,   950,    -1,   236,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   963,    -1,
      -1,    -1,   967,    -1,    -1,   970,   255,    -1,    -1,    -1,
      -1,   260,   261,   262,   263,    -1,   265,   266,   267,   268,
      -1,   270,    -1,   272,   273,   274,    -1,   276,   277,   278,
     279,   280,    -1,   282,   283,   284,   285,   286,   287,    -1,
      -1,   290,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   306,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   317,   318,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   368,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   377,    -1,
      -1,   380,    -1,    -1,    -1,    -1,   385,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    70,    71,    72,    73,    74,    -1,
      76,    77,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   411,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     419,    -1,   421,    -1,    -1,   424,    -1,    -1,   427,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   155,
      -1,   157,   158,   159,   160,   161,   162,   163,   164,   165,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     509,    -1,    -1,    -1,    -1,    -1,    -1,   516,    -1,   518,
      -1,    -1,   521,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   537,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       9,    -1,    -1,    -1,    -1,   231,   232,    -1,    17,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      49,    -1,    -1,   592,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   615,    -1,    -1,    -1,
      79,    80,    81,    82,    83,    84,    85,    86,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    95,    -1,    -1,    -1,
      -1,   100,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   111,   112,   113,   114,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   667,    -1,
     129,   347,   348,   349,   350,   351,    -1,   353,   354,   355,
     139,     1,    -1,   142,   143,   144,    -1,   146,    -1,    -1,
     689,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     376,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   712,    -1,    -1,   392,    -1,    -1,    -1,
     719,   180,    -1,    -1,    -1,    -1,    -1,   726,    -1,    -1,
     189,   190,   191,   192,   193,   194,   195,   196,    -1,    -1,
     416,    -1,    -1,   202,    -1,   204,   745,    -1,    -1,    -1,
      70,    71,    72,    73,    74,    -1,    76,    77,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   766,    -1,    -1,
      -1,    -1,    -1,    -1,   233,   234,    -1,    -1,   237,   238,
      -1,    -1,    -1,   242,    -1,   784,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   798,
      -1,    -1,    -1,    -1,    -1,   264,    -1,    -1,    -1,   808,
     809,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   817,    -1,
      -1,   820,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     289,    -1,    -1,    -1,   293,   155,   835,   157,   158,   159,
     160,   161,   162,   163,   164,   165,    -1,    -1,    -1,   308,
     526,    -1,    -1,    -1,    -1,   314,   315,    -1,   857,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   333,   334,   335,   336,   337,    -1,
      -1,   340,    -1,   882,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   895,    -1,    -1,    -1,
      -1,    -1,   901,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   231,   232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   381,   382,   383,   384,    -1,    -1,   604,    -1,
      -1,   390,   391,    -1,   393,    -1,   395,   396,   397,    -1,
      -1,   400,    -1,   402,    -1,    -1,    -1,   406,    -1,   625,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     959,    -1,    -1,    -1,    -1,   964,   425,   426,    -1,    -1,
      -1,    -1,   648,    -1,    -1,    -1,   435,   436,   437,   438,
     439,   440,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     449,    -1,    -1,    -1,   453,    -1,    -1,    -1,   457,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   347,   348,   349,
     350,   351,    -1,   353,   354,   355,    -1,   496,    -1,    -1,
      -1,   500,    -1,   502,   503,   504,   505,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   513,    -1,   376,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   530,   392,    -1,    -1,    -1,    -1,    -1,    -1,   538,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   416,    -1,    -1,    -1,
     559,   777,   778,   779,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   574,   575,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     609,    -1,    -1,   612,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   623,    -1,    -1,    -1,    -1,    -1,
     629,    -1,    -1,    -1,   633,    -1,   635,   636,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     649,    -1,    -1,   652,   653,    -1,    -1,    -1,    -1,   658,
      -1,    -1,    -1,    -1,    -1,    -1,   526,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   674,    -1,   676,   677,    -1,
      -1,   897,   898,   899,    -1,    -1,   685,   686,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   922,    -1,    -1,   708,
     709,   710,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   581,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     729,   730,   731,   732,    -1,   734,    -1,    -1,    -1,   738,
     739,    -1,    -1,    -1,   604,    -1,    -1,   746,   747,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   755,   756,   757,    -1,
      -1,    -1,    -1,    -1,   763,   625,    -1,    -1,    -1,   768,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   786,   648,    -1,
      -1,    -1,    -1,    -1,     9,    -1,    -1,    -1,    -1,    -1,
     799,   800,    17,    -1,    -1,    -1,   805,    -1,    -1,    -1,
      -1,    -1,   811,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   828,
     829,    -1,    -1,    -1,    49,    -1,    -1,    -1,   837,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   845,    -1,    -1,    -1,
      -1,    -1,   851,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    79,    80,    81,    82,    83,    84,
      85,    86,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      95,    -1,   881,    -1,    -1,   100,    -1,    -1,   887,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   111,   112,   113,   114,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   129,    -1,    -1,   777,   778,   779,
      -1,    -1,    -1,    -1,   139,    -1,    -1,   142,   143,   144,
      -1,   146,   931,    -1,    -1,    -1,    -1,    -1,    -1,   938,
      -1,   940,    -1,    -1,   943,    -1,    -1,    -1,    -1,    -1,
      -1,   950,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   963,   180,    -1,    -1,   967,    -1,
      -1,    -1,    -1,    -1,   189,   190,   191,   192,   193,   194,
     195,   196,    -1,    -1,    -1,    -1,    -1,   202,    -1,   204,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   233,   234,
      -1,    -1,   237,   238,    -1,    -1,    -1,   242,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   897,   898,   899,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   264,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   922,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   289,    -1,    -1,    -1,   293,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   308,    -1,   955,    -1,    -1,    -1,   314,
     315,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   333,   334,
     335,   336,   337,    -1,    -1,   340,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   381,   382,   383,   384,
      -1,    -1,    -1,    -1,    -1,   390,   391,    -1,   393,    -1,
     395,   396,   397,    -1,    -1,   400,    -1,   402,    -1,    -1,
      -1,   406,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     425,   426,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     435,   436,   437,   438,   439,   440,    -1,    -1,    -1,    -1,
      -1,    -1,    18,    -1,   449,    -1,    -1,    -1,   453,   454,
      -1,    -1,   457,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   496,    -1,    -1,    -1,   500,    -1,   502,   503,   504,
     505,    -1,    -1,    12,    -1,    -1,    -1,    -1,   513,    18,
      -1,    -1,    -1,    22,    23,    24,    -1,    -1,    -1,    -1,
      -1,    30,    98,    -1,    -1,   530,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   538,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    53,    54,    55,    56,    57,    58,
      59,    60,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   574,
     575,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     166,    -1,    -1,    -1,    -1,    -1,   172,   173,    -1,    -1,
      -1,    -1,    -1,    -1,   609,    -1,    -1,   612,    -1,    -1,
      -1,    -1,   188,    -1,    -1,    -1,    -1,    -1,   623,   128,
      -1,    -1,    -1,    -1,   629,    -1,    -1,    -1,   633,    -1,
     635,   636,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   649,    -1,    -1,   652,   653,    -1,
      -1,    -1,    -1,   658,    -1,    -1,    -1,   166,    -1,    -1,
      -1,    -1,    -1,   172,   173,    -1,    -1,    -1,    -1,   674,
      -1,   676,   677,    -1,    -1,    -1,    -1,    -1,    -1,   188,
     685,   686,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   708,   709,   710,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   729,   730,   731,   732,    -1,   734,
      -1,    -1,    -1,   738,   739,    -1,    -1,    -1,    -1,    -1,
      -1,   746,   747,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     755,   756,   757,    -1,    -1,    -1,    -1,    -1,   763,    -1,
      -1,    -1,    -1,   768,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   786,    -1,    -1,    -1,   361,    -1,   363,   364,   365,
      -1,   300,    -1,    -1,   799,   800,    -1,    -1,    -1,   375,
     805,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     319,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   828,   829,    -1,    -1,   403,    -1,    -1,
      -1,    -1,   837,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     845,    -1,    -1,    -1,    -1,    -1,   851,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   363,   364,   365,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   375,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   881,    -1,   387,   388,
      -1,    -1,   887,    -1,    -1,    -1,   462,   463,   464,    -1,
      -1,    -1,    -1,    -1,   403,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   481,    -1,    -1,    -1,   485,
     486,   487,    -1,    -1,    -1,    -1,    -1,    -1,   494,    -1,
      -1,   497,    -1,    -1,    -1,   434,   931,    -1,    -1,    -1,
      -1,    -1,    -1,   938,    -1,   940,    -1,    -1,   943,    -1,
      -1,    -1,    -1,    -1,    -1,   950,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   462,   463,   464,   465,   466,   963,    -1,
      -1,    -1,   967,   472,    -1,   474,    -1,    -1,    -1,    -1,
      -1,    -1,   481,    -1,    -1,    -1,   485,   486,   487,    -1,
      12,    -1,    -1,    -1,    -1,   494,    18,    -1,   497,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   580,   514,    -1,    -1,    -1,    -1,
      -1,    43,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   534,    -1,    -1,    -1,    61,
      62,    63,    64,    -1,    -1,    -1,    -1,    69,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    12,    -1,    -1,
     559,    -1,    -1,    18,    -1,    87,    88,    22,    23,    24,
     569,    -1,    -1,    -1,    -1,    30,    -1,    -1,    -1,   578,
      -1,   580,    -1,    -1,    -1,    -1,    -1,    -1,   587,    -1,
      -1,    -1,    -1,    -1,   660,    -1,   595,    -1,    53,    54,
      55,    56,    57,    58,    59,    60,    -1,    -1,    -1,   608,
      -1,    -1,    -1,    -1,    -1,   137,   138,    -1,    -1,   141,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   630,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   166,    -1,    -1,    -1,    -1,   715,
     172,   173,    -1,   175,    -1,   177,    -1,    -1,    -1,    -1,
      -1,   660,    -1,    -1,    -1,    -1,   188,    -1,    -1,    -1,
      -1,    -1,    -1,   128,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   166,    -1,    -1,    -1,    -1,   715,   172,   173,    -1,
      -1,    -1,    -1,   789,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   188,    -1,    -1,    -1,    -1,    -1,    12,
      -1,    -1,    -1,    -1,    -1,    18,    -1,    -1,    -1,   815,
     816,    -1,    -1,    -1,    -1,    -1,    -1,    30,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   838,    -1,    -1,    -1,    -1,    -1,    -1,   301,
      53,    54,    55,    56,    57,    58,    59,    60,    -1,    -1,
     789,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   867,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   815,   816,    -1,   885,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   902,    -1,   360,    -1,
      -1,   363,   364,   365,    -1,   300,   912,    -1,    -1,    -1,
      -1,    -1,    -1,   375,   920,   854,    -1,   856,    -1,   858,
      -1,    -1,    -1,   862,   319,   864,   865,   866,   867,   935,
     869,   870,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   401,
      -1,   403,   948,    -1,    -1,    -1,   885,    -1,   954,   955,
      -1,    -1,    -1,   166,    -1,    -1,    -1,    -1,    -1,   172,
     173,    -1,    -1,    -1,   970,    -1,    -1,    -1,   363,   364,
     365,    -1,    -1,   912,    -1,   188,    -1,    -1,    -1,    -1,
     375,   920,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   387,   388,    -1,    -1,    -1,    -1,    -1,    -1,
     462,   463,   464,    -1,    -1,    -1,    -1,    -1,   403,   948,
     472,   473,   474,    -1,    -1,    -1,   955,    -1,    -1,   481,
      -1,    -1,    -1,   485,   486,   487,    -1,    -1,    -1,    -1,
      -1,   970,   494,   495,    -1,   497,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    12,
      -1,    -1,   514,   515,    -1,    18,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   462,   463,   464,
     465,   466,    -1,    -1,    -1,    -1,    -1,   472,    -1,   474,
     542,    -1,    -1,    -1,    -1,    -1,   481,    -1,    -1,    -1,
     485,   486,   487,    -1,    -1,    -1,    -1,    -1,    -1,   494,
      -1,    -1,   497,    -1,    -1,    -1,   319,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   580,   514,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   534,
      -1,   603,    -1,    -1,    -1,    -1,   608,    -1,    -1,    -1,
     363,   364,   365,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   375,    -1,   559,   627,   628,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   569,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   578,    -1,   580,    -1,    -1,    -1,    -1,
     403,    -1,   587,    -1,    -1,    -1,    -1,    -1,   660,    -1,
     595,    -1,    -1,   166,    -1,    -1,    -1,    -1,    -1,   172,
     173,    -1,    -1,   608,    -1,    -1,    12,    -1,    -1,   182,
      -1,   434,    18,    -1,    -1,   188,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   630,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   462,
     463,   464,   714,   715,   716,   717,    -1,    -1,    -1,   472,
      -1,   474,    -1,    -1,    -1,   660,    -1,    -1,   481,    -1,
      -1,    -1,   485,   486,   487,   737,    -1,    -1,    -1,    -1,
     742,   494,    -1,    -1,   497,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   514,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   781,
     715,    -1,    -1,    -1,    -1,    -1,    -1,   789,    -1,    -1,
      -1,   793,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   559,    -1,    -1,    -1,
      -1,    -1,    -1,   815,   816,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   580,    -1,    -1,
     166,    -1,    -1,    -1,    -1,    -1,   172,   173,    -1,    -1,
      -1,    -1,   595,    -1,    -1,    12,    -1,    -1,    -1,    -1,
      -1,    18,   188,    -1,   789,   608,    -1,    -1,    -1,    -1,
     363,   364,   365,    -1,    -1,   867,    -1,    -1,    -1,    -1,
      -1,    -1,   375,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     815,   816,    -1,   885,    -1,    -1,    -1,    -1,    -1,    -1,
     892,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     403,    -1,    -1,    -1,   906,    -1,    -1,   660,    -1,    -1,
     912,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   920,   854,
      -1,   856,    -1,   858,    -1,    -1,    -1,   862,    -1,   864,
     865,   866,   867,    -1,   869,   870,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   948,    -1,    -1,    -1,
     885,    -1,   954,   955,    -1,    -1,    -1,    -1,    -1,   462,
     463,   464,   715,    -1,    -1,    -1,    -1,    -1,   970,   472,
      -1,   474,    -1,    -1,    -1,    -1,    -1,   912,   481,    -1,
      -1,    -1,   485,   486,   487,   920,    -1,    12,    -1,    -1,
      -1,   494,    -1,    18,   497,    -1,    -1,    -1,    -1,   166,
      -1,    -1,    -1,    -1,    -1,   172,   173,    -1,    -1,    -1,
      -1,   514,    -1,   948,    -1,    -1,    -1,    -1,    -1,    -1,
     955,   188,    -1,    -1,    -1,    -1,    -1,   363,   364,   365,
      -1,    -1,    -1,    -1,    -1,   970,   789,    -1,    -1,   375,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    12,    -1,    -1,    -1,    -1,
      -1,    18,   815,   816,    -1,    -1,    -1,   403,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   580,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   854,    -1,   856,    -1,   608,    -1,    -1,    -1,    -1,
      -1,    -1,   865,   866,   867,    -1,   869,   870,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   462,   463,   464,    -1,
      -1,    -1,   885,    -1,    -1,    -1,   472,    -1,   474,    -1,
      -1,   166,    -1,    -1,    -1,   481,    -1,   172,   173,   485,
     486,   487,    -1,    -1,    -1,    -1,    -1,   660,   494,   912,
      -1,   497,    -1,   188,    -1,    -1,    -1,   920,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   514,    -1,
      -1,    12,    -1,    -1,    -1,    -1,    -1,    18,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   948,   363,   364,   365,    -1,
      -1,    -1,   955,    -1,    -1,    -1,    -1,    -1,   375,   166,
      -1,    -1,   715,    -1,    -1,   172,   173,   970,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   188,    -1,    -1,    -1,    -1,   403,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   580,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   608,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   789,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   462,   463,   464,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   472,    -1,   474,    -1,    -1,
      -1,    -1,   815,   816,   481,    -1,    -1,    -1,   485,   486,
     487,    -1,    -1,    12,   660,    -1,    -1,   494,    -1,    18,
     497,    -1,    -1,    -1,    -1,   166,    -1,    -1,   363,   364,
     365,   172,   173,    -1,   369,    -1,    -1,   514,    -1,    -1,
     375,    -1,    -1,    -1,    -1,    -1,    -1,   188,    -1,    -1,
      -1,    -1,    -1,    -1,   867,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   403,   715,
      -1,    -1,   885,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   363,   364,   365,   912,
      -1,    -1,    -1,   580,    -1,    -1,    -1,   920,   375,    -1,
     587,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   462,   463,   464,
      -1,   608,    -1,    -1,    -1,   948,   403,   472,    -1,   474,
      -1,    -1,   955,   789,    -1,    -1,   481,    -1,    -1,    -1,
     485,   486,   487,    -1,    12,    -1,    -1,   970,    -1,   494,
      18,    -1,   497,    -1,    -1,    -1,    -1,   166,    -1,   815,
     816,    -1,    -1,   172,   173,    -1,    -1,    -1,    -1,   514,
      -1,    -1,    -1,   660,    -1,    -1,    -1,    -1,    -1,   188,
      -1,    -1,    -1,    -1,    -1,   462,   463,   464,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   472,   852,   474,    -1,    -1,
      -1,    -1,    -1,    -1,   481,    -1,    -1,    -1,   485,   486,
     487,   867,   363,   364,   365,    -1,    -1,   494,    -1,    -1,
     497,    -1,    -1,    -1,   375,    -1,    -1,    -1,   715,   885,
      -1,    -1,    -1,    -1,    -1,   580,    -1,   514,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   403,    -1,    -1,    -1,   912,    -1,    -1,    -1,
      -1,    -1,    -1,   608,   920,    -1,    -1,    -1,    -1,    -1,
      12,    -1,    -1,    -1,    -1,    -1,    18,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   948,    -1,    -1,    -1,    -1,    -1,   166,   955,
      -1,    -1,   789,   580,   172,   173,    -1,    -1,    -1,    -1,
      -1,   462,   463,   464,   970,   660,    -1,    -1,    -1,    -1,
     188,   472,    -1,   474,    -1,    -1,    -1,    -1,   815,   816,
     481,   608,    -1,    -1,   485,   486,   487,    -1,    -1,    -1,
      -1,    -1,    -1,   494,    -1,    -1,   497,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   363,   364,   365,    -1,    -1,    -1,
      -1,    -1,    -1,   514,    -1,    -1,   375,    -1,    -1,    -1,
     715,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     867,    -1,    -1,   660,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   403,    -1,    -1,    -1,   885,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    12,    -1,    -1,    -1,    -1,    -1,    18,    -1,
      -1,    -1,    -1,    -1,   166,   912,    -1,    -1,    -1,   580,
     172,   173,    -1,   920,    -1,    -1,    -1,    -1,   715,    -1,
      -1,    -1,    -1,    -1,   789,    -1,   188,    -1,    -1,    -1,
      -1,    -1,    -1,   462,   463,   464,    -1,   608,    -1,    -1,
      -1,   948,    -1,   472,    -1,   474,    -1,    -1,   955,    -1,
     815,   816,   481,    -1,    -1,    -1,   485,   486,   487,    -1,
      -1,    -1,    -1,   970,    -1,   494,    -1,    -1,   497,    -1,
      -1,    -1,    -1,    -1,    -1,   363,   364,   365,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   514,    -1,   375,    -1,   660,
      -1,    -1,   789,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   867,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   403,    -1,    -1,   815,   816,
     885,    -1,    -1,    -1,    -1,    -1,    -1,   556,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   715,    -1,   166,   912,    -1,    -1,
      -1,   580,   172,   173,    -1,   920,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   188,    -1,
     867,    -1,   869,    -1,   462,   463,   464,    -1,    -1,   608,
      -1,    -1,    -1,   948,   472,    -1,   474,    -1,   885,    -1,
     955,    -1,    -1,   481,    -1,    -1,    -1,   485,   486,   487,
      -1,   363,   364,   365,    -1,   970,   494,    -1,    -1,   497,
     781,    -1,    -1,   375,    -1,   912,    -1,    -1,   789,    -1,
      -1,    -1,    -1,   920,    -1,    -1,   514,    -1,    -1,    -1,
      -1,   660,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   403,    -1,    -1,   815,   816,    -1,    -1,    -1,    -1,
      -1,   948,    -1,    -1,    -1,    -1,    -1,    -1,   955,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   970,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   715,    -1,    -1,    -1,
      -1,    -1,   580,    -1,    -1,    -1,   867,    -1,    -1,    -1,
     462,   463,   464,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     472,    -1,   474,    -1,   885,    -1,    -1,    -1,    -1,   481,
     608,    -1,    -1,   485,   486,   487,    -1,    -1,    -1,    -1,
      -1,    -1,   494,    -1,    -1,   497,    -1,    -1,    -1,    -1,
      -1,   912,    -1,   363,   364,   365,    -1,    -1,    -1,   920,
      -1,    -1,   514,    -1,    -1,   375,    -1,    -1,    -1,    -1,
     789,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
       3,    -1,   660,    -1,    -1,    -1,    -1,   948,    -1,    -1,
      13,    -1,    -1,   403,   955,    -1,   815,   816,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    29,    -1,    -1,   970,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    50,   580,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   715,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   867,    -1,
      -1,    -1,   462,   463,   464,    78,   608,    -1,    -1,    -1,
      -1,    -1,   472,    -1,   474,    -1,   885,    -1,    91,    92,
      93,   481,    -1,    96,    -1,   485,   486,   487,    -1,    -1,
     103,    -1,    -1,    -1,   494,    -1,    -1,   497,    -1,    -1,
      -1,    -1,   115,   912,   117,   118,    -1,    -1,    -1,    -1,
      -1,   920,    -1,    -1,   514,    -1,    -1,    -1,   660,    -1,
      -1,   789,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   145,    -1,    -1,    -1,    -1,    -1,    -1,   948,
      -1,    -1,    -1,    -1,    -1,    -1,   955,   815,   816,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   970,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   715,    -1,    -1,    -1,    -1,    -1,    -1,
     580,    -1,    -1,    -1,    -1,    -1,   854,   200,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   867,
      -1,    -1,    -1,    -1,   217,    -1,    -1,    -1,   608,    -1,
      -1,    -1,    31,    -1,    -1,    -1,    -1,   885,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   240,   241,    -1,
     243,   244,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   912,    -1,    -1,   789,    67,    -1,
      -1,    -1,   920,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     660,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    87,    -1,
      -1,    -1,    -1,   815,   816,   288,    -1,    -1,    -1,    -1,
     948,    -1,    -1,    -1,    -1,    -1,    -1,   955,    -1,    -1,
      -1,   304,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   970,    -1,    -1,    -1,    -1,   126,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   715,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   867,    -1,    -1,    -1,    -1,
      -1,   344,   345,   346,    -1,   154,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   885,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   367,    -1,    -1,    -1,    -1,   372,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     912,    -1,    -1,    31,    -1,    -1,    -1,    -1,   920,    -1,
      -1,    -1,    -1,    -1,    -1,   398,   399,    -1,    -1,   789,
      -1,   404,   405,    -1,    -1,    -1,    -1,   216,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   224,   948,    -1,    -1,    67,
      -1,    -1,    -1,   955,    -1,   815,   816,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   970,    87,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   459,    -1,   461,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   478,    -1,   867,   126,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   491,   492,
     493,    -1,    -1,    -1,    -1,   885,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   154,    -1,    -1,    -1,
      -1,    -1,    -1,   322,   323,    -1,   519,    -1,    -1,    -1,
      -1,    -1,   912,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     920,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     543,   544,   545,    -1,   547,    -1,   549,   550,    -1,   552,
     553,   554,    -1,   362,    -1,    -1,    -1,   560,   948,   562,
     563,   564,   565,    -1,    -1,   955,    -1,    -1,   216,    -1,
     379,    -1,    -1,    -1,    -1,   578,   224,    54,    -1,    -1,
     970,    -1,    -1,   586,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   601,   602,
     409,    -1,    -1,    -1,    -1,    -1,    -1,   610,    -1,    -1,
      -1,    -1,    -1,   616,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   432,    -1,   434,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   444,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   456,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   468,
     663,    -1,    -1,    -1,    -1,    -1,   669,    -1,    -1,    -1,
     479,    -1,    -1,    -1,   322,   323,    -1,    -1,    -1,   488,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,
      -1,    -1,    -1,    -1,    -1,   172,   173,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   188,    -1,    -1,   362,    -1,    -1,    -1,    -1,   722,
     723,    -1,   725,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     733,   379,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    54,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   758,    -1,    -1,    -1,    -1,
      -1,   409,    -1,    -1,    -1,    -1,    -1,    -1,   771,   772,
     773,   774,    -1,    -1,   583,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   432,    -1,   434,    -1,   791,   792,
      -1,    -1,    -1,    -1,    -1,    -1,   444,    -1,    -1,   802,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   456,    -1,
      -1,   620,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     468,    -1,   631,    -1,    -1,    -1,    -1,    -1,    -1,   832,
      -1,   479,   641,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     488,    -1,    -1,   846,   847,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   166,    -1,    -1,
      -1,    -1,    -1,   172,   173,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   681,    -1,    -1,    -1,    -1,    -1,    -1,   188,
     883,    -1,    -1,    -1,    -1,    -1,   363,   364,   365,   698,
     893,    -1,    -1,    54,    -1,    -1,    -1,   900,   375,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   911,    -1,
      -1,    -1,   915,   916,   917,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   403,    -1,   737,    -1,
      -1,   740,    -1,   936,   937,   583,    -1,    -1,   941,   942,
      -1,   944,    -1,    -1,    -1,   754,    -1,    -1,   951,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   775,    -1,    -1,    -1,
      -1,    -1,   620,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   790,    -1,   631,    -1,   462,   463,   464,    -1,    -1,
      -1,    -1,    -1,   641,    -1,   472,    -1,   474,    -1,    -1,
      -1,    -1,    -1,    -1,   481,   166,    -1,    -1,   485,   486,
     487,   172,   173,    -1,   823,    -1,    -1,   494,    -1,    -1,
     497,    -1,    -1,    -1,    -1,    -1,    -1,   188,    -1,    -1,
      -1,    -1,    -1,   681,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   857,    -1,
     698,    -1,    -1,    -1,   363,   364,   365,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   375,    -1,    -1,    -1,
      -1,   880,    -1,    -1,    -1,    -1,    -1,    -1,   887,   888,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   737,
      -1,    -1,   740,    54,   403,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   580,   913,    -1,   754,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   928,
      -1,   930,    -1,   932,    -1,    -1,   935,   775,    -1,    -1,
     939,   608,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   790,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   462,   463,   464,    -1,    -1,    -1,    -1,
      -1,    -1,   971,   472,    -1,   474,    -1,    -1,    -1,    -1,
      -1,    -1,   481,    -1,    -1,   823,   485,   486,   487,    -1,
      -1,    -1,    -1,   660,    -1,   494,    -1,    -1,   497,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   363,   364,   365,   166,    -1,    -1,    -1,   857,
      -1,   172,   173,    -1,   375,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   188,    -1,    -1,
      -1,    -1,   880,    -1,    -1,    -1,    -1,    -1,   715,   887,
     888,    -1,   403,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      54,    -1,    -1,    -1,    -1,   913,    -1,    -1,    -1,    -1,
      -1,   580,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     928,    -1,   930,    -1,   932,    -1,    -1,   935,    -1,    -1,
      -1,   939,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   608,
      -1,   462,   463,   464,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   472,   789,   474,    -1,    -1,    -1,    -1,    -1,    -1,
     481,    -1,    -1,   971,   485,   486,   487,    -1,    -1,    -1,
      -1,    -1,    -1,   494,    -1,    -1,   497,    -1,   815,   816,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   660,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   166,    -1,    -1,    -1,    -1,   854,   172,   173,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   865,    -1,
     867,    -1,   869,   870,   188,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   363,   364,   365,    -1,   715,    -1,   885,    -1,
      -1,    -1,    -1,    -1,   375,    -1,    -1,    -1,    -1,   580,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   912,    -1,    -1,    -1,    -1,
      43,    -1,   403,   920,    -1,    48,    -1,   608,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    61,    62,
      63,    64,    -1,    -1,    -1,    68,    69,    -1,    -1,    -1,
      -1,   948,    -1,    -1,    -1,    -1,    -1,    -1,   955,    -1,
     789,    -1,    -1,    -1,    -1,    88,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   970,    -1,    -1,    -1,    -1,    -1,   660,
      -1,   462,   463,   464,    -1,    -1,   815,   816,    -1,    -1,
      -1,   472,    -1,   474,    -1,    -1,    -1,    -1,    -1,    -1,
     481,    -1,    -1,    -1,   485,   486,   487,    -1,    -1,    -1,
      -1,    -1,    -1,   494,   137,   138,   497,    -1,   141,    -1,
      -1,    -1,    -1,    -1,    -1,   854,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   715,    -1,   865,    -1,   867,    -1,
     869,   870,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   363,
     364,   365,   175,    -1,   177,    -1,   885,    -1,    -1,    -1,
      -1,   375,    -1,    -1,    -1,    -1,   189,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   912,    -1,    -1,    -1,    -1,    -1,   403,
      -1,   920,    -1,   216,    -1,    -1,    -1,    -1,    -1,   580,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   789,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    48,    -1,   948,
      -1,    -1,    -1,    -1,    -1,    -1,   955,   608,    -1,    -1,
      61,    62,    63,    64,   815,   816,    -1,    -1,    69,    -1,
      -1,   970,    -1,    -1,    -1,   826,    -1,    -1,   462,   463,
     464,    -1,    -1,    -1,    -1,    -1,    87,    88,   472,    -1,
     474,    -1,    -1,    -1,    -1,    -1,    -1,   481,    -1,    -1,
      -1,   485,   486,   487,    -1,    -1,    -1,   108,    -1,   660,
     494,    -1,    -1,   497,   865,    -1,   867,    -1,   869,   870,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   130,
      -1,    -1,    -1,    -1,   885,    -1,   137,   138,    -1,    -1,
     141,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   912,    -1,    -1,   715,    -1,    -1,   360,    -1,   920,
      -1,    -1,    -1,    -1,   175,    -1,    -1,   370,   371,    -1,
      -1,    -1,    -1,    -1,    -1,   186,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   580,   948,    -1,    -1,
      -1,    -1,    -1,    -1,   955,    -1,    -1,    -1,   401,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   970,
      -1,    -1,    -1,    -1,   608,    -1,    -1,    -1,    -1,    -1,
     231,   232,    -1,    -1,    -1,    -1,    -1,    -1,   789,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   446,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   815,   816,    -1,   460,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   660,    -1,    -1,    -1,
     473,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   492,
     301,    -1,   495,   854,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    48,    -1,   865,    -1,   867,    -1,   869,   870,
      -1,    -1,   515,    -1,    -1,    61,    62,    63,    64,    -1,
      -1,   715,    -1,    69,   885,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   541,    -1,
      -1,    -1,    88,    -1,    -1,   548,    -1,    -1,    -1,   360,
      -1,   912,    -1,    -1,    -1,    -1,    -1,    -1,   369,   920,
     371,    -1,    -1,    -1,    -1,    -1,   166,    -1,   379,    -1,
      -1,    -1,   172,   173,    -1,    -1,    -1,    -1,   389,    -1,
      -1,    -1,   585,    -1,    -1,    -1,    -1,   948,   188,    -1,
     401,    -1,   138,    -1,   955,   789,    -1,    48,    -1,    -1,
     603,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   970,
      61,    62,    63,    64,    -1,    -1,    -1,    -1,    69,    -1,
      -1,   815,   816,   434,   627,   628,    -1,    -1,    -1,   175,
      -1,   177,    -1,   444,    -1,    -1,    87,    88,    -1,    -1,
      -1,    -1,    -1,   189,    -1,   456,    -1,    -1,   651,   460,
      -1,   654,    -1,    -1,    -1,    -1,    -1,   108,    -1,    -1,
      -1,    -1,   473,    -1,    -1,    -1,   477,    -1,    -1,    -1,
     216,   865,    -1,   867,    -1,   869,   870,    -1,    -1,   130,
      -1,    -1,    -1,    -1,   495,    -1,   137,   138,    -1,    -1,
     141,   885,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   702,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   714,    -1,   716,   717,   526,    -1,    -1,   912,    -1,
      -1,   724,    -1,    -1,   175,    -1,   920,    -1,    -1,    -1,
     541,    -1,    -1,    -1,   737,   186,    -1,   548,    -1,   742,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   750,    -1,    -1,
      -1,    -1,    -1,    -1,   948,    -1,    -1,    -1,    -1,    -1,
      -1,   955,    -1,   363,   364,   365,    -1,    -1,    -1,    -1,
      -1,    -1,   583,    -1,   585,   375,   970,    -1,   781,    -1,
     231,   232,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     793,    -1,   603,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   403,    -1,    -1,    -1,    -1,    -1,   620,
      -1,    -1,    -1,    -1,   360,    -1,   627,   628,    -1,    -1,
      -1,    -1,    -1,    -1,   827,   371,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     651,    -1,    -1,    -1,   847,   848,    -1,    -1,    -1,    -1,
     301,    -1,    -1,    -1,    -1,   401,    -1,    -1,    -1,    -1,
      -1,    -1,   462,   463,   464,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   472,    -1,   474,    -1,    -1,    -1,    -1,    -1,
      -1,   481,    -1,    -1,    -1,   485,   486,   487,    -1,   892,
      -1,   702,    -1,    -1,   494,    -1,    -1,   497,    -1,    -1,
      -1,   904,    -1,   714,    -1,   716,   717,    -1,   911,   360,
      -1,    -1,    -1,   724,   460,    -1,    -1,    -1,   369,    -1,
     371,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   379,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   389,   750,
      -1,    -1,    -1,    -1,    -1,    -1,   492,    -1,    -1,   495,
     401,   954,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   775,    -1,    -1,    -1,    -1,    -1,
     781,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     580,    -1,   793,   434,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   444,    -1,   541,    -1,    -1,    -1,    -1,
      -1,    -1,   548,    -1,    -1,   456,    -1,    -1,   608,   460,
      -1,    -1,    -1,   166,    -1,    -1,   827,    -1,    -1,   172,
     173,    -1,   473,    -1,    -1,    -1,   477,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   188,    -1,    -1,    -1,   585,
      -1,   852,    -1,    -1,   495,    -1,   857,    -1,    -1,    -1,
      -1,    -1,   863,    -1,    -1,    -1,    -1,   603,    -1,    -1,
     660,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   880,
      -1,    -1,    -1,    -1,    -1,   526,    -1,   166,    -1,    -1,
      -1,   892,    -1,   172,   173,    -1,    -1,    -1,    -1,    -1,
     541,    -1,    -1,    -1,    -1,    -1,    -1,   548,    -1,   188,
      -1,    -1,   913,    -1,    -1,   651,   706,    -1,   654,    -1,
     921,   922,    -1,    -1,    -1,   715,    -1,    -1,    -1,   930,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   583,    -1,   585,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   603,    -1,    -1,    -1,   702,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   714,   620,
     716,   717,    -1,    -1,    -1,    -1,   627,   628,   724,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   789,
      -1,   737,    -1,    -1,    -1,    -1,   742,    -1,    -1,    -1,
     651,    -1,    -1,    -1,   750,    -1,    -1,    -1,    -1,    -1,
     363,   364,   365,    -1,    -1,   815,   816,    -1,    -1,    -1,
      -1,    -1,   375,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   781,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   793,    -1,    -1,
     403,   702,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   714,    -1,   716,   717,   867,    -1,    -1,
      -1,    -1,    -1,   724,   363,   364,   365,    -1,    -1,    -1,
      -1,   827,    -1,    -1,    -1,   885,   375,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   750,
      -1,    -1,   848,    -1,    -1,    -1,   906,    -1,    -1,   462,
     463,   464,   912,    -1,   403,    -1,    -1,    -1,    -1,   472,
     920,   474,    -1,    -1,   775,    -1,    -1,    -1,   481,    -1,
     781,    -1,   485,   486,   487,    -1,    -1,    -1,    -1,    -1,
      -1,   494,   793,    -1,   497,    -1,   892,    -1,   948,    -1,
      -1,    -1,    -1,    -1,    -1,   955,    -1,    -1,   904,    -1,
      -1,    -1,    -1,    -1,    -1,   911,    -1,    -1,    -1,    -1,
     970,    -1,    -1,   462,   463,   464,   827,    -1,    -1,    -1,
      -1,    -1,    -1,   472,    -1,   474,    -1,    -1,    -1,    -1,
      -1,    -1,   481,    -1,    -1,    -1,   485,   486,   487,    -1,
      -1,   852,    -1,    -1,    -1,   494,   857,    -1,   497,    -1,
      -1,    -1,   863,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   580,    -1,   880,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   892,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   608,    -1,    -1,    -1,    -1,
      -1,    -1,   913,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     921,   922,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   930,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   580,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   660,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   608,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   715,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   660,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   715,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   789,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   815,   816,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     789,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   867,    -1,   869,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   815,   816,    -1,    -1,
      -1,    -1,   885,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   912,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   920,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   867,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   948,   885,    -1,    -1,    -1,
      -1,    -1,   955,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,   970,    -1,    -1,
      -1,    -1,    -1,   912,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   920,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,   948,
      -1,    -1,    -1,    -1,    -1,    -1,   955,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   970
};

  /* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_int16 yystos[] =
{
       0,   975,   976,     0,   977,   978,   979,   982,   983,   175,
    1000,  1001,   594,  1010,  1028,   239,   408,   410,   980,   981,
     984,   985,   992,   995,  1013,  1014,  1016,   857,   294,  1037,
    1038,  1039,  1040,   857,  2328,   981,   374,   646,  1017,  1018,
    1019,  1020,  1015,    38,  1029,  1030,  1011,   168,  1041,  1042,
    1043,  1044,   239,  1002,   857,  1010,   857,  1010,   239,   434,
    2370,   216,  1032,   201,  1216,  1218,  1219,  1220,   423,  1128,
    1129,  1130,    21,   126,   184,   187,   189,   214,   309,   484,
     578,   582,   701,   741,   788,   790,   822,   834,   872,   955,
     966,  1045,  1046,  1047,  1049,  1053,  1067,  1073,  1074,  1075,
    1076,  1077,  1079,  1084,  1102,  1103,  1108,  1111,  1114,  1115,
    1118,  1120,  1121,  1122,  1123,  1124,  1125,  1126,   749,  2328,
     216,  1003,   481,   647,  1021,   275,   986,   987,   988,  1021,
     269,   990,  2328,   529,   793,   796,   797,  1031,   727,   291,
    1033,  1012,   861,  1221,  1222,   239,   749,   329,  1131,     1,
     955,  2229,  2229,   803,   775,  2398,  2370,  2370,  2370,  2229,
     775,  2328,  2328,  2370,  2328,  2328,   124,   169,  2352,  1127,
    2229,  1047,     1,   857,  1076,  1078,   414,  1101,  2328,  1004,
      39,  1023,   989,   988,  1023,   991,   515,  2382,  2370,   429,
    1035,   641,  1558,  1559,  1563,   749,  1223,  2328,  2328,  2328,
    1132,  1085,   359,  1100,  2361,  2370,  2370,   955,  2222,  2281,
     149,  2222,  2370,  2370,  1054,  1068,  2222,  1050,   955,  1109,
    1110,  1287,  1100,  2370,  1116,   481,   585,   588,  1080,  1082,
    1083,  1989,  2287,  2370,    41,   248,   529,   794,   795,   955,
    1160,   749,   481,  1024,  2370,   481,   647,  1022,   857,  2370,
    1022,  2370,   133,   806,   859,  1034,   728,  2328,  1560,  1593,
    1594,  2328,   326,   744,  1217,  1224,  1225,  1227,   442,   754,
    1133,  1193,  1194,  1086,  1089,  1090,  2361,  2370,    25,   526,
    2222,   481,   414,   584,  2426,   481,   880,   123,   506,   645,
     753,   955,  1055,  1056,  1057,  1058,  1059,  1062,  1063,  1065,
    2351,  2393,   373,   645,  1069,  1070,  1071,  1051,  1065,  1110,
    2370,   955,  1104,  1105,  1106,  2231,  2229,    18,   403,   481,
     497,   660,   789,   867,   955,   970,  1117,  2292,  2293,  2294,
    2295,  1989,   434,   803,  2389,  2370,   184,  2229,   857,   857,
     153,   322,   655,   680,   863,  1025,  1026,  1027,  2328,   655,
    2328,    52,   531,   532,   533,   650,   873,   874,   886,  2321,
    2370,   239,     0,     1,     5,    11,    19,    28,   101,   102,
     132,   152,   156,   174,   219,   225,   227,   231,   236,   253,
     290,   306,   311,   317,   318,   368,   377,   380,   385,   411,
     419,   421,   424,   427,   443,   509,   516,   518,   521,   537,
     592,   615,   656,   662,   667,   670,   671,   689,   707,   712,
     719,   726,   745,   760,   766,   784,   798,   808,   809,   817,
     820,   835,   857,   882,   895,   901,   926,   959,   964,   972,
    1595,  1597,  1628,  1633,  1638,  1643,  1669,  1674,  1682,  1686,
    1687,  1691,  1694,  1699,  1704,  1757,  1761,  1763,  1764,  1768,
    1785,  1794,  1798,  1801,  1804,  1808,  1810,  1818,  1828,  1831,
    1834,  1840,  1861,  1862,  1871,  1875,  1877,  1881,  1884,  1888,
    1902,  1916,  1918,  1922,  1937,  1938,  1948,  1951,  1952,  1956,
    1962,  1963,  1964,  1976,  1986,  2003,  2013,  2021,  2022,  2028,
    2039,  2043,  2046,  2049,  2052,  2055,  2066,  2086,  2094,  2095,
    2123,  2339,  1595,   957,  1276,  1277,  1279,  1280,     1,   955,
    2210,  2328,  1134,    32,   520,   704,   737,  1195,  1196,  1197,
    1198,  1200,  1201,  1202,  1207,  1087,  1088,    25,   526,   481,
    1112,  1113,  2291,  2292,   954,  1119,  2413,  2281,   762,   781,
    2401,  2370,   857,  1057,   857,   955,  1056,   127,   136,  1060,
    2353,    18,   375,   955,  1072,   955,     1,   857,  1071,  1052,
    2413,  2293,  1105,    33,   434,  2231,  2372,  2295,   853,  2389,
     434,  2229,  2229,  1081,  1082,     5,  1005,  1006,  1027,  2328,
    2393,   153,  2328,   531,   532,   650,   886,  1036,    99,   514,
     606,   801,   806,   859,   952,  1650,  1651,     5,    11,    19,
      28,   101,   102,   132,   152,   156,   174,   219,   231,   236,
     255,   260,   261,   262,   263,   265,   266,   267,   268,   270,
     272,   273,   274,   276,   277,   278,   279,   280,   282,   283,
     284,   285,   286,   287,   290,   306,   317,   318,   368,   377,
     380,   385,   411,   419,   421,   424,   427,   509,   516,   518,
     521,   537,   592,   615,   667,   689,   712,   719,   726,   745,
     766,   784,   798,   808,   809,   817,   820,   835,   857,   882,
     895,   901,   959,   964,  1812,  2325,  2326,  2327,  1598,  1629,
    1634,  1639,  1644,  1670,  1675,  1683,  1688,  1695,  1692,  1700,
    1705,  1758,  1762,  1769,  1841,  1786,  1795,  1799,  1802,  1805,
    1809,  1811,  1819,  1829,  1832,  1835,  1876,  1878,  1882,  1885,
    1596,  1889,  1903,  1917,  1919,  1923,  1939,  1949,  1953,  1957,
    1977,  1987,  2004,  2014,  2029,  2040,  2044,  2047,  2050,  2053,
    2056,  2067,  2087,  1765,  1766,   377,   613,    18,  1965,   302,
     481,   660,   735,   789,   842,   970,  2026,  2027,  2172,  2271,
    2272,  2281,   377,   613,  1580,   749,   154,  1255,  1256,   252,
     767,   780,  1281,  1282,  1284,  1295,  1297,  1300,  2310,   641,
     857,   861,   971,  2330,  2331,  2337,  1226,   559,   593,  2318,
     152,   181,   198,   199,   321,   490,   501,   634,   675,   694,
     960,   961,  1203,   588,  1208,  2387,   673,   784,   785,  1199,
       1,   201,   442,   641,   754,   857,  1197,  2329,  2336,  2370,
    2370,  1101,  1113,   844,   621,  2370,  2287,   857,  2370,   764,
     431,  1023,     1,   375,   431,  1023,   857,   857,   213,   481,
    1107,  2288,  2295,  2229,  1007,   231,  1008,   993,   996,   954,
    1647,   587,   955,  1599,  1602,  1603,  1604,  2211,  2271,    12,
     166,   172,   173,   182,   188,   363,   364,   365,   375,   462,
     463,   464,   472,   474,   485,   486,   487,   494,   514,   580,
     608,   715,   815,   816,   830,   885,   912,   920,   948,  1630,
    2202,  2235,  2236,  2238,  2239,  2271,  2293,  2297,  2298,  2299,
    2300,  2434,    54,   865,   869,   870,  1635,  2197,  2198,  2199,
    2200,  2201,  2202,  2239,  2242,  2271,  2278,  2279,  2281,  2294,
    2297,   481,  1640,  1641,  2218,  2219,  2220,  2281,  1645,  1650,
      18,   481,   647,  1671,  1672,  1673,  2255,  2271,   953,  1676,
    1677,  1679,  2210,    12,  1684,  2202,  2203,  2204,  2233,  2276,
    2277,  2281,  2294,    15,  1689,   861,  1696,  2210,    18,  1693,
    2271,  2273,   422,   441,   600,   834,  1701,  1703,   301,   356,
     415,   481,   510,   587,   793,   818,   863,   953,  1706,  1707,
    1708,  1709,  1711,  1719,  1721,  1722,  1723,  1726,  1731,  1734,
    1735,  1738,  1740,  2235,  2255,  2271,  2413,  1759,  2236,  1701,
     860,   871,  1770,  1771,  1772,  2176,  2177,  2178,  1838,  2271,
    2293,  2297,   122,  1787,  1789,   373,   611,   615,   645,   749,
    1796,  1800,  2232,  2233,  1803,  2281,   852,  1806,  2409,   378,
     664,   713,  1661,  1797,     1,  2175,  2176,  1820,  2232,   955,
    1830,  2212,   175,   953,  1498,  1743,  1833,  2271,    65,  1836,
    1837,  2005,  2264,  2265,  2281,  1498,  1743,  1879,   182,  1883,
    2236,  1886,  2236,   761,   316,  1890,  1891,  1892,   414,  1904,
    2170,  2363,   955,  2211,   312,  1920,  2271,  1924,  2210,  1940,
    2211,  1950,  2205,  2281,  1954,  2210,   861,  1958,  2205,  2206,
     852,  1978,  1979,  1983,  2211,   294,   452,   514,  1988,  1991,
    1992,  1995,  1996,  1997,  1998,  1999,  2000,  2001,  2002,  2172,
    2213,  2214,  2232,  2263,  2265,  2281,  2005,  2015,  2210,  2030,
    2031,  2032,   182,   830,  2041,  2235,   639,  2045,  2048,  2212,
    2051,  2266,  2271,  2054,  2210,   481,  2057,  2256,  2271,  2297,
    2068,  2271,  2088,  2206,  1650,  1767,   359,  1863,  1872,  1966,
    1967,  2207,  2281,  2023,  2271,   869,  2285,  2286,  2096,  2124,
     857,   955,   972,  1581,  1583,  1584,  1587,  1588,  1593,   154,
     479,   488,   641,   698,   740,   857,  2330,  2335,  2338,   749,
     488,  1413,  1414,  1287,  1299,  1287,  1287,  1282,  2335,   338,
    1285,  1286,  1287,   467,   971,  1228,   593,  2229,  2387,  2409,
    2409,   584,  2386,  2387,  2387,  2409,  2387,  2387,  2409,  2387,
    2387,   861,  2360,   310,  2359,   481,  1147,  2281,    34,  2343,
    2329,    41,   248,   403,   481,   484,   497,   529,   660,   789,
     794,   795,   970,  1091,  1093,  1094,  1095,  1098,   890,   922,
     923,  1092,  1093,  2291,   481,  2287,   484,   824,   919,  1064,
    2225,  2282,  2283,  1061,  2361,  2370,   515,  2288,  2370,  1009,
     857,  1040,  1210,  1210,  1648,   121,   921,  1564,   260,  1627,
    1600,    43,    68,   370,   515,  1609,  1610,  1611,  1615,  1620,
    2346,  2347,  2413,   869,  1606,   510,  2381,   369,  2386,  2271,
     869,   869,   869,  2302,   869,  2426,  2426,   869,   869,   869,
     869,  2426,  2264,   869,  2302,   261,  1632,   852,  1631,  2236,
    2272,  2294,  2297,   869,  2301,   869,   869,  2201,  2201,  2197,
    2201,   124,   865,   870,    53,    55,    56,    57,    58,    59,
      60,   856,   866,   319,  2272,  2294,  2297,   420,  2313,  1641,
     852,  2426,   262,  1668,  2170,  1673,  1680,  2210,   682,   894,
    1678,  2413,  2432,  2386,   263,  1685,   300,   858,  2204,  2423,
     727,  2319,  2285,  2286,  1690,  1697,  2210,   265,  1698,   673,
    2395,   176,  2355,  2271,   834,  2406,   834,  2211,  1720,   386,
    1741,    92,  2349,   266,  1756,   312,   570,   591,  2138,  2140,
    2142,  2418,  1709,  2234,  2235,  1710,   954,  1712,  1606,  1732,
    1741,   907,   908,   909,   910,   177,   267,  1760,    97,   430,
     268,  1775,  1784,    27,   947,  1773,  1774,  1776,  1779,  1780,
      30,    53,    54,    55,    56,    57,    58,    59,    60,   319,
     434,   559,   595,   854,   856,   865,   866,   869,   870,  2179,
    2180,  2188,  2236,  2370,   697,   831,  1842,   523,  1790,   197,
    1797,  2233,   290,  2217,   452,  1920,  2236,   841,  1814,  1821,
    2413,  2212,  2271,     9,    17,    49,    79,    80,    81,    82,
      83,    84,    85,    86,    95,   100,   111,   112,   113,   114,
     129,   139,   142,   143,   144,   146,   180,   189,   190,   191,
     192,   193,   194,   195,   196,   202,   204,   233,   234,   237,
     238,   242,   264,   289,   293,   308,   314,   315,   333,   334,
     335,   336,   337,   340,   381,   382,   383,   384,   390,   391,
     393,   395,   396,   397,   400,   402,   406,   425,   426,   435,
     436,   437,   438,   439,   440,   449,   453,   454,   457,   496,
     500,   502,   503,   504,   505,   513,   530,   538,   574,   575,
     609,   612,   623,   629,   633,   635,   636,   649,   652,   653,
     658,   674,   676,   677,   685,   686,   708,   709,   710,   729,
     730,   731,   732,   734,   738,   739,   746,   747,   755,   756,
     757,   763,   768,   786,   799,   800,   805,   828,   829,   837,
     845,   851,   881,   887,   931,   938,   940,   943,   950,   963,
     967,  1503,  1505,  1507,  1509,  1511,  1513,  1515,  1517,  1520,
    1522,  1524,  1525,  1527,  1529,  1530,  1532,  1534,  1537,  1538,
     455,   781,   850,  1539,  1540,  1838,  2007,   869,  2285,   559,
     811,  1500,  1501,  1502,  1503,  2317,  1539,   272,  1880,  2236,
     852,   273,  1887,    97,  1891,   320,   422,   441,   600,  1893,
      98,   361,   481,  1289,  1909,  1910,  1911,  2218,  2239,  2257,
    2271,  2281,  2293,  2297,  2413,   842,   955,  1921,   276,  1936,
     537,   632,  2316,   277,  1947,   510,   752,  1941,   369,  2089,
     278,  1955,  2395,   955,   279,  1961,  2089,  2236,   281,   369,
    1981,  1982,  2250,  2253,  2271,  2294,  2297,   312,  1998,  2000,
    2232,   640,   852,  2214,   245,   852,   903,  1990,    45,  2285,
     282,  2020,   341,   446,   452,  2017,   283,  2038,   430,  2033,
    2034,  2236,  2271,  2264,   284,  2042,   369,  2212,  2352,   673,
     679,  2396,   285,  2065,   220,  2058,  2271,   286,  2093,  2089,
     481,   380,  1864,  2271,  1873,  2271,  1968,  2207,   280,  1974,
     935,  1969,  1661,  2024,  2236,  2413,  2195,  2197,   869,  2286,
    2097,  2271,  2125,  2271,     1,   749,   857,  1582,  1278,  2328,
     749,   479,  1416,  1417,  1298,  1301,   693,  2335,     1,  1283,
     169,    89,   135,   201,   448,   471,   673,   678,   698,   700,
     930,  1229,  1230,  1232,  1236,  1237,  1240,  1241,  1247,  1250,
    1252,  1253,  2331,  2370,  1135,  2221,  2222,  2222,  2287,  2287,
    2208,  2210,  2208,  2287,  2208,  2208,  2222,  2208,  2208,   833,
    2405,   259,  1209,  2287,  2361,  2225,  1095,    27,   844,   124,
     517,   956,  2430,   955,  2284,    25,   526,  2225,  1079,  2370,
    1044,   994,   997,    99,   606,   806,  1649,  1566,  1565,   713,
    1575,  1609,   970,  2258,  2263,  2287,  2370,  1611,  1616,  1617,
     847,    48,    61,    62,    63,    64,    69,    88,   138,   175,
     177,   189,   216,   360,   371,   401,   460,   492,   495,   541,
     548,   585,   603,   651,   654,   702,   714,   716,   717,   724,
     737,   742,   750,   793,   827,   848,   892,   904,   911,  1621,
    1624,  1625,  1626,  2356,  2394,   151,   481,  1607,  1608,  2245,
    2271,  2271,   183,    36,    37,   140,   147,   150,   205,   210,
     211,   294,   296,   303,   312,   422,   473,   477,   511,   740,
     825,   836,   847,   918,   955,  1614,  2214,  2420,   290,   645,
    2248,  2272,   852,  2195,  2197,  2308,  2195,  2309,   854,  2195,
    2301,  2304,  2305,   955,   955,  2197,  2307,  2307,  2307,  2241,
    2271,  2294,  2297,  2306,   955,   852,  2241,  2303,  2301,    12,
    2202,  2203,  2236,  2281,  2294,   378,  2197,  2241,  2195,   854,
     420,  2314,  2198,  2198,  2199,  2199,  2199,  2199,  2199,  2199,
    2199,  2199,  2199,  2199,   483,  1636,   643,  1642,  2220,  1652,
    1653,  2256,  2271,  1678,   489,   541,  2361,  2413,  2272,  2197,
     515,  2320,  2286,  2197,  2138,  2210,   711,  1929,  1930,  1931,
    1702,  2413,  1712,   953,  2235,  1590,  1591,  2141,  2142,  2139,
    2140,  1590,   906,  1615,  1620,  1714,  1715,  1717,  2413,    61,
      62,    63,    64,    69,    87,    88,   138,   175,   177,   301,
     360,   401,   495,   603,   737,   742,   781,   793,   892,  1625,
    1713,  1754,   301,  1724,  1725,  2271,  2294,   906,  1742,   953,
    2138,  2138,  2138,  2138,  1707,  2236,  2203,  2236,  1772,   947,
    1776,  1777,  1778,     1,    31,   860,   871,  1781,  1782,  2177,
     857,  1590,  1775,  1779,  2187,  2188,  2180,    22,    23,    24,
     128,   300,   387,   388,   465,   466,   534,   569,   578,   587,
     630,   858,   862,   864,  2189,  2190,  2191,  2192,  2193,  2194,
      18,   341,   456,   902,  1845,  1843,  1788,   481,  2215,  2216,
     222,  1807,  2218,   312,  2415,  1812,  1813,  1815,    18,    22,
      25,    26,   526,   527,   578,   579,  1822,  1826,   338,   414,
     858,  2364,  1536,  2287,  2364,  1538,  2364,  2364,  2364,  1540,
     178,   697,   831,  1839,  1848,  1850,  1851,  2009,  2387,  2413,
     434,   858,  2371,  1501,    33,   434,   858,  2373,     3,    13,
      29,    50,    78,    91,    92,    93,    96,   103,   115,   117,
     118,   145,   200,   217,   240,   241,   243,   244,   288,   304,
     344,   345,   346,   367,   372,   398,   399,   404,   405,   459,
     461,   478,   491,   492,   493,   519,   543,   544,   545,   547,
     549,   550,   552,   553,   554,   560,   562,   563,   564,   565,
     578,   586,   601,   602,   610,   616,   663,   669,   722,   723,
     725,   733,   758,   771,   772,   773,   774,   791,   792,   802,
     832,   846,   847,   883,   893,   900,   911,   915,   916,   917,
     936,   937,   941,   942,   944,   951,  1504,  1506,  1508,  1510,
    1512,  1514,  1516,  1518,  1519,  1521,  1523,  1526,  1528,  1531,
    1533,   852,  2232,  2203,  2236,   770,  1894,  2386,   392,  2171,
    2171,   902,   935,   844,     1,    71,    72,    73,    74,    76,
     158,   159,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   481,   625,   648,  1290,  1291,  1292,  1293,  1294,  1346,
    1347,  2246,  2272,   849,   838,  2395,   430,  2262,  2271,  2293,
    2297,   430,  1925,  1929,  1982,  2271,  1984,  2413,   852,   852,
     852,   852,  1989,    12,   290,   781,   860,   871,  2236,    97,
      69,    88,   401,   460,   495,   603,   716,   892,  1993,  1994,
    2370,  2016,  2413,  2271,  2034,   220,  2035,   369,   369,  2203,
    2236,   369,    97,  2350,   430,  2061,    15,    68,  2090,  2091,
    1647,   852,   271,  1870,   369,  1870,   430,  1974,    44,   259,
    1970,  2416,  1975,  2271,  1970,  2236,   302,   558,   151,   759,
     854,  2196,   855,  2197,   287,  2122,   369,  2122,  2127,  2413,
    1585,  2339,  1279,  1257,  2328,   749,   698,  1419,   930,   932,
    1386,  1390,  1318,  1319,  2370,  2310,   857,    31,    67,    87,
     126,   216,   224,   362,   432,   444,   468,   583,   620,   631,
     681,   737,   754,   775,   823,   887,   913,   928,   930,   932,
     935,   939,  1306,  1307,  1308,  1309,  1310,  1313,  1314,  1316,
    1319,  1320,  1323,  1326,  1328,  1329,  1334,  1335,  1337,  1350,
    1354,  1371,  1372,  1374,  1375,  1376,  1379,  1400,  1403,  1405,
    1407,  1408,  1409,  1410,  1411,  1412,  1464,  2370,  2400,  1288,
    2370,   170,  2354,  2370,   673,   679,  2431,  2431,  2370,  2354,
    2370,  2382,  2370,    33,  2342,   584,   955,  1254,  2230,   322,
     379,     1,  1136,  1137,  2222,  2387,  2387,   875,   876,  2435,
    2210,  2387,  2387,  2354,  2386,  2386,   679,  2208,  1096,  1098,
    2426,  2370,  2370,  2225,  1079,  1048,  1049,  1220,  1557,  1557,
     479,  1567,  1568,  1569,  2350,  1567,   587,   955,  1561,   303,
     568,   570,   590,  2131,  2133,  2134,  2136,  2137,  2417,  2418,
      89,   473,  1618,   137,   141,   627,   628,  1619,  2422,   481,
    2259,  2263,  2289,  2370,  2370,  2370,  2259,  2370,    69,   250,
    1626,  2351,   245,   903,  2410,    15,  2341,   446,   781,  1607,
     151,   865,   870,  2131,   969,   968,  2250,  2131,   446,  2375,
     803,   803,   576,  1601,   522,   481,  2249,  2272,  2271,  2196,
     854,  2196,   854,   854,   619,   854,  2241,  2196,   854,   854,
     854,  2196,   854,  2264,  2196,   854,  2386,   573,   782,  2143,
    2145,  2147,  2285,  2286,  2203,   855,   854,   854,   852,  2315,
    1636,  2287,   713,  1637,   852,  2218,  1646,   535,   647,  1654,
      39,  1681,  2413,   718,   692,   541,  2143,  2370,   748,   361,
    2361,   433,   571,  2164,  2165,  2167,  2169,   446,  1736,  1727,
    1592,   184,   185,   637,  1079,  1718,  2214,  1715,   542,  1754,
    2371,   473,   740,  2370,  2370,   297,   299,  1541,  1542,  2358,
    2409,  2371,   245,  2410,  2370,  1754,  1725,  2271,  1733,  1739,
    2138,   378,  2143,   378,   598,   857,  1590,  1775,    27,   844,
    1783,  1781,   970,  2189,  2409,   341,  1098,  1847,  2281,    18,
     456,   902,  1844,  1605,  1606,  1807,  2216,  2387,  1816,   270,
    1817,  1590,  2409,   697,  1823,  2409,  2271,  2271,  2271,  2271,
    2271,  2251,  2272,  2280,  2294,    18,   124,   341,   456,   880,
    1854,  1855,  1856,  1849,  1850,  1157,  2010,  2353,    40,   223,
    1366,   246,  1535,  2271,  2287,   869,  2236,  2232,  2143,   378,
    2413,  1929,  1290,  2363,  1910,  1905,  1906,   318,  1912,  2175,
    1913,  1914,  2271,  2218,   857,  2091,  1925,  2271,  2271,   566,
    2153,  2156,  2158,  2416,  1959,  1960,  2413,   713,  2090,   251,
     256,   305,  2271,  2250,   585,   970,  2260,  2261,  2263,  2287,
    2386,  2249,   584,  2236,  1989,  1989,  1989,  1989,  1989,  1989,
    1989,  1989,  1994,   559,   569,  2018,  2019,  2190,  2317,  2164,
     462,   781,  2433,  2037,  2413,  2350,  2271,  2264,  2143,   378,
    2251,    18,  2059,  2060,  2311,  2062,  2271,  2037,  2062,  1929,
      14,  2340,   921,  1655,   481,  2271,  2271,   947,  1971,   947,
    1972,  1973,   803,  2403,  2403,  2197,   854,  2197,  2271,   713,
    2128,   258,  1589,  2287,  1258,  1415,  2328,  1420,   740,  1482,
    2370,  2342,    30,   319,   595,   854,   856,   865,   866,   869,
     870,  1289,  1305,  1392,  1393,  1394,   930,   379,  2281,   462,
     578,   947,  2411,  2370,  2370,  2370,    77,   123,   578,  1327,
     947,   722,  2397,  2269,  2272,   247,  1357,  2287,  1330,   947,
    2272,    39,  2345,   947,   434,   459,   722,  1373,  2409,  2370,
    2370,   369,  2370,   369,  2342,   955,  1465,  1466,  1308,    70,
      71,    72,    73,    74,    76,    77,   155,   157,   158,   160,
     161,   162,   163,   164,   165,   231,   232,   347,   348,   349,
     350,   351,   355,   376,   392,   416,   526,   604,   625,   648,
     777,   778,   779,   897,   898,   899,   922,  1339,  1346,  1347,
    1289,  1305,  1387,  1388,   322,   323,   409,   790,   888,   456,
     880,   369,  1302,  2345,   379,  2287,  1160,  2372,  2372,   955,
    2226,  2227,   587,   793,  2427,   481,  2222,  2228,  2287,   935,
    2370,   330,   408,   955,  1238,  2230,  2329,     6,    10,    29,
      42,   257,   331,   332,   417,   473,   555,   597,   605,   673,
     688,   705,   770,   784,   861,   877,   878,  1138,  1139,  1148,
    1150,  1154,  1156,  1157,  1159,  1161,  1162,  1163,  1164,  1170,
    1171,  1172,  1173,  1176,  1182,  1183,  1185,  1187,  1189,  1190,
    1191,  1192,  2329,  2353,  2395,  2425,  2208,  2208,  2387,  2208,
    2208,  1204,  1205,  2210,  2432,  2210,  1097,  1098,  2284,  2225,
    2225,  1073,  1211,  1417,   641,   998,   998,  1568,   781,   896,
    1570,  1571,  1572,   683,   930,  2339,  2135,  2136,  1622,  1623,
    2267,  2271,  2132,  2133,  1590,   576,  2384,  2384,  2258,  2197,
     481,  1755,  2244,  2266,  2258,  2370,  2173,  2261,  2173,  2259,
    2363,  2370,   854,   854,  1607,  2245,  2245,  2131,   781,  1612,
    1613,  1615,  2319,   826,  2301,   826,  2301,   854,  2301,  2222,
    2301,  2301,  2301,  2241,  2301,  2319,   456,   880,  2301,  2272,
    1590,  1590,  2146,  2147,  2144,  2145,  2286,  2143,   854,  2197,
    2301,  2301,  2254,  2271,  2293,  1637,  2233,  2171,   541,   718,
    2321,  2197,  1590,  1590,  2168,  2169,  2166,  2167,  2255,  1742,
     216,   407,   850,   887,  1661,  1728,  1729,  1730,  1593,  2258,
    2258,  1755,   473,   740,   259,  2258,  2173,  2173,  2197,    91,
      93,   392,   477,   626,   769,   872,  1615,  1744,  1745,  1746,
    1747,  1748,  1750,  1751,  1752,  1753,  2413,  1744,  2203,  2204,
    2203,  2204,  1782,  2176,    97,   341,  1847,   301,  1791,  2267,
    1590,  1812,   930,  1824,  1825,  1826,   841,  1827,  2407,   930,
     852,    97,  1855,  1857,  2251,    18,   124,   456,   880,  1852,
    1853,  2250,  2267,  2271,  2006,   764,  2375,   414,   596,  2365,
    2235,  2203,    18,   541,   667,  1186,  2208,  2271,  1590,   274,
     857,  1908,    15,   369,    14,   413,  1926,  1927,  1928,  1930,
    1933,  1960,  2413,   201,   546,  1942,  1944,  1946,  1590,  2157,
    2158,  2156,  1590,  2164,   489,   541,  1980,  2271,   697,  1985,
     327,   328,  2236,  2190,  2271,  2191,  2192,  2193,  2194,  2197,
     572,   868,  2148,  2150,  2152,   625,   781,  2036,  2236,  2319,
    2319,  2203,   852,   595,  2250,   221,  2063,   831,  2064,  1959,
     607,  2214,  2258,  1656,   183,  2174,  1874,  2413,  2176,  1590,
    2175,  1972,  2025,  2236,  2025,   854,  2174,   526,   929,  2129,
    2253,   857,   109,  1259,  1260,  1261,  1279,  1418,   749,  1483,
     844,  1391,  1394,  2370,   844,  1296,   970,    22,    23,    24,
      90,   128,   578,  1160,  1406,   556,  1404,  2236,  2232,   201,
    2357,     1,  2181,  2182,  2183,  2184,   869,  1311,  1312,   104,
    1359,   891,   852,  1356,    98,   222,   484,  1331,  1351,  2181,
    2269,  1324,   955,  2270,     1,   581,   955,  1342,  2233,   869,
    1382,  1387,  1388,  1382,  1377,  1378,  1387,   369,  1467,  1466,
     776,   896,  2399,   896,  2399,   896,  2399,   896,  2399,   896,
    2399,    16,  2409,  2386,  1341,  2409,  1340,  2409,   695,  1383,
    1384,  1388,    39,  1317,  2350,  1321,   810,  1315,   762,  2322,
    2322,   955,  1304,  1305,   852,  1235,   359,  1251,  2227,   477,
    2379,   852,  2352,  2363,   324,   342,   736,   889,   924,   933,
    1248,  1249,  2370,  2370,  2382,  2375,  2395,  2409,   765,  2375,
    2370,  2351,   221,  2375,  2375,   541,  1184,  2287,  2413,  2370,
    2370,   803,   489,   764,    70,  2348,  2372,  2208,  1205,   628,
    1206,    27,  2361,  2361,  1114,  1118,  1120,  1212,  1213,  1214,
    1215,  1066,  1067,   999,   988,   990,  2370,   781,  1572,   593,
    1574,   215,  1576,  1590,  2197,  2197,  2255,   473,   477,  2428,
    1623,  2260,   854,  2370,  1613,  2143,  2301,   369,  2323,   854,
    1647,   231,   748,   849,  1737,  2371,  2371,  2371,  2371,  2236,
    1730,  2386,   414,   434,  2374,  2197,  2343,  1745,   116,   459,
     722,  1749,   541,  1754,  2143,   690,  2143,   690,  1847,   697,
    1846,  1792,  1793,  2271,  2293,  1816,  1825,  2357,  2409,  2252,
    2280,  2293,  2250,    97,    15,    68,  1858,  1859,  1860,  1853,
    1858,   359,   422,   921,  2011,  1158,  2361,  2370,  2008,   596,
     854,  2143,   598,  2390,  2390,   589,    20,   230,   359,   458,
     703,   717,   954,  1895,  1896,  1900,  1901,  2413,  2414,   274,
    1907,  1914,  2236,  2387,   489,   446,  1934,  1932,  1933,  2413,
     412,   445,   945,  1590,  1590,  1945,  1946,  1943,  1944,   489,
     473,  2376,  2386,  2386,  1590,  1590,  2151,  2152,  2149,  2150,
    2370,  2143,  2323,  2143,  2252,  2060,  2363,  2174,  2363,  2148,
     298,   567,  2092,  2159,  2161,  2163,  2165,   473,   477,  2377,
    1657,  1658,  1659,  2350,  2363,  1865,   522,  2109,   226,  1590,
    1590,  2098,  2413,   644,   914,  1586,  2069,  2229,  1279,  1279,
    2328,   749,  1289,   947,  1395,  1396,  1397,  2372,  2412,   537,
     798,  1303,  1304,  2281,    30,    53,    54,    55,    56,    57,
      58,    59,    60,   319,   595,   854,   856,   865,   866,   869,
     870,  2185,  2186,  2188,  2189,  2236,   481,  2247,  2363,   369,
    1355,   849,  2408,  2287,  2408,  2287,  2387,  1332,  2370,   598,
    1325,  2181,   683,  1401,  2411,  1385,  2289,  2370,  1384,  2342,
    1378,  1387,   369,  1380,  1383,  2242,    97,  1468,   375,     7,
      66,    78,   125,   148,   207,   292,   357,   366,   448,   455,
     480,   508,   657,   661,   743,   804,   818,   842,   884,   934,
     946,   953,   955,  1496,  2270,   647,  2289,  2409,   481,  2255,
     184,   189,   309,   741,  1322,  2351,  1305,  2287,   124,   679,
    1231,  2221,  1242,  2287,  2401,   481,  1239,  2281,  1239,  2370,
    2370,  2375,   247,   322,  1145,  1146,  2370,   688,  1171,  2370,
    2370,  2370,  2370,    34,    35,  2344,  1186,  2228,  2287,  2370,
    2382,   584,   765,  1188,  2228,  2287,  1098,   526,    25,  1214,
     857,  1215,   239,    48,   216,  2287,  2370,   955,  1577,  1562,
    2260,   416,  2366,   224,  2324,  1655,  1744,  2236,  2236,  2236,
    2236,  2271,  2371,   850,   742,   958,  2204,  2204,    97,  1716,
    1717,  1793,  1590,    97,   216,  1858,  1858,  2252,   863,  2368,
    2368,  1860,  1859,   641,  2208,   378,   600,  2012,    25,   526,
    1160,  2281,    18,   541,   668,   905,   962,  1898,  1899,  1900,
     541,    94,   489,   500,  1897,    97,  1915,   489,  2370,  1935,
    2154,  2156,  2158,  2164,   489,   489,  2210,  2210,  2271,  2324,
    2271,  2271,  1590,  1590,  2162,  2163,  2160,  2161,  1658,   587,
    1571,  2237,  2238,  2268,  2272,   171,   683,   930,  2271,  2109,
    2386,   821,  1867,  2100,  2101,  2102,  2413,   861,  2130,  2205,
     641,  2070,   857,  1262,  1421,  2328,   766,   432,   925,  1398,
     860,  2386,  2186,   970,  2189,   854,   955,  2287,   852,  1356,
     222,   222,  1358,  2222,   781,   955,  1333,   325,   955,  1343,
    1344,   588,  1402,   302,   541,   854,  2196,  1382,   852,  1381,
    2242,   218,   343,   450,   507,   783,   879,  1348,   482,  1349,
    2408,   259,   803,    91,   872,  1243,  1244,  1245,  1246,  2413,
    2352,   369,  1234,  2362,   247,   665,   765,  1149,  2222,  2370,
     105,   106,   107,   228,   229,   231,   422,   423,   447,   473,
     498,   600,   633,   637,   638,   665,   833,  1140,  1141,  1142,
    1143,  1144,  2222,  2228,  1174,  2222,  2222,  2352,  2435,  2222,
    2370,  2222,  2228,   844,  2370,  2370,   857,  1564,    48,  1573,
    2413,  2339,  1580,  2260,  2366,  2143,  1660,  1661,  2271,  2371,
    2143,  2143,  1847,  2236,  1858,  2236,  2236,  2370,  2208,   641,
    2370,  2370,  1160,   599,  2391,   718,  2239,  2243,  2247,  2271,
    2297,   902,  2271,  2157,  2155,  2156,  2143,  2237,  1867,  2110,
    2111,  2271,  1868,  1869,  2271,  2138,   524,  2104,  2102,    46,
     258,   965,  2103,   955,  2370,    43,   249,   313,   379,  2071,
    2072,  2073,  2075,  2079,  2081,  2082,  2085,  2346,  2361,  1263,
    1422,  1484,   852,   947,  1399,  2370,  2271,   420,  1360,  2387,
    2387,   417,  1361,  1363,  1364,  1365,  1366,  1368,  2370,  2386,
       8,   128,   171,   362,   687,   359,   302,  2289,  1382,  2228,
    2228,   358,   222,  1233,  1235,  2287,  2222,   369,    14,   921,
     935,  2281,  2293,  2436,    75,   476,   794,   955,  1175,   787,
     858,  1177,  1178,  2222,  2223,    51,   316,   499,  1165,  2370,
     844,  2228,  2225,  2225,  1575,   506,  1580,   852,  2260,   570,
     868,  1663,  1665,  1667,  2418,    12,   430,   561,   587,   867,
    1662,  2369,  2236,  1909,  2370,  1160,  1160,  2272,  2294,  2297,
    2175,  1866,  2111,  2370,  1869,  2370,   522,  2106,  2253,  1909,
      68,  2341,  1921,  2083,  2084,   645,   213,  1264,  2332,  2335,
    2361,   666,  1423,  1284,  1300,  1485,  1486,  1487,  2175,  1289,
    1361,  2222,  2222,  2350,  1368,  1364,  2375,  1362,  2287,   589,
    1345,  2274,  2275,  2277,  2346,  2387,  2352,  1177,  2281,  2360,
    2281,  2370,   614,  1151,  1152,  1179,  1180,   954,  1166,  1168,
    2413,  1169,  2413,  1166,  1160,  2228,  2328,   781,   259,  2260,
    1590,  1590,  1666,  1667,  1664,  1665,  1590,  2386,  2271,  1909,
    2361,  2361,  2138,   587,  2293,  2253,  2386,   887,  2112,  2126,
     699,   793,  2402,   861,  2209,  2084,   259,   798,  2080,  2387,
     600,  2368,  1424,     1,  1286,  1487,   857,  1361,  1369,  1370,
    2282,  2370,  1363,  2275,  2228,  2222,  1233,  2312,  2413,  1153,
    2312,  1181,  2222,  1181,   489,  2380,   726,   500,  2370,  1578,
    2271,   526,    25,   525,  2105,  2107,  2108,  2271,  2386,   821,
    2117,  2138,  2271,   302,   312,  2424,  2210,   861,    18,  2076,
    2077,  2272,   224,   302,   803,   822,   839,  1269,  1270,  1271,
     422,   441,  2212,   857,  1488,  1489,   857,  1370,  2224,  2225,
    1151,   246,   541,  2370,   588,  2259,   215,  2370,  2370,  2370,
    2108,  2370,  2113,  2114,  2271,   310,   949,  2118,  2119,  2271,
    2099,   641,  2392,  2210,   584,   642,   684,  2078,  2077,   183,
     830,  2370,   446,   446,   224,   462,  1271,   259,   510,   803,
     822,   839,  1265,  1266,  1267,  1268,  2271,  2381,  2404,   259,
     510,   803,   839,  1272,  1273,  1274,  1275,  2271,  2404,  1425,
    1491,   581,  1495,  1496,  2225,   820,  1155,   246,  2222,   520,
     673,   679,  2429,  1579,  1160,  1160,  2253,  2293,  2114,  2370,
      45,   171,   254,   557,   578,  2116,  2120,   403,   497,   789,
     970,  2121,  2296,  2119,  2138,  2387,   584,  2269,  2370,   583,
    2271,  2370,  2370,  2370,  2370,   446,   205,   847,   446,   462,
    1267,  2271,   183,   659,   787,   812,   813,   814,   446,   205,
     847,   446,   462,  1274,  2271,   834,     1,  1426,    48,    61,
      62,    63,    64,    69,    87,    88,   108,   130,   138,   175,
     186,   301,   360,   369,   371,   389,   401,   460,   473,   477,
     495,   541,   583,   603,   651,   702,   724,   750,   781,   793,
     827,   852,   863,   892,   913,   921,   930,  1329,  1336,  1337,
    1350,  1371,  1374,  1492,  1493,  1494,  1555,  1556,  1624,  1625,
    2370,  2422,  1497,  2271,  2287,  1490,   947,  2429,  1167,  1168,
    2339,  2116,  2115,  2116,  2115,   595,   320,   422,   441,   600,
    2074,  2208,  2271,  2287,  2271,  2271,  2271,  2271,  2370,  2370,
    2370,  2370,  2370,  2271,  2370,  2370,  2370,  2370,  2370,  2370,
    2370,  2370,  2370,  2370,  2370,  2271,  2370,  2333,  2335,   175,
     176,   607,  1427,  1428,  1433,  2333,  2370,  2413,  2444,  2370,
     473,   740,  1553,  2384,  1551,  2384,  2370,  2370,  2371,  1541,
    1542,  2370,  2262,  1551,  2371,  2287,   123,  2371,  2271,  2370,
    2271,  2370,   231,   232,   526,   922,  1338,  2294,   379,  1553,
    1499,  1500,    18,   789,   970,  1099,  1167,  2296,  2408,  2271,
    2271,  2271,  2271,  2271,  2271,  2271,  2271,  2271,  2271,  2271,
    2271,  2271,  2271,  2271,  2271,  2271,  2271,  2271,  2372,  2372,
     469,   470,  2378,  1444,   379,   134,   339,  1429,  1430,  1431,
    1432,  2271,  2258,  2370,  2370,  2258,  1755,  2267,  2287,  2258,
    1548,  2258,  2408,  2370,  2267,  2287,     1,  1491,  2295,  1367,
    1368,  2271,  2271,  2372,  2372,   970,  1434,  1435,  1436,  2271,
    2287,  2290,  1284,  1445,  2370,  1431,  1432,   512,   624,   865,
     870,  1544,  1545,  1546,  1547,  1554,  1544,  1546,  1552,   110,
     622,  1549,  1550,  2255,  2271,  2271,  1437,   473,   477,  2377,
    2420,  2428,     1,  1286,  1287,  2255,  2258,  2258,  2271,   341,
     358,   394,   452,   475,  1438,  1439,  1440,  1441,  1442,  1443,
    1435,  1436,  2334,  2335,  1446,  2271,   212,   226,  2437,  2370,
    2370,   120,   175,  2437,  2438,  2370,  1447,  2271,  2370,  1436,
    1436,   394,  2370,  2370,  1436,     4,   137,   141,   390,   473,
     477,   539,   583,   631,   787,   819,   887,  1329,  1334,  1336,
    1350,  1352,  1371,  1374,  1386,  1389,  1448,  1449,  1454,  1457,
    1460,  1461,  1464,  1469,  1470,  1473,  1474,  1480,  1481,  2334,
    2419,  2420,  2421,  2271,  1436,  1436,  1436,   418,  2367,   577,
    2384,  2385,  2342,  2370,  2287,  2370,  2386,  2370,  1387,    15,
      68,   444,   947,   540,  1471,  1472,  1543,  1544,  1477,  1478,
    1479,  1544,  2287,  2385,  2271,  2372,   537,   540,   607,  1455,
    1456,  1544,  2287,  1356,  2242,  2240,  2242,   119,   175,   607,
     617,   618,   698,   720,   721,  1450,  2437,  2438,  2439,  2440,
    2441,  2442,  2443,   536,  2383,  2383,    15,    68,  2175,  1471,
    2290,  1478,  2290,   115,   459,   722,  1475,  1476,  2287,  2408,
    2319,   706,   906,  1458,  2242,   358,   358,   394,   358,   394,
     359,   588,  2388,  2388,   595,   607,  1462,  1463,  2271,  1462,
    2383,  2383,  2372,  1358,  2387,  2271,   339,  1451,  2271,    18,
     339,  1453,  2271,  1462,   607,   607,   807,  1353,   339,  1459,
    2271,   595,  1452,  1452,  1452,  1452,  2287,   607
};

  /* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_int16 yyr1[] =
{
       0,   974,   976,   975,   977,   977,   979,   978,   980,   980,
     981,   981,   981,   981,   983,   982,   984,   985,   986,   986,
     987,   987,   989,   988,   991,   990,   993,   994,   992,   996,
     997,   995,   998,   999,   998,  1000,  1001,  1002,  1001,  1003,
    1004,  1003,  1005,  1005,  1006,  1007,  1006,  1008,  1009,  1008,
    1011,  1012,  1010,  1013,  1013,  1015,  1014,  1016,  1016,  1017,
    1018,  1019,  1020,  1021,  1021,  1022,  1022,  1023,  1023,  1024,
    1024,  1025,  1025,  1025,  1025,  1026,  1026,  1027,  1027,  1028,
    1028,  1029,  1030,  1030,  1031,  1031,  1031,  1031,  1032,  1032,
    1033,  1033,  1034,  1034,  1034,  1035,  1035,  1036,  1036,  1036,
    1036,  1037,  1038,  1038,  1039,  1040,  1041,  1042,  1042,  1043,
    1044,  1045,  1045,  1046,  1046,  1047,  1047,  1047,  1047,  1047,
    1048,  1048,  1050,  1049,  1051,  1051,  1052,  1052,  1054,  1053,
    1055,  1055,  1055,  1055,  1056,  1056,  1057,  1057,  1057,  1057,
    1058,  1059,  1060,  1061,  1061,  1061,  1061,  1061,  1061,  1062,
    1063,  1064,  1064,  1064,  1064,  1065,  1065,  1066,  1066,  1068,
    1067,  1069,  1069,  1069,  1070,  1070,  1071,  1071,  1071,  1071,
    1071,  1072,  1072,  1073,  1074,  1075,  1075,  1075,  1076,  1076,
    1076,  1076,  1076,  1076,  1076,  1076,  1076,  1076,  1076,  1076,
    1076,  1076,  1076,  1078,  1077,  1079,  1079,  1080,  1080,  1080,
    1080,  1081,  1081,  1082,  1083,  1083,  1085,  1084,  1087,  1086,
    1088,  1086,  1089,  1089,  1090,  1091,  1091,  1091,  1091,  1091,
    1092,  1092,  1092,  1092,  1093,  1093,  1093,  1094,  1094,  1095,
    1095,  1096,  1095,  1097,  1097,  1098,  1098,  1098,  1098,  1098,
    1098,  1099,  1099,  1100,  1100,  1100,  1101,  1101,  1102,  1103,
    1104,  1104,  1105,  1106,  1106,  1107,  1107,  1108,  1109,  1109,
    1110,  1111,  1112,  1112,  1113,  1113,  1114,  1116,  1115,  1117,
    1117,  1118,  1119,  1119,  1120,  1121,  1122,  1123,  1124,  1125,
    1127,  1126,  1128,  1129,  1130,  1130,  1131,  1131,  1132,  1132,
    1134,  1135,  1133,  1136,  1136,  1137,  1137,  1138,  1138,  1138,
    1138,  1138,  1138,  1138,  1138,  1138,  1138,  1138,  1138,  1138,
    1138,  1138,  1138,  1138,  1138,  1138,  1138,  1139,  1139,  1139,
    1139,  1139,  1140,  1140,  1140,  1141,  1141,  1141,  1141,  1141,
    1141,  1141,  1142,  1142,  1142,  1142,  1143,  1143,  1143,  1143,
    1143,  1143,  1143,  1144,  1145,  1145,  1146,  1146,  1147,  1147,
    1148,  1149,  1149,  1149,  1150,  1151,  1151,  1153,  1152,  1154,
    1155,  1155,  1155,  1156,  1157,  1158,  1158,  1158,  1158,  1158,
    1158,  1159,  1160,  1160,  1160,  1160,  1160,  1160,  1161,  1162,
    1162,  1162,  1164,  1163,  1165,  1165,  1165,  1166,  1166,  1166,
    1166,  1167,  1167,  1168,  1169,  1169,  1170,  1170,  1171,  1171,
    1171,  1171,  1172,  1174,  1173,  1175,  1175,  1175,  1175,  1176,
    1177,  1177,  1178,  1178,  1180,  1179,  1179,  1181,  1182,  1183,
    1184,  1184,  1185,  1186,  1186,  1186,  1187,  1188,  1188,  1189,
    1190,  1191,  1192,  1193,  1193,  1194,  1195,  1195,  1195,  1196,
    1196,  1197,  1197,  1197,  1197,  1198,  1199,  1199,  1199,  1199,
    1200,  1200,  1200,  1200,  1200,  1201,  1201,  1201,  1201,  1201,
    1201,  1201,  1201,  1203,  1202,  1204,  1204,  1205,  1206,  1206,
    1207,  1208,  1209,  1209,  1210,  1210,  1210,  1211,  1212,  1212,
    1213,  1213,  1214,  1214,  1215,  1215,  1215,  1217,  1216,  1218,
    1218,  1219,  1220,  1221,  1222,  1222,  1223,  1223,  1224,  1226,
    1225,  1225,  1227,  1227,  1228,  1228,  1229,  1229,  1229,  1229,
    1229,  1229,  1229,  1229,  1229,  1229,  1229,  1230,  1231,  1231,
    1231,  1232,  1232,  1232,  1233,  1233,  1234,  1234,  1235,  1235,
    1236,  1237,  1237,  1238,  1238,  1239,  1239,  1240,  1241,  1242,
    1242,  1243,  1243,  1243,  1244,  1245,  1246,  1247,  1248,  1248,
    1248,  1248,  1248,  1249,  1249,  1250,  1251,  1251,  1252,  1253,
    1253,  1254,  1254,  1255,  1256,  1257,  1256,  1258,  1258,  1259,
    1260,  1262,  1261,  1263,  1263,  1264,  1264,  1264,  1265,  1265,
    1265,  1266,  1266,  1267,  1267,  1267,  1267,  1267,  1267,  1267,
    1267,  1267,  1267,  1267,  1268,  1269,  1269,  1270,  1270,  1271,
    1271,  1271,  1271,  1271,  1271,  1271,  1272,  1272,  1272,  1273,
    1273,  1274,  1274,  1274,  1274,  1274,  1274,  1275,  1276,  1277,
    1278,  1277,  1279,  1280,  1279,  1281,  1281,  1282,  1282,  1282,
    1283,  1282,  1282,  1284,  1284,  1285,  1285,  1286,  1286,  1287,
    1288,  1288,  1289,  1289,  1289,  1290,  1290,  1290,  1290,  1290,
    1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,  1290,
    1290,  1291,  1291,  1292,  1292,  1293,  1293,  1294,  1294,  1295,
    1296,  1296,  1298,  1297,  1299,  1299,  1300,  1301,  1300,  1302,
    1302,  1303,  1303,  1303,  1304,  1304,  1305,  1305,  1305,  1305,
    1305,  1305,  1305,  1305,  1305,  1305,  1306,  1306,  1307,  1307,
    1308,  1308,  1308,  1308,  1308,  1308,  1308,  1308,  1308,  1308,
    1308,  1308,  1308,  1308,  1308,  1308,  1308,  1308,  1308,  1308,
    1308,  1308,  1308,  1308,  1308,  1308,  1308,  1308,  1308,  1308,
    1309,  1310,  1311,  1311,  1312,  1313,  1314,  1315,  1315,  1316,
    1317,  1317,  1318,  1318,  1319,  1321,  1320,  1322,  1322,  1322,
    1322,  1324,  1323,  1325,  1325,  1326,  1327,  1327,  1327,  1328,
    1330,  1329,  1331,  1331,  1331,  1331,  1332,  1332,  1333,  1334,
    1335,  1335,  1335,  1335,  1336,  1336,  1337,  1337,  1338,  1338,
    1338,  1338,  1339,  1339,  1339,  1339,  1339,  1339,  1339,  1339,
    1339,  1339,  1339,  1339,  1339,  1339,  1339,  1339,  1339,  1339,
    1339,  1339,  1339,  1339,  1339,  1339,  1339,  1339,  1339,  1339,
    1339,  1339,  1339,  1339,  1339,  1339,  1339,  1339,  1339,  1339,
    1339,  1339,  1339,  1339,  1339,  1339,  1339,  1339,  1339,  1339,
    1339,  1339,  1339,  1339,  1339,  1339,  1339,  1340,  1340,  1341,
    1341,  1342,  1343,  1343,  1343,  1343,  1344,  1344,  1345,  1345,
    1346,  1346,  1347,  1348,  1348,  1348,  1348,  1348,  1348,  1348,
    1349,  1349,  1350,  1350,  1351,  1352,  1353,  1353,  1354,  1354,
    1354,  1355,  1355,  1356,  1356,  1357,  1357,  1358,  1358,  1359,
    1359,  1360,  1360,  1361,  1361,  1362,  1361,  1361,  1361,  1363,
    1364,  1364,  1365,  1366,  1366,  1367,  1367,  1368,  1369,  1369,
    1370,  1371,  1372,  1373,  1373,  1373,  1374,  1375,  1376,  1376,
    1376,  1376,  1376,  1377,  1377,  1378,  1379,  1379,  1380,  1381,
    1381,  1382,  1383,  1383,  1384,  1384,  1385,  1385,  1386,  1386,
    1387,  1387,  1388,  1389,  1391,  1390,  1392,  1393,  1393,  1394,
    1394,  1395,  1395,  1395,  1396,  1397,  1398,  1398,  1399,  1399,
    1400,  1401,  1401,  1402,  1402,  1402,  1402,  1403,  1404,  1404,
    1405,  1406,  1406,  1406,  1406,  1406,  1406,  1406,  1407,  1408,
    1409,  1410,  1410,  1411,  1412,  1413,  1414,  1415,  1414,  1416,
    1417,  1418,  1417,  1419,  1420,  1421,  1419,  1422,  1422,  1424,
    1425,  1423,  1426,  1426,  1426,  1427,  1427,  1427,  1427,  1428,
    1429,  1429,  1429,  1430,  1431,  1431,  1432,  1433,  1434,  1434,
    1434,  1435,  1436,  1436,  1437,  1437,  1438,  1438,  1438,  1438,
    1438,  1438,  1439,  1440,  1441,  1442,  1443,  1444,  1444,  1446,
    1445,  1445,  1447,  1447,  1448,  1448,  1448,  1448,  1448,  1448,
    1448,  1448,  1448,  1448,  1448,  1448,  1448,  1448,  1448,  1448,
    1448,  1449,  1450,  1450,  1450,  1450,  1450,  1450,  1450,  1451,
    1451,  1451,  1452,  1452,  1453,  1453,  1453,  1453,  1454,  1455,
    1455,  1455,  1456,  1456,  1456,  1457,  1458,  1458,  1458,  1459,
    1459,  1460,  1460,  1460,  1460,  1460,  1461,  1461,  1462,  1462,
    1463,  1463,  1463,  1464,  1465,  1465,  1466,  1467,  1467,  1468,
    1468,  1469,  1470,  1470,  1471,  1471,  1472,  1472,  1473,  1474,
    1475,  1475,  1476,  1476,  1476,  1477,  1477,  1478,  1478,  1479,
    1480,  1481,  1482,  1483,  1484,  1482,  1485,  1485,  1486,  1486,
    1487,  1488,  1487,  1489,  1490,  1487,  1487,  1491,  1491,  1492,
    1492,  1492,  1492,  1492,  1492,  1492,  1492,  1492,  1492,  1492,
    1492,  1492,  1492,  1492,  1492,  1492,  1492,  1492,  1492,  1492,
    1492,  1492,  1492,  1492,  1492,  1492,  1492,  1492,  1492,  1492,
    1492,  1492,  1492,  1492,  1492,  1492,  1492,  1492,  1492,  1492,
    1492,  1492,  1492,  1492,  1492,  1492,  1492,  1492,  1492,  1492,
    1493,  1494,  1494,  1495,  1495,  1496,  1496,  1496,  1496,  1496,
    1496,  1496,  1496,  1496,  1496,  1496,  1496,  1496,  1496,  1496,
    1496,  1497,  1497,  1498,  1498,  1499,  1499,  1500,  1500,  1501,
    1501,  1501,  1502,  1502,  1503,  1503,  1504,  1504,  1504,  1504,
    1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,  1504,
    1505,  1505,  1505,  1505,  1505,  1505,  1505,  1505,  1505,  1505,
    1505,  1505,  1505,  1505,  1505,  1506,  1506,  1506,  1506,  1506,
    1506,  1506,  1506,  1506,  1506,  1507,  1507,  1508,  1508,  1508,
    1508,  1508,  1509,  1510,  1510,  1510,  1510,  1510,  1510,  1510,
    1510,  1510,  1510,  1510,  1510,  1510,  1510,  1510,  1511,  1511,
    1511,  1511,  1511,  1511,  1511,  1511,  1511,  1511,  1512,  1512,
    1512,  1512,  1512,  1512,  1512,  1512,  1512,  1512,  1513,  1513,
    1514,  1514,  1515,  1515,  1516,  1516,  1516,  1516,  1516,  1517,
    1517,  1517,  1517,  1517,  1517,  1517,  1517,  1517,  1517,  1517,
    1517,  1517,  1517,  1517,  1517,  1518,  1518,  1518,  1519,  1519,
    1519,  1519,  1519,  1519,  1519,  1519,  1520,  1520,  1520,  1520,
    1520,  1520,  1521,  1521,  1521,  1521,  1521,  1521,  1521,  1521,
    1522,  1522,  1522,  1522,  1523,  1523,  1523,  1524,  1524,  1524,
    1524,  1524,  1524,  1525,  1525,  1525,  1525,  1526,  1526,  1526,
    1526,  1526,  1526,  1526,  1527,  1527,  1527,  1527,  1527,  1527,
    1527,  1527,  1527,  1527,  1527,  1527,  1527,  1527,  1527,  1527,
    1527,  1527,  1527,  1527,  1527,  1527,  1527,  1527,  1527,  1527,
    1527,  1527,  1527,  1527,  1527,  1527,  1527,  1527,  1527,  1527,
    1527,  1527,  1527,  1527,  1527,  1527,  1527,  1527,  1527,  1527,
    1527,  1528,  1528,  1528,  1529,  1529,  1529,  1529,  1529,  1529,
    1529,  1529,  1529,  1530,  1530,  1530,  1530,  1530,  1530,  1530,
    1530,  1530,  1530,  1530,  1530,  1530,  1530,  1530,  1530,  1530,
    1530,  1530,  1530,  1530,  1530,  1530,  1531,  1532,  1533,  1533,
    1533,  1533,  1533,  1533,  1533,  1533,  1534,  1534,  1534,  1535,
    1535,  1536,  1537,  1537,  1538,  1538,  1539,  1539,  1540,  1540,
    1540,  1541,  1541,  1542,  1542,  1543,  1543,  1544,  1545,  1545,
    1546,  1547,  1547,  1548,  1549,  1549,  1550,  1550,  1551,  1552,
    1552,  1552,  1553,  1554,  1554,  1554,  1555,  1556,  1557,  1557,
    1558,  1558,  1560,  1561,  1562,  1559,  1563,  1559,  1564,  1565,
    1564,  1566,  1564,  1567,  1567,  1568,  1569,  1569,  1569,  1570,
    1570,  1571,  1571,  1571,  1571,  1571,  1572,  1573,  1573,  1574,
    1574,  1575,  1575,  1575,  1576,  1577,  1578,  1579,  1576,  1580,
    1580,  1581,  1581,  1582,  1581,  1581,  1581,  1583,  1583,  1585,
    1584,  1586,  1586,  1587,  1588,  1589,  1589,  1591,  1592,  1590,
    1594,  1593,  1593,  1595,  1595,  1595,  1595,  1595,  1595,  1595,
    1595,  1595,  1595,  1595,  1595,  1595,  1595,  1595,  1595,  1595,
    1595,  1595,  1595,  1595,  1595,  1595,  1595,  1595,  1595,  1595,
    1595,  1595,  1595,  1595,  1595,  1595,  1595,  1595,  1595,  1595,
    1595,  1595,  1595,  1595,  1595,  1595,  1595,  1595,  1595,  1595,
    1595,  1595,  1595,  1595,  1595,  1595,  1595,  1595,  1595,  1595,
    1595,  1595,  1595,  1595,  1595,  1595,  1595,  1595,  1596,  1595,
    1595,  1598,  1597,  1600,  1599,  1601,  1599,  1599,  1599,  1599,
    1599,  1599,  1599,  1599,  1599,  1599,  1599,  1599,  1599,  1599,
    1599,  1599,  1599,  1599,  1599,  1599,  1599,  1599,  1599,  1599,
    1599,  1602,  1602,  1604,  1603,  1605,  1605,  1606,  1606,  1606,
    1607,  1607,  1607,  1608,  1608,  1609,  1609,  1610,  1610,  1611,
    1611,  1611,  1611,  1611,  1612,  1612,  1613,  1613,  1614,  1614,
    1616,  1615,  1617,  1615,  1615,  1618,  1619,  1620,  1621,  1621,
    1621,  1621,  1621,  1621,  1621,  1621,  1621,  1621,  1621,  1621,
    1621,  1621,  1621,  1621,  1621,  1621,  1621,  1621,  1621,  1621,
    1621,  1621,  1621,  1621,  1621,  1621,  1621,  1621,  1621,  1621,
    1621,  1621,  1621,  1621,  1621,  1621,  1622,  1622,  1623,  1624,
    1624,  1624,  1625,  1625,  1625,  1626,  1626,  1627,  1627,  1629,
    1628,  1630,  1630,  1630,  1630,  1631,  1631,  1632,  1632,  1634,
    1633,  1635,  1635,  1636,  1636,  1637,  1637,  1639,  1638,  1640,
    1640,  1641,  1642,  1642,  1644,  1643,  1646,  1645,  1647,  1648,
    1647,  1649,  1649,  1649,  1650,  1650,  1651,  1651,  1651,  1651,
    1651,  1651,  1651,  1652,  1652,  1653,  1653,  1654,  1654,  1655,
    1656,  1655,  1657,  1657,  1658,  1658,  1658,  1659,  1659,  1659,
    1659,  1660,  1660,  1660,  1660,  1660,  1661,  1661,  1662,  1662,
    1663,  1663,  1663,  1664,  1664,  1665,  1665,  1666,  1666,  1667,
    1668,  1668,  1670,  1669,  1671,  1671,  1672,  1672,  1673,  1673,
    1675,  1674,  1676,  1676,  1677,  1677,  1678,  1678,  1678,  1678,
    1678,  1678,  1680,  1679,  1681,  1681,  1683,  1682,  1684,  1685,
    1685,  1686,  1688,  1687,  1689,  1690,  1689,  1692,  1691,  1693,
    1693,  1695,  1694,  1696,  1696,  1697,  1697,  1698,  1698,  1700,
    1699,  1701,  1702,  1702,  1703,  1703,  1703,  1703,  1703,  1705,
    1704,  1706,  1706,  1706,  1706,  1706,  1706,  1706,  1706,  1706,
    1706,  1706,  1706,  1707,  1707,  1708,  1708,  1710,  1709,  1711,
    1711,  1712,  1712,  1713,  1713,  1714,  1714,  1715,  1715,  1715,
    1715,  1715,  1716,  1716,  1717,  1717,  1717,  1717,  1718,  1718,
    1720,  1719,  1721,  1723,  1722,  1724,  1724,  1725,  1725,  1725,
    1727,  1726,  1728,  1728,  1729,  1729,  1730,  1730,  1730,  1730,
    1730,  1732,  1733,  1731,  1734,  1734,  1736,  1737,  1735,  1739,
    1738,  1740,  1740,  1740,  1741,  1741,  1742,  1742,  1743,  1743,
    1743,  1744,  1744,  1745,  1745,  1745,  1745,  1745,  1745,  1745,
    1745,  1746,  1747,  1748,  1748,  1748,  1749,  1749,  1749,  1749,
    1750,  1750,  1751,  1751,  1752,  1753,  1754,  1754,  1754,  1754,
    1754,  1754,  1754,  1754,  1754,  1754,  1754,  1754,  1754,  1754,
    1754,  1754,  1754,  1754,  1754,  1754,  1754,  1754,  1754,  1754,
    1755,  1755,  1756,  1756,  1758,  1757,  1759,  1759,  1759,  1759,
    1759,  1760,  1760,  1762,  1761,  1763,  1765,  1764,  1766,  1764,
    1767,  1769,  1768,  1770,  1771,  1771,  1772,  1772,  1772,  1773,
    1773,  1774,  1774,  1775,  1776,  1776,  1776,  1777,  1778,  1778,
    1778,  1779,  1780,  1780,  1781,  1781,  1782,  1782,  1782,  1782,
    1782,  1783,  1783,  1784,  1784,  1786,  1785,  1788,  1787,  1789,
    1789,  1790,  1790,  1791,  1791,  1792,  1792,  1793,  1793,  1795,
    1794,  1796,  1796,  1796,  1796,  1796,  1796,  1796,  1797,  1797,
    1797,  1797,  1799,  1798,  1800,  1802,  1801,  1803,  1805,  1804,
    1806,  1806,  1807,  1807,  1809,  1808,  1811,  1810,  1812,  1813,
    1813,  1813,  1814,  1814,  1815,  1816,  1817,  1817,  1819,  1818,
    1820,  1821,  1821,  1822,  1822,  1822,  1823,  1823,  1824,  1824,
    1825,  1826,  1826,  1826,  1826,  1826,  1826,  1826,  1827,  1827,
    1829,  1828,  1830,  1830,  1832,  1831,  1833,  1833,  1835,  1834,
    1836,  1837,  1837,  1838,  1838,  1838,  1839,  1839,  1839,  1839,
    1841,  1840,  1843,  1842,  1842,  1844,  1844,  1844,  1845,  1845,
    1845,  1845,  1846,  1846,  1847,  1847,  1849,  1848,  1850,  1851,
    1852,  1852,  1853,  1853,  1853,  1853,  1853,  1853,  1854,  1854,
    1855,  1855,  1856,  1856,  1856,  1856,  1856,  1857,  1858,  1858,
    1858,  1858,  1858,  1859,  1860,  1861,  1863,  1862,  1865,  1866,
    1864,  1867,  1867,  1868,  1868,  1869,  1870,  1870,  1872,  1871,
    1873,  1874,  1874,  1876,  1875,  1878,  1877,  1879,  1879,  1880,
    1880,  1882,  1881,  1883,  1883,  1885,  1884,  1886,  1886,  1887,
    1887,  1889,  1888,  1890,  1890,  1891,  1892,  1892,  1893,  1893,
    1893,  1893,  1894,  1894,  1895,  1895,  1895,  1895,  1895,  1896,
    1896,  1897,  1897,  1897,  1898,  1898,  1898,  1899,  1899,  1899,
    1900,  1900,  1901,  1901,  1901,  1903,  1902,  1904,  1905,  1904,
    1906,  1904,  1907,  1907,  1908,  1908,  1909,  1909,  1910,  1910,
    1910,  1910,  1910,  1911,  1911,  1912,  1912,  1913,  1913,  1914,
    1915,  1915,  1917,  1916,  1919,  1918,  1920,  1920,  1921,  1923,
    1922,  1924,  1925,  1925,  1926,  1926,  1926,  1926,  1927,  1927,
    1928,  1928,  1929,  1929,  1930,  1931,  1931,  1931,  1932,  1932,
    1933,  1933,  1933,  1934,  1934,  1935,  1935,  1936,  1936,  1937,
    1939,  1938,  1940,  1941,  1941,  1942,  1942,  1942,  1943,  1943,
    1944,  1945,  1945,  1946,  1947,  1947,  1949,  1948,  1950,  1951,
    1953,  1952,  1954,  1955,  1955,  1957,  1956,  1958,  1959,  1959,
    1960,  1960,  1961,  1961,  1962,  1963,  1965,  1964,  1966,  1964,
    1967,  1968,  1969,  1969,  1970,  1970,  1971,  1972,  1972,  1973,
    1974,  1974,  1975,  1977,  1976,  1978,  1978,  1979,  1980,  1981,
    1981,  1982,  1983,  1983,  1984,  1984,  1984,  1984,  1985,  1985,
    1987,  1986,  1988,  1988,  1988,  1988,  1988,  1988,  1988,  1988,
    1989,  1989,  1990,  1990,  1991,  1992,  1993,  1993,  1994,  1994,
    1994,  1994,  1994,  1994,  1994,  1994,  1995,  1995,  1995,  1995,
    1995,  1996,  1997,  1997,  1998,  1999,  1999,  2000,  2000,  2001,
    2002,  2004,  2003,  2006,  2005,  2007,  2007,  2008,  2008,  2009,
    2009,  2010,  2010,  2011,  2011,  2011,  2012,  2012,  2012,  2014,
    2013,  2015,  2016,  2016,  2017,  2017,  2017,  2017,  2018,  2018,
    2018,  2018,  2018,  2018,  2019,  2019,  2020,  2020,  2021,  2023,
    2022,  2022,  2022,  2022,  2024,  2024,  2024,  2024,  2024,  2025,
    2025,  2026,  2026,  2027,  2027,  2027,  2027,  2029,  2028,  2030,
    2032,  2031,  2033,  2033,  2034,  2035,  2035,  2036,  2036,  2037,
    2037,  2038,  2038,  2040,  2039,  2041,  2041,  2041,  2041,  2042,
    2042,  2044,  2043,  2045,  2045,  2047,  2046,  2048,  2048,  2050,
    2049,  2051,  2053,  2052,  2054,  2056,  2055,  2057,  2058,  2058,
    2059,  2059,  2060,  2061,  2061,  2062,  2063,  2063,  2064,  2064,
    2065,  2065,  2067,  2066,  2068,  2068,  2070,  2069,  2071,  2071,
    2071,  2071,  2071,  2072,  2073,  2073,  2074,  2074,  2074,  2074,
    2074,  2075,  2076,  2076,  2077,  2077,  2077,  2078,  2078,  2078,
    2078,  2079,  2080,  2080,  2081,  2082,  2083,  2083,  2084,  2084,
    2085,  2085,  2087,  2086,  2088,  2089,  2089,  2090,  2090,  2090,
    2090,  2091,  2091,  2092,  2092,  2092,  2093,  2093,  2094,  2096,
    2095,  2098,  2099,  2097,  2100,  2100,  2101,  2101,  2102,  2103,
    2103,  2103,  2104,  2104,  2105,  2105,  2106,  2106,  2107,  2107,
    2108,  2109,  2109,  2110,  2110,  2111,  2111,  2112,  2112,  2113,
    2113,  2114,  2115,  2115,  2116,  2116,  2116,  2117,  2117,  2118,
    2118,  2119,  2119,  2119,  2120,  2120,  2120,  2121,  2121,  2122,
    2122,  2124,  2123,  2126,  2125,  2127,  2127,  2128,  2128,  2129,
    2129,  2130,  2130,  2131,  2131,  2131,  2132,  2132,  2133,  2134,
    2134,  2135,  2135,  2136,  2137,  2137,  2138,  2138,  2138,  2139,
    2139,  2140,  2141,  2141,  2142,  2143,  2143,  2143,  2144,  2144,
    2145,  2146,  2146,  2147,  2148,  2148,  2148,  2149,  2149,  2150,
    2151,  2151,  2152,  2153,  2153,  2154,  2154,  2155,  2155,  2156,
    2157,  2157,  2158,  2159,  2159,  2160,  2160,  2161,  2162,  2162,
    2163,  2164,  2164,  2165,  2165,  2166,  2166,  2167,  2168,  2168,
    2169,  2170,  2170,  2171,  2171,  2172,  2172,  2173,  2173,  2174,
    2174,  2175,  2175,  2176,  2178,  2177,  2179,  2179,  2180,  2180,
    2180,  2180,  2180,  2180,  2180,  2180,  2180,  2180,  2180,  2180,
    2180,  2180,  2180,  2180,  2180,  2180,  2180,  2180,  2180,  2180,
    2181,  2181,  2182,  2184,  2183,  2185,  2185,  2186,  2186,  2186,
    2186,  2186,  2186,  2186,  2186,  2186,  2186,  2186,  2186,  2186,
    2186,  2186,  2186,  2186,  2186,  2186,  2186,  2186,  2187,  2187,
    2188,  2189,  2189,  2189,  2189,  2189,  2189,  2189,  2189,  2189,
    2189,  2189,  2189,  2189,  2189,  2190,  2190,  2191,  2191,  2192,
    2192,  2193,  2194,  2195,  2195,  2196,  2196,  2196,  2197,  2197,
    2197,  2198,  2198,  2198,  2198,  2198,  2198,  2198,  2198,  2198,
    2198,  2199,  2199,  2200,  2200,  2200,  2200,  2201,  2201,  2202,
    2202,  2202,  2202,  2202,  2202,  2203,  2203,  2204,  2205,  2206,
    2206,  2207,  2208,  2208,  2209,  2209,  2210,  2211,  2212,  2213,
    2213,  2214,  2215,  2215,  2216,  2217,  2217,  2218,  2219,  2219,
    2219,  2220,  2221,  2221,  2222,  2223,  2223,  2224,  2224,  2225,
    2226,  2226,  2227,  2228,  2228,  2229,  2229,  2230,  2231,  2232,
    2232,  2233,  2233,  2233,  2234,  2234,  2235,  2235,  2236,  2236,
    2237,  2237,  2238,  2238,  2238,  2238,  2238,  2238,  2238,  2238,
    2238,  2239,  2240,  2240,  2241,  2241,  2241,  2242,  2242,  2242,
    2242,  2242,  2242,  2242,  2243,  2243,  2243,  2243,  2243,  2243,
    2244,  2245,  2246,  2247,  2248,  2248,  2249,  2249,  2250,  2251,
    2251,  2252,  2252,  2253,  2253,  2253,  2254,  2254,  2255,  2255,
    2256,  2256,  2256,  2257,  2257,  2257,  2258,  2258,  2258,  2259,
    2259,  2260,  2260,  2261,  2261,  2262,  2262,  2262,  2263,  2264,
    2265,  2265,  2266,  2267,  2268,  2269,  2270,  2271,  2272,  2272,
    2272,  2272,  2273,  2273,  2274,  2274,  2275,  2276,  2276,  2277,
    2277,  2277,  2277,  2278,  2279,  2280,  2281,  2281,  2283,  2282,
    2284,  2284,  2285,  2286,  2286,  2287,  2288,  2289,  2290,  2290,
    2291,  2291,  2292,  2292,  2292,  2292,  2292,  2292,  2293,  2293,
    2294,  2294,  2295,  2295,  2296,  2296,  2296,  2296,  2297,  2297,
    2297,  2297,  2297,  2297,  2297,  2297,  2297,  2297,  2297,  2297,
    2297,  2297,  2298,  2298,  2299,  2299,  2299,  2299,  2300,  2300,
    2300,  2300,  2300,  2301,  2301,  2301,  2302,  2302,  2302,  2303,
    2303,  2303,  2305,  2304,  2306,  2306,  2307,  2307,  2308,  2308,
    2309,  2309,  2310,  2311,  2311,  2312,  2312,  2312,  2313,  2313,
    2314,  2314,  2315,  2315,  2316,  2316,  2316,  2317,  2317,  2318,
    2318,  2318,  2319,  2319,  2320,  2320,  2321,  2321,  2321,  2321,
    2321,  2321,  2321,  2321,  2322,  2322,  2323,  2323,  2324,  2324,
    2325,  2325,  2325,  2325,  2326,  2326,  2326,  2326,  2326,  2326,
    2326,  2326,  2326,  2326,  2326,  2326,  2326,  2326,  2326,  2326,
    2326,  2326,  2326,  2326,  2326,  2326,  2326,  2326,  2326,  2326,
    2326,  2326,  2326,  2326,  2326,  2326,  2326,  2326,  2326,  2326,
    2326,  2326,  2326,  2326,  2326,  2326,  2326,  2326,  2326,  2326,
    2326,  2326,  2326,  2326,  2326,  2326,  2327,  2327,  2327,  2327,
    2327,  2327,  2327,  2327,  2327,  2327,  2327,  2327,  2327,  2327,
    2327,  2327,  2327,  2327,  2327,  2327,  2327,  2327,  2327,  2328,
    2328,  2329,  2329,  2330,  2331,  2331,  2331,  2332,  2333,  2334,
    2335,  2335,  2335,  2336,  2336,  2336,  2336,  2337,  2337,  2338,
    2338,  2338,  2338,  2338,  2338,  2339,  2339,  2339,  2340,  2340,
    2341,  2341,  2342,  2342,  2343,  2343,  2344,  2344,  2344,  2345,
    2345,  2346,  2346,  2347,  2347,  2348,  2348,  2349,  2349,  2350,
    2350,  2351,  2351,  2352,  2352,  2353,  2353,  2354,  2354,  2355,
    2355,  2356,  2356,  2357,  2357,  2358,  2358,  2359,  2359,  2360,
    2360,  2361,  2361,  2362,  2362,  2363,  2363,  2364,  2364,  2364,
    2365,  2365,  2365,  2366,  2366,  2367,  2367,  2368,  2368,  2369,
    2369,  2370,  2370,  2371,  2371,  2371,  2372,  2372,  2372,  2373,
    2373,  2373,  2373,  2374,  2374,  2374,  2375,  2375,  2376,  2376,
    2377,  2377,  2377,  2378,  2378,  2378,  2379,  2379,  2380,  2380,
    2381,  2381,  2382,  2382,  2383,  2383,  2384,  2384,  2385,  2385,
    2386,  2386,  2387,  2387,  2388,  2388,  2388,  2389,  2389,  2389,
    2389,  2390,  2390,  2391,  2391,  2392,  2392,  2393,  2393,  2394,
    2394,  2395,  2395,  2396,  2396,  2396,  2397,  2397,  2398,  2398,
    2399,  2399,  2400,  2400,  2400,  2401,  2401,  2402,  2402,  2403,
    2403,  2404,  2404,  2405,  2405,  2406,  2406,  2407,  2407,  2408,
    2408,  2409,  2409,  2410,  2410,  2411,  2411,  2412,  2412,  2413,
    2413,  2414,  2414,  2414,  2415,  2415,  2416,  2416,  2417,  2417,
    2418,  2418,  2419,  2419,  2420,  2420,  2421,  2421,  2422,  2422,
    2422,  2422,  2423,  2423,  2424,  2424,  2425,  2425,  2426,  2426,
    2427,  2427,  2428,  2428,  2429,  2429,  2430,  2430,  2430,  2431,
    2431,  2432,  2432,  2433,  2433,  2434,  2434,  2435,  2435,  2436,
    2436,  2437,  2437,  2438,  2438,  2439,  2439,  2440,  2440,  2441,
    2441,  2442,  2442,  2443,  2443,  2444,  2444
};

  /* YYR2[YYN] -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     2,     1,     1,     0,     3,     1,     2,
       1,     1,     1,     1,     0,     2,     4,     4,     0,     1,
       1,     2,     0,     4,     0,     4,     0,     0,    14,     0,
       0,    14,     0,     0,     6,     1,     0,     0,     5,     0,
       0,     5,     0,     3,     0,     0,     4,     0,     0,     4,
       0,     0,     6,     0,     1,     0,     4,     1,     1,     1,
       6,     1,     5,     1,     1,     1,     1,     0,     2,     0,
       3,     1,     1,     1,     1,     2,     2,     1,     1,     0,
       3,     5,     0,     3,     1,     1,     1,     1,     0,     5,
       0,     3,     1,     1,     1,     0,     4,     1,     1,     1,
       1,     3,     0,     1,     1,     3,     2,     0,     1,     1,
       3,     0,     1,     1,     2,     1,     1,     1,     1,     1,
       0,     1,     0,     4,     0,     3,     0,     3,     0,     4,
       0,     2,     3,     2,     1,     2,     1,     1,     1,     1,
       5,     2,     3,     2,     3,     4,     4,     8,     8,     3,
       4,     1,     1,     1,     1,     1,     2,     0,     1,     0,
       4,     0,     2,     3,     1,     2,     3,     3,     3,     3,
       3,     1,     2,     2,     2,     1,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     3,     1,     1,     2,     3,     3,
       1,     0,     1,     1,     3,     4,     0,     4,     0,     4,
       0,     4,     0,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     1,     1,     2,     1,
       3,     0,     4,     1,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     2,     2,     0,     2,     2,     4,
       1,     2,     3,     1,     2,     1,     2,     3,     1,     2,
       3,     6,     1,     2,     1,     3,     4,     0,     4,     1,
       1,     5,     0,     3,     3,     5,     3,     4,     3,     3,
       0,     4,     4,     1,     0,     3,     0,     2,     0,     2,
       0,     0,     6,     2,     2,     0,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     5,     5,     6,
       6,     4,     0,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     0,     1,     1,     1,     1,     1,
       4,     1,     1,     1,     9,     0,     1,     0,     4,     1,
       0,     4,     3,     1,     3,     2,     3,     4,     4,     8,
       8,     6,     1,     1,     1,     1,     1,     1,     5,     0,
       1,     1,     0,     5,     2,     2,     2,     0,     5,     6,
       1,     0,     1,     2,     0,     2,     3,     1,     1,     3,
       1,     2,     4,     0,     5,     1,     1,     1,     1,     7,
       0,     2,     1,     2,     0,     2,     2,     1,     4,     3,
       1,     1,     3,     2,     2,     2,     3,     3,     4,     4,
       4,     4,     4,     0,     2,     2,     0,     2,     3,     1,
       2,     1,     1,     1,     1,     5,     0,     1,     1,     1,
       4,     4,     4,     4,     1,     6,     6,     7,     4,     6,
       4,     6,     4,     0,     6,     1,     2,     2,     0,     2,
       6,     2,     2,     3,     0,     1,     5,     2,     0,     1,
       2,     3,     1,     2,     1,     1,     1,     0,    10,     0,
       1,     1,     3,     1,     0,     3,     0,     2,     2,     0,
       5,     3,     1,     1,     0,     2,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     5,     0,     1,
       1,     4,     7,     9,     0,     3,     0,     2,     0,     2,
       3,     5,     5,     1,     1,     1,     1,     3,     5,     0,
       2,     1,     1,     1,     4,     2,     2,     4,     1,     1,
       1,     1,     1,     1,     1,     4,     0,     2,     2,     2,
       2,     1,     2,     1,     0,     0,     5,     0,     2,     2,
       1,     0,     5,     0,     2,     4,     3,     4,     0,     1,
       1,     1,     2,     4,     4,     4,     4,     4,     4,     4,
       4,     4,     4,     4,    11,     0,     1,     1,     2,     4,
       4,     4,     6,     4,     3,     4,     0,     1,     1,     1,
       2,     4,     4,     4,     4,     4,     4,     6,     1,     0,
       0,     5,     0,     0,     2,     2,     3,     1,     1,     1,
       0,     4,     4,     2,     2,     0,     1,     1,     1,     1,
       0,     2,     1,     2,     3,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     6,
       0,     2,     0,     4,     0,     1,     5,     0,     7,     2,
       2,     1,     3,     1,     1,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     1,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     3,     0,     1,     3,     3,     3,     0,     1,     3,
       0,     2,     0,     1,     2,     0,     4,     1,     2,     1,
       1,     0,     4,     1,     1,     3,     1,     1,     1,     1,
       0,     3,     0,     5,     3,     1,     0,     2,     1,     3,
       2,     3,     3,     3,     2,     3,     0,     2,     1,     1,
       1,     1,     1,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     3,     2,     1,     3,     3,     4,     3,     3,     3,
       4,     3,     3,     1,     1,     1,     1,     1,     1,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     2,     0,
       2,     3,     0,     1,     2,     3,     0,     2,     0,     1,
       1,     1,     1,     0,     1,     1,     1,     1,     1,     1,
       0,     1,     3,     3,     2,     6,     0,     2,     6,     8,
       7,     0,     2,     0,     2,     0,     2,     0,     3,     0,
       3,     0,     1,     0,     2,     0,     3,     1,     1,     1,
       1,     2,     4,     1,     1,     0,     1,     3,     1,     2,
       1,     2,     2,     0,     1,     1,     3,     1,     3,     3,
       4,     4,     3,     1,     2,     3,     4,     4,     2,     0,
       2,     3,     0,     1,     3,     3,     1,     3,     2,     2,
       1,     2,     1,     2,     0,     4,     1,     1,     2,     3,
       1,     0,     1,     1,     4,     3,     1,     1,     0,     2,
       7,     2,     3,     0,     2,     2,     2,     3,     1,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     3,     3,
       3,     2,     2,     2,     4,     1,     0,     0,     5,     1,
       0,     0,     5,     0,     0,     0,     6,     0,     2,     0,
       0,     7,     0,     2,     2,     2,     4,     1,     1,     2,
       2,     1,     1,     1,     1,     2,     1,     4,     2,     1,
       3,     2,     1,     1,     0,     2,     1,     1,     1,     1,
       1,     3,     3,     4,     4,     4,     3,     0,     2,     0,
       5,     3,     0,     2,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     1,     1,     3,     3,     1,     1,     1,     0,
       2,     2,     0,     2,     0,     2,     2,     1,     3,     1,
       2,     1,     1,     1,     1,     4,     0,     3,     2,     1,
       1,     3,     4,     5,     4,     5,     1,     1,     0,     2,
       1,     1,     1,     2,     1,     2,     3,     0,     2,     0,
       2,     2,     3,     2,     0,     2,     1,     2,     2,     4,
       0,     1,     1,     1,     1,     2,     1,     1,     2,     1,
       4,     2,     0,     0,     0,     6,     0,     1,     2,     3,
       1,     0,     4,     0,     0,     7,     3,     0,     2,     2,
       2,     1,     1,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     3,     3,     3,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     4,     1,     1,
       2,     3,     2,     2,     2,     3,     3,     3,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     2,     2,
       2,     0,     2,     1,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     0,     1,     1,     2,     1,
       3,     5,     3,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     3,     3,     1,     2,     3,     3,
       3,     1,     2,     1,     2,     0,     1,     1,     1,     1,
       1,     1,     1,     2,     1,     1,     0,     1,     4,     0,
       1,     1,     4,     0,     1,     1,     3,     2,     0,     2,
       0,     1,     0,     0,     0,    12,     0,     4,     0,     0,
       3,     0,     3,     1,     2,     5,     0,     2,     2,     0,
       1,     3,     3,     4,     2,     1,     3,     0,     5,     0,
       1,     0,     2,     2,     0,     0,     0,     0,     9,     0,
       2,     1,     1,     0,     3,     1,     1,     1,     1,     0,
       6,     0,     2,     2,     2,     0,     1,     0,     0,     3,
       0,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     3,
       2,     0,     4,     0,     4,     0,     5,     3,     3,     3,
       3,     4,     3,     4,     3,     3,     4,     4,     4,     3,
       3,     4,     3,     4,     5,     3,     4,     3,     3,     2,
       3,     1,     1,     0,     3,     0,     1,     5,     4,     4,
       1,     3,     3,     1,     1,     0,     1,     1,     2,     1,
       1,     1,     2,     3,     1,     2,     1,     3,     1,     2,
       0,     3,     0,     3,     2,     3,     3,     3,     1,     1,
       1,     2,     1,     3,     3,     1,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     4,     1,     1,     1,     1,     4,     2,     1,     1,
       3,     3,     3,     3,     3,     4,     0,     1,     1,     2,
       1,     1,     1,     1,     1,     1,     1,     0,     1,     0,
       4,     4,     5,     6,     8,     0,     2,     0,     1,     0,
       3,     4,     5,     0,     2,     0,     2,     0,     3,     1,
       2,     4,     0,     2,     0,     4,     0,     9,     0,     0,
       4,     1,     1,     1,     0,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     2,     0,     2,     1,     1,     0,
       0,     3,     1,     2,     2,     2,     3,     0,     2,     2,
       2,     0,     3,     2,     2,     4,     1,     1,     1,     1,
       0,     2,     2,     0,     1,     2,     2,     0,     1,     2,
       0,     1,     0,     3,     1,     1,     1,     2,     1,     1,
       0,     3,     1,     1,     2,     3,     0,     3,     2,     1,
       3,     4,     0,     4,     0,     3,     0,     4,     4,     0,
       1,     1,     0,     3,     0,     0,     4,     0,     3,     2,
       1,     0,     4,     4,     3,     1,     2,     0,     1,     0,
       3,     3,     0,     3,     0,     2,     1,     2,     1,     0,
       4,     3,     3,     3,     3,     2,     4,     1,     1,     1,
       1,     1,     1,     2,     1,     1,     2,     0,     3,     1,
       1,     0,     2,     1,     2,     1,     2,     1,     2,     1,
       1,     2,     0,     1,     2,     2,     2,     2,     1,     1,
       0,     3,     2,     0,     3,     1,     2,     1,     1,     1,
       0,     5,     0,     1,     1,     2,     3,     3,     3,     3,
       2,     0,     0,     5,     1,     1,     0,     0,     7,     0,
       5,     1,     1,     1,     0,     1,     0,     2,     1,     2,
       1,     1,     2,     1,     2,     1,     5,     1,     1,     1,
       2,     1,     1,     0,     1,     1,     1,     1,     0,     1,
       3,     3,     1,     1,     4,     3,     1,     2,     2,     1,
       3,     3,     1,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     1,     3,     3,     3,     3,
       1,     1,     0,     1,     0,     4,     4,     6,     6,     8,
       8,     0,     1,     0,     3,     1,     0,     3,     0,     6,
       4,     0,     4,     2,     1,     3,     1,     1,     1,     2,
       1,     1,     2,     1,     2,     2,     2,     2,     2,     2,
       2,     1,     2,     3,     1,     3,     2,     1,     1,     1,
       1,     0,     2,     0,     1,     0,     3,     0,     7,     0,
       1,     0,     1,     0,     1,     1,     2,     1,     1,     0,
       3,     0,     2,     1,     2,     1,     1,     1,     0,     2,
       2,     3,     0,     3,     1,     0,     3,     1,     0,     3,
       3,     4,     0,     3,     0,     3,     0,     6,     1,     5,
       3,     2,     0,     1,     0,     0,     0,     1,     0,     3,
       5,     0,     2,     0,     3,     3,     0,     2,     1,     2,
       4,     1,     1,     1,     1,     1,     1,     1,     0,     3,
       0,     3,     1,     2,     0,     3,     2,     2,     0,     3,
       3,     0,     1,     1,     1,     1,     2,     1,     1,     1,
       0,     4,     0,     5,     5,     1,     1,     2,     1,     1,
       1,     2,     0,     3,     1,     1,     0,     3,     2,     5,
       1,     2,     2,     2,     1,     1,     1,     2,     1,     2,
       4,     2,     0,     1,     1,     1,     1,     4,     0,     1,
       1,     2,     2,     3,     3,     1,     0,     5,     0,     0,
       9,     0,     2,     1,     2,     1,     0,     1,     0,     5,
       7,     0,     2,     0,     3,     0,     4,     2,     2,     0,
       1,     0,     3,     3,     4,     0,     4,     4,     6,     0,
       1,     0,     3,     1,     2,     6,     0,     1,     1,     1,
       1,     1,     0,     3,     0,     1,     1,     2,     1,     2,
       2,     1,     1,     1,     2,     1,     1,     1,     1,     1,
       3,     1,     1,     1,     1,     0,     3,     4,     0,     6,
       0,     5,     0,     1,     1,     1,     1,     3,     0,     2,
       1,     3,     3,     0,     3,     1,     1,     1,     3,     6,
       0,     2,     0,     3,     0,     3,     2,     1,     1,     0,
       4,     7,     0,     2,     0,     1,     2,     1,     2,     3,
       3,     1,     0,     1,     1,     4,     4,     2,     0,     1,
       1,     3,     2,     0,     3,     1,     1,     0,     1,     1,
       0,     4,     5,     1,     1,     0,     2,     2,     0,     1,
       2,     0,     1,     2,     0,     1,     0,     3,     2,     1,
       0,     4,     4,     0,     1,     0,     4,     5,     0,     1,
       2,     3,     0,     1,     1,     1,     0,     4,     0,     5,
       4,     5,     0,     2,     0,     3,     0,     1,     2,     3,
       0,     2,     0,     0,     3,     2,     1,     5,     1,     0,
       1,     2,     2,     5,     2,     2,     2,     2,     0,     2,
       0,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     4,     3,     1,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     4,     7,     7,     3,
       5,     4,     1,     2,     3,     1,     2,     3,     3,     4,
       4,     0,     3,     0,     7,     0,     5,     0,     2,     0,
       3,     0,     1,     0,     2,     4,     0,     2,     4,     0,
       4,     4,     0,     3,     0,     4,     1,     1,     1,     2,
       2,     2,     2,     1,     2,     1,     0,     1,     1,     0,
       4,     2,     2,     2,     0,     2,     1,     4,     4,     0,
       1,     1,     1,     1,     1,     1,     1,     0,     4,     5,
       0,     2,     1,     2,     2,     0,     3,     1,     1,     0,
       4,     0,     1,     0,     4,     4,     6,     6,     8,     0,
       1,     0,     3,     0,     1,     0,     3,     1,     2,     0,
       3,     6,     0,     3,     2,     0,     4,     6,     0,     3,
       1,     3,     2,     2,     2,     3,     0,     3,     0,     3,
       0,     1,     0,     3,     1,     2,     0,     3,     1,     1,
       1,     1,     1,     7,     0,     1,     1,     1,     1,     1,
       1,     4,     1,     2,     1,     2,     3,     0,     1,     2,
       1,     3,     1,     1,     4,     2,     1,     2,     1,     2,
       1,     1,     0,     4,     6,     0,     2,     0,     4,     3,
       3,     1,     1,     0,     1,     1,     0,     1,     1,     0,
       5,     0,     0,    12,     0,     1,     1,     2,     2,     2,
       1,     1,     0,     4,     0,     3,     0,     3,     1,     2,
       3,     0,     3,     1,     2,     3,     3,     0,     3,     1,
       2,     3,     0,     1,     1,     1,     1,     0,     2,     1,
       2,     1,     2,     2,     2,     2,     1,     1,     3,     0,
       1,     0,     5,     0,    10,     0,     3,     0,     2,     0,
       3,     1,     2,     0,     2,     2,     0,     1,     3,     1,
       1,     0,     1,     2,     1,     1,     0,     2,     2,     0,
       1,     2,     0,     1,     2,     0,     2,     2,     0,     1,
       2,     0,     1,     2,     0,     2,     2,     0,     1,     2,
       0,     1,     2,     2,     2,     2,     2,     0,     1,     2,
       0,     1,     2,     2,     2,     0,     1,     2,     0,     1,
       2,     0,     1,     2,     2,     0,     1,     2,     0,     1,
       2,     0,     2,     0,     3,     2,     1,     0,     2,     0,
       3,     1,     1,     1,     0,     2,     1,     2,     1,     2,
       3,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     2,     1,     2,     1,     1,     2,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     2,     1,     1,     1,
       1,     1,     1,     1,     3,     0,     1,     1,     3,     3,
       1,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       1,     3,     1,     2,     2,     2,     1,     3,     1,     1,
       3,     1,     3,     1,     3,     1,     2,     2,     1,     1,
       2,     1,     1,     2,     2,     3,     1,     1,     1,     1,
       2,     1,     1,     2,     1,     0,     2,     1,     1,     1,
       3,     1,     1,     2,     1,     0,     1,     1,     2,     1,
       1,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       2,     1,     1,     3,     0,     1,     1,     2,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     2,     4,     3,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     1,
       1,     2,     2,     2,     1,     1,     1,     2,     2,     2,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     1,     1,     1,     1,     1,     1,     3,     2,
       2,     1,     1,     2,     1,     2,     1,     1,     1,     3,
       2,     2,     1,     1,     1,     1,     1,     3,     0,     2,
       1,     3,     3,     4,     5,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       1,     3,     1,     1,     1,     1,     1,     1,     2,     5,
       5,     5,     5,     6,     5,     5,     5,     5,     5,     5,
       3,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     0,     4,     5,     0,     3,     2,     1,
       3,     3,     0,     2,     1,     3,     1,     3,     1,     3,
       1,     3,     0,     0,     1,     0,     3,     2,     0,     1,
       0,     2,     0,     2,     0,     1,     1,     0,     1,     0,
       1,     2,     0,     2,     0,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     2,     0,     5,     0,     3,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     0,     1,
       0,     1,     0,     1,     0,     1,     0,     1,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     3,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     0,     1,     1,
       0,     1,     2,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     1,     0,     1,     1,     0,
       1,     1,     1,     0,     1,     1,     0,     1,     0,     1,
       0,     1,     1,     0,     2,     2,     0,     1,     0,     1,
       0,     1,     0,     1,     0,     1,     0,     1,     1,     1,
       0,     1,     0,     1,     0,     1,     1,     0,     2,     1,
       1,     0,     1,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     1,     0,     1,     0,     1,
       0,     1,     0,     1,     2,     0,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     0,     1,     0,     3,     0,
       1,     0,     1,     1,     0,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     1,     2,     1,     2,     1,     2,
       1,     2,     1,     2,     1,     2,     2
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)

/* This macro is provided for backward compatibility. */
# ifndef YY_LOCATION_PRINT
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif


# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yykind < YYNTOKENS)
    YYPRINT (yyo, yytoknum[yykind], *yyvaluep);
# endif
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif


/* Context of a parse error.  */
typedef struct
{
  yy_state_t *yyssp;
  yysymbol_kind_t yytoken;
} yypcontext_t;

/* Put in YYARG at most YYARGN of the expected tokens given the
   current YYCTX, and return the number of tokens stored in YYARG.  If
   YYARG is null, return the number of expected tokens (guaranteed to
   be less than YYNTOKENS).  Return YYENOMEM on memory exhaustion.
   Return 0 if there are more than YYARGN expected tokens, yet fill
   YYARG up to YYARGN. */
static int
yypcontext_expected_tokens (const yypcontext_t *yyctx,
                            yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  int yyn = yypact[+*yyctx->yyssp];
  if (!yypact_value_is_default (yyn))
    {
      /* Start YYX at -YYN if negative to avoid negative indexes in
         YYCHECK.  In other words, skip the first -YYN actions for
         this state because they are default actions.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;
      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yyx;
      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
        if (yycheck[yyx + yyn] == yyx && yyx != YYSYMBOL_YYerror
            && !yytable_value_is_error (yytable[yyx + yyn]))
          {
            if (!yyarg)
              ++yycount;
            else if (yycount == yyargn)
              return 0;
            else
              yyarg[yycount++] = YY_CAST (yysymbol_kind_t, yyx);
          }
    }
  if (yyarg && yycount == 0 && 0 < yyargn)
    yyarg[0] = YYSYMBOL_YYEMPTY;
  return yycount;
}




#ifndef yystrlen
# if defined __GLIBC__ && defined _STRING_H
#  define yystrlen(S) (YY_CAST (YYPTRDIFF_T, strlen (S)))
# else
/* Return the length of YYSTR.  */
static YYPTRDIFF_T
yystrlen (const char *yystr)
{
  YYPTRDIFF_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
# endif
#endif

#ifndef yystpcpy
# if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#  define yystpcpy stpcpy
# else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
yystpcpy (char *yydest, const char *yysrc)
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
# endif
#endif

#ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYPTRDIFF_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYPTRDIFF_T yyn = 0;
      char const *yyp = yystr;
      for (;;)
        switch (*++yyp)
          {
          case '\'':
          case ',':
            goto do_not_strip_quotes;

          case '\\':
            if (*++yyp != '\\')
              goto do_not_strip_quotes;
            else
              goto append;

          append:
          default:
            if (yyres)
              yyres[yyn] = *yyp;
            yyn++;
            break;

          case '"':
            if (yyres)
              yyres[yyn] = '\0';
            return yyn;
          }
    do_not_strip_quotes: ;
    }

  if (yyres)
    return yystpcpy (yyres, yystr) - yyres;
  else
    return yystrlen (yystr);
}
#endif


static int
yy_syntax_error_arguments (const yypcontext_t *yyctx,
                           yysymbol_kind_t yyarg[], int yyargn)
{
  /* Actual size of YYARG. */
  int yycount = 0;
  /* There are many possibilities here to consider:
     - If this state is a consistent state with a default action, then
       the only way this function was invoked is if the default action
       is an error action.  In that case, don't check for expected
       tokens because there are none.
     - The only way there can be no lookahead present (in yychar) is if
       this state is a consistent state with a default action.  Thus,
       detecting the absence of a lookahead is sufficient to determine
       that there is no unexpected or expected token to report.  In that
       case, just report a simple "syntax error".
     - Don't assume there isn't a lookahead just because this state is a
       consistent state with a default action.  There might have been a
       previous inconsistent state, consistent state with a non-default
       action, or user semantic action that manipulated yychar.
     - Of course, the expected token list depends on states to have
       correct lookahead information, and it depends on the parser not
       to perform extra reductions after fetching a lookahead from the
       scanner and before detecting a syntax error.  Thus, state merging
       (from LALR or IELR) and default reductions corrupt the expected
       token list.  However, the list is correct for canonical LR with
       one exception: it will still contain any token that will not be
       accepted due to an error action in a later state.
  */
  if (yyctx->yytoken != YYSYMBOL_YYEMPTY)
    {
      int yyn;
      if (yyarg)
        yyarg[yycount] = yyctx->yytoken;
      ++yycount;
      yyn = yypcontext_expected_tokens (yyctx,
                                        yyarg ? yyarg + 1 : yyarg, yyargn - 1);
      if (yyn == YYENOMEM)
        return YYENOMEM;
      else
        yycount += yyn;
    }
  return yycount;
}

/* Copy into *YYMSG, which is of size *YYMSG_ALLOC, an error message
   about the unexpected token YYTOKEN for the state stack whose top is
   YYSSP.

   Return 0 if *YYMSG was successfully written.  Return -1 if *YYMSG is
   not large enough to hold the message.  In that case, also set
   *YYMSG_ALLOC to the required number of bytes.  Return YYENOMEM if the
   required number of bytes is too large to store.  */
static int
yysyntax_error (YYPTRDIFF_T *yymsg_alloc, char **yymsg,
                const yypcontext_t *yyctx)
{
  enum { YYARGS_MAX = 5 };
  /* Internationalized format string. */
  const char *yyformat = YY_NULLPTR;
  /* Arguments of yyformat: reported tokens (one for the "unexpected",
     one per "expected"). */
  yysymbol_kind_t yyarg[YYARGS_MAX];
  /* Cumulated lengths of YYARG.  */
  YYPTRDIFF_T yysize = 0;

  /* Actual size of YYARG. */
  int yycount = yy_syntax_error_arguments (yyctx, yyarg, YYARGS_MAX);
  if (yycount == YYENOMEM)
    return YYENOMEM;

  switch (yycount)
    {
#define YYCASE_(N, S)                       \
      case N:                               \
        yyformat = S;                       \
        break
    default: /* Avoid compiler warnings. */
      YYCASE_(0, YY_("syntax error"));
      YYCASE_(1, YY_("syntax error, unexpected %s"));
      YYCASE_(2, YY_("syntax error, unexpected %s, expecting %s"));
      YYCASE_(3, YY_("syntax error, unexpected %s, expecting %s or %s"));
      YYCASE_(4, YY_("syntax error, unexpected %s, expecting %s or %s or %s"));
      YYCASE_(5, YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s"));
#undef YYCASE_
    }

  /* Compute error message size.  Don't count the "%s"s, but reserve
     room for the terminator.  */
  yysize = yystrlen (yyformat) - 2 * yycount + 1;
  {
    int yyi;
    for (yyi = 0; yyi < yycount; ++yyi)
      {
        YYPTRDIFF_T yysize1
          = yysize + yytnamerr (YY_NULLPTR, yytname[yyarg[yyi]]);
        if (yysize <= yysize1 && yysize1 <= YYSTACK_ALLOC_MAXIMUM)
          yysize = yysize1;
        else
          return YYENOMEM;
      }
  }

  if (*yymsg_alloc < yysize)
    {
      *yymsg_alloc = 2 * yysize;
      if (! (yysize <= *yymsg_alloc
             && *yymsg_alloc <= YYSTACK_ALLOC_MAXIMUM))
        *yymsg_alloc = YYSTACK_ALLOC_MAXIMUM;
      return -1;
    }

  /* Avoid sprintf, as that infringes on the user's name space.
     Don't have undefined behavior even if the translation
     produced a string with the wrong number of "%s"s.  */
  {
    char *yyp = *yymsg;
    int yyi = 0;
    while ((*yyp = *yyformat) != '\0')
      if (*yyp == '%' && yyformat[1] == 's' && yyi < yycount)
        {
          yyp += yytnamerr (yyp, yytname[yyarg[yyi++]]);
          yyformat += 2;
        }
      else
        {
          ++yyp;
          ++yyformat;
        }
  }
  return 0;
}


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;

  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYPTRDIFF_T yymsg_alloc = sizeof yymsgbuf;

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    goto yyexhaustedlab;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= TOKEN_EOF)
    {
      yychar = TOKEN_EOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* $@1: %empty  */
#line 3571 "parser.y"
  {
	const char *backup_source_file = cb_source_file;

	clear_initial_values ();
	defined_prog_list = NULL;
	cobc_cs_check = 0;
	main_flag_set = 0;

	clear_initial_values ();
	current_program = cb_build_program (NULL, 0);

	cb_source_file = "register-definition";
	cb_set_intr_when_compiled ();
	cb_build_registers ();
	cb_add_external_defined_registers ();
	cb_source_file = backup_source_file;
  }
#line 15407 "parser.c"
    break;

  case 3: /* start: $@1 compilation_group  */
#line 3589 "parser.y"
  {
	if (!current_program->flag_validated) {
		current_program->flag_validated = 1;
		cb_validate_program_body (current_program);
	}
	if (depth > 1) {
		cb_error (_("multiple PROGRAM-ID's without matching END PROGRAM"));
	}
	if (cobc_flag_main && !main_flag_set) {
		cb_error (_("executable requested but no program found"));
	}
	if (errorcount > 0) {
		YYABORT;
	}
	if (!current_program->entry_list) {
		emit_main_entry (current_program, NULL);
	}
  }
#line 15430 "parser.c"
    break;

  case 6: /* $@2: %empty  */
#line 3616 "parser.y"
  {
	first_prog = 1;
	depth = 0;
	setup_from_identification = 0;
  }
#line 15440 "parser.c"
    break;

  case 14: /* $@3: %empty  */
#line 3638 "parser.y"
  {
	program_init_without_program_id ();
  }
#line 15448 "parser.c"
    break;

  case 15: /* simple_prog: $@3 _program_body  */
#line 3643 "parser.y"
  {
	last_source_line = cb_source_line;
	clean_up_program (NULL, COB_MODULE_TYPE_PROGRAM);
  }
#line 15457 "parser.c"
    break;

  case 18: /* _end_program_list: %empty  */
#line 3669 "parser.y"
  {
	last_source_line = cb_source_line;
	clean_up_program (NULL, COB_MODULE_TYPE_PROGRAM);
  }
#line 15466 "parser.c"
    break;

  case 22: /* $@4: %empty  */
#line 3683 "parser.y"
  {
	last_source_line = cb_source_line;
	check_area_a_of ("END PROGRAM");
  }
#line 15475 "parser.c"
    break;

  case 23: /* end_program: "END PROGRAM" $@4 end_program_name _dot  */
#line 3688 "parser.y"
  {
	first_nested_program = 0;
	clean_up_program (yyvsp[-1], COB_MODULE_TYPE_PROGRAM);
  }
#line 15484 "parser.c"
    break;

  case 24: /* $@5: %empty  */
#line 3696 "parser.y"
  {
	last_source_line = cb_source_line;
	check_area_a_of ("END FUNCTION");
  }
#line 15493 "parser.c"
    break;

  case 25: /* end_function: "END FUNCTION" $@5 end_program_name _dot  */
#line 3701 "parser.y"
  {
	clean_up_program (yyvsp[-1], COB_MODULE_TYPE_FUNCTION);
  }
#line 15501 "parser.c"
    break;

  case 26: /* $@6: %empty  */
#line 3711 "parser.y"
  {
	/* Error if program_id_name is a literal */

	/* Check that we either have no previous program or it was also a prototype */
	if (current_program->next_program && !current_program->flag_prototype) {
		/* Technically, prototypes must come before all other *source units*.  */
		cb_error (_("prototypes must be come before any program/function definitions"));
	}

	if (setup_program (yyvsp[-4], yyvsp[-3], COB_MODULE_TYPE_PROGRAM, 1)) {
		YYABORT;
	}
	setup_prototype (yyvsp[-4], yyvsp[-3], COB_MODULE_TYPE_PROGRAM, 1);
	cobc_cs_check = 0;
	cobc_in_id = 0;

	CB_UNFINISHED ("PROGRAM PROTOTYPE");

	/*
	 Must record:
	  * externalised name
	  * type of source unit (program/function/class/interface)
	  * description of parameters, whether they are BY REFERENCE or BY VALUE, whether they are OPTIONAL
	  * description of return item
	  * exceptions that may be raised
	  * entry convention
	  * object properties
	  * methods contained
	  * type declarations required
	  * whether DECIMAL-POINT IS COMMA is required
	  * CURRENCY SYMBOLS and their corresponding currency strings
	  * any external locales associated with linkage items
	 */
  }
#line 15540 "parser.c"
    break;

  case 27: /* $@7: %empty  */
#line 3746 "parser.y"
  {
	if (!current_program->entry_convention) {
		current_program->entry_convention = cb_int (CB_CONV_COBOL);
	}
  }
#line 15550 "parser.c"
    break;

  case 28: /* program_prototype: _identification_header program_id_header "." program_id_name _as_literal _is PROTOTYPE _dot $@6 _prototype_environment_division $@7 _prototype_data_division _prototype_procedure_division_header end_program  */
#line 3754 "parser.y"
  {
	cb_check_definition_matches_prototype (current_program);

	/* Write information to external repository, if permitted */
  }
#line 15560 "parser.c"
    break;

  case 29: /* $@8: %empty  */
#line 3766 "parser.y"
  {
	/* Error if program_id_name is a literal */

	if (setup_program (yyvsp[-4], yyvsp[-3], COB_MODULE_TYPE_FUNCTION, 1)) {
		YYABORT;
	}
	setup_prototype (yyvsp[-4], yyvsp[-3], COB_MODULE_TYPE_FUNCTION, 1);
	cobc_cs_check = 0;
	cobc_in_id = 0;

	CB_UNFINISHED ("FUNCTION PROTOTYPE");

	/*
	 Must record:
	  * externalised name
	  * type of source unit (program/function/class/interface)
	  * description of parameters, whether they are BY REFERENCE or BY VALUE, whether they are OPTIONAL
	  * description of return item
	  * exceptions that may be raised
	  * entry convention
	  * object properties
	  * methods contained
	  * type declarations required
	  * whether DECIMAL-POINT IS COMMA is required
	  * CURRENCY SYMBOLS and their corresponding currency strings
	  * any external locales associated with linkage items
	 */
  }
#line 15593 "parser.c"
    break;

  case 30: /* $@9: %empty  */
#line 3795 "parser.y"
  {
	if (!current_program->entry_convention) {
		current_program->entry_convention = cb_int (CB_CONV_COBOL);
	}
  }
#line 15603 "parser.c"
    break;

  case 31: /* function_prototype: _identification_header function_id_header "." program_id_name _as_literal _is PROTOTYPE _dot $@8 _prototype_environment_division $@9 _prototype_data_division _prototype_procedure_division_header end_function  */
#line 3803 "parser.y"
  {
	cb_check_definition_matches_prototype (current_program);

	/* Write information to external repository, if permitted */
  }
#line 15613 "parser.c"
    break;

  case 33: /* $@10: %empty  */
#line 3812 "parser.y"
            { check_area_a_of ("PROCEDURE DIVISION"); }
#line 15619 "parser.c"
    break;

  case 34: /* _prototype_procedure_division_header: PROCEDURE $@10 DIVISION _procedure_using_chaining _procedure_returning _dot  */
#line 3814 "parser.y"
  {
	cb_validate_parameters_and_returning (current_program, yyvsp[-2]);
	current_program->num_proc_params = cb_list_length (yyvsp[-2]);
	/* add pseudo-entry as it contains the actual USING parameters */
	emit_main_entry (current_program, yyvsp[-2]);
  }
#line 15630 "parser.c"
    break;

  case 35: /* control: CONTROL  */
#line 3824 "parser.y"
                 { check_area_a_of ("CONTROL DIVISION"); }
#line 15636 "parser.c"
    break;

  case 37: /* $@11: %empty  */
#line 3828 "parser.y"
  {
	  cb_verify (cb_control_division, "CONTROL DIVISION");
  }
#line 15644 "parser.c"
    break;

  case 40: /* $@12: %empty  */
#line 3836 "parser.y"
          { check_area_a_of ("DEFAULT SECTION"); }
#line 15650 "parser.c"
    break;

  case 41: /* _default_section: DEFAULT $@12 SECTION "." _default_clauses  */
#line 3839 "parser.y"
  {
	cobc_cs_check = 0;
  }
#line 15658 "parser.c"
    break;

  case 45: /* $@13: %empty  */
#line 3853 "parser.y"
          { check_non_area_a (yyvsp[0]); }
#line 15664 "parser.c"
    break;

  case 46: /* _default_accept_clause: ACCEPT $@13 _is word_or_terminal  */
#line 3855 "parser.y"
  {
	  CB_PENDING ("ACCEPT statement in DEFAULT SECTION");
	  /* TODO: setup_default_accept ($3); */
  }
#line 15673 "parser.c"
    break;

  case 48: /* $@14: %empty  */
#line 3863 "parser.y"
          { check_non_area_a (yyvsp[0]); }
#line 15679 "parser.c"
    break;

  case 49: /* _default_display_clause: DISPLAY $@14 _is word_or_terminal  */
#line 3865 "parser.y"
  {
	  CB_PENDING ("DISPLAY statement in DEFAULT SECTION");
	  /* TODO: setup_default_display ($3); */
  }
#line 15688 "parser.c"
    break;

  case 50: /* $@15: %empty  */
#line 3876 "parser.y"
  {
	cb_validate_program_environment (current_program);
  }
#line 15696 "parser.c"
    break;

  case 51: /* $@16: %empty  */
#line 3880 "parser.y"
  {
	/* note:
	   we also validate all references we found so far here */
	cb_validate_program_data (current_program);
	within_typedef_definition = 0;
  }
#line 15707 "parser.c"
    break;

  case 55: /* $@17: %empty  */
#line 3897 "parser.y"
                       { check_area_a_of ("IDENTIFICATION DIVISION"); }
#line 15713 "parser.c"
    break;

  case 56: /* identification_header: identification_or_id $@17 DIVISION _dot  */
#line 3899 "parser.y"
  {
	setup_program_start ();
	setup_from_identification = 1;
  }
#line 15722 "parser.c"
    break;

  case 59: /* program_id_header: "PROGRAM-ID"  */
#line 3912 "parser.y"
  {
	cobc_in_id = 1;
	save_tree = NULL;
  }
#line 15731 "parser.c"
    break;

  case 60: /* program_id_paragraph: program_id_header "." program_id_name _as_literal _program_type "."  */
#line 3920 "parser.y"
  {
	if (setup_program (yyvsp[-3], yyvsp[-2], COB_MODULE_TYPE_PROGRAM, 0)) {
		YYABORT;
	}


	setup_prototype (yyvsp[-3], yyvsp[-2], COB_MODULE_TYPE_PROGRAM, 1);

	if (yyvsp[-1]) {
		if (!current_program->nested_level) {
			cb_error (_("COMMON may only be used in a contained program"));
		} else {
			current_program->flag_common = 1;
			cb_add_common_prog (current_program);
		}
	}

	/* TODO: do that more clean, this and above was only moved here
	         to fix a shift/reduce conflict with program prototype */
	if (save_tree == cb_int1) {
		current_program->flag_initial = 1;
	} else if (save_tree == cb_int2) {
		current_program->flag_recursive = 1;
	}

	cobc_cs_check = 0;
	cobc_in_id = 0;
  }
#line 15764 "parser.c"
    break;

  case 61: /* function_id_header: "FUNCTION-ID"  */
#line 3952 "parser.y"
  {
	cobc_in_id = 1;
  }
#line 15772 "parser.c"
    break;

  case 62: /* function_id_paragraph: function_id_header "." program_id_name _as_literal "."  */
#line 3959 "parser.y"
  {
	if (setup_program (yyvsp[-2], yyvsp[-1], COB_MODULE_TYPE_FUNCTION, 0)) {
		YYABORT;
	}
	setup_prototype (yyvsp[-2], yyvsp[-1], COB_MODULE_TYPE_FUNCTION, 1);
	cobc_cs_check = 0;
	cobc_in_id = 0;
  }
#line 15785 "parser.c"
    break;

  case 63: /* program_id_name: "program name"  */
#line 3971 "parser.y"
  {
	if (CB_REFERENCE_P (yyvsp[0]) && CB_WORD_COUNT (yyvsp[0]) > 0) {
		redefinition_error (yyvsp[0]);
	}
	/*
	  The program name is a key part of defining the current_program, so we
	  mustn't lose it (unlike in undefined_word).
	*/
	yyval = yyvsp[0];
  }
#line 15800 "parser.c"
    break;

  case 64: /* program_id_name: "Literal"  */
#line 3982 "parser.y"
  {
	cb_trim_program_id (yyvsp[0]);
  }
#line 15808 "parser.c"
    break;

  case 66: /* end_program_name: "Literal"  */
#line 3990 "parser.y"
  {
	cb_trim_program_id (yyvsp[0]);
  }
#line 15816 "parser.c"
    break;

  case 67: /* _as_literal: %empty  */
#line 3996 "parser.y"
                                { yyval = NULL; }
#line 15822 "parser.c"
    break;

  case 68: /* _as_literal: AS "Literal"  */
#line 3997 "parser.y"
                                { yyval = yyvsp[0]; }
#line 15828 "parser.c"
    break;

  case 69: /* _program_type: %empty  */
#line 4001 "parser.y"
                                { yyval = NULL; }
#line 15834 "parser.c"
    break;

  case 70: /* _program_type: _is program_type_clause _program  */
#line 4002 "parser.y"
                                        { yyval = yyvsp[-1]; }
#line 15840 "parser.c"
    break;

  case 71: /* program_type_clause: COMMON  */
#line 4007 "parser.y"
  {
	yyval = cb_int1;
  }
#line 15848 "parser.c"
    break;

  case 72: /* program_type_clause: init_or_recurse_and_common  */
#line 4011 "parser.y"
  {
	yyval = cb_int2;
  }
#line 15856 "parser.c"
    break;

  case 74: /* program_type_clause: EXTERNAL  */
#line 4016 "parser.y"
  {
	CB_PENDING (_("CALL prototypes"));
  }
#line 15864 "parser.c"
    break;

  case 77: /* init_or_recurse: "INITIAL"  */
#line 4028 "parser.y"
  {
	save_tree = cb_int1;
  }
#line 15872 "parser.c"
    break;

  case 78: /* init_or_recurse: RECURSIVE  */
#line 4032 "parser.y"
  {
	save_tree = cb_int2;
  }
#line 15880 "parser.c"
    break;

  case 80: /* _options_paragraph: OPTIONS "." _options_clauses  */
#line 4041 "parser.y"
  {
	cobc_cs_check = 0;
  }
#line 15888 "parser.c"
    break;

  case 84: /* arithmetic_choice: NATIVE  */
#line 4061 "parser.y"
  {
/* FIXME: the IBM-compatible ARITHMETIC should only be disabled
          for the specified program (and its nested programs)
   note: ibm-strict.conf has no OPTIONS paragraph, but ibm.conf does */
	cb_arithmetic_osvs = 0;
  }
#line 15899 "parser.c"
    break;

  case 85: /* arithmetic_choice: STANDARD  */
#line 4068 "parser.y"
  {
	CB_PENDING ("STANDARD ARITHMETIC");
  }
#line 15907 "parser.c"
    break;

  case 86: /* arithmetic_choice: "STANDARD-BINARY"  */
#line 4072 "parser.y"
  {
	CB_PENDING ("STANDARD-BINARY ARITHMETIC");
  }
#line 15915 "parser.c"
    break;

  case 87: /* arithmetic_choice: "STANDARD-DECIMAL"  */
#line 4076 "parser.y"
  {
	CB_PENDING ("STANDARD-DECIMAL ARITHMETIC");
  }
#line 15923 "parser.c"
    break;

  case 88: /* _default_rounded_clause: %empty  */
#line 4091 "parser.y"
  {
	default_rounded_mode = cb_int (COB_STORE_ROUND);
  }
#line 15931 "parser.c"
    break;

  case 89: /* _default_rounded_clause: DEFAULT ROUNDED _mode _is round_choice  */
#line 4095 "parser.y"
  {
	if (yyvsp[0]) {
		default_rounded_mode = yyvsp[0];
	} else {
		default_rounded_mode = cb_int (COB_STORE_ROUND);
	}
  }
#line 15943 "parser.c"
    break;

  case 91: /* _entry_convention_clause: "ENTRY-CONVENTION" _is convention_type  */
#line 4107 "parser.y"
  {
	current_program->entry_convention = yyvsp[0];
  }
#line 15951 "parser.c"
    break;

  case 92: /* convention_type: COBOL  */
#line 4114 "parser.y"
  {
	yyval = cb_int (CB_CONV_COBOL);
  }
#line 15959 "parser.c"
    break;

  case 93: /* convention_type: "EXTERN"  */
#line 4118 "parser.y"
  {
	yyval = cb_int0;
  }
#line 15967 "parser.c"
    break;

  case 94: /* convention_type: STDCALL  */
#line 4122 "parser.y"
  {
	yyval = cb_int (CB_CONV_STDCALL);
  }
#line 15975 "parser.c"
    break;

  case 96: /* _intermediate_rounding_clause: INTERMEDIATE ROUNDING _is intermediate_rounding_choice  */
#line 4130 "parser.y"
  {
	CB_PENDING ("INTERMEDIATE ROUNDING");
  }
#line 15983 "parser.c"
    break;

  case 97: /* intermediate_rounding_choice: "NEAREST-AWAY-FROM-ZERO"  */
#line 4137 "parser.y"
  {
	yyval = cb_int (COB_STORE_ROUND | COB_STORE_NEAR_AWAY_FROM_ZERO);
  }
#line 15991 "parser.c"
    break;

  case 98: /* intermediate_rounding_choice: "NEAREST-EVEN"  */
#line 4141 "parser.y"
  {
	yyval = cb_int (COB_STORE_ROUND | COB_STORE_NEAR_EVEN);
  }
#line 15999 "parser.c"
    break;

  case 99: /* intermediate_rounding_choice: PROHIBITED  */
#line 4145 "parser.y"
  {
	yyval = cb_int (COB_STORE_ROUND | COB_STORE_PROHIBITED);
  }
#line 16007 "parser.c"
    break;

  case 100: /* intermediate_rounding_choice: TRUNCATION  */
#line 4149 "parser.y"
  {
	yyval = cb_int (COB_STORE_ROUND | COB_STORE_TRUNCATION);
  }
#line 16015 "parser.c"
    break;

  case 104: /* environment: ENVIRONMENT  */
#line 4166 "parser.y"
                         { check_area_a_of ("ENVIRONMENT DIVISION"); }
#line 16021 "parser.c"
    break;

  case 105: /* environment_header: environment DIVISION _dot  */
#line 4169 "parser.y"
  {
	header_check |= COBC_HD_ENVIRONMENT_DIVISION;
  }
#line 16029 "parser.c"
    break;

  case 109: /* configuration: CONFIGURATION  */
#line 4185 "parser.y"
                             { check_area_a_of ("CONFIGURATION SECTION"); }
#line 16035 "parser.c"
    break;

  case 110: /* configuration_header: configuration SECTION _dot  */
#line 4188 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_CONFIGURATION_SECTION;
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "CONFIGURATION SECTION");
	}
  }
#line 16047 "parser.c"
    break;

  case 122: /* $@18: %empty  */
#line 4223 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
	check_conf_section_order (COBC_HD_SOURCE_COMPUTER);
	set_conf_section_part (COBC_HD_SOURCE_COMPUTER);
  }
#line 16058 "parser.c"
    break;

  case 127: /* _with_debugging_mode: _with DEBUGGING MODE  */
#line 4239 "parser.y"
  {
	current_program->flag_debugging = 1;
	needs_debug_item = 1;
	cobc_cs_check = 0;
	cb_build_debug_item ();
  }
#line 16069 "parser.c"
    break;

  case 128: /* $@19: %empty  */
#line 4251 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
	check_conf_section_order (COBC_HD_OBJECT_COMPUTER);
	set_conf_section_part (COBC_HD_OBJECT_COMPUTER);
  }
#line 16080 "parser.c"
    break;

  case 129: /* object_computer_paragraph: "OBJECT-COMPUTER" _dot $@19 _object_computer_entry  */
#line 4258 "parser.y"
  {
	cobc_cs_check = 0;
  }
#line 16088 "parser.c"
    break;

  case 140: /* object_computer_memory: MEMORY _size _is integer object_char_or_word_or_modules  */
#line 4284 "parser.y"
  {
	cb_verify (cb_memory_size_clause, "MEMORY SIZE");
  }
#line 16096 "parser.c"
    break;

  case 141: /* object_computer_sequence: _program program_collating_sequence  */
#line 4292 "parser.y"
  {
	current_program->collating_sequence = alphanumeric_collation;
	current_program->collating_sequence_n = national_collation;
  }
#line 16105 "parser.c"
    break;

  case 143: /* program_coll_sequence_values: _is single_reference  */
#line 4305 "parser.y"
  {
	alphanumeric_collation = yyvsp[0];
  }
#line 16113 "parser.c"
    break;

  case 144: /* program_coll_sequence_values: _is single_reference single_reference  */
#line 4309 "parser.y"
  {
	alphanumeric_collation = yyvsp[-1];
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 16123 "parser.c"
    break;

  case 145: /* program_coll_sequence_values: _for ALPHANUMERIC _is single_reference  */
#line 4315 "parser.y"
  {
	alphanumeric_collation = yyvsp[0];
  }
#line 16131 "parser.c"
    break;

  case 146: /* program_coll_sequence_values: _for NATIONAL _is single_reference  */
#line 4319 "parser.y"
  {
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 16140 "parser.c"
    break;

  case 147: /* program_coll_sequence_values: _for ALPHANUMERIC _is single_reference _for NATIONAL _is single_reference  */
#line 4325 "parser.y"
  {
	alphanumeric_collation = yyvsp[-4];
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 16150 "parser.c"
    break;

  case 148: /* program_coll_sequence_values: _for NATIONAL _is single_reference _for ALPHANUMERIC _is single_reference  */
#line 4332 "parser.y"
  {
	CB_PENDING_X (yyvsp[-4], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[-4];
	alphanumeric_collation = yyvsp[0];
  }
#line 16160 "parser.c"
    break;

  case 149: /* object_computer_segment: "SEGMENT-LIMIT" _is integer  */
#line 4341 "parser.y"
  {
	if (cb_verify (cb_section_segments, "SEGMENT LIMIT")) {
		int segnum = cb_get_int (yyvsp[0]);
		if (segnum == 0 || segnum > 49) {
			cb_error (_("segment-number must be in range of values 1 to 49"));
			yyval = NULL;
		}
	}
	/* Ignore */
  }
#line 16175 "parser.c"
    break;

  case 150: /* object_computer_class: _character CLASSIFICATION _is locale_class  */
#line 4355 "parser.y"
  {
	if (current_program->classification) {
		cb_error (_("duplicate CLASSIFICATION clause"));
	} else {
		current_program->classification = yyvsp[0];
	}
  }
#line 16187 "parser.c"
    break;

  case 151: /* locale_class: single_reference  */
#line 4366 "parser.y"
  {
	yyval = yyvsp[0];
  }
#line 16195 "parser.c"
    break;

  case 152: /* locale_class: LOCALE  */
#line 4370 "parser.y"
  {
	yyval = NULL;
  }
#line 16203 "parser.c"
    break;

  case 153: /* locale_class: "USER-DEFAULT"  */
#line 4374 "parser.y"
  {
	yyval = cb_int1;
  }
#line 16211 "parser.c"
    break;

  case 154: /* locale_class: "SYSTEM-DEFAULT"  */
#line 4378 "parser.y"
  {
	yyval = cb_int1;
  }
#line 16219 "parser.c"
    break;

  case 159: /* $@20: %empty  */
#line 4395 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
	check_conf_section_order (COBC_HD_REPOSITORY);
	set_conf_section_part (COBC_HD_REPOSITORY);
  }
#line 16230 "parser.c"
    break;

  case 160: /* repository_paragraph: REPOSITORY _dot $@20 _repository_entry  */
#line 4402 "parser.y"
  {
	cobc_in_repository = 0;
  }
#line 16238 "parser.c"
    break;

  case 163: /* _repository_entry: repository_list error "."  */
#line 4411 "parser.y"
  {
	yyerrok;
  }
#line 16246 "parser.c"
    break;

  case 166: /* repository_name: FUNCTION ALL INTRINSIC  */
#line 4423 "parser.y"
  {
	functions_are_all = 1;
  }
#line 16254 "parser.c"
    break;

  case 167: /* repository_name: FUNCTION "Identifier" _as_literal  */
#line 4427 "parser.y"
  {
	if (yyvsp[-1] != cb_error_node) {
		setup_prototype (yyvsp[-1], yyvsp[0], COB_MODULE_TYPE_FUNCTION, 0);
	}
  }
#line 16264 "parser.c"
    break;

  case 169: /* repository_name: PROGRAM "Identifier" _as_literal  */
#line 4434 "parser.y"
  {
	  if (yyvsp[-1] != cb_error_node
	   && cb_verify (cb_program_prototypes, _("PROGRAM phrase"))) {
		setup_prototype (yyvsp[-1], yyvsp[0], COB_MODULE_TYPE_PROGRAM, 0);
	}
  }
#line 16275 "parser.c"
    break;

  case 170: /* repository_name: FUNCTION repository_name_list error  */
#line 4441 "parser.y"
  {
	yyerrok;
  }
#line 16283 "parser.c"
    break;

  case 171: /* repository_name_list: "intrinsic function name"  */
#line 4448 "parser.y"
  {
	current_program->function_spec_list =
		cb_list_add (current_program->function_spec_list, yyvsp[0]);
  }
#line 16292 "parser.c"
    break;

  case 172: /* repository_name_list: repository_name_list "intrinsic function name"  */
#line 4453 "parser.y"
  {
	current_program->function_spec_list =
		cb_list_add (current_program->function_spec_list, yyvsp[0]);
  }
#line 16301 "parser.c"
    break;

  case 173: /* special_names_header: "SPECIAL-NAMES" _dot  */
#line 4464 "parser.y"
  {
	check_duplicate = 0;
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION, 0, 0);
	check_conf_section_order (COBC_HD_SPECIAL_NAMES);
	set_conf_section_part (COBC_HD_SPECIAL_NAMES);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	}
	cobc_cs_check = CB_CS_SPECIAL_NAMES;
  }
#line 16317 "parser.c"
    break;

  case 193: /* $@21: %empty  */
#line 4511 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	check_duplicate = 0;
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
		save_tree = NULL;
	} else {
		/* lookup system name with special translation
		   note: result in NULL + raised error if not found */
		save_tree = get_system_name_translated (yyvsp[0]);
	}
  }
#line 16336 "parser.c"
    break;

  case 195: /* word_or_terminal: "Identifier"  */
#line 4529 "parser.y"
           { yyval = yyvsp[0]; }
#line 16342 "parser.c"
    break;

  case 196: /* word_or_terminal: TERMINAL  */
#line 4531 "parser.y"
           { yyval = cb_build_reference ("TERMINAL"); }
#line 16348 "parser.c"
    break;

  case 197: /* mnemonic_choices: _is CRT  */
#line 4535 "parser.y"
  {
	if (save_tree) {
		if (CB_SYSTEM_NAME(save_tree)->token != CB_DEVICE_CONSOLE) {
			cb_error_x (save_tree, _("invalid %s clause"), "");
		} else {
			current_program->flag_console_is_crt = 1;
		}
	}
  }
#line 16362 "parser.c"
    break;

  case 198: /* mnemonic_choices: integer _is undefined_word  */
#line 4546 "parser.y"
  {
	if (save_tree) {
		if (CB_SYSTEM_NAME(save_tree)->token != CB_FEATURE_CONVENTION) {
			cb_error_x (save_tree, _("invalid %s clause"), "SPECIAL NAMES");
		} else if (CB_VALID_TREE (yyvsp[0])) {
			const char *name = CB_NAME (yyvsp[0]);
			CB_SYSTEM_NAME(save_tree)->value = yyvsp[-2];
			cb_define (yyvsp[0], save_tree);
			CB_CHAIN_PAIR (current_program->mnemonic_spec_list,
					yyvsp[0], save_tree);
			/* remove non-standard context-sensitive words when identical to mnemonic */
			if (cb_strcasecmp (name, "EXTERN" ) == 0
			 || cb_strcasecmp (name, "STDCALL") == 0
			 || cb_strcasecmp (name, "WINAPI") == 0
			 || cb_strcasecmp (name, "STATIC" ) == 0
			 || cb_strcasecmp (name, "C"      ) == 0
			 || cb_strcasecmp (name, "PASCAL" ) == 0) {
				remove_context_sensitivity (name, CB_CS_CALL);
			}
		}
	}
  }
#line 16389 "parser.c"
    break;

  case 199: /* mnemonic_choices: _is undefined_word _special_name_mnemonic_on_off  */
#line 4569 "parser.y"
  {
	if (save_tree && CB_VALID_TREE (yyvsp[-1])) {
		cb_define (yyvsp[-1], save_tree);
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list,
				yyvsp[-1], save_tree);
	}
  }
#line 16401 "parser.c"
    break;

  case 203: /* on_off_clauses: on_off_clauses_1  */
#line 4585 "parser.y"
  {
	  check_on_off_duplicate = 0;
  }
#line 16409 "parser.c"
    break;

  case 204: /* on_off_clauses_1: on_or_off _onoff_status undefined_word  */
#line 4592 "parser.y"
  {
	cb_tree		x;

	/* cb_define_switch_name checks param validity */
	x = cb_define_switch_name (yyvsp[0], save_tree, yyvsp[-2] == cb_int1);
	if (x) {
		if (yyvsp[-2] == cb_int1) {
			check_repeated ("ON", SYN_CLAUSE_1, &check_on_off_duplicate);
		} else {
			check_repeated ("OFF", SYN_CLAUSE_2, &check_on_off_duplicate);
		}
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list, yyvsp[0], x);
	}
  }
#line 16428 "parser.c"
    break;

  case 205: /* on_off_clauses_1: on_off_clauses_1 on_or_off _onoff_status undefined_word  */
#line 4607 "parser.y"
  {
	cb_tree		x;

	/* cb_define_switch_name checks param validity */
	x = cb_define_switch_name (yyvsp[0], save_tree, yyvsp[-2] == cb_int1);
	if (x) {
		if (yyvsp[-2] == cb_int1) {
			check_repeated ("ON", SYN_CLAUSE_1, &check_on_off_duplicate);
		} else {
			check_repeated ("OFF", SYN_CLAUSE_2, &check_on_off_duplicate);
		}
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list, yyvsp[0], x);
	}
  }
#line 16447 "parser.c"
    break;

  case 206: /* @22: %empty  */
#line 4627 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
		yyval = NULL;
	} else {
		/* Returns null on error */
		yyval = cb_build_alphabet_name (yyvsp[0]);
	}
  }
#line 16464 "parser.c"
    break;

  case 207: /* alphabet_name_clause: ALPHABET undefined_word @22 alphabet_definition  */
#line 4640 "parser.y"
  {
	if (yyvsp[-1]) {
		current_program->alphabet_name_list =
			cb_list_add (current_program->alphabet_name_list, yyvsp[-1]);
	}
	cobc_cs_check = 0;
  }
#line 16476 "parser.c"
    break;

  case 208: /* @23: %empty  */
#line 4651 "parser.y"
  {
	yyval = yyvsp[-1];
	if (yyvsp[-1]) {
		CB_ALPHABET_NAME (yyvsp[-1])->alphabet_target = CB_ALPHABET_ALPHANUMERIC;
	}
  }
#line 16487 "parser.c"
    break;

  case 210: /* @24: %empty  */
#line 4659 "parser.y"
  {
	yyval = yyvsp[-1];
	if (yyvsp[-1]) {
		CB_ALPHABET_NAME(yyvsp[-1])->alphabet_target = CB_ALPHABET_NATIONAL;
	}
  }
#line 16498 "parser.c"
    break;

  case 216: /* alphabet_type_alphanumeric: "STANDARD-1"  */
#line 4680 "parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_ASCII;
	}
  }
#line 16508 "parser.c"
    break;

  case 217: /* alphabet_type_alphanumeric: "STANDARD-2"  */
#line 4686 "parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_ASCII;
	}
  }
#line 16518 "parser.c"
    break;

  case 218: /* alphabet_type_alphanumeric: EBCDIC  */
#line 4692 "parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_EBCDIC;
	}
  }
#line 16528 "parser.c"
    break;

  case 219: /* alphabet_type_alphanumeric: ASCII  */
#line 4698 "parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_ASCII;
	}
  }
#line 16538 "parser.c"
    break;

  case 221: /* alphabet_type_national: "UCS-4"  */
#line 4708 "parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_PENDING_X (yyvsp[(-1) - (1)], "ALPHABET UCS-4");
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_UCS_4;
	}
  }
#line 16549 "parser.c"
    break;

  case 222: /* alphabet_type_national: "UTF-8"  */
#line 4715 "parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_PENDING_X (yyvsp[(-1) - (1)], "ALPHABET UTF-8");
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_UTF_8;
	}
  }
#line 16560 "parser.c"
    break;

  case 223: /* alphabet_type_national: "UTF-16"  */
#line 4722 "parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_PENDING_X (yyvsp[(-1) - (1)], "ALPHABET UTF-16");
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_UTF_16;
	}
  }
#line 16571 "parser.c"
    break;

  case 224: /* alphabet_type_common: NATIVE  */
#line 4732 "parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_NATIVE;
	}
  }
#line 16581 "parser.c"
    break;

  case 225: /* alphabet_type_common: LOCALE single_reference  */
#line 4738 "parser.y"
  {
	if (yyvsp[(-1) - (2)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (2)])->alphabet_type = CB_ALPHABET_LOCALE;
		CB_ALPHABET_NAME (yyvsp[(-1) - (2)])->custom_list = yyvsp[0];
		CB_PENDING_X (yyvsp[(-1) - (2)], "LOCALE ALPHABET");
	}
  }
#line 16593 "parser.c"
    break;

  case 226: /* alphabet_type_common: alphabet_literal_list  */
#line 4746 "parser.y"
  {
	if (yyvsp[(-1) - (1)]) {
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->alphabet_type = CB_ALPHABET_CUSTOM;
		CB_ALPHABET_NAME (yyvsp[(-1) - (1)])->custom_list = yyvsp[0];
	}
  }
#line 16604 "parser.c"
    break;

  case 227: /* alphabet_literal_list: alphabet_literal  */
#line 4756 "parser.y"
  {
	yyval = CB_LIST_INIT (yyvsp[0]);
  }
#line 16612 "parser.c"
    break;

  case 228: /* alphabet_literal_list: alphabet_literal_list alphabet_literal  */
#line 4760 "parser.y"
  {
	yyval = cb_list_add (yyvsp[-1], yyvsp[0]);
  }
#line 16620 "parser.c"
    break;

  case 229: /* alphabet_literal: alphabet_lits  */
#line 4767 "parser.y"
  {
	yyval = yyvsp[0];
  }
#line 16628 "parser.c"
    break;

  case 230: /* alphabet_literal: alphabet_lits THRU alphabet_lits  */
#line 4771 "parser.y"
  {
	yyval = CB_BUILD_PAIR (yyvsp[-2], yyvsp[0]);
  }
#line 16636 "parser.c"
    break;

  case 231: /* @25: %empty  */
#line 4775 "parser.y"
  {
	yyval = CB_LIST_INIT (yyvsp[-1]);
  }
#line 16644 "parser.c"
    break;

  case 232: /* alphabet_literal: alphabet_lits ALSO @25 alphabet_also_sequence  */
#line 4779 "parser.y"
  {
	yyval = yyvsp[-1];
  }
#line 16652 "parser.c"
    break;

  case 233: /* alphabet_also_sequence: alphabet_lits  */
#line 4786 "parser.y"
  {
	cb_list_add (yyvsp[-1], yyvsp[0]);
  }
#line 16660 "parser.c"
    break;

  case 234: /* alphabet_also_sequence: alphabet_also_sequence ALSO alphabet_lits  */
#line 4790 "parser.y"
  {
	cb_list_add (yyvsp[-3], yyvsp[0]);
  }
#line 16668 "parser.c"
    break;

  case 235: /* alphabet_lits: "Literal"  */
#line 4796 "parser.y"
                                { yyval = yyvsp[0]; }
#line 16674 "parser.c"
    break;

  case 236: /* alphabet_lits: SPACE  */
#line 4797 "parser.y"
                                { yyval = cb_space; }
#line 16680 "parser.c"
    break;

  case 237: /* alphabet_lits: ZERO  */
#line 4798 "parser.y"
                                { yyval = cb_zero; }
#line 16686 "parser.c"
    break;

  case 238: /* alphabet_lits: QUOTE  */
#line 4799 "parser.y"
                                { yyval = cb_quote; }
#line 16692 "parser.c"
    break;

  case 239: /* alphabet_lits: "HIGH-VALUE"  */
#line 4800 "parser.y"
                        { yyval = cb_norm_high; /* -> special case, not cb_high */ }
#line 16698 "parser.c"
    break;

  case 240: /* alphabet_lits: "LOW-VALUE"  */
#line 4801 "parser.y"
                                { yyval = cb_norm_low; }
#line 16704 "parser.c"
    break;

  case 241: /* space_or_zero: SPACE  */
#line 4805 "parser.y"
                                { yyval = cb_space; }
#line 16710 "parser.c"
    break;

  case 242: /* space_or_zero: ZERO  */
#line 4806 "parser.y"
                                { yyval = cb_zero; }
#line 16716 "parser.c"
    break;

  case 243: /* _alphnat_target: %empty  */
#line 4811 "parser.y"
  {
	yyval = NULL;
  }
#line 16724 "parser.c"
    break;

  case 244: /* _alphnat_target: _for ALPHANUMERIC  */
#line 4815 "parser.y"
  {
	yyval = NULL;
  }
#line 16732 "parser.c"
    break;

  case 245: /* _alphnat_target: _for NATIONAL  */
#line 4819 "parser.y"
  {
	yyval = cb_int0;
  }
#line 16740 "parser.c"
    break;

  case 246: /* _in_alphabet: %empty  */
#line 4826 "parser.y"
  {
	yyval = NULL;
  }
#line 16748 "parser.c"
    break;

  case 247: /* _in_alphabet: IN alphabet_name  */
#line 4830 "parser.y"
  {
	/* note: IN is really mandatory here */
	yyval = yyvsp[0];
  }
#line 16757 "parser.c"
    break;

  case 248: /* symbolic_characters_clause: symbolic_collection _in_alphabet  */
#line 4841 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		cb_tree type = CB_PAIR_X (yyvsp[-1]);
		cb_tree chars_list = CB_PAIR_Y (yyvsp[-1]);
		cb_tree alph = yyvsp[0];
		
		/* TODO: at least add a check that $3 and $6 match by type */
		if (type && !alph) {
			cb_error_x (type, _("type does not match alphabet"));
		} else
		if (type) {
			CB_PENDING_X (type, "NATIONAL SYMBOLIC CHARACTER");
		}
		CB_CHAIN_PAIR (current_program->symbolic_char_list, chars_list, alph);
	}
  }
#line 16783 "parser.c"
    break;

  case 249: /* symbolic_collection: SYMBOLIC _characters _alphnat_target symbolic_chars_list  */
#line 4868 "parser.y"
  {
	yyval = CB_BUILD_PAIR (yyvsp[-1], yyvsp[0]);
  }
#line 16791 "parser.c"
    break;

  case 250: /* symbolic_chars_list: symbolic_chars_phrase  */
#line 4875 "parser.y"
  {
	yyval = yyvsp[0];
  }
#line 16799 "parser.c"
    break;

  case 251: /* symbolic_chars_list: symbolic_chars_list symbolic_chars_phrase  */
#line 4879 "parser.y"
  {
	if (yyvsp[0]) {
		yyval = cb_list_append (yyvsp[-1], yyvsp[0]);
	} else {
		yyval = yyvsp[-1];
	}
  }
#line 16811 "parser.c"
    break;

  case 252: /* symbolic_chars_phrase: char_list _is_are integer_list  */
#line 4890 "parser.y"
  {
	cb_tree		l1;
	cb_tree		l2;

	if (cb_list_length (yyvsp[-2]) != cb_list_length (yyvsp[0])) {
		cb_error (_("invalid %s clause"), "SYMBOLIC");
		yyval = NULL;
	} else {
		l1 = yyvsp[-2];
		l2 = yyvsp[0];
		for (; l1; l1 = CB_CHAIN (l1), l2 = CB_CHAIN (l2)) {
			CB_PURPOSE (l1) = CB_VALUE (l2);
		}
		yyval = yyvsp[-2];
	}
  }
#line 16832 "parser.c"
    break;

  case 253: /* char_list: unique_word  */
#line 4910 "parser.y"
  {
	if (yyvsp[0] == NULL) {
		yyval = NULL;
	} else {
		yyval = CB_LIST_INIT (yyvsp[0]);
	}
  }
#line 16844 "parser.c"
    break;

  case 254: /* char_list: char_list unique_word  */
#line 4918 "parser.y"
  {
	if (yyvsp[0] == NULL) {
		yyval = yyvsp[-1];
	} else {
		yyval = cb_list_add (yyvsp[-1], yyvsp[0]);
	}
  }
#line 16856 "parser.c"
    break;

  case 255: /* integer_list: symbolic_integer  */
#line 4928 "parser.y"
                                { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 16862 "parser.c"
    break;

  case 256: /* integer_list: integer_list symbolic_integer  */
#line 4929 "parser.y"
                                { yyval = cb_list_add (yyvsp[-1], yyvsp[0]); }
#line 16868 "parser.c"
    break;

  case 257: /* symbolic_constant_clause: SYMBOLIC CONSTANT symbolic_constant_list  */
#line 4938 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	}
	(void)cb_verify (cb_symbolic_constant, "SYMBOLIC CONSTANT");
  }
#line 16882 "parser.c"
    break;

  case 260: /* symbolic_constant: user_entry_name _is literal  */
#line 4956 "parser.y"
  {
	struct cb_field *f;

	f = CB_FIELD (cb_build_constant (yyvsp[-2], yyvsp[0]));
	f->flag_item_78 = 1;
	f->flag_constant = 1;
	f->flag_is_global = 1;
	f->level = 1;
	f->values = yyvsp[0];
	cb_needs_01 = 1;
	/* Ignore return value */
	(void)cb_validate_78_item (f, 0);
  }
#line 16900 "parser.c"
    break;

  case 261: /* class_name_clause: CLASS undefined_word _alphnat_target _is class_item_list _in_alphabet  */
#line 4975 "parser.y"
  {
	cb_tree		x;

	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		/* Returns null on error */
		x = cb_build_class_name (yyvsp[-4], yyvsp[-1]);
		if (x) {
			current_program->class_name_list =
				cb_list_add (current_program->class_name_list, x);
		}
		/* TODO: at least add a check that $3 and $6 match by type */
		if (yyvsp[-3] && !yyvsp[0]) {
			cb_error_x (yyvsp[-3], _("type does not match alphabet"));
		} else
		if (yyvsp[-3]) {
			CB_PENDING_X (yyvsp[-3], "NATIONAL CLASS");
		}
		if (yyvsp[0]) {
			CB_PENDING_X (yyvsp[0], _("CLASS IS integer IN alphabet-name"));
		}
	}
  }
#line 16932 "parser.c"
    break;

  case 262: /* class_item_list: class_item  */
#line 5005 "parser.y"
                                { yyval = CB_LIST_INIT (yyvsp[0]); }
#line 16938 "parser.c"
    break;

  case 263: /* class_item_list: class_item_list class_item  */
#line 5006 "parser.y"
                                { yyval = cb_list_add (yyvsp[-1], yyvsp[0]); }
#line 16944 "parser.c"
    break;

  case 264: /* class_item: class_value  */
#line 5011 "parser.y"
  {
	yyval = yyvsp[0];
  }
#line 16952 "parser.c"
    break;

  case 265: /* class_item: class_value THRU class_value  */
#line 5015 "parser.y"
  {
	if (CB_TREE_CLASS (yyvsp[-2]) != CB_CLASS_NUMERIC
	 && CB_LITERAL_P (yyvsp[-2]) && CB_LITERAL (yyvsp[-2])->size != 1) {
		cb_error (_("CLASS literal with THRU must have size 1"));
	}
	if (CB_TREE_CLASS (yyvsp[0]) != CB_CLASS_NUMERIC
	 && CB_LITERAL_P (yyvsp[0]) && CB_LITERAL (yyvsp[0])->size != 1) {
		cb_error (_("CLASS literal with THRU must have size 1"));
	}
	if (cb_literal_value (yyvsp[-2]) <= cb_literal_value (yyvsp[0])) {
		yyval = CB_BUILD_PAIR (yyvsp[-2], yyvsp[0]);
	} else {
		yyval = CB_BUILD_PAIR (yyvsp[0], yyvsp[-2]);
	}
  }
#line 16972 "parser.c"
    break;

  case 266: /* locale_clause: LOCALE undefined_word _is "Literal"  */
#line 5036 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		/* Returns null on error */
		cb_tree	l = cb_build_locale_name (yyvsp[-2], yyvsp[0]);
		if (l) {
			current_program->locale_list =
				cb_list_add (current_program->locale_list, l);
		}
	}
  }
#line 16992 "parser.c"
    break;

  case 267: /* @26: %empty  */
#line 5057 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
		yyval = NULL;
	} else {
		/* Returns null on error */
		yyval = cb_build_schema_name (yyvsp[0]);
	}
  }
#line 17009 "parser.c"
    break;

  case 268: /* xml_schema_clause: "XML-SCHEMA" undefined_word @26 schema_definition  */
#line 5070 "parser.y"
  {
	if (yyvsp[-1]) {
		current_program->schema_name_list =
			cb_list_add (current_program->schema_name_list, yyvsp[-1]);
	}
	cobc_cs_check = 0;
  }
#line 17021 "parser.c"
    break;

  case 269: /* schema_definition: literal  */
#line 5081 "parser.y"
  {
	yyval = yyvsp[-1];
	if (yyvsp[-1]) {
		CB_SCHEMA_NAME (yyvsp[-1])->data = (const char *) CB_LITERAL (yyvsp[0])->data;
	}
  }
#line 17032 "parser.c"
    break;

  case 270: /* schema_definition: "Identifier"  */
#line 5088 "parser.y"
  {
	yyval = yyvsp[-1];
	if (yyvsp[-1]) {
		CB_SCHEMA_NAME (yyvsp[-1])->data = CB_REFERENCE (yyvsp[0])->word->name;
	}
  }
#line 17043 "parser.c"
    break;

  case 271: /* currency_sign_clause: CURRENCY _sign _is "Literal" _with_pic_symbol  */
#line 5100 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		unsigned int	error_ind = 0;

		/* FIXME: actual allowed (depending on dialect), see FR #246 */
		check_repeated ("CURRENCY", SYN_CLAUSE_1, &check_duplicate);

		/* checks of CURRENCY SIGN (being currency string) when separate */
		if (yyvsp[0]) {
			unsigned int	char_seen = 0;
			unsigned char	*s = CB_LITERAL (yyvsp[-1])->data;

			CB_PENDING_X (yyvsp[-1], _("separate currency symbol and currency string"));
			while (*s) {
				switch (*s) {
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
				case '+':
				case '-':
				case ',':
				case '.':
				case '*':
					error_ind = 1;
					break;
				case ' ':
					break;
				default:
					char_seen = 1;
					break;
				}
				s++;
			}
			if (!char_seen) {
				error_ind = 1;
			}
		}
		if (error_ind) {
			cb_error_x (yyvsp[-1], _("invalid CURRENCY SIGN '%s'"), (char*)CB_LITERAL (yyvsp[-1])->data);
		}
		if (yyvsp[0]) {
			set_currency_picture_symbol (yyvsp[0]);
		} else {
			if (!error_ind) {
				set_currency_picture_symbol (yyvsp[-1]);
			}
		}
	}
  }
#line 17109 "parser.c"
    break;

  case 272: /* _with_pic_symbol: %empty  */
#line 5166 "parser.y"
  {
	yyval = NULL;
  }
#line 17117 "parser.c"
    break;

  case 273: /* _with_pic_symbol: _with "PICTURE SYMBOL" "Literal"  */
#line 5170 "parser.y"
  {
	yyval = yyvsp[0];
  }
#line 17125 "parser.c"
    break;

  case 274: /* decimal_point_clause: "DECIMAL-POINT" _is COMMA  */
#line 5179 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("DECIMAL-POINT", SYN_CLAUSE_2, &check_duplicate);
		current_program->decimal_point = ',';
		current_program->numeric_separator = '.';
	}
  }
#line 17142 "parser.c"
    break;

  case 275: /* numeric_sign_clause: NUMERIC SIGN _is TRAILING SEPARATE  */
#line 5198 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		current_program->flag_trailing_separate = 1;
	}
  }
#line 17157 "parser.c"
    break;

  case 276: /* cursor_clause: CURSOR _is reference  */
#line 5214 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("CURSOR", SYN_CLAUSE_3, &check_duplicate);
		current_program->cursor_pos = yyvsp[0];
	}
  }
#line 17173 "parser.c"
    break;

  case 277: /* crt_status_clause: CRT STATUS _is reference  */
#line 5232 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("CRT STATUS", SYN_CLAUSE_4, &check_duplicate);
		current_program->crt_status = yyvsp[0];
	}
  }
#line 17189 "parser.c"
    break;

  case 278: /* screen_control: "SCREEN CONTROL" _is reference  */
#line 5250 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("SCREEN CONTROL", SYN_CLAUSE_5, &check_duplicate);
		CB_PENDING ("SCREEN CONTROL");
	}
  }
#line 17205 "parser.c"
    break;

  case 279: /* event_status: "EVENT STATUS" _is reference  */
#line 5267 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
	} else {
		check_repeated ("EVENT STATUS", SYN_CLAUSE_6, &check_duplicate);
		CB_PENDING ("EVENT STATUS");
	}
  }
#line 17221 "parser.c"
    break;

  case 280: /* $@27: %empty  */
#line 5284 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_CONFIGURATION_SECTION,
			       COBC_HD_SPECIAL_NAMES, 0);
	check_duplicate = 0;
	if (current_program->nested_level) {
		cb_error (_("%s not allowed in nested programs"), "SPECIAL-NAMES");
		save_tree = NULL;
	} else {
		/* lookup system name
		   note: result in NULL + raised error if not found */
		save_tree = get_system_name ("TOP");
	}
  }
#line 17240 "parser.c"
    break;

  case 281: /* top_clause: TOP $@27 _is undefined_word  */
#line 5299 "parser.y"
  {
	if (save_tree && CB_VALID_TREE (yyvsp[0])) {
		cb_define (yyvsp[0], save_tree);
		CB_CHAIN_PAIR (current_program->mnemonic_spec_list,
				yyvsp[0], save_tree);
	}
  }
#line 17252 "parser.c"
    break;

  case 283: /* input_output: "INPUT-OUTPUT"  */
#line 5317 "parser.y"
                           { check_area_a_of ("INPUT-OUTPUT SECTION"); }
#line 17258 "parser.c"
    break;

  case 285: /* _input_output_header: input_output SECTION _dot  */
#line 5320 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_INPUT_OUTPUT_SECTION;
  }
#line 17267 "parser.c"
    break;

  case 287: /* _file_control_header: "FILE-CONTROL" _dot  */
#line 5330 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION, 0, 0);
	header_check |= COBC_HD_FILE_CONTROL;
  }
#line 17277 "parser.c"
    break;

  case 290: /* $@28: %empty  */
#line 5342 "parser.y"
         { check_non_area_a (yyvsp[0]); }
#line 17283 "parser.c"
    break;

  case 291: /* $@29: %empty  */
#line 5344 "parser.y"
  {
	char	buff[COB_MINI_BUFF];

	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION,
			       COBC_HD_FILE_CONTROL, 0);
	check_duplicate = 0;
	if (CB_VALID_TREE (yyvsp[0])) {
		/* Build new file */
		current_file = build_file (yyvsp[0]);
		current_file->optional = CB_INTEGER (yyvsp[-1])->val;

		/* Add file to current program list */
		CB_ADD_TO_CHAIN (CB_TREE (current_file),
				 current_program->file_list);
	} else {
		/* Create dummy file */
		snprintf (buff, COB_MINI_BUFF, "SELECT on line %d",
			  cb_source_line);
		current_file = build_file (cb_build_reference (buff));
		CB_ADD_TO_CHAIN (CB_TREE (current_file),
				 current_program->file_list);

	}
	key_type = NO_KEY;
  }
#line 17314 "parser.c"
    break;

  case 292: /* file_control_entry: SELECT $@28 flag_optional undefined_word $@29 _select_clauses_or_error  */
#line 5371 "parser.y"
  {
	cobc_cs_check = 0;
	if (CB_VALID_TREE (yyvsp[-2])) {
		if (current_file->organization == COB_ORG_INDEXED
		    && key_type == RELATIVE_KEY) {
			cb_error_x (current_file->key,
				    _("cannot use RELATIVE KEY clause on INDEXED files"));
		} else if (current_file->organization == COB_ORG_RELATIVE
			   && key_type == RECORD_KEY) {
			cb_error_x (current_file->key,
				    _("cannot use RECORD KEY clause on RELATIVE files"));
		}

		validate_file (current_file, yyvsp[-2]);
	}
  }
#line 17335 "parser.c"
    break;

  case 294: /* _select_clauses_or_error: error dot_or_else_end_of_file_control  */
#line 5392 "parser.y"
  {
	yyerrok;
  }
#line 17343 "parser.c"
    break;

  case 296: /* _select_clause_sequence: _select_clause_sequence select_clause  */
#line 5399 "parser.y"
  {
	/* reset context-sensitive words for next clauses */
	cobc_cs_check = CB_CS_SELECT;
  }
#line 17352 "parser.c"
    break;

  case 317: /* assign_clause: ASSIGN _to _ext_clause _assign_device_or_line_adv_file literal  */
#line 5450 "parser.y"
  {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);
	if (ext_dyn_specified) {
		cb_error (_("EXTERNAL/DYNAMIC cannot be used with literals"));
	}

	current_file->assign_type = CB_ASSIGN_EXT_FILE_NAME_REQUIRED;
	current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
  }
#line 17366 "parser.c"
    break;

  case 318: /* assign_clause: ASSIGN _to _ext_clause _assign_device_or_line_adv_file qualified_word  */
#line 5460 "parser.y"
  {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);

	/* current_file->assign_type is set by _ext_clause */
	if (!ext_dyn_specified) {
		current_file->flag_assign_no_keyword = 1;
	}
	current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
  }
#line 17380 "parser.c"
    break;

  case 319: /* assign_clause: ASSIGN _to _ext_clause _assign_device_or_line_adv_file using_or_varying qualified_word  */
#line 5470 "parser.y"
  {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);
	if (ext_dyn_specified) {
		cb_error (_("EXTERNAL/DYNAMIC cannot be used with USING/VARYING"));
	}
	cb_verify (cb_assign_using_variable, "ASSIGN USING/VARYING variable");

	current_file->assign_type = CB_ASSIGN_VARIABLE_REQUIRED;
	current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
  }
#line 17395 "parser.c"
    break;

  case 320: /* assign_clause: ASSIGN _to _ext_clause DISK FROM qualified_word  */
#line 5481 "parser.y"
  {
	check_repeated ("ASSIGN", SYN_CLAUSE_1, &check_duplicate);
	if (ext_dyn_specified) {
		cb_error (_("EXTERNAL/DYNAMIC cannot be used with DISK FROM"));
	}
	cb_verify (cb_assign_disk_from, "ASSIGN DISK FROM");

	current_file->assign_type = CB_ASSIGN_VARIABLE_REQUIRED;
	current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
  }
#line 17410 "parser.c"
    break;

  case 321: /* assign_clause: ASSIGN _to _ext_clause assign_device  */
#line 5492 "parser.y"
  {
	if (assign_device == CB_ASSIGN_DISPLAY_DEVICE) {
		current_file->assign =
			cb_build_alphanumeric_literal ("stdout", (size_t)6);
		current_file->special = COB_SELECT_STDOUT;
	} else if (assign_device == CB_ASSIGN_KEYBOARD_DEVICE) {
		current_file->assign =
			cb_build_alphanumeric_literal ("stdin", (size_t)5);
		current_file->special = COB_SELECT_STDIN;
	} else if (assign_device == CB_ASSIGN_PRINTER_DEVICE) {
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		current_file->assign =
			cb_build_alphanumeric_literal ("PRINTER", (size_t)7);
	} else if (assign_device == CB_ASSIGN_PRINTER_1_DEVICE) {
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		current_file->assign =
			cb_build_alphanumeric_literal ("PRINTER-1", (size_t)9);
	} else if (assign_device == CB_ASSIGN_PRINT_DEVICE) {
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		current_file->assign =
			cb_build_alphanumeric_literal ("LPT1", (size_t)4);
	} else if (assign_device == CB_ASSIGN_LINE_SEQ_DEVICE
		   || assign_device == CB_ASSIGN_GENERAL_DEVICE) {
		current_file->flag_fileid = 1;
	}
  }
#line 17441 "parser.c"
    break;

  case 322: /* _assign_device_or_line_adv_file: %empty  */
#line 5522 "parser.y"
  {
	assign_device = CB_ASSIGN_NO_DEVICE;
  }
#line 17449 "parser.c"
    break;

  case 323: /* _assign_device_or_line_adv_file: line_adv_file  */
#line 5526 "parser.y"
  {
	assign_device = CB_ASSIGN_NO_DEVICE;
  }
#line 17457 "parser.c"
    break;

  case 325: /* assign_device: general_device_name  */
#line 5534 "parser.y"
  {
	assign_device = CB_ASSIGN_GENERAL_DEVICE;
  }
#line 17465 "parser.c"
    break;

  case 326: /* assign_device: line_seq_device_name  */
#line 5538 "parser.y"
  {
	current_file->organization = COB_ORG_LINE_SEQUENTIAL;
	assign_device = CB_ASSIGN_LINE_SEQ_DEVICE;
  }
#line 17474 "parser.c"
    break;

  case 327: /* assign_device: DISPLAY  */
#line 5543 "parser.y"
  {
	assign_device = CB_ASSIGN_DISPLAY_DEVICE;
  }
#line 17482 "parser.c"
    break;

  case 328: /* assign_device: KEYBOARD  */
#line 5547 "parser.y"
  {
	assign_device = CB_ASSIGN_KEYBOARD_DEVICE;
  }
#line 17490 "parser.c"
    break;

  case 329: /* assign_device: PRINTER  */
#line 5555 "parser.y"
  {
	assign_device = CB_ASSIGN_PRINTER_DEVICE;
	current_file->organization = COB_ORG_LINE_SEQUENTIAL;
	current_file->flag_line_adv = 1;
  }
#line 17500 "parser.c"
    break;

  case 330: /* assign_device: "PRINTER-1"  */
#line 5561 "parser.y"
  {
	assign_device = CB_ASSIGN_PRINTER_1_DEVICE;
	current_file->organization = COB_ORG_LINE_SEQUENTIAL;
	current_file->flag_line_adv = 1;
  }
#line 17510 "parser.c"
    break;

  case 331: /* assign_device: PRINT  */
#line 5567 "parser.y"
  {
	assign_device = CB_ASSIGN_PRINT_DEVICE;
	current_file->organization = COB_ORG_LINE_SEQUENTIAL;
	current_file->flag_line_adv = 1;
  }
#line 17520 "parser.c"
    break;

  case 343: /* line_adv_file: LINE ADVANCING _file  */
#line 5594 "parser.y"
  {
	current_file->flag_line_adv = 1;
  }
#line 17528 "parser.c"
    break;

  case 344: /* _ext_clause: %empty  */
#line 5601 "parser.y"
  {
	ext_dyn_specified = 0;
	current_file->assign_type = cb_assign_type_default;
  }
#line 17537 "parser.c"
    break;

  case 345: /* _ext_clause: ext_clause  */
#line 5606 "parser.y"
  {
	ext_dyn_specified = 1;
	cb_verify (cb_assign_ext_dyn, _("ASSIGN EXTERNAL/DYNAMIC"));
  }
#line 17546 "parser.c"
    break;

  case 346: /* ext_clause: EXTERNAL  */
#line 5614 "parser.y"
  {
	current_file->assign_type = CB_ASSIGN_EXT_FILE_NAME_REQUIRED;
  }
#line 17554 "parser.c"
    break;

  case 347: /* ext_clause: DYNAMIC  */
#line 5618 "parser.y"
  {
	current_file->assign_type = CB_ASSIGN_VARIABLE_REQUIRED;
  }
#line 17562 "parser.c"
    break;

  case 350: /* access_mode_clause: ACCESS _mode _is access_mode  */
#line 5632 "parser.y"
  {
	check_repeated ("ACCESS", SYN_CLAUSE_2, &check_duplicate);
  }
#line 17570 "parser.c"
    break;

  case 351: /* access_mode: SEQUENTIAL  */
#line 5638 "parser.y"
                        { current_file->access_mode = COB_ACCESS_SEQUENTIAL; }
#line 17576 "parser.c"
    break;

  case 352: /* access_mode: DYNAMIC  */
#line 5639 "parser.y"
                        { current_file->access_mode = COB_ACCESS_DYNAMIC; }
#line 17582 "parser.c"
    break;

  case 353: /* access_mode: RANDOM  */
#line 5640 "parser.y"
                        { current_file->access_mode = COB_ACCESS_RANDOM; }
#line 17588 "parser.c"
    break;

  case 354: /* alternate_record_key_clause: ALTERNATE _record _key _is reference _split_keys flag_duplicates _password_clause _suppress_clause  */
#line 5648 "parser.y"
  {
	struct cb_alt_key *p;
	struct cb_alt_key *l;

	cb_tree composite_key;

	p = cobc_parse_malloc (sizeof (struct cb_alt_key));
	p->key = yyvsp[-4];
	p->component_list = NULL;
	if (yyvsp[-2]) {
		p->duplicates = CB_INTEGER (yyvsp[-2])->val;
	} else {
		/* note: we may add a compiler configuration here,
		         as at least ICOBOL defaults to WITH DUPLICATES
		         for ALTERNATE keys if not explicit deactivated
		*/
		p->duplicates = 0;
	}
	p->password = yyvsp[-1];
	if (yyvsp[0]) {
		p->tf_suppress = 1;
		p->char_suppress = CB_INTEGER (yyvsp[0])->val;
	} else {
		p->tf_suppress = 0;
	}
	p->next = NULL;

	/* handle split keys */
	if (yyvsp[-3]) {
		/* generate field (in w-s) for composite-key */
		composite_key = cb_build_field(yyvsp[-4]);
		if (composite_key == cb_error_node) {
			YYERROR;
		} else {
			composite_key->category = CB_CATEGORY_ALPHANUMERIC;
			((struct cb_field *)composite_key)->count = 1;
			p->key = cb_build_field_reference((struct cb_field *)composite_key, NULL);
			p->component_list = key_component_list;
		}
	}

	/* Add to the end of list */
	if (current_file->alt_key_list == NULL) {
		current_file->alt_key_list = p;
	} else {
		l = current_file->alt_key_list;
		for (; l->next; l = l->next) { ; }
		l->next = p;
	}
  }
#line 17643 "parser.c"
    break;

  case 355: /* _password_clause: %empty  */
#line 5702 "parser.y"
  {
	yyval = NULL;
  }
#line 17651 "parser.c"
    break;

  case 357: /* $@30: %empty  */
#line 5710 "parser.y"
  {
	CB_PENDING ("PASSWORD clause");
  }
#line 17659 "parser.c"
    break;

  case 358: /* password_clause: PASSWORD $@30 _is reference  */
#line 5714 "parser.y"
  {
	yyval = yyvsp[0];
  }
#line 17667 "parser.c"
    break;

  case 359: /* encryption_clause: ENCRYPTION  */
#line 5722 "parser.y"
  {
	if (current_file->organization == COB_ORG_INDEXED) {
		cb_error (_("%s only valid with ORGANIZATION %s"), "WITH ENCRYPTION", "INDEXED");
	} else {
		CB_PENDING ("WITH ENCRYPTION");
		current_file->password = cb_int0;
	}
  }
#line 17680 "parser.c"
    break;

  case 360: /* _suppress_clause: %empty  */
#line 5734 "parser.y"
  {
	yyval = NULL;
  }
#line 17688 "parser.c"
    break;

  case 361: /* _suppress_clause: SUPPRESS WHEN ALL basic_value  */
#line 5738 "parser.y"
  {
	yyval = cb_int (cb_literal_value (yyvsp[0]));
  }
#line 17696 "parser.c"
    break;

  case 362: /* _suppress_clause: SUPPRESS WHEN space_or_zero  */
#line 5742 "parser.y"
  {
	yyval = cb_int (cb_literal_value (yyvsp[0]));
  }
#line 17704 "parser.c"
    break;

  case 363: /* collating_sequence_clause: collating_sequence  */
#line 5752 "parser.y"
  {
	check_repeated ("COLLATING", SYN_CLAUSE_3, &check_duplicate);
	current_file->collating_sequence = alphanumeric_collation;
	current_file->collating_sequence_n = national_collation;
	CB_PENDING ("FILE COLLATING SEQUENCE");
  }
#line 17715 "parser.c"
    break;

  case 365: /* coll_sequence_values: _is alphabet_name  */
#line 5767 "parser.y"
  {
	alphanumeric_collation = yyvsp[0];
  }
#line 17723 "parser.c"
    break;

  case 366: /* coll_sequence_values: _is alphabet_name alphabet_name  */
#line 5771 "parser.y"
  {
	alphanumeric_collation = yyvsp[-1];
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 17733 "parser.c"
    break;

  case 367: /* coll_sequence_values: _for ALPHANUMERIC _is alphabet_name  */
#line 5777 "parser.y"
  {
	alphanumeric_collation = yyvsp[0];
  }
#line 17741 "parser.c"
    break;

  case 368: /* coll_sequence_values: _for NATIONAL _is alphabet_name  */
#line 5781 "parser.y"
  {
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 17750 "parser.c"
    break;

  case 369: /* coll_sequence_values: _for ALPHANUMERIC _is alphabet_name _for NATIONAL _is alphabet_name  */
#line 5787 "parser.y"
  {
	alphanumeric_collation = yyvsp[-4];
	CB_PENDING_X (yyvsp[0], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[0];
  }
#line 17760 "parser.c"
    break;

  case 370: /* coll_sequence_values: _for NATIONAL _is alphabet_name _for ALPHANUMERIC _is alphabet_name  */
#line 5794 "parser.y"
  {
	CB_PENDING_X (yyvsp[-4], "NATIONAL COLLATING SEQUENCE");
	national_collation = yyvsp[-4];
	alphanumeric_collation = yyvsp[0];
  }
#line 17770 "parser.c"
    break;

  case 371: /* collating_sequence_clause_key: _collating SEQUENCE OF reference _is alphabet_name  */
#line 5803 "parser.y"
  {
	/* note: both entries must be resolved later on
	   and also attached to the correct key later, so just store in a list here: */
	current_file->collating_sequence_keys =
		cb_list_add(current_file->collating_sequence_keys, CB_BUILD_PAIR (yyvsp[0], yyvsp[-2]));
	CB_PENDING ("KEY COLLATING SEQUENCE");
  }
#line 17782 "parser.c"
    break;

  case 372: /* alphabet_name: "Identifier"  */
#line 5814 "parser.y"
  {
	if (CB_ALPHABET_NAME_P (cb_ref (yyvsp[0]))) {
		yyval = yyvsp[0];
	} else {
		cb_error_x (yyvsp[0], _("'%s' is not an alphabet-name"),
			cb_name (yyvsp[0]));
		yyval = cb_error_node;
	}
  }
#line 17796 "parser.c"
    break;

  case 373: /* alphabet_name: NATIVE  */
#line 5824 "parser.y"
  {
	yyval = build_colseq (CB_COLSEQ_NATIVE);
  }
#line 17804 "parser.c"
    break;

  case 374: /* alphabet_name: "STANDARD-1"  */
#line 5828 "parser.y"
  {
	yyval = build_colseq (CB_COLSEQ_ASCII);
  }
#line 17812 "parser.c"
    break;

  case 375: /* alphabet_name: "STANDARD-2"  */
#line 5832 "parser.y"
  {
	yyval = build_colseq (CB_COLSEQ_ASCII);
  }
#line 17820 "parser.c"
    break;

  case 376: /* alphabet_name: EBCDIC  */
#line 5836 "parser.y"
  {
	yyval = build_colseq (CB_COLSEQ_EBCDIC);
  }
#line 17828 "parser.c"
    break;

  case 377: /* alphabet_name: ASCII  */
#line 5840 "parser.y"
  {
	yyval = build_colseq (CB_COLSEQ_ASCII);
  }
#line 17836 "parser.c"
    break;

  case 378: /* file_status_clause: _file_or_sort STATUS _is reference _reference  */
#line 5849 "parser.y"
  {
	check_repeated ("STATUS", SYN_CLAUSE_4, &check_duplicate);
	current_file->file_status = yyvsp[-1];
	if (yyvsp[0]) {
		/* Ignore VSAM STATUS field */
		cb_verify (cb_vsam_status, _("VSAM status"));
	}
  }
#line 17849 "parser.c"
    break;

  case 382: /* $@31: %empty  */
#line 5868 "parser.y"
  {
	check_repeated ("LOCK", SYN_CLAUSE_5, &check_duplicate);
  }
#line 17857 "parser.c"
    break;

  case 384: /* lock_mode: MANUAL _lock_with  */
#line 5876 "parser.y"
  {
	current_file->lock_mode |= COB_LOCK_MANUAL;
  }
#line 17865 "parser.c"
    break;

  case 385: /* lock_mode: AUTOMATIC _lock_with  */
#line 5880 "parser.y"
  {
	current_file->lock_mode |= COB_LOCK_AUTOMATIC;
  }
#line 17873 "parser.c"
    break;

  case 386: /* lock_mode: EXCLUSIVE _with_mass_update  */
#line 5884 "parser.y"
  {
	current_file->lock_mode |= COB_LOCK_EXCLUSIVE;
  }
#line 17881 "parser.c"
    break;

  case 389: /* _lock_with: WITH _lock ON MULTIPLE lock_records _with_rollback  */
#line 5893 "parser.y"
  {
	current_file->lock_mode |= COB_LOCK_MULTIPLE;
  }
#line 17889 "parser.c"
    break;

  case 390: /* _lock_with: with_rollback  */
#line 5897 "parser.y"
  {
	current_file->lock_mode |= COB_LOCK_MULTIPLE;
  }
#line 17897 "parser.c"
    break;

  case 393: /* with_rollback: _with ROLLBACK  */
#line 5908 "parser.y"
  {
	CB_PENDING ("WITH ROLLBACK");
  }
#line 17905 "parser.c"
    break;

  case 395: /* _with_mass_update: _with "MASS-UPDATE"  */
#line 5915 "parser.y"
  {
	if (current_file->organization == COB_ORG_INDEXED) {
		current_file->lock_mode |= COB_LOCK_EXCLUSIVE;
		/* TODO: pass extra flag to fileio */
		CB_PENDING ("WITH MASS-UPDATE");
	} else {
		cb_error (_("%s only valid with ORGANIZATION %s"), "MASS-UPDATE", "INDEXED");
	}
  }
#line 17919 "parser.c"
    break;

  case 398: /* organization: INDEXED  */
#line 5936 "parser.y"
  {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	error_if_record_delimiter_incompatible (COB_ORG_INDEXED, "INDEXED");
	current_file->organization = COB_ORG_INDEXED;
  }
#line 17929 "parser.c"
    break;

  case 399: /* organization: _record _binary SEQUENTIAL  */
#line 5942 "parser.y"
  {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	error_if_record_delimiter_incompatible (COB_ORG_SEQUENTIAL, "SEQUENTIAL");
	current_file->organization = COB_ORG_SEQUENTIAL;
  }
#line 17939 "parser.c"
    break;

  case 400: /* organization: RELATIVE  */
#line 5948 "parser.y"
  {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	error_if_record_delimiter_incompatible (COB_ORG_RELATIVE, "RELATIVE");
	current_file->organization = COB_ORG_RELATIVE;
  }
#line 17949 "parser.c"
    break;

  case 401: /* organization: LINE SEQUENTIAL  */
#line 5954 "parser.y"
  {
	check_repeated ("ORGANIZATION", SYN_CLAUSE_6, &check_duplicate);
	error_if_record_delimiter_incompatible (COB_ORG_LINE_SEQUENTIAL,
						"LINE SEQUENTIAL");
	current_file->organization = COB_ORG_LINE_SEQUENTIAL;
  }
#line 17960 "parser.c"
    break;

  case 402: /* padding_character_clause: PADDING _character _is reference_or_literal  */
#line 5967 "parser.y"
  {
	check_repeated ("PADDING", SYN_CLAUSE_7, &check_duplicate);
	cb_verify (cb_padding_character_clause, "PADDING CHARACTER");
  }
#line 17969 "parser.c"
    break;

  case 403: /* $@32: %empty  */
#line 5977 "parser.y"
  {
	check_repeated ("RECORD DELIMITER", SYN_CLAUSE_8, &check_duplicate);
	current_file->flag_delimiter = 1;
  }
#line 17978 "parser.c"
    break;

  case 405: /* record_delimiter_option: "STANDARD-1"  */
#line 5986 "parser.y"
  {
	if (current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("RECORD DELIMITER %s only allowed with SEQUENTIAL files"),
			  "STANDARD-1");
		current_file->flag_delimiter = 0;
	} else if (cb_verify (cb_record_delimiter, _("RECORD DELIMITER clause"))) {
		cb_warning (cb_warn_additional,
			    _("%s ignored"), "RECORD DELIMITER STANDARD-1");
	}
  }
#line 17993 "parser.c"
    break;

  case 406: /* record_delimiter_option: "LINE-SEQUENTIAL"  */
#line 5997 "parser.y"
  {
	if (current_file->organization != COB_ORG_SEQUENTIAL
	 && current_file->organization != COB_ORG_LINE_SEQUENTIAL) {
		cb_error (_("RECORD DELIMITER %s only allowed with (LINE) SEQUENTIAL files"),
			  "LINE-SEQUENTIAL");
		current_file->flag_delimiter = 0;
	}

	if (cb_verify (cb_record_delimiter, _("RECORD DELIMITER clause"))
	 && cb_verify (cb_sequential_delimiters, _("LINE-SEQUENTIAL phrase"))) {
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
	}
  }
#line 18011 "parser.c"
    break;

  case 407: /* record_delimiter_option: "BINARY-SEQUENTIAL"  */
#line 6011 "parser.y"
  {
	if (current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("RECORD DELIMITER %s only allowed with SEQUENTIAL files"),
			  "BINARY-SEQUENTIAL");
		current_file->flag_delimiter = 0;
	}

	if (cb_verify (cb_record_delimiter, _("RECORD DELIMITER clause"))
	 && cb_verify (cb_sequential_delimiters, _("BINARY-SEQUENTIAL phrase"))) {
		current_file->organization = COB_ORG_SEQUENTIAL;
	}
  }
#line 18028 "parser.c"
    break;

  case 408: /* record_delimiter_option: "Identifier"  */
#line 6024 "parser.y"
  {
	if (current_file->organization != COB_ORG_SEQUENTIAL
	 && current_file->organization != COB_ORG_LINE_SEQUENTIAL) {
		cb_error (_("RECORD DELIMITER clause only allowed with (LINE) SEQUENTIAL files"));
		current_file->flag_delimiter = 0;
	} else if (cb_verify (cb_record_delimiter, _("RECORD DELIMITER clause"))) {
		cb_warning (cb_warn_additional,
			    _("RECORD DELIMITER %s not recognized; will be ignored"), cb_name (yyvsp[0]));
	}
  }
#line 18043 "parser.c"
    break;

  case 409: /* record_key_clause: RECORD _key _is reference _split_keys _password_clause flag_duplicates  */
#line 6040 "parser.y"
  {
	cb_tree composite_key;

	check_repeated ("RECORD KEY", SYN_CLAUSE_9, &check_duplicate);
	current_file->key = yyvsp[-3];
	key_type = RECORD_KEY;

	/* handle split keys */
	if (yyvsp[-2]) {
		/* generate field (in w-s) for composite-key */
		composite_key = cb_build_field (yyvsp[-3]);
		if (composite_key == cb_error_node) {
			YYERROR;
		} else {
			composite_key->category = CB_CATEGORY_ALPHANUMERIC;
			((struct cb_field *)composite_key)->count = 1;
			current_file->key = cb_build_field_reference ((struct cb_field *)composite_key, NULL);
			current_file->component_list = key_component_list;
		}
	}
	current_file->password = yyvsp[-1];
	if (yyvsp[0]) {
		/* note: we *may* add a compiler configuration here,
		         as most dialects do not allow this clause
		         on primary keys */
		if (CB_INTEGER (yyvsp[0])->val) {
			/* note: see ACUCOBOL docs for implementation notes, including [RE]WRITE rules
			         and "if the underlying (file) system does not support them OPEN
					 result in (sucessfull) io-status 0M" */
			CB_PENDING (_("DUPLICATES for primary keys"));
		};

	}
  }
#line 18082 "parser.c"
    break;

  case 410: /* _split_keys: %empty  */
#line 6078 "parser.y"
  {
  	yyval = NULL;
  }
#line 18090 "parser.c"
    break;

  case 411: /* _split_keys: source_is split_key_list  */
#line 6082 "parser.y"
  {
  	yyval = cb_int0;
  }
#line 18098 "parser.c"
    break;

  case 414: /* $@33: %empty  */
#line 6093 "parser.y"
  {
	key_component_list = NULL;
  }
#line 18106 "parser.c"
    break;

  case 417: /* split_key: reference  */
#line 6103 "parser.y"
  {
	struct cb_key_component *c;
	struct cb_key_component *comp = cobc_main_malloc (sizeof(struct cb_key_component));
	comp->next = NULL;
	comp->component = yyvsp[0];
	if (key_component_list == NULL) {
		key_component_list = comp;
	} else {
		for (c = key_component_list; c->next != NULL; c = c->next);
		c->next = comp;
	}
  }
#line 18123 "parser.c"
    break;

  case 418: /* relative_key_clause: RELATIVE _key _is reference  */
#line 6121 "parser.y"
  {
	check_repeated ("RELATIVE KEY", SYN_CLAUSE_10, &check_duplicate);
	current_file->key = yyvsp[0];
	key_type = RELATIVE_KEY;
  }
#line 18133 "parser.c"
    break;

  case 419: /* reserve_clause: RESERVE no_or_integer _areas  */
#line 6132 "parser.y"
  {
	check_repeated ("RESERVE", SYN_CLAUSE_11, &check_duplicate);
  }
#line 18141 "parser.c"
    break;

  case 422: /* sharing_clause: SHARING _with sharing_option  */
#line 6146 "parser.y"
  {
	check_repeated ("SHARING", SYN_CLAUSE_12, &check_duplicate);
	current_file->sharing = yyvsp[0];
  }
#line 18150 "parser.c"
    break;

  case 423: /* sharing_option: ALL _other  */
#line 6158 "parser.y"
                                { yyval = NULL; }
#line 18156 "parser.c"
    break;

  case 424: /* sharing_option: NO _other  */
#line 6159 "parser.y"
                                { yyval = cb_int (COB_LOCK_OPEN_EXCLUSIVE); }
#line 18162 "parser.c"
    break;

  case 425: /* sharing_option: READ ONLY  */
#line 6160 "parser.y"
                                { yyval = NULL; }
#line 18168 "parser.c"
    break;

  case 426: /* file_limit_clause: file_limit_or_limits _is_are thru_list  */
#line 6167 "parser.y"
  {
	(void)cb_verify (CB_OBSOLETE, "FILE-LIMIT");
	check_repeated ("FILE-LIMIT", SYN_CLAUSE_13, &check_duplicate);
  }
#line 18177 "parser.c"
    break;

  case 429: /* actual_key_clause: ACTUAL _key _is reference  */
#line 6182 "parser.y"
  {
	(void)cb_verify (CB_OBSOLETE, "ACTUAL KEY");
	check_repeated ("ACTUAL KEY", SYN_CLAUSE_14, &check_duplicate);
  }
#line 18186 "parser.c"
    break;

  case 430: /* nominal_key_clause: NOMINAL _key _is reference  */
#line 6192 "parser.y"
  {
	(void)cb_verify (CB_OBSOLETE, "NOMINAL KEY");
	check_repeated ("NOMINAL KEY", SYN_CLAUSE_15, &check_duplicate);
  }
#line 18195 "parser.c"
    break;

  case 431: /* track_area_clause: "TRACK-AREA" _is reference_or_literal _characters  */
#line 6202 "parser.y"
  {
	(void)cb_verify (CB_OBSOLETE, "TRACK-AREA");
	check_repeated ("TRACK-AREA", SYN_CLAUSE_16, &check_duplicate);
  }
#line 18204 "parser.c"
    break;

  case 432: /* track_limit_clause: "TRACK-LIMIT" _is integer track_or_tracks  */
#line 6212 "parser.y"
  {
	(void)cb_verify (CB_OBSOLETE, "TRACK-LIMIT");
	check_repeated ("TRACK-LIMIT", SYN_CLAUSE_17, &check_duplicate);
  }
#line 18213 "parser.c"
    break;

  case 434: /* _i_o_control: i_o_control_header _i_o_control_entries  */
#line 6223 "parser.y"
  {
	cobc_cs_check = 0;
  }
#line 18221 "parser.c"
    break;

  case 435: /* i_o_control_header: "I-O-CONTROL" _dot  */
#line 6230 "parser.y"
{
	check_headers_present(COBC_HD_ENVIRONMENT_DIVISION,
				 COBC_HD_INPUT_OUTPUT_SECTION, 0, 0);
	header_check |= COBC_HD_I_O_CONTROL;
}
#line 18231 "parser.c"
    break;

  case 438: /* _i_o_control_entries: i_o_control_list error dot_or_else_end_of_file_control  */
#line 6240 "parser.y"
  {
	yyerrok;
  }
#line 18239 "parser.c"
    break;

  case 445: /* same_clause: SAME _same_option _area _for file_name_list  */
#line 6261 "parser.y"
  {
	cb_tree l;

	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION,
			       COBC_HD_I_O_CONTROL, 0);
	switch (CB_INTEGER (yyvsp[-3])->val) {
	case 0:
		/* SAME AREA */
		break;
	case 1:
		/* SAME RECORD */
		for (l = yyvsp[0]; l; l = CB_CHAIN (l)) {
			if (CB_VALID_TREE (CB_VALUE (l))) {
				CB_FILE (cb_ref (CB_VALUE (l)))->same_clause = same_area;
			}
		}
		same_area++;
		break;
	case 2:
		/* SAME SORT-MERGE */
		break;
	}
  }
#line 18268 "parser.c"
    break;

  case 446: /* _same_option: %empty  */
#line 6288 "parser.y"
                                { yyval = cb_int0; }
#line 18274 "parser.c"
    break;

  case 447: /* _same_option: RECORD  */
#line 6289 "parser.y"
                                { yyval = cb_int1; }
#line 18280 "parser.c"
    break;

  case 448: /* _same_option: SORT  */
#line 6290 "parser.y"
                                { yyval = cb_int2; }
#line 18286 "parser.c"
    break;

  case 449: /* _same_option: "SORT-MERGE"  */
#line 6291 "parser.y"
                                { yyval = cb_int2; }
#line 18292 "parser.c"
    break;

  case 450: /* apply_clause: APPLY COMMIT _on reference_list  */
#line 6298 "parser.y"
  {
	current_program->apply_commit = yyvsp[0];
	CB_PENDING("APPLY COMMIT");
  }
#line 18301 "parser.c"
    break;

  case 451: /* apply_clause: APPLY "LOCK-HOLDING" _on file_name_list  */
#line 6303 "parser.y"
  {
	CB_PENDING ("APPLY LOCK-HOLDING");
  }
#line 18309 "parser.c"
    break;

  case 452: /* apply_clause: APPLY "PRINT-CONTROL" _on file_name_list  */
#line 6307 "parser.y"
  {
	CB_PENDING ("APPLY PRINT-CONTROL");
  }
#line 18317 "parser.c"
    break;

  case 454: /* apply_clause: obsolete_dos_vs_apply_phrase  */
#line 6312 "parser.y"
  {
	cb_verify (CB_OBSOLETE, _("DOS/VS APPLY phrase"));
  }
#line 18325 "parser.c"
    break;

  case 463: /* $@34: %empty  */
#line 6332 "parser.y"
  {
	/* Fake for TAPE */
	cobc_cs_check = CB_CS_ASSIGN;
  }
#line 18334 "parser.c"
    break;

  case 464: /* multiple_file_tape_clause: MULTIPLE $@34 _file _tape _contains multiple_file_list  */
#line 6337 "parser.y"
  {
	check_headers_present (COBC_HD_ENVIRONMENT_DIVISION,
			       COBC_HD_INPUT_OUTPUT_SECTION,
			       COBC_HD_I_O_CONTROL, 0);
	cb_verify (cb_multiple_file_tape_clause, "MULTIPLE FILE TAPE");
	cobc_cs_check = 0;
  }
#line 18346 "parser.c"
    break;

  case 487: /* $@35: %empty  */
#line 6417 "parser.y"
  {
	current_storage = CB_STORAGE_WORKING;
  }
#line 18354 "parser.c"
    break;

  case 491: /* data: DATA  */
#line 6432 "parser.y"
           { check_area_a_of ("DATA DIVISION"); }
#line 18360 "parser.c"
    break;

  case 492: /* data_division_header: data DIVISION _dot  */
#line 6435 "parser.y"
  {
	header_check |= COBC_HD_DATA_DIVISION;
  }
#line 18368 "parser.c"
    break;

  case 493: /* tok_file: "FILE"  */
#line 6442 "parser.y"
                   { check_area_a_of ("FILE SECTION"); }
#line 18374 "parser.c"
    break;

  case 495: /* _file_section_header: tok_file SECTION _dot  */
#line 6445 "parser.y"
  {
	current_storage = CB_STORAGE_FILE;
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_FILE_SECTION;
  }
#line 18384 "parser.c"
    break;

  case 498: /* file_description: file_description_entry _record_description_list  */
#line 6459 "parser.y"
  {
	if (CB_VALID_TREE (current_file)) {
		if (CB_VALID_TREE (yyvsp[0])) {
			/* Do not keep Record if this is really a report */
			if (!current_file->reports) {
				finalize_file (current_file, CB_FIELD (yyvsp[0]));
			}
		} else if (!current_file->reports) {
			cb_error (_("RECORD description missing or invalid"));
		}
	}
  }
#line 18401 "parser.c"
    break;

  case 499: /* $@36: %empty  */
#line 6477 "parser.y"
  {
	current_storage = CB_STORAGE_FILE;
	check_headers_present (COBC_HD_DATA_DIVISION,
			       COBC_HD_FILE_SECTION, 0, 0);
	check_duplicate = 0;
	if (CB_INVALID_TREE (yyvsp[0])) {
		current_file = NULL;
		YYERROR;
	}
	current_file = CB_FILE (cb_ref (yyvsp[0]));
	current_file->description_entry = yyvsp[0];
	if (CB_VALID_TREE (current_file)) {
		if (yyvsp[-1] == cb_int1) {
			current_file->organization = COB_ORG_SORT;
		}
		/* note: this is a HACK and should be moved */
		if (current_file->flag_finalized) {
			cb_error_x (yyvsp[0], _("duplicate file description for %s"),
				cb_name (CB_TREE (current_file)));
		}
	}
  }
#line 18428 "parser.c"
    break;

  case 501: /* file_description_entry: file_type error dot_or_else_end_of_file_description  */
#line 6501 "parser.y"
  {
	yyerrok;
  }
#line 18436 "parser.c"
    break;

  case 502: /* file_type: FD  */
#line 6508 "parser.y"
  {
	check_area_a_of ("FD");
	yyval = cb_int0;
  }
#line 18445 "parser.c"
    break;

  case 503: /* file_type: SD  */
#line 6513 "parser.y"
  {
	check_area_a_of ("SD");
	yyval = cb_int1;
  }
#line 18454 "parser.c"
    break;

  case 506: /* file_description_clause: _is EXTERNAL  */
#line 6525 "parser.y"
  {
	check_repeated ("EXTERNAL", SYN_CLAUSE_1, &check_duplicate);
#if	0	/* RXWRXW - Global/External */
	if (current_file->flag_global) {
		cb_error (_("%s and %s are mutually exclusive"), "EXTERNAL", "GLOBAL");
	}
#endif
	current_file->flag_external = 1;
  }
#line 18468 "parser.c"
    break;

  case 507: /* file_description_clause: _is GLOBAL  */
#line 6535 "parser.y"
  {
	check_repeated ("GLOBAL", SYN_CLAUSE_2, &check_duplicate);
#if	0	/* RXWRXW - Global/External */
	if (current_file->flag_external) {
		cb_error (_("%s and %s are mutually exclusive"), "EXTERNAL", "GLOBAL");
	}
#endif
	if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("%s is invalid in a user FUNCTION"), "GLOBAL");
	} else {
		current_file->flag_global = 1;
		current_program->flag_file_global = 1;
	}
  }
#line 18487 "parser.c"
    break;

  case 517: /* block_contains_clause: BLOCK _contains integer _to_integer _records_or_characters  */
#line 6565 "parser.y"
  {
	check_repeated ("BLOCK", SYN_CLAUSE_3, &check_duplicate);
	/* ignore */
  }
#line 18496 "parser.c"
    break;

  case 521: /* record_clause: RECORD _contains integer _characters  */
#line 6578 "parser.y"
  {
	check_repeated ("RECORD", SYN_CLAUSE_4, &check_duplicate);
	if (current_file->organization == COB_ORG_LINE_SEQUENTIAL) {
		cb_warning (cb_warn_additional, _("RECORD clause ignored for LINE SEQUENTIAL"));
	} else {
		set_record_size (NULL, yyvsp[-1]);
	}
  }
#line 18509 "parser.c"
    break;

  case 522: /* record_clause: RECORD _contains integer TO integer _characters _record_depending  */
#line 6588 "parser.y"
  {
	check_repeated ("RECORD", SYN_CLAUSE_4, &check_duplicate);
	if (current_file->organization == COB_ORG_LINE_SEQUENTIAL) {
		cb_warning (cb_warn_additional, _("RECORD clause ignored for LINE SEQUENTIAL"));
	} else {
		set_record_size (yyvsp[-4], yyvsp[-2]);
		if (yyvsp[0]) {
			cb_verify (cb_record_contains_depending_clause, "RECORD CONTAINS DEPENDING");
			current_file->record_depending = yyvsp[0];
			current_file->flag_check_record_varying_limits =
				current_file->record_min == 0 || current_file->record_max == 0;
		}
	}
  }
#line 18528 "parser.c"
    break;

  case 523: /* record_clause: RECORD _is VARYING _in _size _from_integer _to_integer _characters _record_depending  */
#line 6604 "parser.y"
  {
	check_repeated ("RECORD", SYN_CLAUSE_4, &check_duplicate);
	set_record_size (yyvsp[-3], yyvsp[-2]);
	current_file->record_depending = yyvsp[0];
	current_file->flag_check_record_varying_limits =
		current_file->record_min == 0 || current_file->record_max == 0;
  }
#line 18540 "parser.c"
    break;

  case 524: /* _record_depending: %empty  */
#line 6614 "parser.y"
                                { yyval = NULL; }
#line 18546 "parser.c"
    break;

  case 525: /* _record_depending: DEPENDING _on reference  */
#line 6615 "parser.y"
                                { yyval = yyvsp[0]; }
#line 18552 "parser.c"
    break;

  case 526: /* _from_integer: %empty  */
#line 6619 "parser.y"
                                { yyval = NULL; }
#line 18558 "parser.c"
    break;

  case 527: /* _from_integer: _from integer  */
#line 6620 "parser.y"
                                { yyval = yyvsp[0]; }
#line 18564 "parser.c"
    break;

  case 528: /* _to_integer: %empty  */
#line 6624 "parser.y"
                                { yyval = NULL; }
#line 18570 "parser.c"
    break;

  case 529: /* _to_integer: TO integer  */
#line 6625 "parser.y"
                                { yyval = yyvsp[0]; }
#line 18576 "parser.c"
    break;

  case 530: /* label_records_clause: LABEL records label_option  */
#line 6633 "parser.y"
  {
	check_repeated ("LABEL", SYN_CLAUSE_5, &check_duplicate);
	cb_verify (cb_label_records_clause, "LABEL RECORDS");
  }
#line 18585 "parser.c"
    break;

  case 531: /* value_of_clause: VALUE OF file_id _is valueof_name  */
#line 6644 "parser.y"
  {
	check_repeated ("VALUE OF", SYN_CLAUSE_6, &check_duplicate);
	cb_verify (cb_value_of_clause, "VALUE OF");
  }
#line 18594 "parser.c"
    break;

  case 532: /* value_of_clause: VALUE OF "FILE-ID" _is valueof_name  */
#line 6649 "parser.y"
  {
	check_repeated ("VALUE OF", SYN_CLAUSE_6, &check_duplicate);
	cb_verify (cb_value_of_clause, "VALUE OF");
	if (!current_file->assign) {
		current_file->assign = cb_build_assignment_name (current_file, yyvsp[0]);
	}
  }
#line 18606 "parser.c"
    break;

  case 537: /* data_records_clause: DATA records optional_reference_list  */
#line 6672 "parser.y"
  {
	check_repeated ("DATA", SYN_CLAUSE_7, &check_duplicate);
	cb_verify (cb_data_records_clause, "DATA RECORDS");
  }
#line 18615 "parser.c"
    break;

  case 538: /* linage_clause: LINAGE _is reference_or_literal _lines _linage_sequence  */
#line 6684 "parser.y"
  {
	check_repeated ("LINAGE", SYN_CLAUSE_8, &check_duplicate);
	if (current_file->organization != COB_ORG_LINE_SEQUENTIAL &&
	    current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("LINAGE clause with wrong file type"));
	} else {
		current_file->linage = yyvsp[-2];
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		if (current_linage == 0) {
			linage_file = current_file;
		}
		current_linage++;
	}
  }
#line 18634 "parser.c"
    break;

  case 544: /* linage_footing: _with FOOTING _at reference_or_literal  */
#line 6712 "parser.y"
  {
	current_file->latfoot = yyvsp[0];
  }
#line 18642 "parser.c"
    break;

  case 545: /* linage_top: TOP reference_or_literal  */
#line 6719 "parser.y"
  {
	current_file->lattop = yyvsp[0];
  }
#line 18650 "parser.c"
    break;

  case 546: /* linage_bottom: BOTTOM reference_or_literal  */
#line 6726 "parser.y"
  {
	current_file->latbot = yyvsp[0];
  }
#line 18658 "parser.c"
    break;

  case 547: /* recording_mode_clause: RECORDING _mode _is recording_mode  */
#line 6735 "parser.y"
  {
	cobc_cs_check ^= CB_CS_RECORDING;
	check_repeated ("RECORDING", SYN_CLAUSE_9, &check_duplicate);
	/* ignore */
  }
#line 18668 "parser.c"
    break;

  case 552: /* recording_mode: u_or_s  */
#line 6748 "parser.y"
  {
	if (current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("RECORDING MODE U or S can only be used with RECORD SEQUENTIAL files"));
	}
  }
#line 18678 "parser.c"
    break;

  case 555: /* code_set_clause: "CODE-SET" _is alphabet_name _for_sub_records_clause  */
#line 6764 "parser.y"
  {
	struct cb_alphabet_name	*al;

	check_repeated ("CODE SET", SYN_CLAUSE_10, &check_duplicate);

	if (CB_VALID_TREE (yyvsp[-1])) {
		al = CB_ALPHABET_NAME (cb_ref (yyvsp[-1]));
		/* FIXME: should be set depending on program alphabet */
		switch (al->alphabet_type) {
		case CB_ALPHABET_CUSTOM:
			CB_PENDING ("custom CODE-SET");
			current_file->code_set = al;
			break;
#ifdef	COB_EBCDIC_MACHINE
		case CB_ALPHABET_ASCII:
#else
		case CB_ALPHABET_EBCDIC:
#endif
			CB_UNFINISHED ("CODE-SET");
			current_file->code_set = al;
			break;
		default:
			if (get_warn_opt_value (cb_warn_additional) != COBC_WARN_DISABLED) {
				cb_note_x (cb_warn_additional, yyvsp[-1], _("ignoring CODE-SET '%s'"),
						  cb_name (yyvsp[-1]));
			}
			break;
		}
	}

	if (current_file->organization != COB_ORG_LINE_SEQUENTIAL &&
	    current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("CODE-SET clause invalid for file type"));
	}

  }
#line 18719 "parser.c"
    break;

  case 557: /* _for_sub_records_clause: FOR reference_list  */
#line 6804 "parser.y"
  {
	  current_file->code_set_items = CB_LIST (yyvsp[0]);
  }
#line 18727 "parser.c"
    break;

  case 558: /* report_clause: report_keyword rep_name_list  */
#line 6813 "parser.y"
  {
	check_repeated ("REPORT", SYN_CLAUSE_11, &check_duplicate);
	if (current_file->organization != COB_ORG_LINE_SEQUENTIAL &&
	    current_file->organization != COB_ORG_SEQUENTIAL) {
		cb_error (_("REPORT clause with wrong file type"));
	} else {
		current_file->reports = yyvsp[0];
		current_file->organization = COB_ORG_LINE_SEQUENTIAL;
		current_file->flag_line_adv = 1;
	}
  }
#line 18743 "parser.c"
    break;

  case 561: /* rep_name_list: undefined_word_but_no_error  */
#line 6833 "parser.y"
  {
	if (CB_VALID_TREE (yyvsp[0])) {
		current_report = build_report (yyvsp[0]);
		current_report->file = current_file;
		current_program->report_list =
			cb_list_add (current_program->report_list,
				     CB_TREE (current_report));
		if (report_count == 0) {
			report_instance = current_report;
		}
		report_count++;
	}
  }
#line 18761 "parser.c"
    break;

  case 562: /* rep_name_list: rep_name_list undefined_word_but_no_error  */
#line 6847 "parser.y"
  {
	if (CB_VALID_TREE (yyvsp[0])) {
		current_report = build_report (yyvsp[0]);
		current_report->file = current_file;
		current_program->report_list =
			cb_list_add (current_program->report_list,
				     CB_TREE (current_report));
#if 0	/* not possible, as long as we don't have this code
     	   twice instead of in a function */
		if (report_count == 0) {
			report_instance = current_report;
		}
#endif
		report_count++;
	}
  }
#line 18782 "parser.c"
    break;

  case 563: /* communication: COMMUNICATION  */
#line 6867 "parser.y"
                             { check_area_a_of ("COMMUNICATION SECTION"); }
#line 18788 "parser.c"
    break;

  case 565: /* $@37: %empty  */
#line 6870 "parser.y"
  {
	current_storage = CB_STORAGE_COMMUNICATION;
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_COMMUNICATION_SECTION;
	/* add a compiler configuration if either */
	if (cb_std_define != CB_STD_85
	 && cb_std_define != CB_STD_RM
	 && cb_std_define != CB_STD_GC
	 && !cb_relaxed_syntax_checks) {
		cb_verify (CB_UNCONFORMABLE, "COMMUNICATION SECTION");
	} else if (cb_verify (CB_OBSOLETE, "COMMUNICATION SECTION")) {
		CB_PENDING ("COMMUNICATION SECTION");
	}
  }
#line 18807 "parser.c"
    break;

  case 569: /* communication_description: communication_description_entry _record_description_list  */
#line 6894 "parser.y"
  {
	if (CB_VALID_TREE (current_cd)) {
		if (CB_VALID_TREE (yyvsp[0])) {
			cb_finalize_cd (current_cd, CB_FIELD (yyvsp[0]));
		} else if (!current_cd->record) {
			cb_error (_("CD record missing"));
		}
	}
  }
#line 18821 "parser.c"
    break;

  case 570: /* cd: CD  */
#line 6907 "parser.y"
       { check_area_a_of ("CD"); }
#line 18827 "parser.c"
    break;

  case 571: /* $@38: %empty  */
#line 6910 "parser.y"
  {
	/* CD internally defines a new file */
	if (CB_VALID_TREE (yyvsp[0])) {
		current_cd = cb_build_cd (yyvsp[0]);

		CB_ADD_TO_CHAIN (CB_TREE (current_cd),
				 current_program->cd_list);
	} else {
		current_cd = NULL;
		/* TODO: Is this necessary? */
		if (current_program->cd_list) {
			current_program->cd_list
				= CB_CHAIN (current_program->cd_list);
		}
	}
	check_duplicate = 0;
  }
#line 18849 "parser.c"
    break;

  case 618: /* working_storage: "WORKING-STORAGE"  */
#line 7017 "parser.y"
                                 { check_area_a_of ("WORKING-STORAGE SECTION"); }
#line 18855 "parser.c"
    break;

  case 620: /* $@39: %empty  */
#line 7021 "parser.y"
  {
	check_headers_present (COBC_HD_DATA_DIVISION, 0, 0, 0);
	header_check |= COBC_HD_WORKING_STORAGE_SECTION;
	current_storage = CB_STORAGE_WORKING;
  }
#line 18865 "parser.c"
    break;

  case 621: /* _working_storage_section: working_storage SECTION dot_or_else_end_of_record_description $@39 _record_description_list  */
#line 7027 "parser.y"
  {
	if (yyvsp[0]) {
		CB_FIELD_ADD (current_program->working_storage, CB_FIELD (yyvsp[0]));
	}
  }
#line 18875 "parser.c"
    break;

  case 622: /* _record_description_list: %empty  */
#line 7036 "parser.y"
  {
	yyval = NULL;
  }
#line 18883 "parser.c"
    break;

  case 623: /* $@40: %empty  */
#line 7040 "parser.y"
  {
	current_field = NULL;
	control_field = NULL;
	description_field = NULL;
	cb_clear_real_field ();
  }
#line 18894 "parser.c"
    break;

  case 624: /* _record_description_list: $@40 record_description_list  */
#line 7047 "parser.y"
  {
	yyval = get_finalized_description_tree ();
  }
#line 18902 "parser.c"
    break;

  case 630: /* $@41: %empty  */
#line 7062 "parser.y"
  {
	const int level = cb_get_level (yyvsp[-1]);
	if (current_field && !CB_INVALID_TREE (current_field->external_definition)) {
		/* finalize last field if target of SAME AS / type-name */
		inherit_external_definition (level);
	}
	if (set_current_field (level, yyvsp[0])) {
		YYERROR;
	}
	save_tree = NULL;
  }
#line 18918 "parser.c"
    break;

  case 631: /* data_description: level_number _entry_name $@41 _data_description_clause_sequence  */
#line 7074 "parser.y"
  {
	if (!qualifier) {
		current_field->flag_filler = 1;
	}
	if (!description_field) {
		description_field = current_field;
	}
  }
#line 18931 "parser.c"
    break;

  case 632: /* data_description: level_number _entry_name error "."  */
#line 7083 "parser.y"
  {
	/* note: this construct "eats" the error, the actual field
	   definition (level + name) is already parsed and added to the tree */
	yyerrok;
	cb_unput_dot ();
	check_pic_duplicate = 0;
	check_duplicate = 0;
#if 0 /* CHECKME - *Why* would we want to change the field here? */
	current_field = cb_get_real_field ();
#endif
  }
#line 18947 "parser.c"
    break;

  case 633: /* level_number: not_const_word "level-number"  */
#line 7118 "parser.y"
  {
	const int	level = cb_get_level (yyvsp[0]);
	switch (level) {
	case 1:
	case 77:
		check_area_a (yyvsp[0]);
		break;
	default:
		break;
	}
	yyval = yyvsp[0];
  }
#line 18964 "parser.c"
    break;

  case 634: /* level_number: not_const_word "level-number (Area A)"  */
#line 7131 "parser.y"
  {
	yyval = yyvsp[0];
  }
#line 18972 "parser.c"
    break;

  case 637: /* _entry_name: _filler  */
#line 7143 "parser.y"
  {
	yyval = cb_build_filler ();
	qualifier = NULL;
	keys_list = NULL;
	non_const_word = 0;
  }
#line 18983 "parser.c"
    break;

  case 639: /* user_entry_name: "Identifier"  */
#line 7154 "parser.y"
  {
	yyval = yyvsp[0];
	qualifier = yyvsp[0];
	keys_list = NULL;
	non_const_word = 0;
  }
#line 18994 "parser.c"
    break;

  case 640: /* _const_global: %empty  */
#line 7164 "parser.y"
  {
	yyval = NULL;
  }
#line 19002 "parser.c"
    break;

  case 641: /* _const_global: _is GLOBAL  */
#line 7168 "parser.y"
  {
	if (current_program->prog_type == COB_MODULE_TYPE_FUNCTION) {
		cb_error (_("%s is invalid in a user FUNCTION"), "GLOBAL");
		yyval = NULL;
	} else {
		yyval = cb_null;
	}
  }
#line 19015 "parser.c"
    break;

  case 642: /* lit_or_length: literal  */
#line 7179 "parser.y"
                                        { yyval = yyvsp[0]; }
#line 19021 "parser.c"
    break;

  case 643: /* lit_or_length: length_of_register con_source  */
#line 7180 "parser.y"
                                                { yyval = cb_build_const_length (yyvsp[0]); }
#line 19027 "parser.c"
    break;

  case 644: /* lit_or_length: "BYTE-LENGTH" _of con_source  */
#line 7182 "parser.y"
                                { yyval = cb_build_const_length (yyvsp[0]); }
#line 19033 "parser.c"
    break;

  case 645: /* con_source: identifier_1  */
#line 7187 "parser.y"
  {
	yyval = yyvsp[0];
  }
#line 19041 "parser.c"
    break;

  case 646: /* con_source: non_numeric_literal  */
#line 7191 "parser.y"
  {
	yyval = yyvsp[0];
  }
#line 19049 "parser.c"
    break;

  case 647: /* con_source: "BINARY-CHAR"  */
#line 7197 "parser.y"
  {
	yyval = cb_int1;
  }
#line 19057 "parser.c"
    break;

  case 648: /* con_source: "BINARY-SHORT"  */
#line 7201 "parser.y"
  {
	yyval = cb_int2;
  }
#line 19065 "parser.c"
    break;

  case 649: /* con_source: "BINARY-LONG"  */
#line 7205 "parser.y"
  {
	yyval = cb_int4;
  }
#line 19073 "parser.c"
    break;

  case 650: /* con_source: "BINARY-DOUBLE"  */
#line 7209 "parser.y"
  {
	yyval = cb_int8;
  }
#line 19081 "parser.c"
    break;

  case 651: /* con_source: "BINARY-C-LONG"  */
#line 7213 "parser.y"
  {
	yyval = cb_int ((int)sizeof(long));
  }
#line 19089 "parser.c"
    break;

  case 652: /* con_source: pointer_len  */
#line 7217 "parser.y"
  {
	yyval = cb_int ((int)sizeof(void *));
  }
#line 19097 "parser.c"
    break;

  case 653: /* con_source: "COMP-1"  */
#line 7221 "parser.y