/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.ehcache;

import java.io.IOException;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class EhCacheManagerFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Resource configLocation;
    private boolean shared = false;
    private String cacheManagerName;
    private CacheManager cacheManager;

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public void setCacheManagerName(String cacheManagerName) {
        this.cacheManagerName = cacheManagerName;
    }

    public void afterPropertiesSet() throws IOException, CacheException {
        this.logger.info("Initializing EHCache CacheManager");
        this.cacheManager = this.shared ? (this.configLocation != null ? CacheManager.create(this.configLocation.getInputStream()) : CacheManager.create()) : (this.configLocation != null ? new CacheManager(this.configLocation.getInputStream()) : new CacheManager());
        if (this.cacheManagerName != null) {
            this.cacheManager.setName(this.cacheManagerName);
        }
    }

    public Object getObject() {
        return this.cacheManager;
    }

    public Class getObjectType() {
        return this.cacheManager != null ? this.cacheManager.getClass() : CacheManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        this.logger.info("Shutting down EHCache CacheManager");
        this.cacheManager.shutdown();
    }
}

