(ert-deftest elpy-find--test-file-should-return-nil-if-not-found ()
  (elpy-testcase ((:project project-root "foo.py"))
    (find-file (f-join project-root "foo.py"))
    (elpy-set-project-root project-root)

    (defun projectile-find-file ())
    (when (require 'projectile nil t)
    (fmakunbound 'find-file-in-project)
    (should (equal (elpy-find--test-file)
                   nil)))
    (defun find-file-in-project ())
    (require 'find-file-in-project)
    (fmakunbound 'projectile-find-file)
    (should (equal (elpy-find--test-file)
                   nil))))

(ert-deftest elpy-find--test-file-should-find-test-file-same-directory ()
  (elpy-testcase ((:project project-root "foo.py" "test_foo.py"))
    (find-file (f-join project-root "foo.py"))
    (elpy-set-project-root project-root)

    (defun projectile-find-file ())
    (when (require 'projectile nil t)
    (fmakunbound 'find-file-in-project)
    (should (f-equal? (elpy-find--test-file)
                      (f-join project-root "test_foo.py"))))
    (defun find-file-in-project ())
    (require 'find-file-in-project)
    (fmakunbound 'projectile-find-file)
    (should (f-equal? (elpy-find--test-file)
                      (f-join project-root "test_foo.py")))))

(ert-deftest elpy-find--test-file-should-find-test-file-in-test-directory ()
  (elpy-testcase ((:project project-root "foo.py" "test/test_foo.py"))
    (find-file (f-join project-root "foo.py"))
    (elpy-set-project-root project-root)

    (defun projectile-find-file ())
    (when (require 'projectile nil t)
    (fmakunbound 'find-file-in-project)
    (should (f-equal? (elpy-find--test-file)
                      (f-join project-root "test/test_foo.py"))))
    (defun find-file-in-project ())
    (require 'find-file-in-project)
    (fmakunbound 'projectile-find-file)
    (should (f-equal? (elpy-find--test-file)
                      (f-join project-root "test/test_foo.py")))))

(ert-deftest elpy-find--test-file-should-find-test-file-in-tests-directory ()
  (elpy-testcase ((:project project-root "foo.py" "tests/test_foo.py"))
    (find-file (f-join project-root "foo.py"))
    (elpy-set-project-root project-root)

    (defun projectile-find-file ())
    (when (require 'projectile nil t)
    (fmakunbound 'find-file-in-project)
    (should (f-equal? (elpy-find--test-file)
                      (f-join project-root "tests/test_foo.py"))))
    (defun find-file-in-project ())
    (require 'find-file-in-project)
    (fmakunbound 'projectile-find-file)
    (should (f-equal? (elpy-find--test-file)
                      (f-join project-root "tests/test_foo.py")))))

(ert-deftest elpy-find--test-file-should-find-test-file-in-test-superdirectory ()
  (elpy-testcase ((:project project-root "pkg/foo.py" "test/test_foo.py"))
    (find-file (f-join project-root "pkg/foo.py"))
    (elpy-set-project-root project-root)

    (defun projectile-find-file ())
    (when (require 'projectile nil t)
    (fmakunbound 'find-file-in-project)
    (should (f-equal? (elpy-find--test-file)
                      (f-join project-root "test/test_foo.py"))))
    (defun find-file-in-project ())
    (require 'find-file-in-project)
    (fmakunbound 'projectile-find-file)
    (should (f-equal? (elpy-find--test-file)
                      (f-join project-root "test/test_foo.py")))))

(ert-deftest elpy-find--test-file-should-find-test-file-in-tests-superdirectory ()
  (elpy-testcase ((:project project-root "pkg/foo.py" "tests/test_foo.py"))
    (find-file (f-join project-root "pkg/foo.py"))
    (elpy-set-project-root project-root)

    (defun projectile-find-file ())
    (when (require 'projectile nil t)
    (fmakunbound 'find-file-in-project)
    (should (f-equal? (elpy-find--test-file)
                      (f-join project-root "tests/test_foo.py"))))
    (defun find-file-in-project ())
    (require 'find-file-in-project)
    (fmakunbound 'projectile-find-file)
    (should (f-equal? (elpy-find--test-file)
                      (f-join project-root "tests/test_foo.py")))))

(ert-deftest elpy-find--test-file-should-find-implementation-file-same-directory ()
  (elpy-testcase ((:project project-root "foo.py" "test_foo.py"))
    (find-file (f-join project-root "test_foo.py"))
    (elpy-set-project-root project-root)

    (defun projectile-find-file ())
    (when (require 'projectile nil t)
    (fmakunbound 'find-file-in-project)
    (should (f-equal? (elpy-find--test-file)
                      (f-join project-root "foo.py"))))
    (defun find-file-in-project ())
    (require 'find-file-in-project)
    (fmakunbound 'projectile-find-file)
    (should (f-equal? (elpy-find--test-file)
                      (f-join project-root "foo.py")))))

(ert-deftest elpy-find--test-file-should-find-implementation-file-superdirectory ()
  (elpy-testcase ((:project project-root "foo.py" "tests/test_foo.py"))
    (find-file (f-join project-root "tests/test_foo.py"))
    (elpy-set-project-root project-root)

    (defun projectile-find-file ())
    (when (require 'projectile nil t)
    (fmakunbound 'find-file-in-project)
    (should (f-equal? (elpy-find--test-file)
                      (f-join project-root "foo.py"))))
    (defun find-file-in-project ())
    (require 'find-file-in-project)
    (fmakunbound 'projectile-find-file)
    (should (f-equal? (elpy-find--test-file)
                      (f-join project-root "foo.py")))))
