﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

namespace System.Windows.Forms;

/// <summary>
///  Specifies the appearance of a <see cref="ListViewGroup"/>.
/// </summary>
public enum ListViewGroupCollapsedState
{
    /// <summary>
    ///  Non-collapsible group, expanded.
    /// </summary>
    Default,

    /// <summary>
    ///  Collapsible group, expanded.
    /// </summary>
    Expanded,

    /// <summary>
    ///  Collapsible group, collapsed.
    /// </summary>
    Collapsed
}
