/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.prc;

import com.kreative.ksfl.KSFLUtilities;
import com.kreative.prc.PalmResource;
import com.kreative.prc.PalmResourceAlreadyExistsException;
import com.kreative.prc.PalmResourceProvider;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;

public class PalmResourceFile
extends PalmResourceProvider {
    public static final int CREATE_NEVER = 0;
    public static final int CREATE_IF_EMPTY = 1;
    public static final int CREATE_ALWAYS = 2;
    private RandomAccessFile raf;
    private boolean readOnly = false;
    private static final int INSERTED_OBJECT_RECORD = 2;
    private static final int INSERTED_DATA = 4;
    private static final int REMOVED_OBJECT_RECORD = 2;
    private static final int REMOVED_DATA = 4;

    private int[] locate(int type, short id) {
        try {
            this.raf.seek(76L);
            int n = this.raf.readShort();
            int i = 0;
            int h = 78;
            while (i < n) {
                int t = this.raf.readInt();
                short d = this.raf.readShort();
                int o = this.raf.readInt();
                if (t == type && d == id) {
                    int o2;
                    if (i == n - 1) {
                        o2 = (int)this.raf.length();
                    } else {
                        this.raf.skipBytes(6);
                        o2 = this.raf.readInt();
                    }
                    return new int[]{n, h, 10, o, o2 - o};
                }
                ++i;
                h += 10;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private int[] locateend() {
        try {
            this.raf.seek(76L);
            short n = this.raf.readShort();
            int[] nArray = new int[5];
            nArray[0] = n;
            nArray[1] = 78 + 10 * n;
            nArray[2] = 10;
            nArray[3] = (int)this.raf.length();
            return nArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void cut(int[] loc, int offset, int length, int what, int type, short id) throws IOException {
        KSFLUtilities.cut(this.raf, (long)offset, length);
        if (loc != null) {
            if (what == 2) {
                loc[0] = loc[0] - 1;
            }
            if (loc[1] > offset) {
                loc[1] = loc[1] - length;
            }
            if (loc[3] > offset) {
                loc[3] = loc[3] - length;
            }
        }
        this.raf.seek(76L);
        int n = this.raf.readShort();
        if (what == 2) {
            this.raf.seek(76L);
            n = n - 1;
            this.raf.writeShort(n);
        }
        int i = 0;
        int h = 78;
        while (i < n) {
            this.raf.seek(h + 6);
            int o = this.raf.readInt();
            if (o > offset) {
                this.raf.seek(h + 6);
                this.raf.writeInt(o - length);
            }
            ++i;
            h += 10;
        }
    }

    private void paste(int[] loc, int offset, byte[] stuff, int what, int type, short id) throws IOException {
        boolean found = false;
        KSFLUtilities.paste(this.raf, (long)offset, stuff);
        if (loc != null) {
            if (what == 2) {
                loc[0] = loc[0] + 1;
            }
            if (loc[1] > offset || loc[1] == offset && what != 2) {
                loc[1] = loc[1] + stuff.length;
            }
            if (loc[3] > offset || loc[3] == offset && what != 4) {
                loc[3] = loc[3] + stuff.length;
            }
        }
        this.raf.seek(76L);
        int n = this.raf.readShort();
        if (what == 2) {
            this.raf.seek(76L);
            n = n + 1;
            this.raf.writeShort(n);
        }
        int i = 0;
        int h = 78;
        while (i < n) {
            int t = this.raf.readInt();
            short d = this.raf.readShort();
            int o = this.raf.readInt();
            if (o > offset || o == offset && (what != 4 || found)) {
                this.raf.seek(h + 6);
                this.raf.writeInt(o + stuff.length);
            }
            found = found || type == t && id == d;
            ++i;
            h += 10;
        }
    }

    public PalmResourceFile(File f, String mode, int create) throws IOException {
        this.raf = new RandomAccessFile(f, mode);
        this.readOnly = mode.equalsIgnoreCase("r");
        if (create == 2 || create == 1 && this.raf.length() == 0L) {
            this.raf.setLength(0L);
            this.raf.seek(0L);
            this.raf.write(new byte[32]);
            this.raf.writeShort(1);
            this.raf.writeShort(1);
            this.raf.writeInt(0);
            this.raf.writeInt(0);
            this.raf.writeInt(0);
            this.raf.writeInt(0);
            this.raf.writeInt(0);
            this.raf.writeInt(0);
            this.raf.writeInt(1634758764);
            this.raf.writeInt(0);
            this.raf.writeInt(0);
            this.raf.writeInt(0);
            this.raf.writeShort(0);
            this.raf.writeShort(0);
        }
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.raf;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public synchronized void flush() {
    }

    @Override
    public synchronized void close() {
        try {
            this.raf.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized byte[] getPRCHeader() {
        byte[] h = new byte[78];
        try {
            this.raf.seek(0L);
            this.raf.read(h);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return h;
    }

    @Override
    public synchronized void setPRCHeader(byte[] header) {
        if (header.length > 76) {
            header = KSFLUtilities.copy(header, 0, 76);
        }
        try {
            this.raf.seek(0L);
            this.raf.write(header);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized boolean add(PalmResource r) throws PalmResourceAlreadyExistsException {
        try {
            if (this.locate(r.type, r.id) != null) {
                throw new PalmResourceAlreadyExistsException();
            }
            int[] loc = this.locateend();
            byte[] rcd = new byte[10];
            KSFLUtilities.putInt(rcd, 0, r.type);
            KSFLUtilities.putShort(rcd, 4, r.id);
            KSFLUtilities.putInt(rcd, 6, loc[3]);
            this.paste(loc, loc[1], rcd, 2, r.type, r.id);
            this.paste(loc, loc[3], r.data, 4, r.type, r.id);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public synchronized boolean contains(int type, short id) {
        return this.locate(type, id) != null;
    }

    @Override
    public synchronized PalmResource get(int type, short id) {
        try {
            int[] l = this.locate(type, id);
            if (l != null) {
                this.raf.seek(l[3]);
                byte[] stuff = new byte[l[4]];
                this.raf.read(stuff);
                return new PalmResource(type, id, stuff);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public synchronized PalmResource getAttributes(int type, short id) {
        int[] l = this.locate(type, id);
        if (l != null) {
            return new PalmResource(type, id, new byte[0]);
        }
        return null;
    }

    @Override
    public synchronized byte[] getData(int type, short id) {
        try {
            int[] l = this.locate(type, id);
            if (l != null) {
                this.raf.seek(l[3]);
                byte[] stuff = new byte[l[4]];
                this.raf.read(stuff);
                return stuff;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public synchronized boolean remove(int type, short id) {
        try {
            int[] loc = this.locate(type, id);
            if (loc != null) {
                this.cut(loc, loc[3], loc[4], 4, type, id);
                this.cut(loc, loc[1], loc[2], 2, type, id);
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public synchronized boolean set(int type, short id, PalmResource r) throws PalmResourceAlreadyExistsException {
        if (!this.contains(type, id)) {
            return false;
        }
        if (r.data == null) {
            r.data = new byte[0];
        }
        return this.setAttributes(type, id, r) && this.setData(r.type, r.id, r.data);
    }

    @Override
    public synchronized boolean setAttributes(int type, short id, PalmResource r) throws PalmResourceAlreadyExistsException {
        try {
            int[] loc = this.locate(type, id);
            if (loc != null) {
                int[] loce = this.locate(r.type, r.id);
                if (loce != null && (loce[0] != loc[0] || loce[1] != loc[1] || loce[2] != loc[2] || loce[3] != loc[3] || loce[4] != loc[4])) {
                    throw new PalmResourceAlreadyExistsException();
                }
                this.raf.seek(loc[1]);
                this.raf.writeInt(r.type);
                this.raf.writeShort(r.id);
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public synchronized boolean setData(int type, short id, byte[] data) {
        try {
            int[] loc = this.locate(type, id);
            if (loc != null) {
                this.cut(loc, loc[3], loc[4], 4, type, id);
                this.paste(loc, loc[3], data, 4, type, id);
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public synchronized int getTypeCount() {
        int cnt = 0;
        try {
            ArrayList<Integer> a = new ArrayList<Integer>();
            this.raf.seek(76L);
            int n = this.raf.readShort();
            int i = 0;
            int h = 78;
            while (i < n) {
                int t = this.raf.readInt();
                this.raf.skipBytes(6);
                if (!a.contains(t)) {
                    ++cnt;
                    a.add(t);
                }
                ++i;
                h += 10;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return cnt;
    }

    @Override
    public synchronized int getType(int index) {
        try {
            int idx = 0;
            ArrayList<Integer> a = new ArrayList<Integer>();
            this.raf.seek(76L);
            int n = this.raf.readShort();
            int i = 0;
            int h = 78;
            while (i < n) {
                int t = this.raf.readInt();
                this.raf.skipBytes(6);
                if (!a.contains(t)) {
                    if (idx == index) {
                        return t;
                    }
                    ++idx;
                    a.add(t);
                }
                ++i;
                h += 10;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public synchronized int[] getTypes() {
        ArrayList<Integer> a = new ArrayList<Integer>();
        try {
            this.raf.seek(76L);
            int n = this.raf.readShort();
            int i = 0;
            int h = 78;
            while (i < n) {
                int t = this.raf.readInt();
                this.raf.skipBytes(6);
                if (!a.contains(t)) {
                    a.add(t);
                }
                ++i;
                h += 10;
            }
        }
        catch (IOException n) {
            // empty catch block
        }
        int[] s = new int[a.size()];
        Iterator i = a.iterator();
        int j = 0;
        while (j < s.length && i.hasNext()) {
            s[j] = (Integer)i.next();
            ++j;
        }
        return s;
    }

    @Override
    public synchronized int getResourceCount(int type) {
        int cnt = 0;
        try {
            this.raf.seek(76L);
            int n = this.raf.readShort();
            int i = 0;
            int h = 78;
            while (i < n) {
                int t = this.raf.readInt();
                this.raf.skipBytes(6);
                if (t == type) {
                    ++cnt;
                }
                ++i;
                h += 10;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return cnt;
    }

    @Override
    public synchronized short getID(int type, int index) {
        try {
            int idx = 0;
            this.raf.seek(76L);
            int n = this.raf.readShort();
            int i = 0;
            int h = 78;
            while (i < n) {
                int t = this.raf.readInt();
                short d = this.raf.readShort();
                this.raf.skipBytes(4);
                if (t == type) {
                    if (idx == index) {
                        return d;
                    }
                    ++idx;
                }
                ++i;
                h += 10;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public synchronized short[] getIDs(int type) {
        ArrayList<Short> a = new ArrayList<Short>();
        try {
            this.raf.seek(76L);
            int n = this.raf.readShort();
            int i = 0;
            int h = 78;
            while (i < n) {
                int t = this.raf.readInt();
                short d = this.raf.readShort();
                this.raf.skipBytes(4);
                if (t == type) {
                    a.add(d);
                }
                ++i;
                h += 10;
            }
        }
        catch (IOException n) {
            // empty catch block
        }
        short[] s = new short[a.size()];
        Iterator i = a.iterator();
        int j = 0;
        while (j < s.length && i.hasNext()) {
            s[j] = (Short)i.next();
            ++j;
        }
        return s;
    }

    @Override
    public synchronized short getNextAvailableID(int type, short start) {
        try {
            ArrayList<Short> a = new ArrayList<Short>();
            this.raf.seek(76L);
            int n = this.raf.readShort();
            int i = 0;
            int h = 78;
            while (i < n) {
                int t = this.raf.readInt();
                short d = this.raf.readShort();
                this.raf.skipBytes(4);
                if (t == type) {
                    a.add(d);
                }
                ++i;
                h += 10;
            }
            while (a.contains(start)) {
                start = (short)(start + 1);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return start;
    }
}

