/*
 This Java source file was generated by test-to-java.xsl
 and is a derived work from the source document.
 The source document contained the following notice:



 Copyright (c) 2001 World Wide Web Consortium,
 (Massachusetts Institute of Technology, Institut National de
 Recherche en Informatique et en Automatique, Keio University).  All
 Rights Reserved.  This program is distributed under the W3C's Software
 Intellectual Property License.  This program is distributed in the
 hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.

 See W3C License http://www.w3.org/Consortium/Legal/ for more details.


 */

package tests.org.w3c.dom;

import java.util.ArrayList;
import java.util.List;

import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

import javax.xml.parsers.DocumentBuilder;

/**
 * The method createDocumentType with valid values for qualifiedName, publicId
 * and systemId should create an empty DocumentType node.
 *
 * Invoke createDocument on this DOMImplementation with a valid qualifiedName
 * and different publicIds and systemIds. Check if the the DocumentType node was
 * created with its ownerDocument attribute set to null.
 *
 * @author IBM
 * @author Neil Delima
 * @see <a
 *      href="http://www.w3.org/TR/DOM-Level-2-Core/core#Level-2-Core-DOM-createDocument">http://www.w3.org/TR/DOM-Level-2-Core/core#Level-2-Core-DOM-createDocument</a>
 */
public final class DOMImplementationCreateDocumentType extends DOMTestCase {

    DOMDocumentBuilderFactory factory;

    DocumentBuilder builder;

    protected void setUp() throws Exception {
        super.setUp();
        try {
            factory = new DOMDocumentBuilderFactory(DOMDocumentBuilderFactory
                    .getConfiguration1());
            builder = factory.getBuilder();
        } catch (Exception e) {
            fail("Unexpected exception" + e.getMessage());
        }
    }

    protected void tearDown() throws Exception {
        factory = null;
        builder = null;
        super.tearDown();
    }

    /**
     * Runs the test case.
     *
     * @throws Throwable
     *             Any uncaught exception causes test to fail
     */
    public void testCreateDocumentType1() throws Throwable {
        Document doc;
        DOMImplementation domImpl;
        DocumentType newDocType;
        Document ownerDocument;
        String qualifiedName = "test:root";
        String publicId;
        String systemId;
        List<String> publicIds = new ArrayList<String>();
        publicIds.add("1234");
        publicIds.add("test");

        List<String> systemIds = new ArrayList<String>();
        systemIds.add("");
        systemIds.add("test");

        doc = (Document) load("staffNS", builder);
        domImpl = doc.getImplementation();
        for (int indexN1005D = 0; indexN1005D < publicIds.size(); indexN1005D++) {
            publicId = (String) publicIds.get(indexN1005D);
            for (int indexN10061 = 0; indexN10061 < systemIds.size(); indexN10061++) {
                systemId = (String) systemIds.get(indexN10061);
                newDocType = domImpl.createDocumentType(qualifiedName,
                        publicId, systemId);
                assertNotNull(
                        "domimplementationcreatedocumenttype01_newDocType",
                        newDocType);
                ownerDocument = newDocType.getOwnerDocument();
                assertNull(
                        "domimplementationcreatedocumenttype01_ownerDocument",
                        ownerDocument);
            }
        }
    }
    public void testCreateDocumentType2() throws Throwable {
        Document doc;
        DOMImplementation domImpl;
        DocumentType newDocType;
        Document ownerDocument;
        String publicId = "http://www.w3.org/DOM/Test/dom2.dtd";
        String systemId = "dom2.dtd";
        String qualifiedName;
        List<String> qualifiedNames = new ArrayList<String>();
        qualifiedNames.add("_:_");
        qualifiedNames.add("_:h0");
        qualifiedNames.add("_:test");
        qualifiedNames.add("_:_.");
        qualifiedNames.add("_:a-");
        qualifiedNames.add("l_:_");
        qualifiedNames.add("ns:_0");
        qualifiedNames.add("ns:a0");
        qualifiedNames.add("ns0:test");
        qualifiedNames.add("ns:EEE.");
        qualifiedNames.add("ns:_-");
        qualifiedNames.add("a.b:c");
        qualifiedNames.add("a-b:c.j");
        qualifiedNames.add("a-b:c");

        doc = (Document) load("staffNS", builder);
        domImpl = doc.getImplementation();
        for (int indexN10077 = 0; indexN10077 < qualifiedNames.size(); indexN10077++) {
            qualifiedName = (String) qualifiedNames.get(indexN10077);
            newDocType = domImpl.createDocumentType(qualifiedName, publicId,
                    systemId);
            assertNotNull("domimplementationcreatedocumenttype02_newDocType",
                    newDocType);
            ownerDocument = newDocType.getOwnerDocument();
            assertNull("domimplementationcreatedocumenttype02_ownerDocument",
                    ownerDocument);
        }
    }
    public void testCreateDocumentType4() throws Throwable {
        Document doc;
        DOMImplementation domImpl;
        DocumentType newDocType;
        Document ownerDocument;
        String publicId = "http://www.w3.org/DOM/Test/dom2.dtd";
        String systemId = "dom2.dtd";
        String qualifiedName;
        List<String> qualifiedNames = new ArrayList<String>();
        qualifiedNames.add("_:_");
        qualifiedNames.add("_:h0");
        qualifiedNames.add("_:test");
        qualifiedNames.add("_:_.");
        qualifiedNames.add("_:a-");
        qualifiedNames.add("l_:_");
        qualifiedNames.add("ns:_0");
        qualifiedNames.add("ns:a0");
        qualifiedNames.add("ns0:test");
        qualifiedNames.add("ns:EEE.");
        qualifiedNames.add("ns:_-");
        qualifiedNames.add("a.b:c");
        qualifiedNames.add("a-b:c.j");
        qualifiedNames.add("a-b:c");

        doc = (Document) load("staffNS", builder);
        domImpl = doc.getImplementation();
        for (int indexN10077 = 0; indexN10077 < qualifiedNames.size(); indexN10077++) {
            qualifiedName = (String) qualifiedNames.get(indexN10077);
            newDocType = domImpl.createDocumentType(qualifiedName, publicId,
                    systemId);
            assertNotNull("domimplementationcreatedocumenttype02_newDocType",
                    newDocType);
            ownerDocument = newDocType.getOwnerDocument();
            assertNull("domimplementationcreatedocumenttype02_ownerDocument",
                    ownerDocument);
        }
    }

}
