/*****************************************************************************
 * Copyright (c) 2014-2024 OpenRCT2 developers
 *
 * For a complete list of all authors, please refer to contributors.md
 * Interested in contributing? Visit https://github.com/OpenRCT2/OpenRCT2
 *
 * OpenRCT2 is licensed under the GNU General Public License version 3.
 *****************************************************************************/

#include "WoodenRollerCoaster.h"

#include "../../config/Config.h"
#include "../../drawing/Drawing.h"
#include "../../interface/Viewport.h"
#include "../../paint/Boundbox.h"
#include "../../paint/Paint.h"
#include "../../paint/support/WoodenSupports.h"
#include "../../paint/tile_element/Paint.Surface.h"
#include "../../paint/tile_element/Paint.TileElement.h"
#include "../../sprites.h"
#include "../../world/Map.h"
#include "../RideData.h"
#include "../TrackData.h"
#include "../TrackPaint.h"

enum
{
    SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_SW_NE = 23497,
    SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_NW_SE = 23498,
    SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_NE_SW = 23499,
    SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_SE_NW = 23500,
    SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_SW_NE = 23501,
    SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_NW_SE = 23502,
    SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_NE_SW = 23503,
    SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_SE_NW = 23504,
    SPR_WOODEN_RC_LEFT_BANK_SW_NE = 23505,
    SPR_WOODEN_RC_LEFT_BANK_NW_SE = 23506,
    SPR_WOODEN_RC_LEFT_BANK_NE_SW = 23507,
    SPR_WOODEN_RC_LEFT_BANK_SE_NW = 23508,
    SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_SW_NE = 23509,
    SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_NW_SE = 23510,
    SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_NE_SW = 23511,
    SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_SE_NW = 23512,
    SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_SW_NE = 23513,
    SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_NW_SE = 23514,
    SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_NE_SW = 23515,
    SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_SE_NW = 23516,
    SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_SW_NE = 23517,
    SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_NW_SE = 23518,
    SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_NE_SW = 23519,
    SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_SE_NW = 23520,
    SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_SW_NE = 23521,
    SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_NW_SE = 23522,
    SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_NE_SW = 23523,
    SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_SE_NW = 23524,
    SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_FRONT_NW_SE = 23525,
    SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_FRONT_SE_NW = 23526,
    SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_FRONT_NE_SW = 23527,
    SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_FRONT_NW_SE = 23528,
    SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_FRONT_NE_SW = 23529,
    SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_FRONT_NW_SE = 23530,
    SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_FRONT_NE_SW = 23531,
    SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_FRONT_NW_SE = 23532,
    SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_FRONT_NE_SW = 23533,
    SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_FRONT_NW_SE = 23534,
    SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_FRONT_NE_SW = 23535,
    SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_FRONT_SW_NE = 23536,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_SW_NE = 23537,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_NW_SE = 23538,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_NE_SW = 23539,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_SE_NW = 23540,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_SW_NE = 23541,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_NW_SE = 23542,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_NE_SW = 23543,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_SE_NW = 23544,
    SPR_WOODEN_RC_25_DEG_SW_NE = 23545,
    SPR_WOODEN_RC_25_DEG_NW_SE = 23546,
    SPR_WOODEN_RC_25_DEG_NE_SW = 23547,
    SPR_WOODEN_RC_25_DEG_SE_NW = 23548,
    SPR_WOODEN_RC_25_DEG_TO_60_DEG_SW_NE = 23549,
    SPR_WOODEN_RC_25_DEG_TO_60_DEG_FRONT_NW_SE = 23550,
    SPR_WOODEN_RC_25_DEG_TO_60_DEG_NW_SE = 23551,
    SPR_WOODEN_RC_25_DEG_TO_60_DEG_FRONT_NE_SW = 23552,
    SPR_WOODEN_RC_25_DEG_TO_60_DEG_NE_SW = 23553,
    SPR_WOODEN_RC_25_DEG_TO_60_DEG_SE_NW = 23554,
    SPR_WOODEN_RC_60_DEG_TO_25_DEG_SW_NE = 23555,
    SPR_WOODEN_RC_60_DEG_TO_25_DEG_FRONT_NW_SE = 23556,
    SPR_WOODEN_RC_60_DEG_TO_25_DEG_NW_SE = 23557,
    SPR_WOODEN_RC_60_DEG_TO_25_DEG_FRONT_NE_SW = 23558,
    SPR_WOODEN_RC_60_DEG_TO_25_DEG_NE_SW = 23559,
    SPR_WOODEN_RC_60_DEG_TO_25_DEG_SE_NW = 23560,
    SPR_WOODEN_RC_60_DEG_SW_NE = 23561,
    SPR_WOODEN_RC_60_DEG_CHAIN_SW_NE = 23561,
    SPR_WOODEN_RC_60_DEG_NW_SE = 23562,
    SPR_WOODEN_RC_60_DEG_CHAIN_NW_SE = 23562,
    SPR_WOODEN_RC_60_DEG_NE_SW = 23563,
    SPR_WOODEN_RC_60_DEG_CHAIN_NE_SW = 23563,
    SPR_WOODEN_RC_60_DEG_SE_NW = 23564,
    SPR_WOODEN_RC_60_DEG_CHAIN_SE_NW = 23564,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_FRONT_NW_SE = 23565,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_FRONT_NE_SW = 23566,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_FRONT_NW_SE = 23567,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_FRONT_NE_SW = 23568,
    SPR_WOODEN_RC_25_DEG_FRONT_NW_SE = 23569,
    SPR_WOODEN_RC_60_DEG_FRONT_NW_SE = 23569,
    SPR_WOODEN_RC_25_DEG_FRONT_NE_SW = 23570,
    SPR_WOODEN_RC_60_DEG_FRONT_NE_SW = 23570,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_SW_NE = 23571,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_NW_SE = 23572,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_NE_SW = 23573,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_SE_NW = 23574,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_SW_NE = 23575,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_NW_SE = 23576,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_NE_SW = 23577,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_SE_NW = 23578,
    SPR_WOODEN_RC_25_DEG_CHAIN_SW_NE = 23579,
    SPR_WOODEN_RC_25_DEG_CHAIN_NW_SE = 23580,
    SPR_WOODEN_RC_25_DEG_CHAIN_NE_SW = 23581,
    SPR_WOODEN_RC_25_DEG_CHAIN_SE_NW = 23582,

    SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_FRONT_NW_SE = 23599,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_FRONT_NE_SW = 23600,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_FRONT_NW_SE = 23601,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_FRONT_NE_SW = 23602,
    SPR_WOODEN_RC_25_DEG_CHAIN_FRONT_NW_SE = 23603,
    SPR_WOODEN_RC_60_DEG_CHAIN_FRONT_NW_SE = 23603,
    SPR_WOODEN_RC_25_DEG_CHAIN_FRONT_NE_SW = 23604,
    SPR_WOODEN_RC_60_DEG_CHAIN_FRONT_NE_SW = 23604,
    SPR_WOODEN_RC_QUARTER_TURN_5_SW_SE_SEQ_0 = 23605,
    SPR_WOODEN_RC_QUARTER_TURN_5_SW_SE_SEQ_2 = 23606,
    SPR_WOODEN_RC_QUARTER_TURN_5_SW_SE_SEQ_3 = 23607,
    SPR_WOODEN_RC_QUARTER_TURN_5_SW_SE_SEQ_5 = 23608,
    SPR_WOODEN_RC_QUARTER_TURN_5_SW_SE_SEQ_6 = 23609,
    SPR_WOODEN_RC_QUARTER_TURN_5_NW_SW_SEQ_0 = 23610,
    SPR_WOODEN_RC_QUARTER_TURN_5_NW_SW_SEQ_2 = 23611,
    SPR_WOODEN_RC_QUARTER_TURN_5_NW_SW_SEQ_3 = 23612,
    SPR_WOODEN_RC_QUARTER_TURN_5_NW_SW_SEQ_5 = 23613,
    SPR_WOODEN_RC_QUARTER_TURN_5_NW_SW_SEQ_6 = 23614,
    SPR_WOODEN_RC_QUARTER_TURN_5_NE_NW_SEQ_0 = 23615,
    SPR_WOODEN_RC_QUARTER_TURN_5_NE_NW_SEQ_2 = 23616,
    SPR_WOODEN_RC_QUARTER_TURN_5_NE_NW_SEQ_3 = 23617,
    SPR_WOODEN_RC_QUARTER_TURN_5_NE_NW_SEQ_5 = 23618,
    SPR_WOODEN_RC_QUARTER_TURN_5_NE_NW_SEQ_6 = 23619,
    SPR_WOODEN_RC_QUARTER_TURN_5_SE_NE_SEQ_0 = 23620,
    SPR_WOODEN_RC_QUARTER_TURN_5_SE_NE_SEQ_2 = 23621,
    SPR_WOODEN_RC_QUARTER_TURN_5_SE_NE_SEQ_3 = 23622,
    SPR_WOODEN_RC_QUARTER_TURN_5_SE_NE_SEQ_5 = 23623,
    SPR_WOODEN_RC_QUARTER_TURN_5_SE_NE_SEQ_6 = 23624,
    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_SW_SE_SEQ_0 = 23625,
    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_SW_SE_SEQ_2 = 23626,
    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_SW_SE_SEQ_3 = 23627,
    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_SW_SE_SEQ_5 = 23628,
    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_SW_SE_SEQ_6 = 23629,
    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_NE_NW_SEQ_0 = 23630,
    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_NE_NW_SEQ_2 = 23631,
    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_NE_NW_SEQ_3 = 23632,
    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_NE_NW_SEQ_5 = 23633,
    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_NE_NW_SEQ_6 = 23634,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SW_SE_SEQ_0 = 23635,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SW_SE_SEQ_2 = 23636,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SW_SE_SEQ_3 = 23637,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SW_SE_SEQ_5 = 23638,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SW_SE_SEQ_6 = 23639,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NW_SW_SEQ_0 = 23640,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NW_SW_SEQ_2 = 23641,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NW_SW_SEQ_3 = 23642,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NW_SW_SEQ_5 = 23643,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NW_SW_SEQ_6 = 23644,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NE_NW_SEQ_0 = 23645,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NE_NW_SEQ_2 = 23646,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NE_NW_SEQ_3 = 23647,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NE_NW_SEQ_5 = 23648,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NE_NW_SEQ_6 = 23649,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SE_NE_SEQ_0 = 23650,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SE_NE_SEQ_2 = 23651,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SE_NE_SEQ_3 = 23652,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SE_NE_SEQ_5 = 23653,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SE_NE_SEQ_6 = 23654,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_SW_SE_SEQ_0 = 23655,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_SW_SE_SEQ_2 = 23656,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_SW_SE_SEQ_3 = 23657,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_SW_SE_SEQ_5 = 23658,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_SW_SE_SEQ_6 = 23659,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_NE_NW_SEQ_0 = 23660,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_NE_NW_SEQ_2 = 23661,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_NE_NW_SEQ_3 = 23662,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_NE_NW_SEQ_5 = 23663,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_NE_NW_SEQ_6 = 23664,

    SPR_WOODEN_RC_FLAT_CHAIN_SW_NE = 23749,
    SPR_WOODEN_RC_FLAT_CHAIN_NW_SE = 23750,
    SPR_WOODEN_RC_FLAT_CHAIN_NE_SW = 23751,
    SPR_WOODEN_RC_FLAT_CHAIN_SE_NW = 23752,
    SPR_WOODEN_RC_FLAT_SW_NE = 23753,
    SPR_WOODEN_RC_FLAT_NW_SE = 23754,
    SPR_WOODEN_RC_BRAKES_SW_NE = 23755,
    SPR_WOODEN_RC_BRAKES_NW_SE = 23756,
    SPR_WOODEN_RC_BLOCK_BRAKES_SW_NE_OPEN = 23757,
    SPR_WOODEN_RC_BLOCK_BRAKES_NW_SE_OPEN = 23758,
    SPR_WOODEN_RC_BLOCK_BRAKES_SW_NE_CLOSED = 23759,
    SPR_WOODEN_RC_BLOCK_BRAKES_NW_SE_CLOSED = 23760,

    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_0 = 23841,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_1 = 23842,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_2 = 23843,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_3 = 23844,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_4 = 23845,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_5 = 23846,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_6 = 23847,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_7 = 23848,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_8 = 23849,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_9 = 23850,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_10 = 23851,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_11 = 23852,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_12 = 23853,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_13 = 23854,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_14 = 23855,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_15 = 23856,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_16 = 23857,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_17 = 23858,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_18 = 23859,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_19 = 23860,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_20 = 23861,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_21 = 23862,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_22 = 23863,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_23 = 23864,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_24 = 23865,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_25 = 23866,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_26 = 23867,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_27 = 23868,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_28 = 23869,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_29 = 23870,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_30 = 23871,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_31 = 23872,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_32 = 23873,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_33 = 23874,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_34 = 23875,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_35 = 23876,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_36 = 23877,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_37 = 23878,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_38 = 23879,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_39 = 23880,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_40 = 23881,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_41 = 23882,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_42 = 23883,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_43 = 23884,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_44 = 23885,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_45 = 23886,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_46 = 23887,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_47 = 23888,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_48 = 23889,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_49 = 23890,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_50 = 23891,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_51 = 23892,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_52 = 23893,
    SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_53 = 23894,

    SPR_WOODEN_RC_STATION_SW_NE = 23973,
    SPR_WOODEN_RC_STATION_NW_SE = 23974,

    SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_RAILS_SW_NE = 24363,
    SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_RAILS_NW_SE = 24364,
    SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_RAILS_NE_SW = 24365,
    SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_RAILS_SE_NW = 24366,
    SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_RAILS_SW_NE = 24367,
    SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_RAILS_NW_SE = 24368,
    SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_RAILS_NE_SW = 24369,
    SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_RAILS_SE_NW = 24370,
    SPR_WOODEN_RC_LEFT_BANK_RAILS_SW_NE = 24371,
    SPR_WOODEN_RC_LEFT_BANK_RAILS_NW_SE = 24372,
    SPR_WOODEN_RC_LEFT_BANK_RAILS_NE_SW = 24373,
    SPR_WOODEN_RC_LEFT_BANK_RAILS_SE_NW = 24374,
    SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_RAILS_SW_NE = 24375,
    SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_RAILS_NW_SE = 24376,
    SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_RAILS_NE_SW = 24377,
    SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_RAILS_SE_NW = 24378,
    SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_RAILS_SW_NE = 24379,
    SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_RAILS_NW_SE = 24380,
    SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_RAILS_NE_SW = 24381,
    SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_RAILS_SE_NW = 24382,
    SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_RAILS_SW_NE = 24383,
    SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_RAILS_NW_SE = 24384,
    SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_RAILS_NE_SW = 24385,
    SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_RAILS_SE_NW = 24386,
    SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_RAILS_SW_NE = 24387,
    SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_RAILS_NW_SE = 24388,
    SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_RAILS_NE_SW = 24389,
    SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_RAILS_SE_NW = 24390,
    SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_RAILS_FRONT_NW_SE = 24391,
    SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_RAILS_FRONT_SE_NW = 24392,
    SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_RAILS_FRONT_NE_SW = 24393,
    SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_RAILS_FRONT_NW_SE = 24394,
    SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_RAILS_FRONT_NE_SW = 24395,
    SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_RAILS_FRONT_NW_SE = 24396,
    SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_RAILS_FRONT_NE_SW = 24397,
    SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_RAILS_FRONT_NW_SE = 24398,
    SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_RAILS_FRONT_NE_SW = 24399,
    SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_RAILS_FRONT_NW_SE = 24400,
    SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_RAILS_FRONT_NE_SW = 24401,
    SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_RAILS_FRONT_SW_NE = 24402,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_RAILS_SW_NE = 24403,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_RAILS_NW_SE = 24404,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_RAILS_NE_SW = 24405,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_RAILS_SE_NW = 24406,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_RAILS_SW_NE = 24407,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_RAILS_NW_SE = 24408,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_RAILS_NE_SW = 24409,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_RAILS_SE_NW = 24410,
    SPR_WOODEN_RC_25_DEG_RAILS_SW_NE = 24411,
    SPR_WOODEN_RC_25_DEG_RAILS_NW_SE = 24412,
    SPR_WOODEN_RC_25_DEG_RAILS_NE_SW = 24413,
    SPR_WOODEN_RC_25_DEG_RAILS_SE_NW = 24414,
    SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_SW_NE = 24415,
    SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_FRONT_NW_SE = 24416,
    SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_NW_SE = 24417,
    SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_FRONT_NE_SW = 24418,
    SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_NE_SW = 24419,
    SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_SE_NW = 24420,
    SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_SW_NE = 24421,
    SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_FRONT_NW_SE = 24422,
    SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_NW_SE = 24423,
    SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_FRONT_NE_SW = 24424,
    SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_NE_SW = 24425,
    SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_SE_NW = 24426,
    SPR_WOODEN_RC_60_DEG_RAILS_SW_NE = 24427,
    SPR_WOODEN_RC_60_DEG_CHAIN_RAILS_SW_NE = 24427,
    SPR_WOODEN_RC_60_DEG_RAILS_NW_SE = 24428,
    SPR_WOODEN_RC_60_DEG_CHAIN_RAILS_NW_SE = 24428,
    SPR_WOODEN_RC_60_DEG_RAILS_NE_SW = 24429,
    SPR_WOODEN_RC_60_DEG_CHAIN_RAILS_NE_SW = 24429,
    SPR_WOODEN_RC_60_DEG_RAILS_SE_NW = 24430,
    SPR_WOODEN_RC_60_DEG_CHAIN_RAILS_SE_NW = 24430,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_RAILS_FRONT_NW_SE = 24431,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_RAILS_FRONT_NE_SW = 24432,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_RAILS_FRONT_NW_SE = 24433,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_RAILS_FRONT_NE_SW = 24434,
    SPR_WOODEN_RC_25_DEG_RAILS_FRONT_NW_SE = 24435,
    SPR_WOODEN_RC_60_DEG_RAILS_FRONT_NW_SE = 24435,
    SPR_WOODEN_RC_25_DEG_RAILS_FRONT_NE_SW = 24436,
    SPR_WOODEN_RC_60_DEG_RAILS_FRONT_NE_SW = 24436,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_RAILS_SW_NE = 24437,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_RAILS_NW_SE = 24438,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_RAILS_NE_SW = 24439,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_RAILS_SE_NW = 24440,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_RAILS_SW_NE = 24441,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_RAILS_NW_SE = 24442,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_RAILS_NE_SW = 24443,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_RAILS_SE_NW = 24444,
    SPR_WOODEN_RC_25_DEG_CHAIN_RAILS_SW_NE = 24445,
    SPR_WOODEN_RC_25_DEG_CHAIN_RAILS_NW_SE = 24446,
    SPR_WOODEN_RC_25_DEG_CHAIN_RAILS_NE_SW = 24447,
    SPR_WOODEN_RC_25_DEG_CHAIN_RAILS_SE_NW = 24448,

    SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_RAILS_FRONT_NW_SE = 24465,
    SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_RAILS_FRONT_NE_SW = 24466,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_RAILS_FRONT_NW_SE = 24467,
    SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_RAILS_FRONT_NE_SW = 24468,
    SPR_WOODEN_RC_25_DEG_CHAIN_RAILS_FRONT_NW_SE = 24469,
    SPR_WOODEN_RC_60_DEG_CHAIN_RAILS_FRONT_NW_SE = 24469,
    SPR_WOODEN_RC_25_DEG_CHAIN_RAILS_FRONT_NE_SW = 24470,
    SPR_WOODEN_RC_60_DEG_CHAIN_RAILS_FRONT_NE_SW = 24470,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SW_SE_SEQ_0 = 24471,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SW_SE_SEQ_2 = 24472,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SW_SE_SEQ_3 = 24473,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SW_SE_SEQ_5 = 24474,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SW_SE_SEQ_6 = 24475,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NW_SW_SEQ_0 = 24476,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NW_SW_SEQ_2 = 24477,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NW_SW_SEQ_3 = 24478,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NW_SW_SEQ_5 = 24479,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NW_SW_SEQ_6 = 24480,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NE_NW_SEQ_0 = 24481,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NE_NW_SEQ_2 = 24482,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NE_NW_SEQ_3 = 24483,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NE_NW_SEQ_5 = 24484,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NE_NW_SEQ_6 = 24485,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SE_NE_SEQ_0 = 24486,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SE_NE_SEQ_2 = 24487,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SE_NE_SEQ_3 = 24488,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SE_NE_SEQ_5 = 24489,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SE_NE_SEQ_6 = 24490,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_0 = 24491,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_2 = 24492,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_3 = 24493,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_5 = 24494,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_6 = 24495,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_0 = 24496,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_2 = 24497,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_3 = 24498,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_5 = 24499,
    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_6 = 24500,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SW_SE_SEQ_0 = 24501,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SW_SE_SEQ_2 = 24502,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SW_SE_SEQ_3 = 24503,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SW_SE_SEQ_5 = 24504,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SW_SE_SEQ_6 = 24505,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NW_SW_SEQ_0 = 24506,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NW_SW_SEQ_2 = 24507,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NW_SW_SEQ_3 = 24508,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NW_SW_SEQ_5 = 24509,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NW_SW_SEQ_6 = 24510,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NE_NW_SEQ_0 = 24511,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NE_NW_SEQ_2 = 24512,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NE_NW_SEQ_3 = 24513,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NE_NW_SEQ_5 = 24514,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NE_NW_SEQ_6 = 24515,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SE_NE_SEQ_0 = 24516,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SE_NE_SEQ_2 = 24517,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SE_NE_SEQ_3 = 24518,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SE_NE_SEQ_5 = 24519,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SE_NE_SEQ_6 = 24520,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_0 = 24521,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_2 = 24522,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_3 = 24523,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_5 = 24524,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_6 = 24525,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_0 = 24526,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_2 = 24527,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_3 = 24528,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_5 = 24529,
    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_6 = 24530,

    SPR_WOODEN_RC_FLAT_CHAIN_RAILS_SW_NE = 24615,
    SPR_WOODEN_RC_FLAT_CHAIN_RAILS_NW_SE = 24616,
    SPR_WOODEN_RC_FLAT_CHAIN_RAILS_NE_SW = 24617,
    SPR_WOODEN_RC_FLAT_CHAIN_RAILS_SE_NW = 24618,
    SPR_WOODEN_RC_FLAT_RAILS_SW_NE = 24619,
    SPR_WOODEN_RC_FLAT_RAILS_NW_SE = 24620,
    SPR_WOODEN_RC_BRAKES_RAILS_SW_NE = 24621,
    SPR_WOODEN_RC_BRAKES_RAILS_NW_SE = 24622,
    SPR_WOODEN_RC_BLOCK_BRAKES_RAILS_SW_NE = 24623,
    SPR_WOODEN_RC_BLOCK_BRAKES_RAILS_NW_SE = 24624,

    SPR_WOODEN_RC_STATION_RAILS_SW_NE = 24839,
    SPR_WOODEN_RC_STATION_RAILS_NW_SE = 24840,
};

static constexpr uint32_t _wooden_rc_block_brakes_image_ids[4][3] = {
    { SPR_WOODEN_RC_BLOCK_BRAKES_SW_NE_OPEN, SPR_WOODEN_RC_BLOCK_BRAKES_SW_NE_CLOSED, SPR_WOODEN_RC_BLOCK_BRAKES_RAILS_SW_NE },
    { SPR_WOODEN_RC_BLOCK_BRAKES_NW_SE_OPEN, SPR_WOODEN_RC_BLOCK_BRAKES_NW_SE_CLOSED, SPR_WOODEN_RC_BLOCK_BRAKES_RAILS_NW_SE },
    { SPR_WOODEN_RC_BLOCK_BRAKES_SW_NE_OPEN, SPR_WOODEN_RC_BLOCK_BRAKES_SW_NE_CLOSED, SPR_WOODEN_RC_BLOCK_BRAKES_RAILS_SW_NE },
    { SPR_WOODEN_RC_BLOCK_BRAKES_NW_SE_OPEN, SPR_WOODEN_RC_BLOCK_BRAKES_NW_SE_CLOSED, SPR_WOODEN_RC_BLOCK_BRAKES_RAILS_NW_SE },
};

static constexpr uint32_t _wooden_rc_station_block_brakes_image_ids[4][2] = {
    { SPR_G2_WOODEN_RC_STATION_BLOCK_BRAKE_OPEN_SW_NE, SPR_G2_WOODEN_RC_STATION_BLOCK_BRAKE_CLOSED_SW_NE },
    { SPR_G2_WOODEN_RC_STATION_BLOCK_BRAKE_OPEN_NW_SE, SPR_G2_WOODEN_RC_STATION_BLOCK_BRAKE_CLOSED_NW_SE },
    { SPR_G2_WOODEN_RC_STATION_BLOCK_BRAKE_OPEN_SW_NE, SPR_G2_WOODEN_RC_STATION_BLOCK_BRAKE_CLOSED_SW_NE },
    { SPR_G2_WOODEN_RC_STATION_BLOCK_BRAKE_OPEN_NW_SE, SPR_G2_WOODEN_RC_STATION_BLOCK_BRAKE_CLOSED_NW_SE },
};

static constexpr const uint32_t WoodenRCDiagBrakeImages[NumOrthogonalDirections] = {
    SPR_G2_WOODEN_RC_DIAG_BRAKES,
    SPR_G2_WOODEN_RC_DIAG_BRAKES + 1,
    SPR_G2_WOODEN_RC_DIAG_BRAKES,
    SPR_G2_WOODEN_RC_DIAG_BRAKES + 1,
};

static constexpr const uint32_t WoodenRCDiagBlockBrakeImages[2][NumOrthogonalDirections] = {
    {
        SPR_G2_WOODEN_RC_DIAG_BRAKES + 3,
        SPR_G2_WOODEN_RC_DIAG_BRAKES + 5,
        SPR_G2_WOODEN_RC_DIAG_BRAKES + 3,
        SPR_G2_WOODEN_RC_DIAG_BRAKES + 5,
    },
    {
        SPR_G2_WOODEN_RC_DIAG_BRAKES + 2,
        SPR_G2_WOODEN_RC_DIAG_BRAKES + 4,
        SPR_G2_WOODEN_RC_DIAG_BRAKES + 2,
        SPR_G2_WOODEN_RC_DIAG_BRAKES + 4,
    },
};

ImageId WoodenRCGetRailsColour(PaintSession& session)
{
    return session.TrackColours;
}

/** rct2: 0x008AC568 */
template<bool isClassic>
static void WoodenRCTrackFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    static constexpr uint32_t imageIds[4][2] = {
        { SPR_WOODEN_RC_FLAT_SW_NE, SPR_WOODEN_RC_FLAT_CHAIN_SW_NE },
        { SPR_WOODEN_RC_FLAT_NW_SE, SPR_WOODEN_RC_FLAT_CHAIN_NW_SE },
        { SPR_WOODEN_RC_FLAT_SW_NE, SPR_WOODEN_RC_FLAT_CHAIN_NE_SW },
        { SPR_WOODEN_RC_FLAT_NW_SE, SPR_WOODEN_RC_FLAT_CHAIN_SE_NW },
    };
    static constexpr uint32_t railsImageIds[4][2] = {
        { SPR_WOODEN_RC_FLAT_RAILS_SW_NE, SPR_WOODEN_RC_FLAT_CHAIN_RAILS_SW_NE },
        { SPR_WOODEN_RC_FLAT_RAILS_NW_SE, SPR_WOODEN_RC_FLAT_CHAIN_RAILS_NW_SE },
        { SPR_WOODEN_RC_FLAT_RAILS_SW_NE, SPR_WOODEN_RC_FLAT_CHAIN_RAILS_NE_SW },
        { SPR_WOODEN_RC_FLAT_RAILS_NW_SE, SPR_WOODEN_RC_FLAT_CHAIN_RAILS_SE_NW },
    };

    uint8_t isChained = trackElement.HasChain() ? 1 : 0;
    WoodenRCTrackPaint<isClassic>(
        session, direction, imageIds[direction][isChained], railsImageIds[direction][isChained], { 0, 2, height },
        { { 0, 3, height }, { 32, 25, 2 } });
    WoodenASupportsPaintSetupRotated(
        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours);
    PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_FLAT);
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
}

template<bool isClassic>
static void WoodenRCTrackStation(
    PaintSession& session, const Ride& ride, [[maybe_unused]] uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    static constexpr uint32_t stationImageIds[4][2] = {
        { SPR_WOODEN_RC_STATION_SW_NE, SPR_WOODEN_RC_STATION_RAILS_SW_NE },
        { SPR_WOODEN_RC_STATION_NW_SE, SPR_WOODEN_RC_STATION_RAILS_NW_SE },
        { SPR_WOODEN_RC_STATION_SW_NE, SPR_WOODEN_RC_STATION_RAILS_SW_NE },
        { SPR_WOODEN_RC_STATION_NW_SE, SPR_WOODEN_RC_STATION_RAILS_NW_SE },
    };

    int32_t trackType = trackElement.GetTrackType();
    if (trackType == TrackElemType::EndStation)
    {
        const auto brakeImg = trackElement.IsBrakeClosed() ? _wooden_rc_station_block_brakes_image_ids[direction][1]
                                                           : _wooden_rc_station_block_brakes_image_ids[direction][0];
        WoodenRCTrackPaint<isClassic>(
            session, direction, brakeImg, SPR_G2_EMPTY, { 0, 2, height }, { { 0, 2, height }, { 32, 27, 2 } });
    }
    else
    {
        WoodenRCTrackPaint<isClassic>(
            session, direction, stationImageIds[direction][0], stationImageIds[direction][1], { 0, 2, height },
            { { 0, 2, height }, { 32, 27, 2 } });
    }
    WoodenASupportsPaintSetupRotated(
        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours);
    TrackPaintUtilDrawStation2(session, ride, direction, height, trackElement, 9, 11);
    PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_FLAT);
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
}

/** rct2: 0x008AC578 */
template<bool isClassic>
static void WoodenRCTrack25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    static constexpr uint32_t imageIds[2][4][4] = {
        {
            {
                SPR_WOODEN_RC_25_DEG_SW_NE,
                SPR_WOODEN_RC_25_DEG_RAILS_SW_NE,
                0,
                0,
            },
            {
                SPR_WOODEN_RC_25_DEG_NW_SE,
                SPR_WOODEN_RC_25_DEG_RAILS_NW_SE,
                SPR_WOODEN_RC_25_DEG_FRONT_NW_SE,
                SPR_WOODEN_RC_25_DEG_RAILS_FRONT_NW_SE,
            },
            {
                SPR_WOODEN_RC_25_DEG_NE_SW,
                SPR_WOODEN_RC_25_DEG_RAILS_NE_SW,
                SPR_WOODEN_RC_25_DEG_FRONT_NE_SW,
                SPR_WOODEN_RC_25_DEG_RAILS_FRONT_NE_SW,
            },
            {
                SPR_WOODEN_RC_25_DEG_SE_NW,
                SPR_WOODEN_RC_25_DEG_RAILS_SE_NW,
                0,
                0,
            },
        },
        {
            {
                SPR_WOODEN_RC_25_DEG_CHAIN_SW_NE,
                SPR_WOODEN_RC_25_DEG_CHAIN_RAILS_SW_NE,
                0,
                0,
            },
            {
                SPR_WOODEN_RC_25_DEG_CHAIN_NW_SE,
                SPR_WOODEN_RC_25_DEG_CHAIN_RAILS_NW_SE,
                SPR_WOODEN_RC_25_DEG_CHAIN_FRONT_NW_SE,
                SPR_WOODEN_RC_25_DEG_CHAIN_RAILS_FRONT_NW_SE,
            },
            {
                SPR_WOODEN_RC_25_DEG_CHAIN_NE_SW,
                SPR_WOODEN_RC_25_DEG_CHAIN_RAILS_NE_SW,
                SPR_WOODEN_RC_25_DEG_CHAIN_FRONT_NE_SW,
                SPR_WOODEN_RC_25_DEG_CHAIN_RAILS_FRONT_NE_SW,
            },
            {
                SPR_WOODEN_RC_25_DEG_CHAIN_SE_NW,
                SPR_WOODEN_RC_25_DEG_CHAIN_RAILS_SE_NW,
                0,
                0,
            },
        },
    };

    uint8_t isChained = trackElement.HasChain() ? 1 : 0;
    WoodenRCTrackPaint<isClassic>(
        session, direction, imageIds[isChained][direction][0], imageIds[isChained][direction][1], { 0, 0, height },
        { { 0, 3, height }, { 32, 25, 2 } });
    if (direction == 1 || direction == 2)
    {
        WoodenRCTrackPaint<isClassic>(
            session, direction, imageIds[isChained][direction][2], imageIds[isChained][direction][3], { 0, 0, height },
            { { 0, 26, height + 5 }, { 32, 1, 9 } });
    }
    WoodenASupportsPaintSetupRotated(
        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
        WoodenSupportTransitionType::Up25Deg);

    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, TUNNEL_SQUARE_7);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 8, TUNNEL_SQUARE_8);
    }

    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
}

/** rct2: 0x008AC588 */
template<bool isClassic>
static void WoodenRCTrack60DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    static constexpr uint32_t imageIdsChained[4][2] = {
        { SPR_G2_WOODEN_RC_60_SWNE_CHAINED, SPR_WOODEN_RC_60_DEG_RAILS_SW_NE },
        { SPR_G2_WOODEN_RC_60_SWNE_CHAINED_BACK, SPR_WOODEN_RC_60_DEG_RAILS_NW_SE },
        { SPR_G2_WOODEN_RC_60_SENW_CHAINED_BACK, SPR_WOODEN_RC_60_DEG_RAILS_NE_SW },
        { SPR_G2_WOODEN_RC_60_SENW_CHAINED, SPR_WOODEN_RC_60_DEG_RAILS_SE_NW },
    };

    static constexpr uint32_t imageIds[4][2] = {
        { SPR_WOODEN_RC_60_DEG_SW_NE, SPR_WOODEN_RC_60_DEG_RAILS_SW_NE },
        { SPR_WOODEN_RC_60_DEG_NW_SE, SPR_WOODEN_RC_60_DEG_RAILS_NW_SE },
        { SPR_WOODEN_RC_60_DEG_NE_SW, SPR_WOODEN_RC_60_DEG_RAILS_NE_SW },
        { SPR_WOODEN_RC_60_DEG_SE_NW, SPR_WOODEN_RC_60_DEG_RAILS_SE_NW },
    };

    if (trackElement.HasChain())
    {
        if (direction == 0 || direction == 3)
        {
            WoodenRCTrackPaint<isClassic>(
                session, direction, imageIdsChained[direction][0], imageIdsChained[direction][1], { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
        }
        else
        {
            session.WoodenSupportsPrependTo = WoodenRCTrackPaint<isClassic>(
                session, direction, imageIdsChained[direction][0], imageIdsChained[direction][1], { 0, 0, height },
                { { 28, 4, height - 16 }, { 2, 24, 93 } });
        }
    }
    else
    {
        if (direction == 0 || direction == 3)
        {
            WoodenRCTrackPaint<isClassic>(
                session, direction, imageIds[direction][0], imageIds[direction][1], { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
        }
        else
        {
            session.WoodenSupportsPrependTo = WoodenRCTrackPaint<isClassic>(
                session, direction, imageIds[direction][0], imageIds[direction][1], { 0, 0, height },
                { { 28, 4, height - 16 }, { 2, 24, 93 } });
        }
    }

    WoodenASupportsPaintSetupRotated(
        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
        WoodenSupportTransitionType::Up60Deg);

    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, TUNNEL_SQUARE_7);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 56, TUNNEL_SQUARE_8);
    }

    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 104, 0x20);
}

/** rct2: 0x008AC598 */
template<bool isClassic>
static void WoodenRCTrackFlatTo25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    static constexpr uint32_t imageIds[2][4][4] = {
        {
            {
                SPR_WOODEN_RC_FLAT_TO_25_DEG_SW_NE,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_RAILS_SW_NE,
                0,
                0,
            },
            {
                SPR_WOODEN_RC_FLAT_TO_25_DEG_NW_SE,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_RAILS_NW_SE,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_FRONT_NW_SE,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_RAILS_FRONT_NW_SE,
            },
            {
                SPR_WOODEN_RC_FLAT_TO_25_DEG_NE_SW,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_RAILS_NE_SW,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_FRONT_NE_SW,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_RAILS_FRONT_NE_SW,
            },
            {
                SPR_WOODEN_RC_FLAT_TO_25_DEG_SE_NW,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_RAILS_SE_NW,
                0,
                0,
            },
        },
        {
            {
                SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_SW_NE,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_RAILS_SW_NE,
                0,
                0,
            },
            {
                SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_NW_SE,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_RAILS_NW_SE,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_FRONT_NW_SE,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_RAILS_FRONT_NW_SE,
            },
            {
                SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_NE_SW,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_RAILS_NE_SW,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_FRONT_NE_SW,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_RAILS_FRONT_NE_SW,
            },
            {
                SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_SE_NW,
                SPR_WOODEN_RC_FLAT_TO_25_DEG_CHAIN_RAILS_SE_NW,
                0,
                0,
            },
        },
    };

    uint8_t isChained = trackElement.HasChain() ? 1 : 0;
    WoodenRCTrackPaint<isClassic>(
        session, direction, imageIds[isChained][direction][0], imageIds[isChained][direction][1], { 0, 0, height },
        { { 0, 3, height }, { 32, 25, 2 } });
    if (direction == 1 || direction == 2)
    {
        WoodenRCTrackPaint<isClassic>(
            session, direction, imageIds[isChained][direction][2], imageIds[isChained][direction][3], { 0, 0, height },
            { { 0, 26, height + 5 }, { 32, 1, 9 } });
    }
    WoodenASupportsPaintSetupRotated(
        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
        WoodenSupportTransitionType::FlatToUp25Deg);

    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_FLAT);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_8);
    }

    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
}

/** rct2: 0x008AC5A8 */
template<bool isClassic>
static void WoodenRCTrack25DegUpTo60DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    static constexpr uint32_t imageIdsChained[4][4] = {
        {
            SPR_G2_WOODEN_RC_25_60_SWNE_CHAINED,
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_SW_NE,
            0,
            0,
        },
        {
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_NW_SE,
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_NW_SE,
            SPR_G2_WOODEN_RC_25_60_SENW_CHAINED_BACK,
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_FRONT_NW_SE,
        },
        {
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_NE_SW,
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_NE_SW,
            SPR_G2_WOODEN_RC_25_60_SWNE_CHAINED_BACK,
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_FRONT_NE_SW,
        },
        {
            SPR_G2_WOODEN_RC_25_60_SENW_CHAINED,
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_SE_NW,
            0,
            0,
        },
    };

    static constexpr uint32_t imageIds[4][4] = {
        {
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_SW_NE,
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_SW_NE,
            0,
            0,
        },
        {
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_NW_SE,
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_NW_SE,
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_FRONT_NW_SE,
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_FRONT_NW_SE,
        },
        {
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_NE_SW,
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_NE_SW,
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_FRONT_NE_SW,
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_FRONT_NE_SW,
        },
        {
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_SE_NW,
            SPR_WOODEN_RC_25_DEG_TO_60_DEG_RAILS_SE_NW,
            0,
            0,
        },
    };
    if (trackElement.HasChain())
    {
        if (direction == 0 || direction == 3)
        {
            WoodenRCTrackPaint<isClassic>(
                session, direction, imageIdsChained[direction][0], imageIdsChained[direction][1], { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
        }
        else
        {
            session.WoodenSupportsPrependTo = WoodenRCTrackPaint<isClassic>(
                session, direction, imageIdsChained[direction][0], imageIdsChained[direction][1], { 0, 0, height },
                { { 28, 4, height + 2 }, { 2, 24, 43 } });
            WoodenRCTrackPaint<isClassic>(
                session, direction, imageIdsChained[direction][2], imageIdsChained[direction][3], { 0, 0, height },
                { { 0, 4, height }, { 32, 2, 43 } });
        }
    }
    else
    {
        if (direction == 0 || direction == 3)
        {
            WoodenRCTrackPaint<isClassic>(
                session, direction, imageIds[direction][0], imageIds[direction][1], { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
        }
        else
        {
            session.WoodenSupportsPrependTo = WoodenRCTrackPaint<isClassic>(
                session, direction, imageIds[direction][0], imageIds[direction][1], { 0, 0, height },
                { { 28, 4, height + 2 }, { 2, 24, 43 } });
            WoodenRCTrackPaint<isClassic>(
                session, direction, imageIds[direction][2], imageIds[direction][3], { 0, 0, height },
                { { 0, 4, height }, { 32, 2, 43 } });
        }
    }

    WoodenASupportsPaintSetupRotated(
        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
        WoodenSupportTransitionType::Up25DegToUp60Deg);

    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, TUNNEL_SQUARE_7);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 24, TUNNEL_SQUARE_8);
    }

    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
}

/** rct2: 0x008AC5B8 */
template<bool isClassic>
static void WoodenRCTrack60DegUpTo25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    static constexpr uint32_t imageIdsChained[4][4] = {
        {
            SPR_G2_WOODEN_RC_60_25_SWNE_CHAINED,
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_SW_NE,
            0,
            0,
        },
        {
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_NW_SE,
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_NW_SE,
            SPR_G2_WOODEN_RC_60_25_SWNE_CHAINED_BACK,
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_FRONT_NW_SE,
        },
        {
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_NE_SW,
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_NE_SW,
            SPR_G2_WOODEN_RC_60_25_SENW_CHAINED_BACK,
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_FRONT_NE_SW,
        },
        {
            SPR_G2_WOODEN_RC_60_25_SENW_CHAINED,
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_SE_NW,
            0,
            0,
        },
    };

    static constexpr uint32_t imageIds[4][4] = {
        {
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_SW_NE,
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_SW_NE,
            0,
            0,
        },
        {
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_NW_SE,
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_NW_SE,
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_FRONT_NW_SE,
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_FRONT_NW_SE,
        },
        {
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_NE_SW,
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_NE_SW,
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_FRONT_NE_SW,
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_FRONT_NE_SW,
        },
        {
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_SE_NW,
            SPR_WOODEN_RC_60_DEG_TO_25_DEG_RAILS_SE_NW,
            0,
            0,
        },
    };

    if (trackElement.HasChain())
    {
        if (direction == 0 || direction == 3)
        {
            WoodenRCTrackPaint<isClassic>(
                session, direction, imageIdsChained[direction][0], imageIdsChained[direction][1], { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
        }
        else
        {
            session.WoodenSupportsPrependTo = WoodenRCTrackPaint<isClassic>(
                session, direction, imageIdsChained[direction][0], imageIdsChained[direction][1], { 0, 0, height },
                { { 4, 28, height - 16 }, { 24, 1, 61 } });
            WoodenRCTrackPaint<isClassic>(
                session, direction, imageIdsChained[direction][2], imageIdsChained[direction][3], { 0, 0, height },
                { { 0, 4, height }, { 32, 2, 43 } });
        }
    }
    else
    {
        if (direction == 0 || direction == 3)
        {
            WoodenRCTrackPaint<isClassic>(
                session, direction, imageIds[direction][0], imageIds[direction][1], { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
        }
        else
        {
            session.WoodenSupportsPrependTo = WoodenRCTrackPaint<isClassic>(
                session, direction, imageIds[direction][0], imageIds[direction][1], { 0, 0, height },
                { { 4, 28, height - 16 }, { 24, 1, 61 } });
            WoodenRCTrackPaint<isClassic>(
                session, direction, imageIds[direction][2], imageIds[direction][3], { 0, 0, height },
                { { 0, 4, height }, { 32, 2, 43 } });
        }
    }

    WoodenASupportsPaintSetupRotated(
        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
        WoodenSupportTransitionType::Up60DegToUp25Deg);

    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, TUNNEL_SQUARE_7);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 24, TUNNEL_SQUARE_8);
    }

    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
}

/** rct2: 0x008AC5C8 */
template<bool isClassic>
static void WoodenRCTrack25DegUpToFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    static constexpr uint32_t imageIds[2][4][4] = {
        {
            {
                SPR_WOODEN_RC_25_DEG_TO_FLAT_SW_NE,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_RAILS_SW_NE,
                0,
                0,
            },
            {
                SPR_WOODEN_RC_25_DEG_TO_FLAT_NW_SE,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_RAILS_NW_SE,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_FRONT_NW_SE,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_RAILS_FRONT_NW_SE,
            },
            {
                SPR_WOODEN_RC_25_DEG_TO_FLAT_NE_SW,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_RAILS_NE_SW,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_FRONT_NE_SW,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_RAILS_FRONT_NE_SW,
            },
            {
                SPR_WOODEN_RC_25_DEG_TO_FLAT_SE_NW,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_RAILS_SE_NW,
                0,
                0,
            },
        },
        {
            {
                SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_SW_NE,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_RAILS_SW_NE,
                0,
                0,
            },
            {
                SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_NW_SE,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_RAILS_NW_SE,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_FRONT_NW_SE,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_RAILS_FRONT_NW_SE,
            },
            {
                SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_NE_SW,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_RAILS_NE_SW,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_FRONT_NE_SW,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_RAILS_FRONT_NE_SW,
            },
            {
                SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_SE_NW,
                SPR_WOODEN_RC_25_DEG_TO_FLAT_CHAIN_RAILS_SE_NW,
                0,
                0,
            },
        },
    };

    uint8_t isChained = trackElement.HasChain() ? 1 : 0;
    WoodenRCTrackPaint<isClassic>(
        session, direction, imageIds[isChained][direction][0], imageIds[isChained][direction][1], { 0, 0, height },
        { { 0, 3, height }, { 32, 25, 2 } });
    if (direction == 1 || direction == 2)
    {
        WoodenRCTrackPaint<isClassic>(
            session, direction, imageIds[isChained][direction][2], imageIds[isChained][direction][3], { 0, 0, height },
            { { 0, 26, height + 5 }, { 32, 1, 9 } });
    }
    WoodenASupportsPaintSetupRotated(
        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
        WoodenSupportTransitionType::Up25DegToFlat);

    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, TUNNEL_SQUARE_FLAT);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 8, TUNNEL_14);
    }

    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 40, 0x20);
}

/** rct2: 0x008AC5D8 */
template<bool isClassic>
static void WoodenRCTrack25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    WoodenRCTrack25DegUp<isClassic>(session, ride, trackSequence, (direction + 2) & 3, height, trackElement);
}

/** rct2: 0x008AC5E8 */
template<bool isClassic>
static void WoodenRCTrack60DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    WoodenRCTrack60DegUp<isClassic>(session, ride, trackSequence, (direction + 2) & 3, height, trackElement);
}

/** rct2: 0x008AC5F8 */
template<bool isClassic>
static void WoodenRCTrackFlatTo25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    WoodenRCTrack25DegUpToFlat<isClassic>(session, ride, trackSequence, (direction + 2) & 3, height, trackElement);
}

/** rct2: 0x008AC608 */
template<bool isClassic>
static void WoodenRCTrack25DegDownTo60DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    WoodenRCTrack60DegUpTo25DegUp<isClassic>(session, ride, trackSequence, (direction + 2) & 3, height, trackElement);
}

/** rct2: 0x008AC618 */
template<bool isClassic>
static void WoodenRCTrack60DegDownTo25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    WoodenRCTrack25DegUpTo60DegUp<isClassic>(session, ride, trackSequence, (direction + 2) & 3, height, trackElement);
}

/** rct2: 0x008AC628 */
template<bool isClassic>
static void WoodenRCTrack25DegDownToFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    WoodenRCTrackFlatTo25DegUp<isClassic>(session, ride, trackSequence, (direction + 2) & 3, height, trackElement);
}

template<bool isClassic>
static void WoodenRCTrackRightQuarterTurn5(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    static constexpr SpriteBoundBox2 imageIds[2][4][7] = {
        {
            {
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_SW_SE_SEQ_0,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SW_SE_SEQ_0,
                    { 0, 2, 0 },
                    BoundBoxXYZ({ 0, 2, 0 }, { 32, 32, 2 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_SW_SE_SEQ_2,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SW_SE_SEQ_2,
                    { 0, 16, 0 },
                    BoundBoxXYZ({ 0, 16, 0 }, { 32, 16, 2 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_SW_SE_SEQ_3,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SW_SE_SEQ_3,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 16, 16, 2 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_SW_SE_SEQ_5,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SW_SE_SEQ_5,
                    { 16, 0, 0 },
                    BoundBoxXYZ({ 16, 0, 0 }, { 16, 32, 2 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_SW_SE_SEQ_6,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SW_SE_SEQ_6,
                    { 2, 0, 0 },
                    BoundBoxXYZ({ 2, 0, 0 }, { 32, 32, 2 }),
                },
            },
            {
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_NW_SW_SEQ_0,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NW_SW_SEQ_0,
                    { 2, 0, 0 },
                    BoundBoxXYZ({ 2, 0, 0 }, { 32, 32, 2 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_NW_SW_SEQ_2,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NW_SW_SEQ_2,
                    { 16, 0, 0 },
                    BoundBoxXYZ({ 16, 0, 0 }, { 16, 34, 2 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_NW_SW_SEQ_3,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NW_SW_SEQ_3,
                    { 0, 16, 0 },
                    BoundBoxXYZ({ 0, 16, 0 }, { 16, 16, 2 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_NW_SW_SEQ_5,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NW_SW_SEQ_5,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 32, 16, 2 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_NW_SW_SEQ_6,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NW_SW_SEQ_6,
                    { 0, 2, 0 },
                    BoundBoxXYZ({ 0, 2, 0 }, { 32, 27, 2 }),
                },
            },
            {
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_NE_NW_SEQ_0,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NE_NW_SEQ_0,
                    { 0, 2, 0 },
                    BoundBoxXYZ({ 0, 2, 0 }, { 32, 27, 2 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_NE_NW_SEQ_2,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NE_NW_SEQ_2,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 32, 16, 2 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_NE_NW_SEQ_3,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NE_NW_SEQ_3,
                    { 16, 16, 0 },
                    BoundBoxXYZ({ 16, 16, 0 }, { 16, 16, 2 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_NE_NW_SEQ_5,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NE_NW_SEQ_5,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 16, 32, 2 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_NE_NW_SEQ_6,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_NE_NW_SEQ_6,
                    { 2, 0, 0 },
                    BoundBoxXYZ({ 2, 0, 0 }, { 27, 32, 2 }),
                },
            },
            {
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_SE_NE_SEQ_0,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SE_NE_SEQ_0,
                    { 2, 0, 0 },
                    BoundBoxXYZ({ 2, 0, 0 }, { 27, 32, 2 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_SE_NE_SEQ_2,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SE_NE_SEQ_2,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 16, 32, 2 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_SE_NE_SEQ_3,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SE_NE_SEQ_3,
                    { 16, 0, 0 },
                    BoundBoxXYZ({ 16, 0, 0 }, { 16, 16, 2 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_SE_NE_SEQ_5,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SE_NE_SEQ_5,
                    { 0, 16, 0 },
                    BoundBoxXYZ({ 0, 16, 0 }, { 32, 16, 2 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_SE_NE_SEQ_6,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_SE_NE_SEQ_6,
                    { 0, 2, 0 },
                    BoundBoxXYZ({ 0, 2, 0 }, { 32, 32, 2 }),
                },
            },
        },
        {
            {
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_SW_SE_SEQ_0,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_0,
                    { 0, 2, 0 },
                    BoundBoxXYZ({ 0, 2, 27 }, { 32, 32, 0 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_SW_SE_SEQ_2,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_2,
                    { 0, 16, 0 },
                    BoundBoxXYZ({ 0, 16, 27 }, { 32, 16, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_SW_SE_SEQ_3,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_3,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 27 }, { 16, 16, 0 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_SW_SE_SEQ_5,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_5,
                    { 16, 0, 0 },
                    BoundBoxXYZ({ 16, 0, 27 }, { 16, 32, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_SW_SE_SEQ_6,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_6,
                    { 2, 0, 0 },
                    BoundBoxXYZ({ 2, 0, 27 }, { 32, 32, 0 }),
                },
            },
            {
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
            },
            {
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_NE_NW_SEQ_0,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_0,
                    { 0, 2, 0 },
                    BoundBoxXYZ({ 0, 2, 27 }, { 32, 27, 0 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_NE_NW_SEQ_2,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_2,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 27 }, { 32, 16, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_NE_NW_SEQ_3,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_3,
                    { 16, 16, 0 },
                    BoundBoxXYZ({ 16, 16, 27 }, { 16, 16, 0 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_NE_NW_SEQ_5,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_5,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 27 }, { 16, 32, 0 }),
                },
                {
                    SPR_WOODEN_RC_QUARTER_TURN_5_FRONT_NE_NW_SEQ_6,
                    SPR_WOODEN_RC_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_6,
                    { 2, 0, 0 },
                    BoundBoxXYZ({ 2, 0, 27 }, { 27, 32, 0 }),
                },
            },
            {
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
            },
        },
    };
    static WoodenSupportSubType supportType[NumOrthogonalDirections][7] = {
        { WoodenSupportSubType::NeSw, WoodenSupportSubType::Null, WoodenSupportSubType::Corner2, WoodenSupportSubType::Corner0,
          WoodenSupportSubType::Null, WoodenSupportSubType::Corner2, WoodenSupportSubType::NwSe },
        { WoodenSupportSubType::NwSe, WoodenSupportSubType::Null, WoodenSupportSubType::Corner3, WoodenSupportSubType::Corner1,
          WoodenSupportSubType::Null, WoodenSupportSubType::Corner3, WoodenSupportSubType::NeSw },
        { WoodenSupportSubType::NeSw, WoodenSupportSubType::Null, WoodenSupportSubType::Corner0, WoodenSupportSubType::Corner2,
          WoodenSupportSubType::Null, WoodenSupportSubType::Corner0, WoodenSupportSubType::NwSe },
        { WoodenSupportSubType::NwSe, WoodenSupportSubType::Null, WoodenSupportSubType::Corner1, WoodenSupportSubType::Corner3,
          WoodenSupportSubType::Null, WoodenSupportSubType::Corner1, WoodenSupportSubType::NeSw },
    };

    WoodenRCTrackPaintBb<isClassic>(session, &imageIds[0][direction][trackSequence], height);
    WoodenRCTrackPaintBb<isClassic>(session, &imageIds[1][direction][trackSequence], height);
    TrackPaintUtilRightQuarterTurn5TilesTunnel(session, height, direction, trackSequence, TUNNEL_SQUARE_FLAT);

    if (supportType[direction][trackSequence] != WoodenSupportSubType::Null)
    {
        WoodenASupportsPaintSetup(
            session, WoodenSupportType::Truss, supportType[direction][trackSequence], height, session.SupportColours);
    }

    int32_t blockedSegments = 0;
    switch (trackSequence)
    {
        case 0:
            blockedSegments = kSegmentsAll;
            break;
        case 1:
            blockedSegments = EnumsToFlags(PaintSegment::topCorner, PaintSegment::topLeftSide, PaintSegment::topRightSide);
            break;
        case 2:
            blockedSegments = EnumsToFlags(
                PaintSegment::rightCorner, PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::topRightSide,
                PaintSegment::bottomLeftSide, PaintSegment::bottomRightSide);
            break;
        case 3:
            blockedSegments = EnumsToFlags(
                PaintSegment::topCorner, PaintSegment::leftCorner, PaintSegment::rightCorner, PaintSegment::centre,
                PaintSegment::topLeftSide, PaintSegment::topRightSide, PaintSegment::bottomLeftSide,
                PaintSegment::bottomRightSide);
            break;
        case 4:
            blockedSegments = EnumsToFlags(PaintSegment::topCorner, PaintSegment::topLeftSide, PaintSegment::topRightSide);
            break;
        case 5:
            blockedSegments = EnumsToFlags(
                PaintSegment::leftCorner, PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                PaintSegment::bottomLeftSide, PaintSegment::bottomRightSide);
            break;
        case 6:
            blockedSegments = kSegmentsAll;
            break;
    }
    PaintUtilSetSegmentSupportHeight(session, PaintUtilRotateSegments(blockedSegments, direction), 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
}

template<bool isClassic>
static void WoodenRCTrackLeftQuarterTurn5(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    trackSequence = mapLeftQuarterTurn5TilesToRightQuarterTurn5Tiles[trackSequence];
    WoodenRCTrackRightQuarterTurn5<isClassic>(session, ride, trackSequence, (direction + 1) & 3, height, trackElement);
}

/** rct2: 0x008AC658 */
template<bool isClassic>
static void WoodenRCTrackFlatToLeftBank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    static constexpr uint32_t imageIds[4][4] = {
        {
            SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_SW_NE,
            SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_RAILS_SW_NE,
            0,
            0,
        },
        {
            SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_NW_SE,
            SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_RAILS_NW_SE,
            SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_FRONT_NW_SE,
            SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_RAILS_FRONT_NW_SE,
        },
        {
            SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_NE_SW,
            SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_RAILS_NE_SW,
            0,
            0,
        },
        {
            SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_SE_NW,
            SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_RAILS_SE_NW,
            SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_FRONT_SE_NW,
            SPR_WOODEN_RC_FLAT_TO_LEFT_BANK_RAILS_FRONT_SE_NW,
        },
    };

    WoodenRCTrackPaint<isClassic>(
        session, direction, imageIds[direction][0], imageIds[direction][1], { 0, 0, height },
        { { 0, 3, height }, { 32, 25, 2 } });
    if (direction == 1 || direction == 3)
    {
        WoodenRCTrackPaint<isClassic>(
            session, direction, imageIds[direction][2], imageIds[direction][3], { 0, 0, height },
            { { 0, 26, height + 5 }, { 32, 1, 9 } });
    }
    WoodenASupportsPaintSetupRotated(
        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours);
    PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_FLAT);
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
}

/** rct2: 0x008AC668 */
template<bool isClassic>
static void WoodenRCTrackFlatToRightBank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    static constexpr uint32_t imageIds[4][4] = {
        {
            SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_SW_NE,
            SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_RAILS_SW_NE,
            SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_FRONT_SW_NE,
            SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_RAILS_FRONT_SW_NE,
        },
        {
            SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_NW_SE,
            SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_RAILS_NW_SE,
            0,
            0,
        },
        {
            SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_NE_SW,
            SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_RAILS_NE_SW,
            SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_FRONT_NE_SW,
            SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_RAILS_FRONT_NE_SW,
        },
        {
            SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_SE_NW,
            SPR_WOODEN_RC_FLAT_TO_RIGHT_BANK_RAILS_SE_NW,
            0,
            0,
        },
    };

    WoodenRCTrackPaint<isClassic>(
        session, direction, imageIds[direction][0], imageIds[direction][1], { 0, 0, height },
        { { 0, 3, height }, { 32, 25, 2 } });
    if (direction == 0 || direction == 2)
    {
        WoodenRCTrackPaint<isClassic>(
            session, direction, imageIds[direction][2], imageIds[direction][3], { 0, 0, height },
            { { 0, 26, height + 5 }, { 32, 1, 9 } });
    }
    WoodenASupportsPaintSetupRotated(
        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours);
    PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_FLAT);
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
}

/** rct2: 0x008AC678 */
template<bool isClassic>
static void WoodenRCTrackLeftBankToFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    WoodenRCTrackFlatToRightBank<isClassic>(session, ride, trackSequence, (direction + 2) & 3, height, trackElement);
}

/** rct2: 0x008AC688 */
template<bool isClassic>
static void WoodenRCTrackRightBankToFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    WoodenRCTrackFlatToLeftBank<isClassic>(session, ride, trackSequence, (direction + 2) & 3, height, trackElement);
}

template<bool isClassic>
static void WoodenRCTrackBankedRightQuarterTurn5(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    static constexpr SpriteBoundBox2 imageIds[2][4][7] = {
        {
            {
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SW_SE_SEQ_0,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SW_SE_SEQ_0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 2, 0 }, { 32, 32, 2 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SW_SE_SEQ_2,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SW_SE_SEQ_2,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 16, 0 }, { 32, 16, 2 }),
                },
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SW_SE_SEQ_3,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SW_SE_SEQ_3,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 16, 16, 2 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SW_SE_SEQ_5,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SW_SE_SEQ_5,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 16, 0, 0 }, { 16, 32, 2 }),
                },
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SW_SE_SEQ_6,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SW_SE_SEQ_6,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 2, 0, 0 }, { 32, 32, 2 }),
                },
            },
            {
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NW_SW_SEQ_0,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NW_SW_SEQ_0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 2, 0, 0 }, { 32, 32, 2 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NW_SW_SEQ_2,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NW_SW_SEQ_2,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 16, 0, 0 }, { 16, 32, 2 }),
                },
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NW_SW_SEQ_3,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NW_SW_SEQ_3,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 16, 0 }, { 16, 16, 2 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NW_SW_SEQ_5,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NW_SW_SEQ_5,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 32, 16, 2 }),
                },
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NW_SW_SEQ_6,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NW_SW_SEQ_6,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 2, 0 }, { 32, 27, 2 }),
                },
            },
            {
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NE_NW_SEQ_0,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NE_NW_SEQ_0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 2, 0 }, { 32, 27, 2 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NE_NW_SEQ_2,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NE_NW_SEQ_2,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 32, 16, 2 }),
                },
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NE_NW_SEQ_3,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NE_NW_SEQ_3,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 16, 16, 0 }, { 16, 16, 2 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NE_NW_SEQ_5,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NE_NW_SEQ_5,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 16, 32, 2 }),
                },
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_NE_NW_SEQ_6,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_NE_NW_SEQ_6,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 2, 0, 0 }, { 27, 32, 2 }),
                },
            },
            {
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SE_NE_SEQ_0,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SE_NE_SEQ_0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 2, 0, 0 }, { 27, 32, 2 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SE_NE_SEQ_2,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SE_NE_SEQ_2,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 16, 32, 2 }),
                },
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SE_NE_SEQ_3,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SE_NE_SEQ_3,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 16, 0, 0 }, { 16, 16, 2 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SE_NE_SEQ_5,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SE_NE_SEQ_5,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 16, 0 }, { 32, 16, 2 }),
                },
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_SE_NE_SEQ_6,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_SE_NE_SEQ_6,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 2, 0 }, { 32, 32, 2 }),
                },
            },
        },
        {
            {
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_SW_SE_SEQ_0,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 2, 27 }, { 32, 32, 0 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_SW_SE_SEQ_2,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_2,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 16, 27 }, { 32, 16, 0 }),
                },
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_SW_SE_SEQ_3,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_3,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 27 }, { 16, 16, 0 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_SW_SE_SEQ_5,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_5,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 16, 0, 27 }, { 16, 32, 0 }),
                },
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_SW_SE_SEQ_6,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_SW_SE_SEQ_6,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 2, 0, 27 }, { 32, 32, 0 }),
                },
            },
            {
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
            },
            {
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_NE_NW_SEQ_0,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 2, 27 }, { 32, 27, 0 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_NE_NW_SEQ_2,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_2,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 27 }, { 32, 16, 0 }),
                },
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_NE_NW_SEQ_3,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_3,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 16, 16, 27 }, { 16, 16, 0 }),
                },
                {
                    0,
                    0,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }),
                },
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_NE_NW_SEQ_5,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_5,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 0, 0, 27 }, { 16, 32, 0 }),
                },
                {
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_FRONT_NE_NW_SEQ_6,
                    SPR_WOODEN_RC_BANKED_QUARTER_TURN_5_RAILS_FRONT_NE_NW_SEQ_6,
                    { 0, 0, 0 },
                    BoundBoxXYZ({ 2, 0, 27 }, { 27, 32, 0 }),
                },
            },
            {
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
                { 0, 0, { 0, 0, 0 }, BoundBoxXYZ({ 0, 0, 0 }, { 0, 0, 0 }) },
            },
        },
    };
    static WoodenSupportSubType supportType[NumOrthogonalDirections][7] = {
        { WoodenSupportSubType::NeSw, WoodenSupportSubType::Null, WoodenSupportSubType::Corner2, WoodenSupportSubType::Corner0,
          WoodenSupportSubType::Null, WoodenSupportSubType::Corner2, WoodenSupportSubType::NwSe },
        { WoodenSupportSubType::NwSe, WoodenSupportSubType::Null, WoodenSupportSubType::Corner3, WoodenSupportSubType::Corner1,
          WoodenSupportSubType::Null, WoodenSupportSubType::Corner3, WoodenSupportSubType::NeSw },
        { WoodenSupportSubType::NeSw, WoodenSupportSubType::Null, WoodenSupportSubType::Corner0, WoodenSupportSubType::Corner2,
          WoodenSupportSubType::Null, WoodenSupportSubType::Corner0, WoodenSupportSubType::NwSe },
        { WoodenSupportSubType::NwSe, WoodenSupportSubType::Null, WoodenSupportSubType::Corner1, WoodenSupportSubType::Corner3,
          WoodenSupportSubType::Null, WoodenSupportSubType::Corner1, WoodenSupportSubType::NeSw },
    };

    WoodenRCTrackPaintBb<isClassic>(session, &imageIds[0][direction][trackSequence], height);
    WoodenRCTrackPaintBb<isClassic>(session, &imageIds[1][direction][trackSequence], height);
    TrackPaintUtilRightQuarterTurn5TilesTunnel(session, height, direction, trackSequence, TUNNEL_SQUARE_FLAT);

    if (supportType[direction][trackSequence] != WoodenSupportSubType::Null)
    {
        WoodenASupportsPaintSetup(
            session, WoodenSupportType::Truss, supportType[direction][trackSequence], height, session.SupportColours);
    }

    int32_t blockedSegments = 0;
    switch (trackSequence)
    {
        case 0:
            blockedSegments = kSegmentsAll;
            break;
        case 1:
            blockedSegments = EnumsToFlags(PaintSegment::topCorner, PaintSegment::topLeftSide, PaintSegment::topRightSide);
            break;
        case 2:
            blockedSegments = EnumsToFlags(
                PaintSegment::rightCorner, PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::topRightSide,
                PaintSegment::bottomLeftSide, PaintSegment::bottomRightSide);
            break;
        case 3:
            blockedSegments = EnumsToFlags(
                PaintSegment::topCorner, PaintSegment::leftCorner, PaintSegment::rightCorner, PaintSegment::centre,
                PaintSegment::topLeftSide, PaintSegment::topRightSide, PaintSegment::bottomLeftSide,
                PaintSegment::bottomRightSide);
            break;
        case 4:
            blockedSegments = EnumsToFlags(PaintSegment::topCorner, PaintSegment::topLeftSide, PaintSegment::topRightSide);
            break;
        case 5:
            blockedSegments = EnumsToFlags(
                PaintSegment::leftCorner, PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                PaintSegment::bottomLeftSide, PaintSegment::bottomRightSide);
            break;
        case 6:
            blockedSegments = kSegmentsAll;
            break;
    }
    PaintUtilSetSegmentSupportHeight(session, PaintUtilRotateSegments(blockedSegments, direction), 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
}

template<bool isClassic>
static void WoodenRCTrackBankedLeftQuarterTurn5(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    trackSequence = mapLeftQuarterTurn5TilesToRightQuarterTurn5Tiles[trackSequence];
    WoodenRCTrackBankedRightQuarterTurn5<isClassic>(session, ride, trackSequence, (direction + 1) & 3, height, trackElement);
}

/** rct2: 0x008AC6B8 */
template<bool isClassic>
static void WoodenRCTrackLeftBankTo25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    static constexpr uint32_t imageIds[4][4] = {
        {
            SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_SW_NE,
            SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_RAILS_SW_NE,
            0,
            0,
        },
        {
            SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_NW_SE,
            SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_RAILS_NW_SE,
            SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_FRONT_NW_SE,
            SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_RAILS_FRONT_NW_SE,
        },
        {
            SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_NE_SW,
            SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_RAILS_NE_SW,
            SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_FRONT_NE_SW,
            SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_RAILS_FRONT_NE_SW,
        },
        {
            SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_SE_NW,
            SPR_WOODEN_RC_LEFT_BANK_TO_25_DEG_RAILS_SE_NW,
            0,
            0,
        },
    };

    WoodenRCTrackPaint<isClassic>(
        session, direction, imageIds[direction][0], imageIds[direction][1], { 0, 0, height },
        { { 0, 3, height }, { 32, 25, 2 } });
    if (direction == 1 || direction == 2)
    {
        WoodenRCTrackPaint<isClassic>(
            session, direction, imageIds[direction][2], imageIds[direction][3], { 0, 0, height },
            { { 0, 26, height + 5 }, { 32, 1, 9 } });
    }
    WoodenASupportsPaintSetupRotated(
        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
        WoodenSupportTransitionType::FlatToUp25Deg);
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_FLAT);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_8);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
}

/** rct2: 0x008AC6C8 */
template<bool isClassic>
static void WoodenRCTrackRightBankTo25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    static constexpr uint32_t imageIds[4][4] = {
        {
            SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_SW_NE,
            SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_RAILS_SW_NE,
            0,
            0,
        },
        {
            SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_NW_SE,
            SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_RAILS_NW_SE,
            SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_FRONT_NW_SE,
            SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_RAILS_FRONT_NW_SE,
        },
        {
            SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_NE_SW,
            SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_RAILS_NE_SW,
            SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_FRONT_NE_SW,
            SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_RAILS_FRONT_NE_SW,
        },
        {
            SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_SE_NW,
            SPR_WOODEN_RC_RIGHT_BANK_TO_25_DEG_RAILS_SE_NW,
            0,
            0,
        },
    };

    WoodenRCTrackPaint<isClassic>(
        session, direction, imageIds[direction][0], imageIds[direction][1], { 0, 0, height },
        { { 0, 3, height }, { 32, 25, 2 } });
    if (direction == 1 || direction == 2)
    {
        WoodenRCTrackPaint<isClassic>(
            session, direction, imageIds[direction][2], imageIds[direction][3], { 0, 0, height },
            { { 0, 26, height + 5 }, { 32, 1, 9 } });
    }
    WoodenASupportsPaintSetupRotated(
        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
        WoodenSupportTransitionType::FlatToUp25Deg);
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_FLAT);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_8);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
}

/** rct2: 0x008AC6D8 */
template<bool isClassic>
static void WoodenRCTrack25DegUpToLeftBank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    static constexpr uint32_t imageIds[4][4] = {
        {
            SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_SW_NE,
            SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_RAILS_SW_NE,
            0,
            0,
        },
        {
            SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_NW_SE,
            SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_RAILS_NW_SE,
            SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_FRONT_NW_SE,
            SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_RAILS_FRONT_NW_SE,
        },
        {
            SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_NE_SW,
            SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_RAILS_NE_SW,
            SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_FRONT_NE_SW,
            SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_RAILS_FRONT_NE_SW,
        },
        {
            SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_SE_NW,
            SPR_WOODEN_RC_25_DEG_TO_LEFT_BANK_RAILS_SE_NW,
            0,
            0,
        },
    };

    WoodenRCTrackPaint<isClassic>(
        session, direction, imageIds[direction][0], imageIds[direction][1], { 0, 0, height },
        { { 0, 3, height }, { 32, 25, 2 } });
    if (direction == 1 || direction == 2)
    {
        WoodenRCTrackPaint<isClassic>(
            session, direction, imageIds[direction][2], imageIds[direction][3], { 0, 0, height },
            { { 0, 26, height + 5 }, { 32, 1, 9 } });
    }
    WoodenASupportsPaintSetupRotated(
        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
        WoodenSupportTransitionType::Up25DegToFlat);
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, TUNNEL_SQUARE_FLAT);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 8, TUNNEL_14);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 40, 0x20);
}

/** rct2: 0x008AC6E8 */
template<bool isClassic>
static void WoodenRCTrack25DegUpToRightBank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    static constexpr uint32_t imageIds[4][4] = {
        {
            SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_SW_NE,
            SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_RAILS_SW_NE,
            0,
            0,
        },
        {
            SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_NW_SE,
            SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_RAILS_NW_SE,
            SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_FRONT_NW_SE,
            SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_RAILS_FRONT_NW_SE,
        },
        {
            SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_NE_SW,
            SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_RAILS_NE_SW,
            SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_FRONT_NE_SW,
            SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_RAILS_FRONT_NE_SW,
        },
        {
            SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_SE_NW,
            SPR_WOODEN_RC_25_DEG_TO_RIGHT_BANK_RAILS_SE_NW,
            0,
            0,
        },
    };

    WoodenRCTrackPaint<isClassic>(
        session, direction, imageIds[direction][0], imageIds[direction][1], { 0, 0, height },
        { { 0, 3, height }, { 32, 25, 2 } });
    if (direction == 1 || direction == 2)
    {
        WoodenRCTrackPaint<isClassic>(
            session, direction, imageIds[direction][2], imageIds[direction][3], { 0, 0, height },
            { { 0, 26, height + 5 }, { 32, 1, 9 } });
    }
    WoodenASupportsPaintSetupRotated(
        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
        WoodenSupportTransitionType::Up25DegToFlat);
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, TUNNEL_SQUARE_FLAT);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 8, TUNNEL_14);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 40, 0x20);
}

/** rct2: 0x008AC6F8 */
template<bool isClassic>
static void WoodenRCTrackLeftBankTo25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    WoodenRCTrack25DegUpToRightBank<isClassic>(session, ride, trackSequence, (direction + 2) & 3, height, trackElement);
}

/** rct2: 0x008AC708 */
template<bool isClassic>
static void WoodenRCTrackRightBankTo25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    WoodenRCTrack25DegUpToLeftBank<isClassic>(session, ride, trackSequence, (direction + 2) & 3, height, trackElement);
}

/** rct2: 0x008AC718 */
template<bool isClassic>
static void WoodenRCTrack25DegDownToLeftBank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    WoodenRCTrackRightBankTo25DegUp<isClassic>(session, ride, trackSequence, (direction + 2) & 3, height, trackElement);
}

/** rct2: 0x008AC728 */
template<bool isClassic>
static void WoodenRCTrack25DegDownToRightBank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    WoodenRCTrackLeftBankTo25DegUp<isClassic>(session, ride, trackSequence, (direction + 2) & 3, height, trackElement);
}

/** rct2: 0x008AC738 */
template<bool isClassic>
static void WoodenRCTrackLeftBank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    static constexpr uint32_t imageIds[4][2] = {
        { SPR_WOODEN_RC_LEFT_BANK_SW_NE, SPR_WOODEN_RC_LEFT_BANK_RAILS_SW_NE },
        { SPR_WOODEN_RC_LEFT_BANK_NW_SE, SPR_WOODEN_RC_LEFT_BANK_RAILS_NW_SE },
        { SPR_WOODEN_RC_LEFT_BANK_NE_SW, SPR_WOODEN_RC_LEFT_BANK_RAILS_NE_SW },
        { SPR_WOODEN_RC_LEFT_BANK_SE_NW, SPR_WOODEN_RC_LEFT_BANK_RAILS_SE_NW },
    };

    WoodenRCTrackPaint<isClassic>(
        session, direction, imageIds[direction][0], imageIds[direction][1], { 0, 0, height },
        { { 0, 3, height }, { 32, 25, 2 } });
    WoodenASupportsPaintSetupRotated(
        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours);
    PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_FLAT);
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
}

/** rct2: 0x008AC748 */
template<bool isClassic>
static void WoodenRCTrackRightBank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    WoodenRCTrackLeftBank<isClassic>(session, ride, trackSequence, (direction + 2) & 3, height, trackElement);
}

/** rct2: 0x008AC758 */
template<bool isClassic>
static void WoodenRCTrackLeftQuarterTurn525DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23781), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24647), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    WoodenASupportsPaintSetupRotated(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height,
                        session.SupportColours, WoodenSupportTransitionType::Up25Deg);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23786), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24652), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23812), { 0, 0, height },
                        { { 0, 2, height + 67 }, { 32, 27, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24678), { 0, 0, height },
                        { { 0, 2, height + 67 }, { 32, 27, 0 } });
                    WoodenASupportsPaintSetupRotated(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height,
                        session.SupportColours, WoodenSupportTransitionType::Up25Deg);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23791), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24657), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    WoodenASupportsPaintSetupRotated(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height,
                        session.SupportColours, WoodenSupportTransitionType::Up25Deg);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23796), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24662), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    WoodenASupportsPaintSetupRotated(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height,
                        session.SupportColours, WoodenSupportTransitionType::Up25Deg);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height - 8, TUNNEL_SQUARE_7);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 1:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::rightCorner, PaintSegment::topRightSide, PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23782), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24648), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23787), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24653), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23813), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24679), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23792), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24658), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23797), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24663), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23819), { 0, 0, height },
                        { { 0, 16, height + 67 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24685), { 0, 0, height },
                        { { 0, 16, height + 67 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::leftCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::topRightSide, PaintSegment::bottomLeftSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23783), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24649), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23788), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24654), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23814), { 0, 0, height },
                        { { 16, 16, height + 59 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24680), { 0, 0, height },
                        { { 16, 16, height + 59 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23793), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24659), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23798), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24664), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23820), { 0, 0, height },
                        { { 0, 0, height + 59 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24686), { 0, 0, height },
                        { { 0, 0, height + 59 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::rightCorner, PaintSegment::bottomCorner, PaintSegment::centre,
                        PaintSegment::topLeftSide, PaintSegment::topRightSide, PaintSegment::bottomLeftSide,
                        PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 64, 0x20);
            break;
        case 4:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::rightCorner, PaintSegment::topRightSide, PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 5:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23784), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24650), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23789), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24655), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23815), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24681), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23794), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24660), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23817), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24683), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23799), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24665), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23821), { 0, 0, height },
                        { { 16, 0, height + 67 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24687), { 0, 0, height },
                        { { 16, 0, height + 67 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::leftCorner, PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::bottomLeftSide, PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 6:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23785), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24651), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23790), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24656), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23816), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24682), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23795), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24661), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23818), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24684), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23800), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24666), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23822), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24688), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    break;
            }
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, DirectionPrev(direction), height,
                session.SupportColours, WoodenSupportTransitionType::Up25Deg);
            switch (direction)
            {
                case 2:
                    PaintUtilPushTunnelRight(session, height + 8, TUNNEL_SQUARE_8);
                    break;
                case 3:
                    PaintUtilPushTunnelLeft(session, height + 8, TUNNEL_SQUARE_8);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
    }
}

/** rct2: 0x008AC768 */
template<bool isClassic>
static void WoodenRCTrackRightQuarterTurn525DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23761), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24627), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    WoodenASupportsPaintSetupRotated(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height,
                        session.SupportColours, WoodenSupportTransitionType::Up25Deg);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23766), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24632), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    WoodenASupportsPaintSetupRotated(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height,
                        session.SupportColours, WoodenSupportTransitionType::Up25Deg);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23771), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24637), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23807), { 0, 0, height },
                        { { 0, 2, height + 67 }, { 32, 27, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24673), { 0, 0, height },
                        { { 0, 2, height + 67 }, { 32, 27, 0 } });
                    WoodenASupportsPaintSetupRotated(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height,
                        session.SupportColours, WoodenSupportTransitionType::Up25Deg);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23776), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24642), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    WoodenASupportsPaintSetupRotated(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height,
                        session.SupportColours, WoodenSupportTransitionType::Up25Deg);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height - 8, TUNNEL_SQUARE_7);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 1:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::topCorner, PaintSegment::topLeftSide, PaintSegment::topRightSide), direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23762), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24628), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23801), { 0, 0, height },
                        { { 0, 16, height + 67 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24667), { 0, 0, height },
                        { { 0, 16, height + 67 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23767), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24633), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23772), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24638), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23808), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24674), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23777), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24643), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::rightCorner, PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::topRightSide,
                        PaintSegment::bottomLeftSide, PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23763), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24629), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23802), { 0, 0, height },
                        { { 0, 0, height + 59 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24668), { 0, 0, height },
                        { { 0, 0, height + 59 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23768), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24634), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23773), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24639), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23809), { 0, 0, height },
                        { { 16, 16, height + 59 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24675), { 0, 0, height },
                        { { 16, 16, height + 59 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23778), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24644), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::leftCorner, PaintSegment::rightCorner, PaintSegment::centre,
                        PaintSegment::topLeftSide, PaintSegment::topRightSide, PaintSegment::bottomLeftSide,
                        PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 64, 0x20);
            break;
        case 4:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::topCorner, PaintSegment::topLeftSide, PaintSegment::topRightSide), direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 5:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23764), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24630), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23803), { 0, 0, height },
                        { { 16, 0, height + 67 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24669), { 0, 0, height },
                        { { 16, 0, height + 67 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23769), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24635), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23805), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24671), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23774), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24640), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23810), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24676), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23779), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24645), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::leftCorner, PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::bottomLeftSide, PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 6:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23765), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24631), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23804), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24670), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });

                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23770), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24636), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23806), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24672), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23775), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24641), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23811), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24677), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23780), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24646), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    break;
            }
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, DirectionNext(direction), height,
                session.SupportColours, WoodenSupportTransitionType::Up25Deg);
            switch (direction)
            {
                case 0:
                    PaintUtilPushTunnelRight(session, height + 8, TUNNEL_SQUARE_8);
                    break;
                case 1:
                    PaintUtilPushTunnelLeft(session, height + 8, TUNNEL_SQUARE_8);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
    }
}

/** rct2: 0x008AC778 */
template<bool isClassic>
static void WoodenRCTrackLeftQuarterTurn525DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    trackSequence = mapLeftQuarterTurn5TilesToRightQuarterTurn5Tiles[trackSequence];
    WoodenRCTrackRightQuarterTurn525DegUp<isClassic>(session, ride, trackSequence, (direction + 1) & 3, height, trackElement);
}

/** rct2: 0x008AC788 */
template<bool isClassic>
static void WoodenRCTrackRightQuarterTurn525DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    trackSequence = mapLeftQuarterTurn5TilesToRightQuarterTurn5Tiles[trackSequence];
    WoodenRCTrackLeftQuarterTurn525DegUp<isClassic>(session, ride, trackSequence, (direction - 1) & 3, height, trackElement);
}

/** rct2: 0x008AC798 */
template<bool isClassic>
static void WoodenRCTrackSBendLeft(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23725), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24591), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23729), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24595), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23741), { 0, 0, height },
                        { { 0, 3, height + 27 }, { 32, 25, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24607), { 0, 0, height },
                        { { 0, 3, height + 27 }, { 32, 25, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23728), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24594), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23732), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24598), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23744), { 0, 0, height },
                        { { 0, 2, height + 27 }, { 32, 27, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24610), { 0, 0, height },
                        { { 0, 2, height + 27 }, { 32, 27, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_FLAT);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23726), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24592), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23730), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24596), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23742), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 26, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24608), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 26, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23727), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24593), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23731), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24597), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23743), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 26, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24609), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 26, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::leftCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::topRightSide, PaintSegment::bottomLeftSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23727), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24593), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23731), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24597), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23743), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 26, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24609), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 26, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23726), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24592), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23730), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24596), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23742), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 26, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24608), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 26, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::rightCorner, PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::topRightSide,
                        PaintSegment::bottomLeftSide, PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23728), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24594), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23732), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24598), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23744), { 0, 0, height },
                        { { 0, 2, height + 27 }, { 32, 27, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24610), { 0, 0, height },
                        { { 0, 2, height + 27 }, { 32, 27, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23725), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24591), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23729), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24595), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23741), { 0, 0, height },
                        { { 0, 3, height + 27 }, { 32, 25, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24607), { 0, 0, height },
                        { { 0, 3, height + 27 }, { 32, 25, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
            }
            switch (direction)
            {
                case 1:
                    PaintUtilPushTunnelRight(session, height, TUNNEL_SQUARE_FLAT);
                    break;
                case 2:
                    PaintUtilPushTunnelLeft(session, height, TUNNEL_SQUARE_FLAT);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
    }
}

/** rct2: 0x008AC7A8 */
template<bool isClassic>
static void WoodenRCTrackSBendRight(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23733), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24599), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23745), { 0, 0, height },
                        { { 0, 3, height + 27 }, { 32, 25, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24611), { 0, 0, height },
                        { { 0, 3, height + 27 }, { 32, 25, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23737), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24603), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23736), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24602), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23748), { 0, 0, height },
                        { { 0, 3, height + 27 }, { 32, 25, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24614), { 0, 0, height },
                        { { 0, 3, height + 27 }, { 32, 25, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23740), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24606), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_FLAT);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23734), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24600), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23746), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 26, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24612), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 26, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23738), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24604), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23735), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24601), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23747), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 26, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24613), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 26, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23739), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24605), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::rightCorner, PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::topRightSide,
                        PaintSegment::bottomLeftSide, PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23735), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24601), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23747), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 26, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24613), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 26, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23739), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24605), { 0, 0, height },
                        { { 0, 0, height }, { 32, 26, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23734), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24600), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23746), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 26, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24612), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 26, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23738), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24604), { 0, 0, height },
                        { { 0, 6, height }, { 32, 26, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::leftCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::topRightSide, PaintSegment::bottomLeftSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23736), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24602), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23748), { 0, 0, height },
                        { { 0, 3, height + 27 }, { 32, 25, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24614), { 0, 0, height },
                        { { 0, 3, height + 27 }, { 32, 25, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23740), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24606), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23733), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24599), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23745), { 0, 0, height },
                        { { 0, 3, height + 27 }, { 32, 25, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24611), { 0, 0, height },
                        { { 0, 3, height + 27 }, { 32, 25, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23737), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24603), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
            }
            switch (direction)
            {
                case 1:
                    PaintUtilPushTunnelRight(session, height, TUNNEL_SQUARE_FLAT);
                    break;
                case 2:
                    PaintUtilPushTunnelLeft(session, height, TUNNEL_SQUARE_FLAT);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
    }
}

/** rct2: 0x008ACE18 */
template<bool isClassic>
static void WoodenRCTrackLeftVerticalLoop(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23453), { 0, 6, height }, { 32, 20, 3 });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23461), { 0, 6, height }, { 32, 20, 3 });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23460), { 0, 6, height }, { 32, 20, 3 });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23468), { 0, 6, height }, { 32, 20, 7 });
                    break;
            }
            MetalASupportsPaintSetup(
                session, MetalSupportType::Boxed, MetalSupportPlace::Centre, 8, height, session.SupportColours);
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height - 8, TUNNEL_SQUARE_7);
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::leftCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::topRightSide, PaintSegment::bottomLeftSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23454), { 0, 0, height }, { 32, 26, 3 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::Boxed, MetalSupportPlace::Centre, 20, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23462), { 0, 14, height }, { 32, 2, 63 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::Boxed, MetalSupportPlace::Centre, 9, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23459), { 0, 6, height }, { 32, 26, 3 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::Boxed, MetalSupportPlace::Centre, 16, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23467), { 0, 6, height }, { 32, 26, 3 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::Boxed, MetalSupportPlace::Centre, 16, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::leftCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::topRightSide, PaintSegment::bottomLeftSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23455), { 16, 0, height },
                        { 5, 16, 119 });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23463), { 12, 0, height },
                        { 3, 16, 119 });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23458), { 10, 16, height },
                        { 4, 16, 119 });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23466), { 16, 16, height },
                        { 4, 16, 119 });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::leftCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::bottomLeftSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 168, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23456), { 0, 0, height + 32 },
                        { 32, 16, 3 });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23464), { 0, 0, height + 32 },
                        { 32, 16, 3 });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23457), { 0, 16, height + 32 },
                        { 32, 16, 3 });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23465), { 0, 16, height + 32 },
                        { 32, 16, 3 });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::leftCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::topRightSide, PaintSegment::bottomLeftSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 4:
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 5:
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 6:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23457), { 0, 16, height + 32 },
                        { 32, 16, 3 });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23465), { 0, 16, height + 32 },
                        { 32, 16, 3 });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23456), { 0, 0, height + 32 },
                        { 32, 16, 3 });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23464), { 0, 0, height + 32 },
                        { 32, 16, 3 });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::rightCorner, PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::topRightSide,
                        PaintSegment::bottomLeftSide, PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 7:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23458), { 10, 16, height },
                        { 4, 16, 119 });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23466), { 16, 16, height },
                        { 4, 16, 119 });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23455), { 16, 0, height },
                        { 5, 16, 119 });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23463), { 12, 0, height },
                        { 3, 16, 119 });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::rightCorner, PaintSegment::centre, PaintSegment::topRightSide,
                        PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 168, 0x20);
            break;
        case 8:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23459), { 0, 6, height }, { 32, 26, 3 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::Boxed, MetalSupportPlace::Centre, 16, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23467), { 0, 6, height }, { 32, 26, 3 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::Boxed, MetalSupportPlace::Centre, 16, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23454), { 0, 0, height }, { 32, 26, 3 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::Boxed, MetalSupportPlace::Centre, 20, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23462), { 0, 14, height }, { 32, 2, 63 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::Boxed, MetalSupportPlace::Centre, 9, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::rightCorner, PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::topRightSide,
                        PaintSegment::bottomLeftSide, PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 9:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23460), { 0, 6, height }, { 32, 20, 3 });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23468), { 0, 6, height }, { 32, 20, 7 });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23453), { 0, 6, height }, { 32, 20, 3 });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23461), { 0, 6, height }, { 32, 20, 3 });
                    break;
            }
            MetalASupportsPaintSetup(
                session, MetalSupportType::Boxed, MetalSupportPlace::Centre, 8, height, session.SupportColours);
            switch (direction)
            {
                case 1:
                    PaintUtilPushTunnelRight(session, height - 8, TUNNEL_SQUARE_7);
                    break;
                case 2:
                    PaintUtilPushTunnelLeft(session, height - 8, TUNNEL_SQUARE_7);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::rightCorner, PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::topRightSide,
                        PaintSegment::bottomLeftSide, PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
    }
}

/** rct2: 0x008ACE28 */
template<bool isClassic>
static void WoodenRCTrackRightVerticalLoop(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23484), { 0, 6, height }, { 32, 20, 7 });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23476), { 0, 6, height }, { 32, 20, 3 });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23477), { 0, 6, height }, { 32, 20, 3 });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23469), { 0, 6, height }, { 32, 20, 3 });
                    break;
            }
            MetalASupportsPaintSetup(
                session, MetalSupportType::Boxed, MetalSupportPlace::Centre, 8, height, session.SupportColours);
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height - 8, TUNNEL_SQUARE_7);
            }
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23483), { 0, 6, height }, { 32, 26, 3 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::Boxed, MetalSupportPlace::Centre, 16, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23475), { 0, 6, height }, { 32, 26, 3 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::Boxed, MetalSupportPlace::Centre, 16, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23478), { 0, 14, height }, { 32, 2, 63 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::Boxed, MetalSupportPlace::Centre, 9, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23470), { 0, 0, height }, { 32, 26, 3 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::Boxed, MetalSupportPlace::Centre, 20, height, session.SupportColours);
                    break;
            }
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23482), { 16, 16, height },
                        { 4, 16, 119 });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23474), { 10, 16, height },
                        { 4, 16, 119 });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23479), { 12, 0, height },
                        { 3, 16, 119 });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23471), { 16, 0, height },
                        { 5, 16, 119 });
                    break;
            }
            PaintUtilSetGeneralSupportHeight(session, height + 168, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23481), { 0, 16, height + 32 },
                        { 32, 16, 3 });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23473), { 0, 16, height + 32 },
                        { 32, 16, 3 });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23480), { 0, 0, height + 32 },
                        { 32, 16, 3 });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23472), { 0, 0, height + 32 },
                        { 32, 16, 3 });
                    break;
            }
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 4:
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 5:
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 6:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23480), { 0, 0, height + 32 },
                        { 32, 16, 3 });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23472), { 0, 0, height + 32 },
                        { 32, 16, 3 });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23481), { 0, 16, height + 32 },
                        { 32, 16, 3 });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23473), { 0, 16, height + 32 },
                        { 32, 16, 3 });
                    break;
            }
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 7:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23479), { 12, 0, height },
                        { 3, 16, 119 });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23471), { 16, 0, height },
                        { 5, 16, 119 });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23482), { 16, 16, height },
                        { 4, 16, 119 });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23474), { 10, 16, height },
                        { 4, 16, 119 });
                    break;
            }
            PaintUtilSetGeneralSupportHeight(session, height + 168, 0x20);
            break;
        case 8:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23478), { 0, 14, height }, { 32, 2, 63 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::Boxed, MetalSupportPlace::Centre, 9, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23470), { 0, 0, height }, { 32, 26, 3 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::Boxed, MetalSupportPlace::Centre, 20, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23483), { 0, 6, height }, { 32, 26, 3 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::Boxed, MetalSupportPlace::Centre, 16, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23475), { 0, 6, height }, { 32, 26, 3 });
                    MetalASupportsPaintSetup(
                        session, MetalSupportType::Boxed, MetalSupportPlace::Centre, 16, height, session.SupportColours);
                    break;
            }
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 9:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23477), { 0, 6, height }, { 32, 20, 3 });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23469), { 0, 6, height }, { 32, 20, 3 });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23484), { 0, 6, height }, { 32, 20, 7 });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(23476), { 0, 6, height }, { 32, 20, 3 });
                    break;
            }
            MetalASupportsPaintSetup(
                session, MetalSupportType::Boxed, MetalSupportPlace::Centre, 8, height, session.SupportColours);
            switch (direction)
            {
                case 1:
                    PaintUtilPushTunnelRight(session, height - 8, TUNNEL_SQUARE_7);
                    break;
                case 2:
                    PaintUtilPushTunnelLeft(session, height - 8, TUNNEL_SQUARE_7);
                    break;
            }
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
    }

    TrackPaintUtilRightVerticalLoopSegments(session, direction, trackSequence);
}

/** rct2: 0x008AC7E8 */
template<bool isClassic>
static void WoodenRCTrackLeftQuarterTurn3(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23828), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24694), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23831), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24697), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23840), { 0, 6, height },
                        { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24706), { 0, 6, height },
                        { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23834), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24700), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23825), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24691), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23837), { 0, 6, height },
                        { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24703), { 0, 6, height },
                        { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_FLAT);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 1:
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23827), { 16, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24693), { 16, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23830), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24696), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23839), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24705), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23833), { 0, 16, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24699), { 0, 16, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23824), { 16, 16, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24690), { 16, 16, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23836), { 16, 16, height },
                        { { 16, 16, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24702), { 16, 16, height },
                        { { 16, 16, height + 27 }, { 16, 16, 0 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::leftCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::bottomLeftSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23826), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24692), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23829), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24695), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23838), { 6, 0, height },
                        { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24704), { 6, 0, height },
                        { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23832), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24698), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23823), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24689), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23835), { 6, 0, height },
                        { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24701), { 6, 0, height },
                        { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
            }
            switch (direction)
            {
                case 2:
                    PaintUtilPushTunnelRight(session, height, TUNNEL_SQUARE_FLAT);
                    break;
                case 3:
                    PaintUtilPushTunnelLeft(session, height, TUNNEL_SQUARE_FLAT);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
    }
}

/** rct2: 0x008AC7F8 */
template<bool isClassic>
static void WoodenRCTrackRightQuarterTurn3(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    trackSequence = mapLeftQuarterTurn3TilesToRightQuarterTurn3Tiles[trackSequence];
    WoodenRCTrackLeftQuarterTurn3<isClassic>(session, ride, trackSequence, (direction - 1) & 3, height, trackElement);
}

/** rct2: 0x008AC808 */
template<bool isClassic>
static void WoodenRCTrackLeftQuarterTurn3Bank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_5),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24712), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_8),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24715), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_17),
                        { 0, 0, height }, { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24724), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_11),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24718), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_2),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24709), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_14),
                        { 0, 0, height }, { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24721), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_FLAT);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 1:
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_4),
                        { 0, 0, height }, { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24711), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_7),
                        { 0, 0, height }, { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24714), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_16),
                        { 0, 0, height }, { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24723), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_10),
                        { 0, 0, height }, { { 0, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24717), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_1),
                        { 0, 0, height }, { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24708), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_13),
                        { 0, 0, height }, { { 16, 16, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24720), { 0, 0, height },
                        { { 16, 16, height + 27 }, { 16, 16, 0 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::leftCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::bottomLeftSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_3),
                        { 0, 0, height }, { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24710), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_6),
                        { 0, 0, height }, { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24713), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_15),
                        { 0, 0, height }, { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24722), { 0, 0, height },
                        { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_9),
                        { 0, 0, height }, { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24716), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_0),
                        { 0, 0, height }, { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24707), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_12),
                        { 0, 0, height }, { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24719), { 0, 0, height },
                        { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
            }
            switch (direction)
            {
                case 2:
                    PaintUtilPushTunnelRight(session, height, TUNNEL_SQUARE_FLAT);
                    break;
                case 3:
                    PaintUtilPushTunnelLeft(session, height, TUNNEL_SQUARE_FLAT);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
    }
}

/** rct2: 0x008AC818 */
template<bool isClassic>
static void WoodenRCTrackRightQuarterTurn3Bank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    trackSequence = mapLeftQuarterTurn3TilesToRightQuarterTurn3Tiles[trackSequence];
    WoodenRCTrackLeftQuarterTurn3Bank<isClassic>(session, ride, trackSequence, (direction - 1) & 3, height, trackElement);
}

/** rct2: 0x008AC828 */
template<bool isClassic>
static void WoodenRCTrackLeftQuarterTurn325DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23906), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24772), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23908), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24774), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23919), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24785), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23910), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24776), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23904), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24770), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23917), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24783), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height - 8, TUNNEL_SQUARE_7);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 1:
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
        case 2:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::leftCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::bottomLeftSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23905), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24771), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23907), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24773), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23918), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24784), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23909), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24775), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23920), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24786), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23903), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24769), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23916), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24782), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
            }
            switch (direction)
            {
                case 2:
                    PaintUtilPushTunnelRight(session, height + 8, TUNNEL_SQUARE_8);
                    break;
                case 3:
                    PaintUtilPushTunnelLeft(session, height + 8, TUNNEL_SQUARE_8);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
    }
}

/** rct2: 0x008AC838 */
template<bool isClassic>
static void WoodenRCTrackRightQuarterTurn325DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23895), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24761), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23911), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24777), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23897), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24763), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23899), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24765), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23914), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24780), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23901), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24767), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height - 8, TUNNEL_SQUARE_7);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 1:
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
        case 2:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::bottomLeftSide,
                        PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23896), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24762), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23912), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24778), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23898), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24764), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23913), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24779), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23900), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24766), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23915), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24781), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23902), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24768), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            switch (direction)
            {
                case 0:
                    PaintUtilPushTunnelRight(session, height + 8, TUNNEL_SQUARE_8);
                    break;
                case 1:
                    PaintUtilPushTunnelLeft(session, height + 8, TUNNEL_SQUARE_8);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
    }
}

/** rct2: 0x008AC848 */
template<bool isClassic>
static void WoodenRCTrackLeftQuarterTurn325DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    trackSequence = mapLeftQuarterTurn3TilesToRightQuarterTurn3Tiles[trackSequence];
    WoodenRCTrackRightQuarterTurn325DegUp<isClassic>(session, ride, trackSequence, (direction + 1) & 3, height, trackElement);
}

/** rct2: 0x008AC858 */
template<bool isClassic>
static void WoodenRCTrackRightQuarterTurn325DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    trackSequence = mapLeftQuarterTurn3TilesToRightQuarterTurn3Tiles[trackSequence];
    WoodenRCTrackLeftQuarterTurn325DegUp<isClassic>(session, ride, trackSequence, (direction - 1) & 3, height, trackElement);
}

/** rct2: 0x008ACAB8 */
template<bool isClassic>
static void WoodenRCTrackLeftHalfBankedHelixUpSmall(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_41),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24748), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_44),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24751), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_53),
                        { 0, 0, height }, { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24760), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_47),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24754), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_38),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24745), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_50),
                        { 0, 0, height }, { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24757), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_FLAT);
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::leftCorner, PaintSegment::rightCorner, PaintSegment::bottomCorner,
                        PaintSegment::bottomRightSide),
                    direction),
                48, 0x20);
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::centre, PaintSegment::topLeftSide, PaintSegment::topRightSide,
                        PaintSegment::bottomLeftSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 2:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
            }
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_40),
                        { 0, 0, height }, { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24747), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_43),
                        { 0, 0, height }, { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24750), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_52),
                        { 0, 0, height }, { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24759), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_46),
                        { 0, 0, height }, { { 0, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24753), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_37),
                        { 0, 0, height }, { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24744), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_49),
                        { 0, 0, height }, { { 16, 16, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24756), { 0, 0, height },
                        { { 16, 16, height + 27 }, { 16, 16, 0 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::leftCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::bottomLeftSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_39),
                        { 0, 0, height }, { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24746), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_42),
                        { 0, 0, height }, { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24749), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_51),
                        { 0, 0, height }, { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24758), { 0, 0, height },
                        { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_45),
                        { 0, 0, height }, { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24752), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_36),
                        { 0, 0, height }, { { 6, 0, height + 8 }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24743), { 0, 0, height },
                        { { 6, 0, height + 8 }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_48),
                        { 0, 0, height }, { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24755), { 0, 0, height },
                        { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
            }
            switch (direction)
            {
                case 2:
                    PaintUtilPushTunnelRight(session, height + 8, TUNNEL_SQUARE_FLAT);
                    break;
                case 3:
                    PaintUtilPushTunnelLeft(session, height + 8, TUNNEL_SQUARE_FLAT);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::leftCorner, PaintSegment::rightCorner,
                        PaintSegment::topRightSide),
                    direction),
                48, 0x20);
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::bottomLeftSide, PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 4:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_38),
                        { 0, 0, height }, { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24745), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_50),
                        { 0, 0, height }, { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24757), { 0, 0, height },
                        { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_41),
                        { 0, 0, height }, { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24748), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_44),
                        { 0, 0, height }, { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24751), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_53),
                        { 0, 0, height }, { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24760), { 0, 0, height },
                        { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_47),
                        { 0, 0, height }, { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24754), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            switch (direction)
            {
                case 0:
                    PaintUtilPushTunnelRight(session, height, TUNNEL_SQUARE_FLAT);
                    break;
                case 1:
                    PaintUtilPushTunnelLeft(session, height, TUNNEL_SQUARE_FLAT);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::rightCorner, PaintSegment::bottomCorner,
                        PaintSegment::topRightSide),
                    direction),
                48, 0x20);
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::leftCorner, PaintSegment::centre, PaintSegment::topLeftSide, PaintSegment::bottomLeftSide,
                        PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 5:
            switch (direction)
            {
                case 0:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 2:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
            }
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 6:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_37),
                        { 0, 0, height }, { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24744), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_49),
                        { 0, 0, height }, { { 16, 16, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24756), { 0, 0, height },
                        { { 16, 16, height + 27 }, { 16, 16, 0 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_40),
                        { 0, 0, height }, { { 0, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24747), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_43),
                        { 0, 0, height }, { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24750), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_52),
                        { 0, 0, height }, { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24759), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_46),
                        { 0, 0, height }, { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24753), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::bottomLeftSide,
                        PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 7:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_36),
                        { 0, 0, height }, { { 0, 6, height + 8 }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24743), { 0, 0, height },
                        { { 0, 6, height + 8 }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_48),
                        { 0, 0, height }, { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24755), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_39),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24746), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_42),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24749), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_51),
                        { 0, 0, height }, { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24758), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_45),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24752), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height + 8, TUNNEL_SQUARE_FLAT);
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::leftCorner, PaintSegment::bottomCorner,
                        PaintSegment::topLeftSide),
                    direction),
                48, 0x20);
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::rightCorner, PaintSegment::centre, PaintSegment::topRightSide,
                        PaintSegment::bottomLeftSide, PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
    }
}

/** rct2: 0x008ACAC8 */
template<bool isClassic>
static void WoodenRCTrackRightHalfBankedHelixUpSmall(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_18),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24725), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_30),
                        { 0, 0, height }, { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24737), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_21),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24728), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_24),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24731), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_33),
                        { 0, 0, height }, { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24740), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_27),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24734), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_FLAT);
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::leftCorner, PaintSegment::bottomCorner,
                        PaintSegment::topLeftSide),
                    direction),
                48, 0x20);
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::rightCorner, PaintSegment::centre, PaintSegment::topRightSide,
                        PaintSegment::bottomLeftSide, PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 2:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
            }
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_19),
                        { 0, 0, height }, { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24726), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_31),
                        { 0, 0, height }, { { 16, 16, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24738), { 0, 0, height },
                        { { 16, 16, height + 27 }, { 16, 16, 0 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_22),
                        { 0, 0, height }, { { 0, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24729), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_25),
                        { 0, 0, height }, { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24732), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_34),
                        { 0, 0, height }, { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24741), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_28),
                        { 0, 0, height }, { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24735), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::bottomLeftSide,
                        PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_20),
                        { 0, 0, height }, { { 6, 0, height + 8 }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24727), { 0, 0, height },
                        { { 6, 0, height + 8 }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_32),
                        { 0, 0, height }, { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24739), { 0, 0, height },
                        { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_23),
                        { 0, 0, height }, { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24730), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_26),
                        { 0, 0, height }, { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24733), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_35),
                        { 0, 0, height }, { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24742), { 0, 0, height },
                        { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_29),
                        { 0, 0, height }, { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24736), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            switch (direction)
            {
                case 0:
                    PaintUtilPushTunnelRight(session, height + 8, TUNNEL_SQUARE_FLAT);
                    break;
                case 1:
                    PaintUtilPushTunnelLeft(session, height + 8, TUNNEL_SQUARE_FLAT);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::rightCorner, PaintSegment::bottomCorner,
                        PaintSegment::topRightSide),
                    direction),
                48, 0x20);
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::leftCorner, PaintSegment::centre, PaintSegment::topLeftSide, PaintSegment::bottomLeftSide,
                        PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 4:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_21),
                        { 0, 0, height }, { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24728), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_24),
                        { 0, 0, height }, { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24731), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_33),
                        { 0, 0, height }, { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24740), { 0, 0, height },
                        { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_27),
                        { 0, 0, height }, { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24734), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_18),
                        { 0, 0, height }, { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24725), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_30),
                        { 0, 0, height }, { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24737), { 0, 0, height },
                        { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
            }
            switch (direction)
            {
                case 2:
                    PaintUtilPushTunnelRight(session, height, TUNNEL_SQUARE_FLAT);
                    break;
                case 3:
                    PaintUtilPushTunnelLeft(session, height, TUNNEL_SQUARE_FLAT);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::leftCorner, PaintSegment::rightCorner,
                        PaintSegment::topRightSide),
                    direction),
                48, 0x20);
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::bottomLeftSide, PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 5:
            switch (direction)
            {
                case 0:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 2:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
            }
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 6:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_22),
                        { 0, 0, height }, { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24729), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_25),
                        { 0, 0, height }, { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24732), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_34),
                        { 0, 0, height }, { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24741), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_28),
                        { 0, 0, height }, { { 0, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24735), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23860), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24726), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_31),
                        { 0, 0, height }, { { 16, 16, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24738), { 0, 0, height },
                        { { 16, 16, height + 27 }, { 16, 16, 0 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::leftCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::bottomLeftSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 7:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_23),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24730), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_26),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24733), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_35),
                        { 0, 0, height }, { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24742), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_29),
                        { 0, 0, height }, { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24736), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_20),
                        { 0, 0, height }, { { 0, 6, height + 8 }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24727), { 0, 0, height },
                        { { 0, 6, height + 8 }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction,
                        WoodenRCGetTrackColour<isClassic>(session).WithIndex(SPR_WOODEN_RC_SMALL_RIGHT_BANKED_TURN_32),
                        { 0, 0, height }, { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24739), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height + 8, TUNNEL_SQUARE_FLAT);
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::leftCorner, PaintSegment::rightCorner, PaintSegment::bottomCorner,
                        PaintSegment::bottomRightSide),
                    direction),
                48, 0x20);
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::centre, PaintSegment::topLeftSide, PaintSegment::topRightSide,
                        PaintSegment::bottomLeftSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
    }
}

/** rct2: 0x008ACAD8 */
template<bool isClassic>
static void WoodenRCTrackLeftHalfBankedHelixDownSmall(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    if (trackSequence >= 4)
    {
        trackSequence -= 4;
        direction = (direction - 1) & 3;
    }
    trackSequence = mapLeftQuarterTurn3TilesToRightQuarterTurn3Tiles[trackSequence];
    WoodenRCTrackRightHalfBankedHelixUpSmall<isClassic>(
        session, ride, trackSequence, (direction + 1) & 3, height, trackElement);
}

/** rct2: 0x008ACAE8 */
template<bool isClassic>
static void WoodenRCTrackRightHalfBankedHelixDownSmall(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    if (trackSequence >= 4)
    {
        trackSequence -= 4;
        direction = (direction + 1) & 3;
    }
    trackSequence = mapLeftQuarterTurn3TilesToRightQuarterTurn3Tiles[trackSequence];
    WoodenRCTrackLeftHalfBankedHelixUpSmall<isClassic>(session, ride, trackSequence, (direction - 1) & 3, height, trackElement);
}

/** rct2: 0x008ACAF8 */
template<bool isClassic>
static void WoodenRCTrackLeftHalfBankedHelixUpLarge(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23704), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24570), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23709), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24575), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23724), { 0, 0, height },
                        { { 0, 2, height + 27 }, { 32, 27, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24590), { 0, 0, height },
                        { { 0, 2, height + 27 }, { 32, 27, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23714), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24580), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23699), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24565), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23719), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24585), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_FLAT);
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::leftCorner, PaintSegment::rightCorner, PaintSegment::bottomCorner,
                        PaintSegment::bottomRightSide),
                    direction),
                48, 0x20);
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::centre, PaintSegment::topLeftSide, PaintSegment::topRightSide,
                        PaintSegment::bottomLeftSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 1:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::rightCorner, PaintSegment::topRightSide, PaintSegment::bottomRightSide),
                    direction),
                48, 0x20);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23703), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24569), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23708), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24574), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23723), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24589), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23713), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24579), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23698), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24564), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23718), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24584), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::leftCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::topRightSide, PaintSegment::bottomLeftSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23702), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24568), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23707), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24573), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23722), { 0, 0, height },
                        { { 16, 16, height + 29 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24588), { 0, 0, height },
                        { { 16, 16, height + 29 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23712), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24578), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23697), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24563), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23717), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24583), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::bottomCorner, PaintSegment::topLeftSide,
                        PaintSegment::bottomLeftSide),
                    direction),
                48, 0x20);
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::rightCorner, PaintSegment::centre, PaintSegment::topRightSide,
                        PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 4:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::rightCorner, PaintSegment::topRightSide, PaintSegment::bottomRightSide),
                    direction),
                48, 0x20);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 5:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23701), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24567), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23706), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24572), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23721), { 0, 0, height },
                        { { 0, 0, height + 33 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24587), { 0, 0, height },
                        { { 0, 0, height + 33 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23711), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24577), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23696), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24562), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23716), { 0, 0, height },
                        { { 16, 0, height + 27 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24582), { 0, 0, height },
                        { { 16, 0, height + 27 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::leftCorner, PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::bottomLeftSide, PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 6:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23700), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24566), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23705), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24571), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23720), { 0, 0, height },
                        { { 2, 0, height + 33 }, { 27, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24586), { 0, 0, height },
                        { { 2, 0, height + 33 }, { 27, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23710), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24576), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23695), { 0, 0, height },
                        { { 6, 0, height + 8 }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24561), { 0, 0, height },
                        { { 6, 0, height + 8 }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23715), { 0, 0, height },
                        { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24581), { 0, 0, height },
                        { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
            }
            switch (direction)
            {
                case 2:
                    PaintUtilPushTunnelRight(session, height + 8, TUNNEL_SQUARE_FLAT);
                    break;
                case 3:
                    PaintUtilPushTunnelLeft(session, height + 8, TUNNEL_SQUARE_FLAT);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::leftCorner, PaintSegment::rightCorner,
                        PaintSegment::topRightSide),
                    direction),
                48, 0x20);
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::bottomLeftSide, PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 7:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23699), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24565), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23719), { 0, 0, height },
                        { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24585), { 0, 0, height },
                        { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23704), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24570), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23709), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24575), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23724), { 0, 0, height },
                        { { 2, 0, height + 27 }, { 27, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24590), { 0, 0, height },
                        { { 2, 0, height + 27 }, { 27, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23714), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24580), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
            }
            switch (direction)
            {
                case 0:
                    PaintUtilPushTunnelRight(session, height, TUNNEL_SQUARE_FLAT);
                    break;
                case 1:
                    PaintUtilPushTunnelLeft(session, height, TUNNEL_SQUARE_FLAT);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::rightCorner, PaintSegment::bottomCorner,
                        PaintSegment::topRightSide),
                    direction),
                48, 0x20);
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::leftCorner, PaintSegment::centre, PaintSegment::topLeftSide, PaintSegment::bottomLeftSide,
                        PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 8:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::topCorner, PaintSegment::topLeftSide, PaintSegment::topRightSide), direction),
                48, 0x20);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 9:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23698), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24564), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23718), { 0, 0, height },
                        { { 16, 0, height + 27 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24584), { 0, 0, height },
                        { { 16, 0, height + 27 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23703), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24569), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23708), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24574), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23723), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24589), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23713), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24579), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::leftCorner, PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::bottomLeftSide, PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 10:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23697), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24563), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23717), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24583), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23702), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24568), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23707), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24573), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23722), { 0, 0, height },
                        { { 16, 16, height + 29 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24588), { 0, 0, height },
                        { { 16, 16, height + 29 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23712), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24578), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::leftCorner, PaintSegment::rightCorner, PaintSegment::bottomLeftSide,
                        PaintSegment::bottomRightSide),
                    direction),
                48, 0x20);
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::centre, PaintSegment::topLeftSide, PaintSegment::topRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 11:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::topCorner, PaintSegment::topLeftSide, PaintSegment::topRightSide), direction),
                48, 0x20);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 12:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23696), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24562), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23716), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24582), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23701), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24567), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23706), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24572), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23721), { 0, 0, height },
                        { { 0, 0, height + 33 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24587), { 0, 0, height },
                        { { 0, 0, height + 33 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23711), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24577), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::rightCorner, PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::topRightSide,
                        PaintSegment::bottomLeftSide, PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 13:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23695), { 0, 0, height },
                        { { 0, 6, height + 8 }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24561), { 0, 0, height },
                        { { 0, 6, height + 8 }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23715), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24581), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23700), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24566), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23705), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24571), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23720), { 0, 0, height },
                        { { 0, 2, height + 33 }, { 32, 27, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24586), { 0, 0, height },
                        { { 0, 2, height + 33 }, { 32, 27, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23710), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24576), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height + 8, TUNNEL_SQUARE_FLAT);
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::leftCorner, PaintSegment::bottomCorner,
                        PaintSegment::topLeftSide),
                    direction),
                48, 0x20);
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::rightCorner, PaintSegment::centre, PaintSegment::topRightSide,
                        PaintSegment::bottomLeftSide, PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
    }
}

/** rct2: 0x008ACB08 */
template<bool isClassic>
static void WoodenRCTrackRightHalfBankedHelixUpLarge(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23665), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24531), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23685), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24551), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23670), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24536), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23675), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24541), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23690), { 0, 0, height },
                        { { 0, 2, height + 27 }, { 32, 27, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24556), { 0, 0, height },
                        { { 0, 2, height + 27 }, { 32, 27, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23680), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24546), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_FLAT);
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::leftCorner, PaintSegment::bottomCorner,
                        PaintSegment::topLeftSide),
                    direction),
                48, 0x20);
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::rightCorner, PaintSegment::centre, PaintSegment::topRightSide,
                        PaintSegment::bottomLeftSide, PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 1:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::topCorner, PaintSegment::topLeftSide, PaintSegment::topRightSide), direction),
                48, 0x20);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23666), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24532), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23686), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24552), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23671), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24537), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23676), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24542), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23691), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24557), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23681), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24547), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::rightCorner, PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::topRightSide,
                        PaintSegment::bottomLeftSide, PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23667), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24533), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23687), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24553), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23672), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24538), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23677), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24543), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23692), { 0, 0, height },
                        { { 16, 16, height + 29 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24558), { 0, 0, height },
                        { { 16, 16, height + 29 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23682), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24548), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::leftCorner, PaintSegment::rightCorner, PaintSegment::bottomLeftSide,
                        PaintSegment::bottomRightSide),
                    direction),
                48, 0x20);
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::centre, PaintSegment::topLeftSide, PaintSegment::topRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 4:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::topCorner, PaintSegment::topLeftSide, PaintSegment::topRightSide), direction),
                48, 0x20);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 5:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23668), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24534), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23688), { 0, 0, height },
                        { { 16, 0, height + 27 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24554), { 0, 0, height },
                        { { 16, 0, height + 27 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23673), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24539), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23678), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24544), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23693), { 0, 0, height },
                        { { 0, 0, height + 33 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24559), { 0, 0, height },
                        { { 0, 0, height + 33 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23683), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24549), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::leftCorner, PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::bottomLeftSide, PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 6:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23669), { 0, 0, height },
                        { { 6, 0, height + 8 }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24535), { 0, 0, height },
                        { { 6, 0, height + 8 }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23689), { 0, 0, height },
                        { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24555), { 0, 0, height },
                        { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23674), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24540), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23679), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24545), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23694), { 0, 0, height },
                        { { 2, 0, height + 33 }, { 27, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24560), { 0, 0, height },
                        { { 2, 0, height + 33 }, { 27, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23684), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24550), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
            }
            switch (direction)
            {
                case 0:
                    PaintUtilPushTunnelRight(session, height + 8, TUNNEL_SQUARE_FLAT);
                    break;
                case 1:
                    PaintUtilPushTunnelLeft(session, height + 8, TUNNEL_SQUARE_FLAT);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::rightCorner, PaintSegment::bottomCorner,
                        PaintSegment::topRightSide),
                    direction),
                48, 0x20);
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::leftCorner, PaintSegment::centre, PaintSegment::topLeftSide, PaintSegment::bottomLeftSide,
                        PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 7:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23670), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24536), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23675), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24541), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23690), { 0, 0, height },
                        { { 2, 0, height + 27 }, { 27, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24556), { 0, 0, height },
                        { { 2, 0, height + 27 }, { 27, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23680), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24546), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23665), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24531), { 0, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23685), { 0, 0, height },
                        { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24551), { 0, 0, height },
                        { { 6, 0, height + 27 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
            }
            switch (direction)
            {
                case 2:
                    PaintUtilPushTunnelRight(session, height, TUNNEL_SQUARE_FLAT);
                    break;
                case 3:
                    PaintUtilPushTunnelLeft(session, height, TUNNEL_SQUARE_FLAT);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::leftCorner, PaintSegment::rightCorner,
                        PaintSegment::topRightSide),
                    direction),
                48, 0x20);
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::bottomLeftSide, PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 8:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::rightCorner, PaintSegment::topRightSide, PaintSegment::bottomRightSide),
                    direction),
                48, 0x20);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 9:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23671), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24537), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23676), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24542), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23691), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24557), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23681), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24547), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23666), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24532), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23686), { 0, 0, height },
                        { { 16, 0, height + 27 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24552), { 0, 0, height },
                        { { 16, 0, height + 27 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::leftCorner, PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::bottomLeftSide, PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 10:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23672), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24538), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23677), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24543), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23692), { 0, 0, height },
                        { { 16, 16, height + 29 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24558), { 0, 0, height },
                        { { 16, 16, height + 29 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23682), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24548), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23667), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24533), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23687), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24553), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::bottomCorner, PaintSegment::topLeftSide,
                        PaintSegment::bottomLeftSide),
                    direction),
                48, 0x20);
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::rightCorner, PaintSegment::centre, PaintSegment::topRightSide,
                        PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 11:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::rightCorner, PaintSegment::topRightSide, PaintSegment::bottomRightSide),
                    direction),
                48, 0x20);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 12:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23673), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24539), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23678), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24544), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23693), { 0, 0, height },
                        { { 0, 0, height + 33 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24559), { 0, 0, height },
                        { { 0, 0, height + 33 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23683), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24549), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23668), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24534), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23688), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24554), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::leftCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::topRightSide, PaintSegment::bottomLeftSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 13:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23674), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24540), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23679), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24545), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23694), { 0, 0, height },
                        { { 0, 2, height + 33 }, { 32, 27, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24560), { 0, 0, height },
                        { { 0, 2, height + 33 }, { 32, 27, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23684), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24550), { 0, 0, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23669), { 0, 0, height },
                        { { 0, 6, height + 8 }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24535), { 0, 0, height },
                        { { 0, 6, height + 8 }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23689), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24555), { 0, 0, height },
                        { { 0, 6, height + 27 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height + 8, TUNNEL_SQUARE_FLAT);
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::leftCorner, PaintSegment::rightCorner, PaintSegment::bottomCorner,
                        PaintSegment::bottomRightSide),
                    direction),
                48, 0x20);
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::centre, PaintSegment::topLeftSide, PaintSegment::topRightSide,
                        PaintSegment::bottomLeftSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
    }
}

/** rct2: 0x008ACB18 */
template<bool isClassic>
static void WoodenRCTrackLeftHalfBankedHelixDownLarge(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    if (trackSequence >= 7)
    {
        trackSequence -= 7;
        direction = (direction - 1) & 3;
    }
    trackSequence = mapLeftQuarterTurn5TilesToRightQuarterTurn5Tiles[trackSequence];
    WoodenRCTrackRightHalfBankedHelixUpLarge<isClassic>(
        session, ride, trackSequence, (direction + 1) & 3, height, trackElement);
}

/** rct2: 0x008ACB28 */
template<bool isClassic>
static void WoodenRCTrackRightHalfBankedHelixDownLarge(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    if (trackSequence >= 7)
    {
        trackSequence -= 7;
        direction = (direction + 1) & 3;
    }
    trackSequence = mapLeftQuarterTurn5TilesToRightQuarterTurn5Tiles[trackSequence];
    WoodenRCTrackLeftHalfBankedHelixUpLarge<isClassic>(session, ride, trackSequence, (direction - 1) & 3, height, trackElement);
}

/** rct2: 0x008ACB98 */
template<bool isClassic>
static void WoodenRCTrackLeftQuarterTurn160DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24209), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25075), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24217), { 0, 0, height },
                { { 2, 2, height + 99 }, { 28, 28, 1 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25083), { 0, 0, height },
                { { 2, 2, height + 99 }, { 28, 28, 1 } });
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24210), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25076), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24218), { 0, 0, height },
                { { 2, 2, height + 99 }, { 28, 28, 1 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25084), { 0, 0, height },
                { { 2, 2, height + 99 }, { 28, 28, 1 } });
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24211), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25077), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24219), { 0, 0, height },
                { { 2, 2, height + 99 }, { 28, 28, 1 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25085), { 0, 0, height },
                { { 2, 2, height + 99 }, { 28, 28, 1 } });
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24212), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25078), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24220), { 0, 0, height },
                { { 2, 2, height + 99 }, { 28, 28, 1 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25086), { 0, 0, height },
                { { 2, 2, height + 99 }, { 28, 28, 1 } });
            break;
    }
    TrackPaintUtilLeftQuarterTurn1TileTunnel(session, direction, height, -8, TUNNEL_SQUARE_7, +56, TUNNEL_SQUARE_8);
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 104, 0x20);
}

/** rct2: 0x008ACB78 */
template<bool isClassic>
static void WoodenRCTrackRightQuarterTurn160DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24213), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25079), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24221), { 0, 0, height },
                { { 2, 2, height + 99 }, { 28, 28, 1 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25087), { 0, 0, height },
                { { 2, 2, height + 99 }, { 28, 28, 1 } });
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24214), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25080), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24222), { 0, 0, height },
                { { 2, 2, height + 99 }, { 28, 28, 1 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25088), { 0, 0, height },
                { { 2, 2, height + 99 }, { 28, 28, 1 } });
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24215), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25081), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24223), { 0, 0, height },
                { { 2, 2, height + 99 }, { 28, 28, 1 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25089), { 0, 0, height },
                { { 2, 2, height + 99 }, { 28, 28, 1 } });
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24216), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25082), { 0, 0, height },
                { { 2, 2, height }, { 28, 28, 3 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24224), { 0, 0, height },
                { { 2, 2, height + 99 }, { 28, 28, 1 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25090), { 0, 0, height },
                { { 2, 2, height + 99 }, { 28, 28, 1 } });
            break;
    }
    TrackPaintUtilRightQuarterTurn1TileTunnel(session, direction, height, -8, TUNNEL_SQUARE_7, +56, TUNNEL_SQUARE_8);
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 104, 0x20);
}

/** rct2: 0x008ACB88 */
template<bool isClassic>
static void WoodenRCTrackLeftQuarterTurn160DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    WoodenRCTrackRightQuarterTurn160DegUp<isClassic>(session, ride, trackSequence, (direction + 1) & 3, height, trackElement);
}

/** rct2: 0x008ACBA8 */
template<bool isClassic>
static void WoodenRCTrackRightQuarterTurn160DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    WoodenRCTrackLeftQuarterTurn160DegUp<isClassic>(session, ride, trackSequence, (direction - 1) & 3, height, trackElement);
}

/** rct2: 0x008AC868 */
template<bool isClassic>
static void WoodenRCTrackBrakes(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    static constexpr uint32_t imageIds[4][2] = {
        { SPR_WOODEN_RC_BRAKES_SW_NE, SPR_WOODEN_RC_BRAKES_RAILS_SW_NE },
        { SPR_WOODEN_RC_BRAKES_NW_SE, SPR_WOODEN_RC_BRAKES_RAILS_NW_SE },
        { SPR_WOODEN_RC_BRAKES_SW_NE, SPR_WOODEN_RC_BRAKES_RAILS_SW_NE },
        { SPR_WOODEN_RC_BRAKES_NW_SE, SPR_WOODEN_RC_BRAKES_RAILS_NW_SE },
    };

    WoodenRCTrackPaint<isClassic>(
        session, direction, imageIds[direction][0], imageIds[direction][1], { 0, 2, height },
        { { 0, 3, height }, { 32, 25, 2 } });
    WoodenASupportsPaintSetupRotated(
        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours);
    PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_FLAT);
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
}

/** rct2: 0x008ACC78 */
template<bool isClassic>
static void WoodenRCTrack25DegUpLeftBanked(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24249), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25115), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25Deg);
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24250), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25116), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24257), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25123), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25Deg);
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24251), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25117), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24258), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25124), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25Deg);
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24252), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25118), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25Deg);
            break;
    }
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, TUNNEL_SQUARE_7);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 8, TUNNEL_SQUARE_8);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
}

/** rct2: 0x008ACC88 */
template<bool isClassic>
static void WoodenRCTrack25DegUpRightBanked(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24253), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25119), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25Deg);
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24254), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25120), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24259), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25125), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25Deg);
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24255), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25121), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24260), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25126), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25Deg);
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24256), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25122), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25Deg);
            break;
    }
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, TUNNEL_SQUARE_7);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 8, TUNNEL_SQUARE_8);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
}

/** rct2: 0x008AC878 */
template<bool isClassic>
static void WoodenRCTrackOnRidePhoto(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23753), { 0, 2, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(24619), { 0, 2, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23754), { 0, 2, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(24620), { 0, 2, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23753), { 0, 2, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(24619), { 0, 2, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23754), { 0, 2, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(24620), { 0, 2, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            break;
    }
    WoodenASupportsPaintSetupRotated(
        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours);
    TrackPaintUtilOnridePhotoSmallPaint(session, direction, height + 16, trackElement);
    PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_INVERTED_9);
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
}

/** rct2: 0x008ACC98 */
template<bool isClassic>
static void WoodenRCTrack25DegDownLeftBanked(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    WoodenRCTrack25DegUpRightBanked<isClassic>(session, ride, trackSequence, (direction + 2) & 3, height, trackElement);
}

/** rct2: 0x008ACCA8 */
template<bool isClassic>
static void WoodenRCTrack25DegDownRightBanked(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    WoodenRCTrack25DegUpLeftBanked<isClassic>(session, ride, trackSequence, (direction + 2) & 3, height, trackElement);
}

/** rct2: 0x008ACE08 */
template<bool isClassic>
static void WoodenRCTrackWaterSplash(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    const bool transparent = gConfigGeneral.TransparentWater || (session.ViewFlags & VIEWPORT_FLAG_UNDERGROUND_INSIDE);
    const auto waterMask = ImageId(SPR_WATER_MASK).WithRemap(FilterPaletteID::PaletteWater).WithBlended(true);
    const auto waterOverlay = ImageId(transparent ? SPR_WATER_OVERLAY : SPR_RCT1_WATER_OVERLAY);

    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23989), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24855), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23997), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24863), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23993), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24859), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23990), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24856), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23998), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24864), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23994), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24860), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23987), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24853), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23995), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24861), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23991), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24857), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23988), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24854), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23996), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24862), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23992), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24858), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
            }
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours);
            PaintUtilPushTunnelRotated(session, direction, height + 16, TUNNEL_SQUARE_FLAT);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23977), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24843), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23985), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24851), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23981), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24847), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23978), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24844), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23986), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24852), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23982), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24848), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23975), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24841), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23983), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24849), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23979), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24845), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23976), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24842), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23984), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24850), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23980), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24846), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
            }
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23999), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24865), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24003), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24869), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24001), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24867), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
                case 1:
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24000), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24866), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24004), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24870), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24002), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24868), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
            }
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23975), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24841), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23983), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24849), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23979), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24845), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23976), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24842), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23984), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24850), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23980), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24846), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23977), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24843), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23985), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24851), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23981), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24847), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23978), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24844), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23986), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24852), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23982), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24848), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
            }
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 4:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23987), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24853), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23995), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24861), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23991), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24857), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23988), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24854), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23996), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24862), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23992), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24858), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23989), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24855), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23997), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24863), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23993), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24859), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23990), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24856), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterMask, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, waterOverlay, { 0, 0, height + 16 }, { { 0, 3, height + 16 }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(23998), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, session.SupportColours.WithIndex(24864), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23994), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24860), { 0, 0, height },
                        { { 0, 3, height }, { 32, 25, 2 } });
                    break;
            }
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours);
            PaintUtilPushTunnelRotated(session, direction, height + 16, TUNNEL_SQUARE_FLAT);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
    }
}

/** rct2: 0x008AC958 */
template<bool isClassic>
static void WoodenRCTrackLeftEighthToDiag(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24137), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25003), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24141), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25007), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24153), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25019), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24145), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25011), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24149), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25015), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24157), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25023), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_FLAT);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24138), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25004), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24142), { 0, 0, height },
                        { { 0, 0, height }, { 34, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25008), { 0, 0, height },
                        { { 0, 0, height }, { 34, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24154), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25020), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24146), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25012), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24150), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25016), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24158), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25024), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24139), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25005), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24143), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25009), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24155), { 0, 0, height },
                        { { 16, 16, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25021), { 0, 0, height },
                        { { 16, 16, height + 27 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24147), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25013), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24151), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25017), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24159), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25025), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 2:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 4:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24140), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25006), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24144), { 0, 0, height },
                        { { 0, 16, height }, { 16, 18, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25010), { 0, 0, height },
                        { { 0, 16, height }, { 16, 18, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24156), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25022), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 16, 16, 0 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24148), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25014), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24152), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25018), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24160), { 0, 0, height },
                        { { 16, 0, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25026), { 0, 0, height },
                        { { 16, 0, height + 27 }, { 16, 16, 0 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
    }
}

/** rct2: 0x008AC968 */
template<bool isClassic>
static void WoodenRCTrackRightEighthToDiag(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24113), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24979), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24129), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24995), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24117), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24983), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24121), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24987), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24133), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24999), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24125), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24991), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_FLAT);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24114), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24980), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24130), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24996), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24118), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24984), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24122), { 0, 0, height },
                        { { 0, 0, height }, { 34, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24988), { 0, 0, height },
                        { { 0, 0, height }, { 34, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24134), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25000), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24126), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24992), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24115), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24981), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24131), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24997), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24119), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24985), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24123), { 0, 0, height },
                        { { 4, 4, height }, { 28, 28, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24989), { 0, 0, height },
                        { { 4, 4, height }, { 28, 28, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24135), { 0, 0, height },
                        { { 4, 4, height + 27 }, { 28, 28, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25001), { 0, 0, height },
                        { { 4, 4, height + 27 }, { 28, 28, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24127), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24993), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 4:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24116), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24982), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24132), { 0, 0, height },
                        { { 16, 0, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24998), { 0, 0, height },
                        { { 16, 0, height + 27 }, { 16, 16, 0 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24120), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24986), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24124), { 0, 0, height },
                        { { 0, 16, height }, { 16, 18, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24990), { 0, 0, height },
                        { { 0, 16, height }, { 16, 18, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24136), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25002), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 16, 16, 0 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24128), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24994), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
    }
}

/** rct2: 0x008AC978 */
template<bool isClassic>
static void WoodenRCTrackLeftEighthToOrthogonal(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    trackSequence = mapLeftEighthTurnToOrthogonal[trackSequence];
    WoodenRCTrackRightEighthToDiag<isClassic>(session, ride, trackSequence, (direction + 2) & 3, height, trackElement);
}

/** rct2: 0x008AC988 */
template<bool isClassic>
static void WoodenRCTrackRightEighthToOrthogonal(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    trackSequence = mapLeftEighthTurnToOrthogonal[trackSequence];
    WoodenRCTrackLeftEighthToDiag<isClassic>(session, ride, trackSequence, (direction + 3) & 3, height, trackElement);
}

/** rct2: 0x008AC998 */
template<bool isClassic>
static void WoodenRCTrackLeftEighthBankToDiag(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24185), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25051), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24189), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25055), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24201), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25067), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24193), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25059), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24197), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25063), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24205), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25071), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_FLAT);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24186), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25052), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24190), { 0, 0, height },
                        { { 0, 0, height }, { 34, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25056), { 0, 0, height },
                        { { 0, 0, height }, { 34, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24202), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25068), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24194), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25060), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24198), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25064), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24206), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25072), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24187), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25053), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24191), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25057), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24203), { 0, 0, height },
                        { { 16, 16, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25069), { 0, 0, height },
                        { { 16, 16, height + 27 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24195), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25061), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24199), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25065), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24207), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25073), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 2:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 4:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24188), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25054), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24192), { 0, 0, height },
                        { { 0, 16, height }, { 16, 18, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25058), { 0, 0, height },
                        { { 0, 16, height }, { 16, 18, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24204), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25070), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 16, 16, 0 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24196), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25062), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24200), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25066), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24208), { 0, 0, height },
                        { { 16, 0, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25074), { 0, 0, height },
                        { { 16, 0, height + 27 }, { 16, 16, 0 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
    }
}

/** rct2: 0x008AC9A8 */
template<bool isClassic>
static void WoodenRCTrackRightEighthBankToDiag(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24161), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25027), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24177), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25043), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24165), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25031), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24169), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25035), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24181), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25047), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24173), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25039), { 0, 0, height },
                        { { 0, 0, height }, { 32, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_FLAT);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24162), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25028), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24178), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25044), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24166), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25032), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24170), { 0, 0, height },
                        { { 0, 0, height }, { 34, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25036), { 0, 0, height },
                        { { 0, 0, height }, { 34, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24182), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25048), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24174), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25040), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NwSe, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24163), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25029), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24179), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25045), { 0, 0, height },
                        { { 0, 0, height + 27 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24167), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25033), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24171), { 0, 0, height },
                        { { 4, 4, height }, { 28, 28, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25037), { 0, 0, height },
                        { { 4, 4, height }, { 28, 28, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24183), { 0, 0, height },
                        { { 4, 4, height + 27 }, { 28, 28, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25049), { 0, 0, height },
                        { { 4, 4, height + 27 }, { 28, 28, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24175), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25041), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 4:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24164), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25030), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24180), { 0, 0, height },
                        { { 16, 0, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25046), { 0, 0, height },
                        { { 16, 0, height + 27 }, { 16, 16, 0 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24168), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25034), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24172), { 0, 0, height },
                        { { 0, 16, height }, { 16, 18, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25038), { 0, 0, height },
                        { { 0, 16, height }, { 16, 18, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24184), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25050), { 0, 0, height },
                        { { 0, 16, height + 27 }, { 16, 16, 0 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24176), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25042), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
    }
}

/** rct2: 0x008AC9B8 */
template<bool isClassic>
static void WoodenRCTrackLeftEighthBankToOrthogonal(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    trackSequence = mapLeftEighthTurnToOrthogonal[trackSequence];
    WoodenRCTrackRightEighthBankToDiag<isClassic>(session, ride, trackSequence, (direction + 2) & 3, height, trackElement);
}

/** rct2: 0x008AC9C8 */
template<bool isClassic>
static void WoodenRCTrackRightEighthBankToOrthogonal(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    trackSequence = mapLeftEighthTurnToOrthogonal[trackSequence];
    WoodenRCTrackLeftEighthBankToDiag<isClassic>(session, ride, trackSequence, (direction + 3) & 3, height, trackElement);
}

template<bool isClassic>
static void WoodenRCTrackDiagBrakes(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    static constexpr SpriteBoundBox2 imageIds[4][NumOrthogonalDirections][2] = {
        {
            // sequence 0
            {
                // direction 0
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
            },
            {
                // direction 1
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
            },
            {
                // direction 2
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
            },
            {
                // direction 3
                {
                    WoodenRCDiagBrakeImages[3],
                    24916, // diagonal vertical trim image
                    { -16, -16, 0 },
                    { { -16, -16, 0 }, { 32, 32, 2 } },
                },
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
            },
        },
        {
            // sequence 1
            {
                // direction 0
                {
                    WoodenRCDiagBrakeImages[0],
                    24913, // diagonal horizontal trim image
                    { -16, -16, 0 },
                    { { -16, -16, 0 }, { 32, 32, 2 } },
                },
                {
                    24051, // diagonal horizontal railing image
                    24917, // diagonal horizontal foreground trim image
                    { -16, -16, 0 },
                    { { -16, -16, 27 }, { 32, 32, 0 } },
                },
            },
            {
                // direction 1
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
            },
            {
                // direction 2
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
            },
            {
                // direction 3
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
            },
        },
        {
            // sequence 2
            {
                // direction 0
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
            },
            {
                // direction 1
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
            },
            {
                // direction 2
                {
                    WoodenRCDiagBrakeImages[2],
                    24913, // diagonal vertical trim image
                    { -16, -16, 0 },
                    { { -16, -16, 0 }, { 32, 32, 2 } },
                },
                {
                    24051, // diagonal vertical railing image
                    24917, // diagonal vertical foreground trim image
                    { -16, -16, 0 },
                    { { -16, -16, 27 }, { 32, 32, 0 } },
                },
            },
            {
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
            }, // direction 3
        },
        {
            // sequence 3
            {
                // direction 0
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
            },
            {
                // direction 1
                {
                    WoodenRCDiagBrakeImages[1],
                    24916, // diagonal vertical trim image
                    { -16, -16, 0 },
                    { { -16, -16, 0 }, { 32, 32, 2 } },
                },
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
            },
            {
                // direction 2
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
            },
            {
                // direction 3
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
                { 0, 0, {}, BoundBoxXYZ({}, {}) },
            },
        },
    };

    WoodenRCTrackPaintBb<isClassic>(session, &imageIds[trackSequence][direction][0], height);
    WoodenRCTrackPaintBb<isClassic>(session, &imageIds[trackSequence][direction][0], height);

    if (WoodenRCDiagonalSupports[trackSequence][direction] != WoodenSupportSubType::Null)
    {
        WoodenASupportsPaintSetup(
            session, WoodenSupportType::Truss, WoodenRCDiagonalSupports[trackSequence][direction], height,
            session.SupportColours);
    }

    int32_t blockedSegments = DiagBlockedSegments[trackSequence];
    PaintUtilSetSegmentSupportHeight(session, PaintUtilRotateSegments(blockedSegments, direction), 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
}

template<bool isClassic>
static void WoodenRCTrackDiagBlockBrakes(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    static constexpr SpriteBoundBox2 imageIds[2][4][NumOrthogonalDirections][2] = {
        {
            {
                // sequence 0
                {
                    // direction 0
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 1
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 2
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 3
                    {
                        WoodenRCDiagBlockBrakeImages[0][3],
                        24916,           // diagonal vertical trim image
                        { -16, -16, 0 }, // todo: rotate these bboxes
                        BoundBoxXYZ({ -16, -16, 0 }, { 32, 32, 2 }),
                    },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
            },
            {
                // sequence 1
                {
                    // direction 0
                    {
                        WoodenRCDiagBlockBrakeImages[0][0],
                        24913, // diagonal horizontal trim image
                        { -16, -16, 0 },
                        BoundBoxXYZ({ -16, -16, 0 }, { 32, 32, 2 }),
                    },
                    {
                        24051, // diagonal horizontal railing image
                        24917, // diagonal horizontal foreground trim image
                        { -16, -16, 0 },
                        BoundBoxXYZ({ -16, -16, 27 }, { 32, 32, 0 }),
                    },
                },
                {
                    // direction 1
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 2
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 3
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
            },
            {
                // sequence 2
                {
                    // direction 0
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 1
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 2
                    {
                        WoodenRCDiagBlockBrakeImages[0][2],
                        24913, // diagonal vertical trim image
                        { -16, -16, 0 },
                        BoundBoxXYZ({ -16, -16, 0 }, { 32, 32, 2 }),
                    },
                    {
                        24051, // diagonal vertical railing image
                        24917, // diagonal vertical foreground trim image
                        { -16, -16, 0 },
                        BoundBoxXYZ({ -16, -16, 27 }, { 32, 32, 0 }),
                    },
                },
                {
                    // direction 3
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
            },
            {
                // sequence 3
                {
                    // direction 0
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 1
                    {
                        WoodenRCDiagBlockBrakeImages[0][1],
                        24916, // diagonal vertical trim image
                        { -16, -16, 0 },
                        BoundBoxXYZ({ -16, -16, 0 }, { 32, 32, 2 }),
                    },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 2
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 3
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
            },
        },
        {
            {
                // sequence 0
                {
                    // direction 0
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 1
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 2
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 3
                    {
                        WoodenRCDiagBlockBrakeImages[1][3],
                        24916, // diagonal vertical trim image
                        { -16, -16, 0 },
                        BoundBoxXYZ({ -16, -16, 0 }, { 32, 32, 2 }),
                    },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
            },
            {
                // sequence 1
                {
                    // direction 0
                    {
                        WoodenRCDiagBlockBrakeImages[1][0],
                        24913, // diagonal horizontal trim image
                        { -16, -16, 0 },
                        BoundBoxXYZ({ -16, -16, 0 }, { 32, 32, 2 }),
                    },
                    {
                        24051, // diagonal horizontal railing image
                        24917, // diagonal horizontal foreground trim image
                        { -16, -16, 0 },
                        BoundBoxXYZ({ -16, -16, 27 }, { 32, 32, 0 }),
                    },
                },
                {
                    // direction 1
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 2
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 3
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
            },
            {
                // sequence 2
                {
                    // direction 0
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 1
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 2
                    {
                        WoodenRCDiagBlockBrakeImages[1][2],
                        24913, // diagonal vertical trim image
                        { -16, -16, 0 },
                        BoundBoxXYZ({ -16, -16, 0 }, { 32, 32, 2 }),
                    },
                    {
                        24051, // diagonal vertical railing image
                        24917, // diagonal vertical foreground trim image
                        { -16, -16, 0 },
                        BoundBoxXYZ({ -16, -16, 27 }, { 32, 32, 0 }),
                    },
                },
                {
                    // direction 3
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
            },
            {
                // sequence 3
                {
                    // direction 0
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 1
                    {
                        WoodenRCDiagBlockBrakeImages[1][1],
                        24916, // diagonal vertical trim image
                        { -16, -16, 0 },
                        BoundBoxXYZ({ -16, -16, 0 }, { 32, 32, 2 }),
                    },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 2
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
                {
                    // direction 3
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                    { 0, 0, {}, BoundBoxXYZ({}, {}) },
                },
            },
        },
    };

    WoodenRCTrackPaintBb<isClassic>(session, &imageIds[trackElement.IsBrakeClosed()][trackSequence][direction][0], height);
    WoodenRCTrackPaintBb<isClassic>(session, &imageIds[trackElement.IsBrakeClosed()][trackSequence][direction][0], height);

    if (WoodenRCDiagonalSupports[trackSequence][direction] != WoodenSupportSubType::Null)
    {
        WoodenASupportsPaintSetup(
            session, WoodenSupportType::Truss, WoodenRCDiagonalSupports[trackSequence][direction], height,
            session.SupportColours);
    }

    int32_t blockedSegments = DiagBlockedSegments[trackSequence];
    PaintUtilSetSegmentSupportHeight(session, PaintUtilRotateSegments(blockedSegments, direction), 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
}

/** rct2: 0x008AC888 */
template<bool isClassic>
static void WoodenRCTrackDiagFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 3:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24050),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24916), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 3:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24008),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24874), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 1:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 0:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24047),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24913), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24051),
                            { -16, -16, height }, { { -16, -16, height + 27 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24917), { -16, -16, height },
                            { { -16, -16, height + 27 }, { 32, 32, 0 } });
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                        break;
                    case 1:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                        break;
                    case 2:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                        break;
                    case 3:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 0:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24005),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24871), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24009),
                            { -16, -16, height }, { { -16, -16, height + 27 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24875), { -16, -16, height },
                            { { -16, -16, height + 27 }, { 32, 32, 0 } });
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                        break;
                    case 1:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                        break;
                    case 2:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                        break;
                    case 3:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 2:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 0:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                        break;
                    case 1:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                        break;
                    case 2:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24049),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24915), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24052),
                            { -16, -16, height }, { { -16, -16, height + 27 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24918), { -16, -16, height },
                            { { -16, -16, height + 27 }, { 32, 32, 0 } });
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                        break;
                    case 3:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 0:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                        break;
                    case 1:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                        break;
                    case 2:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24007),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24873), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24010),
                            { -16, -16, height }, { { -16, -16, height + 27 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24876), { -16, -16, height },
                            { { -16, -16, height + 27 }, { 32, 32, 0 } });
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                        break;
                    case 3:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 3:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 1:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24048),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24914), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 1:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24006),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24872), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
    }
}

/** rct2: 0x008AC8B8 */
template<bool isClassic>
static void WoodenRCTrackDiag25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 3:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24068),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24934), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 3:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24026),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24892), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
        case 1:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 0:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24065),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24931), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24069),
                            { -16, -16, height }, { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24935), { -16, -16, height },
                            { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        break;
                }
                WoodenBSupportsPaintSetupRotated(
                    session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, direction, height + 16,
                    session.SupportColours);
            }
            else
            {
                switch (direction)
                {
                    case 0:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24023),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24889), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24027),
                            { -16, -16, height }, { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24893), { -16, -16, height },
                            { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        break;
                }
                WoodenBSupportsPaintSetupRotated(
                    session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, direction, height + 16,
                    session.SupportColours);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
        case 2:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 2:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24067),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24933), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24070),
                            { -16, -16, height }, { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24936), { -16, -16, height },
                            { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 2:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24025),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24891), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24028),
                            { -16, -16, height }, { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24894), { -16, -16, height },
                            { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        break;
                }
            }

            WoodenBSupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, direction, height + 16,
                session.SupportColours);

            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
        case 3:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 1:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24066),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24932), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 1:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24024),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24890), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
    }
}

/** rct2: 0x008AC8E8 */
template<bool isClassic>
static void WoodenRCTrackDiag60DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24044), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24910), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 104, 0x20);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24041), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24907), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24045), { -16, -16, height },
                        { { -16, -16, height + 91 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24911), { -16, -16, height },
                        { { -16, -16, height + 91 }, { 32, 32, 0 } });
                    break;
            }
            WoodenBSupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, direction, height + 16,
                session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 104, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24043), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24909), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24046), { -16, -16, height },
                        { { -16, -16, height + 91 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24912), { -16, -16, height },
                        { { -16, -16, height + 91 }, { 32, 32, 0 } });
                    break;
            }

            WoodenBSupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, direction, height + 16,
                session.SupportColours);

            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 104, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24042), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24908), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 104, 0x20);
            break;
    }
}

/** rct2: 0x008AC898 */
template<bool isClassic>
static void WoodenRCTrackDiagFlatTo25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 3:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24056),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24922), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 3:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24014),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24880), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 1:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 0:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24053),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24919), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24057),
                            { -16, -16, height }, { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24923), { -16, -16, height },
                            { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                        break;
                    case 1:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                        break;
                    case 2:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                        break;
                    case 3:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 0:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24011),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24877), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24015),
                            { -16, -16, height }, { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24881), { -16, -16, height },
                            { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                        break;
                    case 1:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                        break;
                    case 2:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                        break;
                    case 3:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 2:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 0:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                        break;
                    case 1:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                        break;
                    case 2:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24055),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24921), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24058),
                            { -16, -16, height }, { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24924), { -16, -16, height },
                            { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                        break;
                    case 3:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 0:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                        break;
                    case 1:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                        break;
                    case 2:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24013),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24879), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24016),
                            { -16, -16, height }, { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24882), { -16, -16, height },
                            { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                        break;
                    case 3:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 3:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 1:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24054),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24920), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 1:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24012),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24878), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
    }
}

/** rct2: 0x008AC8C8 */
template<bool isClassic>
static void WoodenRCTrackDiag25DegUpTo60DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24032), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24898), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24029), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24895), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24033), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24899), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    break;
            }
            WoodenBSupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, direction, height + 16,
                session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24031), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24897), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24034), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24900), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    break;
            }

            WoodenBSupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, direction, height + 16,
                session.SupportColours);

            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24030), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24896), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
    }
}

/** rct2: 0x008AC8D8 */
template<bool isClassic>
static void WoodenRCTrackDiag60DegUpTo25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24038), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24904), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24035), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24901), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24039), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24905), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    break;
            }
            WoodenBSupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, direction, height + 16,
                session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24037), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24903), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24040), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24906), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    break;
            }
            WoodenBSupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, direction, height + 16,
                session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24036), { -16, -16, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24902), { -16, -16, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
    }
}

/** rct2: 0x008AC8A8 */
template<bool isClassic>
static void WoodenRCTrackDiag25DegUpToFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 3:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24062),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24928), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 3:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24020),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24886), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
        case 1:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 0:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24059),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24925), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24063),
                            { -16, -16, height }, { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24929), { -16, -16, height },
                            { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        break;
                }
                WoodenBSupportsPaintSetupRotated(
                    session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, direction, height + 16,
                    session.SupportColours);
            }
            else
            {
                switch (direction)
                {
                    case 0:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24017),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24883), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24021),
                            { -16, -16, height }, { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24887), { -16, -16, height },
                            { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        break;
                }
                WoodenBSupportsPaintSetupRotated(
                    session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, direction, height + 16,
                    session.SupportColours);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
        case 2:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 2:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24061),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24927), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24064),
                            { -16, -16, height }, { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24930), { -16, -16, height },
                            { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 2:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24019),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24885), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24022),
                            { -16, -16, height }, { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24888), { -16, -16, height },
                            { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        break;
                }
            }

            WoodenBSupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, direction, height + 16,
                session.SupportColours);

            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
        case 3:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 1:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24060),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24926), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 1:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24018),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24884), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
    }
}

/** rct2: 0x008AC918 */
template<bool isClassic>
static void WoodenRCTrackDiag25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 3:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24066),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24932), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 3:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24024),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24890), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
        case 1:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 0:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24067),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24933), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24070),
                            { -16, -16, height }, { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24936), { -16, -16, height },
                            { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        break;
                }
                WoodenBSupportsPaintSetupRotated(
                    session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, direction, height + 16,
                    session.SupportColours);
            }
            else
            {
                switch (direction)
                {
                    case 0:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24025),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24891), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24028),
                            { -16, -16, height }, { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24894), { -16, -16, height },
                            { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        break;
                }
                WoodenBSupportsPaintSetupRotated(
                    session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, direction, height + 16,
                    session.SupportColours);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
        case 2:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 2:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24065),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24931), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24069),
                            { -16, -16, height }, { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24935), { -16, -16, height },
                            { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 2:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24023),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24889), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24027),
                            { -16, -16, height }, { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24893), { -16, -16, height },
                            { { -16, -16, height + 43 }, { 32, 32, 0 } });
                        break;
                }
            }

            WoodenBSupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, direction, height + 16,
                session.SupportColours);

            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
        case 3:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 1:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24068),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24934), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 1:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24026),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24892), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
    }
}

/** rct2: 0x008AC948 */
template<bool isClassic>
static void WoodenRCTrackDiag60DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24042), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24908), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 104, 0x20);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24043), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24909), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24046), { -16, -16, height },
                        { { -16, -16, height + 91 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24912), { -16, -16, height },
                        { { -16, -16, height + 91 }, { 32, 32, 0 } });
                    break;
            }
            WoodenBSupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, direction, height + 16,
                session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 104, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24041), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24907), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24045), { -16, -16, height },
                        { { -16, -16, height + 91 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24911), { -16, -16, height },
                        { { -16, -16, height + 91 }, { 32, 32, 0 } });
                    break;
            }
            WoodenBSupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, direction, height + 16,
                session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 104, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24044), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24910), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 104, 0x20);
            break;
    }
}

/** rct2: 0x008AC8F8 */
template<bool isClassic>
static void WoodenRCTrackDiagFlatTo25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 3:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24060),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24926), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 3:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24018),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24884), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            break;
        case 1:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 0:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24061),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24927), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24064),
                            { -16, -16, height }, { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24930), { -16, -16, height },
                            { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        break;
                }
                WoodenBSupportsPaintSetupRotated(
                    session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, direction, height + 16,
                    session.SupportColours);
            }
            else
            {
                switch (direction)
                {
                    case 0:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24019),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24885), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24022),
                            { -16, -16, height }, { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24888), { -16, -16, height },
                            { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        break;
                }
                WoodenBSupportsPaintSetupRotated(
                    session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, direction, height + 16,
                    session.SupportColours);
            }
            break;
        case 2:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 2:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24059),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24925), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24063),
                            { -16, -16, height }, { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24929), { -16, -16, height },
                            { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 2:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24017),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24883), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24021),
                            { -16, -16, height }, { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24887), { -16, -16, height },
                            { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        break;
                }
            }

            WoodenBSupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, direction, height + 16,
                session.SupportColours);

            break;
        case 3:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 1:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24062),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24928), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 1:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24020),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24886), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            break;
    }

    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
}

/** rct2: 0x008AC928 */
template<bool isClassic>
static void WoodenRCTrackDiag25DegDownTo60DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24036), { -16, -16, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24902), { -16, -16, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24037), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24903), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24040), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24906), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    break;
            }
            WoodenBSupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, direction, height + 16,
                session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24035), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24901), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24039), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24905), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    break;
            }
            WoodenBSupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, direction, height + 16,
                session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24038), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24904), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
    }
}

/** rct2: 0x008AC938 */
template<bool isClassic>
static void WoodenRCTrackDiag60DegDownTo25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24030), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24896), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24031), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24897), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24034), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24900), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    break;
            }
            WoodenBSupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, direction, height + 16,
                session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24029), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24895), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24033), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24899), { -16, -16, height },
                        { { -16, -16, height + 59 }, { 32, 32, 0 } });
                    break;
            }
            WoodenBSupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, direction, height + 16,
                session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24032), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24898), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
    }
}

/** rct2: 0x008AC908 */
template<bool isClassic>
static void WoodenRCTrackDiag25DegDownToFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 3:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24054),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24920), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 3:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24012),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24878), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 1:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 0:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24055),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24921), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24058),
                            { -16, -16, height }, { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24924), { -16, -16, height },
                            { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                        break;
                    case 1:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                        break;
                    case 2:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                        break;
                    case 3:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 0:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24013),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24879), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24016),
                            { -16, -16, height }, { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24882), { -16, -16, height },
                            { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                        break;
                    case 1:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                        break;
                    case 2:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                        break;
                    case 3:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 2:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 0:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                        break;
                    case 1:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                        break;
                    case 2:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24053),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24919), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24057),
                            { -16, -16, height }, { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24923), { -16, -16, height },
                            { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                        break;
                    case 3:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 0:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                        break;
                    case 1:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                        break;
                    case 2:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24011),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24877), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24015),
                            { -16, -16, height }, { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24881), { -16, -16, height },
                            { { -16, -16, height + 35 }, { 32, 32, 0 } });
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                        break;
                    case 3:
                        WoodenASupportsPaintSetup(
                            session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 3:
            if (trackElement.HasChain())
            {
                switch (direction)
                {
                    case 1:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24056),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24922), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            else
            {
                switch (direction)
                {
                    case 1:
                        PaintAddImageAsParentRotated(
                            session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24014),
                            { -16, -16, height }, { { -16, -16, height }, { 32, 32, 2 } });
                        PaintAddImageAsChildRotated(
                            session, direction, WoodenRCGetRailsColour(session).WithIndex(24880), { -16, -16, height },
                            { { -16, -16, height }, { 32, 32, 2 } });
                        break;
                }
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
    }
}

/** rct2: 0x008ACA18 */
template<bool isClassic>
static void WoodenRCTrackDiagFlatToLeftBank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24080), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24946), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24077), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24943), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24081), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24947), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 2:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24079), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24945), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24082), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24948), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24078), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24944), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
    }
}

/** rct2: 0x008AC9F8 */
template<bool isClassic>
static void WoodenRCTrackDiagFlatToRightBank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24086), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24952), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24083), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24949), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24087), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24953), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 2:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24085), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24951), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24088), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24954), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24084), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24950), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
    }
}

/** rct2: 0x008ACA08 */
template<bool isClassic>
static void WoodenRCTrackDiagLeftBankToFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24084), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24950), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24085), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24951), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24088), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24954), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 2:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24083), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24949), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24087), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24953), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24086), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24952), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
    }
}

/** rct2: 0x008ACA28 */
template<bool isClassic>
static void WoodenRCTrackDiagRightBankToFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24078), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24944), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24079), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24945), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24082), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24948), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 2:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24077), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24943), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24081), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24947), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24080), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24946), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
    }
}

/** rct2: 0x008ACA58 */
template<bool isClassic>
static void WoodenRCTrackDiagLeftBankTo25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24104), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24970), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24101), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24967), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24105), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24971), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 2:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24103), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24969), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24106), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24972), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24102), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24968), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
    }
}

/** rct2: 0x008ACA68 */
template<bool isClassic>
static void WoodenRCTrackDiagRightBankTo25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24110), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24976), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24107), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24973), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24111), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24977), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 2:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24109), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24975), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24112), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24978), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24108), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24974), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
    }
}

/** rct2: 0x008ACA38 */
template<bool isClassic>
static void WoodenRCTrackDiag25DegUpToLeftBank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24092), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24958), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24089), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24955), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24093), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24959), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    break;
            }
            WoodenBSupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, direction, height + 16,
                session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24091), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24957), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24094), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24960), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    break;
            }
            WoodenBSupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, direction, height + 16,
                session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24090), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24956), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
    }
}

/** rct2: 0x008ACA48 */
template<bool isClassic>
static void WoodenRCTrackDiag25DegUpToRightBank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24098), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24964), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24095), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24961), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24099), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24965), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    break;
            }
            WoodenBSupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, direction, height + 16,
                session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24097), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24963), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24100), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24966), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    break;
            }
            WoodenBSupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, direction, height + 16,
                session.SupportColours);
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24096), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24962), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
    }
}

/** rct2: 0x008ACA78 */
template<bool isClassic>
static void WoodenRCTrackDiagLeftBankTo25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24096), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24962), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24097), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24963), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24100), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24966), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    break;
            }
            WoodenBSupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, direction, height + 16,
                session.SupportColours);
            break;
        case 2:
            switch (direction)
            {
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24095), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24961), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24099), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24965), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    break;
            }

            WoodenBSupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, direction, height + 16,
                session.SupportColours);

            break;
        case 3:
            switch (direction)
            {
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24098), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24964), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            break;
    }

    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
}

/** rct2: 0x008ACA88 */
template<bool isClassic>
static void WoodenRCTrackDiagRightBankTo25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24090), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24956), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24091), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24957), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24094), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24960), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    break;
            }
            WoodenBSupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, direction, height + 16,
                session.SupportColours);
            break;
        case 2:
            switch (direction)
            {
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24089), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24955), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24093), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24959), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    break;
            }
            WoodenBSupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, direction, height + 16,
                session.SupportColours);
            break;
        case 3:
            switch (direction)
            {
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24092), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24958), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            break;
    }

    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
}

/** rct2: 0x008ACA98 */
template<bool isClassic>
static void WoodenRCTrackDiag25DegDownToLeftBank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24108), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24974), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24109), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24975), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24112), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24978), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 2:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24107), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24973), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24111), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24977), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24110), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24976), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
    }
}

/** rct2: 0x008ACAA8 */
template<bool isClassic>
static void WoodenRCTrackDiag25DegDownToRightBank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24102), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24968), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24103), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24969), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24106), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24972), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 2:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24101), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24967), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24105), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24971), { -16, -16, height },
                        { { -16, -16, height + 35 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24104), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24970), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
    }
}

/** rct2: 0x008AC9D8 */
template<bool isClassic>
static void WoodenRCTrackDiagLeftBank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24074), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24940), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24071), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24937), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24075), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24941), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 2:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24073), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24939), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24076), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24942), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24072), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24938), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
    }
}

/** rct2: 0x008AC9E8 */
template<bool isClassic>
static void WoodenRCTrackDiagRightBank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24072), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24938), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 1:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24073), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24939), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24076), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24942), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 2:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24071), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24937), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24075), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24941), { -16, -16, height },
                        { { -16, -16, height + 27 }, { 32, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24074), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24940), { -16, -16, height },
                        { { -16, -16, height }, { 32, 32, 2 } });
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
            break;
    }
}

/** rct2: 0x008ACB38 */
template<bool isClassic>
static void WoodenRCTrackLeftBankToLeftQuarterTurn325DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23958), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24824), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23960), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24826), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23971), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24837), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23962), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24828), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23956), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24822), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23969), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24835), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_FLAT);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 64, 0x20);
            break;
        case 1:
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 2:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::leftCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::bottomLeftSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23957), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24823), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23959), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24825), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23970), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24836), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23961), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24827), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23972), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24838), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23955), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24821), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23968), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24834), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
            }
            switch (direction)
            {
                case 2:
                    PaintUtilPushTunnelRight(session, height, TUNNEL_SQUARE_8);
                    break;
                case 3:
                    PaintUtilPushTunnelLeft(session, height, TUNNEL_SQUARE_8);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 64, 0x20);
            break;
    }
}

/** rct2: 0x008ACB48 */
template<bool isClassic>
static void WoodenRCTrackRightBankToRightQuarterTurn325DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23947), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24813), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23963), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24829), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23949), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24815), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23951), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24817), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23966), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24832), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23953), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24819), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_FLAT);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 64, 0x20);
            break;
        case 1:
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 2:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::bottomLeftSide,
                        PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23948), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24814), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23964), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24830), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23950), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24816), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23965), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24831), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23952), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24818), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23967), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24833), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23954), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24820), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            switch (direction)
            {
                case 0:
                    PaintUtilPushTunnelRight(session, height, TUNNEL_SQUARE_8);
                    break;
                case 1:
                    PaintUtilPushTunnelLeft(session, height, TUNNEL_SQUARE_8);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 64, 0x20);
            break;
    }
}

/** rct2: 0x008ACB58 */
template<bool isClassic>
static void WoodenRCTrackLeftQuarterTurn325DegDownToLeftBank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23950), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24816), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23965), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24831), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23952), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24818), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23967), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24833), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23954), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24820), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23948), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24814), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23964), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24830), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_8);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 64, 0x20);
            break;
        case 1:
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 2:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::leftCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::bottomLeftSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23949), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24815), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23951), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24817), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23966), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24832), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23953), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24819), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23947), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24813), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23963), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24829), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
            }
            switch (direction)
            {
                case 2:
                    PaintUtilPushTunnelRight(session, height, TUNNEL_SQUARE_FLAT);
                    break;
                case 3:
                    PaintUtilPushTunnelLeft(session, height, TUNNEL_SQUARE_FLAT);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 64, 0x20);
            break;
    }
}

/** rct2: 0x008ACB68 */
template<bool isClassic>
static void WoodenRCTrackRightQuarterTurn325DegDownToRightBank(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23955), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24821), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23968), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24834), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23957), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24823), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23959), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24825), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23970), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24836), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23961), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24827), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23972), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24838), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_8);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 64, 0x20);
            break;
        case 1:
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 2:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::bottomLeftSide,
                        PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23956), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24822), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23969), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24835), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23958), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24824), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23960), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24826), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23971), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24837), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23962), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24828), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            switch (direction)
            {
                case 0:
                    PaintUtilPushTunnelRight(session, height, TUNNEL_SQUARE_FLAT);
                    break;
                case 1:
                    PaintUtilPushTunnelLeft(session, height, TUNNEL_SQUARE_FLAT);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 64, 0x20);
            break;
    }
}

/** rct2: 0x008ACDF8 */
template<bool isClassic>
static void WoodenRCTrackBlockBrakes(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    const auto brakeImg = trackElement.IsBrakeClosed() ? _wooden_rc_block_brakes_image_ids[direction][1]
                                                       : _wooden_rc_block_brakes_image_ids[direction][0];
    WoodenRCTrackPaint<isClassic>(
        session, direction, brakeImg, _wooden_rc_block_brakes_image_ids[direction][2], { 0, 2, height },
        { { 0, 3, height }, { 32, 25, 2 } });
    WoodenASupportsPaintSetupRotated(
        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours);
    PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_FLAT);
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
}

/** rct2: 0x008ACCB8 */
template<bool isClassic>
static void WoodenRCTrackLeftBankedQuarterTurn325DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23932), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24798), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23934), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24800), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23945), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24811), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23936), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24802), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23930), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24796), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23943), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24809), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height - 8, TUNNEL_SQUARE_7);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 1:
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
        case 2:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::leftCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::bottomLeftSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23931), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24797), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23933), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24799), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23944), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24810), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23935), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24801), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23946), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24812), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23929), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24795), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23942), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24808), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
            }
            switch (direction)
            {
                case 2:
                    PaintUtilPushTunnelRight(session, height + 8, TUNNEL_SQUARE_8);
                    break;
                case 3:
                    PaintUtilPushTunnelLeft(session, height + 8, TUNNEL_SQUARE_8);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
    }
}

/** rct2: 0x008ACCC8 */
template<bool isClassic>
static void WoodenRCTrackRightBankedQuarterTurn325DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23921), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24787), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23937), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24803), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23923), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24789), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23925), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24791), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23940), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24806), { 0, 6, height },
                        { { 0, 6, height + 67 }, { 32, 20, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23927), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24793), { 0, 6, height },
                        { { 0, 6, height }, { 32, 20, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height - 8, TUNNEL_SQUARE_7);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 1:
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
        case 2:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::bottomLeftSide,
                        PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23922), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24788), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23938), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24804), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23924), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24790), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23939), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24805), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23926), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24792), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23941), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24807), { 6, 0, height },
                        { { 6, 0, height + 67 }, { 20, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(23928), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(24794), { 6, 0, height },
                        { { 6, 0, height }, { 20, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            switch (direction)
            {
                case 0:
                    PaintUtilPushTunnelRight(session, height + 8, TUNNEL_SQUARE_8);
                    break;
                case 1:
                    PaintUtilPushTunnelLeft(session, height + 8, TUNNEL_SQUARE_8);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
    }
}

/** rct2: 0x008ACCD8 */
template<bool isClassic>
static void WoodenRCTrackLeftBankedQuarterTurn325DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    trackSequence = mapLeftQuarterTurn3TilesToRightQuarterTurn3Tiles[trackSequence];
    WoodenRCTrackRightBankedQuarterTurn325DegUp<isClassic>(
        session, ride, trackSequence, (direction + 1) & 3, height, trackElement);
}

/** rct2: 0x008ACCE8 */
template<bool isClassic>
static void WoodenRCTrackRightBankedQuarterTurn325DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    trackSequence = mapLeftQuarterTurn3TilesToRightQuarterTurn3Tiles[trackSequence];
    WoodenRCTrackLeftBankedQuarterTurn325DegUp<isClassic>(
        session, ride, trackSequence, (direction - 1) & 3, height, trackElement);
}

/** rct2: 0x008ACC38 */
template<bool isClassic>
static void WoodenRCTrackLeftBankedQuarterTurn525DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24321), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25187), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    WoodenASupportsPaintSetupRotated(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height,
                        session.SupportColours, WoodenSupportTransitionType::Up25Deg);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24326), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25192), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24352), { 0, 0, height },
                        { { 0, 2, height + 67 }, { 32, 27, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25218), { 0, 0, height },
                        { { 0, 2, height + 67 }, { 32, 27, 0 } });
                    WoodenASupportsPaintSetupRotated(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height,
                        session.SupportColours, WoodenSupportTransitionType::Up25Deg);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24331), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25197), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    WoodenASupportsPaintSetupRotated(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height,
                        session.SupportColours, WoodenSupportTransitionType::Up25Deg);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24336), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25202), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    WoodenASupportsPaintSetupRotated(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height,
                        session.SupportColours, WoodenSupportTransitionType::Up25Deg);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height - 8, TUNNEL_SQUARE_7);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 1:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::rightCorner, PaintSegment::topRightSide, PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24322), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25188), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24327), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25193), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24353), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25219), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24332), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25198), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24337), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25203), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24359), { 0, 0, height },
                        { { 0, 16, height + 67 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25225), { 0, 0, height },
                        { { 0, 16, height + 67 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::leftCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::topRightSide, PaintSegment::bottomLeftSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24323), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25189), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24328), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25194), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24354), { 0, 0, height },
                        { { 16, 16, height + 59 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25220), { 0, 0, height },
                        { { 16, 16, height + 59 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24333), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25199), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24338), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25204), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24360), { 0, 0, height },
                        { { 0, 0, height + 59 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25226), { 0, 0, height },
                        { { 0, 0, height + 59 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::rightCorner, PaintSegment::bottomCorner, PaintSegment::centre,
                        PaintSegment::topLeftSide, PaintSegment::topRightSide, PaintSegment::bottomLeftSide,
                        PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 64, 0x20);
            break;
        case 4:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::rightCorner, PaintSegment::topRightSide, PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 5:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24324), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25190), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24329), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25195), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24355), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25221), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24334), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25200), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24357), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25223), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24339), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25205), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24361), { 0, 0, height },
                        { { 16, 0, height + 67 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25227), { 0, 0, height },
                        { { 16, 0, height + 67 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::leftCorner, PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::bottomLeftSide, PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 6:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24325), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25191), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24330), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25196), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24356), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25222), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24335), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25201), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24358), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25224), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24340), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25206), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24362), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25228), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    break;
            }
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, DirectionPrev(direction), height,
                session.SupportColours, WoodenSupportTransitionType::Up25Deg);
            switch (direction)
            {
                case 2:
                    PaintUtilPushTunnelRight(session, height + 8, TUNNEL_SQUARE_8);
                    break;
                case 3:
                    PaintUtilPushTunnelLeft(session, height + 8, TUNNEL_SQUARE_8);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
    }
}

/** rct2: 0x008ACC48 */
template<bool isClassic>
static void WoodenRCTrackRightBankedQuarterTurn525DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (trackSequence)
    {
        case 0:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24301), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25167), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    WoodenASupportsPaintSetupRotated(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height,
                        session.SupportColours, WoodenSupportTransitionType::Up25Deg);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24306), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25172), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    WoodenASupportsPaintSetupRotated(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height,
                        session.SupportColours, WoodenSupportTransitionType::Up25Deg);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24311), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25177), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24347), { 0, 0, height },
                        { { 0, 2, height + 67 }, { 32, 27, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25213), { 0, 0, height },
                        { { 0, 2, height + 67 }, { 32, 27, 0 } });
                    WoodenASupportsPaintSetupRotated(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height,
                        session.SupportColours, WoodenSupportTransitionType::Up25Deg);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24316), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25182), { 0, 0, height },
                        { { 0, 2, height }, { 32, 27, 2 } });
                    WoodenASupportsPaintSetupRotated(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height,
                        session.SupportColours, WoodenSupportTransitionType::Up25Deg);
                    break;
            }
            if (direction == 0 || direction == 3)
            {
                PaintUtilPushTunnelRotated(session, direction, height - 8, TUNNEL_SQUARE_7);
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 1:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::topCorner, PaintSegment::topLeftSide, PaintSegment::topRightSide), direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 2:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24302), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25168), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24341), { 0, 0, height },
                        { { 0, 16, height + 67 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25207), { 0, 0, height },
                        { { 0, 16, height + 67 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24307), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25173), { 0, 0, height },
                        { { 0, 16, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24312), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25178), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24348), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 32, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25214), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 32, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24317), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25183), { 0, 0, height },
                        { { 0, 0, height }, { 32, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::rightCorner, PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::topRightSide,
                        PaintSegment::bottomLeftSide, PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 3:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24303), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25169), { 0, 0, height },
                        { { 0, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24342), { 0, 0, height },
                        { { 0, 0, height + 59 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25208), { 0, 0, height },
                        { { 0, 0, height + 59 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24308), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25174), { 0, 0, height },
                        { { 16, 0, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24313), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25179), { 0, 0, height },
                        { { 16, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24349), { 0, 0, height },
                        { { 16, 16, height + 59 }, { 16, 16, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25215), { 0, 0, height },
                        { { 16, 16, height + 59 }, { 16, 16, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24318), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25184), { 0, 0, height },
                        { { 0, 16, height }, { 16, 16, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::topCorner, PaintSegment::leftCorner, PaintSegment::rightCorner, PaintSegment::centre,
                        PaintSegment::topLeftSide, PaintSegment::topRightSide, PaintSegment::bottomLeftSide,
                        PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 64, 0x20);
            break;
        case 4:
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(PaintSegment::topCorner, PaintSegment::topLeftSide, PaintSegment::topRightSide), direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 5:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24304), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25170), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24343), { 0, 0, height },
                        { { 16, 0, height + 67 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25209), { 0, 0, height },
                        { { 16, 0, height + 67 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner2, height, session.SupportColours);
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24309), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25175), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24345), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25211), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner3, height, session.SupportColours);
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24314), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25180), { 0, 0, height },
                        { { 0, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24350), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25216), { 0, 0, height },
                        { { 0, 0, height + 67 }, { 16, 32, 0 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner0, height, session.SupportColours);
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24319), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25185), { 0, 0, height },
                        { { 16, 0, height }, { 16, 32, 2 } });
                    WoodenASupportsPaintSetup(
                        session, WoodenSupportType::Truss, WoodenSupportSubType::Corner1, height, session.SupportColours);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(
                session,
                PaintUtilRotateSegments(
                    EnumsToFlags(
                        PaintSegment::leftCorner, PaintSegment::bottomCorner, PaintSegment::centre, PaintSegment::topLeftSide,
                        PaintSegment::bottomLeftSide, PaintSegment::bottomRightSide),
                    direction),
                0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
        case 6:
            switch (direction)
            {
                case 0:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24305), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25171), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24344), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25210), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    break;
                case 1:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24310), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25176), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24346), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25212), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    break;
                case 2:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24315), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25181), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24351), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25217), { 0, 0, height },
                        { { 2, 0, height + 67 }, { 27, 32, 0 } });
                    break;
                case 3:
                    PaintAddImageAsParentRotated(
                        session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24320), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    PaintAddImageAsChildRotated(
                        session, direction, WoodenRCGetRailsColour(session).WithIndex(25186), { 0, 0, height },
                        { { 2, 0, height }, { 27, 32, 2 } });
                    break;
            }
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, DirectionNext(direction), height,
                session.SupportColours, WoodenSupportTransitionType::Up25Deg);
            switch (direction)
            {
                case 0:
                    PaintUtilPushTunnelRight(session, height + 8, TUNNEL_SQUARE_8);
                    break;
                case 1:
                    PaintUtilPushTunnelLeft(session, height + 8, TUNNEL_SQUARE_8);
                    break;
            }
            PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
            PaintUtilSetGeneralSupportHeight(session, height + 72, 0x20);
            break;
    }
}

/** rct2: 0x008ACC58 */
template<bool isClassic>
static void WoodenRCTrackLeftBankedQuarterTurn525DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    trackSequence = mapLeftQuarterTurn5TilesToRightQuarterTurn5Tiles[trackSequence];
    WoodenRCTrackRightBankedQuarterTurn525DegUp<isClassic>(
        session, ride, trackSequence, (direction + 1) & 3, height, trackElement);
}

/** rct2: 0x008ACC68 */
template<bool isClassic>
static void WoodenRCTrackRightBankedQuarterTurn525DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    trackSequence = mapLeftQuarterTurn5TilesToRightQuarterTurn5Tiles[trackSequence];
    WoodenRCTrackLeftBankedQuarterTurn525DegUp<isClassic>(
        session, ride, trackSequence, (direction - 1) & 3, height, trackElement);
}

/** rct2: 0x008ACCF8 */
template<bool isClassic>
static void WoodenRCTrack25DegUpToLeftBanked25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24261), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25127), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25Deg);
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24262), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25128), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25Deg);
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24263), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25129), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25Deg);
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24264), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25130), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25Deg);
            break;
    }
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, TUNNEL_SQUARE_7);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 8, TUNNEL_SQUARE_8);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
}

/** rct2: 0x008ACD08 */
template<bool isClassic>
static void WoodenRCTrack25DegUpToRightBanked25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24265), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25131), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25Deg);
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24266), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25132), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25Deg);
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24267), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25133), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25Deg);
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24268), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25134), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25Deg);
            break;
    }
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, TUNNEL_SQUARE_7);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 8, TUNNEL_SQUARE_8);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
}

/** rct2: 0x008ACD18 */
template<bool isClassic>
static void WoodenRCTrackLeftBanked25DegUpTo25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24269), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25135), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25Deg);
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24270), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25136), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25Deg);
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24271), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25137), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25Deg);
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24272), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25138), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25Deg);
            break;
    }
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, TUNNEL_SQUARE_7);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 8, TUNNEL_SQUARE_8);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
}

/** rct2: 0x008ACD28 */
template<bool isClassic>
static void WoodenRCTrackRightBanked25DegUpTo25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24273), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25139), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25Deg);
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24274), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25140), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25Deg);
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24275), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25141), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25Deg);
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24276), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25142), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25Deg);
            break;
    }
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, TUNNEL_SQUARE_7);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 8, TUNNEL_SQUARE_8);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 56, 0x20);
}

/** rct2: 0x008ACD38 */
template<bool isClassic>
static void WoodenRCTrack25DegDownToLeftBanked25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    WoodenRCTrackRightBanked25DegUpTo25DegUp<isClassic>(
        session, ride, trackSequence, (direction + 2) & 3, height, trackElement);
}

/** rct2: 0x008ACD48 */
template<bool isClassic>
static void WoodenRCTrack25DegDownToRightBanked25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    WoodenRCTrackLeftBanked25DegUpTo25DegUp<isClassic>(session, ride, trackSequence, (direction + 2) & 3, height, trackElement);
}

/** rct2: 0x008ACD58 */
template<bool isClassic>
static void WoodenRCTrackLeftBanked25DegDownTo25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    WoodenRCTrack25DegUpToRightBanked25DegUp<isClassic>(
        session, ride, trackSequence, (direction + 2) & 3, height, trackElement);
}

/** rct2: 0x008ACD68 */
template<bool isClassic>
static void WoodenRCTrackRightBanked25DegDownTo25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    WoodenRCTrack25DegUpToLeftBanked25DegUp<isClassic>(session, ride, trackSequence, (direction + 2) & 3, height, trackElement);
}

/** rct2: 0x008ACD78 */
template<bool isClassic>
static void WoodenRCTrackLeftBankedFlatToLeftBanked25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24277), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25143), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::FlatToUp25Deg);
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24278), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25144), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24293), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25159), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::FlatToUp25Deg);
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24279), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25145), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24294), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25160), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::FlatToUp25Deg);
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24280), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25146), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::FlatToUp25Deg);
            break;
    }
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_FLAT);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_8);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
}

/** rct2: 0x008ACD88 */
template<bool isClassic>
static void WoodenRCTrackRightBankedFlatToRightBanked25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24281), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25147), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::FlatToUp25Deg);
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24282), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25148), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24295), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25161), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::FlatToUp25Deg);
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24283), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25149), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24296), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25162), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::FlatToUp25Deg);
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24284), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25150), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::FlatToUp25Deg);
            break;
    }
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_FLAT);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_8);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
}

/** rct2: 0x008ACD98 */
template<bool isClassic>
static void WoodenRCTrackLeftBanked25DegUpToLeftBankedFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24285), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25151), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25DegToFlat);
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24286), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25152), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24297), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25163), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25DegToFlat);
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24287), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25153), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24298), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25164), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25DegToFlat);
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24288), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25154), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25DegToFlat);
            break;
    }
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, TUNNEL_SQUARE_FLAT);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 8, TUNNEL_14);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 40, 0x20);
}

/** rct2: 0x008ACDA8 */
template<bool isClassic>
static void WoodenRCTrackRightBanked25DegUpToRightBankedFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24289), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25155), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25DegToFlat);
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24290), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25156), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24299), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25165), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25DegToFlat);
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24291), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25157), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24300), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25166), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25DegToFlat);
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24292), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25158), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25DegToFlat);
            break;
    }
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, TUNNEL_SQUARE_FLAT);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 8, TUNNEL_14);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 40, 0x20);
}

/** rct2: 0x008ACDB8 */
template<bool isClassic>
static void WoodenRCTrackLeftBankedFlatToLeftBanked25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    WoodenRCTrackRightBanked25DegUpToRightBankedFlat<isClassic>(
        session, ride, trackSequence, (direction + 2) & 3, height, trackElement);
}

/** rct2: 0x008ACDC8 */
template<bool isClassic>
static void WoodenRCTrackRightBankedFlatToRightBanked25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    WoodenRCTrackLeftBanked25DegUpToLeftBankedFlat<isClassic>(
        session, ride, trackSequence, (direction + 2) & 3, height, trackElement);
}

/** rct2: 0x008ACDD8 */
template<bool isClassic>
static void WoodenRCTrackLeftBanked25DegDownToLeftBankedFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    WoodenRCTrackRightBankedFlatToRightBanked25DegUp<isClassic>(
        session, ride, trackSequence, (direction + 2) & 3, height, trackElement);
}

/** rct2: 0x008ACDE8 */
template<bool isClassic>
static void WoodenRCTrackRightBanked25DegDownToRightBankedFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    WoodenRCTrackLeftBankedFlatToLeftBanked25DegUp<isClassic>(
        session, ride, trackSequence, (direction + 2) & 3, height, trackElement);
}

/** rct2: 0x008ACBB8 */
template<bool isClassic>
static void WoodenRCTrackFlatToLeftBanked25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24225), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25091), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::FlatToUp25Deg);
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24226), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25092), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24241), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25107), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::FlatToUp25Deg);
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24227), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25093), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24242), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25108), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::FlatToUp25Deg);
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24228), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25094), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::FlatToUp25Deg);
            break;
    }
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_FLAT);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_8);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
}

/** rct2: 0x008ACBC8 */
template<bool isClassic>
static void WoodenRCTrackFlatToRightBanked25DegUp(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24229), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25095), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::FlatToUp25Deg);
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24230), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25096), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24243), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25109), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::FlatToUp25Deg);
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24231), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25097), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24244), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25110), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::FlatToUp25Deg);
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24232), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25098), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::FlatToUp25Deg);
            break;
    }
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_FLAT);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_8);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 48, 0x20);
}

/** rct2: 0x008ACBD8 */
template<bool isClassic>
static void WoodenRCTrackLeftBanked25DegUpToFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24233), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25099), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25DegToFlat);
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24234), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25100), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24245), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25111), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25DegToFlat);
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24235), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25101), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24246), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25112), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25DegToFlat);
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24236), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25102), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25DegToFlat);
            break;
    }
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, TUNNEL_SQUARE_FLAT);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 8, TUNNEL_14);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 40, 0x20);
}

/** rct2: 0x008ACBE8 */
template<bool isClassic>
static void WoodenRCTrackRightBanked25DegUpToFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    switch (direction)
    {
        case 0:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24237), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25103), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25DegToFlat);
            break;
        case 1:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24238), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25104), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24247), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25113), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25DegToFlat);
            break;
        case 2:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24239), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25105), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24248), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25114), { 0, 0, height },
                { { 0, 26, height + 5 }, { 32, 1, 9 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25DegToFlat);
            break;
        case 3:
            PaintAddImageAsParentRotated(
                session, direction, WoodenRCGetTrackColour<isClassic>(session).WithIndex(24240), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            PaintAddImageAsChildRotated(
                session, direction, WoodenRCGetRailsColour(session).WithIndex(25106), { 0, 0, height },
                { { 0, 3, height }, { 32, 25, 2 } });
            WoodenASupportsPaintSetupRotated(
                session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours,
                WoodenSupportTransitionType::Up25DegToFlat);
            break;
    }
    if (direction == 0 || direction == 3)
    {
        PaintUtilPushTunnelRotated(session, direction, height - 8, TUNNEL_SQUARE_FLAT);
    }
    else
    {
        PaintUtilPushTunnelRotated(session, direction, height + 8, TUNNEL_14);
    }
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 40, 0x20);
}

/** rct2: 0x008ACBF8 */
template<bool isClassic>
static void WoodenRCTrackFlatToLeftBanked25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    WoodenRCTrackRightBanked25DegUpToFlat<isClassic>(session, ride, trackSequence, (direction + 2) & 3, height, trackElement);
}

/** rct2: 0x008ACC08 */
template<bool isClassic>
static void WoodenRCTrackFlatToRightBanked25DegDown(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    WoodenRCTrackLeftBanked25DegUpToFlat<isClassic>(session, ride, trackSequence, (direction + 2) & 3, height, trackElement);
}

/** rct2: 0x008ACC18 */
template<bool isClassic>
static void WoodenRCTrackLeftBanked25DegDownToFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    WoodenRCTrackFlatToRightBanked25DegUp<isClassic>(session, ride, trackSequence, (direction + 2) & 3, height, trackElement);
}

/** rct2: 0x008ACC28 */
template<bool isClassic>
static void WoodenRCTrackRightBanked25DegDownToFlat(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    WoodenRCTrackFlatToLeftBanked25DegUp<isClassic>(session, ride, trackSequence, (direction + 2) & 3, height, trackElement);
}

template<bool isClassic>
static void WoodenRCTrackBooster(
    PaintSession& session, const Ride& ride, uint8_t trackSequence, uint8_t direction, int32_t height,
    const TrackElement& trackElement)
{
    static constexpr uint32_t imageIds[4] = {
        SPR_G2_WOODEN_RC_BOOSTER_SW_NE,
        SPR_G2_WOODEN_RC_BOOSTER_NW_SE,
        SPR_G2_WOODEN_RC_BOOSTER_SW_NE,
        SPR_G2_WOODEN_RC_BOOSTER_NW_SE,
    };
    static constexpr uint32_t railsImageIds[4] = {
        SPR_WOODEN_RC_FLAT_CHAIN_RAILS_SW_NE,
        SPR_WOODEN_RC_FLAT_CHAIN_RAILS_NW_SE,
        SPR_WOODEN_RC_FLAT_CHAIN_RAILS_NE_SW,
        SPR_WOODEN_RC_FLAT_CHAIN_RAILS_SE_NW,
    };

    WoodenRCTrackPaint<isClassic>(
        session, direction, imageIds[direction], railsImageIds[direction], { 0, 2, height },
        { { 0, 3, height }, { 32, 25, 2 } });
    WoodenASupportsPaintSetupRotated(
        session, WoodenSupportType::Truss, WoodenSupportSubType::NeSw, direction, height, session.SupportColours);
    PaintUtilPushTunnelRotated(session, direction, height, TUNNEL_SQUARE_FLAT);
    PaintUtilSetSegmentSupportHeight(session, kSegmentsAll, 0xFFFF, 0);
    PaintUtilSetGeneralSupportHeight(session, height + 32, 0x20);
}

template<bool isClassic> TRACK_PAINT_FUNCTION GetTrackPaintFunctionWoodenAndClassicWoodenRC(int32_t trackType)
{
    switch (trackType)
    {
        case TrackElemType::Flat:
            return WoodenRCTrackFlat<isClassic>;
        case TrackElemType::EndStation:
        case TrackElemType::BeginStation:
        case TrackElemType::MiddleStation:
            return WoodenRCTrackStation<isClassic>;
        case TrackElemType::Up25:
            return WoodenRCTrack25DegUp<isClassic>;
        case TrackElemType::Up60:
            return WoodenRCTrack60DegUp<isClassic>;
        case TrackElemType::FlatToUp25:
            return WoodenRCTrackFlatTo25DegUp<isClassic>;
        case TrackElemType::Up25ToUp60:
            return WoodenRCTrack25DegUpTo60DegUp<isClassic>;
        case TrackElemType::Up60ToUp25:
            return WoodenRCTrack60DegUpTo25DegUp<isClassic>;
        case TrackElemType::Up25ToFlat:
            return WoodenRCTrack25DegUpToFlat<isClassic>;
        case TrackElemType::Down25:
            return WoodenRCTrack25DegDown<isClassic>;
        case TrackElemType::Down60:
            return WoodenRCTrack60DegDown<isClassic>;
        case TrackElemType::FlatToDown25:
            return WoodenRCTrackFlatTo25DegDown<isClassic>;
        case TrackElemType::Down25ToDown60:
            return WoodenRCTrack25DegDownTo60DegDown<isClassic>;
        case TrackElemType::Down60ToDown25:
            return WoodenRCTrack60DegDownTo25DegDown<isClassic>;
        case TrackElemType::Down25ToFlat:
            return WoodenRCTrack25DegDownToFlat<isClassic>;
        case TrackElemType::LeftQuarterTurn5Tiles:
            return WoodenRCTrackLeftQuarterTurn5<isClassic>;
        case TrackElemType::RightQuarterTurn5Tiles:
            return WoodenRCTrackRightQuarterTurn5<isClassic>;
        case TrackElemType::FlatToLeftBank:
            return WoodenRCTrackFlatToLeftBank<isClassic>;
        case TrackElemType::FlatToRightBank:
            return WoodenRCTrackFlatToRightBank<isClassic>;
        case TrackElemType::LeftBankToFlat:
            return WoodenRCTrackLeftBankToFlat<isClassic>;
        case TrackElemType::RightBankToFlat:
            return WoodenRCTrackRightBankToFlat<isClassic>;
        case TrackElemType::BankedLeftQuarterTurn5Tiles:
            return WoodenRCTrackBankedLeftQuarterTurn5<isClassic>;
        case TrackElemType::BankedRightQuarterTurn5Tiles:
            return WoodenRCTrackBankedRightQuarterTurn5<isClassic>;
        case TrackElemType::LeftBankToUp25:
            return WoodenRCTrackLeftBankTo25DegUp<isClassic>;
        case TrackElemType::RightBankToUp25:
            return WoodenRCTrackRightBankTo25DegUp<isClassic>;
        case TrackElemType::Up25ToLeftBank:
            return WoodenRCTrack25DegUpToLeftBank<isClassic>;
        case TrackElemType::Up25ToRightBank:
            return WoodenRCTrack25DegUpToRightBank<isClassic>;
        case TrackElemType::LeftBankToDown25:
            return WoodenRCTrackLeftBankTo25DegDown<isClassic>;
        case TrackElemType::RightBankToDown25:
            return WoodenRCTrackRightBankTo25DegDown<isClassic>;
        case TrackElemType::Down25ToLeftBank:
            return WoodenRCTrack25DegDownToLeftBank<isClassic>;
        case TrackElemType::Down25ToRightBank:
            return WoodenRCTrack25DegDownToRightBank<isClassic>;
        case TrackElemType::LeftBank:
            return WoodenRCTrackLeftBank<isClassic>;
        case TrackElemType::RightBank:
            return WoodenRCTrackRightBank<isClassic>;
        case TrackElemType::LeftQuarterTurn5TilesUp25:
            return WoodenRCTrackLeftQuarterTurn525DegUp<isClassic>;
        case TrackElemType::RightQuarterTurn5TilesUp25:
            return WoodenRCTrackRightQuarterTurn525DegUp<isClassic>;
        case TrackElemType::LeftQuarterTurn5TilesDown25:
            return WoodenRCTrackLeftQuarterTurn525DegDown<isClassic>;
        case TrackElemType::RightQuarterTurn5TilesDown25:
            return WoodenRCTrackRightQuarterTurn525DegDown<isClassic>;
        case TrackElemType::SBendLeft:
            return WoodenRCTrackSBendLeft<isClassic>;
        case TrackElemType::SBendRight:
            return WoodenRCTrackSBendRight<isClassic>;
        case TrackElemType::LeftVerticalLoop:
            return WoodenRCTrackLeftVerticalLoop<isClassic>;
        case TrackElemType::RightVerticalLoop:
            return WoodenRCTrackRightVerticalLoop<isClassic>;
        case TrackElemType::LeftQuarterTurn3Tiles:
            return WoodenRCTrackLeftQuarterTurn3<isClassic>;
        case TrackElemType::RightQuarterTurn3Tiles:
            return WoodenRCTrackRightQuarterTurn3<isClassic>;
        case TrackElemType::LeftBankedQuarterTurn3Tiles:
            return WoodenRCTrackLeftQuarterTurn3Bank<isClassic>;
        case TrackElemType::RightBankedQuarterTurn3Tiles:
            return WoodenRCTrackRightQuarterTurn3Bank<isClassic>;
        case TrackElemType::LeftQuarterTurn3TilesUp25:
            return WoodenRCTrackLeftQuarterTurn325DegUp<isClassic>;
        case TrackElemType::RightQuarterTurn3TilesUp25:
            return WoodenRCTrackRightQuarterTurn325DegUp<isClassic>;
        case TrackElemType::LeftQuarterTurn3TilesDown25:
            return WoodenRCTrackLeftQuarterTurn325DegDown<isClassic>;
        case TrackElemType::RightQuarterTurn3TilesDown25:
            return WoodenRCTrackRightQuarterTurn325DegDown<isClassic>;
        case TrackElemType::LeftHalfBankedHelixUpSmall:
            return WoodenRCTrackLeftHalfBankedHelixUpSmall<isClassic>;
        case TrackElemType::RightHalfBankedHelixUpSmall:
            return WoodenRCTrackRightHalfBankedHelixUpSmall<isClassic>;
        case TrackElemType::LeftHalfBankedHelixDownSmall:
            return WoodenRCTrackLeftHalfBankedHelixDownSmall<isClassic>;
        case TrackElemType::RightHalfBankedHelixDownSmall:
            return WoodenRCTrackRightHalfBankedHelixDownSmall<isClassic>;
        case TrackElemType::LeftHalfBankedHelixUpLarge:
            return WoodenRCTrackLeftHalfBankedHelixUpLarge<isClassic>;
        case TrackElemType::RightHalfBankedHelixUpLarge:
            return WoodenRCTrackRightHalfBankedHelixUpLarge<isClassic>;
        case TrackElemType::LeftHalfBankedHelixDownLarge:
            return WoodenRCTrackLeftHalfBankedHelixDownLarge<isClassic>;
        case TrackElemType::RightHalfBankedHelixDownLarge:
            return WoodenRCTrackRightHalfBankedHelixDownLarge<isClassic>;
        case TrackElemType::LeftQuarterTurn1TileUp60:
            return WoodenRCTrackLeftQuarterTurn160DegUp<isClassic>;
        case TrackElemType::RightQuarterTurn1TileUp60:
            return WoodenRCTrackRightQuarterTurn160DegUp<isClassic>;
        case TrackElemType::LeftQuarterTurn1TileDown60:
            return WoodenRCTrackLeftQuarterTurn160DegDown<isClassic>;
        case TrackElemType::RightQuarterTurn1TileDown60:
            return WoodenRCTrackRightQuarterTurn160DegDown<isClassic>;
        case TrackElemType::Brakes:
            return WoodenRCTrackBrakes<isClassic>;
        case TrackElemType::Up25LeftBanked:
            return WoodenRCTrack25DegUpLeftBanked<isClassic>;
        case TrackElemType::Up25RightBanked:
            return WoodenRCTrack25DegUpRightBanked<isClassic>;
        case TrackElemType::OnRidePhoto:
            return WoodenRCTrackOnRidePhoto<isClassic>;
        case TrackElemType::Down25LeftBanked:
            return WoodenRCTrack25DegDownLeftBanked<isClassic>;
        case TrackElemType::Down25RightBanked:
            return WoodenRCTrack25DegDownRightBanked<isClassic>;
        case TrackElemType::Watersplash:
            return WoodenRCTrackWaterSplash<isClassic>;
        case TrackElemType::LeftEighthToDiag:
            return WoodenRCTrackLeftEighthToDiag<isClassic>;
        case TrackElemType::RightEighthToDiag:
            return WoodenRCTrackRightEighthToDiag<isClassic>;
        case TrackElemType::LeftEighthToOrthogonal:
            return WoodenRCTrackLeftEighthToOrthogonal<isClassic>;
        case TrackElemType::RightEighthToOrthogonal:
            return WoodenRCTrackRightEighthToOrthogonal<isClassic>;
        case TrackElemType::LeftEighthBankToDiag:
            return WoodenRCTrackLeftEighthBankToDiag<isClassic>;
        case TrackElemType::RightEighthBankToDiag:
            return WoodenRCTrackRightEighthBankToDiag<isClassic>;
        case TrackElemType::LeftEighthBankToOrthogonal:
            return WoodenRCTrackLeftEighthBankToOrthogonal<isClassic>;
        case TrackElemType::RightEighthBankToOrthogonal:
            return WoodenRCTrackRightEighthBankToOrthogonal<isClassic>;
        case TrackElemType::DiagFlat:
            return WoodenRCTrackDiagFlat<isClassic>;
        case TrackElemType::DiagUp25:
            return WoodenRCTrackDiag25DegUp<isClassic>;
        case TrackElemType::DiagUp60:
            return WoodenRCTrackDiag60DegUp<isClassic>;
        case TrackElemType::DiagFlatToUp25:
            return WoodenRCTrackDiagFlatTo25DegUp<isClassic>;
        case TrackElemType::DiagUp25ToUp60:
            return WoodenRCTrackDiag25DegUpTo60DegUp<isClassic>;
        case TrackElemType::DiagUp60ToUp25:
            return WoodenRCTrackDiag60DegUpTo25DegUp<isClassic>;
        case TrackElemType::DiagUp25ToFlat:
            return WoodenRCTrackDiag25DegUpToFlat<isClassic>;
        case TrackElemType::DiagDown25:
            return WoodenRCTrackDiag25DegDown<isClassic>;
        case TrackElemType::DiagDown60:
            return WoodenRCTrackDiag60DegDown<isClassic>;
        case TrackElemType::DiagFlatToDown25:
            return WoodenRCTrackDiagFlatTo25DegDown<isClassic>;
        case TrackElemType::DiagDown25ToDown60:
            return WoodenRCTrackDiag25DegDownTo60DegDown<isClassic>;
        case TrackElemType::DiagDown60ToDown25:
            return WoodenRCTrackDiag60DegDownTo25DegDown<isClassic>;
        case TrackElemType::DiagDown25ToFlat:
            return WoodenRCTrackDiag25DegDownToFlat<isClassic>;
        case TrackElemType::DiagFlatToLeftBank:
            return WoodenRCTrackDiagFlatToLeftBank<isClassic>;
        case TrackElemType::DiagFlatToRightBank:
            return WoodenRCTrackDiagFlatToRightBank<isClassic>;
        case TrackElemType::DiagLeftBankToFlat:
            return WoodenRCTrackDiagLeftBankToFlat<isClassic>;
        case TrackElemType::DiagRightBankToFlat:
            return WoodenRCTrackDiagRightBankToFlat<isClassic>;
        case TrackElemType::DiagLeftBankToUp25:
            return WoodenRCTrackDiagLeftBankTo25DegUp<isClassic>;
        case TrackElemType::DiagRightBankToUp25:
            return WoodenRCTrackDiagRightBankTo25DegUp<isClassic>;
        case TrackElemType::DiagUp25ToLeftBank:
            return WoodenRCTrackDiag25DegUpToLeftBank<isClassic>;
        case TrackElemType::DiagUp25ToRightBank:
            return WoodenRCTrackDiag25DegUpToRightBank<isClassic>;
        case TrackElemType::DiagLeftBankToDown25:
            return WoodenRCTrackDiagLeftBankTo25DegDown<isClassic>;
        case TrackElemType::DiagRightBankToDown25:
            return WoodenRCTrackDiagRightBankTo25DegDown<isClassic>;
        case TrackElemType::DiagDown25ToLeftBank:
            return WoodenRCTrackDiag25DegDownToLeftBank<isClassic>;
        case TrackElemType::DiagDown25ToRightBank:
            return WoodenRCTrackDiag25DegDownToRightBank<isClassic>;
        case TrackElemType::DiagLeftBank:
            return WoodenRCTrackDiagLeftBank<isClassic>;
        case TrackElemType::DiagRightBank:
            return WoodenRCTrackDiagRightBank<isClassic>;
        case TrackElemType::LeftBankToLeftQuarterTurn3TilesUp25:
            return WoodenRCTrackLeftBankToLeftQuarterTurn325DegUp<isClassic>;
        case TrackElemType::RightBankToRightQuarterTurn3TilesUp25:
            return WoodenRCTrackRightBankToRightQuarterTurn325DegUp<isClassic>;
        case TrackElemType::LeftQuarterTurn3TilesDown25ToLeftBank:
            return WoodenRCTrackLeftQuarterTurn325DegDownToLeftBank<isClassic>;
        case TrackElemType::RightQuarterTurn3TilesDown25ToRightBank:
            return WoodenRCTrackRightQuarterTurn325DegDownToRightBank<isClassic>;
        case TrackElemType::BlockBrakes:
            return WoodenRCTrackBlockBrakes<isClassic>;
        case TrackElemType::LeftBankedQuarterTurn3TileUp25:
            return WoodenRCTrackLeftBankedQuarterTurn325DegUp<isClassic>;
        case TrackElemType::RightBankedQuarterTurn3TileUp25:
            return WoodenRCTrackRightBankedQuarterTurn325DegUp<isClassic>;
        case TrackElemType::LeftBankedQuarterTurn3TileDown25:
            return WoodenRCTrackLeftBankedQuarterTurn325DegDown<isClassic>;
        case TrackElemType::RightBankedQuarterTurn3TileDown25:
            return WoodenRCTrackRightBankedQuarterTurn325DegDown<isClassic>;
        case TrackElemType::LeftBankedQuarterTurn5TileUp25:
            return WoodenRCTrackLeftBankedQuarterTurn525DegUp<isClassic>;
        case TrackElemType::RightBankedQuarterTurn5TileUp25:
            return WoodenRCTrackRightBankedQuarterTurn525DegUp<isClassic>;
        case TrackElemType::LeftBankedQuarterTurn5TileDown25:
            return WoodenRCTrackLeftBankedQuarterTurn525DegDown<isClassic>;
        case TrackElemType::RightBankedQuarterTurn5TileDown25:
            return WoodenRCTrackRightBankedQuarterTurn525DegDown<isClassic>;
        case TrackElemType::Up25ToLeftBankedUp25:
            return WoodenRCTrack25DegUpToLeftBanked25DegUp<isClassic>;
        case TrackElemType::Up25ToRightBankedUp25:
            return WoodenRCTrack25DegUpToRightBanked25DegUp<isClassic>;
        case TrackElemType::LeftBankedUp25ToUp25:
            return WoodenRCTrackLeftBanked25DegUpTo25DegUp<isClassic>;
        case TrackElemType::RightBankedUp25ToUp25:
            return WoodenRCTrackRightBanked25DegUpTo25DegUp<isClassic>;
        case TrackElemType::Down25ToLeftBankedDown25:
            return WoodenRCTrack25DegDownToLeftBanked25DegDown<isClassic>;
        case TrackElemType::Down25ToRightBankedDown25:
            return WoodenRCTrack25DegDownToRightBanked25DegDown<isClassic>;
        case TrackElemType::LeftBankedDown25ToDown25:
            return WoodenRCTrackLeftBanked25DegDownTo25DegDown<isClassic>;
        case TrackElemType::RightBankedDown25ToDown25:
            return WoodenRCTrackRightBanked25DegDownTo25DegDown<isClassic>;
        case TrackElemType::LeftBankedFlatToLeftBankedUp25:
            return WoodenRCTrackLeftBankedFlatToLeftBanked25DegUp<isClassic>;
        case TrackElemType::RightBankedFlatToRightBankedUp25:
            return WoodenRCTrackRightBankedFlatToRightBanked25DegUp<isClassic>;
        case TrackElemType::LeftBankedUp25ToLeftBankedFlat:
            return WoodenRCTrackLeftBanked25DegUpToLeftBankedFlat<isClassic>;
        case TrackElemType::RightBankedUp25ToRightBankedFlat:
            return WoodenRCTrackRightBanked25DegUpToRightBankedFlat<isClassic>;
        case TrackElemType::LeftBankedFlatToLeftBankedDown25:
            return WoodenRCTrackLeftBankedFlatToLeftBanked25DegDown<isClassic>;
        case TrackElemType::RightBankedFlatToRightBankedDown25:
            return WoodenRCTrackRightBankedFlatToRightBanked25DegDown<isClassic>;
        case TrackElemType::LeftBankedDown25ToLeftBankedFlat:
            return WoodenRCTrackLeftBanked25DegDownToLeftBankedFlat<isClassic>;
        case TrackElemType::RightBankedDown25ToRightBankedFlat:
            return WoodenRCTrackRightBanked25DegDownToRightBankedFlat<isClassic>;
        case TrackElemType::FlatToLeftBankedUp25:
            return WoodenRCTrackFlatToLeftBanked25DegUp<isClassic>;
        case TrackElemType::FlatToRightBankedUp25:
            return WoodenRCTrackFlatToRightBanked25DegUp<isClassic>;
        case TrackElemType::LeftBankedUp25ToFlat:
            return WoodenRCTrackLeftBanked25DegUpToFlat<isClassic>;
        case TrackElemType::RightBankedUp25ToFlat:
            return WoodenRCTrackRightBanked25DegUpToFlat<isClassic>;
        case TrackElemType::FlatToLeftBankedDown25:
            return WoodenRCTrackFlatToLeftBanked25DegDown<isClassic>;
        case TrackElemType::FlatToRightBankedDown25:
            return WoodenRCTrackFlatToRightBanked25DegDown<isClassic>;
        case TrackElemType::LeftBankedDown25ToFlat:
            return WoodenRCTrackLeftBanked25DegDownToFlat<isClassic>;
        case TrackElemType::RightBankedDown25ToFlat:
            return WoodenRCTrackRightBanked25DegDownToFlat<isClassic>;
        case TrackElemType::Booster:
            return WoodenRCTrackBooster<isClassic>;
        case TrackElemType::DiagBrakes:
            return WoodenRCTrackDiagBrakes<isClassic>;
        case TrackElemType::DiagBlockBrakes:
            return WoodenRCTrackDiagBlockBrakes<isClassic>;
    }
    return nullptr;
}

TRACK_PAINT_FUNCTION GetTrackPaintFunctionWoodenRC(int32_t trackType)
{
    return GetTrackPaintFunctionWoodenAndClassicWoodenRC<false>(trackType);
}

TRACK_PAINT_FUNCTION GetTrackPaintFunctionClassicWoodenRCFallback(int32_t trackType)
{
    return GetTrackPaintFunctionWoodenAndClassicWoodenRC<true>(trackType);
}
