/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.fastq;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.fastq.FastqRecord;
import htsjdk.samtools.util.SequenceUtil;
import java.io.IOException;

public final class FastqEncoder {
    private FastqEncoder() {
    }

    public static String encode(FastqRecord record) {
        int capacity = record.getReadLength() * 2 + 5;
        if (record.getReadName() != null) {
            capacity += record.getReadName().length();
        }
        return FastqEncoder.write(new StringBuilder(capacity), record).toString();
    }

    public static Appendable write(Appendable out, FastqRecord record) {
        String readName = record.getReadName();
        String readString = record.getReadString();
        String qualHeader = record.getBaseQualityHeader();
        String qualityString = record.getBaseQualityString();
        try {
            return out.append("@").append(readName == null ? "" : readName).append('\n').append(readString == null ? "" : readString).append('\n').append("+").append(qualHeader == null ? "" : qualHeader).append('\n').append(qualityString == null ? "" : qualityString);
        }
        catch (IOException e) {
            throw new SAMException(e);
        }
    }

    public static String encode(SAMRecord record) {
        return FastqEncoder.encode(FastqEncoder.asFastqRecord(record));
    }

    public static FastqRecord asFastqRecord(SAMRecord record) {
        String readName = record.getReadName();
        if (record.getReadPairedFlag() && (record.getFirstOfPairFlag() || record.getSecondOfPairFlag())) {
            readName = readName + (record.getFirstOfPairFlag() ? "/1" : "/2");
        }
        return new FastqRecord(readName, record.getReadString(), null, record.getBaseQualityString());
    }

    public static SAMRecord asSAMRecord(FastqRecord record, SAMFileHeader header) {
        SAMRecord samRecord = new SAMRecord(header);
        samRecord.setReadUnmappedFlag(true);
        String readName = SequenceUtil.getSamReadNameFromFastqHeader(record.getReadName());
        samRecord.setReadName(readName);
        samRecord.setReadBases(record.getReadBases());
        samRecord.setBaseQualities(record.getBaseQualities());
        return samRecord;
    }
}

