/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.LineReader;
import java.io.BufferedWriter;

public class SAMSequenceDictionaryCodec {
    private static final SAMFileHeader EMPTY_HEADER = new SAMFileHeader();
    private final SAMTextHeaderCodec codec = new SAMTextHeaderCodec();

    public SAMSequenceDictionaryCodec(BufferedWriter writer) {
        this.codec.setmFileHeader(EMPTY_HEADER);
        this.codec.setWriter(writer);
    }

    public void encodeSequenceRecord(SAMSequenceRecord sequenceRecord) {
        this.codec.encodeSequenceRecord(sequenceRecord);
    }

    public void encodeHeaderLine(boolean keepExistingVersionNumber) {
        this.codec.encodeHeaderLine(keepExistingVersionNumber);
    }

    public SAMSequenceDictionary decode(LineReader reader, String source) {
        return this.codec.decode(reader, source).getSequenceDictionary();
    }

    public void encode(SAMSequenceDictionary dictionary) {
        this.codec.encodeHeaderLine(false);
        dictionary.getSequences().forEach(this::encodeSequenceRecord);
    }

    public void setValidationStringency(ValidationStringency validationStringency) {
        this.codec.setValidationStringency(validationStringency);
    }
}

