.\" dpkg manual page - dpkg-deb(1)
.\"
.\" Copyright © 1995-1996 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 1999 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2006 Frank Lichtenheld <djpig@debian.org>
.\" Copyright © 2007-2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.TH dpkg\-deb 1 "%RELEASE_DATE%" "%VERSION%" "dpkg suite"
.nh
.SH NAME
dpkg\-deb \- Debian package archive (.deb) manipulation tool
.
.SH SYNOPSIS
.B dpkg\-deb
.RI [ option "...] " command
.
.SH DESCRIPTION
.B dpkg\-deb
packs, unpacks and provides information about Debian archives.
.PP
Use
.B dpkg
to install and remove packages from your system.
.PP
You can also invoke
.B dpkg\-deb
by calling
.B dpkg
with whatever options you want to pass to
.BR dpkg\-deb ". " dpkg
will spot that you wanted
.B dpkg\-deb
and run it for you.
.PP
For most commands taking an input archive argument, the archive can be
read from standard input if the archive name is given as a single minus
character («\fB\-\fP»); otherwise lack of support will be documented in
their respective command description.
.
.SH COMMANDS
.TP
.BR \-b ", " \-\-build " \fIbinary-directory\fP [\fIarchive\fP|\fIdirectory\fP]"
Creates a debian archive from the filesystem tree stored in
.IR binary-directory ". " binary-directory
must have a
.B DEBIAN
subdirectory, which contains the control information files such
as the control file itself. This directory will
.I not
appear in the binary package's filesystem archive, but instead
the files in it will be put in the binary package's control
information area.

Unless you specify
.BR \-\-nocheck ", " dpkg\-deb
will read
.B DEBIAN/control
and parse it. It will check the file for syntax errors and other problems,
and display the name of the binary package being built.
.B dpkg\-deb
will also check the permissions of the maintainer scripts and other
files found in the
.B DEBIAN
control information directory.

If no
.I archive
is specified then
.B dpkg\-deb
will write the package into the file
.IR binary-directory \fB.deb\fR.

If the archive to be created already exists it will be overwritten.

If the second argument is a directory then
.B dpkg\-deb
will write to the file
.IB directory / package _ version _ arch .deb.
When a target directory is specified, rather than a file, the
.B \-\-nocheck
option may not be used (since
.B dpkg\-deb
needs to read and parse the package control file to determine which
filename to use).
.TP
.BR \-I ", " \-\-info " \fIarchive\fP [\fIcontrol-file-name\fP...]"
Provides information about a binary package archive.

If no
.IR control-file-name s
are specified then it will print a summary of the contents of the
package as well as its control file.

If any
.IR control-file-name s
are specified then
.B dpkg\-deb
will print them in the order they were specified; if any of the
components weren't present it will print an error message to stderr
about each one and exit with status 2.
.TP
.BR \-W ", " \-\-show " \fIarchive\fP"
Provides information about a binary package archive in the format
specified by the
.B \-\-showformat
argument. The default format displays the package's name and version
on one line, separated by a tabulator.
.TP
.BR \-f ", " \-\-field " \fIarchive\fP [\fIcontrol-field-name\fP...]"
Extracts control file information from a binary package archive.

If no
.IR control-field-name s
are specified then it will print the whole control file.

If any are specified then
.B dpkg\-deb
will print their contents, in the order in which they appear in the
control file. If more than one
.IR control-field-name
is specified then
.B dpkg\-deb
will precede each with its field name (and a colon and space).

No errors are reported for fields requested but not found.
.TP
.BR \-c ", " \-\-contents " \fIarchive\fP"
Lists the contents of the filesystem tree archive portion of the
package archive. It is currently produced in the format generated by
.BR tar 's
verbose listing.
.TP
.BR \-x ", " \-\-extract " \fIarchive directory\fP"
Extracts the filesystem tree from a package archive into the specified
directory.

Note that extracting a package to the root directory will
.I not
result in a correct installation! Use
.B dpkg
to install packages.

.I directory
(but not its parents) will be created if necessary, and its permissions
modified to match the contents of the package.
.TP
.BR \-X ", " \-\-vextract " \fIarchive directory\fP"
Is like
.BR \-\-extract " (" \-x ")"
with
.BR \-\-verbose " (" \-v ")"
which prints a listing of the files extracted as it goes.
.TP
.BR \-R ", " \-\-raw\-extract " \fIarchive directory\fP"
Extracts the filesystem tree from a package archive into a specified
directory, and the control information files into a
.B DEBIAN
subdirectory of the specified directory (since dpkg 1.16.1).

The target directory (but not its parents) will be created if necessary.

The input archive is not (currently) processed sequentially, so reading
it from standard input («\fB\-\fP») is \fBnot\fP supported.
.TP
.BR \-\-ctrl\-tarfile " \fIarchive\fP"
Extracts the control data from a binary package and sends it to standard
output in
.B tar
format (since dpkg 1.17.14). Together with
.BR tar (1)
this can be used to extract a particular control file from a package archive.
The input archive will always be processed sequentially.
.TP
.BR \-\-fsys\-tarfile " \fIarchive\fP"
Extracts the filesystem tree data from a binary package and sends it
to standard output in
.B tar
format. Together with
.BR tar (1)
this can be used to extract a particular file from a package archive.
The input archive will always be processed sequentially.
.TP
.BR \-e ", " \-\-control " \fIarchive\fP [\fIdirectory\fP]"
Extracts the control information files from a package archive into the
specified directory.

If no directory is specified then a subdirectory
.B DEBIAN
in the current directory is used.

The target directory (but not its parents) will be created if
necessary.
.TP
.BR \-? ", " \-\-help
Show the usage message and exit.
.TP
.B \-\-version
Show the version and exit.
.
.SH OPTIONS
.TP
\fB\-\-showformat=\fP\fIformat\fR
This option is used to specify the format of the output \fB\-\-show\fP
will produce. The format is a string that will be output for each package
listed.

The string may reference any status field using the
“${\fIfield-name\fR}” form, a list of the valid fields can be easily
produced using
.B \-I
on the same package. A complete explanation of the formatting options
(including escape sequences and field tabbing) can be found in the
explanation of the \fB\-\-showformat\fP option in
.BR dpkg\-query (1).

The default for this field is “${Package}\\t${Version}\\n”.
.TP
.BI \-z compress-level
Specify which compression level to use on the compressor backend, when
building a package (default is 9 for gzip, 6 for xz and 19 for zstd).
The accepted values are 0-9 with: 0 being mapped to compressor none for gzip.
Before dpkg 1.16.2 level 0 was equivalent to compressor none for all
compressors.
.TP
.BI \-S compress-strategy
Specify which compression strategy to use on the compressor backend, when
building a package (since dpkg 1.16.2). Allowed values are \fBnone\fP (since
dpkg 1.16.4), \fBfiltered\fP, \fBhuffman\fP, \fBrle\fP and \fBfixed\fP for
gzip (since dpkg 1.17.0) and \fBextreme\fP for xz.
.TP
.BI \-Z compress-type
Specify which compression type to use when building a package.
Allowed values are \fBgzip\fP, \fBxz\fP (since dpkg 1.15.6),
and \fBnone\fP (default is \fBxz\fP).
.TP
.B \-\-[no\-]uniform\-compression
Specify that the same compression parameters should be used for all archive
members (i.e. \fBcontrol.tar\fP and \fBdata.tar\fP; since dpkg 1.17.6).
Otherwise only the
\fBdata.tar\fP member will use those parameters. The only supported
compression types allowed to be uniformly used are \fBnone\fP, \fBgzip\fP
and \fBxz\fP.
The \fB\-\-no\-uniform\-compression\fP option disables uniform compression
(since dpkg 1.19.0).
Uniform compression is the default (since dpkg 1.19.0).
.TP
.B \-\-root\-owner\-group
Set the owner and group for each entry in the filesystem tree data to
root with id 0 (since dpkg 1.19.0).

\fBNote\fP: This option can be useful for rootless builds (see
\fIrootless\-builds.txt\fP), but should \fBnot\fP be used when the
entries have an owner or group that is not root.
Support for these will be added later in the form of a meta manifest.
.TP
.BI \-\-deb\-format= format
Set the archive format version used when building (since dpkg 1.17.0).
Allowed values are \fB2.0\fP for the new format, and \fB0.939000\fP
for the old one (default is \fB2.0\fP).

The old archive format is less easily parsed by non-Debian tools and is
now obsolete; its only use is when building packages to be parsed by
versions of dpkg older than 0.93.76 (September 1995), which was released
as i386 a.out only.
.TP
.B \-\-nocheck
Inhibits
.BR "dpkg\-deb \-\-build" 's
usual checks on the proposed contents of an archive. You can build
any archive you want, no matter how broken, this way.
.TP
.BR \-v ", " \-\-verbose
Enables verbose output (since dpkg 1.16.1).
This currently only affects \fB\-\-extract\fP making it behave like
\fB\-\-vextract\fP.
.TP
.BR \-D ", " \-\-debug
Enables debugging output. This is not very interesting.
.
.SH EXIT STATUS
.TP
.B 0
The requested action was successfully performed.
.TP
.B 2
Fatal or unrecoverable error due to invalid command-line usage, or
interactions with the system, such as accesses to the database,
memory allocations, etc.
.
.SH ENVIRONMENT
.TP
.B DPKG_COLORS
Sets the color mode (since dpkg 1.18.5).
The currently accepted values are: \fBauto\fP (default), \fBalways\fP and
\fBnever\fP.
.TP
.B TMPDIR
If set, \fBdpkg\-deb\fP will use it as the directory in which to create
temporary files and directories.
.TP
.B SOURCE_DATE_EPOCH
If set, it will be used as the timestamp (as seconds since the epoch) in
the \fBdeb\fP(5)'s \fBar\fP(5) container and used to clamp the mtime in
the \fBtar\fP(5) file entries.
.
.SH NOTES
Do not attempt to use just
.B dpkg\-deb
to install software! You must use
.B dpkg
proper to ensure that all the files are correctly placed and the
package's scripts run and its status and contents recorded.
.
.SH BUGS
.B dpkg\-deb \-I
.IB package1 .deb
.IB package2 .deb
does the wrong thing.

There is no authentication on
.B .deb
files; in fact, there isn't even a straightforward checksum.
(Higher level tools like APT support authenticating \fB.deb\fP packages
retrieved from a given repository, and most packages nowadays provide an
md5sum control file generated by debian/rules. Though this is not directly
supported by the lower level tools.)
.
.SH SEE ALSO
.BR deb (5),
.BR deb\-control (5),
.BR dpkg (1),
.BR dselect (1).
