/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.search;

import com.dickimawbooks.texparserlib.AssignedMacro;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.search.SearchMatcher;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ControlSequenceMatcher
implements SearchMatcher {
    private Pattern pattern;
    private int flags;
    public static final int FLAG_PROCESS = 1;
    public static final int FLAG_EXPANSION = 2;

    public ControlSequenceMatcher(Pattern pattern) {
        this(pattern, 3);
    }

    public ControlSequenceMatcher(Pattern pattern, int n) {
        this.pattern = pattern;
        this.flags = n;
    }

    @Override
    public boolean isMatch(Object object) {
        if (!(object instanceof ControlSequence)) {
            return false;
        }
        ControlSequence controlSequence = (ControlSequence)object;
        Matcher matcher = this.pattern.matcher(controlSequence.getName());
        if (matcher.matches()) {
            return true;
        }
        if (controlSequence instanceof AssignedMacro) {
            return this.isMatch(((AssignedMacro)((Object)controlSequence)).getUnderlying());
        }
        return false;
    }

    public int getFlags() {
        return this.flags;
    }

    public String toString() {
        return String.format("%s[pattern=%s,flags=%d]", this.getClass().getSimpleName(), this.pattern, this.flags);
    }
}

