/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.xds.XdsNameResolverProvider;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class SharedCallCounterMap
implements XdsNameResolverProvider.CallCounterProvider {
    private final ReferenceQueue<AtomicLong> refQueue = new ReferenceQueue();
    private final Map<String, Map<String, CounterReference>> counters;

    private SharedCallCounterMap() {
        this(new HashMap<String, Map<String, CounterReference>>());
    }

    @VisibleForTesting
    SharedCallCounterMap(Map<String, Map<String, CounterReference>> counters) {
        this.counters = (Map)Preconditions.checkNotNull(counters, (Object)"counters");
    }

    static SharedCallCounterMap getInstance() {
        return SharedCallCounterMapHolder.instance;
    }

    @Override
    public synchronized AtomicLong getOrCreate(String cluster, @Nullable String edsServiceName) {
        Map<String, CounterReference> clusterCounters = this.counters.get(cluster);
        if (clusterCounters == null) {
            clusterCounters = new HashMap<String, CounterReference>();
            this.counters.put(cluster, clusterCounters);
        }
        CounterReference ref = clusterCounters.get(edsServiceName);
        AtomicLong counter = null;
        if (ref != null && (counter = (AtomicLong)ref.get()) == null) {
            ref.enqueue();
        }
        if (counter == null) {
            counter = new AtomicLong();
            ref = new CounterReference(counter, this.refQueue, cluster, edsServiceName);
            clusterCounters.put(edsServiceName, ref);
        }
        this.cleanQueue();
        return counter;
    }

    @VisibleForTesting
    void cleanQueue() {
        CounterReference ref;
        while ((ref = (CounterReference)this.refQueue.poll()) != null) {
            Map<String, CounterReference> clusterCounter = this.counters.get(ref.cluster);
            if (clusterCounter.get(ref.edsServiceName) != ref) continue;
            clusterCounter.remove(ref.edsServiceName);
            if (!clusterCounter.isEmpty()) continue;
            this.counters.remove(ref.cluster);
        }
    }

    private static final class SharedCallCounterMapHolder {
        private static final SharedCallCounterMap instance = new SharedCallCounterMap();

        private SharedCallCounterMapHolder() {
        }
    }

    @VisibleForTesting
    static final class CounterReference
    extends WeakReference<AtomicLong> {
        private final String cluster;
        @Nullable
        private final String edsServiceName;

        CounterReference(AtomicLong counter, ReferenceQueue<AtomicLong> refQueue, String cluster, @Nullable String edsServiceName) {
            super(counter, refQueue);
            this.cluster = cluster;
            this.edsServiceName = edsServiceName;
        }
    }
}

