/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j;

import dev.ai4j.openai4j.Utils;
import java.io.IOException;
import java.util.function.Function;
import retrofit2.Call;
import retrofit2.Response;

class SyncRequestExecutor<Response, ResponseContent> {
    private final Call<Response> call;
    private final Function<Response, ResponseContent> responseContentExtractor;

    SyncRequestExecutor(Call<Response> call, Function<Response, ResponseContent> responseContentExtractor) {
        this.call = call;
        this.responseContentExtractor = responseContentExtractor;
    }

    ResponseContent execute() {
        try {
            Response retrofitResponse = this.call.execute();
            if (retrofitResponse.isSuccessful()) {
                Object response = retrofitResponse.body();
                return this.responseContentExtractor.apply(response);
            }
            throw Utils.toException(retrofitResponse);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

