/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.simpletext.SimpleTextStoredFieldsWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;

public class SimpleTextStoredFieldsReader
extends StoredFieldsReader {
    private long[] offsets;
    private IndexInput in;
    private BytesRefBuilder scratch = new BytesRefBuilder();
    private CharsRefBuilder scratchUTF16 = new CharsRefBuilder();
    private final FieldInfos fieldInfos;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleTextStoredFieldsReader(Directory directory, SegmentInfo si, FieldInfos fn, IOContext context) throws IOException {
        this.fieldInfos = fn;
        boolean success = false;
        try {
            this.in = directory.openInput(IndexFileNames.segmentFileName((String)si.name, (String)"", (String)"fld"), context);
            success = true;
        }
        finally {
            if (!success) {
                try {
                    this.close();
                }
                catch (Throwable throwable) {}
            }
        }
        this.readIndex(si.maxDoc());
    }

    SimpleTextStoredFieldsReader(long[] offsets, IndexInput in, FieldInfos fieldInfos) {
        this.offsets = offsets;
        this.in = in;
        this.fieldInfos = fieldInfos;
    }

    private void readIndex(int size) throws IOException {
        BufferedChecksumIndexInput input = new BufferedChecksumIndexInput(this.in);
        this.offsets = new long[size];
        int upto = 0;
        while (!this.scratch.get().equals((Object)SimpleTextStoredFieldsWriter.END)) {
            SimpleTextUtil.readLine((DataInput)input, this.scratch);
            if (!StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextStoredFieldsWriter.DOC)) continue;
            this.offsets[upto] = input.getFilePointer();
            ++upto;
        }
        SimpleTextUtil.checkFooter((ChecksumIndexInput)input);
        assert (upto == this.offsets.length);
    }

    public void document(int n, StoredFieldVisitor visitor) throws IOException {
        this.in.seek(this.offsets[n]);
        block5: while (true) {
            BytesRef type;
            this.readLine();
            if (!StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextStoredFieldsWriter.FIELD)) break;
            int fieldNumber = this.parseIntAt(SimpleTextStoredFieldsWriter.FIELD.length);
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(fieldNumber);
            this.readLine();
            assert (StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextStoredFieldsWriter.NAME));
            this.readLine();
            assert (StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextStoredFieldsWriter.TYPE));
            if (this.equalsAt(SimpleTextStoredFieldsWriter.TYPE_STRING, this.scratch.get(), SimpleTextStoredFieldsWriter.TYPE.length)) {
                type = SimpleTextStoredFieldsWriter.TYPE_STRING;
            } else if (this.equalsAt(SimpleTextStoredFieldsWriter.TYPE_BINARY, this.scratch.get(), SimpleTextStoredFieldsWriter.TYPE.length)) {
                type = SimpleTextStoredFieldsWriter.TYPE_BINARY;
            } else if (this.equalsAt(SimpleTextStoredFieldsWriter.TYPE_INT, this.scratch.get(), SimpleTextStoredFieldsWriter.TYPE.length)) {
                type = SimpleTextStoredFieldsWriter.TYPE_INT;
            } else if (this.equalsAt(SimpleTextStoredFieldsWriter.TYPE_LONG, this.scratch.get(), SimpleTextStoredFieldsWriter.TYPE.length)) {
                type = SimpleTextStoredFieldsWriter.TYPE_LONG;
            } else if (this.equalsAt(SimpleTextStoredFieldsWriter.TYPE_FLOAT, this.scratch.get(), SimpleTextStoredFieldsWriter.TYPE.length)) {
                type = SimpleTextStoredFieldsWriter.TYPE_FLOAT;
            } else if (this.equalsAt(SimpleTextStoredFieldsWriter.TYPE_DOUBLE, this.scratch.get(), SimpleTextStoredFieldsWriter.TYPE.length)) {
                type = SimpleTextStoredFieldsWriter.TYPE_DOUBLE;
            } else {
                throw new RuntimeException("unknown field type");
            }
            switch (visitor.needsField(fieldInfo)) {
                case YES: {
                    this.readField(type, fieldInfo, visitor);
                    break;
                }
                case NO: {
                    this.readLine();
                    assert (StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextStoredFieldsWriter.VALUE));
                    continue block5;
                }
                case STOP: {
                    return;
                }
            }
        }
    }

    private void readField(BytesRef type, FieldInfo fieldInfo, StoredFieldVisitor visitor) throws IOException {
        this.readLine();
        assert (StringHelper.startsWith((BytesRef)this.scratch.get(), (BytesRef)SimpleTextStoredFieldsWriter.VALUE));
        if (type == SimpleTextStoredFieldsWriter.TYPE_STRING) {
            byte[] bytes = new byte[this.scratch.length() - SimpleTextStoredFieldsWriter.VALUE.length];
            System.arraycopy(this.scratch.bytes(), SimpleTextStoredFieldsWriter.VALUE.length, bytes, 0, bytes.length);
            visitor.stringField(fieldInfo, new String(bytes, StandardCharsets.UTF_8));
        } else if (type == SimpleTextStoredFieldsWriter.TYPE_BINARY) {
            byte[] copy = new byte[this.scratch.length() - SimpleTextStoredFieldsWriter.VALUE.length];
            System.arraycopy(this.scratch.bytes(), SimpleTextStoredFieldsWriter.VALUE.length, copy, 0, copy.length);
            visitor.binaryField(fieldInfo, copy);
        } else if (type == SimpleTextStoredFieldsWriter.TYPE_INT) {
            this.scratchUTF16.copyUTF8Bytes(this.scratch.bytes(), SimpleTextStoredFieldsWriter.VALUE.length, this.scratch.length() - SimpleTextStoredFieldsWriter.VALUE.length);
            visitor.intField(fieldInfo, Integer.parseInt(this.scratchUTF16.toString()));
        } else if (type == SimpleTextStoredFieldsWriter.TYPE_LONG) {
            this.scratchUTF16.copyUTF8Bytes(this.scratch.bytes(), SimpleTextStoredFieldsWriter.VALUE.length, this.scratch.length() - SimpleTextStoredFieldsWriter.VALUE.length);
            visitor.longField(fieldInfo, Long.parseLong(this.scratchUTF16.toString()));
        } else if (type == SimpleTextStoredFieldsWriter.TYPE_FLOAT) {
            this.scratchUTF16.copyUTF8Bytes(this.scratch.bytes(), SimpleTextStoredFieldsWriter.VALUE.length, this.scratch.length() - SimpleTextStoredFieldsWriter.VALUE.length);
            visitor.floatField(fieldInfo, Float.parseFloat(this.scratchUTF16.toString()));
        } else if (type == SimpleTextStoredFieldsWriter.TYPE_DOUBLE) {
            this.scratchUTF16.copyUTF8Bytes(this.scratch.bytes(), SimpleTextStoredFieldsWriter.VALUE.length, this.scratch.length() - SimpleTextStoredFieldsWriter.VALUE.length);
            visitor.doubleField(fieldInfo, Double.parseDouble(this.scratchUTF16.toString()));
        }
    }

    public StoredFieldsReader clone() {
        if (this.in == null) {
            throw new AlreadyClosedException("this FieldsReader is closed");
        }
        return new SimpleTextStoredFieldsReader(this.offsets, this.in.clone(), this.fieldInfos);
    }

    public void close() throws IOException {
        try {
            IOUtils.close((Closeable[])new Closeable[]{this.in});
        }
        finally {
            this.in = null;
            this.offsets = null;
        }
    }

    private void readLine() throws IOException {
        SimpleTextUtil.readLine((DataInput)this.in, this.scratch);
    }

    private int parseIntAt(int offset) {
        this.scratchUTF16.copyUTF8Bytes(this.scratch.bytes(), offset, this.scratch.length() - offset);
        return ArrayUtil.parseInt((char[])this.scratchUTF16.chars(), (int)0, (int)this.scratchUTF16.length());
    }

    private boolean equalsAt(BytesRef a, BytesRef b, int bOffset) {
        return a.length == b.length - bOffset && Arrays.equals(a.bytes, a.offset, a.offset + a.length, b.bytes, b.offset + bOffset, b.offset + b.length);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public void checkIntegrity() throws IOException {
    }
}

