/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.eq.FieldEqualitor;
import org.apache.solr.client.solrj.io.eq.StreamEqualitor;
import org.apache.solr.client.solrj.io.stream.PushBackStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.UniqueStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ComplementStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private PushBackStream streamA;
    private PushBackStream streamB;
    private TupleStream originalStreamB;
    private StreamEqualitor eq;

    public ComplementStream(TupleStream streamA, TupleStream streamB, StreamEqualitor eq) throws IOException {
        this.init(streamA, streamB, eq);
    }

    public ComplementStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        StreamExpressionNamedParameter onExpression = factory.getNamedOperand(expression, "on");
        if (expression.getParameters().size() != streamExpressions.size() + 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found", expression));
        }
        if (2 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting two streams but found %d (must be TupleStream types)", expression, streamExpressions.size()));
        }
        if (null == onExpression || !(onExpression.getParameter() instanceof StreamExpressionValue)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting single 'on' parameter listing fields to merge on but didn't find one", expression));
        }
        this.init(factory.constructStream(streamExpressions.get(0)), factory.constructStream(streamExpressions.get(1)), factory.constructEqualitor(((StreamExpressionValue)onExpression.getParameter()).getValue(), FieldEqualitor.class));
    }

    private void init(TupleStream streamA, TupleStream streamB, StreamEqualitor eq) throws IOException {
        this.streamA = new PushBackStream(streamA);
        this.streamB = new PushBackStream(new UniqueStream(streamB, eq));
        this.originalStreamB = streamB;
        this.eq = eq;
        if (!eq.isDerivedFrom(streamA.getStreamSort()) || !eq.isDerivedFrom(streamB.getStreamSort())) {
            throw new IOException("Invalid ComplementStream - both substream comparators (sort) must be a superset of this stream's equalitor.");
        }
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        if (includeStreams) {
            if (this.streamA == null) {
                throw new IOException("This IntersectionStream contains a non-expressible TupleStream - it cannot be converted to an expression");
            }
            expression.addParameter(this.streamA.toExpression(factory));
            if (!(this.originalStreamB instanceof Expressible)) throw new IOException("This IntersectStream contains a non-expressible TupleStream - it cannot be converted to an expression");
            expression.addParameter(((Expressible)((Object)this.originalStreamB)).toExpression(factory));
        } else {
            expression.addParameter("<stream>");
            expression.addParameter("<stream>");
        }
        expression.addParameter(new StreamExpressionNamedParameter("on", this.eq.toExpression(factory)));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new StreamExplanation(this.getStreamNodeId().toString()).withChildren(new Explanation[]{this.streamA.toExplanation(factory), this.originalStreamB.toExplanation(factory)}).withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpressionType("stream-decorator").withExpression(this.toExpression(factory, false).toString()).withHelper(this.eq.toExplanation(factory));
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.streamA.setStreamContext(context);
        this.streamB.setStreamContext(context);
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.streamA);
        l.add(this.streamB);
        return l;
    }

    @Override
    public void open() throws IOException {
        this.streamA.open();
        this.streamB.open();
    }

    @Override
    public void close() throws IOException {
        this.streamA.close();
        this.streamB.close();
    }

    @Override
    public Tuple read() throws IOException {
        while (true) {
            Tuple a = this.streamA.read();
            Tuple b = this.streamB.read();
            if (a.EOF) {
                return a;
            }
            if (b.EOF) {
                this.streamB.pushBack(b);
                return a;
            }
            if (!this.eq.test(a, b) && this.streamA.getStreamSort().compare(a, b) < 0) {
                this.streamB.pushBack(b);
                return a;
            }
            if (this.eq.test(a, b)) {
                this.streamB.pushBack(b);
                continue;
            }
            this.streamA.pushBack(a);
        }
    }

    @Override
    public StreamComparator getStreamSort() {
        return this.streamA.getStreamSort();
    }

    @Override
    public int getCost() {
        return 0;
    }
}

