/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

public strictfp final class R1Interval {
    private final double lo;
    private final double hi;

    public R1Interval(double lo, double hi) {
        this.lo = lo;
        this.hi = hi;
    }

    public static R1Interval empty() {
        return new R1Interval(1.0, 0.0);
    }

    public static R1Interval fromPoint(double p) {
        return new R1Interval(p, p);
    }

    public static R1Interval fromPointPair(double p1, double p2) {
        if (p1 <= p2) {
            return new R1Interval(p1, p2);
        }
        return new R1Interval(p2, p1);
    }

    public double lo() {
        return this.lo;
    }

    public double hi() {
        return this.hi;
    }

    public boolean isEmpty() {
        return this.lo() > this.hi();
    }

    public double getCenter() {
        return 0.5 * (this.lo() + this.hi());
    }

    public double getLength() {
        return this.hi() - this.lo();
    }

    public boolean contains(double p) {
        return p >= this.lo() && p <= this.hi();
    }

    public boolean interiorContains(double p) {
        return p > this.lo() && p < this.hi();
    }

    public boolean contains(R1Interval y) {
        if (y.isEmpty()) {
            return true;
        }
        return y.lo() >= this.lo() && y.hi() <= this.hi();
    }

    public boolean interiorContains(R1Interval y) {
        if (y.isEmpty()) {
            return true;
        }
        return y.lo() > this.lo() && y.hi() < this.hi();
    }

    public boolean intersects(R1Interval y) {
        if (this.lo() <= y.lo()) {
            return y.lo() <= this.hi() && y.lo() <= y.hi();
        }
        return this.lo() <= y.hi() && this.lo() <= this.hi();
    }

    public boolean interiorIntersects(R1Interval y) {
        return y.lo() < this.hi() && this.lo() < y.hi() && this.lo() < this.hi() && y.lo() <= y.hi();
    }

    public R1Interval addPoint(double p) {
        if (this.isEmpty()) {
            return R1Interval.fromPoint(p);
        }
        if (p < this.lo()) {
            return new R1Interval(p, this.hi());
        }
        if (p > this.hi()) {
            return new R1Interval(this.lo(), p);
        }
        return new R1Interval(this.lo(), this.hi());
    }

    public R1Interval expanded(double radius) {
        if (this.isEmpty()) {
            return this;
        }
        return new R1Interval(this.lo() - radius, this.hi() + radius);
    }

    public R1Interval union(R1Interval y) {
        if (this.isEmpty()) {
            return y;
        }
        if (y.isEmpty()) {
            return this;
        }
        return new R1Interval(Math.min(this.lo(), y.lo()), Math.max(this.hi(), y.hi()));
    }

    public R1Interval intersection(R1Interval y) {
        return new R1Interval(Math.max(this.lo(), y.lo()), Math.min(this.hi(), y.hi()));
    }

    public boolean equals(Object that) {
        if (that instanceof R1Interval) {
            R1Interval y = (R1Interval)that;
            return this.lo() == y.lo() && this.hi() == y.hi() || this.isEmpty() && y.isEmpty();
        }
        return false;
    }

    public int hashCode() {
        if (this.isEmpty()) {
            return 17;
        }
        long value = 17L;
        value = 37L * value + Double.doubleToLongBits(this.lo);
        value = 37L * value + Double.doubleToLongBits(this.hi);
        return (int)(value ^ value >>> 32);
    }

    public boolean approxEquals(R1Interval y) {
        return this.approxEquals(y, 1.0E-15);
    }

    public boolean approxEquals(R1Interval y, double maxError) {
        if (this.isEmpty()) {
            return y.getLength() <= maxError;
        }
        if (y.isEmpty()) {
            return this.getLength() <= maxError;
        }
        return Math.abs(y.lo() - this.lo()) + Math.abs(y.hi() - this.hi()) <= maxError;
    }

    public String toString() {
        return "[" + this.lo() + ", " + this.hi() + "]";
    }
}

