/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.circuitbreaker;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.util.SolrPluginUtils;
import org.apache.solr.util.circuitbreaker.CircuitBreakerManager;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;

public abstract class CircuitBreaker
implements NamedListInitializedPlugin,
Closeable {
    private Set<SolrRequest.SolrRequestType> requestTypes = Set.of(SolrRequest.SolrRequestType.QUERY);
    private boolean warnOnly;
    private final List<SolrRequest.SolrRequestType> SUPPORTED_TYPES = List.of(SolrRequest.SolrRequestType.QUERY, SolrRequest.SolrRequestType.UPDATE);

    @Override
    public void init(NamedList<?> args) {
        SolrPluginUtils.invokeSetters(this, args);
        if (args.getBooleanArg("warnOnly") != null) {
            this.setWarnOnly(args.getBooleanArg("warnOnly"));
        }
    }

    public abstract boolean isTripped();

    public abstract String getErrorMessage();

    @Override
    public void close() throws IOException {
    }

    public void setRequestTypes(List<String> requestTypes) {
        this.requestTypes = requestTypes.stream().map(t -> SolrRequest.SolrRequestType.valueOf((String)t.toUpperCase(Locale.ROOT))).peek(t -> {
            if (!this.SUPPORTED_TYPES.contains(t)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Request type %s is not supported for circuit breakers", t.name()));
            }
        }).collect(Collectors.toSet());
    }

    public void setWarnOnly(boolean warnOnly) {
        this.warnOnly = warnOnly;
    }

    public boolean isWarnOnly() {
        return this.warnOnly;
    }

    public Set<SolrRequest.SolrRequestType> getRequestTypes() {
        return this.requestTypes;
    }

    @Deprecated(since="9.4")
    public static SolrException.ErrorCode getErrorCode(List<CircuitBreaker> trippedCircuitBreakers) {
        if (trippedCircuitBreakers != null && trippedCircuitBreakers.stream().anyMatch(cb -> cb instanceof CircuitBreakerManager)) {
            return SolrException.ErrorCode.SERVICE_UNAVAILABLE;
        }
        return SolrException.ErrorCode.TOO_MANY_REQUESTS;
    }
}

