/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.passay.PasswordData;
import org.passay.Rule;
import org.passay.RuleResult;

public class RepeatCharactersRule
implements Rule {
    public static final String ERROR_CODE = "ILLEGAL_REPEATED_CHARS";
    public static final int DEFAULT_SEQUENCE_LENGTH = 5;
    public static final int DEFAULT_SEQUENCE_COUNT = 1;
    protected int sequenceLength;
    protected int sequenceCount;

    public RepeatCharactersRule() {
        this(5);
    }

    public RepeatCharactersRule(int sl) {
        this(sl, 1);
    }

    public RepeatCharactersRule(int sl, int sc) {
        if (sl < 2 || sc < 1) {
            throw new IllegalArgumentException("invalid sequence length or sequence count");
        }
        this.sequenceLength = sl;
        this.sequenceCount = sc;
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult();
        ArrayList<String> matches = new ArrayList<String>();
        String password = passwordData.getPassword() + '\uffff';
        int max = password.length() - 1;
        int count = 0;
        int repeat = 1;
        int n = -1;
        for (int i = 0; i <= max; ++i) {
            char c;
            char c2 = password.charAt(i);
            if (c2 == c) {
                ++repeat;
            } else {
                if (repeat >= this.sequenceLength) {
                    String match = password.substring(i - repeat, i);
                    matches.add(match);
                    ++count;
                }
                repeat = 1;
            }
            c = c2;
        }
        if (count >= this.sequenceCount) {
            result.addError(ERROR_CODE, this.createRuleResultDetailParameters(matches));
        }
        return result;
    }

    protected Map<String, Object> createRuleResultDetailParameters(List<String> matches) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("sequenceLength", this.sequenceLength);
        m.put("sequenceCount", this.sequenceCount);
        m.put("matchesCount", matches.size());
        m.put("matches", matches);
        return m;
    }
}

