"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCompressedSuperSelect = exports.EuiSuperSelect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _accessibility = require("../../accessibility");
var _super_select_control = require("./super_select_control");
var _popover = require("../../popover");
var _context_menu = require("../../context_menu");
var _services = require("../../../services");
var _i18n = require("../../i18n");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) { "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); } return f; })(e, t); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _createSuper(t) { var r = _isNativeReflectConstruct(); return function () { var e, o = _getPrototypeOf(t); if (r) { var s = _getPrototypeOf(this).constructor; e = Reflect.construct(o, arguments, s); } else e = o.apply(this, arguments); return _possibleConstructorReturn(this, e); }; }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */ /*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var ShiftDirection;
(function (ShiftDirection) {
  ShiftDirection["BACK"] = "back";
  ShiftDirection["FORWARD"] = "forward";
})(ShiftDirection || (ShiftDirection = {}));
var EuiSuperSelect = /*#__PURE__*/function (_Component) {
  _inherits(EuiSuperSelect, _Component);
  var _super = _createSuper(EuiSuperSelect);
  function EuiSuperSelect() {
    var _this;
    _classCallCheck(this, EuiSuperSelect);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "itemNodes", []);
    _defineProperty(_assertThisInitialized(_this), "_isMounted", false);
    _defineProperty(_assertThisInitialized(_this), "state", {
      isPopoverOpen: _this.props.isOpen || false
    });
    _defineProperty(_assertThisInitialized(_this), "setItemNode", function (node, index) {
      _this.itemNodes[index] = node;
    });
    _defineProperty(_assertThisInitialized(_this), "openPopover", function () {
      _this.setState({
        isPopoverOpen: true
      });
      var focusSelected = function focusSelected() {
        var indexOfSelected = _this.props.options.reduce(function (indexOfSelected, option, index) {
          if (indexOfSelected != null) return indexOfSelected;
          if (option == null) return null;
          return option.value === _this.props.valueOfSelected ? index : null;
        }, null);
        requestAnimationFrame(function () {
          if (!_this._isMounted) {
            return;
          }
          if (_this.props.valueOfSelected != null) {
            if (indexOfSelected != null) {
              _this.focusItemAt(indexOfSelected);
            } else {
              focusSelected();
            }
          }
        });
      };
      requestAnimationFrame(focusSelected);
    });
    _defineProperty(_assertThisInitialized(_this), "closePopover", function () {
      _this.setState({
        isPopoverOpen: false
      });
    });
    _defineProperty(_assertThisInitialized(_this), "itemClicked", function (value) {
      _this.setState({
        isPopoverOpen: false
      });
      if (_this.props.onChange) {
        _this.props.onChange(value);
      }
    });
    _defineProperty(_assertThisInitialized(_this), "onSelectKeyDown", function (event) {
      if (event.key === _services.keys.ARROW_UP || event.key === _services.keys.ARROW_DOWN) {
        event.preventDefault();
        event.stopPropagation();
        _this.openPopover();
      }
    });
    _defineProperty(_assertThisInitialized(_this), "onItemKeyDown", function (event) {
      switch (event.key) {
        case _services.keys.ESCAPE:
          // close the popover and prevent ancestors from handling
          event.preventDefault();
          event.stopPropagation();
          _this.closePopover();
          break;
        case _services.keys.TAB:
          // no-op
          event.preventDefault();
          event.stopPropagation();
          break;
        case _services.keys.ARROW_UP:
          event.preventDefault();
          event.stopPropagation();
          _this.shiftFocus(ShiftDirection.BACK);
          break;
        case _services.keys.ARROW_DOWN:
          event.preventDefault();
          event.stopPropagation();
          _this.shiftFocus(ShiftDirection.FORWARD);
          break;
      }
    });
    return _this;
  }
  _createClass(EuiSuperSelect, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this._isMounted = true;
      if (this.props.isOpen) {
        this.openPopover();
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this._isMounted = false;
    }
  }, {
    key: "focusItemAt",
    value: function focusItemAt(index) {
      var targetElement = this.itemNodes[index];
      if (targetElement != null) {
        targetElement.focus();
      }
    }
  }, {
    key: "shiftFocus",
    value: function shiftFocus(direction) {
      var currentIndex = this.itemNodes.indexOf(document.activeElement);
      var targetElementIndex;
      if (currentIndex === -1) {
        // somehow the select options has lost focus
        targetElementIndex = 0;
      } else {
        if (direction === ShiftDirection.BACK) {
          targetElementIndex = currentIndex === 0 ? this.itemNodes.length - 1 : currentIndex - 1;
        } else {
          targetElementIndex = currentIndex === this.itemNodes.length - 1 ? 0 : currentIndex + 1;
        }
      }
      this.focusItemAt(targetElementIndex);
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props = this.props,
        className = _this$props.className,
        options = _this$props.options,
        valueOfSelected = _this$props.valueOfSelected,
        onChange = _this$props.onChange,
        isOpen = _this$props.isOpen,
        isInvalid = _this$props.isInvalid,
        hasDividers = _this$props.hasDividers,
        itemClassName = _this$props.itemClassName,
        itemLayoutAlign = _this$props.itemLayoutAlign,
        fullWidth = _this$props.fullWidth,
        popoverClassName = _this$props.popoverClassName,
        compressed = _this$props.compressed,
        rest = _objectWithoutProperties(_this$props, ["className", "options", "valueOfSelected", "onChange", "isOpen", "isInvalid", "hasDividers", "itemClassName", "itemLayoutAlign", "fullWidth", "popoverClassName", "compressed"]);
      var popoverClasses = (0, _classnames.default)('euiSuperSelect', popoverClassName);
      var buttonClasses = (0, _classnames.default)({
        'euiSuperSelect--isOpen__button': this.state.isPopoverOpen
      }, className);
      var itemClasses = (0, _classnames.default)('euiSuperSelect__item', {
        'euiSuperSelect__item--hasDividers': hasDividers
      }, itemClassName);
      var button = /*#__PURE__*/_react.default.createElement(_super_select_control.EuiSuperSelectControl, _extends({
        options: options,
        value: valueOfSelected,
        onClick: this.state.isPopoverOpen ? this.closePopover : this.openPopover,
        onKeyDown: this.onSelectKeyDown,
        className: buttonClasses,
        fullWidth: fullWidth,
        isInvalid: isInvalid,
        compressed: compressed
      }, rest));
      var items = options.map(function (option, index) {
        var value = option.value,
          dropdownDisplay = option.dropdownDisplay,
          inputDisplay = option.inputDisplay,
          optionRest = _objectWithoutProperties(option, ["value", "dropdownDisplay", "inputDisplay"]);
        return /*#__PURE__*/_react.default.createElement(_context_menu.EuiContextMenuItem, _extends({
          key: index,
          className: itemClasses,
          icon: valueOfSelected === value ? 'check' : 'empty',
          onClick: function onClick() {
            return _this2.itemClicked(value);
          },
          onKeyDown: _this2.onItemKeyDown,
          layoutAlign: itemLayoutAlign,
          buttonRef: function buttonRef(node) {
            return _this2.setItemNode(node, index);
          },
          role: "option",
          id: value,
          "aria-selected": valueOfSelected === value
        }, optionRest), dropdownDisplay || inputDisplay);
      });
      return /*#__PURE__*/_react.default.createElement(_popover.EuiInputPopover, {
        className: popoverClasses,
        input: button,
        isOpen: isOpen || this.state.isPopoverOpen,
        closePopover: this.closePopover,
        panelPaddingSize: "none",
        fullWidth: fullWidth
      }, /*#__PURE__*/_react.default.createElement(_accessibility.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("p", {
        role: "alert"
      }, /*#__PURE__*/_react.default.createElement(_i18n.EuiI18n, {
        token: "euiSuperSelect.screenReaderAnnouncement",
        default: "You are in a form selector of {optionsCount} items and must select a single option. Use the up and down keys to navigate or escape to close.",
        values: {
          optionsCount: options.length
        }
      }))), /*#__PURE__*/_react.default.createElement("div", {
        className: "euiSuperSelect__listbox",
        role: "listbox",
        "aria-activedescendant": valueOfSelected,
        tabIndex: 0
      }, items));
    }
  }]);
  return EuiSuperSelect;
}(_react.Component); // @internal
exports.EuiSuperSelect = EuiSuperSelect;
_defineProperty(EuiSuperSelect, "defaultProps", {
  hasDividers: false,
  fullWidth: false,
  compressed: false,
  isInvalid: false,
  isLoading: false
});
EuiSuperSelect.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  compressed: _propTypes.default.bool,
  fullWidth: _propTypes.default.bool,
  isInvalid: _propTypes.default.bool,
  isLoading: _propTypes.default.bool,
  readOnly: _propTypes.default.bool,
  name: _propTypes.default.string,
  /**
     * Creates an input group with element(s) coming before input.
     * `string` | `ReactElement` or an array of these
     */
  prepend: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
  /**
     * Creates an input group with element(s) coming after input.
     * `string` | `ReactElement` or an array of these
     */
  append: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired, _propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.string.isRequired, _propTypes.default.element.isRequired]).isRequired).isRequired]),
  /**
       * Pass an array of options that must at least include:
       * `value`: storing unique value of item,
       * `inputDisplay`: what shows inside the form input when selected
       * `dropdownDisplay` (optional): what shows for the item in the dropdown
       */
  options: _propTypes.default.arrayOf(_propTypes.default.shape({
    value: _propTypes.default.any.isRequired,
    inputDisplay: _propTypes.default.node,
    dropdownDisplay: _propTypes.default.node,
    disabled: _propTypes.default.bool,
    "data-test-subj": _propTypes.default.string
  }).isRequired).isRequired,
  valueOfSelected: _propTypes.default.any,
  /**
       * Classes for the context menu item
       */
  itemClassName: _propTypes.default.string,
  /**
       * You must pass an `onChange` function to handle the update of the value
       */
  onChange: _propTypes.default.func,
  /**
       * Change to `true` if you want horizontal lines between options.
       * This is best used when options are multi-line.
       */
  hasDividers: _propTypes.default.bool,
  /**
       * Change `EuiContextMenuItem` layout position of icon
       */
  itemLayoutAlign: _propTypes.default.oneOf(["center", "top", "bottom"]),
  /**
       * Applied to the outermost wrapper (popover)
       */
  popoverClassName: _propTypes.default.string,
  /**
       * Controls whether the options are shown. Default: false
       */
  isOpen: _propTypes.default.bool
};
// @internal
var EuiCompressedSuperSelect = /*#__PURE__*/function (_EuiSuperSelect) {
  _inherits(EuiCompressedSuperSelect, _EuiSuperSelect);
  var _super2 = _createSuper(EuiCompressedSuperSelect);
  function EuiCompressedSuperSelect() {
    _classCallCheck(this, EuiCompressedSuperSelect);
    return _super2.apply(this, arguments);
  }
  return EuiCompressedSuperSelect;
}(EuiSuperSelect);
exports.EuiCompressedSuperSelect = EuiCompressedSuperSelect;
_defineProperty(EuiCompressedSuperSelect, "defaultProps", _objectSpread(_objectSpread({}, EuiSuperSelect.defaultProps), {}, {
  compressed: true
}));