/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.utils.cache.stats;

import org.opensearch.index.store.remote.utils.cache.stats.IRefCountedCacheStats;
import org.opensearch.index.store.remote.utils.cache.stats.RefCountedCacheStats;
import org.opensearch.index.store.remote.utils.cache.stats.StatsCounter;

public class DefaultStatsCounter<K, V>
implements StatsCounter<K, V> {
    private long hitCount = 0L;
    private long missCount = 0L;
    private long removeCount = 0L;
    private long removeWeight = 0L;
    private long replaceCount = 0L;
    private long evictionCount = 0L;
    private long evictionWeight = 0L;
    private long usage = 0L;
    private long activeUsage = 0L;
    private long pinnedUsage;

    @Override
    public void recordHits(K key, V value, boolean pinned, int count) {
        this.hitCount += (long)count;
    }

    @Override
    public void recordMisses(K key, int count) {
        this.missCount += (long)count;
    }

    @Override
    public void recordRemoval(V value, boolean pinned, long weight) {
        ++this.removeCount;
        this.removeWeight += weight;
        this.usage -= weight;
    }

    @Override
    public void recordReplacement(V oldValue, V newValue, long oldWeight, long newWeight, boolean shouldUpdateActiveUsage, boolean isPinned) {
        ++this.replaceCount;
        if (shouldUpdateActiveUsage) {
            this.activeUsage = this.activeUsage - oldWeight + newWeight;
        }
        if (isPinned) {
            this.pinnedUsage = this.pinnedUsage - oldWeight + newWeight;
        }
        this.usage = this.usage - oldWeight + newWeight;
    }

    @Override
    public void recordEviction(V value, long weight) {
        ++this.evictionCount;
        this.evictionWeight += weight;
        this.usage -= weight;
    }

    @Override
    public void recordUsage(V value, long weight, boolean pinned, boolean shouldDecrease) {
        weight = shouldDecrease ? -1L * weight : weight;
        this.usage += weight;
    }

    @Override
    public void recordActiveUsage(V value, long weight, boolean pinned, boolean shouldDecrease) {
        weight = shouldDecrease ? -1L * weight : weight;
        this.activeUsage += weight;
    }

    @Override
    public void recordPinnedUsage(V value, long weight, boolean shouldDecrease) {
        weight = shouldDecrease ? -1L * weight : weight;
        this.pinnedUsage += weight;
    }

    @Override
    public void resetActiveUsage() {
        this.activeUsage = 0L;
    }

    @Override
    public void resetPinnedUsage() {
        this.pinnedUsage = 0L;
    }

    @Override
    public void resetUsage() {
        this.usage = 0L;
    }

    @Override
    public long activeUsage() {
        return this.activeUsage;
    }

    @Override
    public long usage() {
        return this.usage;
    }

    @Override
    public long pinnedUsage() {
        return this.pinnedUsage;
    }

    @Override
    public IRefCountedCacheStats snapshot() {
        return new RefCountedCacheStats(this.hitCount, this.missCount, this.removeCount, this.removeWeight, this.replaceCount, this.evictionCount, this.evictionWeight, this.usage, this.activeUsage, this.pinnedUsage);
    }

    public String toString() {
        return this.snapshot().toString();
    }
}

