/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg.sig;

import org.bouncycastle.bcpg.FingerprintUtil;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.bcpg.SignatureSubpacket;

public class IssuerKeyID
extends SignatureSubpacket {
    protected static byte[] keyIDToBytes(long keyId) {
        byte[] data = new byte[8];
        FingerprintUtil.writeKeyID(keyId, data);
        return data;
    }

    public IssuerKeyID(boolean critical, boolean isLongLength, byte[] data) {
        super(16, critical, isLongLength, data);
    }

    public IssuerKeyID(boolean critical, long keyID) {
        super(16, critical, false, IssuerKeyID.keyIDToBytes(keyID));
    }

    public long getKeyID() {
        return FingerprintUtil.readKeyID(this.data);
    }

    public KeyIdentifier getKeyIdentifier() {
        return new KeyIdentifier(this.getKeyID());
    }
}

