/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import org.gradle.api.internal.provider.ValueCollector;
import org.gradle.api.internal.provider.ValueSanitizer;
import org.jspecify.annotations.Nullable;

class ValidatingValueCollector<T>
implements ValueCollector<T> {
    private final Class<?> collectionType;
    private final Class<T> elementType;
    private final ValueSanitizer<T> sanitizer;

    ValidatingValueCollector(Class<?> collectionType, Class<T> elementType, ValueSanitizer<T> sanitizer) {
        this.collectionType = collectionType;
        this.elementType = elementType;
        this.sanitizer = sanitizer;
    }

    @Override
    public void add(@Nullable T value, ImmutableCollection.Builder<T> dest) {
        Preconditions.checkNotNull(value, (String)"Cannot get the value of a property of type %s with element type %s as the source value contains a null element.", (Object)this.collectionType.getName(), (Object)this.elementType.getName());
        T sanitized = this.sanitizer.sanitize(value);
        if (!this.elementType.isInstance(sanitized)) {
            throw new IllegalArgumentException(String.format("Cannot get the value of a property of type %s with element type %s as the source value contains an element of type %s.", this.collectionType.getName(), this.elementType.getName(), value.getClass().getName()));
        }
        dest.add(sanitized);
    }

    @Override
    public void addAll(Iterable<? extends T> values, ImmutableCollection.Builder<T> dest) {
        for (T value : values) {
            this.add(value, dest);
        }
    }
}

