/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.wagon.shared.http;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.org.apache.http.HttpHost;
import org.jetbrains.kotlin.org.apache.http.client.config.RequestConfig;
import org.jetbrains.kotlin.org.apache.maven.wagon.shared.http.HttpMethodConfiguration;

public class ConfigurationUtils {
    public static void copyConfig(HttpMethodConfiguration config, RequestConfig.Builder builder) {
        builder.setConnectTimeout(config.getConnectionTimeout());
        builder.setSocketTimeout(config.getReadTimeout());
        Properties params = config.getParams();
        if (params != null) {
            Pattern coercePattern = Pattern.compile("%(\\w+),(.+)");
            for (Map.Entry<Object, Object> entry : params.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                Matcher matcher = coercePattern.matcher(value);
                if (matcher.matches()) {
                    value = matcher.group(2);
                }
                if (key.equals("http.socket.timeout")) {
                    builder.setSocketTimeout(Integer.parseInt(value));
                    continue;
                }
                if (key.equals("http.connection.stalecheck")) {
                    builder.setStaleConnectionCheckEnabled(Boolean.valueOf(value));
                    continue;
                }
                if (key.equals("http.connection.timeout")) {
                    builder.setConnectTimeout(Integer.parseInt(value));
                    continue;
                }
                if (key.equals("http.protocol.expect-continue")) {
                    builder.setExpectContinueEnabled(Boolean.valueOf(value));
                    continue;
                }
                if (key.equals("http.route.default-proxy")) {
                    builder.setProxy(HttpHost.create(value));
                    continue;
                }
                if (key.equals("http.route.local-address")) {
                    try {
                        builder.setLocalAddress(InetAddress.getByName(value));
                    }
                    catch (UnknownHostException unknownHostException) {}
                    continue;
                }
                if (key.equals("http.auth.proxy-scheme-pref")) {
                    builder.setProxyPreferredAuthSchemes(Arrays.asList(value.split(",")));
                    continue;
                }
                if (key.equals("http.auth.target-scheme-pref")) {
                    builder.setTargetPreferredAuthSchemes(Arrays.asList(value.split(",")));
                    continue;
                }
                if (key.equals("http.protocol.handle-authentication")) {
                    builder.setAuthenticationEnabled(Boolean.valueOf(value));
                    continue;
                }
                if (key.equals("http.protocol.allow-circular-redirects")) {
                    builder.setCircularRedirectsAllowed(Boolean.valueOf(value));
                    continue;
                }
                if (key.equals("http.conn-manager.timeout")) {
                    builder.setConnectionRequestTimeout(Integer.parseInt(value));
                    continue;
                }
                if (key.equals("http.protocol.cookie-policy")) {
                    builder.setCookieSpec(value);
                    continue;
                }
                if (key.equals("http.protocol.max-redirects")) {
                    builder.setMaxRedirects(Integer.parseInt(value));
                    continue;
                }
                if (key.equals("http.protocol.handle-redirects")) {
                    builder.setRedirectsEnabled(Boolean.valueOf(value));
                    continue;
                }
                if (key.equals("http.protocol.reject-relative-redirect")) {
                    builder.setRelativeRedirectsAllowed(Boolean.valueOf(value) == false);
                    continue;
                }
                if (key.equals("http.protocol.handle-content-compression")) {
                    builder.setContentCompressionEnabled(Boolean.valueOf(value));
                    continue;
                }
                if (!key.equals("http.protocol.handle-uri-normalization")) continue;
                builder.setNormalizeUri(Boolean.valueOf(value));
            }
        }
    }

    public static HttpMethodConfiguration merge(HttpMethodConfiguration base, HttpMethodConfiguration local) {
        if (base == null && local == null) {
            return null;
        }
        if (base == null) {
            return local;
        }
        if (local == null) {
            return base;
        }
        HttpMethodConfiguration result = base.copy();
        if (local.getConnectionTimeout() != 60000) {
            result.setConnectionTimeout(local.getConnectionTimeout());
        }
        if (local.getReadTimeout() != 1800000) {
            result.setReadTimeout(local.getReadTimeout());
        }
        if (local.getHeaders() != null) {
            result.getHeaders().putAll((Map<?, ?>)local.getHeaders());
        }
        if (local.getParams() != null) {
            result.getParams().putAll((Map<?, ?>)local.getParams());
        }
        if (local.getUseDefaultHeaders() != null) {
            result.setUseDefaultHeaders(local.isUseDefaultHeaders());
        }
        return result;
    }
}

