/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.step.transform;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.Client;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.indexmanagement.indexstatemanagement.step.transform.WaitForTransformCompletionStep;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Step;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepContext;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepMetaData;
import org.opensearch.indexmanagement.transform.action.explain.ExplainTransformAction;
import org.opensearch.indexmanagement.transform.action.explain.ExplainTransformRequest;
import org.opensearch.indexmanagement.transform.action.explain.ExplainTransformResponse;
import org.opensearch.indexmanagement.transform.model.TransformMetadata;
import org.opensearch.transport.RemoteTransportException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\f\u001a\u00020\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rJ+\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\"\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001eJ\u001e\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006#"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/transform/WaitForTransformCompletionStep;", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step;", "()V", "info", "", "", "", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "stepStatus", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step$StepStatus;", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "explainTransformJob", "Lorg/opensearch/indexmanagement/transform/action/explain/ExplainTransformResponse;", "transformJobId", "indexName", "context", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;", "(Ljava/lang/String;Ljava/lang/String;Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getUpdatedManagedIndexMetadata", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "currentMetadata", "isIdempotent", "", "processFailure", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "processTransformMetadataStatus", "transformMetadata", "Lorg/opensearch/indexmanagement/transform/model/TransformMetadata;", "Companion", "opensearch-index-management"})
public final class WaitForTransformCompletionStep
extends Step {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    @NotNull
    private Step.StepStatus stepStatus = Step.StepStatus.STARTING;
    @Nullable
    private Map<String, ? extends Object> info;
    @NotNull
    public static final String name = "wait_for_transform_completion";
    @NotNull
    public static final String JOB_STOPPED_MESSAGE = "Transform job was stopped";

    public WaitForTransformCompletionStep() {
        super(name, false, 2, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object execute(@NotNull Continuation<? super Step> var1_1) {
        if (!(var1_1 instanceof execute.1)) ** GOTO lbl-1000
        var9_2 = var1_1;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ WaitForTransformCompletionStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute((Continuation<? super Step>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.getContext();
                if (v0 == null) {
                    return this;
                }
                context = v0;
                indexName = context.getMetadata().getIndex();
                managedIndexMetadata = context.getMetadata();
                v1 = managedIndexMetadata.getActionMetaData();
                v2 = v1 != null && (v1 = v1.getActionProperties()) != null && (v1 = v1.getTransformActionProperties()) != null ? v1.getTransformId() : (transformJobId = null);
                if (transformJobId == null) {
                    this.logger.error("No transform job id passed down.");
                    this.stepStatus = Step.StepStatus.FAILED;
                    this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)WaitForTransformCompletionStep.Companion.getMissingTransformJobMessage(indexName)));
                    return this;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = indexName;
                $continuation.L$2 = transformJobId;
                $continuation.label = 1;
                v3 = this.explainTransformJob(transformJobId, indexName, context, (Continuation<? super ExplainTransformResponse>)$continuation);
                if (v3 == var10_4) {
                    return var10_4;
                }
                ** GOTO lbl39
            }
            case 1: {
                transformJobId = (String)$continuation.L$2;
                indexName = (String)$continuation.L$1;
                this = (WaitForTransformCompletionStep)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl39:
                // 2 sources

                if ((explainTransformResponse = (ExplainTransformResponse)v3) == null) {
                    return this;
                }
                explainTransform = explainTransformResponse.getIdsToExplain$opensearch_index_management().get(transformJobId);
                if (explainTransform == null) {
                    this.logger.warn("Job " + transformJobId + " is not found, mark step as COMPLETED.");
                    this.stepStatus = Step.StepStatus.COMPLETED;
                    this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)WaitForTransformCompletionStep.Companion.getJobNotFoundMessage(transformJobId, indexName)));
                    return this;
                }
                v4 = explainTransform.getMetadata();
                if ((v4 != null ? v4.getStatus() : null) == null) {
                    this.logger.warn("Job " + transformJobId + " has not started yet");
                    this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
                    this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)WaitForTransformCompletionStep.Companion.getJobProcessingMessage(transformJobId, indexName)));
                    return this;
                }
                this.processTransformMetadataStatus(transformJobId, indexName, explainTransform.getMetadata());
                return this;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object explainTransformJob(String var1_1, String var2_2, StepContext var3_3, Continuation<? super ExplainTransformResponse> var4_4) {
        if (!(var4_4 instanceof explainTransformJob.1)) ** GOTO lbl-1000
        var9_5 = var4_4;
        if ((var9_5.label & -2147483648) != 0) {
            var9_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ WaitForTransformCompletionStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return WaitForTransformCompletionStep.access$explainTransformJob(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                explainTransformRequest = new ExplainTransformRequest(CollectionsKt.listOf((Object)transformJobId));
                $continuation.L$0 = this;
                $continuation.L$1 = transformJobId;
                $continuation.L$2 = indexName;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)context.getClient(), (Function2)new Function2<Client, ActionListener<ExplainTransformResponse>, Unit>(explainTransformRequest){
                    final /* synthetic */ ExplainTransformRequest $explainTransformRequest;
                    {
                        this.$explainTransformRequest = $explainTransformRequest;
                        super(2);
                    }

                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<ExplainTransformResponse> it) {
                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        $this$suspendUntil.execute((ActionType)ExplainTransformAction.Companion.getINSTANCE(), (ActionRequest)this.$explainTransformRequest, it);
                    }
                }, $continuation);
                ** if (v0 != var10_7) goto lbl22
lbl21:
                // 1 sources

                return var10_7;
lbl22:
                // 1 sources

                ** GOTO lbl31
            }
            case 1: {
                indexName = (String)$continuation.L$2;
                transformJobId = (String)$continuation.L$1;
                this = (WaitForTransformCompletionStep)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl31:
                    // 2 sources

                    response = (ExplainTransformResponse)v0;
                    this.logger.info("Received the status for jobs [" + response.getIdsToExplain$opensearch_index_management().keySet() + "]");
                    return response;
                }
                catch (RemoteTransportException e) {
                    var7_12 = ExceptionsHelper.unwrapCause((Throwable)e);
                    Intrinsics.checkNotNull((Object)var7_12, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    this.processFailure(transformJobId, indexName, (Exception)var7_12);
                }
                catch (Exception e) {
                    this.processFailure(transformJobId, indexName, e);
                }
                return null;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void processTransformMetadataStatus(@NotNull String transformJobId, @NotNull String indexName, @NotNull TransformMetadata transformMetadata2) {
        Intrinsics.checkNotNullParameter((Object)transformJobId, (String)"transformJobId");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Intrinsics.checkNotNullParameter((Object)transformMetadata2, (String)"transformMetadata");
        switch (WhenMappings.$EnumSwitchMapping$0[transformMetadata2.getStatus().ordinal()]) {
            case 1: 
            case 2: {
                this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
                this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)Companion.getJobProcessingMessage(transformJobId, indexName)));
                break;
            }
            case 3: {
                this.stepStatus = Step.StepStatus.FAILED;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"message", (Object)Companion.getJobFailedMessage(transformJobId, indexName)), TuplesKt.to((Object)"cause", (Object)String.valueOf(transformMetadata2.getFailureReason()))};
                this.info = MapsKt.mapOf((Pair[])pairArray);
                break;
            }
            case 4: {
                this.stepStatus = Step.StepStatus.COMPLETED;
                this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)Companion.getJobCompletionMessage(transformJobId, indexName)));
                break;
            }
            case 5: {
                this.stepStatus = Step.StepStatus.FAILED;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"message", (Object)Companion.getJobFailedMessage(transformJobId, indexName)), TuplesKt.to((Object)"cause", (Object)JOB_STOPPED_MESSAGE)};
                this.info = MapsKt.mapOf((Pair[])pairArray);
            }
        }
    }

    public final void processFailure(@NotNull String transformJobId, @NotNull String indexName, @NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)transformJobId, (String)"transformJobId");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.stepStatus = Step.StepStatus.FAILED;
        String message = Companion.getFailedMessage(transformJobId, indexName);
        this.logger.error(message, (Throwable)e);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"message", (Object)message)};
        Map mutableInfo = MapsKt.mutableMapOf((Pair[])pairArray);
        String errorMessage = e.getMessage();
        if (errorMessage != null) {
            mutableInfo.put("cause", errorMessage);
        }
        this.info = MapsKt.toMap((Map)mutableInfo);
    }

    @NotNull
    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(@NotNull ManagedIndexMetaData currentMetadata) {
        Intrinsics.checkNotNullParameter((Object)currentMetadata, (String)"currentMetadata");
        ActionMetaData actionMetaData = currentMetadata.getActionMetaData();
        StepMetaData stepMetaData = new StepMetaData(this.getName(), this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus);
        Map<String, ? extends Object> map = this.info;
        return ManagedIndexMetaData.copy$default((ManagedIndexMetaData)currentMetadata, null, null, null, null, null, null, null, null, null, null, (ActionMetaData)actionMetaData, (StepMetaData)stepMetaData, null, map, null, (long)0L, (long)0L, null, (int)250623, null);
    }

    public boolean isIdempotent() {
        return true;
    }

    public static final /* synthetic */ Object access$explainTransformJob(WaitForTransformCompletionStep $this, String transformJobId, String indexName, StepContext context, Continuation $completion) {
        return $this.explainTransformJob(transformJobId, indexName, context, (Continuation<? super ExplainTransformResponse>)$completion);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/transform/WaitForTransformCompletionStep$Companion;", "", "()V", "JOB_STOPPED_MESSAGE", "", "name", "getFailedMessage", "transformJob", "index", "getJobCompletionMessage", "getJobFailedMessage", "getJobNotFoundMessage", "getJobProcessingMessage", "getMissingTransformJobMessage", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getFailedMessage(@NotNull String transformJob, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)transformJob, (String)"transformJob");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Failed to get the status of transform job [" + transformJob + "] [index=" + index2 + "]";
        }

        @NotNull
        public final String getJobProcessingMessage(@NotNull String transformJob, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)transformJob, (String)"transformJob");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Transform job [" + transformJob + "] is still processing [index=" + index2 + "]";
        }

        @NotNull
        public final String getJobCompletionMessage(@NotNull String transformJob, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)transformJob, (String)"transformJob");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Transform job [" + transformJob + "] completed [index=" + index2 + "]";
        }

        @NotNull
        public final String getJobFailedMessage(@NotNull String transformJob, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)transformJob, (String)"transformJob");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Transform job [" + transformJob + "] failed [index=" + index2 + "]";
        }

        @NotNull
        public final String getMissingTransformJobMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Transform job was not found [index=" + index2 + "]";
        }

        @NotNull
        public final String getJobNotFoundMessage(@NotNull String transformJob, @NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)transformJob, (String)"transformJob");
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Transform job [" + transformJob + "] is not found [index=" + index2 + "]";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TransformMetadata.Status.values().length];
            try {
                nArray[TransformMetadata.Status.INIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransformMetadata.Status.STARTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransformMetadata.Status.FAILED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransformMetadata.Status.FINISHED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransformMetadata.Status.STOPPED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

