/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_film;

import java.awt.event.ActionEvent;
import java.io.Closeable;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mediathek.controller.history.SeenHistoryController;
import mediathek.daten.DatenFilm;
import mediathek.daten.FilmResolution;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.SwingErrorDialog;
import mediathek.tool.http.MVHttpClient;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lmediathek/gui/tabs/tab_film/JDownloadHelper;", "", "()V", "historyController", "Lmediathek/controller/history/SeenHistoryController;", "downloadUrl", "", "url", "Lokhttp3/HttpUrl;", "film", "Lmediathek/daten/DatenFilm;", "installContextMenu", "jPopupMenu", "Ljavax/swing/JPopupMenu;", "showErrorMessage", "Companion", "MediathekView"})
public final class JDownloadHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SeenHistoryController historyController = new SeenHistoryController();
    private static final Logger logger = LogManager.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void downloadUrl(HttpUrl url, DatenFilm film) {
        RequestBody formBody = new FormBody.Builder(null, 1, null).add("urls", url.toString()).build();
        Request request = new Request.Builder().url("http://127.0.0.1:9666/flash/add").post(formBody).build();
        try {
            OkHttpClient.Builder builder = MVHttpClient.getInstance().getReducedTimeOutClient().newBuilder();
            builder.connectTimeout(125L, TimeUnit.MILLISECONDS);
            OkHttpClient client = builder.build();
            Closeable closeable = client.newCall(request).execute();
            Throwable throwable = null;
            try {
                Response it = (Response)closeable;
                boolean bl = false;
                if (it.isSuccessful()) {
                    this.historyController.markSeen(film);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (ConnectException e) {
            this.showErrorMessage();
        }
        catch (SocketTimeoutException e) {
            this.showErrorMessage();
        }
        catch (Exception e) {
            logger.error("downloadUrl", (Throwable)e);
            SwingErrorDialog.showExceptionMessage(MediathekGui.ui(), "<html>Die URL konnte nicht mit JDownloader geladen werden.<br>Bitte wenden Sie sich bei Bedarf an das Forum.</html>", e);
        }
    }

    private final void showErrorMessage() {
        JOptionPane.showMessageDialog(MediathekGui.ui(), "Verbindung mit JDownloader nicht m\u00f6glich.\nBitte stellen Sie sicher, dass JDownloader gestartet wurde.", "MediathekView", 0);
    }

    public final void installContextMenu(@NotNull DatenFilm film, @NotNull JPopupMenu jPopupMenu) {
        Intrinsics.checkNotNullParameter(film, "film");
        Intrinsics.checkNotNullParameter(jPopupMenu, "jPopupMenu");
        jPopupMenu.addSeparator();
        JMenu mJD = new JMenu("Mit JDownloader herunterladen");
        String string = film.getUrlNormalQuality();
        Intrinsics.checkNotNullExpressionValue(string, "film.urlNormalQuality");
        HttpUrl uNormal = HttpUrl.Companion.get(string);
        String string2 = film.getUrlFuerAufloesung(FilmResolution.Enum.HIGH_QUALITY);
        Intrinsics.checkNotNullExpressionValue(string2, "film.getUrlFuerAufloesun\u2026lution.Enum.HIGH_QUALITY)");
        HttpUrl uHq = HttpUrl.Companion.get(string2);
        String string3 = film.getUrlFuerAufloesung(FilmResolution.Enum.LOW);
        Intrinsics.checkNotNullExpressionValue(string3, "film.getUrlFuerAufloesung(FilmResolution.Enum.LOW)");
        HttpUrl uLow = HttpUrl.Companion.get(string3);
        if (film.isHighQuality()) {
            JMenuItem miHq = new JMenuItem("in bester Qualit\u00e4t");
            miHq.addActionListener(arg_0 -> JDownloadHelper.installContextMenu$lambda$1(this, uHq, film, arg_0));
            mJD.add(miHq);
        }
        JMenuItem miNormal = new JMenuItem("in normaler Qualit\u00e4t");
        miNormal.addActionListener(arg_0 -> JDownloadHelper.installContextMenu$lambda$2(this, uNormal, film, arg_0));
        mJD.add(miNormal);
        if (uLow != uNormal) {
            JMenuItem miLow = new JMenuItem("in niedriger Qualit\u00e4t");
            miLow.addActionListener(arg_0 -> JDownloadHelper.installContextMenu$lambda$3(this, uLow, film, arg_0));
            mJD.add(miLow);
        }
        jPopupMenu.add(mJD);
        JMenuItem miWebsiteToJd = new JMenuItem("Webseiten-URL an JDownloader \u00fcbergeben");
        miWebsiteToJd.addActionListener(arg_0 -> JDownloadHelper.installContextMenu$lambda$4(film, this, arg_0));
        jPopupMenu.add(miWebsiteToJd);
        String string4 = film.getWebsiteUrl();
        Intrinsics.checkNotNullExpressionValue(string4, "film.websiteUrl");
        if (StringsKt.isBlank(string4)) {
            miWebsiteToJd.setEnabled(false);
        }
    }

    private static final void installContextMenu$lambda$1(JDownloadHelper this$0, HttpUrl $uHq, DatenFilm $film, ActionEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($uHq, "$uHq");
        Intrinsics.checkNotNullParameter($film, "$film");
        this$0.downloadUrl($uHq, $film);
    }

    private static final void installContextMenu$lambda$2(JDownloadHelper this$0, HttpUrl $uNormal, DatenFilm $film, ActionEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($uNormal, "$uNormal");
        Intrinsics.checkNotNullParameter($film, "$film");
        this$0.downloadUrl($uNormal, $film);
    }

    private static final void installContextMenu$lambda$3(JDownloadHelper this$0, HttpUrl $uLow, DatenFilm $film, ActionEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($uLow, "$uLow");
        Intrinsics.checkNotNullParameter($film, "$film");
        this$0.downloadUrl($uLow, $film);
    }

    private static final void installContextMenu$lambda$4(DatenFilm $film, JDownloadHelper this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter($film, "$film");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        try {
            String string = $film.getWebsiteUrl();
            Intrinsics.checkNotNullExpressionValue(string, "film.websiteUrl");
            HttpUrl webSiteUrl = HttpUrl.Companion.get(string);
            this$0.downloadUrl(webSiteUrl, $film);
        }
        catch (IllegalArgumentException e) {
            logger.error("Illegal Website URL found: {}", (Object)$film.getWebsiteUrl());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lmediathek/gui/tabs/tab_film/JDownloadHelper$Companion;", "", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

