/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTKeyStroke;
import java.awt.Toolkit;
import java.util.logging.Logger;
import sun.awt.EmbeddedFrame;
import sun.awt.X11.XEmbeddedFramePeer;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XTrayIconPeer;

public class XEmbeddedFrame
extends EmbeddedFrame {
    private static final Logger log = Logger.getLogger(XEmbeddedFrame.class.getName());
    long handle;

    public XEmbeddedFrame() {
    }

    public XEmbeddedFrame(long handle) {
        this(handle, false);
    }

    public XEmbeddedFrame(long handle, boolean supportsXEmbed, boolean isTrayIconWindow) {
        super(handle, supportsXEmbed);
        if (isTrayIconWindow) {
            XTrayIconPeer.suppressWarningString(this);
        }
        this.handle = handle;
        if (handle != 0L) {
            this.addNotify();
            if (!isTrayIconWindow) {
                this.show();
            }
        }
    }

    @Override
    public void addNotify() {
        if (this.getPeer() == null) {
            XToolkit toolkit = (XToolkit)Toolkit.getDefaultToolkit();
            this.setPeer(toolkit.createEmbeddedFrame(this));
        }
        super.addNotify();
    }

    public XEmbeddedFrame(long handle, boolean supportsXEmbed) {
        this(handle, supportsXEmbed, false);
    }

    @Override
    public boolean traverseIn(boolean direction) {
        XEmbeddedFramePeer peer = (XEmbeddedFramePeer)this.getPeer();
        if (peer != null) {
            if (peer.supportsXEmbed() && peer.isXEmbedActive()) {
                log.fine("The method shouldn't be called when XEmbed is active!");
            } else {
                return super.traverseIn(direction);
            }
        }
        return false;
    }

    @Override
    protected boolean traverseOut(boolean direction) {
        XEmbeddedFramePeer xefp = (XEmbeddedFramePeer)this.getPeer();
        if (direction) {
            xefp.traverseOutForward();
        } else {
            xefp.traverseOutBackward();
        }
        return true;
    }

    @Override
    public void synthesizeWindowActivation(boolean doActivate) {
        XEmbeddedFramePeer peer = (XEmbeddedFramePeer)this.getPeer();
        if (peer != null) {
            if (peer.supportsXEmbed() && peer.isXEmbedActive()) {
                log.fine("The method shouldn't be called when XEmbed is active!");
            } else {
                peer.synthesizeFocusInOut(doActivate);
            }
        }
    }

    @Override
    public void registerAccelerator(AWTKeyStroke stroke) {
        XEmbeddedFramePeer xefp = (XEmbeddedFramePeer)this.getPeer();
        if (xefp != null) {
            xefp.registerAccelerator(stroke);
        }
    }

    @Override
    public void unregisterAccelerator(AWTKeyStroke stroke) {
        XEmbeddedFramePeer xefp = (XEmbeddedFramePeer)this.getPeer();
        if (xefp != null) {
            xefp.unregisterAccelerator(stroke);
        }
    }
}

