/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.AtomicSortComparer;
import net.sf.saxon.expr.sort.DescendingComparer;
import net.sf.saxon.expr.sort.EmptyGreatestComparer;
import net.sf.saxon.expr.sort.NumericComparer;
import net.sf.saxon.expr.sort.NumericComparer11;
import net.sf.saxon.expr.sort.TextComparer;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class SortKeyDefinition
implements Serializable {
    private static StringLiteral defaultOrder = new StringLiteral("ascending");
    private static StringLiteral defaultCaseOrder = new StringLiteral("#default");
    private static StringLiteral defaultLanguage = new StringLiteral(StringValue.EMPTY_STRING);
    protected Expression sortKey;
    protected Expression order = defaultOrder;
    protected Expression dataTypeExpression = null;
    protected Expression caseOrder = defaultCaseOrder;
    protected Expression language = defaultLanguage;
    protected Expression collationName = null;
    protected Expression stable = null;
    protected StringCollator collation;
    protected String baseURI;
    protected boolean emptyLeast = true;
    protected boolean backwardsCompatible = false;
    private transient AtomicComparer finalComparator = null;

    public void setSortKey(Expression exp) {
        this.sortKey = exp;
    }

    public Expression getSortKey() {
        return this.sortKey;
    }

    public void setOrder(Expression exp) {
        this.order = exp;
    }

    public Expression getOrder() {
        return this.order;
    }

    public void setDataTypeExpression(Expression exp) {
        this.dataTypeExpression = exp;
    }

    public Expression getDataTypeExpression() {
        return this.dataTypeExpression;
    }

    public void setCaseOrder(Expression exp) {
        this.caseOrder = exp;
    }

    public Expression getCaseOrder() {
        return this.caseOrder;
    }

    public void setLanguage(Expression exp) {
        this.language = exp;
    }

    public Expression getLanguage() {
        return this.language;
    }

    public void setCollationNameExpression(Expression collationName) {
        this.collationName = collationName;
    }

    public Expression getCollationNameExpression() {
        return this.collationName;
    }

    public void setCollation(StringCollator collation) {
        this.collation = collation;
    }

    public StringCollator getCollation() {
        return this.collation;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setStable(Expression stable) {
        this.stable = stable;
    }

    public Expression getStable() {
        return this.stable;
    }

    public void setBackwardsCompatible(boolean compatible) {
        this.backwardsCompatible = compatible;
    }

    public boolean isBackwardsCompatible() {
        return this.backwardsCompatible;
    }

    public void setEmptyLeast(boolean emptyLeast) {
        this.emptyLeast = emptyLeast;
    }

    public boolean getEmptyLeast() {
        return this.emptyLeast;
    }

    public boolean isFixed() {
        return !(!(this.order instanceof Literal) || this.dataTypeExpression != null && !(this.dataTypeExpression instanceof Literal) || !(this.caseOrder instanceof Literal) || !(this.language instanceof Literal) || this.stable != null && !(this.stable instanceof Literal) || this.collationName != null && !(this.collationName instanceof Literal));
    }

    public SortKeyDefinition simplify(ExpressionVisitor visitor) throws XPathException {
        this.sortKey = visitor.simplify(this.sortKey);
        this.order = visitor.simplify(this.order);
        this.dataTypeExpression = visitor.simplify(this.dataTypeExpression);
        this.caseOrder = visitor.simplify(this.caseOrder);
        this.language = visitor.simplify(this.language);
        this.stable = visitor.simplify(this.stable);
        this.collationName = visitor.simplify(this.collationName);
        return this;
    }

    public SortKeyDefinition copy() {
        SortKeyDefinition sk2 = new SortKeyDefinition();
        sk2.setSortKey(this.copy(this.sortKey));
        sk2.setOrder(this.copy(this.order));
        sk2.setDataTypeExpression(this.copy(this.dataTypeExpression));
        sk2.setCaseOrder(this.copy(this.caseOrder));
        sk2.setLanguage(this.copy(this.language));
        sk2.setStable(this.copy(this.stable));
        sk2.setCollationNameExpression(this.copy(this.collationName));
        sk2.collation = this.collation;
        sk2.emptyLeast = this.emptyLeast;
        sk2.baseURI = this.baseURI;
        sk2.backwardsCompatible = this.backwardsCompatible;
        sk2.finalComparator = this.finalComparator;
        return sk2;
    }

    private Expression copy(Expression in) {
        return in == null ? null : in.copy();
    }

    public void typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        ConversionResult v;
        this.order = visitor.typeCheck(this.order, contextItemType);
        this.dataTypeExpression = visitor.typeCheck(this.dataTypeExpression, contextItemType);
        this.caseOrder = visitor.typeCheck(this.caseOrder, contextItemType);
        this.language = visitor.typeCheck(this.language, contextItemType);
        this.stable = visitor.typeCheck(this.stable, contextItemType);
        this.collationName = visitor.typeCheck(this.collationName, contextItemType);
        if (this.language instanceof StringLiteral && ((StringLiteral)this.language).getStringValue().length() != 0 && (v = StringValue.convertStringToBuiltInType(((StringLiteral)this.language).getStringValue(), BuiltInAtomicType.LANGUAGE, visitor.getConfiguration().getConversionRules())) instanceof ValidationFailure) {
            throw new XPathException("The lang attribute of xsl:sort must be a valid language code", "XTDE0030");
        }
    }

    public AtomicComparer makeComparator(XPathContext context) throws XPathException {
        StringValue stableVal;
        String s;
        AtomicComparer atomicComparer;
        StringCollator stringCollator;
        String orderX = ((Object)this.order.evaluateAsString(context)).toString();
        Configuration config = context.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        if (this.collation != null) {
            stringCollator = this.collation;
        } else {
            if (this.collationName != null) {
                URI collationURI;
                String cname = ((Object)this.collationName.evaluateAsString(context)).toString();
                try {
                    collationURI = new URI(cname);
                    if (!collationURI.isAbsolute()) {
                        if (this.baseURI == null) {
                            throw new XPathException("Collation URI is relative, and base URI is unknown");
                        }
                        URI base = new URI(this.baseURI);
                        collationURI = base.resolve(collationURI);
                    }
                }
                catch (URISyntaxException err) {
                    throw new XPathException("Collation name " + cname + " is not a valid URI: " + err);
                }
                try {
                    stringCollator = context.getCollation(collationURI.toString());
                }
                catch (XPathException e) {
                    if ("FOCH0002".equals(e.getErrorCodeLocalPart())) {
                        e.setErrorCode("XTDE1035");
                    }
                    throw e;
                }
            }
            String caseOrderX = ((Object)this.caseOrder.evaluateAsString(context)).toString();
            String languageX = ((Object)this.language.evaluateAsString(context)).toString();
            Properties props = new Properties();
            if (languageX.length() != 0 && !(this.language instanceof StringLiteral)) {
                ConversionResult v = StringValue.convertStringToBuiltInType(languageX, BuiltInAtomicType.LANGUAGE, config.getConversionRules());
                if (v instanceof ValidationFailure) {
                    throw new XPathException("The lang attribute of xsl:sort must be a valid language code", "XTDE0030");
                }
                props.setProperty("lang", languageX);
            }
            if (!caseOrderX.equals("#default")) {
                props.setProperty("case-order", caseOrderX);
            }
            stringCollator = Configuration.getPlatform().makeCollation(config, props, "");
        }
        if (this.dataTypeExpression == null) {
            atomicComparer = AtomicSortComparer.makeSortComparer(stringCollator, this.sortKey.getItemType(th).getAtomizedItemType().getPrimitiveType(), context);
            if (!this.emptyLeast) {
                atomicComparer = new EmptyGreatestComparer(atomicComparer);
            }
        } else {
            String dataType = ((Object)this.dataTypeExpression.evaluateAsString(context)).toString();
            if (dataType.equals("text")) {
                atomicComparer = AtomicSortComparer.makeSortComparer(stringCollator, 513, context);
                atomicComparer = new TextComparer(atomicComparer);
            } else if (dataType.equals("number")) {
                atomicComparer = context.getConfiguration().getXsdVersion() == 10 ? NumericComparer.getInstance() : NumericComparer11.getInstance();
            } else {
                XPathException err = new XPathException("data-type on xsl:sort must be 'text' or 'number'");
                err.setErrorCode("XTDE0030");
                throw err;
            }
        }
        if (this.stable != null && !(s = Whitespace.trim((stableVal = (StringValue)this.stable.evaluateItem(context)).getStringValue())).equals("yes") && !s.equals("no")) {
            XPathException err = new XPathException("Value of 'stable' on xsl:sort must be 'yes' or 'no'");
            err.setErrorCode("XTDE0030");
            throw err;
        }
        if (orderX.equals("ascending")) {
            return atomicComparer;
        }
        if (orderX.equals("descending")) {
            return new DescendingComparer(atomicComparer);
        }
        XPathException err1 = new XPathException("order must be 'ascending' or 'descending'");
        err1.setErrorCode("XTDE0030");
        throw err1;
    }

    public void setFinalComparator(AtomicComparer comp) {
        this.finalComparator = comp;
    }

    public AtomicComparer getFinalComparator() {
        return this.finalComparator;
    }
}

