dnl acinclude.m4 -- various bits of this have been borrowed from the m4
dnl configuration files for KDE and GNOME

AC_DEFUN([AC_CHECK_COMPILERS],
[
  AC_ARG_ENABLE(debug,[  --enable-debug 	  creates debugging code [default=no]],
  [ 
   if test $enableval = "no"; dnl 
     then ac_use_debug_code="no"
     else ac_use_debug_code="yes"
   fi
  ], [ac_use_debug_code="no"])

  dnl Just for configure --help

  dnl this prevents stupid AC_PROG_CC from adding "-g" to the default CFLAGS
  c_flags_in=$CFLAGS

  AC_PROG_CC
  AC_PROG_CPP

  CFLAGS=$c_flags_in

  if test -z "$CFLAGS"; then 
    if test "$GCC" = "yes"; then
      if test "$ac_use_debug_code" = "yes"; then
        CFLAGS="-g $CFLAGS"
      else
        CFLAGS="-O2 $CFLAGS"
      fi
    else 
      if test "$ac_use_debug_code" = "yes"; then
        AC_CHECK_C_COMPILER_FLAG(g,
          [
            CFLAGS="-g $CFLAGS"
        ])
      else 
        AC_CHECK_C_COMPILER_FLAG(O2,
          [
            CFLAGS="-O2 $CFLAGS"
        ])
      fi
    fi
    if test "$GCC" = "yes"; then
       CFLAGS="$CFLAGS -Wall"
    fi
  fi

  PTHREAD_FLAG_C=""
  AC_CHECK_C_COMPILER_FLAG(pthread,
    [
      PTHREAD_FLAG_C="-pthread"
  ])
  AC_SUBST(PTHREAD_FLAG_C)

  dnl this prevents stupid AC_PROG_CXX from adding "-g" to the default CXXFLAGS
  cxx_flags_in=$CXXFLAGS

  AC_PROG_CXX
  AC_PROG_CXXCPP

  CXXFLAGS=$cxx_flags_in

  if test -z "$CXXFLAGS"; then 
    if test "$GXX" = "yes"; then
      if test "$ac_use_debug_code" = "yes"; then
        CXXFLAGS="-g $CXXFLAGS"
      else
        CXXFLAGS="-O2 $CXXFLAGS"
        if test -z "$LDFLAGS"; then 
          LDFLAGS="-s"
        fi
      fi
    else 
      if test "$ac_use_debug_code" = "yes"; then
        AC_CHECK_COMPILER_FLAG(g,
          [
            CXXFLAGS="-g $CXXFLAGS"
        ])
      else 
        AC_CHECK_COMPILER_FLAG(O2,
          [
            CXXFLAGS="-O2 $CXXFLAGS"
        ])
      fi
    fi

    AC_CHECK_COMPILER_FLAG(fexceptions,
      [
        CXXFLAGS="$CXXFLAGS -fexceptions"
    ])

    if test "$GXX" = "yes"; then
       CXXFLAGS="$CXXFLAGS -Wall"
    fi

    AC_CHECK_COMPILER_FLAG(Wno-mismatched-tags,
      [
        CXXFLAGS="$CXXFLAGS -Wno-mismatched-tags"
    ])

    AC_CHECK_COMPILER_FLAG(Wno-unused-private-field,
      [
        CXXFLAGS="$CXXFLAGS -Wno-unused-private-field"
    ])
  fi

  AC_CHECK_COMPILER_FLAG(std=c++11,
    [
      CXXFLAGS="$CXXFLAGS -std=c++11"
    ],
    [
    AC_CHECK_COMPILER_FLAG(std=c++0x,
      [
        CXXFLAGS="$CXXFLAGS -std=c++0x"
    ])
  ])

  PTHREAD_FLAG_CXX=""
  AC_CHECK_COMPILER_FLAG(pthread,
    [
      PTHREAD_FLAG_CXX="-pthread"
  ])
  AC_SUBST(PTHREAD_FLAG_CXX)
])

AC_DEFUN([AC_CHECK_COMPILER_FLAG],
[
AC_MSG_CHECKING(whether $CXX supports -$1)
flag_cache=`echo $1 | sed 'y%.=/+-%___p_%'`
AC_CACHE_VAL(ac_cv_prog_cxx_$flag_cache,
[
echo 'int main() { return 0; }' >conftest.cc
eval "ac_cv_prog_cxx_$flag_cache=no"
if test -z "`$CXX -$1 -c conftest.cc 2>&1`"; then
  if test -z "`$CXX -$1 -o conftest conftest.o 2>&1`"; then
    eval "ac_cv_prog_cxx_$flag_cache=yes"
  fi
fi
rm -f conftest*
])
if eval "test \"`echo '$ac_cv_prog_cxx_'$flag_cache`\" = yes"; then
 AC_MSG_RESULT(yes)
 :
 $2
else
 AC_MSG_RESULT(no)
 :
 $3
fi
])

AC_DEFUN([AC_CHECK_C_COMPILER_FLAG],
[
AC_MSG_CHECKING(whether $CC supports -$1)
flag_cache=`echo $1 | sed 'y%.=/+-%___p_%'`
AC_CACHE_VAL(ac_cv_prog_c_$flag_cache,
[
echo 'int main(void) { return 0; }' >conftest.c
eval "ac_cv_prog_c_$flag_cache=no"
if test -z "`$CC -$1 -c conftest.c 2>&1`"; then
  if test -z "`$CC -$1 -o conftest conftest.o 2>&1`"; then
    eval "ac_cv_prog_c_$flag_cache=yes"
  fi
fi
rm -f conftest*
])
if eval "test \"`echo '$ac_cv_prog_c_'$flag_cache`\" = yes"; then
 AC_MSG_RESULT(yes)
 :
 $2
else
 AC_MSG_RESULT(no)
 :
 $3
fi
])

AC_DEFUN([AC_CLOSING_MESSAGE],
[
echo
echo "    Configuration complete."
echo
echo "    To compile, enter \`make', and then enter \`make install'"
echo "      -- \`make install' must be run as root."
echo
echo "    To reconfigure, enter \`make clean' and then run \`./configure' again."
echo
])

dnl PKG_CHECK_MODULES(GSTUFF, gtk+-2.0 >= 1.3 glib = 1.3.4, action-if, action-not)
dnl defines GSTUFF_LIBS, GSTUFF_CFLAGS, see pkg-config man page
dnl also defines GSTUFF_PKG_ERRORS on error
AC_DEFUN([PKG_CHECK_MODULES], [
  succeeded=no

  if test -z "$PKG_CONFIG"; then
    AC_PATH_PROG(PKG_CONFIG, pkg-config, no)
  fi

  if test "$PKG_CONFIG" = "no" ; then
     echo "*** The pkg-config script could not be found. Make sure it is"
     echo "*** in your path, or set the PKG_CONFIG environment variable"
     echo "*** to the full path to pkg-config."
     echo "*** Or see http://www.freedesktop.org/software/pkgconfig to get pkg-config."
  else
     PKG_CONFIG_MIN_VERSION=0.9.0
     if $PKG_CONFIG --atleast-pkgconfig-version $PKG_CONFIG_MIN_VERSION; then
        AC_MSG_CHECKING(for $2)

        if $PKG_CONFIG --exists "$2" ; then
            AC_MSG_RESULT(yes)
            succeeded=yes

            AC_MSG_CHECKING($1_CFLAGS)
            $1_CFLAGS=`$PKG_CONFIG --cflags "$2"`
            AC_MSG_RESULT($$1_CFLAGS)

            AC_MSG_CHECKING($1_LIBS)
            $1_LIBS=`$PKG_CONFIG --libs "$2"`
            AC_MSG_RESULT($$1_LIBS)
        else
            $1_CFLAGS=""
            $1_LIBS=""
            AC_MSG_RESULT([no])
        fi

        AC_SUBST($1_CFLAGS)
        AC_SUBST($1_LIBS)
     else
        echo "*** Your version of pkg-config is too old. You need version $PKG_CONFIG_MIN_VERSION or newer."
        echo "*** See http://www.freedesktop.org/software/pkgconfig"
     fi
  fi

  if test $succeeded = yes; then
     ifelse([$3], , :, [$3])
  else
     ifelse([$4], , AC_MSG_ERROR([Library requirements ($2) not met; consider adjusting the PKG_CONFIG_PATH environment variable if your libraries are in a nonstandard prefix so pkg-config can find them.]), [$4])
  fi
])

dnl PKG_CHECK_VERSION does the same as PKG_CHECK_MODULES except
dnl that it does not set *_CFLAGS and *_LIBS variables
dnl PKG_CHECK_VERSION(description, gtk+-2.0 >= 1.3 glib = 1.3.4, action-if, action-not)
AC_DEFUN([PKG_CHECK_VERSION], [
  succeeded=no

  if test -z "$PKG_CONFIG"; then
    AC_PATH_PROG(PKG_CONFIG, pkg-config, no)
  fi

  if test "$PKG_CONFIG" = "no" ; then
     echo "*** The pkg-config script could not be found. Make sure it is"
     echo "*** in your path, or set the PKG_CONFIG environment variable"
     echo "*** to the full path to pkg-config."
     echo "*** Or see http://www.freedesktop.org/software/pkgconfig to get pkg-config."
  else
     PKG_CONFIG_MIN_VERSION=0.9.0
     if $PKG_CONFIG --atleast-pkgconfig-version $PKG_CONFIG_MIN_VERSION; then
        AC_MSG_CHECKING(for $1)

        if $PKG_CONFIG --exists "$2" ; then
            AC_MSG_RESULT(yes)
            succeeded=yes
        else
            AC_MSG_RESULT([no])
        fi
     else
        echo "*** Your version of pkg-config is too old. You need version $PKG_CONFIG_MIN_VERSION or newer."
        echo "*** See http://www.freedesktop.org/software/pkgconfig"
     fi
  fi

  if test $succeeded = yes; then
     ifelse([$3], , :, [$3])
  else
     ifelse([$4], , AC_MSG_ERROR([Library requirements ($2) not met; consider adjusting the PKG_CONFIG_PATH environment variable if your libraries are in a nonstandard prefix so pkg-config can find them.]), [$4])
  fi
])

AC_DEFUN([PKG_CHECK_DBUS_GLIB], [

  PKG_CHECK_MODULES(DBUS_GLIB, dbus-glib-1 >= 0.70,
  [
    AC_DEFINE([HAVE_DBUS_GLIB], [1], [Define to 1 if you do not have gio dbus but do have dbus-glib.])
  ],
  [
    DBUS_GLIB_CFLAGS=""
    DBUS_GLIB_LIBS=""
    AC_SUBST(DBUS_GLIB_CFLAGS)
    AC_SUBST(DBUS_GLIB_LIBS)
  ])
])

AC_DEFUN([PKG_CHECK_GIO], [

  PKG_CHECK_MODULES(GIO, gio-2.0 >= 2.26.0,
  [
    AC_DEFINE([HAVE_GIO_DBUS], [1], [Define to 1 if you have the gio dbus implementation.])
    DBUS_GLIB_CFLAGS=""
    DBUS_GLIB_LIBS=""
    AC_SUBST(DBUS_GLIB_CFLAGS)
    AC_SUBST(DBUS_GLIB_LIBS)
  ],
  [ 
    PKG_CHECK_MODULES(GIO, gio-2.0 >= 2.16.0,
    [ : ],
    [
      GIO_CFLAGS=""
      GIO_LIBS=""
      AC_SUBST(GIO_CFLAGS)
      AC_SUBST(GIO_LIBS)
    ])

    PKG_CHECK_DBUS_GLIB
  ])
])

AC_DEFUN([AC_MEMORY_SLICES],
[
  AC_MSG_CHECKING(whether library is to use glib memory slices)
  AC_MSG_RESULT([ ])

  no_compat=""
  AC_ARG_WITH(glib-memory-slices-no-compat,
  [  --with-glib-memory-slices-no-compat   use glib memory slices to allocate memory on free store and do not keep compatibility with library compiled without this option [[default=no]]],
  [
    if test "x$withval" != "xno";  then
      AC_USE_GLIB_MEMORY_SLICES_NO_COMPAT="define CGU_USE_GLIB_MEMORY_SLICES_NO_COMPAT 1"
      AC_MSG_RESULT([    without keeping compatibility with the library compiled without slices: yes])
      no_compat="yes"
    else
      AC_USE_GLIB_MEMORY_SLICES_NO_COMPAT="undef CGU_USE_GLIB_MEMORY_SLICES_NO_COMPAT"
      AC_MSG_RESULT([    without keeping compatibility with the library compiled without slices: no])
    fi
  ]
  ,
  [
    AC_USE_GLIB_MEMORY_SLICES_NO_COMPAT="undef CGU_USE_GLIB_MEMORY_SLICES_NO_COMPAT"
    AC_MSG_RESULT([    without keeping compatibility with the library compiled without slices: no])
  ])
  AC_SUBST(AC_USE_GLIB_MEMORY_SLICES_NO_COMPAT)
  
  if test "x$no_compat" != "xyes";  then
    AC_ARG_WITH(glib-memory-slices-compat,
    [  --with-glib-memory-slices-compat   use glib memory slices to allocate memory on free store but keep compatibility with library compiled without this option [[default=no]]],
    [
      if test "x$withval" != "xno";  then
        AC_USE_GLIB_MEMORY_SLICES_COMPAT="define CGU_USE_GLIB_MEMORY_SLICES_COMPAT 1"
        AC_MSG_RESULT([    keeping compatibility with the library compiled without slices:         yes])
      else
        AC_USE_GLIB_MEMORY_SLICES_COMPAT="undef CGU_USE_GLIB_MEMORY_SLICES_COMPAT"
        AC_MSG_RESULT([    keeping compatibility with the library compiled without slices:         no])
      fi
    ]
    ,
    [
      AC_USE_GLIB_MEMORY_SLICES_COMPAT="undef CGU_USE_GLIB_MEMORY_SLICES_COMPAT"
      AC_MSG_RESULT([    keeping compatibility with the library compiled without slices:         no])
    ])
  else
    AC_USE_GLIB_MEMORY_SLICES_COMPAT="undef CGU_USE_GLIB_MEMORY_SLICES_COMPAT"
  fi
  
  AC_SUBST(AC_USE_GLIB_MEMORY_SLICES_COMPAT)
])

AC_DEFUN([AC_WITH_CGU_USING_DIRECTIVE],
[
  AC_MSG_CHECKING(whether library headers to incorporate Cgu using directive)

  AC_ARG_WITH(cgu-using-directive,
  [  --with-cgu-using-directive   whether library headers are to include a 'using namespace Cgu' directive [[default=no]]],
  [
    if test "x$withval" != "xno";  then
      AC_USING_NAMESPACE="using namespace Cgu;"
      AC_MSG_RESULT([yes])
    else
      AC_USING_NAMESPACE="// do not include using directive"
      AC_MSG_RESULT([no])
    fi
  ]
  ,
  [
    AC_USING_NAMESPACE="// do not include using directive"
    AC_MSG_RESULT([no])
  ])
  AC_SUBST(AC_USING_NAMESPACE)
])

AC_DEFUN([AC_WITH_SMART_PTR_COMPARISON],
[
  AC_MSG_CHECKING([whether ==, != and < operators to be available for smart pointers and handles])

  AC_ARG_WITH(smart-ptr-comp,
  [  --without-smart-ptr-comp   whether ==, != and < operators to be available for smart pointers and handles  [[default=with]]],
  [
    if test "x$withval" != "xno";  then
      AC_USE_SMART_PTR_COMPARISON="define CGU_USE_SMART_PTR_COMPARISON 1"
      AC_MSG_RESULT([yes])
    else
      AC_USE_SMART_PTR_COMPARISON="undef CGU_USE_SMART_PTR_COMPARISON"
      AC_MSG_RESULT([no])
    fi
  ]
  ,
  [
    AC_USE_SMART_PTR_COMPARISON="define CGU_USE_SMART_PTR_COMPARISON 1"
    AC_MSG_RESULT([yes])
  ])
  AC_SUBST(AC_USE_SMART_PTR_COMPARISON)
])

AC_DEFUN([AC_CHECK_HAVE_MONOTONIC_CLOCK],
[
  AC_MSG_CHECKING(whether the system supports monotonic clocks)
  AC_CACHE_VAL(ac_cv_have_monotonic_clock,
  [
    AC_RUN_IFELSE(
    [
      AC_LANG_PROGRAM(
      [
#include <unistd.h>
      ],
      [
        if (_POSIX_MONOTONIC_CLOCK > 0
	   && _POSIX_CLOCK_SELECTION > 0)
	   return 0;

        if (_POSIX_MONOTONIC_CLOCK == -1
	   || _POSIX_CLOCK_SELECTION == -1)
	    return -1;

        if (sysconf(_SC_MONOTONIC_CLOCK) > 0
	   && sysconf(_SC_CLOCK_SELECTION) > 0)
	   return 0;

        return -1;
      ])
    ],
    [
      ac_cv_have_monotonic_clock="yes"
    ],
    [
      ac_cv_have_monotonic_clock="no"
    ],
    [
      AC_MSG_RESULT([cross-compiling: ])
      ac_cv_have_monotonic_clock="no"
    ])
  ])

  AC_MSG_RESULT([$ac_cv_have_monotonic_clock])
  if test "$ac_cv_have_monotonic_clock" = "yes" ; then
    AC_DEFINE(HAVE_MONOTONIC_CLOCK, 1, [ Define if the system supports monotonic clocks ])
  fi
])

AC_DEFUN([AC_CHECK_HAVE_SCHED_YIELD],
[
  AC_MSG_CHECKING(for sched_yield)
  AC_CACHE_VAL(ac_cv_have_sched_yield,
  [
    AC_COMPILE_IFELSE(
    [
      AC_LANG_PROGRAM([
#include <sched.h>
      ],
      [
        sched_yield();
      ])
    ],
    [
      ac_cv_have_sched_yield="yes"
    ],
    [
      ac_cv_have_sched_yield="no"
    ]
    )
  ])

  AC_MSG_RESULT([$ac_cv_have_sched_yield])
  if test "$ac_cv_have_sched_yield" = "yes" ; then
    AC_USE_SCHED_YIELD="define CGU_USE_SCHED_YIELD 1"
  else
    AC_USE_SCHED_YIELD="undef CGU_USE_SCHED_YIELD"
  fi 
  AC_SUBST(AC_USE_SCHED_YIELD)
])

AC_DEFUN([AC_CHECK_HAVE_RECURSIVE_MUTEX],
[
  AC_MSG_CHECKING(whether headers include provision for recursive mutexes)
  AC_CACHE_VAL(ac_cv_have_recursive_mutex_headers,
  [
    AC_COMPILE_IFELSE(
    [
      AC_LANG_PROGRAM([
#define _XOPEN_SOURCE 600
#include <pthread.h>
      ],
      [
        pthread_mutexattr_t attr;
        pthread_mutexattr_init(&attr);
        pthread_mutexattr_settype(&attr, PTHREAD_MUTEX_RECURSIVE);
        pthread_mutexattr_destroy(&attr);
      ])
    ],
    [
      ac_cv_have_recursive_mutex_headers="yes"
    ],
    [
      ac_cv_have_recursive_mutex_headers="no"
    ]
    )
  ])

  AC_MSG_RESULT([$ac_cv_have_recursive_mutex_headers])
  if test "$ac_cv_have_recursive_mutex_headers" = "yes" ; then

    AC_DEFINE(HAVE_RECURSIVE_MUTEX_HEADERS, 1, [ Define if headers include provision for recursive mutexes ])

    AC_MSG_CHECKING(whether the runtime provides working recursive mutexes)
    AC_CACHE_VAL(ac_cv_have_recursive_mutex_runtime,
    [
      lib_save=$LIBS
      echo 'int main(void) { return 0; }' >conftest.c
      cgu_pthread_flag=no
      if test -z "`$CC -pthread -c conftest.c 2>&1`"; then
        if test -z "`$CC -pthread -o conftest conftest.o 2>&1`"; then
	  cgu_pthread_flag=yes
	fi
      fi
      rm -f conftest*
      if test "$cgu_pthread_flag" = "yes" ; then
        LIBS="-pthread"
	echo -n "using -pthread: "
      else
        dnl if -pthread (and so the gcc toolchain) isn't used
	dnl then -lpthread should be OK just for a run test
        LIBS="-lpthread"
      fi        
      AC_RUN_IFELSE(
      [
        AC_LANG_PROGRAM(
      	[
#define _XOPEN_SOURCE 600
#include <pthread.h>
        ],
      	[
          pthread_mutexattr_t attr;
	  if (pthread_mutexattr_init(&attr))
    	  return -1;
  	  if (pthread_mutexattr_settype(&attr, PTHREAD_MUTEX_RECURSIVE)) {
    	    pthread_mutexattr_destroy(&attr);
	    return -1;
  	  }
  	  pthread_mutexattr_destroy(&attr);
  	  return 0;
      	])
      ],
      [
        ac_cv_have_recursive_mutex_runtime="yes"
      ],
      [
        ac_cv_have_recursive_mutex_runtime="no"
      ],
      [
        AC_MSG_RESULT([cross-compiling: ])
      	ac_cv_have_recursive_mutex_runtime="no"
      ])
      LIBS=$lib_save
    ])
    
    AC_MSG_RESULT([$ac_cv_have_recursive_mutex_runtime])
    if test "$ac_cv_have_recursive_mutex_runtime" = "yes" ; then
      AC_HAVE_RECURSIVE_MUTEX_RUNTIME="define CGU_HAVE_RECURSIVE_MUTEX 1"
    else
      AC_HAVE_RECURSIVE_MUTEX_RUNTIME="undef CGU_HAVE_RECURSIVE_MUTEX"
    fi 
  else
    AC_HAVE_RECURSIVE_MUTEX_RUNTIME="undef CGU_HAVE_RECURSIVE_MUTEX"
  fi
  AC_SUBST(AC_HAVE_RECURSIVE_MUTEX_RUNTIME)
])

AC_DEFUN([AC_CHECK_HAVE_INHERITABLE_QUEUE],
[
  AC_MSG_CHECKING([for standard-conforming inheritable queue implementation])
  AC_CACHE_VAL(ac_cv_have_inheritable_queue,
  [
    AC_COMPILE_IFELSE(
    [
      AC_LANG_PROGRAM([
#include <queue>
#include <list>
class Q: public std::queue<int, std::list<int> > {
public:
  void splice_end(std::list<int>& lst) {
    this->c.splice(this->c.end(), lst);
  }
};
      ],
      [
        std::list<int> l;
	Q q;
	l.push_back(2);
	q.splice_end(l)
      ])
    ],
    [
      ac_cv_have_inheritable_queue="yes"
    ],
    [
      ac_cv_have_inheritable_queue="no"
    ]
    )
  ])

  AC_MSG_RESULT([$ac_cv_have_inheritable_queue])
  if test "$ac_cv_have_inheritable_queue" = "yes" ; then
    AC_USE_INHERITABLE_QUEUE="define CGU_USE_INHERITABLE_QUEUE 1"
  else
    AC_USE_INHERITABLE_QUEUE="undef CGU_USE_INHERITABLE_QUEUE"
  fi 
  AC_SUBST(AC_USE_INHERITABLE_QUEUE)
])

AC_DEFUN([AC_WITH_GTK4],
[
  AC_MSG_CHECKING(whether to compile with GTK+ support)

  AC_ARG_WITH(gtk,
  [  --without-gtk 	  whether the library is to be compiled without GTK+ support  [[default=with]]],
  [  
    if test "x$withval" != "xno";  then
      AC_USE_GTK="define CGU_USE_GTK 4"
      AC_MSG_RESULT([yes])
      PKG_CHECK_MODULES(GTK, gtk4 >= 3.98.4)
      PKG_CHECK_MODULES(GTK_UNIX_PRINT, gtk4-unix-print >= 3.98.4)
      COND_TESTS="tests"
    else
      AC_USE_GTK="undef CGU_USE_GTK"
      AC_MSG_RESULT([no])
      COND_TESTS=""
    fi
  ]
  ,
  [
    AC_USE_GTK="define CGU_USE_GTK 4"
    AC_MSG_RESULT([yes])
    PKG_CHECK_MODULES(GTK, gtk4 >= 3.98.4)
    PKG_CHECK_MODULES(GTK_UNIX_PRINT, gtk4-unix-print >= 3.98.4)
    COND_TESTS="tests"
  ])
  AC_SUBST(AC_USE_GTK)
  AC_SUBST(COND_TESTS)
])

AC_DEFUN([AC_WITH_GTK3],
[
  AC_MSG_CHECKING(whether to compile with GTK+ support)

  AC_ARG_WITH(gtk,
  [  --without-gtk 	  whether the library is to be compiled without GTK+ support  [[default=with]]],
  [  
    if test "x$withval" != "xno";  then
      AC_USE_GTK="define CGU_USE_GTK 3"
      AC_MSG_RESULT([yes])
      PKG_CHECK_MODULES(GTK, gtk+-3.0 >= 2.90.0)
      PKG_CHECK_MODULES(GTK_UNIX_PRINT, gtk+-unix-print-3.0 >= 2.90.0)
      COND_TESTS="tests"
    else
      AC_USE_GTK="undef CGU_USE_GTK"
      AC_MSG_RESULT([no])
      COND_TESTS=""
    fi
  ]
  ,
  [
    AC_USE_GTK="define CGU_USE_GTK 3"
    AC_MSG_RESULT([yes])
    PKG_CHECK_MODULES(GTK, gtk+-3.0 >= 2.90.0)
    PKG_CHECK_MODULES(GTK_UNIX_PRINT, gtk+-unix-print-3.0 >= 2.90.0)
    COND_TESTS="tests"
  ])
  AC_SUBST(AC_USE_GTK)
  AC_SUBST(COND_TESTS)
])

AC_DEFUN([AC_WITH_GTK2],
[
  AC_MSG_CHECKING(whether to compile with GTK+ support)

  AC_ARG_WITH(gtk,
  [  --without-gtk 	  whether the library is to be compiled without GTK+ support  [[default=with]]],
  [  
    if test "x$withval" != "xno";  then
      AC_USE_GTK="define CGU_USE_GTK 2"
      AC_MSG_RESULT([yes])
      PKG_CHECK_MODULES(GTK, gtk+-2.0 >= 2.10.0)
      PKG_CHECK_MODULES(GTK_UNIX_PRINT, gtk+-unix-print-2.0 >= 2.10.0)
      PKG_CHECK_VERSION(tests, gtk+-2.0 >= 2.14.0,
      [
        COND_TESTS="tests"
      ],
      [
        COND_TESTS=""
      ])
    else
      AC_USE_GTK="undef CGU_USE_GTK"
      AC_MSG_RESULT([no])
      COND_TESTS=""
    fi
  ]
  ,
  [
    AC_USE_GTK="define CGU_USE_GTK 2"
    AC_MSG_RESULT([yes])
    PKG_CHECK_MODULES(GTK, gtk+-2.0 >= 2.10.0)
    PKG_CHECK_MODULES(GTK_UNIX_PRINT, gtk+-unix-print-2.0 >= 2.10.0)
    PKG_CHECK_VERSION(tests, gtk+-2.0 >= 2.14.0,
    [
      COND_TESTS="tests"
    ],
    [
      COND_TESTS=""
    ])
  ])
  AC_SUBST(AC_USE_GTK)
  AC_SUBST(COND_TESTS)
])

AC_DEFUN([AC_GUILE_BROKEN_LINKING],
[
  AC_GUILE_HAS_BROKEN_LINKING="define CGU_GUILE_HAS_BROKEN_LINKING 1"

  if test -z "$PKG_CONFIG"; then
    AC_PATH_PROG(PKG_CONFIG, pkg-config, no)
  fi

  if test "$PKG_CONFIG" = "no" ; then
    echo "*** The pkg-config script could not be found. Make sure it is"
    echo "*** in your path, or set the PKG_CONFIG environment variable"
    echo "*** to the full path to pkg-config."
    echo "*** Or see http://www.freedesktop.org/software/pkgconfig to get pkg-config."
  else
    AC_MSG_CHECKING(whether libguile links scm_dynwind_block_asyncs)
    libs_saved=$LIBS
    cxxflags_saved=$CXXFLAGS
    cflags_saved=$CFLAGS
    LIBS=`$PKG_CONFIG --libs guile-2.0`
    CXXFLAGS=`$PKG_CONFIG --cflags guile-2.0`
    CFLAGS=$CXXFLAGS
    AC_LINK_IFELSE(
    [
      AC_LANG_PROGRAM([
#include <libguile.h>
      ],
      [
        scm_dynwind_begin((scm_t_dynwind_flags)0);
        scm_dynwind_block_asyncs();
        scm_dynwind_end();
      ])
    ],
    [
      ac_cv_guile_can_link="yes"
      AC_GUILE_HAS_BROKEN_LINKING="undef CGU_GUILE_HAS_BROKEN_LINKING"
    ],
    [
      ac_cv_guile_can_link="no"
    ])
    AC_MSG_RESULT([$ac_cv_guile_can_link])

    LIBS=$libs_saved
    CXXFLAGS=$cxxflags_saved
    CFLAGS=$cflags_saved
  fi
])

AC_DEFUN([AC_WITH_GUILE],
[
  AC_MSG_CHECKING(whether to configure for guile and run extension tests)
  
  AC_ARG_WITH(guile,
  [  --with-guile            whether to offer support for guile extensions [(yes, 3.0, 2.2, 2.0, no, auto)] [[default=auto]]],
  [
    if test "x$withval" = "xno" ; then
      AC_MSG_RESULT([no])
      AC_USE_GUILE="undef CGU_USE_GUILE"
      AC_GUILE_HAS_BROKEN_LINKING="define CGU_GUILE_HAS_BROKEN_LINKING 1"
    elif test "x$withval" = "xyes" ; then
      AC_MSG_RESULT([yes])
      PKG_CHECK_MODULES(GUILE, guile-3.0 >= 3.0.0,
      [
        AC_USE_GUILE="define CGU_USE_GUILE 1"
        AC_GUILE_HAS_BROKEN_LINKING="undef CGU_GUILE_HAS_BROKEN_LINKING"
      ],
      [
        PKG_CHECK_MODULES(GUILE, guile-2.2 >= 2.1.3,
      	[
          AC_USE_GUILE="define CGU_USE_GUILE 1"
          AC_GUILE_HAS_BROKEN_LINKING="undef CGU_GUILE_HAS_BROKEN_LINKING"
      	],
      	[
	  PKG_CHECK_MODULES(GUILE, guile-2.0 >= 2.0.2)
	  AC_USE_GUILE="define CGU_USE_GUILE 1"
	  AC_GUILE_BROKEN_LINKING
	])
      ])
    elif test "x$withval" = "x3.0" ; then
      AC_MSG_RESULT([guile-3.0])
      PKG_CHECK_MODULES(GUILE, guile-3.0 >= 3.0.0)
      AC_USE_GUILE="define CGU_USE_GUILE 1"
      AC_GUILE_HAS_BROKEN_LINKING="undef CGU_GUILE_HAS_BROKEN_LINKING"
    elif test "x$withval" = "x2.2" ; then
      AC_MSG_RESULT([guile-2.2])
      PKG_CHECK_MODULES(GUILE, guile-2.2 >= 2.1.3)
      AC_USE_GUILE="define CGU_USE_GUILE 1"
      AC_GUILE_HAS_BROKEN_LINKING="undef CGU_GUILE_HAS_BROKEN_LINKING"
    elif test "x$withval" = "x2.0" ; then
      AC_MSG_RESULT([guile-2.0])
      PKG_CHECK_MODULES(GUILE, guile-2.0 >= 2.0.2)
      AC_USE_GUILE="define CGU_USE_GUILE 1"
      AC_GUILE_BROKEN_LINKING
    else
      AC_MSG_RESULT([auto])
      PKG_CHECK_MODULES(GUILE, guile-3.0 >= 3.0.0,
      [
        AC_USE_GUILE="define CGU_USE_GUILE 1"
        AC_GUILE_HAS_BROKEN_LINKING="undef CGU_GUILE_HAS_BROKEN_LINKING"
      ],
      [
        PKG_CHECK_MODULES(GUILE, guile-2.2 >= 2.1.3,
        [
	  AC_USE_GUILE="define CGU_USE_GUILE 1"
	  AC_GUILE_HAS_BROKEN_LINKING="undef CGU_GUILE_HAS_BROKEN_LINKING"
	],
      	[
	  PKG_CHECK_MODULES(GUILE, guile-2.0 >= 2.0.2,
          [
	    AC_USE_GUILE="define CGU_USE_GUILE 1"
	    AC_GUILE_BROKEN_LINKING
	  ],      
	  [
	    AC_USE_GUILE="undef CGU_USE_GUILE"
	    AC_GUILE_HAS_BROKEN_LINKING="define CGU_GUILE_HAS_BROKEN_LINKING 1"
	  ])
        ])
      ])
    fi
  ],
  [
    AC_MSG_RESULT([auto])
    PKG_CHECK_MODULES(GUILE, guile-3.0 >= 3.0.0,
    [
      AC_USE_GUILE="define CGU_USE_GUILE 1"
      AC_GUILE_HAS_BROKEN_LINKING="undef CGU_GUILE_HAS_BROKEN_LINKING"
    ],
    [
      PKG_CHECK_MODULES(GUILE, guile-2.2 >= 2.1.3,
      [
        AC_USE_GUILE="define CGU_USE_GUILE 1"
        AC_GUILE_HAS_BROKEN_LINKING="undef CGU_GUILE_HAS_BROKEN_LINKING"
      ],
      [
        PKG_CHECK_MODULES(GUILE, guile-2.0 >= 2.0.2,
      	[
	  AC_USE_GUILE="define CGU_USE_GUILE 1"
	  AC_GUILE_BROKEN_LINKING
        ],      
      	[
	  AC_USE_GUILE="undef CGU_USE_GUILE"
	  AC_GUILE_HAS_BROKEN_LINKING="define CGU_GUILE_HAS_BROKEN_LINKING 1"
	])
      ])
    ])
  ])
  AC_SUBST(AC_USE_GUILE)
  AC_SUBST(AC_GUILE_HAS_BROKEN_LINKING)
])

AC_DEFUN([AC_WITH_TUPLE],
[
  AC_MSG_CHECKING([whether to use std::tuple implementation of callback classes])

  ac_cv_compile_test="yes"
  AC_ARG_WITH([tuple],
  [  --with-tuple            whether to use std::tuple implementation of callback classes [(yes, no, auto)] [[default=auto]]],
  [
    if test "x$withval" = "xno" ; then
      AC_MSG_RESULT([no])
      AC_USE_TUPLE="undef CGU_USE_TUPLE"
      ac_cv_compile_test="no"
    elif test "x$withval" = "xyes" ; then
      AC_MSG_RESULT([yes])
      AC_USE_TUPLE="define CGU_USE_TUPLE 1"
      ac_cv_compile_test="no"
    fi
  ],
  [])
  
  if test $ac_cv_compile_test = "yes"; then
    AC_COMPILE_IFELSE(
    [
      AC_LANG_PROGRAM([],
      [
#if defined (__GNUC__) \
    && (__GNUC__ > 4 \
        || (__GNUC__ == 4 && __GNUC_MINOR__ > 7) \
        || (defined (__clang__) && (__clang_major__ > 3 \
	                            || (__clang_major__ == 3 && __clang_minor__ > 3))))
  return 0;
#elif defined (__clang__) && (__clang_major__ > 3 \
	                      || (__clang_major__ == 3 && __clang_minor__ > 3))
  return 0;
#else
  let us fail to compile
#endif
      ])
    ],
    [
      AC_MSG_RESULT([yes])
      AC_USE_TUPLE="define CGU_USE_TUPLE 1"
    ],
    [
      AC_MSG_RESULT([no])
      AC_USE_TUPLE="undef CGU_USE_TUPLE"
    ])
  fi
  AC_SUBST(AC_USE_TUPLE)
])

AC_DEFUN([AC_CHECK_IO_WATCH_BACKEND],
[
  AC_MSG_CHECKING(which glib fd backend to use for io watch)

  AC_ARG_WITH(glib-fd-backend,
  [  --with-glib-fd-backend  whether to use unix or GPollFD backend [(unix, gpollfd, auto)] [[default=auto]]],
  [
    if test "x$withval" = "xunix" ;  then
      AC_MSG_RESULT([unix])
      PKG_CHECK_VERSION([glib >= 2.36], glib-2.0 >= 2.36.0,
      [
        AC_DEFINE([HAVE_UNIX_FD_BACKEND], [1], [Define to 1 to use the glib unix fd backend.])
      ],
      [
        AC_MSG_ERROR([glib >= 2.36 must be installed for unix fd backend; consider adjusting the PKG_CONFIG_PATH
environment variable if your libraries are in a nonstandard prefix so pkg-config can find them])
      ])
    elif test "x$withval" = "xgpollfd" ;  then
      AC_MSG_RESULT([gpollfd])
    elif test "x$withval" = "xauto" ;  then
      AC_MSG_RESULT([auto])
      PKG_CHECK_VERSION([glib >= 2.36], glib-2.0 >= 2.36.0,
      [
        AC_DEFINE([HAVE_UNIX_FD_BACKEND], [1], [Define to 1 to use the glib unix fd backend.])
      ],
      [
        :
      ])
    else
      AC_MSG_ERROR([incorrect glib fd backend specified - should be unix, gpollfd or auto])
    fi
  ],
  [
    AC_MSG_RESULT([auto])
    PKG_CHECK_VERSION([glib >= 2.36], glib-2.0 >= 2.36.0,
    [
      AC_DEFINE([HAVE_UNIX_FD_BACKEND], [1], [Define to 1 to use the glib unix fd backend.])
    ],
    [
      :
    ])
  ])
])

AC_DEFUN([AC_CHECK_HAVE_DIAGNOSTIC_PRAGMAS],
[
  AC_MSG_CHECKING(for gcc diagnostic pragmas)
  AC_CACHE_VAL(ac_cv_have_diagnostic_pragmas,
  [
    AC_COMPILE_IFELSE(
    [
      AC_LANG_PROGRAM([
      ],
      [
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#pragma GCC diagnostic push
#pragma GCC diagnostic pop
      ])
    ],
    [
      ac_cv_have_diagnostic_pragmas="yes"
    ],
    [
      ac_cv_have_diagnostic_pragmas="no"
    ]
    )
  ])

  AC_MSG_RESULT([$ac_cv_have_diagnostic_pragmas])
  if test "$ac_cv_have_diagnostic_pragmas" = "yes" ; then
    AC_USE_DIAGNOSTIC_PRAGMAS="define CGU_USE_DIAGNOSTIC_PRAGMAS 1"
  else
    AC_USE_DIAGNOSTIC_PRAGMAS="undef CGU_USE_DIAGNOSTIC_PRAGMAS"
  fi 
  AC_SUBST(AC_USE_DIAGNOSTIC_PRAGMAS)
])
