'use client';
import { jsxs, jsx } from 'react/jsx-runtime';
import 'react';
import { getRadius } from '../../core/utils/get-size/get-size.mjs';
import '@mantine/hooks';
import { createVarsResolver } from '../../core/styles-api/create-vars-resolver/create-vars-resolver.mjs';
import 'clsx';
import { getThemeColor } from '../../core/MantineProvider/color-functions/get-theme-color/get-theme-color.mjs';
import '../../core/MantineProvider/Mantine.context.mjs';
import '../../core/MantineProvider/default-theme.mjs';
import '../../core/MantineProvider/MantineProvider.mjs';
import '../../core/MantineProvider/MantineThemeProvider/MantineThemeProvider.mjs';
import { useProps } from '../../core/MantineProvider/use-props/use-props.mjs';
import '../../core/MantineProvider/MantineCssVariables/MantineCssVariables.mjs';
import { useStyles } from '../../core/styles-api/use-styles/use-styles.mjs';
import { Box } from '../../core/Box/Box.mjs';
import { factory } from '../../core/factory/factory.mjs';
import '../../core/DirectionProvider/DirectionProvider.mjs';
import '../CloseButton/CloseIcon.mjs';
import { CloseButton } from '../CloseButton/CloseButton.mjs';
import { Loader } from '../Loader/Loader.mjs';
import classes from './Notification.module.css.mjs';

const defaultProps = {
  withCloseButton: true
};
const varsResolver = createVarsResolver((theme, { radius, color }) => ({
  root: {
    "--notification-radius": radius === void 0 ? void 0 : getRadius(radius),
    "--notification-color": color ? getThemeColor(color, theme) : void 0
  }
}));
const Notification = factory((_props, ref) => {
  const props = useProps("Notification", defaultProps, _props);
  const {
    className,
    color,
    radius,
    loading,
    withCloseButton,
    withBorder,
    title,
    icon,
    children,
    onClose,
    closeButtonProps,
    classNames,
    style,
    styles,
    unstyled,
    variant,
    vars,
    mod,
    loaderProps,
    ...others
  } = props;
  const getStyles = useStyles({
    name: "Notification",
    classes,
    props,
    className,
    style,
    classNames,
    styles,
    unstyled,
    vars,
    varsResolver
  });
  return /* @__PURE__ */ jsxs(
    Box,
    {
      ...getStyles("root"),
      mod: [{ "data-with-icon": !!icon || loading, "data-with-border": withBorder }, mod],
      ref,
      variant,
      ...others,
      role: "alert",
      children: [
        icon && !loading && /* @__PURE__ */ jsx("div", { ...getStyles("icon"), children: icon }),
        loading && /* @__PURE__ */ jsx(Loader, { size: 28, color, ...loaderProps, ...getStyles("loader") }),
        /* @__PURE__ */ jsxs("div", { ...getStyles("body"), children: [
          title && /* @__PURE__ */ jsx("div", { ...getStyles("title"), children: title }),
          /* @__PURE__ */ jsx(Box, { ...getStyles("description"), mod: { "data-with-title": !!title }, children })
        ] }),
        withCloseButton && /* @__PURE__ */ jsx(
          CloseButton,
          {
            iconSize: 16,
            color: "gray",
            ...closeButtonProps,
            unstyled,
            onClick: onClose,
            ...getStyles("closeButton")
          }
        )
      ]
    }
  );
});
Notification.classes = classes;
Notification.displayName = "@mantine/core/Notification";

export { Notification };
//# sourceMappingURL=Notification.mjs.map
