import{jsx as _jsx,jsxs as _jsxs}from"react/jsx-runtime";import React,{useEffect,useState}from"react";import{Filter,Trash2}from"lucide-react";import classes from"./RemotePersistentFilterDropdown.module.css";import{Combobox,Group,useCombobox}from"@mantine/core";import{useTranslation}from"react-i18next";import{Tooltip}from"../../Tooltip";const RemotePersistentFilterDropdown=({remotePersistentFilters,onSelect,onDelete})=>{const{t}=useTranslation();const[filterDropdownList,setFilterDropdownList]=useState([]);const[selectedFilter,setSelectedFilter]=useState();useEffect(()=>{if(remotePersistentFilters){const dropdownList=remotePersistentFilters.map(filter=>{return{value:filter.id,label:filter.filterName}});setFilterDropdownList(dropdownList)}},[remotePersistentFilters]);const combobox=useCombobox();const handleClick=()=>{combobox.toggleDropdown()};useEffect(()=>{if(selectedFilter){onSelect(selectedFilter)}},[selectedFilter]);const handleSelect=filter=>{if(filter){combobox.closeDropdown();setSelectedFilter(filter)}};const handleDelete=(e,filterId)=>{e.stopPropagation();if(window.confirm(t("Do you really want to delete this filter?"))){onDelete(filterId)}};const options=filterDropdownList.sort((a,b)=>a.label.localeCompare(b.label)).map(item=>_jsx(Combobox.Option,{"data-testid":"dropdown-option",value:item.value,children:_jsxs(Group,{className:classes.options,children:[item.label.length>35?_jsx(Tooltip,{label:item.label,children:_jsx("span",{className:classes["truncate-text"],children:item.label})}):_jsx("span",{children:item.label}),_jsx(Tooltip,{label:t("Delete filter"),children:_jsx(Trash2,{"data-testid":"delete-icon",color:"red",size:16,className:classes["options-label"],onClick:e=>handleDelete(e,item.value)})})]})},item.value));const emptyOption=_jsx(Combobox.Option,{value:"",children:_jsx(Group,{className:classes.options,children:_jsx("span",{children:t("No filters available")})})},"");return _jsxs(Combobox,{store:combobox,width:300,position:"bottom-start",withArrow:true,onOptionSubmit:handleSelect,children:[_jsx(Combobox.Target,{children:_jsx("div",{"data-testid":"filter-icon",className:classes.actions,onClick:handleClick,children:_jsx(Tooltip,{offset:15,label:t("Saved filters"),children:_jsx(Filter,{"data-testid":"filter-chevron-image",color:"var(--filter-chevron-color)",size:16})})})}),_jsx(Combobox.Dropdown,{children:_jsx(Combobox.Options,{children:options.length>0?options:emptyOption})})]})};export{RemotePersistentFilterDropdown};
//# sourceMappingURL=RemotePersistentFilterDropdown.js.map