"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LifecycleContextProvider = LifecycleContextProvider;
exports.useLifecycle = useLifecycle;
exports.useMonitorForLifecycle = useMonitorForLifecycle;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _combine = require("@atlaskit/pragmatic-drag-and-drop/combine");
var _batchUpdatesForReact = require("../utils/batch-updates-for-react-16");
var _rbdInvariant = require("./rbd-invariant");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t.return || t.return(); } finally { if (u) throw o; } } }; }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; } /**
 * The lifecycle methods owned by this provided are used to align internal
 * timings with those of the rbd lifecycle.
 *
 * The events are intentionally distinct to those exposed by rbd to avoid
 * any confusion around whether events are fired internally or externally
 * first.
 */ // eslint-disable-next-line import/no-extraneous-dependencies
/**
 * The data associated with each type of lifecycle event.
 */

function createRegistry() {
  return {
    onPendingDragStart: [],
    onPrePendingDragUpdate: [],
    onPendingDragUpdate: [],
    onBeforeDragEnd: []
  };
}
function createLifecycleManager() {
  var registry = createRegistry();
  var addResponder = function addResponder(event, responder) {
    registry[event].push(responder);
    return function () {
      // @ts-expect-error - type narrowing issues
      registry[event] = registry[event].filter(function (value) {
        return value !== responder;
      });
    };
  };
  var dispatch = function dispatch(event, data) {
    (0, _batchUpdatesForReact.batchUpdatesForReact16)(function () {
      var _iterator = _createForOfIteratorHelper(registry[event]),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var _responder = _step.value;
          _responder(data);
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    });
  };
  return {
    addResponder: addResponder,
    dispatch: dispatch
  };
}

/**
 * Creates a new lifecycle manager, returning methods for interfacing with it.
 */
function useLifecycle() {
  var _useState = (0, _react.useState)(createLifecycleManager),
    _useState2 = (0, _slicedToArray2.default)(_useState, 1),
    lifecycleManager = _useState2[0];
  return lifecycleManager;
}
var LifecycleContext = /*#__PURE__*/(0, _react.createContext)(null);
function LifecycleContextProvider(_ref) {
  var children = _ref.children,
    lifecycle = _ref.lifecycle;
  /**
   * Allows for `<Draggable>` and `<Droppable>` instances to know about the
   * lifecycle timings.
   *
   * Designed to have a similar API to the pdnd monitors.
   */
  var monitorForLifecycle = (0, _react.useCallback)(function (responders) {
    var cleanupFns = [];
    for (var _i = 0, _Object$entries = Object.entries(responders); _i < _Object$entries.length; _i++) {
      var entry = _Object$entries[_i];
      var _ref2 = entry,
        _ref3 = (0, _slicedToArray2.default)(_ref2, 2),
        _event = _ref3[0],
        _responder2 = _ref3[1];
      cleanupFns.push(lifecycle.addResponder(_event, _responder2));
    }
    return _combine.combine.apply(void 0, cleanupFns);
  }, [lifecycle]);
  return /*#__PURE__*/_react.default.createElement(LifecycleContext.Provider, {
    value: monitorForLifecycle
  }, children);
}
function useMonitorForLifecycle() {
  var monitorForLifecycle = (0, _react.useContext)(LifecycleContext);
  (0, _rbdInvariant.rbdInvariant)(monitorForLifecycle !== null, 'useLifecycle() should only be called inside of a <DragDropContext />');
  return monitorForLifecycle;
}