"use strict";

var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DragDropContextProvider = DragDropContextProvider;
exports.useDragDropContext = useDragDropContext;
var _react = _interopRequireWildcard(require("react"));
var _rbdInvariant = require("./rbd-invariant");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var DragDropContext = /*#__PURE__*/(0, _react.createContext)(null);
function useDragDropContext() {
  var value = (0, _react.useContext)(DragDropContext);
  (0, _rbdInvariant.rbdInvariant)(value !== null, 'Unable to find DragDropContext context');
  return value;
}
function DragDropContextProvider(_ref) {
  var children = _ref.children,
    contextId = _ref.contextId,
    getDragState = _ref.getDragState,
    startKeyboardDrag = _ref.startKeyboardDrag,
    droppableRegistry = _ref.droppableRegistry;
  var value = (0, _react.useMemo)(function () {
    return {
      contextId: contextId,
      getDragState: getDragState,
      startKeyboardDrag: startKeyboardDrag,
      droppableRegistry: droppableRegistry
    };
  }, [contextId, getDragState, startKeyboardDrag, droppableRegistry]);
  return /*#__PURE__*/_react.default.createElement(DragDropContext.Provider, {
    value: value
  }, children);
}