/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;

public class ConcatenatingAxisIterator
implements AxisIterator {
    AxisIterator first;
    AxisIterator second;
    AxisIterator active;

    public ConcatenatingAxisIterator(AxisIterator first, AxisIterator second) {
        this.first = first;
        this.second = second;
        this.active = first;
    }

    public static AxisIterator makeConcatenatingIterator(AxisIterator first, AxisIterator second) {
        if (first instanceof EmptyIterator.OfNodes) {
            return second;
        }
        if (second instanceof EmptyIterator.OfNodes) {
            return first;
        }
        return new ConcatenatingAxisIterator(first, second);
    }

    @Override
    public NodeInfo next() {
        NodeInfo n = this.active.next();
        if (n == null && this.active == this.first) {
            this.active = this.second;
            n = this.second.next();
        }
        return n;
    }

    @Override
    public void close() {
        this.first.close();
        this.second.close();
    }

    @Override
    public int getProperties() {
        return 0;
    }
}

