/***************************************************************************
 *   Copyright (C) 2005 by Karye   *
 *   karye@users.sourceforge.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef KUROOINIT_H
#define KUROOINIT_H

#include <KProcess>
#include <QObject>
#include <qobject.h>      // for QObject
#include <qobjectdefs.h>  // for Q_OBJECT, slots
#include <qstring.h>      // for QString
#include <qstringlist.h>  // for QStringList

class IntroDlg;
class KProcess;
class QWidget;

/**
 * @class KurooInit
 * @short Checks that kuroo environment is correctly setup.
 */
class KurooInit : public QObject
{
Q_OBJECT
public:
	KurooInit( QWidget *parent = nullptr );
	~KurooInit();

	static void 	firstTimeWizard();
	void 			getEnvironment();
	static void		checkUser( QWidget *parent );

private Q_SLOTS:
	void			slotCollectOutput();
	void			slotEmergeInfo();

private:
	KProcess*       eProc;
	IntroDlg 		*wizardDialog;
	QStringList		m_emergeInfoLines;

	static void		checkEtcFiles();
};

#endif
