// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/pubsublite/v1/common.proto

package pubsublite

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// When this subscription should send messages to subscribers relative to
// messages persistence in storage. For details, see [Creating Lite
// subscriptions](https://cloud.google.com/pubsub/lite/docs/subscriptions#creating_lite_subscriptions).
type Subscription_DeliveryConfig_DeliveryRequirement int32

const (
	// Default value. This value is unused.
	Subscription_DeliveryConfig_DELIVERY_REQUIREMENT_UNSPECIFIED Subscription_DeliveryConfig_DeliveryRequirement = 0
	// The server does not wait for a published message to be successfully
	// written to storage before delivering it to subscribers.
	Subscription_DeliveryConfig_DELIVER_IMMEDIATELY Subscription_DeliveryConfig_DeliveryRequirement = 1
	// The server will not deliver a published message to subscribers until
	// the message has been successfully written to storage. This will result
	// in higher end-to-end latency, but consistent delivery.
	Subscription_DeliveryConfig_DELIVER_AFTER_STORED Subscription_DeliveryConfig_DeliveryRequirement = 2
)

// Enum value maps for Subscription_DeliveryConfig_DeliveryRequirement.
var (
	Subscription_DeliveryConfig_DeliveryRequirement_name = map[int32]string{
		0: "DELIVERY_REQUIREMENT_UNSPECIFIED",
		1: "DELIVER_IMMEDIATELY",
		2: "DELIVER_AFTER_STORED",
	}
	Subscription_DeliveryConfig_DeliveryRequirement_value = map[string]int32{
		"DELIVERY_REQUIREMENT_UNSPECIFIED": 0,
		"DELIVER_IMMEDIATELY":              1,
		"DELIVER_AFTER_STORED":             2,
	}
)

func (x Subscription_DeliveryConfig_DeliveryRequirement) Enum() *Subscription_DeliveryConfig_DeliveryRequirement {
	p := new(Subscription_DeliveryConfig_DeliveryRequirement)
	*p = x
	return p
}

func (x Subscription_DeliveryConfig_DeliveryRequirement) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Subscription_DeliveryConfig_DeliveryRequirement) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_pubsublite_v1_common_proto_enumTypes[0].Descriptor()
}

func (Subscription_DeliveryConfig_DeliveryRequirement) Type() protoreflect.EnumType {
	return &file_google_cloud_pubsublite_v1_common_proto_enumTypes[0]
}

func (x Subscription_DeliveryConfig_DeliveryRequirement) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Subscription_DeliveryConfig_DeliveryRequirement.Descriptor instead.
func (Subscription_DeliveryConfig_DeliveryRequirement) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP(), []int{6, 0, 0}
}

// An export state.
type ExportConfig_State int32

const (
	// Default value. This value is unused.
	ExportConfig_STATE_UNSPECIFIED ExportConfig_State = 0
	// Messages are being exported.
	ExportConfig_ACTIVE ExportConfig_State = 1
	// Exporting messages is suspended.
	ExportConfig_PAUSED ExportConfig_State = 2
)

// Enum value maps for ExportConfig_State.
var (
	ExportConfig_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "PAUSED",
	}
	ExportConfig_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"PAUSED":            2,
	}
)

func (x ExportConfig_State) Enum() *ExportConfig_State {
	p := new(ExportConfig_State)
	*p = x
	return p
}

func (x ExportConfig_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExportConfig_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_pubsublite_v1_common_proto_enumTypes[1].Descriptor()
}

func (ExportConfig_State) Type() protoreflect.EnumType {
	return &file_google_cloud_pubsublite_v1_common_proto_enumTypes[1]
}

func (x ExportConfig_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExportConfig_State.Descriptor instead.
func (ExportConfig_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP(), []int{7, 0}
}

// The values associated with a key of an attribute.
type AttributeValues struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of values associated with a key.
	Values [][]byte `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *AttributeValues) Reset() {
	*x = AttributeValues{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttributeValues) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttributeValues) ProtoMessage() {}

func (x *AttributeValues) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttributeValues.ProtoReflect.Descriptor instead.
func (*AttributeValues) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP(), []int{0}
}

func (x *AttributeValues) GetValues() [][]byte {
	if x != nil {
		return x.Values
	}
	return nil
}

// A message that is published by publishers and delivered to subscribers.
type PubSubMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key used for routing messages to partitions or for compaction (e.g.,
	// keep the last N messages per key). If the key is empty, the message is
	// routed to an arbitrary partition.
	Key []byte `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The payload of the message.
	Data []byte `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	// Optional attributes that can be used for message metadata/headers.
	Attributes map[string]*AttributeValues `protobuf:"bytes,3,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// An optional, user-specified event time.
	EventTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=event_time,json=eventTime,proto3" json:"event_time,omitempty"`
}

func (x *PubSubMessage) Reset() {
	*x = PubSubMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PubSubMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PubSubMessage) ProtoMessage() {}

func (x *PubSubMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PubSubMessage.ProtoReflect.Descriptor instead.
func (*PubSubMessage) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP(), []int{1}
}

func (x *PubSubMessage) GetKey() []byte {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *PubSubMessage) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *PubSubMessage) GetAttributes() map[string]*AttributeValues {
	if x != nil {
		return x.Attributes
	}
	return nil
}

func (x *PubSubMessage) GetEventTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EventTime
	}
	return nil
}

// A cursor that describes the position of a message within a topic partition.
type Cursor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The offset of a message within a topic partition. Must be greater than or
	// equal 0.
	Offset int64 `protobuf:"varint,1,opt,name=offset,proto3" json:"offset,omitempty"`
}

func (x *Cursor) Reset() {
	*x = Cursor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Cursor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Cursor) ProtoMessage() {}

func (x *Cursor) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Cursor.ProtoReflect.Descriptor instead.
func (*Cursor) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP(), []int{2}
}

func (x *Cursor) GetOffset() int64 {
	if x != nil {
		return x.Offset
	}
	return 0
}

// A message that has been stored and sequenced by the Pub/Sub Lite system.
type SequencedMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The position of a message within the partition where it is stored.
	Cursor *Cursor `protobuf:"bytes,1,opt,name=cursor,proto3" json:"cursor,omitempty"`
	// The time when the message was received by the server when it was first
	// published.
	PublishTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=publish_time,json=publishTime,proto3" json:"publish_time,omitempty"`
	// The user message.
	Message *PubSubMessage `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
	// The size in bytes of this message for flow control and quota purposes.
	SizeBytes int64 `protobuf:"varint,4,opt,name=size_bytes,json=sizeBytes,proto3" json:"size_bytes,omitempty"`
}

func (x *SequencedMessage) Reset() {
	*x = SequencedMessage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SequencedMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SequencedMessage) ProtoMessage() {}

func (x *SequencedMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SequencedMessage.ProtoReflect.Descriptor instead.
func (*SequencedMessage) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP(), []int{3}
}

func (x *SequencedMessage) GetCursor() *Cursor {
	if x != nil {
		return x.Cursor
	}
	return nil
}

func (x *SequencedMessage) GetPublishTime() *timestamppb.Timestamp {
	if x != nil {
		return x.PublishTime
	}
	return nil
}

func (x *SequencedMessage) GetMessage() *PubSubMessage {
	if x != nil {
		return x.Message
	}
	return nil
}

func (x *SequencedMessage) GetSizeBytes() int64 {
	if x != nil {
		return x.SizeBytes
	}
	return 0
}

// Metadata about a reservation resource.
type Reservation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the reservation.
	// Structured like:
	// projects/{project_number}/locations/{location}/reservations/{reservation_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The reserved throughput capacity. Every unit of throughput capacity is
	// equivalent to 1 MiB/s of published messages or 2 MiB/s of subscribed
	// messages.
	//
	// Any topics which are declared as using capacity from a Reservation will
	// consume resources from this reservation instead of being charged
	// individually.
	ThroughputCapacity int64 `protobuf:"varint,2,opt,name=throughput_capacity,json=throughputCapacity,proto3" json:"throughput_capacity,omitempty"`
}

func (x *Reservation) Reset() {
	*x = Reservation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Reservation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Reservation) ProtoMessage() {}

func (x *Reservation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Reservation.ProtoReflect.Descriptor instead.
func (*Reservation) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP(), []int{4}
}

func (x *Reservation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Reservation) GetThroughputCapacity() int64 {
	if x != nil {
		return x.ThroughputCapacity
	}
	return 0
}

// Metadata about a topic resource.
type Topic struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the topic.
	// Structured like:
	// projects/{project_number}/locations/{location}/topics/{topic_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The settings for this topic's partitions.
	PartitionConfig *Topic_PartitionConfig `protobuf:"bytes,2,opt,name=partition_config,json=partitionConfig,proto3" json:"partition_config,omitempty"`
	// The settings for this topic's message retention.
	RetentionConfig *Topic_RetentionConfig `protobuf:"bytes,3,opt,name=retention_config,json=retentionConfig,proto3" json:"retention_config,omitempty"`
	// The settings for this topic's Reservation usage.
	ReservationConfig *Topic_ReservationConfig `protobuf:"bytes,4,opt,name=reservation_config,json=reservationConfig,proto3" json:"reservation_config,omitempty"`
}

func (x *Topic) Reset() {
	*x = Topic{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Topic) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Topic) ProtoMessage() {}

func (x *Topic) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Topic.ProtoReflect.Descriptor instead.
func (*Topic) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP(), []int{5}
}

func (x *Topic) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Topic) GetPartitionConfig() *Topic_PartitionConfig {
	if x != nil {
		return x.PartitionConfig
	}
	return nil
}

func (x *Topic) GetRetentionConfig() *Topic_RetentionConfig {
	if x != nil {
		return x.RetentionConfig
	}
	return nil
}

func (x *Topic) GetReservationConfig() *Topic_ReservationConfig {
	if x != nil {
		return x.ReservationConfig
	}
	return nil
}

// Metadata about a subscription resource.
type Subscription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the subscription.
	// Structured like:
	// projects/{project_number}/locations/{location}/subscriptions/{subscription_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The name of the topic this subscription is attached to.
	// Structured like:
	// projects/{project_number}/locations/{location}/topics/{topic_id}
	Topic string `protobuf:"bytes,2,opt,name=topic,proto3" json:"topic,omitempty"`
	// The settings for this subscription's message delivery.
	DeliveryConfig *Subscription_DeliveryConfig `protobuf:"bytes,3,opt,name=delivery_config,json=deliveryConfig,proto3" json:"delivery_config,omitempty"`
	// If present, messages are automatically written from the Pub/Sub Lite topic
	// associated with this subscription to a destination.
	ExportConfig *ExportConfig `protobuf:"bytes,4,opt,name=export_config,json=exportConfig,proto3" json:"export_config,omitempty"`
}

func (x *Subscription) Reset() {
	*x = Subscription{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Subscription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Subscription) ProtoMessage() {}

func (x *Subscription) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Subscription.ProtoReflect.Descriptor instead.
func (*Subscription) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP(), []int{6}
}

func (x *Subscription) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Subscription) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

func (x *Subscription) GetDeliveryConfig() *Subscription_DeliveryConfig {
	if x != nil {
		return x.DeliveryConfig
	}
	return nil
}

func (x *Subscription) GetExportConfig() *ExportConfig {
	if x != nil {
		return x.ExportConfig
	}
	return nil
}

// Configuration for a Pub/Sub Lite subscription that writes messages to a
// destination. User subscriber clients must not connect to this subscription.
type ExportConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The desired state of this export.
	DesiredState ExportConfig_State `protobuf:"varint,1,opt,name=desired_state,json=desiredState,proto3,enum=google.cloud.pubsublite.v1.ExportConfig_State" json:"desired_state,omitempty"`
	// Output only. The export statuses of each partition. This field is output only.
	Statuses []*ExportConfig_PartitionStatus `protobuf:"bytes,4,rep,name=statuses,proto3" json:"statuses,omitempty"`
	// Optional. The name of an optional Pub/Sub Lite topic to publish messages that can not
	// be exported to the destination. For example, the message can not be
	// published to the Pub/Sub service because it does not satisfy the
	// constraints documented at https://cloud.google.com/pubsub/docs/publisher.
	//
	// Structured like:
	// projects/{project_number}/locations/{location}/topics/{topic_id}.
	// Must be within the same project and location as the subscription. The topic
	// may be changed or removed.
	DeadLetterTopic string `protobuf:"bytes,5,opt,name=dead_letter_topic,json=deadLetterTopic,proto3" json:"dead_letter_topic,omitempty"`
	// The destination to export to. Required.
	//
	// Types that are assignable to Destination:
	//
	//	*ExportConfig_PubsubConfig
	Destination isExportConfig_Destination `protobuf_oneof:"destination"`
}

func (x *ExportConfig) Reset() {
	*x = ExportConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportConfig) ProtoMessage() {}

func (x *ExportConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportConfig.ProtoReflect.Descriptor instead.
func (*ExportConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP(), []int{7}
}

func (x *ExportConfig) GetDesiredState() ExportConfig_State {
	if x != nil {
		return x.DesiredState
	}
	return ExportConfig_STATE_UNSPECIFIED
}

func (x *ExportConfig) GetStatuses() []*ExportConfig_PartitionStatus {
	if x != nil {
		return x.Statuses
	}
	return nil
}

func (x *ExportConfig) GetDeadLetterTopic() string {
	if x != nil {
		return x.DeadLetterTopic
	}
	return ""
}

func (m *ExportConfig) GetDestination() isExportConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *ExportConfig) GetPubsubConfig() *ExportConfig_PubSubConfig {
	if x, ok := x.GetDestination().(*ExportConfig_PubsubConfig); ok {
		return x.PubsubConfig
	}
	return nil
}

type isExportConfig_Destination interface {
	isExportConfig_Destination()
}

type ExportConfig_PubsubConfig struct {
	// Messages are automatically written from the Pub/Sub Lite topic associated
	// with this subscription to a Pub/Sub topic.
	PubsubConfig *ExportConfig_PubSubConfig `protobuf:"bytes,3,opt,name=pubsub_config,json=pubsubConfig,proto3,oneof"`
}

func (*ExportConfig_PubsubConfig) isExportConfig_Destination() {}

// A target publish or event time. Can be used for seeking to or retrieving the
// corresponding cursor.
type TimeTarget struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of message time to query.
	//
	// Types that are assignable to Time:
	//
	//	*TimeTarget_PublishTime
	//	*TimeTarget_EventTime
	Time isTimeTarget_Time `protobuf_oneof:"time"`
}

func (x *TimeTarget) Reset() {
	*x = TimeTarget{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TimeTarget) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeTarget) ProtoMessage() {}

func (x *TimeTarget) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TimeTarget.ProtoReflect.Descriptor instead.
func (*TimeTarget) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP(), []int{8}
}

func (m *TimeTarget) GetTime() isTimeTarget_Time {
	if m != nil {
		return m.Time
	}
	return nil
}

func (x *TimeTarget) GetPublishTime() *timestamppb.Timestamp {
	if x, ok := x.GetTime().(*TimeTarget_PublishTime); ok {
		return x.PublishTime
	}
	return nil
}

func (x *TimeTarget) GetEventTime() *timestamppb.Timestamp {
	if x, ok := x.GetTime().(*TimeTarget_EventTime); ok {
		return x.EventTime
	}
	return nil
}

type isTimeTarget_Time interface {
	isTimeTarget_Time()
}

type TimeTarget_PublishTime struct {
	// Request the cursor of the first message with publish time greater than or
	// equal to `publish_time`. All messages thereafter are guaranteed to have
	// publish times >= `publish_time`.
	PublishTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=publish_time,json=publishTime,proto3,oneof"`
}

type TimeTarget_EventTime struct {
	// Request the cursor of the first message with event time greater than or
	// equal to `event_time`. If messages are missing an event time, the publish
	// time is used as a fallback. As event times are user supplied, subsequent
	// messages may have event times less than `event_time` and should be
	// filtered by the client, if necessary.
	EventTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=event_time,json=eventTime,proto3,oneof"`
}

func (*TimeTarget_PublishTime) isTimeTarget_Time() {}

func (*TimeTarget_EventTime) isTimeTarget_Time() {}

// The settings for a topic's partitions.
type Topic_PartitionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of partitions in the topic. Must be at least 1.
	//
	// Once a topic has been created the number of partitions can be increased
	// but not decreased. Message ordering is not guaranteed across a topic
	// resize. For more information see
	// https://cloud.google.com/pubsub/lite/docs/topics#scaling_capacity
	Count int64 `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	// The throughput dimension of this topic.
	//
	// Types that are assignable to Dimension:
	//
	//	*Topic_PartitionConfig_Scale
	//	*Topic_PartitionConfig_Capacity_
	Dimension isTopic_PartitionConfig_Dimension `protobuf_oneof:"dimension"`
}

func (x *Topic_PartitionConfig) Reset() {
	*x = Topic_PartitionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Topic_PartitionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Topic_PartitionConfig) ProtoMessage() {}

func (x *Topic_PartitionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Topic_PartitionConfig.ProtoReflect.Descriptor instead.
func (*Topic_PartitionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP(), []int{5, 0}
}

func (x *Topic_PartitionConfig) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (m *Topic_PartitionConfig) GetDimension() isTopic_PartitionConfig_Dimension {
	if m != nil {
		return m.Dimension
	}
	return nil
}

// Deprecated: Do not use.
func (x *Topic_PartitionConfig) GetScale() int32 {
	if x, ok := x.GetDimension().(*Topic_PartitionConfig_Scale); ok {
		return x.Scale
	}
	return 0
}

func (x *Topic_PartitionConfig) GetCapacity() *Topic_PartitionConfig_Capacity {
	if x, ok := x.GetDimension().(*Topic_PartitionConfig_Capacity_); ok {
		return x.Capacity
	}
	return nil
}

type isTopic_PartitionConfig_Dimension interface {
	isTopic_PartitionConfig_Dimension()
}

type Topic_PartitionConfig_Scale struct {
	// DEPRECATED: Use capacity instead which can express a superset of
	// configurations.
	//
	// Every partition in the topic is allocated throughput equivalent to
	// `scale` times the standard partition throughput (4 MiB/s). This is also
	// reflected in the cost of this topic; a topic with `scale` of 2 and
	// count of 10 is charged for 20 partitions. This value must be in the
	// range [1,4].
	//
	// Deprecated: Do not use.
	Scale int32 `protobuf:"varint,2,opt,name=scale,proto3,oneof"`
}

type Topic_PartitionConfig_Capacity_ struct {
	// The capacity configuration.
	Capacity *Topic_PartitionConfig_Capacity `protobuf:"bytes,3,opt,name=capacity,proto3,oneof"`
}

func (*Topic_PartitionConfig_Scale) isTopic_PartitionConfig_Dimension() {}

func (*Topic_PartitionConfig_Capacity_) isTopic_PartitionConfig_Dimension() {}

// The settings for a topic's message retention.
type Topic_RetentionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The provisioned storage, in bytes, per partition. If the number of bytes
	// stored in any of the topic's partitions grows beyond this value, older
	// messages will be dropped to make room for newer ones, regardless of the
	// value of `period`.
	PerPartitionBytes int64 `protobuf:"varint,1,opt,name=per_partition_bytes,json=perPartitionBytes,proto3" json:"per_partition_bytes,omitempty"`
	// How long a published message is retained. If unset, messages will be
	// retained as long as the bytes retained for each partition is below
	// `per_partition_bytes`.
	Period *durationpb.Duration `protobuf:"bytes,2,opt,name=period,proto3" json:"period,omitempty"`
}

func (x *Topic_RetentionConfig) Reset() {
	*x = Topic_RetentionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Topic_RetentionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Topic_RetentionConfig) ProtoMessage() {}

func (x *Topic_RetentionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Topic_RetentionConfig.ProtoReflect.Descriptor instead.
func (*Topic_RetentionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP(), []int{5, 1}
}

func (x *Topic_RetentionConfig) GetPerPartitionBytes() int64 {
	if x != nil {
		return x.PerPartitionBytes
	}
	return 0
}

func (x *Topic_RetentionConfig) GetPeriod() *durationpb.Duration {
	if x != nil {
		return x.Period
	}
	return nil
}

// The settings for this topic's Reservation usage.
type Topic_ReservationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Reservation to use for this topic's throughput capacity.
	// Structured like:
	// projects/{project_number}/locations/{location}/reservations/{reservation_id}
	ThroughputReservation string `protobuf:"bytes,1,opt,name=throughput_reservation,json=throughputReservation,proto3" json:"throughput_reservation,omitempty"`
}

func (x *Topic_ReservationConfig) Reset() {
	*x = Topic_ReservationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Topic_ReservationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Topic_ReservationConfig) ProtoMessage() {}

func (x *Topic_ReservationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Topic_ReservationConfig.ProtoReflect.Descriptor instead.
func (*Topic_ReservationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP(), []int{5, 2}
}

func (x *Topic_ReservationConfig) GetThroughputReservation() string {
	if x != nil {
		return x.ThroughputReservation
	}
	return ""
}

// The throughput capacity configuration for each partition.
type Topic_PartitionConfig_Capacity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Publish throughput capacity per partition in MiB/s.
	// Must be >= 4 and <= 16.
	PublishMibPerSec int32 `protobuf:"varint,1,opt,name=publish_mib_per_sec,json=publishMibPerSec,proto3" json:"publish_mib_per_sec,omitempty"`
	// Subscribe throughput capacity per partition in MiB/s.
	// Must be >= 4 and <= 32.
	SubscribeMibPerSec int32 `protobuf:"varint,2,opt,name=subscribe_mib_per_sec,json=subscribeMibPerSec,proto3" json:"subscribe_mib_per_sec,omitempty"`
}

func (x *Topic_PartitionConfig_Capacity) Reset() {
	*x = Topic_PartitionConfig_Capacity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Topic_PartitionConfig_Capacity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Topic_PartitionConfig_Capacity) ProtoMessage() {}

func (x *Topic_PartitionConfig_Capacity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Topic_PartitionConfig_Capacity.ProtoReflect.Descriptor instead.
func (*Topic_PartitionConfig_Capacity) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP(), []int{5, 0, 0}
}

func (x *Topic_PartitionConfig_Capacity) GetPublishMibPerSec() int32 {
	if x != nil {
		return x.PublishMibPerSec
	}
	return 0
}

func (x *Topic_PartitionConfig_Capacity) GetSubscribeMibPerSec() int32 {
	if x != nil {
		return x.SubscribeMibPerSec
	}
	return 0
}

// The settings for a subscription's message delivery.
type Subscription_DeliveryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The DeliveryRequirement for this subscription.
	DeliveryRequirement Subscription_DeliveryConfig_DeliveryRequirement `protobuf:"varint,3,opt,name=delivery_requirement,json=deliveryRequirement,proto3,enum=google.cloud.pubsublite.v1.Subscription_DeliveryConfig_DeliveryRequirement" json:"delivery_requirement,omitempty"`
}

func (x *Subscription_DeliveryConfig) Reset() {
	*x = Subscription_DeliveryConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Subscription_DeliveryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Subscription_DeliveryConfig) ProtoMessage() {}

func (x *Subscription_DeliveryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Subscription_DeliveryConfig.ProtoReflect.Descriptor instead.
func (*Subscription_DeliveryConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP(), []int{6, 0}
}

func (x *Subscription_DeliveryConfig) GetDeliveryRequirement() Subscription_DeliveryConfig_DeliveryRequirement {
	if x != nil {
		return x.DeliveryRequirement
	}
	return Subscription_DeliveryConfig_DELIVERY_REQUIREMENT_UNSPECIFIED
}

// The export status of a partition.
type ExportConfig_PartitionStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The partition number.
	Partition int64 `protobuf:"varint,1,opt,name=partition,proto3" json:"partition,omitempty"`
	// If the export for a partition is healthy and the desired state is
	// `ACTIVE`, the status code will be `OK` (zero). If the desired state of
	// the export is `PAUSED`, the status code will be `CANCELLED`.
	//
	// If the export has been suspended due to an error, the status will be
	// populated with an error code and details. The service will automatically
	// retry after a period of time, and will update the status code to `OK` if
	// export subsequently succeeds.
	Status *status.Status `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *ExportConfig_PartitionStatus) Reset() {
	*x = ExportConfig_PartitionStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportConfig_PartitionStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportConfig_PartitionStatus) ProtoMessage() {}

func (x *ExportConfig_PartitionStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportConfig_PartitionStatus.ProtoReflect.Descriptor instead.
func (*ExportConfig_PartitionStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP(), []int{7, 0}
}

func (x *ExportConfig_PartitionStatus) GetPartition() int64 {
	if x != nil {
		return x.Partition
	}
	return 0
}

func (x *ExportConfig_PartitionStatus) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

// Configuration for exporting to a Pub/Sub topic.
type ExportConfig_PubSubConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the Pub/Sub topic.
	// Structured like: projects/{project_number}/topics/{topic_id}.
	// The topic may be changed.
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
}

func (x *ExportConfig_PubSubConfig) Reset() {
	*x = ExportConfig_PubSubConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportConfig_PubSubConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportConfig_PubSubConfig) ProtoMessage() {}

func (x *ExportConfig_PubSubConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_pubsublite_v1_common_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportConfig_PubSubConfig.ProtoReflect.Descriptor instead.
func (*ExportConfig_PubSubConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP(), []int{7, 1}
}

func (x *ExportConfig_PubSubConfig) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

var File_google_cloud_pubsublite_v1_common_proto protoreflect.FileDescriptor

var file_google_cloud_pubsublite_v1_common_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x70,
	0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69,
	0x74, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x29, 0x0a, 0x0f, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x16,
	0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0c, 0x52, 0x06,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0xb7, 0x02, 0x0a, 0x0d, 0x50, 0x75, 0x62, 0x53, 0x75,
	0x62, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12, 0x59,
	0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x61,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x39, 0x0a, 0x0a, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x54, 0x69, 0x6d, 0x65, 0x1a, 0x6a, 0x0a, 0x0f, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x41, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69,
	0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0x20, 0x0a, 0x06, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x22, 0xf1, 0x01, 0x0a, 0x10, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x64,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a, 0x06, 0x63, 0x75, 0x72, 0x73, 0x6f,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x72, 0x73, 0x6f, 0x72, 0x52, 0x06, 0x63, 0x75, 0x72,
	0x73, 0x6f, 0x72, 0x12, 0x3d, 0x0a, 0x0c, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x43, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x07,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x69, 0x7a, 0x65, 0x5f,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x73, 0x69, 0x7a,
	0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x22, 0xc2, 0x01, 0x0a, 0x0b, 0x52, 0x65, 0x73, 0x65, 0x72,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2f, 0x0a, 0x13, 0x74, 0x68,
	0x72, 0x6f, 0x75, 0x67, 0x68, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x12, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68,
	0x70, 0x75, 0x74, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x3a, 0x6e, 0xea, 0x41, 0x6b,
	0x0a, 0x25, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x65,
	0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x72,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x22, 0xa2, 0x07, 0x0a, 0x05,
	0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5c, 0x0a, 0x10, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5c, 0x0a, 0x10, 0x72, 0x65, 0x74, 0x65, 0x6e,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x6f, 0x70, 0x69, 0x63, 0x2e, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x0f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x62, 0x0a, 0x12, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x6f, 0x70, 0x69, 0x63, 0x2e, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x11, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x98, 0x02, 0x0a, 0x0f, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x14, 0x0a,
	0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x1a, 0x0a, 0x05, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x05, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x12,
	0x58, 0x0a, 0x08, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x6f, 0x70, 0x69, 0x63, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x48, 0x00, 0x52,
	0x08, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x1a, 0x6c, 0x0a, 0x08, 0x43, 0x61, 0x70,
	0x61, 0x63, 0x69, 0x74, 0x79, 0x12, 0x2d, 0x0a, 0x13, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x5f, 0x6d, 0x69, 0x62, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x10, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x4d, 0x69, 0x62, 0x50, 0x65,
	0x72, 0x53, 0x65, 0x63, 0x12, 0x31, 0x0a, 0x15, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62,
	0x65, 0x5f, 0x6d, 0x69, 0x62, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x63, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x12, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x4d, 0x69,
	0x62, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x42, 0x0b, 0x0a, 0x09, 0x64, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x74, 0x0a, 0x0f, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2e, 0x0a, 0x13, 0x70, 0x65, 0x72, 0x5f, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x70, 0x65, 0x72, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x31, 0x0a, 0x06, 0x70, 0x65, 0x72, 0x69, 0x6f,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x06, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x1a, 0x76, 0x0a, 0x11, 0x52, 0x65,
	0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x61, 0x0a, 0x16, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x70, 0x75, 0x74, 0x5f, 0x72, 0x65,
	0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2a, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15, 0x74, 0x68, 0x72,
	0x6f, 0x75, 0x67, 0x68, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x3a, 0x5c, 0xea, 0x41, 0x59, 0x0a, 0x1f, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c,
	0x69, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x36, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x73, 0x2f, 0x7b, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x7d,
	0x22, 0x85, 0x05, 0x0a, 0x0c, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x70, 0x75, 0x62, 0x73, 0x75,
	0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69,
	0x63, 0x12, 0x60, 0x0a, 0x0f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62,
	0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x0e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x4d, 0x0a, 0x0d, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62,
	0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x1a, 0x80, 0x02, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7e, 0x0a, 0x14, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x79, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x65,
	0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x44, 0x65, 0x6c,
	0x69, 0x76, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x13, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x6e, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x24, 0x0a, 0x20,
	0x44, 0x45, 0x4c, 0x49, 0x56, 0x45, 0x52, 0x59, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x49, 0x52, 0x45,
	0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x44, 0x45, 0x4c, 0x49, 0x56, 0x45, 0x52, 0x5f, 0x49, 0x4d,
	0x4d, 0x45, 0x44, 0x49, 0x41, 0x54, 0x45, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x44,
	0x45, 0x4c, 0x49, 0x56, 0x45, 0x52, 0x5f, 0x41, 0x46, 0x54, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x4f,
	0x52, 0x45, 0x44, 0x10, 0x02, 0x3a, 0x71, 0xea, 0x41, 0x6e, 0x0a, 0x26, 0x70, 0x75, 0x62, 0x73,
	0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x44, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x73, 0x75, 0x62, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x22, 0xbb, 0x04, 0x0a, 0x0c, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x53, 0x0a, 0x0d, 0x64, 0x65, 0x73,
	0x69, 0x72, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x52, 0x0c, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x64, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x59,
	0x0a, 0x08, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x08, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x12, 0x53, 0x0a, 0x11, 0x64, 0x65, 0x61,
	0x64, 0x5f, 0x6c, 0x65, 0x74, 0x74, 0x65, 0x72, 0x5f, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x70, 0x75,
	0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x52, 0x0f, 0x64,
	0x65, 0x61, 0x64, 0x4c, 0x65, 0x74, 0x74, 0x65, 0x72, 0x54, 0x6f, 0x70, 0x69, 0x63, 0x12, 0x5c,
	0x0a, 0x0d, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0c,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x5b, 0x0a, 0x0f,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12,
	0x1c, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a,
	0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x1a, 0x24, 0x0a, 0x0c, 0x50, 0x75, 0x62,
	0x53, 0x75, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f, 0x70,
	0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x22,
	0x36, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x50,
	0x41, 0x55, 0x53, 0x45, 0x44, 0x10, 0x02, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x92, 0x01, 0x0a, 0x0a, 0x54, 0x69, 0x6d, 0x65, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x3f, 0x0a, 0x0c, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x00, 0x52, 0x0b, 0x70, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x00, 0x52, 0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x42, 0xd5, 0x01, 0x0a, 0x21,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x42, 0x0b, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e,
	0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x70, 0x75,
	0x62, 0x73, 0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0x2f, 0x76, 0x31, 0x3b, 0x70, 0x75, 0x62, 0x73,
	0x75, 0x62, 0x6c, 0x69, 0x74, 0x65, 0xf8, 0x01, 0x01, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x4c,
	0x69, 0x74, 0x65, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x4c, 0x69, 0x74, 0x65,
	0x5c, 0x56, 0x31, 0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x50, 0x75, 0x62, 0x53, 0x75, 0x62, 0x4c, 0x69, 0x74, 0x65, 0x3a,
	0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_pubsublite_v1_common_proto_rawDescOnce sync.Once
	file_google_cloud_pubsublite_v1_common_proto_rawDescData = file_google_cloud_pubsublite_v1_common_proto_rawDesc
)

func file_google_cloud_pubsublite_v1_common_proto_rawDescGZIP() []byte {
	file_google_cloud_pubsublite_v1_common_proto_rawDescOnce.Do(func() {
		file_google_cloud_pubsublite_v1_common_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_pubsublite_v1_common_proto_rawDescData)
	})
	return file_google_cloud_pubsublite_v1_common_proto_rawDescData
}

var file_google_cloud_pubsublite_v1_common_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_pubsublite_v1_common_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_google_cloud_pubsublite_v1_common_proto_goTypes = []interface{}{
	(Subscription_DeliveryConfig_DeliveryRequirement)(0), // 0: google.cloud.pubsublite.v1.Subscription.DeliveryConfig.DeliveryRequirement
	(ExportConfig_State)(0),                              // 1: google.cloud.pubsublite.v1.ExportConfig.State
	(*AttributeValues)(nil),                              // 2: google.cloud.pubsublite.v1.AttributeValues
	(*PubSubMessage)(nil),                                // 3: google.cloud.pubsublite.v1.PubSubMessage
	(*Cursor)(nil),                                       // 4: google.cloud.pubsublite.v1.Cursor
	(*SequencedMessage)(nil),                             // 5: google.cloud.pubsublite.v1.SequencedMessage
	(*Reservation)(nil),                                  // 6: google.cloud.pubsublite.v1.Reservation
	(*Topic)(nil),                                        // 7: google.cloud.pubsublite.v1.Topic
	(*Subscription)(nil),                                 // 8: google.cloud.pubsublite.v1.Subscription
	(*ExportConfig)(nil),                                 // 9: google.cloud.pubsublite.v1.ExportConfig
	(*TimeTarget)(nil),                                   // 10: google.cloud.pubsublite.v1.TimeTarget
	nil,                                                  // 11: google.cloud.pubsublite.v1.PubSubMessage.AttributesEntry
	(*Topic_PartitionConfig)(nil),                        // 12: google.cloud.pubsublite.v1.Topic.PartitionConfig
	(*Topic_RetentionConfig)(nil),                        // 13: google.cloud.pubsublite.v1.Topic.RetentionConfig
	(*Topic_ReservationConfig)(nil),                      // 14: google.cloud.pubsublite.v1.Topic.ReservationConfig
	(*Topic_PartitionConfig_Capacity)(nil),               // 15: google.cloud.pubsublite.v1.Topic.PartitionConfig.Capacity
	(*Subscription_DeliveryConfig)(nil),                  // 16: google.cloud.pubsublite.v1.Subscription.DeliveryConfig
	(*ExportConfig_PartitionStatus)(nil),                 // 17: google.cloud.pubsublite.v1.ExportConfig.PartitionStatus
	(*ExportConfig_PubSubConfig)(nil),                    // 18: google.cloud.pubsublite.v1.ExportConfig.PubSubConfig
	(*timestamppb.Timestamp)(nil),                        // 19: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),                          // 20: google.protobuf.Duration
	(*status.Status)(nil),                                // 21: google.rpc.Status
}
var file_google_cloud_pubsublite_v1_common_proto_depIdxs = []int32{
	11, // 0: google.cloud.pubsublite.v1.PubSubMessage.attributes:type_name -> google.cloud.pubsublite.v1.PubSubMessage.AttributesEntry
	19, // 1: google.cloud.pubsublite.v1.PubSubMessage.event_time:type_name -> google.protobuf.Timestamp
	4,  // 2: google.cloud.pubsublite.v1.SequencedMessage.cursor:type_name -> google.cloud.pubsublite.v1.Cursor
	19, // 3: google.cloud.pubsublite.v1.SequencedMessage.publish_time:type_name -> google.protobuf.Timestamp
	3,  // 4: google.cloud.pubsublite.v1.SequencedMessage.message:type_name -> google.cloud.pubsublite.v1.PubSubMessage
	12, // 5: google.cloud.pubsublite.v1.Topic.partition_config:type_name -> google.cloud.pubsublite.v1.Topic.PartitionConfig
	13, // 6: google.cloud.pubsublite.v1.Topic.retention_config:type_name -> google.cloud.pubsublite.v1.Topic.RetentionConfig
	14, // 7: google.cloud.pubsublite.v1.Topic.reservation_config:type_name -> google.cloud.pubsublite.v1.Topic.ReservationConfig
	16, // 8: google.cloud.pubsublite.v1.Subscription.delivery_config:type_name -> google.cloud.pubsublite.v1.Subscription.DeliveryConfig
	9,  // 9: google.cloud.pubsublite.v1.Subscription.export_config:type_name -> google.cloud.pubsublite.v1.ExportConfig
	1,  // 10: google.cloud.pubsublite.v1.ExportConfig.desired_state:type_name -> google.cloud.pubsublite.v1.ExportConfig.State
	17, // 11: google.cloud.pubsublite.v1.ExportConfig.statuses:type_name -> google.cloud.pubsublite.v1.ExportConfig.PartitionStatus
	18, // 12: google.cloud.pubsublite.v1.ExportConfig.pubsub_config:type_name -> google.cloud.pubsublite.v1.ExportConfig.PubSubConfig
	19, // 13: google.cloud.pubsublite.v1.TimeTarget.publish_time:type_name -> google.protobuf.Timestamp
	19, // 14: google.cloud.pubsublite.v1.TimeTarget.event_time:type_name -> google.protobuf.Timestamp
	2,  // 15: google.cloud.pubsublite.v1.PubSubMessage.AttributesEntry.value:type_name -> google.cloud.pubsublite.v1.AttributeValues
	15, // 16: google.cloud.pubsublite.v1.Topic.PartitionConfig.capacity:type_name -> google.cloud.pubsublite.v1.Topic.PartitionConfig.Capacity
	20, // 17: google.cloud.pubsublite.v1.Topic.RetentionConfig.period:type_name -> google.protobuf.Duration
	0,  // 18: google.cloud.pubsublite.v1.Subscription.DeliveryConfig.delivery_requirement:type_name -> google.cloud.pubsublite.v1.Subscription.DeliveryConfig.DeliveryRequirement
	21, // 19: google.cloud.pubsublite.v1.ExportConfig.PartitionStatus.status:type_name -> google.rpc.Status
	20, // [20:20] is the sub-list for method output_type
	20, // [20:20] is the sub-list for method input_type
	20, // [20:20] is the sub-list for extension type_name
	20, // [20:20] is the sub-list for extension extendee
	0,  // [0:20] is the sub-list for field type_name
}

func init() { file_google_cloud_pubsublite_v1_common_proto_init() }
func file_google_cloud_pubsublite_v1_common_proto_init() {
	if File_google_cloud_pubsublite_v1_common_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_pubsublite_v1_common_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttributeValues); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_common_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PubSubMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_common_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Cursor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_common_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SequencedMessage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_common_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Reservation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_common_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Topic); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_common_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Subscription); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_common_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_common_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TimeTarget); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_common_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Topic_PartitionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_common_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Topic_RetentionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_common_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Topic_ReservationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_common_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Topic_PartitionConfig_Capacity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_common_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Subscription_DeliveryConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_common_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportConfig_PartitionStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_pubsublite_v1_common_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportConfig_PubSubConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_pubsublite_v1_common_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*ExportConfig_PubsubConfig)(nil),
	}
	file_google_cloud_pubsublite_v1_common_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*TimeTarget_PublishTime)(nil),
		(*TimeTarget_EventTime)(nil),
	}
	file_google_cloud_pubsublite_v1_common_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*Topic_PartitionConfig_Scale)(nil),
		(*Topic_PartitionConfig_Capacity_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_pubsublite_v1_common_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_pubsublite_v1_common_proto_goTypes,
		DependencyIndexes: file_google_cloud_pubsublite_v1_common_proto_depIdxs,
		EnumInfos:         file_google_cloud_pubsublite_v1_common_proto_enumTypes,
		MessageInfos:      file_google_cloud_pubsublite_v1_common_proto_msgTypes,
	}.Build()
	File_google_cloud_pubsublite_v1_common_proto = out.File
	file_google_cloud_pubsublite_v1_common_proto_rawDesc = nil
	file_google_cloud_pubsublite_v1_common_proto_goTypes = nil
	file_google_cloud_pubsublite_v1_common_proto_depIdxs = nil
}
